% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identity.R
\name{identity_match}
\alias{identity_match}
\title{Assign Common Id to Nodes and Edgelists to Git and Mbox}
\usage{
identity_match(
  project_log,
  name_column,
  assign_identity_function,
  use_name_only = FALSE,
  label
)
}
\arguments{
\item{project_log}{A list which can be any number of tables from \code{\link{parse_gitlog}}
or \code{\link{parse_mbox}}}

\item{name_column}{A string or vector of strings containing the column names
which identity match should apply. One column name should provided for each
table in the `project_log` list.}

\item{assign_identity_function}{The heuristic function which decides common IDs
(currently only available: \code{\link{assign_exact_identity}})}

\item{use_name_only}{Uses only the name field (i.e. disregard the e-mail field)}

\item{label}{Whether to replace the original non matched name with the
collection of all names (label == raw_name), or an id (label == identity_id)}
}
\value{
Returns `project_log`, with two added columns, `raw_name` and
`identity_id`. `raw_name` contains all names matched to the user, while
`identity_id` provides a unique identifier, starting at 1, for all names
passed in `project_log` across all tables of the list.
}
\description{
Assign Common Id to Nodes and Edgelists to Git and Mbox
}
