% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{graph_to_dsmj}
\alias{graph_to_dsmj}
\title{Exports a graph as a dsmj.}
\usage{
graph_to_dsmj(graph, dsmj_path, dsmj_name, is_directed, is_sorted = FALSE)
}
\arguments{
\item{graph}{a graph returned by \code{\link{model_directed_graph}}}

\item{dsmj_path}{path to save the dsmj.}

\item{dsmj_name}{name of the dsmj file, passed by the call from an appropriate transform function.}

\item{is_directed}{whether the graph is directed. If false, cells will be doubled.
with src/dest switched to represent an undirected graph as a directed graph.}

\item{is_sorted}{whether to sort the variables (filenames) in the dsm.json files (optional).}
}
\value{
the path to the dsm.json file saved.
}
\description{
Exports a graph as a dsmj.
}
\seealso{
\code{\link{transform_dependencies_to_sdsmj}} to transform dependencies from Depends into a structure dsm.json,
\code{\link{transform_gitlog_to_hdsmj}} to transform a gitlog table into a history dsm.json, and
\code{\link{transform_temporal_gitlog_to_adsmj}} to transform a gitlog table into an author dsm.json.

Other dv8: 
\code{\link{dependencies_to_sdsmj}()},
\code{\link{dv8_clsxb_to_clsxj}()},
\code{\link{dv8_clsxj_to_clsxb}()},
\code{\link{dv8_depends_to_sdsmj}()},
\code{\link{dv8_dsmj_to_dsmb}()},
\code{\link{dv8_hdsmb_sdsmb_to_mdsmb}()},
\code{\link{dv8_mdsmb_to_flaws}()},
\code{\link{gitlog_to_hdsmj}()},
\code{\link{parse_dv8_architectural_flaws}()},
\code{\link{parse_dv8_clusters}()},
\code{\link{transform_dependencies_to_sdsmj}()},
\code{\link{transform_gitlog_to_hdsmj}()},
\code{\link{transform_temporal_gitlog_to_adsmj}()}
}
\concept{dv8}
