% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{github_api_project_issue_search}
\alias{github_api_project_issue_search}
\title{Download Project Issues via Search}
\usage{
github_api_project_issue_search(
  owner,
  repo,
  token,
  query = NULL,
  issue_or_pr,
  verbose = TRUE
)
}
\arguments{
\item{owner}{GitHub's repository owner (e.g. sailuh)}

\item{repo}{GitHub's repository name (e.g. kaiaulu)}

\item{token}{Your GitHub API token}

\item{query}{Optional query to append to search api}

\item{issue_or_pr}{This specifies whether issues or pull requests are being searched for.
Acceptable inputs are "is:issue" or "is:pull-request".}

\item{verbose}{Prints operational messages when se to true such as stating the search query.}
}
\description{
Download Commits from "GET /repos/{owner}/{repo}/search/issues" endpoint.
This search endpoint allows for optional query parameter. Potential queries are found
[here](https://docs.github.com/en/rest/search/search?apiVersion=2022-11-28). The query parameter
assumes that owner/repo is already prepended to the query. If no query is passed to the function,
it will prepend only owner/repo to the query.
}
\references{
For details, see \url{https://docs.github.com/en/rest/search/search?apiVersion=2022-11-28}.

For details on timestampes, se \url{https://docs.github.com/en/search-github/searching-on-github/searching-issues-and-pull-requests#search-by-when-an-issue-or-pull-request-was-created-or-last-updated}
}
