% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{github_api_project_issue_or_pr_comments_by_date}
\alias{github_api_project_issue_or_pr_comments_by_date}
\title{Download Github comment Data by Date}
\usage{
github_api_project_issue_or_pr_comments_by_date(
  owner,
  repo,
  token,
  since,
  verbose = FALSE
)
}
\arguments{
\item{owner}{GitHub's repository owner (e.g. sailuh)}

\item{repo}{GitHub's repository name (e.g. kaiaulu)}

\item{token}{Your GitHub API token}

\item{since}{The lower bound. Comments created and/or updated after this date will be retrieved.}

\item{verbose}{boolean value. When set to true, it prints operational messages including
greatest dates and the file name that contains the greatest date.}
}
\description{
Appends a 'since' query to the issue/comments api request and returns the first page of the result.
}
\details{
#' Acceptable formats for `since` are:

* "YYYY-MM-DD"
* "YYYY-MM-DDTHH:MM"
* "YYYY-MM-DDTHH:MM:SS"
* "YYYY-MM-DDTHH:MM:SSZ"
* "YYYY-MM-DDTHH:MM:SS+00:00"
* NULL

#' For example: `since="2020-07-04"` (a comment ocurring at the exact specified time will also be downloaded).

For further details on the `since` Query see [the associated Github API documentation](https://docs.github.com/en/rest/issues/comments?apiVersion=2022-11-28#:~:text=asc%2C%20desc-,since,-string).
}
\seealso{
\code{link{github_api_project_issue_or_pr_comment_refresh}} to refresh comment data

\code{link{github_api_project_issue_refresh}} to refresh issue data

\code{link{github_api_project_issue_or_pr_comments}} to call issue/comments endpoint
}
