% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{github_api_project_issue_or_pr_comment_refresh}
\alias{github_api_project_issue_or_pr_comment_refresh}
\title{Download Project issues or pr comments after certain date}
\usage{
github_api_project_issue_or_pr_comment_refresh(
  owner,
  repo,
  token,
  file_save_path,
  verbose = TRUE
)
}
\arguments{
\item{owner}{GitHub's repository owner (e.g. sailuh)}

\item{repo}{GitHub's repository name (e.g. kaiaulu)}

\item{token}{Your GitHub API token}

\item{file_save_path}{the save path for the issue comments folder}

\item{verbose}{boolean value. When set to true, it prints operational messages including
greatest dates and the file name that contains the greatest date.}
}
\description{
Uses the adopted file name convention by \code{\link{github_api_iterate_pages}} to identify
the latest downloaded Github created_at date among the directory(intended to be the  folder).
It uses this date to construct a query and calls \code{\link{github_api_project_issue_or_pr_comments}}
}
\details{
If no files exist in the file_save_path,\code{link{github_api_project_issue_or_pr_comments}}
is called with no additional query and all comments are downloaded.

Because the endpoint this function relies on is based on the updated timestamp, running the refresher
will download the most recent version of the comment changes. Only the most recent version of the comment will
be downloaded, not all copies. However, if the same comment was modified before the next refresh call,
then if the refresher function was executed again, then this would result in two comments with the same
comment id being present in the table. This can be addressed by performing a group by over the comment\_id
in the generated parsed table, and selecting to return the max(updated_at) comment, resulting in a table
that only the most recent comment verson as of the latest time the refresher was executed.
}
\references{
For details, see \url{https://docs.github.com/en/rest/reference/issues#list-repository-issues}.
}
\seealso{
\code{link{github_api_project_issue_or_pr_comments}} to download all comment data

\code{link{format_created_at_from_file}} for function that iterates through
a .json file and returns the greatest 'created_at' value

\code{link{github_api_iterate_pages}} to write data returned by this function to file as .json

\code{link{github_api_project_issue_or_pr_comments}} to call issue/comments endpoint
}
