% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{github_api_project_issue_by_date}
\alias{github_api_project_issue_by_date}
\title{Download Github Issue Data by Date}
\usage{
github_api_project_issue_by_date(
  owner,
  repo,
  token,
  date_lower_bound = NULL,
  date_upper_bound = NULL,
  issue_or_pr,
  verbose = FALSE
)
}
\arguments{
\item{owner}{GitHub's repository owner (e.g. sailuh)}

\item{repo}{GitHub's repository name (e.g. kaiaulu)}

\item{token}{Your GitHub API token}

\item{date_lower_bound}{Optional. Specify the lower bound date time (e.g. 2023/11/16 21:00)}

\item{date_upper_bound}{Optional. Specify the upper bound date time (e.g. 2023/11/16 21:00)}

\item{issue_or_pr}{This specifies whether issues or pull requests are being searched for.
Acceptable inputs are "is:issue" or "is:pull-request".
greatest dates and the file name that contains the greatest date.}

\item{verbose}{boolean value. When set to true, it prints operational messages including
greatest dates and the file name that contains the greatest date.}
}
\description{
Appends a 'created' field to a search github JQL query and returns the first page of the response.
}
\details{
Acceptable formats for `date_lower_bound` and `date_upper_bound` are:

* "YYYY-MM-DD"
* "YYYY-MM-DDTHH:MM"
* "YYYY-MM-DDTHH:MM:SS"
* "YYYY-MM-DDTHH:MM:SSZ"
* "YYYY-MM-DDTHH:MM:SS+00:00"
* NULL

For example: `date_lower_bound="2020-07-04"` (an issue ocurring at the exact specified time will also be downloaded).

For further details on the `created` Query see [the associated Github API documentation](https://docs.github.com/en/search-github/searching-on-github/searching-issues-and-pull-requests#search-by-when-an-issue-or-pull-request-was-created-or-last-updated).
}
\references{
For details on is:issue or is:pull-request see \url{https://docs.github.com/en/rest/search/search?apiVersion=2022-11-28}

For details on timestampes, se \url{https://docs.github.com/en/search-github/searching-on-github/searching-issues-and-pull-requests#search-by-when-an-issue-or-pull-request-was-created-or-last-updated}
}
\seealso{
\code{link{github_api_project_issue_or_pr_comment_refresh}} to refresh comment data

\code{link{github_api_project_issue_or_pr_comments}} to refresh issue data
}
