% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{get_tool_project}
\alias{get_tool_project}
\title{Returns the specified tool project from a parsed tool configuration file.}
\usage{
get_tool_project(tool_name, config_file)
}
\arguments{
\item{tool_name}{The name of the tool (e.g. "perceval" or "dv8").}

\item{config_file}{The parsed configuration file obtained from \code{\link{parse_config}}.}
}
\value{
The specified `tool_name` tool project from `config_file`.
}
\description{
This function returns a path to a specified tool from a
specified parsed tool configuration file. The function takes the input
`tool_name` and uses it to index a specific tool project in a parsed
tool configuration file, `config_file`, where it then returns the specified
tool project. The function will inform the user if the specified attribute,
`tool_name`, exists in the parsed configuration file, `config_file`.
}
