% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{get_bugzilla_project_key}
\alias{get_bugzilla_project_key}
\title{Returns the name of the Bugzilla project key for a specific project key index.}
\usage{
get_bugzilla_project_key(config_file, project_key_index)
}
\arguments{
\item{config_file}{The parsed configuration file obtained from \code{\link{parse_config}}.}

\item{project_key_index}{The name of the index of the project key (e.g. "project_key_1" or "project_key_2").}
}
\value{
The Bugzilla project key name for project specified by key `project_key_index`.
}
\description{
This function returns the name of the Bugzilla project key for
a specific project key, that is specified in the input parameter
`config_file`. The input, `config_file` must be a parsed configuration file.
The function will inform the user if the name of the Bugzilla project key
exists in the parsed configuration file, `config_file`.
}
