% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_by_commit_size}
\alias{filter_by_commit_size}
\title{Filter by number of files in commit}
\usage{
filter_by_commit_size(project_git, commit_size = 30)
}
\arguments{
\item{project_git}{The parsed `project_git` file obtained from \code{\link{parse_gitlog}}.}

\item{commit_size}{Commits which modify a number of files greater than this threshold are deleted from
`project_git`.}
}
\value{
a data.table which only contain file changes to commits less or equal than `commit_size.
}
\description{
If a commit modified more than `commit_size` files, then all file changes in `project_git`
associated to the commit are deleted from the table. Specifying a `commit_size` is useful
to decrease threats to validity on "migration commits" when performing a graph projection
on a file-commit network to obtain co-change.(e.g. \code{\link{transform_gitlog_to_hdsmj}}).
}
\seealso{
Other filters: 
\code{\link{filter_by_commit_interval}()},
\code{\link{filter_by_filepath_substring}()}
}
\concept{filters}
