% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_by_commit_interval}
\alias{filter_by_commit_interval}
\title{Filter by commit interval}
\usage{
filter_by_commit_interval(git_log, start_commit, end_commit)
}
\arguments{
\item{git_log}{any data.table with a named column `data.AuthorDate` with datetime in POSIXct}

\item{start_commit}{a commit hash which indicates the start of interval (the commit must exist in `git_log`)}

\item{end_commit}{a commit hash which indicates the end of interval (the commit must exist in `git_log`)}
}
\value{
a data.table which contains only commits within `start_commit` and `end_commit`
}
\description{
Filters a data.table by with author or commit datetime using the specified start and end commits
}
\seealso{
\code{\link{parse_gitlog}} to create git_log

Other filters: 
\code{\link{filter_by_commit_size}()},
\code{\link{filter_by_filepath_substring}()}
}
\concept{filters}
