% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.R
\name{export_understand_dependencies}
\alias{export_understand_dependencies}
\title{Extract Understand Dependencies}
\usage{
export_understand_dependencies(
  scitools_path,
  db_filepath,
  parse_type = c("file", "class"),
  output_filepath
)
}
\arguments{
\item{scitools_path}{path to the scitools binary `und`}

\item{parse_type}{Type of dependencies to generate into xml (either "file" or "class")}

\item{output_filepath}{path to the output XML filepath of dependencies}

\item{db_path}{path to the scitools DB (see \code{\link{build_understand_project}})}
}
\value{
The output directory where the db will be created, i.e. output_dir parameter.
}
\description{
Extract the XML dependency file for either class or file granularity from
an understand DB.
}
\references{
See pg. 352 in https://documentation.scitools.com/pdf/understand.pdf Sept. 2024 Edition
}
\seealso{
Other parsers: 
\code{\link{build_understand_project}()},
\code{\link{parse_bugzilla_perceval_rest_issue_comments}()},
\code{\link{parse_bugzilla_perceval_traditional_issue_comments}()},
\code{\link{parse_bugzilla_rest_comments}()},
\code{\link{parse_bugzilla_rest_issues_comments}()},
\code{\link{parse_bugzilla_rest_issues}()},
\code{\link{parse_commit_message_id}()},
\code{\link{parse_dependencies}()},
\code{\link{parse_dv8_clusters}()},
\code{\link{parse_gitlog}()},
\code{\link{parse_jira_latest_date}()},
\code{\link{parse_jira_rss_xml}()},
\code{\link{parse_jira}()},
\code{\link{parse_mbox}()},
\code{\link{parse_nvdfeed}()},
\code{\link{parse_understand_dependencies}()}
}
\concept{parsers}
