% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dv8.R
\name{dv8_mdsmb_to_flaws}
\alias{dv8_mdsmb_to_flaws}
\title{Computes the Architectural Flaws folder}
\usage{
dv8_mdsmb_to_flaws(
  dv8_path,
  mdsmb_path,
  flaws_path,
  is_file_only_metric = FALSE,
  cliqueDepends = "call,use",
  crossingCochange = 2,
  crossingFanIn = 4,
  crossingFanOut = 4,
  mvCochange = 2,
  uiCochange = 2,
  uihDepends = "call,use",
  uihInheritance = "extend,implement,public,private,virtual",
  uiHistoryImpact = 10,
  uiStructImpact = 0.01
)
}
\arguments{
\item{dv8_path}{path to dv8 binary}

\item{mdsmb_path}{path to the merge binary DSM created by \code{\link{dv8_hdsmb_sdsmb_to_mdsmb}}.
Note you can also use a hdsmb or sdsmb separately to compute architectural flaws.}

\item{flaws_path}{path to save the architectural flaws folder}

\item{is_file_only_metric}{default is FALSE. If TRUE, uses DV8 computed file metrics. Caution: While much faster,
these metrics can *not* be used to aggregate. Choosing FALSE will generate the file to flaw id mapping. Choosing
TRUE will generate the aggregation from DV8.}

\item{cliqueDepends}{(For Clique detection) Filtered dependencies for clique detection. Multiple dependencies should be delimited using ","}

\item{crossingCochange}{(For Crossing detection) Threshold of co-change between two files}

\item{crossingFanIn}{(For Crossing detection) The number of other files that depend on it >= "crossingFanIn"}

\item{crossingFanOut}{(For Crossing detection) The number of other files it depends on >= "crossingFanOut"}

\item{mvCochange}{(For Modularity Violation detection) Threshold of co-change between two files}

\item{uiCochange}{(For Unstable Interface detection) Threshold of co-change between two files}

\item{uihDepends}{(For Unhealthy Inheritance detection) Filtered dependencies for unhealthy inheritance detection. Multiple dependencies should be delimited using ","}

\item{uihInheritance}{(For Unhealthy Inheritance detection) Dependencies for unhealthy inheritance detection. Multiple dependencies should be delimited using ","}

\item{uiHistoryImpact}{(For Unstable Interface detection) Threshold of the number of co-changed (more than "co-change" times) files}

\item{uiStructImpact}{(For Unstable Interface detection) Threshold of value < 1 means percentage of all files are dependents}
}
\value{
the path to the flaws folder
}
\description{
Computes the Architectural Flaws folder
}
\seealso{
\code{\link{parse_dv8_architectural_flaws}} to create a `.csv`
mapping of file to architectural flaw.

Other dv8: 
\code{\link{dependencies_to_sdsmj}()},
\code{\link{dv8_clsxb_to_clsxj}()},
\code{\link{dv8_clsxj_to_clsxb}()},
\code{\link{dv8_depends_to_sdsmj}()},
\code{\link{dv8_dsmj_to_dsmb}()},
\code{\link{dv8_hdsmb_sdsmb_to_mdsmb}()},
\code{\link{gitlog_to_hdsmj}()},
\code{\link{graph_to_dsmj}()},
\code{\link{parse_dv8_architectural_flaws}()},
\code{\link{parse_dv8_clusters}()},
\code{\link{transform_dependencies_to_sdsmj}()},
\code{\link{transform_gitlog_to_hdsmj}()},
\code{\link{transform_temporal_gitlog_to_adsmj}()}
}
\concept{dv8}
