% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dv8.R
\name{dv8_hdsmb_sdsmb_to_mdsmb}
\alias{dv8_hdsmb_sdsmb_to_mdsmb}
\title{Merge history DSM and structural DSM to merged DSM.}
\usage{
dv8_hdsmb_sdsmb_to_mdsmb(dv8_path, hdsmb_path, sdsmb_path, mdsmb_path)
}
\arguments{
\item{dv8_path}{path to dv8 binary}

\item{hdsmb_path}{path to historical DSM binary
created by \code{\link{dv8_gitnumstat_to_hdsmb}} or (\code{\link{gitlog_to_hdsmj}} and \code{\link{dv8_dsmj_to_dsmb}}).}

\item{sdsmb_path}{path to structural DSM binary created by (\code{\link{dependencies_to_sdsmj}},
or \code{\link{dependencies_to_sdsmj}}) and \code{\link{dv8_depends_to_sdsmj}}}

\item{mdsmb_path}{path to save the merge DSM binary}
}
\value{
the mdsmb_path
}
\description{
A history DSM (\*-hdsm.dv8-dsm) and a structural DSM (\*-sdsm.dv8-dsm) are
merged to a merge DSM (*.dv8-dsm)
}
\seealso{
\code{\link{dv8_mdsmb_drhier_to_excel}} to export a `*-merged.dv8-dsm` file to `merged.xlsx` for DSM visualization.
For analysis, see \code{\link{dv8_mdsmb_to_decoupling_level}} to calculate decoupling level `*-dl.json`, or
\code{\link{dv8_mdsmb_to_flaws}} to generate the architectural flaws `folder`.
For conversions, see \code{\link{dv8_mdsmb_to_hierclsxb}} to cluster the DSM to `*-clsx.dv8-clsx`, or
\code{\link{dv8_dsmb_to_dsmj}} to convert a `*-merged.dv8-dsm` binary file as a JSON `-*merged.json` file

Other dv8: 
\code{\link{dependencies_to_sdsmj}()},
\code{\link{dv8_clsxb_to_clsxj}()},
\code{\link{dv8_clsxj_to_clsxb}()},
\code{\link{dv8_depends_to_sdsmj}()},
\code{\link{dv8_dsmj_to_dsmb}()},
\code{\link{dv8_mdsmb_to_flaws}()},
\code{\link{gitlog_to_hdsmj}()},
\code{\link{graph_to_dsmj}()},
\code{\link{parse_dv8_architectural_flaws}()},
\code{\link{parse_dv8_clusters}()},
\code{\link{transform_dependencies_to_sdsmj}()},
\code{\link{transform_gitlog_to_hdsmj}()},
\code{\link{transform_temporal_gitlog_to_adsmj}()}
}
\concept{dv8}
