% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dv8.R
\name{dv8_gitnumstat_to_hdsmb}
\alias{dv8_gitnumstat_to_hdsmb}
\title{Converts a git log text file into a hdsmb binary file}
\usage{
dv8_gitnumstat_to_hdsmb(
  dv8_path,
  git_numstat_path,
  hdsmb_path,
  max_cochange_count = 1000,
  params_output_file = ""
)
}
\arguments{
\item{dv8_path}{path to DV8 binary}

\item{git_numstat_path}{path to local git log text file obtained by \code{\link{dv8_gitlog_to_gitnumstat}}}

\item{hdsmb_path}{name of output hdsmb binary file, defaults to name of input}

\item{max_cochange_count}{maximum count of co-changed files per commit, default 1000}

\item{params_output_file}{output file used to record parameters}
}
\value{
the hdsmb_path
}
\description{
An input file \*.txt is converted to \*.dv8-dsm
}
\seealso{
\code{\link{dv8_hdsmb_sdsmb_to_mdsmb}} to merge DSMs into `*-merge.dv8-dsm`.
}
