% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jira.R
\name{download_jira_issues_by_issue_key}
\alias{download_jira_issues_by_issue_key}
\title{Download JIRA Issues and/or Comments by Issue Key Range}
\usage{
download_jira_issues_by_issue_key(
  domain,
  jql_query,
  fields,
  username = NULL,
  password = NULL,
  save_folder_path,
  max_results,
  max_total_downloads,
  issue_key_lower_bound = NULL,
  issue_key_upper_bound = NULL,
  verbose
)
}
\arguments{
\item{domain}{Custom JIRA domain URL}

\item{jql_query}{Specific query string to specify criteria for fetching}

\item{fields}{List of fields that are downloaded in each issue}

\item{username}{the JIRA username}

\item{password}{the JIRA password/API token}

\item{save_folder_path}{Path that files will be saved in .json format}

\item{max_results}{(optional) the [maximum number of results](https://confluence.atlassian.com/jirakb/how-to-use-the-maxresults-api-parameter-for-jira-issue-search-rest-api-1251999998.html)
to download per page. Default is 50.}

\item{max_total_downloads}{Maximum downloads per function call.
This parameter specifies how many issues should be downloaded. Subsequent API calls will stop if they
reach or surpass this value.
See \code{\link{download_jira_issues_by_date}} and \code{\link{download_jira_issues_by_issue_key}}
source code for examples.}

\item{issue_key_lower_bound}{Optional. Specify the lower bound issue key (e.g. SAILUH-1)}

\item{issue_key_upper_bound}{Optional. Specify the upper bound issue key (e.g. SAILUH-3)}

\item{verbose}{Set verbose=TRUE to print execution details.}
}
\description{
#' Wraps around \code{\link{download_jira_issues}} providing jql query parameters for specifying issue key ranges.
Only issues created in the specified date range inclusive will be downloaded.
}
\details{
The acceptable format for `issue_key_lower_bound` and `issue_key_upper_bound` is: <project key>-<issue number>

For example: `issue_key_lower_bound=SAILUH-1` (SAILUH-1 will also be downloaded).

For further details on the `issueKey` JQL Query see [the associated JIRA API documentation](https://support.atlassian.com/jira-software-cloud/docs/jql-fields/#Issue-key)
}
\seealso{
\code{\link{download_jira_issues_by_date}} to download JIRA issues and/or comments by date range

\code{\link{download_jira_issues}} for more flexibility in specifying the JQL query

\code{\link{parse_jira}} to parse jira data with or without comments

\code{\link{refresh_jira_issues}} to obtain more recent data from any of the downloader functions

Other jira: 
\code{\link{download_jira_issues_by_date}()},
\code{\link{download_jira_issues}()},
\code{\link{refresh_jira_issues}()}

Other downloaders: 
\code{\link{download_jira_issues_by_date}()},
\code{\link{download_jira_issues}()},
\code{\link{refresh_jira_issues}()}
}
\concept{downloaders}
\concept{jira}
