% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jira.R
\name{download_jira_issues_by_date}
\alias{download_jira_issues_by_date}
\title{Download JIRA Issues and/or Comments by Date Range}
\usage{
download_jira_issues_by_date(
  domain,
  jql_query,
  fields,
  username = NULL,
  password = NULL,
  save_folder_path,
  max_results,
  max_total_downloads,
  date_lower_bound = NULL,
  date_upper_bound = NULL,
  verbose
)
}
\arguments{
\item{domain}{Custom JIRA domain URL}

\item{jql_query}{Specific query string to specify criteria for fetching}

\item{fields}{List of fields that are downloaded in each issue}

\item{username}{the JIRA username}

\item{password}{the JIRA password/API token}

\item{save_folder_path}{Path that files will be saved in .json format}

\item{max_results}{(optional) the [maximum number of results](https://confluence.atlassian.com/jirakb/how-to-use-the-maxresults-api-parameter-for-jira-issue-search-rest-api-1251999998.html)
to download per page. Default is 50.}

\item{max_total_downloads}{Maximum downloads per function call.
This parameter specifies how many issues should be downloaded. Subsequent API calls will stop if they
reach or surpass this value.
See \code{\link{download_jira_issues_by_date}} and \code{\link{download_jira_issues_by_issue_key}}
source code for examples.}

\item{date_lower_bound}{Optional. Specify the lower bound date time (e.g. 2023/11/16 21:00)}

\item{date_upper_bound}{Optional. Specify the upper bound date time (e.g. 2023/11/17 21:00)}

\item{verbose}{Set verbose=TRUE to print execution details.}
}
\description{
Wraps around \code{\link{download_jira_issues}} providing JQL query parameters for specifying date ranges.
Only issues created in the specified date range will be downloaded.
}
\details{
Acceptable formats for `date_lower_bound` and `date_upper_bound` are:

* "yyyy/MM/dd HH:mm"
* "yyyy-MM-dd HH:mm"
* "yyyy/MM/dd"
* "yyyy-MM-dd"

For example: `date_lower_bound=2023/11/16 21:00` (an issue ocurring at the exact specified time will also be downloaded).

For further details on the `created` JQL Query see [the associated JIRA API documentation](https://support.atlassian.com/jira-software-cloud/docs/jql-fields/#Created).
}
\seealso{
\code{\link{download_jira_issues_by_issue_key}} to download JIRA issues and/or comments by issue key range

\code{\link{download_jira_issues}} for more flexibility in specifying the JQL query

\code{\link{parse_jira}} to parse jira data with or without comments

\code{\link{refresh_jira_issues}} to obtain more recent data from any of the downloader functions

Other jira: 
\code{\link{download_jira_issues_by_issue_key}()},
\code{\link{download_jira_issues}()},
\code{\link{refresh_jira_issues}()}

Other downloaders: 
\code{\link{download_jira_issues_by_issue_key}()},
\code{\link{download_jira_issues}()},
\code{\link{refresh_jira_issues}()}
}
\concept{downloaders}
\concept{jira}
