% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jira.R
\name{download_jira_issues}
\alias{download_jira_issues}
\title{Download JIRA Issues and/or Comments}
\usage{
download_jira_issues(
  domain,
  jql_query,
  fields,
  username = NULL,
  password = NULL,
  save_folder_path,
  max_results = 50,
  max_total_downloads = 5000,
  search_query = NULL,
  verbose = FALSE
)
}
\arguments{
\item{domain}{Custom JIRA domain URL}

\item{jql_query}{Specific query string to specify criteria for fetching}

\item{fields}{List of fields that are downloaded in each issue}

\item{username}{the JIRA username}

\item{password}{the JIRA password/API token}

\item{save_folder_path}{Path that files will be saved in .json format}

\item{max_results}{(optional) the [maximum number of results](https://confluence.atlassian.com/jirakb/how-to-use-the-maxresults-api-parameter-for-jira-issue-search-rest-api-1251999998.html)
to download per page. Default is 50.}

\item{max_total_downloads}{Maximum downloads per function call.
This parameter specifies how many issues should be downloaded. Subsequent API calls will stop if they
reach or surpass this value.}

\item{search_query}{an optional API parameter that alters the GET request.
See \code{\link{download_jira_issues_by_date}} and \code{\link{download_jira_issues_by_issue_key}}
source code for examples.}

\item{verbose}{Set verbose=TRUE to print execution details.}
}
\description{
Download JIRA issues and/or comments using [rest/api/2/search](https://developer.atlassian.com/cloud/jira/platform/rest/v2/api-group-issue-search/#api-rest-api-2-search-post) endpoint
to the specified `save_folder_path`.
}
\details{
The folder assumes the following convention: "(PROJECTKEY)_(uniextimestamp_lowerbound)_(unixtimestamp_upperbound).json"
For example: "SAILUH_1231234_2312413.json".

Comments data are added when the field `comment` is included.

If a project requires authentication and authentication fails, the function will end without downloading any data.

If the number of results per page returned is less than the number specified, the max_results value will adjust to that value.
}
\seealso{
\code{\link{download_jira_issues_by_date}} to download JIRA issues and/or comments by date range

\code{\link{download_jira_issues_by_issue_key}} to download JIRA issues and/or comments by issue key range

\code{\link{parse_jira}} to parse jira data with or without comments

\code{\link{refresh_jira_issues}} to obtain more recent data from any of the downloader functions

Other jira: 
\code{\link{download_jira_issues_by_date}()},
\code{\link{download_jira_issues_by_issue_key}()},
\code{\link{refresh_jira_issues}()}

Other downloaders: 
\code{\link{download_jira_issues_by_date}()},
\code{\link{download_jira_issues_by_issue_key}()},
\code{\link{refresh_jira_issues}()}
}
\concept{downloaders}
\concept{jira}
