% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bugzilla.R
\name{download_bugzilla_rest_issues}
\alias{download_bugzilla_rest_issues}
\title{Download Bugzilla issues using the Bugzilla REST API}
\usage{
download_bugzilla_rest_issues(
  bugzilla_site,
  start_timestamp,
  save_folder_path,
  limit_upperbound = 500
)
}
\arguments{
\item{bugzilla_site}{URL to specific bugzilla site}

\item{start_timestamp}{when to start bug retrieval (ex. 2023-01-01T00:14:57Z)}

\item{save_folder_path}{the full *folder* path where the bugzilla issues will be stored}

\item{limit_upperbound}{the number of issues saved in each page file. Some bugzilla sites have limits set on how many bugs
can be retrieved in one GET request, in which case, the limit set by the bugzilla site will be used in place of
limit_upperbound to ensure full bug retrieval.}
}
\value{
a vector of bug ids
}
\description{
Downloads bugzilla issues into a folder, where each file is a json containing a page of issues.
Returns a list of bugzilla bug ids for use with \code{\link{download_bugzilla_rest_comments}}.
}
\details{
Note that some bugzilla sites limit the bugs that can retrieved in a single GET request.
The limit_upperbound you set to retrieve a number of bugs for each page/file may be greater
than the limit set for bug retrieval by the bugzilla site, in which case, this function
will adjust the limit accordingly to ensure all bugs are retrieved.
}
\seealso{
\code{\link{download_bugzilla_rest_comments}} a downloader function to download the issue comments
}
