% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bugzilla.R
\name{download_bugzilla_perceval_traditional_issue_comments}
\alias{download_bugzilla_perceval_traditional_issue_comments}
\title{Download Bugzilla issues and comments using Perceval traditional backend.}
\usage{
download_bugzilla_perceval_traditional_issue_comments(
  perceval_path,
  bugzilla_site,
  datetime,
  save_file_path,
  max_bugs = 500
)
}
\arguments{
\item{perceval_path}{path to perceval binary}

\item{bugzilla_site}{link to specific bugzilla site}

\item{datetime}{fetch bugs updated since this date (in any ISO 8601 format, e.g., 'YYYY-MM-DD HH:mm:SS+|-HH:MM'))}

\item{save_file_path}{the file path, name and extension (should be .json) to save the file.}

\item{max_bugs}{the maximum number of bugs requested on the same query. Note: Some sites might have restrictions on the number of bugs in one request.}
}
\value{
path to downloaded json file.
}
\description{
Download Bugzilla issues and comments using Perceval traditional backend.
}
\seealso{
\code{\link{parse_bugzilla_perceval_traditional_issue_comments}} a parser function to parse bugzilla data
}
