% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bugzilla.R
\name{download_bugzilla_perceval_rest_issue_comments}
\alias{download_bugzilla_perceval_rest_issue_comments}
\title{Download Bugzilla issues and comments using Perceval REST API backend.}
\usage{
download_bugzilla_perceval_rest_issue_comments(
  perceval_path,
  bugzilla_site,
  datetime,
  save_file_path,
  max_bugs = 500
)
}
\arguments{
\item{perceval_path}{path to perceval binary}

\item{bugzilla_site}{link to specific bugzilla site}

\item{datetime}{fetch bugs updated since this date (in any ISO 8601 format, e.g., 'YYYY-MM-DD HH:mm:SS+|-HH:MM'))}

\item{save_file_path}{the file path, name and extension (should be .json) to save the file.}

\item{max_bugs}{the maximum number of bugs requested on the same query. This acts as the limit parameter
in the Bugzilla REST API. Bugzilla sites may have specific limits set, so make sure to change the max_bugs
parameter accordingly to correctly download the data when using the "bugzillarest" backend.}
}
\value{
json object with bugzilla data
}
\description{
Note that for the Bugzilla REST API backend, Bugzilla sites may limit the number of bugs that can be retrieved at one time.
Thus, the max_bugs parameter needs to be set correctly to ensure all bugs are retrieved and that
the json data is not broken. If you get an error trying to parse the data downloaded with this
}
\seealso{
\code{\link{parse_bugzilla_perceval_rest_issue_comments}} a parser function to parse bugzilla data
}
