% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dv8.R
\name{dependencies_to_sdsmj}
\alias{dependencies_to_sdsmj}
\title{Transforms a dependencies table to a structural DSM JSON file.}
\usage{
dependencies_to_sdsmj(project_dependencies, sdsmj_path, is_sorted = FALSE)
}
\arguments{
\item{project_dependencies}{parsed dependencies table created by \code{\link{parse_dependencies}}}

\item{sdsmj_path}{path to save output file}

\item{is_sorted}{whether the json is sorted by src and dest}
}
\value{
the sdsmj_path
}
\description{
Converts table of dependencies from \code{\link{parse_dependencies}} into an *-sdsm.json.
In the sdsm.json, the Variables are all files/methods or any variables under analysis
(rows/columns in dependency matrix) and the Cells (matrix cell) contain all the relations of
 variable (src & dest) pairs.
}
\seealso{
\code{\link{dv8_dsmj_to_dsmb}} to convert to `*-sdsm.dv8-dsm` and
\code{\link{dv8_hdsmb_sdsmb_to_mdsmb}} to merge DSMs into `*-merge.dv8-dsm`.

Other dv8: 
\code{\link{dv8_clsxb_to_clsxj}()},
\code{\link{dv8_clsxj_to_clsxb}()},
\code{\link{dv8_depends_to_sdsmj}()},
\code{\link{dv8_dsmj_to_dsmb}()},
\code{\link{dv8_hdsmb_sdsmb_to_mdsmb}()},
\code{\link{dv8_mdsmb_to_flaws}()},
\code{\link{gitlog_to_hdsmj}()},
\code{\link{graph_to_dsmj}()},
\code{\link{parse_dv8_architectural_flaws}()},
\code{\link{parse_dv8_clusters}()},
\code{\link{transform_dependencies_to_sdsmj}()},
\code{\link{transform_gitlog_to_hdsmj}()},
\code{\link{transform_temporal_gitlog_to_adsmj}()}
}
\concept{dv8}
