% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric.R
\name{commit_message_id_coverage}
\alias{commit_message_id_coverage}
\title{Commit Message Id Coverage Metric}
\usage{
commit_message_id_coverage(git_log, commit_message_id_regex)
}
\arguments{
\item{git_log}{a parsed git log table where each row is identified by commit+file}

\item{commit_message_id_regex}{the regex to extract the id from the commit message
in the table}
}
\value{
a single numeric value with the number of commits which contains the id
}
\description{
Calculates the number of commits from the git log which contains the message id.
}
\seealso{
\code{\link{parse_gitlog}} to obtain additions and deletions from gitlog

Other {metrics}: 
\code{\link{metric_churn_per_commit_interval}()},
\code{\link{metric_churn_per_commit_per_file}()},
\code{\link{metric_churn}()},
\code{\link{metric_file_bug_churn}()},
\code{\link{metric_file_bug_frequency}()},
\code{\link{metric_file_churn}()},
\code{\link{metric_file_non_bug_churn}()},
\code{\link{metric_file_non_bug_frequency}()}
}
\concept{{metrics}}
