% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{bipartite_graph_projection}
\alias{bipartite_graph_projection}
\title{Apply a bipartite graph projection}
\usage{
bipartite_graph_projection(graph, mode, weight_scheme_function = NULL)
}
\arguments{
\item{graph}{A bipartite network (the same pair of nodes can *not* have multiple edges)}

\item{mode}{Which of the two nodes the projection should be applied to. TRUE or FALSE}

\item{weight_scheme_function}{When not specified, bipartite_graph_projection will return an intermediate
projection table specifying the deleted node, from_projection, to_projection, from_weight, and to_weight.
This table also contains (N choose 2) rows for every "deleted_node" in the original graph.
When receiving as parameter \code{\link{weight_scheme_sum_edges}} or
\code{\link{weight_scheme_count_deleted_nodes}}, the final projection table will be returned instead.}
}
\value{
A graph projection.
}
\description{
Apply a bipartite graph projection
}
