# SaaS 最佳实践 - 2024
在我们的创业之旅中，我们确定了最佳实践和实用工具。每个季度，我们都会重新审视和更新我们的榜单，以反映最新的见解和发展。

[![issues](https://img.shields.io/github/issues/saasfly/best-practice?color=green)](https://github.com/saasfly/best-practice/issues)
[![prs](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](https://github.com/saasfly/best-practice/pulls)
[![stars](https://img.shields.io/github/stars/saasfly/best-practice.svg?color=yellow)](https://github.com/saasfly/best-practice)
[![forks](https://img.shields.io/github/forks/saasfly/best-practice.svg?color=orange)](https://github.com/saasfly/best-practice)
[![License: CC BY-NC-SA 4.0](https://img.shields.io/badge/License-CC%20BY--NC--SA%204.0-lightgrey.svg)](https://creativecommons.org/licenses/by-nc-sa/4.0/)
[![chinese](https://img.shields.io/badge/-English-blue.svg)](README.md)

## 注意
目前,我们原则上只接受与翻译相关的pull requests,以及开源作者的自我推荐。不过,在提交自我推荐的PR之前,我们建议您先与我们进行友善沟通,以确保双方的期望一致。

## 许可证
[SaaS最佳实践](https://practices.best/)由[Nextify Limited](https://nextify.ltd)在[CC BY-NC-SA 4.0](http://creativecommons.org/licenses/by-nc-sa/4.0/?ref=chooser-v1)许可下发布。

| 目录 | 标题 | 描述 | 链接 |
| --- | --- | --- | --- |
| 强烈推荐 | Cloudflare | 全栈开发所需的一切 | https://www.cloudflare.com/ |
|  | Vercel | 最佳Next.js托管提供商 | https://vercel.com |
|  | Fly.io | 如果你使用Docker,就选它 | https://fly.io |
|  | AWS | 除了成本,没有任何缺点 | https://aws.amazon.com |
|  | ChatGPT | 最强大的AI | https://chat.openai.com/ |
|  | Github | 全球领先的AI驱动开发者平台 | https://github.com/ |
|  | Stripe | 在线支付的新标准 | https://stripe.com |
|  | Your Site（ad） | 联系我们 | / |
| AI | OpenAI | OpenAI是一家AI研究和部署公司 | https://openai.com/ |
|  | Midjourney | Midjourney是一个创建和分享AI生成内容的平台 | https://www.midjourney.com |
|  | Perplexity AI | 引导式AI搜索,更深入探索 | https://www.perplexity.ai |
| 创业积分 | AWS | 最高可获得100,000美元的AWS Activate积分 | https://aws.amazon.com/startups/credits |
|  | Azure | 最高可获得2年120,000美元的免费Azure云服务等 | https://azure.microsoft.com/free/startups/ |
|  | GCP | AI创业公司最高可获得350,000美元 | https://cloud.google.com/startup |
|  | 阿里云 | 终身最高可获得120,000美元云积分 | https://www.alibabacloud.com/startup |
| 全栈 | React | 用于Web和原生用户界面的库 | https://reactjs.org/ |
|  | Next.js | 用于生产环境的React框架 | https://nextjs.org/ |
|  | Shadcn/ui | 设计精美的组件 | https://ui.shadcn.com/ |
|  | Auth.js | Next.js的身份验证库 | https://authjs.dev |
|  | Vue.js | 渐进式JavaScript框架 | https://vuejs.org |
|  | Nuxt.js | 直观的Vue框架 | https://nuxtjs.org |
|  | UI库 | UI库合集 | https://ui-libs.vercel.app |
|  | Pinia | 直观的Vue.js状态管理库 | https://pinia.vuejs.org |
|  | Zustand | 一个小巧、快速、可扩展的React状态管理库 | https://docs.pmnd.rs/zustand/getting-started/introduction |
|  | Jotai | 原始灵活的React状态管理 | https://jotai.org |
|  | ahooks | 一个高质量可靠的React Hooks库 | https://ahooks.js.org/ |
|  | Kysely | 用于TypeScript的SQL查询构建器 | https://kysely.dev/ |
| 后端 | Hono | 快速、轻量级、符合Web标准,可在任何JavaScript运行时运行 | https://hono.dev/ |
|  | ElysiaJS | 快速、轻量级、符合Web标准,可在任何JavaScript运行时运行 | https://elysiajs.com/ |
|  | Quarkus | 超音速亚原子Java | https://quarkus.io/ |
|  | FastAPI | FastAPI是一个用于构建API的现代、快速(高性能)的Web框架,使用Python 3.7+基于标准的Python类型提示 | https://fastapi.tiangolo.com |
| 架构&DevOps | Traefik | 云原生应用代理 | https://traefik.io/ |
|  | Dockge | 自托管-Docker compose.yaml-面向堆栈的管理器 | https://dockge.kuma.pet/ |
|  | Dozzle | 基于Web的Docker日志查看器,提供实时监控 | https://dozzle.dev/ |
|  | Authentik | 你需要的身份验证粘合剂 | https://goauthentik.io/ |
|  | Umami | 轻松收集、分析和理解你的网站数据 | https://umami.is/ |
|  | Uptime | 一个自托管的监控工具 | https://uptime.kuma.pet/ |
|  | Outline | 你团队的知识库-wiki、文档、手册等-全都在一个地方 | https://github.com/outline/outline |
|  | PocketBase | 开源实时后端,一个文件搞定 | https://pocketbase.io/ |
| 网站生成器 | Starlight | 构建一流文档网站所需的一切。快速、易访问、易使用 | https://starlight.astro.build/ |
|  | VitePress | 由Vite&Vue驱动的静态网站生成器 | https://vitepress.dev/ |
|  | Nextra | 一个Next.js静态网站生成器 | https://nextra.site/ |
| Node工具链 | Bun | 使用Bun开发、测试、运行和打包JavaScript和TypeScript项目 | https://bun.sh |
|  | Deno | 一个安全的JavaScript和TypeScript运行时 | https://deno.land |
|  | Node.js | 基于Chrome V8引擎的Node.js,用于构建快速可扩展的网络应用 | https://nodejs.org/ |
|  | Turbo | Turbo是一个用Rust编写的针对JavaScript和TypeScript优化的增量打包器和构建系统 | https://turbo.build |
|  | Vite | Vite是一个构建工具,旨在为现代Web项目提供更快、更精简的开发体验 | https://vitejs.dev |
|  | Biome | 以极快的速度格式化、lint等 | https://biomejs.dev/ |
|  | pnpm | 快速、节省磁盘空间的包管理器 | https://pnpm.io/ |
|  | Yarn | 快速、可靠、安全的依赖管理 | https://yarnpkg.com/ |
| CSS | PostCSS | 一个用JavaScript转换CSS的工具 | https://postcss.org |
|  | Sass | 具有超能力的CSS | https://sass-lang.com |
|  | TailwindCSS | 一个实用优先的CSS框架,用于快速构建定制设计 | https://tailwindcss.com/ |
|  | UnoCSS | 即时按需原子化CSS引擎 | https://unocss.dev/ |
| 很棒的软件  | 命令行 | iTerm2 + zsh + oh-my-zsh  | |
|   | IDE | Jetbrains ide  | https://www.jetbrains.com/ |
|   | IDE | Visual Studio Code  | https://code.visualstudio.com/ |
|   | 浏览器 | Arc  | https://arc.net/ |
|   | IM | Discord  | https://discord.com/ |
|   | Git图形客户端 | GitBulter | https://gitbutler.com/ |
| 云原生 |  |  |  |
| SaaS服务 |  |  |  |
