# SaaS Best Practices - 2024 
During our entrepreneurial journey, we've identified best practices and practical tools. Every quarter, we revisit and update our list to reflect the latest insights and developments.

[![issues](https://img.shields.io/github/issues/saasfly/best-practice?color=green)](https://github.com/saasfly/best-practice/issues)
[![prs](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](https://github.com/saasfly/best-practice/pulls)
[![stars](https://img.shields.io/github/stars/saasfly/best-practice.svg?color=yellow)](https://github.com/saasfly/best-practice)
[![forks](https://img.shields.io/github/forks/saasfly/best-practice.svg?color=orange)](https://github.com/saasfly/best-practice)
[![License: CC BY-NC-SA 4.0](https://img.shields.io/badge/License-CC%20BY--NC--SA%204.0-lightgrey.svg)](https://creativecommons.org/licenses/by-nc-sa/4.0/)
[![chinese](https://img.shields.io/badge/-Chinese-blue.svg)](README_zh.md)

## Attention

Currently, we primarily accept pull requests related to translations and self-recommendations from open-source authors.
However, before submitting a self-recommendation PR, we advise you to engage in friendly communication with us to ensure that expectations are aligned on both sides.

## License
[SaaS Best Practices](https://practices.best/) by [Nextify Limited](https://nextify.ltd) is licensed under [CC BY-NC-SA 4.0](http://creativecommons.org/licenses/by-nc-sa/4.0/?ref=chooser-v1).

| Category | Title | Description | Link |
| --- | --- | --- | --- |
| Highly Recommended | Cloudflare | Anything you need in full stack develop | https://www.cloudflare.com/ |
|  | Vercel | Best Next.js Hosting Providers | https://vercel.com |
|  | Fly.io | If you use Docker, choose it | https://fly.io |
|  | AWS | Apart from the cost, there are no disadvantages. | https://aws.amazon.com |
|  | ChatGPT | The most powerful AI | https://chat.openai.com/ |
|  | Github | The world's leading AI-powered developer platform. | https://github.com/ |
|  | Stripe | The new standard in online payments | https://stripe.com |
|  | Your Site(ad) | Contact us  | / |
| AI | OpenAI | OpenAI is an AI research and deployment company. | https://openai.com/ |
|  | Midjourney | Midjourney is a platform for creating and sharing AI-generated content | https://www.midjourney.com |
|  | Perplexity AI | Guided AI search for deeper exploration | https://www.perplexity.ai |
| Startups Credits | AWS | Up to $100,000 USD in AWS Activate Credits. | https://aws.amazon.com/startups/credits |
|  | Azure | Up to $120,000 USD of free Azure cloud for 2 years and more. | https://azure.microsoft.com/free/startups/ |
|  | GCP | Up to $350,000 USD for AI startups | https://cloud.google.com/startup |
|  | Alibaba Cloud | Up to $120K USD of cloud credits in a lifetime. | https://www.alibabacloud.com/startup |
| Full Stack | React | A library for web and native user interfaces | https://reactjs.org/ |
|  | Next.js | The React Framework for Production | https://nextjs.org/ |
|  | Shadcn/ui | Beautifully designed components | https://ui.shadcn.com/ |
|  | Auth.js | Authentication library for Next.js | https://authjs.dev |
|  | Vue.js | The Progressive JavaScript Framework | https://vuejs.org |
|  | Nuxt.js | The Intuitive Vue Framework | https://nuxtjs.org |
|  | UI Libs | A collection of UI libraries | https://ui-libs.vercel.app |
|  | Pinia | Intuitive Vue.js Store | https://pinia.vuejs.org |
|  | Zustand | A small, fast and scaleable bearbones state-management for React | https://docs.pmnd.rs/zustand/getting-started/introduction |
|  | Jotai | primitive and flexible state management for React | https://jotai.org |
|  | ahooks | A high-quality & reliable React Hooks library | https://ahooks.js.org/ |
|  | Kysely | SQL query builder for TypeScript | https://kysely.dev/ |
| Backend | Hono | Fast, Lightweight, Web-standards , Runs on any JavaScript runtime. | https://hono.dev/ |
|  | ElysiaJS | Fast, Lightweight, Web-standards ,Runs on any JavaScript runtime. | https://elysiajs.com/ |
|  | Quarkus | Supersonic Subatomic Java | https://quarkus.io/ |
|  | FastAPI | FastAPI is a modern, fast (high-performance), web framework for building APIs with Python 3.7+ based on standard Python type hints. | https://fastapi.tiangolo.com |
| Architecture & DevOps | Traefik | The Cloud Native Application Proxy | https://traefik.io/ |
|  | Dockge | Self-hosted - Docker compose.yaml - Stack-oriented Manager | https://dockge.kuma.pet/ |
|  | Dozzle | web-based Docker log viewer that provides real-time monitoring | https://dozzle.dev/ |
|  | Authentik | The authentication glue you need. | https://goauthentik.io/ |
|  | Umami | easy to collect, analyze, and understand your web data | https://umami.is/ |
|  | Uptime | A self-hosted monitoring tool | https://uptime.kuma.pet/ |
|  | Outline | Your team's knowledge base – wiki, documentation, playbooks, and more – all in one place. | https://github.com/outline/outline |
|  | PocketBase | Open Source realtime backend in 1 file | https://pocketbase.io/ |
|  | SQLite | The most used database engine in the world |  https://www.sqlite.org/ |
|  | PostgreSQL| The World's Most Advanced Open Source Relational Database| https://www.postgresql.org/ |
| Site generator | Starlight | Everything you need to build a stellar documentation website. Fast, accessible, and easy-to-use. | https://starlight.astro.build/ |
|  | VitePress | Vite & Vue powered static site generator | https://vitepress.dev/ |
|  | Nextra | A Next.js static site generator | https://nextra.site/ |
| Node ToolChain | Bun | Develop, test, run, and bundle JavaScript & TypeScript projects—all with Bun | https://bun.sh |
|  | Deno | A secure runtime for JavaScript and TypeScript | https://deno.land |
|  | Node.js | Node.js based on Chrome V8 engine for building fast and scalable network applications. | https://nodejs.org/ |
|  | Turbo | Turbo is an incremental bundler and build system optimized for JavaScript and TypeScript, written in Rust | https://turbo.build |
|  | Vite | Vite is a build tool that aims to provide a faster and leaner development experience for modern web projects. | https://vitejs.dev |
|  | Biome | Format, lint, and more in a fraction of a second. | https://biomejs.dev/ |
|  | pnpm | Fast, disk space efficient package manager | https://pnpm.io/ |
|  | Yarn | Fast, reliable, and secure dependency management | https://yarnpkg.com/ |
| CSS | PostCSS | A tool for transforming CSS with JavaScript | https://postcss.org |
|  | Sass | CSS with superpowers | https://sass-lang.com |
|  | TailwindCSS | A utility-first CSS framework for rapidly building custom designs | https://tailwindcss.com/ |
|  | UnoCSS | Instant On-demand Atomic CSS Engine | https://unocss.dev/ |
| Awesome Software  | Terminal | iTerm2 + zsh + oh-my-zsh  | |
|   | IDE | Jetbrains ide  | https://www.jetbrains.com/ |
|   | IDE | Visual Studio Code  | https://code.visualstudio.com/ |
|   | Brower | Arc  | https://arc.net/ |
|   | IM | Discord  | https://discord.com/ |
|   | Git GUI | GitBulter | https://gitbutler.com/ |
| Cloud Native |  |  |  |
| SaaS Service |  |  |  |
