import styled from 'styled-components'

interface Props {
  width?: number
}

const Svg = styled.svg`
  rect {
    stroke: var(--primary);
  }

  rect:last-of-type {
    fill: var(--primary);
  }

  path:first-of-type {
    fill: var(--primary);
  }
`

export function Logo({ width = 200 }: Props) {
  return (
    <Svg
      viewBox="0 0 256 95"
      width={width}
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <rect x={1.5} y={1.5} width={253} height={92} rx={2.5} strokeWidth={3} />
      <path d="M102.496 46.488c.96 0 1.739-.256 2.336-.768.597-.512.896-1.216.896-2.112 0-.917-.299-1.632-.896-2.144-.597-.512-1.376-.768-2.336-.768h-2.944v5.792h2.944zM99.52 50.84V59h-5.056V36.312h8.544c1.152 0 2.197.181 3.136.544.96.363 1.781.864 2.464 1.504a6.235 6.235 0 011.6 2.304c.384.896.576 1.867.576 2.912 0 1.067-.192 2.048-.576 2.944a6.235 6.235 0 01-1.6 2.304c-.683.64-1.504 1.141-2.464 1.504-.939.341-1.984.512-3.136.512H99.52zm24.017-2.944a5.636 5.636 0 00-.8-.128 8.881 8.881 0 00-.736-.032c-.49 0-.96.075-1.408.224-.448.15-.842.395-1.184.736-.341.341-.618.79-.832 1.344-.192.555-.288 1.227-.288 2.016V59h-4.864V43.096h4.704v2.144c.214-.448.48-.821.8-1.12a4.32 4.32 0 011.088-.704c.384-.17.768-.288 1.152-.352a5.349 5.349 0 011.088-.128c.491 0 .918.053 1.28.16v4.8zM133.596 55c.47 0 .918-.075 1.344-.224.427-.17.8-.416 1.12-.736.342-.341.608-.757.8-1.248.214-.49.32-1.077.32-1.76 0-.661-.106-1.237-.32-1.728-.192-.512-.458-.928-.8-1.248a2.933 2.933 0 00-1.12-.704 3.58 3.58 0 00-1.344-.256c-.448 0-.896.085-1.344.256-.426.15-.81.384-1.152.704-.32.32-.586.736-.8 1.248-.192.49-.288 1.067-.288 1.728s.096 1.248.288 1.76c.214.49.48.907.8 1.248.342.32.726.565 1.152.736.448.15.896.224 1.344.224zm0-12.384c1.195 0 2.304.213 3.328.64a7.726 7.726 0 012.656 1.728 7.883 7.883 0 011.792 2.656c.448 1.024.672 2.155.672 3.392s-.224 2.379-.672 3.424a7.883 7.883 0 01-1.792 2.656 8.129 8.129 0 01-2.656 1.76c-1.024.405-2.133.608-3.328.608-1.194 0-2.304-.203-3.328-.608a8.51 8.51 0 01-2.688-1.76 8.583 8.583 0 01-1.792-2.656c-.426-1.045-.64-2.187-.64-3.424s.214-2.368.64-3.392a8.583 8.583 0 011.792-2.656 8.077 8.077 0 012.688-1.728c1.024-.427 2.134-.64 3.328-.64zm11.579 22.464V43.096h4.704v1.632c.342-.512.918-.97 1.728-1.376.811-.427 1.792-.64 2.944-.64s2.187.213 3.104.64a6.186 6.186 0 012.304 1.728c.64.725 1.131 1.6 1.472 2.624.342 1.003.512 2.101.512 3.296 0 1.216-.192 2.336-.576 3.36a7.673 7.673 0 01-1.568 2.656 7.277 7.277 0 01-2.4 1.728c-.917.405-1.93.608-3.04.608-1.024 0-1.909-.15-2.656-.448-.746-.32-1.301-.704-1.664-1.152v7.328h-4.864zm12-14.048c0-.661-.096-1.237-.288-1.728a3.26 3.26 0 00-.8-1.216 2.992 2.992 0 00-1.184-.736 3.58 3.58 0 00-1.344-.256c-.469 0-.928.085-1.376.256-.426.15-.81.395-1.152.736a3.49 3.49 0 00-.768 1.216c-.192.49-.288 1.067-.288 1.728s.096 1.237.288 1.728c.192.49.448.907.768 1.248.342.32.726.565 1.152.736.448.17.907.256 1.376.256.47 0 .918-.075 1.344-.224.448-.17.843-.416 1.184-.736.342-.341.608-.757.8-1.248.192-.512.288-1.099.288-1.76zM172.378 55c.469 0 .917-.075 1.344-.224.426-.17.8-.416 1.12-.736.341-.341.608-.757.8-1.248.213-.49.32-1.077.32-1.76 0-.661-.107-1.237-.32-1.728-.192-.512-.459-.928-.8-1.248a2.94 2.94 0 00-1.12-.704 3.587 3.587 0 00-1.344-.256c-.448 0-.896.085-1.344.256-.427.15-.811.384-1.152.704-.32.32-.587.736-.8 1.248-.192.49-.288 1.067-.288 1.728s.096 1.248.288 1.76c.213.49.48.907.8 1.248.341.32.725.565 1.152.736.448.15.896.224 1.344.224zm0-12.384c1.194 0 2.304.213 3.328.64a7.736 7.736 0 012.656 1.728 7.898 7.898 0 011.792 2.656c.448 1.024.672 2.155.672 3.392s-.224 2.379-.672 3.424a7.898 7.898 0 01-1.792 2.656 8.14 8.14 0 01-2.656 1.76c-1.024.405-2.134.608-3.328.608-1.195 0-2.304-.203-3.328-.608a8.51 8.51 0 01-2.688-1.76 8.566 8.566 0 01-1.792-2.656c-.427-1.045-.64-2.187-.64-3.424s.213-2.368.64-3.392a8.566 8.566 0 011.792-2.656 8.077 8.077 0 012.688-1.728c1.024-.427 2.133-.64 3.328-.64zm14.395 11.136c.042.555.256 1.056.64 1.504.405.427 1.024.64 1.856.64.618 0 1.077-.139 1.376-.416.32-.277.48-.597.48-.96 0-.299-.118-.555-.352-.768-.214-.235-.619-.416-1.216-.544l-1.824-.416c-.854-.192-1.579-.448-2.176-.768-.598-.32-1.088-.693-1.472-1.12a3.958 3.958 0 01-.832-1.408 5.017 5.017 0 01-.256-1.6c0-.725.149-1.408.448-2.048a5.007 5.007 0 011.248-1.664 6.126 6.126 0 011.952-1.152c.746-.277 1.568-.416 2.464-.416 1.152 0 2.122.16 2.912.48.789.32 1.429.725 1.92 1.216.512.47.885.981 1.12 1.536.234.533.373 1.035.416 1.504l-4.032.736a2.367 2.367 0 00-.64-1.376c-.342-.384-.886-.576-1.632-.576-.47 0-.875.128-1.216.384-.342.235-.512.565-.512.992 0 .341.117.608.352.8.234.192.533.32.896.384l2.112.416c1.664.341 2.89.97 3.68 1.888.81.896 1.216 1.93 1.216 3.104 0 .683-.128 1.344-.384 1.984a4.916 4.916 0 01-1.184 1.728c-.534.49-1.195.885-1.984 1.184-.79.32-1.718.48-2.784.48-1.259 0-2.315-.17-3.168-.512-.832-.363-1.504-.8-2.016-1.312s-.896-1.056-1.152-1.632c-.235-.576-.363-1.088-.384-1.536l4.128-.736zm11.099.864c0-.704.117-1.333.352-1.888a4.276 4.276 0 011.024-1.408 4.865 4.865 0 011.472-.96 7.475 7.475 0 011.856-.544l3.744-.576c.426-.064.725-.192.896-.384.17-.192.256-.427.256-.704 0-.47-.203-.875-.608-1.216-.384-.341-.96-.512-1.729-.512-.853 0-1.514.245-1.983.736-.448.47-.694 1.003-.736 1.6l-4.224-.864c.042-.576.213-1.173.512-1.792a5.633 5.633 0 011.28-1.696c.576-.512 1.29-.939 2.144-1.28.853-.341 1.866-.512 3.04-.512 1.28 0 2.368.17 3.264.512.896.32 1.621.768 2.176 1.344a4.583 4.583 0 011.216 1.952c.256.747.384 1.525.384 2.336v7.776c0 .619.021 1.163.064 1.632.064.47.106.747.128.832h-4.384a4.173 4.173 0 01-.096-.512c-.043-.299-.064-.725-.064-1.28a4.642 4.642 0 01-1.761 1.632c-.746.405-1.653.608-2.719.608-.875 0-1.654-.139-2.336-.416-.683-.256-1.259-.608-1.728-1.056a4.797 4.797 0 01-1.088-1.536 4.782 4.782 0 01-.352-1.824zm6.688 1.312c.362 0 .714-.043 1.056-.128.362-.107.672-.277.928-.512.277-.256.501-.587.672-.992.17-.405.256-.917.256-1.536v-.704l-3.008.48c-.512.085-.939.267-1.28.544-.342.256-.512.661-.512 1.216 0 .427.138.81.416 1.152.298.32.789.48 1.472.48zM216.3 59V35.832h4.864V59H216.3zm11.973-5.248c.042.555.256 1.056.64 1.504.405.427 1.024.64 1.856.64.618 0 1.077-.139 1.376-.416.32-.277.48-.597.48-.96 0-.299-.118-.555-.352-.768-.214-.235-.619-.416-1.216-.544l-1.824-.416c-.854-.192-1.579-.448-2.176-.768-.598-.32-1.088-.693-1.472-1.12a3.958 3.958 0 01-.832-1.408 5.017 5.017 0 01-.256-1.6c0-.725.149-1.408.448-2.048a5.007 5.007 0 011.248-1.664 6.126 6.126 0 011.952-1.152c.746-.277 1.568-.416 2.464-.416 1.152 0 2.122.16 2.912.48.789.32 1.429.725 1.92 1.216.512.47.885.981 1.12 1.536.234.533.373 1.035.416 1.504l-4.032.736a2.367 2.367 0 00-.64-1.376c-.342-.384-.886-.576-1.632-.576-.47 0-.875.128-1.216.384-.342.235-.512.565-.512.992 0 .341.117.608.352.8.234.192.533.32.896.384l2.112.416c1.664.341 2.89.97 3.68 1.888.81.896 1.216 1.93 1.216 3.104 0 .683-.128 1.344-.384 1.984a4.916 4.916 0 01-1.184 1.728c-.534.49-1.195.885-1.984 1.184-.79.32-1.718.48-2.784.48-1.259 0-2.315-.17-3.168-.512-.832-.363-1.504-.8-2.016-1.312s-.896-1.056-1.152-1.632c-.235-.576-.363-1.088-.384-1.536l4.128-.736z" />
      <rect x={18} y={15} width={65} height={65} rx={4} />
      <path
        d="M33.464 59V36.312h14.368v4.768H38.52v4.32h8.448v4.448H38.52V54.2h9.344V59h-14.4zm29.728-15.84a3.413 3.413 0 00-.288-.864 2.427 2.427 0 00-.64-.928c-.277-.299-.65-.544-1.12-.736-.47-.213-1.045-.32-1.728-.32-.938 0-1.696.256-2.272.768-.554.49-.832 1.045-.832 1.664 0 .555.17 1.024.512 1.408.363.363.939.619 1.728.768l3.04.576c1.088.192 2.038.512 2.848.96.81.427 1.494.939 2.048 1.536.555.597.97 1.27 1.248 2.016.278.725.416 1.493.416 2.304a6.65 6.65 0 01-.544 2.624 6.807 6.807 0 01-1.632 2.304c-.704.661-1.578 1.205-2.624 1.632-1.045.405-2.24.608-3.584.608-1.578 0-2.933-.224-4.064-.672-1.13-.47-2.07-1.056-2.816-1.76s-1.312-1.483-1.696-2.336c-.384-.853-.618-1.685-.704-2.496l4.64-1.12c.043.512.16 1.013.352 1.504.214.47.512.885.896 1.248.384.341.864.619 1.44.832.576.213 1.248.32 2.016.32 1.003 0 1.782-.213 2.336-.64.576-.448.864-1.024.864-1.728 0-.576-.224-1.056-.672-1.44-.426-.405-1.013-.683-1.76-.832l-3.104-.576c-1.941-.363-3.456-1.141-4.544-2.336-1.088-1.195-1.632-2.635-1.632-4.32 0-1.067.214-2.048.64-2.944a7.3 7.3 0 011.792-2.304 8.434 8.434 0 012.592-1.504 8.881 8.881 0 013.104-.544c1.408 0 2.614.192 3.616.576 1.003.384 1.824.875 2.464 1.472.662.576 1.163 1.227 1.504 1.952.342.704.576 1.387.704 2.048l-4.544 1.28z"
        fill="#000"
      />
    </Svg>
  )
}
