package com.tsunderebug.scolor.otf.types.gen

import spire.math.UShort

case class MacLanguage(script: UShort, language: UShort)

object MacLanguage {

  object Script {

    val `Roman` = UShort(0)
    val `Japanese` = UShort(1)
    val `Chinese (Traditional)` = UShort(2)
    val `Korean` = UShort(3)
    val `Arabic` = UShort(4)
    val `Hebrew` = UShort(5)
    val `Greek` = UShort(6)
    val `Russian` = UShort(7)
    val `RSymbol` = UShort(8)
    val `Devanagari` = UShort(9)
    val `Gurmukhi` = UShort(10)
    val `Gujarati` = UShort(11)
    val `Oriya` = UShort(12)
    val `Bengali` = UShort(13)
    val `Tamil` = UShort(14)
    val `Telugu` = UShort(15)
    val `Kannada` = UShort(16)
    val `Malayalam` = UShort(17)
    val `Sinhalese` = UShort(18)
    val `Burmese` = UShort(19)
    val `Khmer` = UShort(20)
    val `Thai` = UShort(21)
    val `Laotian` = UShort(22)
    val `Georgian` = UShort(23)
    val `Armenian` = UShort(24)
    val `Chinese (Simplified)` = UShort(25)
    val `Tibetan` = UShort(26)
    val `Mongolian` = UShort(27)
    val `Geez` = UShort(28)
    val `Slavic` = UShort(29)
    val `Vietnamese` = UShort(30)
    val `Sindhi` = UShort(31)
    val `Uninterpreted` = UShort(32)

  }

  object Language {

    val `English` = UShort(0)
    val `French` = UShort(1)
    val `German` = UShort(2)
    val `Italian` = UShort(3)
    val `Dutch` = UShort(4)
    val `Swedish` = UShort(5)
    val `Spanish` = UShort(6)
    val `Danish` = UShort(7)
    val `Portuguese` = UShort(8)
    val `Norwegian` = UShort(9)
    val `Hebrew` = UShort(10)
    val `Japanese` = UShort(11)
    val `Arabic` = UShort(12)
    val `Finnish` = UShort(13)
    val `Greek` = UShort(14)
    val `Icelandic` = UShort(15)
    val `Maltese` = UShort(16)
    val `Turkish` = UShort(17)
    val `Croatian` = UShort(18)
    val `Chinese (Traditional)` = UShort(19)
    val `Urdu` = UShort(20)
    val `Hindi` = UShort(21)
    val `Thai` = UShort(22)
    val `Korean` = UShort(23)
    val `Lithuanian` = UShort(24)
    val `Polish` = UShort(25)
    val `Hungarian` = UShort(26)
    val `Estonian` = UShort(27)
    val `Latvian` = UShort(28)
    val `Sami` = UShort(29)
    val `Faroese` = UShort(30)
    val `Farsi/Persian` = UShort(31)
    val `Russian` = UShort(32)
    val `Chinese (Simplified)` = UShort(33)
    val `Flemish` = UShort(34)
    val `Irish Gaelic` = UShort(35)
    val `Albanian` = UShort(36)
    val `Romanian` = UShort(37)
    val `Czech` = UShort(38)
    val `Slovak` = UShort(39)
    val `Slovenian` = UShort(40)
    val `Yiddish` = UShort(41)
    val `Serbian` = UShort(42)
    val `Macedonian` = UShort(43)
    val `Bulgarian` = UShort(44)
    val `Ukrainian` = UShort(45)
    val `Byelorussian` = UShort(46)
    val `Uzbek` = UShort(47)
    val `Kazakh` = UShort(48)
    val `Azerbaijani (Cyrillic script)` = UShort(49)
    val `Azerbaijani (Arabic script)` = UShort(50)
    val `Armenian` = UShort(51)
    val `Georgian` = UShort(52)
    val `Moldavian` = UShort(53)
    val `Kirghiz` = UShort(54)
    val `Tajiki` = UShort(55)
    val `Turkmen` = UShort(56)
    val `Mongolian (Mongolian script)` = UShort(57)
    val `Mongolian (Cyrillic script)` = UShort(58)
    val `Pashto` = UShort(59)
    val `Kurdish` = UShort(60)
    val `Kashmiri` = UShort(61)
    val `Sindhi` = UShort(62)
    val `Tibetan` = UShort(63)
    val `Nepali` = UShort(64)
    val `Sanskrit` = UShort(65)
    val `Marathi` = UShort(66)
    val `Bengali` = UShort(67)
    val `Assamese` = UShort(68)
    val `Gujarati` = UShort(69)
    val `Punjabi` = UShort(70)
    val `Oriya` = UShort(71)
    val `Malayalam` = UShort(72)
    val `Kannada` = UShort(73)
    val `Tamil` = UShort(74)
    val `Telugu` = UShort(75)
    val `Sinhalese` = UShort(76)
    val `Burmese` = UShort(77)
    val `Khmer` = UShort(78)
    val `Lao` = UShort(79)
    val `Vietnamese` = UShort(80)
    val `Indonesian` = UShort(81)
    val `Tagalong` = UShort(82)
    val `Malay (Roman script)` = UShort(83)
    val `Malay (Arabic script)` = UShort(84)
    val `Amharic` = UShort(85)
    val `Tigrinya` = UShort(86)
    val `Galla` = UShort(87)
    val `Somali` = UShort(88)
    val `Swahili` = UShort(89)
    val `Kinyarwanda/Ruanda` = UShort(90)
    val `Rundi` = UShort(91)
    val `Nyanja/Chewa` = UShort(92)
    val `Malagasy` = UShort(93)
    val `Esperanto` = UShort(94)
    val `Welsh` = UShort(128)
    val `Basque` = UShort(129)
    val `Catalan` = UShort(130)
    val `Latin` = UShort(131)
    val `Quenchua` = UShort(132)
    val `Guarani` = UShort(133)
    val `Aymara` = UShort(134)
    val `Tatar` = UShort(135)
    val `Uighur` = UShort(136)
    val `Dzongkha` = UShort(137)
    val `Javanese (Roman script)` = UShort(138)
    val `Sundanese (Roman script)` = UShort(139)
    val `Galician` = UShort(140)
    val `Afrikaans` = UShort(141)
    val `Breton` = UShort(142)
    val `Inuktitut` = UShort(14)
    val `Scottish Gaelic` = UShort(144)
    val `Manx Gaelic` = UShort(145)
    val `Irish Gaelic (with dot above)` = UShort(146)
    val `Tongan` = UShort(147)
    val `Greek (polytonic)` = UShort(148)
    val `Greenlandic` = UShort(149)
    val `Azerbaijani (Roman script)` = UShort(150)

  }

}
