// =====================================
// ==== Directory of the STAR files ====
// =====================================

typedef struct { int idx; char* name; int fileno, start, end, size, nblocks, blocksize, lsize; } DIRENTRY;

DIRENTRY dir[]=
{
  { .idx=0x00, .name="DIRECTORY   ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks= 163, .blocksize=  21, .lsize=0x00 },
  { .idx=0x01, .name="INSTANCE    ", .fileno=2, .start=0x03f800, .end=0x06a2c0, .size=0x2aad0, .nblocks=10925, .blocksize=  16, .lsize=0x00 },
  { .idx=0x02, .name="IROOT       ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x03, .name="ISYSTEM     ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x04, .name="INACTIVE    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x05, .name="FRAGMENT    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x06, .name="DICTIONARY  ", .fileno=1, .start=0x001000, .end=0x00c620, .size=0x0b630, .nblocks=2915, .blocksize=  16, .lsize=0x00 },
  { .idx=0x07, .name="IAPPLICATION", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x08, .name="ECOSYSTEM   ", .fileno=2, .start=0x06a2d0, .end=0x06a530, .size=0x00270, .nblocks=  41, .blocksize=  15, .lsize=0x00 },
  { .idx=0x09, .name="STIS        ", .fileno=2, .start=0x06a540, .end=0x06a7c0, .size=0x00290, .nblocks=  24, .blocksize=  27, .lsize=0x0a },
  { .idx=0x0a, .name="BOOT/KERNEL ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=8192, .blocksize=  16, .lsize=0x00 },
  { .idx=0x0b, .name="BOX         ", .fileno=2, .start=0x06a7d0, .end=0x06abc0, .size=0x00400, .nblocks=  64, .blocksize=  16, .lsize=0x08 },
  { .idx=0x0c, .name="STARPORT    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x0d, .name="BANK        ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x09 },
  { .idx=0x0e, .name="BANK-TRANS  ", .fileno=2, .start=0x06abd0, .end=0x06ac70, .size=0x000b0, .nblocks=   8, .blocksize=  19, .lsize=0x06 },
  { .idx=0x0f, .name="PERSONNEL   ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x10, .name="CREWMEMBER  ", .fileno=2, .start=0x06ac80, .end=0x06ad00, .size=0x00090, .nblocks=   7, .blocksize=  20, .lsize=0x18 },
  { .idx=0x11, .name="ASSIGN-CREW ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x18 },
  { .idx=0x12, .name="SHIP-CONFIG ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x13, .name="TRADE-DEPOT ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x14, .name="SHIP        ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x4d },
  { .idx=0x15, .name="TRADERS     ", .fileno=2, .start=0x06ad10, .end=0x06b5c0, .size=0x008c0, .nblocks=  44, .blocksize=  50, .lsize=0x09 },
  { .idx=0x16, .name="TIME        ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x04 },
  { .idx=0x17, .name="STARSYSTEM  ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x09 },
  { .idx=0x18, .name="STAR        ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x06 },
  { .idx=0x19, .name="VESSEL      ", .fileno=2, .start=0x06b5d0, .end=0x06ba80, .size=0x004c0, .nblocks=  33, .blocksize=  36, .lsize=0x0e },
  { .idx=0x1a, .name="ELEMENT     ", .fileno=2, .start=0x06ba90, .end=0x06bcc0, .size=0x00240, .nblocks=  25, .blocksize=  23, .lsize=0x0a },
  { .idx=0x1b, .name="MESSAGE     ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x11 },
  { .idx=0x1c, .name="ARTIFACT    ", .fileno=2, .start=0x06bcd0, .end=0x06c3d0, .size=0x00710, .nblocks=  56, .blocksize=  32, .lsize=0x0a },
  { .idx=0x1d, .name="PROJECTILE  ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=  16, .blocksize=   1, .lsize=0x1e },
  { .idx=0x1e, .name="COMPOUNDS   ", .fileno=2, .start=0x06c3e0, .end=0x06c480, .size=0x000b0, .nblocks=  23, .blocksize=   7, .lsize=0x00 },
  { .idx=0x1f, .name="CITY        ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x06 },
  { .idx=0x20, .name="PLANET      ", .fileno=2, .start=0x06c490, .end=0x06ca10, .size=0x00590, .nblocks=  61, .blocksize=  23, .lsize=0x0a },
  { .idx=0x21, .name="MARKET      ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x06 },
  { .idx=0x22, .name="OPERATIONS  ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x23, .name="NOTICE      ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x01 },
  { .idx=0x24, .name="EVALUATION  ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x19 },
  { .idx=0x25, .name="CULTURE     ", .fileno=2, .start=0x06ca20, .end=0x06d030, .size=0x00620, .nblocks=  98, .blocksize=  16, .lsize=0x00 },
  { .idx=0x26, .name="TOOLS       ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x27, .name="FX          ", .fileno=2, .start=0x06d040, .end=0x06d530, .size=0x00500, .nblocks=  80, .blocksize=  16, .lsize=0x00 },
  { .idx=0x28, .name="TRADE-MAP   ", .fileno=2, .start=0x06d540, .end=0x06d7f0, .size=0x002c0, .nblocks=   6, .blocksize= 116, .lsize=0x00 },
  { .idx=0x29, .name="RUIN        ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x07 },
  { .idx=0x2a, .name="TVEHICLE    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x07 },
  { .idx=0x2b, .name="COMM-MSG    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x03 },
  { .idx=0x2c, .name="PALETTES    ", .fileno=1, .start=0x00c630, .end=0x00c6e0, .size=0x000c0, .nblocks=  10, .blocksize=  18, .lsize=0x00 },
  { .idx=0x2d, .name="FLUX-NODE   ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x08 },
  { .idx=0x2e, .name="NEBULA      ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x07 },
  { .idx=0x2f, .name="CAPT-LOG    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x24 },
  { .idx=0x30, .name="STRING      ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x31, .name="ENDING      ", .fileno=2, .start=0x06d800, .end=0x06e560, .size=0x00d70, .nblocks= 215, .blocksize=  16, .lsize=0x00 },
  { .idx=0x32, .name="PHRASECONTRL", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x06 },
  { .idx=0x33, .name="SUBJECT     ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x34, .name="ORIGINATOR  ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=  25, .blocksize=   0, .lsize=0x13 },
  { .idx=0x35, .name="MESSAGE'    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x02 },
  { .idx=0x36, .name="BIGPAL      ", .fileno=4, .start=0x00c800, .end=0x00ca70, .size=0x00280, .nblocks=  40, .blocksize=  16, .lsize=0x00 },
  { .idx=0x37, .name="TEXT        ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x28 },
  { .idx=0x38, .name="SCROLL-TEXT ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x2c },
  { .idx=0x39, .name="ANALYZE-TEXT", .fileno=2, .start=0x06e570, .end=0x06e560, .size=0x00000, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x3a, .name="BUTTONS     ", .fileno=2, .start=0x06e570, .end=0x06e920, .size=0x003c0, .nblocks=  12, .blocksize=  73, .lsize=0x00 },
  { .idx=0x3b, .name="BLT-HEAD    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x12 },
  { .idx=0x3c, .name="EYE         ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x06 },
  { .idx=0x3d, .name="ENCOUNTER   ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x13 },
  { .idx=0x3e, .name="ICON1:1     ", .fileno=1, .start=0x00ca80, .end=0x00cea0, .size=0x00430, .nblocks=  59, .blocksize=  18, .lsize=0x00 },
  { .idx=0x3f, .name="ICON1:2     ", .fileno=1, .start=0x00ceb0, .end=0x00d2e0, .size=0x00440, .nblocks=  59, .blocksize=  18, .lsize=0x00 },
  { .idx=0x40, .name="ICON1:4     ", .fileno=1, .start=0x00d2f0, .end=0x00d710, .size=0x00430, .nblocks=  59, .blocksize=  18, .lsize=0x00 },
  { .idx=0x41, .name="ICON-NAME   ", .fileno=2, .start=0x06e930, .end=0x06ede0, .size=0x004c0, .nblocks=  44, .blocksize=  27, .lsize=0x00 },
  { .idx=0x42, .name="DEPART      ", .fileno=2, .start=0x06edf0, .end=0x06efb0, .size=0x001d0, .nblocks=  29, .blocksize=  16, .lsize=0x00 },
  { .idx=0x43, .name="REGIONS     ", .fileno=2, .start=0x06efc0, .end=0x06f060, .size=0x000b0, .nblocks=   6, .blocksize=  28, .lsize=0x02 },
  { .idx=0x44, .name="CREATURE    ", .fileno=2, .start=0x06f070, .end=0x06f640, .size=0x005e0, .nblocks=  43, .blocksize=  34, .lsize=0x0f },
  { .idx=0x45, .name="<unused>    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x46, .name="CHKFLIGHT-OV", .fileno=2, .start=0x06f650, .end=0x06fa30, .size=0x003f0, .nblocks=  63, .blocksize=  16, .lsize=0x00 },
  { .idx=0x47, .name="FRACT-OV    ", .fileno=2, .start=0x06fa40, .end=0x070c50, .size=0x01220, .nblocks= 290, .blocksize=  16, .lsize=0x00 },
  { .idx=0x48, .name="ICONP-OV    ", .fileno=2, .start=0x070c60, .end=0x071100, .size=0x004b0, .nblocks=  75, .blocksize=  16, .lsize=0x00 },
  { .idx=0x49, .name="SITE-OV     ", .fileno=2, .start=0x071110, .end=0x071520, .size=0x00420, .nblocks=  66, .blocksize=  16, .lsize=0x00 },
  { .idx=0x4a, .name="HYPERMSG-OV ", .fileno=2, .start=0x071530, .end=0x072430, .size=0x00f10, .nblocks= 241, .blocksize=  16, .lsize=0x00 },
  { .idx=0x4b, .name="GPOLY       ", .fileno=1, .start=0x00d720, .end=0x00d880, .size=0x00170, .nblocks=  89, .blocksize=   4, .lsize=0x00 },
  { .idx=0x4c, .name="FACET       ", .fileno=1, .start=0x00d890, .end=0x00d9a0, .size=0x00120, .nblocks=  72, .blocksize=   4, .lsize=0x00 },
  { .idx=0x4d, .name="VERTEX      ", .fileno=1, .start=0x00d9b0, .end=0x00db40, .size=0x001a0, .nblocks= 134, .blocksize=   3, .lsize=0x00 },
  { .idx=0x4e, .name="BLT-OV      ", .fileno=2, .start=0x072440, .end=0x0729b0, .size=0x00580, .nblocks=  88, .blocksize=  16, .lsize=0x00 },
  { .idx=0x4f, .name="MISC-OV     ", .fileno=2, .start=0x0729c0, .end=0x0730e0, .size=0x00730, .nblocks= 115, .blocksize=  16, .lsize=0x00 },
  { .idx=0x50, .name="BANK-OV     ", .fileno=2, .start=0x0730f0, .end=0x0736c0, .size=0x005e0, .nblocks=  94, .blocksize=  16, .lsize=0x00 },
  { .idx=0x51, .name="ASSCREW-OV  ", .fileno=2, .start=0x0736d0, .end=0x074170, .size=0x00ab0, .nblocks= 171, .blocksize=  16, .lsize=0x00 },
  { .idx=0x52, .name="PERSONNEL-OV", .fileno=2, .start=0x074180, .end=0x075300, .size=0x01190, .nblocks= 281, .blocksize=  16, .lsize=0x00 },
  { .idx=0x53, .name="SHIPGRPH-OV ", .fileno=2, .start=0x075310, .end=0x075bb0, .size=0x008b0, .nblocks= 139, .blocksize=  16, .lsize=0x00 },
  { .idx=0x54, .name="CONFIG-OV   ", .fileno=2, .start=0x075bc0, .end=0x076a30, .size=0x00e80, .nblocks= 232, .blocksize=  16, .lsize=0x00 },
  { .idx=0x55, .name="TDEPOT-OV   ", .fileno=2, .start=0x076a40, .end=0x0779c0, .size=0x00f90, .nblocks= 249, .blocksize=  16, .lsize=0x00 },
  { .idx=0x56, .name="EDIT-OV     ", .fileno=1, .start=0x00db50, .end=0x00e2e0, .size=0x007a0, .nblocks= 122, .blocksize=  16, .lsize=0x00 },
  { .idx=0x57, .name="PORTMENU-OV ", .fileno=2, .start=0x0779d0, .end=0x078240, .size=0x00880, .nblocks= 136, .blocksize=  16, .lsize=0x00 },
  { .idx=0x58, .name="VITA-OV     ", .fileno=2, .start=0x078250, .end=0x078630, .size=0x003f0, .nblocks=  63, .blocksize=  16, .lsize=0x00 },
  { .idx=0x59, .name="ECOSYSTEM   ", .fileno=2, .start=0x078640, .end=0x078870, .size=0x00240, .nblocks=  41, .blocksize=  14, .lsize=0x00 },
  { .idx=0x5a, .name="EYE-OV      ", .fileno=2, .start=0x078880, .end=0x079220, .size=0x009b0, .nblocks= 155, .blocksize=  16, .lsize=0x00 },
  { .idx=0x5b, .name="DESCRIBE    ", .fileno=2, .start=0x079230, .end=0x07a190, .size=0x00f70, .nblocks= 247, .blocksize=  16, .lsize=0x00 },
  { .idx=0x5c, .name="TV-OV       ", .fileno=2, .start=0x07a1a0, .end=0x07b020, .size=0x00e90, .nblocks= 233, .blocksize=  16, .lsize=0x00 },
  { .idx=0x5d, .name="COMM-OV     ", .fileno=2, .start=0x07b030, .end=0x07cda0, .size=0x01d80, .nblocks= 472, .blocksize=  16, .lsize=0x00 },
  { .idx=0x5e, .name="COMMSPEC-OV ", .fileno=2, .start=0x07cdb0, .end=0x07ddc0, .size=0x01020, .nblocks= 258, .blocksize=  16, .lsize=0x00 },
  { .idx=0x5f, .name="SEED-OV     ", .fileno=2, .start=0x07ddd0, .end=0x07e710, .size=0x00950, .nblocks= 149, .blocksize=  16, .lsize=0x00 },
  { .idx=0x60, .name="LISTICONS   ", .fileno=2, .start=0x07e720, .end=0x07e9c0, .size=0x002b0, .nblocks=  43, .blocksize=  16, .lsize=0x00 },
  { .idx=0x61, .name="MOVE-OV     ", .fileno=2, .start=0x07e9d0, .end=0x07f500, .size=0x00b40, .nblocks= 180, .blocksize=  16, .lsize=0x00 },
  { .idx=0x62, .name="ENGINEER    ", .fileno=2, .start=0x07f510, .end=0x07fdc0, .size=0x008c0, .nblocks= 140, .blocksize=  16, .lsize=0x00 },
  { .idx=0x63, .name="DOCTOR      ", .fileno=2, .start=0x07fdd0, .end=0x0802c0, .size=0x00500, .nblocks=  80, .blocksize=  16, .lsize=0x00 },
  { .idx=0x64, .name="ORBIT-OV    ", .fileno=2, .start=0x0802d0, .end=0x081d00, .size=0x01a40, .nblocks= 420, .blocksize=  16, .lsize=0x00 },
  { .idx=0x65, .name="CAPTAIN     ", .fileno=2, .start=0x081d10, .end=0x082e40, .size=0x01140, .nblocks= 276, .blocksize=  16, .lsize=0x00 },
  { .idx=0x66, .name="SCIENCE     ", .fileno=2, .start=0x082e50, .end=0x084410, .size=0x015d0, .nblocks= 349, .blocksize=  16, .lsize=0x00 },
  { .idx=0x67, .name="NAVIGATR    ", .fileno=2, .start=0x084420, .end=0x0847f0, .size=0x003e0, .nblocks=  62, .blocksize=  16, .lsize=0x00 },
  { .idx=0x68, .name="SHIPBUTTONS ", .fileno=2, .start=0x084800, .end=0x085170, .size=0x00980, .nblocks= 152, .blocksize=  16, .lsize=0x00 },
  { .idx=0x69, .name="*MAP-OV     ", .fileno=2, .start=0x085180, .end=0x086390, .size=0x01220, .nblocks= 290, .blocksize=  16, .lsize=0x00 },
  { .idx=0x6a, .name="HYPER-OV    ", .fileno=2, .start=0x0863a0, .end=0x087f70, .size=0x01be0, .nblocks= 446, .blocksize=  16, .lsize=0x00 },
  { .idx=0x6b, .name="ANALYZE-OV  ", .fileno=2, .start=0x087f80, .end=0x088880, .size=0x00910, .nblocks= 145, .blocksize=  16, .lsize=0x00 },
  { .idx=0x6c, .name="LAUNCH-OV   ", .fileno=2, .start=0x088890, .end=0x088d50, .size=0x004d0, .nblocks=  77, .blocksize=  16, .lsize=0x00 },
  { .idx=0x6d, .name="FLUX-EFFECT ", .fileno=2, .start=0x088d60, .end=0x088f80, .size=0x00230, .nblocks=  35, .blocksize=  16, .lsize=0x00 },
  { .idx=0x6e, .name="OP-OV       ", .fileno=2, .start=0x088f90, .end=0x089f60, .size=0x00fe0, .nblocks= 254, .blocksize=  16, .lsize=0x00 },
  { .idx=0x6f, .name="TVITEMS     ", .fileno=2, .start=0x089f70, .end=0x08aea0, .size=0x00f40, .nblocks= 244, .blocksize=  16, .lsize=0x00 },
  { .idx=0x70, .name="LSYSICON    ", .fileno=2, .start=0x08aeb0, .end=0x08aea0, .size=0x00000, .nblocks=   0, .blocksize=  16, .lsize=0x00 },
  { .idx=0x71, .name="MSYSICON    ", .fileno=2, .start=0x08aeb0, .end=0x08aea0, .size=0x00000, .nblocks=   0, .blocksize=  16, .lsize=0x00 },
  { .idx=0x72, .name="SSYSICON    ", .fileno=2, .start=0x08aeb0, .end=0x08aea0, .size=0x00000, .nblocks=   0, .blocksize=  16, .lsize=0x00 },
  { .idx=0x73, .name="BEHAV-OV    ", .fileno=2, .start=0x08aeb0, .end=0x08bf90, .size=0x010f0, .nblocks= 271, .blocksize=  16, .lsize=0x00 },
  { .idx=0x74, .name="CMAP        ", .fileno=2, .start=0x08bfa0, .end=0x08c230, .size=0x002a0, .nblocks=  10, .blocksize=  64, .lsize=0x00 },
  { .idx=0x75, .name="<UNUSED>    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x76, .name="HEAL-OV     ", .fileno=2, .start=0x08c240, .end=0x08c720, .size=0x004f0, .nblocks=  79, .blocksize=  16, .lsize=0x00 },
  { .idx=0x77, .name="REPAIR-OV   ", .fileno=2, .start=0x08c730, .end=0x08cda0, .size=0x00680, .nblocks= 104, .blocksize=  16, .lsize=0x00 },
  { .idx=0x78, .name="GAME-OV     ", .fileno=2, .start=0x08cdb0, .end=0x08cda0, .size=0x00000, .nblocks=   0, .blocksize=  16, .lsize=0x00 },
  { .idx=0x79, .name="PLSET-OV    ", .fileno=2, .start=0x08cdb0, .end=0x08d5b0, .size=0x00810, .nblocks= 129, .blocksize=  16, .lsize=0x00 },
  { .idx=0x7a, .name="MAPS-OV     ", .fileno=2, .start=0x08d5c0, .end=0x08de30, .size=0x00880, .nblocks= 136, .blocksize=  16, .lsize=0x00 },
  { .idx=0x7b, .name="VESBLT      ", .fileno=4, .start=0x00e400, .end=0x011e70, .size=0x03a80, .nblocks= 936, .blocksize=  16, .lsize=0x00 },
  { .idx=0x7c, .name="STORM-OV    ", .fileno=2, .start=0x08de40, .end=0x08e280, .size=0x00450, .nblocks=  69, .blocksize=  16, .lsize=0x00 },
  { .idx=0x7d, .name="HUM-PIC     ", .fileno=1, .start=0x011e80, .end=0x012b60, .size=0x00cf0, .nblocks= 206, .blocksize=  16, .lsize=0x00 },
  { .idx=0x7e, .name="VEL-PIC     ", .fileno=1, .start=0x012000, .end=0x0121f0, .size=0x00200, .nblocks=  32, .blocksize=  16, .lsize=0x00 },
  { .idx=0x7f, .name="THR-PIC     ", .fileno=1, .start=0x012200, .end=0x012380, .size=0x00190, .nblocks=  25, .blocksize=  16, .lsize=0x00 },
  { .idx=0x80, .name="ELO-PIC     ", .fileno=1, .start=0x012390, .end=0x012660, .size=0x002e0, .nblocks=  46, .blocksize=  16, .lsize=0x00 },
  { .idx=0x81, .name="AND-PIC     ", .fileno=1, .start=0x012670, .end=0x012890, .size=0x00230, .nblocks=  35, .blocksize=  16, .lsize=0x00 },
  { .idx=0x82, .name="DWENL-PIC   ", .fileno=1, .start=0x0128a0, .end=0x0129b0, .size=0x00120, .nblocks=  18, .blocksize=  16, .lsize=0x00 },
  { .idx=0x83, .name="GNUNK-PIC   ", .fileno=1, .start=0x0129c0, .end=0x012b50, .size=0x001a0, .nblocks=  26, .blocksize=  16, .lsize=0x00 },
  { .idx=0x84, .name="COMBAT-OV   ", .fileno=2, .start=0x08e290, .end=0x08fae0, .size=0x01860, .nblocks= 390, .blocksize=  16, .lsize=0x00 },
  { .idx=0x85, .name="DAMAGE-OV   ", .fileno=2, .start=0x08faf0, .end=0x090980, .size=0x00ea0, .nblocks= 234, .blocksize=  16, .lsize=0x00 },
  { .idx=0x86, .name="LAND-OV     ", .fileno=2, .start=0x090990, .end=0x090d50, .size=0x003d0, .nblocks=  61, .blocksize=  16, .lsize=0x00 },
  { .idx=0x87, .name="PSTATS      ", .fileno=2, .start=0x090d60, .end=0x090da0, .size=0x00050, .nblocks=   7, .blocksize=  11, .lsize=0x00 },
  { .idx=0x88, .name="SAVE        ", .fileno=4, .start=0x012c00, .end=0x03bc30, .size=0x29040, .nblocks=10500, .blocksize=  16, .lsize=0x00 },
  { .idx=0x89, .name="MUSIC       ", .fileno=1, .start=0x03bc40, .end=0x03c630, .size=0x00a00, .nblocks= 160, .blocksize=  16, .lsize=0x00 },
  { .idx=0x8a, .name="MODGAME     ", .fileno=1, .start=0x03c640, .end=0x03dea0, .size=0x01870, .nblocks= 391, .blocksize=  16, .lsize=0x00 },
  { .idx=0x8b, .name="STP-OV      ", .fileno=2, .start=0x090db0, .end=0x091290, .size=0x004f0, .nblocks=  79, .blocksize=  16, .lsize=0x00 },
  { .idx=0x8c, .name="<unused>    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=  16, .lsize=0x00 },
  { .idx=0x8d, .name="<unused>    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x8e, .name="COMBAUX     ", .fileno=2, .start=0x0912a0, .end=0x091540, .size=0x002b0, .nblocks=  43, .blocksize=  16, .lsize=0x00 },
  { .idx=0x8f, .name="POLYCON     ", .fileno=1, .start=0x03deb0, .end=0x03e7b0, .size=0x00910, .nblocks= 145, .blocksize=  16, .lsize=0x00 },
  { .idx=0x90, .name="<unused>    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x91, .name="<unused>    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x92, .name="IT-OV       ", .fileno=2, .start=0x091550, .end=0x091c20, .size=0x006e0, .nblocks= 110, .blocksize=  16, .lsize=0x00 },
  { .idx=0x93, .name="BLDLISTS    ", .fileno=2, .start=0x091c30, .end=0x092610, .size=0x009f0, .nblocks= 159, .blocksize=  16, .lsize=0x00 },
  { .idx=0x94, .name="BARTER      ", .fileno=2, .start=0x092620, .end=0x093bb0, .size=0x015a0, .nblocks= 346, .blocksize=  16, .lsize=0x00 },
  { .idx=0x95, .name="MARKET      ", .fileno=2, .start=0x093bc0, .end=0x094900, .size=0x00d50, .nblocks= 213, .blocksize=  16, .lsize=0x00 },
  { .idx=0x96, .name="TVCON-OV    ", .fileno=2, .start=0x094910, .end=0x095110, .size=0x00810, .nblocks= 129, .blocksize=  16, .lsize=0x00 },
  { .idx=0x97, .name="CLOUD-OV    ", .fileno=2, .start=0x095120, .end=0x0952c0, .size=0x001b0, .nblocks=  27, .blocksize=  16, .lsize=0x00 },
  { .idx=0x98, .name="JUMP        ", .fileno=2, .start=0x0952d0, .end=0x095af0, .size=0x00830, .nblocks= 131, .blocksize=  16, .lsize=0x00 },
  { .idx=0x99, .name="SHIPCON     ", .fileno=2, .start=0x095b00, .end=0x095cf0, .size=0x00200, .nblocks=  32, .blocksize=  16, .lsize=0x00 },
  { .idx=0x9a, .name="DRONE       ", .fileno=2, .start=0x095d00, .end=0x096670, .size=0x00980, .nblocks= 152, .blocksize=  16, .lsize=0x00 },
  { .idx=0x9b, .name="WEAPONS     ", .fileno=2, .start=0x096680, .end=0x096fc0, .size=0x00950, .nblocks= 149, .blocksize=  16, .lsize=0x00 },
  { .idx=0x9c, .name="<unused>    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x9d, .name="<unused>    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x9e, .name="<unused>    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0x9f, .name="<unused>    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0xa0, .name="<unused>    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0xa1, .name="<unused>    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0xa2, .name="<unused>    ", .fileno=0, .start=0x000000, .end=0x000000, .size=0x00010, .nblocks=   0, .blocksize=   0, .lsize=0x00 },
  { .idx=0xa3, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xa4, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xa5, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xa6, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xa7, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xa8, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xa9, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xaa, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xab, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xac, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xad, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xae, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xaf, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xb0, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xb1, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xb2, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xb3, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xb4, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xb5, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xb6, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xb7, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xb8, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xb9, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xba, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xbb, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xbc, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xbd, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xbe, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx=0xbf, .name="            ", .fileno=32, .start=0x020200, .end=0x020200, .size=0x00010, .nblocks=8224, .blocksize=  32, .lsize=0x20 },
  { .idx= -1, .name=NULL, .fileno=0, .start=0x0, .end=0x0, .size=0x0, .nblocks=0x0, .blocksize=0x0, .lsize=0x0 }};
