// =================================
// =========== Dictionary ==========
// =================================

typedef struct { int ov; unsigned short code, word; char immediate; unsigned char flags; char* name; } WORD;

WORD dictionary[]=
{
  { .ov = -1, .code = 0x0138, .word = 0x0138, .immediate=0, .flags=0x80, .name = "(!SET)" },
  { .ov = -1, .code = 0x0160, .word = 0x0160, .immediate=0, .flags=0x80, .name = "(!OLD)" },
  { .ov = -1, .code = 0x1d29, .word = 0x0188, .immediate=0, .flags=0x80, .name = "(TIME)" },
  { .ov = -1, .code = 0x01fa, .word = 0x01fa, .immediate=0, .flags=0x80, .name = "SET0/" },
  { .ov = -1, .code = 0x224c, .word = 0x0222, .immediate=0, .flags=0x80, .name = "(RESTORE)" },
  { .ov = -1, .code = 0x224c, .word = 0x0279, .immediate=0, .flags=0x80, .name = "AUTO-CACHE" },
  { .ov = -1, .code = 0x224c, .word = 0x02c2, .immediate=0, .flags=0x80, .name = "AUTO-LIMIT" },
  { .ov = -1, .code = 0x224c, .word = 0x02f6, .immediate=0, .flags=0x80, .name = "AUTO-SCREEN" },
  { .ov = -1, .code = 0x224c, .word = 0x0339, .immediate=0, .flags=0x80, .name = "COLD" },
  { .ov = -1, .code = 0x224c, .word = 0x0343, .immediate=0, .flags=0x00, .name = "W0343" },
  { .ov = -1, .code = 0x224c, .word = 0x03c3, .immediate=0, .flags=0x00, .name = "W03C3" },
  { .ov = -1, .code = 0x224c, .word = 0x03db, .immediate=0, .flags=0x80, .name = "SET-BUFFERS" },
  { .ov = -1, .code = 0x1792, .word = 0x040d, .immediate=0, .flags=0x80, .name = "SP0" },
  { .ov = -1, .code = 0x1792, .word = 0x0416, .immediate=0, .flags=0x80, .name = "R0" },
  { .ov = -1, .code = 0x1792, .word = 0x041f, .immediate=0, .flags=0x80, .name = "DP" },
  { .ov = -1, .code = 0x1792, .word = 0x042b, .immediate=0, .flags=0x80, .name = "FENCE" },
  { .ov = -1, .code = 0x1792, .word = 0x0438, .immediate=0, .flags=0x80, .name = "(INTO)" },
  { .ov = -1, .code = 0x1792, .word = 0x0447, .immediate=0, .flags=0x80, .name = "MSGFLAGS" },
  { .ov = -1, .code = 0x1792, .word = 0x0456, .immediate=0, .flags=0x80, .name = "VOC-LINK" },
  { .ov = -1, .code = 0x1792, .word = 0x0465, .immediate=0, .flags=0x80, .name = "USERSIZE" },
  { .ov = -1, .code = 0x1792, .word = 0x0474, .immediate=0, .flags=0x80, .name = "USERNEXT" },
  { .ov = -1, .code = 0x1792, .word = 0x047e, .immediate=0, .flags=0x80, .name = ">IN" },
  { .ov = -1, .code = 0x1792, .word = 0x0488, .immediate=0, .flags=0x80, .name = "TIB" },
  { .ov = -1, .code = 0x1792, .word = 0x0498, .immediate=0, .flags=0x80, .name = "VIDEOPORT" },
  { .ov = -1, .code = 0x1792, .word = 0x04a7, .immediate=0, .flags=0x80, .name = "VIDEOMEM" },
  { .ov = -1, .code = 0x1792, .word = 0x04b7, .immediate=0, .flags=0x80, .name = "CURSORLOC" },
  { .ov = -1, .code = 0x1792, .word = 0x04c1, .immediate=0, .flags=0x80, .name = "ROW" },
  { .ov = -1, .code = 0x1792, .word = 0x04cb, .immediate=0, .flags=0x80, .name = "COL" },
  { .ov = -1, .code = 0x1792, .word = 0x04d8, .immediate=0, .flags=0x80, .name = "ROWMIN" },
  { .ov = -1, .code = 0x1792, .word = 0x04e5, .immediate=0, .flags=0x80, .name = "COLMIN" },
  { .ov = -1, .code = 0x1792, .word = 0x04f2, .immediate=0, .flags=0x80, .name = "ROWMAX" },
  { .ov = -1, .code = 0x1792, .word = 0x04ff, .immediate=0, .flags=0x80, .name = "COLMAX" },
  { .ov = -1, .code = 0x1792, .word = 0x050f, .immediate=0, .flags=0x80, .name = "ATTRIBUTE" },
  { .ov = -1, .code = 0x1792, .word = 0x051d, .immediate=0, .flags=0x80, .name = "DOFFSET" },
  { .ov = -1, .code = 0x1792, .word = 0x052e, .immediate=0, .flags=0x80, .name = "SERIALPORT" },
  { .ov = -1, .code = 0x1792, .word = 0x0541, .immediate=0, .flags=0x80, .name = "PARALLELPORT" },
  { .ov = -1, .code = 0x1792, .word = 0x054c, .immediate=0, .flags=0x80, .name = "BASE" },
  { .ov = -1, .code = 0x1792, .word = 0x0556, .immediate=0, .flags=0x80, .name = "BLK" },
  { .ov = -1, .code = 0x1792, .word = 0x0560, .immediate=0, .flags=0x80, .name = "DPL" },
  { .ov = -1, .code = 0x1792, .word = 0x056a, .immediate=0, .flags=0x80, .name = "FLD" },
  { .ov = -1, .code = 0x1792, .word = 0x0574, .immediate=0, .flags=0x80, .name = "HLD" },
  { .ov = -1, .code = 0x1792, .word = 0x057d, .immediate=0, .flags=0x80, .name = "R#" },
  { .ov = -1, .code = 0x1792, .word = 0x0587, .immediate=0, .flags=0x80, .name = "SCR" },
  { .ov = -1, .code = 0x1792, .word = 0x0592, .immediate=0, .flags=0x80, .name = "SSCR" },
  { .ov = -1, .code = 0x1792, .word = 0x059e, .immediate=0, .flags=0x80, .name = "STATE" },
  { .ov = -1, .code = 0x1792, .word = 0x05ac, .immediate=0, .flags=0x80, .name = "CONTEXT_1" },
  { .ov = -1, .code = 0x1792, .word = 0x05b6, .immediate=0, .flags=0x80, .name = "CSP" },
  { .ov = -1, .code = 0x1792, .word = 0x05c4, .immediate=0, .flags=0x80, .name = "CURRENT" },
  { .ov = -1, .code = 0x1792, .word = 0x05d1, .immediate=0, .flags=0x80, .name = "LFALEN" },
  { .ov = -1, .code = 0x1792, .word = 0x05e1, .immediate=0, .flags=0x80, .name = "LOWERCASE" },
  { .ov = -1, .code = 0x1792, .word = 0x05f3, .immediate=0, .flags=0x80, .name = "SEARCHORDER" },
  { .ov = -1, .code = 0x1792, .word = 0x05ff, .immediate=0, .flags=0x80, .name = "WIDTH" },
  { .ov = -1, .code = 0x17b7, .word = 0x060b, .immediate=0, .flags=0x80, .name = "-FIND" },
  { .ov = -1, .code = 0x17b7, .word = 0x061b, .immediate=0, .flags=0x80, .name = "?TERMINAL" },
  { .ov = -1, .code = 0x17b7, .word = 0x0627, .immediate=0, .flags=0x80, .name = "ABORT" },
  { .ov = -1, .code = 0x17b7, .word = 0x0632, .immediate=0, .flags=0x80, .name = "BELL" },
  { .ov = -1, .code = 0x17b7, .word = 0x063b, .immediate=0, .flags=0x80, .name = "BS" },
  { .ov = -1, .code = 0x17b7, .word = 0x0644, .immediate=0, .flags=0x80, .name = "CR" },
  { .ov = -1, .code = 0x17b7, .word = 0x0651, .immediate=0, .flags=0x80, .name = "CREATE" },
  { .ov = -1, .code = 0x17b7, .word = 0x0662, .immediate=0, .flags=0x80, .name = "DISKERROR?" },
  { .ov = -1, .code = 0x17b7, .word = 0x066d, .immediate=0, .flags=0x80, .name = "EMIT" },
  { .ov = -1, .code = 0x17b7, .word = 0x067a, .immediate=0, .flags=0x80, .name = "EXPECT" },
  { .ov = -1, .code = 0x17b7, .word = 0x068a, .immediate=0, .flags=0x80, .name = "INTERPRET" },
  { .ov = -1, .code = 0x17b7, .word = 0x0697, .immediate=0, .flags=0x80, .name = "LINKS>" },
  { .ov = -1, .code = 0x17b7, .word = 0x06a2, .immediate=0, .flags=0x80, .name = "LOAD_1" },
  { .ov = -1, .code = 0x17b7, .word = 0x06ac, .immediate=0, .flags=0x80, .name = "KEY_1" },
  { .ov = -1, .code = 0x17b7, .word = 0x06b9, .immediate=0, .flags=0x80, .name = "NUMBER" },
  { .ov = -1, .code = 0x17b7, .word = 0x06c4, .immediate=0, .flags=0x80, .name = "PAGE" },
  { .ov = -1, .code = 0x17b7, .word = 0x06d3, .immediate=0, .flags=0x80, .name = "POSITION" },
  { .ov = -1, .code = 0x17b7, .word = 0x06dd, .immediate=0, .flags=0x80, .name = "R/W" },
  { .ov = -1, .code = 0x17b7, .word = 0x06e8, .immediate=0, .flags=0x80, .name = "TYPE" },
  { .ov = -1, .code = 0x17b7, .word = 0x06f4, .immediate=0, .flags=0x80, .name = "WHERE" },
  { .ov = -1, .code = 0x17b7, .word = 0x06ff, .immediate=0, .flags=0x80, .name = "WORD" },
  { .ov = -1, .code = 0x1d29, .word = 0x078c, .immediate=0, .flags=0x80, .name = "OPERATOR" },
  { .ov = -1, .code = 0x1ab5, .word = 0x081a, .immediate=1, .flags=0x80, .name = "FORTH" },
  { .ov = -1, .code = 0x224c, .word = 0x0833, .immediate=0, .flags=0x80, .name = "FREEZE" },
  { .ov = -1, .code = 0x224c, .word = 0x085d, .immediate=0, .flags=0x80, .name = "BYE_1" },
  { .ov = -1, .code = 0x224c, .word = 0x0872, .immediate=0, .flags=0x80, .name = "CHANGE" },
  { .ov = -1, .code = 0x224c, .word = 0x08dd, .immediate=0, .flags=0x80, .name = "(SETUP)" },
  { .ov = -1, .code = 0x224c, .word = 0x0939, .immediate=0, .flags=0x00, .name = "W0939" },
  { .ov = -1, .code = 0x2214, .word = 0x099a, .immediate=0, .flags=0x80, .name = "BL" },
  { .ov = -1, .code = 0x2214, .word = 0x09a4, .immediate=0, .flags=0x80, .name = "C/L" },
  { .ov = -1, .code = 0x2214, .word = 0x09b5, .immediate=0, .flags=0x80, .name = "INIT-FORTH" },
  { .ov = -1, .code = 0x2214, .word = 0x09c5, .immediate=0, .flags=0x80, .name = "INIT-USER" },
  { .ov = -1, .code = 0x2214, .word = 0x09d6, .immediate=0, .flags=0x80, .name = "INITIAL-DP" },
  { .ov = -1, .code = 0x2214, .word = 0x09e2, .immediate=0, .flags=0x80, .name = "LIMIT" },
  { .ov = -1, .code = 0x1d29, .word = 0x09ef, .immediate=0, .flags=0x80, .name = "#CACHE" },
  { .ov = -1, .code = 0x1d29, .word = 0x09fe, .immediate=0, .flags=0x80, .name = "#BUFFERS" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a0b, .immediate=0, .flags=0x80, .name = "#SPACE" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a1b, .immediate=0, .flags=0x80, .name = "'RESTORE+" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a29, .immediate=0, .flags=0x80, .name = "'SETUP+" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a36, .immediate=0, .flags=0x80, .name = "@,0*1;" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a43, .immediate=0, .flags=0x80, .name = ">BREAK" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a53, .immediate=0, .flags=0x80, .name = "BOOT-HOOK" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a63, .immediate=0, .flags=0x80, .name = "BOOT-LOAD" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a76, .immediate=0, .flags=0x80, .name = "BUFFER-BEGIN" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a88, .immediate=0, .flags=0x80, .name = "BUFFER-HEAD" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a9a, .immediate=0, .flags=0x80, .name = "CACHE-BEGIN" },
  { .ov = -1, .code = 0x1d29, .word = 0x0aab, .immediate=0, .flags=0x80, .name = "CACHE-HEAD" },
  { .ov = -1, .code = 0x224c, .word = 0x0ab8, .immediate=0, .flags=0x80, .name = "'FORTH" },
  { .ov = -1, .code = 0x0ad1, .word = 0x0ad1, .immediate=0, .flags=0x80, .name = "ME" },
  { .ov = -1, .code = 0x224c, .word = 0x0ad9, .immediate=0, .flags=0x00, .name = "W0AD9" },
  { .ov = -1, .code = 0x224c, .word = 0x0b12, .immediate=0, .flags=0x00, .name = "W0B12" },
  { .ov = -1, .code = 0x224c, .word = 0x0b30, .immediate=0, .flags=0x00, .name = "W0B30" },
  { .ov = -1, .code = 0x224c, .word = 0x0b5d, .immediate=0, .flags=0x00, .name = "W0B5D" },
  { .ov = -1, .code = 0x224c, .word = 0x0b7c, .immediate=0, .flags=0x80, .name = "?ENOUGH" },
  { .ov = -1, .code = 0x0bb0, .word = 0x0bb0, .immediate=0, .flags=0x80, .name = "@" },
  { .ov = -1, .code = 0x0bbf, .word = 0x0bbf, .immediate=0, .flags=0x80, .name = "@L" },
  { .ov = -1, .code = 0x0be1, .word = 0x0be1, .immediate=0, .flags=0x80, .name = "!" },
  { .ov = -1, .code = 0x0bf1, .word = 0x0bf1, .immediate=0, .flags=0x80, .name = "!L" },
  { .ov = -1, .code = 0x0c17, .word = 0x0c17, .immediate=0, .flags=0x80, .name = "(CS?)" },
  { .ov = -1, .code = 0x0c24, .word = 0x0c24, .immediate=0, .flags=0x80, .name = "2!_1" },
  { .ov = -1, .code = 0x0c3a, .word = 0x0c3a, .immediate=0, .flags=0x80, .name = "2@" },
  { .ov = -1, .code = 0x224c, .word = 0x0c53, .immediate=0, .flags=0x80, .name = "BLANK" },
  { .ov = -1, .code = 0x0c60, .word = 0x0c60, .immediate=0, .flags=0x80, .name = "C!_1" },
  { .ov = -1, .code = 0x0c71, .word = 0x0c71, .immediate=0, .flags=0x80, .name = "C!L" },
  { .ov = -1, .code = 0x0c94, .word = 0x0c94, .immediate=0, .flags=0x80, .name = "C@" },
  { .ov = -1, .code = 0x0ca7, .word = 0x0ca7, .immediate=0, .flags=0x80, .name = "C@L" },
  { .ov = -1, .code = 0x224c, .word = 0x0ccf, .immediate=0, .flags=0x80, .name = "COUNT" },
  { .ov = -1, .code = 0x0ce4, .word = 0x0ce4, .immediate=0, .flags=0x80, .name = "CMOVE>" },
  { .ov = -1, .code = 0x0d10, .word = 0x0d10, .immediate=0, .flags=0x80, .name = "CMOVE_1" },
  { .ov = -1, .code = 0x0d35, .word = 0x0d35, .immediate=0, .flags=0x80, .name = "FILL_1" },
  { .ov = -1, .code = 0x0d56, .word = 0x0d56, .immediate=0, .flags=0x80, .name = "P!" },
  { .ov = -1, .code = 0x0d65, .word = 0x0d65, .immediate=0, .flags=0x80, .name = "P@" },
  { .ov = -1, .code = 0x0d7c, .word = 0x0d7c, .immediate=0, .flags=0x80, .name = "SEG>ADDR" },
  { .ov = -1, .code = 0x0d9c, .word = 0x0d9c, .immediate=0, .flags=0x80, .name = "ADDR>SEG" },
  { .ov = -1, .code = 0x0db6, .word = 0x0db6, .immediate=0, .flags=0x80, .name = ">R" },
  { .ov = -1, .code = 0x0dca, .word = 0x0dca, .immediate=0, .flags=0x80, .name = "?DUP" },
  { .ov = -1, .code = 0x0de0, .word = 0x0de0, .immediate=0, .flags=0x80, .name = "2DROP" },
  { .ov = -1, .code = 0x0df2, .word = 0x0df2, .immediate=0, .flags=0x80, .name = "2DUP" },
  { .ov = -1, .code = 0x0e08, .word = 0x0e08, .immediate=0, .flags=0x80, .name = "2SWAP" },
  { .ov = -1, .code = 0x224c, .word = 0x0e1f, .immediate=0, .flags=0x80, .name = "DEPTH" },
  { .ov = -1, .code = 0x0e34, .word = 0x0e34, .immediate=0, .flags=0x80, .name = "DROP" },
  { .ov = -1, .code = 0x0e43, .word = 0x0e43, .immediate=0, .flags=0x80, .name = "DUP" },
  { .ov = -1, .code = 0x0e52, .word = 0x0e52, .immediate=0, .flags=0x80, .name = "I" },
  { .ov = -1, .code = 0x0e62, .word = 0x0e62, .immediate=0, .flags=0x80, .name = "I'" },
  { .ov = -1, .code = 0x0e70, .word = 0x0e70, .immediate=0, .flags=0x80, .name = "J" },
  { .ov = -1, .code = 0x0e81, .word = 0x0e81, .immediate=0, .flags=0x80, .name = "OVER" },
  { .ov = -1, .code = 0x0e92, .word = 0x0e92, .immediate=0, .flags=0x80, .name = "R>" },
  { .ov = -1, .code = 0x0ea4, .word = 0x0ea4, .immediate=0, .flags=0x80, .name = "R@" },
  { .ov = -1, .code = 0x0eb5, .word = 0x0eb5, .immediate=0, .flags=0x80, .name = "ROT" },
  { .ov = -1, .code = 0x0ec8, .word = 0x0ec8, .immediate=0, .flags=0x80, .name = "RP!" },
  { .ov = -1, .code = 0x0ed8, .word = 0x0ed8, .immediate=0, .flags=0x80, .name = "RP@" },
  { .ov = -1, .code = 0x224c, .word = 0x0ee5, .immediate=0, .flags=0x80, .name = "S0" },
  { .ov = -1, .code = 0x0ef4, .word = 0x0ef4, .immediate=0, .flags=0x80, .name = "SWAP" },
  { .ov = -1, .code = 0x0f05, .word = 0x0f05, .immediate=0, .flags=0x80, .name = "SP!" },
  { .ov = -1, .code = 0x0f14, .word = 0x0f14, .immediate=0, .flags=0x80, .name = "SP@" },
  { .ov = -1, .code = 0x0f22, .word = 0x0f22, .immediate=0, .flags=0x80, .name = "0" },
  { .ov = -1, .code = 0x0f30, .word = 0x0f30, .immediate=0, .flags=0x80, .name = "1" },
  { .ov = -1, .code = 0x0f3f, .word = 0x0f3f, .immediate=0, .flags=0x80, .name = "2" },
  { .ov = -1, .code = 0x0f4e, .word = 0x0f4e, .immediate=0, .flags=0x80, .name = "/" },
  { .ov = -1, .code = 0x0f62, .word = 0x0f62, .immediate=0, .flags=0x80, .name = "/MOD" },
  { .ov = -1, .code = 0x0f74, .word = 0x0f74, .immediate=0, .flags=0x80, .name = "+" },
  { .ov = -1, .code = 0x0f85, .word = 0x0f85, .immediate=0, .flags=0x80, .name = "+!" },
  { .ov = -1, .code = 0x0f94, .word = 0x0f94, .immediate=0, .flags=0x80, .name = "-" },
  { .ov = -1, .code = 0x224c, .word = 0x0fa5, .immediate=0, .flags=0x80, .name = "+-" },
  { .ov = -1, .code = 0x0fb5, .word = 0x0fb5, .immediate=0, .flags=0x80, .name = "*" },
  { .ov = -1, .code = 0x224c, .word = 0x0fc6, .immediate=0, .flags=0x80, .name = "*/" },
  { .ov = -1, .code = 0x224c, .word = 0x0fd8, .immediate=0, .flags=0x80, .name = "*/MOD" },
  { .ov = -1, .code = 0x0fe9, .word = 0x0fe9, .immediate=0, .flags=0x80, .name = "1+" },
  { .ov = -1, .code = 0x0ff8, .word = 0x0ff8, .immediate=0, .flags=0x80, .name = "1-" },
  { .ov = -1, .code = 0x1007, .word = 0x1007, .immediate=0, .flags=0x80, .name = "2*" },
  { .ov = -1, .code = 0x1017, .word = 0x1017, .immediate=0, .flags=0x80, .name = "2+" },
  { .ov = -1, .code = 0x1027, .word = 0x1027, .immediate=0, .flags=0x80, .name = "2-" },
  { .ov = -1, .code = 0x1037, .word = 0x1037, .immediate=0, .flags=0x80, .name = "2/" },
  { .ov = -1, .code = 0x1047, .word = 0x1047, .immediate=0, .flags=0x80, .name = "4*" },
  { .ov = -1, .code = 0x224c, .word = 0x105a, .immediate=0, .flags=0x80, .name = "ABS" },
  { .ov = -1, .code = 0x1067, .word = 0x1067, .immediate=0, .flags=0x80, .name = "D+" },
  { .ov = -1, .code = 0x224c, .word = 0x107e, .immediate=0, .flags=0x80, .name = "D+-" },
  { .ov = -1, .code = 0x224c, .word = 0x1094, .immediate=0, .flags=0x80, .name = "DECIMAL" },
  { .ov = -1, .code = 0x224c, .word = 0x10a7, .immediate=0, .flags=0x80, .name = "DABS" },
  { .ov = -1, .code = 0x10b9, .word = 0x10b9, .immediate=0, .flags=0x80, .name = "DNEGATE" },
  { .ov = -1, .code = 0x224c, .word = 0x10cf, .immediate=0, .flags=0x80, .name = "M*" },
  { .ov = -1, .code = 0x224c, .word = 0x10eb, .immediate=0, .flags=0x80, .name = "M*/" },
  { .ov = -1, .code = 0x224c, .word = 0x1136, .immediate=0, .flags=0x80, .name = "M+" },
  { .ov = -1, .code = 0x224c, .word = 0x1143, .immediate=0, .flags=0x80, .name = "M/" },
  { .ov = -1, .code = 0x224c, .word = 0x116f, .immediate=0, .flags=0x80, .name = "M/MOD" },
  { .ov = -1, .code = 0x224c, .word = 0x118b, .immediate=0, .flags=0x80, .name = "MAX" },
  { .ov = -1, .code = 0x224c, .word = 0x11a1, .immediate=0, .flags=0x80, .name = "MOD" },
  { .ov = -1, .code = 0x224c, .word = 0x11af, .immediate=0, .flags=0x80, .name = "MIN" },
  { .ov = -1, .code = 0x11c8, .word = 0x11c8, .immediate=0, .flags=0x80, .name = "NEGATE" },
  { .ov = -1, .code = 0x11d8, .word = 0x11d8, .immediate=0, .flags=0x80, .name = "U*" },
  { .ov = -1, .code = 0x11ed, .word = 0x11ed, .immediate=0, .flags=0x80, .name = "U/MOD" },
  { .ov = -1, .code = 0x224c, .word = 0x1202, .immediate=0, .flags=0x80, .name = "UMAX" },
  { .ov = -1, .code = 0x224c, .word = 0x1219, .immediate=0, .flags=0x80, .name = "UMIN" },
  { .ov = -1, .code = 0x122f, .word = 0x122f, .immediate=0, .flags=0x80, .name = ">" },
  { .ov = -1, .code = 0x1248, .word = 0x1248, .immediate=0, .flags=0x80, .name = "<" },
  { .ov = -1, .code = 0x1261, .word = 0x1261, .immediate=0, .flags=0x80, .name = "=" },
  { .ov = -1, .code = 0x127a, .word = 0x127a, .immediate=0, .flags=0x80, .name = "0<" },
  { .ov = -1, .code = 0x128b, .word = 0x128b, .immediate=0, .flags=0x80, .name = "0=" },
  { .ov = -1, .code = 0x12a1, .word = 0x12a1, .immediate=0, .flags=0x80, .name = "0>" },
  { .ov = -1, .code = 0x224c, .word = 0x12b4, .immediate=0, .flags=0x80, .name = "D<" },
  { .ov = -1, .code = 0x12e1, .word = 0x12e1, .immediate=0, .flags=0x80, .name = "U<" },
  { .ov = -1, .code = 0x12f7, .word = 0x12f7, .immediate=0, .flags=0x80, .name = "AND" },
  { .ov = -1, .code = 0x1309, .word = 0x1309, .immediate=0, .flags=0x80, .name = "NOT" },
  { .ov = -1, .code = 0x224c, .word = 0x1320, .immediate=0, .flags=0x80, .name = "OFF_1" },
  { .ov = -1, .code = 0x224c, .word = 0x132f, .immediate=0, .flags=0x80, .name = "ON_3" },
  { .ov = -1, .code = 0x1340, .word = 0x1340, .immediate=0, .flags=0x80, .name = "OR" },
  { .ov = -1, .code = 0x1355, .word = 0x1355, .immediate=0, .flags=0x80, .name = "TOGGLE" },
  { .ov = -1, .code = 0x1366, .word = 0x1366, .immediate=0, .flags=0x80, .name = "XOR" },
  { .ov = -1, .code = 0x224c, .word = 0x1376, .immediate=0, .flags=0x80, .name = "#" },
  { .ov = -1, .code = 0x224c, .word = 0x13a1, .immediate=0, .flags=0x80, .name = "#>" },
  { .ov = -1, .code = 0x224c, .word = 0x13b6, .immediate=0, .flags=0x80, .name = "#S" },
  { .ov = -1, .code = 0x224c, .word = 0x13d1, .immediate=0, .flags=0x80, .name = "(NUMBER)" },
  { .ov = -1, .code = 0x143a, .word = 0x143a, .immediate=0, .flags=0x80, .name = ">UPPERCASE" },
  { .ov = -1, .code = 0x224c, .word = 0x145f, .immediate=0, .flags=0x80, .name = "<#" },
  { .ov = -1, .code = 0x224c, .word = 0x1473, .immediate=0, .flags=0x80, .name = "CONVERT" },
  { .ov = -1, .code = 0x14bd, .word = 0x14bd, .immediate=0, .flags=0x80, .name = "DIGIT" },
  { .ov = -1, .code = 0x224c, .word = 0x14ef, .immediate=0, .flags=0x80, .name = "HOLD" },
  { .ov = -1, .code = 0x1508, .word = 0x1508, .immediate=0, .flags=0x80, .name = "S->D" },
  { .ov = -1, .code = 0x224c, .word = 0x151c, .immediate=0, .flags=0x80, .name = "SIGN" },
  { .ov = -1, .code = 0x1536, .word = 0x1536, .immediate=0, .flags=0x80, .name = "(>CODE)" },
  { .ov = -1, .code = 0x1548, .word = 0x1548, .immediate=0, .flags=0x80, .name = "(;VIA)" },
  { .ov = -1, .code = 0x155e, .word = 0x155e, .immediate=0, .flags=0x80, .name = "(+LOOP)" },
  { .ov = -1, .code = 0x1593, .word = 0x1593, .immediate=0, .flags=0x80, .name = "(/LOOP)" },
  { .ov = -1, .code = 0x15ba, .word = 0x15ba, .immediate=0, .flags=0x80, .name = "(DO)" },
  { .ov = -1, .code = 0x15d2, .word = 0x15d2, .immediate=0, .flags=0x80, .name = "(LOOP)" },
  { .ov = -1, .code = 0x15fc, .word = 0x15fc, .immediate=0, .flags=0x80, .name = "0BRANCH" },
  { .ov = -1, .code = 0x1618, .word = 0x1618, .immediate=0, .flags=0x80, .name = "2LIT" },
  { .ov = -1, .code = 0x224c, .word = 0x162e, .immediate=0, .flags=0x80, .name = "ABORT-IT" },
  { .ov = -1, .code = 0x1662, .word = 0x1662, .immediate=0, .flags=0x80, .name = "BRANCH" },
  { .ov = -1, .code = 0x1675, .word = 0x1675, .immediate=0, .flags=0x80, .name = "CFAEXEC" },
  { .ov = -1, .code = 0x1684, .word = 0x1684, .immediate=0, .flags=0x80, .name = "EXECUTE" },
  { .ov = -1, .code = 0x1692, .word = 0x1692, .immediate=0, .flags=0x80, .name = "EXIT" },
  { .ov = -1, .code = 0x16a3, .word = 0x16a3, .immediate=0, .flags=0x80, .name = "GO" },
  { .ov = -1, .code = 0x1d29, .word = 0x16b4, .immediate=0, .flags=0x80, .name = "REGISTERS" },
  { .ov = -1, .code = 0x16d9, .word = 0x16d9, .immediate=0, .flags=0x80, .name = "INTERRUPT" },
  { .ov = -1, .code = 0x174c, .word = 0x174c, .immediate=0, .flags=0x80, .name = "LEAVE" },
  { .ov = -1, .code = 0x175f, .word = 0x175f, .immediate=0, .flags=0x80, .name = "LIT" },
  { .ov = -1, .code = 0x1772, .word = 0x1772, .immediate=0, .flags=0x80, .name = "SYSCALL" },
  { .ov = -1, .code = 0x224c, .word = 0x178a, .immediate=0, .flags=0x80, .name = "USER" },
  { .ov = -1, .code = 0x224c, .word = 0x17af, .immediate=0, .flags=0x80, .name = "USEREXECUTOR" },
  { .ov = -1, .code = 0x224c, .word = 0x17cb, .immediate=0, .flags=0x80, .name = "+FIND" },
  { .ov = -1, .code = 0x224c, .word = 0x17e1, .immediate=0, .flags=0x80, .name = "(-FIND)" },
  { .ov = -1, .code = 0x1818, .word = 0x1818, .immediate=0, .flags=0x80, .name = "(FIND)" },
  { .ov = -1, .code = 0x224c, .word = 0x186e, .immediate=0, .flags=0x80, .name = "(FORGET)" },
  { .ov = -1, .code = 0x224c, .word = 0x191a, .immediate=0, .flags=0x80, .name = "(LINKS)" },
  { .ov = -1, .code = 0x224c, .word = 0x193f, .immediate=0, .flags=0x80, .name = "<NAME>" },
  { .ov = -1, .code = 0x224c, .word = 0x1961, .immediate=0, .flags=0x80, .name = "?FIND" },
  { .ov = -1, .code = 0x224c, .word = 0x1982, .immediate=0, .flags=0x80, .name = "?[PTR]" },
  { .ov = -1, .code = 0x224c, .word = 0x199c, .immediate=0, .flags=0x80, .name = "DEFINITIONS" },
  { .ov = -1, .code = 0x224c, .word = 0x19b0, .immediate=0, .flags=0x80, .name = "EMPTY" },
  { .ov = -1, .code = 0x224c, .word = 0x19d3, .immediate=0, .flags=0x80, .name = "FIND" },
  { .ov = -1, .code = 0x224c, .word = 0x19f2, .immediate=0, .flags=0x80, .name = "FORGET" },
  { .ov = -1, .code = 0x224c, .word = 0x1a5c, .immediate=0, .flags=0x00, .name = "W1A5C" },
  { .ov = -1, .code = 0x224c, .word = 0x1a66, .immediate=0, .flags=0x00, .name = "W1A66" },
  { .ov = -1, .code = 0x224c, .word = 0x1a6e, .immediate=0, .flags=0x00, .name = "W1A6E" },
  { .ov = -1, .code = 0x224c, .word = 0x1a89, .immediate=0, .flags=0x80, .name = "VOCABULARY" },
  { .ov = -1, .code = 0x1ac0, .word = 0x1ac0, .immediate=0, .flags=0x00, .name = "W1AC0" },
  { .ov = -1, .code = 0x224c, .word = 0x1ae0, .immediate=0, .flags=0x80, .name = "WITHIN?" },
  { .ov = -1, .code = 0x224c, .word = 0x1b0c, .immediate=0, .flags=0x80, .name = "[-FIND]" },
  { .ov = -1, .code = 0x224c, .word = 0x1b35, .immediate=0, .flags=0x80, .name = "[-FINDS]" },
  { .ov = -1, .code = 0x224c, .word = 0x1b7d, .immediate=1, .flags=0x80, .name = "'_1" },
  { .ov = -1, .code = 0x224c, .word = 0x1b8f, .immediate=0, .flags=0x80, .name = "'STREAM" },
  { .ov = -1, .code = 0x224c, .word = 0x1bb1, .immediate=1, .flags=0x80, .name = "(" },
  { .ov = -1, .code = 0x224c, .word = 0x1bde, .immediate=0, .flags=0x80, .name = "(.\")" },
  { .ov = -1, .code = 0x224c, .word = 0x1bfc, .immediate=0, .flags=0x80, .name = "(;CODE)" },
  { .ov = -1, .code = 0x224c, .word = 0x1c15, .immediate=0, .flags=0x80, .name = "(ABORT\")" },
  { .ov = -1, .code = 0x224c, .word = 0x1c45, .immediate=0, .flags=0x80, .name = "(ABORT)" },
  { .ov = -1, .code = 0x224c, .word = 0x1c56, .immediate=1, .flags=0x80, .name = ".\"" },
  { .ov = -1, .code = 0x224c, .word = 0x1cbb, .immediate=0, .flags=0x80, .name = "(CREATE)" },
  { .ov = -1, .code = 0x224c, .word = 0x1d3e, .immediate=0, .flags=0x80, .name = "(EXPECT)" },
  { .ov = -1, .code = 0x224c, .word = 0x1dd8, .immediate=0, .flags=0x80, .name = "(INTERPRET)" },
  { .ov = -1, .code = 0x224c, .word = 0x1e23, .immediate=0, .flags=0x80, .name = "(LOAD)" },
  { .ov = -1, .code = 0x224c, .word = 0x1e68, .immediate=0, .flags=0x80, .name = "(WHERE)" },
  { .ov = -1, .code = 0x224c, .word = 0x1f06, .immediate=0, .flags=0x80, .name = "(WORD)" },
  { .ov = -1, .code = 0x224c, .word = 0x1f7d, .immediate=1, .flags=0x80, .name = "+LOOP" },
  { .ov = -1, .code = 0x224c, .word = 0x1f95, .immediate=0, .flags=0x80, .name = "," },
  { .ov = -1, .code = 0x224c, .word = 0x1fad, .immediate=1, .flags=0x80, .name = "/LOOP" },
  { .ov = -1, .code = 0x224c, .word = 0x1fc5, .immediate=1, .flags=0x80, .name = ";" },
  { .ov = -1, .code = 0x224c, .word = 0x1fdb, .immediate=0, .flags=0x80, .name = "?COMP" },
  { .ov = -1, .code = 0x224c, .word = 0x1ff4, .immediate=0, .flags=0x00, .name = "W1FF4" },
  { .ov = -1, .code = 0x224c, .word = 0x2031, .immediate=0, .flags=0x80, .name = "?CSP" },
  { .ov = -1, .code = 0x224c, .word = 0x2057, .immediate=0, .flags=0x00, .name = "W2057" },
  { .ov = -1, .code = 0x224c, .word = 0x2084, .immediate=0, .flags=0x80, .name = "?LOADING" },
  { .ov = -1, .code = 0x224c, .word = 0x20a6, .immediate=0, .flags=0x80, .name = "?PAIRS" },
  { .ov = -1, .code = 0x224c, .word = 0x20c6, .immediate=0, .flags=0x00, .name = "W20C6" },
  { .ov = -1, .code = 0x224c, .word = 0x2126, .immediate=1, .flags=0x80, .name = "ABORT\"" },
  { .ov = -1, .code = 0x224c, .word = 0x2174, .immediate=1, .flags=0x80, .name = "AGAIN" },
  { .ov = -1, .code = 0x224c, .word = 0x218e, .immediate=0, .flags=0x80, .name = "ALLOT" },
  { .ov = -1, .code = 0x224c, .word = 0x21a2, .immediate=1, .flags=0x80, .name = "BEGIN" },
  { .ov = -1, .code = 0x224c, .word = 0x21b1, .immediate=0, .flags=0x80, .name = "C," },
  { .ov = -1, .code = 0x224c, .word = 0x21c3, .immediate=0, .flags=0x80, .name = "CFA" },
  { .ov = -1, .code = 0x21c9, .word = 0x21c9, .immediate=0, .flags=0x00, .name = "W21C9" },
  { .ov = -1, .code = 0x224c, .word = 0x21f1, .immediate=0, .flags=0x80, .name = "COMPILE" },
  { .ov = -1, .code = 0x224c, .word = 0x220e, .immediate=0, .flags=0x80, .name = "CONSTANT" },
  { .ov = -1, .code = 0x224c, .word = 0x2224, .immediate=1, .flags=0x80, .name = "DO" },
  { .ov = -1, .code = 0x224c, .word = 0x2236, .immediate=0, .flags=0x80, .name = ":" },
  { .ov = -1, .code = 0x224c, .word = 0x2264, .immediate=1, .flags=0x80, .name = "DOES>" },
  { .ov = -1, .code = 0x224c, .word = 0x2287, .immediate=1, .flags=0x80, .name = "ELSE" },
  { .ov = -1, .code = 0x22ab, .word = 0x22ab, .immediate=0, .flags=0x80, .name = "ENCLOSE" },
  { .ov = -1, .code = 0x224c, .word = 0x22ef, .immediate=0, .flags=0x80, .name = "HERE" },
  { .ov = -1, .code = 0x224c, .word = 0x22fd, .immediate=0, .flags=0x80, .name = "HEX" },
  { .ov = -1, .code = 0x224c, .word = 0x230e, .immediate=1, .flags=0x80, .name = "IF" },
  { .ov = -1, .code = 0x224c, .word = 0x232a, .immediate=0, .flags=0x80, .name = "IMMEDIATE" },
  { .ov = -1, .code = 0x224c, .word = 0x233f, .immediate=0, .flags=0x80, .name = "LATEST" },
  { .ov = -1, .code = 0x224c, .word = 0x2355, .immediate=0, .flags=0x80, .name = "LFA" },
  { .ov = -1, .code = 0x224c, .word = 0x2367, .immediate=1, .flags=0x80, .name = "LITERAL" },
  { .ov = -1, .code = 0x224c, .word = 0x2386, .immediate=1, .flags=0x80, .name = "LOOP" },
  { .ov = -1, .code = 0x224c, .word = 0x23a5, .immediate=1, .flags=0x80, .name = "2LITERAL" },
  { .ov = -1, .code = 0x224c, .word = 0x23c7, .immediate=0, .flags=0x80, .name = "NFA" },
  { .ov = -1, .code = 0x224c, .word = 0x23dd, .immediate=0, .flags=0x80, .name = "PAD" },
  { .ov = -1, .code = 0x224c, .word = 0x23ef, .immediate=0, .flags=0x80, .name = "PFA" },
  { .ov = -1, .code = 0x224c, .word = 0x2405, .immediate=0, .flags=0x80, .name = "QUERY" },
  { .ov = -1, .code = 0x224c, .word = 0x2420, .immediate=0, .flags=0x80, .name = "QUIT" },
  { .ov = -1, .code = 0x224c, .word = 0x2467, .immediate=1, .flags=0x80, .name = "REPEAT" },
  { .ov = -1, .code = 0x224c, .word = 0x2482, .immediate=0, .flags=0x80, .name = "SMUDGE" },
  { .ov = -1, .code = 0x224c, .word = 0x2495, .immediate=0, .flags=0x80, .name = "TEXT" },
  { .ov = -1, .code = 0x224c, .word = 0x24c0, .immediate=1, .flags=0x80, .name = "THEN" },
  { .ov = -1, .code = 0x224c, .word = 0x24df, .immediate=0, .flags=0x80, .name = "TRAVERSE" },
  { .ov = -1, .code = 0x224c, .word = 0x2503, .immediate=1, .flags=0x80, .name = "UNTIL" },
  { .ov = -1, .code = 0x224c, .word = 0x2520, .immediate=0, .flags=0x80, .name = "VARIABLE" },
  { .ov = -1, .code = 0x224c, .word = 0x2532, .immediate=1, .flags=0x80, .name = "WHILE" },
  { .ov = -1, .code = 0x224c, .word = 0x253e, .immediate=1, .flags=0x80, .name = "zero_length_unknown" },
  { .ov = -1, .code = 0x224c, .word = 0x2558, .immediate=1, .flags=0x80, .name = "[" },
  { .ov = -1, .code = 0x224c, .word = 0x256e, .immediate=1, .flags=0x80, .name = "[COMPILE]" },
  { .ov = -1, .code = 0x224c, .word = 0x257e, .immediate=1, .flags=0x80, .name = "\\" },
  { .ov = -1, .code = 0x224c, .word = 0x25a2, .immediate=0, .flags=0x80, .name = "]" },
  { .ov = -1, .code = 0x25bc, .word = 0x25bc, .immediate=0, .flags=0x80, .name = "(?TERMINAL)" },
  { .ov = -1, .code = 0x25d7, .word = 0x25d7, .immediate=0, .flags=0x80, .name = "(KEY)" },
  { .ov = -1, .code = 0x1d29, .word = 0x25fe, .immediate=0, .flags=0x80, .name = "BEEPMS" },
  { .ov = -1, .code = 0x1d29, .word = 0x260d, .immediate=0, .flags=0x80, .name = "BEEPTONE" },
  { .ov = -1, .code = 0x2618, .word = 0x2618, .immediate=0, .flags=0x80, .name = "TONE" },
  { .ov = -1, .code = 0x2638, .word = 0x2638, .immediate=0, .flags=0x80, .name = "BEEPON_1" },
  { .ov = -1, .code = 0x2653, .word = 0x2653, .immediate=0, .flags=0x80, .name = "BEEPOFF" },
  { .ov = -1, .code = 0x224c, .word = 0x266b, .immediate=0, .flags=0x80, .name = "BEEP" },
  { .ov = -1, .code = 0x224c, .word = 0x2690, .immediate=0, .flags=0x80, .name = "(TYPE)" },
  { .ov = -1, .code = 0x224c, .word = 0x26cf, .immediate=0, .flags=0x80, .name = "(BS)" },
  { .ov = -1, .code = 0x224c, .word = 0x26ee, .immediate=0, .flags=0x80, .name = "(CR)" },
  { .ov = -1, .code = 0x224c, .word = 0x2731, .immediate=0, .flags=0x80, .name = "(EMIT)" },
  { .ov = -1, .code = 0x224c, .word = 0x274c, .immediate=0, .flags=0x80, .name = "(PAGE)" },
  { .ov = -1, .code = 0x2767, .word = 0x2767, .immediate=0, .flags=0x80, .name = "(POSITION)" },
  { .ov = -1, .code = 0x224c, .word = 0x2790, .immediate=0, .flags=0x80, .name = "-TRAILING" },
  { .ov = -1, .code = 0x224c, .word = 0x27ba, .immediate=0, .flags=0x80, .name = "." },
  { .ov = -1, .code = 0x224c, .word = 0x27ca, .immediate=0, .flags=0x80, .name = ".LINE" },
  { .ov = -1, .code = 0x224c, .word = 0x27e3, .immediate=0, .flags=0x80, .name = ".R" },
  { .ov = -1, .code = 0x27f8, .word = 0x27f8, .immediate=0, .flags=0x80, .name = ">VMOVE" },
  { .ov = -1, .code = 0x224c, .word = 0x2822, .immediate=0, .flags=0x80, .name = "?" },
  { .ov = -1, .code = 0x2836, .word = 0x2836, .immediate=0, .flags=0x80, .name = "?POSITION" },
  { .ov = -1, .code = 0x2852, .word = 0x2852, .immediate=0, .flags=0x80, .name = "CUR>ADDR" },
  { .ov = -1, .code = 0x224c, .word = 0x2868, .immediate=0, .flags=0x80, .name = "CURFWD" },
  { .ov = -1, .code = 0x224c, .word = 0x2895, .immediate=0, .flags=0x80, .name = "D." },
  { .ov = -1, .code = 0x224c, .word = 0x28a5, .immediate=0, .flags=0x80, .name = "D.R" },
  { .ov = -1, .code = 0x224c, .word = 0x28d3, .immediate=0, .flags=0x80, .name = "ID." },
  { .ov = -1, .code = 0x224c, .word = 0x2928, .immediate=0, .flags=0x80, .name = "LIST" },
  { .ov = -1, .code = 0x2973, .word = 0x2973, .immediate=0, .flags=0x80, .name = "SCROLLUP" },
  { .ov = -1, .code = 0x224c, .word = 0x2996, .immediate=0, .flags=0x80, .name = "SPACE" },
  { .ov = -1, .code = 0x224c, .word = 0x29a7, .immediate=0, .flags=0x80, .name = "SPACES" },
  { .ov = -1, .code = 0x224c, .word = 0x29c4, .immediate=0, .flags=0x80, .name = "U." },
  { .ov = -1, .code = 0x224c, .word = 0x29d2, .immediate=0, .flags=0x80, .name = "U.R" },
  { .ov = -1, .code = 0x29e1, .word = 0x29e1, .immediate=0, .flags=0x80, .name = "V@" },
  { .ov = -1, .code = 0x29fc, .word = 0x29fc, .immediate=0, .flags=0x80, .name = "V!" },
  { .ov = -1, .code = 0x2a18, .word = 0x2a18, .immediate=0, .flags=0x80, .name = "VFILL" },
  { .ov = -1, .code = 0x2a36, .word = 0x2a36, .immediate=0, .flags=0x80, .name = "VMOVE" },
  { .ov = -1, .code = 0x2a5f, .word = 0x2a5f, .immediate=0, .flags=0x80, .name = "VMOVE-" },
  { .ov = -1, .code = 0x2214, .word = 0x2a72, .immediate=0, .flags=0x80, .name = "MS/TICK" },
  { .ov = -1, .code = 0x2214, .word = 0x2a82, .immediate=0, .flags=0x80, .name = "TICKS/ADJ" },
  { .ov = -1, .code = 0x2214, .word = 0x2a8f, .immediate=0, .flags=0x80, .name = "MS/ADJ" },
  { .ov = -1, .code = 0x2a9a, .word = 0x2a9a, .immediate=0, .flags=0x80, .name = "TIME" },
  { .ov = -1, .code = 0x224c, .word = 0x2af1, .immediate=0, .flags=0x80, .name = "MS" },
  { .ov = -1, .code = 0x2214, .word = 0x2b21, .immediate=0, .flags=0x80, .name = "#DRIVES" },
  { .ov = -1, .code = 0x2214, .word = 0x2b2d, .immediate=0, .flags=0x80, .name = "#FCBS" },
  { .ov = -1, .code = 0x2214, .word = 0x2b3a, .immediate=0, .flags=0x80, .name = "#FILES" },
  { .ov = -1, .code = 0x2214, .word = 0x2b49, .immediate=0, .flags=0x80, .name = "#SEC/TRK" },
  { .ov = -1, .code = 0x2214, .word = 0x2b58, .immediate=0, .flags=0x80, .name = "DOS-FILE" },
  { .ov = -1, .code = 0x2214, .word = 0x2b66, .immediate=0, .flags=0x80, .name = "RETRIES" },
  { .ov = -1, .code = 0x2214, .word = 0x2b76, .immediate=0, .flags=0x80, .name = "SECORIGIN" },
  { .ov = -1, .code = 0x1d29, .word = 0x2b83, .immediate=0, .flags=0x80, .name = "'SVBUF" },
  { .ov = -1, .code = 0x1d29, .word = 0x2b90, .immediate=0, .flags=0x80, .name = "'MTBUF" },
  { .ov = -1, .code = 0x1d29, .word = 0x2b9c, .immediate=0, .flags=0x80, .name = "#SECS" },
  { .ov = -1, .code = 0x1d29, .word = 0x2ba7, .immediate=0, .flags=0x80, .name = "'FCB" },
  { .ov = -1, .code = 0x1d29, .word = 0x2bb4, .immediate=0, .flags=0x80, .name = "'CACHE" },
  { .ov = -1, .code = 0x1d29, .word = 0x2bc4, .immediate=0, .flags=0x80, .name = "'DOSMOUNT" },
  { .ov = -1, .code = 0x1d29, .word = 0x2bd6, .immediate=0, .flags=0x80, .name = "'DOSUNMOUNT" },
  { .ov = -1, .code = 0x1d29, .word = 0x2be3, .immediate=0, .flags=0x80, .name = "REUSEC" },
  { .ov = -1, .code = 0x1d29, .word = 0x2bf5, .immediate=0, .flags=0x80, .name = "1STCACHEBUF" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c04, .immediate=0, .flags=0x80, .name = "BLKCACHE" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c15, .immediate=0, .flags=0x80, .name = "DEFAULTDRV" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c26, .immediate=0, .flags=0x80, .name = "DISK-ERROR" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c32, .immediate=0, .flags=0x80, .name = "DRIVE" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c3c, .immediate=0, .flags=0x80, .name = "DTA_1" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c49, .immediate=0, .flags=0x80, .name = "FILE" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c55, .immediate=0, .flags=0x80, .name = "FRESH" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c60, .immediate=0, .flags=0x80, .name = "HEAD" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c6c, .immediate=0, .flags=0x80, .name = "LPREV" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c79, .immediate=0, .flags=0x80, .name = "OFFSET" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c84, .immediate=0, .flags=0x80, .name = "PREV" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c8e, .immediate=0, .flags=0x80, .name = "SEC" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c9d, .immediate=0, .flags=0x80, .name = "SEGCACHE" },
  { .ov = -1, .code = 0x1d29, .word = 0x2ca8, .immediate=0, .flags=0x80, .name = "SYSK" },
  { .ov = -1, .code = 0x1d29, .word = 0x2cb4, .immediate=0, .flags=0x80, .name = "TRACK" },
  { .ov = -1, .code = 0x1d29, .word = 0x2cbe, .immediate=0, .flags=0x80, .name = "USE" },
  { .ov = -1, .code = 0x1d29, .word = 0x2cd0, .immediate=0, .flags=0x80, .name = "=DRIVESIZES" },
  { .ov = -1, .code = 0x224c, .word = 0x2ce5, .immediate=0, .flags=0x80, .name = "DRIVESIZES" },
  { .ov = -1, .code = 0x224c, .word = 0x2cfa, .immediate=0, .flags=0x80, .name = "BARRAY" },
  { .ov = -1, .code = 0x224c, .word = 0x2d09, .immediate=0, .flags=0x80, .name = "WARRAY" },
  { .ov = -1, .code = 0x1d29, .word = 0x2d23, .immediate=0, .flags=0x80, .name = "=DRIVENUMBERS" },
  { .ov = -1, .code = 0x1d29, .word = 0x2d34, .immediate=0, .flags=0x80, .name = "=FCBPFAS" },
  { .ov = -1, .code = 0x1d29, .word = 0x2d4c, .immediate=0, .flags=0x80, .name = "=FILEBLOCKS" },
  { .ov = -1, .code = 0x1d29, .word = 0x2d63, .immediate=0, .flags=0x80, .name = "=FILETYPES" },
  { .ov = -1, .code = 0x1d29, .word = 0x2d74, .immediate=0, .flags=0x80, .name = "=OFFSETS" },
  { .ov = -1, .code = 0x1d29, .word = 0x2d87, .immediate=0, .flags=0x80, .name = "=R/W'S" },
  { .ov = -1, .code = 0x1d29, .word = 0x2d97, .immediate=0, .flags=0x80, .name = "FCB" },
  { .ov = -1, .code = 0x1d29, .word = 0x2dfd, .immediate=0, .flags=0x80, .name = "FILENAMES" },
  { .ov = -1, .code = 0x224c, .word = 0x2e3a, .immediate=0, .flags=0x80, .name = "DRIVENUMBERS" },
  { .ov = -1, .code = 0x224c, .word = 0x2e4c, .immediate=0, .flags=0x80, .name = "FCBPFAS" },
  { .ov = -1, .code = 0x224c, .word = 0x2e61, .immediate=0, .flags=0x80, .name = "FILEBLOCKS" },
  { .ov = -1, .code = 0x224c, .word = 0x2e75, .immediate=0, .flags=0x80, .name = "FILETYPES" },
  { .ov = -1, .code = 0x224c, .word = 0x2e87, .immediate=0, .flags=0x80, .name = "OFFSETS" },
  { .ov = -1, .code = 0x224c, .word = 0x2e97, .immediate=0, .flags=0x80, .name = "R/W'S" },
  { .ov = -1, .code = 0x2ea4, .word = 0x2ea4, .immediate=0, .flags=0x80, .name = "L@" },
  { .ov = -1, .code = 0x2eb8, .word = 0x2eb8, .immediate=0, .flags=0x80, .name = "L!" },
  { .ov = -1, .code = 0x2ecd, .word = 0x2ecd, .immediate=0, .flags=0x80, .name = "LC@" },
  { .ov = -1, .code = 0x2ee5, .word = 0x2ee5, .immediate=0, .flags=0x80, .name = "LC!" },
  { .ov = -1, .code = 0x2efe, .word = 0x2efe, .immediate=0, .flags=0x80, .name = "LCMOVE" },
  { .ov = -1, .code = 0x1d29, .word = 0x2f36, .immediate=0, .flags=0x80, .name = "{LXCHG}" },
  { .ov = -1, .code = 0x2f51, .word = 0x2f51, .immediate=0, .flags=0x80, .name = "LWSCAN" },
  { .ov = -1, .code = 0x224c, .word = 0x2f89, .immediate=0, .flags=0x80, .name = "[SEGCACHE]" },
  { .ov = -1, .code = 0x224c, .word = 0x2fa6, .immediate=0, .flags=0x80, .name = "[BLKCACHE]" },
  { .ov = -1, .code = 0x224c, .word = 0x2fbf, .immediate=0, .flags=0x80, .name = "UPDATE" },
  { .ov = -1, .code = 0x224c, .word = 0x2fd9, .immediate=0, .flags=0x80, .name = "REFRESH" },
  { .ov = -1, .code = 0x224c, .word = 0x2fe9, .immediate=0, .flags=0x80, .name = "MTBUF" },
  { .ov = -1, .code = 0x224c, .word = 0x302d, .immediate=0, .flags=0x80, .name = "MTBUFFERS" },
  { .ov = -1, .code = 0x3048, .word = 0x3048, .immediate=0, .flags=0x80, .name = "(BUFFER)" },
  { .ov = -1, .code = 0x30a8, .word = 0x30a8, .immediate=0, .flags=0x80, .name = "ADVANCE" },
  { .ov = -1, .code = 0x224c, .word = 0x30d5, .immediate=0, .flags=0x80, .name = "MTCACHE" },
  { .ov = -1, .code = 0x224c, .word = 0x3115, .immediate=0, .flags=0x80, .name = "INITCACHE" },
  { .ov = -1, .code = 0x224c, .word = 0x3177, .immediate=0, .flags=0x80, .name = "(CACHE)" },
  { .ov = -1, .code = 0x224c, .word = 0x31bb, .immediate=0, .flags=0x80, .name = "CACHE>USE" },
  { .ov = -1, .code = 0x224c, .word = 0x31e5, .immediate=0, .flags=0x80, .name = "?INBCACHE" },
  { .ov = -1, .code = 0x224c, .word = 0x321b, .immediate=0, .flags=0x80, .name = "[BUF>CACHE]" },
  { .ov = -1, .code = 0x224c, .word = 0x3245, .immediate=0, .flags=0x80, .name = "BUF>CACHE" },
  { .ov = -1, .code = 0x224c, .word = 0x326b, .immediate=0, .flags=0x80, .name = "SEC-I/O" },
  { .ov = -1, .code = 0x224c, .word = 0x32d5, .immediate=0, .flags=0x80, .name = "T&SCALC" },
  { .ov = -1, .code = 0x224c, .word = 0x32fd, .immediate=0, .flags=0x80, .name = "[R/W]" },
  { .ov = -1, .code = 0x224c, .word = 0x3344, .immediate=0, .flags=0x80, .name = "[DIRECT]" },
  { .ov = -1, .code = 0x224c, .word = 0x3398, .immediate=0, .flags=0x80, .name = "<MOUNT>" },
  { .ov = -1, .code = 0x1d29, .word = 0x3408, .immediate=0, .flags=0x80, .name = "DIRNAME" },
  { .ov = -1, .code = 0x224c, .word = 0x341b, .immediate=0, .flags=0x80, .name = "DR0" },
  { .ov = -1, .code = 0x224c, .word = 0x3439, .immediate=0, .flags=0x80, .name = "DR1" },
  { .ov = -1, .code = 0x224c, .word = 0x345f, .immediate=0, .flags=0x80, .name = "<UNMOUNT>" },
  { .ov = -1, .code = 0x224c, .word = 0x34c9, .immediate=0, .flags=0x80, .name = "UNMOUNT" },
  { .ov = -1, .code = 0x224c, .word = 0x34ec, .immediate=0, .flags=0x80, .name = "NOFILES" },
  { .ov = -1, .code = 0x224c, .word = 0x350d, .immediate=0, .flags=0x80, .name = "NODRIVES" },
  { .ov = -1, .code = 0x224c, .word = 0x351b, .immediate=0, .flags=0x80, .name = "EMITS" },
  { .ov = -1, .code = 0x224c, .word = 0x353b, .immediate=0, .flags=0x80, .name = "FILES" },
  { .ov = -1, .code = 0x224c, .word = 0x3633, .immediate=0, .flags=0x80, .name = "DRIVES" },
  { .ov = -1, .code = 0x224c, .word = 0x3648, .immediate=0, .flags=0x80, .name = "(DISKERROR?)" },
  { .ov = -1, .code = 0x3672, .word = 0x3672, .immediate=0, .flags=0x00, .name = "W3672" },
  { .ov = -1, .code = 0x367f, .word = 0x367f, .immediate=0, .flags=0x00, .name = "W367F" },
  { .ov = -1, .code = 0x36bb, .word = 0x36bb, .immediate=0, .flags=0x00, .name = "W36BB" },
  { .ov = -1, .code = 0x224c, .word = 0x36d7, .immediate=0, .flags=0x00, .name = "W36D7" },
  { .ov = -1, .code = 0x224c, .word = 0x3715, .immediate=0, .flags=0x00, .name = "W3715" },
  { .ov = -1, .code = 0x224c, .word = 0x3753, .immediate=0, .flags=0x00, .name = "W3753" },
  { .ov = -1, .code = 0x224c, .word = 0x3783, .immediate=0, .flags=0x00, .name = "W3783" },
  { .ov = -1, .code = 0x224c, .word = 0x37af, .immediate=0, .flags=0x00, .name = "W37AF" },
  { .ov = -1, .code = 0x224c, .word = 0x37d3, .immediate=0, .flags=0x00, .name = "W37D3" },
  { .ov = -1, .code = 0x224c, .word = 0x3823, .immediate=0, .flags=0x00, .name = "W3823" },
  { .ov = -1, .code = 0x224c, .word = 0x3849, .immediate=0, .flags=0x00, .name = "W3849" },
  { .ov = -1, .code = 0x224c, .word = 0x385f, .immediate=0, .flags=0x80, .name = "BLOCK_1" },
  { .ov = -1, .code = 0x224c, .word = 0x3880, .immediate=0, .flags=0x80, .name = "LBLOCK_1" },
  { .ov = -1, .code = 0x224c, .word = 0x38ad, .immediate=0, .flags=0x80, .name = "SAVE-BUFFERS" },
  { .ov = -1, .code = 0x224c, .word = 0x38fd, .immediate=0, .flags=0x80, .name = "EMPTY-BUFFERS" },
  { .ov = -1, .code = 0x224c, .word = 0x3913, .immediate=0, .flags=0x80, .name = "FLUSH_1" },
  { .ov = -1, .code = 0x224c, .word = 0x3922, .immediate=0, .flags=0x80, .name = "COPY" },
  { .ov = -1, .code = 0x224c, .word = 0x393f, .immediate=0, .flags=0x80, .name = "BLOCKS" },
  { .ov = -1, .code = 0x2214, .word = 0x3991, .immediate=0, .flags=0x80, .name = "PSW" },
  { .ov = -1, .code = 0x2214, .word = 0x399a, .immediate=0, .flags=0x80, .name = "AX" },
  { .ov = -1, .code = 0x2214, .word = 0x39a3, .immediate=0, .flags=0x80, .name = "BX" },
  { .ov = -1, .code = 0x2214, .word = 0x39ac, .immediate=0, .flags=0x80, .name = "CX" },
  { .ov = -1, .code = 0x2214, .word = 0x39b5, .immediate=0, .flags=0x80, .name = "DX" },
  { .ov = -1, .code = 0x2214, .word = 0x39be, .immediate=0, .flags=0x80, .name = "BP" },
  { .ov = -1, .code = 0x2214, .word = 0x39c7, .immediate=0, .flags=0x80, .name = "DI" },
  { .ov = -1, .code = 0x2214, .word = 0x39d0, .immediate=0, .flags=0x80, .name = "SI" },
  { .ov = -1, .code = 0x2214, .word = 0x39d9, .immediate=0, .flags=0x80, .name = "DS" },
  { .ov = -1, .code = 0x2214, .word = 0x39e2, .immediate=0, .flags=0x80, .name = "ES" },
  { .ov = -1, .code = 0x39ee, .word = 0x39ee, .immediate=0, .flags=0x80, .name = "MATCH" },
  { .ov = -1, .code = 0x3a39, .word = 0x3a39, .immediate=0, .flags=0x80, .name = "@EXECUTE" },
  { .ov = -1, .code = 0x224c, .word = 0x3a48, .immediate=0, .flags=0x80, .name = "NOP" },
  { .ov = -1, .code = 0x224c, .word = 0x3a51, .immediate=1, .flags=0x80, .name = "**" },
  { .ov = -1, .code = 0x1d29, .word = 0x3a60, .immediate=0, .flags=0x80, .name = "'UNRAVEL" },
  { .ov = -1, .code = 0x224c, .word = 0x3a6e, .immediate=0, .flags=0x80, .name = "UNRAVEL" },
  { .ov = -1, .code = 0x224c, .word = 0x3abf, .immediate=0, .flags=0x80, .name = "?UNRAVEL" },
  { .ov = -1, .code = 0x224c, .word = 0x3acf, .immediate=0, .flags=0x80, .name = "SYN" },
  { .ov = -1, .code = 0x1d29, .word = 0x3b1b, .immediate=0, .flags=0x80, .name = "TRACE" },
  { .ov = -1, .code = 0x1d29, .word = 0x3b28, .immediate=0, .flags=0x80, .name = "[TRACE" },
  { .ov = -1, .code = 0x1d29, .word = 0x3b35, .immediate=0, .flags=0x80, .name = "TRACE]" },
  { .ov = -1, .code = 0x3af8, .word = 0x3b3e, .immediate=1, .flags=0x80, .name = "D@" },
  { .ov = -1, .code = 0x3af8, .word = 0x3b47, .immediate=1, .flags=0x80, .name = "V=" },
  { .ov = -1, .code = 0x3af8, .word = 0x3b50, .immediate=1, .flags=0x80, .name = "C=" },
  { .ov = -1, .code = 0x224c, .word = 0x3b5a, .immediate=0, .flags=0x80, .name = "2V=" },
  { .ov = -1, .code = 0x224c, .word = 0x3b6c, .immediate=0, .flags=0x80, .name = "2C=" },
  { .ov = -1, .code = 0x2214, .word = 0x3b81, .immediate=0, .flags=0x80, .name = "3" },
  { .ov = -1, .code = 0x2214, .word = 0x3b89, .immediate=0, .flags=0x80, .name = "4" },
  { .ov = -1, .code = 0x2214, .word = 0x3b91, .immediate=0, .flags=0x80, .name = "5" },
  { .ov = -1, .code = 0x2214, .word = 0x3b99, .immediate=0, .flags=0x80, .name = "6" },
  { .ov = -1, .code = 0x2214, .word = 0x3ba1, .immediate=0, .flags=0x80, .name = "7" },
  { .ov = -1, .code = 0x2214, .word = 0x3ba9, .immediate=0, .flags=0x80, .name = "8" },
  { .ov = -1, .code = 0x2214, .word = 0x3bb1, .immediate=0, .flags=0x80, .name = "9" },
  { .ov = -1, .code = 0x2214, .word = 0x3bba, .immediate=0, .flags=0x80, .name = "-1" },
  { .ov = -1, .code = 0x2214, .word = 0x3bc3, .immediate=0, .flags=0x80, .name = "-2" },
  { .ov = -1, .code = 0x224c, .word = 0x3bce, .immediate=0, .flags=0x80, .name = "THRU_1" },
  { .ov = -1, .code = 0x224c, .word = 0x3bfa, .immediate=0, .flags=0x80, .name = "(TRACE)" },
  { .ov = -1, .code = 0x1d29, .word = 0x3c04, .immediate=0, .flags=0x80, .name = "OVA" },
  { .ov = -1, .code = 0x1d29, .word = 0x3c0f, .immediate=0, .flags=0x80, .name = "T-DP" },
  { .ov = -1, .code = 0x224c, .word = 0x3c25, .immediate=0, .flags=0x80, .name = "TRANS-ALLOT" },
  { .ov = -1, .code = 0x224c, .word = 0x3c3f, .immediate=0, .flags=0x80, .name = "NEWT-DP" },
  { .ov = -1, .code = 0x224c, .word = 0x3c5b, .immediate=0, .flags=0x80, .name = "TRANSIENT" },
  { .ov = -1, .code = 0x224c, .word = 0x3c7e, .immediate=0, .flags=0x80, .name = "RESIDENT" },
  { .ov = -1, .code = 0x224c, .word = 0x3c9e, .immediate=0, .flags=0x80, .name = "HEAD:" },
  { .ov = -1, .code = 0x224c, .word = 0x3ccc, .immediate=1, .flags=0x80, .name = "T:" },
  { .ov = -1, .code = 0x224c, .word = 0x3ceb, .immediate=1, .flags=0x80, .name = "T;" },
  { .ov = -1, .code = 0x224c, .word = 0x3cf7, .immediate=0, .flags=0x00, .name = "W3CF7" },
  { .ov = -1, .code = 0x224c, .word = 0x3d45, .immediate=0, .flags=0x00, .name = "W3D45" },
  { .ov = -1, .code = 0x224c, .word = 0x3d9b, .immediate=0, .flags=0x80, .name = "DISPOSE" },
  { .ov = -1, .code = 0x224c, .word = 0x3e03, .immediate=1, .flags=0x80, .name = "'_2" },
  { .ov = -1, .code = 0x1d29, .word = 0x3e2d, .immediate=0, .flags=0x80, .name = "(2V:)" },
  { .ov = -1, .code = 0x2214, .word = 0x3e3a, .immediate=0, .flags=0x80, .name = "(C:)" },
  { .ov = -1, .code = 0x3b74, .word = 0x3e46, .immediate=0, .flags=0x80, .name = "(2C:)" },
  { .ov = -1, .code = 0x224c, .word = 0x3e51, .immediate=0, .flags=0x80, .name = "V:" },
  { .ov = -1, .code = 0x224c, .word = 0x3e67, .immediate=0, .flags=0x80, .name = "2V:" },
  { .ov = -1, .code = 0x224c, .word = 0x3e7c, .immediate=0, .flags=0x80, .name = "C:" },
  { .ov = -1, .code = 0x224c, .word = 0x3e90, .immediate=0, .flags=0x80, .name = "2C:" },
  { .ov = -1, .code = 0x224c, .word = 0x3eab, .immediate=0, .flags=0x80, .name = "EXECUTES" },
  { .ov = -1, .code = 0x224c, .word = 0x3ec0, .immediate=0, .flags=0x80, .name = "BINARY" },
  { .ov = -1, .code = 0x224c, .word = 0x3ecf, .immediate=0, .flags=0x80, .name = "H." },
  { .ov = -1, .code = 0x224c, .word = 0x3ee9, .immediate=0, .flags=0x80, .name = "RANGE" },
  { .ov = -1, .code = 0x224c, .word = 0x3efb, .immediate=1, .flags=0x80, .name = "ASCII" },
  { .ov = -1, .code = 0x224c, .word = 0x3f09, .immediate=0, .flags=0x00, .name = "SET_STR_AS_PARAM" },
  { .ov = -1, .code = 0x224c, .word = 0x3f1f, .immediate=1, .flags=0x80, .name = "\"" },
  { .ov = -1, .code = 0x224c, .word = 0x3f5d, .immediate=0, .flags=0x80, .name = "DU<" },
  { .ov = -1, .code = 0x224c, .word = 0x3f7e, .immediate=0, .flags=0x80, .name = "PICK" },
  { .ov = -1, .code = 0x224c, .word = 0x3f9d, .immediate=0, .flags=0x80, .name = "ROLL" },
  { .ov = -1, .code = 0x224c, .word = 0x3fdd, .immediate=0, .flags=0x80, .name = "2OVER" },
  { .ov = -1, .code = 0x224c, .word = 0x3fee, .immediate=0, .flags=0x80, .name = "D-" },
  { .ov = -1, .code = 0x224c, .word = 0x3ffc, .immediate=0, .flags=0x80, .name = "D0=" },
  { .ov = -1, .code = 0x224c, .word = 0x4009, .immediate=0, .flags=0x80, .name = "D=" },
  { .ov = -1, .code = 0x224c, .word = 0x4016, .immediate=0, .flags=0x80, .name = "D>" },
  { .ov = -1, .code = 0x224c, .word = 0x4027, .immediate=0, .flags=0x80, .name = "WITHIN" },
  { .ov = -1, .code = 0x224c, .word = 0x4044, .immediate=0, .flags=0x80, .name = "DMIN" },
  { .ov = -1, .code = 0x224c, .word = 0x405d, .immediate=0, .flags=0x80, .name = "DMAX" },
  { .ov = -1, .code = 0x224c, .word = 0x4078, .immediate=1, .flags=0x80, .name = "MYSELF" },
  { .ov = -1, .code = 0x224c, .word = 0x409d, .immediate=0, .flags=0x80, .name = ">TIB" },
  { .ov = -1, .code = 0x224c, .word = 0x40bd, .immediate=0, .flags=0x80, .name = "DOSPARM" },
  { .ov = -1, .code = 0x1d29, .word = 0x40d4, .immediate=0, .flags=0x80, .name = "MAXDRV" },
  { .ov = -1, .code = 0x224c, .word = 0x40e2, .immediate=0, .flags=0x80, .name = "?#DETTE" },
  { .ov = -1, .code = 0x224c, .word = 0x4105, .immediate=0, .flags=0x80, .name = "XFCB" },
  { .ov = -1, .code = 0x224c, .word = 0x4117, .immediate=0, .flags=0x80, .name = "DRV" },
  { .ov = -1, .code = 0x224c, .word = 0x4125, .immediate=0, .flags=0x80, .name = "NAM" },
  { .ov = -1, .code = 0x224c, .word = 0x4135, .immediate=0, .flags=0x80, .name = "TYP" },
  { .ov = -1, .code = 0x224c, .word = 0x414c, .immediate=0, .flags=0x80, .name = "CURBLK" },
  { .ov = -1, .code = 0x224c, .word = 0x4164, .immediate=0, .flags=0x80, .name = "RECSIZE" },
  { .ov = -1, .code = 0x224c, .word = 0x417c, .immediate=0, .flags=0x80, .name = "FILESIZ" },
  { .ov = -1, .code = 0x224c, .word = 0x4193, .immediate=0, .flags=0x80, .name = "CURREC" },
  { .ov = -1, .code = 0x224c, .word = 0x41aa, .immediate=0, .flags=0x80, .name = "RELREC" },
  { .ov = -1, .code = 0x224c, .word = 0x41c1, .immediate=0, .flags=0x80, .name = "CLRFCB" },
  { .ov = -1, .code = 0x224c, .word = 0x41e8, .immediate=0, .flags=0x80, .name = "SYSTEM" },
  { .ov = -1, .code = 0x224c, .word = 0x4202, .immediate=0, .flags=0x80, .name = "SYSUTIL" },
  { .ov = -1, .code = 0x224c, .word = 0x421e, .immediate=0, .flags=0x80, .name = "DOSCALL" },
  { .ov = -1, .code = 0x224c, .word = 0x4235, .immediate=0, .flags=0x80, .name = ">FCB" },
  { .ov = -1, .code = 0x224c, .word = 0x4274, .immediate=0, .flags=0x80, .name = "SETFCB" },
  { .ov = -1, .code = 0x224c, .word = 0x42a1, .immediate=0, .flags=0x80, .name = "INIT" },
  { .ov = -1, .code = 0x224c, .word = 0x42b5, .immediate=0, .flags=0x80, .name = "FCBCALL" },
  { .ov = -1, .code = 0x224c, .word = 0x42d4, .immediate=0, .flags=0x80, .name = "OPEN" },
  { .ov = -1, .code = 0x224c, .word = 0x42e6, .immediate=0, .flags=0x80, .name = "CLOSE" },
  { .ov = -1, .code = 0x224c, .word = 0x42fa, .immediate=0, .flags=0x80, .name = "SEARCH1" },
  { .ov = -1, .code = 0x224c, .word = 0x430e, .immediate=0, .flags=0x80, .name = "READNEX" },
  { .ov = -1, .code = 0x224c, .word = 0x4322, .immediate=0, .flags=0x80, .name = "WRITENE" },
  { .ov = -1, .code = 0x224c, .word = 0x4333, .immediate=0, .flags=0x80, .name = "MAKE" },
  { .ov = -1, .code = 0x224c, .word = 0x4347, .immediate=0, .flags=0x80, .name = "DOS-DTA" },
  { .ov = -1, .code = 0x224c, .word = 0x4367, .immediate=0, .flags=0x80, .name = "READ-RA" },
  { .ov = -1, .code = 0x224c, .word = 0x437b, .immediate=0, .flags=0x80, .name = "WRITE-R" },
  { .ov = -1, .code = 0x224c, .word = 0x4385, .immediate=0, .flags=0x00, .name = "W4385" },
  { .ov = -1, .code = 0x224c, .word = 0x439e, .immediate=0, .flags=0x80, .name = "MAKE<NA" },
  { .ov = -1, .code = 0x224c, .word = 0x43c2, .immediate=0, .flags=0x80, .name = "OPEN<NA" },
  { .ov = -1, .code = 0x224c, .word = 0x43e3, .immediate=0, .flags=0x80, .name = "[FILE]" },
  { .ov = -1, .code = 0x224c, .word = 0x4414, .immediate=0, .flags=0x80, .name = "SYSGEN" },
  { .ov = -1, .code = 0x224c, .word = 0x4450, .immediate=0, .flags=0x80, .name = "4TH>DOS" },
  { .ov = -1, .code = 0x224c, .word = 0x4480, .immediate=0, .flags=0x00, .name = "W4480" },
  { .ov = -1, .code = 0x224c, .word = 0x44d8, .immediate=0, .flags=0x00, .name = "W44D8" },
  { .ov = -1, .code = 0x224c, .word = 0x44f2, .immediate=0, .flags=0x00, .name = "W44F2" },
  { .ov = -1, .code = 0x224c, .word = 0x450c, .immediate=0, .flags=0x80, .name = "SETMAXD" },
  { .ov = -1, .code = 0x224c, .word = 0x455a, .immediate=0, .flags=0x00, .name = "W455A" },
  { .ov = -1, .code = 0x224c, .word = 0x4576, .immediate=0, .flags=0x80, .name = "?1DRV" },
  { .ov = -1, .code = 0x224c, .word = 0x458e, .immediate=0, .flags=0x00, .name = "W458E" },
  { .ov = -1, .code = 0x224c, .word = 0x45b2, .immediate=0, .flags=0x80, .name = "SMARTOP" },
  { .ov = -1, .code = 0x1d29, .word = 0x460e, .immediate=0, .flags=0x80, .name = "ASKMOUN" },
  { .ov = -1, .code = 0x1d29, .word = 0x4619, .immediate=0, .flags=0x80, .name = "'BYE" },
  { .ov = -1, .code = 0x1d29, .word = 0x4627, .immediate=0, .flags=0x80, .name = "SKIPPED" },
  { .ov = -1, .code = 0x1d29, .word = 0x4635, .immediate=0, .flags=0x80, .name = "CANSKIP" },
  { .ov = -1, .code = 0x224c, .word = 0x4643, .immediate=0, .flags=0x80, .name = "<ASKMOU" },
  { .ov = -1, .code = 0x224c, .word = 0x46da, .immediate=0, .flags=0x80, .name = "DOSMOUN" },
  { .ov = -1, .code = 0x224c, .word = 0x4744, .immediate=0, .flags=0x80, .name = "DOSUNMO" },
  { .ov = -1, .code = 0x224c, .word = 0x475c, .immediate=0, .flags=0x80, .name = "DR2" },
  { .ov = -1, .code = 0x224c, .word = 0x4782, .immediate=0, .flags=0x80, .name = "DR3" },
  { .ov = -1, .code = 0x224c, .word = 0x47ac, .immediate=0, .flags=0x80, .name = "USING" },
  { .ov = -1, .code = 0x224c, .word = 0x47c6, .immediate=0, .flags=0x80, .name = "SETBLOC" },
  { .ov = -1, .code = 0x224c, .word = 0x4804, .immediate=0, .flags=0x80, .name = "SETSYSK" },
  { .ov = -1, .code = 0x1d29, .word = 0x484e, .immediate=0, .flags=0x00, .name = "W484E" },
  { .ov = -1, .code = 0x1d29, .word = 0x4852, .immediate=0, .flags=0x00, .name = "W4852" },
  { .ov = -1, .code = 0x1d29, .word = 0x4856, .immediate=0, .flags=0x00, .name = "W4856" },
  { .ov = -1, .code = 0x224c, .word = 0x4863, .immediate=0, .flags=0x80, .name = "?ERR" },
  { .ov = -1, .code = 0x224c, .word = 0x486f, .immediate=0, .flags=0x00, .name = "W486F" },
  { .ov = -1, .code = 0x224c, .word = 0x48ab, .immediate=0, .flags=0x80, .name = "[LDS]" },
  { .ov = -1, .code = 0x1d29, .word = 0x4901, .immediate=0, .flags=0x00, .name = "W4901" },
  { .ov = -1, .code = 0x224c, .word = 0x491c, .immediate=0, .flags=0x80, .name = "(LDS)" },
  { .ov = -1, .code = 0x224c, .word = 0x4954, .immediate=0, .flags=0x00, .name = "W4954" },
  { .ov = -1, .code = 0x4961, .word = 0x4961, .immediate=0, .flags=0x80, .name = "ON_1" },
  { .ov = -1, .code = 0x4974, .word = 0x4974, .immediate=0, .flags=0x80, .name = "OFF_2" },
  { .ov = -1, .code = 0x4980, .word = 0x4980, .immediate=0, .flags=0x00, .name = "W4980" },
  { .ov = -1, .code = 0x224c, .word = 0x4999, .immediate=0, .flags=0x80, .name = "KEY_2" },
  { .ov = -1, .code = 0x3b74, .word = 0x49a8, .immediate=0, .flags=0x80, .name = "NULL" },
  { .ov = -1, .code = 0x1d29, .word = 0x49b4, .immediate=0, .flags=0x80, .name = "ZZZ" },
  { .ov = -1, .code = 0x49ca, .word = 0x49ca, .immediate=0, .flags=0x80, .name = "<LCMOVE" },
  { .ov = -1, .code = 0x49fe, .word = 0x49fe, .immediate=0, .flags=0x80, .name = "2^N" },
  { .ov = -1, .code = 0x224c, .word = 0x4a15, .immediate=0, .flags=0x80, .name = "BIT" },
  { .ov = -1, .code = 0x4a23, .word = 0x4a23, .immediate=0, .flags=0x80, .name = "16/" },
  { .ov = -1, .code = 0x4a37, .word = 0x4a37, .immediate=0, .flags=0x80, .name = "16*" },
  { .ov = -1, .code = 0x4a4c, .word = 0x4a4c, .immediate=0, .flags=0x80, .name = "D16*" },
  { .ov = -1, .code = 0x224c, .word = 0x4a65, .immediate=0, .flags=0x80, .name = "3*" },
  { .ov = -1, .code = 0x4a72, .word = 0x4a72, .immediate=0, .flags=0x80, .name = "3+" },
  { .ov = -1, .code = 0x4a85, .word = 0x4a85, .immediate=0, .flags=0x80, .name = "1.5@" },
  { .ov = -1, .code = 0x4a9c, .word = 0x4a9c, .immediate=0, .flags=0x80, .name = "1.5!_1" },
  { .ov = -1, .code = 0x4ab0, .word = 0x4ab0, .immediate=0, .flags=0x80, .name = "@DS" },
  { .ov = -1, .code = 0x1d29, .word = 0x4ab8, .immediate=0, .flags=0x00, .name = "W4AB8" },
  { .ov = -1, .code = 0x224c, .word = 0x4acf, .immediate=0, .flags=0x80, .name = "+@" },
  { .ov = -1, .code = 0x224c, .word = 0x4adf, .immediate=0, .flags=0x80, .name = ">FLAG" },
  { .ov = -1, .code = 0x4aee, .word = 0x4aee, .immediate=0, .flags=0x80, .name = "L+-@" },
  { .ov = -1, .code = 0x4b01, .word = 0x4b01, .immediate=0, .flags=0x00, .name = "W4B01" },
  { .ov = -1, .code = 0x224c, .word = 0x4b2d, .immediate=0, .flags=0x80, .name = "CASE" },
  { .ov = -1, .code = 0x224c, .word = 0x4b4b, .immediate=0, .flags=0x80, .name = "IS" },
  { .ov = -1, .code = 0x224c, .word = 0x4b60, .immediate=0, .flags=0x80, .name = "OTHERS" },
  { .ov = -1, .code = 0x224c, .word = 0x4b7a, .immediate=0, .flags=0x80, .name = "CASE:" },
  { .ov = -1, .code = 0x1d29, .word = 0x4b9c, .immediate=0, .flags=0x80, .name = "SEED_3" },
  { .ov = -1, .code = 0x4ba7, .word = 0x4ba7, .immediate=0, .flags=0x80, .name = "FRND" },
  { .ov = -1, .code = 0x224c, .word = 0x4bc6, .immediate=0, .flags=0x80, .name = "RRND" },
  { .ov = -1, .code = 0x4bdf, .word = 0x4bdf, .immediate=0, .flags=0x80, .name = "+BIT" },
  { .ov = -1, .code = 0x4bf4, .word = 0x4bf4, .immediate=0, .flags=0x00, .name = "D2*" },
  { .ov = -1, .code = 0x4c03, .word = 0x4c03, .immediate=0, .flags=0x00, .name = "EASY-BITS" },
  { .ov = -1, .code = 0x224c, .word = 0x4c2a, .immediate=0, .flags=0x00, .name = "W4C2A" },
  { .ov = -1, .code = 0x224c, .word = 0x4c64, .immediate=0, .flags=0x00, .name = "W4C64" },
  { .ov = -1, .code = 0x224c, .word = 0x4c93, .immediate=0, .flags=0x80, .name = "SQRT" },
  { .ov = -1, .code = 0x4cb1, .word = 0x4cb1, .immediate=0, .flags=0x80, .name = "+-@" },
  { .ov = -1, .code = 0x4cc5, .word = 0x4cc5, .immediate=0, .flags=0x80, .name = "L1.5@" },
  { .ov = -1, .code = 0x0c60, .word = 0x4ce3, .immediate=0, .flags=0x80, .name = "<C!>" },
  { .ov = -1, .code = 0x0be1, .word = 0x4ceb, .immediate=0, .flags=0x80, .name = "<!>" },
  { .ov = -1, .code = 0x4a9c, .word = 0x4cf6, .immediate=0, .flags=0x80, .name = "<1.5!>" },
  { .ov = -1, .code = 0x0f85, .word = 0x4cff, .immediate=0, .flags=0x80, .name = "<+!>" },
  { .ov = -1, .code = 0x0c24, .word = 0x4d08, .immediate=0, .flags=0x80, .name = "<D!>" },
  { .ov = -1, .code = 0x3af8, .word = 0x4d12, .immediate=1, .flags=0x80, .name = "<OFF>" },
  { .ov = -1, .code = 0x3af8, .word = 0x4d1d, .immediate=1, .flags=0x80, .name = "<ON>" },
  { .ov = -1, .code = 0x3af8, .word = 0x4d2b, .immediate=1, .flags=0x80, .name = "<BLOCK>" },
  { .ov = -1, .code = 0x1d29, .word = 0x4d39, .immediate=0, .flags=0x80, .name = "SPHEREW" },
  { .ov = -1, .code = 0x1d29, .word = 0x4d47, .immediate=0, .flags=0x80, .name = "SIGNEXT" },
  { .ov = -1, .code = 0x1d29, .word = 0x4d4b, .immediate=0, .flags=0x00, .name = "W4D4B" },
  { .ov = -1, .code = 0x1d29, .word = 0x4d4f, .immediate=0, .flags=0x00, .name = "W4D4F" },
  { .ov = -1, .code = 0x1d29, .word = 0x4d53, .immediate=0, .flags=0x00, .name = "W4D53" },
  { .ov = -1, .code = 0x1d29, .word = 0x4d60, .immediate=0, .flags=0x80, .name = "'ARRAY" },
  { .ov = -1, .code = 0x224c, .word = 0x4d6e, .immediate=0, .flags=0x80, .name = "ARRAYSE" },
  { .ov = -1, .code = 0x224c, .word = 0x4d83, .immediate=0, .flags=0x80, .name = "#BYTES" },
  { .ov = -1, .code = 0x224c, .word = 0x4d97, .immediate=0, .flags=0x80, .name = "#COLZ" },
  { .ov = -1, .code = 0x224c, .word = 0x4da9, .immediate=0, .flags=0x80, .name = "#ROWZ" },
  { .ov = -1, .code = 0x224c, .word = 0x4dbf, .immediate=0, .flags=0x80, .name = "ACELLAD" },
  { .ov = -1, .code = 0x4dcb, .word = 0x4dcb, .immediate=0, .flags=0x00, .name = "W4DCB" },
  { .ov = -1, .code = 0x224c, .word = 0x4df4, .immediate=0, .flags=0x80, .name = "A!" },
  { .ov = -1, .code = 0x224c, .word = 0x4e01, .immediate=0, .flags=0x80, .name = "A@" },
  { .ov = -1, .code = 0x4e13, .word = 0x4e13, .immediate=0, .flags=0x80, .name = "!OFFSETS" },
  { .ov = -1, .code = 0x224c, .word = 0x4e49, .immediate=0, .flags=0x80, .name = "ARRAY" },
  { .ov = -1, .code = 0x224c, .word = 0x4e82, .immediate=0, .flags=0x80, .name = "SETLARR" },
  { .ov = -1, .code = 0x1d29, .word = 0x4eb8, .immediate=0, .flags=0x80, .name = "XLL" },
  { .ov = -1, .code = 0x1d29, .word = 0x4ec2, .immediate=0, .flags=0x80, .name = "YLL" },
  { .ov = -1, .code = 0x1d29, .word = 0x4ecc, .immediate=0, .flags=0x80, .name = "XUR" },
  { .ov = -1, .code = 0x1d29, .word = 0x4ed6, .immediate=0, .flags=0x80, .name = "YUR" },
  { .ov = -1, .code = 0x224c, .word = 0x4ee4, .immediate=0, .flags=0x80, .name = "FULLARR" },
  { .ov = -1, .code = 0x224c, .word = 0x4efe, .immediate=0, .flags=0x80, .name = "SETREGI" },
  { .ov = -1, .code = 0x224c, .word = 0x4f1c, .immediate=0, .flags=0x80, .name = "FILLREG" },
  { .ov = -1, .code = 0x1d29, .word = 0x4f54, .immediate=0, .flags=0x80, .name = "FONT#" },
  { .ov = -1, .code = 0x1d29, .word = 0x4f60, .immediate=0, .flags=0x80, .name = "TANDY" },
  { .ov = -1, .code = 0x1d29, .word = 0x4f6d, .immediate=0, .flags=0x80, .name = "COLORT" },
  { .ov = -1, .code = 0x224c, .word = 0x4f86, .immediate=0, .flags=0x80, .name = "I>C" },
  { .ov = -1, .code = 0x224c, .word = 0x4f90, .immediate=0, .flags=0x00, .name = "W4F90" },
  { .ov = -1, .code = 0x4f96, .word = 0x4fa9, .immediate=0, .flags=0x80, .name = "BLACK" },
  { .ov = -1, .code = 0x4f96, .word = 0x4fb6, .immediate=0, .flags=0x80, .name = "DK-BLUE" },
  { .ov = -1, .code = 0x4f96, .word = 0x4fc3, .immediate=0, .flags=0x80, .name = "DK-GREE" },
  { .ov = -1, .code = 0x4f96, .word = 0x4fce, .immediate=0, .flags=0x80, .name = "GREEN" },
  { .ov = -1, .code = 0x4f96, .word = 0x4fd7, .immediate=0, .flags=0x80, .name = "RED" },
  { .ov = -1, .code = 0x4f96, .word = 0x4fe3, .immediate=0, .flags=0x80, .name = "VIOLET" },
  { .ov = -1, .code = 0x4f96, .word = 0x4fee, .immediate=0, .flags=0x80, .name = "BROWN" },
  { .ov = -1, .code = 0x4f96, .word = 0x4ff9, .immediate=0, .flags=0x80, .name = "GREY1" },
  { .ov = -1, .code = 0x4f96, .word = 0x5004, .immediate=0, .flags=0x80, .name = "GREY2" },
  { .ov = -1, .code = 0x4f96, .word = 0x500e, .immediate=0, .flags=0x80, .name = "BLUE" },
  { .ov = -1, .code = 0x4f96, .word = 0x501b, .immediate=0, .flags=0x80, .name = "LT-GREE" },
  { .ov = -1, .code = 0x4f96, .word = 0x5028, .immediate=0, .flags=0x80, .name = "LT-BLUE" },
  { .ov = -1, .code = 0x4f96, .word = 0x5032, .immediate=0, .flags=0x80, .name = "PINK" },
  { .ov = -1, .code = 0x4f96, .word = 0x503e, .immediate=0, .flags=0x80, .name = "ORANGE" },
  { .ov = -1, .code = 0x4f96, .word = 0x504a, .immediate=0, .flags=0x80, .name = "YELLOW" },
  { .ov = -1, .code = 0x4f96, .word = 0x5055, .immediate=0, .flags=0x80, .name = "WHITE" },
  { .ov = -1, .code = 0x1d29, .word = 0x505f, .immediate=0, .flags=0x80, .name = "?NID" },
  { .ov = -1, .code = 0x1d29, .word = 0x506a, .immediate=0, .flags=0x80, .name = "BMAP" },
  { .ov = -1, .code = 0x224c, .word = 0x507a, .immediate=0, .flags=0x00, .name = "W507A" },
  { .ov = -1, .code = 0x224c, .word = 0x508a, .immediate=0, .flags=0x80, .name = "BMOFF" },
  { .ov = -1, .code = 0x224c, .word = 0x509a, .immediate=0, .flags=0x80, .name = "BMSEG" },
  { .ov = -1, .code = 0x224c, .word = 0x50ab, .immediate=0, .flags=0x80, .name = "BMWIDE" },
  { .ov = -1, .code = 0x224c, .word = 0x50bd, .immediate=0, .flags=0x80, .name = "BMBYTES" },
  { .ov = -1, .code = 0x224c, .word = 0x50d0, .immediate=0, .flags=0x80, .name = "BMHIGH" },
  { .ov = -1, .code = 0x224c, .word = 0x50e2, .immediate=0, .flags=0x80, .name = "BMPAL" },
  { .ov = -1, .code = 0x2214, .word = 0x50f6, .immediate=0, .flags=0x80, .name = "IHEADLE" },
  { .ov = -1, .code = 0x2214, .word = 0x50fa, .immediate=0, .flags=0x00, .name = "W50FA" },
  { .ov = -1, .code = 0x2214, .word = 0x50fe, .immediate=0, .flags=0x00, .name = "W50FE" },
  { .ov = -1, .code = 0x2214, .word = 0x5102, .immediate=0, .flags=0x00, .name = "W5102" },
  { .ov = -1, .code = 0x2214, .word = 0x5110, .immediate=0, .flags=0x80, .name = "*MAPSCA" },
  { .ov = -1, .code = 0x2214, .word = 0x511d, .immediate=0, .flags=0x80, .name = "SIGBLK" },
  { .ov = -1, .code = 0x2214, .word = 0x512a, .immediate=0, .flags=0x80, .name = "ALOVSA" },
  { .ov = -1, .code = 0x2214, .word = 0x5137, .immediate=0, .flags=0x80, .name = "AHIVSA" },
  { .ov = -1, .code = 0x2214, .word = 0x5144, .immediate=0, .flags=0x80, .name = "BLOVSA" },
  { .ov = -1, .code = 0x2214, .word = 0x5151, .immediate=0, .flags=0x80, .name = "BHIVSA" },
  { .ov = -1, .code = 0x2214, .word = 0x515f, .immediate=0, .flags=0x80, .name = "'OVBACK" },
  { .ov = -1, .code = 0x2214, .word = 0x516c, .immediate=0, .flags=0x80, .name = "MUSSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5176, .immediate=0, .flags=0x80, .name = "WIN" },
  { .ov = -1, .code = 0x2214, .word = 0x5184, .immediate=0, .flags=0x80, .name = "?FIRED-" },
  { .ov = -1, .code = 0x2214, .word = 0x5192, .immediate=0, .flags=0x80, .name = "?A-SHIE" },
  { .ov = -1, .code = 0x2214, .word = 0x51a0, .immediate=0, .flags=0x80, .name = "?A-WEAP" },
  { .ov = -1, .code = 0x2214, .word = 0x51aa, .immediate=0, .flags=0x80, .name = "16K" },
  { .ov = -1, .code = 0x3b74, .word = 0x51b8, .immediate=0, .flags=0x80, .name = "DBUF-SI" },
  { .ov = -1, .code = 0x2214, .word = 0x51c5, .immediate=0, .flags=0x80, .name = "TRUE" },
  { .ov = -1, .code = 0x2214, .word = 0x51d1, .immediate=0, .flags=0x80, .name = "FALSE" },
  { .ov = -1, .code = 0x1d29, .word = 0x51db, .immediate=0, .flags=0x80, .name = "?UF" },
  { .ov = -1, .code = 0x1d29, .word = 0x51e5, .immediate=0, .flags=0x80, .name = "?AF" },
  { .ov = -1, .code = 0x1d29, .word = 0x51f2, .immediate=0, .flags=0x80, .name = "#SHOTS" },
  { .ov = -1, .code = 0x1d29, .word = 0x51fe, .immediate=0, .flags=0x80, .name = "'ASYS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5208, .immediate=0, .flags=0x80, .name = "P/B" },
  { .ov = -1, .code = 0x1d29, .word = 0x5214, .immediate=0, .flags=0x80, .name = "'BOSS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5220, .immediate=0, .flags=0x80, .name = "%TALK" },
  { .ov = -1, .code = 0x2214, .word = 0x522e, .immediate=0, .flags=0x80, .name = "NULL-IC" },
  { .ov = -1, .code = 0x2214, .word = 0x523c, .immediate=0, .flags=0x80, .name = "SYS-ICO" },
  { .ov = -1, .code = 0x2214, .word = 0x524a, .immediate=0, .flags=0x80, .name = "INVIS-I" },
  { .ov = -1, .code = 0x2214, .word = 0x5258, .immediate=0, .flags=0x80, .name = "FLUX-IC" },
  { .ov = -1, .code = 0x2214, .word = 0x5266, .immediate=0, .flags=0x80, .name = "DEAD-IC" },
  { .ov = -1, .code = 0x2214, .word = 0x5274, .immediate=0, .flags=0x80, .name = "DEFAULT" },
  { .ov = -1, .code = 0x2214, .word = 0x5282, .immediate=0, .flags=0x80, .name = "TEXTC/L" },
  { .ov = -1, .code = 0x2214, .word = 0x5286, .immediate=0, .flags=0x00, .name = "W5286" },
  { .ov = -1, .code = 0x2214, .word = 0x5294, .immediate=0, .flags=0x80, .name = "FUEL/SE" },
  { .ov = -1, .code = 0x2214, .word = 0x52a2, .immediate=0, .flags=0x80, .name = "POLYSEG" },
  { .ov = -1, .code = 0x2214, .word = 0x52af, .immediate=0, .flags=0x80, .name = "'ANSYS" },
  { .ov = -1, .code = 0x2214, .word = 0x52bd, .immediate=0, .flags=0x80, .name = "?CALLED" },
  { .ov = -1, .code = 0x3b74, .word = 0x52c6, .immediate=0, .flags=0x80, .name = "0." },
  { .ov = -1, .code = 0x3b74, .word = 0x52d6, .immediate=0, .flags=0x80, .name = "VANEWSP" },
  { .ov = -1, .code = 0x3b74, .word = 0x52e4, .immediate=0, .flags=0x80, .name = "IROOT" },
  { .ov = -1, .code = 0x3b74, .word = 0x52f4, .immediate=0, .flags=0x80, .name = "INACTIV" },
  { .ov = -1, .code = 0x3b74, .word = 0x5304, .immediate=0, .flags=0x80, .name = "FRAGMEN" },
  { .ov = -1, .code = 0x3b74, .word = 0x5312, .immediate=0, .flags=0x80, .name = "*SECS" },
  { .ov = -1, .code = 0x3b74, .word = 0x5322, .immediate=0, .flags=0x80, .name = "*ASSIGN" },
  { .ov = -1, .code = 0x3b74, .word = 0x5330, .immediate=0, .flags=0x80, .name = "*SHIP" },
  { .ov = -1, .code = 0x3b74, .word = 0x533e, .immediate=0, .flags=0x80, .name = "*ASYS" },
  { .ov = -1, .code = 0x3b74, .word = 0x534c, .immediate=0, .flags=0x80, .name = "*ARTH" },
  { .ov = -1, .code = 0x3b74, .word = 0x535c, .immediate=0, .flags=0x80, .name = "*ARREST" },
  { .ov = -1, .code = 0x3b74, .word = 0x5368, .immediate=0, .flags=0x80, .name = "*HL" },
  { .ov = -1, .code = 0x3b74, .word = 0x5374, .immediate=0, .flags=0x80, .name = "*LH" },
  { .ov = -1, .code = 0x3b74, .word = 0x5380, .immediate=0, .flags=0x80, .name = "*GD" },
  { .ov = -1, .code = 0x3b74, .word = 0x538f, .immediate=0, .flags=0x80, .name = "*4SALE" },
  { .ov = -1, .code = 0x3b74, .word = 0x539d, .immediate=0, .flags=0x80, .name = "*2BUY" },
  { .ov = -1, .code = 0x2214, .word = 0x53a9, .immediate=0, .flags=0x80, .name = "MPS" },
  { .ov = -1, .code = 0x3b74, .word = 0x53b7, .immediate=0, .flags=0x80, .name = "BOX-IAD" },
  { .ov = -1, .code = 0x3b74, .word = 0x53c5, .immediate=0, .flags=0x80, .name = "*DICT" },
  { .ov = -1, .code = 0x1d29, .word = 0x53d5, .immediate=0, .flags=0x80, .name = "CLIP-TA" },
  { .ov = -1, .code = 0x224c, .word = 0x53f3, .immediate=0, .flags=0x80, .name = "TABLE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5410, .immediate=0, .flags=0x80, .name = "FONTSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x541d, .immediate=0, .flags=0x80, .name = "REMSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x542b, .immediate=0, .flags=0x80, .name = "XBUF-SE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5436, .immediate=0, .flags=0x80, .name = "DICT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5441, .immediate=0, .flags=0x80, .name = "?ALL" },
  { .ov = -1, .code = 0x1d29, .word = 0x544c, .immediate=0, .flags=0x80, .name = "?YOK" },
  { .ov = -1, .code = 0x1d29, .word = 0x5456, .immediate=0, .flags=0x80, .name = "HUB" },
  { .ov = -1, .code = 0x1d29, .word = 0x5461, .immediate=0, .flags=0x80, .name = "PIC#" },
  { .ov = -1, .code = 0x1d29, .word = 0x546d, .immediate=0, .flags=0x80, .name = "1LOGO" },
  { .ov = -1, .code = 0x1d29, .word = 0x547d, .immediate=0, .flags=0x00, .name = "W547D" },
  { .ov = -1, .code = 0x1d29, .word = 0x5489, .immediate=0, .flags=0x00, .name = "W5489" },
  { .ov = -1, .code = 0x1d29, .word = 0x5491, .immediate=0, .flags=0x00, .name = "W5491" },
  { .ov = -1, .code = 0x1d29, .word = 0x549e, .immediate=0, .flags=0x80, .name = "'XCOMM" },
  { .ov = -1, .code = 0x1d29, .word = 0x54a9, .immediate=0, .flags=0x80, .name = "TCLR" },
  { .ov = -1, .code = 0x1d29, .word = 0x54b5, .immediate=0, .flags=0x80, .name = "'TRAK" },
  { .ov = -1, .code = 0x1d29, .word = 0x54c3, .immediate=0, .flags=0x80, .name = "TRAK-HR" },
  { .ov = -1, .code = 0x1d29, .word = 0x54d1, .immediate=0, .flags=0x80, .name = "A-STREN" },
  { .ov = -1, .code = 0x1d29, .word = 0x54de, .immediate=0, .flags=0x80, .name = "DIRBLK" },
  { .ov = -1, .code = 0x1d29, .word = 0x54ec, .immediate=0, .flags=0x80, .name = "TIMESTA" },
  { .ov = -1, .code = 0x1d29, .word = 0x54fa, .immediate=0, .flags=0x80, .name = "RELAXTI" },
  { .ov = -1, .code = 0x7420, .word = 0x54fc, .immediate=0, .flags=0x00, .name = "W54FC" },
  { .ov = -1, .code = 0x1d29, .word = 0x5508, .immediate=0, .flags=0x80, .name = "):-,601" },
  { .ov = -1, .code = 0x1d29, .word = 0x5518, .immediate=0, .flags=0x80, .name = "ICONFON" },
  { .ov = -1, .code = 0x1d29, .word = 0x5525, .immediate=0, .flags=0x80, .name = "LFRAME" },
  { .ov = -1, .code = 0x1d29, .word = 0x5531, .immediate=0, .flags=0x80, .name = "?AUTO" },
  { .ov = -1, .code = 0x1d29, .word = 0x553f, .immediate=0, .flags=0x80, .name = "?CRITIC" },
  { .ov = -1, .code = 0x1d29, .word = 0x554d, .immediate=0, .flags=0x80, .name = "P-POSTU" },
  { .ov = -1, .code = 0x1d29, .word = 0x555b, .immediate=0, .flags=0x80, .name = "ELEM-AM" },
  { .ov = -1, .code = 0x1d29, .word = 0x5569, .immediate=0, .flags=0x80, .name = "'INJURE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5577, .immediate=0, .flags=0x80, .name = "P-COLOR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5586, .immediate=0, .flags=0x80, .name = "P-PHRAS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5594, .immediate=0, .flags=0x80, .name = "P-CARP" },
  { .ov = -1, .code = 0x1d29, .word = 0x55a3, .immediate=0, .flags=0x80, .name = "O-COLOR" },
  { .ov = -1, .code = 0x1d29, .word = 0x55b0, .immediate=0, .flags=0x80, .name = "HYDRO" },
  { .ov = -1, .code = 0x1d29, .word = 0x55bb, .immediate=0, .flags=0x80, .name = "ATMO" },
  { .ov = -1, .code = 0x1d29, .word = 0x55c8, .immediate=0, .flags=0x80, .name = "LCOLOR" },
  { .ov = -1, .code = 0x1d29, .word = 0x55d2, .immediate=0, .flags=0x80, .name = "?TV" },
  { .ov = -1, .code = 0x1d29, .word = 0x55de, .immediate=0, .flags=0x80, .name = "OLDHR" },
  { .ov = -1, .code = 0x1d29, .word = 0x55ea, .immediate=0, .flags=0x80, .name = "AVCNT" },
  { .ov = -1, .code = 0x1d29, .word = 0x55ee, .immediate=0, .flags=0x00, .name = "W55EE" },
  { .ov = -1, .code = 0x1d29, .word = 0x55fa, .immediate=0, .flags=0x80, .name = "?BOMB" },
  { .ov = -1, .code = 0x1d29, .word = 0x55ff, .immediate=0, .flags=0x00, .name = "W55FF" },
  { .ov = -1, .code = 0x1d29, .word = 0x5603, .immediate=0, .flags=0x00, .name = "W5603" },
  { .ov = -1, .code = 0x1d29, .word = 0x5607, .immediate=0, .flags=0x00, .name = "W5607" },
  { .ov = -1, .code = 0x1d29, .word = 0x5613, .immediate=0, .flags=0x80, .name = "FILE#" },
  { .ov = -1, .code = 0x1d29, .word = 0x5621, .immediate=0, .flags=0x80, .name = "RECORD#" },
  { .ov = -1, .code = 0x1d29, .word = 0x5625, .immediate=0, .flags=0x00, .name = "W5625" },
  { .ov = -1, .code = 0x1d29, .word = 0x5629, .immediate=0, .flags=0x00, .name = "W5629" },
  { .ov = -1, .code = 0x1d29, .word = 0x5634, .immediate=0, .flags=0x80, .name = "CXSP" },
  { .ov = -1, .code = 0x1d29, .word = 0x5638, .immediate=0, .flags=0x00, .name = "W5638" },
  { .ov = -1, .code = 0x1d29, .word = 0x563c, .immediate=0, .flags=0x00, .name = "W563C" },
  { .ov = -1, .code = 0x1d29, .word = 0x5646, .immediate=0, .flags=0x80, .name = "EDL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5654, .immediate=0, .flags=0x80, .name = "A-POSTU" },
  { .ov = -1, .code = 0x1d29, .word = 0x5658, .immediate=0, .flags=0x00, .name = "W5658" },
  { .ov = -1, .code = 0x1d29, .word = 0x5666, .immediate=0, .flags=0x80, .name = "P-RACES" },
  { .ov = -1, .code = 0x1d29, .word = 0x566a, .immediate=0, .flags=0x00, .name = "W566A" },
  { .ov = -1, .code = 0x1d29, .word = 0x566e, .immediate=0, .flags=0x00, .name = "W566E" },
  { .ov = -1, .code = 0x1d29, .word = 0x5672, .immediate=0, .flags=0x00, .name = "W5672" },
  { .ov = -1, .code = 0x1d29, .word = 0x5676, .immediate=0, .flags=0x00, .name = "W5676" },
  { .ov = -1, .code = 0x1d29, .word = 0x567a, .immediate=0, .flags=0x00, .name = "W567A" },
  { .ov = -1, .code = 0x1d29, .word = 0x5688, .immediate=0, .flags=0x80, .name = "'THROW-" },
  { .ov = -1, .code = 0x1d29, .word = 0x5693, .immediate=0, .flags=0x80, .name = "'MAP" },
  { .ov = -1, .code = 0x1d29, .word = 0x56a1, .immediate=0, .flags=0x80, .name = "'TRAVER" },
  { .ov = -1, .code = 0x1d29, .word = 0x56ae, .immediate=0, .flags=0x80, .name = "'?EXIT" },
  { .ov = -1, .code = 0x1d29, .word = 0x56b2, .immediate=0, .flags=0x00, .name = "W56B2" },
  { .ov = -1, .code = 0x1d29, .word = 0x56c0, .immediate=0, .flags=0x80, .name = "'.FLUX-" },
  { .ov = -1, .code = 0x1d29, .word = 0x56ca, .immediate=0, .flags=0x80, .name = "?TD" },
  { .ov = -1, .code = 0x1d29, .word = 0x56d8, .immediate=0, .flags=0x80, .name = "?LANDED" },
  { .ov = -1, .code = 0x1d29, .word = 0x56dc, .immediate=0, .flags=0x00, .name = "W56DC" },
  { .ov = -1, .code = 0x1d29, .word = 0x56e0, .immediate=0, .flags=0x00, .name = "W56E0" },
  { .ov = -1, .code = 0x1d29, .word = 0x56e4, .immediate=0, .flags=0x00, .name = "W56E4" },
  { .ov = -1, .code = 0x1d29, .word = 0x56e8, .immediate=0, .flags=0x00, .name = "W56E8" },
  { .ov = -1, .code = 0x1d29, .word = 0x56ec, .immediate=0, .flags=0x00, .name = "W56EC" },
  { .ov = -1, .code = 0x1d29, .word = 0x56f0, .immediate=0, .flags=0x00, .name = "W56F0" },
  { .ov = -1, .code = 0x1d29, .word = 0x56f4, .immediate=0, .flags=0x00, .name = "W56F4" },
  { .ov = -1, .code = 0x1d29, .word = 0x56f8, .immediate=0, .flags=0x00, .name = "W56F8" },
  { .ov = -1, .code = 0x1d29, .word = 0x5703, .immediate=0, .flags=0x80, .name = "-END" },
  { .ov = -1, .code = 0x1d29, .word = 0x570d, .immediate=0, .flags=0x80, .name = "OV#" },
  { .ov = -1, .code = 0x1d29, .word = 0x5711, .immediate=0, .flags=0x00, .name = "W5711" },
  { .ov = -1, .code = 0x1d29, .word = 0x571f, .immediate=0, .flags=0x80, .name = "REPAIRT" },
  { .ov = -1, .code = 0x1d29, .word = 0x572d, .immediate=0, .flags=0x80, .name = "HBUF-SE" },
  { .ov = -1, .code = 0x1d29, .word = 0x573b, .immediate=0, .flags=0x80, .name = "DBUF-SE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5747, .immediate=0, .flags=0x80, .name = "COLOR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5754, .immediate=0, .flags=0x80, .name = "DCOLOR" },
  { .ov = -1, .code = 0x1d29, .word = 0x575f, .immediate=0, .flags=0x80, .name = "YTAB" },
  { .ov = -1, .code = 0x1d29, .word = 0x5768, .immediate=0, .flags=0x80, .name = "Y1" },
  { .ov = -1, .code = 0x1d29, .word = 0x5771, .immediate=0, .flags=0x80, .name = "X1" },
  { .ov = -1, .code = 0x1d29, .word = 0x577a, .immediate=0, .flags=0x80, .name = "Y2" },
  { .ov = -1, .code = 0x1d29, .word = 0x5783, .immediate=0, .flags=0x80, .name = "X2" },
  { .ov = -1, .code = 0x1d29, .word = 0x578f, .immediate=0, .flags=0x80, .name = "YTABL" },
  { .ov = -1, .code = 0x1d29, .word = 0x579d, .immediate=0, .flags=0x80, .name = "BUF-SEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x57aa, .immediate=0, .flags=0x80, .name = "RETURN" },
  { .ov = -1, .code = 0x1d29, .word = 0x57b5, .immediate=0, .flags=0x80, .name = "?WIN" },
  { .ov = -1, .code = 0x1d29, .word = 0x57bf, .immediate=0, .flags=0x80, .name = "#IN" },
  { .ov = -1, .code = 0x1d29, .word = 0x57ca, .immediate=0, .flags=0x80, .name = "#OUT" },
  { .ov = -1, .code = 0x1d29, .word = 0x57d4, .immediate=0, .flags=0x80, .name = "VIN" },
  { .ov = -1, .code = 0x1d29, .word = 0x57df, .immediate=0, .flags=0x80, .name = "VOUT" },
  { .ov = -1, .code = 0x1d29, .word = 0x57e9, .immediate=0, .flags=0x80, .name = "OIN" },
  { .ov = -1, .code = 0x1d29, .word = 0x57f4, .immediate=0, .flags=0x80, .name = "OOUT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5800, .immediate=0, .flags=0x80, .name = "IVPTR" },
  { .ov = -1, .code = 0x1d29, .word = 0x580c, .immediate=0, .flags=0x80, .name = "OVPTR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5818, .immediate=0, .flags=0x80, .name = "ICPTR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5824, .immediate=0, .flags=0x80, .name = "OCPTR" },
  { .ov = -1, .code = 0x1d29, .word = 0x582f, .immediate=0, .flags=0x80, .name = "FLIP" },
  { .ov = -1, .code = 0x1d29, .word = 0x583c, .immediate=0, .flags=0x80, .name = "TACCPT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5848, .immediate=0, .flags=0x80, .name = "TRJCT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5854, .immediate=0, .flags=0x80, .name = "?OPEN" },
  { .ov = -1, .code = 0x1d29, .word = 0x5860, .immediate=0, .flags=0x80, .name = "?EVAL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5869, .immediate=0, .flags=0x80, .name = "SX" },
  { .ov = -1, .code = 0x1d29, .word = 0x5872, .immediate=0, .flags=0x80, .name = "SY" },
  { .ov = -1, .code = 0x1d29, .word = 0x587b, .immediate=0, .flags=0x80, .name = "SO" },
  { .ov = -1, .code = 0x1d29, .word = 0x5884, .immediate=0, .flags=0x80, .name = "PX" },
  { .ov = -1, .code = 0x1d29, .word = 0x588d, .immediate=0, .flags=0x80, .name = "PY" },
  { .ov = -1, .code = 0x1d29, .word = 0x5896, .immediate=0, .flags=0x80, .name = "PO" },
  { .ov = -1, .code = 0x1d29, .word = 0x589f, .immediate=0, .flags=0x80, .name = "IX" },
  { .ov = -1, .code = 0x1d29, .word = 0x58a8, .immediate=0, .flags=0x80, .name = "IY" },
  { .ov = -1, .code = 0x1d29, .word = 0x58b1, .immediate=0, .flags=0x80, .name = "IO" },
  { .ov = -1, .code = 0x1d29, .word = 0x58bf, .immediate=0, .flags=0x80, .name = "COMPARE" },
  { .ov = -1, .code = 0x1d29, .word = 0x58cd, .immediate=0, .flags=0x80, .name = "X-INTER" },
  { .ov = -1, .code = 0x1d29, .word = 0x58d9, .immediate=0, .flags=0x80, .name = "ILEFT" },
  { .ov = -1, .code = 0x1d29, .word = 0x58e6, .immediate=0, .flags=0x80, .name = "IRIGHT" },
  { .ov = -1, .code = 0x1d29, .word = 0x58f3, .immediate=0, .flags=0x80, .name = "IBELOW" },
  { .ov = -1, .code = 0x1d29, .word = 0x5900, .immediate=0, .flags=0x80, .name = "IABOVE" },
  { .ov = -1, .code = 0x1d29, .word = 0x590b, .immediate=0, .flags=0x80, .name = "'FLY" },
  { .ov = -1, .code = 0x1d29, .word = 0x5919, .immediate=0, .flags=0x80, .name = "'UNNEST" },
  { .ov = -1, .code = 0x1d29, .word = 0x5924, .immediate=0, .flags=0x80, .name = "?NEW" },
  { .ov = -1, .code = 0x1d29, .word = 0x5931, .immediate=0, .flags=0x80, .name = "FORCED" },
  { .ov = -1, .code = 0x1d29, .word = 0x593d, .immediate=0, .flags=0x80, .name = "#VESS" },
  { .ov = -1, .code = 0x1d29, .word = 0x594b, .immediate=0, .flags=0x80, .name = "CTCOLOR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5958, .immediate=0, .flags=0x80, .name = "XSTART" },
  { .ov = -1, .code = 0x1d29, .word = 0x5963, .immediate=0, .flags=0x80, .name = "XEND" },
  { .ov = -1, .code = 0x1d29, .word = 0x596f, .immediate=0, .flags=0x80, .name = "YLINE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5978, .immediate=0, .flags=0x80, .name = "?3" },
  { .ov = -1, .code = 0x1d29, .word = 0x5985, .immediate=0, .flags=0x80, .name = "'.HUFF" },
  { .ov = -1, .code = 0x1d29, .word = 0x5990, .immediate=0, .flags=0x80, .name = "SCAN" },
  { .ov = -1, .code = 0x1d29, .word = 0x599b, .immediate=0, .flags=0x80, .name = "LMNT" },
  { .ov = -1, .code = 0x1d29, .word = 0x59a7, .immediate=0, .flags=0x80, .name = "SCAN+" },
  { .ov = -1, .code = 0x1d29, .word = 0x59b2, .immediate=0, .flags=0x80, .name = "YMIN" },
  { .ov = -1, .code = 0x1d29, .word = 0x59bd, .immediate=0, .flags=0x80, .name = "YMAX" },
  { .ov = -1, .code = 0x1d29, .word = 0x59ca, .immediate=0, .flags=0x80, .name = "#HORIZ" },
  { .ov = -1, .code = 0x1d29, .word = 0x59d6, .immediate=0, .flags=0x80, .name = "MOVED" },
  { .ov = -1, .code = 0x1d29, .word = 0x59e3, .immediate=0, .flags=0x80, .name = "MEMSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x59f0, .immediate=0, .flags=0x80, .name = "MEMOFF" },
  { .ov = -1, .code = 0x1d29, .word = 0x59fe, .immediate=0, .flags=0x80, .name = "MONITOR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a0c, .immediate=0, .flags=0x80, .name = "LOCRADI" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a1a, .immediate=0, .flags=0x80, .name = "(ELIST)" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a27, .immediate=0, .flags=0x80, .name = "ICON^" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a32, .immediate=0, .flags=0x80, .name = "PAL^" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a3d, .immediate=0, .flags=0x80, .name = "YBLT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a48, .immediate=0, .flags=0x80, .name = "XBLT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a56, .immediate=0, .flags=0x80, .name = "XORMODE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a61, .immediate=0, .flags=0x80, .name = "LBLT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a6c, .immediate=0, .flags=0x80, .name = "WBLT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a77, .immediate=0, .flags=0x80, .name = "ABLT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a84, .immediate=0, .flags=0x80, .name = "BLTSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a8f, .immediate=0, .flags=0x80, .name = "BLT>" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a9d, .immediate=0, .flags=0x80, .name = "TILE-PT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5aab, .immediate=0, .flags=0x80, .name = "?FUEL-D" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ab9, .immediate=0, .flags=0x80, .name = "?G-AWAR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ac3, .immediate=0, .flags=0x80, .name = "GWF" },
  { .ov = -1, .code = 0x1d29, .word = 0x5acf, .immediate=0, .flags=0x80, .name = "DXVIS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5adb, .immediate=0, .flags=0x80, .name = "DYVIS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ae6, .immediate=0, .flags=0x80, .name = "XCON" },
  { .ov = -1, .code = 0x1d29, .word = 0x5af1, .immediate=0, .flags=0x80, .name = "YCON" },
  { .ov = -1, .code = 0x1d29, .word = 0x5afd, .immediate=0, .flags=0x80, .name = "DXCON" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b09, .immediate=0, .flags=0x80, .name = "DYCON" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b14, .immediate=0, .flags=0x80, .name = "XVIS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b1f, .immediate=0, .flags=0x80, .name = "YVIS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b2d, .immediate=0, .flags=0x80, .name = "XLLDEST" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b3b, .immediate=0, .flags=0x80, .name = "YLLDEST" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b49, .immediate=0, .flags=0x80, .name = "GLOBALS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b56, .immediate=0, .flags=0x80, .name = "'.CELL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b64, .immediate=0, .flags=0x80, .name = "'.BACKG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b72, .immediate=0, .flags=0x80, .name = "'ICON-P" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b80, .immediate=0, .flags=0x80, .name = "'ICONBO" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b8a, .immediate=0, .flags=0x80, .name = "'CC" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b8e, .immediate=0, .flags=0x00, .name = "W5B8E" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b92, .immediate=0, .flags=0x00, .name = "W5B92" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b96, .immediate=0, .flags=0x00, .name = "W5B96" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b9a, .immediate=0, .flags=0x00, .name = "W5B9A" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b9e, .immediate=0, .flags=0x00, .name = "W5B9E" },
  { .ov = -1, .code = 0x1d29, .word = 0x5baa, .immediate=0, .flags=0x80, .name = "IHSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5bb8, .immediate=0, .flags=0x80, .name = "IGLOBAL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5bc5, .immediate=0, .flags=0x80, .name = "ILOCAL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5bd2, .immediate=0, .flags=0x80, .name = "IINDEX" },
  { .ov = -1, .code = 0x1d29, .word = 0x5bdd, .immediate=0, .flags=0x80, .name = "XWLL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5be8, .immediate=0, .flags=0x80, .name = "YWLL" },
  { .ov = -1, .code = 0x7420, .word = 0x5bea, .immediate=0, .flags=0x00, .name = "W5BEA" },
  { .ov = -1, .code = 0x1d29, .word = 0x5bf3, .immediate=0, .flags=0x80, .name = "XWUR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5bfe, .immediate=0, .flags=0x80, .name = "YWUR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c0c, .immediate=0, .flags=0x80, .name = "*GLOBAL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c1a, .immediate=0, .flags=0x80, .name = "(STOP-C" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c1e, .immediate=0, .flags=0x00, .name = "W5C1E" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c2c, .immediate=0, .flags=0x80, .name = "CONTEXT_3" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c37, .immediate=0, .flags=0x80, .name = "%EFF" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c43, .immediate=0, .flags=0x80, .name = "STORM" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c4e, .immediate=0, .flags=0x80, .name = "'TVT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c5b, .immediate=0, .flags=0x80, .name = "'STORM" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c65, .immediate=0, .flags=0x80, .name = "E/M" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c73, .immediate=0, .flags=0x80, .name = "FORCEPT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c80, .immediate=0, .flags=0x80, .name = "#STORM" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c84, .immediate=0, .flags=0x00, .name = "W5C84" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c88, .immediate=0, .flags=0x00, .name = "W5C88" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c8c, .immediate=0, .flags=0x00, .name = "W5C8C" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c90, .immediate=0, .flags=0x00, .name = "W5C90" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c9e, .immediate=0, .flags=0x80, .name = "PORTDAT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5caa, .immediate=0, .flags=0x80, .name = "?PORT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5cb5, .immediate=0, .flags=0x80, .name = "TVIS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5cc0, .immediate=0, .flags=0x80, .name = "RVIS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ccb, .immediate=0, .flags=0x80, .name = "BVIS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5cd6, .immediate=0, .flags=0x80, .name = "LVIS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ce2, .immediate=0, .flags=0x80, .name = "LFSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5cef, .immediate=0, .flags=0x80, .name = "LSYSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5cfc, .immediate=0, .flags=0x80, .name = "MSYSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d09, .immediate=0, .flags=0x80, .name = "SSYSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d17, .immediate=0, .flags=0x80, .name = "?REPAIR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d23, .immediate=0, .flags=0x80, .name = "?HEAL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d2f, .immediate=0, .flags=0x80, .name = "MXNEB" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d3d, .immediate=0, .flags=0x80, .name = "THIS-BU" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d48, .immediate=0, .flags=0x80, .name = "NCRS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d53, .immediate=0, .flags=0x80, .name = "OCRS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d5e, .immediate=0, .flags=0x80, .name = "WTOP" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d6c, .immediate=0, .flags=0x80, .name = "WBOTTOM" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d79, .immediate=0, .flags=0x80, .name = "WRIGHT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d85, .immediate=0, .flags=0x80, .name = "WLEFT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d92, .immediate=0, .flags=0x80, .name = "WLINES" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d9f, .immediate=0, .flags=0x80, .name = "WCHARS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5dad, .immediate=0, .flags=0x80, .name = "SKIP2NE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5db8, .immediate=0, .flags=0x80, .name = "-AIN" },
  { .ov = -1, .code = 0x1d29, .word = 0x5dc6, .immediate=0, .flags=0x80, .name = "'LAUNCH" },
  { .ov = -1, .code = 0x1d29, .word = 0x5dd4, .immediate=0, .flags=0x80, .name = "?ON-PLA" },
  { .ov = -1, .code = 0x1d29, .word = 0x5de2, .immediate=0, .flags=0x80, .name = "?RECALL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ded, .immediate=0, .flags=0x80, .name = "WMSG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5df7, .immediate=0, .flags=0x80, .name = "CTX" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e01, .immediate=0, .flags=0x80, .name = "CTY" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e0d, .immediate=0, .flags=0x80, .name = "FTRIG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e19, .immediate=0, .flags=0x80, .name = "FQUIT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e24, .immediate=0, .flags=0x80, .name = "LKEY" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e32, .immediate=0, .flags=0x80, .name = "'BUTTON" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e40, .immediate=0, .flags=0x80, .name = "BTN-REC" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e4e, .immediate=0, .flags=0x80, .name = "CRSCOLO" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e52, .immediate=0, .flags=0x00, .name = "W5E52" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e5d, .immediate=0, .flags=0x80, .name = "?>OP" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e69, .immediate=0, .flags=0x80, .name = "'YANK" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e73, .immediate=0, .flags=0x80, .name = "?12" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e80, .immediate=0, .flags=0x80, .name = "'+VESS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e8b, .immediate=0, .flags=0x80, .name = "?NEB" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e99, .immediate=0, .flags=0x80, .name = "FORCEKE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ea4, .immediate=0, .flags=0x80, .name = "%VAL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5eb2, .immediate=0, .flags=0x80, .name = "SCROLL-" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ec0, .immediate=0, .flags=0x80, .name = "[#CACHE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ecd, .immediate=0, .flags=0x80, .name = "ESC-EN" },
  { .ov = -1, .code = 0x1d29, .word = 0x5edb, .immediate=0, .flags=0x80, .name = "ESC-PFA" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ee9, .immediate=0, .flags=0x80, .name = "LINE-CO" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ef6, .immediate=0, .flags=0x80, .name = "PM-PTR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5efa, .immediate=0, .flags=0x00, .name = "W5EFA" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f05, .immediate=0, .flags=0x80, .name = "SKEY" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f10, .immediate=0, .flags=0x80, .name = "#AUX" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f1b, .immediate=0, .flags=0x80, .name = "?EGA" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f26, .immediate=0, .flags=0x80, .name = "?5:(" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f31, .immediate=0, .flags=0x80, .name = "XABS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f3c, .immediate=0, .flags=0x80, .name = "YABS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f4a, .immediate=0, .flags=0x80, .name = "HEADING" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f56, .immediate=0, .flags=0x80, .name = "3DSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f61, .immediate=0, .flags=0x80, .name = "VIN'" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f6f, .immediate=0, .flags=0x80, .name = "YSCREEN" },
  { .ov = -1, .code = 0x7420, .word = 0x5f71, .immediate=0, .flags=0x00, .name = "W5F71" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f7d, .immediate=0, .flags=0x80, .name = "XSCREEN" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f8b, .immediate=0, .flags=0x80, .name = "'COMBAT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f97, .immediate=0, .flags=0x80, .name = "'CEX+" },
  { .ov = -1, .code = 0x1d29, .word = 0x5fa2, .immediate=0, .flags=0x80, .name = "'CEX" },
  { .ov = -1, .code = 0x1d29, .word = 0x5fad, .immediate=0, .flags=0x80, .name = "'WAX" },
  { .ov = -1, .code = 0x1d29, .word = 0x5fbb, .immediate=0, .flags=0x80, .name = "TERMINA" },
  { .ov = -1, .code = 0x1d29, .word = 0x5fc9, .immediate=0, .flags=0x80, .name = "?COMBAT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5fd7, .immediate=0, .flags=0x80, .name = "?ATTACK" },
  { .ov = -1, .code = 0x1d29, .word = 0x5fe2, .immediate=0, .flags=0x80, .name = "TBOX" },
  { .ov = -1, .code = 0x1d29, .word = 0x5fe6, .immediate=0, .flags=0x00, .name = "W5FE6" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ff4, .immediate=0, .flags=0x80, .name = "STAR-HR" },
  { .ov = -1, .code = 0x1d29, .word = 0x6002, .immediate=0, .flags=0x80, .name = "STARDAT" },
  { .ov = -1, .code = 0x1d29, .word = 0x6010, .immediate=0, .flags=0x80, .name = "TIME-PA" },
  { .ov = -1, .code = 0x1d29, .word = 0x601e, .immediate=0, .flags=0x80, .name = "#CLRMAP" },
  { .ov = -1, .code = 0x1d29, .word = 0x6029, .immediate=0, .flags=0x80, .name = "PLHI" },
  { .ov = -1, .code = 0x1d29, .word = 0x6037, .immediate=0, .flags=0x80, .name = "'PROCES" },
  { .ov = -1, .code = 0x1d29, .word = 0x6044, .immediate=0, .flags=0x80, .name = "CURSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x6052, .immediate=0, .flags=0x80, .name = "'SIMULA" },
  { .ov = -1, .code = 0x1d29, .word = 0x6060, .immediate=0, .flags=0x80, .name = "'ENDING" },
  { .ov = -1, .code = 0x1d29, .word = 0x606e, .immediate=0, .flags=0x80, .name = "[KEYINT" },
  { .ov = -1, .code = 0x1d29, .word = 0x6079, .immediate=0, .flags=0x80, .name = "SIL^" },
  { .ov = -1, .code = 0x1d29, .word = 0x6084, .immediate=0, .flags=0x80, .name = "PIC^" },
  { .ov = -1, .code = 0x1d29, .word = 0x6092, .immediate=0, .flags=0x80, .name = "'CLEANU" },
  { .ov = -1, .code = 0x1d29, .word = 0x60a0, .immediate=0, .flags=0x80, .name = "'KEY-CA" },
  { .ov = -1, .code = 0x1d29, .word = 0x60ae, .immediate=0, .flags=0x80, .name = "'.VITAL" },
  { .ov = -1, .code = 0x1d29, .word = 0x60bb, .immediate=0, .flags=0x80, .name = "'.DATE" },
  { .ov = -1, .code = 0x1d29, .word = 0x60c9, .immediate=0, .flags=0x80, .name = "'.VEHIC" },
  { .ov = -1, .code = 0x1d29, .word = 0x60d7, .immediate=0, .flags=0x80, .name = "'VEHICL" },
  { .ov = -1, .code = 0x1d29, .word = 0x60e5, .immediate=0, .flags=0x80, .name = "'CREW-C" },
  { .ov = -1, .code = 0x1d29, .word = 0x60f3, .immediate=0, .flags=0x80, .name = "'EXTERN" },
  { .ov = -1, .code = 0x1d29, .word = 0x6101, .immediate=0, .flags=0x80, .name = "'REPAIR" },
  { .ov = -1, .code = 0x1d29, .word = 0x610f, .immediate=0, .flags=0x80, .name = "'TREATM" },
  { .ov = -1, .code = 0x1d29, .word = 0x611d, .immediate=0, .flags=0x80, .name = "WEAPON-" },
  { .ov = -1, .code = 0x1d29, .word = 0x6129, .immediate=0, .flags=0x80, .name = "^CRIT" },
  { .ov = -1, .code = 0x1d29, .word = 0x6135, .immediate=0, .flags=0x80, .name = "?FLAT" },
  { .ov = -1, .code = 0x1d29, .word = 0x613f, .immediate=0, .flags=0x80, .name = "1ST" },
  { .ov = -1, .code = 0x1d29, .word = 0x614a, .immediate=0, .flags=0x80, .name = "?MVT" },
  { .ov = -1, .code = 0x1d29, .word = 0x6155, .immediate=0, .flags=0x80, .name = "?SUP" },
  { .ov = -1, .code = 0x1d29, .word = 0x6161, .immediate=0, .flags=0x80, .name = "E-USE" },
  { .ov = -1, .code = 0x1d29, .word = 0x616f, .immediate=0, .flags=0x80, .name = "'ENERGY" },
  { .ov = -1, .code = 0x1d29, .word = 0x617d, .immediate=0, .flags=0x80, .name = "?SECURE" },
  { .ov = -1, .code = 0x1d29, .word = 0x6188, .immediate=0, .flags=0x80, .name = "'STP" },
  { .ov = -1, .code = 0x1d29, .word = 0x6195, .immediate=0, .flags=0x80, .name = "'RSIDE" },
  { .ov = -1, .code = 0x1d29, .word = 0x61a2, .immediate=0, .flags=0x80, .name = "DERROR" },
  { .ov = -1, .code = 0x1d29, .word = 0x61ac, .immediate=0, .flags=0x80, .name = "NLR" },
  { .ov = -1, .code = 0x53f7, .word = 0x61b6, .immediate=0, .flags=0x80, .name = "OVT" },
  { .ov = -1, .code = 0x1d29, .word = 0x61d4, .immediate=0, .flags=0x80, .name = "?10" },
  { .ov = -1, .code = 0x1d29, .word = 0x61df, .immediate=0, .flags=0x80, .name = "BITS" },
  { .ov = -1, .code = 0x1d29, .word = 0x61eb, .immediate=0, .flags=0x80, .name = "#BITS" },
  { .ov = -1, .code = 0x1d29, .word = 0x61f4, .immediate=0, .flags=0x80, .name = "?5" },
  { .ov = -1, .code = 0x1d29, .word = 0x6202, .immediate=0, .flags=0x80, .name = "SELLING" },
  { .ov = -1, .code = 0x1d29, .word = 0x6210, .immediate=0, .flags=0x80, .name = "BARTERI" },
  { .ov = -1, .code = 0x1d29, .word = 0x621d, .immediate=0, .flags=0x80, .name = "?REPLY" },
  { .ov = -1, .code = 0x1d29, .word = 0x6229, .immediate=0, .flags=0x80, .name = "PLAST" },
  { .ov = -1, .code = 0x1d29, .word = 0x6234, .immediate=0, .flags=0x80, .name = "PAST" },
  { .ov = -1, .code = 0x1d29, .word = 0x623f, .immediate=0, .flags=0x80, .name = "HAZE" },
  { .ov = -1, .code = 0x1d29, .word = 0x624f, .immediate=0, .flags=0x80, .name = "?CALLIN" },
  { .ov = -1, .code = 0x1d29, .word = 0x625c, .immediate=0, .flags=0x80, .name = "STAGES" },
  { .ov = -1, .code = 0x1d29, .word = 0x6274, .immediate=0, .flags=0x80, .name = "%SLUG" },
  { .ov = -1, .code = 0x1d29, .word = 0x627f, .immediate=0, .flags=0x80, .name = "ITEM" },
  { .ov = -1, .code = 0x1d29, .word = 0x628d, .immediate=0, .flags=0x80, .name = "FSTUN" },
  { .ov = -1, .code = 0x1d29, .word = 0x629b, .immediate=0, .flags=0x80, .name = "PATIENC" },
  { .ov = -1, .code = 0x1d29, .word = 0x62a6, .immediate=0, .flags=0x80, .name = "TMAP" },
  { .ov = -1, .code = 0x1d29, .word = 0x62b1, .immediate=0, .flags=0x80, .name = ":(" },
  { .ov = -1, .code = 0x1d29, .word = 0x62bf, .immediate=0, .flags=0x80, .name = "TIRED-T" },
  { .ov = -1, .code = 0x1d29, .word = 0x62cf, .immediate=0, .flags=0x80, .name = "LASTREP" },
  { .ov = -1, .code = 0x1d29, .word = 0x62df, .immediate=0, .flags=0x80, .name = "TALKCOU" },
  { .ov = -1, .code = 0x1d29, .word = 0x62ee, .immediate=0, .flags=0x80, .name = "VSTIME" },
  { .ov = -1, .code = 0x1d29, .word = 0x62fe, .immediate=0, .flags=0x80, .name = "10*CARG" },
  { .ov = -1, .code = 0x1d29, .word = 0x630e, .immediate=0, .flags=0x80, .name = "SENSE-A" },
  { .ov = -1, .code = 0x1d29, .word = 0x631c, .immediate=0, .flags=0x80, .name = "EYEXY" },
  { .ov = -1, .code = 0x1d29, .word = 0x632b, .immediate=0, .flags=0x80, .name = "WEAPXY" },
  { .ov = -1, .code = 0x1d29, .word = 0x633a, .immediate=0, .flags=0x80, .name = "10*END" },
  { .ov = -1, .code = 0x1d29, .word = 0x634a, .immediate=0, .flags=0x80, .name = "TOWFINE" },
  { .ov = -1, .code = 0x1d29, .word = 0x635a, .immediate=0, .flags=0x80, .name = "ENC-TIM" },
  { .ov = -1, .code = 0x1d29, .word = 0x636a, .immediate=0, .flags=0x80, .name = "NAV-TIM" },
  { .ov = -1, .code = 0x1d29, .word = 0x6370, .immediate=0, .flags=0x00, .name = "W6370" },
  { .ov = -1, .code = 0x1d29, .word = 0x637e, .immediate=0, .flags=0x80, .name = "STIME" },
  { .ov = -1, .code = 0x1d29, .word = 0x638c, .immediate=0, .flags=0x80, .name = "ETIME" },
  { .ov = -1, .code = 0x1d29, .word = 0x6390, .immediate=0, .flags=0x00, .name = "W6390" },
  { .ov = -1, .code = 0x1d29, .word = 0x6396, .immediate=0, .flags=0x00, .name = "W6396" },
  { .ov = -1, .code = 0x1d29, .word = 0x639c, .immediate=0, .flags=0x00, .name = "W639C" },
  { .ov = -1, .code = 0x1d29, .word = 0x63a2, .immediate=0, .flags=0x00, .name = "W63A2" },
  { .ov = -1, .code = 0x1d29, .word = 0x63b2, .immediate=0, .flags=0x80, .name = "KEYTIME" },
  { .ov = -1, .code = 0x1d29, .word = 0x63c2, .immediate=0, .flags=0x80, .name = "LKEYTIM" },
  { .ov = -1, .code = 0x1d29, .word = 0x63d2, .immediate=0, .flags=0x80, .name = "(SCROLL_1" },
  { .ov = -1, .code = 0x1d29, .word = 0x63e2, .immediate=0, .flags=0x80, .name = "(ORIGIN" },
  { .ov = -1, .code = 0x1d29, .word = 0x63f2, .immediate=0, .flags=0x80, .name = "(SCROLL_2" },
  { .ov = -1, .code = 0x1d29, .word = 0x6402, .immediate=0, .flags=0x80, .name = "REAL-MS" },
  { .ov = -1, .code = 0x1d29, .word = 0x6412, .immediate=0, .flags=0x80, .name = "LAST-UP" },
  { .ov = -1, .code = 0x1d29, .word = 0x6422, .immediate=0, .flags=0x80, .name = "XWLD:XP" },
  { .ov = -1, .code = 0x1d29, .word = 0x6432, .immediate=0, .flags=0x80, .name = "YWLD:YP" },
  { .ov = -1, .code = 0x1d29, .word = 0x6441, .immediate=0, .flags=0x80, .name = "ANCHOR" },
  { .ov = -1, .code = 0x1d29, .word = 0x6451, .immediate=0, .flags=0x80, .name = "OK-TALK" },
  { .ov = -1, .code = 0x1d29, .word = 0x6461, .immediate=0, .flags=0x80, .name = "TVEHICL" },
  { .ov = -1, .code = 0x1d29, .word = 0x6471, .immediate=0, .flags=0x80, .name = "TV-HOLD" },
  { .ov = -1, .code = 0x1d29, .word = 0x6481, .immediate=0, .flags=0x80, .name = "SUPER-B" },
  { .ov = -1, .code = 0x1d29, .word = 0x6491, .immediate=0, .flags=0x80, .name = "(SYSTEM" },
  { .ov = -1, .code = 0x1d29, .word = 0x64a1, .immediate=0, .flags=0x80, .name = "(ORBIT)" },
  { .ov = -1, .code = 0x1d29, .word = 0x64b1, .immediate=0, .flags=0x80, .name = "(PLANET" },
  { .ov = -1, .code = 0x1d29, .word = 0x64c1, .immediate=0, .flags=0x80, .name = "(SURFAC" },
  { .ov = -1, .code = 0x1d29, .word = 0x64d1, .immediate=0, .flags=0x80, .name = "(ENCOUN" },
  { .ov = -1, .code = 0x1d29, .word = 0x64e1, .immediate=0, .flags=0x80, .name = "(SHIPBO" },
  { .ov = -1, .code = 0x1d29, .word = 0x64f1, .immediate=0, .flags=0x80, .name = "(AORIGI" },
  { .ov = -1, .code = 0x1d29, .word = 0x6501, .immediate=0, .flags=0x80, .name = "THIS-RE" },
  { .ov = -1, .code = 0x1d29, .word = 0x6511, .immediate=0, .flags=0x80, .name = "(THIS-I" },
  { .ov = -1, .code = 0x1d29, .word = 0x6517, .immediate=0, .flags=0x00, .name = "W6517" },
  { .ov = -1, .code = 0x1d29, .word = 0x651b, .immediate=0, .flags=0x00, .name = "W651B" },
  { .ov = -1, .code = 0x1d29, .word = 0x65de, .immediate=0, .flags=0x80, .name = "IBFR" },
  { .ov = -1, .code = 0x1d29, .word = 0x66f9, .immediate=0, .flags=0x80, .name = "LSCAN" },
  { .ov = -1, .code = 0x1d29, .word = 0x688b, .immediate=0, .flags=0x00, .name = "W688B" },
  { .ov = -1, .code = 0x1d29, .word = 0x68cd, .immediate=0, .flags=0x00, .name = "W68CD" },
  { .ov = -1, .code = 0x1d29, .word = 0x690f, .immediate=0, .flags=0x00, .name = "W690F" },
  { .ov = -1, .code = 0x1d29, .word = 0x6951, .immediate=0, .flags=0x00, .name = "W6951" },
  { .ov = -1, .code = 0x1d29, .word = 0x699a, .immediate=0, .flags=0x80, .name = "CMAP" },
  { .ov = -1, .code = 0x1d29, .word = 0x69e4, .immediate=0, .flags=0x80, .name = "ATIME" },
  { .ov = -1, .code = 0x1d29, .word = 0x69f2, .immediate=0, .flags=0x80, .name = "LRTRN" },
  { .ov = -1, .code = 0x1d29, .word = 0x6a02, .immediate=0, .flags=0x80, .name = "(TRADER" },
  { .ov = -1, .code = 0x1d29, .word = 0x6a12, .immediate=0, .flags=0x80, .name = "(THING)" },
  { .ov = -1, .code = 0x3b74, .word = 0x6a22, .immediate=0, .flags=0x80, .name = "BUY-LIS" },
  { .ov = -1, .code = 0x1d29, .word = 0x6a31, .immediate=0, .flags=0x80, .name = "#ETIME" },
  { .ov = -1, .code = 0x1d29, .word = 0x6a3f, .immediate=0, .flags=0x80, .name = "NTIME" },
  { .ov = -1, .code = 0x1d29, .word = 0x6a4c, .immediate=0, .flags=0x80, .name = "'UHL" },
  { .ov = -1, .code = 0x4e6f, .word = 0x6a5a, .immediate=0, .flags=0x80, .name = "MERCATO" },
  { .ov = -1, .code = 0x4e6f, .word = 0x6a6e, .immediate=0, .flags=0x80, .name = "CONANCH" },
  { .ov = -1, .code = 0x4e6f, .word = 0x6a82, .immediate=0, .flags=0x80, .name = "CONTOUR" },
  { .ov = -1, .code = 0x4e6f, .word = 0x6a96, .immediate=0, .flags=0x80, .name = "ICONIMA" },
  { .ov = -1, .code = 0x4e6f, .word = 0x6aa9, .immediate=0, .flags=0x80, .name = "VERTEX" },
  { .ov = -1, .code = 0x4e6f, .word = 0x6abb, .immediate=0, .flags=0x80, .name = "FACET" },
  { .ov = -1, .code = 0x4e6f, .word = 0x6acc, .immediate=0, .flags=0x80, .name = "FACE" },
  { .ov = -1, .code = 0x4e6f, .word = 0x6ade, .immediate=0, .flags=0x80, .name = "PPOLY" },
  { .ov = -1, .code = 0x4e6f, .word = 0x6af2, .immediate=0, .flags=0x80, .name = "GVERTEX" },
  { .ov = -1, .code = 0x4e6f, .word = 0x6b04, .immediate=0, .flags=0x80, .name = "GPOLY" },
  { .ov = -1, .code = 0x4e6f, .word = 0x6b18, .immediate=0, .flags=0x80, .name = "GRIDCOL" },
  { .ov = -1, .code = 0x4e6f, .word = 0x6b2b, .immediate=0, .flags=0x80, .name = "G1VERT" },
  { .ov = -1, .code = 0x4e6f, .word = 0x6b3f, .immediate=0, .flags=0x80, .name = "9X9COAR" },
  { .ov = -1, .code = 0x4e6f, .word = 0x6b53, .immediate=0, .flags=0x80, .name = "9X9FINE" },
  { .ov = -1, .code = 0x4e6f, .word = 0x6b67, .immediate=0, .flags=0x80, .name = "XFORMVE" },
  { .ov = -1, .code = 0x53f7, .word = 0x6b7b, .immediate=0, .flags=0x80, .name = "IARRAYS" },
  { .ov = -1, .code = 0x3b74, .word = 0x6ba5, .immediate=0, .flags=0x80, .name = "*STARPO" },
  { .ov = -1, .code = 0x3b74, .word = 0x6bb5, .immediate=0, .flags=0x80, .name = "*PERSON" },
  { .ov = -1, .code = 0x3b74, .word = 0x6bc5, .immediate=0, .flags=0x80, .name = "*SHIP-C" },
  { .ov = -1, .code = 0x3b74, .word = 0x6bd5, .immediate=0, .flags=0x80, .name = "*TRADE-" },
  { .ov = -1, .code = 0x3b74, .word = 0x6be5, .immediate=0, .flags=0x80, .name = "*ITEMS-" },
  { .ov = -1, .code = 0x3b74, .word = 0x6bf5, .immediate=0, .flags=0x80, .name = "*OPERAT" },
  { .ov = -1, .code = 0x3b74, .word = 0x6c03, .immediate=0, .flags=0x80, .name = "*BANK" },
  { .ov = -1, .code = 0x3b74, .word = 0x6c13, .immediate=0, .flags=0x80, .name = "*STARSH" },
  { .ov = -1, .code = 0x3b74, .word = 0x6c20, .immediate=0, .flags=0x80, .name = "*EYE" },
  { .ov = -1, .code = 0x3b74, .word = 0x6c2f, .immediate=0, .flags=0x80, .name = "*PLIST" },
  { .ov = -1, .code = 0x3b74, .word = 0x6c3d, .immediate=0, .flags=0x80, .name = "*MISS" },
  { .ov = -1, .code = 0x3b74, .word = 0x6c4b, .immediate=0, .flags=0x80, .name = "*MESS" },
  { .ov = -1, .code = 0x1d29, .word = 0x6c5b, .immediate=0, .flags=0x80, .name = "'VERSIO" },
  { .ov = -1, .code = 0x1d29, .word = 0x6c67, .immediate=0, .flags=0x80, .name = "CTTOP" },
  { .ov = -1, .code = 0x1d29, .word = 0x6c73, .immediate=0, .flags=0x80, .name = "CTBOT" },
  { .ov = -1, .code = 0x224c, .word = 0x6c80, .immediate=0, .flags=0x80, .name = ">0FONT_1" },
  { .ov = -1, .code = 0x6cb2, .word = 0x6cb2, .immediate=0, .flags=0x80, .name = "?UPDATE" },
  { .ov = -1, .code = 0x224c, .word = 0x6d0c, .immediate=0, .flags=0x80, .name = "C!_2" },
  { .ov = -1, .code = 0x224c, .word = 0x6d18, .immediate=0, .flags=0x80, .name = "!_2" },
  { .ov = -1, .code = 0x224c, .word = 0x6d25, .immediate=0, .flags=0x80, .name = "+!_2" },
  { .ov = -1, .code = 0x224c, .word = 0x6d34, .immediate=0, .flags=0x80, .name = "1.5!_2" },
  { .ov = -1, .code = 0x224c, .word = 0x6d41, .immediate=0, .flags=0x80, .name = "2!_2" },
  { .ov = -1, .code = 0x224c, .word = 0x6d4e, .immediate=0, .flags=0x80, .name = "D!" },
  { .ov = -1, .code = 0x224c, .word = 0x6d59, .immediate=0, .flags=0x80, .name = "ON_2" },
  { .ov = -1, .code = 0x224c, .word = 0x6d67, .immediate=0, .flags=0x80, .name = "099" },
  { .ov = -1, .code = 0x224c, .word = 0x6d76, .immediate=0, .flags=0x80, .name = "2OFF" },
  { .ov = -1, .code = 0x224c, .word = 0x6d8c, .immediate=0, .flags=0x80, .name = "CMOVE_2" },
  { .ov = -1, .code = 0x224c, .word = 0x6d9f, .immediate=0, .flags=0x80, .name = "FILL_2" },
  { .ov = -1, .code = 0x224c, .word = 0x6dad, .immediate=0, .flags=0x00, .name = "W6DAD" },
  { .ov = -1, .code = 0x224c, .word = 0x6dc1, .immediate=0, .flags=0x80, .name = "BLOCK_2" },
  { .ov = -1, .code = 0x224c, .word = 0x6dd2, .immediate=0, .flags=0x80, .name = "LBLOCK_2" },
  { .ov = -1, .code = 0x224c, .word = 0x6de1, .immediate=0, .flags=0x80, .name = "LOAD_2" },
  { .ov = -1, .code = 0x224c, .word = 0x6df7, .immediate=0, .flags=0x80, .name = "-TEXT" },
  { .ov = -1, .code = 0x224c, .word = 0x6e34, .immediate=0, .flags=0x80, .name = "$=" },
  { .ov = -1, .code = 0x224c, .word = 0x6e61, .immediate=0, .flags=0x80, .name = "SIGFLD" },
  { .ov = -1, .code = 0x6e67, .word = 0x6e80, .immediate=0, .flags=0x80, .name = ":SIGNAT" },
  { .ov = -1, .code = 0x6e67, .word = 0x6e8e, .immediate=0, .flags=0x80, .name = ":TIMEST" },
  { .ov = -1, .code = 0x6e67, .word = 0x6e9b, .immediate=0, .flags=0x80, .name = ":CKSUM" },
  { .ov = -1, .code = 0x6e67, .word = 0x6ea7, .immediate=0, .flags=0x80, .name = ":SAVE" },
  { .ov = -1, .code = 0x6e67, .word = 0x6eb5, .immediate=0, .flags=0x80, .name = ":VERSIO" },
  { .ov = -1, .code = 0x224c, .word = 0x6ec0, .immediate=0, .flags=0x80, .name = "THRU_2" },
  { .ov = -1, .code = 0x6eef, .word = 0x6eef, .immediate=0, .flags=0x80, .name = "VA>BLK" },
  { .ov = -1, .code = 0x224c, .word = 0x6f13, .immediate=0, .flags=0x80, .name = "VA>BUF" },
  { .ov = -1, .code = 0x224c, .word = 0x6f1d, .immediate=0, .flags=0x00, .name = "W6F1D" },
  { .ov = -1, .code = 0x224c, .word = 0x6f27, .immediate=0, .flags=0x00, .name = "W6F27" },
  { .ov = -1, .code = 0x224c, .word = 0x6f35, .immediate=0, .flags=0x00, .name = "W6F35" },
  { .ov = -1, .code = 0x224c, .word = 0x6f49, .immediate=0, .flags=0x00, .name = "W6F49" },
  { .ov = -1, .code = 0x224c, .word = 0x6f57, .immediate=0, .flags=0x00, .name = "W6F57" },
  { .ov = -1, .code = 0x224c, .word = 0x6f69, .immediate=0, .flags=0x80, .name = "MOUNTFI" },
  { .ov = -1, .code = 0x224c, .word = 0x6f85, .immediate=0, .flags=0x00, .name = "W6F85" },
  { .ov = -1, .code = 0x224c, .word = 0x6f91, .immediate=0, .flags=0x00, .name = "W6F91" },
  { .ov = -1, .code = 0x224c, .word = 0x6fa6, .immediate=0, .flags=0x80, .name = "MOUNTA" },
  { .ov = -1, .code = 0x224c, .word = 0x6fca, .immediate=0, .flags=0x80, .name = "MOUNTB" },
  { .ov = -1, .code = 0x224c, .word = 0x6fe5, .immediate=0, .flags=0x00, .name = "W6FE5" },
  { .ov = -1, .code = 0x224c, .word = 0x6ffd, .immediate=0, .flags=0x00, .name = "W6FFD" },
  { .ov = -1, .code = 0x224c, .word = 0x700f, .immediate=0, .flags=0x00, .name = "W700F" },
  { .ov = -1, .code = 0x224c, .word = 0x7021, .immediate=0, .flags=0x00, .name = "W7021" },
  { .ov = -1, .code = 0x224c, .word = 0x7075, .immediate=0, .flags=0x00, .name = "W7075" },
  { .ov = -1, .code = 0x224c, .word = 0x7083, .immediate=0, .flags=0x00, .name = "W7083" },
  { .ov = -1, .code = 0x224c, .word = 0x711d, .immediate=0, .flags=0x80, .name = "MEM>DSK" },
  { .ov = -1, .code = 0x224c, .word = 0x712f, .immediate=0, .flags=0x80, .name = "MEM<DSK" },
  { .ov = -1, .code = 0x7137, .word = 0x7137, .immediate=0, .flags=0x00, .name = "W7137" },
  { .ov = -1, .code = 0x7187, .word = 0x7187, .immediate=0, .flags=0x00, .name = "W7187" },
  { .ov = -1, .code = 0x224c, .word = 0x71cb, .immediate=0, .flags=0x00, .name = "W71CB" },
  { .ov = -1, .code = 0x71d1, .word = 0x71ee, .immediate=0, .flags=0x80, .name = "FILE-NA" },
  { .ov = -1, .code = 0x71d1, .word = 0x71fb, .immediate=0, .flags=0x80, .name = "FILE-TY" },
  { .ov = -1, .code = 0x71d1, .word = 0x7208, .immediate=0, .flags=0x80, .name = "FILE-ST" },
  { .ov = -1, .code = 0x71d1, .word = 0x7215, .immediate=0, .flags=0x80, .name = "FILE-EN" },
  { .ov = -1, .code = 0x71d1, .word = 0x7222, .immediate=0, .flags=0x80, .name = "FILE-#R" },
  { .ov = -1, .code = 0x71d1, .word = 0x722f, .immediate=0, .flags=0x80, .name = "FILE-RL" },
  { .ov = -1, .code = 0x71d1, .word = 0x723c, .immediate=0, .flags=0x80, .name = "FILE-SL" },
  { .ov = -1, .code = 0x723f, .word = 0x723f, .immediate=0, .flags=0x00, .name = "W723F" },
  { .ov = -1, .code = 0x224c, .word = 0x7263, .immediate=1, .flags=0x80, .name = "FILE:" },
  { .ov = -1, .code = 0x224c, .word = 0x72c9, .immediate=0, .flags=0x80, .name = ">FILE" },
  { .ov = -1, .code = 0x224c, .word = 0x72e3, .immediate=0, .flags=0x80, .name = "FILE<" },
  { .ov = -1, .code = 0x224c, .word = 0x72f5, .immediate=0, .flags=0x00, .name = "W72F5" },
  { .ov = -1, .code = 0x224c, .word = 0x7301, .immediate=0, .flags=0x00, .name = "W7301" },
  { .ov = -1, .code = 0x224c, .word = 0x7323, .immediate=0, .flags=0x00, .name = "W7323" },
  { .ov = -1, .code = 0x224c, .word = 0x7345, .immediate=0, .flags=0x80, .name = "@RECORD" },
  { .ov = -1, .code = 0x224c, .word = 0x7372, .immediate=0, .flags=0x80, .name = "AFIELD" },
  { .ov = -1, .code = 0x73f8, .word = 0x73f8, .immediate=0, .flags=0x00, .name = "W73F8" },
  { .ov = -1, .code = 0x224c, .word = 0x7412, .immediate=0, .flags=0x80, .name = "IFIELD" },
  { .ov = -1, .code = 0x7420, .word = 0x7464, .immediate=0, .flags=0x80, .name = "INST-SI" },
  { .ov = -1, .code = 0x7420, .word = 0x7473, .immediate=0, .flags=0x80, .name = "INST-PR" },
  { .ov = -1, .code = 0x7420, .word = 0x7482, .immediate=0, .flags=0x80, .name = "INST-OF" },
  { .ov = -1, .code = 0x7420, .word = 0x7491, .immediate=0, .flags=0x80, .name = "INST-CL" },
  { .ov = -1, .code = 0x7420, .word = 0x74a0, .immediate=0, .flags=0x80, .name = "INST-SP" },
  { .ov = -1, .code = 0x7420, .word = 0x74af, .immediate=0, .flags=0x80, .name = "INST-QT" },
  { .ov = -1, .code = 0x7420, .word = 0x74bd, .immediate=0, .flags=0x80, .name = "INST-X" },
  { .ov = -1, .code = 0x7420, .word = 0x74cb, .immediate=0, .flags=0x80, .name = "INST-Y" },
  { .ov = -1, .code = 0x224c, .word = 0x74d0, .immediate=0, .flags=0x00, .name = "W74D0" },
  { .ov = -1, .code = 0x224c, .word = 0x74d8, .immediate=0, .flags=0x00, .name = "W74D8" },
  { .ov = -1, .code = 0x224c, .word = 0x74e0, .immediate=0, .flags=0x00, .name = "W74E0" },
  { .ov = -1, .code = 0x224c, .word = 0x74e8, .immediate=0, .flags=0x00, .name = "W74E8" },
  { .ov = -1, .code = 0x224c, .word = 0x74fa, .immediate=0, .flags=0x80, .name = "!INST-S" },
  { .ov = -1, .code = 0x224c, .word = 0x7502, .immediate=0, .flags=0x00, .name = "W7502" },
  { .ov = -1, .code = 0x224c, .word = 0x750a, .immediate=0, .flags=0x00, .name = "W750A" },
  { .ov = -1, .code = 0x224c, .word = 0x7512, .immediate=0, .flags=0x00, .name = "W7512" },
  { .ov = -1, .code = 0x224c, .word = 0x7524, .immediate=0, .flags=0x80, .name = "@INST-C" },
  { .ov = -1, .code = 0x224c, .word = 0x7536, .immediate=0, .flags=0x80, .name = "@INST-S" },
  { .ov = -1, .code = 0x224c, .word = 0x7548, .immediate=0, .flags=0x80, .name = "=SPECIE" },
  { .ov = -1, .code = 0x7555, .word = 0x7555, .immediate=0, .flags=0x80, .name = ">C" },
  { .ov = -1, .code = 0x7570, .word = 0x7570, .immediate=0, .flags=0x80, .name = "C>" },
  { .ov = -1, .code = 0x758d, .word = 0x758d, .immediate=0, .flags=0x80, .name = "CI" },
  { .ov = -1, .code = 0x224c, .word = 0x75a9, .immediate=0, .flags=0x80, .name = "CDROP" },
  { .ov = -1, .code = 0x224c, .word = 0x75b7, .immediate=0, .flags=0x80, .name = "CI'" },
  { .ov = -1, .code = 0x224c, .word = 0x75c8, .immediate=0, .flags=0x80, .name = "CJ" },
  { .ov = -1, .code = 0x224c, .word = 0x75dc, .immediate=0, .flags=0x80, .name = "COVER" },
  { .ov = -1, .code = 0x75ed, .word = 0x75ed, .immediate=0, .flags=0x80, .name = "CDEPTH" },
  { .ov = -1, .code = 0x224c, .word = 0x7609, .immediate=0, .flags=0x80, .name = "?NULL" },
  { .ov = -1, .code = 0x224c, .word = 0x761a, .immediate=0, .flags=0x80, .name = "?-NULL" },
  { .ov = -1, .code = 0x224c, .word = 0x762b, .immediate=0, .flags=0x80, .name = "?CHILD" },
  { .ov = -1, .code = 0x224c, .word = 0x7635, .immediate=0, .flags=0x00, .name = "W7635" },
  { .ov = -1, .code = 0x224c, .word = 0x7648, .immediate=0, .flags=0x80, .name = "!IADDR" },
  { .ov = -1, .code = 0x7650, .word = 0x7650, .immediate=0, .flags=0x00, .name = "W7650" },
  { .ov = -1, .code = 0x224c, .word = 0x765c, .immediate=0, .flags=0x00, .name = "W765C" },
  { .ov = -1, .code = 0x224c, .word = 0x7672, .immediate=0, .flags=0x00, .name = "W7672" },
  { .ov = -1, .code = 0x224c, .word = 0x7688, .immediate=0, .flags=0x00, .name = "W7688" },
  { .ov = -1, .code = 0x769a, .word = 0x769a, .immediate=0, .flags=0x80, .name = "PRIORIT" },
  { .ov = -1, .code = 0x224c, .word = 0x76ce, .immediate=0, .flags=0x00, .name = "W76CE" },
  { .ov = -1, .code = 0x224c, .word = 0x7702, .immediate=0, .flags=0x00, .name = "W7702" },
  { .ov = -1, .code = 0x224c, .word = 0x7736, .immediate=0, .flags=0x00, .name = "W7736" },
  { .ov = -1, .code = 0x224c, .word = 0x779e, .immediate=0, .flags=0x00, .name = "W779E" },
  { .ov = -1, .code = 0x224c, .word = 0x77a6, .immediate=0, .flags=0x00, .name = "W77A6" },
  { .ov = -1, .code = 0x224c, .word = 0x77ba, .immediate=0, .flags=0x00, .name = "W77BA" },
  { .ov = -1, .code = 0x224c, .word = 0x77d6, .immediate=0, .flags=0x00, .name = "W77D6" },
  { .ov = -1, .code = 0x224c, .word = 0x7816, .immediate=0, .flags=0x00, .name = "W7816" },
  { .ov = -1, .code = 0x224c, .word = 0x7892, .immediate=0, .flags=0x00, .name = "W7892" },
  { .ov = -1, .code = 0x7394, .word = 0x78b7, .immediate=0, .flags=0x80, .name = "1BTN" },
  { .ov = -1, .code = 0x224c, .word = 0x78c9, .immediate=0, .flags=0x80, .name = "AFIELD:" },
  { .ov = -1, .code = 0x224c, .word = 0x78fd, .immediate=0, .flags=0x80, .name = "IFIELD:" },
  { .ov = -1, .code = 0x7394, .word = 0x791a, .immediate=0, .flags=0x80, .name = "#BTN" },
  { .ov = -1, .code = 0x224c, .word = 0x7922, .immediate=0, .flags=0x00, .name = "W7922" },
  { .ov = -1, .code = 0x224c, .word = 0x79a2, .immediate=0, .flags=0x80, .name = "SET-CUR" },
  { .ov = -1, .code = 0x224c, .word = 0x79e1, .immediate=0, .flags=0x80, .name = "ICLOSE" },
  { .ov = -1, .code = 0x224c, .word = 0x7a0c, .immediate=0, .flags=0x80, .name = "*CLOSE" },
  { .ov = -1, .code = 0x224c, .word = 0x7a21, .immediate=0, .flags=0x80, .name = ">C+S" },
  { .ov = -1, .code = 0x224c, .word = 0x7a31, .immediate=0, .flags=0x80, .name = "@>C+S" },
  { .ov = -1, .code = 0x224c, .word = 0x7a41, .immediate=0, .flags=0x80, .name = "IOPEN" },
  { .ov = -1, .code = 0x224c, .word = 0x7a56, .immediate=0, .flags=0x80, .name = "CCLR" },
  { .ov = -1, .code = 0x224c, .word = 0x7a6c, .immediate=0, .flags=0x00, .name = "W7A6C" },
  { .ov = -1, .code = 0x224c, .word = 0x7a7c, .immediate=0, .flags=0x80, .name = "?LAST" },
  { .ov = -1, .code = 0x224c, .word = 0x7a8f, .immediate=0, .flags=0x80, .name = "?FIRST" },
  { .ov = -1, .code = 0x224c, .word = 0x7a9f, .immediate=0, .flags=0x80, .name = ">C+" },
  { .ov = -1, .code = 0x224c, .word = 0x7ab3, .immediate=0, .flags=0x80, .name = "INEXT" },
  { .ov = -1, .code = 0x224c, .word = 0x7acb, .immediate=0, .flags=0x80, .name = "IPREV" },
  { .ov = -1, .code = 0x224c, .word = 0x7ae4, .immediate=0, .flags=0x80, .name = "IFIRST" },
  { .ov = -1, .code = 0x224c, .word = 0x7af6, .immediate=0, .flags=0x80, .name = "ILAST" },
  { .ov = -1, .code = 0x224c, .word = 0x7b05, .immediate=0, .flags=0x80, .name = "VCLR" },
  { .ov = -1, .code = 0x7b14, .word = 0x7b14, .immediate=0, .flags=0x80, .name = ">V" },
  { .ov = -1, .code = 0x7b2b, .word = 0x7b2b, .immediate=0, .flags=0x80, .name = "V>" },
  { .ov = -1, .code = 0x7b42, .word = 0x7b42, .immediate=0, .flags=0x80, .name = "VI" },
  { .ov = -1, .code = 0x224c, .word = 0x7b50, .immediate=0, .flags=0x00, .name = "W7B50" },
  { .ov = -1, .code = 0x224c, .word = 0x7b7c, .immediate=0, .flags=0x80, .name = "SAVE-BU" },
  { .ov = -1, .code = 0x224c, .word = 0x7b8c, .immediate=0, .flags=0x80, .name = "FLUSH_2" },
  { .ov = -1, .code = 0x224c, .word = 0x7b99, .immediate=0, .flags=0x80, .name = "MT" },
  { .ov = -1, .code = 0x224c, .word = 0x7bab, .immediate=0, .flags=0x80, .name = "IINSERT" },
  { .ov = -1, .code = 0x224c, .word = 0x7bf3, .immediate=0, .flags=0x80, .name = "<INSERT" },
  { .ov = -1, .code = 0x224c, .word = 0x7c19, .immediate=0, .flags=0x80, .name = ">INSERT" },
  { .ov = -1, .code = 0x224c, .word = 0x7c2f, .immediate=0, .flags=0x80, .name = "IEXTRAC" },
  { .ov = -1, .code = 0x224c, .word = 0x7c71, .immediate=0, .flags=0x00, .name = "W7C71" },
  { .ov = -1, .code = 0x224c, .word = 0x7c83, .immediate=0, .flags=0x80, .name = "@NEWSPA" },
  { .ov = -1, .code = 0x224c, .word = 0x7c95, .immediate=0, .flags=0x80, .name = "!NEWSPA" },
  { .ov = -1, .code = 0x224c, .word = 0x7c9d, .immediate=0, .flags=0x00, .name = "W7C9D" },
  { .ov = -1, .code = 0x224c, .word = 0x7cb3, .immediate=0, .flags=0x80, .name = "MAXSPAC" },
  { .ov = -1, .code = 0x224c, .word = 0x7cc3, .immediate=0, .flags=0x00, .name = "W7CC3" },
  { .ov = -1, .code = 0x4b3b, .word = 0x7cdc, .immediate=0, .flags=0x80, .name = "FLD@" },
  { .ov = -1, .code = 0x4b3b, .word = 0x7cf5, .immediate=0, .flags=0x80, .name = "FLD!" },
  { .ov = -1, .code = 0x224c, .word = 0x7d0f, .immediate=0, .flags=0x80, .name = "IFLD@" },
  { .ov = -1, .code = 0x224c, .word = 0x7d29, .immediate=0, .flags=0x80, .name = "IFLD!" },
  { .ov = -1, .code = 0x224c, .word = 0x7d3b, .immediate=0, .flags=0x00, .name = "W7D3B" },
  { .ov = -1, .code = 0x224c, .word = 0x7d51, .immediate=0, .flags=0x80, .name = "?CLASS/" },
  { .ov = -1, .code = 0x224c, .word = 0x7d73, .immediate=0, .flags=0x00, .name = "W7D73" },
  { .ov = -1, .code = 0x224c, .word = 0x7d7b, .immediate=0, .flags=0x00, .name = "W7D7B" },
  { .ov = -1, .code = 0x224c, .word = 0x7d83, .immediate=0, .flags=0x00, .name = "W7D83" },
  { .ov = -1, .code = 0x224c, .word = 0x7d91, .immediate=0, .flags=0x80, .name = "MAP" },
  { .ov = -1, .code = 0x224c, .word = 0x7d99, .immediate=0, .flags=0x00, .name = "W7D99" },
  { .ov = -1, .code = 0x224c, .word = 0x7da5, .immediate=0, .flags=0x00, .name = "W7DA5" },
  { .ov = -1, .code = 0x224c, .word = 0x7db8, .immediate=0, .flags=0x80, .name = "SELECT" },
  { .ov = -1, .code = 0x224c, .word = 0x7dec, .immediate=0, .flags=0x80, .name = "?>FIRST" },
  { .ov = -1, .code = 0x224c, .word = 0x7e04, .immediate=0, .flags=0x80, .name = "SELECT-" },
  { .ov = -1, .code = 0x224c, .word = 0x7e30, .immediate=0, .flags=0x00, .name = "W7E30" },
  { .ov = -1, .code = 0x224c, .word = 0x7e3c, .immediate=0, .flags=0x00, .name = "W7E3C" },
  { .ov = -1, .code = 0x224c, .word = 0x7e4e, .immediate=0, .flags=0x80, .name = "IFIND" },
  { .ov = -1, .code = 0x224c, .word = 0x7e58, .immediate=0, .flags=0x00, .name = "W7E58" },
  { .ov = -1, .code = 0x224c, .word = 0x7e7c, .immediate=0, .flags=0x80, .name = "MAP>LEA" },
  { .ov = -1, .code = 0x224c, .word = 0x7ea0, .immediate=0, .flags=0x80, .name = "MAKE1ST" },
  { .ov = -1, .code = 0x224c, .word = 0x7eb4, .immediate=0, .flags=0x00, .name = "W7EB4" },
  { .ov = -1, .code = 0x224c, .word = 0x7ef2, .immediate=0, .flags=0x80, .name = ">INACTI" },
  { .ov = -1, .code = 0x224c, .word = 0x7f0e, .immediate=0, .flags=0x00, .name = "W7F0E" },
  { .ov = -1, .code = 0x224c, .word = 0x7f20, .immediate=0, .flags=0x80, .name = "IDELETE" },
  { .ov = -1, .code = 0x224c, .word = 0x7f4c, .immediate=0, .flags=0x00, .name = "W7F4C" },
  { .ov = -1, .code = 0x224c, .word = 0x7f8e, .immediate=0, .flags=0x80, .name = "ALL" },
  { .ov = -1, .code = 0x224c, .word = 0x7fab, .immediate=0, .flags=0x80, .name = "EACH" },
  { .ov = -1, .code = 0x224c, .word = 0x7fbd, .immediate=0, .flags=0x00, .name = "W7FBD" },
  { .ov = -1, .code = 0x224c, .word = 0x7fcf, .immediate=0, .flags=0x80, .name = "NULLPOI" },
  { .ov = -1, .code = 0x224c, .word = 0x7fdf, .immediate=0, .flags=0x00, .name = "W7FDF" },
  { .ov = -1, .code = 0x224c, .word = 0x7ff5, .immediate=0, .flags=0x00, .name = "W7FF5" },
  { .ov = -1, .code = 0x224c, .word = 0x802b, .immediate=0, .flags=0x00, .name = "W802B" },
  { .ov = -1, .code = 0x224c, .word = 0x8077, .immediate=0, .flags=0x80, .name = "?>MAXSP" },
  { .ov = -1, .code = 0x224c, .word = 0x808d, .immediate=0, .flags=0x00, .name = "W808D" },
  { .ov = -1, .code = 0x224c, .word = 0x80c7, .immediate=0, .flags=0x00, .name = "W80C7" },
  { .ov = -1, .code = 0x4b3b, .word = 0x8115, .immediate=0, .flags=0x80, .name = "SET?REU" },
  { .ov = -1, .code = 0x224c, .word = 0x8165, .immediate=0, .flags=0x80, .name = "VICREAT" },
  { .ov = -1, .code = 0x224c, .word = 0x81ab, .immediate=0, .flags=0x80, .name = "ICREATE" },
  { .ov = -1, .code = 0x7394, .word = 0x81ff, .immediate=0, .flags=0x80, .name = "BOX-NAM" },
  { .ov = -1, .code = 0x224c, .word = 0x8211, .immediate=0, .flags=0x80, .name = "*CREATE" },
  { .ov = -1, .code = 0x224c, .word = 0x823e, .immediate=0, .flags=0x80, .name = ".C" },
  { .ov = -1, .code = 0x224c, .word = 0x8279, .immediate=0, .flags=0x00, .name = "W8279" },
  { .ov = -1, .code = 0x224c, .word = 0x828b, .immediate=0, .flags=0x80, .name = "OV-CANC" },
  { .ov = -1, .code = 0x224c, .word = 0x82c7, .immediate=0, .flags=0x00, .name = "W82C7" },
  { .ov = -1, .code = 0x224c, .word = 0x82d3, .immediate=0, .flags=0x00, .name = "W82D3" },
  { .ov = -1, .code = 0x224c, .word = 0x82ee, .immediate=0, .flags=0x00, .name = "W82EE" },
  { .ov = -1, .code = 0x224c, .word = 0x8317, .immediate=0, .flags=0x00, .name = "W8317" },
  { .ov = -1, .code = 0x224c, .word = 0x838f, .immediate=0, .flags=0x80, .name = "SAVE-OV" },
  { .ov = -1, .code = 0x224c, .word = 0x83cf, .immediate=0, .flags=0x80, .name = "OVERLAY" },
  { .ov = -1, .code = 0x224c, .word = 0x83e8, .immediate=0, .flags=0x00, .name = "W83E8" },
  { .ov = -1, .code = 0x224c, .word = 0x840c, .immediate=0, .flags=0x80, .name = "OPEN-OV" },
  { .ov = -1, .code = 0x224c, .word = 0x8460, .immediate=0, .flags=0x00, .name = "W8460" },
  { .ov = -1, .code = 0x224c, .word = 0x84c4, .immediate=0, .flags=0x80, .name = "CLOSE-O" },
  { .ov = -1, .code = 0x224c, .word = 0x84db, .immediate=0, .flags=0x80, .name = "MODULE" },
  { .ov = -1, .code = 0x1d29, .word = 0x84f5, .immediate=0, .flags=0x80, .name = "GRSEG" },
  { .ov = -1, .code = 0x8503, .word = 0x8503, .immediate=0, .flags=0x80, .name = "SHL-BIT" },
  { .ov = -1, .code = 0x1d29, .word = 0x8511, .immediate=0, .flags=0x00, .name = "W8511" },
  { .ov = -1, .code = 0x224c, .word = 0x851f, .immediate=0, .flags=0x80, .name = "1PIX" },
  { .ov = -1, .code = 0x224c, .word = 0x8536, .immediate=0, .flags=0x80, .name = "2PIX" },
  { .ov = -1, .code = 0x854f, .word = 0x854f, .immediate=0, .flags=0x80, .name = "GRCALL" },
  { .ov = -1, .code = 0x224c, .word = 0x8579, .immediate=0, .flags=0x80, .name = "PAD|16" },
  { .ov = -1, .code = 0x224c, .word = 0x858f, .immediate=0, .flags=0x80, .name = "PAD>SEG" },
  { .ov = -1, .code = 0x224c, .word = 0x8597, .immediate=0, .flags=0x00, .name = "W8597" },
  { .ov = -1, .code = 0x224c, .word = 0x85ad, .immediate=0, .flags=0x80, .name = "@MODE" },
  { .ov = -1, .code = 0x224c, .word = 0x85ed, .immediate=0, .flags=0x80, .name = "?HERCUL" },
  { .ov = -1, .code = 0x224c, .word = 0x8600, .immediate=0, .flags=0x80, .name = "?VGA" },
  { .ov = -1, .code = 0x224c, .word = 0x8611, .immediate=0, .flags=0x80, .name = "?CGA" },
  { .ov = -1, .code = 0x1d29, .word = 0x8622, .immediate=0, .flags=0x80, .name = "CCGA" },
  { .ov = -1, .code = 0x1d29, .word = 0x863b, .immediate=0, .flags=0x80, .name = "PCGA" },
  { .ov = -1, .code = 0x224c, .word = 0x8655, .immediate=0, .flags=0x80, .name = "NBCLR" },
  { .ov = -1, .code = 0x866e, .word = 0x866e, .immediate=0, .flags=0x80, .name = "?XOR" },
  { .ov = -1, .code = 0x224c, .word = 0x869f, .immediate=0, .flags=0x80, .name = "!COLOR" },
  { .ov = -1, .code = 0x224c, .word = 0x86f2, .immediate=0, .flags=0x80, .name = "@COLOR" },
  { .ov = -1, .code = 0x224c, .word = 0x86fa, .immediate=0, .flags=0x00, .name = "W86FA" },
  { .ov = -1, .code = 0x224c, .word = 0x870d, .immediate=0, .flags=0x80, .name = "RNDCLR" },
  { .ov = -1, .code = 0x224c, .word = 0x8721, .immediate=0, .flags=0x00, .name = "W8721" },
  { .ov = -1, .code = 0x224c, .word = 0x8733, .immediate=0, .flags=0x00, .name = "W8733" },
  { .ov = -1, .code = 0x224c, .word = 0x8747, .immediate=0, .flags=0x00, .name = "W8747" },
  { .ov = -1, .code = 0x224c, .word = 0x875b, .immediate=0, .flags=0x00, .name = "W875B" },
  { .ov = -1, .code = 0x4b3b, .word = 0x8779, .immediate=0, .flags=0x80, .name = "MON>MEM" },
  { .ov = -1, .code = 0x224c, .word = 0x8795, .immediate=0, .flags=0x80, .name = "SETDBUF" },
  { .ov = -1, .code = 0x1d29, .word = 0x87b7, .immediate=0, .flags=0x00, .name = "W87B7" },
  { .ov = -1, .code = 0x224c, .word = 0x87bd, .immediate=0, .flags=0x00, .name = "W87BD" },
  { .ov = -1, .code = 0x224c, .word = 0x87cb, .immediate=0, .flags=0x00, .name = "W87CB" },
  { .ov = -1, .code = 0x87fd, .word = 0x87fd, .immediate=0, .flags=0x80, .name = "L@PIXEL" },
  { .ov = -1, .code = 0x8818, .word = 0x8818, .immediate=0, .flags=0x80, .name = "LPLOT" },
  { .ov = -1, .code = 0x884a, .word = 0x884a, .immediate=0, .flags=0x80, .name = "LXPLOT" },
  { .ov = -1, .code = 0x224c, .word = 0x8873, .immediate=0, .flags=0x00, .name = "W8873" },
  { .ov = -1, .code = 0x224c, .word = 0x889d, .immediate=0, .flags=0x80, .name = "BFILL" },
  { .ov = -1, .code = 0x224c, .word = 0x88ba, .immediate=0, .flags=0x80, .name = "DARK" },
  { .ov = -1, .code = 0x224c, .word = 0x88d4, .immediate=0, .flags=0x00, .name = "W88D4" },
  { .ov = -1, .code = 0x224c, .word = 0x88fc, .immediate=0, .flags=0x80, .name = "LLINE" },
  { .ov = -1, .code = 0x8914, .word = 0x8914, .immediate=0, .flags=0x80, .name = "FCIRC" },
  { .ov = -1, .code = 0x224c, .word = 0x892b, .immediate=0, .flags=0x00, .name = "W892B" },
  { .ov = -1, .code = 0x224c, .word = 0x893d, .immediate=0, .flags=0x00, .name = "W893D" },
  { .ov = -1, .code = 0x8953, .word = 0x8953, .immediate=0, .flags=0x00, .name = "W8953" },
  { .ov = -1, .code = 0x224c, .word = 0x8974, .immediate=0, .flags=0x80, .name = ".CIRCLE_1" },
  { .ov = -1, .code = 0x224c, .word = 0x8986, .immediate=0, .flags=0x80, .name = "FILLCIR" },
  { .ov = -1, .code = 0x224c, .word = 0x8998, .immediate=0, .flags=0x80, .name = ".ELLIPS" },
  { .ov = -1, .code = 0x224c, .word = 0x89aa, .immediate=0, .flags=0x80, .name = "FILLELL" },
  { .ov = -1, .code = 0x1d29, .word = 0x89b2, .immediate=0, .flags=0x00, .name = "W89B2" },
  { .ov = -1, .code = 0x89ef, .word = 0x89ef, .immediate=0, .flags=0x80, .name = "HLINE" },
  { .ov = -1, .code = 0x1d29, .word = 0x89f9, .immediate=0, .flags=0x00, .name = "W89F9" },
  { .ov = -1, .code = 0x224c, .word = 0x89ff, .immediate=0, .flags=0x00, .name = "W89FF" },
  { .ov = -1, .code = 0x224c, .word = 0x8a2f, .immediate=0, .flags=0x00, .name = "W8A2F" },
  { .ov = -1, .code = 0x224c, .word = 0x8a49, .immediate=0, .flags=0x00, .name = "W8A49" },
  { .ov = -1, .code = 0x224c, .word = 0x8a80, .immediate=0, .flags=0x80, .name = ">1FONT" },
  { .ov = -1, .code = 0x224c, .word = 0x8a91, .immediate=0, .flags=0x80, .name = ">2FONT" },
  { .ov = -1, .code = 0x224c, .word = 0x8aa2, .immediate=0, .flags=0x80, .name = ">3FONT" },
  { .ov = -1, .code = 0x224c, .word = 0x8ab3, .immediate=0, .flags=0x80, .name = ">0FONT_2" },
  { .ov = -1, .code = 0x224c, .word = 0x8ac5, .immediate=0, .flags=0x80, .name = "LDPAL" },
  { .ov = -1, .code = 0x224c, .word = 0x8ae3, .immediate=0, .flags=0x00, .name = "W8AE3" },
  { .ov = -1, .code = 0x224c, .word = 0x8af7, .immediate=0, .flags=0x80, .name = ":8>" },
  { .ov = -1, .code = 0x224c, .word = 0x8b05, .immediate=0, .flags=0x80, .name = ")8>" },
  { .ov = -1, .code = 0x224c, .word = 0x8b14, .immediate=0, .flags=0x80, .name = "2<8>" },
  { .ov = -1, .code = 0x224c, .word = 0x8b22, .immediate=0, .flags=0x80, .name = "<8>" },
  { .ov = -1, .code = 0x224c, .word = 0x8b31, .immediate=0, .flags=0x80, .name = "HERC" },
  { .ov = -1, .code = 0x2214, .word = 0x8b4d, .immediate=0, .flags=0x80, .name = "#VECTOR" },
  { .ov = -1, .code = 0x1d29, .word = 0x8b5b, .immediate=0, .flags=0x80, .name = "TREJECT" },
  { .ov = -1, .code = 0x8b6d, .word = 0x8b6d, .immediate=0, .flags=0x80, .name = "CLIPPER" },
  { .ov = -1, .code = 0x8b83, .word = 0x8b83, .immediate=0, .flags=0x80, .name = "SCANPOL" },
  { .ov = -1, .code = 0x8b99, .word = 0x8b99, .immediate=0, .flags=0x80, .name = ">PLANES" },
  { .ov = -1, .code = 0x8bad, .word = 0x8bad, .immediate=0, .flags=0x80, .name = "LFILL" },
  { .ov = -1, .code = 0x8bbf, .word = 0x8bbf, .immediate=0, .flags=0x80, .name = "BLT" },
  { .ov = -1, .code = 0x224c, .word = 0x8bd5, .immediate=0, .flags=0x80, .name = "LFILLPO" },
  { .ov = -1, .code = 0x224c, .word = 0x8be5, .immediate=0, .flags=0x00, .name = "W8BE5" },
  { .ov = -1, .code = 0x224c, .word = 0x8c11, .immediate=0, .flags=0x80, .name = "SETCLIP" },
  { .ov = -1, .code = 0x224c, .word = 0x8c61, .immediate=0, .flags=0x80, .name = "VDCLIPS" },
  { .ov = -1, .code = 0x224c, .word = 0x8c7f, .immediate=0, .flags=0x80, .name = "VCLIPSE" },
  { .ov = -1, .code = 0x224c, .word = 0x8c9b, .immediate=0, .flags=0x80, .name = "DCLIPSE" },
  { .ov = -1, .code = 0x1d29, .word = 0x8cad, .immediate=0, .flags=0x00, .name = "W8CAD" },
  { .ov = -1, .code = 0x224c, .word = 0x8cbb, .immediate=0, .flags=0x00, .name = "W8CBB" },
  { .ov = -1, .code = 0x224c, .word = 0x8cdf, .immediate=0, .flags=0x00, .name = "W8CDF" },
  { .ov = -1, .code = 0x224c, .word = 0x8d05, .immediate=0, .flags=0x00, .name = "W8D05" },
  { .ov = -1, .code = 0x224c, .word = 0x8d21, .immediate=0, .flags=0x80, .name = ">MAINVI" },
  { .ov = -1, .code = 0x224c, .word = 0x8d47, .immediate=0, .flags=0x80, .name = ">DISPLA" },
  { .ov = -1, .code = 0x224c, .word = 0x8d6b, .immediate=0, .flags=0x80, .name = ">HIDDEN" },
  { .ov = -1, .code = 0x2214, .word = 0x8d8d, .immediate=0, .flags=0x80, .name = "R2OVL" },
  { .ov = -1, .code = 0x8d99, .word = 0x8d99, .immediate=0, .flags=0x00, .name = "W8D99" },
  { .ov = -1, .code = 0x224c, .word = 0x8da5, .immediate=0, .flags=0x00, .name = "W8DA5" },
  { .ov = -1, .code = 0x224c, .word = 0x8dc5, .immediate=0, .flags=0x00, .name = "W8DC5" },
  { .ov = -1, .code = 0x1d29, .word = 0x8dd9, .immediate=0, .flags=0x80, .name = "SRC" },
  { .ov = -1, .code = 0x1d29, .word = 0x8de3, .immediate=0, .flags=0x80, .name = "DST" },
  { .ov = -1, .code = 0x1d29, .word = 0x8def, .immediate=0, .flags=0x80, .name = "SEGME" },
  { .ov = -1, .code = 0x1d29, .word = 0x8df9, .immediate=0, .flags=0x80, .name = "PLZ" },
  { .ov = -1, .code = 0x1d29, .word = 0x8e05, .immediate=0, .flags=0x80, .name = "XPCOL" },
  { .ov = -1, .code = 0x224c, .word = 0x8e10, .immediate=0, .flags=0x80, .name = ".RAW" },
  { .ov = -1, .code = 0x8e52, .word = 0x8e52, .immediate=0, .flags=0x80, .name = "DISPLAY" },
  { .ov = -1, .code = 0x224c, .word = 0x8e75, .immediate=0, .flags=0x80, .name = ">ALPHA" },
  { .ov = -1, .code = 0x224c, .word = 0x8e8a, .immediate=0, .flags=0x80, .name = ">A" },
  { .ov = -1, .code = 0x224c, .word = 0x8e99, .immediate=0, .flags=0x80, .name = ">LORES" },
  { .ov = -1, .code = 0x224c, .word = 0x8ec1, .immediate=0, .flags=0x00, .name = "W8EC1" },
  { .ov = -1, .code = 0x224c, .word = 0x8efb, .immediate=0, .flags=0x00, .name = "W8EFB" },
  { .ov = -1, .code = 0x224c, .word = 0x8f19, .immediate=0, .flags=0x80, .name = "D>H" },
  { .ov = -1, .code = 0x224c, .word = 0x8f2d, .immediate=0, .flags=0x80, .name = "H>D" },
  { .ov = -1, .code = 0x224c, .word = 0x8f45, .immediate=0, .flags=0x80, .name = "SAVE-SC" },
  { .ov = -1, .code = 0x224c, .word = 0x8f57, .immediate=0, .flags=0x80, .name = "SCR-RES" },
  { .ov = -1, .code = 0x224c, .word = 0x8f69, .immediate=0, .flags=0x80, .name = "V>DISPL" },
  { .ov = -1, .code = 0x224c, .word = 0x8fa5, .immediate=0, .flags=0x00, .name = "W8FA5" },
  { .ov = -1, .code = 0x224c, .word = 0x8fcd, .immediate=0, .flags=0x00, .name = "W8FCD" },
  { .ov = -1, .code = 0x224c, .word = 0x8fe9, .immediate=0, .flags=0x80, .name = "LCOPYBL" },
  { .ov = -1, .code = 0x224c, .word = 0x9021, .immediate=0, .flags=0x80, .name = "(BYE)" },
  { .ov = -1, .code = 0x224c, .word = 0x9041, .immediate=0, .flags=0x80, .name = "BYE_2" },
  { .ov = -1, .code = 0x224c, .word = 0x9049, .immediate=0, .flags=0x00, .name = "W9049" },
  { .ov = -1, .code = 0x224c, .word = 0x9075, .immediate=0, .flags=0x80, .name = "SET-COL" },
  { .ov = -1, .code = 0x90af, .word = 0x90af, .immediate=0, .flags=0x80, .name = "COLORMA_1" },
  { .ov = -1, .code = 0x224c, .word = 0x90e8, .immediate=0, .flags=0x80, .name = "COLORMA_2" },
  { .ov = -1, .code = 0x224c, .word = 0x90fe, .immediate=0, .flags=0x80, .name = "CELLCOL" },
  { .ov = -1, .code = 0x224c, .word = 0x9112, .immediate=0, .flags=0x80, .name = "!XYSEED" },
  { .ov = -1, .code = 0x224c, .word = 0x913a, .immediate=0, .flags=0x80, .name = "SQLPLOT" },
  { .ov = -1, .code = 0x915a, .word = 0x915a, .immediate=0, .flags=0x80, .name = "BUFFERX" },
  { .ov = -1, .code = 0x224c, .word = 0x9187, .immediate=0, .flags=0x00, .name = "W9187" },
  { .ov = -1, .code = 0x224c, .word = 0x9199, .immediate=0, .flags=0x80, .name = ".1X2CEL" },
  { .ov = -1, .code = 0x224c, .word = 0x91b3, .immediate=0, .flags=0x80, .name = "TILEFIL" },
  { .ov = -1, .code = 0x224c, .word = 0x91ff, .immediate=0, .flags=0x80, .name = ".2X2CEL" },
  { .ov = -1, .code = 0x224c, .word = 0x9223, .immediate=0, .flags=0x80, .name = ".4X4CEL" },
  { .ov = -1, .code = 0x224c, .word = 0x9241, .immediate=0, .flags=0x80, .name = ".8X8CEL" },
  { .ov = -1, .code = 0x224c, .word = 0x925f, .immediate=0, .flags=0x80, .name = ".REGION" },
  { .ov = -1, .code = 0x9292, .word = 0x9292, .immediate=0, .flags=0x80, .name = "?INVIS" },
  { .ov = -1, .code = 0x92d5, .word = 0x92d5, .immediate=0, .flags=0x80, .name = "WLD>SCR" },
  { .ov = -1, .code = 0x9319, .word = 0x9319, .immediate=0, .flags=0x80, .name = "SCR>BLT" },
  { .ov = -1, .code = 0x224c, .word = 0x9339, .immediate=0, .flags=0x80, .name = "!VISWIN" },
  { .ov = -1, .code = 0x224c, .word = 0x934d, .immediate=0, .flags=0x00, .name = "W934D" },
  { .ov = -1, .code = 0x224c, .word = 0x9375, .immediate=0, .flags=0x80, .name = ">1ICONF" },
  { .ov = -1, .code = 0x224c, .word = 0x9391, .immediate=0, .flags=0x80, .name = ">2ICONF" },
  { .ov = -1, .code = 0x224c, .word = 0x93af, .immediate=0, .flags=0x80, .name = ">3ICONF" },
  { .ov = -1, .code = 0x93c3, .word = 0x93c3, .immediate=0, .flags=0x00, .name = "W93C3" },
  { .ov = -1, .code = 0x93d9, .word = 0x93d9, .immediate=0, .flags=0x00, .name = "W93D9" },
  { .ov = -1, .code = 0x93f5, .word = 0x93f5, .immediate=0, .flags=0x80, .name = "!IW" },
  { .ov = -1, .code = 0x9411, .word = 0x9411, .immediate=0, .flags=0x80, .name = "!IB" },
  { .ov = -1, .code = 0x224c, .word = 0x942b, .immediate=0, .flags=0x80, .name = "@IX" },
  { .ov = -1, .code = 0x224c, .word = 0x943b, .immediate=0, .flags=0x80, .name = "@IY" },
  { .ov = -1, .code = 0x224c, .word = 0x944b, .immediate=0, .flags=0x80, .name = "@ID" },
  { .ov = -1, .code = 0x224c, .word = 0x945b, .immediate=0, .flags=0x80, .name = "@IC" },
  { .ov = -1, .code = 0x224c, .word = 0x946b, .immediate=0, .flags=0x80, .name = "@IL" },
  { .ov = -1, .code = 0x224c, .word = 0x947b, .immediate=0, .flags=0x80, .name = "@IH" },
  { .ov = -1, .code = 0x224c, .word = 0x948b, .immediate=0, .flags=0x80, .name = "!IX" },
  { .ov = -1, .code = 0x224c, .word = 0x949b, .immediate=0, .flags=0x80, .name = "!IY" },
  { .ov = -1, .code = 0x224c, .word = 0x94ab, .immediate=0, .flags=0x80, .name = "!ID" },
  { .ov = -1, .code = 0x224c, .word = 0x94bb, .immediate=0, .flags=0x80, .name = "!IC" },
  { .ov = -1, .code = 0x224c, .word = 0x94cb, .immediate=0, .flags=0x80, .name = "!IL" },
  { .ov = -1, .code = 0x224c, .word = 0x94db, .immediate=0, .flags=0x80, .name = "!IH" },
  { .ov = -1, .code = 0x224c, .word = 0x94ef, .immediate=0, .flags=0x80, .name = "INIT-IC" },
  { .ov = -1, .code = 0x224c, .word = 0x9505, .immediate=0, .flags=0x80, .name = ".BACKGR" },
  { .ov = -1, .code = 0x224c, .word = 0x9516, .immediate=0, .flags=0x80, .name = "?VCLIP" },
  { .ov = -1, .code = 0x224c, .word = 0x9548, .immediate=0, .flags=0x00, .name = "W9548" },
  { .ov = -1, .code = 0x224c, .word = 0x959a, .immediate=0, .flags=0x00, .name = "W959A" },
  { .ov = -1, .code = 0x224c, .word = 0x95e2, .immediate=0, .flags=0x00, .name = "W95E2" },
  { .ov = -1, .code = 0x224c, .word = 0x95f4, .immediate=0, .flags=0x80, .name = ".CIRCLE_2" },
  { .ov = -1, .code = 0x4b3b, .word = 0x9630, .immediate=0, .flags=0x80, .name = "SYSCASE" },
  { .ov = -1, .code = 0x224c, .word = 0x9646, .immediate=0, .flags=0x00, .name = "W9646" },
  { .ov = -1, .code = 0x224c, .word = 0x9668, .immediate=0, .flags=0x00, .name = "W9668" },
  { .ov = -1, .code = 0x4b3b, .word = 0x96c6, .immediate=0, .flags=0x80, .name = ".ICONCA" },
  { .ov = -1, .code = 0x224c, .word = 0x96e6, .immediate=0, .flags=0x80, .name = "POINT>I" },
  { .ov = -1, .code = 0x224c, .word = 0x96f6, .immediate=0, .flags=0x80, .name = ".ICON" },
  { .ov = -1, .code = 0x224c, .word = 0x973e, .immediate=0, .flags=0x80, .name = ".LOCAL-" },
  { .ov = -1, .code = 0x975a, .word = 0x975a, .immediate=0, .flags=0x00, .name = "W975A" },
  { .ov = -1, .code = 0x224c, .word = 0x97c4, .immediate=0, .flags=0x80, .name = "?ICONS-_1" },
  { .ov = -1, .code = 0x224c, .word = 0x97d8, .immediate=0, .flags=0x80, .name = "?ICONS-_2" },
  { .ov = -1, .code = 0x224c, .word = 0x97ec, .immediate=0, .flags=0x80, .name = "?ICON=I" },
  { .ov = -1, .code = 0x9856, .word = 0x9856, .immediate=0, .flags=0x00, .name = "W9856" },
  { .ov = -1, .code = 0x224c, .word = 0x9895, .immediate=0, .flags=0x00, .name = "W9895" },
  { .ov = -1, .code = 0x224c, .word = 0x98bd, .immediate=0, .flags=0x80, .name = "-ICON" },
  { .ov = -1, .code = 0x98f3, .word = 0x98f3, .immediate=0, .flags=0x00, .name = "W98F3" },
  { .ov = -1, .code = 0x224c, .word = 0x9940, .immediate=0, .flags=0x80, .name = "?ICONSI" },
  { .ov = -1, .code = 0x224c, .word = 0x9952, .immediate=0, .flags=0x80, .name = "+ICON_2" },
  { .ov = -1, .code = 0x224c, .word = 0x9984, .immediate=0, .flags=0x80, .name = "+ICONBO" },
  { .ov = -1, .code = 0x224c, .word = 0x9998, .immediate=0, .flags=0x80, .name = "ORGLIST" },
  { .ov = -1, .code = 0x224c, .word = 0x9a70, .immediate=0, .flags=0x80, .name = "SFILL" },
  { .ov = -1, .code = 0x224c, .word = 0x9a7d, .immediate=0, .flags=0x80, .name = "POS." },
  { .ov = -1, .code = 0x224c, .word = 0x9a92, .immediate=0, .flags=0x80, .name = "WINDOW" },
  { .ov = -1, .code = 0x224c, .word = 0x9ad5, .immediate=0, .flags=0x80, .name = ".1LOGO" },
  { .ov = -1, .code = 0x224c, .word = 0x9b15, .immediate=0, .flags=0x00, .name = "W9B15" },
  { .ov = -1, .code = 0x224c, .word = 0x9b31, .immediate=0, .flags=0x00, .name = "W9B31" },
  { .ov = -1, .code = 0x224c, .word = 0x9b95, .immediate=0, .flags=0x80, .name = "POLY-WI" },
  { .ov = -1, .code = 0x224c, .word = 0x9ba7, .immediate=0, .flags=0x80, .name = ">SSCT" },
  { .ov = -1, .code = 0x224c, .word = 0x9bdd, .immediate=0, .flags=0x80, .name = ">TVCT" },
  { .ov = -1, .code = 0x224c, .word = 0x9c18, .immediate=0, .flags=0x80, .name = "CTPOS." },
  { .ov = -1, .code = 0x224c, .word = 0x9c48, .immediate=0, .flags=0x80, .name = "CTERASE" },
  { .ov = -1, .code = 0x224c, .word = 0x9c6e, .immediate=0, .flags=0x00, .name = "W9C6E" },
  { .ov = -1, .code = 0x224c, .word = 0x9c7a, .immediate=0, .flags=0x00, .name = "W9C7A" },
  { .ov = -1, .code = 0x224c, .word = 0x9c8e, .immediate=0, .flags=0x80, .name = "CLICK" },
  { .ov = -1, .code = 0x224c, .word = 0x9caf, .immediate=0, .flags=0x80, .name = ">SND" },
  { .ov = -1, .code = 0x224c, .word = 0x9ce4, .immediate=0, .flags=0x80, .name = "BEEPON_2" },
  { .ov = -1, .code = 0x224c, .word = 0x9cf2, .immediate=0, .flags=0x00, .name = "W9CF2" },
  { .ov = -1, .code = 0x224c, .word = 0x9cfa, .immediate=0, .flags=0x00, .name = "W9CFA" },
  { .ov = -1, .code = 0x224c, .word = 0x9d02, .immediate=0, .flags=0x00, .name = "W9D02" },
  { .ov = -1, .code = 0x224c, .word = 0x9d0a, .immediate=0, .flags=0x00, .name = "W9D0A" },
  { .ov = -1, .code = 0x224c, .word = 0x9d12, .immediate=0, .flags=0x00, .name = "W9D12" },
  { .ov = -1, .code = 0x224c, .word = 0x9d1a, .immediate=0, .flags=0x00, .name = "W9D1A" },
  { .ov = -1, .code = 0x224c, .word = 0x9d24, .immediate=0, .flags=0x00, .name = "W9D24" },
  { .ov = -1, .code = 0x224c, .word = 0x9d37, .immediate=0, .flags=0x80, .name = "SONG" },
  { .ov = -1, .code = 0x224c, .word = 0x9d8a, .immediate=0, .flags=0x80, .name = "@CRS" },
  { .ov = -1, .code = 0x224c, .word = 0x9dbf, .immediate=0, .flags=0x80, .name = "!CRS" },
  { .ov = -1, .code = 0x224c, .word = 0x9df0, .immediate=0, .flags=0x80, .name = "$." },
  { .ov = -1, .code = 0x224c, .word = 0x9e02, .immediate=0, .flags=0x80, .name = "POLY-ER" },
  { .ov = -1, .code = 0x224c, .word = 0x9e36, .immediate=0, .flags=0x80, .name = "POS.PXT" },
  { .ov = -1, .code = 0x224c, .word = 0x9e54, .immediate=0, .flags=0x00, .name = "W9E54" },
  { .ov = -1, .code = 0x224c, .word = 0x9e76, .immediate=0, .flags=0x00, .name = "W9E76" },
  { .ov = -1, .code = 0x224c, .word = 0x9e9a, .immediate=0, .flags=0x80, .name = "WUP" },
  { .ov = -1, .code = 0x224c, .word = 0x9eca, .immediate=0, .flags=0x80, .name = "WDN" },
  { .ov = -1, .code = 0x224c, .word = 0x9efe, .immediate=0, .flags=0x80, .name = "WLINE-U" },
  { .ov = -1, .code = 0x224c, .word = 0x9f10, .immediate=0, .flags=0x80, .name = "WLINE-D" },
  { .ov = -1, .code = 0x224c, .word = 0x9f1e, .immediate=0, .flags=0x80, .name = "GCR" },
  { .ov = -1, .code = 0x224c, .word = 0x9f3c, .immediate=0, .flags=0x80, .name = "WSHORTE" },
  { .ov = -1, .code = 0x224c, .word = 0x9f5e, .immediate=0, .flags=0x00, .name = "W9F5E" },
  { .ov = -1, .code = 0x224c, .word = 0x9f68, .immediate=0, .flags=0x00, .name = "W9F68" },
  { .ov = -1, .code = 0x224c, .word = 0x9f7a, .immediate=0, .flags=0x80, .name = ">BOTT" },
  { .ov = -1, .code = 0x224c, .word = 0x9f9f, .immediate=0, .flags=0x80, .name = "CTCR" },
  { .ov = -1, .code = 0x224c, .word = 0x9fbb, .immediate=0, .flags=0x80, .name = "TTY-SCR" },
  { .ov = -1, .code = 0x224c, .word = 0x9fc1, .immediate=0, .flags=0x00, .name = "W9FC1" },
  { .ov = -1, .code = 0x224c, .word = 0x9fd4, .immediate=0, .flags=0x80, .name = "CTINIT" },
  { .ov = -1, .code = 0x224c, .word = 0x9ff3, .immediate=0, .flags=0x80, .name = ".TTY" },
  { .ov = -1, .code = 0x224c, .word = 0xa005, .immediate=0, .flags=0x80, .name = "VIEWSCR" },
  { .ov = -1, .code = 0x224c, .word = 0xa0a3, .immediate=0, .flags=0x80, .name = "TXT-WIN" },
  { .ov = -1, .code = 0x224c, .word = 0xa10d, .immediate=0, .flags=0x80, .name = "AUXSCRE" },
  { .ov = -1, .code = 0x224c, .word = 0xa16d, .immediate=0, .flags=0x80, .name = "BTN-WIN" },
  { .ov = -1, .code = 0x224c, .word = 0xa1cd, .immediate=0, .flags=0x80, .name = ".BUTTON" },
  { .ov = -1, .code = 0x224c, .word = 0xa21e, .immediate=0, .flags=0x80, .name = "?MRC" },
  { .ov = -1, .code = 0x224c, .word = 0xa250, .immediate=0, .flags=0x00, .name = "WA250" },
  { .ov = -1, .code = 0x224c, .word = 0xa278, .immediate=0, .flags=0x80, .name = "ERASE-A" },
  { .ov = -1, .code = 0x224c, .word = 0xa2a0, .immediate=0, .flags=0x80, .name = "ERASE-T" },
  { .ov = -1, .code = 0x224c, .word = 0xa2c0, .immediate=0, .flags=0x00, .name = "WA2C0" },
  { .ov = -1, .code = 0x224c, .word = 0xa2e8, .immediate=0, .flags=0x80, .name = ".HIGHLI" },
  { .ov = -1, .code = 0x224c, .word = 0xa308, .immediate=0, .flags=0x00, .name = "WA308" },
  { .ov = -1, .code = 0x224c, .word = 0xa33a, .immediate=0, .flags=0x80, .name = ".ON" },
  { .ov = -1, .code = 0x224c, .word = 0xa35c, .immediate=0, .flags=0x80, .name = "CLR-BUT" },
  { .ov = -1, .code = 0x224c, .word = 0xa37e, .immediate=0, .flags=0x80, .name = "INIT-BU" },
  { .ov = -1, .code = 0x224c, .word = 0xa398, .immediate=0, .flags=0x80, .name = "(SHIP-C" },
  { .ov = -1, .code = 0x224c, .word = 0xa3ce, .immediate=0, .flags=0x80, .name = "SHIP-CO" },
  { .ov = -1, .code = 0x224c, .word = 0xa3df, .immediate=0, .flags=0x80, .name = "'KEY" },
  { .ov = -1, .code = 0x224c, .word = 0xa45f, .immediate=0, .flags=0x00, .name = "WA45F" },
  { .ov = -1, .code = 0x224c, .word = 0xa467, .immediate=0, .flags=0x00, .name = "WA467" },
  { .ov = -1, .code = 0x224c, .word = 0xa46f, .immediate=0, .flags=0x00, .name = "WA46F" },
  { .ov = -1, .code = 0x224c, .word = 0xa477, .immediate=0, .flags=0x00, .name = "WA477" },
  { .ov = -1, .code = 0x1d29, .word = 0xa489, .immediate=0, .flags=0x80, .name = "NOF" },
  { .ov = -1, .code = 0x224c, .word = 0xa494, .immediate=0, .flags=0x80, .name = "FKEY" },
  { .ov = -1, .code = 0x224c, .word = 0xa4b3, .immediate=0, .flags=0x00, .name = "WA4B3" },
  { .ov = -1, .code = 0xa49a, .word = 0xa4bf, .immediate=0, .flags=0x80, .name = "'F1" },
  { .ov = -1, .code = 0xa49a, .word = 0xa4c9, .immediate=0, .flags=0x80, .name = "'F2" },
  { .ov = -1, .code = 0xa49a, .word = 0xa4d3, .immediate=0, .flags=0x80, .name = "'F3" },
  { .ov = -1, .code = 0xa49a, .word = 0xa4dd, .immediate=0, .flags=0x80, .name = "'F4" },
  { .ov = -1, .code = 0xa49a, .word = 0xa4e7, .immediate=0, .flags=0x80, .name = "'F5" },
  { .ov = -1, .code = 0xa49a, .word = 0xa4f1, .immediate=0, .flags=0x80, .name = "'F6" },
  { .ov = -1, .code = 0xa49a, .word = 0xa4fb, .immediate=0, .flags=0x80, .name = "'F7" },
  { .ov = -1, .code = 0xa49a, .word = 0xa505, .immediate=0, .flags=0x80, .name = "'F8" },
  { .ov = -1, .code = 0xa49a, .word = 0xa50f, .immediate=0, .flags=0x80, .name = "'F9" },
  { .ov = -1, .code = 0xa49a, .word = 0xa51a, .immediate=0, .flags=0x80, .name = "'F10" },
  { .ov = -1, .code = 0x224c, .word = 0xa51e, .immediate=0, .flags=0x00, .name = "WA51E" },
  { .ov = -1, .code = 0x224c, .word = 0xa52a, .immediate=0, .flags=0x00, .name = "WA52A" },
  { .ov = -1, .code = 0x224c, .word = 0xa532, .immediate=0, .flags=0x00, .name = "WA532" },
  { .ov = -1, .code = 0x224c, .word = 0xa53a, .immediate=0, .flags=0x00, .name = "WA53A" },
  { .ov = -1, .code = 0x224c, .word = 0xa542, .immediate=0, .flags=0x00, .name = "WA542" },
  { .ov = -1, .code = 0x224c, .word = 0xa548, .immediate=0, .flags=0x00, .name = "WA548" },
  { .ov = -1, .code = 0x224c, .word = 0xa55c, .immediate=0, .flags=0x80, .name = "DOTRACE" },
  { .ov = -1, .code = 0x1d29, .word = 0xa583, .immediate=0, .flags=0x80, .name = "'TRACE" },
  { .ov = -1, .code = 0x224c, .word = 0xa587, .immediate=0, .flags=0x00, .name = "WA587" },
  { .ov = -1, .code = 0x4b3b, .word = 0xa599, .immediate=0, .flags=0x80, .name = "(XYSCAN" },
  { .ov = -1, .code = 0x224c, .word = 0xa618, .immediate=0, .flags=0x80, .name = "XYSCAN" },
  { .ov = -1, .code = 0x224c, .word = 0xa630, .immediate=0, .flags=0x80, .name = "?TRIG" },
  { .ov = -1, .code = 0x224c, .word = 0xa64a, .immediate=0, .flags=0x80, .name = "?QUIT" },
  { .ov = -1, .code = 0x224c, .word = 0xa662, .immediate=0, .flags=0x80, .name = "Y/N" },
  { .ov = -1, .code = 0x224c, .word = 0xa676, .immediate=0, .flags=0x00, .name = "WA676" },
  { .ov = -1, .code = 0x224c, .word = 0xa68a, .immediate=0, .flags=0x00, .name = "WA68A" },
  { .ov = -1, .code = 0x224c, .word = 0xa69a, .immediate=0, .flags=0x80, .name = ".ABTN" },
  { .ov = -1, .code = 0x224c, .word = 0xa6f0, .immediate=0, .flags=0x00, .name = "WA6F0" },
  { .ov = -1, .code = 0x224c, .word = 0xa71c, .immediate=0, .flags=0x80, .name = ".BTN-TE" },
  { .ov = -1, .code = 0x224c, .word = 0xa776, .immediate=0, .flags=0x80, .name = "NEW-BUT" },
  { .ov = -1, .code = 0x224c, .word = 0xa7c6, .immediate=0, .flags=0x80, .name = "CURSORS" },
  { .ov = -1, .code = 0x224c, .word = 0xa7de, .immediate=0, .flags=0x80, .name = "BLD-CRS" },
  { .ov = -1, .code = 0x224c, .word = 0xa83c, .immediate=0, .flags=0x80, .name = "SET-CRS" },
  { .ov = -1, .code = 0x224c, .word = 0xa89d, .immediate=0, .flags=0x80, .name = "$!" },
  { .ov = -1, .code = 0x224c, .word = 0xa8b3, .immediate=0, .flags=0x80, .name = "SUBROOT" },
  { .ov = -1, .code = 0x224c, .word = 0xa8c7, .immediate=0, .flags=0x80, .name = "SRDEPTH" },
  { .ov = -1, .code = 0x224c, .word = 0xa8d3, .immediate=0, .flags=0x00, .name = "WA8D3" },
  { .ov = -1, .code = 0x224c, .word = 0xa8f3, .immediate=0, .flags=0x80, .name = "NEXT-NO" },
  { .ov = -1, .code = 0x7420, .word = 0xa91b, .immediate=0, .flags=0x80, .name = "INST-VA" },
  { .ov = -1, .code = 0x7420, .word = 0xa92a, .immediate=0, .flags=0x80, .name = "INST-DA" },
  { .ov = -1, .code = 0x7420, .word = 0xa937, .immediate=0, .flags=0x80, .name = "%NAME" },
  { .ov = -1, .code = 0x7394, .word = 0xa946, .immediate=0, .flags=0x80, .name = "ORIG-NA" },
  { .ov = -1, .code = 0x7394, .word = 0xa958, .immediate=0, .flags=0x80, .name = "ELEM-NA" },
  { .ov = -1, .code = 0x7394, .word = 0xa96a, .immediate=0, .flags=0x80, .name = "ELEM-VA" },
  { .ov = -1, .code = 0x7394, .word = 0xa97c, .immediate=0, .flags=0x80, .name = "ART-NAM" },
  { .ov = -1, .code = 0x7394, .word = 0xa98e, .immediate=0, .flags=0x80, .name = "ART-VAL" },
  { .ov = -1, .code = 0x7394, .word = 0xa9a0, .immediate=0, .flags=0x80, .name = "ART-VOL" },
  { .ov = -1, .code = 0x7420, .word = 0xa9b2, .immediate=0, .flags=0x80, .name = "PHR-CNT" },
  { .ov = -1, .code = 0x7420, .word = 0xa9c0, .immediate=0, .flags=0x80, .name = "PHRASE" },
  { .ov = -1, .code = 0x7420, .word = 0xa9ce, .immediate=0, .flags=0x80, .name = "ASKING" },
  { .ov = -1, .code = 0x224c, .word = 0xa9d9, .immediate=0, .flags=0x80, .name = "U>$" },
  { .ov = -1, .code = 0x224c, .word = 0xa9e5, .immediate=0, .flags=0x00, .name = "WA9E5" },
  { .ov = -1, .code = 0x224c, .word = 0xa9fb, .immediate=0, .flags=0x00, .name = "WA9FB" },
  { .ov = -1, .code = 0x224c, .word = 0xaa1d, .immediate=0, .flags=0x80, .name = "<CTVERS" },
  { .ov = -1, .code = 0x224c, .word = 0xaa3b, .immediate=0, .flags=0x80, .name = "<CTASKM" },
  { .ov = -1, .code = 0x7420, .word = 0xaa59, .immediate=0, .flags=0x80, .name = "TEXT-CO" },
  { .ov = -1, .code = 0x7420, .word = 0xaa68, .immediate=0, .flags=0x80, .name = "TEXT-IN" },
  { .ov = -1, .code = 0x7420, .word = 0xaa77, .immediate=0, .flags=0x80, .name = "TEXT-TE" },
  { .ov = -1, .code = 0x224c, .word = 0xaa86, .immediate=0, .flags=0x80, .name = "TEXT>PA" },
  { .ov = -1, .code = 0x224c, .word = 0xaaa6, .immediate=0, .flags=0x80, .name = "CMESS" },
  { .ov = -1, .code = 0x224c, .word = 0xaadd, .immediate=0, .flags=0x80, .name = "X0MESS" },
  { .ov = -1, .code = 0x224c, .word = 0xab11, .immediate=0, .flags=0x80, .name = "0MESS" },
  { .ov = -1, .code = 0x2214, .word = 0xab19, .immediate=0, .flags=0x00, .name = "WAB19" },
  { .ov = -1, .code = 0x224c, .word = 0xab27, .immediate=0, .flags=0x80, .name = "-XTRAIL" },
  { .ov = -1, .code = 0x1d29, .word = 0xab57, .immediate=0, .flags=0x00, .name = "WAB57" },
  { .ov = -1, .code = 0x1d29, .word = 0xab63, .immediate=0, .flags=0x80, .name = "SMART" },
  { .ov = -1, .code = 0x2214, .word = 0xab67, .immediate=0, .flags=0x00, .name = "WAB67" },
  { .ov = -1, .code = 0x2214, .word = 0xab6b, .immediate=0, .flags=0x00, .name = "WAB6B" },
  { .ov = -1, .code = 0x2214, .word = 0xab6f, .immediate=0, .flags=0x00, .name = "WAB6F" },
  { .ov = -1, .code = 0x2214, .word = 0xab73, .immediate=0, .flags=0x00, .name = "WAB73" },
  { .ov = -1, .code = 0x2214, .word = 0xab77, .immediate=0, .flags=0x00, .name = "WAB77" },
  { .ov = -1, .code = 0x2214, .word = 0xab7b, .immediate=0, .flags=0x00, .name = "WAB7B" },
  { .ov = -1, .code = 0x2214, .word = 0xab7f, .immediate=0, .flags=0x00, .name = "WAB7F" },
  { .ov = -1, .code = 0x224c, .word = 0xab83, .immediate=0, .flags=0x00, .name = "WAB83" },
  { .ov = -1, .code = 0x224c, .word = 0xab95, .immediate=0, .flags=0x80, .name = "C+!" },
  { .ov = -1, .code = 0x224c, .word = 0xaba5, .immediate=0, .flags=0x00, .name = "WABA5" },
  { .ov = -1, .code = 0x224c, .word = 0xabfd, .immediate=0, .flags=0x80, .name = "DISTRAC" },
  { .ov = -1, .code = 0x224c, .word = 0xac0d, .immediate=0, .flags=0x00, .name = "WAC0D" },
  { .ov = -1, .code = 0x224c, .word = 0xac98, .immediate=0, .flags=0x80, .name = "EXPERT" },
  { .ov = -1, .code = 0x224c, .word = 0xad39, .immediate=0, .flags=0x80, .name = "-->" },
  { .ov = -1, .code = 0x224c, .word = 0xad3f, .immediate=0, .flags=0x00, .name = "WAD3F" },
  { .ov = -1, .code = 0x224c, .word = 0xad73, .immediate=0, .flags=0x00, .name = "WAD73" },
  { .ov = -1, .code = 0x224c, .word = 0xade0, .immediate=0, .flags=0x80, .name = "RULE:" },
  { .ov = -1, .code = 0x224c, .word = 0xae81, .immediate=0, .flags=0x80, .name = "CEX+WAX" },
  { .ov = -1, .code = 0x224c, .word = 0xae8d, .immediate=0, .flags=0x00, .name = "WAE8D" },
  { .ov = -1, .code = 0x224c, .word = 0xae95, .immediate=0, .flags=0x00, .name = "WAE95" },
  { .ov = -1, .code = 0x224c, .word = 0xae9d, .immediate=0, .flags=0x00, .name = "WAE9D" },
  { .ov = -1, .code = 0x224c, .word = 0xaea5, .immediate=0, .flags=0x00, .name = "WAEA5" },
  { .ov = -1, .code = 0x224c, .word = 0xaead, .immediate=0, .flags=0x00, .name = "WAEAD" },
  { .ov = -1, .code = 0x224c, .word = 0xaebb, .immediate=0, .flags=0x00, .name = "WAEBB" },
  { .ov = -1, .code = 0x224c, .word = 0xaec3, .immediate=0, .flags=0x00, .name = "WAEC3" },
  { .ov = -1, .code = 0x224c, .word = 0xaecb, .immediate=0, .flags=0x00, .name = "WAECB" },
  { .ov = -1, .code = 0x224c, .word = 0xaed3, .immediate=0, .flags=0x00, .name = "WAED3" },
  { .ov = -1, .code = 0x224c, .word = 0xaeeb, .immediate=0, .flags=0x80, .name = "?NEW-HO" },
  { .ov = -1, .code = 0x224c, .word = 0xaf01, .immediate=0, .flags=0x00, .name = "WAF01" },
  { .ov = -1, .code = 0x224c, .word = 0xaf09, .immediate=0, .flags=0x00, .name = "WAF09" },
  { .ov = -1, .code = 0x224c, .word = 0xaf81, .immediate=0, .flags=0x80, .name = "PARALLE" },
  { .ov = -1, .code = 0x224c, .word = 0xaf95, .immediate=0, .flags=0x00, .name = "WAF95" },
  { .ov = -1, .code = 0x224c, .word = 0xafa5, .immediate=0, .flags=0x00, .name = "WAFA5" },
  { .ov = -1, .code = 0x224c, .word = 0xafb5, .immediate=0, .flags=0x00, .name = "WAFB5" },
  { .ov = -1, .code = 0x224c, .word = 0xafc7, .immediate=0, .flags=0x80, .name = "DOTASKS" },
  { .ov = -1, .code = 0x224c, .word = 0xb033, .immediate=0, .flags=0x80, .name = "?VCYCLE" },
  { .ov = -1, .code = 0x224c, .word = 0xb066, .immediate=0, .flags=0x00, .name = "WB066" },
  { .ov = -1, .code = 0x224c, .word = 0xb080, .immediate=0, .flags=0x00, .name = "WB080" },
  { .ov = -1, .code = 0x224c, .word = 0xb095, .immediate=0, .flags=0x80, .name = ">XOR" },
  { .ov = -1, .code = 0x224c, .word = 0xb0c1, .immediate=0, .flags=0x00, .name = "LFCLAIM" },
  { .ov = -1, .code = 0x224c, .word = 0xb0d3, .immediate=0, .flags=0x00, .name = "AINSTALL" },
  { .ov = -1, .code = 0x224c, .word = 0xb0f5, .immediate=0, .flags=0x00, .name = "BINSTALL" },
  { .ov = -1, .code = 0x224c, .word = 0xb0ff, .immediate=0, .flags=0x00, .name = "AINSTALLS" },
  { .ov = -1, .code = 0x224c, .word = 0xb125, .immediate=0, .flags=0x00, .name = "WB125" },
  { .ov = -1, .code = 0x224c, .word = 0xb141, .immediate=0, .flags=0x00, .name = "BINSTALLS" },
  { .ov = -1, .code = 0x224c, .word = 0xb1d4, .immediate=0, .flags=0x80, .name = "ICINIT" },
  { .ov = -1, .code = 0x224c, .word = 0xb200, .immediate=0, .flags=0x00, .name = "WB200" },
  { .ov = -1, .code = 0xb22a, .word = 0xb22a, .immediate=0, .flags=0x80, .name = "XKEYINT" },
  { .ov = -1, .code = 0x224c, .word = 0xb255, .immediate=0, .flags=0x80, .name = "INSTALL" },
  { .ov = -1, .code = 0x224c, .word = 0xb27b, .immediate=0, .flags=0x00, .name = "WB27B" },
  { .ov = -1, .code = 0x224c, .word = 0xb28b, .immediate=0, .flags=0x00, .name = "WB28B" },
  { .ov = -1, .code = 0x224c, .word = 0xb2a1, .immediate=0, .flags=0x80, .name = "RESTORE" },
  { .ov = -1, .code = 0x224c, .word = 0xb2bb, .immediate=0, .flags=0x00, .name = "WB2BB" },
  { .ov = -1, .code = 0x224c, .word = 0xb2c3, .immediate=0, .flags=0x00, .name = "WB2C3" },
  { .ov = -1, .code = 0x224c, .word = 0xb2e7, .immediate=0, .flags=0x00, .name = "WB2E7" },
  { .ov = -1, .code = 0x224c, .word = 0xb2fd, .immediate=0, .flags=0x80, .name = "LOAD-DI" },
  { .ov = -1, .code = 0x224c, .word = 0xb328, .immediate=0, .flags=0x80, .name = "LDSILS" },
  { .ov = -1, .code = 0x224c, .word = 0xb33d, .immediate=0, .flags=0x80, .name = "!PAL" },
  { .ov = -1, .code = 0x224c, .word = 0xb35b, .immediate=0, .flags=0x80, .name = "CONFIGU" },
  { .ov = -1, .code = 0x224c, .word = 0xb3d3, .immediate=0, .flags=0x80, .name = "STARTER" },
  { .ov = -1, .code = 0x224c, .word = 0xb3e5, .immediate=0, .flags=0x80, .name = "DOS" },
  { .ov = -1, .code = 0x1ab5, .word = 0xb3f1, .immediate=1, .flags=0x80, .name = "+EDIT" },
  { .ov = -1, .code = 0x83dd, .word = 0xb411, .immediate=0, .flags=0x80, .name = "EDIT-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xb41c, .immediate=0, .flags=0x80, .name = "EDIT" },
  { .ov = -1, .code = 0x224c, .word = 0xb42d, .immediate=0, .flags=0x80, .name = "USE\"" },
  { .ov = -1, .code = 0x2214, .word = 0xb43a, .immediate=0, .flags=0x80, .name = "SB" },
  { .ov = -1, .code = 0xb43e, .word = 0xb43e, .immediate=0, .flags=0x00, .name = "WB43E" },
  { .ov = -1, .code = 0x224c, .word = 0xb449, .immediate=0, .flags=0x00, .name = "WB449" },
  { .ov = -1, .code = 0x224c, .word = 0xb459, .immediate=0, .flags=0x00, .name = "WB459" },
  { .ov = -1, .code = 0x224c, .word = 0xb473, .immediate=0, .flags=0x00, .name = "WB473" },
  { .ov = -1, .code = 0x224c, .word = 0xb47d, .immediate=0, .flags=0x00, .name = "WB47D" },
  { .ov = -1, .code = 0x224c, .word = 0xb48b, .immediate=0, .flags=0x00, .name = "WB48B" },
  { .ov = -1, .code = 0x224c, .word = 0xb495, .immediate=0, .flags=0x00, .name = "WB495" },
  { .ov = -1, .code = 0x224c, .word = 0xb4a9, .immediate=0, .flags=0x00, .name = "WB4A9" },
  { .ov = -1, .code = 0x224c, .word = 0xb4c3, .immediate=0, .flags=0x00, .name = "WB4C3" },
  { .ov = -1, .code = 0x224c, .word = 0xb4d9, .immediate=0, .flags=0x00, .name = "WB4D9" },
  { .ov = -1, .code = 0x224c, .word = 0xb533, .immediate=0, .flags=0x00, .name = "WB533" },
  { .ov = -1, .code = 0x224c, .word = 0xb558, .immediate=0, .flags=0x80, .name = "WS" },
  { .ov = -1, .code = 0x224c, .word = 0xb565, .immediate=0, .flags=0x80, .name = "WL" },
  { .ov = -1, .code = 0x224c, .word = 0xb56d, .immediate=0, .flags=0x00, .name = "WB56D" },
  { .ov = -1, .code = 0x224c, .word = 0xb588, .immediate=0, .flags=0x80, .name = ".S" },
  { .ov = -1, .code = 0x1ab5, .word = 0xb5a2, .immediate=1, .flags=0x80, .name = "MUSIC" },
  { .ov = -1, .code = 0x83dd, .word = 0xb5c3, .immediate=0, .flags=0x80, .name = "MUSIC-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xb5d0, .immediate=0, .flags=0x80, .name = "INTROS" },
  { .ov = -1, .code = 0x224c, .word = 0xb5e0, .immediate=0, .flags=0x80, .name = "HIMUS" },
  { .ov = -1, .code = 0x224c, .word = 0xb5f1, .immediate=0, .flags=0x80, .name = "TALLOC" },
  { .ov = -1, .code = 0x224c, .word = 0xb603, .immediate=0, .flags=0x80, .name = "SETABLT" },
  { .ov = -1, .code = 0x3b74, .word = 0xb611, .immediate=0, .flags=0x80, .name = "*OP" },
  { .ov = -1, .code = 0x3b74, .word = 0xb61f, .immediate=0, .flags=0x80, .name = "*COMM" },
  { .ov = -1, .code = 0x3b74, .word = 0xb62c, .immediate=0, .flags=0x80, .name = "*EOL" },
  { .ov = -1, .code = 0x1d29, .word = 0xb63a, .immediate=0, .flags=0x80, .name = "OTABL" },
  { .ov = -1, .code = 0x4b3b, .word = 0xb679, .immediate=0, .flags=0x80, .name = "+ORG" },
  { .ov = -1, .code = 0x224c, .word = 0xb69f, .immediate=0, .flags=0x80, .name = "ORGIA" },
  { .ov = -1, .code = 0x1ab5, .word = 0xb6c1, .immediate=1, .flags=0x80, .name = "MISC-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xb6df, .immediate=0, .flags=0x80, .name = "MISC-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xb6ec, .immediate=0, .flags=0x80, .name = "=CARGO" },
  { .ov = -1, .code = 0x224c, .word = 0xb6fd, .immediate=0, .flags=0x80, .name = "OV#IN$" },
  { .ov = -1, .code = 0x224c, .word = 0xb70e, .immediate=0, .flags=0x80, .name = "OVQUIT" },
  { .ov = -1, .code = 0x224c, .word = 0xb71f, .immediate=0, .flags=0x80, .name = "OV.0$$" },
  { .ov = -1, .code = 0x224c, .word = 0xb730, .immediate=0, .flags=0x80, .name = "OV0$$$" },
  { .ov = -1, .code = 0x224c, .word = 0xb741, .immediate=0, .flags=0x80, .name = "OVTRIM_2" },
  { .ov = -1, .code = 0x224c, .word = 0xb752, .immediate=0, .flags=0x80, .name = "OVTRIM_1" },
  { .ov = -1, .code = 0x224c, .word = 0xb76b, .immediate=0, .flags=0x80, .name = "OV?ART" },
  { .ov = -1, .code = 0x224c, .word = 0xb77c, .immediate=0, .flags=0x80, .name = "OV?.EQ" },
  { .ov = -1, .code = 0x224c, .word = 0xb78d, .immediate=0, .flags=0x80, .name = "TV?ART" },
  { .ov = -1, .code = 0x224c, .word = 0xb79c, .immediate=0, .flags=0x80, .name = "RSTE" },
  { .ov = -1, .code = 0x1ab5, .word = 0xb7ad, .immediate=1, .flags=0x80, .name = "SCON-V" },
  { .ov = -1, .code = 0x83dd, .word = 0xb7cc, .immediate=0, .flags=0x80, .name = "SCON-O" },
  { .ov = -1, .code = 0x224c, .word = 0xb7d6, .immediate=0, .flags=0x80, .name = "TOW" },
  { .ov = -1, .code = 0x224c, .word = 0xb7e7, .immediate=0, .flags=0x80, .name = ".NOFUN" },
  { .ov = -1, .code = 0x1ab5, .word = 0xb7f8, .immediate=1, .flags=0x80, .name = "FX-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xb816, .immediate=0, .flags=0x80, .name = "FX-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xb822, .immediate=0, .flags=0x80, .name = "PSYCH" },
  { .ov = -1, .code = 0x224c, .word = 0xb834, .immediate=0, .flags=0x80, .name = ".TMAP" },
  { .ov = -1, .code = 0x1ab5, .word = 0xb845, .immediate=1, .flags=0x80, .name = "IT-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xb863, .immediate=0, .flags=0x80, .name = "IT-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xb867, .immediate=0, .flags=0x00, .name = "WB867" },
  { .ov = -1, .code = 0x224c, .word = 0xb86f, .immediate=0, .flags=0x00, .name = "WB86F" },
  { .ov = -1, .code = 0x224c, .word = 0xb877, .immediate=0, .flags=0x00, .name = "WB877" },
  { .ov = -1, .code = 0x224c, .word = 0xb87f, .immediate=0, .flags=0x00, .name = "WB87F" },
  { .ov = -1, .code = 0x224c, .word = 0xb887, .immediate=0, .flags=0x00, .name = "WB887" },
  { .ov = -1, .code = 0x224c, .word = 0xb88f, .immediate=0, .flags=0x00, .name = "WB88F" },
  { .ov = -1, .code = 0x224c, .word = 0xb897, .immediate=0, .flags=0x00, .name = "WB897" },
  { .ov = -1, .code = 0x224c, .word = 0xb89f, .immediate=0, .flags=0x00, .name = "WB89F" },
  { .ov = -1, .code = 0x224c, .word = 0xb8a7, .immediate=0, .flags=0x00, .name = "WB8A7" },
  { .ov = -1, .code = 0x224c, .word = 0xb8af, .immediate=0, .flags=0x00, .name = "WB8AF" },
  { .ov = -1, .code = 0x224c, .word = 0xb8b7, .immediate=0, .flags=0x00, .name = "WB8B7" },
  { .ov = -1, .code = 0x224c, .word = 0xb8c9, .immediate=0, .flags=0x80, .name = "DATE$>A" },
  { .ov = -1, .code = 0x224c, .word = 0xb8dd, .immediate=0, .flags=0x80, .name = "BOX>LIS" },
  { .ov = -1, .code = 0x224c, .word = 0xb8f1, .immediate=0, .flags=0x80, .name = "GET-BOX" },
  { .ov = -1, .code = 0x224c, .word = 0xb905, .immediate=0, .flags=0x80, .name = "MAKE-SC" },
  { .ov = -1, .code = 0x224c, .word = 0xb919, .immediate=0, .flags=0x80, .name = "DELETE-" },
  { .ov = -1, .code = 0x224c, .word = 0xb92d, .immediate=0, .flags=0x80, .name = "BOX>TOC" },
  { .ov = -1, .code = 0x224c, .word = 0xb93e, .immediate=0, .flags=0x80, .name = ">BOX" },
  { .ov = -1, .code = 0x224c, .word = 0xb94f, .immediate=0, .flags=0x80, .name = "BOX>" },
  { .ov = -1, .code = 0x224c, .word = 0xb962, .immediate=0, .flags=0x80, .name = "(BOX>)" },
  { .ov = -1, .code = 0x224c, .word = 0xb976, .immediate=0, .flags=0x80, .name = "CLASS>B" },
  { .ov = -1, .code = 0x224c, .word = 0xb98a, .immediate=0, .flags=0x80, .name = "ITEM>PA" },
  { .ov = -1, .code = 0x1ab5, .word = 0xb99e, .immediate=1, .flags=0x80, .name = "BLT-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xb9bb, .immediate=0, .flags=0x80, .name = "BLT-" },
  { .ov = -1, .code = 0x224c, .word = 0xb9c8, .immediate=0, .flags=0x80, .name = "@.HYBR" },
  { .ov = -1, .code = 0x224c, .word = 0xb9d8, .immediate=0, .flags=0x80, .name = ".TPIC" },
  { .ov = -1, .code = 0x224c, .word = 0xb9e8, .immediate=0, .flags=0x80, .name = ".APIC" },
  { .ov = -1, .code = 0x224c, .word = 0xb9f9, .immediate=0, .flags=0x80, .name = "SETBLT" },
  { .ov = -1, .code = 0x224c, .word = 0xba0a, .immediate=0, .flags=0x80, .name = "LDAPIC" },
  { .ov = -1, .code = 0x224c, .word = 0xba1a, .immediate=0, .flags=0x80, .name = "LDSYS" },
  { .ov = -1, .code = 0x1ab5, .word = 0xba2b, .immediate=1, .flags=0x80, .name = "VICONP" },
  { .ov = -1, .code = 0x83dd, .word = 0xba49, .immediate=0, .flags=0x80, .name = "ICONP" },
  { .ov = -1, .code = 0x224c, .word = 0xba55, .immediate=0, .flags=0x80, .name = "ICON-" },
  { .ov = -1, .code = 0x224c, .word = 0xba65, .immediate=0, .flags=0x80, .name = "+ICON_1" },
  { .ov = -1, .code = 0x1ab5, .word = 0xba75, .immediate=1, .flags=0x80, .name = "FRACT" },
  { .ov = -1, .code = 0x83dd, .word = 0xba96, .immediate=0, .flags=0x80, .name = "FRACT-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xbaa2, .immediate=0, .flags=0x80, .name = "MERCA" },
  { .ov = -1, .code = 0x224c, .word = 0xbab2, .immediate=0, .flags=0x80, .name = "NEWCO" },
  { .ov = -1, .code = 0x224c, .word = 0xbac2, .immediate=0, .flags=0x80, .name = "MAKE-" },
  { .ov = -1, .code = 0x224c, .word = 0xbad2, .immediate=0, .flags=0x80, .name = "SCRLC" },
  { .ov = -1, .code = 0x1d29, .word = 0xbae3, .immediate=0, .flags=0x80, .name = "BTADDR" },
  { .ov = -1, .code = 0x1d29, .word = 0xbae7, .immediate=0, .flags=0x00, .name = "HUFF_BT_POINTER" },
  { .ov = -1, .code = 0x1d29, .word = 0xbaeb, .immediate=0, .flags=0x00, .name = "HUFF_ACTIVE_POINTER_BYTE" },
  { .ov = -1, .code = 0x1d29, .word = 0xbaef, .immediate=0, .flags=0x00, .name = "WBAEF" },
  { .ov = -1, .code = 0x1d29, .word = 0xbaf3, .immediate=0, .flags=0x00, .name = "HUFF_ACTIVE_POINTER_BIT" },
  { .ov = -1, .code = 0x2214, .word = 0xbaf7, .immediate=0, .flags=0x00, .name = "HUFF_PHRASE_ADDCHAR" },
  { .ov = -1, .code = 0x2214, .word = 0xbafb, .immediate=0, .flags=0x00, .name = "HUFF_PHRASE_INIT" },
  { .ov = -1, .code = 0x2214, .word = 0xbaff, .immediate=0, .flags=0x00, .name = "HUFF_PHRASE_FINISH" },
  { .ov = -1, .code = 0x224c, .word = 0xbb03, .immediate=0, .flags=0x00, .name = "HUFF_MOVE_ACTIVE_POINTER" },
  { .ov = -1, .code = 0x224c, .word = 0xbb29, .immediate=0, .flags=0x00, .name = "WBB29" },
  { .ov = -1, .code = 0x224c, .word = 0xbb81, .immediate=0, .flags=0x80, .name = "HUFF>" },
  { .ov = -1, .code = 0x7420, .word = 0xbbcd, .immediate=0, .flags=0x80, .name = "PHRASE$" },
  { .ov = -1, .code = 0x224c, .word = 0xbbd2, .immediate=0, .flags=0x00, .name = "HUFF_LSCAN_INIT" },
  { .ov = -1, .code = 0x224c, .word = 0xbbda, .immediate=0, .flags=0x00, .name = "HUFF_LSCAN_ADDCHAR" },
  { .ov = -1, .code = 0x224c, .word = 0xbbf0, .immediate=0, .flags=0x00, .name = "HUFF_LSCAN_FINISH" },
  { .ov = -1, .code = 0x1ab5, .word = 0xbc6e, .immediate=1, .flags=0x80, .name = "ENG-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xbc8c, .immediate=0, .flags=0x80, .name = "ENG-O" },
  { .ov = -1, .code = 0x224c, .word = 0xbc98, .immediate=0, .flags=0x80, .name = "OV/DA" },
  { .ov = -1, .code = 0x224c, .word = 0xbca8, .immediate=0, .flags=0x80, .name = "OV/RE" },
  { .ov = -1, .code = 0x224c, .word = 0xbcb8, .immediate=0, .flags=0x80, .name = "OVDBA" },
  { .ov = -1, .code = 0x1ab5, .word = 0xbcc9, .immediate=1, .flags=0x80, .name = "SETTER" },
  { .ov = -1, .code = 0x83dd, .word = 0xbcea, .immediate=0, .flags=0x80, .name = "PLSET-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xbcf9, .immediate=0, .flags=0x80, .name = "SET-PLAN" },
  { .ov = -1, .code = 0x1ab5, .word = 0xbd09, .immediate=1, .flags=0x80, .name = "ORBIT_2" },
  { .ov = -1, .code = 0x83dd, .word = 0xbd27, .immediate=0, .flags=0x80, .name = "ORBIT_1" },
  { .ov = -1, .code = 0x224c, .word = 0xbd33, .immediate=0, .flags=0x80, .name = "INIT-" },
  { .ov = -1, .code = 0x224c, .word = 0xbd45, .immediate=0, .flags=0x80, .name = "SHOWS" },
  { .ov = -1, .code = 0x224c, .word = 0xbd55, .immediate=0, .flags=0x80, .name = "DESCE" },
  { .ov = -1, .code = 0x224c, .word = 0xbd67, .immediate=0, .flags=0x80, .name = "ASCEN" },
  { .ov = -1, .code = 0x224c, .word = 0xbd79, .immediate=0, .flags=0x80, .name = "ROTAT" },
  { .ov = -1, .code = 0x224c, .word = 0xbd8b, .immediate=0, .flags=0x80, .name = "SEEGR" },
  { .ov = -1, .code = 0x224c, .word = 0xbd9b, .immediate=0, .flags=0x80, .name = "MROTA" },
  { .ov = -1, .code = 0x1ab5, .word = 0xbdaf, .immediate=1, .flags=0x80, .name = "CULTURE" },
  { .ov = -1, .code = 0x83dd, .word = 0xbdce, .immediate=0, .flags=0x80, .name = "CULTUR" },
  { .ov = -1, .code = 0x224c, .word = 0xbdda, .immediate=0, .flags=0x80, .name = ".CULT" },
  { .ov = -1, .code = 0x224c, .word = 0xbdea, .immediate=0, .flags=0x80, .name = ".RACE" },
  { .ov = -1, .code = 0x1ab5, .word = 0xbdfb, .immediate=1, .flags=0x80, .name = "DESCRI" },
  { .ov = -1, .code = 0x83dd, .word = 0xbe19, .immediate=0, .flags=0x80, .name = "DESCR" },
  { .ov = -1, .code = 0x224c, .word = 0xbe25, .immediate=0, .flags=0x80, .name = "DO-LO" },
  { .ov = -1, .code = 0x224c, .word = 0xbe35, .immediate=0, .flags=0x80, .name = ".LIFE" },
  { .ov = -1, .code = 0x224c, .word = 0xbe45, .immediate=0, .flags=0x80, .name = ".HUFF" },
  { .ov = -1, .code = 0x224c, .word = 0xbe55, .immediate=0, .flags=0x80, .name = ".AHUF" },
  { .ov = -1, .code = 0x224c, .word = 0xbe64, .immediate=0, .flags=0x80, .name = "SSCN" },
  { .ov = -1, .code = 0x224c, .word = 0xbe74, .immediate=0, .flags=0x80, .name = "?COMS" },
  { .ov = -1, .code = 0x224c, .word = 0xbe84, .immediate=0, .flags=0x80, .name = "SSCAN" },
  { .ov = -1, .code = 0x224c, .word = 0xbe96, .immediate=0, .flags=0x80, .name = "CPAUS" },
  { .ov = -1, .code = 0x1ab5, .word = 0xbea9, .immediate=1, .flags=0x80, .name = "COMM-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xbec9, .immediate=0, .flags=0x80, .name = "COMM-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xbed7, .immediate=0, .flags=0x80, .name = "OVINIT-_2" },
  { .ov = -1, .code = 0x224c, .word = 0xbef2, .immediate=0, .flags=0x80, .name = "U-COMM" },
  { .ov = -1, .code = 0x224c, .word = 0xbf06, .immediate=0, .flags=0x80, .name = "COMM-EX" },
  { .ov = -1, .code = 0x224c, .word = 0xbf16, .immediate=0, .flags=0x80, .name = "A>O" },
  { .ov = -1, .code = 0x224c, .word = 0xbf26, .immediate=0, .flags=0x80, .name = "O>C" },
  { .ov = -1, .code = 0x224c, .word = 0xbf38, .immediate=0, .flags=0x80, .name = ">HAIL" },
  { .ov = -1, .code = 0x224c, .word = 0xbf4a, .immediate=0, .flags=0x80, .name = "OV+!EDL" },
  { .ov = -1, .code = 0x224c, .word = 0xbf5e, .immediate=0, .flags=0x80, .name = "OVEDL+A" },
  { .ov = -1, .code = 0x224c, .word = 0xbf6f, .immediate=0, .flags=0x80, .name = "P>CT" },
  { .ov = -1, .code = 0x224c, .word = 0xbf80, .immediate=0, .flags=0x80, .name = "CTUP" },
  { .ov = -1, .code = 0x224c, .word = 0xbf8f, .immediate=0, .flags=0x80, .name = "1SYL" },
  { .ov = -1, .code = 0x224c, .word = 0xbfa1, .immediate=0, .flags=0x80, .name = "MCOMM-E" },
  { .ov = -1, .code = 0x224c, .word = 0xbfb5, .immediate=0, .flags=0x80, .name = "MEDL+AU" },
  { .ov = -1, .code = 0x224c, .word = 0xbfc8, .immediate=0, .flags=0x80, .name = "DA-STR" },
  { .ov = -1, .code = 0x224c, .word = 0xbfda, .immediate=0, .flags=0x80, .name = "EDL>P" },
  { .ov = -1, .code = 0x1ab5, .word = 0xbfea, .immediate=1, .flags=0x80, .name = "BLDLI-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xc008, .immediate=0, .flags=0x80, .name = "BLDLI-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc014, .immediate=0, .flags=0x80, .name = "BLDLI" },
  { .ov = -1, .code = 0x224c, .word = 0xc024, .immediate=0, .flags=0x80, .name = "SET-C" },
  { .ov = -1, .code = 0x224c, .word = 0xc032, .immediate=0, .flags=0x80, .name = "T>O" },
  { .ov = -1, .code = 0x224c, .word = 0xc042, .immediate=0, .flags=0x80, .name = "!TAMT" },
  { .ov = -1, .code = 0x224c, .word = 0xc052, .immediate=0, .flags=0x80, .name = "@TAMT" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc064, .immediate=1, .flags=0x80, .name = "SCI-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xc083, .immediate=0, .flags=0x80, .name = "SCI-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc090, .immediate=0, .flags=0x80, .name = "OV/STA" },
  { .ov = -1, .code = 0x224c, .word = 0xc0a1, .immediate=0, .flags=0x80, .name = "OV/STX" },
  { .ov = -1, .code = 0x224c, .word = 0xc0b2, .immediate=0, .flags=0x80, .name = "OVSTAR" },
  { .ov = -1, .code = 0x224c, .word = 0xc0c5, .immediate=0, .flags=0x80, .name = "OV/SEN" },
  { .ov = -1, .code = 0x224c, .word = 0xc0d6, .immediate=0, .flags=0x80, .name = "?HEAVY" },
  { .ov = -1, .code = 0x224c, .word = 0xc0e7, .immediate=0, .flags=0x80, .name = "/STARD" },
  { .ov = -1, .code = 0x224c, .word = 0xc0f9, .immediate=0, .flags=0x80, .name = ".SORD" },
  { .ov = -1, .code = 0x1d29, .word = 0xc128, .immediate=0, .flags=0x80, .name = "HEALTI" },
  { .ov = -1, .code = 0x1d29, .word = 0xc135, .immediate=0, .flags=0x80, .name = "LASTAP" },
  { .ov = -1, .code = 0x1d29, .word = 0xc144, .immediate=0, .flags=0x80, .name = "ROSTER" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc161, .immediate=1, .flags=0x80, .name = "HEALER" },
  { .ov = -1, .code = 0x83dd, .word = 0xc180, .immediate=0, .flags=0x80, .name = "HEAL-O" },
  { .ov = -1, .code = 0x224c, .word = 0xc18b, .immediate=0, .flags=0x80, .name = "(OBI" },
  { .ov = -1, .code = 0x224c, .word = 0xc19a, .immediate=0, .flags=0x80, .name = "(.VI" },
  { .ov = -1, .code = 0x224c, .word = 0xc1a9, .immediate=0, .flags=0x80, .name = "(HEA" },
  { .ov = -1, .code = 0x224c, .word = 0xc1b8, .immediate=0, .flags=0x80, .name = "(ROL" },
  { .ov = -1, .code = 0x224c, .word = 0xc1c7, .immediate=0, .flags=0x80, .name = "HEAL" },
  { .ov = -1, .code = 0x224c, .word = 0xc1d8, .immediate=0, .flags=0x80, .name = ".VIT" },
  { .ov = -1, .code = 0x224c, .word = 0xc1e9, .immediate=0, .flags=0x80, .name = "KILL" },
  { .ov = -1, .code = 0x224c, .word = 0xc1f8, .immediate=0, .flags=0x80, .name = "?APP" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc233, .immediate=1, .flags=0x80, .name = "BANK-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xc253, .immediate=0, .flags=0x80, .name = "BANK-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc261, .immediate=0, .flags=0x80, .name = "OVINIT-_1" },
  { .ov = -1, .code = 0x224c, .word = 0xc273, .immediate=0, .flags=0x80, .name = "OVTRANS" },
  { .ov = -1, .code = 0x224c, .word = 0xc285, .immediate=0, .flags=0x80, .name = "OVD@BAL" },
  { .ov = -1, .code = 0x224c, .word = 0xc297, .immediate=0, .flags=0x80, .name = "OVD!BAL" },
  { .ov = -1, .code = 0x224c, .word = 0xc2a9, .immediate=0, .flags=0x80, .name = "OV?BALA" },
  { .ov = -1, .code = 0x224c, .word = 0xc2bb, .immediate=0, .flags=0x80, .name = "OV!TFLA" },
  { .ov = -1, .code = 0x224c, .word = 0xc2cd, .immediate=0, .flags=0x80, .name = "I-TRANS" },
  { .ov = -1, .code = 0x224c, .word = 0xc2db, .immediate=0, .flags=0x80, .name = "U-B" },
  { .ov = -1, .code = 0x224c, .word = 0xc2ed, .immediate=0, .flags=0x80, .name = "T+BALAN" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc306, .immediate=1, .flags=0x80, .name = "XCOM-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xc326, .immediate=0, .flags=0x80, .name = "XCOM-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc332, .immediate=0, .flags=0x80, .name = "XCOMM" },
  { .ov = -1, .code = 0x224c, .word = 0xc342, .immediate=0, .flags=0x80, .name = "#>PRO" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc353, .immediate=1, .flags=0x80, .name = "REPAIR" },
  { .ov = -1, .code = 0x83dd, .word = 0xc373, .immediate=0, .flags=0x80, .name = "REPAIR-" },
  { .ov = -1, .code = 0x224c, .word = 0xc381, .immediate=0, .flags=0x80, .name = "DO-REPA" },
  { .ov = -1, .code = 0x224c, .word = 0xc39d, .immediate=0, .flags=0x80, .name = "?SHIP-R" },
  { .ov = -1, .code = 0x224c, .word = 0xc3cf, .immediate=0, .flags=0x80, .name = "MREPAIR" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc3f9, .immediate=1, .flags=0x80, .name = "BARTE" },
  { .ov = -1, .code = 0x83dd, .word = 0xc419, .immediate=0, .flags=0x80, .name = "BARTER-" },
  { .ov = -1, .code = 0x224c, .word = 0xc427, .immediate=0, .flags=0x80, .name = "DOENTER" },
  { .ov = -1, .code = 0x224c, .word = 0xc43a, .immediate=0, .flags=0x80, .name = "DOOPEN" },
  { .ov = -1, .code = 0x224c, .word = 0xc44e, .immediate=0, .flags=0x80, .name = "DOBARTE" },
  { .ov = -1, .code = 0x224c, .word = 0xc462, .immediate=0, .flags=0x80, .name = "!PFLAGS" },
  { .ov = -1, .code = 0x224c, .word = 0xc472, .immediate=0, .flags=0x80, .name = "L>P" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc482, .immediate=1, .flags=0x80, .name = "MAR" },
  { .ov = -1, .code = 0x83dd, .word = 0xc4a0, .immediate=0, .flags=0x80, .name = "MARKE" },
  { .ov = -1, .code = 0x224c, .word = 0xc4ac, .immediate=0, .flags=0x80, .name = "TRADE" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc4c1, .immediate=1, .flags=0x80, .name = "SITE-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xc4e1, .immediate=0, .flags=0x80, .name = "SITE-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc4ef, .immediate=0, .flags=0x80, .name = "(.MERC)" },
  { .ov = -1, .code = 0x224c, .word = 0xc505, .immediate=0, .flags=0x80, .name = "(GETSITE)" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc51c, .immediate=1, .flags=0x80, .name = "FLUX-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xc53c, .immediate=0, .flags=0x80, .name = "FLUX-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc548, .immediate=0, .flags=0x80, .name = "OVFLU" },
  { .ov = -1, .code = 0x224c, .word = 0xc558, .immediate=0, .flags=0x80, .name = "JUMPF" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc56c, .immediate=1, .flags=0x80, .name = "DPART-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xc58d, .immediate=0, .flags=0x80, .name = "DPART-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc59a, .immediate=0, .flags=0x80, .name = "DEPART" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc5ac, .immediate=1, .flags=0x80, .name = "CLOUD-V" },
  { .ov = -1, .code = 0x83dd, .word = 0xc5cc, .immediate=0, .flags=0x80, .name = "CLOUD-O" },
  { .ov = -1, .code = 0x224c, .word = 0xc5da, .immediate=0, .flags=0x80, .name = "DO-CLOU" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc5ec, .immediate=1, .flags=0x80, .name = "NAV-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xc60a, .immediate=0, .flags=0x80, .name = "NAV-O" },
  { .ov = -1, .code = 0x224c, .word = 0xc616, .immediate=0, .flags=0x80, .name = "OV/(D" },
  { .ov = -1, .code = 0x224c, .word = 0xc626, .immediate=0, .flags=0x80, .name = "OV/(U" },
  { .ov = -1, .code = 0x224c, .word = 0xc636, .immediate=0, .flags=0x80, .name = "OV-SH" },
  { .ov = -1, .code = 0x224c, .word = 0xc64e, .immediate=0, .flags=0x80, .name = "OV-AR" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc668, .immediate=1, .flags=0x80, .name = "DAMAGE-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xc688, .immediate=0, .flags=0x80, .name = "DAMAGE-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc694, .immediate=0, .flags=0x80, .name = "DO-DA" },
  { .ov = -1, .code = 0x224c, .word = 0xc6a5, .immediate=0, .flags=0x80, .name = ">DAM" },
  { .ov = -1, .code = 0x224c, .word = 0xc6ba, .immediate=0, .flags=0x80, .name = ".AUX" },
  { .ov = -1, .code = 0x224c, .word = 0xc6ca, .immediate=0, .flags=0x80, .name = "CREWD" },
  { .ov = -1, .code = 0x224c, .word = 0xc6d9, .immediate=0, .flags=0x80, .name = "BLST" },
  { .ov = -1, .code = 0x1d29, .word = 0xc6e9, .immediate=0, .flags=0x80, .name = "#MISS" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc6f4, .immediate=1, .flags=0x80, .name = "WEAP" },
  { .ov = -1, .code = 0x83dd, .word = 0xc710, .immediate=0, .flags=0x80, .name = "WEA" },
  { .ov = -1, .code = 0x224c, .word = 0xc71a, .immediate=0, .flags=0x80, .name = "TAR" },
  { .ov = -1, .code = 0x224c, .word = 0xc728, .immediate=0, .flags=0x80, .name = "DTA_2" },
  { .ov = -1, .code = 0x224c, .word = 0xc738, .immediate=0, .flags=0x80, .name = "DNL_2" },
  { .ov = -1, .code = 0x224c, .word = 0xc746, .immediate=0, .flags=0x80, .name = "GNL" },
  { .ov = -1, .code = 0x224c, .word = 0xc754, .immediate=0, .flags=0x80, .name = "DNL_1" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc768, .immediate=1, .flags=0x80, .name = "EYE-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xc786, .immediate=0, .flags=0x80, .name = "EYE-O" },
  { .ov = -1, .code = 0x224c, .word = 0xc78f, .immediate=0, .flags=0x80, .name = "AI" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc7a2, .immediate=1, .flags=0x80, .name = "COMBAU-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xc7c1, .immediate=0, .flags=0x80, .name = "COMBAU-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc7ce, .immediate=0, .flags=0x80, .name = "CSCALE" },
  { .ov = -1, .code = 0x224c, .word = 0xc7dc, .immediate=0, .flags=0x80, .name = "@NF" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc7f1, .immediate=1, .flags=0x80, .name = "COMBAT-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xc812, .immediate=0, .flags=0x80, .name = "COMBAT-O" },
  { .ov = -1, .code = 0x224c, .word = 0xc81d, .immediate=0, .flags=0x80, .name = "(WAR" },
  { .ov = -1, .code = 0x224c, .word = 0xc82e, .immediate=0, .flags=0x80, .name = "(COM" },
  { .ov = -1, .code = 0x224c, .word = 0xc83c, .immediate=0, .flags=0x80, .name = "C&C" },
  { .ov = -1, .code = 0x224c, .word = 0xc84b, .immediate=0, .flags=0x80, .name = "?J" },
  { .ov = -1, .code = 0x224c, .word = 0xc85a, .immediate=0, .flags=0x80, .name = "?JMP" },
  { .ov = -1, .code = 0x224c, .word = 0xc86b, .immediate=0, .flags=0x80, .name = "COMB" },
  { .ov = -1, .code = 0x224c, .word = 0xc87b, .immediate=0, .flags=0x80, .name = "WAR" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc88c, .immediate=1, .flags=0x80, .name = "END-" },
  { .ov = -1, .code = 0x83dd, .word = 0xc8a9, .immediate=0, .flags=0x80, .name = "ENDI" },
  { .ov = -1, .code = 0x224c, .word = 0xc8b4, .immediate=0, .flags=0x80, .name = "HALL" },
  { .ov = -1, .code = 0x224c, .word = 0xc8c3, .immediate=0, .flags=0x80, .name = "?FRE" },
  { .ov = -1, .code = 0x224c, .word = 0xc8d1, .immediate=0, .flags=0x80, .name = "DHL" },
  { .ov = -1, .code = 0x224c, .word = 0xc8e0, .immediate=0, .flags=0x80, .name = "DUHL" },
  { .ov = -1, .code = 0x224c, .word = 0xc8f1, .immediate=0, .flags=0x80, .name = "BOLT" },
  { .ov = -1, .code = 0x224c, .word = 0xc900, .immediate=0, .flags=0x80, .name = "IUHL" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc914, .immediate=1, .flags=0x80, .name = "HMISC-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xc934, .immediate=0, .flags=0x80, .name = "HMISC-O" },
  { .ov = -1, .code = 0x224c, .word = 0xc93e, .immediate=0, .flags=0x80, .name = "UFM" },
  { .ov = -1, .code = 0x224c, .word = 0xc94c, .immediate=0, .flags=0x80, .name = "USM" },
  { .ov = -1, .code = 0x224c, .word = 0xc95a, .immediate=0, .flags=0x80, .name = "NFM" },
  { .ov = -1, .code = 0x224c, .word = 0xc968, .immediate=0, .flags=0x80, .name = "NSM" },
  { .ov = -1, .code = 0x224c, .word = 0xc976, .immediate=0, .flags=0x80, .name = ".EX" },
  { .ov = -1, .code = 0x224c, .word = 0xc985, .immediate=0, .flags=0x80, .name = "DMSG" },
  { .ov = -1, .code = 0x224c, .word = 0xc994, .immediate=0, .flags=0x80, .name = "D-UP" },
  { .ov = -1, .code = 0x224c, .word = 0xc9a3, .immediate=0, .flags=0x80, .name = "ORB>" },
  { .ov = -1, .code = 0x224c, .word = 0xc9b2, .immediate=0, .flags=0x80, .name = ">ORB" },
  { .ov = -1, .code = 0x224c, .word = 0xc9c1, .immediate=0, .flags=0x80, .name = "OSET" },
  { .ov = -1, .code = 0x224c, .word = 0xc9d1, .immediate=0, .flags=0x80, .name = "ORBUP" },
  { .ov = -1, .code = 0x224c, .word = 0xc9e5, .immediate=0, .flags=0x80, .name = "TRAK-EN" },
  { .ov = -1, .code = 0x224c, .word = 0xca0d, .immediate=0, .flags=0x80, .name = "!'EXT" },
  { .ov = -1, .code = 0x224c, .word = 0xca1e, .immediate=0, .flags=0x80, .name = "(CTXT)" },
  { .ov = -1, .code = 0x224c, .word = 0xca30, .immediate=0, .flags=0x80, .name = "CONTEXT_2" },
  { .ov = -1, .code = 0x224c, .word = 0xca44, .immediate=0, .flags=0x80, .name = "+A-VESS" },
  { .ov = -1, .code = 0x224c, .word = 0xca56, .immediate=0, .flags=0x80, .name = "MTRAK-E" },
  { .ov = -1, .code = 0x1ab5, .word = 0xca6a, .immediate=1, .flags=0x80, .name = "SHPMOV-" },
  { .ov = -1, .code = 0x83dd, .word = 0xca88, .immediate=0, .flags=0x80, .name = "HYPER" },
  { .ov = -1, .code = 0x224c, .word = 0xca92, .immediate=0, .flags=0x80, .name = "FLY" },
  { .ov = -1, .code = 0x224c, .word = 0xcaa2, .immediate=0, .flags=0x80, .name = "MAN" },
  { .ov = -1, .code = 0x224c, .word = 0xcada, .immediate=0, .flags=0x80, .name = ".AS" },
  { .ov = -1, .code = 0x224c, .word = 0xcaeb, .immediate=0, .flags=0x80, .name = "JMPSHP" },
  { .ov = -1, .code = 0x224c, .word = 0xcafc, .immediate=0, .flags=0x80, .name = "UNNEST" },
  { .ov = -1, .code = 0x224c, .word = 0xcb0c, .immediate=0, .flags=0x80, .name = ">NEST" },
  { .ov = -1, .code = 0x224c, .word = 0xcb1d, .immediate=0, .flags=0x80, .name = "GET-HA" },
  { .ov = -1, .code = 0x224c, .word = 0xcb2e, .immediate=0, .flags=0x80, .name = "OV.MVS" },
  { .ov = -1, .code = 0x224c, .word = 0xcb3f, .immediate=0, .flags=0x80, .name = "S>PORT" },
  { .ov = -1, .code = 0x224c, .word = 0xcb51, .immediate=0, .flags=0x80, .name = "USE-E" },
  { .ov = -1, .code = 0x224c, .word = 0xcb62, .immediate=0, .flags=0x80, .name = "MUSE-E" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcb72, .immediate=1, .flags=0x80, .name = "ACR-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xcb8e, .immediate=0, .flags=0x80, .name = "ACR-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xcb98, .immediate=0, .flags=0x80, .name = "U-A" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcba7, .immediate=1, .flags=0x80, .name = "PFIL-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xcbc4, .immediate=0, .flags=0x80, .name = "PFIL-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xcbcf, .immediate=0, .flags=0x80, .name = "U-PF" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcbe1, .immediate=1, .flags=0x80, .name = "SHIP-GR-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xcc01, .immediate=0, .flags=0x80, .name = "SHIP-GR-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xcc0f, .immediate=0, .flags=0x80, .name = "OV.MASS" },
  { .ov = -1, .code = 0x224c, .word = 0xcc20, .immediate=0, .flags=0x80, .name = "OV.ACC" },
  { .ov = -1, .code = 0x224c, .word = 0xcc32, .immediate=0, .flags=0x80, .name = "OV.PODS" },
  { .ov = -1, .code = 0x224c, .word = 0xcc44, .immediate=0, .flags=0x80, .name = "OV.SHIP" },
  { .ov = -1, .code = 0x224c, .word = 0xcc56, .immediate=0, .flags=0x80, .name = "OVBALAN" },
  { .ov = -1, .code = 0x224c, .word = 0xcc68, .immediate=0, .flags=0x80, .name = "OV.CONF" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcc7a, .immediate=1, .flags=0x80, .name = "CONFIG-" },
  { .ov = -1, .code = 0x83dd, .word = 0xcc9c, .immediate=0, .flags=0x80, .name = "CONFIG-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xcca7, .immediate=0, .flags=0x80, .name = "U-SC" },
  { .ov = -1, .code = 0x1ab5, .word = 0xccb8, .immediate=1, .flags=0x80, .name = "TD-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xccd6, .immediate=0, .flags=0x80, .name = "TD-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xcce1, .immediate=0, .flags=0x80, .name = "U-TD" },
  { .ov = -1, .code = 0x224c, .word = 0xccf0, .immediate=0, .flags=0x80, .name = "TOSS" },
  { .ov = -1, .code = 0x224c, .word = 0xcd01, .immediate=0, .flags=0x80, .name = "KEY-EL" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcd12, .immediate=1, .flags=0x80, .name = "OP-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xcd30, .immediate=0, .flags=0x80, .name = "OP-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xcd3b, .immediate=0, .flags=0x80, .name = "U-OP" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcd4a, .immediate=1, .flags=0x80, .name = "VITA" },
  { .ov = -1, .code = 0x83dd, .word = 0xcd6a, .immediate=0, .flags=0x80, .name = "VITA-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xcd74, .immediate=0, .flags=0x80, .name = "DIO" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcd87, .immediate=1, .flags=0x80, .name = "MAPS-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xcda5, .immediate=0, .flags=0x80, .name = "MAPS-" },
  { .ov = -1, .code = 0x224c, .word = 0xcdb0, .immediate=0, .flags=0x80, .name = "MAPS" },
  { .ov = -1, .code = 0x224c, .word = 0xcdc0, .immediate=0, .flags=0x80, .name = ".STOR" },
  { .ov = -1, .code = 0x224c, .word = 0xcdd0, .immediate=0, .flags=0x80, .name = "(2X2)" },
  { .ov = -1, .code = 0x224c, .word = 0xcde0, .immediate=0, .flags=0x80, .name = "2X2CO" },
  { .ov = -1, .code = 0x224c, .word = 0xcdf2, .immediate=0, .flags=0x80, .name = "(4X4)" },
  { .ov = -1, .code = 0x224c, .word = 0xce02, .immediate=0, .flags=0x80, .name = "4X4CO" },
  { .ov = -1, .code = 0x224c, .word = 0xce14, .immediate=0, .flags=0x80, .name = "(8X8)" },
  { .ov = -1, .code = 0x224c, .word = 0xce24, .immediate=0, .flags=0x80, .name = "8X8CO" },
  { .ov = -1, .code = 0x1ab5, .word = 0xce34, .immediate=1, .flags=0x80, .name = "STO-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xce50, .immediate=0, .flags=0x80, .name = "STO-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xce5a, .immediate=0, .flags=0x80, .name = "DO." },
  { .ov = -1, .code = 0x224c, .word = 0xce68, .immediate=0, .flags=0x80, .name = "INJ" },
  { .ov = -1, .code = 0x1ab5, .word = 0xce7a, .immediate=1, .flags=0x80, .name = "DRONE-V" },
  { .ov = -1, .code = 0x83dd, .word = 0xce9a, .immediate=0, .flags=0x80, .name = "DRONE-O" },
  { .ov = -1, .code = 0x224c, .word = 0xcea4, .immediate=0, .flags=0x80, .name = "DRN" },
  { .ov = -1, .code = 0x224c, .word = 0xceb6, .immediate=0, .flags=0x80, .name = "RECAL" },
  { .ov = -1, .code = 0x224c, .word = 0xcec8, .immediate=0, .flags=0x80, .name = "DRONE" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcedc, .immediate=1, .flags=0x80, .name = "TVCON-V" },
  { .ov = -1, .code = 0x83dd, .word = 0xcefd, .immediate=0, .flags=0x80, .name = "TVCON-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xcf08, .immediate=0, .flags=0x80, .name = "DOST" },
  { .ov = -1, .code = 0x224c, .word = 0xcf1b, .immediate=0, .flags=0x80, .name = "DO-STORM" },
  { .ov = -1, .code = 0x224c, .word = 0xcf2b, .immediate=0, .flags=0x80, .name = ".ST" },
  { .ov = -1, .code = 0x224c, .word = 0xcf39, .immediate=0, .flags=0x80, .name = ".WH" },
  { .ov = -1, .code = 0x224c, .word = 0xcf47, .immediate=0, .flags=0x80, .name = ".DA" },
  { .ov = -1, .code = 0x224c, .word = 0xcf55, .immediate=0, .flags=0x80, .name = ".EN" },
  { .ov = -1, .code = 0x224c, .word = 0xcf63, .immediate=0, .flags=0x80, .name = ".CA" },
  { .ov = -1, .code = 0x224c, .word = 0xcf71, .immediate=0, .flags=0x80, .name = ".DI" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcf80, .immediate=1, .flags=0x80, .name = "SEED-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xcf9d, .immediate=0, .flags=0x80, .name = "SEED-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xcfa8, .immediate=0, .flags=0x80, .name = "POPU" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcfb8, .immediate=1, .flags=0x80, .name = "ITEMS" },
  { .ov = -1, .code = 0x83dd, .word = 0xcfd9, .immediate=0, .flags=0x80, .name = "ITEMS-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xcfe6, .immediate=0, .flags=0x80, .name = "/ITEMS" },
  { .ov = -1, .code = 0x224c, .word = 0xcff8, .immediate=0, .flags=0x80, .name = ">DEBRIS" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd009, .immediate=1, .flags=0x80, .name = "ICON-V" },
  { .ov = -1, .code = 0x83dd, .word = 0xd028, .immediate=0, .flags=0x80, .name = "LISTIC" },
  { .ov = -1, .code = 0x224c, .word = 0xd034, .immediate=0, .flags=0x80, .name = "ICONS" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd047, .immediate=1, .flags=0x80, .name = "MOVE-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xd067, .immediate=0, .flags=0x80, .name = "MOVE-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd072, .immediate=0, .flags=0x80, .name = "TVMO" },
  { .ov = -1, .code = 0x224c, .word = 0xd081, .immediate=0, .flags=0x80, .name = "?POP" },
  { .ov = -1, .code = 0x224c, .word = 0xd090, .immediate=0, .flags=0x80, .name = "!E/M" },
  { .ov = -1, .code = 0x224c, .word = 0xd09f, .immediate=0, .flags=0x80, .name = "TELE_1" },
  { .ov = -1, .code = 0x224c, .word = 0xd0ae, .immediate=0, .flags=0x80, .name = "TELE_2" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd0bf, .immediate=1, .flags=0x80, .name = "T.V." },
  { .ov = -1, .code = 0x83dd, .word = 0xd0dd, .immediate=0, .flags=0x80, .name = "TV-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd0e9, .immediate=0, .flags=0x80, .name = "TV-DI" },
  { .ov = -1, .code = 0x224c, .word = 0xd0f9, .immediate=0, .flags=0x80, .name = "(TVSE" },
  { .ov = -1, .code = 0x224c, .word = 0xd109, .immediate=0, .flags=0x80, .name = "(CLEA" },
  { .ov = -1, .code = 0x224c, .word = 0xd119, .immediate=0, .flags=0x80, .name = "(HEAV" },
  { .ov = -1, .code = 0x224c, .word = 0xd129, .immediate=0, .flags=0x80, .name = "(WEAP" },
  { .ov = -1, .code = 0x224c, .word = 0xd139, .immediate=0, .flags=0x80, .name = "(TALK" },
  { .ov = -1, .code = 0x224c, .word = 0xd149, .immediate=0, .flags=0x80, .name = "HEAVE" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd15f, .immediate=1, .flags=0x80, .name = "BEHAVIO" },
  { .ov = -1, .code = 0x83dd, .word = 0xd17d, .immediate=0, .flags=0x80, .name = "BEHAV" },
  { .ov = -1, .code = 0x224c, .word = 0xd189, .immediate=0, .flags=0x80, .name = "TVTAS" },
  { .ov = -1, .code = 0x224c, .word = 0xd196, .immediate=0, .flags=0x80, .name = "TV" },
  { .ov = -1, .code = 0x224c, .word = 0xd1a6, .immediate=0, .flags=0x80, .name = "(SIMU" },
  { .ov = -1, .code = 0x224c, .word = 0xd1b6, .immediate=0, .flags=0x80, .name = "SIMUL" },
  { .ov = -1, .code = 0x224c, .word = 0xd1c7, .immediate=0, .flags=0x80, .name = "FSTN" },
  { .ov = -1, .code = 0x224c, .word = 0xd1d7, .immediate=0, .flags=0x80, .name = "DSTUN" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd1eb, .immediate=1, .flags=0x80, .name = "STP-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xd20a, .immediate=0, .flags=0x80, .name = "STP-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd216, .immediate=0, .flags=0x80, .name = "SECUR" },
  { .ov = -1, .code = 0x224c, .word = 0xd226, .immediate=0, .flags=0x80, .name = "SIC'E" },
  { .ov = -1, .code = 0x224c, .word = 0xd235, .immediate=0, .flags=0x80, .name = "2NDS" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd248, .immediate=1, .flags=0x80, .name = "LAUNCH-V" },
  { .ov = -1, .code = 0x83dd, .word = 0xd266, .immediate=0, .flags=0x80, .name = "LAUNC" },
  { .ov = -1, .code = 0x224c, .word = 0xd272, .immediate=0, .flags=0x80, .name = "OVCOU" },
  { .ov = -1, .code = 0x224c, .word = 0xd284, .immediate=0, .flags=0x80, .name = "OVBAC" },
  { .ov = -1, .code = 0x224c, .word = 0xd296, .immediate=0, .flags=0x80, .name = ".AIRL" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd2a8, .immediate=1, .flags=0x80, .name = "CAP-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xd2c6, .immediate=0, .flags=0x80, .name = "CAP-O" },
  { .ov = -1, .code = 0x224c, .word = 0xd2d2, .immediate=0, .flags=0x80, .name = "OV/IT" },
  { .ov = -1, .code = 0x224c, .word = 0xd2e2, .immediate=0, .flags=0x80, .name = "OV/LA" },
  { .ov = -1, .code = 0x224c, .word = 0xd2f2, .immediate=0, .flags=0x80, .name = "OV>DE" },
  { .ov = -1, .code = 0x224c, .word = 0xd302, .immediate=0, .flags=0x80, .name = "OV/LO" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd314, .immediate=1, .flags=0x80, .name = "DOC-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xd333, .immediate=0, .flags=0x80, .name = "DOC-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd33f, .immediate=0, .flags=0x80, .name = "OV/EX" },
  { .ov = -1, .code = 0x224c, .word = 0xd34f, .immediate=0, .flags=0x80, .name = "OV/TR" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd360, .immediate=1, .flags=0x80, .name = "AN-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xd37e, .immediate=0, .flags=0x80, .name = "AN-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd38a, .immediate=0, .flags=0x80, .name = "OV/AN" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd399, .immediate=1, .flags=0x80, .name = "*MAP" },
  { .ov = -1, .code = 0x83dd, .word = 0xd3b9, .immediate=0, .flags=0x80, .name = "*MAP-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd3c5, .immediate=0, .flags=0x80, .name = "OV/ST" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd3dd, .immediate=1, .flags=0x80, .name = "JUMP-VO" },
  { .ov = -1, .code = 0x83dd, .word = 0xd3fd, .immediate=0, .flags=0x80, .name = "JUMP-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd408, .immediate=0, .flags=0x80, .name = "JUMP" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd41a, .immediate=1, .flags=0x80, .name = "LAND-VO" },
  { .ov = -1, .code = 0x83dd, .word = 0xd438, .immediate=0, .flags=0x80, .name = "LAND-" },
  { .ov = -1, .code = 0x224c, .word = 0xd444, .immediate=0, .flags=0x80, .name = "TRY-L_2" },
  { .ov = -1, .code = 0x224c, .word = 0xd454, .immediate=0, .flags=0x80, .name = "TRY-L_1" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd466, .immediate=1, .flags=0x80, .name = "BTN-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xd485, .immediate=0, .flags=0x80, .name = "BTN-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd491, .immediate=0, .flags=0x80, .name = "OVFLT" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd4a2, .immediate=1, .flags=0x80, .name = "CHKFLT" },
  { .ov = -1, .code = 0x83dd, .word = 0xd4c0, .immediate=0, .flags=0x80, .name = "CHKFL" },
  { .ov = -1, .code = 0x224c, .word = 0xd4cc, .immediate=0, .flags=0x80, .name = "?FLIG" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd4dd, .immediate=1, .flags=0x80, .name = "PM-VOC" },
  { .ov = -1, .code = 0x83dd, .word = 0xd4fb, .immediate=0, .flags=0x80, .name = "PM-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd507, .immediate=0, .flags=0x80, .name = "PORTM" },
  { .ov = -1, .code = 0x224c, .word = 0xd516, .immediate=0, .flags=0x80, .name = "PPIC" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd525, .immediate=1, .flags=0x80, .name = "GAME" },
  { .ov = -1, .code = 0x83dd, .word = 0xd545, .immediate=0, .flags=0x80, .name = "GAME-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd553, .immediate=0, .flags=0x80, .name = "STARTGA" },
  { .ov = -1, .code = 0x224c, .word = 0xd562, .immediate=0, .flags=0x80, .name = "ERR!" },
  { .ov = -1, .code = 0x224c, .word = 0xd571, .immediate=0, .flags=0x80, .name = "MERR" },
  { .ov = -1, .code = 0x224c, .word = 0xd585, .immediate=0, .flags=0x80, .name = "GAMEOPS" },
  { .ov = -1, .code = 0x224c, .word = 0xd599, .immediate=0, .flags=0x80, .name = "GAMEOPM" },
  { .ov = -1, .code = 0x224c, .word = 0xd5aa, .immediate=0, .flags=0x80, .name = "BOSS" },
  { .ov = -1, .code = 0x224c, .word = 0xd5b8, .immediate=0, .flags=0x80, .name = "DBS" },
  { .ov = -1, .code = 0x224c, .word = 0xd5cc, .immediate=0, .flags=0x80, .name = "LET-THE" },
  { .ov =  0, .code = 0x224c, .word = 0xef56, .immediate=0, .flags=0x00, .name = "WEF56" },
  { .ov =  0, .code = 0x2214, .word = 0xef94, .immediate=0, .flags=0x00, .name = "WEF94" },
  { .ov =  0, .code = 0x7394, .word = 0xef98, .immediate=0, .flags=0x00, .name = "WEF98" },
  { .ov =  0, .code = 0x7394, .word = 0xefa0, .immediate=0, .flags=0x00, .name = "WEFA0" },
  { .ov =  0, .code = 0x7394, .word = 0xefa8, .immediate=0, .flags=0x00, .name = "WEFA8" },
  { .ov =  0, .code = 0x7394, .word = 0xefb0, .immediate=0, .flags=0x00, .name = "WEFB0" },
  { .ov =  0, .code = 0x7394, .word = 0xefc3, .immediate=0, .flags=0x80, .name = "ATTITUDE" },
  { .ov =  0, .code = 0x7394, .word = 0xefcb, .immediate=0, .flags=0x00, .name = "WEFCB" },
  { .ov =  0, .code = 0x7394, .word = 0xefd3, .immediate=0, .flags=0x00, .name = "WEFD3" },
  { .ov =  0, .code = 0x7394, .word = 0xefdb, .immediate=0, .flags=0x00, .name = "WEFDB" },
  { .ov =  0, .code = 0x7394, .word = 0xefe3, .immediate=0, .flags=0x00, .name = "WEFE3" },
  { .ov =  0, .code = 0x7394, .word = 0xefeb, .immediate=0, .flags=0x00, .name = "WEFEB" },
  { .ov =  0, .code = 0x7394, .word = 0xeff3, .immediate=0, .flags=0x00, .name = "WEFF3" },
  { .ov =  0, .code = 0x7394, .word = 0xeffb, .immediate=0, .flags=0x00, .name = "WEFFB" },
  { .ov =  0, .code = 0x7394, .word = 0xf003, .immediate=0, .flags=0x00, .name = "WF003" },
  { .ov =  0, .code = 0x224c, .word = 0xf00b, .immediate=0, .flags=0x00, .name = "WF00B" },
  { .ov =  0, .code = 0x224c, .word = 0xf017, .immediate=0, .flags=0x00, .name = "WF017" },
  { .ov =  0, .code = 0x224c, .word = 0xf023, .immediate=0, .flags=0x00, .name = "WF023" },
  { .ov =  0, .code = 0x7394, .word = 0xf02b, .immediate=0, .flags=0x00, .name = "WF02B" },
  { .ov =  0, .code = 0x224c, .word = 0xf033, .immediate=0, .flags=0x00, .name = "WF033" },
  { .ov =  0, .code = 0x224c, .word = 0xf043, .immediate=0, .flags=0x00, .name = "WF043" },
  { .ov =  0, .code = 0x224c, .word = 0xf04f, .immediate=0, .flags=0x00, .name = "WF04F" },
  { .ov =  0, .code = 0x224c, .word = 0xf05e, .immediate=0, .flags=0x00, .name = "WF05E" },
  { .ov =  0, .code = 0x4b3b, .word = 0xf070, .immediate=0, .flags=0x80, .name = ">ECO" },
  { .ov =  0, .code = 0x224c, .word = 0xf082, .immediate=0, .flags=0x00, .name = "WF082" },
  { .ov =  0, .code = 0x224c, .word = 0xf0a2, .immediate=0, .flags=0x00, .name = "WF0A2" },
  { .ov =  0, .code = 0x224c, .word = 0xf0aa, .immediate=0, .flags=0x00, .name = "WF0AA" },
  { .ov =  0, .code = 0x224c, .word = 0xf0b4, .immediate=0, .flags=0x00, .name = "WF0B4" },
  { .ov =  0, .code = 0x224c, .word = 0xf0bc, .immediate=0, .flags=0x00, .name = "WF0BC" },
  { .ov =  0, .code = 0x224c, .word = 0xf0dc, .immediate=0, .flags=0x00, .name = "WF0DC" },
  { .ov =  0, .code = 0x224c, .word = 0xf10e, .immediate=0, .flags=0x00, .name = "WF10E" },
  { .ov =  0, .code = 0x224c, .word = 0xf199, .immediate=0, .flags=0x00, .name = "WF199" },
  { .ov =  0, .code = 0x224c, .word = 0xf1bb, .immediate=0, .flags=0x00, .name = "WF1BB" },
  { .ov =  0, .code = 0x224c, .word = 0xf1d9, .immediate=0, .flags=0x00, .name = "WF1D9" },
  { .ov =  0, .code = 0x224c, .word = 0xf1ed, .immediate=0, .flags=0x00, .name = "WF1ED" },
  { .ov =  0, .code = 0x4b3b, .word = 0xf207, .immediate=0, .flags=0x80, .name = ">EXTRA" },
  { .ov =  0, .code = 0x224c, .word = 0xf21d, .immediate=0, .flags=0x80, .name = ".RACE" },
  { .ov =  0, .code = 0x224c, .word = 0xf23d, .immediate=0, .flags=0x00, .name = "WF23D" },
  { .ov =  0, .code = 0x224c, .word = 0xf24a, .immediate=0, .flags=0x00, .name = "WF24A" },
  { .ov =  0, .code = 0x224c, .word = 0xf259, .immediate=0, .flags=0x00, .name = "WF259" },
  { .ov =  0, .code = 0x224c, .word = 0xf265, .immediate=0, .flags=0x00, .name = "WF265" },
  { .ov =  0, .code = 0x224c, .word = 0xf276, .immediate=0, .flags=0x00, .name = "WF276" },
  { .ov =  0, .code = 0x224c, .word = 0xf286, .immediate=0, .flags=0x00, .name = "WF286" },
  { .ov =  0, .code = 0x224c, .word = 0xf296, .immediate=0, .flags=0x00, .name = "WF296" },
  { .ov =  0, .code = 0x224c, .word = 0xf2a7, .immediate=0, .flags=0x00, .name = "WF2A7" },
  { .ov =  0, .code = 0x224c, .word = 0xf2b9, .immediate=0, .flags=0x00, .name = "WF2B9" },
  { .ov =  0, .code = 0x224c, .word = 0xf2ca, .immediate=0, .flags=0x00, .name = "WF2CA" },
  { .ov =  0, .code = 0x224c, .word = 0xf2dd, .immediate=0, .flags=0x00, .name = "WF2DD" },
  { .ov =  0, .code = 0x224c, .word = 0xf2f4, .immediate=0, .flags=0x00, .name = "WF2F4" },
  { .ov =  0, .code = 0x4b3b, .word = 0xf310, .immediate=0, .flags=0x80, .name = ">TECH" },
  { .ov =  0, .code = 0x224c, .word = 0xf326, .immediate=0, .flags=0x00, .name = "WF326" },
  { .ov =  0, .code = 0x4b3b, .word = 0xf350, .immediate=0, .flags=0x80, .name = ">DENSE" },
  { .ov =  0, .code = 0x224c, .word = 0xf366, .immediate=0, .flags=0x00, .name = "WF366" },
  { .ov =  0, .code = 0x4b3b, .word = 0xf396, .immediate=0, .flags=0x80, .name = ">ATT" },
  { .ov =  0, .code = 0x224c, .word = 0xf3ac, .immediate=0, .flags=0x00, .name = "WF3AC" },
  { .ov =  0, .code = 0x224c, .word = 0xf3d0, .immediate=0, .flags=0x00, .name = "WF3D0" },
  { .ov =  0, .code = 0x224c, .word = 0xf412, .immediate=0, .flags=0x00, .name = "WF412" },
  { .ov =  0, .code = 0x224c, .word = 0xf430, .immediate=0, .flags=0x00, .name = "WF430" },
  { .ov =  0, .code = 0x224c, .word = 0xf444, .immediate=0, .flags=0x00, .name = "WF444" },
  { .ov =  0, .code = 0x224c, .word = 0xf472, .immediate=0, .flags=0x00, .name = "WF472" },
  { .ov =  0, .code = 0x224c, .word = 0xf486, .immediate=0, .flags=0x00, .name = "WF486" },
  { .ov =  0, .code = 0x224c, .word = 0xf4b4, .immediate=0, .flags=0x00, .name = "WF4B4" },
  { .ov =  0, .code = 0x224c, .word = 0xf4f1, .immediate=0, .flags=0x80, .name = ".CULTURE" },
  { .ov =  1, .code = 0x7394, .word = 0xf076, .immediate=0, .flags=0x00, .name = "WF076" },
  { .ov =  1, .code = 0x224c, .word = 0xf07e, .immediate=0, .flags=0x00, .name = "WF07E" },
  { .ov =  1, .code = 0x1d29, .word = 0xf08c, .immediate=0, .flags=0x00, .name = "WF08C" },
  { .ov =  1, .code = 0x224c, .word = 0xf090, .immediate=0, .flags=0x00, .name = "WF090" },
  { .ov =  1, .code = 0x4b3b, .word = 0xf0a5, .immediate=0, .flags=0x80, .name = "N>STAT" },
  { .ov =  1, .code = 0x224c, .word = 0xf0bb, .immediate=0, .flags=0x00, .name = "WF0BB" },
  { .ov =  1, .code = 0x224c, .word = 0xf0c5, .immediate=0, .flags=0x00, .name = "WF0C5" },
  { .ov =  1, .code = 0x224c, .word = 0xf0d9, .immediate=0, .flags=0x00, .name = "WF0D9" },
  { .ov =  1, .code = 0x224c, .word = 0xf0e3, .immediate=0, .flags=0x00, .name = "WF0E3" },
  { .ov =  1, .code = 0x224c, .word = 0xf0f5, .immediate=0, .flags=0x00, .name = "WF0F5" },
  { .ov =  1, .code = 0x224c, .word = 0xf107, .immediate=0, .flags=0x00, .name = "WF107" },
  { .ov =  1, .code = 0x224c, .word = 0xf13d, .immediate=0, .flags=0x00, .name = "WF13D" },
  { .ov =  1, .code = 0x224c, .word = 0xf14f, .immediate=0, .flags=0x00, .name = "WF14F" },
  { .ov =  1, .code = 0x224c, .word = 0xf163, .immediate=0, .flags=0x00, .name = "WF163" },
  { .ov =  1, .code = 0x224c, .word = 0xf171, .immediate=0, .flags=0x00, .name = "WF171" },
  { .ov =  1, .code = 0x224c, .word = 0xf180, .immediate=0, .flags=0x00, .name = "WF180" },
  { .ov =  1, .code = 0x224c, .word = 0xf18c, .immediate=0, .flags=0x00, .name = "WF18C" },
  { .ov =  1, .code = 0x4b3b, .word = 0xf1a6, .immediate=0, .flags=0x80, .name = "#>.COL" },
  { .ov =  1, .code = 0x224c, .word = 0xf1bc, .immediate=0, .flags=0x00, .name = "WF1BC" },
  { .ov =  1, .code = 0x224c, .word = 0xf1ee, .immediate=0, .flags=0x00, .name = "WF1EE" },
  { .ov =  1, .code = 0x224c, .word = 0xf20a, .immediate=0, .flags=0x00, .name = "WF20A" },
  { .ov =  1, .code = 0x224c, .word = 0xf23a, .immediate=0, .flags=0x80, .name = "PSYCH" },
  { .ov =  1, .code = 0x224c, .word = 0xf28a, .immediate=0, .flags=0x00, .name = "WF28A" },
  { .ov =  1, .code = 0x224c, .word = 0xf2a0, .immediate=0, .flags=0x00, .name = "WF2A0" },
  { .ov =  1, .code = 0x7394, .word = 0xf2b4, .immediate=0, .flags=0x00, .name = "WF2B4" },
  { .ov =  1, .code = 0x7394, .word = 0xf2bc, .immediate=0, .flags=0x00, .name = "WF2BC" },
  { .ov =  1, .code = 0x224c, .word = 0xf2c4, .immediate=0, .flags=0x00, .name = "WF2C4" },
  { .ov =  1, .code = 0x224c, .word = 0xf2d8, .immediate=0, .flags=0x00, .name = "WF2D8" },
  { .ov =  1, .code = 0x224c, .word = 0xf2e6, .immediate=0, .flags=0x00, .name = "WF2E6" },
  { .ov =  1, .code = 0x224c, .word = 0xf2f2, .immediate=0, .flags=0x00, .name = "WF2F2" },
  { .ov =  1, .code = 0x224c, .word = 0xf2fe, .immediate=0, .flags=0x00, .name = "WF2FE" },
  { .ov =  1, .code = 0x224c, .word = 0xf30a, .immediate=0, .flags=0x00, .name = "WF30A" },
  { .ov =  1, .code = 0x224c, .word = 0xf316, .immediate=0, .flags=0x00, .name = "WF316" },
  { .ov =  1, .code = 0x224c, .word = 0xf322, .immediate=0, .flags=0x00, .name = "WF322" },
  { .ov =  1, .code = 0x224c, .word = 0xf32a, .immediate=0, .flags=0x00, .name = "WF32A" },
  { .ov =  1, .code = 0x224c, .word = 0xf3b8, .immediate=0, .flags=0x00, .name = "WF3B8" },
  { .ov =  1, .code = 0x224c, .word = 0xf3ce, .immediate=0, .flags=0x00, .name = "WF3CE" },
  { .ov =  1, .code = 0x224c, .word = 0xf3de, .immediate=0, .flags=0x00, .name = "WF3DE" },
  { .ov =  1, .code = 0x224c, .word = 0xf48c, .immediate=0, .flags=0x00, .name = "WF48C" },
  { .ov =  1, .code = 0x224c, .word = 0xf4be, .immediate=0, .flags=0x00, .name = "WF4BE" },
  { .ov =  1, .code = 0x224c, .word = 0xf4ec, .immediate=0, .flags=0x00, .name = "WF4EC" },
  { .ov =  1, .code = 0x224c, .word = 0xf544, .immediate=0, .flags=0x80, .name = ".TMAP" },
  { .ov =  2, .code = 0x1d29, .word = 0xe806, .immediate=0, .flags=0x00, .name = "WE806" },
  { .ov =  2, .code = 0x7420, .word = 0xe80a, .immediate=0, .flags=0x00, .name = "WE80A" },
  { .ov =  2, .code = 0x7420, .word = 0xe80f, .immediate=0, .flags=0x00, .name = "WE80F" },
  { .ov =  2, .code = 0x7420, .word = 0xe814, .immediate=0, .flags=0x00, .name = "WE814" },
  { .ov =  2, .code = 0x7420, .word = 0xe819, .immediate=0, .flags=0x00, .name = "WE819" },
  { .ov =  2, .code = 0x7420, .word = 0xe81e, .immediate=0, .flags=0x00, .name = "WE81E" },
  { .ov =  2, .code = 0x7394, .word = 0xe823, .immediate=0, .flags=0x00, .name = "WE823" },
  { .ov =  2, .code = 0x7420, .word = 0xe82b, .immediate=0, .flags=0x00, .name = "WE82B" },
  { .ov =  2, .code = 0x224c, .word = 0xe830, .immediate=0, .flags=0x00, .name = "WE830" },
  { .ov =  2, .code = 0x224c, .word = 0xe83c, .immediate=0, .flags=0x00, .name = "WE83C" },
  { .ov =  2, .code = 0x224c, .word = 0xe852, .immediate=0, .flags=0x00, .name = "WE852" },
  { .ov =  2, .code = 0x224c, .word = 0xe85a, .immediate=0, .flags=0x00, .name = "WE85A" },
  { .ov =  2, .code = 0x224c, .word = 0xe862, .immediate=0, .flags=0x00, .name = "WE862" },
  { .ov =  2, .code = 0x224c, .word = 0xe86a, .immediate=0, .flags=0x00, .name = "WE86A" },
  { .ov =  2, .code = 0x224c, .word = 0xe8b6, .immediate=0, .flags=0x80, .name = "FREEB" },
  { .ov =  2, .code = 0x224c, .word = 0xe8de, .immediate=0, .flags=0x00, .name = "WE8DE" },
  { .ov =  2, .code = 0x224c, .word = 0xe904, .immediate=0, .flags=0x00, .name = "WE904" },
  { .ov =  2, .code = 0x224c, .word = 0xe91c, .immediate=0, .flags=0x00, .name = "WE91C" },
  { .ov =  2, .code = 0x224c, .word = 0xe92e, .immediate=0, .flags=0x00, .name = "WE92E" },
  { .ov =  2, .code = 0x224c, .word = 0xe93a, .immediate=0, .flags=0x00, .name = "WE93A" },
  { .ov =  2, .code = 0x224c, .word = 0xe940, .immediate=0, .flags=0x00, .name = "WE940" },
  { .ov =  2, .code = 0x1d29, .word = 0xe95a, .immediate=0, .flags=0x80, .name = "EXPOS" },
  { .ov =  2, .code = 0x1d29, .word = 0xe964, .immediate=0, .flags=0x00, .name = "WE964" },
  { .ov =  2, .code = 0x1d29, .word = 0xe96a, .immediate=0, .flags=0x00, .name = "WE96A" },
  { .ov =  2, .code = 0x224c, .word = 0xe970, .immediate=0, .flags=0x00, .name = "WE970" },
  { .ov =  2, .code = 0x1d29, .word = 0xe988, .immediate=0, .flags=0x80, .name = "STAGESE" },
  { .ov =  2, .code = 0x224c, .word = 0xe990, .immediate=0, .flags=0x00, .name = "WE990" },
  { .ov =  2, .code = 0x224c, .word = 0xe9aa, .immediate=0, .flags=0x00, .name = "WE9AA" },
  { .ov =  2, .code = 0x224c, .word = 0xe9b0, .immediate=0, .flags=0x00, .name = "WE9B0" },
  { .ov =  2, .code = 0x224c, .word = 0xe9b8, .immediate=0, .flags=0x00, .name = "WE9B8" },
  { .ov =  2, .code = 0x224c, .word = 0xe9c2, .immediate=0, .flags=0x00, .name = "WE9C2" },
  { .ov =  2, .code = 0x224c, .word = 0xe9cc, .immediate=0, .flags=0x00, .name = "WE9CC" },
  { .ov =  2, .code = 0x224c, .word = 0xe9d6, .immediate=0, .flags=0x00, .name = "WE9D6" },
  { .ov =  2, .code = 0x224c, .word = 0xe9e0, .immediate=0, .flags=0x00, .name = "WE9E0" },
  { .ov =  2, .code = 0x224c, .word = 0xe9ec, .immediate=0, .flags=0x00, .name = "WE9EC" },
  { .ov =  2, .code = 0x224c, .word = 0xea06, .immediate=0, .flags=0x00, .name = "WEA06" },
  { .ov =  2, .code = 0x224c, .word = 0xea10, .immediate=0, .flags=0x00, .name = "WEA10" },
  { .ov =  2, .code = 0x224c, .word = 0xea44, .immediate=0, .flags=0x00, .name = "WEA44" },
  { .ov =  2, .code = 0x224c, .word = 0xea56, .immediate=0, .flags=0x00, .name = "WEA56" },
  { .ov =  2, .code = 0x224c, .word = 0xea92, .immediate=0, .flags=0x00, .name = "WEA92" },
  { .ov =  2, .code = 0x1d29, .word = 0xeab0, .immediate=0, .flags=0x00, .name = "WEAB0" },
  { .ov =  2, .code = 0x1d29, .word = 0xeab6, .immediate=0, .flags=0x00, .name = "WEAB6" },
  { .ov =  2, .code = 0x1d29, .word = 0xeabc, .immediate=0, .flags=0x00, .name = "WEABC" },
  { .ov =  2, .code = 0x1d29, .word = 0xeac2, .immediate=0, .flags=0x00, .name = "WEAC2" },
  { .ov =  2, .code = 0x1d29, .word = 0xeac8, .immediate=0, .flags=0x00, .name = "WEAC8" },
  { .ov =  2, .code = 0x224c, .word = 0xeace, .immediate=0, .flags=0x00, .name = "WEACE" },
  { .ov =  2, .code = 0x224c, .word = 0xeade, .immediate=0, .flags=0x00, .name = "WEADE" },
  { .ov =  2, .code = 0x224c, .word = 0xeafe, .immediate=0, .flags=0x00, .name = "WEAFE" },
  { .ov =  2, .code = 0x224c, .word = 0xeb56, .immediate=0, .flags=0x00, .name = "WEB56" },
  { .ov =  2, .code = 0x224c, .word = 0xeb62, .immediate=0, .flags=0x00, .name = "WEB62" },
  { .ov =  2, .code = 0x224c, .word = 0xebb0, .immediate=0, .flags=0x00, .name = "WEBB0" },
  { .ov =  2, .code = 0x1d29, .word = 0xebca, .immediate=0, .flags=0x00, .name = "WEBCA" },
  { .ov =  2, .code = 0x1d29, .word = 0xebce, .immediate=0, .flags=0x00, .name = "WEBCE" },
  { .ov =  2, .code = 0x224c, .word = 0xebd4, .immediate=0, .flags=0x00, .name = "WEBD4" },
  { .ov =  2, .code = 0x224c, .word = 0xebf4, .immediate=0, .flags=0x00, .name = "WEBF4" },
  { .ov =  2, .code = 0x224c, .word = 0xec1a, .immediate=0, .flags=0x00, .name = "WEC1A" },
  { .ov =  2, .code = 0x224c, .word = 0xec78, .immediate=0, .flags=0x00, .name = "WEC78" },
  { .ov =  2, .code = 0x224c, .word = 0xeca2, .immediate=0, .flags=0x00, .name = "WECA2" },
  { .ov =  2, .code = 0x2214, .word = 0xecc9, .immediate=0, .flags=0x80, .name = "TPIC" },
  { .ov =  2, .code = 0x2214, .word = 0xece0, .immediate=0, .flags=0x80, .name = "BPIC" },
  { .ov =  2, .code = 0x2214, .word = 0xecf7, .immediate=0, .flags=0x80, .name = "VPIC" },
  { .ov =  2, .code = 0x224c, .word = 0xed07, .immediate=0, .flags=0x00, .name = "WED07" },
  { .ov =  2, .code = 0x224c, .word = 0xed1f, .immediate=0, .flags=0x00, .name = "WED1F" },
  { .ov =  2, .code = 0x224c, .word = 0xed33, .immediate=0, .flags=0x00, .name = "WED33" },
  { .ov =  2, .code = 0x224c, .word = 0xed8d, .immediate=0, .flags=0x00, .name = "WED8D" },
  { .ov =  2, .code = 0x224c, .word = 0xedb9, .immediate=0, .flags=0x00, .name = "WEDB9" },
  { .ov =  2, .code = 0x224c, .word = 0xedcb, .immediate=0, .flags=0x00, .name = "WEDCB" },
  { .ov =  2, .code = 0x224c, .word = 0xede3, .immediate=0, .flags=0x00, .name = "WEDE3" },
  { .ov =  2, .code = 0x224c, .word = 0xedfd, .immediate=0, .flags=0x00, .name = "WEDFD" },
  { .ov =  2, .code = 0x224c, .word = 0xee43, .immediate=0, .flags=0x00, .name = "WEE43" },
  { .ov =  2, .code = 0x224c, .word = 0xee75, .immediate=0, .flags=0x00, .name = "WEE75" },
  { .ov =  2, .code = 0x224c, .word = 0xee81, .immediate=0, .flags=0x00, .name = "WEE81" },
  { .ov =  2, .code = 0x224c, .word = 0xeebb, .immediate=0, .flags=0x00, .name = "WEEBB" },
  { .ov =  2, .code = 0x224c, .word = 0xeed1, .immediate=0, .flags=0x00, .name = "WEED1" },
  { .ov =  2, .code = 0x224c, .word = 0xef4f, .immediate=0, .flags=0x00, .name = "WEF4F" },
  { .ov =  2, .code = 0x224c, .word = 0xef5d, .immediate=0, .flags=0x00, .name = "WEF5D" },
  { .ov =  2, .code = 0x224c, .word = 0xefab, .immediate=0, .flags=0x00, .name = "WEFAB" },
  { .ov =  2, .code = 0x224c, .word = 0xefdb, .immediate=0, .flags=0x00, .name = "WEFDB" },
  { .ov =  2, .code = 0x224c, .word = 0xf01f, .immediate=0, .flags=0x00, .name = "WF01F" },
  { .ov =  2, .code = 0x224c, .word = 0xf05b, .immediate=0, .flags=0x00, .name = "WF05B" },
  { .ov =  2, .code = 0x224c, .word = 0xf069, .immediate=0, .flags=0x00, .name = "WF069" },
  { .ov =  2, .code = 0x224c, .word = 0xf079, .immediate=0, .flags=0x00, .name = "WF079" },
  { .ov =  2, .code = 0x224c, .word = 0xf099, .immediate=0, .flags=0x00, .name = "WF099" },
  { .ov =  2, .code = 0x2214, .word = 0xf0bc, .immediate=0, .flags=0x80, .name = "ANIM" },
  { .ov =  2, .code = 0x224c, .word = 0xf0ca, .immediate=0, .flags=0x00, .name = "WF0CA" },
  { .ov =  2, .code = 0x224c, .word = 0xf0da, .immediate=0, .flags=0x00, .name = "WF0DA" },
  { .ov =  2, .code = 0x224c, .word = 0xf138, .immediate=0, .flags=0x00, .name = "WF138" },
  { .ov =  2, .code = 0x224c, .word = 0xf15c, .immediate=0, .flags=0x00, .name = "WF15C" },
  { .ov =  2, .code = 0x224c, .word = 0xf184, .immediate=0, .flags=0x00, .name = "WF184" },
  { .ov =  2, .code = 0x224c, .word = 0xf1a0, .immediate=0, .flags=0x00, .name = "WF1A0" },
  { .ov =  2, .code = 0x224c, .word = 0xf1ac, .immediate=0, .flags=0x00, .name = "WF1AC" },
  { .ov =  2, .code = 0x224c, .word = 0xf1c2, .immediate=0, .flags=0x00, .name = "WF1C2" },
  { .ov =  2, .code = 0x224c, .word = 0xf1d8, .immediate=0, .flags=0x00, .name = "WF1D8" },
  { .ov =  2, .code = 0x224c, .word = 0xf210, .immediate=0, .flags=0x00, .name = "WF210" },
  { .ov =  2, .code = 0x224c, .word = 0xf246, .immediate=0, .flags=0x00, .name = "WF246" },
  { .ov =  2, .code = 0x224c, .word = 0xf24e, .immediate=0, .flags=0x00, .name = "WF24E" },
  { .ov =  2, .code = 0x224c, .word = 0xf264, .immediate=0, .flags=0x00, .name = "WF264" },
  { .ov =  2, .code = 0x224c, .word = 0xf2b0, .immediate=0, .flags=0x00, .name = "WF2B0" },
  { .ov =  2, .code = 0x224c, .word = 0xf2fa, .immediate=0, .flags=0x00, .name = "WF2FA" },
  { .ov =  2, .code = 0x224c, .word = 0xf33e, .immediate=0, .flags=0x00, .name = "WF33E" },
  { .ov =  2, .code = 0x224c, .word = 0xf3b4, .immediate=0, .flags=0x00, .name = "WF3B4" },
  { .ov =  2, .code = 0x224c, .word = 0xf3f0, .immediate=0, .flags=0x00, .name = "WF3F0" },
  { .ov =  2, .code = 0x224c, .word = 0xf415, .immediate=0, .flags=0x80, .name = "BOLT" },
  { .ov =  2, .code = 0x224c, .word = 0xf479, .immediate=0, .flags=0x00, .name = "WF479" },
  { .ov =  2, .code = 0x224c, .word = 0xf49f, .immediate=0, .flags=0x00, .name = "WF49F" },
  { .ov =  2, .code = 0x224c, .word = 0xf4c7, .immediate=0, .flags=0x00, .name = "WF4C7" },
  { .ov =  2, .code = 0x224c, .word = 0xf4e1, .immediate=0, .flags=0x00, .name = "WF4E1" },
  { .ov =  2, .code = 0x224c, .word = 0xf4eb, .immediate=0, .flags=0x00, .name = "WF4EB" },
  { .ov =  2, .code = 0x224c, .word = 0xf4f5, .immediate=0, .flags=0x00, .name = "WF4F5" },
  { .ov =  2, .code = 0x224c, .word = 0xf516, .immediate=0, .flags=0x80, .name = "DO-HALLS" },
  { .ov =  2, .code = 0x224c, .word = 0xf536, .immediate=0, .flags=0x80, .name = "!INIT" },
  { .ov =  2, .code = 0x224c, .word = 0xf545, .immediate=0, .flags=0x80, .name = "DUHL" },
  { .ov =  3, .code = 0x7394, .word = 0xf3a6, .immediate=0, .flags=0x00, .name = "WF3A6" },
  { .ov =  3, .code = 0x224c, .word = 0xf3ae, .immediate=0, .flags=0x00, .name = "WF3AE" },
  { .ov =  3, .code = 0x224c, .word = 0xf3ba, .immediate=0, .flags=0x00, .name = "WF3BA" },
  { .ov =  3, .code = 0x4b3b, .word = 0xf3fd, .immediate=0, .flags=0x80, .name = "DISPOSAL" },
  { .ov =  3, .code = 0x224c, .word = 0xf423, .immediate=0, .flags=0x00, .name = "WF423" },
  { .ov =  3, .code = 0x224c, .word = 0xf439, .immediate=0, .flags=0x00, .name = "WF439" },
  { .ov =  3, .code = 0x224c, .word = 0xf447, .immediate=0, .flags=0x00, .name = "WF447" },
  { .ov =  3, .code = 0x224c, .word = 0xf48d, .immediate=0, .flags=0x00, .name = "WF48D" },
  { .ov =  3, .code = 0x7420, .word = 0xf4b7, .immediate=0, .flags=0x00, .name = "WF4B7" },
  { .ov =  3, .code = 0x224c, .word = 0xf4bc, .immediate=0, .flags=0x00, .name = "WF4BC" },
  { .ov =  3, .code = 0x224c, .word = 0xf511, .immediate=0, .flags=0x80, .name = "DEPART" },
  { .ov =  4, .code = 0x7420, .word = 0xf186, .immediate=0, .flags=0x00, .name = "WF186" },
  { .ov =  4, .code = 0x7420, .word = 0xf18b, .immediate=0, .flags=0x00, .name = "WF18B" },
  { .ov =  4, .code = 0x7420, .word = 0xf190, .immediate=0, .flags=0x00, .name = "WF190" },
  { .ov =  4, .code = 0x224c, .word = 0xf195, .immediate=0, .flags=0x00, .name = "WF195" },
  { .ov =  4, .code = 0x224c, .word = 0xf1cb, .immediate=0, .flags=0x00, .name = "WF1CB" },
  { .ov =  4, .code = 0x224c, .word = 0xf25e, .immediate=0, .flags=0x00, .name = "WF25E" },
  { .ov =  4, .code = 0x224c, .word = 0xf276, .immediate=0, .flags=0x00, .name = "WF276" },
  { .ov =  4, .code = 0x224c, .word = 0xf2ae, .immediate=0, .flags=0x00, .name = "WF2AE" },
  { .ov =  4, .code = 0x224c, .word = 0xf2d0, .immediate=0, .flags=0x00, .name = "WF2D0" },
  { .ov =  4, .code = 0x224c, .word = 0xf2e4, .immediate=0, .flags=0x00, .name = "WF2E4" },
  { .ov =  4, .code = 0x224c, .word = 0xf2fb, .immediate=0, .flags=0x00, .name = "WF2FB" },
  { .ov =  4, .code = 0x4b3b, .word = 0xf31b, .immediate=0, .flags=0x80, .name = "(.CS)" },
  { .ov =  4, .code = 0x1d29, .word = 0xf32d, .immediate=0, .flags=0x00, .name = "WF32D" },
  { .ov =  4, .code = 0x224c, .word = 0xf331, .immediate=0, .flags=0x00, .name = "WF331" },
  { .ov =  4, .code = 0x224c, .word = 0xf378, .immediate=0, .flags=0x00, .name = "WF378" },
  { .ov =  4, .code = 0x224c, .word = 0xf3a9, .immediate=0, .flags=0x00, .name = "WF3A9" },
  { .ov =  4, .code = 0x224c, .word = 0xf406, .immediate=0, .flags=0x00, .name = "WF406" },
  { .ov =  4, .code = 0x224c, .word = 0xf414, .immediate=0, .flags=0x00, .name = "WF414" },
  { .ov =  4, .code = 0x224c, .word = 0xf462, .immediate=0, .flags=0x00, .name = "WF462" },
  { .ov =  4, .code = 0x224c, .word = 0xf492, .immediate=0, .flags=0x00, .name = "WF492" },
  { .ov =  4, .code = 0x224c, .word = 0xf4bc, .immediate=0, .flags=0x00, .name = "WF4BC" },
  { .ov =  4, .code = 0x224c, .word = 0xf513, .immediate=0, .flags=0x80, .name = "?CAN-LEAVE" },
  { .ov =  5, .code = 0x1d29, .word = 0xe356, .immediate=0, .flags=0x00, .name = "WE356" },
  { .ov =  5, .code = 0x1d29, .word = 0xe35a, .immediate=0, .flags=0x00, .name = "WE35A" },
  { .ov =  5, .code = 0x1d29, .word = 0xe35e, .immediate=0, .flags=0x00, .name = "WE35E" },
  { .ov =  5, .code = 0x2214, .word = 0xe364, .immediate=0, .flags=0x00, .name = "WE364" },
  { .ov =  5, .code = 0x1d29, .word = 0xe368, .immediate=0, .flags=0x00, .name = "WE368" },
  { .ov =  5, .code = 0x1d29, .word = 0xe36c, .immediate=0, .flags=0x00, .name = "WE36C" },
  { .ov =  5, .code = 0x1d29, .word = 0xe370, .immediate=0, .flags=0x00, .name = "WE370" },
  { .ov =  5, .code = 0x1d29, .word = 0xe374, .immediate=0, .flags=0x00, .name = "WE374" },
  { .ov =  5, .code = 0x1d29, .word = 0xe378, .immediate=0, .flags=0x00, .name = "WE378" },
  { .ov =  5, .code = 0x1d29, .word = 0xe37c, .immediate=0, .flags=0x00, .name = "WE37C" },
  { .ov =  5, .code = 0x3b74, .word = 0xe380, .immediate=0, .flags=0x00, .name = "WE380" },
  { .ov =  5, .code = 0x2214, .word = 0xe386, .immediate=0, .flags=0x00, .name = "WE386" },
  { .ov =  5, .code = 0x1d29, .word = 0xe38a, .immediate=0, .flags=0x00, .name = "WE38A" },
  { .ov =  5, .code = 0x1d29, .word = 0xe38e, .immediate=0, .flags=0x00, .name = "WE38E" },
  { .ov =  5, .code = 0x1d29, .word = 0xe392, .immediate=0, .flags=0x00, .name = "WE392" },
  { .ov =  5, .code = 0x1d29, .word = 0xe396, .immediate=0, .flags=0x00, .name = "WE396" },
  { .ov =  5, .code = 0x224c, .word = 0xe39a, .immediate=0, .flags=0x00, .name = "WE39A" },
  { .ov =  5, .code = 0x224c, .word = 0xe3a6, .immediate=0, .flags=0x00, .name = "WE3A6" },
  { .ov =  5, .code = 0x1d29, .word = 0xe3c0, .immediate=0, .flags=0x00, .name = "WE3C0" },
  { .ov =  5, .code = 0x1d29, .word = 0xe3e0, .immediate=0, .flags=0x00, .name = "WE3E0" },
  { .ov =  5, .code = 0x1d29, .word = 0xe3fa, .immediate=0, .flags=0x00, .name = "WE3FA" },
  { .ov =  5, .code = 0x1d29, .word = 0xe469, .immediate=0, .flags=0x00, .name = "WE469" },
  { .ov =  5, .code = 0x1d29, .word = 0xe4b9, .immediate=0, .flags=0x00, .name = "WE4B9" },
  { .ov =  5, .code = 0x1d29, .word = 0xe4ef, .immediate=0, .flags=0x00, .name = "WE4EF" },
  { .ov =  5, .code = 0x1d29, .word = 0xe50f, .immediate=0, .flags=0x00, .name = "WE50F" },
  { .ov =  5, .code = 0xe537, .word = 0xe537, .immediate=0, .flags=0x00, .name = "WE537" },
  { .ov =  5, .code = 0x224c, .word = 0xe541, .immediate=0, .flags=0x00, .name = "WE541" },
  { .ov =  5, .code = 0x1d29, .word = 0xe56d, .immediate=0, .flags=0x00, .name = "WE56D" },
  { .ov =  5, .code = 0x1d29, .word = 0xe5b4, .immediate=0, .flags=0x00, .name = "WE5B4" },
  { .ov =  5, .code = 0x1d29, .word = 0xe5fb, .immediate=0, .flags=0x00, .name = "WE5FB" },
  { .ov =  5, .code = 0x1d29, .word = 0xe630, .immediate=0, .flags=0x00, .name = "WE630" },
  { .ov =  5, .code = 0x1d29, .word = 0xe691, .immediate=0, .flags=0x00, .name = "WE691" },
  { .ov =  5, .code = 0x1d29, .word = 0xe6aa, .immediate=0, .flags=0x00, .name = "WE6AA" },
  { .ov =  5, .code = 0x1d29, .word = 0xe6c2, .immediate=0, .flags=0x00, .name = "WE6C2" },
  { .ov =  5, .code = 0xe75e, .word = 0xe75e, .immediate=0, .flags=0x00, .name = "WE75E" },
  { .ov =  5, .code = 0xe770, .word = 0xe770, .immediate=0, .flags=0x00, .name = "WE770" },
  { .ov =  5, .code = 0x224c, .word = 0xe78c, .immediate=0, .flags=0x00, .name = "WE78C" },
  { .ov =  5, .code = 0x224c, .word = 0xe7b9, .immediate=0, .flags=0x80, .name = "MERCATOR-GEN" },
  { .ov =  5, .code = 0x3b74, .word = 0xe7f7, .immediate=0, .flags=0x00, .name = "WE7F7" },
  { .ov =  5, .code = 0x2214, .word = 0xe7fd, .immediate=0, .flags=0x00, .name = "WE7FD" },
  { .ov =  5, .code = 0x224c, .word = 0xe801, .immediate=0, .flags=0x00, .name = "WE801" },
  { .ov =  5, .code = 0x224c, .word = 0xe80f, .immediate=0, .flags=0x00, .name = "WE80F" },
  { .ov =  5, .code = 0x224c, .word = 0xe86f, .immediate=0, .flags=0x00, .name = "WE86F" },
  { .ov =  5, .code = 0x224c, .word = 0xe8a1, .immediate=0, .flags=0x00, .name = "WE8A1" },
  { .ov =  5, .code = 0x224c, .word = 0xe8f7, .immediate=0, .flags=0x00, .name = "WE8F7" },
  { .ov =  5, .code = 0x224c, .word = 0xe921, .immediate=0, .flags=0x00, .name = "WE921" },
  { .ov =  5, .code = 0x224c, .word = 0xe94f, .immediate=0, .flags=0x00, .name = "WE94F" },
  { .ov =  5, .code = 0x224c, .word = 0xe979, .immediate=0, .flags=0x00, .name = "WE979" },
  { .ov =  5, .code = 0x224c, .word = 0xe985, .immediate=0, .flags=0x00, .name = "WE985" },
  { .ov =  5, .code = 0x224c, .word = 0xea21, .immediate=0, .flags=0x00, .name = "WEA21" },
  { .ov =  5, .code = 0x224c, .word = 0xea37, .immediate=0, .flags=0x00, .name = "WEA37" },
  { .ov =  5, .code = 0x224c, .word = 0xea97, .immediate=0, .flags=0x00, .name = "WEA97" },
  { .ov =  5, .code = 0x1d29, .word = 0xeacd, .immediate=0, .flags=0x00, .name = "WEACD" },
  { .ov =  5, .code = 0xead1, .word = 0xead1, .immediate=0, .flags=0x00, .name = "WEAD1" },
  { .ov =  5, .code = 0xeadc, .word = 0xeadc, .immediate=0, .flags=0x00, .name = "WEADC" },
  { .ov =  5, .code = 0xeaea, .word = 0xeaea, .immediate=0, .flags=0x00, .name = "WEAEA" },
  { .ov =  5, .code = 0xeaf8, .word = 0xeaf8, .immediate=0, .flags=0x00, .name = "WEAF8" },
  { .ov =  5, .code = 0x224c, .word = 0xeb06, .immediate=0, .flags=0x00, .name = "WEB06" },
  { .ov =  5, .code = 0x224c, .word = 0xeb0e, .immediate=0, .flags=0x00, .name = "WEB0E" },
  { .ov =  5, .code = 0x224c, .word = 0xeb16, .immediate=0, .flags=0x00, .name = "WEB16" },
  { .ov =  5, .code = 0x224c, .word = 0xeb20, .immediate=0, .flags=0x00, .name = "WEB20" },
  { .ov =  5, .code = 0x224c, .word = 0xeb28, .immediate=0, .flags=0x00, .name = "WEB28" },
  { .ov =  5, .code = 0x224c, .word = 0xeb30, .immediate=0, .flags=0x00, .name = "WEB30" },
  { .ov =  5, .code = 0x224c, .word = 0xeb38, .immediate=0, .flags=0x00, .name = "WEB38" },
  { .ov =  5, .code = 0x224c, .word = 0xeb42, .immediate=0, .flags=0x00, .name = "WEB42" },
  { .ov =  5, .code = 0x224c, .word = 0xeb4c, .immediate=0, .flags=0x00, .name = "WEB4C" },
  { .ov =  5, .code = 0x224c, .word = 0xeb54, .immediate=0, .flags=0x00, .name = "WEB54" },
  { .ov =  5, .code = 0x224c, .word = 0xeb5e, .immediate=0, .flags=0x00, .name = "WEB5E" },
  { .ov =  5, .code = 0x1d29, .word = 0xeb80, .immediate=0, .flags=0x80, .name = "POLYPTR" },
  { .ov =  5, .code = 0x1d29, .word = 0xeb84, .immediate=0, .flags=0x00, .name = "WEB84" },
  { .ov =  5, .code = 0x1d29, .word = 0xeb88, .immediate=0, .flags=0x00, .name = "WEB88" },
  { .ov =  5, .code = 0x1d29, .word = 0xeb8c, .immediate=0, .flags=0x00, .name = "WEB8C" },
  { .ov =  5, .code = 0x224c, .word = 0xeb90, .immediate=0, .flags=0x00, .name = "WEB90" },
  { .ov =  5, .code = 0x224c, .word = 0xebfc, .immediate=0, .flags=0x00, .name = "WEBFC" },
  { .ov =  5, .code = 0x224c, .word = 0xec70, .immediate=0, .flags=0x80, .name = "POLYGON-EXTRACT" },
  { .ov =  5, .code = 0x224c, .word = 0xecc6, .immediate=0, .flags=0x00, .name = "WECC6" },
  { .ov =  5, .code = 0x1d29, .word = 0xed30, .immediate=0, .flags=0x00, .name = "WED30" },
  { .ov =  5, .code = 0xed34, .word = 0xed34, .immediate=0, .flags=0x00, .name = "WED34" },
  { .ov =  5, .code = 0xed44, .word = 0xed44, .immediate=0, .flags=0x00, .name = "WED44" },
  { .ov =  5, .code = 0xed50, .word = 0xed50, .immediate=0, .flags=0x00, .name = "WED50" },
  { .ov =  5, .code = 0xed62, .word = 0xed62, .immediate=0, .flags=0x00, .name = "WED62" },
  { .ov =  5, .code = 0x1d29, .word = 0xed7d, .immediate=0, .flags=0x80, .name = "FADDR" },
  { .ov =  5, .code = 0x1d29, .word = 0xed81, .immediate=0, .flags=0x00, .name = "WED81" },
  { .ov =  5, .code = 0x1d29, .word = 0xed85, .immediate=0, .flags=0x00, .name = "WED85" },
  { .ov =  5, .code = 0x1d29, .word = 0xed89, .immediate=0, .flags=0x00, .name = "WED89" },
  { .ov =  5, .code = 0x224c, .word = 0xed8d, .immediate=0, .flags=0x00, .name = "WED8D" },
  { .ov =  5, .code = 0x224c, .word = 0xedd9, .immediate=0, .flags=0x00, .name = "WEDD9" },
  { .ov =  5, .code = 0xee65, .word = 0xee65, .immediate=0, .flags=0x00, .name = "WEE65" },
  { .ov =  5, .code = 0xee96, .word = 0xee96, .immediate=0, .flags=0x00, .name = "WEE96" },
  { .ov =  5, .code = 0xeec2, .word = 0xeec2, .immediate=0, .flags=0x00, .name = "WEEC2" },
  { .ov =  5, .code = 0xeecc, .word = 0xeecc, .immediate=0, .flags=0x00, .name = "WEECC" },
  { .ov =  5, .code = 0xeee5, .word = 0xeee5, .immediate=0, .flags=0x00, .name = "WEEE5" },
  { .ov =  5, .code = 0x224c, .word = 0xeefa, .immediate=0, .flags=0x00, .name = "WEEFA" },
  { .ov =  5, .code = 0x224c, .word = 0xef86, .immediate=0, .flags=0x00, .name = "WEF86" },
  { .ov =  5, .code = 0x224c, .word = 0xefad, .immediate=0, .flags=0x80, .name = "MAKE-GLOBE" },
  { .ov =  5, .code = 0x224c, .word = 0xefb5, .immediate=0, .flags=0x00, .name = "WEFB5" },
  { .ov =  5, .code = 0x224c, .word = 0xefd9, .immediate=0, .flags=0x00, .name = "WEFD9" },
  { .ov =  5, .code = 0x224c, .word = 0xeffb, .immediate=0, .flags=0x00, .name = "WEFFB" },
  { .ov =  5, .code = 0x224c, .word = 0xf023, .immediate=0, .flags=0x00, .name = "WF023" },
  { .ov =  5, .code = 0x224c, .word = 0xf049, .immediate=0, .flags=0x00, .name = "WF049" },
  { .ov =  5, .code = 0x224c, .word = 0xf08b, .immediate=0, .flags=0x00, .name = "WF08B" },
  { .ov =  5, .code = 0x224c, .word = 0xf0d7, .immediate=0, .flags=0x80, .name = "SCRLCON" },
  { .ov =  5, .code = 0x224c, .word = 0xf108, .immediate=0, .flags=0x80, .name = "NEWCONTOUR" },
  { .ov =  6, .code = 0x7420, .word = 0xf0c6, .immediate=0, .flags=0x00, .name = "WF0C6" },
  { .ov =  6, .code = 0x7420, .word = 0xf0cb, .immediate=0, .flags=0x00, .name = "WF0CB" },
  { .ov =  6, .code = 0x7394, .word = 0xf0d0, .immediate=0, .flags=0x00, .name = "WF0D0" },
  { .ov =  6, .code = 0x7420, .word = 0xf0d8, .immediate=0, .flags=0x00, .name = "WF0D8" },
  { .ov =  6, .code = 0x7394, .word = 0xf0dd, .immediate=0, .flags=0x00, .name = "WF0DD" },
  { .ov =  6, .code = 0x7420, .word = 0xf0e5, .immediate=0, .flags=0x00, .name = "WF0E5" },
  { .ov =  6, .code = 0x7420, .word = 0xf0ea, .immediate=0, .flags=0x00, .name = "WF0EA" },
  { .ov =  6, .code = 0x7394, .word = 0xf0ef, .immediate=0, .flags=0x00, .name = "WF0EF" },
  { .ov =  6, .code = 0x7420, .word = 0xf0f7, .immediate=0, .flags=0x00, .name = "WF0F7" },
  { .ov =  6, .code = 0x7394, .word = 0xf0fc, .immediate=0, .flags=0x00, .name = "WF0FC" },
  { .ov =  6, .code = 0x7420, .word = 0xf104, .immediate=0, .flags=0x00, .name = "WF104" },
  { .ov =  6, .code = 0x7420, .word = 0xf109, .immediate=0, .flags=0x00, .name = "WF109" },
  { .ov =  6, .code = 0x7394, .word = 0xf10e, .immediate=0, .flags=0x00, .name = "WF10E" },
  { .ov =  6, .code = 0x2214, .word = 0xf116, .immediate=0, .flags=0x00, .name = "WF116" },
  { .ov =  6, .code = 0x2214, .word = 0xf11a, .immediate=0, .flags=0x00, .name = "WF11A" },
  { .ov =  6, .code = 0x2214, .word = 0xf11e, .immediate=0, .flags=0x00, .name = "WF11E" },
  { .ov =  6, .code = 0x2214, .word = 0xf122, .immediate=0, .flags=0x00, .name = "WF122" },
  { .ov =  6, .code = 0x2214, .word = 0xf126, .immediate=0, .flags=0x00, .name = "WF126" },
  { .ov =  6, .code = 0x2214, .word = 0xf12a, .immediate=0, .flags=0x00, .name = "WF12A" },
  { .ov =  6, .code = 0x2214, .word = 0xf12e, .immediate=0, .flags=0x00, .name = "WF12E" },
  { .ov =  6, .code = 0x2214, .word = 0xf132, .immediate=0, .flags=0x00, .name = "WF132" },
  { .ov =  6, .code = 0x2214, .word = 0xf136, .immediate=0, .flags=0x00, .name = "WF136" },
  { .ov =  6, .code = 0x2214, .word = 0xf13a, .immediate=0, .flags=0x00, .name = "WF13A" },
  { .ov =  6, .code = 0x2214, .word = 0xf13e, .immediate=0, .flags=0x00, .name = "WF13E" },
  { .ov =  6, .code = 0x2214, .word = 0xf142, .immediate=0, .flags=0x00, .name = "WF142" },
  { .ov =  6, .code = 0x2214, .word = 0xf146, .immediate=0, .flags=0x00, .name = "WF146" },
  { .ov =  6, .code = 0x2214, .word = 0xf14a, .immediate=0, .flags=0x00, .name = "WF14A" },
  { .ov =  6, .code = 0x2214, .word = 0xf14e, .immediate=0, .flags=0x00, .name = "WF14E" },
  { .ov =  6, .code = 0x2214, .word = 0xf152, .immediate=0, .flags=0x00, .name = "WF152" },
  { .ov =  6, .code = 0x2214, .word = 0xf156, .immediate=0, .flags=0x00, .name = "WF156" },
  { .ov =  6, .code = 0x2214, .word = 0xf15a, .immediate=0, .flags=0x00, .name = "WF15A" },
  { .ov =  6, .code = 0x2214, .word = 0xf15e, .immediate=0, .flags=0x00, .name = "WF15E" },
  { .ov =  6, .code = 0x2214, .word = 0xf162, .immediate=0, .flags=0x00, .name = "WF162" },
  { .ov =  6, .code = 0x2214, .word = 0xf166, .immediate=0, .flags=0x00, .name = "WF166" },
  { .ov =  6, .code = 0x224c, .word = 0xf16a, .immediate=0, .flags=0x00, .name = "WF16A" },
  { .ov =  6, .code = 0x224c, .word = 0xf172, .immediate=0, .flags=0x00, .name = "WF172" },
  { .ov =  6, .code = 0x224c, .word = 0xf184, .immediate=0, .flags=0x00, .name = "WF184" },
  { .ov =  6, .code = 0x224c, .word = 0xf192, .immediate=0, .flags=0x00, .name = "WF192" },
  { .ov =  6, .code = 0x4b3b, .word = 0xf1df, .immediate=0, .flags=0x80, .name = "STAR-ID-CASE" },
  { .ov =  6, .code = 0x224c, .word = 0xf1e9, .immediate=0, .flags=0x00, .name = "WF1E9" },
  { .ov =  6, .code = 0x4b3b, .word = 0xf202, .immediate=0, .flags=0x80, .name = "PLANET-ID-CA" },
  { .ov =  6, .code = 0x224c, .word = 0xf20c, .immediate=0, .flags=0x00, .name = "WF20C" },
  { .ov =  6, .code = 0x224c, .word = 0xf216, .immediate=0, .flags=0x00, .name = "WF216" },
  { .ov =  6, .code = 0x4b3b, .word = 0xf22b, .immediate=0, .flags=0x80, .name = "BOX-ID" },
  { .ov =  6, .code = 0x224c, .word = 0xf239, .immediate=0, .flags=0x00, .name = "WF239" },
  { .ov =  6, .code = 0x224c, .word = 0xf245, .immediate=0, .flags=0x00, .name = "WF245" },
  { .ov =  6, .code = 0x4b3b, .word = 0xf264, .immediate=0, .flags=0x80, .name = "SPACE-ID" },
  { .ov =  6, .code = 0x224c, .word = 0xf28e, .immediate=0, .flags=0x00, .name = "WF28E" },
  { .ov =  6, .code = 0x4b3b, .word = 0xf2b5, .immediate=0, .flags=0x80, .name = "RUIN-ID-CASE" },
  { .ov =  6, .code = 0x224c, .word = 0xf2cb, .immediate=0, .flags=0x00, .name = "WF2CB" },
  { .ov =  6, .code = 0x224c, .word = 0xf2e7, .immediate=0, .flags=0x00, .name = "WF2E7" },
  { .ov =  6, .code = 0x224c, .word = 0xf2ef, .immediate=0, .flags=0x00, .name = "WF2EF" },
  { .ov =  6, .code = 0x224c, .word = 0xf31f, .immediate=0, .flags=0x00, .name = "WF31F" },
  { .ov =  6, .code = 0x4b3b, .word = 0xf333, .immediate=0, .flags=0x80, .name = "PLANET-ID" },
  { .ov =  6, .code = 0x224c, .word = 0xf365, .immediate=0, .flags=0x00, .name = "WF365" },
  { .ov =  6, .code = 0x4b3b, .word = 0xf38a, .immediate=0, .flags=0x80, .name = "STAR-IC-CASE" },
  { .ov =  6, .code = 0x224c, .word = 0xf3a8, .immediate=0, .flags=0x00, .name = "WF3A8" },
  { .ov =  6, .code = 0x224c, .word = 0xf3b0, .immediate=0, .flags=0x00, .name = "WF3B0" },
  { .ov =  6, .code = 0x224c, .word = 0xf3c2, .immediate=0, .flags=0x00, .name = "WF3C2" },
  { .ov =  6, .code = 0x224c, .word = 0xf3e6, .immediate=0, .flags=0x00, .name = "WF3E6" },
  { .ov =  6, .code = 0x4b3b, .word = 0xf407, .immediate=0, .flags=0x80, .name = "PLAN-IC-CASE" },
  { .ov =  6, .code = 0x224c, .word = 0xf421, .immediate=0, .flags=0x00, .name = "WF421" },
  { .ov =  6, .code = 0x224c, .word = 0xf42b, .immediate=0, .flags=0x00, .name = "WF42B" },
  { .ov =  6, .code = 0x4b3b, .word = 0xf446, .immediate=0, .flags=0x80, .name = "BOX-IC" },
  { .ov =  6, .code = 0x224c, .word = 0xf454, .immediate=0, .flags=0x00, .name = "WF454" },
  { .ov =  6, .code = 0x224c, .word = 0xf460, .immediate=0, .flags=0x00, .name = "WF460" },
  { .ov =  6, .code = 0x4b3b, .word = 0xf48e, .immediate=0, .flags=0x80, .name = "#IC-CASES" },
  { .ov =  6, .code = 0x224c, .word = 0xf4b4, .immediate=0, .flags=0x00, .name = "WF4B4" },
  { .ov =  6, .code = 0x224c, .word = 0xf4bc, .immediate=0, .flags=0x00, .name = "WF4BC" },
  { .ov =  6, .code = 0x224c, .word = 0xf508, .immediate=0, .flags=0x80, .name = "ICON-PARM" },
  { .ov =  6, .code = 0x224c, .word = 0xf51a, .immediate=0, .flags=0x00, .name = "WF51A" },
  { .ov =  6, .code = 0x224c, .word = 0xf533, .immediate=0, .flags=0x80, .name = "+ICONBOX" },
  { .ov =  7, .code = 0x1d29, .word = 0xf160, .immediate=0, .flags=0x80, .name = "LTLNBLT" },
  { .ov =  7, .code = 0x224c, .word = 0xf16e, .immediate=0, .flags=0x00, .name = "WF16E" },
  { .ov =  7, .code = 0x224c, .word = 0xf176, .immediate=0, .flags=0x00, .name = "WF176" },
  { .ov =  7, .code = 0x224c, .word = 0xf17e, .immediate=0, .flags=0x00, .name = "WF17E" },
  { .ov =  7, .code = 0x224c, .word = 0xf1e1, .immediate=0, .flags=0x00, .name = "WF1E1" },
  { .ov =  7, .code = 0x1d29, .word = 0xf22b, .immediate=0, .flags=0x00, .name = "WF22B" },
  { .ov =  7, .code = 0x1d29, .word = 0xf22f, .immediate=0, .flags=0x00, .name = "WF22F" },
  { .ov =  7, .code = 0x224c, .word = 0xf233, .immediate=0, .flags=0x00, .name = "WF233" },
  { .ov =  7, .code = 0x224c, .word = 0xf2a7, .immediate=0, .flags=0x00, .name = "WF2A7" },
  { .ov =  7, .code = 0x224c, .word = 0xf31b, .immediate=0, .flags=0x00, .name = "WF31B" },
  { .ov =  7, .code = 0x224c, .word = 0xf34d, .immediate=0, .flags=0x00, .name = "WF34D" },
  { .ov =  7, .code = 0x224c, .word = 0xf38d, .immediate=0, .flags=0x00, .name = "WF38D" },
  { .ov =  7, .code = 0x224c, .word = 0xf3b7, .immediate=0, .flags=0x00, .name = "WF3B7" },
  { .ov =  7, .code = 0x224c, .word = 0xf3df, .immediate=0, .flags=0x00, .name = "WF3DF" },
  { .ov =  7, .code = 0x224c, .word = 0xf425, .immediate=0, .flags=0x00, .name = "WF425" },
  { .ov =  7, .code = 0x224c, .word = 0xf42f, .immediate=0, .flags=0x00, .name = "WF42F" },
  { .ov =  7, .code = 0x224c, .word = 0xf441, .immediate=0, .flags=0x80, .name = "GETSITE_1" },
  { .ov =  7, .code = 0x224c, .word = 0xf4f5, .immediate=0, .flags=0x80, .name = ".MERCATOR" },
  { .ov =  7, .code = 0x224c, .word = 0xf547, .immediate=0, .flags=0x80, .name = "GETSITE_2" },
  { .ov =  8, .code = 0x224c, .word = 0xe666, .immediate=0, .flags=0x00, .name = "WE666" },
  { .ov =  8, .code = 0x224c, .word = 0xe66e, .immediate=0, .flags=0x00, .name = "WE66E" },
  { .ov =  8, .code = 0x2214, .word = 0xe678, .immediate=0, .flags=0x00, .name = "WE678" },
  { .ov =  8, .code = 0x2214, .word = 0xe67c, .immediate=0, .flags=0x00, .name = "WE67C" },
  { .ov =  8, .code = 0x2214, .word = 0xe680, .immediate=0, .flags=0x00, .name = "WE680" },
  { .ov =  8, .code = 0x2214, .word = 0xe684, .immediate=0, .flags=0x00, .name = "WE684" },
  { .ov =  8, .code = 0x2214, .word = 0xe688, .immediate=0, .flags=0x00, .name = "WE688" },
  { .ov =  8, .code = 0x224c, .word = 0xe68c, .immediate=0, .flags=0x00, .name = "WE68C" },
  { .ov =  8, .code = 0x7420, .word = 0xe69c, .immediate=0, .flags=0x00, .name = "WE69C" },
  { .ov =  8, .code = 0x7394, .word = 0xe6a1, .immediate=0, .flags=0x00, .name = "WE6A1" },
  { .ov =  8, .code = 0x7420, .word = 0xe6a9, .immediate=0, .flags=0x00, .name = "WE6A9" },
  { .ov =  8, .code = 0x7394, .word = 0xe6ae, .immediate=0, .flags=0x00, .name = "WE6AE" },
  { .ov =  8, .code = 0x7394, .word = 0xe6b6, .immediate=0, .flags=0x00, .name = "WE6B6" },
  { .ov =  8, .code = 0x7420, .word = 0xe6be, .immediate=0, .flags=0x00, .name = "WE6BE" },
  { .ov =  8, .code = 0x7420, .word = 0xe6c3, .immediate=0, .flags=0x00, .name = "WE6C3" },
  { .ov =  8, .code = 0x7420, .word = 0xe6c8, .immediate=0, .flags=0x00, .name = "WE6C8" },
  { .ov =  8, .code = 0x7420, .word = 0xe6cd, .immediate=0, .flags=0x00, .name = "WE6CD" },
  { .ov =  8, .code = 0x7420, .word = 0xe6d2, .immediate=0, .flags=0x00, .name = "WE6D2" },
  { .ov =  8, .code = 0x7420, .word = 0xe6d7, .immediate=0, .flags=0x00, .name = "WE6D7" },
  { .ov =  8, .code = 0x7420, .word = 0xe6dc, .immediate=0, .flags=0x00, .name = "WE6DC" },
  { .ov =  8, .code = 0x7420, .word = 0xe6e1, .immediate=0, .flags=0x00, .name = "WE6E1" },
  { .ov =  8, .code = 0x7420, .word = 0xe6e6, .immediate=0, .flags=0x00, .name = "WE6E6" },
  { .ov =  8, .code = 0x7420, .word = 0xe6eb, .immediate=0, .flags=0x00, .name = "WE6EB" },
  { .ov =  8, .code = 0x7420, .word = 0xe6f0, .immediate=0, .flags=0x00, .name = "WE6F0" },
  { .ov =  8, .code = 0x7420, .word = 0xe6f5, .immediate=0, .flags=0x00, .name = "WE6F5" },
  { .ov =  8, .code = 0x4b3b, .word = 0xe704, .immediate=0, .flags=0x80, .name = "GET-VES" },
  { .ov =  8, .code = 0x224c, .word = 0xe716, .immediate=0, .flags=0x00, .name = "WE716" },
  { .ov =  8, .code = 0x224c, .word = 0xe788, .immediate=0, .flags=0x00, .name = "WE788" },
  { .ov =  8, .code = 0x224c, .word = 0xe79c, .immediate=0, .flags=0x00, .name = "WE79C" },
  { .ov =  8, .code = 0x224c, .word = 0xe7cc, .immediate=0, .flags=0x00, .name = "WE7CC" },
  { .ov =  8, .code = 0x224c, .word = 0xe7f0, .immediate=0, .flags=0x00, .name = "WE7F0" },
  { .ov =  8, .code = 0x224c, .word = 0xe83c, .immediate=0, .flags=0x00, .name = "WE83C" },
  { .ov =  8, .code = 0x224c, .word = 0xe852, .immediate=0, .flags=0x80, .name = "?LIQUID" },
  { .ov =  8, .code = 0x224c, .word = 0xe868, .immediate=0, .flags=0x00, .name = "WE868" },
  { .ov =  8, .code = 0x224c, .word = 0xe880, .immediate=0, .flags=0x00, .name = "WE880" },
  { .ov =  8, .code = 0x224c, .word = 0xe8c8, .immediate=0, .flags=0x00, .name = "WE8C8" },
  { .ov =  8, .code = 0x224c, .word = 0xe8ea, .immediate=0, .flags=0x00, .name = "WE8EA" },
  { .ov =  8, .code = 0x224c, .word = 0xe90a, .immediate=0, .flags=0x00, .name = "WE90A" },
  { .ov =  8, .code = 0x224c, .word = 0xe91c, .immediate=0, .flags=0x00, .name = "WE91C" },
  { .ov =  8, .code = 0x224c, .word = 0xe93a, .immediate=0, .flags=0x00, .name = "WE93A" },
  { .ov =  8, .code = 0x224c, .word = 0xe960, .immediate=0, .flags=0x00, .name = "WE960" },
  { .ov =  8, .code = 0x224c, .word = 0xe976, .immediate=0, .flags=0x00, .name = "WE976" },
  { .ov =  8, .code = 0x224c, .word = 0xe98a, .immediate=0, .flags=0x00, .name = "WE98A" },
  { .ov =  8, .code = 0x224c, .word = 0xe9a2, .immediate=0, .flags=0x00, .name = "WE9A2" },
  { .ov =  8, .code = 0x4b3b, .word = 0xe9cb, .immediate=0, .flags=0x80, .name = "DISP-SETUP" },
  { .ov =  8, .code = 0x1d29, .word = 0xe9e5, .immediate=0, .flags=0x00, .name = "WE9E5" },
  { .ov =  8, .code = 0x224c, .word = 0xe9e9, .immediate=0, .flags=0x00, .name = "WE9E9" },
  { .ov =  8, .code = 0x224c, .word = 0xea05, .immediate=0, .flags=0x00, .name = "WEA05" },
  { .ov =  8, .code = 0x224c, .word = 0xea19, .immediate=0, .flags=0x00, .name = "WEA19" },
  { .ov =  8, .code = 0x224c, .word = 0xea47, .immediate=0, .flags=0x00, .name = "WEA47" },
  { .ov =  8, .code = 0x224c, .word = 0xea57, .immediate=0, .flags=0x00, .name = "WEA57" },
  { .ov =  8, .code = 0x224c, .word = 0xea7a, .immediate=0, .flags=0x00, .name = "WEA7A" },
  { .ov =  8, .code = 0x224c, .word = 0xea86, .immediate=0, .flags=0x00, .name = "WEA86" },
  { .ov =  8, .code = 0x224c, .word = 0xea93, .immediate=0, .flags=0x00, .name = "WEA93" },
  { .ov =  8, .code = 0x224c, .word = 0xeaa2, .immediate=0, .flags=0x00, .name = "WEAA2" },
  { .ov =  8, .code = 0x224c, .word = 0xeab2, .immediate=0, .flags=0x00, .name = "WEAB2" },
  { .ov =  8, .code = 0x224c, .word = 0xeaca, .immediate=0, .flags=0x00, .name = "WEACA" },
  { .ov =  8, .code = 0x224c, .word = 0xeae1, .immediate=0, .flags=0x00, .name = "WEAE1" },
  { .ov =  8, .code = 0x224c, .word = 0xeb0f, .immediate=0, .flags=0x00, .name = "WEB0F" },
  { .ov =  8, .code = 0x224c, .word = 0xeb2d, .immediate=0, .flags=0x00, .name = "WEB2D" },
  { .ov =  8, .code = 0x224c, .word = 0xeb52, .immediate=0, .flags=0x00, .name = "WEB52" },
  { .ov =  8, .code = 0x224c, .word = 0xeb75, .immediate=0, .flags=0x00, .name = "WEB75" },
  { .ov =  8, .code = 0x224c, .word = 0xeb8e, .immediate=0, .flags=0x00, .name = "WEB8E" },
  { .ov =  8, .code = 0x4b3b, .word = 0xebb7, .immediate=0, .flags=0x80, .name = "NF-M" },
  { .ov =  8, .code = 0x224c, .word = 0xebdb, .immediate=0, .flags=0x80, .name = "NF-MESS" },
  { .ov =  8, .code = 0x224c, .word = 0xebe3, .immediate=0, .flags=0x00, .name = "WEBE3" },
  { .ov =  8, .code = 0x224c, .word = 0xec11, .immediate=0, .flags=0x00, .name = "WEC11" },
  { .ov =  8, .code = 0x224c, .word = 0xec3a, .immediate=0, .flags=0x00, .name = "WEC3A" },
  { .ov =  8, .code = 0x224c, .word = 0xec64, .immediate=0, .flags=0x00, .name = "WEC64" },
  { .ov =  8, .code = 0x224c, .word = 0xec8c, .immediate=0, .flags=0x00, .name = "WEC8C" },
  { .ov =  8, .code = 0x4b3b, .word = 0xecda, .immediate=0, .flags=0x80, .name = "NS-M" },
  { .ov =  8, .code = 0x224c, .word = 0xecfe, .immediate=0, .flags=0x80, .name = "NS-MESS" },
  { .ov =  8, .code = 0x7394, .word = 0xed06, .immediate=0, .flags=0x00, .name = "WED06" },
  { .ov =  8, .code = 0x7394, .word = 0xed18, .immediate=0, .flags=0x80, .name = "P-LSEED" },
  { .ov =  8, .code = 0x7394, .word = 0xed20, .immediate=0, .flags=0x00, .name = "WED20" },
  { .ov =  8, .code = 0x7420, .word = 0xed28, .immediate=0, .flags=0x00, .name = "WED28" },
  { .ov =  8, .code = 0x7420, .word = 0xed2d, .immediate=0, .flags=0x00, .name = "WED2D" },
  { .ov =  8, .code = 0x224c, .word = 0xed32, .immediate=0, .flags=0x00, .name = "WED32" },
  { .ov =  8, .code = 0x4b3b, .word = 0xed4d, .immediate=0, .flags=0x80, .name = "S>CM" },
  { .ov =  8, .code = 0x224c, .word = 0xed5f, .immediate=0, .flags=0x00, .name = "WED5F" },
  { .ov =  8, .code = 0x224c, .word = 0xed70, .immediate=0, .flags=0x80, .name = "OSET" },
  { .ov =  8, .code = 0x224c, .word = 0xedca, .immediate=0, .flags=0x00, .name = "WEDCA" },
  { .ov =  8, .code = 0x224c, .word = 0xedd2, .immediate=0, .flags=0x00, .name = "WEDD2" },
  { .ov =  8, .code = 0x224c, .word = 0xede8, .immediate=0, .flags=0x00, .name = "WEDE8" },
  { .ov =  8, .code = 0x224c, .word = 0xee09, .immediate=0, .flags=0x00, .name = "WEE09" },
  { .ov =  8, .code = 0x224c, .word = 0xee7d, .immediate=0, .flags=0x00, .name = "WEE7D" },
  { .ov =  8, .code = 0x4b3b, .word = 0xeeae, .immediate=0, .flags=0x80, .name = "UF-M" },
  { .ov =  8, .code = 0x224c, .word = 0xeed2, .immediate=0, .flags=0x80, .name = "UF-MESS" },
  { .ov =  8, .code = 0x224c, .word = 0xeeda, .immediate=0, .flags=0x00, .name = "WEEDA" },
  { .ov =  8, .code = 0x224c, .word = 0xeef3, .immediate=0, .flags=0x00, .name = "WEEF3" },
  { .ov =  8, .code = 0x224c, .word = 0xeefb, .immediate=0, .flags=0x00, .name = "WEEFB" },
  { .ov =  8, .code = 0x224c, .word = 0xef03, .immediate=0, .flags=0x00, .name = "WEF03" },
  { .ov =  8, .code = 0x224c, .word = 0xef0b, .immediate=0, .flags=0x00, .name = "WEF0B" },
  { .ov =  8, .code = 0x4b3b, .word = 0xef1a, .immediate=0, .flags=0x80, .name = "US-M" },
  { .ov =  8, .code = 0x224c, .word = 0xef3a, .immediate=0, .flags=0x80, .name = "US-MESS" },
  { .ov =  8, .code = 0x224c, .word = 0xef42, .immediate=0, .flags=0x00, .name = "WEF42" },
  { .ov =  8, .code = 0x224c, .word = 0xef4a, .immediate=0, .flags=0x00, .name = "WEF4A" },
  { .ov =  8, .code = 0x224c, .word = 0xef52, .immediate=0, .flags=0x00, .name = "WEF52" },
  { .ov =  8, .code = 0x224c, .word = 0xef6e, .immediate=0, .flags=0x00, .name = "WEF6E" },
  { .ov =  8, .code = 0x224c, .word = 0xef8f, .immediate=0, .flags=0x00, .name = "WEF8F" },
  { .ov =  8, .code = 0x4b3b, .word = 0xefad, .immediate=0, .flags=0x80, .name = ".EX" },
  { .ov =  8, .code = 0x224c, .word = 0xefbb, .immediate=0, .flags=0x00, .name = "WEFBB" },
  { .ov =  8, .code = 0x7420, .word = 0xefd5, .immediate=0, .flags=0x00, .name = "WEFD5" },
  { .ov =  8, .code = 0x1d29, .word = 0xefda, .immediate=0, .flags=0x00, .name = "WEFDA" },
  { .ov =  8, .code = 0x224c, .word = 0xefe5, .immediate=0, .flags=0x80, .name = "DMSG" },
  { .ov =  8, .code = 0x224c, .word = 0xf04d, .immediate=0, .flags=0x00, .name = "WF04D" },
  { .ov =  8, .code = 0x224c, .word = 0xf055, .immediate=0, .flags=0x00, .name = "WF055" },
  { .ov =  8, .code = 0x224c, .word = 0xf069, .immediate=0, .flags=0x00, .name = "WF069" },
  { .ov =  8, .code = 0x224c, .word = 0xf071, .immediate=0, .flags=0x00, .name = "WF071" },
  { .ov =  8, .code = 0x224c, .word = 0xf079, .immediate=0, .flags=0x00, .name = "WF079" },
  { .ov =  8, .code = 0x224c, .word = 0xf08f, .immediate=0, .flags=0x00, .name = "WF08F" },
  { .ov =  8, .code = 0x4b3b, .word = 0xf0bc, .immediate=0, .flags=0x80, .name = "(CTXT)" },
  { .ov =  8, .code = 0x1d29, .word = 0xf0d6, .immediate=0, .flags=0x00, .name = "WF0D6" },
  { .ov =  8, .code = 0x1d29, .word = 0xf0da, .immediate=0, .flags=0x00, .name = "WF0DA" },
  { .ov =  8, .code = 0x1d29, .word = 0xf0de, .immediate=0, .flags=0x00, .name = "WF0DE" },
  { .ov =  8, .code = 0x1d29, .word = 0xf0e2, .immediate=0, .flags=0x00, .name = "WF0E2" },
  { .ov =  8, .code = 0x224c, .word = 0xf0e6, .immediate=0, .flags=0x00, .name = "WF0E6" },
  { .ov =  8, .code = 0x7420, .word = 0xf167, .immediate=0, .flags=0x00, .name = "WF167" },
  { .ov =  8, .code = 0x7420, .word = 0xf16c, .immediate=0, .flags=0x00, .name = "WF16C" },
  { .ov =  8, .code = 0x7420, .word = 0xf171, .immediate=0, .flags=0x00, .name = "WF171" },
  { .ov =  8, .code = 0x224c, .word = 0xf176, .immediate=0, .flags=0x00, .name = "WF176" },
  { .ov =  8, .code = 0x224c, .word = 0xf18e, .immediate=0, .flags=0x00, .name = "WF18E" },
  { .ov =  8, .code = 0x224c, .word = 0xf200, .immediate=0, .flags=0x00, .name = "WF200" },
  { .ov =  8, .code = 0x224c, .word = 0xf248, .immediate=0, .flags=0x00, .name = "WF248" },
  { .ov =  8, .code = 0x224c, .word = 0xf278, .immediate=0, .flags=0x00, .name = "WF278" },
  { .ov =  8, .code = 0x1d29, .word = 0xf290, .immediate=0, .flags=0x00, .name = "WF290" },
  { .ov =  8, .code = 0x224c, .word = 0xf29d, .immediate=0, .flags=0x80, .name = "TRAK-E" },
  { .ov =  8, .code = 0x224c, .word = 0xf331, .immediate=0, .flags=0x00, .name = "WF331" },
  { .ov =  8, .code = 0x2214, .word = 0xf339, .immediate=0, .flags=0x00, .name = "WF339" },
  { .ov =  8, .code = 0x224c, .word = 0xf33d, .immediate=0, .flags=0x00, .name = "WF33D" },
  { .ov =  8, .code = 0x4b3b, .word = 0xf34d, .immediate=0, .flags=0x80, .name = "@'EXT" },
  { .ov =  8, .code = 0x224c, .word = 0xf369, .immediate=0, .flags=0x80, .name = "(!'EXT)" },
  { .ov =  8, .code = 0x224c, .word = 0xf381, .immediate=0, .flags=0x80, .name = "+A-VESS" },
  { .ov =  8, .code = 0x224c, .word = 0xf401, .immediate=0, .flags=0x00, .name = "WF401" },
  { .ov =  8, .code = 0x224c, .word = 0xf409, .immediate=0, .flags=0x00, .name = "WF409" },
  { .ov =  8, .code = 0x224c, .word = 0xf413, .immediate=0, .flags=0x00, .name = "WF413" },
  { .ov =  8, .code = 0x7420, .word = 0xf42b, .immediate=0, .flags=0x00, .name = "WF42B" },
  { .ov =  8, .code = 0x1d29, .word = 0xf430, .immediate=0, .flags=0x00, .name = "WF430" },
  { .ov =  8, .code = 0x1d29, .word = 0xf434, .immediate=0, .flags=0x00, .name = "WF434" },
  { .ov =  8, .code = 0x224c, .word = 0xf438, .immediate=0, .flags=0x00, .name = "WF438" },
  { .ov =  8, .code = 0x224c, .word = 0xf464, .immediate=0, .flags=0x00, .name = "WF464" },
  { .ov =  8, .code = 0x224c, .word = 0xf4b2, .immediate=0, .flags=0x00, .name = "WF4B2" },
  { .ov =  8, .code = 0x224c, .word = 0xf4e6, .immediate=0, .flags=0x80, .name = ">ORBITS" },
  { .ov =  8, .code = 0x224c, .word = 0xf506, .immediate=0, .flags=0x00, .name = "WF506" },
  { .ov =  8, .code = 0x224c, .word = 0xf530, .immediate=0, .flags=0x80, .name = "ORBITS>" },
  { .ov =  9, .code = 0x1d29, .word = 0xeff6, .immediate=0, .flags=0x00, .name = "WEFF6" },
  { .ov =  9, .code = 0x1d29, .word = 0xf006, .immediate=0, .flags=0x00, .name = "WF006" },
  { .ov =  9, .code = 0x1d29, .word = 0xf01b, .immediate=0, .flags=0x00, .name = "WF01B" },
  { .ov =  9, .code = 0x224c, .word = 0xf046, .immediate=0, .flags=0x00, .name = "WF046" },
  { .ov =  9, .code = 0x224c, .word = 0xf058, .immediate=0, .flags=0x00, .name = "WF058" },
  { .ov =  9, .code = 0x1d29, .word = 0xf068, .immediate=0, .flags=0x00, .name = "WF068" },
  { .ov =  9, .code = 0x224c, .word = 0xf07b, .immediate=0, .flags=0x00, .name = "WF07B" },
  { .ov =  9, .code = 0x224c, .word = 0xf0f1, .immediate=0, .flags=0x00, .name = "WF0F1" },
  { .ov =  9, .code = 0x224c, .word = 0xf111, .immediate=0, .flags=0x00, .name = "WF111" },
  { .ov =  9, .code = 0x224c, .word = 0xf12b, .immediate=0, .flags=0x00, .name = "WF12B" },
  { .ov =  9, .code = 0x224c, .word = 0xf145, .immediate=0, .flags=0x00, .name = "WF145" },
  { .ov =  9, .code = 0x224c, .word = 0xf179, .immediate=0, .flags=0x00, .name = "WF179" },
  { .ov =  9, .code = 0x224c, .word = 0xf192, .immediate=0, .flags=0x80, .name = "LDAP" },
  { .ov =  9, .code = 0x224c, .word = 0xf1d8, .immediate=0, .flags=0x00, .name = "WF1D8" },
  { .ov =  9, .code = 0x224c, .word = 0xf200, .immediate=0, .flags=0x00, .name = "WF200" },
  { .ov =  9, .code = 0x224c, .word = 0xf210, .immediate=0, .flags=0x00, .name = "WF210" },
  { .ov =  9, .code = 0x224c, .word = 0xf222, .immediate=0, .flags=0x00, .name = "WF222" },
  { .ov =  9, .code = 0x224c, .word = 0xf25a, .immediate=0, .flags=0x00, .name = "WF25A" },
  { .ov =  9, .code = 0x224c, .word = 0xf26a, .immediate=0, .flags=0x00, .name = "WF26A" },
  { .ov =  9, .code = 0x224c, .word = 0xf280, .immediate=0, .flags=0x00, .name = "WF280" },
  { .ov =  9, .code = 0x224c, .word = 0xf30a, .immediate=0, .flags=0x00, .name = "WF30A" },
  { .ov =  9, .code = 0x224c, .word = 0xf357, .immediate=0, .flags=0x80, .name = "SETB" },
  { .ov =  9, .code = 0x2214, .word = 0xf396, .immediate=0, .flags=0x80, .name = "ESTA" },
  { .ov =  9, .code = 0x2214, .word = 0xf3ac, .immediate=0, .flags=0x80, .name = "VSTA" },
  { .ov =  9, .code = 0x224c, .word = 0xf3bb, .immediate=0, .flags=0x00, .name = "WF3BB" },
  { .ov =  9, .code = 0x224c, .word = 0xf41e, .immediate=0, .flags=0x80, .name = "LDSY" },
  { .ov =  9, .code = 0x224c, .word = 0xf465, .immediate=0, .flags=0x80, .name = "@.HY" },
  { .ov =  9, .code = 0x224c, .word = 0xf4ca, .immediate=0, .flags=0x80, .name = ".TPI" },
  { .ov =  9, .code = 0x224c, .word = 0xf509, .immediate=0, .flags=0x80, .name = ".API" },
  { .ov = 10, .code = 0x1d29, .word = 0xee46, .immediate=0, .flags=0x00, .name = "WEE46" },
  { .ov = 10, .code = 0x224c, .word = 0xee4a, .immediate=0, .flags=0x00, .name = "WEE4A" },
  { .ov = 10, .code = 0x224c, .word = 0xee68, .immediate=0, .flags=0x00, .name = "WEE68" },
  { .ov = 10, .code = 0x224c, .word = 0xee76, .immediate=0, .flags=0x00, .name = "WEE76" },
  { .ov = 10, .code = 0x224c, .word = 0xee93, .immediate=0, .flags=0x00, .name = "WEE93" },
  { .ov = 10, .code = 0x224c, .word = 0xeea0, .immediate=0, .flags=0x00, .name = "WEEA0" },
  { .ov = 10, .code = 0x224c, .word = 0xeeaf, .immediate=0, .flags=0x00, .name = "WEEAF" },
  { .ov = 10, .code = 0x224c, .word = 0xeebd, .immediate=0, .flags=0x00, .name = "WEEBD" },
  { .ov = 10, .code = 0x4b3b, .word = 0xeed2, .immediate=0, .flags=0x80, .name = ".ERR" },
  { .ov = 10, .code = 0x4b3b, .word = 0xeef8, .immediate=0, .flags=0x80, .name = "EINDE" },
  { .ov = 10, .code = 0x7420, .word = 0xef16, .immediate=0, .flags=0x00, .name = "WEF16" },
  { .ov = 10, .code = 0x7420, .word = 0xef1b, .immediate=0, .flags=0x00, .name = "WEF1B" },
  { .ov = 10, .code = 0x7420, .word = 0xef20, .immediate=0, .flags=0x00, .name = "WEF20" },
  { .ov = 10, .code = 0x7420, .word = 0xef25, .immediate=0, .flags=0x00, .name = "WEF25" },
  { .ov = 10, .code = 0x7420, .word = 0xef31, .immediate=0, .flags=0x80, .name = "SCNT" },
  { .ov = 10, .code = 0x224c, .word = 0xef36, .immediate=0, .flags=0x00, .name = "WEF36" },
  { .ov = 10, .code = 0x224c, .word = 0xef52, .immediate=0, .flags=0x00, .name = "WEF52" },
  { .ov = 10, .code = 0x224c, .word = 0xef6e, .immediate=0, .flags=0x00, .name = "WEF6E" },
  { .ov = 10, .code = 0x224c, .word = 0xefa6, .immediate=0, .flags=0x00, .name = "WEFA6" },
  { .ov = 10, .code = 0x224c, .word = 0xefae, .immediate=0, .flags=0x00, .name = "WEFAE" },
  { .ov = 10, .code = 0x224c, .word = 0xefc8, .immediate=0, .flags=0x00, .name = "WEFC8" },
  { .ov = 10, .code = 0x1d29, .word = 0xeff2, .immediate=0, .flags=0x00, .name = "WEFF2" },
  { .ov = 10, .code = 0x224c, .word = 0xf010, .immediate=0, .flags=0x80, .name = "(TRIM" },
  { .ov = 10, .code = 0x224c, .word = 0xf042, .immediate=0, .flags=0x00, .name = "WF042" },
  { .ov = 10, .code = 0x224c, .word = 0xf078, .immediate=0, .flags=0x00, .name = "WF078" },
  { .ov = 10, .code = 0x224c, .word = 0xf09a, .immediate=0, .flags=0x00, .name = "WF09A" },
  { .ov = 10, .code = 0x224c, .word = 0xf0c0, .immediate=0, .flags=0x00, .name = "WF0C0" },
  { .ov = 10, .code = 0x224c, .word = 0xf0f0, .immediate=0, .flags=0x80, .name = "(#IN$" },
  { .ov = 10, .code = 0x224c, .word = 0xf1b4, .immediate=0, .flags=0x80, .name = "(?ART" },
  { .ov = 10, .code = 0x224c, .word = 0xf208, .immediate=0, .flags=0x00, .name = "WF208" },
  { .ov = 10, .code = 0x224c, .word = 0xf247, .immediate=0, .flags=0x80, .name = "RSTE" },
  { .ov = 10, .code = 0x224c, .word = 0xf26b, .immediate=0, .flags=0x80, .name = "(QUIT" },
  { .ov = 10, .code = 0x224c, .word = 0xf296, .immediate=0, .flags=0x80, .name = "(.0$$" },
  { .ov = 10, .code = 0x224c, .word = 0xf2b9, .immediate=0, .flags=0x80, .name = "(0$$$" },
  { .ov = 10, .code = 0x224c, .word = 0xf2f1, .immediate=0, .flags=0x00, .name = "WF2F1" },
  { .ov = 10, .code = 0x224c, .word = 0xf35b, .immediate=0, .flags=0x00, .name = "WF35B" },
  { .ov = 10, .code = 0x224c, .word = 0xf39f, .immediate=0, .flags=0x80, .name = "(?.EQ" },
  { .ov = 10, .code = 0x224c, .word = 0xf41c, .immediate=0, .flags=0x00, .name = "WF41C" },
  { .ov = 10, .code = 0x224c, .word = 0xf446, .immediate=0, .flags=0x80, .name = "=CARG" },
  { .ov = 10, .code = 0x224c, .word = 0xf4fc, .immediate=0, .flags=0x80, .name = "TV?AR" },
  { .ov = 11, .code = 0x224c, .word = 0xef96, .immediate=0, .flags=0x00, .name = "WEF96" },
  { .ov = 11, .code = 0x2214, .word = 0xefa0, .immediate=0, .flags=0x00, .name = "WEFA0" },
  { .ov = 11, .code = 0x2214, .word = 0xefa4, .immediate=0, .flags=0x00, .name = "WEFA4" },
  { .ov = 11, .code = 0x2214, .word = 0xefa8, .immediate=0, .flags=0x00, .name = "WEFA8" },
  { .ov = 11, .code = 0x2214, .word = 0xefac, .immediate=0, .flags=0x00, .name = "WEFAC" },
  { .ov = 11, .code = 0x2214, .word = 0xefb0, .immediate=0, .flags=0x00, .name = "WEFB0" },
  { .ov = 11, .code = 0x7420, .word = 0xefb4, .immediate=0, .flags=0x00, .name = "WEFB4" },
  { .ov = 11, .code = 0x7420, .word = 0xefb9, .immediate=0, .flags=0x00, .name = "WEFB9" },
  { .ov = 11, .code = 0x7420, .word = 0xefbe, .immediate=0, .flags=0x00, .name = "WEFBE" },
  { .ov = 11, .code = 0x7394, .word = 0xefc3, .immediate=0, .flags=0x00, .name = "WEFC3" },
  { .ov = 11, .code = 0x7420, .word = 0xefcb, .immediate=0, .flags=0x00, .name = "WEFCB" },
  { .ov = 11, .code = 0x7420, .word = 0xefd0, .immediate=0, .flags=0x00, .name = "WEFD0" },
  { .ov = 11, .code = 0x224c, .word = 0xefd5, .immediate=0, .flags=0x00, .name = "WEFD5" },
  { .ov = 11, .code = 0x224c, .word = 0xefe6, .immediate=0, .flags=0x80, .name = "!TFLAG" },
  { .ov = 11, .code = 0x224c, .word = 0xf000, .immediate=0, .flags=0x80, .name = "D@BALANCE" },
  { .ov = 11, .code = 0x224c, .word = 0xf018, .immediate=0, .flags=0x80, .name = "D!BALANCE" },
  { .ov = 11, .code = 0x224c, .word = 0xf02f, .immediate=0, .flags=0x80, .name = "?BALANCE" },
  { .ov = 11, .code = 0x224c, .word = 0xf048, .immediate=0, .flags=0x80, .name = "INIT-BALANCE" },
  { .ov = 11, .code = 0x224c, .word = 0xf063, .immediate=0, .flags=0x80, .name = "TRANSACT" },
  { .ov = 11, .code = 0x224c, .word = 0xf0de, .immediate=0, .flags=0x80, .name = "INT%" },
  { .ov = 11, .code = 0x1d29, .word = 0xf122, .immediate=0, .flags=0x00, .name = "WF122" },
  { .ov = 11, .code = 0x224c, .word = 0xf138, .immediate=0, .flags=0x00, .name = "WF138" },
  { .ov = 11, .code = 0x224c, .word = 0xf162, .immediate=0, .flags=0x00, .name = "WF162" },
  { .ov = 11, .code = 0x224c, .word = 0xf1a6, .immediate=0, .flags=0x00, .name = "WF1A6" },
  { .ov = 11, .code = 0x224c, .word = 0xf1ea, .immediate=0, .flags=0x00, .name = "WF1EA" },
  { .ov = 11, .code = 0x224c, .word = 0xf1f2, .immediate=0, .flags=0x00, .name = "WF1F2" },
  { .ov = 11, .code = 0x224c, .word = 0xf27f, .immediate=0, .flags=0x00, .name = "WF27F" },
  { .ov = 11, .code = 0x224c, .word = 0xf3bb, .immediate=0, .flags=0x00, .name = "WF3BB" },
  { .ov = 11, .code = 0x224c, .word = 0xf474, .immediate=0, .flags=0x00, .name = "WF474" },
  { .ov = 11, .code = 0x224c, .word = 0xf482, .immediate=0, .flags=0x00, .name = "WF482" },
  { .ov = 11, .code = 0x224c, .word = 0xf4bc, .immediate=0, .flags=0x00, .name = "WF4BC" },
  { .ov = 11, .code = 0x224c, .word = 0xf4d4, .immediate=0, .flags=0x00, .name = "WF4D4" },
  { .ov = 11, .code = 0x224c, .word = 0xf4ff, .immediate=0, .flags=0x80, .name = "(U-BANK)" },
  { .ov = 12, .code = 0x224c, .word = 0xeac6, .immediate=0, .flags=0x00, .name = "WEAC6" },
  { .ov = 12, .code = 0x2214, .word = 0xead0, .immediate=0, .flags=0x00, .name = "WEAD0" },
  { .ov = 12, .code = 0x2214, .word = 0xead4, .immediate=0, .flags=0x00, .name = "WEAD4" },
  { .ov = 12, .code = 0x1d29, .word = 0xead8, .immediate=0, .flags=0x00, .name = "WEAD8" },
  { .ov = 12, .code = 0x224c, .word = 0xeadc, .immediate=0, .flags=0x00, .name = "WEADC" },
  { .ov = 12, .code = 0x1d29, .word = 0xeafe, .immediate=0, .flags=0x00, .name = "WEAFE" },
  { .ov = 12, .code = 0x224c, .word = 0xeb04, .immediate=0, .flags=0x00, .name = "WEB04" },
  { .ov = 12, .code = 0x224c, .word = 0xeb20, .immediate=0, .flags=0x00, .name = "WEB20" },
  { .ov = 12, .code = 0x224c, .word = 0xeb49, .immediate=0, .flags=0x00, .name = "WEB49" },
  { .ov = 12, .code = 0x7394, .word = 0xeb63, .immediate=0, .flags=0x00, .name = "WEB63" },
  { .ov = 12, .code = 0x7394, .word = 0xeb6b, .immediate=0, .flags=0x00, .name = "WEB6B" },
  { .ov = 12, .code = 0x7394, .word = 0xeb73, .immediate=0, .flags=0x00, .name = "WEB73" },
  { .ov = 12, .code = 0x7420, .word = 0xeb7b, .immediate=0, .flags=0x00, .name = "WEB7B" },
  { .ov = 12, .code = 0x7420, .word = 0xeb80, .immediate=0, .flags=0x00, .name = "WEB80" },
  { .ov = 12, .code = 0x7420, .word = 0xeb85, .immediate=0, .flags=0x00, .name = "WEB85" },
  { .ov = 12, .code = 0x7420, .word = 0xeb8a, .immediate=0, .flags=0x00, .name = "WEB8A" },
  { .ov = 12, .code = 0x7420, .word = 0xeb8f, .immediate=0, .flags=0x00, .name = "WEB8F" },
  { .ov = 12, .code = 0x7420, .word = 0xeb94, .immediate=0, .flags=0x00, .name = "WEB94" },
  { .ov = 12, .code = 0x7420, .word = 0xeb99, .immediate=0, .flags=0x00, .name = "WEB99" },
  { .ov = 12, .code = 0x7420, .word = 0xeb9e, .immediate=0, .flags=0x00, .name = "WEB9E" },
  { .ov = 12, .code = 0x7420, .word = 0xeba3, .immediate=0, .flags=0x00, .name = "WEBA3" },
  { .ov = 12, .code = 0x7420, .word = 0xeba8, .immediate=0, .flags=0x00, .name = "WEBA8" },
  { .ov = 12, .code = 0x224c, .word = 0xebad, .immediate=0, .flags=0x00, .name = "WEBAD" },
  { .ov = 12, .code = 0x224c, .word = 0xebc1, .immediate=0, .flags=0x00, .name = "WEBC1" },
  { .ov = 12, .code = 0x1d29, .word = 0xecb3, .immediate=0, .flags=0x00, .name = "WECB3" },
  { .ov = 12, .code = 0x224c, .word = 0xecb7, .immediate=0, .flags=0x00, .name = "WECB7" },
  { .ov = 12, .code = 0x224c, .word = 0xecbf, .immediate=0, .flags=0x00, .name = "WECBF" },
  { .ov = 12, .code = 0x224c, .word = 0xedd3, .immediate=0, .flags=0x00, .name = "WEDD3" },
  { .ov = 12, .code = 0x224c, .word = 0xedfd, .immediate=0, .flags=0x00, .name = "WEDFD" },
  { .ov = 12, .code = 0x224c, .word = 0xee31, .immediate=0, .flags=0x00, .name = "WEE31" },
  { .ov = 12, .code = 0x224c, .word = 0xef80, .immediate=0, .flags=0x00, .name = "WEF80" },
  { .ov = 12, .code = 0x224c, .word = 0xf052, .immediate=0, .flags=0x00, .name = "WF052" },
  { .ov = 12, .code = 0x224c, .word = 0xf161, .immediate=0, .flags=0x00, .name = "WF161" },
  { .ov = 12, .code = 0x224c, .word = 0xf197, .immediate=0, .flags=0x00, .name = "WF197" },
  { .ov = 12, .code = 0x224c, .word = 0xf1cb, .immediate=0, .flags=0x00, .name = "WF1CB" },
  { .ov = 12, .code = 0x224c, .word = 0xf207, .immediate=0, .flags=0x00, .name = "WF207" },
  { .ov = 12, .code = 0x224c, .word = 0xf225, .immediate=0, .flags=0x00, .name = "WF225" },
  { .ov = 12, .code = 0x224c, .word = 0xf271, .immediate=0, .flags=0x00, .name = "WF271" },
  { .ov = 12, .code = 0x224c, .word = 0xf2dc, .immediate=0, .flags=0x00, .name = "WF2DC" },
  { .ov = 12, .code = 0x224c, .word = 0xf2ea, .immediate=0, .flags=0x00, .name = "WF2EA" },
  { .ov = 12, .code = 0x224c, .word = 0xf367, .immediate=0, .flags=0x00, .name = "WF367" },
  { .ov = 12, .code = 0x224c, .word = 0xf3ce, .immediate=0, .flags=0x00, .name = "WF3CE" },
  { .ov = 12, .code = 0x224c, .word = 0xf410, .immediate=0, .flags=0x00, .name = "WF410" },
  { .ov = 12, .code = 0x224c, .word = 0xf442, .immediate=0, .flags=0x00, .name = "WF442" },
  { .ov = 12, .code = 0x224c, .word = 0xf498, .immediate=0, .flags=0x80, .name = "(U-ASSCREW)" },
  { .ov = 13, .code = 0x224c, .word = 0xe3e6, .immediate=0, .flags=0x00, .name = "WE3E6" },
  { .ov = 13, .code = 0x224c, .word = 0xe3ee, .immediate=0, .flags=0x00, .name = "WE3EE" },
  { .ov = 13, .code = 0x224c, .word = 0xe3fe, .immediate=0, .flags=0x00, .name = "WE3FE" },
  { .ov = 13, .code = 0x224c, .word = 0xe43a, .immediate=0, .flags=0x00, .name = "WE43A" },
  { .ov = 13, .code = 0x224c, .word = 0xe4a2, .immediate=0, .flags=0x00, .name = "WE4A2" },
  { .ov = 13, .code = 0x224c, .word = 0xe4ac, .immediate=0, .flags=0x00, .name = "WE4AC" },
  { .ov = 13, .code = 0x224c, .word = 0xe4b6, .immediate=0, .flags=0x00, .name = "WE4B6" },
  { .ov = 13, .code = 0x224c, .word = 0xe4c0, .immediate=0, .flags=0x00, .name = "WE4C0" },
  { .ov = 13, .code = 0x224c, .word = 0xe4ca, .immediate=0, .flags=0x00, .name = "WE4CA" },
  { .ov = 13, .code = 0x2214, .word = 0xe4d4, .immediate=0, .flags=0x00, .name = "WE4D4" },
  { .ov = 13, .code = 0x2214, .word = 0xe4d8, .immediate=0, .flags=0x00, .name = "WE4D8" },
  { .ov = 13, .code = 0x2214, .word = 0xe4dc, .immediate=0, .flags=0x00, .name = "WE4DC" },
  { .ov = 13, .code = 0x224c, .word = 0xe4e0, .immediate=0, .flags=0x00, .name = "WE4E0" },
  { .ov = 13, .code = 0x224c, .word = 0xe4ec, .immediate=0, .flags=0x00, .name = "WE4EC" },
  { .ov = 13, .code = 0x224c, .word = 0xe4f6, .immediate=0, .flags=0x00, .name = "WE4F6" },
  { .ov = 13, .code = 0x224c, .word = 0xe500, .immediate=0, .flags=0x00, .name = "WE500" },
  { .ov = 13, .code = 0x224c, .word = 0xe50a, .immediate=0, .flags=0x00, .name = "WE50A" },
  { .ov = 13, .code = 0x7420, .word = 0xe514, .immediate=0, .flags=0x00, .name = "WE514" },
  { .ov = 13, .code = 0x1d29, .word = 0xe519, .immediate=0, .flags=0x00, .name = "WE519" },
  { .ov = 13, .code = 0x224c, .word = 0xe529, .immediate=0, .flags=0x00, .name = "WE529" },
  { .ov = 13, .code = 0x224c, .word = 0xe54b, .immediate=0, .flags=0x00, .name = "WE54B" },
  { .ov = 13, .code = 0x224c, .word = 0xe557, .immediate=0, .flags=0x00, .name = "WE557" },
  { .ov = 13, .code = 0x224c, .word = 0xe56d, .immediate=0, .flags=0x00, .name = "WE56D" },
  { .ov = 13, .code = 0x1d29, .word = 0xe577, .immediate=0, .flags=0x00, .name = "WE577" },
  { .ov = 13, .code = 0x224c, .word = 0xe581, .immediate=0, .flags=0x00, .name = "WE581" },
  { .ov = 13, .code = 0x224c, .word = 0xe5ab, .immediate=0, .flags=0x00, .name = "WE5AB" },
  { .ov = 13, .code = 0x224c, .word = 0xe5bb, .immediate=0, .flags=0x00, .name = "WE5BB" },
  { .ov = 13, .code = 0x224c, .word = 0xe5d3, .immediate=0, .flags=0x00, .name = "WE5D3" },
  { .ov = 13, .code = 0x224c, .word = 0xe5e1, .immediate=0, .flags=0x00, .name = "WE5E1" },
  { .ov = 13, .code = 0x224c, .word = 0xe5eb, .immediate=0, .flags=0x00, .name = "WE5EB" },
  { .ov = 13, .code = 0x224c, .word = 0xe604, .immediate=0, .flags=0x00, .name = "WE604" },
  { .ov = 13, .code = 0x224c, .word = 0xe620, .immediate=0, .flags=0x00, .name = "WE620" },
  { .ov = 13, .code = 0x224c, .word = 0xe647, .immediate=0, .flags=0x00, .name = "WE647" },
  { .ov = 13, .code = 0x7394, .word = 0xe661, .immediate=0, .flags=0x00, .name = "WE661" },
  { .ov = 13, .code = 0x7394, .word = 0xe669, .immediate=0, .flags=0x00, .name = "WE669" },
  { .ov = 13, .code = 0x7394, .word = 0xe671, .immediate=0, .flags=0x00, .name = "WE671" },
  { .ov = 13, .code = 0x7394, .word = 0xe679, .immediate=0, .flags=0x00, .name = "WE679" },
  { .ov = 13, .code = 0x7394, .word = 0xe681, .immediate=0, .flags=0x00, .name = "WE681" },
  { .ov = 13, .code = 0x7420, .word = 0xe689, .immediate=0, .flags=0x00, .name = "WE689" },
  { .ov = 13, .code = 0x7420, .word = 0xe68e, .immediate=0, .flags=0x00, .name = "WE68E" },
  { .ov = 13, .code = 0x7420, .word = 0xe693, .immediate=0, .flags=0x00, .name = "WE693" },
  { .ov = 13, .code = 0x7420, .word = 0xe698, .immediate=0, .flags=0x00, .name = "WE698" },
  { .ov = 13, .code = 0x7420, .word = 0xe69d, .immediate=0, .flags=0x00, .name = "WE69D" },
  { .ov = 13, .code = 0x7420, .word = 0xe6a2, .immediate=0, .flags=0x00, .name = "WE6A2" },
  { .ov = 13, .code = 0x7420, .word = 0xe6a7, .immediate=0, .flags=0x00, .name = "WE6A7" },
  { .ov = 13, .code = 0x7420, .word = 0xe6ac, .immediate=0, .flags=0x00, .name = "WE6AC" },
  { .ov = 13, .code = 0x7394, .word = 0xe6b1, .immediate=0, .flags=0x00, .name = "WE6B1" },
  { .ov = 13, .code = 0x7394, .word = 0xe6b9, .immediate=0, .flags=0x00, .name = "WE6B9" },
  { .ov = 13, .code = 0x7394, .word = 0xe6c1, .immediate=0, .flags=0x00, .name = "WE6C1" },
  { .ov = 13, .code = 0x224c, .word = 0xe6c9, .immediate=0, .flags=0x00, .name = "WE6C9" },
  { .ov = 13, .code = 0x224c, .word = 0xe803, .immediate=0, .flags=0x00, .name = "WE803" },
  { .ov = 13, .code = 0x224c, .word = 0xe827, .immediate=0, .flags=0x00, .name = "WE827" },
  { .ov = 13, .code = 0x1d29, .word = 0xe861, .immediate=0, .flags=0x00, .name = "WE861" },
  { .ov = 13, .code = 0x224c, .word = 0xe874, .immediate=0, .flags=0x00, .name = "WE874" },
  { .ov = 13, .code = 0x1d29, .word = 0xe91b, .immediate=0, .flags=0x00, .name = "WE91B" },
  { .ov = 13, .code = 0x224c, .word = 0xe91f, .immediate=0, .flags=0x00, .name = "WE91F" },
  { .ov = 13, .code = 0x224c, .word = 0xe927, .immediate=0, .flags=0x00, .name = "WE927" },
  { .ov = 13, .code = 0x224c, .word = 0xea41, .immediate=0, .flags=0x00, .name = "WEA41" },
  { .ov = 13, .code = 0x224c, .word = 0xea83, .immediate=0, .flags=0x00, .name = "WEA83" },
  { .ov = 13, .code = 0x224c, .word = 0xeb53, .immediate=0, .flags=0x00, .name = "WEB53" },
  { .ov = 13, .code = 0x224c, .word = 0xeba9, .immediate=0, .flags=0x00, .name = "WEBA9" },
  { .ov = 13, .code = 0x224c, .word = 0xec39, .immediate=0, .flags=0x00, .name = "WEC39" },
  { .ov = 13, .code = 0x224c, .word = 0xed3d, .immediate=0, .flags=0x00, .name = "WED3D" },
  { .ov = 13, .code = 0x224c, .word = 0xed4b, .immediate=0, .flags=0x00, .name = "WED4B" },
  { .ov = 13, .code = 0x224c, .word = 0xedc5, .immediate=0, .flags=0x00, .name = "WEDC5" },
  { .ov = 13, .code = 0x224c, .word = 0xedf5, .immediate=0, .flags=0x00, .name = "WEDF5" },
  { .ov = 13, .code = 0x224c, .word = 0xee17, .immediate=0, .flags=0x00, .name = "WEE17" },
  { .ov = 13, .code = 0x1d29, .word = 0xee39, .immediate=0, .flags=0x00, .name = "WEE39" },
  { .ov = 13, .code = 0x224c, .word = 0xee3d, .immediate=0, .flags=0x00, .name = "WEE3D" },
  { .ov = 13, .code = 0x224c, .word = 0xef2b, .immediate=0, .flags=0x00, .name = "WEF2B" },
  { .ov = 13, .code = 0x224c, .word = 0xefd8, .immediate=0, .flags=0x00, .name = "WEFD8" },
  { .ov = 13, .code = 0x224c, .word = 0xf006, .immediate=0, .flags=0x00, .name = "WF006" },
  { .ov = 13, .code = 0x224c, .word = 0xf02c, .immediate=0, .flags=0x00, .name = "WF02C" },
  { .ov = 13, .code = 0x224c, .word = 0xf082, .immediate=0, .flags=0x00, .name = "WF082" },
  { .ov = 13, .code = 0x224c, .word = 0xf149, .immediate=0, .flags=0x00, .name = "WF149" },
  { .ov = 13, .code = 0x224c, .word = 0xf177, .immediate=0, .flags=0x00, .name = "WF177" },
  { .ov = 13, .code = 0x224c, .word = 0xf1dc, .immediate=0, .flags=0x00, .name = "WF1DC" },
  { .ov = 13, .code = 0x224c, .word = 0xf217, .immediate=0, .flags=0x00, .name = "WF217" },
  { .ov = 13, .code = 0x1d29, .word = 0xf29b, .immediate=0, .flags=0x00, .name = "WF29B" },
  { .ov = 13, .code = 0x224c, .word = 0xf2b2, .immediate=0, .flags=0x00, .name = "WF2B2" },
  { .ov = 13, .code = 0x224c, .word = 0xf2c4, .immediate=0, .flags=0x00, .name = "WF2C4" },
  { .ov = 13, .code = 0x224c, .word = 0xf36a, .immediate=0, .flags=0x00, .name = "WF36A" },
  { .ov = 13, .code = 0x224c, .word = 0xf3a2, .immediate=0, .flags=0x00, .name = "WF3A2" },
  { .ov = 13, .code = 0x224c, .word = 0xf3e6, .immediate=0, .flags=0x00, .name = "WF3E6" },
  { .ov = 13, .code = 0x224c, .word = 0xf3f8, .immediate=0, .flags=0x00, .name = "WF3F8" },
  { .ov = 13, .code = 0x224c, .word = 0xf496, .immediate=0, .flags=0x00, .name = "WF496" },
  { .ov = 13, .code = 0x4b3b, .word = 0xf4db, .immediate=0, .flags=0x80, .name = "PFILE-FUNCTI" },
  { .ov = 13, .code = 0x224c, .word = 0xf4fd, .immediate=0, .flags=0x80, .name = "(U-PFILE)" },
  { .ov = 14, .code = 0x224c, .word = 0xecc6, .immediate=0, .flags=0x00, .name = "WECC6" },
  { .ov = 14, .code = 0x224c, .word = 0xecd6, .immediate=0, .flags=0x00, .name = "WECD6" },
  { .ov = 14, .code = 0x224c, .word = 0xece1, .immediate=0, .flags=0x00, .name = "WECE1" },
  { .ov = 14, .code = 0x224c, .word = 0xecf0, .immediate=0, .flags=0x00, .name = "WECF0" },
  { .ov = 14, .code = 0x224c, .word = 0xecfb, .immediate=0, .flags=0x00, .name = "WECFB" },
  { .ov = 14, .code = 0x4b3b, .word = 0xed14, .immediate=0, .flags=0x80, .name = "A>TEXT" },
  { .ov = 14, .code = 0x7420, .word = 0xed2e, .immediate=0, .flags=0x00, .name = "WED2E" },
  { .ov = 14, .code = 0x7420, .word = 0xed33, .immediate=0, .flags=0x00, .name = "WED33" },
  { .ov = 14, .code = 0x7420, .word = 0xed38, .immediate=0, .flags=0x00, .name = "WED38" },
  { .ov = 14, .code = 0x7420, .word = 0xed3d, .immediate=0, .flags=0x00, .name = "WED3D" },
  { .ov = 14, .code = 0x7420, .word = 0xed42, .immediate=0, .flags=0x00, .name = "WED42" },
  { .ov = 14, .code = 0x7420, .word = 0xed47, .immediate=0, .flags=0x00, .name = "WED47" },
  { .ov = 14, .code = 0x7420, .word = 0xed4c, .immediate=0, .flags=0x00, .name = "WED4C" },
  { .ov = 14, .code = 0x7420, .word = 0xed51, .immediate=0, .flags=0x00, .name = "WED51" },
  { .ov = 14, .code = 0x7420, .word = 0xed56, .immediate=0, .flags=0x00, .name = "WED56" },
  { .ov = 14, .code = 0x7420, .word = 0xed5b, .immediate=0, .flags=0x00, .name = "WED5B" },
  { .ov = 14, .code = 0x7420, .word = 0xed60, .immediate=0, .flags=0x00, .name = "WED60" },
  { .ov = 14, .code = 0x224c, .word = 0xed65, .immediate=0, .flags=0x00, .name = "WED65" },
  { .ov = 14, .code = 0x1d29, .word = 0xed71, .immediate=0, .flags=0x00, .name = "WED71" },
  { .ov = 14, .code = 0x1d29, .word = 0xedb7, .immediate=0, .flags=0x00, .name = "WEDB7" },
  { .ov = 14, .code = 0x1d29, .word = 0xedfd, .immediate=0, .flags=0x00, .name = "WEDFD" },
  { .ov = 14, .code = 0x1d29, .word = 0xee31, .immediate=0, .flags=0x00, .name = "WEE31" },
  { .ov = 14, .code = 0x1d29, .word = 0xee55, .immediate=0, .flags=0x00, .name = "WEE55" },
  { .ov = 14, .code = 0x1d29, .word = 0xee59, .immediate=0, .flags=0x00, .name = "WEE59" },
  { .ov = 14, .code = 0x224c, .word = 0xee6b, .immediate=0, .flags=0x80, .name = "(.MASS)" },
  { .ov = 14, .code = 0x224c, .word = 0xef02, .immediate=0, .flags=0x80, .name = "(.ACC)" },
  { .ov = 14, .code = 0x224c, .word = 0xef3a, .immediate=0, .flags=0x00, .name = "WEF3A" },
  { .ov = 14, .code = 0x224c, .word = 0xefb0, .immediate=0, .flags=0x00, .name = "WEFB0" },
  { .ov = 14, .code = 0x224c, .word = 0xf034, .immediate=0, .flags=0x00, .name = "WF034" },
  { .ov = 14, .code = 0x224c, .word = 0xf046, .immediate=0, .flags=0x00, .name = "WF046" },
  { .ov = 14, .code = 0x1d29, .word = 0xf0b8, .immediate=0, .flags=0x00, .name = "WF0B8" },
  { .ov = 14, .code = 0x1d29, .word = 0xf0ca, .immediate=0, .flags=0x00, .name = "WF0CA" },
  { .ov = 14, .code = 0x1d29, .word = 0xf0dc, .immediate=0, .flags=0x00, .name = "WF0DC" },
  { .ov = 14, .code = 0x224c, .word = 0xf0e0, .immediate=0, .flags=0x00, .name = "WF0E0" },
  { .ov = 14, .code = 0x224c, .word = 0xf106, .immediate=0, .flags=0x00, .name = "WF106" },
  { .ov = 14, .code = 0x224c, .word = 0xf124, .immediate=0, .flags=0x80, .name = "(.PODS)" },
  { .ov = 14, .code = 0x1d29, .word = 0xf17c, .immediate=0, .flags=0x00, .name = "WF17C" },
  { .ov = 14, .code = 0x1d29, .word = 0xf182, .immediate=0, .flags=0x00, .name = "WF182" },
  { .ov = 14, .code = 0x1d29, .word = 0xf188, .immediate=0, .flags=0x00, .name = "WF188" },
  { .ov = 14, .code = 0x224c, .word = 0xf192, .immediate=0, .flags=0x00, .name = "WF192" },
  { .ov = 14, .code = 0x224c, .word = 0xf1d4, .immediate=0, .flags=0x00, .name = "WF1D4" },
  { .ov = 14, .code = 0x224c, .word = 0xf216, .immediate=0, .flags=0x80, .name = "(.SHIP)" },
  { .ov = 14, .code = 0x224c, .word = 0xf238, .immediate=0, .flags=0x80, .name = "(BALANC" },
  { .ov = 14, .code = 0x224c, .word = 0xf277, .immediate=0, .flags=0x00, .name = "WF277" },
  { .ov = 14, .code = 0x224c, .word = 0xf36a, .immediate=0, .flags=0x00, .name = "WF36A" },
  { .ov = 14, .code = 0x224c, .word = 0xf376, .immediate=0, .flags=0x00, .name = "WF376" },
  { .ov = 14, .code = 0x224c, .word = 0xf478, .immediate=0, .flags=0x00, .name = "WF478" },
  { .ov = 14, .code = 0x224c, .word = 0xf555, .immediate=0, .flags=0x80, .name = "(.CONFI" },
  { .ov = 15, .code = 0x224c, .word = 0xe6f6, .immediate=0, .flags=0x00, .name = "WE6F6" },
  { .ov = 15, .code = 0x224c, .word = 0xe700, .immediate=0, .flags=0x00, .name = "WE700" },
  { .ov = 15, .code = 0x224c, .word = 0xe70a, .immediate=0, .flags=0x00, .name = "WE70A" },
  { .ov = 15, .code = 0x224c, .word = 0xe714, .immediate=0, .flags=0x00, .name = "WE714" },
  { .ov = 15, .code = 0x224c, .word = 0xe71e, .immediate=0, .flags=0x00, .name = "WE71E" },
  { .ov = 15, .code = 0x224c, .word = 0xe728, .immediate=0, .flags=0x00, .name = "WE728" },
  { .ov = 15, .code = 0x224c, .word = 0xe732, .immediate=0, .flags=0x00, .name = "WE732" },
  { .ov = 15, .code = 0x224c, .word = 0xe73c, .immediate=0, .flags=0x00, .name = "WE73C" },
  { .ov = 15, .code = 0x224c, .word = 0xe746, .immediate=0, .flags=0x00, .name = "WE746" },
  { .ov = 15, .code = 0x224c, .word = 0xe750, .immediate=0, .flags=0x00, .name = "WE750" },
  { .ov = 15, .code = 0x7420, .word = 0xe75a, .immediate=0, .flags=0x00, .name = "WE75A" },
  { .ov = 15, .code = 0x7420, .word = 0xe75f, .immediate=0, .flags=0x00, .name = "WE75F" },
  { .ov = 15, .code = 0x7420, .word = 0xe764, .immediate=0, .flags=0x00, .name = "WE764" },
  { .ov = 15, .code = 0x7420, .word = 0xe769, .immediate=0, .flags=0x00, .name = "WE769" },
  { .ov = 15, .code = 0x7420, .word = 0xe76e, .immediate=0, .flags=0x00, .name = "WE76E" },
  { .ov = 15, .code = 0x7420, .word = 0xe773, .immediate=0, .flags=0x00, .name = "WE773" },
  { .ov = 15, .code = 0x7420, .word = 0xe778, .immediate=0, .flags=0x00, .name = "WE778" },
  { .ov = 15, .code = 0x7420, .word = 0xe77d, .immediate=0, .flags=0x00, .name = "WE77D" },
  { .ov = 15, .code = 0x7420, .word = 0xe782, .immediate=0, .flags=0x00, .name = "WE782" },
  { .ov = 15, .code = 0x7420, .word = 0xe787, .immediate=0, .flags=0x00, .name = "WE787" },
  { .ov = 15, .code = 0x7420, .word = 0xe78c, .immediate=0, .flags=0x00, .name = "WE78C" },
  { .ov = 15, .code = 0x7420, .word = 0xe791, .immediate=0, .flags=0x00, .name = "WE791" },
  { .ov = 15, .code = 0x7420, .word = 0xe796, .immediate=0, .flags=0x00, .name = "WE796" },
  { .ov = 15, .code = 0x7420, .word = 0xe7a5, .immediate=0, .flags=0x80, .name = "#JUMPOS" },
  { .ov = 15, .code = 0x7420, .word = 0xe7b5, .immediate=0, .flags=0x80, .name = "#BLASTOS" },
  { .ov = 15, .code = 0x1d29, .word = 0xe7ba, .immediate=0, .flags=0x00, .name = "WE7BA" },
  { .ov = 15, .code = 0x224c, .word = 0xe7be, .immediate=0, .flags=0x00, .name = "WE7BE" },
  { .ov = 15, .code = 0x224c, .word = 0xe7d4, .immediate=0, .flags=0x00, .name = "WE7D4" },
  { .ov = 15, .code = 0x224c, .word = 0xe7f0, .immediate=0, .flags=0x00, .name = "WE7F0" },
  { .ov = 15, .code = 0x224c, .word = 0xe80a, .immediate=0, .flags=0x00, .name = "WE80A" },
  { .ov = 15, .code = 0x224c, .word = 0xe826, .immediate=0, .flags=0x00, .name = "WE826" },
  { .ov = 15, .code = 0x224c, .word = 0xe866, .immediate=0, .flags=0x00, .name = "WE866" },
  { .ov = 15, .code = 0x224c, .word = 0xe888, .immediate=0, .flags=0x00, .name = "WE888" },
  { .ov = 15, .code = 0x224c, .word = 0xe8b8, .immediate=0, .flags=0x00, .name = "WE8B8" },
  { .ov = 15, .code = 0x1d29, .word = 0xe8ec, .immediate=0, .flags=0x00, .name = "WE8EC" },
  { .ov = 15, .code = 0x1d29, .word = 0xe903, .immediate=0, .flags=0x00, .name = "WE903" },
  { .ov = 15, .code = 0x224c, .word = 0xe926, .immediate=0, .flags=0x00, .name = "WE926" },
  { .ov = 15, .code = 0x224c, .word = 0xe9aa, .immediate=0, .flags=0x00, .name = "WE9AA" },
  { .ov = 15, .code = 0x224c, .word = 0xea2e, .immediate=0, .flags=0x00, .name = "WEA2E" },
  { .ov = 15, .code = 0x224c, .word = 0xea52, .immediate=0, .flags=0x00, .name = "WEA52" },
  { .ov = 15, .code = 0x1d29, .word = 0xea76, .immediate=0, .flags=0x00, .name = "WEA76" },
  { .ov = 15, .code = 0x224c, .word = 0xeaaa, .immediate=0, .flags=0x00, .name = "WEAAA" },
  { .ov = 15, .code = 0x224c, .word = 0xeb07, .immediate=0, .flags=0x00, .name = "WEB07" },
  { .ov = 15, .code = 0x224c, .word = 0xeb45, .immediate=0, .flags=0x00, .name = "WEB45" },
  { .ov = 15, .code = 0x224c, .word = 0xeb5b, .immediate=0, .flags=0x00, .name = "WEB5B" },
  { .ov = 15, .code = 0x224c, .word = 0xeb71, .immediate=0, .flags=0x00, .name = "WEB71" },
  { .ov = 15, .code = 0x224c, .word = 0xeb87, .immediate=0, .flags=0x00, .name = "WEB87" },
  { .ov = 15, .code = 0x224c, .word = 0xebcb, .immediate=0, .flags=0x00, .name = "WEBCB" },
  { .ov = 15, .code = 0x4b3b, .word = 0xec21, .immediate=0, .flags=0x80, .name = "#>." },
  { .ov = 15, .code = 0x224c, .word = 0xec33, .immediate=0, .flags=0x00, .name = "WEC33" },
  { .ov = 15, .code = 0x4b3b, .word = 0xec54, .immediate=0, .flags=0x80, .name = "(PARTADDR)" },
  { .ov = 15, .code = 0x224c, .word = 0xec6a, .immediate=0, .flags=0x00, .name = "WEC6A" },
  { .ov = 15, .code = 0x4b3b, .word = 0xec7a, .immediate=0, .flags=0x80, .name = "(PTS)" },
  { .ov = 15, .code = 0x224c, .word = 0xec88, .immediate=0, .flags=0x00, .name = "WEC88" },
  { .ov = 15, .code = 0x1d29, .word = 0xec9c, .immediate=0, .flags=0x00, .name = "WEC9C" },
  { .ov = 15, .code = 0x224c, .word = 0xeca2, .immediate=0, .flags=0x00, .name = "WECA2" },
  { .ov = 15, .code = 0x224c, .word = 0xed22, .immediate=0, .flags=0x00, .name = "WED22" },
  { .ov = 15, .code = 0x224c, .word = 0xed46, .immediate=0, .flags=0x00, .name = "WED46" },
  { .ov = 15, .code = 0x224c, .word = 0xed74, .immediate=0, .flags=0x00, .name = "WED74" },
  { .ov = 15, .code = 0x4b3b, .word = 0xeda0, .immediate=0, .flags=0x80, .name = "#>VALUE" },
  { .ov = 15, .code = 0x224c, .word = 0xedb2, .immediate=0, .flags=0x00, .name = "WEDB2" },
  { .ov = 15, .code = 0x224c, .word = 0xedd2, .immediate=0, .flags=0x00, .name = "WEDD2" },
  { .ov = 15, .code = 0x224c, .word = 0xedde, .immediate=0, .flags=0x00, .name = "WEDDE" },
  { .ov = 15, .code = 0x4b3b, .word = 0xee82, .immediate=0, .flags=0x80, .name = "#>BUY" },
  { .ov = 15, .code = 0x224c, .word = 0xee94, .immediate=0, .flags=0x00, .name = "WEE94" },
  { .ov = 15, .code = 0x224c, .word = 0xef52, .immediate=0, .flags=0x00, .name = "WEF52" },
  { .ov = 15, .code = 0x224c, .word = 0xefcc, .immediate=0, .flags=0x00, .name = "WEFCC" },
  { .ov = 15, .code = 0x224c, .word = 0xf047, .immediate=0, .flags=0x00, .name = "WF047" },
  { .ov = 15, .code = 0x4b3b, .word = 0xf0e9, .immediate=0, .flags=0x80, .name = "#>SELL" },
  { .ov = 15, .code = 0x224c, .word = 0xf0fb, .immediate=0, .flags=0x00, .name = "WF0FB" },
  { .ov = 15, .code = 0x1d29, .word = 0xf16f, .immediate=0, .flags=0x00, .name = "WF16F" },
  { .ov = 15, .code = 0x224c, .word = 0xf173, .immediate=0, .flags=0x00, .name = "WF173" },
  { .ov = 15, .code = 0x224c, .word = 0xf1fd, .immediate=0, .flags=0x00, .name = "WF1FD" },
  { .ov = 15, .code = 0x224c, .word = 0xf24d, .immediate=0, .flags=0x00, .name = "WF24D" },
  { .ov = 15, .code = 0x224c, .word = 0xf2af, .immediate=0, .flags=0x00, .name = "WF2AF" },
  { .ov = 15, .code = 0x224c, .word = 0xf2ec, .immediate=0, .flags=0x00, .name = "WF2EC" },
  { .ov = 15, .code = 0x224c, .word = 0xf321, .immediate=0, .flags=0x00, .name = "WF321" },
  { .ov = 15, .code = 0x224c, .word = 0xf36d, .immediate=0, .flags=0x00, .name = "WF36D" },
  { .ov = 15, .code = 0x224c, .word = 0xf3df, .immediate=0, .flags=0x00, .name = "WF3DF" },
  { .ov = 15, .code = 0x224c, .word = 0xf3fe, .immediate=0, .flags=0x00, .name = "WF3FE" },
  { .ov = 15, .code = 0x224c, .word = 0xf424, .immediate=0, .flags=0x00, .name = "WF424" },
  { .ov = 15, .code = 0x224c, .word = 0xf494, .immediate=0, .flags=0x00, .name = "WF494" },
  { .ov = 15, .code = 0x224c, .word = 0xf49e, .immediate=0, .flags=0x00, .name = "WF49E" },
  { .ov = 15, .code = 0x4b3b, .word = 0xf4ba, .immediate=0, .flags=0x80, .name = "CONFIG-FUNCTION" },
  { .ov = 15, .code = 0x224c, .word = 0xf4e1, .immediate=0, .flags=0x80, .name = "(U-CONFIG)" },
  { .ov = 16, .code = 0x1d29, .word = 0xe5e6, .immediate=0, .flags=0x00, .name = "WE5E6" },
  { .ov = 16, .code = 0x1d29, .word = 0xe5ea, .immediate=0, .flags=0x00, .name = "WE5EA" },
  { .ov = 16, .code = 0x1d29, .word = 0xe5ee, .immediate=0, .flags=0x00, .name = "WE5EE" },
  { .ov = 16, .code = 0x224c, .word = 0xe5f2, .immediate=0, .flags=0x00, .name = "WE5F2" },
  { .ov = 16, .code = 0x224c, .word = 0xe60c, .immediate=0, .flags=0x00, .name = "WE60C" },
  { .ov = 16, .code = 0x224c, .word = 0xe616, .immediate=0, .flags=0x00, .name = "WE616" },
  { .ov = 16, .code = 0x224c, .word = 0xe620, .immediate=0, .flags=0x00, .name = "WE620" },
  { .ov = 16, .code = 0x224c, .word = 0xe62a, .immediate=0, .flags=0x00, .name = "WE62A" },
  { .ov = 16, .code = 0x224c, .word = 0xe634, .immediate=0, .flags=0x00, .name = "WE634" },
  { .ov = 16, .code = 0x224c, .word = 0xe644, .immediate=0, .flags=0x00, .name = "WE644" },
  { .ov = 16, .code = 0x224c, .word = 0xe64a, .immediate=0, .flags=0x00, .name = "WE64A" },
  { .ov = 16, .code = 0x224c, .word = 0xe654, .immediate=0, .flags=0x00, .name = "WE654" },
  { .ov = 16, .code = 0x224c, .word = 0xe65e, .immediate=0, .flags=0x00, .name = "WE65E" },
  { .ov = 16, .code = 0x224c, .word = 0xe668, .immediate=0, .flags=0x00, .name = "WE668" },
  { .ov = 16, .code = 0x224c, .word = 0xe682, .immediate=0, .flags=0x00, .name = "WE682" },
  { .ov = 16, .code = 0x224c, .word = 0xe6ab, .immediate=0, .flags=0x00, .name = "WE6AB" },
  { .ov = 16, .code = 0x7420, .word = 0xe6bf, .immediate=0, .flags=0x00, .name = "WE6BF" },
  { .ov = 16, .code = 0x7394, .word = 0xe6c4, .immediate=0, .flags=0x00, .name = "WE6C4" },
  { .ov = 16, .code = 0x224c, .word = 0xe6cc, .immediate=0, .flags=0x00, .name = "WE6CC" },
  { .ov = 16, .code = 0x224c, .word = 0xe6d4, .immediate=0, .flags=0x00, .name = "WE6D4" },
  { .ov = 16, .code = 0x224c, .word = 0xe6e0, .immediate=0, .flags=0x00, .name = "WE6E0" },
  { .ov = 16, .code = 0x224c, .word = 0xe6ec, .immediate=0, .flags=0x00, .name = "WE6EC" },
  { .ov = 16, .code = 0x224c, .word = 0xe6f6, .immediate=0, .flags=0x00, .name = "WE6F6" },
  { .ov = 16, .code = 0x224c, .word = 0xe70c, .immediate=0, .flags=0x00, .name = "WE70C" },
  { .ov = 16, .code = 0x224c, .word = 0xe716, .immediate=0, .flags=0x00, .name = "WE716" },
  { .ov = 16, .code = 0x224c, .word = 0xe726, .immediate=0, .flags=0x00, .name = "WE726" },
  { .ov = 16, .code = 0x224c, .word = 0xe734, .immediate=0, .flags=0x00, .name = "WE734" },
  { .ov = 16, .code = 0x1d29, .word = 0xe7d2, .immediate=0, .flags=0x00, .name = "WE7D2" },
  { .ov = 16, .code = 0x224c, .word = 0xe7e1, .immediate=0, .flags=0x00, .name = "WE7E1" },
  { .ov = 16, .code = 0x224c, .word = 0xe815, .immediate=0, .flags=0x00, .name = "WE815" },
  { .ov = 16, .code = 0x224c, .word = 0xe851, .immediate=0, .flags=0x00, .name = "WE851" },
  { .ov = 16, .code = 0x224c, .word = 0xe920, .immediate=0, .flags=0x00, .name = "WE920" },
  { .ov = 16, .code = 0x224c, .word = 0xe942, .immediate=0, .flags=0x00, .name = "WE942" },
  { .ov = 16, .code = 0x224c, .word = 0xe974, .immediate=0, .flags=0x00, .name = "WE974" },
  { .ov = 16, .code = 0x224c, .word = 0xe98e, .immediate=0, .flags=0x00, .name = "WE98E" },
  { .ov = 16, .code = 0x224c, .word = 0xe9b8, .immediate=0, .flags=0x00, .name = "WE9B8" },
  { .ov = 16, .code = 0x224c, .word = 0xea04, .immediate=0, .flags=0x00, .name = "WEA04" },
  { .ov = 16, .code = 0x224c, .word = 0xea30, .immediate=0, .flags=0x00, .name = "WEA30" },
  { .ov = 16, .code = 0x224c, .word = 0xea44, .immediate=0, .flags=0x00, .name = "WEA44" },
  { .ov = 16, .code = 0x224c, .word = 0xea97, .immediate=0, .flags=0x00, .name = "WEA97" },
  { .ov = 16, .code = 0x224c, .word = 0xeace, .immediate=0, .flags=0x00, .name = "WEACE" },
  { .ov = 16, .code = 0x224c, .word = 0xeae3, .immediate=0, .flags=0x00, .name = "WEAE3" },
  { .ov = 16, .code = 0x224c, .word = 0xeaff, .immediate=0, .flags=0x00, .name = "WEAFF" },
  { .ov = 16, .code = 0x224c, .word = 0xeb09, .immediate=0, .flags=0x00, .name = "WEB09" },
  { .ov = 16, .code = 0x224c, .word = 0xeb11, .immediate=0, .flags=0x00, .name = "WEB11" },
  { .ov = 16, .code = 0x224c, .word = 0xeb23, .immediate=0, .flags=0x00, .name = "WEB23" },
  { .ov = 16, .code = 0x224c, .word = 0xeb35, .immediate=0, .flags=0x00, .name = "WEB35" },
  { .ov = 16, .code = 0x224c, .word = 0xeb45, .immediate=0, .flags=0x00, .name = "WEB45" },
  { .ov = 16, .code = 0x224c, .word = 0xebb3, .immediate=0, .flags=0x00, .name = "WEBB3" },
  { .ov = 16, .code = 0x224c, .word = 0xebe1, .immediate=0, .flags=0x00, .name = "WEBE1" },
  { .ov = 16, .code = 0x224c, .word = 0xebeb, .immediate=0, .flags=0x00, .name = "WEBEB" },
  { .ov = 16, .code = 0x224c, .word = 0xec21, .immediate=0, .flags=0x00, .name = "WEC21" },
  { .ov = 16, .code = 0x224c, .word = 0xec63, .immediate=0, .flags=0x00, .name = "WEC63" },
  { .ov = 16, .code = 0x224c, .word = 0xec97, .immediate=0, .flags=0x00, .name = "WEC97" },
  { .ov = 16, .code = 0x224c, .word = 0xecb5, .immediate=0, .flags=0x00, .name = "WECB5" },
  { .ov = 16, .code = 0x224c, .word = 0xece5, .immediate=0, .flags=0x00, .name = "WECE5" },
  { .ov = 16, .code = 0x4b3b, .word = 0xed0f, .immediate=0, .flags=0x80, .name = "TD-SCROLL" },
  { .ov = 16, .code = 0x224c, .word = 0xed1d, .immediate=0, .flags=0x00, .name = "WED1D" },
  { .ov = 16, .code = 0x224c, .word = 0xed4c, .immediate=0, .flags=0x00, .name = "WED4C" },
  { .ov = 16, .code = 0x224c, .word = 0xed62, .immediate=0, .flags=0x00, .name = "WED62" },
  { .ov = 16, .code = 0x224c, .word = 0xed96, .immediate=0, .flags=0x00, .name = "WED96" },
  { .ov = 16, .code = 0x224c, .word = 0xee30, .immediate=0, .flags=0x00, .name = "WEE30" },
  { .ov = 16, .code = 0x224c, .word = 0xee89, .immediate=0, .flags=0x80, .name = "KEY-ELEM-AMT" },
  { .ov = 16, .code = 0x224c, .word = 0xef7e, .immediate=0, .flags=0x00, .name = "WEF7E" },
  { .ov = 16, .code = 0x224c, .word = 0xef98, .immediate=0, .flags=0x00, .name = "WEF98" },
  { .ov = 16, .code = 0x224c, .word = 0xefde, .immediate=0, .flags=0x00, .name = "WEFDE" },
  { .ov = 16, .code = 0x224c, .word = 0xefea, .immediate=0, .flags=0x00, .name = "WEFEA" },
  { .ov = 16, .code = 0x224c, .word = 0xf07e, .immediate=0, .flags=0x00, .name = "WF07E" },
  { .ov = 16, .code = 0x224c, .word = 0xf0f2, .immediate=0, .flags=0x00, .name = "WF0F2" },
  { .ov = 16, .code = 0x224c, .word = 0xf148, .immediate=0, .flags=0x00, .name = "WF148" },
  { .ov = 16, .code = 0x224c, .word = 0xf162, .immediate=0, .flags=0x00, .name = "WF162" },
  { .ov = 16, .code = 0x224c, .word = 0xf174, .immediate=0, .flags=0x00, .name = "WF174" },
  { .ov = 16, .code = 0x4b3b, .word = 0xf1c8, .immediate=0, .flags=0x80, .name = "SELL-WHAT" },
  { .ov = 16, .code = 0x224c, .word = 0xf1e4, .immediate=0, .flags=0x80, .name = "SELL-IT" },
  { .ov = 16, .code = 0x224c, .word = 0xf228, .immediate=0, .flags=0x00, .name = "WF228" },
  { .ov = 16, .code = 0x224c, .word = 0xf25a, .immediate=0, .flags=0x00, .name = "WF25A" },
  { .ov = 16, .code = 0x224c, .word = 0xf312, .immediate=0, .flags=0x00, .name = "WF312" },
  { .ov = 16, .code = 0x224c, .word = 0xf35c, .immediate=0, .flags=0x00, .name = "WF35C" },
  { .ov = 16, .code = 0x4b3b, .word = 0xf3ff, .immediate=0, .flags=0x80, .name = "BUY-WHAT" },
  { .ov = 16, .code = 0x224c, .word = 0xf40d, .immediate=0, .flags=0x00, .name = "WF40D" },
  { .ov = 16, .code = 0x224c, .word = 0xf451, .immediate=0, .flags=0x00, .name = "WF451" },
  { .ov = 16, .code = 0x4b3b, .word = 0xf4be, .immediate=0, .flags=0x80, .name = "DEPOT-FUNCTION" },
  { .ov = 16, .code = 0x224c, .word = 0xf4dc, .immediate=0, .flags=0x80, .name = "(U-DEPOT)" },
  { .ov = 17, .code = 0x1d29, .word = 0xedd6, .immediate=0, .flags=0x00, .name = "WEDD6" },
  { .ov = 17, .code = 0x1d29, .word = 0xedee, .immediate=0, .flags=0x80, .name = "STAMP" },
  { .ov = 17, .code = 0x224c, .word = 0xedf2, .immediate=0, .flags=0x00, .name = "WEDF2" },
  { .ov = 17, .code = 0x224c, .word = 0xedfc, .immediate=0, .flags=0x00, .name = "WEDFC" },
  { .ov = 17, .code = 0x224c, .word = 0xee06, .immediate=0, .flags=0x00, .name = "WEE06" },
  { .ov = 17, .code = 0x224c, .word = 0xee10, .immediate=0, .flags=0x00, .name = "WEE10" },
  { .ov = 17, .code = 0x224c, .word = 0xee1a, .immediate=0, .flags=0x00, .name = "WEE1A" },
  { .ov = 17, .code = 0x224c, .word = 0xee24, .immediate=0, .flags=0x00, .name = "WEE24" },
  { .ov = 17, .code = 0x224c, .word = 0xee2e, .immediate=0, .flags=0x00, .name = "WEE2E" },
  { .ov = 17, .code = 0x224c, .word = 0xee38, .immediate=0, .flags=0x00, .name = "WEE38" },
  { .ov = 17, .code = 0x224c, .word = 0xee42, .immediate=0, .flags=0x00, .name = "WEE42" },
  { .ov = 17, .code = 0x224c, .word = 0xee4c, .immediate=0, .flags=0x00, .name = "WEE4C" },
  { .ov = 17, .code = 0x224c, .word = 0xee56, .immediate=0, .flags=0x00, .name = "WEE56" },
  { .ov = 17, .code = 0x224c, .word = 0xee60, .immediate=0, .flags=0x00, .name = "WEE60" },
  { .ov = 17, .code = 0x2214, .word = 0xee6a, .immediate=0, .flags=0x00, .name = "WEE6A" },
  { .ov = 17, .code = 0x2214, .word = 0xee6e, .immediate=0, .flags=0x00, .name = "WEE6E" },
  { .ov = 17, .code = 0x1d29, .word = 0xee72, .immediate=0, .flags=0x00, .name = "WEE72" },
  { .ov = 17, .code = 0x1d29, .word = 0xee76, .immediate=0, .flags=0x00, .name = "WEE76" },
  { .ov = 17, .code = 0x1d29, .word = 0xee7a, .immediate=0, .flags=0x00, .name = "WEE7A" },
  { .ov = 17, .code = 0x224c, .word = 0xee7e, .immediate=0, .flags=0x00, .name = "WEE7E" },
  { .ov = 17, .code = 0x224c, .word = 0xee94, .immediate=0, .flags=0x00, .name = "WEE94" },
  { .ov = 17, .code = 0x224c, .word = 0xeea0, .immediate=0, .flags=0x00, .name = "WEEA0" },
  { .ov = 17, .code = 0x224c, .word = 0xeea8, .immediate=0, .flags=0x00, .name = "WEEA8" },
  { .ov = 17, .code = 0x224c, .word = 0xeeb0, .immediate=0, .flags=0x00, .name = "WEEB0" },
  { .ov = 17, .code = 0x224c, .word = 0xeec0, .immediate=0, .flags=0x00, .name = "WEEC0" },
  { .ov = 17, .code = 0x224c, .word = 0xeed4, .immediate=0, .flags=0x00, .name = "WEED4" },
  { .ov = 17, .code = 0x224c, .word = 0xeee4, .immediate=0, .flags=0x00, .name = "WEEE4" },
  { .ov = 17, .code = 0x224c, .word = 0xeef4, .immediate=0, .flags=0x00, .name = "WEEF4" },
  { .ov = 17, .code = 0x224c, .word = 0xef04, .immediate=0, .flags=0x00, .name = "WEF04" },
  { .ov = 17, .code = 0x224c, .word = 0xef16, .immediate=0, .flags=0x00, .name = "WEF16" },
  { .ov = 17, .code = 0x224c, .word = 0xef26, .immediate=0, .flags=0x00, .name = "WEF26" },
  { .ov = 17, .code = 0x224c, .word = 0xef34, .immediate=0, .flags=0x00, .name = "WEF34" },
  { .ov = 17, .code = 0x224c, .word = 0xef44, .immediate=0, .flags=0x00, .name = "WEF44" },
  { .ov = 17, .code = 0x224c, .word = 0xef54, .immediate=0, .flags=0x00, .name = "WEF54" },
  { .ov = 17, .code = 0x224c, .word = 0xef5c, .immediate=0, .flags=0x00, .name = "WEF5C" },
  { .ov = 17, .code = 0x224c, .word = 0xef66, .immediate=0, .flags=0x00, .name = "WEF66" },
  { .ov = 17, .code = 0x224c, .word = 0xef70, .immediate=0, .flags=0x00, .name = "WEF70" },
  { .ov = 17, .code = 0x224c, .word = 0xef7a, .immediate=0, .flags=0x00, .name = "WEF7A" },
  { .ov = 17, .code = 0x224c, .word = 0xef84, .immediate=0, .flags=0x00, .name = "WEF84" },
  { .ov = 17, .code = 0x224c, .word = 0xef8c, .immediate=0, .flags=0x00, .name = "WEF8C" },
  { .ov = 17, .code = 0x224c, .word = 0xef96, .immediate=0, .flags=0x00, .name = "WEF96" },
  { .ov = 17, .code = 0x224c, .word = 0xefc0, .immediate=0, .flags=0x00, .name = "WEFC0" },
  { .ov = 17, .code = 0x224c, .word = 0xefe4, .immediate=0, .flags=0x00, .name = "WEFE4" },
  { .ov = 17, .code = 0x224c, .word = 0xeffc, .immediate=0, .flags=0x00, .name = "WEFFC" },
  { .ov = 17, .code = 0x224c, .word = 0xf00c, .immediate=0, .flags=0x00, .name = "WF00C" },
  { .ov = 17, .code = 0x224c, .word = 0xf02e, .immediate=0, .flags=0x80, .name = ".MODE" },
  { .ov = 17, .code = 0x224c, .word = 0xf069, .immediate=0, .flags=0x80, .name = "DISPLAYKEY" },
  { .ov = 17, .code = 0x224c, .word = 0xf0ca, .immediate=0, .flags=0x80, .name = "CLEAR" },
  { .ov = 17, .code = 0x224c, .word = 0xf0e9, .immediate=0, .flags=0x80, .name = "ML" },
  { .ov = 17, .code = 0x224c, .word = 0xf102, .immediate=0, .flags=0x80, .name = "MLDN" },
  { .ov = 17, .code = 0x224c, .word = 0xf111, .immediate=0, .flags=0x80, .name = "MLUP" },
  { .ov = 17, .code = 0x224c, .word = 0xf123, .immediate=0, .flags=0x80, .name = "LHOLD" },
  { .ov = 17, .code = 0x224c, .word = 0xf138, .immediate=0, .flags=0x80, .name = "(DUPL)" },
  { .ov = 17, .code = 0x224c, .word = 0xf15d, .immediate=0, .flags=0x80, .name = "INSL" },
  { .ov = 17, .code = 0x224c, .word = 0xf170, .immediate=0, .flags=0x80, .name = "DUPL" },
  { .ov = 17, .code = 0x224c, .word = 0xf180, .immediate=0, .flags=0x80, .name = "SPLIT" },
  { .ov = 17, .code = 0x224c, .word = 0xf1a9, .immediate=0, .flags=0x80, .name = "XL" },
  { .ov = 17, .code = 0x224c, .word = 0xf1da, .immediate=0, .flags=0x80, .name = "XC" },
  { .ov = 17, .code = 0x224c, .word = 0xf205, .immediate=0, .flags=0x80, .name = "INSERT" },
  { .ov = 17, .code = 0x224c, .word = 0xf24c, .immediate=0, .flags=0x80, .name = "DELETE" },
  { .ov = 17, .code = 0x4b82, .word = 0xf272, .immediate=0, .flags=0x80, .name = "#>MON" },
  { .ov = 17, .code = 0x224c, .word = 0xf29b, .immediate=0, .flags=0x80, .name = "?VISIBLE" },
  { .ov = 17, .code = 0x224c, .word = 0xf2b9, .immediate=0, .flags=0x80, .name = "EOL" },
  { .ov = 17, .code = 0x224c, .word = 0xf2dd, .immediate=0, .flags=0x80, .name = "PUT" },
  { .ov = 17, .code = 0x224c, .word = 0xf342, .immediate=0, .flags=0x80, .name = "SET-USER" },
  { .ov = 17, .code = 0x224c, .word = 0xf3dc, .immediate=0, .flags=0x00, .name = "WF3DC" },
  { .ov = 17, .code = 0x224c, .word = 0xf3e8, .immediate=0, .flags=0x00, .name = "WF3E8" },
  { .ov = 17, .code = 0x224c, .word = 0xf3f2, .immediate=0, .flags=0x00, .name = "WF3F2" },
  { .ov = 17, .code = 0x224c, .word = 0xf3fc, .immediate=0, .flags=0x00, .name = "WF3FC" },
  { .ov = 17, .code = 0x224c, .word = 0xf406, .immediate=0, .flags=0x00, .name = "WF406" },
  { .ov = 17, .code = 0x224c, .word = 0xf40e, .immediate=0, .flags=0x00, .name = "WF40E" },
  { .ov = 17, .code = 0x224c, .word = 0xf416, .immediate=0, .flags=0x00, .name = "WF416" },
  { .ov = 17, .code = 0x224c, .word = 0xf42f, .immediate=0, .flags=0x80, .name = ">STAMP" },
  { .ov = 17, .code = 0x4b3b, .word = 0xf487, .immediate=0, .flags=0x80, .name = "EDIT-KEYS" },
  { .ov = 17, .code = 0x224c, .word = 0xf4f4, .immediate=0, .flags=0x80, .name = "EDIT" },
  { .ov = 17, .code = 0x4b3b, .word = 0xf522, .immediate=0, .flags=0x80, .name = "VIEW-KEYS" },
  { .ov = 17, .code = 0x224c, .word = 0xf53b, .immediate=0, .flags=0x80, .name = "VIEW" },
  { .ov = 18, .code = 0x7420, .word = 0xecf6, .immediate=0, .flags=0x00, .name = "WECF6" },
  { .ov = 18, .code = 0x7420, .word = 0xecfb, .immediate=0, .flags=0x00, .name = "WECFB" },
  { .ov = 18, .code = 0x7420, .word = 0xed00, .immediate=0, .flags=0x00, .name = "WED00" },
  { .ov = 18, .code = 0x7420, .word = 0xed05, .immediate=0, .flags=0x00, .name = "WED05" },
  { .ov = 18, .code = 0x1d29, .word = 0xed0a, .immediate=0, .flags=0x00, .name = "WED0A" },
  { .ov = 18, .code = 0x224c, .word = 0xed0e, .immediate=0, .flags=0x00, .name = "WED0E" },
  { .ov = 18, .code = 0x224c, .word = 0xed54, .immediate=0, .flags=0x00, .name = "WED54" },
  { .ov = 18, .code = 0x224c, .word = 0xed62, .immediate=0, .flags=0x00, .name = "WED62" },
  { .ov = 18, .code = 0x1d29, .word = 0xed8c, .immediate=0, .flags=0x00, .name = "WED8C" },
  { .ov = 18, .code = 0x224c, .word = 0xed90, .immediate=0, .flags=0x00, .name = "WED90" },
  { .ov = 18, .code = 0x1d29, .word = 0xedf7, .immediate=0, .flags=0x80, .name = "MANX" },
  { .ov = 18, .code = 0x1d29, .word = 0xee02, .immediate=0, .flags=0x80, .name = "MANY" },
  { .ov = 18, .code = 0x224c, .word = 0xee06, .immediate=0, .flags=0x00, .name = "WEE06" },
  { .ov = 18, .code = 0x224c, .word = 0xee18, .immediate=0, .flags=0x00, .name = "WEE18" },
  { .ov = 18, .code = 0x224c, .word = 0xee28, .immediate=0, .flags=0x00, .name = "WEE28" },
  { .ov = 18, .code = 0x224c, .word = 0xee38, .immediate=0, .flags=0x00, .name = "WEE38" },
  { .ov = 18, .code = 0x224c, .word = 0xee48, .immediate=0, .flags=0x00, .name = "WEE48" },
  { .ov = 18, .code = 0x224c, .word = 0xee58, .immediate=0, .flags=0x00, .name = "WEE58" },
  { .ov = 18, .code = 0x224c, .word = 0xee68, .immediate=0, .flags=0x00, .name = "WEE68" },
  { .ov = 18, .code = 0x224c, .word = 0xee7c, .immediate=0, .flags=0x80, .name = "|REGION" },
  { .ov = 18, .code = 0x1d29, .word = 0xeed0, .immediate=0, .flags=0x00, .name = "WEED0" },
  { .ov = 18, .code = 0x1d29, .word = 0xeed4, .immediate=0, .flags=0x00, .name = "WEED4" },
  { .ov = 18, .code = 0x224c, .word = 0xeee5, .immediate=0, .flags=0x00, .name = "WEEE5" },
  { .ov = 18, .code = 0x1d29, .word = 0xef0f, .immediate=0, .flags=0x00, .name = "WEF0F" },
  { .ov = 18, .code = 0x224c, .word = 0xef15, .immediate=0, .flags=0x00, .name = "WEF15" },
  { .ov = 18, .code = 0x224c, .word = 0xef23, .immediate=0, .flags=0x00, .name = "WEF23" },
  { .ov = 18, .code = 0x224c, .word = 0xef37, .immediate=0, .flags=0x00, .name = "WEF37" },
  { .ov = 18, .code = 0x224c, .word = 0xef48, .immediate=0, .flags=0x00, .name = "WEF48" },
  { .ov = 18, .code = 0x224c, .word = 0xef61, .immediate=0, .flags=0x00, .name = "WEF61" },
  { .ov = 18, .code = 0x224c, .word = 0xef71, .immediate=0, .flags=0x00, .name = "WEF71" },
  { .ov = 18, .code = 0x224c, .word = 0xef87, .immediate=0, .flags=0x00, .name = "WEF87" },
  { .ov = 18, .code = 0x224c, .word = 0xef99, .immediate=0, .flags=0x00, .name = "WEF99" },
  { .ov = 18, .code = 0x224c, .word = 0xefa4, .immediate=0, .flags=0x00, .name = "WEFA4" },
  { .ov = 18, .code = 0x224c, .word = 0xefb6, .immediate=0, .flags=0x00, .name = "WEFB6" },
  { .ov = 18, .code = 0x4b3b, .word = 0xefdc, .immediate=0, .flags=0x80, .name = "(.DOOR)" },
  { .ov = 18, .code = 0x224c, .word = 0xeffe, .immediate=0, .flags=0x00, .name = "WEFFE" },
  { .ov = 18, .code = 0x224c, .word = 0xf00e, .immediate=0, .flags=0x00, .name = "WF00E" },
  { .ov = 18, .code = 0x224c, .word = 0xf02e, .immediate=0, .flags=0x00, .name = "WF02E" },
  { .ov = 18, .code = 0x1d29, .word = 0xf074, .immediate=0, .flags=0x00, .name = "WF074" },
  { .ov = 18, .code = 0x2214, .word = 0xf083, .immediate=0, .flags=0x80, .name = "STPORT" },
  { .ov = 18, .code = 0x224c, .word = 0xf091, .immediate=0, .flags=0x00, .name = "WF091" },
  { .ov = 18, .code = 0x224c, .word = 0xf0a1, .immediate=0, .flags=0x00, .name = "WF0A1" },
  { .ov = 18, .code = 0x224c, .word = 0xf0b7, .immediate=0, .flags=0x00, .name = "WF0B7" },
  { .ov = 18, .code = 0x224c, .word = 0xf11c, .immediate=0, .flags=0x00, .name = "WF11C" },
  { .ov = 18, .code = 0x224c, .word = 0xf198, .immediate=0, .flags=0x00, .name = "WF198" },
  { .ov = 18, .code = 0x1d29, .word = 0xf1be, .immediate=0, .flags=0x00, .name = "WF1BE" },
  { .ov = 18, .code = 0x1d29, .word = 0xf1c2, .immediate=0, .flags=0x00, .name = "WF1C2" },
  { .ov = 18, .code = 0x1d29, .word = 0xf1c6, .immediate=0, .flags=0x00, .name = "WF1C6" },
  { .ov = 18, .code = 0x1d29, .word = 0xf1d4, .immediate=0, .flags=0x00, .name = "WF1D4" },
  { .ov = 18, .code = 0x1d29, .word = 0xf270, .immediate=0, .flags=0x00, .name = "WF270" },
  { .ov = 18, .code = 0x224c, .word = 0xf2aa, .immediate=0, .flags=0x00, .name = "WF2AA" },
  { .ov = 18, .code = 0x224c, .word = 0xf2c8, .immediate=0, .flags=0x00, .name = "WF2C8" },
  { .ov = 18, .code = 0x224c, .word = 0xf308, .immediate=0, .flags=0x00, .name = "WF308" },
  { .ov = 18, .code = 0x224c, .word = 0xf33e, .immediate=0, .flags=0x00, .name = "WF33E" },
  { .ov = 18, .code = 0x224c, .word = 0xf346, .immediate=0, .flags=0x00, .name = "WF346" },
  { .ov = 18, .code = 0x224c, .word = 0xf352, .immediate=0, .flags=0x00, .name = "WF352" },
  { .ov = 18, .code = 0x224c, .word = 0xf360, .immediate=0, .flags=0x00, .name = "WF360" },
  { .ov = 18, .code = 0x224c, .word = 0xf37e, .immediate=0, .flags=0x00, .name = "WF37E" },
  { .ov = 18, .code = 0x224c, .word = 0xf3d0, .immediate=0, .flags=0x00, .name = "WF3D0" },
  { .ov = 18, .code = 0x224c, .word = 0xf410, .immediate=0, .flags=0x00, .name = "WF410" },
  { .ov = 18, .code = 0x224c, .word = 0xf41c, .immediate=0, .flags=0x00, .name = "WF41C" },
  { .ov = 18, .code = 0x224c, .word = 0xf42a, .immediate=0, .flags=0x00, .name = "WF42A" },
  { .ov = 18, .code = 0x224c, .word = 0xf486, .immediate=0, .flags=0x00, .name = "WF486" },
  { .ov = 18, .code = 0x4b3b, .word = 0xf49e, .immediate=0, .flags=0x80, .name = "DO-ROOM" },
  { .ov = 18, .code = 0x224c, .word = 0xf4c0, .immediate=0, .flags=0x00, .name = "WF4C0" },
  { .ov = 18, .code = 0x4b3b, .word = 0xf4fc, .immediate=0, .flags=0x80, .name = "XWALK" },
  { .ov = 18, .code = 0x224c, .word = 0xf514, .immediate=0, .flags=0x80, .name = "WALKIES" },
  { .ov = 18, .code = 0x224c, .word = 0xf54d, .immediate=0, .flags=0x80, .name = "PPIC" },
  { .ov = 19, .code = 0x2214, .word = 0xf186, .immediate=0, .flags=0x00, .name = "WF186" },
  { .ov = 19, .code = 0x2214, .word = 0xf18a, .immediate=0, .flags=0x00, .name = "WF18A" },
  { .ov = 19, .code = 0x2214, .word = 0xf18e, .immediate=0, .flags=0x00, .name = "WF18E" },
  { .ov = 19, .code = 0x7394, .word = 0xf192, .immediate=0, .flags=0x00, .name = "WF192" },
  { .ov = 19, .code = 0x7394, .word = 0xf19a, .immediate=0, .flags=0x00, .name = "WF19A" },
  { .ov = 19, .code = 0x7394, .word = 0xf1a2, .immediate=0, .flags=0x00, .name = "WF1A2" },
  { .ov = 19, .code = 0x7394, .word = 0xf1aa, .immediate=0, .flags=0x00, .name = "WF1AA" },
  { .ov = 19, .code = 0x7394, .word = 0xf1b2, .immediate=0, .flags=0x00, .name = "WF1B2" },
  { .ov = 19, .code = 0x7394, .word = 0xf1ba, .immediate=0, .flags=0x00, .name = "WF1BA" },
  { .ov = 19, .code = 0x7394, .word = 0xf1c2, .immediate=0, .flags=0x00, .name = "WF1C2" },
  { .ov = 19, .code = 0x7394, .word = 0xf1ca, .immediate=0, .flags=0x00, .name = "WF1CA" },
  { .ov = 19, .code = 0x7394, .word = 0xf1d2, .immediate=0, .flags=0x00, .name = "WF1D2" },
  { .ov = 19, .code = 0x7394, .word = 0xf1da, .immediate=0, .flags=0x00, .name = "WF1DA" },
  { .ov = 19, .code = 0x7394, .word = 0xf1e2, .immediate=0, .flags=0x00, .name = "WF1E2" },
  { .ov = 19, .code = 0x7394, .word = 0xf1ea, .immediate=0, .flags=0x00, .name = "WF1EA" },
  { .ov = 19, .code = 0x7394, .word = 0xf1f2, .immediate=0, .flags=0x00, .name = "WF1F2" },
  { .ov = 19, .code = 0x7394, .word = 0xf1fa, .immediate=0, .flags=0x00, .name = "WF1FA" },
  { .ov = 19, .code = 0x7394, .word = 0xf202, .immediate=0, .flags=0x00, .name = "WF202" },
  { .ov = 19, .code = 0x7394, .word = 0xf20a, .immediate=0, .flags=0x00, .name = "WF20A" },
  { .ov = 19, .code = 0x7394, .word = 0xf212, .immediate=0, .flags=0x00, .name = "WF212" },
  { .ov = 19, .code = 0x7394, .word = 0xf21a, .immediate=0, .flags=0x00, .name = "WF21A" },
  { .ov = 19, .code = 0x7394, .word = 0xf222, .immediate=0, .flags=0x00, .name = "WF222" },
  { .ov = 19, .code = 0x7394, .word = 0xf22a, .immediate=0, .flags=0x00, .name = "WF22A" },
  { .ov = 19, .code = 0x7394, .word = 0xf232, .immediate=0, .flags=0x00, .name = "WF232" },
  { .ov = 19, .code = 0x7394, .word = 0xf23a, .immediate=0, .flags=0x00, .name = "WF23A" },
  { .ov = 19, .code = 0x7394, .word = 0xf242, .immediate=0, .flags=0x00, .name = "WF242" },
  { .ov = 19, .code = 0x7394, .word = 0xf24a, .immediate=0, .flags=0x00, .name = "WF24A" },
  { .ov = 19, .code = 0x7394, .word = 0xf252, .immediate=0, .flags=0x00, .name = "WF252" },
  { .ov = 19, .code = 0x7394, .word = 0xf25a, .immediate=0, .flags=0x00, .name = "WF25A" },
  { .ov = 19, .code = 0x7394, .word = 0xf262, .immediate=0, .flags=0x00, .name = "WF262" },
  { .ov = 19, .code = 0x7394, .word = 0xf26a, .immediate=0, .flags=0x00, .name = "WF26A" },
  { .ov = 19, .code = 0x7420, .word = 0xf272, .immediate=0, .flags=0x00, .name = "WF272" },
  { .ov = 19, .code = 0x224c, .word = 0xf277, .immediate=0, .flags=0x00, .name = "WF277" },
  { .ov = 19, .code = 0x224c, .word = 0xf27f, .immediate=0, .flags=0x00, .name = "WF27F" },
  { .ov = 19, .code = 0x224c, .word = 0xf28b, .immediate=0, .flags=0x00, .name = "WF28B" },
  { .ov = 19, .code = 0x224c, .word = 0xf295, .immediate=0, .flags=0x00, .name = "WF295" },
  { .ov = 19, .code = 0x224c, .word = 0xf2a1, .immediate=0, .flags=0x00, .name = "WF2A1" },
  { .ov = 19, .code = 0x224c, .word = 0xf2b7, .immediate=0, .flags=0x00, .name = "WF2B7" },
  { .ov = 19, .code = 0x224c, .word = 0xf2ce, .immediate=0, .flags=0x00, .name = "WF2CE" },
  { .ov = 19, .code = 0x224c, .word = 0xf2dc, .immediate=0, .flags=0x00, .name = "WF2DC" },
  { .ov = 19, .code = 0x224c, .word = 0xf374, .immediate=0, .flags=0x00, .name = "WF374" },
  { .ov = 19, .code = 0x224c, .word = 0xf39c, .immediate=0, .flags=0x00, .name = "WF39C" },
  { .ov = 19, .code = 0x224c, .word = 0xf3aa, .immediate=0, .flags=0x00, .name = "WF3AA" },
  { .ov = 19, .code = 0xf2bf, .word = 0xf3ed, .immediate=0, .flags=0x80, .name = "A.DENSIT" },
  { .ov = 19, .code = 0xf2bf, .word = 0xf408, .immediate=0, .flags=0x80, .name = "PLANET.G" },
  { .ov = 19, .code = 0x224c, .word = 0xf418, .immediate=0, .flags=0x00, .name = "WF418" },
  { .ov = 19, .code = 0x224c, .word = 0xf440, .immediate=0, .flags=0x00, .name = "WF440" },
  { .ov = 19, .code = 0x224c, .word = 0xf45e, .immediate=0, .flags=0x00, .name = "WF45E" },
  { .ov = 19, .code = 0x224c, .word = 0xf474, .immediate=0, .flags=0x00, .name = "WF474" },
  { .ov = 19, .code = 0x224c, .word = 0xf4c8, .immediate=0, .flags=0x80, .name = "DIO" },
  { .ov = 20, .code = 0x7420, .word = 0xebc6, .immediate=0, .flags=0x00, .name = "WEBC6" },
  { .ov = 20, .code = 0x7420, .word = 0xebcb, .immediate=0, .flags=0x00, .name = "WEBCB" },
  { .ov = 20, .code = 0x7420, .word = 0xebd0, .immediate=0, .flags=0x00, .name = "WEBD0" },
  { .ov = 20, .code = 0x224c, .word = 0xebd5, .immediate=0, .flags=0x00, .name = "WEBD5" },
  { .ov = 20, .code = 0x224c, .word = 0xebdf, .immediate=0, .flags=0x00, .name = "WEBDF" },
  { .ov = 20, .code = 0x224c, .word = 0xebe7, .immediate=0, .flags=0x00, .name = "WEBE7" },
  { .ov = 20, .code = 0x224c, .word = 0xebfd, .immediate=0, .flags=0x00, .name = "WEBFD" },
  { .ov = 20, .code = 0x1d29, .word = 0xec4b, .immediate=0, .flags=0x00, .name = "WEC4B" },
  { .ov = 20, .code = 0x1d29, .word = 0xec51, .immediate=0, .flags=0x00, .name = "WEC51" },
  { .ov = 20, .code = 0x1d29, .word = 0xec55, .immediate=0, .flags=0x00, .name = "WEC55" },
  { .ov = 20, .code = 0x1d29, .word = 0xec59, .immediate=0, .flags=0x00, .name = "WEC59" },
  { .ov = 20, .code = 0x1d29, .word = 0xec5d, .immediate=0, .flags=0x00, .name = "WEC5D" },
  { .ov = 20, .code = 0x1d29, .word = 0xec61, .immediate=0, .flags=0x00, .name = "WEC61" },
  { .ov = 20, .code = 0x224c, .word = 0xec65, .immediate=0, .flags=0x00, .name = "WEC65" },
  { .ov = 20, .code = 0x1d29, .word = 0xec7d, .immediate=0, .flags=0x00, .name = "WEC7D" },
  { .ov = 20, .code = 0x224c, .word = 0xec83, .immediate=0, .flags=0x00, .name = "WEC83" },
  { .ov = 20, .code = 0x224c, .word = 0xec99, .immediate=0, .flags=0x00, .name = "WEC99" },
  { .ov = 20, .code = 0x224c, .word = 0xeca1, .immediate=0, .flags=0x00, .name = "WECA1" },
  { .ov = 20, .code = 0x224c, .word = 0xecaf, .immediate=0, .flags=0x00, .name = "WECAF" },
  { .ov = 20, .code = 0x224c, .word = 0xecbd, .immediate=0, .flags=0x00, .name = "WECBD" },
  { .ov = 20, .code = 0x224c, .word = 0xecf5, .immediate=0, .flags=0x00, .name = "WECF5" },
  { .ov = 20, .code = 0x1d29, .word = 0xed5d, .immediate=0, .flags=0x00, .name = "WED5D" },
  { .ov = 20, .code = 0x1d29, .word = 0xed9b, .immediate=0, .flags=0x00, .name = "WED9B" },
  { .ov = 20, .code = 0x1d29, .word = 0xed9f, .immediate=0, .flags=0x00, .name = "WED9F" },
  { .ov = 20, .code = 0x224c, .word = 0xeda3, .immediate=0, .flags=0x00, .name = "WEDA3" },
  { .ov = 20, .code = 0x224c, .word = 0xedb5, .immediate=0, .flags=0x00, .name = "WEDB5" },
  { .ov = 20, .code = 0x224c, .word = 0xee25, .immediate=0, .flags=0x00, .name = "WEE25" },
  { .ov = 20, .code = 0x224c, .word = 0xee3f, .immediate=0, .flags=0x00, .name = "WEE3F" },
  { .ov = 20, .code = 0x224c, .word = 0xeebd, .immediate=0, .flags=0x00, .name = "WEEBD" },
  { .ov = 20, .code = 0x224c, .word = 0xeee3, .immediate=0, .flags=0x00, .name = "WEEE3" },
  { .ov = 20, .code = 0x224c, .word = 0xeeff, .immediate=0, .flags=0x00, .name = "WEEFF" },
  { .ov = 20, .code = 0x224c, .word = 0xef0d, .immediate=0, .flags=0x00, .name = "WEF0D" },
  { .ov = 20, .code = 0x224c, .word = 0xef15, .immediate=0, .flags=0x00, .name = "WEF15" },
  { .ov = 20, .code = 0x224c, .word = 0xef1d, .immediate=0, .flags=0x00, .name = "WEF1D" },
  { .ov = 20, .code = 0x224c, .word = 0xef25, .immediate=0, .flags=0x00, .name = "WEF25" },
  { .ov = 20, .code = 0x224c, .word = 0xef93, .immediate=0, .flags=0x00, .name = "WEF93" },
  { .ov = 20, .code = 0x224c, .word = 0xefd4, .immediate=0, .flags=0x00, .name = "WEFD4" },
  { .ov = 20, .code = 0x224c, .word = 0xf078, .immediate=0, .flags=0x00, .name = "WF078" },
  { .ov = 20, .code = 0x224c, .word = 0xf098, .immediate=0, .flags=0x00, .name = "WF098" },
  { .ov = 20, .code = 0x224c, .word = 0xf0b2, .immediate=0, .flags=0x00, .name = "WF0B2" },
  { .ov = 20, .code = 0x224c, .word = 0xf0ca, .immediate=0, .flags=0x00, .name = "WF0CA" },
  { .ov = 20, .code = 0x224c, .word = 0xf0fe, .immediate=0, .flags=0x00, .name = "WF0FE" },
  { .ov = 20, .code = 0x224c, .word = 0xf146, .immediate=0, .flags=0x00, .name = "WF146" },
  { .ov = 20, .code = 0x224c, .word = 0xf164, .immediate=0, .flags=0x00, .name = "WF164" },
  { .ov = 20, .code = 0x2214, .word = 0xf174, .immediate=0, .flags=0x00, .name = "WF174" },
  { .ov = 20, .code = 0x2214, .word = 0xf178, .immediate=0, .flags=0x00, .name = "WF178" },
  { .ov = 20, .code = 0x2214, .word = 0xf17c, .immediate=0, .flags=0x00, .name = "WF17C" },
  { .ov = 20, .code = 0x2214, .word = 0xf180, .immediate=0, .flags=0x00, .name = "WF180" },
  { .ov = 20, .code = 0x224c, .word = 0xf184, .immediate=0, .flags=0x00, .name = "WF184" },
  { .ov = 20, .code = 0x224c, .word = 0xf1a6, .immediate=0, .flags=0x00, .name = "WF1A6" },
  { .ov = 20, .code = 0x224c, .word = 0xf1b6, .immediate=0, .flags=0x00, .name = "WF1B6" },
  { .ov = 20, .code = 0x224c, .word = 0xf265, .immediate=0, .flags=0x00, .name = "WF265" },
  { .ov = 20, .code = 0x224c, .word = 0xf297, .immediate=0, .flags=0x00, .name = "WF297" },
  { .ov = 20, .code = 0x224c, .word = 0xf2ad, .immediate=0, .flags=0x00, .name = "WF2AD" },
  { .ov = 20, .code = 0x224c, .word = 0xf338, .immediate=0, .flags=0x00, .name = "WF338" },
  { .ov = 20, .code = 0x224c, .word = 0xf3f9, .immediate=0, .flags=0x00, .name = "WF3F9" },
  { .ov = 20, .code = 0x224c, .word = 0xf40b, .immediate=0, .flags=0x00, .name = "WF40B" },
  { .ov = 20, .code = 0x224c, .word = 0xf431, .immediate=0, .flags=0x00, .name = "WF431" },
  { .ov = 20, .code = 0x224c, .word = 0xf441, .immediate=0, .flags=0x00, .name = "WF441" },
  { .ov = 20, .code = 0x224c, .word = 0xf45f, .immediate=0, .flags=0x00, .name = "WF45F" },
  { .ov = 20, .code = 0x224c, .word = 0xf4a5, .immediate=0, .flags=0x00, .name = "WF4A5" },
  { .ov = 20, .code = 0x224c, .word = 0xf506, .immediate=0, .flags=0x80, .name = "DO-EYE" },
  { .ov = 21, .code = 0x224c, .word = 0xe606, .immediate=0, .flags=0x00, .name = "WE606" },
  { .ov = 21, .code = 0x7394, .word = 0xe622, .immediate=0, .flags=0x00, .name = "WE622" },
  { .ov = 21, .code = 0x7394, .word = 0xe62a, .immediate=0, .flags=0x00, .name = "WE62A" },
  { .ov = 21, .code = 0x7394, .word = 0xe632, .immediate=0, .flags=0x00, .name = "WE632" },
  { .ov = 21, .code = 0x7394, .word = 0xe63a, .immediate=0, .flags=0x00, .name = "WE63A" },
  { .ov = 21, .code = 0x7394, .word = 0xe642, .immediate=0, .flags=0x00, .name = "WE642" },
  { .ov = 21, .code = 0x7420, .word = 0xe64a, .immediate=0, .flags=0x00, .name = "WE64A" },
  { .ov = 21, .code = 0x7420, .word = 0xe64f, .immediate=0, .flags=0x00, .name = "WE64F" },
  { .ov = 21, .code = 0x7420, .word = 0xe654, .immediate=0, .flags=0x00, .name = "WE654" },
  { .ov = 21, .code = 0x7420, .word = 0xe659, .immediate=0, .flags=0x00, .name = "WE659" },
  { .ov = 21, .code = 0x7420, .word = 0xe65e, .immediate=0, .flags=0x00, .name = "WE65E" },
  { .ov = 21, .code = 0x7394, .word = 0xe663, .immediate=0, .flags=0x00, .name = "WE663" },
  { .ov = 21, .code = 0x7394, .word = 0xe66b, .immediate=0, .flags=0x00, .name = "WE66B" },
  { .ov = 21, .code = 0x7394, .word = 0xe673, .immediate=0, .flags=0x00, .name = "WE673" },
  { .ov = 21, .code = 0x7394, .word = 0xe67b, .immediate=0, .flags=0x00, .name = "WE67B" },
  { .ov = 21, .code = 0x7394, .word = 0xe683, .immediate=0, .flags=0x00, .name = "WE683" },
  { .ov = 21, .code = 0x7394, .word = 0xe68b, .immediate=0, .flags=0x00, .name = "WE68B" },
  { .ov = 21, .code = 0x7394, .word = 0xe693, .immediate=0, .flags=0x00, .name = "WE693" },
  { .ov = 21, .code = 0x7394, .word = 0xe69b, .immediate=0, .flags=0x00, .name = "WE69B" },
  { .ov = 21, .code = 0x7394, .word = 0xe6a3, .immediate=0, .flags=0x00, .name = "WE6A3" },
  { .ov = 21, .code = 0x7394, .word = 0xe6ab, .immediate=0, .flags=0x00, .name = "WE6AB" },
  { .ov = 21, .code = 0x7420, .word = 0xe6b3, .immediate=0, .flags=0x00, .name = "WE6B3" },
  { .ov = 21, .code = 0x7420, .word = 0xe6b8, .immediate=0, .flags=0x00, .name = "WE6B8" },
  { .ov = 21, .code = 0x7394, .word = 0xe6bd, .immediate=0, .flags=0x00, .name = "WE6BD" },
  { .ov = 21, .code = 0x7394, .word = 0xe6c5, .immediate=0, .flags=0x00, .name = "WE6C5" },
  { .ov = 21, .code = 0x7394, .word = 0xe6cd, .immediate=0, .flags=0x00, .name = "WE6CD" },
  { .ov = 21, .code = 0x7420, .word = 0xe6d5, .immediate=0, .flags=0x00, .name = "WE6D5" },
  { .ov = 21, .code = 0x224c, .word = 0xe6da, .immediate=0, .flags=0x00, .name = "WE6DA" },
  { .ov = 21, .code = 0x224c, .word = 0xe6fb, .immediate=0, .flags=0x80, .name = "APAUSE" },
  { .ov = 21, .code = 0x224c, .word = 0xe765, .immediate=0, .flags=0x00, .name = "WE765" },
  { .ov = 21, .code = 0x224c, .word = 0xe771, .immediate=0, .flags=0x00, .name = "WE771" },
  { .ov = 21, .code = 0x224c, .word = 0xe78f, .immediate=0, .flags=0x00, .name = "WE78F" },
  { .ov = 21, .code = 0x224c, .word = 0xe797, .immediate=0, .flags=0x00, .name = "WE797" },
  { .ov = 21, .code = 0x224c, .word = 0xe7c7, .immediate=0, .flags=0x00, .name = "WE7C7" },
  { .ov = 21, .code = 0x224c, .word = 0xe7df, .immediate=0, .flags=0x00, .name = "WE7DF" },
  { .ov = 21, .code = 0x224c, .word = 0xe833, .immediate=0, .flags=0x00, .name = "WE833" },
  { .ov = 21, .code = 0x1d29, .word = 0xe83f, .immediate=0, .flags=0x00, .name = "WE83F" },
  { .ov = 21, .code = 0x224c, .word = 0xe843, .immediate=0, .flags=0x00, .name = "WE843" },
  { .ov = 21, .code = 0x224c, .word = 0xe853, .immediate=0, .flags=0x00, .name = "WE853" },
  { .ov = 21, .code = 0x224c, .word = 0xe8ab, .immediate=0, .flags=0x00, .name = "WE8AB" },
  { .ov = 21, .code = 0x224c, .word = 0xe8b3, .immediate=0, .flags=0x00, .name = "WE8B3" },
  { .ov = 21, .code = 0x224c, .word = 0xe8f5, .immediate=0, .flags=0x00, .name = "WE8F5" },
  { .ov = 21, .code = 0x224c, .word = 0xe90b, .immediate=0, .flags=0x00, .name = "WE90B" },
  { .ov = 21, .code = 0x224c, .word = 0xe956, .immediate=0, .flags=0x00, .name = "WE956" },
  { .ov = 21, .code = 0x224c, .word = 0xe972, .immediate=0, .flags=0x00, .name = "WE972" },
  { .ov = 21, .code = 0x224c, .word = 0xe98d, .immediate=0, .flags=0x00, .name = "WE98D" },
  { .ov = 21, .code = 0x224c, .word = 0xe9aa, .immediate=0, .flags=0x00, .name = "WE9AA" },
  { .ov = 21, .code = 0x224c, .word = 0xe9ba, .immediate=0, .flags=0x00, .name = "WE9BA" },
  { .ov = 21, .code = 0x224c, .word = 0xe9ce, .immediate=0, .flags=0x00, .name = "WE9CE" },
  { .ov = 21, .code = 0x4b3b, .word = 0xe9e1, .immediate=0, .flags=0x80, .name = ">SPECIAL" },
  { .ov = 21, .code = 0x224c, .word = 0xe9fb, .immediate=0, .flags=0x00, .name = "WE9FB" },
  { .ov = 21, .code = 0x224c, .word = 0xea33, .immediate=0, .flags=0x00, .name = "WEA33" },
  { .ov = 21, .code = 0x224c, .word = 0xea51, .immediate=0, .flags=0x00, .name = "WEA51" },
  { .ov = 21, .code = 0x224c, .word = 0xea73, .immediate=0, .flags=0x80, .name = ".PHRASE" },
  { .ov = 21, .code = 0x224c, .word = 0xea83, .immediate=0, .flags=0x00, .name = "WEA83" },
  { .ov = 21, .code = 0x224c, .word = 0xeaa0, .immediate=0, .flags=0x80, .name = ".APHRASE" },
  { .ov = 21, .code = 0x224c, .word = 0xeab0, .immediate=0, .flags=0x00, .name = "WEAB0" },
  { .ov = 21, .code = 0x224c, .word = 0xeaba, .immediate=0, .flags=0x00, .name = "WEABA" },
  { .ov = 21, .code = 0x224c, .word = 0xeac6, .immediate=0, .flags=0x00, .name = "WEAC6" },
  { .ov = 21, .code = 0x224c, .word = 0xead0, .immediate=0, .flags=0x00, .name = "WEAD0" },
  { .ov = 21, .code = 0x224c, .word = 0xeadc, .immediate=0, .flags=0x00, .name = "WEADC" },
  { .ov = 21, .code = 0x2214, .word = 0xeae4, .immediate=0, .flags=0x00, .name = "WEAE4" },
  { .ov = 21, .code = 0x2214, .word = 0xeae8, .immediate=0, .flags=0x00, .name = "WEAE8" },
  { .ov = 21, .code = 0x2214, .word = 0xeaec, .immediate=0, .flags=0x00, .name = "WEAEC" },
  { .ov = 21, .code = 0x2214, .word = 0xeaf0, .immediate=0, .flags=0x00, .name = "WEAF0" },
  { .ov = 21, .code = 0x2214, .word = 0xeaf4, .immediate=0, .flags=0x00, .name = "WEAF4" },
  { .ov = 21, .code = 0x4b3b, .word = 0xeb03, .immediate=0, .flags=0x80, .name = "RACE>TRA" },
  { .ov = 21, .code = 0x1d29, .word = 0xeb35, .immediate=0, .flags=0x00, .name = "WEB35" },
  { .ov = 21, .code = 0x224c, .word = 0xeb3b, .immediate=0, .flags=0x00, .name = "WEB3B" },
  { .ov = 21, .code = 0x224c, .word = 0xeb51, .immediate=0, .flags=0x00, .name = "WEB51" },
  { .ov = 21, .code = 0x1d29, .word = 0xeb63, .immediate=0, .flags=0x00, .name = "WEB63" },
  { .ov = 21, .code = 0x224c, .word = 0xeb67, .immediate=0, .flags=0x00, .name = "WEB67" },
  { .ov = 21, .code = 0x224c, .word = 0xeb8d, .immediate=0, .flags=0x00, .name = "WEB8D" },
  { .ov = 21, .code = 0x224c, .word = 0xebc1, .immediate=0, .flags=0x00, .name = "WEBC1" },
  { .ov = 21, .code = 0x224c, .word = 0xebcd, .immediate=0, .flags=0x00, .name = "WEBCD" },
  { .ov = 21, .code = 0x1d29, .word = 0xebdb, .immediate=0, .flags=0x00, .name = "WEBDB" },
  { .ov = 21, .code = 0x224c, .word = 0xebe0, .immediate=0, .flags=0x00, .name = "WEBE0" },
  { .ov = 21, .code = 0x224c, .word = 0xebea, .immediate=0, .flags=0x00, .name = "WEBEA" },
  { .ov = 21, .code = 0x224c, .word = 0xebf2, .immediate=0, .flags=0x00, .name = "WEBF2" },
  { .ov = 21, .code = 0x224c, .word = 0xebfc, .immediate=0, .flags=0x00, .name = "WEBFC" },
  { .ov = 21, .code = 0x224c, .word = 0xec10, .immediate=0, .flags=0x00, .name = "WEC10" },
  { .ov = 21, .code = 0x1d29, .word = 0xec24, .immediate=0, .flags=0x00, .name = "WEC24" },
  { .ov = 21, .code = 0x224c, .word = 0xec29, .immediate=0, .flags=0x00, .name = "WEC29" },
  { .ov = 21, .code = 0x224c, .word = 0xec33, .immediate=0, .flags=0x00, .name = "WEC33" },
  { .ov = 21, .code = 0x224c, .word = 0xec3b, .immediate=0, .flags=0x00, .name = "WEC3B" },
  { .ov = 21, .code = 0x224c, .word = 0xec4f, .immediate=0, .flags=0x00, .name = "WEC4F" },
  { .ov = 21, .code = 0x224c, .word = 0xec63, .immediate=0, .flags=0x00, .name = "WEC63" },
  { .ov = 21, .code = 0x224c, .word = 0xec77, .immediate=0, .flags=0x00, .name = "WEC77" },
  { .ov = 21, .code = 0x224c, .word = 0xec89, .immediate=0, .flags=0x00, .name = "WEC89" },
  { .ov = 21, .code = 0x224c, .word = 0xecbd, .immediate=0, .flags=0x00, .name = "WECBD" },
  { .ov = 21, .code = 0x224c, .word = 0xed0f, .immediate=0, .flags=0x00, .name = "WED0F" },
  { .ov = 21, .code = 0x224c, .word = 0xed17, .immediate=0, .flags=0x00, .name = "WED17" },
  { .ov = 21, .code = 0x224c, .word = 0xed4b, .immediate=0, .flags=0x00, .name = "WED4B" },
  { .ov = 21, .code = 0x224c, .word = 0xed5d, .immediate=0, .flags=0x00, .name = "WED5D" },
  { .ov = 21, .code = 0x224c, .word = 0xed6b, .immediate=0, .flags=0x00, .name = "WED6B" },
  { .ov = 21, .code = 0x224c, .word = 0xed75, .immediate=0, .flags=0x00, .name = "WED75" },
  { .ov = 21, .code = 0x224c, .word = 0xeda7, .immediate=0, .flags=0x00, .name = "WEDA7" },
  { .ov = 21, .code = 0x224c, .word = 0xedb9, .immediate=0, .flags=0x00, .name = "WEDB9" },
  { .ov = 21, .code = 0x224c, .word = 0xedd1, .immediate=0, .flags=0x00, .name = "WEDD1" },
  { .ov = 21, .code = 0x4b3b, .word = 0xee00, .immediate=0, .flags=0x80, .name = "RACE-SCR" },
  { .ov = 21, .code = 0x224c, .word = 0xee0e, .immediate=0, .flags=0x00, .name = "WEE0E" },
  { .ov = 21, .code = 0x224c, .word = 0xee4e, .immediate=0, .flags=0x00, .name = "WEE4E" },
  { .ov = 21, .code = 0x224c, .word = 0xee8c, .immediate=0, .flags=0x00, .name = "WEE8C" },
  { .ov = 21, .code = 0x224c, .word = 0xeea1, .immediate=0, .flags=0x80, .name = "?COMSG" },
  { .ov = 21, .code = 0x224c, .word = 0xeec1, .immediate=0, .flags=0x00, .name = "WEEC1" },
  { .ov = 21, .code = 0x224c, .word = 0xeecd, .immediate=0, .flags=0x00, .name = "WEECD" },
  { .ov = 21, .code = 0x224c, .word = 0xeed9, .immediate=0, .flags=0x00, .name = "WEED9" },
  { .ov = 21, .code = 0x224c, .word = 0xeee5, .immediate=0, .flags=0x00, .name = "WEEE5" },
  { .ov = 21, .code = 0x224c, .word = 0xeef1, .immediate=0, .flags=0x00, .name = "WEEF1" },
  { .ov = 21, .code = 0x224c, .word = 0xeefd, .immediate=0, .flags=0x00, .name = "WEEFD" },
  { .ov = 21, .code = 0x224c, .word = 0xef09, .immediate=0, .flags=0x00, .name = "WEF09" },
  { .ov = 21, .code = 0x224c, .word = 0xef1d, .immediate=0, .flags=0x00, .name = "WEF1D" },
  { .ov = 21, .code = 0x224c, .word = 0xef31, .immediate=0, .flags=0x00, .name = "WEF31" },
  { .ov = 21, .code = 0x224c, .word = 0xef45, .immediate=0, .flags=0x00, .name = "WEF45" },
  { .ov = 21, .code = 0x224c, .word = 0xef51, .immediate=0, .flags=0x00, .name = "WEF51" },
  { .ov = 21, .code = 0x224c, .word = 0xef75, .immediate=0, .flags=0x00, .name = "WEF75" },
  { .ov = 21, .code = 0x224c, .word = 0xef81, .immediate=0, .flags=0x00, .name = "WEF81" },
  { .ov = 21, .code = 0x224c, .word = 0xef8d, .immediate=0, .flags=0x00, .name = "WEF8D" },
  { .ov = 21, .code = 0x224c, .word = 0xef99, .immediate=0, .flags=0x00, .name = "WEF99" },
  { .ov = 21, .code = 0x224c, .word = 0xefa5, .immediate=0, .flags=0x00, .name = "WEFA5" },
  { .ov = 21, .code = 0x224c, .word = 0xefb1, .immediate=0, .flags=0x00, .name = "WEFB1" },
  { .ov = 21, .code = 0x4b3b, .word = 0xefc8, .immediate=0, .flags=0x80, .name = "#>SURFAC" },
  { .ov = 21, .code = 0x224c, .word = 0xefe2, .immediate=0, .flags=0x00, .name = "WEFE2" },
  { .ov = 21, .code = 0x224c, .word = 0xf02e, .immediate=0, .flags=0x00, .name = "WF02E" },
  { .ov = 21, .code = 0x224c, .word = 0xf054, .immediate=0, .flags=0x00, .name = "WF054" },
  { .ov = 21, .code = 0x224c, .word = 0xf094, .immediate=0, .flags=0x00, .name = "WF094" },
  { .ov = 21, .code = 0x1d29, .word = 0xf0ac, .immediate=0, .flags=0x00, .name = "WF0AC" },
  { .ov = 21, .code = 0x224c, .word = 0xf0b0, .immediate=0, .flags=0x00, .name = "WF0B0" },
  { .ov = 21, .code = 0x224c, .word = 0xf0c4, .immediate=0, .flags=0x00, .name = "WF0C4" },
  { .ov = 21, .code = 0x224c, .word = 0xf0da, .immediate=0, .flags=0x00, .name = "WF0DA" },
  { .ov = 21, .code = 0x224c, .word = 0xf0ec, .immediate=0, .flags=0x00, .name = "WF0EC" },
  { .ov = 21, .code = 0x224c, .word = 0xf10e, .immediate=0, .flags=0x00, .name = "WF10E" },
  { .ov = 21, .code = 0x224c, .word = 0xf144, .immediate=0, .flags=0x00, .name = "WF144" },
  { .ov = 21, .code = 0x224c, .word = 0xf168, .immediate=0, .flags=0x00, .name = "WF168" },
  { .ov = 21, .code = 0x224c, .word = 0xf174, .immediate=0, .flags=0x00, .name = "WF174" },
  { .ov = 21, .code = 0x224c, .word = 0xf1b8, .immediate=0, .flags=0x00, .name = "WF1B8" },
  { .ov = 21, .code = 0x224c, .word = 0xf1c4, .immediate=0, .flags=0x00, .name = "WF1C4" },
  { .ov = 21, .code = 0x2214, .word = 0xf1e8, .immediate=0, .flags=0x00, .name = "WF1E8" },
  { .ov = 21, .code = 0x224c, .word = 0xf1ec, .immediate=0, .flags=0x00, .name = "WF1EC" },
  { .ov = 21, .code = 0x224c, .word = 0xf23a, .immediate=0, .flags=0x00, .name = "WF23A" },
  { .ov = 21, .code = 0x224c, .word = 0xf2a6, .immediate=0, .flags=0x00, .name = "WF2A6" },
  { .ov = 21, .code = 0x224c, .word = 0xf2c3, .immediate=0, .flags=0x80, .name = "SYSCAN" },
  { .ov = 21, .code = 0x224c, .word = 0xf349, .immediate=0, .flags=0x00, .name = "WF349" },
  { .ov = 21, .code = 0x4b3b, .word = 0xf36d, .immediate=0, .flags=0x80, .name = "RCASE" },
  { .ov = 21, .code = 0x224c, .word = 0xf38b, .immediate=0, .flags=0x00, .name = "WF38B" },
  { .ov = 21, .code = 0x224c, .word = 0xf3a5, .immediate=0, .flags=0x00, .name = "WF3A5" },
  { .ov = 21, .code = 0x224c, .word = 0xf3e1, .immediate=0, .flags=0x00, .name = "WF3E1" },
  { .ov = 21, .code = 0x224c, .word = 0xf3f3, .immediate=0, .flags=0x00, .name = "WF3F3" },
  { .ov = 21, .code = 0x224c, .word = 0xf415, .immediate=0, .flags=0x00, .name = "WF415" },
  { .ov = 21, .code = 0x224c, .word = 0xf425, .immediate=0, .flags=0x00, .name = "WF425" },
  { .ov = 21, .code = 0x224c, .word = 0xf437, .immediate=0, .flags=0x00, .name = "WF437" },
  { .ov = 21, .code = 0x224c, .word = 0xf461, .immediate=0, .flags=0x00, .name = "WF461" },
  { .ov = 21, .code = 0x224c, .word = 0xf46f, .immediate=0, .flags=0x00, .name = "WF46F" },
  { .ov = 21, .code = 0x224c, .word = 0xf479, .immediate=0, .flags=0x00, .name = "WF479" },
  { .ov = 21, .code = 0x224c, .word = 0xf483, .immediate=0, .flags=0x00, .name = "WF483" },
  { .ov = 21, .code = 0x224c, .word = 0xf48d, .immediate=0, .flags=0x00, .name = "WF48D" },
  { .ov = 21, .code = 0x4b3b, .word = 0xf4a8, .immediate=0, .flags=0x80, .name = "CLASS>TY" },
  { .ov = 21, .code = 0x224c, .word = 0xf4e1, .immediate=0, .flags=0x80, .name = "DESCRIBE" },
  { .ov = 22, .code = 0x2214, .word = 0xe6e6, .immediate=0, .flags=0x00, .name = "WE6E6" },
  { .ov = 22, .code = 0x224c, .word = 0xe6ea, .immediate=0, .flags=0x00, .name = "WE6EA" },
  { .ov = 22, .code = 0x2214, .word = 0xe736, .immediate=0, .flags=0x00, .name = "WE736" },
  { .ov = 22, .code = 0x7420, .word = 0xe73a, .immediate=0, .flags=0x00, .name = "WE73A" },
  { .ov = 22, .code = 0x7420, .word = 0xe73f, .immediate=0, .flags=0x00, .name = "WE73F" },
  { .ov = 22, .code = 0x7420, .word = 0xe744, .immediate=0, .flags=0x00, .name = "WE744" },
  { .ov = 22, .code = 0x7420, .word = 0xe749, .immediate=0, .flags=0x00, .name = "WE749" },
  { .ov = 22, .code = 0x7420, .word = 0xe74e, .immediate=0, .flags=0x00, .name = "WE74E" },
  { .ov = 22, .code = 0x7394, .word = 0xe753, .immediate=0, .flags=0x00, .name = "WE753" },
  { .ov = 22, .code = 0x7420, .word = 0xe75b, .immediate=0, .flags=0x00, .name = "WE75B" },
  { .ov = 22, .code = 0x7394, .word = 0xe760, .immediate=0, .flags=0x00, .name = "WE760" },
  { .ov = 22, .code = 0x7420, .word = 0xe768, .immediate=0, .flags=0x00, .name = "WE768" },
  { .ov = 22, .code = 0x224c, .word = 0xe76d, .immediate=0, .flags=0x00, .name = "WE76D" },
  { .ov = 22, .code = 0x224c, .word = 0xe779, .immediate=0, .flags=0x00, .name = "WE779" },
  { .ov = 22, .code = 0x4b3b, .word = 0xe7bc, .immediate=0, .flags=0x80, .name = "DISPOSAL" },
  { .ov = 22, .code = 0x224c, .word = 0xe7e2, .immediate=0, .flags=0x00, .name = "WE7E2" },
  { .ov = 22, .code = 0x224c, .word = 0xe7fc, .immediate=0, .flags=0x00, .name = "WE7FC" },
  { .ov = 22, .code = 0x224c, .word = 0xe80a, .immediate=0, .flags=0x00, .name = "WE80A" },
  { .ov = 22, .code = 0x224c, .word = 0xe824, .immediate=0, .flags=0x00, .name = "WE824" },
  { .ov = 22, .code = 0x224c, .word = 0xe852, .immediate=0, .flags=0x00, .name = "WE852" },
  { .ov = 22, .code = 0x224c, .word = 0xe85c, .immediate=0, .flags=0x00, .name = "WE85C" },
  { .ov = 22, .code = 0x224c, .word = 0xe86e, .immediate=0, .flags=0x00, .name = "WE86E" },
  { .ov = 22, .code = 0x224c, .word = 0xe896, .immediate=0, .flags=0x00, .name = "WE896" },
  { .ov = 22, .code = 0x224c, .word = 0xe8b0, .immediate=0, .flags=0x00, .name = "WE8B0" },
  { .ov = 22, .code = 0x224c, .word = 0xe8c8, .immediate=0, .flags=0x00, .name = "WE8C8" },
  { .ov = 22, .code = 0x224c, .word = 0xe8dc, .immediate=0, .flags=0x00, .name = "WE8DC" },
  { .ov = 22, .code = 0x224c, .word = 0xe8e8, .immediate=0, .flags=0x00, .name = "WE8E8" },
  { .ov = 22, .code = 0x224c, .word = 0xe8f2, .immediate=0, .flags=0x00, .name = "WE8F2" },
  { .ov = 22, .code = 0x224c, .word = 0xe908, .immediate=0, .flags=0x00, .name = "WE908" },
  { .ov = 22, .code = 0x224c, .word = 0xe920, .immediate=0, .flags=0x00, .name = "WE920" },
  { .ov = 22, .code = 0x224c, .word = 0xe936, .immediate=0, .flags=0x00, .name = "WE936" },
  { .ov = 22, .code = 0x224c, .word = 0xe94a, .immediate=0, .flags=0x00, .name = "WE94A" },
  { .ov = 22, .code = 0x224c, .word = 0xe96a, .immediate=0, .flags=0x00, .name = "WE96A" },
  { .ov = 22, .code = 0x224c, .word = 0xe992, .immediate=0, .flags=0x00, .name = "WE992" },
  { .ov = 22, .code = 0x224c, .word = 0xe9b6, .immediate=0, .flags=0x00, .name = "WE9B6" },
  { .ov = 22, .code = 0x224c, .word = 0xe9da, .immediate=0, .flags=0x00, .name = "WE9DA" },
  { .ov = 22, .code = 0x224c, .word = 0xe9fa, .immediate=0, .flags=0x00, .name = "WE9FA" },
  { .ov = 22, .code = 0x224c, .word = 0xea0c, .immediate=0, .flags=0x00, .name = "WEA0C" },
  { .ov = 22, .code = 0x224c, .word = 0xea18, .immediate=0, .flags=0x00, .name = "WEA18" },
  { .ov = 22, .code = 0x224c, .word = 0xea44, .immediate=0, .flags=0x00, .name = "WEA44" },
  { .ov = 22, .code = 0x224c, .word = 0xea6a, .immediate=0, .flags=0x00, .name = "WEA6A" },
  { .ov = 22, .code = 0x224c, .word = 0xea94, .immediate=0, .flags=0x00, .name = "WEA94" },
  { .ov = 22, .code = 0x224c, .word = 0xeb14, .immediate=0, .flags=0x00, .name = "WEB14" },
  { .ov = 22, .code = 0x224c, .word = 0xeb2a, .immediate=0, .flags=0x00, .name = "WEB2A" },
  { .ov = 22, .code = 0x224c, .word = 0xeba4, .immediate=0, .flags=0x00, .name = "WEBA4" },
  { .ov = 22, .code = 0x224c, .word = 0xec03, .immediate=0, .flags=0x00, .name = "WEC03" },
  { .ov = 22, .code = 0x224c, .word = 0xec2d, .immediate=0, .flags=0x00, .name = "WEC2D" },
  { .ov = 22, .code = 0x224c, .word = 0xec49, .immediate=0, .flags=0x00, .name = "WEC49" },
  { .ov = 22, .code = 0x224c, .word = 0xec73, .immediate=0, .flags=0x00, .name = "WEC73" },
  { .ov = 22, .code = 0x224c, .word = 0xec7b, .immediate=0, .flags=0x00, .name = "WEC7B" },
  { .ov = 22, .code = 0x224c, .word = 0xeca1, .immediate=0, .flags=0x00, .name = "WECA1" },
  { .ov = 22, .code = 0x1d29, .word = 0xecbd, .immediate=0, .flags=0x80, .name = "FUNCTIONS" },
  { .ov = 22, .code = 0x224c, .word = 0xecd8, .immediate=0, .flags=0x00, .name = "WECD8" },
  { .ov = 22, .code = 0x224c, .word = 0xecee, .immediate=0, .flags=0x00, .name = "WECEE" },
  { .ov = 22, .code = 0x224c, .word = 0xed3c, .immediate=0, .flags=0x00, .name = "WED3C" },
  { .ov = 22, .code = 0x1d29, .word = 0xed4c, .immediate=0, .flags=0x00, .name = "WED4C" },
  { .ov = 22, .code = 0x224c, .word = 0xed54, .immediate=0, .flags=0x00, .name = "WED54" },
  { .ov = 22, .code = 0x224c, .word = 0xed7c, .immediate=0, .flags=0x00, .name = "WED7C" },
  { .ov = 22, .code = 0x224c, .word = 0xeda8, .immediate=0, .flags=0x00, .name = "WEDA8" },
  { .ov = 22, .code = 0x224c, .word = 0xee28, .immediate=0, .flags=0x80, .name = "HEAVEHO" },
  { .ov = 22, .code = 0x2214, .word = 0xee34, .immediate=0, .flags=0x00, .name = "WEE34" },
  { .ov = 22, .code = 0x224c, .word = 0xee38, .immediate=0, .flags=0x00, .name = "WEE38" },
  { .ov = 22, .code = 0x224c, .word = 0xee71, .immediate=0, .flags=0x80, .name = "TV-SETUP" },
  { .ov = 22, .code = 0x224c, .word = 0xee81, .immediate=0, .flags=0x00, .name = "WEE81" },
  { .ov = 22, .code = 0x224c, .word = 0xee8f, .immediate=0, .flags=0x00, .name = "WEE8F" },
  { .ov = 22, .code = 0x224c, .word = 0xeea1, .immediate=0, .flags=0x00, .name = "WEEA1" },
  { .ov = 22, .code = 0x224c, .word = 0xeec9, .immediate=0, .flags=0x00, .name = "WEEC9" },
  { .ov = 22, .code = 0x224c, .word = 0xeeef, .immediate=0, .flags=0x00, .name = "WEEEF" },
  { .ov = 22, .code = 0x224c, .word = 0xef49, .immediate=0, .flags=0x00, .name = "WEF49" },
  { .ov = 22, .code = 0x224c, .word = 0xef97, .immediate=0, .flags=0x00, .name = "WEF97" },
  { .ov = 22, .code = 0x224c, .word = 0xefb5, .immediate=0, .flags=0x00, .name = "WEFB5" },
  { .ov = 22, .code = 0x224c, .word = 0xf00f, .immediate=0, .flags=0x00, .name = "WF00F" },
  { .ov = 22, .code = 0x224c, .word = 0xf06b, .immediate=0, .flags=0x00, .name = "WF06B" },
  { .ov = 22, .code = 0x224c, .word = 0xf07f, .immediate=0, .flags=0x00, .name = "WF07F" },
  { .ov = 22, .code = 0x224c, .word = 0xf113, .immediate=0, .flags=0x00, .name = "WF113" },
  { .ov = 22, .code = 0x224c, .word = 0xf151, .immediate=0, .flags=0x00, .name = "WF151" },
  { .ov = 22, .code = 0x224c, .word = 0xf163, .immediate=0, .flags=0x00, .name = "WF163" },
  { .ov = 22, .code = 0x1d29, .word = 0xf191, .immediate=0, .flags=0x00, .name = "WF191" },
  { .ov = 22, .code = 0x224c, .word = 0xf199, .immediate=0, .flags=0x00, .name = "WF199" },
  { .ov = 22, .code = 0x224c, .word = 0xf1e5, .immediate=0, .flags=0x00, .name = "WF1E5" },
  { .ov = 22, .code = 0x224c, .word = 0xf21b, .immediate=0, .flags=0x00, .name = "WF21B" },
  { .ov = 22, .code = 0x224c, .word = 0xf233, .immediate=0, .flags=0x00, .name = "WF233" },
  { .ov = 22, .code = 0x224c, .word = 0xf299, .immediate=0, .flags=0x80, .name = "WALK&TALK" },
  { .ov = 22, .code = 0x224c, .word = 0xf2bd, .immediate=0, .flags=0x00, .name = "WF2BD" },
  { .ov = 22, .code = 0x224c, .word = 0xf2f8, .immediate=0, .flags=0x00, .name = "WF2F8" },
  { .ov = 22, .code = 0x224c, .word = 0xf328, .immediate=0, .flags=0x00, .name = "WF328" },
  { .ov = 22, .code = 0x224c, .word = 0xf33a, .immediate=0, .flags=0x00, .name = "WF33A" },
  { .ov = 22, .code = 0x224c, .word = 0xf354, .immediate=0, .flags=0x80, .name = "TV-DISP" },
  { .ov = 22, .code = 0x224c, .word = 0xf3d3, .immediate=0, .flags=0x80, .name = "TV-CLEANU" },
  { .ov = 22, .code = 0x1d29, .word = 0xf3d9, .immediate=0, .flags=0x00, .name = "WF3D9" },
  { .ov = 22, .code = 0x224c, .word = 0xf3dd, .immediate=0, .flags=0x00, .name = "WF3DD" },
  { .ov = 22, .code = 0x224c, .word = 0xf3f5, .immediate=0, .flags=0x00, .name = "WF3F5" },
  { .ov = 22, .code = 0x224c, .word = 0xf40f, .immediate=0, .flags=0x00, .name = "WF40F" },
  { .ov = 22, .code = 0x224c, .word = 0xf423, .immediate=0, .flags=0x00, .name = "WF423" },
  { .ov = 22, .code = 0x1d29, .word = 0xf46e, .immediate=0, .flags=0x00, .name = "WF46E" },
  { .ov = 22, .code = 0x224c, .word = 0xf472, .immediate=0, .flags=0x00, .name = "WF472" },
  { .ov = 22, .code = 0x224c, .word = 0xf500, .immediate=0, .flags=0x80, .name = "DO.WEAPON" },
  { .ov = 23, .code = 0x224c, .word = 0xd7f6, .immediate=0, .flags=0x00, .name = "WD7F6" },
  { .ov = 23, .code = 0x224c, .word = 0xd7fe, .immediate=0, .flags=0x00, .name = "WD7FE" },
  { .ov = 23, .code = 0x224c, .word = 0xd806, .immediate=0, .flags=0x00, .name = "WD806" },
  { .ov = 23, .code = 0x224c, .word = 0xd80e, .immediate=0, .flags=0x00, .name = "WD80E" },
  { .ov = 23, .code = 0x7420, .word = 0xd820, .immediate=0, .flags=0x00, .name = "WD820" },
  { .ov = 23, .code = 0x7420, .word = 0xd825, .immediate=0, .flags=0x00, .name = "WD825" },
  { .ov = 23, .code = 0x7420, .word = 0xd82a, .immediate=0, .flags=0x00, .name = "WD82A" },
  { .ov = 23, .code = 0x7420, .word = 0xd82f, .immediate=0, .flags=0x00, .name = "WD82F" },
  { .ov = 23, .code = 0x7420, .word = 0xd834, .immediate=0, .flags=0x00, .name = "WD834" },
  { .ov = 23, .code = 0x7420, .word = 0xd839, .immediate=0, .flags=0x00, .name = "WD839" },
  { .ov = 23, .code = 0x7420, .word = 0xd83e, .immediate=0, .flags=0x00, .name = "WD83E" },
  { .ov = 23, .code = 0x7420, .word = 0xd843, .immediate=0, .flags=0x00, .name = "WD843" },
  { .ov = 23, .code = 0x7420, .word = 0xd848, .immediate=0, .flags=0x00, .name = "WD848" },
  { .ov = 23, .code = 0x7420, .word = 0xd84d, .immediate=0, .flags=0x00, .name = "WD84D" },
  { .ov = 23, .code = 0x7420, .word = 0xd852, .immediate=0, .flags=0x00, .name = "WD852" },
  { .ov = 23, .code = 0x7420, .word = 0xd857, .immediate=0, .flags=0x00, .name = "WD857" },
  { .ov = 23, .code = 0x7420, .word = 0xd85c, .immediate=0, .flags=0x00, .name = "WD85C" },
  { .ov = 23, .code = 0x7420, .word = 0xd861, .immediate=0, .flags=0x00, .name = "WD861" },
  { .ov = 23, .code = 0x7420, .word = 0xd866, .immediate=0, .flags=0x00, .name = "WD866" },
  { .ov = 23, .code = 0x7420, .word = 0xd86b, .immediate=0, .flags=0x00, .name = "WD86B" },
  { .ov = 23, .code = 0x7420, .word = 0xd870, .immediate=0, .flags=0x00, .name = "WD870" },
  { .ov = 23, .code = 0x7420, .word = 0xd875, .immediate=0, .flags=0x00, .name = "WD875" },
  { .ov = 23, .code = 0x7420, .word = 0xd87a, .immediate=0, .flags=0x00, .name = "WD87A" },
  { .ov = 23, .code = 0x7420, .word = 0xd87f, .immediate=0, .flags=0x00, .name = "WD87F" },
  { .ov = 23, .code = 0x7420, .word = 0xd884, .immediate=0, .flags=0x00, .name = "WD884" },
  { .ov = 23, .code = 0x7420, .word = 0xd889, .immediate=0, .flags=0x00, .name = "WD889" },
  { .ov = 23, .code = 0x7420, .word = 0xd88e, .immediate=0, .flags=0x00, .name = "WD88E" },
  { .ov = 23, .code = 0x7420, .word = 0xd893, .immediate=0, .flags=0x00, .name = "WD893" },
  { .ov = 23, .code = 0x7420, .word = 0xd898, .immediate=0, .flags=0x00, .name = "WD898" },
  { .ov = 23, .code = 0x7420, .word = 0xd89d, .immediate=0, .flags=0x00, .name = "WD89D" },
  { .ov = 23, .code = 0x7420, .word = 0xd8a2, .immediate=0, .flags=0x00, .name = "WD8A2" },
  { .ov = 23, .code = 0x7420, .word = 0xd8a7, .immediate=0, .flags=0x00, .name = "WD8A7" },
  { .ov = 23, .code = 0x7420, .word = 0xd8ac, .immediate=0, .flags=0x00, .name = "WD8AC" },
  { .ov = 23, .code = 0x7420, .word = 0xd8b1, .immediate=0, .flags=0x00, .name = "WD8B1" },
  { .ov = 23, .code = 0x7420, .word = 0xd8b6, .immediate=0, .flags=0x00, .name = "WD8B6" },
  { .ov = 23, .code = 0x7420, .word = 0xd8bb, .immediate=0, .flags=0x00, .name = "WD8BB" },
  { .ov = 23, .code = 0x7394, .word = 0xd8c0, .immediate=0, .flags=0x00, .name = "WD8C0" },
  { .ov = 23, .code = 0x7394, .word = 0xd8c8, .immediate=0, .flags=0x00, .name = "WD8C8" },
  { .ov = 23, .code = 0x7420, .word = 0xd8d0, .immediate=0, .flags=0x00, .name = "WD8D0" },
  { .ov = 23, .code = 0x7394, .word = 0xd8d5, .immediate=0, .flags=0x00, .name = "WD8D5" },
  { .ov = 23, .code = 0x1d29, .word = 0xd8dd, .immediate=0, .flags=0x00, .name = "WD8DD" },
  { .ov = 23, .code = 0x1d29, .word = 0xd8e1, .immediate=0, .flags=0x00, .name = "WD8E1" },
  { .ov = 23, .code = 0x2214, .word = 0xd8e7, .immediate=0, .flags=0x00, .name = "WD8E7" },
  { .ov = 23, .code = 0x1d29, .word = 0xd8eb, .immediate=0, .flags=0x00, .name = "WD8EB" },
  { .ov = 23, .code = 0x1d29, .word = 0xd8ef, .immediate=0, .flags=0x00, .name = "WD8EF" },
  { .ov = 23, .code = 0x1d29, .word = 0xd8f3, .immediate=0, .flags=0x00, .name = "WD8F3" },
  { .ov = 23, .code = 0x1d29, .word = 0xd8f7, .immediate=0, .flags=0x00, .name = "WD8F7" },
  { .ov = 23, .code = 0x1d29, .word = 0xd8fb, .immediate=0, .flags=0x00, .name = "WD8FB" },
  { .ov = 23, .code = 0x1d29, .word = 0xd8ff, .immediate=0, .flags=0x00, .name = "WD8FF" },
  { .ov = 23, .code = 0x1d29, .word = 0xd903, .immediate=0, .flags=0x00, .name = "WD903" },
  { .ov = 23, .code = 0x1d29, .word = 0xd907, .immediate=0, .flags=0x00, .name = "WD907" },
  { .ov = 23, .code = 0x1d29, .word = 0xd90b, .immediate=0, .flags=0x00, .name = "WD90B" },
  { .ov = 23, .code = 0x2214, .word = 0xd90f, .immediate=0, .flags=0x00, .name = "WD90F" },
  { .ov = 23, .code = 0x2214, .word = 0xd913, .immediate=0, .flags=0x00, .name = "WD913" },
  { .ov = 23, .code = 0x1d29, .word = 0xd917, .immediate=0, .flags=0x00, .name = "WD917" },
  { .ov = 23, .code = 0x1d29, .word = 0xd91b, .immediate=0, .flags=0x00, .name = "WD91B" },
  { .ov = 23, .code = 0x1d29, .word = 0xd91f, .immediate=0, .flags=0x00, .name = "WD91F" },
  { .ov = 23, .code = 0x1d29, .word = 0xd923, .immediate=0, .flags=0x00, .name = "WD923" },
  { .ov = 23, .code = 0x1d29, .word = 0xd927, .immediate=0, .flags=0x00, .name = "WD927" },
  { .ov = 23, .code = 0x2214, .word = 0xd92d, .immediate=0, .flags=0x00, .name = "WD92D" },
  { .ov = 23, .code = 0x1d29, .word = 0xd931, .immediate=0, .flags=0x00, .name = "WD931" },
  { .ov = 23, .code = 0x2214, .word = 0xd935, .immediate=0, .flags=0x00, .name = "WD935" },
  { .ov = 23, .code = 0x224c, .word = 0xd939, .immediate=0, .flags=0x00, .name = "WD939" },
  { .ov = 23, .code = 0x224c, .word = 0xd945, .immediate=0, .flags=0x00, .name = "WD945" },
  { .ov = 23, .code = 0x224c, .word = 0xd955, .immediate=0, .flags=0x00, .name = "WD955" },
  { .ov = 23, .code = 0x224c, .word = 0xd963, .immediate=0, .flags=0x00, .name = "WD963" },
  { .ov = 23, .code = 0x224c, .word = 0xd9bb, .immediate=0, .flags=0x00, .name = "WD9BB" },
  { .ov = 23, .code = 0x4b3b, .word = 0xd9d3, .immediate=0, .flags=0x80, .name = "S>EDL" },
  { .ov = 23, .code = 0x224c, .word = 0xd9e9, .immediate=0, .flags=0x00, .name = "WD9E9" },
  { .ov = 23, .code = 0x2214, .word = 0xd9f7, .immediate=0, .flags=0x00, .name = "WD9F7" },
  { .ov = 23, .code = 0x1d29, .word = 0xd9fb, .immediate=0, .flags=0x00, .name = "WD9FB" },
  { .ov = 23, .code = 0x2214, .word = 0xd9ff, .immediate=0, .flags=0x00, .name = "WD9FF" },
  { .ov = 23, .code = 0x2214, .word = 0xda03, .immediate=0, .flags=0x00, .name = "WDA03" },
  { .ov = 23, .code = 0x1d29, .word = 0xda07, .immediate=0, .flags=0x00, .name = "WDA07" },
  { .ov = 23, .code = 0x1d29, .word = 0xda19, .immediate=0, .flags=0x00, .name = "WDA19" },
  { .ov = 23, .code = 0x1d29, .word = 0xda2b, .immediate=0, .flags=0x00, .name = "WDA2B" },
  { .ov = 23, .code = 0x1d29, .word = 0xda3d, .immediate=0, .flags=0x00, .name = "WDA3D" },
  { .ov = 23, .code = 0x1d29, .word = 0xda4f, .immediate=0, .flags=0x00, .name = "WDA4F" },
  { .ov = 23, .code = 0x1d29, .word = 0xda55, .immediate=0, .flags=0x00, .name = "WDA55" },
  { .ov = 23, .code = 0x1d29, .word = 0xda59, .immediate=0, .flags=0x00, .name = "WDA59" },
  { .ov = 23, .code = 0x2214, .word = 0xda5d, .immediate=0, .flags=0x00, .name = "WDA5D" },
  { .ov = 23, .code = 0x1d29, .word = 0xda61, .immediate=0, .flags=0x00, .name = "WDA61" },
  { .ov = 23, .code = 0x1d29, .word = 0xda65, .immediate=0, .flags=0x00, .name = "WDA65" },
  { .ov = 23, .code = 0x2214, .word = 0xda69, .immediate=0, .flags=0x00, .name = "WDA69" },
  { .ov = 23, .code = 0x2214, .word = 0xda6d, .immediate=0, .flags=0x00, .name = "WDA6D" },
  { .ov = 23, .code = 0x2214, .word = 0xda71, .immediate=0, .flags=0x00, .name = "WDA71" },
  { .ov = 23, .code = 0x2214, .word = 0xda75, .immediate=0, .flags=0x00, .name = "WDA75" },
  { .ov = 23, .code = 0x2214, .word = 0xda79, .immediate=0, .flags=0x00, .name = "WDA79" },
  { .ov = 23, .code = 0x2214, .word = 0xda7d, .immediate=0, .flags=0x00, .name = "WDA7D" },
  { .ov = 23, .code = 0x7420, .word = 0xda81, .immediate=0, .flags=0x00, .name = "WDA81" },
  { .ov = 23, .code = 0x224c, .word = 0xda86, .immediate=0, .flags=0x00, .name = "WDA86" },
  { .ov = 23, .code = 0x224c, .word = 0xda8e, .immediate=0, .flags=0x00, .name = "WDA8E" },
  { .ov = 23, .code = 0x224c, .word = 0xda98, .immediate=0, .flags=0x00, .name = "WDA98" },
  { .ov = 23, .code = 0x224c, .word = 0xdab8, .immediate=0, .flags=0x80, .name = "ORIGINATOR>" },
  { .ov = 23, .code = 0x224c, .word = 0xdade, .immediate=0, .flags=0x80, .name = "A>ORIGINATO" },
  { .ov = 23, .code = 0x224c, .word = 0xdb00, .immediate=0, .flags=0x00, .name = "WDB00" },
  { .ov = 23, .code = 0x224c, .word = 0xdb1a, .immediate=0, .flags=0x00, .name = "WDB1A" },
  { .ov = 23, .code = 0x224c, .word = 0xdb22, .immediate=0, .flags=0x00, .name = "WDB22" },
  { .ov = 23, .code = 0x224c, .word = 0xdb30, .immediate=0, .flags=0x00, .name = "WDB30" },
  { .ov = 23, .code = 0x224c, .word = 0xdb3e, .immediate=0, .flags=0x00, .name = "WDB3E" },
  { .ov = 23, .code = 0x4b3b, .word = 0xdb51, .immediate=0, .flags=0x80, .name = "P>AFIELD" },
  { .ov = 23, .code = 0x224c, .word = 0xdb5f, .immediate=0, .flags=0x00, .name = "WDB5F" },
  { .ov = 23, .code = 0x224c, .word = 0xdb71, .immediate=0, .flags=0x00, .name = "WDB71" },
  { .ov = 23, .code = 0x224c, .word = 0xdb81, .immediate=0, .flags=0x00, .name = "WDB81" },
  { .ov = 23, .code = 0x224c, .word = 0xdb95, .immediate=0, .flags=0x00, .name = "WDB95" },
  { .ov = 23, .code = 0x3b74, .word = 0xdba1, .immediate=0, .flags=0x00, .name = "WDBA1" },
  { .ov = 23, .code = 0x3b74, .word = 0xdba7, .immediate=0, .flags=0x00, .name = "WDBA7" },
  { .ov = 23, .code = 0x3b74, .word = 0xdbad, .immediate=0, .flags=0x00, .name = "WDBAD" },
  { .ov = 23, .code = 0x3b74, .word = 0xdbb3, .immediate=0, .flags=0x00, .name = "WDBB3" },
  { .ov = 23, .code = 0x4b3b, .word = 0xdbc0, .immediate=0, .flags=0x80, .name = "#PHR" },
  { .ov = 23, .code = 0x224c, .word = 0xdbd6, .immediate=0, .flags=0x00, .name = "WDBD6" },
  { .ov = 23, .code = 0x4b3b, .word = 0xdc07, .immediate=0, .flags=0x80, .name = "N>POST" },
  { .ov = 23, .code = 0x224c, .word = 0xdc1d, .immediate=0, .flags=0x00, .name = "WDC1D" },
  { .ov = 23, .code = 0x224c, .word = 0xdc83, .immediate=0, .flags=0x00, .name = "WDC83" },
  { .ov = 23, .code = 0x224c, .word = 0xdcdf, .immediate=0, .flags=0x80, .name = "EDL>P" },
  { .ov = 23, .code = 0x224c, .word = 0xdcf5, .immediate=0, .flags=0x80, .name = "+!EDL" },
  { .ov = 23, .code = 0x224c, .word = 0xdd15, .immediate=0, .flags=0x00, .name = "WDD15" },
  { .ov = 23, .code = 0x224c, .word = 0xdd35, .immediate=0, .flags=0x00, .name = "WDD35" },
  { .ov = 23, .code = 0x224c, .word = 0xdd47, .immediate=0, .flags=0x00, .name = "WDD47" },
  { .ov = 23, .code = 0x224c, .word = 0xdd59, .immediate=0, .flags=0x00, .name = "WDD59" },
  { .ov = 23, .code = 0x224c, .word = 0xddab, .immediate=0, .flags=0x00, .name = "WDDAB" },
  { .ov = 23, .code = 0x224c, .word = 0xddc5, .immediate=0, .flags=0x00, .name = "WDDC5" },
  { .ov = 23, .code = 0x224c, .word = 0xde07, .immediate=0, .flags=0x00, .name = "WDE07" },
  { .ov = 23, .code = 0x224c, .word = 0xde43, .immediate=0, .flags=0x00, .name = "WDE43" },
  { .ov = 23, .code = 0x224c, .word = 0xde55, .immediate=0, .flags=0x00, .name = "WDE55" },
  { .ov = 23, .code = 0x224c, .word = 0xde61, .immediate=0, .flags=0x00, .name = "WDE61" },
  { .ov = 23, .code = 0x224c, .word = 0xde7c, .immediate=0, .flags=0x80, .name = ">HAIL$" },
  { .ov = 23, .code = 0x224c, .word = 0xde8e, .immediate=0, .flags=0x00, .name = "WDE8E" },
  { .ov = 23, .code = 0x224c, .word = 0xde9e, .immediate=0, .flags=0x00, .name = "WDE9E" },
  { .ov = 23, .code = 0x224c, .word = 0xdebe, .immediate=0, .flags=0x00, .name = "WDEBE" },
  { .ov = 23, .code = 0x1d29, .word = 0xdedc, .immediate=0, .flags=0x00, .name = "WDEDC" },
  { .ov = 23, .code = 0x224c, .word = 0xdf4e, .immediate=0, .flags=0x00, .name = "WDF4E" },
  { .ov = 23, .code = 0x224c, .word = 0xdf92, .immediate=0, .flags=0x00, .name = "WDF92" },
  { .ov = 23, .code = 0x224c, .word = 0xdfa7, .immediate=0, .flags=0x80, .name = "1SYL" },
  { .ov = 23, .code = 0x224c, .word = 0xdfbd, .immediate=0, .flags=0x00, .name = "WDFBD" },
  { .ov = 23, .code = 0x224c, .word = 0xe005, .immediate=0, .flags=0x00, .name = "WE005" },
  { .ov = 23, .code = 0x224c, .word = 0xe021, .immediate=0, .flags=0x00, .name = "WE021" },
  { .ov = 23, .code = 0x224c, .word = 0xe043, .immediate=0, .flags=0x00, .name = "WE043" },
  { .ov = 23, .code = 0x224c, .word = 0xe06b, .immediate=0, .flags=0x00, .name = "WE06B" },
  { .ov = 23, .code = 0x224c, .word = 0xe081, .immediate=0, .flags=0x00, .name = "WE081" },
  { .ov = 23, .code = 0x224c, .word = 0xe0e1, .immediate=0, .flags=0x00, .name = "WE0E1" },
  { .ov = 23, .code = 0x4b3b, .word = 0xe0f9, .immediate=0, .flags=0x80, .name = "ACASE" },
  { .ov = 23, .code = 0x224c, .word = 0xe107, .immediate=0, .flags=0x00, .name = "WE107" },
  { .ov = 23, .code = 0x224c, .word = 0xe13d, .immediate=0, .flags=0x00, .name = "WE13D" },
  { .ov = 23, .code = 0x224c, .word = 0xe16d, .immediate=0, .flags=0x00, .name = "WE16D" },
  { .ov = 23, .code = 0x224c, .word = 0xe1c1, .immediate=0, .flags=0x00, .name = "WE1C1" },
  { .ov = 23, .code = 0x224c, .word = 0xe1cd, .immediate=0, .flags=0x00, .name = "WE1CD" },
  { .ov = 23, .code = 0x224c, .word = 0xe1e8, .immediate=0, .flags=0x80, .name = "CTSCROLL" },
  { .ov = 23, .code = 0x224c, .word = 0xe20e, .immediate=0, .flags=0x00, .name = "WE20E" },
  { .ov = 23, .code = 0x224c, .word = 0xe23a, .immediate=0, .flags=0x00, .name = "WE23A" },
  { .ov = 23, .code = 0x1d29, .word = 0xe280, .immediate=0, .flags=0x00, .name = "WE280" },
  { .ov = 23, .code = 0x224c, .word = 0xe29b, .immediate=0, .flags=0x00, .name = "WE29B" },
  { .ov = 23, .code = 0x224c, .word = 0xe2a3, .immediate=0, .flags=0x00, .name = "WE2A3" },
  { .ov = 23, .code = 0x224c, .word = 0xe2ab, .immediate=0, .flags=0x00, .name = "WE2AB" },
  { .ov = 23, .code = 0x224c, .word = 0xe2b3, .immediate=0, .flags=0x00, .name = "WE2B3" },
  { .ov = 23, .code = 0x224c, .word = 0xe2c3, .immediate=0, .flags=0x00, .name = "WE2C3" },
  { .ov = 23, .code = 0x224c, .word = 0xe2e3, .immediate=0, .flags=0x00, .name = "WE2E3" },
  { .ov = 23, .code = 0x224c, .word = 0xe305, .immediate=0, .flags=0x00, .name = "WE305" },
  { .ov = 23, .code = 0x224c, .word = 0xe311, .immediate=0, .flags=0x00, .name = "WE311" },
  { .ov = 23, .code = 0x224c, .word = 0xe328, .immediate=0, .flags=0x00, .name = "WE328" },
  { .ov = 23, .code = 0x224c, .word = 0xe33b, .immediate=0, .flags=0x00, .name = "WE33B" },
  { .ov = 23, .code = 0x224c, .word = 0xe347, .immediate=0, .flags=0x00, .name = "WE347" },
  { .ov = 23, .code = 0x224c, .word = 0xe34f, .immediate=0, .flags=0x00, .name = "WE34F" },
  { .ov = 23, .code = 0x224c, .word = 0xe36e, .immediate=0, .flags=0x00, .name = "WE36E" },
  { .ov = 23, .code = 0x224c, .word = 0xe37a, .immediate=0, .flags=0x00, .name = "WE37A" },
  { .ov = 23, .code = 0x224c, .word = 0xe382, .immediate=0, .flags=0x00, .name = "WE382" },
  { .ov = 23, .code = 0x4b3b, .word = 0xe391, .immediate=0, .flags=0x80, .name = "?S" },
  { .ov = 23, .code = 0x224c, .word = 0xe3a7, .immediate=0, .flags=0x00, .name = "WE3A7" },
  { .ov = 23, .code = 0x4b3b, .word = 0xe3b7, .immediate=0, .flags=0x80, .name = "SPL" },
  { .ov = 23, .code = 0x224c, .word = 0xe3e1, .immediate=0, .flags=0x00, .name = "WE3E1" },
  { .ov = 23, .code = 0x224c, .word = 0xe40b, .immediate=0, .flags=0x80, .name = "(PHRASE>CT)" },
  { .ov = 23, .code = 0x224c, .word = 0xe449, .immediate=0, .flags=0x00, .name = "WE449" },
  { .ov = 23, .code = 0x224c, .word = 0xe45b, .immediate=0, .flags=0x00, .name = "WE45B" },
  { .ov = 23, .code = 0x224c, .word = 0xe47b, .immediate=0, .flags=0x00, .name = "WE47B" },
  { .ov = 23, .code = 0x224c, .word = 0xe49f, .immediate=0, .flags=0x00, .name = "WE49F" },
  { .ov = 23, .code = 0x224c, .word = 0xe4c9, .immediate=0, .flags=0x00, .name = "WE4C9" },
  { .ov = 23, .code = 0x1d29, .word = 0xe563, .immediate=0, .flags=0x00, .name = "WE563" },
  { .ov = 23, .code = 0x224c, .word = 0xe567, .immediate=0, .flags=0x00, .name = "WE567" },
  { .ov = 23, .code = 0x1d29, .word = 0xe5c1, .immediate=0, .flags=0x00, .name = "WE5C1" },
  { .ov = 23, .code = 0x224c, .word = 0xe5dc, .immediate=0, .flags=0x00, .name = "WE5DC" },
  { .ov = 23, .code = 0x224c, .word = 0xe5ea, .immediate=0, .flags=0x00, .name = "WE5EA" },
  { .ov = 23, .code = 0x224c, .word = 0xe5fe, .immediate=0, .flags=0x00, .name = "WE5FE" },
  { .ov = 23, .code = 0x224c, .word = 0xe60c, .immediate=0, .flags=0x00, .name = "WE60C" },
  { .ov = 23, .code = 0x224c, .word = 0xe614, .immediate=0, .flags=0x00, .name = "WE614" },
  { .ov = 23, .code = 0x224c, .word = 0xe61e, .immediate=0, .flags=0x00, .name = "WE61E" },
  { .ov = 23, .code = 0x224c, .word = 0xe628, .immediate=0, .flags=0x00, .name = "WE628" },
  { .ov = 23, .code = 0x224c, .word = 0xe632, .immediate=0, .flags=0x00, .name = "WE632" },
  { .ov = 23, .code = 0x224c, .word = 0xe64c, .immediate=0, .flags=0x00, .name = "WE64C" },
  { .ov = 23, .code = 0x224c, .word = 0xe65c, .immediate=0, .flags=0x00, .name = "WE65C" },
  { .ov = 23, .code = 0x224c, .word = 0xe664, .immediate=0, .flags=0x00, .name = "WE664" },
  { .ov = 23, .code = 0x224c, .word = 0xe66c, .immediate=0, .flags=0x00, .name = "WE66C" },
  { .ov = 23, .code = 0x224c, .word = 0xe67a, .immediate=0, .flags=0x00, .name = "WE67A" },
  { .ov = 23, .code = 0x224c, .word = 0xe688, .immediate=0, .flags=0x00, .name = "WE688" },
  { .ov = 23, .code = 0x224c, .word = 0xe6a0, .immediate=0, .flags=0x00, .name = "WE6A0" },
  { .ov = 23, .code = 0x224c, .word = 0xe6ae, .immediate=0, .flags=0x00, .name = "WE6AE" },
  { .ov = 23, .code = 0x224c, .word = 0xe6bc, .immediate=0, .flags=0x00, .name = "WE6BC" },
  { .ov = 23, .code = 0x224c, .word = 0xe6d8, .immediate=0, .flags=0x00, .name = "WE6D8" },
  { .ov = 23, .code = 0x224c, .word = 0xe6e6, .immediate=0, .flags=0x00, .name = "WE6E6" },
  { .ov = 23, .code = 0x224c, .word = 0xe6fa, .immediate=0, .flags=0x00, .name = "WE6FA" },
  { .ov = 23, .code = 0x224c, .word = 0xe704, .immediate=0, .flags=0x00, .name = "WE704" },
  { .ov = 23, .code = 0x224c, .word = 0xe70e, .immediate=0, .flags=0x00, .name = "WE70E" },
  { .ov = 23, .code = 0x224c, .word = 0xe718, .immediate=0, .flags=0x00, .name = "WE718" },
  { .ov = 23, .code = 0x224c, .word = 0xe722, .immediate=0, .flags=0x00, .name = "WE722" },
  { .ov = 23, .code = 0x224c, .word = 0xe72c, .immediate=0, .flags=0x00, .name = "WE72C" },
  { .ov = 23, .code = 0x224c, .word = 0xe736, .immediate=0, .flags=0x00, .name = "WE736" },
  { .ov = 23, .code = 0x224c, .word = 0xe740, .immediate=0, .flags=0x00, .name = "WE740" },
  { .ov = 23, .code = 0x224c, .word = 0xe748, .immediate=0, .flags=0x00, .name = "WE748" },
  { .ov = 23, .code = 0x224c, .word = 0xe752, .immediate=0, .flags=0x00, .name = "WE752" },
  { .ov = 23, .code = 0x224c, .word = 0xe75e, .immediate=0, .flags=0x00, .name = "WE75E" },
  { .ov = 23, .code = 0x224c, .word = 0xe76e, .immediate=0, .flags=0x00, .name = "WE76E" },
  { .ov = 23, .code = 0x224c, .word = 0xe77f, .immediate=0, .flags=0x00, .name = "WE77F" },
  { .ov = 23, .code = 0x224c, .word = 0xe797, .immediate=0, .flags=0x00, .name = "WE797" },
  { .ov = 23, .code = 0x224c, .word = 0xe7af, .immediate=0, .flags=0x00, .name = "WE7AF" },
  { .ov = 23, .code = 0x224c, .word = 0xe7c7, .immediate=0, .flags=0x00, .name = "WE7C7" },
  { .ov = 23, .code = 0x224c, .word = 0xe7df, .immediate=0, .flags=0x00, .name = "WE7DF" },
  { .ov = 23, .code = 0x224c, .word = 0xe7f5, .immediate=0, .flags=0x00, .name = "WE7F5" },
  { .ov = 23, .code = 0x224c, .word = 0xe811, .immediate=0, .flags=0x00, .name = "WE811" },
  { .ov = 23, .code = 0x224c, .word = 0xe827, .immediate=0, .flags=0x00, .name = "WE827" },
  { .ov = 23, .code = 0x224c, .word = 0xe857, .immediate=0, .flags=0x00, .name = "WE857" },
  { .ov = 23, .code = 0x224c, .word = 0xe86b, .immediate=0, .flags=0x00, .name = "WE86B" },
  { .ov = 23, .code = 0x224c, .word = 0xe881, .immediate=0, .flags=0x00, .name = "WE881" },
  { .ov = 23, .code = 0x224c, .word = 0xe893, .immediate=0, .flags=0x00, .name = "WE893" },
  { .ov = 23, .code = 0x224c, .word = 0xe8c7, .immediate=0, .flags=0x00, .name = "WE8C7" },
  { .ov = 23, .code = 0x224c, .word = 0xe8d9, .immediate=0, .flags=0x00, .name = "WE8D9" },
  { .ov = 23, .code = 0x224c, .word = 0xe8e5, .immediate=0, .flags=0x00, .name = "WE8E5" },
  { .ov = 23, .code = 0x1d29, .word = 0xe8fd, .immediate=0, .flags=0x80, .name = "(?RACE)" },
  { .ov = 23, .code = 0x224c, .word = 0xe918, .immediate=0, .flags=0x00, .name = "WE918" },
  { .ov = 23, .code = 0x224c, .word = 0xe926, .immediate=0, .flags=0x00, .name = "WE926" },
  { .ov = 23, .code = 0x224c, .word = 0xe92e, .immediate=0, .flags=0x00, .name = "WE92E" },
  { .ov = 23, .code = 0x224c, .word = 0xe936, .immediate=0, .flags=0x00, .name = "WE936" },
  { .ov = 23, .code = 0x224c, .word = 0xe93e, .immediate=0, .flags=0x00, .name = "WE93E" },
  { .ov = 23, .code = 0x224c, .word = 0xe946, .immediate=0, .flags=0x00, .name = "WE946" },
  { .ov = 23, .code = 0x224c, .word = 0xe950, .immediate=0, .flags=0x00, .name = "WE950" },
  { .ov = 23, .code = 0x224c, .word = 0xe95a, .immediate=0, .flags=0x00, .name = "WE95A" },
  { .ov = 23, .code = 0x224c, .word = 0xe96a, .immediate=0, .flags=0x00, .name = "WE96A" },
  { .ov = 23, .code = 0x224c, .word = 0xe978, .immediate=0, .flags=0x00, .name = "WE978" },
  { .ov = 23, .code = 0x224c, .word = 0xe99a, .immediate=0, .flags=0x00, .name = "WE99A" },
  { .ov = 23, .code = 0x224c, .word = 0xe9b0, .immediate=0, .flags=0x00, .name = "WE9B0" },
  { .ov = 23, .code = 0x224c, .word = 0xe9c8, .immediate=0, .flags=0x00, .name = "WE9C8" },
  { .ov = 23, .code = 0x224c, .word = 0xea14, .immediate=0, .flags=0x00, .name = "WEA14" },
  { .ov = 23, .code = 0x224c, .word = 0xea20, .immediate=0, .flags=0x00, .name = "WEA20" },
  { .ov = 23, .code = 0x224c, .word = 0xea2c, .immediate=0, .flags=0x00, .name = "WEA2C" },
  { .ov = 23, .code = 0x224c, .word = 0xea38, .immediate=0, .flags=0x00, .name = "WEA38" },
  { .ov = 23, .code = 0x224c, .word = 0xea44, .immediate=0, .flags=0x00, .name = "WEA44" },
  { .ov = 23, .code = 0x224c, .word = 0xea5e, .immediate=0, .flags=0x00, .name = "WEA5E" },
  { .ov = 23, .code = 0x224c, .word = 0xea6a, .immediate=0, .flags=0x00, .name = "WEA6A" },
  { .ov = 23, .code = 0x224c, .word = 0xea84, .immediate=0, .flags=0x00, .name = "WEA84" },
  { .ov = 23, .code = 0x224c, .word = 0xea90, .immediate=0, .flags=0x00, .name = "WEA90" },
  { .ov = 23, .code = 0x224c, .word = 0xea9c, .immediate=0, .flags=0x00, .name = "WEA9C" },
  { .ov = 23, .code = 0x224c, .word = 0xeaa8, .immediate=0, .flags=0x00, .name = "WEAA8" },
  { .ov = 23, .code = 0x224c, .word = 0xeab4, .immediate=0, .flags=0x00, .name = "WEAB4" },
  { .ov = 23, .code = 0x224c, .word = 0xeac2, .immediate=0, .flags=0x00, .name = "WEAC2" },
  { .ov = 23, .code = 0x224c, .word = 0xeacc, .immediate=0, .flags=0x00, .name = "WEACC" },
  { .ov = 23, .code = 0x224c, .word = 0xeadc, .immediate=0, .flags=0x00, .name = "WEADC" },
  { .ov = 23, .code = 0x224c, .word = 0xeae6, .immediate=0, .flags=0x00, .name = "WEAE6" },
  { .ov = 23, .code = 0x224c, .word = 0xeaf2, .immediate=0, .flags=0x00, .name = "WEAF2" },
  { .ov = 23, .code = 0x224c, .word = 0xeb10, .immediate=0, .flags=0x00, .name = "WEB10" },
  { .ov = 23, .code = 0x224c, .word = 0xeb1c, .immediate=0, .flags=0x00, .name = "WEB1C" },
  { .ov = 23, .code = 0x224c, .word = 0xeb30, .immediate=0, .flags=0x00, .name = "WEB30" },
  { .ov = 23, .code = 0x224c, .word = 0xeb70, .immediate=0, .flags=0x00, .name = "WEB70" },
  { .ov = 23, .code = 0xaccc, .word = 0xeb8a, .immediate=0, .flags=0x80, .name = "<EDL>" },
  { .ov = 23, .code = 0xaccc, .word = 0xec23, .immediate=0, .flags=0x80, .name = "<TALK>" },
  { .ov = 23, .code = 0xaccc, .word = 0xece9, .immediate=0, .flags=0x80, .name = "<AUX>" },
  { .ov = 23, .code = 0xaccc, .word = 0xed97, .immediate=0, .flags=0x80, .name = "<COMM>" },
  { .ov = 23, .code = 0x224c, .word = 0xee2b, .immediate=0, .flags=0x00, .name = "WEE2B" },
  { .ov = 23, .code = 0x224c, .word = 0xee57, .immediate=0, .flags=0x00, .name = "WEE57" },
  { .ov = 23, .code = 0x224c, .word = 0xee5f, .immediate=0, .flags=0x00, .name = "WEE5F" },
  { .ov = 23, .code = 0x224c, .word = 0xee8f, .immediate=0, .flags=0x00, .name = "WEE8F" },
  { .ov = 23, .code = 0x1d29, .word = 0xeeb3, .immediate=0, .flags=0x00, .name = "WEEB3" },
  { .ov = 23, .code = 0x224c, .word = 0xeeb8, .immediate=0, .flags=0x00, .name = "WEEB8" },
  { .ov = 23, .code = 0x4b3b, .word = 0xeee7, .immediate=0, .flags=0x80, .name = "(>?)" },
  { .ov = 23, .code = 0x224c, .word = 0xeefd, .immediate=0, .flags=0x00, .name = "WEEFD" },
  { .ov = 23, .code = 0x224c, .word = 0xef2b, .immediate=0, .flags=0x00, .name = "WEF2B" },
  { .ov = 23, .code = 0x4b3b, .word = 0xef3f, .immediate=0, .flags=0x80, .name = ">CM" },
  { .ov = 23, .code = 0x224c, .word = 0xef51, .immediate=0, .flags=0x00, .name = "WEF51" },
  { .ov = 23, .code = 0x224c, .word = 0xef64, .immediate=0, .flags=0x00, .name = "WEF64" },
  { .ov = 23, .code = 0x224c, .word = 0xef76, .immediate=0, .flags=0x00, .name = "WEF76" },
  { .ov = 23, .code = 0x224c, .word = 0xef82, .immediate=0, .flags=0x00, .name = "WEF82" },
  { .ov = 23, .code = 0x4b3b, .word = 0xef91, .immediate=0, .flags=0x80, .name = ">Y/N" },
  { .ov = 23, .code = 0x224c, .word = 0xefa3, .immediate=0, .flags=0x00, .name = "WEFA3" },
  { .ov = 23, .code = 0x224c, .word = 0xefbf, .immediate=0, .flags=0x00, .name = "WEFBF" },
  { .ov = 23, .code = 0x224c, .word = 0xefe1, .immediate=0, .flags=0x80, .name = "EDL+AUX" },
  { .ov = 23, .code = 0x224c, .word = 0xf013, .immediate=0, .flags=0x80, .name = "COMM-EXPERT" },
  { .ov = 23, .code = 0x224c, .word = 0xf04b, .immediate=0, .flags=0x00, .name = "WF04B" },
  { .ov = 23, .code = 0x224c, .word = 0xf065, .immediate=0, .flags=0x00, .name = "WF065" },
  { .ov = 23, .code = 0x224c, .word = 0xf093, .immediate=0, .flags=0x00, .name = "WF093" },
  { .ov = 23, .code = 0x224c, .word = 0xf0af, .immediate=0, .flags=0x00, .name = "WF0AF" },
  { .ov = 23, .code = 0x224c, .word = 0xf0df, .immediate=0, .flags=0x00, .name = "WF0DF" },
  { .ov = 23, .code = 0x224c, .word = 0xf165, .immediate=0, .flags=0x00, .name = "WF165" },
  { .ov = 23, .code = 0x224c, .word = 0xf1b7, .immediate=0, .flags=0x00, .name = "WF1B7" },
  { .ov = 23, .code = 0x4b3b, .word = 0xf1ca, .immediate=0, .flags=0x80, .name = "(CBTN)" },
  { .ov = 23, .code = 0x224c, .word = 0xf1dc, .immediate=0, .flags=0x00, .name = "WF1DC" },
  { .ov = 23, .code = 0x224c, .word = 0xf212, .immediate=0, .flags=0x80, .name = "CL1" },
  { .ov = 23, .code = 0x224c, .word = 0xf2c6, .immediate=0, .flags=0x00, .name = "WF2C6" },
  { .ov = 23, .code = 0x224c, .word = 0xf328, .immediate=0, .flags=0x00, .name = "WF328" },
  { .ov = 23, .code = 0x224c, .word = 0xf3ce, .immediate=0, .flags=0x00, .name = "WF3CE" },
  { .ov = 23, .code = 0x224c, .word = 0xf45e, .immediate=0, .flags=0x00, .name = "WF45E" },
  { .ov = 23, .code = 0x224c, .word = 0xf47e, .immediate=0, .flags=0x80, .name = "IAPWR" },
  { .ov = 23, .code = 0x224c, .word = 0xf4e4, .immediate=0, .flags=0x00, .name = "WF4E4" },
  { .ov = 23, .code = 0x224c, .word = 0xf4fa, .immediate=0, .flags=0x00, .name = "WF4FA" },
  { .ov = 23, .code = 0x224c, .word = 0xf52e, .immediate=0, .flags=0x80, .name = "ICOMM" },
  { .ov = 24, .code = 0x224c, .word = 0xe556, .immediate=0, .flags=0x00, .name = "WE556" },
  { .ov = 24, .code = 0x224c, .word = 0xe560, .immediate=0, .flags=0x00, .name = "WE560" },
  { .ov = 24, .code = 0x224c, .word = 0xe56c, .immediate=0, .flags=0x00, .name = "WE56C" },
  { .ov = 24, .code = 0x224c, .word = 0xe576, .immediate=0, .flags=0x00, .name = "WE576" },
  { .ov = 24, .code = 0x224c, .word = 0xe580, .immediate=0, .flags=0x00, .name = "WE580" },
  { .ov = 24, .code = 0x224c, .word = 0xe58a, .immediate=0, .flags=0x00, .name = "WE58A" },
  { .ov = 24, .code = 0x224c, .word = 0xe59e, .immediate=0, .flags=0x00, .name = "WE59E" },
  { .ov = 24, .code = 0x224c, .word = 0xe5e2, .immediate=0, .flags=0x00, .name = "WE5E2" },
  { .ov = 24, .code = 0x224c, .word = 0xe5f4, .immediate=0, .flags=0x00, .name = "WE5F4" },
  { .ov = 24, .code = 0x224c, .word = 0xe5fe, .immediate=0, .flags=0x00, .name = "WE5FE" },
  { .ov = 24, .code = 0x7420, .word = 0xe616, .immediate=0, .flags=0x00, .name = "WE616" },
  { .ov = 24, .code = 0x7420, .word = 0xe61b, .immediate=0, .flags=0x00, .name = "WE61B" },
  { .ov = 24, .code = 0x7420, .word = 0xe620, .immediate=0, .flags=0x00, .name = "WE620" },
  { .ov = 24, .code = 0x7420, .word = 0xe625, .immediate=0, .flags=0x00, .name = "WE625" },
  { .ov = 24, .code = 0x7420, .word = 0xe62a, .immediate=0, .flags=0x00, .name = "WE62A" },
  { .ov = 24, .code = 0x7420, .word = 0xe62f, .immediate=0, .flags=0x00, .name = "WE62F" },
  { .ov = 24, .code = 0x7420, .word = 0xe634, .immediate=0, .flags=0x00, .name = "WE634" },
  { .ov = 24, .code = 0x7420, .word = 0xe639, .immediate=0, .flags=0x00, .name = "WE639" },
  { .ov = 24, .code = 0x1d29, .word = 0xe63e, .immediate=0, .flags=0x00, .name = "WE63E" },
  { .ov = 24, .code = 0x224c, .word = 0xe642, .immediate=0, .flags=0x00, .name = "WE642" },
  { .ov = 24, .code = 0x224c, .word = 0xe658, .immediate=0, .flags=0x00, .name = "WE658" },
  { .ov = 24, .code = 0x224c, .word = 0xe69b, .immediate=0, .flags=0x00, .name = "WE69B" },
  { .ov = 24, .code = 0x224c, .word = 0xe6ba, .immediate=0, .flags=0x00, .name = "WE6BA" },
  { .ov = 24, .code = 0x224c, .word = 0xe6cc, .immediate=0, .flags=0x00, .name = "WE6CC" },
  { .ov = 24, .code = 0x4b3b, .word = 0xe6e5, .immediate=0, .flags=0x80, .name = "?VOWEL" },
  { .ov = 24, .code = 0x224c, .word = 0xe6ff, .immediate=0, .flags=0x00, .name = "WE6FF" },
  { .ov = 24, .code = 0x224c, .word = 0xe707, .immediate=0, .flags=0x00, .name = "WE707" },
  { .ov = 24, .code = 0x224c, .word = 0xe715, .immediate=0, .flags=0x00, .name = "WE715" },
  { .ov = 24, .code = 0x224c, .word = 0xe71f, .immediate=0, .flags=0x00, .name = "WE71F" },
  { .ov = 24, .code = 0x224c, .word = 0xe733, .immediate=0, .flags=0x00, .name = "WE733" },
  { .ov = 24, .code = 0x224c, .word = 0xe76b, .immediate=0, .flags=0x00, .name = "WE76B" },
  { .ov = 24, .code = 0x224c, .word = 0xe77d, .immediate=0, .flags=0x00, .name = "WE77D" },
  { .ov = 24, .code = 0x224c, .word = 0xe78d, .immediate=0, .flags=0x00, .name = "WE78D" },
  { .ov = 24, .code = 0x224c, .word = 0xe7a1, .immediate=0, .flags=0x00, .name = "WE7A1" },
  { .ov = 24, .code = 0x224c, .word = 0xe7b9, .immediate=0, .flags=0x00, .name = "WE7B9" },
  { .ov = 24, .code = 0x224c, .word = 0xe7d9, .immediate=0, .flags=0x00, .name = "WE7D9" },
  { .ov = 24, .code = 0x224c, .word = 0xe7f9, .immediate=0, .flags=0x00, .name = "WE7F9" },
  { .ov = 24, .code = 0x224c, .word = 0xe809, .immediate=0, .flags=0x00, .name = "WE809" },
  { .ov = 24, .code = 0x224c, .word = 0xe815, .immediate=0, .flags=0x00, .name = "WE815" },
  { .ov = 24, .code = 0x224c, .word = 0xe841, .immediate=0, .flags=0x00, .name = "WE841" },
  { .ov = 24, .code = 0x224c, .word = 0xe84f, .immediate=0, .flags=0x00, .name = "WE84F" },
  { .ov = 24, .code = 0x224c, .word = 0xe8bf, .immediate=0, .flags=0x00, .name = "WE8BF" },
  { .ov = 24, .code = 0x224c, .word = 0xe8d7, .immediate=0, .flags=0x00, .name = "WE8D7" },
  { .ov = 24, .code = 0x224c, .word = 0xe8f1, .immediate=0, .flags=0x00, .name = "WE8F1" },
  { .ov = 24, .code = 0x224c, .word = 0xe8fb, .immediate=0, .flags=0x00, .name = "WE8FB" },
  { .ov = 24, .code = 0x224c, .word = 0xe91f, .immediate=0, .flags=0x00, .name = "WE91F" },
  { .ov = 24, .code = 0x224c, .word = 0xe935, .immediate=0, .flags=0x00, .name = "WE935" },
  { .ov = 24, .code = 0x224c, .word = 0xe959, .immediate=0, .flags=0x00, .name = "WE959" },
  { .ov = 24, .code = 0x224c, .word = 0xe9b3, .immediate=0, .flags=0x00, .name = "WE9B3" },
  { .ov = 24, .code = 0x224c, .word = 0xe9c3, .immediate=0, .flags=0x00, .name = "WE9C3" },
  { .ov = 24, .code = 0x224c, .word = 0xea21, .immediate=0, .flags=0x00, .name = "WEA21" },
  { .ov = 24, .code = 0x224c, .word = 0xea2d, .immediate=0, .flags=0x00, .name = "WEA2D" },
  { .ov = 24, .code = 0x224c, .word = 0xea43, .immediate=0, .flags=0x00, .name = "WEA43" },
  { .ov = 24, .code = 0x224c, .word = 0xea51, .immediate=0, .flags=0x00, .name = "WEA51" },
  { .ov = 24, .code = 0x224c, .word = 0xea63, .immediate=0, .flags=0x00, .name = "WEA63" },
  { .ov = 24, .code = 0x7420, .word = 0xea97, .immediate=0, .flags=0x00, .name = "WEA97" },
  { .ov = 24, .code = 0x7420, .word = 0xea9c, .immediate=0, .flags=0x00, .name = "WEA9C" },
  { .ov = 24, .code = 0x224c, .word = 0xeaa1, .immediate=0, .flags=0x00, .name = "WEAA1" },
  { .ov = 24, .code = 0x224c, .word = 0xeb64, .immediate=0, .flags=0x80, .name = "GORZEK>UHL" },
  { .ov = 24, .code = 0x224c, .word = 0xebf6, .immediate=0, .flags=0x00, .name = "WEBF6" },
  { .ov = 24, .code = 0x224c, .word = 0xec36, .immediate=0, .flags=0x00, .name = "WEC36" },
  { .ov = 24, .code = 0x224c, .word = 0xec70, .immediate=0, .flags=0x00, .name = "WEC70" },
  { .ov = 24, .code = 0x224c, .word = 0xec84, .immediate=0, .flags=0x00, .name = "WEC84" },
  { .ov = 24, .code = 0x4b3b, .word = 0xeca1, .immediate=0, .flags=0x80, .name = "NPCREW" },
  { .ov = 24, .code = 0x224c, .word = 0xecaf, .immediate=0, .flags=0x00, .name = "WECAF" },
  { .ov = 24, .code = 0x224c, .word = 0xecdd, .immediate=0, .flags=0x00, .name = "WECDD" },
  { .ov = 24, .code = 0x224c, .word = 0xed59, .immediate=0, .flags=0x00, .name = "WED59" },
  { .ov = 24, .code = 0x224c, .word = 0xed71, .immediate=0, .flags=0x00, .name = "WED71" },
  { .ov = 24, .code = 0x224c, .word = 0xed9f, .immediate=0, .flags=0x00, .name = "WED9F" },
  { .ov = 24, .code = 0x224c, .word = 0xedb5, .immediate=0, .flags=0x00, .name = "WEDB5" },
  { .ov = 24, .code = 0x224c, .word = 0xedc3, .immediate=0, .flags=0x00, .name = "WEDC3" },
  { .ov = 24, .code = 0x224c, .word = 0xedd1, .immediate=0, .flags=0x00, .name = "WEDD1" },
  { .ov = 24, .code = 0x224c, .word = 0xee09, .immediate=0, .flags=0x00, .name = "WEE09" },
  { .ov = 24, .code = 0x224c, .word = 0xee17, .immediate=0, .flags=0x00, .name = "WEE17" },
  { .ov = 24, .code = 0x224c, .word = 0xee5b, .immediate=0, .flags=0x00, .name = "WEE5B" },
  { .ov = 24, .code = 0x224c, .word = 0xee7b, .immediate=0, .flags=0x00, .name = "WEE7B" },
  { .ov = 24, .code = 0x224c, .word = 0xee8b, .immediate=0, .flags=0x00, .name = "WEE8B" },
  { .ov = 24, .code = 0x224c, .word = 0xee99, .immediate=0, .flags=0x00, .name = "WEE99" },
  { .ov = 24, .code = 0x224c, .word = 0xeebd, .immediate=0, .flags=0x00, .name = "WEEBD" },
  { .ov = 24, .code = 0x224c, .word = 0xeee1, .immediate=0, .flags=0x00, .name = "WEEE1" },
  { .ov = 24, .code = 0x224c, .word = 0xeeed, .immediate=0, .flags=0x00, .name = "WEEED" },
  { .ov = 24, .code = 0x224c, .word = 0xeef7, .immediate=0, .flags=0x00, .name = "WEEF7" },
  { .ov = 24, .code = 0x224c, .word = 0xef05, .immediate=0, .flags=0x00, .name = "WEF05" },
  { .ov = 24, .code = 0x224c, .word = 0xef39, .immediate=0, .flags=0x00, .name = "WEF39" },
  { .ov = 24, .code = 0x224c, .word = 0xef4f, .immediate=0, .flags=0x00, .name = "WEF4F" },
  { .ov = 24, .code = 0x224c, .word = 0xefe9, .immediate=0, .flags=0x00, .name = "WEFE9" },
  { .ov = 24, .code = 0x224c, .word = 0xf001, .immediate=0, .flags=0x00, .name = "WF001" },
  { .ov = 24, .code = 0x224c, .word = 0xf036, .immediate=0, .flags=0x00, .name = "WF036" },
  { .ov = 24, .code = 0x224c, .word = 0xf062, .immediate=0, .flags=0x00, .name = "WF062" },
  { .ov = 24, .code = 0x224c, .word = 0xf076, .immediate=0, .flags=0x00, .name = "WF076" },
  { .ov = 24, .code = 0x224c, .word = 0xf088, .immediate=0, .flags=0x00, .name = "WF088" },
  { .ov = 24, .code = 0x224c, .word = 0xf0e6, .immediate=0, .flags=0x00, .name = "WF0E6" },
  { .ov = 24, .code = 0x224c, .word = 0xf11a, .immediate=0, .flags=0x00, .name = "WF11A" },
  { .ov = 24, .code = 0x224c, .word = 0xf13a, .immediate=0, .flags=0x00, .name = "WF13A" },
  { .ov = 24, .code = 0x224c, .word = 0xf190, .immediate=0, .flags=0x00, .name = "WF190" },
  { .ov = 24, .code = 0x224c, .word = 0xf1d2, .immediate=0, .flags=0x00, .name = "WF1D2" },
  { .ov = 24, .code = 0x224c, .word = 0xf1f6, .immediate=0, .flags=0x00, .name = "WF1F6" },
  { .ov = 24, .code = 0x224c, .word = 0xf204, .immediate=0, .flags=0x00, .name = "WF204" },
  { .ov = 24, .code = 0x224c, .word = 0xf22a, .immediate=0, .flags=0x00, .name = "WF22A" },
  { .ov = 24, .code = 0x224c, .word = 0xf23c, .immediate=0, .flags=0x00, .name = "WF23C" },
  { .ov = 24, .code = 0x4b3b, .word = 0xf250, .immediate=0, .flags=0x80, .name = "#>PROTEST" },
  { .ov = 24, .code = 0x224c, .word = 0xf26a, .immediate=0, .flags=0x80, .name = "#>PRO" },
  { .ov = 24, .code = 0x224c, .word = 0xf27e, .immediate=0, .flags=0x00, .name = "WF27E" },
  { .ov = 24, .code = 0x224c, .word = 0xf28a, .immediate=0, .flags=0x00, .name = "WF28A" },
  { .ov = 24, .code = 0x224c, .word = 0xf2de, .immediate=0, .flags=0x00, .name = "WF2DE" },
  { .ov = 24, .code = 0x224c, .word = 0xf2ea, .immediate=0, .flags=0x00, .name = "WF2EA" },
  { .ov = 24, .code = 0x224c, .word = 0xf2f6, .immediate=0, .flags=0x00, .name = "WF2F6" },
  { .ov = 24, .code = 0x224c, .word = 0xf332, .immediate=0, .flags=0x00, .name = "WF332" },
  { .ov = 24, .code = 0x224c, .word = 0xf33e, .immediate=0, .flags=0x00, .name = "WF33E" },
  { .ov = 24, .code = 0x224c, .word = 0xf36a, .immediate=0, .flags=0x00, .name = "WF36A" },
  { .ov = 24, .code = 0x224c, .word = 0xf394, .immediate=0, .flags=0x00, .name = "WF394" },
  { .ov = 24, .code = 0x224c, .word = 0xf3ec, .immediate=0, .flags=0x00, .name = "WF3EC" },
  { .ov = 24, .code = 0x1d29, .word = 0xf406, .immediate=0, .flags=0x00, .name = "WF406" },
  { .ov = 24, .code = 0x224c, .word = 0xf40a, .immediate=0, .flags=0x00, .name = "WF40A" },
  { .ov = 24, .code = 0x224c, .word = 0xf444, .immediate=0, .flags=0x00, .name = "WF444" },
  { .ov = 24, .code = 0x1d29, .word = 0xf472, .immediate=0, .flags=0x00, .name = "WF472" },
  { .ov = 24, .code = 0x1d29, .word = 0xf477, .immediate=0, .flags=0x00, .name = "WF477" },
  { .ov = 24, .code = 0x1d29, .word = 0xf47e, .immediate=0, .flags=0x00, .name = "WF47E" },
  { .ov = 24, .code = 0x1d29, .word = 0xf485, .immediate=0, .flags=0x00, .name = "WF485" },
  { .ov = 24, .code = 0x1d29, .word = 0xf48e, .immediate=0, .flags=0x00, .name = "WF48E" },
  { .ov = 24, .code = 0x1d29, .word = 0xf495, .immediate=0, .flags=0x00, .name = "WF495" },
  { .ov = 24, .code = 0x1d29, .word = 0xf49c, .immediate=0, .flags=0x00, .name = "WF49C" },
  { .ov = 24, .code = 0x1d29, .word = 0xf4a3, .immediate=0, .flags=0x00, .name = "WF4A3" },
  { .ov = 24, .code = 0x1d29, .word = 0xf4a8, .immediate=0, .flags=0x00, .name = "WF4A8" },
  { .ov = 24, .code = 0x224c, .word = 0xf4ad, .immediate=0, .flags=0x00, .name = "WF4AD" },
  { .ov = 24, .code = 0x4b3b, .word = 0xf4ef, .immediate=0, .flags=0x80, .name = "SA-CASE" },
  { .ov = 24, .code = 0x224c, .word = 0xf51d, .immediate=0, .flags=0x00, .name = "WF51D" },
  { .ov = 24, .code = 0x224c, .word = 0xf53d, .immediate=0, .flags=0x80, .name = "(XCOMM)" },
  { .ov = 25, .code = 0x2214, .word = 0xec26, .immediate=0, .flags=0x00, .name = "WEC26" },
  { .ov = 25, .code = 0x2214, .word = 0xec2a, .immediate=0, .flags=0x00, .name = "WEC2A" },
  { .ov = 25, .code = 0x2214, .word = 0xec2e, .immediate=0, .flags=0x00, .name = "WEC2E" },
  { .ov = 25, .code = 0x2214, .word = 0xec32, .immediate=0, .flags=0x00, .name = "WEC32" },
  { .ov = 25, .code = 0x2214, .word = 0xec36, .immediate=0, .flags=0x00, .name = "WEC36" },
  { .ov = 25, .code = 0x2214, .word = 0xec3a, .immediate=0, .flags=0x00, .name = "WEC3A" },
  { .ov = 25, .code = 0x2214, .word = 0xec3e, .immediate=0, .flags=0x00, .name = "WEC3E" },
  { .ov = 25, .code = 0x1d29, .word = 0xec42, .immediate=0, .flags=0x00, .name = "WEC42" },
  { .ov = 25, .code = 0x1d29, .word = 0xec46, .immediate=0, .flags=0x00, .name = "WEC46" },
  { .ov = 25, .code = 0x7394, .word = 0xec4a, .immediate=0, .flags=0x00, .name = "WEC4A" },
  { .ov = 25, .code = 0x7394, .word = 0xec52, .immediate=0, .flags=0x00, .name = "WEC52" },
  { .ov = 25, .code = 0x7394, .word = 0xec5a, .immediate=0, .flags=0x00, .name = "WEC5A" },
  { .ov = 25, .code = 0x7394, .word = 0xec62, .immediate=0, .flags=0x00, .name = "WEC62" },
  { .ov = 25, .code = 0x7394, .word = 0xec6a, .immediate=0, .flags=0x00, .name = "WEC6A" },
  { .ov = 25, .code = 0x7394, .word = 0xec72, .immediate=0, .flags=0x00, .name = "WEC72" },
  { .ov = 25, .code = 0x7394, .word = 0xec7a, .immediate=0, .flags=0x00, .name = "WEC7A" },
  { .ov = 25, .code = 0x7394, .word = 0xec82, .immediate=0, .flags=0x00, .name = "WEC82" },
  { .ov = 25, .code = 0x7394, .word = 0xec8a, .immediate=0, .flags=0x00, .name = "WEC8A" },
  { .ov = 25, .code = 0x7394, .word = 0xec92, .immediate=0, .flags=0x00, .name = "WEC92" },
  { .ov = 25, .code = 0x7420, .word = 0xec9a, .immediate=0, .flags=0x00, .name = "WEC9A" },
  { .ov = 25, .code = 0x7420, .word = 0xec9f, .immediate=0, .flags=0x00, .name = "WEC9F" },
  { .ov = 25, .code = 0x7420, .word = 0xeca4, .immediate=0, .flags=0x00, .name = "WECA4" },
  { .ov = 25, .code = 0x7394, .word = 0xeca9, .immediate=0, .flags=0x00, .name = "WECA9" },
  { .ov = 25, .code = 0x7394, .word = 0xecb1, .immediate=0, .flags=0x00, .name = "WECB1" },
  { .ov = 25, .code = 0x7394, .word = 0xecb9, .immediate=0, .flags=0x00, .name = "WECB9" },
  { .ov = 25, .code = 0x7394, .word = 0xecc1, .immediate=0, .flags=0x00, .name = "WECC1" },
  { .ov = 25, .code = 0x7420, .word = 0xecc9, .immediate=0, .flags=0x00, .name = "WECC9" },
  { .ov = 25, .code = 0x7420, .word = 0xecce, .immediate=0, .flags=0x00, .name = "WECCE" },
  { .ov = 25, .code = 0x7420, .word = 0xecd3, .immediate=0, .flags=0x00, .name = "WECD3" },
  { .ov = 25, .code = 0x7420, .word = 0xecd8, .immediate=0, .flags=0x00, .name = "WECD8" },
  { .ov = 25, .code = 0x7420, .word = 0xecdd, .immediate=0, .flags=0x00, .name = "WECDD" },
  { .ov = 25, .code = 0x224c, .word = 0xece2, .immediate=0, .flags=0x00, .name = "WECE2" },
  { .ov = 25, .code = 0x224c, .word = 0xecee, .immediate=0, .flags=0x00, .name = "WECEE" },
  { .ov = 25, .code = 0x224c, .word = 0xecf8, .immediate=0, .flags=0x00, .name = "WECF8" },
  { .ov = 25, .code = 0x224c, .word = 0xed04, .immediate=0, .flags=0x00, .name = "WED04" },
  { .ov = 25, .code = 0x224c, .word = 0xed16, .immediate=0, .flags=0x00, .name = "WED16" },
  { .ov = 25, .code = 0x224c, .word = 0xed24, .immediate=0, .flags=0x00, .name = "WED24" },
  { .ov = 25, .code = 0x224c, .word = 0xed2c, .immediate=0, .flags=0x00, .name = "WED2C" },
  { .ov = 25, .code = 0x224c, .word = 0xed34, .immediate=0, .flags=0x00, .name = "WED34" },
  { .ov = 25, .code = 0x224c, .word = 0xed46, .immediate=0, .flags=0x00, .name = "WED46" },
  { .ov = 25, .code = 0x224c, .word = 0xed52, .immediate=0, .flags=0x00, .name = "WED52" },
  { .ov = 25, .code = 0x224c, .word = 0xed70, .immediate=0, .flags=0x00, .name = "WED70" },
  { .ov = 25, .code = 0x224c, .word = 0xed8e, .immediate=0, .flags=0x00, .name = "WED8E" },
  { .ov = 25, .code = 0x224c, .word = 0xed96, .immediate=0, .flags=0x00, .name = "WED96" },
  { .ov = 25, .code = 0x224c, .word = 0xedae, .immediate=0, .flags=0x00, .name = "WEDAE" },
  { .ov = 25, .code = 0x224c, .word = 0xedba, .immediate=0, .flags=0x00, .name = "WEDBA" },
  { .ov = 25, .code = 0x224c, .word = 0xedc6, .immediate=0, .flags=0x00, .name = "WEDC6" },
  { .ov = 25, .code = 0x224c, .word = 0xedd8, .immediate=0, .flags=0x00, .name = "WEDD8" },
  { .ov = 25, .code = 0x224c, .word = 0xedf6, .immediate=0, .flags=0x00, .name = "WEDF6" },
  { .ov = 25, .code = 0x224c, .word = 0xee08, .immediate=0, .flags=0x00, .name = "WEE08" },
  { .ov = 25, .code = 0x224c, .word = 0xee1a, .immediate=0, .flags=0x00, .name = "WEE1A" },
  { .ov = 25, .code = 0x224c, .word = 0xee2c, .immediate=0, .flags=0x00, .name = "WEE2C" },
  { .ov = 25, .code = 0x224c, .word = 0xee5e, .immediate=0, .flags=0x00, .name = "WEE5E" },
  { .ov = 25, .code = 0x224c, .word = 0xee7e, .immediate=0, .flags=0x00, .name = "WEE7E" },
  { .ov = 25, .code = 0x224c, .word = 0xee92, .immediate=0, .flags=0x00, .name = "WEE92" },
  { .ov = 25, .code = 0x224c, .word = 0xeec0, .immediate=0, .flags=0x00, .name = "WEEC0" },
  { .ov = 25, .code = 0x1d29, .word = 0xeede, .immediate=0, .flags=0x00, .name = "WEEDE" },
  { .ov = 25, .code = 0x224c, .word = 0xeeee, .immediate=0, .flags=0x00, .name = "WEEEE" },
  { .ov = 25, .code = 0x224c, .word = 0xef0a, .immediate=0, .flags=0x00, .name = "WEF0A" },
  { .ov = 25, .code = 0x224c, .word = 0xef14, .immediate=0, .flags=0x00, .name = "WEF14" },
  { .ov = 25, .code = 0x224c, .word = 0xef4e, .immediate=0, .flags=0x00, .name = "WEF4E" },
  { .ov = 25, .code = 0x224c, .word = 0xef94, .immediate=0, .flags=0x00, .name = "WEF94" },
  { .ov = 25, .code = 0x224c, .word = 0xefd4, .immediate=0, .flags=0x00, .name = "WEFD4" },
  { .ov = 25, .code = 0x224c, .word = 0xefe6, .immediate=0, .flags=0x00, .name = "WEFE6" },
  { .ov = 25, .code = 0x224c, .word = 0xf016, .immediate=0, .flags=0x00, .name = "WF016" },
  { .ov = 25, .code = 0x224c, .word = 0xf02a, .immediate=0, .flags=0x00, .name = "WF02A" },
  { .ov = 25, .code = 0x224c, .word = 0xf044, .immediate=0, .flags=0x00, .name = "WF044" },
  { .ov = 25, .code = 0x224c, .word = 0xf090, .immediate=0, .flags=0x00, .name = "WF090" },
  { .ov = 25, .code = 0x224c, .word = 0xf0b2, .immediate=0, .flags=0x00, .name = "WF0B2" },
  { .ov = 25, .code = 0x224c, .word = 0xf0da, .immediate=0, .flags=0x00, .name = "WF0DA" },
  { .ov = 25, .code = 0x224c, .word = 0xf120, .immediate=0, .flags=0x00, .name = "WF120" },
  { .ov = 25, .code = 0x224c, .word = 0xf15e, .immediate=0, .flags=0x00, .name = "WF15E" },
  { .ov = 25, .code = 0x224c, .word = 0xf162, .immediate=0, .flags=0x00, .name = "WF162" },
  { .ov = 25, .code = 0x224c, .word = 0xf190, .immediate=0, .flags=0x00, .name = "WF190" },
  { .ov = 25, .code = 0x224c, .word = 0xf1a2, .immediate=0, .flags=0x00, .name = "WF1A2" },
  { .ov = 25, .code = 0x224c, .word = 0xf1ba, .immediate=0, .flags=0x00, .name = "WF1BA" },
  { .ov = 25, .code = 0x224c, .word = 0xf1da, .immediate=0, .flags=0x00, .name = "WF1DA" },
  { .ov = 25, .code = 0x224c, .word = 0xf1e8, .immediate=0, .flags=0x00, .name = "WF1E8" },
  { .ov = 25, .code = 0x224c, .word = 0xf1f4, .immediate=0, .flags=0x00, .name = "WF1F4" },
  { .ov = 25, .code = 0x224c, .word = 0xf21c, .immediate=0, .flags=0x00, .name = "WF21C" },
  { .ov = 25, .code = 0x224c, .word = 0xf2a2, .immediate=0, .flags=0x00, .name = "WF2A2" },
  { .ov = 25, .code = 0x224c, .word = 0xf2bc, .immediate=0, .flags=0x00, .name = "WF2BC" },
  { .ov = 25, .code = 0x224c, .word = 0xf2da, .immediate=0, .flags=0x00, .name = "WF2DA" },
  { .ov = 25, .code = 0x224c, .word = 0xf2ea, .immediate=0, .flags=0x00, .name = "WF2EA" },
  { .ov = 25, .code = 0x224c, .word = 0xf2fa, .immediate=0, .flags=0x00, .name = "WF2FA" },
  { .ov = 25, .code = 0x224c, .word = 0xf300, .immediate=0, .flags=0x00, .name = "WF300" },
  { .ov = 25, .code = 0x224c, .word = 0xf32e, .immediate=0, .flags=0x00, .name = "WF32E" },
  { .ov = 25, .code = 0x224c, .word = 0xf33a, .immediate=0, .flags=0x00, .name = "WF33A" },
  { .ov = 25, .code = 0x224c, .word = 0xf34a, .immediate=0, .flags=0x00, .name = "WF34A" },
  { .ov = 25, .code = 0x224c, .word = 0xf374, .immediate=0, .flags=0x00, .name = "WF374" },
  { .ov = 25, .code = 0x224c, .word = 0xf3b8, .immediate=0, .flags=0x00, .name = "WF3B8" },
  { .ov = 25, .code = 0x224c, .word = 0xf3c0, .immediate=0, .flags=0x00, .name = "WF3C0" },
  { .ov = 25, .code = 0x224c, .word = 0xf3d4, .immediate=0, .flags=0x00, .name = "WF3D4" },
  { .ov = 25, .code = 0x224c, .word = 0xf3fa, .immediate=0, .flags=0x00, .name = "WF3FA" },
  { .ov = 25, .code = 0x224c, .word = 0xf41e, .immediate=0, .flags=0x00, .name = "WF41E" },
  { .ov = 25, .code = 0x224c, .word = 0xf43a, .immediate=0, .flags=0x00, .name = "WF43A" },
  { .ov = 25, .code = 0x224c, .word = 0xf480, .immediate=0, .flags=0x00, .name = "WF480" },
  { .ov = 25, .code = 0x224c, .word = 0xf48e, .immediate=0, .flags=0x00, .name = "WF48E" },
  { .ov = 25, .code = 0x224c, .word = 0xf4c0, .immediate=0, .flags=0x00, .name = "WF4C0" },
  { .ov = 25, .code = 0x224c, .word = 0xf506, .immediate=0, .flags=0x00, .name = "WF506" },
  { .ov = 25, .code = 0x224c, .word = 0xf52b, .immediate=0, .flags=0x80, .name = "POPULA" },
  { .ov = 26, .code = 0x224c, .word = 0xf2c6, .immediate=0, .flags=0x00, .name = "WF2C6" },
  { .ov = 26, .code = 0x224c, .word = 0xf36f, .immediate=0, .flags=0x00, .name = "WF36F" },
  { .ov = 26, .code = 0x224c, .word = 0xf3e6, .immediate=0, .flags=0x00, .name = "WF3E6" },
  { .ov = 26, .code = 0x224c, .word = 0xf418, .immediate=0, .flags=0x00, .name = "WF418" },
  { .ov = 26, .code = 0x224c, .word = 0xf452, .immediate=0, .flags=0x00, .name = "WF452" },
  { .ov = 26, .code = 0x224c, .word = 0xf45e, .immediate=0, .flags=0x00, .name = "WF45E" },
  { .ov = 26, .code = 0x224c, .word = 0xf4e6, .immediate=0, .flags=0x80, .name = "ICONS" },
  { .ov = 27, .code = 0x224c, .word = 0xea36, .immediate=0, .flags=0x00, .name = "WEA36" },
  { .ov = 27, .code = 0x224c, .word = 0xea3e, .immediate=0, .flags=0x00, .name = "WEA3E" },
  { .ov = 27, .code = 0x224c, .word = 0xea46, .immediate=0, .flags=0x00, .name = "WEA46" },
  { .ov = 27, .code = 0x224c, .word = 0xea76, .immediate=0, .flags=0x00, .name = "WEA76" },
  { .ov = 27, .code = 0x7394, .word = 0xea88, .immediate=0, .flags=0x00, .name = "WEA88" },
  { .ov = 27, .code = 0x7394, .word = 0xea90, .immediate=0, .flags=0x00, .name = "WEA90" },
  { .ov = 27, .code = 0x7394, .word = 0xea98, .immediate=0, .flags=0x00, .name = "WEA98" },
  { .ov = 27, .code = 0x224c, .word = 0xeaa0, .immediate=0, .flags=0x00, .name = "WEAA0" },
  { .ov = 27, .code = 0x4b3b, .word = 0xeabb, .immediate=0, .flags=0x80, .name = "S>CM" },
  { .ov = 27, .code = 0x224c, .word = 0xeacd, .immediate=0, .flags=0x00, .name = "WEACD" },
  { .ov = 27, .code = 0x224c, .word = 0xeadb, .immediate=0, .flags=0x00, .name = "WEADB" },
  { .ov = 27, .code = 0x224c, .word = 0xeae7, .immediate=0, .flags=0x00, .name = "WEAE7" },
  { .ov = 27, .code = 0x224c, .word = 0xeaf1, .immediate=0, .flags=0x00, .name = "WEAF1" },
  { .ov = 27, .code = 0x224c, .word = 0xeafd, .immediate=0, .flags=0x00, .name = "WEAFD" },
  { .ov = 27, .code = 0x224c, .word = 0xeb09, .immediate=0, .flags=0x00, .name = "WEB09" },
  { .ov = 27, .code = 0x224c, .word = 0xeb23, .immediate=0, .flags=0x00, .name = "WEB23" },
  { .ov = 27, .code = 0x224c, .word = 0xeb43, .immediate=0, .flags=0x00, .name = "WEB43" },
  { .ov = 27, .code = 0x224c, .word = 0xeb5d, .immediate=0, .flags=0x80, .name = "SET-SPE" },
  { .ov = 27, .code = 0x224c, .word = 0xeb92, .immediate=0, .flags=0x80, .name = ".STATS" },
  { .ov = 27, .code = 0x224c, .word = 0xeba6, .immediate=0, .flags=0x80, .name = ".DISTAN" },
  { .ov = 27, .code = 0x224c, .word = 0xebb9, .immediate=0, .flags=0x80, .name = ".WHERE" },
  { .ov = 27, .code = 0x224c, .word = 0xebcd, .immediate=0, .flags=0x80, .name = ".ENERGY" },
  { .ov = 27, .code = 0x224c, .word = 0xebd7, .immediate=0, .flags=0x00, .name = "WEBD7" },
  { .ov = 27, .code = 0x1d29, .word = 0xebf6, .immediate=0, .flags=0x80, .name = "CBLT" },
  { .ov = 27, .code = 0xec04, .word = 0xec04, .immediate=0, .flags=0x80, .name = "CBLTP" },
  { .ov = 27, .code = 0x224c, .word = 0xec32, .immediate=0, .flags=0x00, .name = "WEC32" },
  { .ov = 27, .code = 0x224c, .word = 0xecfa, .immediate=0, .flags=0x00, .name = "WECFA" },
  { .ov = 27, .code = 0x224c, .word = 0xed2a, .immediate=0, .flags=0x00, .name = "WED2A" },
  { .ov = 27, .code = 0x224c, .word = 0xed8a, .immediate=0, .flags=0x00, .name = "WED8A" },
  { .ov = 27, .code = 0x224c, .word = 0xeda6, .immediate=0, .flags=0x80, .name = ".STARDA" },
  { .ov = 27, .code = 0x1d29, .word = 0xedb0, .immediate=0, .flags=0x00, .name = "WEDB0" },
  { .ov = 27, .code = 0x1d29, .word = 0xedb4, .immediate=0, .flags=0x00, .name = "WEDB4" },
  { .ov = 27, .code = 0x2214, .word = 0xedb8, .immediate=0, .flags=0x00, .name = "WEDB8" },
  { .ov = 27, .code = 0x2214, .word = 0xedbc, .immediate=0, .flags=0x00, .name = "WEDBC" },
  { .ov = 27, .code = 0x7394, .word = 0xedc0, .immediate=0, .flags=0x00, .name = "WEDC0" },
  { .ov = 27, .code = 0x224c, .word = 0xedc8, .immediate=0, .flags=0x00, .name = "WEDC8" },
  { .ov = 27, .code = 0x224c, .word = 0xede3, .immediate=0, .flags=0x80, .name = "#BOXES" },
  { .ov = 27, .code = 0x224c, .word = 0xee07, .immediate=0, .flags=0x00, .name = "WEE07" },
  { .ov = 27, .code = 0x224c, .word = 0xee1f, .immediate=0, .flags=0x00, .name = "WEE1F" },
  { .ov = 27, .code = 0x224c, .word = 0xee3f, .immediate=0, .flags=0x00, .name = "WEE3F" },
  { .ov = 27, .code = 0x224c, .word = 0xee4d, .immediate=0, .flags=0x00, .name = "WEE4D" },
  { .ov = 27, .code = 0x224c, .word = 0xee5b, .immediate=0, .flags=0x00, .name = "WEE5B" },
  { .ov = 27, .code = 0x224c, .word = 0xeedb, .immediate=0, .flags=0x00, .name = "WEEDB" },
  { .ov = 27, .code = 0x224c, .word = 0xeee3, .immediate=0, .flags=0x00, .name = "WEEE3" },
  { .ov = 27, .code = 0x224c, .word = 0xeef1, .immediate=0, .flags=0x00, .name = "WEEF1" },
  { .ov = 27, .code = 0x224c, .word = 0xef01, .immediate=0, .flags=0x00, .name = "WEF01" },
  { .ov = 27, .code = 0x224c, .word = 0xef19, .immediate=0, .flags=0x00, .name = "WEF19" },
  { .ov = 27, .code = 0x224c, .word = 0xef2d, .immediate=0, .flags=0x00, .name = "WEF2D" },
  { .ov = 27, .code = 0x224c, .word = 0xef57, .immediate=0, .flags=0x00, .name = "WEF57" },
  { .ov = 27, .code = 0x224c, .word = 0xef79, .immediate=0, .flags=0x00, .name = "WEF79" },
  { .ov = 27, .code = 0x224c, .word = 0xef99, .immediate=0, .flags=0x00, .name = "WEF99" },
  { .ov = 27, .code = 0x224c, .word = 0xefa7, .immediate=0, .flags=0x00, .name = "WEFA7" },
  { .ov = 27, .code = 0x224c, .word = 0xefb1, .immediate=0, .flags=0x00, .name = "WEFB1" },
  { .ov = 27, .code = 0x224c, .word = 0xefdf, .immediate=0, .flags=0x00, .name = "WEFDF" },
  { .ov = 27, .code = 0x224c, .word = 0xf00d, .immediate=0, .flags=0x00, .name = "WF00D" },
  { .ov = 27, .code = 0x224c, .word = 0xf067, .immediate=0, .flags=0x00, .name = "WF067" },
  { .ov = 27, .code = 0x224c, .word = 0xf095, .immediate=0, .flags=0x00, .name = "WF095" },
  { .ov = 27, .code = 0x224c, .word = 0xf0b9, .immediate=0, .flags=0x00, .name = "WF0B9" },
  { .ov = 27, .code = 0x224c, .word = 0xf0cb, .immediate=0, .flags=0x80, .name = "?POPULA" },
  { .ov = 27, .code = 0x224c, .word = 0xf123, .immediate=0, .flags=0x00, .name = "WF123" },
  { .ov = 27, .code = 0x224c, .word = 0xf16d, .immediate=0, .flags=0x00, .name = "WF16D" },
  { .ov = 27, .code = 0x224c, .word = 0xf197, .immediate=0, .flags=0x00, .name = "WF197" },
  { .ov = 27, .code = 0x224c, .word = 0xf1bd, .immediate=0, .flags=0x00, .name = "WF1BD" },
  { .ov = 27, .code = 0x224c, .word = 0xf1d9, .immediate=0, .flags=0x00, .name = "WF1D9" },
  { .ov = 27, .code = 0x224c, .word = 0xf201, .immediate=0, .flags=0x00, .name = "WF201" },
  { .ov = 27, .code = 0x224c, .word = 0xf20b, .immediate=0, .flags=0x00, .name = "WF20B" },
  { .ov = 27, .code = 0x224c, .word = 0xf223, .immediate=0, .flags=0x00, .name = "WF223" },
  { .ov = 27, .code = 0x224c, .word = 0xf231, .immediate=0, .flags=0x00, .name = "WF231" },
  { .ov = 27, .code = 0x224c, .word = 0xf25f, .immediate=0, .flags=0x00, .name = "WF25F" },
  { .ov = 27, .code = 0x224c, .word = 0xf295, .immediate=0, .flags=0x00, .name = "WF295" },
  { .ov = 27, .code = 0x224c, .word = 0xf30d, .immediate=0, .flags=0x00, .name = "WF30D" },
  { .ov = 27, .code = 0x224c, .word = 0xf383, .immediate=0, .flags=0x00, .name = "WF383" },
  { .ov = 27, .code = 0x224c, .word = 0xf3c9, .immediate=0, .flags=0x00, .name = "WF3C9" },
  { .ov = 27, .code = 0x224c, .word = 0xf3d9, .immediate=0, .flags=0x00, .name = "WF3D9" },
  { .ov = 27, .code = 0x224c, .word = 0xf3e7, .immediate=0, .flags=0x00, .name = "WF3E7" },
  { .ov = 27, .code = 0x224c, .word = 0xf40d, .immediate=0, .flags=0x00, .name = "WF40D" },
  { .ov = 27, .code = 0x224c, .word = 0xf417, .immediate=0, .flags=0x00, .name = "WF417" },
  { .ov = 27, .code = 0x224c, .word = 0xf447, .immediate=0, .flags=0x00, .name = "WF447" },
  { .ov = 27, .code = 0x224c, .word = 0xf45f, .immediate=0, .flags=0x00, .name = "WF45F" },
  { .ov = 27, .code = 0x224c, .word = 0xf46d, .immediate=0, .flags=0x00, .name = "WF46D" },
  { .ov = 27, .code = 0x224c, .word = 0xf47d, .immediate=0, .flags=0x00, .name = "WF47D" },
  { .ov = 27, .code = 0x224c, .word = 0xf489, .immediate=0, .flags=0x00, .name = "WF489" },
  { .ov = 27, .code = 0x224c, .word = 0xf499, .immediate=0, .flags=0x00, .name = "WF499" },
  { .ov = 27, .code = 0x224c, .word = 0xf4f2, .immediate=0, .flags=0x80, .name = "TELE" },
  { .ov = 27, .code = 0x224c, .word = 0xf53b, .immediate=0, .flags=0x80, .name = "TV-MOVE" },
  { .ov = 28, .code = 0x7420, .word = 0xecb6, .immediate=0, .flags=0x00, .name = "WECB6" },
  { .ov = 28, .code = 0x7420, .word = 0xecbb, .immediate=0, .flags=0x00, .name = "WECBB" },
  { .ov = 28, .code = 0x7420, .word = 0xecc0, .immediate=0, .flags=0x00, .name = "WECC0" },
  { .ov = 28, .code = 0x224c, .word = 0xecc5, .immediate=0, .flags=0x00, .name = "WECC5" },
  { .ov = 28, .code = 0x224c, .word = 0xecd9, .immediate=0, .flags=0x00, .name = "WECD9" },
  { .ov = 28, .code = 0x224c, .word = 0xed21, .immediate=0, .flags=0x00, .name = "WED21" },
  { .ov = 28, .code = 0x224c, .word = 0xed35, .immediate=0, .flags=0x00, .name = "WED35" },
  { .ov = 28, .code = 0x224c, .word = 0xedac, .immediate=0, .flags=0x00, .name = "WEDAC" },
  { .ov = 28, .code = 0x224c, .word = 0xee52, .immediate=0, .flags=0x80, .name = "DBARS" },
  { .ov = 28, .code = 0x224c, .word = 0xeea4, .immediate=0, .flags=0x80, .name = "(/DAMAGE)" },
  { .ov = 28, .code = 0x224c, .word = 0xeeb8, .immediate=0, .flags=0x00, .name = "WEEB8" },
  { .ov = 28, .code = 0x224c, .word = 0xeef0, .immediate=0, .flags=0x00, .name = "WEEF0" },
  { .ov = 28, .code = 0x224c, .word = 0xefc0, .immediate=0, .flags=0x00, .name = "WEFC0" },
  { .ov = 28, .code = 0x224c, .word = 0xefcb, .immediate=0, .flags=0x00, .name = "WEFCB" },
  { .ov = 28, .code = 0x224c, .word = 0xefd9, .immediate=0, .flags=0x00, .name = "WEFD9" },
  { .ov = 28, .code = 0x224c, .word = 0xefe7, .immediate=0, .flags=0x00, .name = "WEFE7" },
  { .ov = 28, .code = 0x224c, .word = 0xeffc, .immediate=0, .flags=0x00, .name = "WEFFC" },
  { .ov = 28, .code = 0x224c, .word = 0xf00a, .immediate=0, .flags=0x00, .name = "WF00A" },
  { .ov = 28, .code = 0x224c, .word = 0xf021, .immediate=0, .flags=0x00, .name = "WF021" },
  { .ov = 28, .code = 0x4b3b, .word = 0xf041, .immediate=0, .flags=0x80, .name = ".SHIP-ITEM" },
  { .ov = 28, .code = 0x224c, .word = 0xf063, .immediate=0, .flags=0x00, .name = "WF063" },
  { .ov = 28, .code = 0x224c, .word = 0xf0ab, .immediate=0, .flags=0x00, .name = "WF0AB" },
  { .ov = 28, .code = 0x224c, .word = 0xf0d0, .immediate=0, .flags=0x00, .name = "WF0D0" },
  { .ov = 28, .code = 0x224c, .word = 0xf11b, .immediate=0, .flags=0x00, .name = "WF11B" },
  { .ov = 28, .code = 0x224c, .word = 0xf14f, .immediate=0, .flags=0x00, .name = "WF14F" },
  { .ov = 28, .code = 0x224c, .word = 0xf1d3, .immediate=0, .flags=0x00, .name = "WF1D3" },
  { .ov = 28, .code = 0x224c, .word = 0xf221, .immediate=0, .flags=0x00, .name = "WF221" },
  { .ov = 28, .code = 0x224c, .word = 0xf255, .immediate=0, .flags=0x00, .name = "WF255" },
  { .ov = 28, .code = 0x224c, .word = 0xf281, .immediate=0, .flags=0x00, .name = "WF281" },
  { .ov = 28, .code = 0x224c, .word = 0xf2f0, .immediate=0, .flags=0x00, .name = "WF2F0" },
  { .ov = 28, .code = 0x224c, .word = 0xf31e, .immediate=0, .flags=0x00, .name = "WF31E" },
  { .ov = 28, .code = 0x224c, .word = 0xf36a, .immediate=0, .flags=0x00, .name = "WF36A" },
  { .ov = 28, .code = 0x224c, .word = 0xf38a, .immediate=0, .flags=0x00, .name = "WF38A" },
  { .ov = 28, .code = 0x224c, .word = 0xf3a8, .immediate=0, .flags=0x00, .name = "WF3A8" },
  { .ov = 28, .code = 0x224c, .word = 0xf3cb, .immediate=0, .flags=0x00, .name = "WF3CB" },
  { .ov = 28, .code = 0x224c, .word = 0xf3f1, .immediate=0, .flags=0x00, .name = "WF3F1" },
  { .ov = 28, .code = 0x224c, .word = 0xf415, .immediate=0, .flags=0x00, .name = "WF415" },
  { .ov = 28, .code = 0x224c, .word = 0xf469, .immediate=0, .flags=0x80, .name = "(/REPAIR)" },
  { .ov = 29, .code = 0x7394, .word = 0xf076, .immediate=0, .flags=0x00, .name = "WF076" },
  { .ov = 29, .code = 0x7420, .word = 0xf07e, .immediate=0, .flags=0x00, .name = "WF07E" },
  { .ov = 29, .code = 0x7420, .word = 0xf083, .immediate=0, .flags=0x00, .name = "WF083" },
  { .ov = 29, .code = 0x7420, .word = 0xf088, .immediate=0, .flags=0x00, .name = "WF088" },
  { .ov = 29, .code = 0x7420, .word = 0xf08d, .immediate=0, .flags=0x00, .name = "WF08D" },
  { .ov = 29, .code = 0x224c, .word = 0xf092, .immediate=0, .flags=0x00, .name = "WF092" },
  { .ov = 29, .code = 0x224c, .word = 0xf0a6, .immediate=0, .flags=0x00, .name = "WF0A6" },
  { .ov = 29, .code = 0x224c, .word = 0xf0e6, .immediate=0, .flags=0x00, .name = "WF0E6" },
  { .ov = 29, .code = 0x224c, .word = 0xf1b0, .immediate=0, .flags=0x00, .name = "WF1B0" },
  { .ov = 29, .code = 0x224c, .word = 0xf1ce, .immediate=0, .flags=0x00, .name = "WF1CE" },
  { .ov = 29, .code = 0x224c, .word = 0xf219, .immediate=0, .flags=0x00, .name = "WF219" },
  { .ov = 29, .code = 0x224c, .word = 0xf248, .immediate=0, .flags=0x00, .name = "WF248" },
  { .ov = 29, .code = 0x224c, .word = 0xf263, .immediate=0, .flags=0x00, .name = "WF263" },
  { .ov = 29, .code = 0x224c, .word = 0xf28e, .immediate=0, .flags=0x00, .name = "WF28E" },
  { .ov = 29, .code = 0x224c, .word = 0xf2ce, .immediate=0, .flags=0x00, .name = "WF2CE" },
  { .ov = 29, .code = 0x224c, .word = 0xf2f8, .immediate=0, .flags=0x00, .name = "WF2F8" },
  { .ov = 29, .code = 0x224c, .word = 0xf310, .immediate=0, .flags=0x00, .name = "WF310" },
  { .ov = 29, .code = 0x224c, .word = 0xf33d, .immediate=0, .flags=0x00, .name = "WF33D" },
  { .ov = 29, .code = 0x224c, .word = 0xf353, .immediate=0, .flags=0x00, .name = "WF353" },
  { .ov = 29, .code = 0x224c, .word = 0xf367, .immediate=0, .flags=0x00, .name = "WF367" },
  { .ov = 29, .code = 0x4b3b, .word = 0xf384, .immediate=0, .flags=0x80, .name = "NPCREW" },
  { .ov = 29, .code = 0x224c, .word = 0xf392, .immediate=0, .flags=0x00, .name = "WF392" },
  { .ov = 29, .code = 0x224c, .word = 0xf440, .immediate=0, .flags=0x00, .name = "WF440" },
  { .ov = 29, .code = 0x224c, .word = 0xf4f4, .immediate=0, .flags=0x80, .name = "(/EXAMINE)" },
  { .ov = 29, .code = 0x224c, .word = 0xf50d, .immediate=0, .flags=0x80, .name = "(/TREAT)" },
  { .ov = 30, .code = 0x2214, .word = 0xdb36, .immediate=0, .flags=0x00, .name = "WDB36" },
  { .ov = 30, .code = 0x2214, .word = 0xdb3a, .immediate=0, .flags=0x00, .name = "WDB3A" },
  { .ov = 30, .code = 0x2214, .word = 0xdb3e, .immediate=0, .flags=0x00, .name = "WDB3E" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb42, .immediate=0, .flags=0x00, .name = "WDB42" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb50, .immediate=0, .flags=0x00, .name = "WDB50" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb54, .immediate=0, .flags=0x00, .name = "WDB54" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb58, .immediate=0, .flags=0x00, .name = "WDB58" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb5c, .immediate=0, .flags=0x00, .name = "WDB5C" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb60, .immediate=0, .flags=0x00, .name = "WDB60" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb64, .immediate=0, .flags=0x00, .name = "WDB64" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb68, .immediate=0, .flags=0x00, .name = "WDB68" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb6c, .immediate=0, .flags=0x00, .name = "WDB6C" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb70, .immediate=0, .flags=0x00, .name = "WDB70" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb74, .immediate=0, .flags=0x00, .name = "WDB74" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb78, .immediate=0, .flags=0x00, .name = "WDB78" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb7c, .immediate=0, .flags=0x00, .name = "WDB7C" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb80, .immediate=0, .flags=0x00, .name = "WDB80" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb84, .immediate=0, .flags=0x00, .name = "WDB84" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb88, .immediate=0, .flags=0x00, .name = "WDB88" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb8c, .immediate=0, .flags=0x00, .name = "WDB8C" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb90, .immediate=0, .flags=0x00, .name = "WDB90" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb94, .immediate=0, .flags=0x00, .name = "WDB94" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb98, .immediate=0, .flags=0x00, .name = "WDB98" },
  { .ov = 30, .code = 0x1d29, .word = 0xdb9c, .immediate=0, .flags=0x00, .name = "WDB9C" },
  { .ov = 30, .code = 0x1d29, .word = 0xdba0, .immediate=0, .flags=0x00, .name = "WDBA0" },
  { .ov = 30, .code = 0x1d29, .word = 0xdba4, .immediate=0, .flags=0x00, .name = "WDBA4" },
  { .ov = 30, .code = 0x1d29, .word = 0xdba8, .immediate=0, .flags=0x00, .name = "WDBA8" },
  { .ov = 30, .code = 0x1d29, .word = 0xdbac, .immediate=0, .flags=0x00, .name = "WDBAC" },
  { .ov = 30, .code = 0x1d29, .word = 0xdbb0, .immediate=0, .flags=0x00, .name = "WDBB0" },
  { .ov = 30, .code = 0x1d29, .word = 0xdbb4, .immediate=0, .flags=0x00, .name = "WDBB4" },
  { .ov = 30, .code = 0x1d29, .word = 0xdbb8, .immediate=0, .flags=0x00, .name = "WDBB8" },
  { .ov = 30, .code = 0x1d29, .word = 0xdbbc, .immediate=0, .flags=0x00, .name = "WDBBC" },
  { .ov = 30, .code = 0x1d29, .word = 0xdbc0, .immediate=0, .flags=0x00, .name = "WDBC0" },
  { .ov = 30, .code = 0x1d29, .word = 0xdbc4, .immediate=0, .flags=0x00, .name = "WDBC4" },
  { .ov = 30, .code = 0x1d29, .word = 0xdbc8, .immediate=0, .flags=0x00, .name = "WDBC8" },
  { .ov = 30, .code = 0x1d29, .word = 0xdbcc, .immediate=0, .flags=0x00, .name = "WDBCC" },
  { .ov = 30, .code = 0x1d29, .word = 0xdbd0, .immediate=0, .flags=0x00, .name = "WDBD0" },
  { .ov = 30, .code = 0x1d29, .word = 0xdbd4, .immediate=0, .flags=0x00, .name = "WDBD4" },
  { .ov = 30, .code = 0x1d29, .word = 0xdbd8, .immediate=0, .flags=0x00, .name = "WDBD8" },
  { .ov = 30, .code = 0x1d29, .word = 0xdbdc, .immediate=0, .flags=0x00, .name = "WDBDC" },
  { .ov = 30, .code = 0x1d29, .word = 0xdbe0, .immediate=0, .flags=0x00, .name = "WDBE0" },
  { .ov = 30, .code = 0x1d29, .word = 0xdbe4, .immediate=0, .flags=0x00, .name = "WDBE4" },
  { .ov = 30, .code = 0x1d29, .word = 0xdbe8, .immediate=0, .flags=0x00, .name = "WDBE8" },
  { .ov = 30, .code = 0x1d29, .word = 0xdc0a, .immediate=0, .flags=0x00, .name = "WDC0A" },
  { .ov = 30, .code = 0x1d29, .word = 0xdc14, .immediate=0, .flags=0x00, .name = "WDC14" },
  { .ov = 30, .code = 0x1d29, .word = 0xdc36, .immediate=0, .flags=0x00, .name = "WDC36" },
  { .ov = 30, .code = 0x1d29, .word = 0xdc40, .immediate=0, .flags=0x00, .name = "WDC40" },
  { .ov = 30, .code = 0x1d29, .word = 0xdc72, .immediate=0, .flags=0x00, .name = "WDC72" },
  { .ov = 30, .code = 0x7394, .word = 0xdc8c, .immediate=0, .flags=0x00, .name = "WDC8C" },
  { .ov = 30, .code = 0x1d29, .word = 0xdc94, .immediate=0, .flags=0x00, .name = "WDC94" },
  { .ov = 30, .code = 0x1d29, .word = 0xdcd0, .immediate=0, .flags=0x00, .name = "WDCD0" },
  { .ov = 30, .code = 0xdcdc, .word = 0xdcdc, .immediate=0, .flags=0x00, .name = "WDCDC" },
  { .ov = 30, .code = 0x224c, .word = 0xdd54, .immediate=0, .flags=0x00, .name = "WDD54" },
  { .ov = 30, .code = 0x224c, .word = 0xdd76, .immediate=0, .flags=0x00, .name = "WDD76" },
  { .ov = 30, .code = 0x224c, .word = 0xdd9e, .immediate=0, .flags=0x00, .name = "WDD9E" },
  { .ov = 30, .code = 0x224c, .word = 0xddec, .immediate=0, .flags=0x00, .name = "WDDEC" },
  { .ov = 30, .code = 0xde46, .word = 0xde46, .immediate=0, .flags=0x80, .name = "SETQUAD" },
  { .ov = 30, .code = 0xde57, .word = 0xde57, .immediate=0, .flags=0x80, .name = "C*/" },
  { .ov = 30, .code = 0x224c, .word = 0xde67, .immediate=0, .flags=0x00, .name = "WDE67" },
  { .ov = 30, .code = 0x224c, .word = 0xde95, .immediate=0, .flags=0x00, .name = "WDE95" },
  { .ov = 30, .code = 0x224c, .word = 0xdeb9, .immediate=0, .flags=0x00, .name = "WDEB9" },
  { .ov = 30, .code = 0x224c, .word = 0xded9, .immediate=0, .flags=0x00, .name = "WDED9" },
  { .ov = 30, .code = 0x224c, .word = 0xdef1, .immediate=0, .flags=0x00, .name = "WDEF1" },
  { .ov = 30, .code = 0x224c, .word = 0xdf09, .immediate=0, .flags=0x00, .name = "WDF09" },
  { .ov = 30, .code = 0x224c, .word = 0xdf21, .immediate=0, .flags=0x00, .name = "WDF21" },
  { .ov = 30, .code = 0x224c, .word = 0xdf35, .immediate=0, .flags=0x00, .name = "WDF35" },
  { .ov = 30, .code = 0x224c, .word = 0xdf5f, .immediate=0, .flags=0x00, .name = "WDF5F" },
  { .ov = 30, .code = 0x224c, .word = 0xdf77, .immediate=0, .flags=0x00, .name = "WDF77" },
  { .ov = 30, .code = 0x224c, .word = 0xdfa7, .immediate=0, .flags=0x00, .name = "WDFA7" },
  { .ov = 30, .code = 0x224c, .word = 0xdfd5, .immediate=0, .flags=0x00, .name = "WDFD5" },
  { .ov = 30, .code = 0x224c, .word = 0xdfef, .immediate=0, .flags=0x00, .name = "WDFEF" },
  { .ov = 30, .code = 0x224c, .word = 0xe021, .immediate=0, .flags=0x00, .name = "WE021" },
  { .ov = 30, .code = 0x224c, .word = 0xe03d, .immediate=0, .flags=0x00, .name = "WE03D" },
  { .ov = 30, .code = 0x224c, .word = 0xe051, .immediate=0, .flags=0x00, .name = "WE051" },
  { .ov = 30, .code = 0x224c, .word = 0xe06d, .immediate=0, .flags=0x00, .name = "WE06D" },
  { .ov = 30, .code = 0x224c, .word = 0xe07f, .immediate=0, .flags=0x00, .name = "WE07F" },
  { .ov = 30, .code = 0xe0af, .word = 0xe0af, .immediate=0, .flags=0x00, .name = "WE0AF" },
  { .ov = 30, .code = 0xe0fa, .word = 0xe0fa, .immediate=0, .flags=0x00, .name = "WE0FA" },
  { .ov = 30, .code = 0xe16c, .word = 0xe16c, .immediate=0, .flags=0x00, .name = "WE16C" },
  { .ov = 30, .code = 0x224c, .word = 0xe1be, .immediate=0, .flags=0x00, .name = "WE1BE" },
  { .ov = 30, .code = 0x224c, .word = 0xe22a, .immediate=0, .flags=0x00, .name = "WE22A" },
  { .ov = 30, .code = 0x224c, .word = 0xe29c, .immediate=0, .flags=0x00, .name = "WE29C" },
  { .ov = 30, .code = 0x224c, .word = 0xe2cc, .immediate=0, .flags=0x00, .name = "WE2CC" },
  { .ov = 30, .code = 0x224c, .word = 0xe2ec, .immediate=0, .flags=0x00, .name = "WE2EC" },
  { .ov = 30, .code = 0x224c, .word = 0xe304, .immediate=0, .flags=0x00, .name = "WE304" },
  { .ov = 30, .code = 0x224c, .word = 0xe354, .immediate=0, .flags=0x00, .name = "WE354" },
  { .ov = 30, .code = 0x224c, .word = 0xe3a6, .immediate=0, .flags=0x00, .name = "WE3A6" },
  { .ov = 30, .code = 0xe3d0, .word = 0xe3d0, .immediate=0, .flags=0x00, .name = "WE3D0" },
  { .ov = 30, .code = 0xe3ee, .word = 0xe3ee, .immediate=0, .flags=0x00, .name = "WE3EE" },
  { .ov = 30, .code = 0x224c, .word = 0xe3f8, .immediate=0, .flags=0x00, .name = "WE3F8" },
  { .ov = 30, .code = 0x224c, .word = 0xe494, .immediate=0, .flags=0x00, .name = "WE494" },
  { .ov = 30, .code = 0x224c, .word = 0xe4a8, .immediate=0, .flags=0x00, .name = "WE4A8" },
  { .ov = 30, .code = 0x224c, .word = 0xe4e0, .immediate=0, .flags=0x00, .name = "WE4E0" },
  { .ov = 30, .code = 0x1d29, .word = 0xe53e, .immediate=0, .flags=0x00, .name = "WE53E" },
  { .ov = 30, .code = 0x224c, .word = 0xe542, .immediate=0, .flags=0x00, .name = "WE542" },
  { .ov = 30, .code = 0x224c, .word = 0xe598, .immediate=0, .flags=0x00, .name = "WE598" },
  { .ov = 30, .code = 0x224c, .word = 0xe5b4, .immediate=0, .flags=0x00, .name = "WE5B4" },
  { .ov = 30, .code = 0x224c, .word = 0xe5d2, .immediate=0, .flags=0x00, .name = "WE5D2" },
  { .ov = 30, .code = 0x224c, .word = 0xe620, .immediate=0, .flags=0x00, .name = "WE620" },
  { .ov = 30, .code = 0x224c, .word = 0xe647, .immediate=0, .flags=0x80, .name = "SHOWSITE" },
  { .ov = 30, .code = 0x224c, .word = 0xe66b, .immediate=0, .flags=0x80, .name = ">VIEWSITE" },
  { .ov = 30, .code = 0x224c, .word = 0xe6ad, .immediate=0, .flags=0x00, .name = "WE6AD" },
  { .ov = 30, .code = 0x224c, .word = 0xe6eb, .immediate=0, .flags=0x00, .name = "WE6EB" },
  { .ov = 30, .code = 0x224c, .word = 0xe751, .immediate=0, .flags=0x00, .name = "WE751" },
  { .ov = 30, .code = 0x224c, .word = 0xe7a9, .immediate=0, .flags=0x00, .name = "WE7A9" },
  { .ov = 30, .code = 0x224c, .word = 0xe7e5, .immediate=0, .flags=0x00, .name = "WE7E5" },
  { .ov = 30, .code = 0x224c, .word = 0xe829, .immediate=0, .flags=0x00, .name = "WE829" },
  { .ov = 30, .code = 0x224c, .word = 0xe88b, .immediate=0, .flags=0x00, .name = "WE88B" },
  { .ov = 30, .code = 0x224c, .word = 0xe8bd, .immediate=0, .flags=0x00, .name = "WE8BD" },
  { .ov = 30, .code = 0x224c, .word = 0xe8e3, .immediate=0, .flags=0x00, .name = "WE8E3" },
  { .ov = 30, .code = 0x224c, .word = 0xe8f7, .immediate=0, .flags=0x00, .name = "WE8F7" },
  { .ov = 30, .code = 0x224c, .word = 0xe931, .immediate=0, .flags=0x00, .name = "WE931" },
  { .ov = 30, .code = 0x224c, .word = 0xe96f, .immediate=0, .flags=0x00, .name = "WE96F" },
  { .ov = 30, .code = 0x224c, .word = 0xe99d, .immediate=0, .flags=0x00, .name = "WE99D" },
  { .ov = 30, .code = 0x224c, .word = 0xe9cd, .immediate=0, .flags=0x00, .name = "WE9CD" },
  { .ov = 30, .code = 0x224c, .word = 0xe9fb, .immediate=0, .flags=0x00, .name = "WE9FB" },
  { .ov = 30, .code = 0x224c, .word = 0xea35, .immediate=0, .flags=0x00, .name = "WEA35" },
  { .ov = 30, .code = 0x224c, .word = 0xea89, .immediate=0, .flags=0x00, .name = "WEA89" },
  { .ov = 30, .code = 0x224c, .word = 0xeaa3, .immediate=0, .flags=0x00, .name = "WEAA3" },
  { .ov = 30, .code = 0x224c, .word = 0xeb13, .immediate=0, .flags=0x00, .name = "WEB13" },
  { .ov = 30, .code = 0x224c, .word = 0xeba7, .immediate=0, .flags=0x80, .name = "SEEGRID" },
  { .ov = 30, .code = 0x224c, .word = 0xebbf, .immediate=0, .flags=0x00, .name = "WEBBF" },
  { .ov = 30, .code = 0x224c, .word = 0xebd9, .immediate=0, .flags=0x00, .name = "WEBD9" },
  { .ov = 30, .code = 0x224c, .word = 0xec17, .immediate=0, .flags=0x00, .name = "WEC17" },
  { .ov = 30, .code = 0x224c, .word = 0xec59, .immediate=0, .flags=0x00, .name = "WEC59" },
  { .ov = 30, .code = 0x224c, .word = 0xecf3, .immediate=0, .flags=0x00, .name = "WECF3" },
  { .ov = 30, .code = 0x224c, .word = 0xed11, .immediate=0, .flags=0x00, .name = "WED11" },
  { .ov = 30, .code = 0x224c, .word = 0xed3d, .immediate=0, .flags=0x00, .name = "WED3D" },
  { .ov = 30, .code = 0x224c, .word = 0xeda7, .immediate=0, .flags=0x00, .name = "WEDA7" },
  { .ov = 30, .code = 0x224c, .word = 0xeddd, .immediate=0, .flags=0x00, .name = "WEDDD" },
  { .ov = 30, .code = 0x224c, .word = 0xee13, .immediate=0, .flags=0x00, .name = "WEE13" },
  { .ov = 30, .code = 0x224c, .word = 0xee75, .immediate=0, .flags=0x00, .name = "WEE75" },
  { .ov = 30, .code = 0x224c, .word = 0xeeb1, .immediate=0, .flags=0x00, .name = "WEEB1" },
  { .ov = 30, .code = 0x224c, .word = 0xeed9, .immediate=0, .flags=0x00, .name = "WEED9" },
  { .ov = 30, .code = 0x224c, .word = 0xef1d, .immediate=0, .flags=0x00, .name = "WEF1D" },
  { .ov = 30, .code = 0x224c, .word = 0xef3d, .immediate=0, .flags=0x00, .name = "WEF3D" },
  { .ov = 30, .code = 0x224c, .word = 0xef65, .immediate=0, .flags=0x00, .name = "WEF65" },
  { .ov = 30, .code = 0x224c, .word = 0xef85, .immediate=0, .flags=0x00, .name = "WEF85" },
  { .ov = 30, .code = 0x224c, .word = 0xefad, .immediate=0, .flags=0x00, .name = "WEFAD" },
  { .ov = 30, .code = 0x224c, .word = 0xefc9, .immediate=0, .flags=0x00, .name = "WEFC9" },
  { .ov = 30, .code = 0x224c, .word = 0xefd9, .immediate=0, .flags=0x00, .name = "WEFD9" },
  { .ov = 30, .code = 0x224c, .word = 0xefe5, .immediate=0, .flags=0x00, .name = "WEFE5" },
  { .ov = 30, .code = 0x224c, .word = 0xeff1, .immediate=0, .flags=0x00, .name = "WEFF1" },
  { .ov = 30, .code = 0x224c, .word = 0xeffd, .immediate=0, .flags=0x00, .name = "WEFFD" },
  { .ov = 30, .code = 0x224c, .word = 0xf0c1, .immediate=0, .flags=0x00, .name = "WF0C1" },
  { .ov = 30, .code = 0x224c, .word = 0xf0db, .immediate=0, .flags=0x80, .name = "DESCEND" },
  { .ov = 30, .code = 0x224c, .word = 0xf16a, .immediate=0, .flags=0x00, .name = "WF16A" },
  { .ov = 30, .code = 0x224c, .word = 0xf1d8, .immediate=0, .flags=0x00, .name = "WF1D8" },
  { .ov = 30, .code = 0x224c, .word = 0xf220, .immediate=0, .flags=0x00, .name = "WF220" },
  { .ov = 30, .code = 0x1d29, .word = 0xf234, .immediate=0, .flags=0x00, .name = "WF234" },
  { .ov = 30, .code = 0x224c, .word = 0xf238, .immediate=0, .flags=0x00, .name = "WF238" },
  { .ov = 30, .code = 0x224c, .word = 0xf2ab, .immediate=0, .flags=0x80, .name = "ASCEND" },
  { .ov = 30, .code = 0x224c, .word = 0xf2b5, .immediate=0, .flags=0x00, .name = "WF2B5" },
  { .ov = 30, .code = 0x224c, .word = 0xf2bd, .immediate=0, .flags=0x00, .name = "WF2BD" },
  { .ov = 30, .code = 0x224c, .word = 0xf2e9, .immediate=0, .flags=0x00, .name = "WF2E9" },
  { .ov = 30, .code = 0x4b3b, .word = 0xf31b, .immediate=0, .flags=0x80, .name = "SKYCASE" },
  { .ov = 30, .code = 0x224c, .word = 0xf331, .immediate=0, .flags=0x00, .name = "WF331" },
  { .ov = 30, .code = 0x224c, .word = 0xf34c, .immediate=0, .flags=0x80, .name = "INIT-ORBIT" },
  { .ov = 30, .code = 0x224c, .word = 0xf37b, .immediate=0, .flags=0x80, .name = "ROTATE" },
  { .ov = 31, .code = 0x1d29, .word = 0xe436, .immediate=0, .flags=0x00, .name = "WE436" },
  { .ov = 31, .code = 0x1d29, .word = 0xe43a, .immediate=0, .flags=0x00, .name = "WE43A" },
  { .ov = 31, .code = 0x1d29, .word = 0xe43e, .immediate=0, .flags=0x00, .name = "WE43E" },
  { .ov = 31, .code = 0x1d29, .word = 0xe444, .immediate=0, .flags=0x00, .name = "WE444" },
  { .ov = 31, .code = 0x1d29, .word = 0xe448, .immediate=0, .flags=0x00, .name = "WE448" },
  { .ov = 31, .code = 0x224c, .word = 0xe44c, .immediate=0, .flags=0x00, .name = "WE44C" },
  { .ov = 31, .code = 0x224c, .word = 0xe454, .immediate=0, .flags=0x00, .name = "WE454" },
  { .ov = 31, .code = 0x7394, .word = 0xe45e, .immediate=0, .flags=0x00, .name = "WE45E" },
  { .ov = 31, .code = 0x224c, .word = 0xe466, .immediate=0, .flags=0x00, .name = "WE466" },
  { .ov = 31, .code = 0x224c, .word = 0xe472, .immediate=0, .flags=0x00, .name = "WE472" },
  { .ov = 31, .code = 0x224c, .word = 0xe47c, .immediate=0, .flags=0x00, .name = "WE47C" },
  { .ov = 31, .code = 0x7394, .word = 0xe4a7, .immediate=0, .flags=0x00, .name = "WE4A7" },
  { .ov = 31, .code = 0x7394, .word = 0xe4af, .immediate=0, .flags=0x00, .name = "WE4AF" },
  { .ov = 31, .code = 0x7394, .word = 0xe4b7, .immediate=0, .flags=0x00, .name = "WE4B7" },
  { .ov = 31, .code = 0x7420, .word = 0xe4bf, .immediate=0, .flags=0x00, .name = "WE4BF" },
  { .ov = 31, .code = 0x7394, .word = 0xe4c4, .immediate=0, .flags=0x00, .name = "WE4C4" },
  { .ov = 31, .code = 0x7394, .word = 0xe4cc, .immediate=0, .flags=0x00, .name = "WE4CC" },
  { .ov = 31, .code = 0x7394, .word = 0xe4d4, .immediate=0, .flags=0x00, .name = "WE4D4" },
  { .ov = 31, .code = 0x7394, .word = 0xe4dc, .immediate=0, .flags=0x00, .name = "WE4DC" },
  { .ov = 31, .code = 0x7394, .word = 0xe4e4, .immediate=0, .flags=0x00, .name = "WE4E4" },
  { .ov = 31, .code = 0x7420, .word = 0xe4ec, .immediate=0, .flags=0x00, .name = "WE4EC" },
  { .ov = 31, .code = 0x7394, .word = 0xe4f1, .immediate=0, .flags=0x00, .name = "WE4F1" },
  { .ov = 31, .code = 0x7394, .word = 0xe4f9, .immediate=0, .flags=0x00, .name = "WE4F9" },
  { .ov = 31, .code = 0x7420, .word = 0xe501, .immediate=0, .flags=0x00, .name = "WE501" },
  { .ov = 31, .code = 0x7420, .word = 0xe506, .immediate=0, .flags=0x00, .name = "WE506" },
  { .ov = 31, .code = 0x7420, .word = 0xe50b, .immediate=0, .flags=0x00, .name = "WE50B" },
  { .ov = 31, .code = 0x7420, .word = 0xe510, .immediate=0, .flags=0x00, .name = "WE510" },
  { .ov = 31, .code = 0x7420, .word = 0xe515, .immediate=0, .flags=0x00, .name = "WE515" },
  { .ov = 31, .code = 0x7420, .word = 0xe51a, .immediate=0, .flags=0x00, .name = "WE51A" },
  { .ov = 31, .code = 0x7420, .word = 0xe51f, .immediate=0, .flags=0x00, .name = "WE51F" },
  { .ov = 31, .code = 0x7420, .word = 0xe524, .immediate=0, .flags=0x00, .name = "WE524" },
  { .ov = 31, .code = 0x7420, .word = 0xe529, .immediate=0, .flags=0x00, .name = "WE529" },
  { .ov = 31, .code = 0x7420, .word = 0xe52e, .immediate=0, .flags=0x00, .name = "WE52E" },
  { .ov = 31, .code = 0x7420, .word = 0xe533, .immediate=0, .flags=0x00, .name = "WE533" },
  { .ov = 31, .code = 0x7420, .word = 0xe538, .immediate=0, .flags=0x00, .name = "WE538" },
  { .ov = 31, .code = 0x7420, .word = 0xe53d, .immediate=0, .flags=0x00, .name = "WE53D" },
  { .ov = 31, .code = 0x1d29, .word = 0xe542, .immediate=0, .flags=0x00, .name = "WE542" },
  { .ov = 31, .code = 0x224c, .word = 0xe546, .immediate=0, .flags=0x00, .name = "WE546" },
  { .ov = 31, .code = 0x224c, .word = 0xe552, .immediate=0, .flags=0x00, .name = "WE552" },
  { .ov = 31, .code = 0x224c, .word = 0xe564, .immediate=0, .flags=0x00, .name = "WE564" },
  { .ov = 31, .code = 0x224c, .word = 0xe56e, .immediate=0, .flags=0x00, .name = "WE56E" },
  { .ov = 31, .code = 0x224c, .word = 0xe583, .immediate=0, .flags=0x80, .name = ".BAL" },
  { .ov = 31, .code = 0x224c, .word = 0xe5cb, .immediate=0, .flags=0x00, .name = "WE5CB" },
  { .ov = 31, .code = 0x224c, .word = 0xe5d3, .immediate=0, .flags=0x00, .name = "WE5D3" },
  { .ov = 31, .code = 0x224c, .word = 0xe5e5, .immediate=0, .flags=0x00, .name = "WE5E5" },
  { .ov = 31, .code = 0x224c, .word = 0xe5f7, .immediate=0, .flags=0x00, .name = "WE5F7" },
  { .ov = 31, .code = 0x224c, .word = 0xe607, .immediate=0, .flags=0x00, .name = "WE607" },
  { .ov = 31, .code = 0x224c, .word = 0xe617, .immediate=0, .flags=0x00, .name = "WE617" },
  { .ov = 31, .code = 0x224c, .word = 0xe64b, .immediate=0, .flags=0x00, .name = "WE64B" },
  { .ov = 31, .code = 0x224c, .word = 0xe657, .immediate=0, .flags=0x00, .name = "WE657" },
  { .ov = 31, .code = 0x224c, .word = 0xe683, .immediate=0, .flags=0x00, .name = "WE683" },
  { .ov = 31, .code = 0x224c, .word = 0xe6bb, .immediate=0, .flags=0x00, .name = "WE6BB" },
  { .ov = 31, .code = 0x224c, .word = 0xe6cd, .immediate=0, .flags=0x00, .name = "WE6CD" },
  { .ov = 31, .code = 0x4b3b, .word = 0xe6f1, .immediate=0, .flags=0x80, .name = "TD-SCROLL" },
  { .ov = 31, .code = 0x224c, .word = 0xe6ff, .immediate=0, .flags=0x00, .name = "WE6FF" },
  { .ov = 31, .code = 0x224c, .word = 0xe72f, .immediate=0, .flags=0x00, .name = "WE72F" },
  { .ov = 31, .code = 0x224c, .word = 0xe758, .immediate=0, .flags=0x00, .name = "WE758" },
  { .ov = 31, .code = 0x224c, .word = 0xe79c, .immediate=0, .flags=0x00, .name = "WE79C" },
  { .ov = 31, .code = 0x224c, .word = 0xe7f4, .immediate=0, .flags=0x00, .name = "WE7F4" },
  { .ov = 31, .code = 0x224c, .word = 0xe832, .immediate=0, .flags=0x00, .name = "WE832" },
  { .ov = 31, .code = 0x224c, .word = 0xe848, .immediate=0, .flags=0x00, .name = "WE848" },
  { .ov = 31, .code = 0x224c, .word = 0xe872, .immediate=0, .flags=0x00, .name = "WE872" },
  { .ov = 31, .code = 0x224c, .word = 0xe8a4, .immediate=0, .flags=0x00, .name = "WE8A4" },
  { .ov = 31, .code = 0x224c, .word = 0xe8d0, .immediate=0, .flags=0x00, .name = "WE8D0" },
  { .ov = 31, .code = 0x224c, .word = 0xe960, .immediate=0, .flags=0x00, .name = "WE960" },
  { .ov = 31, .code = 0x224c, .word = 0xe98c, .immediate=0, .flags=0x00, .name = "WE98C" },
  { .ov = 31, .code = 0x224c, .word = 0xea52, .immediate=0, .flags=0x00, .name = "WEA52" },
  { .ov = 31, .code = 0x224c, .word = 0xea70, .immediate=0, .flags=0x00, .name = "WEA70" },
  { .ov = 31, .code = 0x224c, .word = 0xea9b, .immediate=0, .flags=0x00, .name = "WEA9B" },
  { .ov = 31, .code = 0x224c, .word = 0xeae3, .immediate=0, .flags=0x00, .name = "WEAE3" },
  { .ov = 31, .code = 0x224c, .word = 0xeb2d, .immediate=0, .flags=0x00, .name = "WEB2D" },
  { .ov = 31, .code = 0x224c, .word = 0xeb55, .immediate=0, .flags=0x00, .name = "WEB55" },
  { .ov = 31, .code = 0x224c, .word = 0xeba3, .immediate=0, .flags=0x00, .name = "WEBA3" },
  { .ov = 31, .code = 0x224c, .word = 0xec11, .immediate=0, .flags=0x00, .name = "WEC11" },
  { .ov = 31, .code = 0x224c, .word = 0xec3b, .immediate=0, .flags=0x00, .name = "WEC3B" },
  { .ov = 31, .code = 0x224c, .word = 0xec81, .immediate=0, .flags=0x00, .name = "WEC81" },
  { .ov = 31, .code = 0x224c, .word = 0xeca9, .immediate=0, .flags=0x00, .name = "WECA9" },
  { .ov = 31, .code = 0x224c, .word = 0xeccd, .immediate=0, .flags=0x00, .name = "WECCD" },
  { .ov = 31, .code = 0x224c, .word = 0xecf1, .immediate=0, .flags=0x00, .name = "WECF1" },
  { .ov = 31, .code = 0x224c, .word = 0xed21, .immediate=0, .flags=0x00, .name = "WED21" },
  { .ov = 31, .code = 0x224c, .word = 0xed61, .immediate=0, .flags=0x00, .name = "WED61" },
  { .ov = 31, .code = 0x224c, .word = 0xed77, .immediate=0, .flags=0x00, .name = "WED77" },
  { .ov = 31, .code = 0x4b3b, .word = 0xeda1, .immediate=0, .flags=0x80, .name = "1STOPTION" },
  { .ov = 31, .code = 0x1d29, .word = 0xedbb, .immediate=0, .flags=0x00, .name = "WEDBB" },
  { .ov = 31, .code = 0x1d29, .word = 0xedbf, .immediate=0, .flags=0x00, .name = "WEDBF" },
  { .ov = 31, .code = 0x224c, .word = 0xedcf, .immediate=0, .flags=0x80, .name = "DO-OPTION" },
  { .ov = 31, .code = 0x224c, .word = 0xede7, .immediate=0, .flags=0x00, .name = "WEDE7" },
  { .ov = 31, .code = 0x224c, .word = 0xedf9, .immediate=0, .flags=0x00, .name = "WEDF9" },
  { .ov = 31, .code = 0x224c, .word = 0xee16, .immediate=0, .flags=0x00, .name = "WEE16" },
  { .ov = 31, .code = 0x4b3b, .word = 0xee4b, .immediate=0, .flags=0x80, .name = "ITEM-OPTIONS" },
  { .ov = 31, .code = 0x224c, .word = 0xee61, .immediate=0, .flags=0x00, .name = "WEE61" },
  { .ov = 31, .code = 0x224c, .word = 0xeeb4, .immediate=0, .flags=0x00, .name = "WEEB4" },
  { .ov = 31, .code = 0x224c, .word = 0xef5a, .immediate=0, .flags=0x00, .name = "WEF5A" },
  { .ov = 31, .code = 0x224c, .word = 0xef8b, .immediate=0, .flags=0x80, .name = "(/ITEMS)" },
  { .ov = 31, .code = 0x224c, .word = 0xf02c, .immediate=0, .flags=0x80, .name = ">DESCEND" },
  { .ov = 31, .code = 0x224c, .word = 0xf05f, .immediate=0, .flags=0x00, .name = "WF05F" },
  { .ov = 31, .code = 0x224c, .word = 0xf10d, .immediate=0, .flags=0x00, .name = "WF10D" },
  { .ov = 31, .code = 0x224c, .word = 0xf12a, .immediate=0, .flags=0x00, .name = "WF12A" },
  { .ov = 31, .code = 0x224c, .word = 0xf17a, .immediate=0, .flags=0x80, .name = "(/LAUNCH/LAND)" },
  { .ov = 31, .code = 0x1d29, .word = 0xf1c0, .immediate=0, .flags=0x00, .name = "WF1C0" },
  { .ov = 31, .code = 0x224c, .word = 0xf1c4, .immediate=0, .flags=0x00, .name = "WF1C4" },
  { .ov = 31, .code = 0x224c, .word = 0xf1cc, .immediate=0, .flags=0x00, .name = "WF1CC" },
  { .ov = 31, .code = 0x224c, .word = 0xf1de, .immediate=0, .flags=0x00, .name = "WF1DE" },
  { .ov = 31, .code = 0x224c, .word = 0xf1f0, .immediate=0, .flags=0x00, .name = "WF1F0" },
  { .ov = 31, .code = 0x224c, .word = 0xf212, .immediate=0, .flags=0x00, .name = "WF212" },
  { .ov = 31, .code = 0x224c, .word = 0xf22e, .immediate=0, .flags=0x00, .name = "WF22E" },
  { .ov = 31, .code = 0x224c, .word = 0xf24c, .immediate=0, .flags=0x00, .name = "WF24C" },
  { .ov = 31, .code = 0x224c, .word = 0xf266, .immediate=0, .flags=0x00, .name = "WF266" },
  { .ov = 31, .code = 0x224c, .word = 0xf272, .immediate=0, .flags=0x00, .name = "WF272" },
  { .ov = 31, .code = 0x224c, .word = 0xf28a, .immediate=0, .flags=0x00, .name = "WF28A" },
  { .ov = 31, .code = 0x224c, .word = 0xf2c5, .immediate=0, .flags=0x00, .name = "WF2C5" },
  { .ov = 31, .code = 0x224c, .word = 0xf303, .immediate=0, .flags=0x00, .name = "WF303" },
  { .ov = 31, .code = 0x224c, .word = 0xf353, .immediate=0, .flags=0x00, .name = "WF353" },
  { .ov = 31, .code = 0x224c, .word = 0xf385, .immediate=0, .flags=0x00, .name = "WF385" },
  { .ov = 31, .code = 0x224c, .word = 0xf3bb, .immediate=0, .flags=0x00, .name = "WF3BB" },
  { .ov = 31, .code = 0x224c, .word = 0xf3dc, .immediate=0, .flags=0x00, .name = "WF3DC" },
  { .ov = 31, .code = 0x224c, .word = 0xf451, .immediate=0, .flags=0x80, .name = "(/LOG-PLAN)" },
  { .ov = 32, .code = 0x1d29, .word = 0xdfa6, .immediate=0, .flags=0x00, .name = "WDFA6" },
  { .ov = 32, .code = 0x7420, .word = 0xdfaa, .immediate=0, .flags=0x00, .name = "WDFAA" },
  { .ov = 32, .code = 0x1d29, .word = 0xdfaf, .immediate=0, .flags=0x00, .name = "WDFAF" },
  { .ov = 32, .code = 0x1d29, .word = 0xdfb3, .immediate=0, .flags=0x00, .name = "WDFB3" },
  { .ov = 32, .code = 0x224c, .word = 0xdfb7, .immediate=0, .flags=0x00, .name = "WDFB7" },
  { .ov = 32, .code = 0x7420, .word = 0xe003, .immediate=0, .flags=0x00, .name = "WE003" },
  { .ov = 32, .code = 0x7420, .word = 0xe008, .immediate=0, .flags=0x00, .name = "WE008" },
  { .ov = 32, .code = 0x7420, .word = 0xe00d, .immediate=0, .flags=0x00, .name = "WE00D" },
  { .ov = 32, .code = 0x7420, .word = 0xe012, .immediate=0, .flags=0x00, .name = "WE012" },
  { .ov = 32, .code = 0x7420, .word = 0xe017, .immediate=0, .flags=0x00, .name = "WE017" },
  { .ov = 32, .code = 0x7420, .word = 0xe01c, .immediate=0, .flags=0x00, .name = "WE01C" },
  { .ov = 32, .code = 0x7420, .word = 0xe021, .immediate=0, .flags=0x00, .name = "WE021" },
  { .ov = 32, .code = 0x7420, .word = 0xe026, .immediate=0, .flags=0x00, .name = "WE026" },
  { .ov = 32, .code = 0x7420, .word = 0xe02b, .immediate=0, .flags=0x00, .name = "WE02B" },
  { .ov = 32, .code = 0x7420, .word = 0xe030, .immediate=0, .flags=0x00, .name = "WE030" },
  { .ov = 32, .code = 0x7420, .word = 0xe035, .immediate=0, .flags=0x00, .name = "WE035" },
  { .ov = 32, .code = 0x7420, .word = 0xe03a, .immediate=0, .flags=0x00, .name = "WE03A" },
  { .ov = 32, .code = 0x7420, .word = 0xe03f, .immediate=0, .flags=0x00, .name = "WE03F" },
  { .ov = 32, .code = 0x7394, .word = 0xe044, .immediate=0, .flags=0x00, .name = "WE044" },
  { .ov = 32, .code = 0x7394, .word = 0xe04c, .immediate=0, .flags=0x00, .name = "WE04C" },
  { .ov = 32, .code = 0x7394, .word = 0xe054, .immediate=0, .flags=0x00, .name = "WE054" },
  { .ov = 32, .code = 0x7394, .word = 0xe05c, .immediate=0, .flags=0x00, .name = "WE05C" },
  { .ov = 32, .code = 0x7420, .word = 0xe064, .immediate=0, .flags=0x00, .name = "WE064" },
  { .ov = 32, .code = 0x7394, .word = 0xe069, .immediate=0, .flags=0x00, .name = "WE069" },
  { .ov = 32, .code = 0x7420, .word = 0xe071, .immediate=0, .flags=0x00, .name = "WE071" },
  { .ov = 32, .code = 0x7394, .word = 0xe076, .immediate=0, .flags=0x00, .name = "WE076" },
  { .ov = 32, .code = 0x7420, .word = 0xe07e, .immediate=0, .flags=0x00, .name = "WE07E" },
  { .ov = 32, .code = 0x7394, .word = 0xe083, .immediate=0, .flags=0x00, .name = "WE083" },
  { .ov = 32, .code = 0x7394, .word = 0xe08b, .immediate=0, .flags=0x00, .name = "WE08B" },
  { .ov = 32, .code = 0x7394, .word = 0xe093, .immediate=0, .flags=0x00, .name = "WE093" },
  { .ov = 32, .code = 0x7394, .word = 0xe09b, .immediate=0, .flags=0x00, .name = "WE09B" },
  { .ov = 32, .code = 0x7394, .word = 0xe0a3, .immediate=0, .flags=0x00, .name = "WE0A3" },
  { .ov = 32, .code = 0x224c, .word = 0xe0ab, .immediate=0, .flags=0x00, .name = "WE0AB" },
  { .ov = 32, .code = 0x224c, .word = 0xe0f7, .immediate=0, .flags=0x00, .name = "WE0F7" },
  { .ov = 32, .code = 0x224c, .word = 0xe0ff, .immediate=0, .flags=0x00, .name = "WE0FF" },
  { .ov = 32, .code = 0x224c, .word = 0xe107, .immediate=0, .flags=0x00, .name = "WE107" },
  { .ov = 32, .code = 0x224c, .word = 0xe10f, .immediate=0, .flags=0x00, .name = "WE10F" },
  { .ov = 32, .code = 0x4b3b, .word = 0xe123, .immediate=0, .flags=0x80, .name = "BIO/ENR" },
  { .ov = 32, .code = 0x224c, .word = 0xe141, .immediate=0, .flags=0x00, .name = "WE141" },
  { .ov = 32, .code = 0x224c, .word = 0xe151, .immediate=0, .flags=0x00, .name = "WE151" },
  { .ov = 32, .code = 0x224c, .word = 0xe1f5, .immediate=0, .flags=0x00, .name = "WE1F5" },
  { .ov = 32, .code = 0x224c, .word = 0xe207, .immediate=0, .flags=0x00, .name = "WE207" },
  { .ov = 32, .code = 0x224c, .word = 0xe213, .immediate=0, .flags=0x00, .name = "WE213" },
  { .ov = 32, .code = 0x224c, .word = 0xe267, .immediate=0, .flags=0x00, .name = "WE267" },
  { .ov = 32, .code = 0x224c, .word = 0xe277, .immediate=0, .flags=0x00, .name = "WE277" },
  { .ov = 32, .code = 0x224c, .word = 0xe2c9, .immediate=0, .flags=0x00, .name = "WE2C9" },
  { .ov = 32, .code = 0x224c, .word = 0xe2da, .immediate=0, .flags=0x80, .name = "?HEAVY" },
  { .ov = 32, .code = 0x224c, .word = 0xe2ea, .immediate=0, .flags=0x00, .name = "WE2EA" },
  { .ov = 32, .code = 0x224c, .word = 0xe388, .immediate=0, .flags=0x00, .name = "WE388" },
  { .ov = 32, .code = 0x224c, .word = 0xe3ae, .immediate=0, .flags=0x00, .name = "WE3AE" },
  { .ov = 32, .code = 0x224c, .word = 0xe3c8, .immediate=0, .flags=0x00, .name = "WE3C8" },
  { .ov = 32, .code = 0x224c, .word = 0xe408, .immediate=0, .flags=0x00, .name = "WE408" },
  { .ov = 32, .code = 0x224c, .word = 0xe448, .immediate=0, .flags=0x00, .name = "WE448" },
  { .ov = 32, .code = 0x224c, .word = 0xe46c, .immediate=0, .flags=0x00, .name = "WE46C" },
  { .ov = 32, .code = 0x224c, .word = 0xe498, .immediate=0, .flags=0x00, .name = "WE498" },
  { .ov = 32, .code = 0x224c, .word = 0xe4bb, .immediate=0, .flags=0x00, .name = "WE4BB" },
  { .ov = 32, .code = 0x224c, .word = 0xe4dd, .immediate=0, .flags=0x00, .name = "WE4DD" },
  { .ov = 32, .code = 0x224c, .word = 0xe517, .immediate=0, .flags=0x00, .name = "WE517" },
  { .ov = 32, .code = 0x224c, .word = 0xe573, .immediate=0, .flags=0x00, .name = "WE573" },
  { .ov = 32, .code = 0x1d29, .word = 0xe57b, .immediate=0, .flags=0x00, .name = "WE57B" },
  { .ov = 32, .code = 0x224c, .word = 0xe58d, .immediate=0, .flags=0x00, .name = "WE58D" },
  { .ov = 32, .code = 0x224c, .word = 0xe59f, .immediate=0, .flags=0x00, .name = "WE59F" },
  { .ov = 32, .code = 0x224c, .word = 0xe647, .immediate=0, .flags=0x00, .name = "WE647" },
  { .ov = 32, .code = 0x1d29, .word = 0xe73e, .immediate=0, .flags=0x00, .name = "WE73E" },
  { .ov = 32, .code = 0x1d29, .word = 0xe742, .immediate=0, .flags=0x00, .name = "WE742" },
  { .ov = 32, .code = 0x1d29, .word = 0xe746, .immediate=0, .flags=0x00, .name = "WE746" },
  { .ov = 32, .code = 0x1d29, .word = 0xe74a, .immediate=0, .flags=0x00, .name = "WE74A" },
  { .ov = 32, .code = 0x224c, .word = 0xe74e, .immediate=0, .flags=0x00, .name = "WE74E" },
  { .ov = 32, .code = 0x224c, .word = 0xe764, .immediate=0, .flags=0x00, .name = "WE764" },
  { .ov = 32, .code = 0x224c, .word = 0xe772, .immediate=0, .flags=0x00, .name = "WE772" },
  { .ov = 32, .code = 0x224c, .word = 0xe780, .immediate=0, .flags=0x00, .name = "WE780" },
  { .ov = 32, .code = 0x224c, .word = 0xe79e, .immediate=0, .flags=0x00, .name = "WE79E" },
  { .ov = 32, .code = 0x224c, .word = 0xe7ba, .immediate=0, .flags=0x00, .name = "WE7BA" },
  { .ov = 32, .code = 0x224c, .word = 0xe7de, .immediate=0, .flags=0x00, .name = "WE7DE" },
  { .ov = 32, .code = 0x224c, .word = 0xe804, .immediate=0, .flags=0x00, .name = "WE804" },
  { .ov = 32, .code = 0x224c, .word = 0xe82a, .immediate=0, .flags=0x00, .name = "WE82A" },
  { .ov = 32, .code = 0x224c, .word = 0xe84c, .immediate=0, .flags=0x00, .name = "WE84C" },
  { .ov = 32, .code = 0x224c, .word = 0xe8b4, .immediate=0, .flags=0x00, .name = "WE8B4" },
  { .ov = 32, .code = 0x224c, .word = 0xe8c0, .immediate=0, .flags=0x00, .name = "WE8C0" },
  { .ov = 32, .code = 0x224c, .word = 0xe906, .immediate=0, .flags=0x00, .name = "WE906" },
  { .ov = 32, .code = 0x1d29, .word = 0xe910, .immediate=0, .flags=0x00, .name = "WE910" },
  { .ov = 32, .code = 0x1d29, .word = 0xe914, .immediate=0, .flags=0x00, .name = "WE914" },
  { .ov = 32, .code = 0x1d29, .word = 0xe918, .immediate=0, .flags=0x00, .name = "WE918" },
  { .ov = 32, .code = 0x224c, .word = 0xe922, .immediate=0, .flags=0x00, .name = "WE922" },
  { .ov = 32, .code = 0x224c, .word = 0xe95c, .immediate=0, .flags=0x00, .name = "WE95C" },
  { .ov = 32, .code = 0x224c, .word = 0xe9a0, .immediate=0, .flags=0x00, .name = "WE9A0" },
  { .ov = 32, .code = 0x224c, .word = 0xea1c, .immediate=0, .flags=0x00, .name = "WEA1C" },
  { .ov = 32, .code = 0x224c, .word = 0xeabc, .immediate=0, .flags=0x00, .name = "WEABC" },
  { .ov = 32, .code = 0x224c, .word = 0xeb7a, .immediate=0, .flags=0x00, .name = "WEB7A" },
  { .ov = 32, .code = 0x224c, .word = 0xebac, .immediate=0, .flags=0x00, .name = "WEBAC" },
  { .ov = 32, .code = 0x224c, .word = 0xebd4, .immediate=0, .flags=0x00, .name = "WEBD4" },
  { .ov = 32, .code = 0x224c, .word = 0xebf2, .immediate=0, .flags=0x00, .name = "WEBF2" },
  { .ov = 32, .code = 0x1d29, .word = 0xec00, .immediate=0, .flags=0x00, .name = "WEC00" },
  { .ov = 32, .code = 0x224c, .word = 0xec0b, .immediate=0, .flags=0x00, .name = "WEC0B" },
  { .ov = 32, .code = 0x224c, .word = 0xec25, .immediate=0, .flags=0x00, .name = "WEC25" },
  { .ov = 32, .code = 0x1d29, .word = 0xecc7, .immediate=0, .flags=0x00, .name = "WECC7" },
  { .ov = 32, .code = 0x1d29, .word = 0xecce, .immediate=0, .flags=0x00, .name = "WECCE" },
  { .ov = 32, .code = 0x224c, .word = 0xecd5, .immediate=0, .flags=0x00, .name = "WECD5" },
  { .ov = 32, .code = 0x224c, .word = 0xeceb, .immediate=0, .flags=0x00, .name = "WECEB" },
  { .ov = 32, .code = 0x224c, .word = 0xed45, .immediate=0, .flags=0x00, .name = "WED45" },
  { .ov = 32, .code = 0x224c, .word = 0xed4d, .immediate=0, .flags=0x00, .name = "WED4D" },
  { .ov = 32, .code = 0x224c, .word = 0xed6d, .immediate=0, .flags=0x00, .name = "WED6D" },
  { .ov = 32, .code = 0x224c, .word = 0xed7e, .immediate=0, .flags=0x00, .name = "WED7E" },
  { .ov = 32, .code = 0x224c, .word = 0xed92, .immediate=0, .flags=0x00, .name = "WED92" },
  { .ov = 32, .code = 0x224c, .word = 0xed9e, .immediate=0, .flags=0x00, .name = "WED9E" },
  { .ov = 32, .code = 0x224c, .word = 0xedae, .immediate=0, .flags=0x00, .name = "WEDAE" },
  { .ov = 32, .code = 0x224c, .word = 0xee3b, .immediate=0, .flags=0x00, .name = "WEE3B" },
  { .ov = 32, .code = 0x224c, .word = 0xee8f, .immediate=0, .flags=0x00, .name = "WEE8F" },
  { .ov = 32, .code = 0x224c, .word = 0xef1b, .immediate=0, .flags=0x00, .name = "WEF1B" },
  { .ov = 32, .code = 0x224c, .word = 0xefa0, .immediate=0, .flags=0x00, .name = "WEFA0" },
  { .ov = 32, .code = 0x224c, .word = 0xefb2, .immediate=0, .flags=0x00, .name = "WEFB2" },
  { .ov = 32, .code = 0x224c, .word = 0xf06c, .immediate=0, .flags=0x00, .name = "WF06C" },
  { .ov = 32, .code = 0x224c, .word = 0xf0a4, .immediate=0, .flags=0x00, .name = "WF0A4" },
  { .ov = 32, .code = 0x224c, .word = 0xf0da, .immediate=0, .flags=0x00, .name = "WF0DA" },
  { .ov = 32, .code = 0x224c, .word = 0xf0e6, .immediate=0, .flags=0x00, .name = "WF0E6" },
  { .ov = 32, .code = 0x4b3b, .word = 0xf13a, .immediate=0, .flags=0x80, .name = ".READINGS" },
  { .ov = 32, .code = 0x224c, .word = 0xf159, .immediate=0, .flags=0x80, .name = "(/SENSORS)" },
  { .ov = 32, .code = 0x224c, .word = 0xf20e, .immediate=0, .flags=0x00, .name = "WF20E" },
  { .ov = 32, .code = 0x224c, .word = 0xf24e, .immediate=0, .flags=0x00, .name = "WF24E" },
  { .ov = 32, .code = 0x224c, .word = 0xf260, .immediate=0, .flags=0x00, .name = "WF260" },
  { .ov = 32, .code = 0x224c, .word = 0xf268, .immediate=0, .flags=0x00, .name = "WF268" },
  { .ov = 32, .code = 0x224c, .word = 0xf2a0, .immediate=0, .flags=0x00, .name = "WF2A0" },
  { .ov = 32, .code = 0x224c, .word = 0xf2b4, .immediate=0, .flags=0x00, .name = "WF2B4" },
  { .ov = 32, .code = 0x224c, .word = 0xf2d6, .immediate=0, .flags=0x00, .name = "WF2D6" },
  { .ov = 32, .code = 0x224c, .word = 0xf32a, .immediate=0, .flags=0x00, .name = "WF32A" },
  { .ov = 32, .code = 0x4b3b, .word = 0xf33b, .immediate=0, .flags=0x80, .name = "CTXT>I" },
  { .ov = 32, .code = 0x224c, .word = 0xf349, .immediate=0, .flags=0x00, .name = "WF349" },
  { .ov = 32, .code = 0x224c, .word = 0xf34f, .immediate=0, .flags=0x00, .name = "WF34F" },
  { .ov = 32, .code = 0x224c, .word = 0xf357, .immediate=0, .flags=0x00, .name = "WF357" },
  { .ov = 32, .code = 0x224c, .word = 0xf361, .immediate=0, .flags=0x00, .name = "WF361" },
  { .ov = 32, .code = 0x224c, .word = 0xf36b, .immediate=0, .flags=0x00, .name = "WF36B" },
  { .ov = 32, .code = 0x224c, .word = 0xf37d, .immediate=0, .flags=0x00, .name = "WF37D" },
  { .ov = 32, .code = 0x224c, .word = 0xf39d, .immediate=0, .flags=0x00, .name = "WF39D" },
  { .ov = 32, .code = 0x224c, .word = 0xf3c1, .immediate=0, .flags=0x00, .name = "WF3C1" },
  { .ov = 32, .code = 0x1d29, .word = 0xf401, .immediate=0, .flags=0x80, .name = "'DO-CLOUD" },
  { .ov = 32, .code = 0x224c, .word = 0xf405, .immediate=0, .flags=0x00, .name = "WF405" },
  { .ov = 32, .code = 0x224c, .word = 0xf40f, .immediate=0, .flags=0x00, .name = "WF40F" },
  { .ov = 32, .code = 0x224c, .word = 0xf463, .immediate=0, .flags=0x80, .name = ".STARDATE" },
  { .ov = 32, .code = 0x224c, .word = 0xf4b1, .immediate=0, .flags=0x00, .name = "WF4B1" },
  { .ov = 32, .code = 0x224c, .word = 0xf4c9, .immediate=0, .flags=0x00, .name = "WF4C9" },
  { .ov = 32, .code = 0x224c, .word = 0xf4e7, .immediate=0, .flags=0x00, .name = "WF4E7" },
  { .ov = 32, .code = 0x224c, .word = 0xf537, .immediate=0, .flags=0x80, .name = "(/STATUS)" },
  { .ov = 32, .code = 0x224c, .word = 0xf554, .immediate=0, .flags=0x80, .name = ".STAT-TEXT" },
  { .ov = 33, .code = 0x7420, .word = 0xf196, .immediate=0, .flags=0x00, .name = "WF196" },
  { .ov = 33, .code = 0x7420, .word = 0xf19b, .immediate=0, .flags=0x00, .name = "WF19B" },
  { .ov = 33, .code = 0x7420, .word = 0xf1a0, .immediate=0, .flags=0x00, .name = "WF1A0" },
  { .ov = 33, .code = 0x7420, .word = 0xf1a5, .immediate=0, .flags=0x00, .name = "WF1A5" },
  { .ov = 33, .code = 0x7394, .word = 0xf1aa, .immediate=0, .flags=0x00, .name = "WF1AA" },
  { .ov = 33, .code = 0x7394, .word = 0xf1b2, .immediate=0, .flags=0x00, .name = "WF1B2" },
  { .ov = 33, .code = 0x224c, .word = 0xf1ba, .immediate=0, .flags=0x00, .name = "WF1BA" },
  { .ov = 33, .code = 0x224c, .word = 0xf1c4, .immediate=0, .flags=0x00, .name = "WF1C4" },
  { .ov = 33, .code = 0x224c, .word = 0xf1d6, .immediate=0, .flags=0x00, .name = "WF1D6" },
  { .ov = 33, .code = 0x224c, .word = 0xf1e0, .immediate=0, .flags=0x00, .name = "WF1E0" },
  { .ov = 33, .code = 0x224c, .word = 0xf202, .immediate=0, .flags=0x00, .name = "WF202" },
  { .ov = 33, .code = 0x224c, .word = 0xf243, .immediate=0, .flags=0x80, .name = ">DOWN-SHIELD" },
  { .ov = 33, .code = 0x224c, .word = 0xf301, .immediate=0, .flags=0x00, .name = "WF301" },
  { .ov = 33, .code = 0x224c, .word = 0xf311, .immediate=0, .flags=0x00, .name = "WF311" },
  { .ov = 33, .code = 0x224c, .word = 0xf3a9, .immediate=0, .flags=0x80, .name = ">DISARM" },
  { .ov = 33, .code = 0x224c, .word = 0xf3ef, .immediate=0, .flags=0x00, .name = "WF3EF" },
  { .ov = 33, .code = 0x224c, .word = 0xf4d9, .immediate=0, .flags=0x80, .name = "(/(DIS)ARM)" },
  { .ov = 33, .code = 0x224c, .word = 0xf50b, .immediate=0, .flags=0x80, .name = "(/(UD)SHIELD)" },
  { .ov = 34, .code = 0x1d29, .word = 0xebf6, .immediate=0, .flags=0x00, .name = "WEBF6" },
  { .ov = 34, .code = 0x7420, .word = 0xebfa, .immediate=0, .flags=0x00, .name = "WEBFA" },
  { .ov = 34, .code = 0x7420, .word = 0xebff, .immediate=0, .flags=0x00, .name = "WEBFF" },
  { .ov = 34, .code = 0x7420, .word = 0xec04, .immediate=0, .flags=0x00, .name = "WEC04" },
  { .ov = 34, .code = 0x7420, .word = 0xec09, .immediate=0, .flags=0x00, .name = "WEC09" },
  { .ov = 34, .code = 0x7394, .word = 0xec0e, .immediate=0, .flags=0x00, .name = "WEC0E" },
  { .ov = 34, .code = 0x224c, .word = 0xec16, .immediate=0, .flags=0x00, .name = "WEC16" },
  { .ov = 34, .code = 0x224c, .word = 0xec20, .immediate=0, .flags=0x00, .name = "WEC20" },
  { .ov = 34, .code = 0x224c, .word = 0xec2a, .immediate=0, .flags=0x00, .name = "WEC2A" },
  { .ov = 34, .code = 0x224c, .word = 0xec34, .immediate=0, .flags=0x00, .name = "WEC34" },
  { .ov = 34, .code = 0x224c, .word = 0xec6c, .immediate=0, .flags=0x00, .name = "WEC6C" },
  { .ov = 34, .code = 0x224c, .word = 0xec78, .immediate=0, .flags=0x00, .name = "WEC78" },
  { .ov = 34, .code = 0x224c, .word = 0xec92, .immediate=0, .flags=0x00, .name = "WEC92" },
  { .ov = 34, .code = 0x224c, .word = 0xecb4, .immediate=0, .flags=0x00, .name = "WECB4" },
  { .ov = 34, .code = 0x224c, .word = 0xecec, .immediate=0, .flags=0x00, .name = "WECEC" },
  { .ov = 34, .code = 0x224c, .word = 0xed3a, .immediate=0, .flags=0x00, .name = "WED3A" },
  { .ov = 34, .code = 0x224c, .word = 0xed62, .immediate=0, .flags=0x00, .name = "WED62" },
  { .ov = 34, .code = 0x224c, .word = 0xed86, .immediate=0, .flags=0x00, .name = "WED86" },
  { .ov = 34, .code = 0x224c, .word = 0xedba, .immediate=0, .flags=0x00, .name = "WEDBA" },
  { .ov = 34, .code = 0x224c, .word = 0xedd0, .immediate=0, .flags=0x00, .name = "WEDD0" },
  { .ov = 34, .code = 0x224c, .word = 0xede6, .immediate=0, .flags=0x00, .name = "WEDE6" },
  { .ov = 34, .code = 0x224c, .word = 0xedf4, .immediate=0, .flags=0x00, .name = "WEDF4" },
  { .ov = 34, .code = 0x224c, .word = 0xee30, .immediate=0, .flags=0x00, .name = "WEE30" },
  { .ov = 34, .code = 0x224c, .word = 0xee3a, .immediate=0, .flags=0x00, .name = "WEE3A" },
  { .ov = 34, .code = 0x224c, .word = 0xee5e, .immediate=0, .flags=0x00, .name = "WEE5E" },
  { .ov = 34, .code = 0x224c, .word = 0xee76, .immediate=0, .flags=0x00, .name = "WEE76" },
  { .ov = 34, .code = 0x4b3b, .word = 0xee8a, .immediate=0, .flags=0x80, .name = "(GET-AUX)" },
  { .ov = 34, .code = 0x224c, .word = 0xeeac, .immediate=0, .flags=0x00, .name = "WEEAC" },
  { .ov = 34, .code = 0x224c, .word = 0xeece, .immediate=0, .flags=0x00, .name = "WEECE" },
  { .ov = 34, .code = 0x224c, .word = 0xeee6, .immediate=0, .flags=0x00, .name = "WEEE6" },
  { .ov = 34, .code = 0x4b3b, .word = 0xef1b, .immediate=0, .flags=0x80, .name = "1.1BTN.XEQ" },
  { .ov = 34, .code = 0x224c, .word = 0xef29, .immediate=0, .flags=0x00, .name = "WEF29" },
  { .ov = 34, .code = 0x224c, .word = 0xef3d, .immediate=0, .flags=0x00, .name = "WEF3D" },
  { .ov = 34, .code = 0x224c, .word = 0xeff2, .immediate=0, .flags=0x00, .name = "WEFF2" },
  { .ov = 34, .code = 0x4b3b, .word = 0xf02a, .immediate=0, .flags=0x80, .name = ">DISEMBARK" },
  { .ov = 34, .code = 0x224c, .word = 0xf038, .immediate=0, .flags=0x00, .name = "WF038" },
  { .ov = 34, .code = 0x224c, .word = 0xf082, .immediate=0, .flags=0x00, .name = "WF082" },
  { .ov = 34, .code = 0x224c, .word = 0xf096, .immediate=0, .flags=0x00, .name = "WF096" },
  { .ov = 34, .code = 0x224c, .word = 0xf0a0, .immediate=0, .flags=0x00, .name = "WF0A0" },
  { .ov = 34, .code = 0x224c, .word = 0xf0aa, .immediate=0, .flags=0x00, .name = "WF0AA" },
  { .ov = 34, .code = 0x4b3b, .word = 0xf0e3, .immediate=0, .flags=0x80, .name = "1BTN.XEQ" },
  { .ov = 34, .code = 0x224c, .word = 0xf0fd, .immediate=0, .flags=0x00, .name = "WF0FD" },
  { .ov = 34, .code = 0x224c, .word = 0xf11e, .immediate=0, .flags=0x00, .name = "WF11E" },
  { .ov = 34, .code = 0x224c, .word = 0xf172, .immediate=0, .flags=0x00, .name = "WF172" },
  { .ov = 34, .code = 0x224c, .word = 0xf17e, .immediate=0, .flags=0x00, .name = "WF17E" },
  { .ov = 34, .code = 0x224c, .word = 0xf18a, .immediate=0, .flags=0x00, .name = "WF18A" },
  { .ov = 34, .code = 0x4b3b, .word = 0xf19d, .immediate=0, .flags=0x80, .name = "2BTN.XEQ" },
  { .ov = 34, .code = 0x224c, .word = 0xf1b3, .immediate=0, .flags=0x00, .name = "WF1B3" },
  { .ov = 34, .code = 0x224c, .word = 0xf1c1, .immediate=0, .flags=0x00, .name = "WF1C1" },
  { .ov = 34, .code = 0x224c, .word = 0xf1d1, .immediate=0, .flags=0x00, .name = "WF1D1" },
  { .ov = 34, .code = 0x224c, .word = 0xf1db, .immediate=0, .flags=0x00, .name = "WF1DB" },
  { .ov = 34, .code = 0x224c, .word = 0xf1eb, .immediate=0, .flags=0x00, .name = "WF1EB" },
  { .ov = 34, .code = 0x4b3b, .word = 0xf208, .immediate=0, .flags=0x80, .name = "3BTN.XEQ" },
  { .ov = 34, .code = 0x224c, .word = 0xf222, .immediate=0, .flags=0x00, .name = "WF222" },
  { .ov = 34, .code = 0x224c, .word = 0xf22a, .immediate=0, .flags=0x00, .name = "WF22A" },
  { .ov = 34, .code = 0x224c, .word = 0xf236, .immediate=0, .flags=0x00, .name = "WF236" },
  { .ov = 34, .code = 0x4b3b, .word = 0xf24b, .immediate=0, .flags=0x80, .name = "4BTN.XEQ" },
  { .ov = 34, .code = 0x224c, .word = 0xf25d, .immediate=0, .flags=0x00, .name = "WF25D" },
  { .ov = 34, .code = 0x224c, .word = 0xf277, .immediate=0, .flags=0x00, .name = "WF277" },
  { .ov = 34, .code = 0x224c, .word = 0xf289, .immediate=0, .flags=0x00, .name = "WF289" },
  { .ov = 34, .code = 0x224c, .word = 0xf293, .immediate=0, .flags=0x00, .name = "WF293" },
  { .ov = 34, .code = 0x4b3b, .word = 0xf2a8, .immediate=0, .flags=0x80, .name = "6BTN.XEQ" },
  { .ov = 34, .code = 0x224c, .word = 0xf2b6, .immediate=0, .flags=0x00, .name = "WF2B6" },
  { .ov = 34, .code = 0x224c, .word = 0xf2d2, .immediate=0, .flags=0x00, .name = "WF2D2" },
  { .ov = 34, .code = 0x224c, .word = 0xf2ea, .immediate=0, .flags=0x00, .name = "WF2EA" },
  { .ov = 34, .code = 0x224c, .word = 0xf302, .immediate=0, .flags=0x00, .name = "WF302" },
  { .ov = 34, .code = 0x224c, .word = 0xf31a, .immediate=0, .flags=0x00, .name = "WF31A" },
  { .ov = 34, .code = 0x224c, .word = 0xf32a, .immediate=0, .flags=0x00, .name = "WF32A" },
  { .ov = 34, .code = 0x4b3b, .word = 0xf34f, .immediate=0, .flags=0x80, .name = "[0BTN.XEQ]" },
  { .ov = 34, .code = 0x224c, .word = 0xf369, .immediate=0, .flags=0x00, .name = "WF369" },
  { .ov = 34, .code = 0x224c, .word = 0xf3b3, .immediate=0, .flags=0x00, .name = "WF3B3" },
  { .ov = 34, .code = 0x224c, .word = 0xf452, .immediate=0, .flags=0x00, .name = "WF452" },
  { .ov = 34, .code = 0x224c, .word = 0xf460, .immediate=0, .flags=0x00, .name = "WF460" },
  { .ov = 34, .code = 0x224c, .word = 0xf47c, .immediate=0, .flags=0x00, .name = "WF47C" },
  { .ov = 34, .code = 0x224c, .word = 0xf502, .immediate=0, .flags=0x00, .name = "WF502" },
  { .ov = 34, .code = 0x224c, .word = 0xf517, .immediate=0, .flags=0x80, .name = ">FLT" },
  { .ov = 35, .code = 0x7420, .word = 0xe356, .immediate=0, .flags=0x00, .name = "WE356" },
  { .ov = 35, .code = 0x7420, .word = 0xe35b, .immediate=0, .flags=0x00, .name = "WE35B" },
  { .ov = 35, .code = 0x7420, .word = 0xe360, .immediate=0, .flags=0x00, .name = "WE360" },
  { .ov = 35, .code = 0x7420, .word = 0xe365, .immediate=0, .flags=0x00, .name = "WE365" },
  { .ov = 35, .code = 0x1d29, .word = 0xe36a, .immediate=0, .flags=0x00, .name = "WE36A" },
  { .ov = 35, .code = 0x2214, .word = 0xe36e, .immediate=0, .flags=0x00, .name = "WE36E" },
  { .ov = 35, .code = 0x1d29, .word = 0xe372, .immediate=0, .flags=0x00, .name = "WE372" },
  { .ov = 35, .code = 0x1d29, .word = 0xe376, .immediate=0, .flags=0x00, .name = "WE376" },
  { .ov = 35, .code = 0x1d29, .word = 0xe37a, .immediate=0, .flags=0x00, .name = "WE37A" },
  { .ov = 35, .code = 0x1d29, .word = 0xe37e, .immediate=0, .flags=0x00, .name = "WE37E" },
  { .ov = 35, .code = 0x1d29, .word = 0xe382, .immediate=0, .flags=0x00, .name = "WE382" },
  { .ov = 35, .code = 0x1d29, .word = 0xe386, .immediate=0, .flags=0x00, .name = "WE386" },
  { .ov = 35, .code = 0x1d29, .word = 0xe38a, .immediate=0, .flags=0x00, .name = "WE38A" },
  { .ov = 35, .code = 0x1d29, .word = 0xe38e, .immediate=0, .flags=0x00, .name = "WE38E" },
  { .ov = 35, .code = 0x7420, .word = 0xe392, .immediate=0, .flags=0x00, .name = "WE392" },
  { .ov = 35, .code = 0x7420, .word = 0xe397, .immediate=0, .flags=0x00, .name = "WE397" },
  { .ov = 35, .code = 0x7420, .word = 0xe39c, .immediate=0, .flags=0x00, .name = "WE39C" },
  { .ov = 35, .code = 0x7420, .word = 0xe3a1, .immediate=0, .flags=0x00, .name = "WE3A1" },
  { .ov = 35, .code = 0x7420, .word = 0xe3a6, .immediate=0, .flags=0x00, .name = "WE3A6" },
  { .ov = 35, .code = 0x7394, .word = 0xe3ab, .immediate=0, .flags=0x00, .name = "WE3AB" },
  { .ov = 35, .code = 0x1d29, .word = 0xe3b3, .immediate=0, .flags=0x00, .name = "WE3B3" },
  { .ov = 35, .code = 0x1d29, .word = 0xe3c1, .immediate=0, .flags=0x00, .name = "WE3C1" },
  { .ov = 35, .code = 0x224c, .word = 0xe3c5, .immediate=0, .flags=0x00, .name = "WE3C5" },
  { .ov = 35, .code = 0x224c, .word = 0xe3f3, .immediate=0, .flags=0x00, .name = "WE3F3" },
  { .ov = 35, .code = 0x224c, .word = 0xe471, .immediate=0, .flags=0x00, .name = "WE471" },
  { .ov = 35, .code = 0x224c, .word = 0xe497, .immediate=0, .flags=0x00, .name = "WE497" },
  { .ov = 35, .code = 0x1d29, .word = 0xe4ab, .immediate=0, .flags=0x00, .name = "WE4AB" },
  { .ov = 35, .code = 0x1d29, .word = 0xe4af, .immediate=0, .flags=0x00, .name = "WE4AF" },
  { .ov = 35, .code = 0x1d29, .word = 0xe4b3, .immediate=0, .flags=0x00, .name = "WE4B3" },
  { .ov = 35, .code = 0x1d29, .word = 0xe4b7, .immediate=0, .flags=0x00, .name = "WE4B7" },
  { .ov = 35, .code = 0x224c, .word = 0xe4bb, .immediate=0, .flags=0x00, .name = "WE4BB" },
  { .ov = 35, .code = 0x224c, .word = 0xe4dd, .immediate=0, .flags=0x00, .name = "WE4DD" },
  { .ov = 35, .code = 0x224c, .word = 0xe4f3, .immediate=0, .flags=0x00, .name = "WE4F3" },
  { .ov = 35, .code = 0x224c, .word = 0xe52f, .immediate=0, .flags=0x00, .name = "WE52F" },
  { .ov = 35, .code = 0x224c, .word = 0xe549, .immediate=0, .flags=0x00, .name = "WE549" },
  { .ov = 35, .code = 0x224c, .word = 0xe585, .immediate=0, .flags=0x00, .name = "WE585" },
  { .ov = 35, .code = 0x224c, .word = 0xe629, .immediate=0, .flags=0x00, .name = "WE629" },
  { .ov = 35, .code = 0x224c, .word = 0xe635, .immediate=0, .flags=0x00, .name = "WE635" },
  { .ov = 35, .code = 0x224c, .word = 0xe722, .immediate=0, .flags=0x00, .name = "WE722" },
  { .ov = 35, .code = 0x224c, .word = 0xe766, .immediate=0, .flags=0x00, .name = "WE766" },
  { .ov = 35, .code = 0x224c, .word = 0xe7b4, .immediate=0, .flags=0x00, .name = "WE7B4" },
  { .ov = 35, .code = 0x224c, .word = 0xe7fe, .immediate=0, .flags=0x00, .name = "WE7FE" },
  { .ov = 35, .code = 0x224c, .word = 0xe84e, .immediate=0, .flags=0x00, .name = "WE84E" },
  { .ov = 35, .code = 0x224c, .word = 0xe864, .immediate=0, .flags=0x00, .name = "WE864" },
  { .ov = 35, .code = 0x224c, .word = 0xe89c, .immediate=0, .flags=0x00, .name = "WE89C" },
  { .ov = 35, .code = 0x224c, .word = 0xe8e6, .immediate=0, .flags=0x00, .name = "WE8E6" },
  { .ov = 35, .code = 0x224c, .word = 0xe94a, .immediate=0, .flags=0x00, .name = "WE94A" },
  { .ov = 35, .code = 0x224c, .word = 0xe952, .immediate=0, .flags=0x00, .name = "WE952" },
  { .ov = 35, .code = 0x224c, .word = 0xe9e0, .immediate=0, .flags=0x00, .name = "WE9E0" },
  { .ov = 35, .code = 0x224c, .word = 0xea04, .immediate=0, .flags=0x00, .name = "WEA04" },
  { .ov = 35, .code = 0x224c, .word = 0xea3a, .immediate=0, .flags=0x00, .name = "WEA3A" },
  { .ov = 35, .code = 0x224c, .word = 0xea52, .immediate=0, .flags=0x00, .name = "WEA52" },
  { .ov = 35, .code = 0x224c, .word = 0xea7c, .immediate=0, .flags=0x00, .name = "WEA7C" },
  { .ov = 35, .code = 0x224c, .word = 0xea8c, .immediate=0, .flags=0x00, .name = "WEA8C" },
  { .ov = 35, .code = 0x224c, .word = 0xead0, .immediate=0, .flags=0x00, .name = "WEAD0" },
  { .ov = 35, .code = 0x224c, .word = 0xeaf0, .immediate=0, .flags=0x00, .name = "WEAF0" },
  { .ov = 35, .code = 0x224c, .word = 0xeb47, .immediate=0, .flags=0x00, .name = "WEB47" },
  { .ov = 35, .code = 0x224c, .word = 0xeb85, .immediate=0, .flags=0x00, .name = "WEB85" },
  { .ov = 35, .code = 0x224c, .word = 0xebc7, .immediate=0, .flags=0x00, .name = "WEBC7" },
  { .ov = 35, .code = 0x224c, .word = 0xec0f, .immediate=0, .flags=0x00, .name = "WEC0F" },
  { .ov = 35, .code = 0x224c, .word = 0xec3c, .immediate=0, .flags=0x00, .name = "WEC3C" },
  { .ov = 35, .code = 0x224c, .word = 0xec70, .immediate=0, .flags=0x80, .name = "NOMAP" },
  { .ov = 35, .code = 0x224c, .word = 0xec84, .immediate=0, .flags=0x00, .name = "WEC84" },
  { .ov = 35, .code = 0x224c, .word = 0xecaa, .immediate=0, .flags=0x00, .name = "WECAA" },
  { .ov = 35, .code = 0x1d29, .word = 0xecf0, .immediate=0, .flags=0x00, .name = "WECF0" },
  { .ov = 35, .code = 0x1d29, .word = 0xed01, .immediate=0, .flags=0x80, .name = "FLUX-ARRAY" },
  { .ov = 35, .code = 0x224c, .word = 0xed7d, .immediate=0, .flags=0x00, .name = "WED7D" },
  { .ov = 35, .code = 0x224c, .word = 0xed8b, .immediate=0, .flags=0x00, .name = "WED8B" },
  { .ov = 35, .code = 0x224c, .word = 0xed93, .immediate=0, .flags=0x00, .name = "WED93" },
  { .ov = 35, .code = 0x224c, .word = 0xed9b, .immediate=0, .flags=0x00, .name = "WED9B" },
  { .ov = 35, .code = 0x224c, .word = 0xeda5, .immediate=0, .flags=0x00, .name = "WEDA5" },
  { .ov = 35, .code = 0x224c, .word = 0xedaf, .immediate=0, .flags=0x00, .name = "WEDAF" },
  { .ov = 35, .code = 0x224c, .word = 0xedb7, .immediate=0, .flags=0x00, .name = "WEDB7" },
  { .ov = 35, .code = 0x224c, .word = 0xedd5, .immediate=0, .flags=0x00, .name = "WEDD5" },
  { .ov = 35, .code = 0x224c, .word = 0xede9, .immediate=0, .flags=0x00, .name = "WEDE9" },
  { .ov = 35, .code = 0x224c, .word = 0xee03, .immediate=0, .flags=0x00, .name = "WEE03" },
  { .ov = 35, .code = 0x224c, .word = 0xee1b, .immediate=0, .flags=0x00, .name = "WEE1B" },
  { .ov = 35, .code = 0x224c, .word = 0xee27, .immediate=0, .flags=0x00, .name = "WEE27" },
  { .ov = 35, .code = 0x224c, .word = 0xee3f, .immediate=0, .flags=0x00, .name = "WEE3F" },
  { .ov = 35, .code = 0x224c, .word = 0xee51, .immediate=0, .flags=0x00, .name = "WEE51" },
  { .ov = 35, .code = 0x224c, .word = 0xeead, .immediate=0, .flags=0x00, .name = "WEEAD" },
  { .ov = 35, .code = 0x224c, .word = 0xeeb7, .immediate=0, .flags=0x00, .name = "WEEB7" },
  { .ov = 35, .code = 0x224c, .word = 0xeed1, .immediate=0, .flags=0x00, .name = "WEED1" },
  { .ov = 35, .code = 0x224c, .word = 0xeeeb, .immediate=0, .flags=0x00, .name = "WEEEB" },
  { .ov = 35, .code = 0x224c, .word = 0xef29, .immediate=0, .flags=0x00, .name = "WEF29" },
  { .ov = 35, .code = 0x224c, .word = 0xef86, .immediate=0, .flags=0x80, .name = "DO-TMAPS" },
  { .ov = 35, .code = 0x224c, .word = 0xefe2, .immediate=0, .flags=0x00, .name = "WEFE2" },
  { .ov = 35, .code = 0x224c, .word = 0xefee, .immediate=0, .flags=0x00, .name = "WEFEE" },
  { .ov = 35, .code = 0x224c, .word = 0xeff6, .immediate=0, .flags=0x00, .name = "WEFF6" },
  { .ov = 35, .code = 0x224c, .word = 0xf008, .immediate=0, .flags=0x00, .name = "WF008" },
  { .ov = 35, .code = 0x224c, .word = 0xf01a, .immediate=0, .flags=0x00, .name = "WF01A" },
  { .ov = 35, .code = 0x4b3b, .word = 0xf04b, .immediate=0, .flags=0x80, .name = "KEY>ACTION" },
  { .ov = 35, .code = 0x224c, .word = 0xf05d, .immediate=0, .flags=0x00, .name = "WF05D" },
  { .ov = 35, .code = 0x224c, .word = 0xf085, .immediate=0, .flags=0x00, .name = "WF085" },
  { .ov = 35, .code = 0x224c, .word = 0xf11b, .immediate=0, .flags=0x00, .name = "WF11B" },
  { .ov = 35, .code = 0x224c, .word = 0xf131, .immediate=0, .flags=0x00, .name = "WF131" },
  { .ov = 35, .code = 0x224c, .word = 0xf160, .immediate=0, .flags=0x80, .name = "(/STARMAP)" },
  { .ov = 36, .code = 0x224c, .word = 0xd996, .immediate=0, .flags=0x00, .name = "WD996" },
  { .ov = 36, .code = 0x224c, .word = 0xd9a0, .immediate=0, .flags=0x00, .name = "WD9A0" },
  { .ov = 36, .code = 0x224c, .word = 0xd9a8, .immediate=0, .flags=0x00, .name = "WD9A8" },
  { .ov = 36, .code = 0x224c, .word = 0xd9b0, .immediate=0, .flags=0x00, .name = "WD9B0" },
  { .ov = 36, .code = 0x224c, .word = 0xd9b8, .immediate=0, .flags=0x00, .name = "WD9B8" },
  { .ov = 36, .code = 0x224c, .word = 0xd9c0, .immediate=0, .flags=0x00, .name = "WD9C0" },
  { .ov = 36, .code = 0x224c, .word = 0xd9c8, .immediate=0, .flags=0x00, .name = "WD9C8" },
  { .ov = 36, .code = 0x2214, .word = 0xd9d0, .immediate=0, .flags=0x00, .name = "WD9D0" },
  { .ov = 36, .code = 0x2214, .word = 0xd9d4, .immediate=0, .flags=0x00, .name = "WD9D4" },
  { .ov = 36, .code = 0x2214, .word = 0xd9d8, .immediate=0, .flags=0x00, .name = "WD9D8" },
  { .ov = 36, .code = 0x2214, .word = 0xd9dc, .immediate=0, .flags=0x00, .name = "WD9DC" },
  { .ov = 36, .code = 0x2214, .word = 0xd9e0, .immediate=0, .flags=0x00, .name = "WD9E0" },
  { .ov = 36, .code = 0x2214, .word = 0xd9e4, .immediate=0, .flags=0x00, .name = "WD9E4" },
  { .ov = 36, .code = 0x2214, .word = 0xd9e8, .immediate=0, .flags=0x00, .name = "WD9E8" },
  { .ov = 36, .code = 0x2214, .word = 0xd9ec, .immediate=0, .flags=0x00, .name = "WD9EC" },
  { .ov = 36, .code = 0x2214, .word = 0xd9f0, .immediate=0, .flags=0x00, .name = "WD9F0" },
  { .ov = 36, .code = 0x2214, .word = 0xd9f4, .immediate=0, .flags=0x00, .name = "WD9F4" },
  { .ov = 36, .code = 0x2214, .word = 0xd9f8, .immediate=0, .flags=0x00, .name = "WD9F8" },
  { .ov = 36, .code = 0x1d29, .word = 0xd9fc, .immediate=0, .flags=0x00, .name = "WD9FC" },
  { .ov = 36, .code = 0x1d29, .word = 0xda00, .immediate=0, .flags=0x00, .name = "WDA00" },
  { .ov = 36, .code = 0x1d29, .word = 0xda04, .immediate=0, .flags=0x00, .name = "WDA04" },
  { .ov = 36, .code = 0x1d29, .word = 0xda08, .immediate=0, .flags=0x00, .name = "WDA08" },
  { .ov = 36, .code = 0x1d29, .word = 0xda0c, .immediate=0, .flags=0x00, .name = "WDA0C" },
  { .ov = 36, .code = 0x1d29, .word = 0xda10, .immediate=0, .flags=0x00, .name = "WDA10" },
  { .ov = 36, .code = 0x1d29, .word = 0xda14, .immediate=0, .flags=0x00, .name = "WDA14" },
  { .ov = 36, .code = 0x1d29, .word = 0xda1a, .immediate=0, .flags=0x00, .name = "WDA1A" },
  { .ov = 36, .code = 0x1d29, .word = 0xda1e, .immediate=0, .flags=0x00, .name = "WDA1E" },
  { .ov = 36, .code = 0x1d29, .word = 0xda22, .immediate=0, .flags=0x00, .name = "WDA22" },
  { .ov = 36, .code = 0x1d29, .word = 0xda26, .immediate=0, .flags=0x00, .name = "WDA26" },
  { .ov = 36, .code = 0x1d29, .word = 0xda2a, .immediate=0, .flags=0x00, .name = "WDA2A" },
  { .ov = 36, .code = 0x1d29, .word = 0xda2e, .immediate=0, .flags=0x00, .name = "WDA2E" },
  { .ov = 36, .code = 0x7420, .word = 0xda32, .immediate=0, .flags=0x00, .name = "WDA32" },
  { .ov = 36, .code = 0x7420, .word = 0xda37, .immediate=0, .flags=0x00, .name = "WDA37" },
  { .ov = 36, .code = 0x7420, .word = 0xda3c, .immediate=0, .flags=0x00, .name = "WDA3C" },
  { .ov = 36, .code = 0x7420, .word = 0xda41, .immediate=0, .flags=0x00, .name = "WDA41" },
  { .ov = 36, .code = 0x7420, .word = 0xda46, .immediate=0, .flags=0x00, .name = "WDA46" },
  { .ov = 36, .code = 0x7420, .word = 0xda4b, .immediate=0, .flags=0x00, .name = "WDA4B" },
  { .ov = 36, .code = 0x7420, .word = 0xda50, .immediate=0, .flags=0x00, .name = "WDA50" },
  { .ov = 36, .code = 0x7420, .word = 0xda55, .immediate=0, .flags=0x00, .name = "WDA55" },
  { .ov = 36, .code = 0x7420, .word = 0xda5a, .immediate=0, .flags=0x00, .name = "WDA5A" },
  { .ov = 36, .code = 0x7420, .word = 0xda5f, .immediate=0, .flags=0x00, .name = "WDA5F" },
  { .ov = 36, .code = 0x7420, .word = 0xda64, .immediate=0, .flags=0x00, .name = "WDA64" },
  { .ov = 36, .code = 0x7420, .word = 0xda69, .immediate=0, .flags=0x00, .name = "WDA69" },
  { .ov = 36, .code = 0x7420, .word = 0xda6e, .immediate=0, .flags=0x00, .name = "WDA6E" },
  { .ov = 36, .code = 0x7394, .word = 0xda73, .immediate=0, .flags=0x00, .name = "WDA73" },
  { .ov = 36, .code = 0x7420, .word = 0xda7b, .immediate=0, .flags=0x00, .name = "WDA7B" },
  { .ov = 36, .code = 0x7420, .word = 0xda80, .immediate=0, .flags=0x00, .name = "WDA80" },
  { .ov = 36, .code = 0x7420, .word = 0xda85, .immediate=0, .flags=0x00, .name = "WDA85" },
  { .ov = 36, .code = 0x7420, .word = 0xda8a, .immediate=0, .flags=0x00, .name = "WDA8A" },
  { .ov = 36, .code = 0x7420, .word = 0xda8f, .immediate=0, .flags=0x00, .name = "WDA8F" },
  { .ov = 36, .code = 0x224c, .word = 0xda94, .immediate=0, .flags=0x00, .name = "WDA94" },
  { .ov = 36, .code = 0x224c, .word = 0xda9e, .immediate=0, .flags=0x00, .name = "WDA9E" },
  { .ov = 36, .code = 0x224c, .word = 0xdaa8, .immediate=0, .flags=0x00, .name = "WDAA8" },
  { .ov = 36, .code = 0x224c, .word = 0xdab4, .immediate=0, .flags=0x00, .name = "WDAB4" },
  { .ov = 36, .code = 0x224c, .word = 0xdac0, .immediate=0, .flags=0x00, .name = "WDAC0" },
  { .ov = 36, .code = 0x224c, .word = 0xdaca, .immediate=0, .flags=0x00, .name = "WDACA" },
  { .ov = 36, .code = 0x224c, .word = 0xdad2, .immediate=0, .flags=0x00, .name = "WDAD2" },
  { .ov = 36, .code = 0x224c, .word = 0xdadc, .immediate=0, .flags=0x00, .name = "WDADC" },
  { .ov = 36, .code = 0x224c, .word = 0xdae8, .immediate=0, .flags=0x00, .name = "WDAE8" },
  { .ov = 36, .code = 0x224c, .word = 0xdaf2, .immediate=0, .flags=0x00, .name = "WDAF2" },
  { .ov = 36, .code = 0x224c, .word = 0xdb00, .immediate=0, .flags=0x00, .name = "WDB00" },
  { .ov = 36, .code = 0x224c, .word = 0xdb0c, .immediate=0, .flags=0x00, .name = "WDB0C" },
  { .ov = 36, .code = 0x224c, .word = 0xdb1c, .immediate=0, .flags=0x00, .name = "WDB1C" },
  { .ov = 36, .code = 0x224c, .word = 0xdb26, .immediate=0, .flags=0x00, .name = "WDB26" },
  { .ov = 36, .code = 0x224c, .word = 0xdb54, .immediate=0, .flags=0x00, .name = "WDB54" },
  { .ov = 36, .code = 0x224c, .word = 0xdb7e, .immediate=0, .flags=0x00, .name = "WDB7E" },
  { .ov = 36, .code = 0x7420, .word = 0xdbde, .immediate=0, .flags=0x00, .name = "WDBDE" },
  { .ov = 36, .code = 0x7420, .word = 0xdbe3, .immediate=0, .flags=0x00, .name = "WDBE3" },
  { .ov = 36, .code = 0x7420, .word = 0xdbe8, .immediate=0, .flags=0x00, .name = "WDBE8" },
  { .ov = 36, .code = 0x7420, .word = 0xdbed, .immediate=0, .flags=0x00, .name = "WDBED" },
  { .ov = 36, .code = 0x7420, .word = 0xdbf2, .immediate=0, .flags=0x00, .name = "WDBF2" },
  { .ov = 36, .code = 0x224c, .word = 0xdbf7, .immediate=0, .flags=0x00, .name = "WDBF7" },
  { .ov = 36, .code = 0x224c, .word = 0xdc25, .immediate=0, .flags=0x00, .name = "WDC25" },
  { .ov = 36, .code = 0x224c, .word = 0xdc43, .immediate=0, .flags=0x00, .name = "WDC43" },
  { .ov = 36, .code = 0x224c, .word = 0xdc71, .immediate=0, .flags=0x00, .name = "WDC71" },
  { .ov = 36, .code = 0x4b3b, .word = 0xdcae, .immediate=0, .flags=0x80, .name = "PS>C" },
  { .ov = 36, .code = 0x224c, .word = 0xdcc8, .immediate=0, .flags=0x00, .name = "WDCC8" },
  { .ov = 36, .code = 0x224c, .word = 0xdcf2, .immediate=0, .flags=0x00, .name = "WDCF2" },
  { .ov = 36, .code = 0x224c, .word = 0xdd30, .immediate=0, .flags=0x00, .name = "WDD30" },
  { .ov = 36, .code = 0x224c, .word = 0xdd58, .immediate=0, .flags=0x00, .name = "WDD58" },
  { .ov = 36, .code = 0x224c, .word = 0xdd7e, .immediate=0, .flags=0x00, .name = "WDD7E" },
  { .ov = 36, .code = 0x224c, .word = 0xddae, .immediate=0, .flags=0x00, .name = "WDDAE" },
  { .ov = 36, .code = 0x224c, .word = 0xde14, .immediate=0, .flags=0x00, .name = "WDE14" },
  { .ov = 36, .code = 0x224c, .word = 0xde6e, .immediate=0, .flags=0x00, .name = "WDE6E" },
  { .ov = 36, .code = 0x224c, .word = 0xde8a, .immediate=0, .flags=0x00, .name = "WDE8A" },
  { .ov = 36, .code = 0x224c, .word = 0xdea0, .immediate=0, .flags=0x00, .name = "WDEA0" },
  { .ov = 36, .code = 0x224c, .word = 0xdec0, .immediate=0, .flags=0x00, .name = "WDEC0" },
  { .ov = 36, .code = 0x224c, .word = 0xded8, .immediate=0, .flags=0x00, .name = "WDED8" },
  { .ov = 36, .code = 0x224c, .word = 0xdee2, .immediate=0, .flags=0x00, .name = "WDEE2" },
  { .ov = 36, .code = 0x224c, .word = 0xdeec, .immediate=0, .flags=0x00, .name = "WDEEC" },
  { .ov = 36, .code = 0x224c, .word = 0xdef6, .immediate=0, .flags=0x00, .name = "WDEF6" },
  { .ov = 36, .code = 0x224c, .word = 0xdf14, .immediate=0, .flags=0x00, .name = "WDF14" },
  { .ov = 36, .code = 0x224c, .word = 0xdf66, .immediate=0, .flags=0x00, .name = "WDF66" },
  { .ov = 36, .code = 0x4b3b, .word = 0xdf84, .immediate=0, .flags=0x80, .name = ">XY" },
  { .ov = 36, .code = 0x224c, .word = 0xdf92, .immediate=0, .flags=0x00, .name = "WDF92" },
  { .ov = 36, .code = 0x4b3b, .word = 0xdfb7, .immediate=0, .flags=0x80, .name = "SC>C" },
  { .ov = 36, .code = 0x224c, .word = 0xdfd5, .immediate=0, .flags=0x00, .name = "WDFD5" },
  { .ov = 36, .code = 0x224c, .word = 0xdfe9, .immediate=0, .flags=0x00, .name = "WDFE9" },
  { .ov = 36, .code = 0x224c, .word = 0xe055, .immediate=0, .flags=0x80, .name = ".AUXSYS" },
  { .ov = 36, .code = 0x224c, .word = 0xe0b7, .immediate=0, .flags=0x00, .name = "WE0B7" },
  { .ov = 36, .code = 0x224c, .word = 0xe0d9, .immediate=0, .flags=0x00, .name = "WE0D9" },
  { .ov = 36, .code = 0x224c, .word = 0xe0fd, .immediate=0, .flags=0x00, .name = "WE0FD" },
  { .ov = 36, .code = 0x224c, .word = 0xe149, .immediate=0, .flags=0x00, .name = "WE149" },
  { .ov = 36, .code = 0x224c, .word = 0xe157, .immediate=0, .flags=0x00, .name = "WE157" },
  { .ov = 36, .code = 0x224c, .word = 0xe173, .immediate=0, .flags=0x00, .name = "WE173" },
  { .ov = 36, .code = 0x224c, .word = 0xe17b, .immediate=0, .flags=0x00, .name = "WE17B" },
  { .ov = 36, .code = 0x4b3b, .word = 0xe18f, .immediate=0, .flags=0x80, .name = "RADII" },
  { .ov = 36, .code = 0x4b3b, .word = 0xe1ac, .immediate=0, .flags=0x80, .name = "IVAR" },
  { .ov = 36, .code = 0x224c, .word = 0xe1c2, .immediate=0, .flags=0x00, .name = "WE1C2" },
  { .ov = 36, .code = 0x224c, .word = 0xe1e2, .immediate=0, .flags=0x00, .name = "WE1E2" },
  { .ov = 36, .code = 0x224c, .word = 0xe1fa, .immediate=0, .flags=0x00, .name = "WE1FA" },
  { .ov = 36, .code = 0x224c, .word = 0xe200, .immediate=0, .flags=0x00, .name = "WE200" },
  { .ov = 36, .code = 0x224c, .word = 0xe20a, .immediate=0, .flags=0x00, .name = "WE20A" },
  { .ov = 36, .code = 0x4b3b, .word = 0xe22d, .immediate=0, .flags=0x80, .name = "XYCASE" },
  { .ov = 36, .code = 0x224c, .word = 0xe23b, .immediate=0, .flags=0x00, .name = "WE23B" },
  { .ov = 36, .code = 0x2214, .word = 0xe2ad, .immediate=0, .flags=0x00, .name = "WE2AD" },
  { .ov = 36, .code = 0x2214, .word = 0xe2b1, .immediate=0, .flags=0x00, .name = "WE2B1" },
  { .ov = 36, .code = 0x2214, .word = 0xe2b5, .immediate=0, .flags=0x00, .name = "WE2B5" },
  { .ov = 36, .code = 0x2214, .word = 0xe2b9, .immediate=0, .flags=0x00, .name = "WE2B9" },
  { .ov = 36, .code = 0x1d29, .word = 0xe2bd, .immediate=0, .flags=0x00, .name = "WE2BD" },
  { .ov = 36, .code = 0x224c, .word = 0xe2d7, .immediate=0, .flags=0x00, .name = "WE2D7" },
  { .ov = 36, .code = 0x224c, .word = 0xe303, .immediate=0, .flags=0x00, .name = "WE303" },
  { .ov = 36, .code = 0x224c, .word = 0xe327, .immediate=0, .flags=0x00, .name = "WE327" },
  { .ov = 36, .code = 0x224c, .word = 0xe37b, .immediate=0, .flags=0x00, .name = "WE37B" },
  { .ov = 36, .code = 0x224c, .word = 0xe3a8, .immediate=0, .flags=0x80, .name = ".MVS" },
  { .ov = 36, .code = 0x224c, .word = 0xe3f6, .immediate=0, .flags=0x00, .name = "WE3F6" },
  { .ov = 36, .code = 0x224c, .word = 0xe466, .immediate=0, .flags=0x00, .name = "WE466" },
  { .ov = 36, .code = 0x224c, .word = 0xe4a6, .immediate=0, .flags=0x00, .name = "WE4A6" },
  { .ov = 36, .code = 0x224c, .word = 0xe516, .immediate=0, .flags=0x00, .name = "WE516" },
  { .ov = 36, .code = 0x224c, .word = 0xe526, .immediate=0, .flags=0x00, .name = "WE526" },
  { .ov = 36, .code = 0x224c, .word = 0xe544, .immediate=0, .flags=0x00, .name = "WE544" },
  { .ov = 36, .code = 0x224c, .word = 0xe554, .immediate=0, .flags=0x00, .name = "WE554" },
  { .ov = 36, .code = 0x224c, .word = 0xe5a4, .immediate=0, .flags=0x00, .name = "WE5A4" },
  { .ov = 36, .code = 0x1d29, .word = 0xe614, .immediate=0, .flags=0x00, .name = "WE614" },
  { .ov = 36, .code = 0x224c, .word = 0xe626, .immediate=0, .flags=0x00, .name = "WE626" },
  { .ov = 36, .code = 0x224c, .word = 0xe63a, .immediate=0, .flags=0x00, .name = "WE63A" },
  { .ov = 36, .code = 0x224c, .word = 0xe656, .immediate=0, .flags=0x00, .name = "WE656" },
  { .ov = 36, .code = 0x224c, .word = 0xe674, .immediate=0, .flags=0x00, .name = "WE674" },
  { .ov = 36, .code = 0x224c, .word = 0xe69a, .immediate=0, .flags=0x00, .name = "WE69A" },
  { .ov = 36, .code = 0x224c, .word = 0xe6ae, .immediate=0, .flags=0x00, .name = "WE6AE" },
  { .ov = 36, .code = 0x224c, .word = 0xe6de, .immediate=0, .flags=0x00, .name = "WE6DE" },
  { .ov = 36, .code = 0x224c, .word = 0xe6f8, .immediate=0, .flags=0x00, .name = "WE6F8" },
  { .ov = 36, .code = 0x224c, .word = 0xe7b0, .immediate=0, .flags=0x00, .name = "WE7B0" },
  { .ov = 36, .code = 0x224c, .word = 0xe7cc, .immediate=0, .flags=0x80, .name = "USE-E" },
  { .ov = 36, .code = 0x224c, .word = 0xe822, .immediate=0, .flags=0x00, .name = "WE822" },
  { .ov = 36, .code = 0x224c, .word = 0xe83e, .immediate=0, .flags=0x00, .name = "WE83E" },
  { .ov = 36, .code = 0x224c, .word = 0xe874, .immediate=0, .flags=0x00, .name = "WE874" },
  { .ov = 36, .code = 0x224c, .word = 0xe882, .immediate=0, .flags=0x00, .name = "WE882" },
  { .ov = 36, .code = 0x2214, .word = 0xe896, .immediate=0, .flags=0x00, .name = "WE896" },
  { .ov = 36, .code = 0x4b3b, .word = 0xe8a3, .immediate=0, .flags=0x80, .name = "CSPEED" },
  { .ov = 36, .code = 0x1d29, .word = 0xe8b8, .immediate=0, .flags=0x80, .name = "#ACC" },
  { .ov = 36, .code = 0x1d29, .word = 0xe8c5, .immediate=0, .flags=0x80, .name = "KEYINC" },
  { .ov = 36, .code = 0x224c, .word = 0xe8c9, .immediate=0, .flags=0x00, .name = "WE8C9" },
  { .ov = 36, .code = 0x224c, .word = 0xe8df, .immediate=0, .flags=0x00, .name = "WE8DF" },
  { .ov = 36, .code = 0x224c, .word = 0xe905, .immediate=0, .flags=0x00, .name = "WE905" },
  { .ov = 36, .code = 0x224c, .word = 0xe941, .immediate=0, .flags=0x00, .name = "WE941" },
  { .ov = 36, .code = 0x224c, .word = 0xe959, .immediate=0, .flags=0x00, .name = "WE959" },
  { .ov = 36, .code = 0x224c, .word = 0xe977, .immediate=0, .flags=0x00, .name = "WE977" },
  { .ov = 36, .code = 0x224c, .word = 0xe98d, .immediate=0, .flags=0x00, .name = "WE98D" },
  { .ov = 36, .code = 0x4b3b, .word = 0xe9a5, .immediate=0, .flags=0x80, .name = "?~C" },
  { .ov = 36, .code = 0x224c, .word = 0xe9b7, .immediate=0, .flags=0x00, .name = "WE9B7" },
  { .ov = 36, .code = 0x4b3b, .word = 0xe9db, .immediate=0, .flags=0x80, .name = "NEST-SE" },
  { .ov = 36, .code = 0x224c, .word = 0xe9f1, .immediate=0, .flags=0x00, .name = "WE9F1" },
  { .ov = 36, .code = 0x224c, .word = 0xea26, .immediate=0, .flags=0x80, .name = "NEST" },
  { .ov = 36, .code = 0x224c, .word = 0xea94, .immediate=0, .flags=0x00, .name = "WEA94" },
  { .ov = 36, .code = 0x224c, .word = 0xeab8, .immediate=0, .flags=0x00, .name = "WEAB8" },
  { .ov = 36, .code = 0x224c, .word = 0xeada, .immediate=0, .flags=0x00, .name = "WEADA" },
  { .ov = 36, .code = 0x224c, .word = 0xeafe, .immediate=0, .flags=0x00, .name = "WEAFE" },
  { .ov = 36, .code = 0x224c, .word = 0xeb1a, .immediate=0, .flags=0x00, .name = "WEB1A" },
  { .ov = 36, .code = 0x224c, .word = 0xeb59, .immediate=0, .flags=0x80, .name = "JMPSHP" },
  { .ov = 36, .code = 0x224c, .word = 0xeb7b, .immediate=0, .flags=0x00, .name = "WEB7B" },
  { .ov = 36, .code = 0x224c, .word = 0xeba7, .immediate=0, .flags=0x00, .name = "WEBA7" },
  { .ov = 36, .code = 0x4b3b, .word = 0xebbd, .immediate=0, .flags=0x80, .name = "COLLIDE" },
  { .ov = 36, .code = 0x224c, .word = 0xebdb, .immediate=0, .flags=0x00, .name = "WEBDB" },
  { .ov = 36, .code = 0x224c, .word = 0xec81, .immediate=0, .flags=0x00, .name = "WEC81" },
  { .ov = 36, .code = 0x224c, .word = 0xeca5, .immediate=0, .flags=0x00, .name = "WECA5" },
  { .ov = 36, .code = 0x224c, .word = 0xecc1, .immediate=0, .flags=0x00, .name = "WECC1" },
  { .ov = 36, .code = 0x224c, .word = 0xed11, .immediate=0, .flags=0x00, .name = "WED11" },
  { .ov = 36, .code = 0x4b3b, .word = 0xed7e, .immediate=0, .flags=0x80, .name = "UNNEST-" },
  { .ov = 36, .code = 0x224c, .word = 0xed94, .immediate=0, .flags=0x00, .name = "WED94" },
  { .ov = 36, .code = 0x224c, .word = 0xedb8, .immediate=0, .flags=0x00, .name = "WEDB8" },
  { .ov = 36, .code = 0x224c, .word = 0xee14, .immediate=0, .flags=0x00, .name = "WEE14" },
  { .ov = 36, .code = 0x224c, .word = 0xee45, .immediate=0, .flags=0x80, .name = "UNNEST" },
  { .ov = 36, .code = 0x224c, .word = 0xeebb, .immediate=0, .flags=0x00, .name = "WEEBB" },
  { .ov = 36, .code = 0x224c, .word = 0xeeef, .immediate=0, .flags=0x80, .name = "(GET-AU" },
  { .ov = 36, .code = 0x224c, .word = 0xef03, .immediate=0, .flags=0x00, .name = "WEF03" },
  { .ov = 36, .code = 0x224c, .word = 0xef35, .immediate=0, .flags=0x00, .name = "WEF35" },
  { .ov = 36, .code = 0x224c, .word = 0xef63, .immediate=0, .flags=0x80, .name = "FLY" },
  { .ov = 36, .code = 0x224c, .word = 0xef89, .immediate=0, .flags=0x00, .name = "WEF89" },
  { .ov = 36, .code = 0x224c, .word = 0xefaf, .immediate=0, .flags=0x80, .name = "SET-DES" },
  { .ov = 36, .code = 0x224c, .word = 0xf069, .immediate=0, .flags=0x80, .name = "SETUP-M" },
  { .ov = 36, .code = 0x224c, .word = 0xf103, .immediate=0, .flags=0x80, .name = "CLEANUP" },
  { .ov = 36, .code = 0x224c, .word = 0xf189, .immediate=0, .flags=0x80, .name = "CHK-MOV" },
  { .ov = 36, .code = 0x224c, .word = 0xf219, .immediate=0, .flags=0x00, .name = "WF219" },
  { .ov = 36, .code = 0x224c, .word = 0xf252, .immediate=0, .flags=0x80, .name = "+NEST" },
  { .ov = 36, .code = 0x224c, .word = 0xf268, .immediate=0, .flags=0x80, .name = "COME-HI" },
  { .ov = 37, .code = 0x7420, .word = 0xec66, .immediate=0, .flags=0x00, .name = "WEC66" },
  { .ov = 37, .code = 0x7420, .word = 0xec6b, .immediate=0, .flags=0x00, .name = "WEC6B" },
  { .ov = 37, .code = 0x7420, .word = 0xec70, .immediate=0, .flags=0x00, .name = "WEC70" },
  { .ov = 37, .code = 0x7394, .word = 0xec75, .immediate=0, .flags=0x00, .name = "WEC75" },
  { .ov = 37, .code = 0x7394, .word = 0xec7d, .immediate=0, .flags=0x00, .name = "WEC7D" },
  { .ov = 37, .code = 0x7420, .word = 0xec85, .immediate=0, .flags=0x00, .name = "WEC85" },
  { .ov = 37, .code = 0x7394, .word = 0xec8a, .immediate=0, .flags=0x00, .name = "WEC8A" },
  { .ov = 37, .code = 0x7394, .word = 0xec92, .immediate=0, .flags=0x00, .name = "WEC92" },
  { .ov = 37, .code = 0x7394, .word = 0xec9a, .immediate=0, .flags=0x00, .name = "WEC9A" },
  { .ov = 37, .code = 0x7394, .word = 0xeca2, .immediate=0, .flags=0x00, .name = "WECA2" },
  { .ov = 37, .code = 0x7394, .word = 0xecaa, .immediate=0, .flags=0x00, .name = "WECAA" },
  { .ov = 37, .code = 0x7420, .word = 0xecb2, .immediate=0, .flags=0x00, .name = "WECB2" },
  { .ov = 37, .code = 0x7394, .word = 0xecb7, .immediate=0, .flags=0x00, .name = "WECB7" },
  { .ov = 37, .code = 0x7394, .word = 0xecbf, .immediate=0, .flags=0x00, .name = "WECBF" },
  { .ov = 37, .code = 0x7394, .word = 0xecc7, .immediate=0, .flags=0x00, .name = "WECC7" },
  { .ov = 37, .code = 0x7394, .word = 0xeccf, .immediate=0, .flags=0x00, .name = "WECCF" },
  { .ov = 37, .code = 0x7394, .word = 0xecd7, .immediate=0, .flags=0x00, .name = "WECD7" },
  { .ov = 37, .code = 0x7394, .word = 0xecdf, .immediate=0, .flags=0x00, .name = "WECDF" },
  { .ov = 37, .code = 0x7394, .word = 0xece7, .immediate=0, .flags=0x00, .name = "WECE7" },
  { .ov = 37, .code = 0x224c, .word = 0xecef, .immediate=0, .flags=0x00, .name = "WECEF" },
  { .ov = 37, .code = 0x224c, .word = 0xecfc, .immediate=0, .flags=0x00, .name = "WECFC" },
  { .ov = 37, .code = 0x224c, .word = 0xed09, .immediate=0, .flags=0x00, .name = "WED09" },
  { .ov = 37, .code = 0x4b3b, .word = 0xed22, .immediate=0, .flags=0x80, .name = "(.VESSEL)" },
  { .ov = 37, .code = 0x224c, .word = 0xed38, .immediate=0, .flags=0x00, .name = "WED38" },
  { .ov = 37, .code = 0x224c, .word = 0xed40, .immediate=0, .flags=0x00, .name = "WED40" },
  { .ov = 37, .code = 0x224c, .word = 0xed4d, .immediate=0, .flags=0x00, .name = "WED4D" },
  { .ov = 37, .code = 0x224c, .word = 0xed5a, .immediate=0, .flags=0x00, .name = "WED5A" },
  { .ov = 37, .code = 0x4b3b, .word = 0xed85, .immediate=0, .flags=0x80, .name = "(.OBJECT)" },
  { .ov = 37, .code = 0x224c, .word = 0xed9f, .immediate=0, .flags=0x00, .name = "WED9F" },
  { .ov = 37, .code = 0x224c, .word = 0xedee, .immediate=0, .flags=0x00, .name = "WEDEE" },
  { .ov = 37, .code = 0x224c, .word = 0xee04, .immediate=0, .flags=0x00, .name = "WEE04" },
  { .ov = 37, .code = 0x224c, .word = 0xee5b, .immediate=0, .flags=0x00, .name = "WEE5B" },
  { .ov = 37, .code = 0x224c, .word = 0xee9b, .immediate=0, .flags=0x00, .name = "WEE9B" },
  { .ov = 37, .code = 0x224c, .word = 0xeea7, .immediate=0, .flags=0x00, .name = "WEEA7" },
  { .ov = 37, .code = 0x224c, .word = 0xeeb7, .immediate=0, .flags=0x00, .name = "WEEB7" },
  { .ov = 37, .code = 0x224c, .word = 0xeec3, .immediate=0, .flags=0x00, .name = "WEEC3" },
  { .ov = 37, .code = 0x4b3b, .word = 0xeedb, .immediate=0, .flags=0x80, .name = "(.TYPE)" },
  { .ov = 37, .code = 0x224c, .word = 0xeeed, .immediate=0, .flags=0x00, .name = "WEEED" },
  { .ov = 37, .code = 0x224c, .word = 0xef08, .immediate=0, .flags=0x00, .name = "WEF08" },
  { .ov = 37, .code = 0x224c, .word = 0xef13, .immediate=0, .flags=0x00, .name = "WEF13" },
  { .ov = 37, .code = 0x224c, .word = 0xef53, .immediate=0, .flags=0x00, .name = "WEF53" },
  { .ov = 37, .code = 0x224c, .word = 0xeff7, .immediate=0, .flags=0x00, .name = "WEFF7" },
  { .ov = 37, .code = 0x224c, .word = 0xf02c, .immediate=0, .flags=0x00, .name = "WF02C" },
  { .ov = 37, .code = 0x224c, .word = 0xf07e, .immediate=0, .flags=0x00, .name = "WF07E" },
  { .ov = 37, .code = 0x224c, .word = 0xf0a7, .immediate=0, .flags=0x00, .name = "WF0A7" },
  { .ov = 37, .code = 0x224c, .word = 0xf0b5, .immediate=0, .flags=0x00, .name = "WF0B5" },
  { .ov = 37, .code = 0x224c, .word = 0xf0dc, .immediate=0, .flags=0x00, .name = "WF0DC" },
  { .ov = 37, .code = 0x224c, .word = 0xf0e9, .immediate=0, .flags=0x00, .name = "WF0E9" },
  { .ov = 37, .code = 0x224c, .word = 0xf0f6, .immediate=0, .flags=0x00, .name = "WF0F6" },
  { .ov = 37, .code = 0x224c, .word = 0xf106, .immediate=0, .flags=0x00, .name = "WF106" },
  { .ov = 37, .code = 0x224c, .word = 0xf115, .immediate=0, .flags=0x00, .name = "WF115" },
  { .ov = 37, .code = 0x224c, .word = 0xf123, .immediate=0, .flags=0x00, .name = "WF123" },
  { .ov = 37, .code = 0x4b3b, .word = 0xf13a, .immediate=0, .flags=0x80, .name = ".TDESC" },
  { .ov = 37, .code = 0x224c, .word = 0xf158, .immediate=0, .flags=0x00, .name = "WF158" },
  { .ov = 37, .code = 0x224c, .word = 0xf197, .immediate=0, .flags=0x00, .name = "WF197" },
  { .ov = 37, .code = 0x224c, .word = 0xf1a1, .immediate=0, .flags=0x00, .name = "WF1A1" },
  { .ov = 37, .code = 0x224c, .word = 0xf1ae, .immediate=0, .flags=0x00, .name = "WF1AE" },
  { .ov = 37, .code = 0x224c, .word = 0xf1bb, .immediate=0, .flags=0x00, .name = "WF1BB" },
  { .ov = 37, .code = 0x224c, .word = 0xf1c6, .immediate=0, .flags=0x00, .name = "WF1C6" },
  { .ov = 37, .code = 0x4b3b, .word = 0xf1dd, .immediate=0, .flags=0x80, .name = "(.SURF)" },
  { .ov = 37, .code = 0x224c, .word = 0xf1f7, .immediate=0, .flags=0x00, .name = "WF1F7" },
  { .ov = 37, .code = 0x224c, .word = 0xf221, .immediate=0, .flags=0x00, .name = "WF221" },
  { .ov = 37, .code = 0x224c, .word = 0xf283, .immediate=0, .flags=0x00, .name = "WF283" },
  { .ov = 37, .code = 0x224c, .word = 0xf28e, .immediate=0, .flags=0x00, .name = "WF28E" },
  { .ov = 37, .code = 0x224c, .word = 0xf29c, .immediate=0, .flags=0x00, .name = "WF29C" },
  { .ov = 37, .code = 0x224c, .word = 0xf2ab, .immediate=0, .flags=0x00, .name = "WF2AB" },
  { .ov = 37, .code = 0x224c, .word = 0xf2b7, .immediate=0, .flags=0x00, .name = "WF2B7" },
  { .ov = 37, .code = 0x4b3b, .word = 0xf2cf, .immediate=0, .flags=0x80, .name = "(.ATMO)" },
  { .ov = 37, .code = 0x224c, .word = 0xf2e9, .immediate=0, .flags=0x00, .name = "WF2E9" },
  { .ov = 37, .code = 0x224c, .word = 0xf313, .immediate=0, .flags=0x00, .name = "WF313" },
  { .ov = 37, .code = 0x224c, .word = 0xf31e, .immediate=0, .flags=0x00, .name = "WF31E" },
  { .ov = 37, .code = 0x224c, .word = 0xf32d, .immediate=0, .flags=0x00, .name = "WF32D" },
  { .ov = 37, .code = 0x224c, .word = 0xf33b, .immediate=0, .flags=0x00, .name = "WF33B" },
  { .ov = 37, .code = 0x4b3b, .word = 0xf354, .immediate=0, .flags=0x80, .name = "(.WEATH)" },
  { .ov = 37, .code = 0x224c, .word = 0xf36a, .immediate=0, .flags=0x00, .name = "WF36A" },
  { .ov = 37, .code = 0x224c, .word = 0xf38f, .immediate=0, .flags=0x00, .name = "WF38F" },
  { .ov = 37, .code = 0x1d29, .word = 0xf3af, .immediate=0, .flags=0x00, .name = "WF3AF" },
  { .ov = 37, .code = 0x224c, .word = 0xf3b8, .immediate=0, .flags=0x00, .name = "WF3B8" },
  { .ov = 37, .code = 0x224c, .word = 0xf3e2, .immediate=0, .flags=0x00, .name = "WF3E2" },
  { .ov = 37, .code = 0x224c, .word = 0xf414, .immediate=0, .flags=0x00, .name = "WF414" },
  { .ov = 37, .code = 0x224c, .word = 0xf436, .immediate=0, .flags=0x00, .name = "WF436" },
  { .ov = 37, .code = 0x224c, .word = 0xf442, .immediate=0, .flags=0x00, .name = "WF442" },
  { .ov = 37, .code = 0x224c, .word = 0xf448, .immediate=0, .flags=0x00, .name = "WF448" },
  { .ov = 37, .code = 0x224c, .word = 0xf44e, .immediate=0, .flags=0x00, .name = "WF44E" },
  { .ov = 37, .code = 0x4b3b, .word = 0xf467, .immediate=0, .flags=0x80, .name = "(.V/P-OBJ)" },
  { .ov = 37, .code = 0x224c, .word = 0xf475, .immediate=0, .flags=0x00, .name = "WF475" },
  { .ov = 37, .code = 0x224c, .word = 0xf47d, .immediate=0, .flags=0x00, .name = "WF47D" },
  { .ov = 37, .code = 0x224c, .word = 0xf48d, .immediate=0, .flags=0x00, .name = "WF48D" },
  { .ov = 37, .code = 0x4b3b, .word = 0xf4a3, .immediate=0, .flags=0x80, .name = "(.ANALYSIS)" },
  { .ov = 37, .code = 0x224c, .word = 0xf4c7, .immediate=0, .flags=0x80, .name = "(/ANALYSIS)" },
  { .ov = 38, .code = 0x224c, .word = 0xf0a6, .immediate=0, .flags=0x00, .name = "WF0A6" },
  { .ov = 38, .code = 0x224c, .word = 0xf0b4, .immediate=0, .flags=0x00, .name = "WF0B4" },
  { .ov = 38, .code = 0x224c, .word = 0xf0e4, .immediate=0, .flags=0x00, .name = "WF0E4" },
  { .ov = 38, .code = 0x224c, .word = 0xf0fa, .immediate=0, .flags=0x00, .name = "WF0FA" },
  { .ov = 38, .code = 0x224c, .word = 0xf10c, .immediate=0, .flags=0x00, .name = "WF10C" },
  { .ov = 38, .code = 0x224c, .word = 0xf11a, .immediate=0, .flags=0x00, .name = "WF11A" },
  { .ov = 38, .code = 0x224c, .word = 0xf14e, .immediate=0, .flags=0x00, .name = "WF14E" },
  { .ov = 38, .code = 0x224c, .word = 0xf192, .immediate=0, .flags=0x00, .name = "WF192" },
  { .ov = 38, .code = 0x224c, .word = 0xf1a6, .immediate=0, .flags=0x00, .name = "WF1A6" },
  { .ov = 38, .code = 0x224c, .word = 0xf1b6, .immediate=0, .flags=0x00, .name = "WF1B6" },
  { .ov = 38, .code = 0x224c, .word = 0xf1e4, .immediate=0, .flags=0x00, .name = "WF1E4" },
  { .ov = 38, .code = 0x224c, .word = 0xf202, .immediate=0, .flags=0x00, .name = "WF202" },
  { .ov = 38, .code = 0x1d29, .word = 0xf220, .immediate=0, .flags=0x00, .name = "WF220" },
  { .ov = 38, .code = 0x224c, .word = 0xf25f, .immediate=0, .flags=0x80, .name = ".AIRLOCK" },
  { .ov = 38, .code = 0x224c, .word = 0xf306, .immediate=0, .flags=0x00, .name = "WF306" },
  { .ov = 38, .code = 0x224c, .word = 0xf312, .immediate=0, .flags=0x00, .name = "WF312" },
  { .ov = 38, .code = 0x224c, .word = 0xf320, .immediate=0, .flags=0x00, .name = "WF320" },
  { .ov = 38, .code = 0x224c, .word = 0xf32a, .immediate=0, .flags=0x00, .name = "WF32A" },
  { .ov = 38, .code = 0x224c, .word = 0xf390, .immediate=0, .flags=0x00, .name = "WF390" },
  { .ov = 38, .code = 0x224c, .word = 0xf3b7, .immediate=0, .flags=0x00, .name = "WF3B7" },
  { .ov = 38, .code = 0x224c, .word = 0xf417, .immediate=0, .flags=0x80, .name = "&LAUNCH" },
  { .ov = 38, .code = 0x224c, .word = 0xf471, .immediate=0, .flags=0x80, .name = "&RETURN" },
  { .ov = 39, .code = 0x224c, .word = 0xf346, .immediate=0, .flags=0x00, .name = "WF346" },
  { .ov = 39, .code = 0x1d29, .word = 0xf356, .immediate=0, .flags=0x00, .name = "WF356" },
  { .ov = 39, .code = 0x1d29, .word = 0xf38a, .immediate=0, .flags=0x00, .name = "WF38A" },
  { .ov = 39, .code = 0x224c, .word = 0xf38e, .immediate=0, .flags=0x00, .name = "WF38E" },
  { .ov = 39, .code = 0x224c, .word = 0xf3a0, .immediate=0, .flags=0x00, .name = "WF3A0" },
  { .ov = 39, .code = 0x224c, .word = 0xf406, .immediate=0, .flags=0x00, .name = "WF406" },
  { .ov = 39, .code = 0x224c, .word = 0xf420, .immediate=0, .flags=0x00, .name = "WF420" },
  { .ov = 39, .code = 0x224c, .word = 0xf48e, .immediate=0, .flags=0x80, .name = "HYPER-FRAME" },
  { .ov = 39, .code = 0x224c, .word = 0xf4b9, .immediate=0, .flags=0x80, .name = "FLUX" },
  { .ov = 39, .code = 0x224c, .word = 0xf4e5, .immediate=0, .flags=0x00, .name = "WF4E5" },
  { .ov = 39, .code = 0x224c, .word = 0xf514, .immediate=0, .flags=0x80, .name = "JUMPFX" },
  { .ov = 40, .code = 0x1d29, .word = 0xe596, .immediate=0, .flags=0x00, .name = "WE596" },
  { .ov = 40, .code = 0x224c, .word = 0xe59a, .immediate=0, .flags=0x00, .name = "WE59A" },
  { .ov = 40, .code = 0x7420, .word = 0xe5a2, .immediate=0, .flags=0x00, .name = "WE5A2" },
  { .ov = 40, .code = 0x7420, .word = 0xe5a7, .immediate=0, .flags=0x00, .name = "WE5A7" },
  { .ov = 40, .code = 0x7420, .word = 0xe5ac, .immediate=0, .flags=0x00, .name = "WE5AC" },
  { .ov = 40, .code = 0x7420, .word = 0xe5b1, .immediate=0, .flags=0x00, .name = "WE5B1" },
  { .ov = 40, .code = 0x7420, .word = 0xe5b6, .immediate=0, .flags=0x00, .name = "WE5B6" },
  { .ov = 40, .code = 0x7420, .word = 0xe5bb, .immediate=0, .flags=0x00, .name = "WE5BB" },
  { .ov = 40, .code = 0x7420, .word = 0xe5c0, .immediate=0, .flags=0x00, .name = "WE5C0" },
  { .ov = 40, .code = 0x7420, .word = 0xe5c5, .immediate=0, .flags=0x00, .name = "WE5C5" },
  { .ov = 40, .code = 0x224c, .word = 0xe5ca, .immediate=0, .flags=0x00, .name = "WE5CA" },
  { .ov = 40, .code = 0x224c, .word = 0xe5d4, .immediate=0, .flags=0x00, .name = "WE5D4" },
  { .ov = 40, .code = 0x224c, .word = 0xe5ec, .immediate=0, .flags=0x00, .name = "WE5EC" },
  { .ov = 40, .code = 0x224c, .word = 0xe5fe, .immediate=0, .flags=0x00, .name = "WE5FE" },
  { .ov = 40, .code = 0x224c, .word = 0xe625, .immediate=0, .flags=0x00, .name = "WE625" },
  { .ov = 40, .code = 0x1d29, .word = 0xe636, .immediate=0, .flags=0x00, .name = "WE636" },
  { .ov = 40, .code = 0x224c, .word = 0xe672, .immediate=0, .flags=0x00, .name = "WE672" },
  { .ov = 40, .code = 0x224c, .word = 0xe69e, .immediate=0, .flags=0x00, .name = "WE69E" },
  { .ov = 40, .code = 0x1d29, .word = 0xe71c, .immediate=0, .flags=0x00, .name = "WE71C" },
  { .ov = 40, .code = 0x224c, .word = 0xe72b, .immediate=0, .flags=0x00, .name = "WE72B" },
  { .ov = 40, .code = 0x224c, .word = 0xe787, .immediate=0, .flags=0x00, .name = "WE787" },
  { .ov = 40, .code = 0x224c, .word = 0xe7bc, .immediate=0, .flags=0x00, .name = "WE7BC" },
  { .ov = 40, .code = 0x224c, .word = 0xe7ea, .immediate=0, .flags=0x00, .name = "WE7EA" },
  { .ov = 40, .code = 0x224c, .word = 0xe84e, .immediate=0, .flags=0x00, .name = "WE84E" },
  { .ov = 40, .code = 0x224c, .word = 0xe890, .immediate=0, .flags=0x00, .name = "WE890" },
  { .ov = 40, .code = 0x224c, .word = 0xe8e6, .immediate=0, .flags=0x00, .name = "WE8E6" },
  { .ov = 40, .code = 0x224c, .word = 0xe91a, .immediate=0, .flags=0x00, .name = "WE91A" },
  { .ov = 40, .code = 0x224c, .word = 0xe96c, .immediate=0, .flags=0x00, .name = "WE96C" },
  { .ov = 40, .code = 0x224c, .word = 0xe992, .immediate=0, .flags=0x00, .name = "WE992" },
  { .ov = 40, .code = 0x224c, .word = 0xe99c, .immediate=0, .flags=0x00, .name = "WE99C" },
  { .ov = 40, .code = 0x1d29, .word = 0xe9ac, .immediate=0, .flags=0x00, .name = "WE9AC" },
  { .ov = 40, .code = 0x224c, .word = 0xe9b0, .immediate=0, .flags=0x00, .name = "WE9B0" },
  { .ov = 40, .code = 0x224c, .word = 0xe9c0, .immediate=0, .flags=0x00, .name = "WE9C0" },
  { .ov = 40, .code = 0x224c, .word = 0xe9e4, .immediate=0, .flags=0x00, .name = "WE9E4" },
  { .ov = 40, .code = 0x224c, .word = 0xea10, .immediate=0, .flags=0x00, .name = "WEA10" },
  { .ov = 40, .code = 0x224c, .word = 0xea2e, .immediate=0, .flags=0x00, .name = "WEA2E" },
  { .ov = 40, .code = 0x1d29, .word = 0xea58, .immediate=0, .flags=0x00, .name = "WEA58" },
  { .ov = 40, .code = 0x224c, .word = 0xea5c, .immediate=0, .flags=0x00, .name = "WEA5C" },
  { .ov = 40, .code = 0x224c, .word = 0xea6c, .immediate=0, .flags=0x00, .name = "WEA6C" },
  { .ov = 40, .code = 0x224c, .word = 0xeb3a, .immediate=0, .flags=0x00, .name = "WEB3A" },
  { .ov = 40, .code = 0x224c, .word = 0xeb54, .immediate=0, .flags=0x00, .name = "WEB54" },
  { .ov = 40, .code = 0x4b3b, .word = 0xeb72, .immediate=0, .flags=0x80, .name = "(NOTICES)" },
  { .ov = 40, .code = 0x224c, .word = 0xeb80, .immediate=0, .flags=0x00, .name = "WEB80" },
  { .ov = 40, .code = 0x224c, .word = 0xec6f, .immediate=0, .flags=0x00, .name = "WEC6F" },
  { .ov = 40, .code = 0x224c, .word = 0xed1f, .immediate=0, .flags=0x00, .name = "WED1F" },
  { .ov = 40, .code = 0x224c, .word = 0xed8e, .immediate=0, .flags=0x00, .name = "WED8E" },
  { .ov = 40, .code = 0x224c, .word = 0xedc8, .immediate=0, .flags=0x00, .name = "WEDC8" },
  { .ov = 40, .code = 0x224c, .word = 0xedf8, .immediate=0, .flags=0x00, .name = "WEDF8" },
  { .ov = 40, .code = 0x224c, .word = 0xee10, .immediate=0, .flags=0x00, .name = "WEE10" },
  { .ov = 40, .code = 0x224c, .word = 0xee26, .immediate=0, .flags=0x00, .name = "WEE26" },
  { .ov = 40, .code = 0x224c, .word = 0xee3a, .immediate=0, .flags=0x00, .name = "WEE3A" },
  { .ov = 40, .code = 0x224c, .word = 0xee4e, .immediate=0, .flags=0x00, .name = "WEE4E" },
  { .ov = 40, .code = 0x224c, .word = 0xee66, .immediate=0, .flags=0x00, .name = "WEE66" },
  { .ov = 40, .code = 0x224c, .word = 0xee7c, .immediate=0, .flags=0x00, .name = "WEE7C" },
  { .ov = 40, .code = 0x224c, .word = 0xee92, .immediate=0, .flags=0x00, .name = "WEE92" },
  { .ov = 40, .code = 0x224c, .word = 0xeea7, .immediate=0, .flags=0x00, .name = "WEEA7" },
  { .ov = 40, .code = 0x224c, .word = 0xeec1, .immediate=0, .flags=0x00, .name = "WEEC1" },
  { .ov = 40, .code = 0x4b3b, .word = 0xeeeb, .immediate=0, .flags=0x80, .name = "(BAD-PLAN)" },
  { .ov = 40, .code = 0x224c, .word = 0xef11, .immediate=0, .flags=0x00, .name = "WEF11" },
  { .ov = 40, .code = 0x224c, .word = 0xef2d, .immediate=0, .flags=0x00, .name = "WEF2D" },
  { .ov = 40, .code = 0x224c, .word = 0xf024, .immediate=0, .flags=0x00, .name = "WF024" },
  { .ov = 40, .code = 0x224c, .word = 0xf060, .immediate=0, .flags=0x00, .name = "WF060" },
  { .ov = 40, .code = 0x224c, .word = 0xf097, .immediate=0, .flags=0x00, .name = "WF097" },
  { .ov = 40, .code = 0x224c, .word = 0xf0ee, .immediate=0, .flags=0x00, .name = "WF0EE" },
  { .ov = 40, .code = 0x224c, .word = 0xf142, .immediate=0, .flags=0x00, .name = "WF142" },
  { .ov = 40, .code = 0x224c, .word = 0xf1d8, .immediate=0, .flags=0x00, .name = "WF1D8" },
  { .ov = 40, .code = 0x224c, .word = 0xf214, .immediate=0, .flags=0x00, .name = "WF214" },
  { .ov = 40, .code = 0x224c, .word = 0xf226, .immediate=0, .flags=0x00, .name = "WF226" },
  { .ov = 40, .code = 0x224c, .word = 0xf240, .immediate=0, .flags=0x00, .name = "WF240" },
  { .ov = 40, .code = 0x224c, .word = 0xf27a, .immediate=0, .flags=0x00, .name = "WF27A" },
  { .ov = 40, .code = 0x224c, .word = 0xf28e, .immediate=0, .flags=0x00, .name = "WF28E" },
  { .ov = 40, .code = 0x224c, .word = 0xf2bc, .immediate=0, .flags=0x00, .name = "WF2BC" },
  { .ov = 40, .code = 0x224c, .word = 0xf339, .immediate=0, .flags=0x00, .name = "WF339" },
  { .ov = 40, .code = 0x224c, .word = 0xf38b, .immediate=0, .flags=0x00, .name = "WF38B" },
  { .ov = 40, .code = 0x224c, .word = 0xf3b4, .immediate=0, .flags=0x00, .name = "WF3B4" },
  { .ov = 40, .code = 0x224c, .word = 0xf3ea, .immediate=0, .flags=0x00, .name = "WF3EA" },
  { .ov = 40, .code = 0x224c, .word = 0xf438, .immediate=0, .flags=0x00, .name = "WF438" },
  { .ov = 40, .code = 0x224c, .word = 0xf44e, .immediate=0, .flags=0x00, .name = "WF44E" },
  { .ov = 40, .code = 0x224c, .word = 0xf47a, .immediate=0, .flags=0x00, .name = "WF47A" },
  { .ov = 40, .code = 0x4b3b, .word = 0xf4e6, .immediate=0, .flags=0x80, .name = "OP-CASE" },
  { .ov = 40, .code = 0x224c, .word = 0xf501, .immediate=0, .flags=0x80, .name = "(U-OP)" },
  { .ov = 41, .code = 0x1d29, .word = 0xe636, .immediate=0, .flags=0x00, .name = "WE636" },
  { .ov = 41, .code = 0x1d29, .word = 0xe63a, .immediate=0, .flags=0x00, .name = "WE63A" },
  { .ov = 41, .code = 0x1d29, .word = 0xe63e, .immediate=0, .flags=0x00, .name = "WE63E" },
  { .ov = 41, .code = 0x1d29, .word = 0xe642, .immediate=0, .flags=0x00, .name = "WE642" },
  { .ov = 41, .code = 0x224c, .word = 0xe646, .immediate=0, .flags=0x00, .name = "WE646" },
  { .ov = 41, .code = 0x224c, .word = 0xe67a, .immediate=0, .flags=0x00, .name = "WE67A" },
  { .ov = 41, .code = 0x224c, .word = 0xe684, .immediate=0, .flags=0x00, .name = "WE684" },
  { .ov = 41, .code = 0x224c, .word = 0xe6b4, .immediate=0, .flags=0x00, .name = "WE6B4" },
  { .ov = 41, .code = 0x224c, .word = 0xe6d4, .immediate=0, .flags=0x00, .name = "WE6D4" },
  { .ov = 41, .code = 0x2214, .word = 0xe6dc, .immediate=0, .flags=0x00, .name = "WE6DC" },
  { .ov = 41, .code = 0x2214, .word = 0xe6e0, .immediate=0, .flags=0x00, .name = "WE6E0" },
  { .ov = 41, .code = 0x2214, .word = 0xe6e4, .immediate=0, .flags=0x00, .name = "WE6E4" },
  { .ov = 41, .code = 0x2214, .word = 0xe6e8, .immediate=0, .flags=0x00, .name = "WE6E8" },
  { .ov = 41, .code = 0x7420, .word = 0xe6ec, .immediate=0, .flags=0x00, .name = "WE6EC" },
  { .ov = 41, .code = 0x7394, .word = 0xe6f1, .immediate=0, .flags=0x00, .name = "WE6F1" },
  { .ov = 41, .code = 0x7420, .word = 0xe6f9, .immediate=0, .flags=0x00, .name = "WE6F9" },
  { .ov = 41, .code = 0x7420, .word = 0xe6fe, .immediate=0, .flags=0x00, .name = "WE6FE" },
  { .ov = 41, .code = 0x7420, .word = 0xe703, .immediate=0, .flags=0x00, .name = "WE703" },
  { .ov = 41, .code = 0x7394, .word = 0xe708, .immediate=0, .flags=0x00, .name = "WE708" },
  { .ov = 41, .code = 0x7394, .word = 0xe710, .immediate=0, .flags=0x00, .name = "WE710" },
  { .ov = 41, .code = 0x7394, .word = 0xe718, .immediate=0, .flags=0x00, .name = "WE718" },
  { .ov = 41, .code = 0x7420, .word = 0xe720, .immediate=0, .flags=0x00, .name = "WE720" },
  { .ov = 41, .code = 0x7420, .word = 0xe725, .immediate=0, .flags=0x00, .name = "WE725" },
  { .ov = 41, .code = 0x224c, .word = 0xe72a, .immediate=0, .flags=0x00, .name = "WE72A" },
  { .ov = 41, .code = 0x224c, .word = 0xe73e, .immediate=0, .flags=0x00, .name = "WE73E" },
  { .ov = 41, .code = 0x224c, .word = 0xe74e, .immediate=0, .flags=0x00, .name = "WE74E" },
  { .ov = 41, .code = 0x224c, .word = 0xe762, .immediate=0, .flags=0x00, .name = "WE762" },
  { .ov = 41, .code = 0x224c, .word = 0xe774, .immediate=0, .flags=0x00, .name = "WE774" },
  { .ov = 41, .code = 0x224c, .word = 0xe784, .immediate=0, .flags=0x00, .name = "WE784" },
  { .ov = 41, .code = 0x224c, .word = 0xe78a, .immediate=0, .flags=0x00, .name = "WE78A" },
  { .ov = 41, .code = 0x224c, .word = 0xe7b4, .immediate=0, .flags=0x00, .name = "WE7B4" },
  { .ov = 41, .code = 0x224c, .word = 0xe7c1, .immediate=0, .flags=0x00, .name = "WE7C1" },
  { .ov = 41, .code = 0x224c, .word = 0xe7cc, .immediate=0, .flags=0x00, .name = "WE7CC" },
  { .ov = 41, .code = 0x224c, .word = 0xe7db, .immediate=0, .flags=0x00, .name = "WE7DB" },
  { .ov = 41, .code = 0x224c, .word = 0xe7e7, .immediate=0, .flags=0x00, .name = "WE7E7" },
  { .ov = 41, .code = 0x224c, .word = 0xe7f4, .immediate=0, .flags=0x00, .name = "WE7F4" },
  { .ov = 41, .code = 0x1d29, .word = 0xe7fe, .immediate=0, .flags=0x00, .name = "WE7FE" },
  { .ov = 41, .code = 0x1d29, .word = 0xe802, .immediate=0, .flags=0x00, .name = "WE802" },
  { .ov = 41, .code = 0x224c, .word = 0xe806, .immediate=0, .flags=0x00, .name = "WE806" },
  { .ov = 41, .code = 0x224c, .word = 0xe810, .immediate=0, .flags=0x00, .name = "WE810" },
  { .ov = 41, .code = 0x224c, .word = 0xe81e, .immediate=0, .flags=0x00, .name = "WE81E" },
  { .ov = 41, .code = 0x224c, .word = 0xe82c, .immediate=0, .flags=0x00, .name = "WE82C" },
  { .ov = 41, .code = 0x224c, .word = 0xe845, .immediate=0, .flags=0x00, .name = "WE845" },
  { .ov = 41, .code = 0x4b3b, .word = 0xe865, .immediate=0, .flags=0x80, .name = "T.OPTIONS" },
  { .ov = 41, .code = 0x224c, .word = 0xe87f, .immediate=0, .flags=0x00, .name = "WE87F" },
  { .ov = 41, .code = 0x224c, .word = 0xe88d, .immediate=0, .flags=0x00, .name = "WE88D" },
  { .ov = 41, .code = 0x224c, .word = 0xe89b, .immediate=0, .flags=0x00, .name = "WE89B" },
  { .ov = 41, .code = 0x224c, .word = 0xe8b4, .immediate=0, .flags=0x00, .name = "WE8B4" },
  { .ov = 41, .code = 0x224c, .word = 0xe8e2, .immediate=0, .flags=0x00, .name = "WE8E2" },
  { .ov = 41, .code = 0x4b3b, .word = 0xe8fe, .immediate=0, .flags=0x80, .name = "P.OPTIONS" },
  { .ov = 41, .code = 0x224c, .word = 0xe914, .immediate=0, .flags=0x00, .name = "WE914" },
  { .ov = 41, .code = 0x224c, .word = 0xe922, .immediate=0, .flags=0x00, .name = "WE922" },
  { .ov = 41, .code = 0x224c, .word = 0xe936, .immediate=0, .flags=0x00, .name = "WE936" },
  { .ov = 41, .code = 0x224c, .word = 0xe94c, .immediate=0, .flags=0x00, .name = "WE94C" },
  { .ov = 41, .code = 0x224c, .word = 0xe95a, .immediate=0, .flags=0x00, .name = "WE95A" },
  { .ov = 41, .code = 0x4b3b, .word = 0xe976, .immediate=0, .flags=0x80, .name = "CLASS>VOL" },
  { .ov = 41, .code = 0x224c, .word = 0xe984, .immediate=0, .flags=0x00, .name = "WE984" },
  { .ov = 41, .code = 0x224c, .word = 0xe9d5, .immediate=0, .flags=0x00, .name = "WE9D5" },
  { .ov = 41, .code = 0x224c, .word = 0xe9e1, .immediate=0, .flags=0x00, .name = "WE9E1" },
  { .ov = 41, .code = 0x224c, .word = 0xea31, .immediate=0, .flags=0x00, .name = "WEA31" },
  { .ov = 41, .code = 0x224c, .word = 0xea3b, .immediate=0, .flags=0x00, .name = "WEA3B" },
  { .ov = 41, .code = 0x224c, .word = 0xea57, .immediate=0, .flags=0x00, .name = "WEA57" },
  { .ov = 41, .code = 0x224c, .word = 0xea69, .immediate=0, .flags=0x00, .name = "WEA69" },
  { .ov = 41, .code = 0x224c, .word = 0xea75, .immediate=0, .flags=0x00, .name = "WEA75" },
  { .ov = 41, .code = 0x224c, .word = 0xea7f, .immediate=0, .flags=0x00, .name = "WEA7F" },
  { .ov = 41, .code = 0x224c, .word = 0xeaa7, .immediate=0, .flags=0x00, .name = "WEAA7" },
  { .ov = 41, .code = 0x224c, .word = 0xead7, .immediate=0, .flags=0x00, .name = "WEAD7" },
  { .ov = 41, .code = 0x224c, .word = 0xeb09, .immediate=0, .flags=0x00, .name = "WEB09" },
  { .ov = 41, .code = 0x224c, .word = 0xeb19, .immediate=0, .flags=0x00, .name = "WEB19" },
  { .ov = 41, .code = 0x224c, .word = 0xeb23, .immediate=0, .flags=0x00, .name = "WEB23" },
  { .ov = 41, .code = 0x224c, .word = 0xeb2b, .immediate=0, .flags=0x00, .name = "WEB2B" },
  { .ov = 41, .code = 0x224c, .word = 0xeb57, .immediate=0, .flags=0x00, .name = "WEB57" },
  { .ov = 41, .code = 0x1d29, .word = 0xeb95, .immediate=0, .flags=0x00, .name = "WEB95" },
  { .ov = 41, .code = 0x224c, .word = 0xeb9b, .immediate=0, .flags=0x00, .name = "WEB9B" },
  { .ov = 41, .code = 0x224c, .word = 0xebf1, .immediate=0, .flags=0x00, .name = "WEBF1" },
  { .ov = 41, .code = 0x224c, .word = 0xec23, .immediate=0, .flags=0x00, .name = "WEC23" },
  { .ov = 41, .code = 0x224c, .word = 0xec29, .immediate=0, .flags=0x00, .name = "WEC29" },
  { .ov = 41, .code = 0x224c, .word = 0xec2f, .immediate=0, .flags=0x00, .name = "WEC2F" },
  { .ov = 41, .code = 0x224c, .word = 0xec45, .immediate=0, .flags=0x00, .name = "WEC45" },
  { .ov = 41, .code = 0x224c, .word = 0xec79, .immediate=0, .flags=0x00, .name = "WEC79" },
  { .ov = 41, .code = 0x224c, .word = 0xec7f, .immediate=0, .flags=0x00, .name = "WEC7F" },
  { .ov = 41, .code = 0x4b3b, .word = 0xec8e, .immediate=0, .flags=0x80, .name = "PA.ACT" },
  { .ov = 41, .code = 0x4b3b, .word = 0xeca1, .immediate=0, .flags=0x80, .name = "TA.ACT" },
  { .ov = 41, .code = 0x224c, .word = 0xecab, .immediate=0, .flags=0x00, .name = "WECAB" },
  { .ov = 41, .code = 0x224c, .word = 0xecbf, .immediate=0, .flags=0x00, .name = "WECBF" },
  { .ov = 41, .code = 0x224c, .word = 0xecdf, .immediate=0, .flags=0x00, .name = "WECDF" },
  { .ov = 41, .code = 0x224c, .word = 0xed0b, .immediate=0, .flags=0x00, .name = "WED0B" },
  { .ov = 41, .code = 0x224c, .word = 0xed17, .immediate=0, .flags=0x00, .name = "WED17" },
  { .ov = 41, .code = 0x4b3b, .word = 0xed3c, .immediate=0, .flags=0x80, .name = "PM.ACT" },
  { .ov = 41, .code = 0x4b3b, .word = 0xed53, .immediate=0, .flags=0x80, .name = "TM.ACT" },
  { .ov = 41, .code = 0x224c, .word = 0xed61, .immediate=0, .flags=0x00, .name = "WED61" },
  { .ov = 41, .code = 0x224c, .word = 0xed75, .immediate=0, .flags=0x00, .name = "WED75" },
  { .ov = 41, .code = 0x4b3b, .word = 0xed96, .immediate=0, .flags=0x80, .name = "PL.ACT" },
  { .ov = 41, .code = 0x4b3b, .word = 0xedad, .immediate=0, .flags=0x80, .name = "TL.ACT" },
  { .ov = 41, .code = 0x224c, .word = 0xedbb, .immediate=0, .flags=0x00, .name = "WEDBB" },
  { .ov = 41, .code = 0x4b3b, .word = 0xedda, .immediate=0, .flags=0x80, .name = "DISPATCH" },
  { .ov = 41, .code = 0x224c, .word = 0xedf0, .immediate=0, .flags=0x00, .name = "WEDF0" },
  { .ov = 41, .code = 0x224c, .word = 0xee3e, .immediate=0, .flags=0x00, .name = "WEE3E" },
  { .ov = 41, .code = 0x1d29, .word = 0xee91, .immediate=0, .flags=0x00, .name = "WEE91" },
  { .ov = 41, .code = 0x224c, .word = 0xee96, .immediate=0, .flags=0x00, .name = "WEE96" },
  { .ov = 41, .code = 0x224c, .word = 0xee9e, .immediate=0, .flags=0x00, .name = "WEE9E" },
  { .ov = 41, .code = 0x224c, .word = 0xeeb0, .immediate=0, .flags=0x00, .name = "WEEB0" },
  { .ov = 41, .code = 0x224c, .word = 0xeec2, .immediate=0, .flags=0x00, .name = "WEEC2" },
  { .ov = 41, .code = 0x224c, .word = 0xeed2, .immediate=0, .flags=0x00, .name = "WEED2" },
  { .ov = 41, .code = 0x224c, .word = 0xeee2, .immediate=0, .flags=0x00, .name = "WEEE2" },
  { .ov = 41, .code = 0x224c, .word = 0xef0a, .immediate=0, .flags=0x00, .name = "WEF0A" },
  { .ov = 41, .code = 0x224c, .word = 0xef10, .immediate=0, .flags=0x00, .name = "WEF10" },
  { .ov = 41, .code = 0x224c, .word = 0xef22, .immediate=0, .flags=0x00, .name = "WEF22" },
  { .ov = 41, .code = 0x224c, .word = 0xef52, .immediate=0, .flags=0x00, .name = "WEF52" },
  { .ov = 41, .code = 0x224c, .word = 0xef7e, .immediate=0, .flags=0x00, .name = "WEF7E" },
  { .ov = 41, .code = 0x224c, .word = 0xef94, .immediate=0, .flags=0x00, .name = "WEF94" },
  { .ov = 41, .code = 0x224c, .word = 0xefc4, .immediate=0, .flags=0x00, .name = "WEFC4" },
  { .ov = 41, .code = 0x224c, .word = 0xeff2, .immediate=0, .flags=0x00, .name = "WEFF2" },
  { .ov = 41, .code = 0x224c, .word = 0xf018, .immediate=0, .flags=0x00, .name = "WF018" },
  { .ov = 41, .code = 0x224c, .word = 0xf096, .immediate=0, .flags=0x00, .name = "WF096" },
  { .ov = 41, .code = 0x224c, .word = 0xf0a2, .immediate=0, .flags=0x00, .name = "WF0A2" },
  { .ov = 41, .code = 0x224c, .word = 0xf0cc, .immediate=0, .flags=0x00, .name = "WF0CC" },
  { .ov = 41, .code = 0x224c, .word = 0xf0f6, .immediate=0, .flags=0x00, .name = "WF0F6" },
  { .ov = 41, .code = 0x224c, .word = 0xf122, .immediate=0, .flags=0x00, .name = "WF122" },
  { .ov = 41, .code = 0x224c, .word = 0xf164, .immediate=0, .flags=0x00, .name = "WF164" },
  { .ov = 41, .code = 0x224c, .word = 0xf182, .immediate=0, .flags=0x00, .name = "WF182" },
  { .ov = 41, .code = 0x224c, .word = 0xf18a, .immediate=0, .flags=0x00, .name = "WF18A" },
  { .ov = 41, .code = 0x224c, .word = 0xf194, .immediate=0, .flags=0x00, .name = "WF194" },
  { .ov = 41, .code = 0x224c, .word = 0xf1ce, .immediate=0, .flags=0x00, .name = "WF1CE" },
  { .ov = 41, .code = 0x4b3b, .word = 0xf21a, .immediate=0, .flags=0x80, .name = "TD-SCROLL" },
  { .ov = 41, .code = 0x224c, .word = 0xf228, .immediate=0, .flags=0x00, .name = "WF228" },
  { .ov = 41, .code = 0x224c, .word = 0xf258, .immediate=0, .flags=0x00, .name = "WF258" },
  { .ov = 41, .code = 0x224c, .word = 0xf2a2, .immediate=0, .flags=0x00, .name = "WF2A2" },
  { .ov = 41, .code = 0x224c, .word = 0xf2e0, .immediate=0, .flags=0x00, .name = "WF2E0" },
  { .ov = 41, .code = 0x224c, .word = 0xf2f4, .immediate=0, .flags=0x00, .name = "WF2F4" },
  { .ov = 41, .code = 0x224c, .word = 0xf322, .immediate=0, .flags=0x00, .name = "WF322" },
  { .ov = 41, .code = 0x224c, .word = 0xf35c, .immediate=0, .flags=0x00, .name = "WF35C" },
  { .ov = 41, .code = 0x224c, .word = 0xf37e, .immediate=0, .flags=0x00, .name = "WF37E" },
  { .ov = 41, .code = 0x224c, .word = 0xf3e4, .immediate=0, .flags=0x00, .name = "WF3E4" },
  { .ov = 41, .code = 0x224c, .word = 0xf406, .immediate=0, .flags=0x00, .name = "WF406" },
  { .ov = 41, .code = 0x224c, .word = 0xf420, .immediate=0, .flags=0x00, .name = "WF420" },
  { .ov = 41, .code = 0x224c, .word = 0xf448, .immediate=0, .flags=0x00, .name = "WF448" },
  { .ov = 41, .code = 0x224c, .word = 0xf45c, .immediate=0, .flags=0x80, .name = ">DEBRIS" },
  { .ov = 41, .code = 0x224c, .word = 0xf466, .immediate=0, .flags=0x00, .name = "WF466" },
  { .ov = 41, .code = 0x224c, .word = 0xf490, .immediate=0, .flags=0x00, .name = "WF490" },
  { .ov = 41, .code = 0x224c, .word = 0xf4ab, .immediate=0, .flags=0x80, .name = "(/ITEMS)" },
  { .ov = 42, .code = 0x224c, .word = 0xe486, .immediate=0, .flags=0x00, .name = "WE486" },
  { .ov = 42, .code = 0x224c, .word = 0xe494, .immediate=0, .flags=0x00, .name = "WE494" },
  { .ov = 42, .code = 0x224c, .word = 0xe49c, .immediate=0, .flags=0x00, .name = "WE49C" },
  { .ov = 42, .code = 0x224c, .word = 0xe4a8, .immediate=0, .flags=0x00, .name = "WE4A8" },
  { .ov = 42, .code = 0x224c, .word = 0xe4b2, .immediate=0, .flags=0x00, .name = "WE4B2" },
  { .ov = 42, .code = 0x224c, .word = 0xe4be, .immediate=0, .flags=0x00, .name = "WE4BE" },
  { .ov = 42, .code = 0x224c, .word = 0xe4c6, .immediate=0, .flags=0x00, .name = "WE4C6" },
  { .ov = 42, .code = 0x1d29, .word = 0xe4d4, .immediate=0, .flags=0x00, .name = "WE4D4" },
  { .ov = 42, .code = 0x224c, .word = 0xe4d8, .immediate=0, .flags=0x00, .name = "WE4D8" },
  { .ov = 42, .code = 0x224c, .word = 0xe4ec, .immediate=0, .flags=0x00, .name = "WE4EC" },
  { .ov = 42, .code = 0x224c, .word = 0xe4f8, .immediate=0, .flags=0x00, .name = "WE4F8" },
  { .ov = 42, .code = 0x224c, .word = 0xe500, .immediate=0, .flags=0x00, .name = "WE500" },
  { .ov = 42, .code = 0x224c, .word = 0xe514, .immediate=0, .flags=0x00, .name = "WE514" },
  { .ov = 42, .code = 0x224c, .word = 0xe51c, .immediate=0, .flags=0x00, .name = "WE51C" },
  { .ov = 42, .code = 0x224c, .word = 0xe548, .immediate=0, .flags=0x00, .name = "WE548" },
  { .ov = 42, .code = 0x224c, .word = 0xe552, .immediate=0, .flags=0x00, .name = "WE552" },
  { .ov = 42, .code = 0x224c, .word = 0xe55c, .immediate=0, .flags=0x00, .name = "WE55C" },
  { .ov = 42, .code = 0x224c, .word = 0xe566, .immediate=0, .flags=0x00, .name = "WE566" },
  { .ov = 42, .code = 0x7420, .word = 0xe570, .immediate=0, .flags=0x00, .name = "WE570" },
  { .ov = 42, .code = 0x7394, .word = 0xe575, .immediate=0, .flags=0x00, .name = "WE575" },
  { .ov = 42, .code = 0x7420, .word = 0xe57d, .immediate=0, .flags=0x00, .name = "WE57D" },
  { .ov = 42, .code = 0x7420, .word = 0xe582, .immediate=0, .flags=0x00, .name = "WE582" },
  { .ov = 42, .code = 0x7420, .word = 0xe587, .immediate=0, .flags=0x00, .name = "WE587" },
  { .ov = 42, .code = 0x7420, .word = 0xe58c, .immediate=0, .flags=0x00, .name = "WE58C" },
  { .ov = 42, .code = 0x7394, .word = 0xe591, .immediate=0, .flags=0x00, .name = "WE591" },
  { .ov = 42, .code = 0x7420, .word = 0xe599, .immediate=0, .flags=0x00, .name = "WE599" },
  { .ov = 42, .code = 0x7394, .word = 0xe59e, .immediate=0, .flags=0x00, .name = "WE59E" },
  { .ov = 42, .code = 0x7394, .word = 0xe5a6, .immediate=0, .flags=0x00, .name = "WE5A6" },
  { .ov = 42, .code = 0x7394, .word = 0xe5ae, .immediate=0, .flags=0x00, .name = "WE5AE" },
  { .ov = 42, .code = 0x7420, .word = 0xe5b6, .immediate=0, .flags=0x00, .name = "WE5B6" },
  { .ov = 42, .code = 0x7420, .word = 0xe5bb, .immediate=0, .flags=0x00, .name = "WE5BB" },
  { .ov = 42, .code = 0x7420, .word = 0xe5c0, .immediate=0, .flags=0x00, .name = "WE5C0" },
  { .ov = 42, .code = 0x7420, .word = 0xe5c5, .immediate=0, .flags=0x00, .name = "WE5C5" },
  { .ov = 42, .code = 0x7420, .word = 0xe5ca, .immediate=0, .flags=0x00, .name = "WE5CA" },
  { .ov = 42, .code = 0x7394, .word = 0xe5cf, .immediate=0, .flags=0x00, .name = "WE5CF" },
  { .ov = 42, .code = 0x7394, .word = 0xe5d7, .immediate=0, .flags=0x00, .name = "WE5D7" },
  { .ov = 42, .code = 0x7420, .word = 0xe5df, .immediate=0, .flags=0x00, .name = "WE5DF" },
  { .ov = 42, .code = 0x7420, .word = 0xe5e4, .immediate=0, .flags=0x00, .name = "WE5E4" },
  { .ov = 42, .code = 0x7420, .word = 0xe5e9, .immediate=0, .flags=0x00, .name = "WE5E9" },
  { .ov = 42, .code = 0x224c, .word = 0xe5ee, .immediate=0, .flags=0x00, .name = "WE5EE" },
  { .ov = 42, .code = 0x224c, .word = 0xe5fa, .immediate=0, .flags=0x00, .name = "WE5FA" },
  { .ov = 42, .code = 0x224c, .word = 0xe606, .immediate=0, .flags=0x00, .name = "WE606" },
  { .ov = 42, .code = 0x224c, .word = 0xe618, .immediate=0, .flags=0x00, .name = "WE618" },
  { .ov = 42, .code = 0x224c, .word = 0xe626, .immediate=0, .flags=0x00, .name = "WE626" },
  { .ov = 42, .code = 0x224c, .word = 0xe646, .immediate=0, .flags=0x00, .name = "WE646" },
  { .ov = 42, .code = 0x224c, .word = 0xe654, .immediate=0, .flags=0x00, .name = "WE654" },
  { .ov = 42, .code = 0x224c, .word = 0xe660, .immediate=0, .flags=0x00, .name = "WE660" },
  { .ov = 42, .code = 0x224c, .word = 0xe66a, .immediate=0, .flags=0x00, .name = "WE66A" },
  { .ov = 42, .code = 0x224c, .word = 0xe674, .immediate=0, .flags=0x00, .name = "WE674" },
  { .ov = 42, .code = 0x224c, .word = 0xe67e, .immediate=0, .flags=0x00, .name = "WE67E" },
  { .ov = 42, .code = 0x224c, .word = 0xe688, .immediate=0, .flags=0x00, .name = "WE688" },
  { .ov = 42, .code = 0x224c, .word = 0xe692, .immediate=0, .flags=0x00, .name = "WE692" },
  { .ov = 42, .code = 0x224c, .word = 0xe69c, .immediate=0, .flags=0x00, .name = "WE69C" },
  { .ov = 42, .code = 0x224c, .word = 0xe6a6, .immediate=0, .flags=0x00, .name = "WE6A6" },
  { .ov = 42, .code = 0x224c, .word = 0xe6ae, .immediate=0, .flags=0x00, .name = "WE6AE" },
  { .ov = 42, .code = 0x224c, .word = 0xe6ba, .immediate=0, .flags=0x00, .name = "WE6BA" },
  { .ov = 42, .code = 0x224c, .word = 0xe6cc, .immediate=0, .flags=0x00, .name = "WE6CC" },
  { .ov = 42, .code = 0x224c, .word = 0xe70a, .immediate=0, .flags=0x00, .name = "WE70A" },
  { .ov = 42, .code = 0x224c, .word = 0xe72e, .immediate=0, .flags=0x00, .name = "WE72E" },
  { .ov = 42, .code = 0x224c, .word = 0xe73e, .immediate=0, .flags=0x00, .name = "WE73E" },
  { .ov = 42, .code = 0x224c, .word = 0xe74a, .immediate=0, .flags=0x00, .name = "WE74A" },
  { .ov = 42, .code = 0x224c, .word = 0xe758, .immediate=0, .flags=0x00, .name = "WE758" },
  { .ov = 42, .code = 0x224c, .word = 0xe762, .immediate=0, .flags=0x00, .name = "WE762" },
  { .ov = 42, .code = 0x224c, .word = 0xe778, .immediate=0, .flags=0x00, .name = "WE778" },
  { .ov = 42, .code = 0x224c, .word = 0xe786, .immediate=0, .flags=0x00, .name = "WE786" },
  { .ov = 42, .code = 0x224c, .word = 0xe79a, .immediate=0, .flags=0x00, .name = "WE79A" },
  { .ov = 42, .code = 0x224c, .word = 0xe7b6, .immediate=0, .flags=0x00, .name = "WE7B6" },
  { .ov = 42, .code = 0x224c, .word = 0xe7c0, .immediate=0, .flags=0x00, .name = "WE7C0" },
  { .ov = 42, .code = 0x224c, .word = 0xe7d8, .immediate=0, .flags=0x00, .name = "WE7D8" },
  { .ov = 42, .code = 0x224c, .word = 0xe7f9, .immediate=0, .flags=0x00, .name = "WE7F9" },
  { .ov = 42, .code = 0x224c, .word = 0xe821, .immediate=0, .flags=0x00, .name = "WE821" },
  { .ov = 42, .code = 0x4b3b, .word = 0xe84b, .immediate=0, .flags=0x80, .name = ">WEAP" },
  { .ov = 42, .code = 0x224c, .word = 0xe861, .immediate=0, .flags=0x00, .name = "WE861" },
  { .ov = 42, .code = 0x224c, .word = 0xe86f, .immediate=0, .flags=0x00, .name = "WE86F" },
  { .ov = 42, .code = 0x224c, .word = 0xe87d, .immediate=0, .flags=0x00, .name = "WE87D" },
  { .ov = 42, .code = 0x224c, .word = 0xe893, .immediate=0, .flags=0x00, .name = "WE893" },
  { .ov = 42, .code = 0x224c, .word = 0xe8c9, .immediate=0, .flags=0x00, .name = "WE8C9" },
  { .ov = 42, .code = 0x224c, .word = 0xe8e3, .immediate=0, .flags=0x00, .name = "WE8E3" },
  { .ov = 42, .code = 0x224c, .word = 0xe8fb, .immediate=0, .flags=0x00, .name = "WE8FB" },
  { .ov = 42, .code = 0x224c, .word = 0xe927, .immediate=0, .flags=0x00, .name = "WE927" },
  { .ov = 42, .code = 0x224c, .word = 0xe93b, .immediate=0, .flags=0x00, .name = "WE93B" },
  { .ov = 42, .code = 0x224c, .word = 0xe947, .immediate=0, .flags=0x00, .name = "WE947" },
  { .ov = 42, .code = 0x224c, .word = 0xe96f, .immediate=0, .flags=0x00, .name = "WE96F" },
  { .ov = 42, .code = 0x224c, .word = 0xe98f, .immediate=0, .flags=0x00, .name = "WE98F" },
  { .ov = 42, .code = 0x224c, .word = 0xe999, .immediate=0, .flags=0x00, .name = "WE999" },
  { .ov = 42, .code = 0x224c, .word = 0xe9cb, .immediate=0, .flags=0x00, .name = "WE9CB" },
  { .ov = 42, .code = 0x224c, .word = 0xe9f7, .immediate=0, .flags=0x00, .name = "WE9F7" },
  { .ov = 42, .code = 0x224c, .word = 0xea01, .immediate=0, .flags=0x00, .name = "WEA01" },
  { .ov = 42, .code = 0x224c, .word = 0xea2b, .immediate=0, .flags=0x00, .name = "WEA2B" },
  { .ov = 42, .code = 0x224c, .word = 0xea45, .immediate=0, .flags=0x00, .name = "WEA45" },
  { .ov = 42, .code = 0x224c, .word = 0xea86, .immediate=0, .flags=0x00, .name = "WEA86" },
  { .ov = 42, .code = 0x224c, .word = 0xeab6, .immediate=0, .flags=0x00, .name = "WEAB6" },
  { .ov = 42, .code = 0x224c, .word = 0xeac4, .immediate=0, .flags=0x00, .name = "WEAC4" },
  { .ov = 42, .code = 0x224c, .word = 0xeae0, .immediate=0, .flags=0x00, .name = "WEAE0" },
  { .ov = 42, .code = 0x224c, .word = 0xeb33, .immediate=0, .flags=0x00, .name = "WEB33" },
  { .ov = 42, .code = 0x224c, .word = 0xeb4d, .immediate=0, .flags=0x00, .name = "WEB4D" },
  { .ov = 42, .code = 0x224c, .word = 0xeb57, .immediate=0, .flags=0x00, .name = "WEB57" },
  { .ov = 42, .code = 0x224c, .word = 0xeb5f, .immediate=0, .flags=0x00, .name = "WEB5F" },
  { .ov = 42, .code = 0xaccc, .word = 0xeb9a, .immediate=0, .flags=0x80, .name = "SENT2P" },
  { .ov = 42, .code = 0xaccc, .word = 0xebd6, .immediate=0, .flags=0x80, .name = "P2SENT" },
  { .ov = 42, .code = 0xaccc, .word = 0xec17, .immediate=0, .flags=0x80, .name = "CRIT2P" },
  { .ov = 42, .code = 0xaccc, .word = 0xec67, .immediate=0, .flags=0x80, .name = "P2CRIT" },
  { .ov = 42, .code = 0x224c, .word = 0xeca4, .immediate=0, .flags=0x00, .name = "WECA4" },
  { .ov = 42, .code = 0x224c, .word = 0xece0, .immediate=0, .flags=0x00, .name = "WECE0" },
  { .ov = 42, .code = 0x224c, .word = 0xed40, .immediate=0, .flags=0x00, .name = "WED40" },
  { .ov = 42, .code = 0x224c, .word = 0xed5c, .immediate=0, .flags=0x00, .name = "WED5C" },
  { .ov = 42, .code = 0x224c, .word = 0xed66, .immediate=0, .flags=0x00, .name = "WED66" },
  { .ov = 42, .code = 0x224c, .word = 0xed78, .immediate=0, .flags=0x80, .name = "CIRCLES" },
  { .ov = 42, .code = 0x224c, .word = 0xee2a, .immediate=0, .flags=0x00, .name = "WEE2A" },
  { .ov = 42, .code = 0x224c, .word = 0xee4c, .immediate=0, .flags=0x00, .name = "WEE4C" },
  { .ov = 42, .code = 0x224c, .word = 0xee64, .immediate=0, .flags=0x00, .name = "WEE64" },
  { .ov = 42, .code = 0x224c, .word = 0xee74, .immediate=0, .flags=0x00, .name = "WEE74" },
  { .ov = 42, .code = 0x224c, .word = 0xee89, .immediate=0, .flags=0x80, .name = "?ANYBODY" },
  { .ov = 42, .code = 0x224c, .word = 0xee8f, .immediate=0, .flags=0x00, .name = "WEE8F" },
  { .ov = 42, .code = 0x224c, .word = 0xeea3, .immediate=0, .flags=0x00, .name = "WEEA3" },
  { .ov = 42, .code = 0x4b3b, .word = 0xeec6, .immediate=0, .flags=0x80, .name = "(SIMULATE)" },
  { .ov = 42, .code = 0x224c, .word = 0xeee0, .immediate=0, .flags=0x80, .name = "1SIMULATE" },
  { .ov = 42, .code = 0x224c, .word = 0xef24, .immediate=0, .flags=0x00, .name = "WEF24" },
  { .ov = 42, .code = 0x224c, .word = 0xef38, .immediate=0, .flags=0x00, .name = "WEF38" },
  { .ov = 42, .code = 0x224c, .word = 0xef4c, .immediate=0, .flags=0x00, .name = "WEF4C" },
  { .ov = 42, .code = 0x224c, .word = 0xef9a, .immediate=0, .flags=0x00, .name = "WEF9A" },
  { .ov = 42, .code = 0x224c, .word = 0xefd0, .immediate=0, .flags=0x00, .name = "WEFD0" },
  { .ov = 42, .code = 0x224c, .word = 0xf002, .immediate=0, .flags=0x00, .name = "WF002" },
  { .ov = 42, .code = 0x224c, .word = 0xf012, .immediate=0, .flags=0x00, .name = "WF012" },
  { .ov = 42, .code = 0x224c, .word = 0xf026, .immediate=0, .flags=0x00, .name = "WF026" },
  { .ov = 42, .code = 0x1d29, .word = 0xf052, .immediate=0, .flags=0x80, .name = "FUNCTIONS" },
  { .ov = 42, .code = 0x224c, .word = 0xf06d, .immediate=0, .flags=0x00, .name = "WF06D" },
  { .ov = 42, .code = 0x224c, .word = 0xf079, .immediate=0, .flags=0x00, .name = "WF079" },
  { .ov = 42, .code = 0x224c, .word = 0xf08c, .immediate=0, .flags=0x80, .name = "MAPS" },
  { .ov = 42, .code = 0x224c, .word = 0xf0a2, .immediate=0, .flags=0x80, .name = "WALK&TALK" },
  { .ov = 42, .code = 0x224c, .word = 0xf0b5, .immediate=0, .flags=0x80, .name = "TVMOVE" },
  { .ov = 42, .code = 0x224c, .word = 0xf0d4, .immediate=0, .flags=0x80, .name = "DO.WEAPONS" },
  { .ov = 42, .code = 0x224c, .word = 0xf0f7, .immediate=0, .flags=0x80, .name = "/ITEMS" },
  { .ov = 42, .code = 0x224c, .word = 0xf109, .immediate=0, .flags=0x80, .name = "ICONS" },
  { .ov = 42, .code = 0x4b3b, .word = 0xf120, .immediate=0, .flags=0x80, .name = ">BUTTONS" },
  { .ov = 42, .code = 0x224c, .word = 0xf146, .immediate=0, .flags=0x80, .name = "?FUNC" },
  { .ov = 42, .code = 0x224c, .word = 0xf19a, .immediate=0, .flags=0x00, .name = "WF19A" },
  { .ov = 42, .code = 0x224c, .word = 0xf1ff, .immediate=0, .flags=0x80, .name = "TV-KEY" },
  { .ov = 42, .code = 0x224c, .word = 0xf275, .immediate=0, .flags=0x00, .name = "WF275" },
  { .ov = 42, .code = 0x224c, .word = 0xf289, .immediate=0, .flags=0x00, .name = "WF289" },
  { .ov = 42, .code = 0x224c, .word = 0xf2d5, .immediate=0, .flags=0x00, .name = "WF2D5" },
  { .ov = 42, .code = 0x224c, .word = 0xf312, .immediate=0, .flags=0x00, .name = "WF312" },
  { .ov = 42, .code = 0x224c, .word = 0xf354, .immediate=0, .flags=0x00, .name = "WF354" },
  { .ov = 42, .code = 0x224c, .word = 0xf3ca, .immediate=0, .flags=0x00, .name = "WF3CA" },
  { .ov = 42, .code = 0x224c, .word = 0xf3e6, .immediate=0, .flags=0x00, .name = "WF3E6" },
  { .ov = 42, .code = 0x224c, .word = 0xf403, .immediate=0, .flags=0x80, .name = "GNUNK-CHEC" },
  { .ov = 42, .code = 0x224c, .word = 0xf438, .immediate=0, .flags=0x80, .name = "TV-TASKS" },
  { .ov = 42, .code = 0x224c, .word = 0xf48e, .immediate=0, .flags=0x00, .name = "WF48E" },
  { .ov = 42, .code = 0x224c, .word = 0xf4f2, .immediate=0, .flags=0x00, .name = "WF4F2" },
  { .ov = 42, .code = 0x224c, .word = 0xf500, .immediate=0, .flags=0x00, .name = "WF500" },
  { .ov = 42, .code = 0x224c, .word = 0xf543, .immediate=0, .flags=0x80, .name = "TV" },
  { .ov = 43, .code = 0x224c, .word = 0xf086, .immediate=0, .flags=0x00, .name = "WF086" },
  { .ov = 43, .code = 0x224c, .word = 0xf09c, .immediate=0, .flags=0x00, .name = "WF09C" },
  { .ov = 43, .code = 0x7420, .word = 0xf0be, .immediate=0, .flags=0x00, .name = "WF0BE" },
  { .ov = 43, .code = 0x7420, .word = 0xf0c3, .immediate=0, .flags=0x00, .name = "WF0C3" },
  { .ov = 43, .code = 0x7420, .word = 0xf0c8, .immediate=0, .flags=0x00, .name = "WF0C8" },
  { .ov = 43, .code = 0x7420, .word = 0xf0cd, .immediate=0, .flags=0x00, .name = "WF0CD" },
  { .ov = 43, .code = 0x7420, .word = 0xf0d2, .immediate=0, .flags=0x00, .name = "WF0D2" },
  { .ov = 43, .code = 0x7420, .word = 0xf0d7, .immediate=0, .flags=0x00, .name = "WF0D7" },
  { .ov = 43, .code = 0x7420, .word = 0xf0dc, .immediate=0, .flags=0x00, .name = "WF0DC" },
  { .ov = 43, .code = 0x7420, .word = 0xf0e1, .immediate=0, .flags=0x00, .name = "WF0E1" },
  { .ov = 43, .code = 0x7420, .word = 0xf0e6, .immediate=0, .flags=0x00, .name = "WF0E6" },
  { .ov = 43, .code = 0x7420, .word = 0xf0eb, .immediate=0, .flags=0x00, .name = "WF0EB" },
  { .ov = 43, .code = 0x7420, .word = 0xf0f0, .immediate=0, .flags=0x00, .name = "WF0F0" },
  { .ov = 43, .code = 0x7394, .word = 0xf0f5, .immediate=0, .flags=0x00, .name = "WF0F5" },
  { .ov = 43, .code = 0x224c, .word = 0xf0fd, .immediate=0, .flags=0x00, .name = "WF0FD" },
  { .ov = 43, .code = 0x224c, .word = 0xf107, .immediate=0, .flags=0x00, .name = "WF107" },
  { .ov = 43, .code = 0x224c, .word = 0xf115, .immediate=0, .flags=0x00, .name = "WF115" },
  { .ov = 43, .code = 0x224c, .word = 0xf151, .immediate=0, .flags=0x00, .name = "WF151" },
  { .ov = 43, .code = 0x224c, .word = 0xf1c6, .immediate=0, .flags=0x80, .name = "ROLE-C" },
  { .ov = 43, .code = 0x224c, .word = 0xf212, .immediate=0, .flags=0x00, .name = "WF212" },
  { .ov = 43, .code = 0x224c, .word = 0xf256, .immediate=0, .flags=0x00, .name = "WF256" },
  { .ov = 43, .code = 0x224c, .word = 0xf268, .immediate=0, .flags=0x00, .name = "WF268" },
  { .ov = 43, .code = 0x224c, .word = 0xf28a, .immediate=0, .flags=0x00, .name = "WF28A" },
  { .ov = 43, .code = 0x224c, .word = 0xf2a3, .immediate=0, .flags=0x00, .name = "WF2A3" },
  { .ov = 43, .code = 0x224c, .word = 0xf331, .immediate=0, .flags=0x80, .name = ".VITS" },
  { .ov = 43, .code = 0x4b3b, .word = 0xf3d2, .immediate=0, .flags=0x80, .name = ">SKILL" },
  { .ov = 43, .code = 0x224c, .word = 0xf3ec, .immediate=0, .flags=0x00, .name = "WF3EC" },
  { .ov = 43, .code = 0x224c, .word = 0xf40c, .immediate=0, .flags=0x00, .name = "WF40C" },
  { .ov = 43, .code = 0x1d29, .word = 0xf420, .immediate=0, .flags=0x00, .name = "WF420" },
  { .ov = 43, .code = 0x1d29, .word = 0xf424, .immediate=0, .flags=0x00, .name = "WF424" },
  { .ov = 43, .code = 0x224c, .word = 0xf429, .immediate=0, .flags=0x00, .name = "WF429" },
  { .ov = 43, .code = 0x224c, .word = 0xf483, .immediate=0, .flags=0x00, .name = "WF483" },
  { .ov = 43, .code = 0x224c, .word = 0xf4a1, .immediate=0, .flags=0x00, .name = "WF4A1" },
  { .ov = 43, .code = 0x224c, .word = 0xf4ad, .immediate=0, .flags=0x00, .name = "WF4AD" },
  { .ov = 43, .code = 0x224c, .word = 0xf4d3, .immediate=0, .flags=0x00, .name = "WF4D3" },
  { .ov = 43, .code = 0x224c, .word = 0xf52d, .immediate=0, .flags=0x80, .name = "OBITS" },
  { .ov = 43, .code = 0x224c, .word = 0xf53c, .immediate=0, .flags=0x80, .name = "KILL" },
  { .ov = 43, .code = 0x224c, .word = 0xf551, .immediate=0, .flags=0x80, .name = "HEAL" },
  { .ov = 44, .code = 0x2214, .word = 0xeef6, .immediate=0, .flags=0x00, .name = "WEEF6" },
  { .ov = 44, .code = 0x7420, .word = 0xeefa, .immediate=0, .flags=0x00, .name = "WEEFA" },
  { .ov = 44, .code = 0x7420, .word = 0xeeff, .immediate=0, .flags=0x00, .name = "WEEFF" },
  { .ov = 44, .code = 0x7420, .word = 0xef04, .immediate=0, .flags=0x00, .name = "WEF04" },
  { .ov = 44, .code = 0x7420, .word = 0xef09, .immediate=0, .flags=0x00, .name = "WEF09" },
  { .ov = 44, .code = 0x7420, .word = 0xef0e, .immediate=0, .flags=0x00, .name = "WEF0E" },
  { .ov = 44, .code = 0x7420, .word = 0xef13, .immediate=0, .flags=0x00, .name = "WEF13" },
  { .ov = 44, .code = 0x7420, .word = 0xef18, .immediate=0, .flags=0x00, .name = "WEF18" },
  { .ov = 44, .code = 0x7420, .word = 0xef1d, .immediate=0, .flags=0x00, .name = "WEF1D" },
  { .ov = 44, .code = 0x7420, .word = 0xef22, .immediate=0, .flags=0x00, .name = "WEF22" },
  { .ov = 44, .code = 0x7420, .word = 0xef27, .immediate=0, .flags=0x00, .name = "WEF27" },
  { .ov = 44, .code = 0x7420, .word = 0xef2c, .immediate=0, .flags=0x00, .name = "WEF2C" },
  { .ov = 44, .code = 0x7420, .word = 0xef31, .immediate=0, .flags=0x00, .name = "WEF31" },
  { .ov = 44, .code = 0x7420, .word = 0xef36, .immediate=0, .flags=0x00, .name = "WEF36" },
  { .ov = 44, .code = 0x4b3b, .word = 0xef44, .immediate=0, .flags=0x80, .name = ">FIELD" },
  { .ov = 44, .code = 0x1d29, .word = 0xef66, .immediate=0, .flags=0x00, .name = "WEF66" },
  { .ov = 44, .code = 0x1d29, .word = 0xef6a, .immediate=0, .flags=0x00, .name = "WEF6A" },
  { .ov = 44, .code = 0x1d29, .word = 0xef6e, .immediate=0, .flags=0x00, .name = "WEF6E" },
  { .ov = 44, .code = 0x1d29, .word = 0xef72, .immediate=0, .flags=0x00, .name = "WEF72" },
  { .ov = 44, .code = 0x224c, .word = 0xef76, .immediate=0, .flags=0x00, .name = "WEF76" },
  { .ov = 44, .code = 0x224c, .word = 0xef7e, .immediate=0, .flags=0x00, .name = "WEF7E" },
  { .ov = 44, .code = 0x224c, .word = 0xef86, .immediate=0, .flags=0x00, .name = "WEF86" },
  { .ov = 44, .code = 0x224c, .word = 0xef8e, .immediate=0, .flags=0x00, .name = "WEF8E" },
  { .ov = 44, .code = 0x224c, .word = 0xef96, .immediate=0, .flags=0x00, .name = "WEF96" },
  { .ov = 44, .code = 0x224c, .word = 0xef9e, .immediate=0, .flags=0x00, .name = "WEF9E" },
  { .ov = 44, .code = 0x224c, .word = 0xefae, .immediate=0, .flags=0x00, .name = "WEFAE" },
  { .ov = 44, .code = 0x224c, .word = 0xefba, .immediate=0, .flags=0x00, .name = "WEFBA" },
  { .ov = 44, .code = 0x224c, .word = 0xefca, .immediate=0, .flags=0x00, .name = "WEFCA" },
  { .ov = 44, .code = 0x224c, .word = 0xefe0, .immediate=0, .flags=0x00, .name = "WEFE0" },
  { .ov = 44, .code = 0x224c, .word = 0xf000, .immediate=0, .flags=0x00, .name = "WF000" },
  { .ov = 44, .code = 0x224c, .word = 0xf010, .immediate=0, .flags=0x00, .name = "WF010" },
  { .ov = 44, .code = 0x224c, .word = 0xf01c, .immediate=0, .flags=0x00, .name = "WF01C" },
  { .ov = 44, .code = 0x1d29, .word = 0xf05a, .immediate=0, .flags=0x00, .name = "WF05A" },
  { .ov = 44, .code = 0x224c, .word = 0xf05e, .immediate=0, .flags=0x00, .name = "WF05E" },
  { .ov = 44, .code = 0x224c, .word = 0xf0a6, .immediate=0, .flags=0x00, .name = "WF0A6" },
  { .ov = 44, .code = 0x1d29, .word = 0xf0e4, .immediate=0, .flags=0x00, .name = "WF0E4" },
  { .ov = 44, .code = 0x224c, .word = 0xf0f0, .immediate=0, .flags=0x00, .name = "WF0F0" },
  { .ov = 44, .code = 0x224c, .word = 0xf108, .immediate=0, .flags=0x00, .name = "WF108" },
  { .ov = 44, .code = 0x224c, .word = 0xf12e, .immediate=0, .flags=0x00, .name = "WF12E" },
  { .ov = 44, .code = 0x224c, .word = 0xf142, .immediate=0, .flags=0x00, .name = "WF142" },
  { .ov = 44, .code = 0x224c, .word = 0xf150, .immediate=0, .flags=0x00, .name = "WF150" },
  { .ov = 44, .code = 0x224c, .word = 0xf1a2, .immediate=0, .flags=0x00, .name = "WF1A2" },
  { .ov = 44, .code = 0x224c, .word = 0xf1c6, .immediate=0, .flags=0x00, .name = "WF1C6" },
  { .ov = 44, .code = 0x224c, .word = 0xf1e0, .immediate=0, .flags=0x00, .name = "WF1E0" },
  { .ov = 44, .code = 0x224c, .word = 0xf204, .immediate=0, .flags=0x00, .name = "WF204" },
  { .ov = 44, .code = 0x224c, .word = 0xf228, .immediate=0, .flags=0x00, .name = "WF228" },
  { .ov = 44, .code = 0x224c, .word = 0xf258, .immediate=0, .flags=0x00, .name = "WF258" },
  { .ov = 44, .code = 0x224c, .word = 0xf278, .immediate=0, .flags=0x00, .name = "WF278" },
  { .ov = 44, .code = 0x224c, .word = 0xf28e, .immediate=0, .flags=0x00, .name = "WF28E" },
  { .ov = 44, .code = 0x224c, .word = 0xf2c2, .immediate=0, .flags=0x00, .name = "WF2C2" },
  { .ov = 44, .code = 0x224c, .word = 0xf2e0, .immediate=0, .flags=0x00, .name = "WF2E0" },
  { .ov = 44, .code = 0x224c, .word = 0xf2f4, .immediate=0, .flags=0x00, .name = "WF2F4" },
  { .ov = 44, .code = 0x224c, .word = 0xf2fc, .immediate=0, .flags=0x00, .name = "WF2FC" },
  { .ov = 44, .code = 0x224c, .word = 0xf312, .immediate=0, .flags=0x00, .name = "WF312" },
  { .ov = 44, .code = 0x224c, .word = 0xf338, .immediate=0, .flags=0x00, .name = "WF338" },
  { .ov = 44, .code = 0x224c, .word = 0xf346, .immediate=0, .flags=0x00, .name = "WF346" },
  { .ov = 44, .code = 0x224c, .word = 0xf362, .immediate=0, .flags=0x00, .name = "WF362" },
  { .ov = 44, .code = 0x224c, .word = 0xf37d, .immediate=0, .flags=0x00, .name = "WF37D" },
  { .ov = 44, .code = 0x224c, .word = 0xf3b1, .immediate=0, .flags=0x00, .name = "WF3B1" },
  { .ov = 44, .code = 0x224c, .word = 0xf3ed, .immediate=0, .flags=0x00, .name = "WF3ED" },
  { .ov = 44, .code = 0x224c, .word = 0xf40d, .immediate=0, .flags=0x00, .name = "WF40D" },
  { .ov = 44, .code = 0x224c, .word = 0xf417, .immediate=0, .flags=0x00, .name = "WF417" },
  { .ov = 44, .code = 0x224c, .word = 0xf429, .immediate=0, .flags=0x00, .name = "WF429" },
  { .ov = 44, .code = 0x224c, .word = 0xf46b, .immediate=0, .flags=0x00, .name = "WF46B" },
  { .ov = 44, .code = 0x224c, .word = 0xf481, .immediate=0, .flags=0x00, .name = "WF481" },
  { .ov = 44, .code = 0x224c, .word = 0xf4cb, .immediate=0, .flags=0x00, .name = "WF4CB" },
  { .ov = 44, .code = 0x224c, .word = 0xf4df, .immediate=0, .flags=0x00, .name = "WF4DF" },
  { .ov = 44, .code = 0x224c, .word = 0xf505, .immediate=0, .flags=0x80, .name = "DO-REPA" },
  { .ov = 45, .code = 0x2214, .word = 0xed66, .immediate=0, .flags=0x00, .name = "WED66" },
  { .ov = 45, .code = 0x2214, .word = 0xed6a, .immediate=0, .flags=0x00, .name = "WED6A" },
  { .ov = 45, .code = 0x2214, .word = 0xed6e, .immediate=0, .flags=0x00, .name = "WED6E" },
  { .ov = 45, .code = 0x7394, .word = 0xed72, .immediate=0, .flags=0x00, .name = "WED72" },
  { .ov = 45, .code = 0x7394, .word = 0xed7a, .immediate=0, .flags=0x00, .name = "WED7A" },
  { .ov = 45, .code = 0x7394, .word = 0xed82, .immediate=0, .flags=0x00, .name = "WED82" },
  { .ov = 45, .code = 0x7394, .word = 0xed8a, .immediate=0, .flags=0x00, .name = "WED8A" },
  { .ov = 45, .code = 0x7394, .word = 0xed92, .immediate=0, .flags=0x00, .name = "WED92" },
  { .ov = 45, .code = 0x7394, .word = 0xed9a, .immediate=0, .flags=0x00, .name = "WED9A" },
  { .ov = 45, .code = 0x7394, .word = 0xeda2, .immediate=0, .flags=0x00, .name = "WEDA2" },
  { .ov = 45, .code = 0x7394, .word = 0xedaa, .immediate=0, .flags=0x00, .name = "WEDAA" },
  { .ov = 45, .code = 0x7394, .word = 0xedb2, .immediate=0, .flags=0x00, .name = "WEDB2" },
  { .ov = 45, .code = 0x7394, .word = 0xedba, .immediate=0, .flags=0x00, .name = "WEDBA" },
  { .ov = 45, .code = 0x7394, .word = 0xedc2, .immediate=0, .flags=0x00, .name = "WEDC2" },
  { .ov = 45, .code = 0x7394, .word = 0xedca, .immediate=0, .flags=0x00, .name = "WEDCA" },
  { .ov = 45, .code = 0x7394, .word = 0xedd2, .immediate=0, .flags=0x00, .name = "WEDD2" },
  { .ov = 45, .code = 0x224c, .word = 0xedda, .immediate=0, .flags=0x00, .name = "WEDDA" },
  { .ov = 45, .code = 0x224c, .word = 0xedf1, .immediate=0, .flags=0x00, .name = "WEDF1" },
  { .ov = 45, .code = 0x224c, .word = 0xedfd, .immediate=0, .flags=0x00, .name = "WEDFD" },
  { .ov = 45, .code = 0x7420, .word = 0xee09, .immediate=0, .flags=0x00, .name = "WEE09" },
  { .ov = 45, .code = 0x224c, .word = 0xee0e, .immediate=0, .flags=0x00, .name = "WEE0E" },
  { .ov = 45, .code = 0x224c, .word = 0xee44, .immediate=0, .flags=0x00, .name = "WEE44" },
  { .ov = 45, .code = 0x224c, .word = 0xeea4, .immediate=0, .flags=0x00, .name = "WEEA4" },
  { .ov = 45, .code = 0xede2, .word = 0xeeca, .immediate=0, .flags=0x80, .name = "LO-MASS" },
  { .ov = 45, .code = 0xede2, .word = 0xeee6, .immediate=0, .flags=0x80, .name = "HI-MASS" },
  { .ov = 45, .code = 0x224c, .word = 0xeef8, .immediate=0, .flags=0x00, .name = "WEEF8" },
  { .ov = 45, .code = 0x224c, .word = 0xef0e, .immediate=0, .flags=0x00, .name = "WEF0E" },
  { .ov = 45, .code = 0x224c, .word = 0xef3e, .immediate=0, .flags=0x00, .name = "WEF3E" },
  { .ov = 45, .code = 0x224c, .word = 0xef5c, .immediate=0, .flags=0x00, .name = "WEF5C" },
  { .ov = 45, .code = 0x224c, .word = 0xef8a, .immediate=0, .flags=0x00, .name = "WEF8A" },
  { .ov = 45, .code = 0x224c, .word = 0xefe0, .immediate=0, .flags=0x00, .name = "WEFE0" },
  { .ov = 45, .code = 0x224c, .word = 0xf072, .immediate=0, .flags=0x00, .name = "WF072" },
  { .ov = 45, .code = 0x224c, .word = 0xf082, .immediate=0, .flags=0x00, .name = "WF082" },
  { .ov = 45, .code = 0x224c, .word = 0xf0e2, .immediate=0, .flags=0x00, .name = "WF0E2" },
  { .ov = 45, .code = 0x224c, .word = 0xf114, .immediate=0, .flags=0x00, .name = "WF114" },
  { .ov = 45, .code = 0x224c, .word = 0xf136, .immediate=0, .flags=0x00, .name = "WF136" },
  { .ov = 45, .code = 0x224c, .word = 0xf140, .immediate=0, .flags=0x00, .name = "WF140" },
  { .ov = 45, .code = 0x224c, .word = 0xf14c, .immediate=0, .flags=0x00, .name = "WF14C" },
  { .ov = 45, .code = 0x1d29, .word = 0xf167, .immediate=0, .flags=0x80, .name = "SUBHYDRO" },
  { .ov = 45, .code = 0x1d29, .word = 0xf179, .immediate=0, .flags=0x80, .name = "TEMPHYDR" },
  { .ov = 45, .code = 0x1d29, .word = 0xf18e, .immediate=0, .flags=0x80, .name = "INFHYDRO" },
  { .ov = 45, .code = 0x1d29, .word = 0xf1a1, .immediate=0, .flags=0x80, .name = "SUBATMO" },
  { .ov = 45, .code = 0x1d29, .word = 0xf1b3, .immediate=0, .flags=0x80, .name = "TEMPATMO" },
  { .ov = 45, .code = 0x1d29, .word = 0xf1c8, .immediate=0, .flags=0x80, .name = "INFATMO" },
  { .ov = 45, .code = 0x224c, .word = 0xf1d1, .immediate=0, .flags=0x00, .name = "WF1D1" },
  { .ov = 45, .code = 0x224c, .word = 0xf1e1, .immediate=0, .flags=0x00, .name = "WF1E1" },
  { .ov = 45, .code = 0x224c, .word = 0xf21b, .immediate=0, .flags=0x00, .name = "WF21B" },
  { .ov = 45, .code = 0x224c, .word = 0xf247, .immediate=0, .flags=0x00, .name = "WF247" },
  { .ov = 45, .code = 0x224c, .word = 0xf283, .immediate=0, .flags=0x00, .name = "WF283" },
  { .ov = 45, .code = 0x224c, .word = 0xf2a1, .immediate=0, .flags=0x00, .name = "WF2A1" },
  { .ov = 45, .code = 0x224c, .word = 0xf2dd, .immediate=0, .flags=0x00, .name = "WF2DD" },
  { .ov = 45, .code = 0x224c, .word = 0xf2f7, .immediate=0, .flags=0x00, .name = "WF2F7" },
  { .ov = 45, .code = 0x224c, .word = 0xf329, .immediate=0, .flags=0x00, .name = "WF329" },
  { .ov = 45, .code = 0x1d29, .word = 0xf33e, .immediate=0, .flags=0x80, .name = "RUGS" },
  { .ov = 45, .code = 0x224c, .word = 0xf360, .immediate=0, .flags=0x00, .name = "WF360" },
  { .ov = 45, .code = 0x224c, .word = 0xf374, .immediate=0, .flags=0x00, .name = "WF374" },
  { .ov = 45, .code = 0x224c, .word = 0xf38a, .immediate=0, .flags=0x00, .name = "WF38A" },
  { .ov = 45, .code = 0x224c, .word = 0xf39a, .immediate=0, .flags=0x00, .name = "WF39A" },
  { .ov = 45, .code = 0x1d29, .word = 0xf3b5, .immediate=0, .flags=0x80, .name = "CLIST1" },
  { .ov = 45, .code = 0x1d29, .word = 0xf3d4, .immediate=0, .flags=0x80, .name = "CLIST2" },
  { .ov = 45, .code = 0x1d29, .word = 0xf3f3, .immediate=0, .flags=0x80, .name = "CLIST3" },
  { .ov = 45, .code = 0x224c, .word = 0xf409, .immediate=0, .flags=0x00, .name = "WF409" },
  { .ov = 45, .code = 0x1d29, .word = 0xf428, .immediate=0, .flags=0x80, .name = "(SAND)" },
  { .ov = 45, .code = 0x224c, .word = 0xf43a, .immediate=0, .flags=0x00, .name = "WF43A" },
  { .ov = 45, .code = 0x224c, .word = 0xf48e, .immediate=0, .flags=0x00, .name = "WF48E" },
  { .ov = 45, .code = 0x224c, .word = 0xf49c, .immediate=0, .flags=0x00, .name = "WF49C" },
  { .ov = 45, .code = 0x224c, .word = 0xf4b4, .immediate=0, .flags=0x00, .name = "WF4B4" },
  { .ov = 45, .code = 0x4b3b, .word = 0xf4d3, .immediate=0, .flags=0x80, .name = "(TERRAIN" },
  { .ov = 45, .code = 0x224c, .word = 0xf4ed, .immediate=0, .flags=0x00, .name = "WF4ED" },
  { .ov = 45, .code = 0x224c, .word = 0xf4f7, .immediate=0, .flags=0x00, .name = "WF4F7" },
  { .ov = 45, .code = 0x224c, .word = 0xf501, .immediate=0, .flags=0x00, .name = "WF501" },
  { .ov = 45, .code = 0x224c, .word = 0xf528, .immediate=0, .flags=0x80, .name = "PLAN-RUL" },
  { .ov = 46, .code = 0x2214, .word = 0xecf6, .immediate=0, .flags=0x00, .name = "WECF6" },
  { .ov = 46, .code = 0x7394, .word = 0xecfa, .immediate=0, .flags=0x00, .name = "WECFA" },
  { .ov = 46, .code = 0x7394, .word = 0xed02, .immediate=0, .flags=0x00, .name = "WED02" },
  { .ov = 46, .code = 0x7394, .word = 0xed0a, .immediate=0, .flags=0x00, .name = "WED0A" },
  { .ov = 46, .code = 0x7394, .word = 0xed12, .immediate=0, .flags=0x00, .name = "WED12" },
  { .ov = 46, .code = 0x7394, .word = 0xed1a, .immediate=0, .flags=0x00, .name = "WED1A" },
  { .ov = 46, .code = 0x7394, .word = 0xed22, .immediate=0, .flags=0x00, .name = "WED22" },
  { .ov = 46, .code = 0x7394, .word = 0xed2a, .immediate=0, .flags=0x00, .name = "WED2A" },
  { .ov = 46, .code = 0x7394, .word = 0xed32, .immediate=0, .flags=0x00, .name = "WED32" },
  { .ov = 46, .code = 0x7394, .word = 0xed3a, .immediate=0, .flags=0x00, .name = "WED3A" },
  { .ov = 46, .code = 0x2214, .word = 0xed42, .immediate=0, .flags=0x00, .name = "WED42" },
  { .ov = 46, .code = 0x7394, .word = 0xed46, .immediate=0, .flags=0x00, .name = "WED46" },
  { .ov = 46, .code = 0x224c, .word = 0xed4e, .immediate=0, .flags=0x00, .name = "WED4E" },
  { .ov = 46, .code = 0x224c, .word = 0xeda0, .immediate=0, .flags=0x00, .name = "WEDA0" },
  { .ov = 46, .code = 0x224c, .word = 0xedb8, .immediate=0, .flags=0x00, .name = "WEDB8" },
  { .ov = 46, .code = 0x224c, .word = 0xedea, .immediate=0, .flags=0x00, .name = "WEDEA" },
  { .ov = 46, .code = 0x7394, .word = 0xee1a, .immediate=0, .flags=0x00, .name = "WEE1A" },
  { .ov = 46, .code = 0x224c, .word = 0xee22, .immediate=0, .flags=0x00, .name = "WEE22" },
  { .ov = 46, .code = 0x224c, .word = 0xee4e, .immediate=0, .flags=0x00, .name = "WEE4E" },
  { .ov = 46, .code = 0x224c, .word = 0xee66, .immediate=0, .flags=0x00, .name = "WEE66" },
  { .ov = 46, .code = 0x224c, .word = 0xee72, .immediate=0, .flags=0x00, .name = "WEE72" },
  { .ov = 46, .code = 0x224c, .word = 0xee82, .immediate=0, .flags=0x00, .name = "WEE82" },
  { .ov = 46, .code = 0x224c, .word = 0xee90, .immediate=0, .flags=0x00, .name = "WEE90" },
  { .ov = 46, .code = 0x224c, .word = 0xef06, .immediate=0, .flags=0x00, .name = "WEF06" },
  { .ov = 46, .code = 0x224c, .word = 0xef2b, .immediate=0, .flags=0x80, .name = "2X2CONTOUR" },
  { .ov = 46, .code = 0x224c, .word = 0xef6e, .immediate=0, .flags=0x80, .name = "4X4CONTOUR" },
  { .ov = 46, .code = 0x1d29, .word = 0xefb7, .immediate=0, .flags=0x80, .name = "CBLT" },
  { .ov = 46, .code = 0xefc5, .word = 0xefc5, .immediate=0, .flags=0x80, .name = "CBLTP" },
  { .ov = 46, .code = 0x224c, .word = 0xeff3, .immediate=0, .flags=0x00, .name = "WEFF3" },
  { .ov = 46, .code = 0x224c, .word = 0xf0c0, .immediate=0, .flags=0x80, .name = "8X8CONTOUR" },
  { .ov = 46, .code = 0x1d29, .word = 0xf109, .immediate=0, .flags=0x80, .name = "'4X4" },
  { .ov = 46, .code = 0x1d29, .word = 0xf114, .immediate=0, .flags=0x80, .name = "'2X2" },
  { .ov = 46, .code = 0x1d29, .word = 0xf11f, .immediate=0, .flags=0x80, .name = "'8X8" },
  { .ov = 46, .code = 0x224c, .word = 0xf123, .immediate=0, .flags=0x00, .name = "WF123" },
  { .ov = 46, .code = 0x224c, .word = 0xf175, .immediate=0, .flags=0x00, .name = "WF175" },
  { .ov = 46, .code = 0x224c, .word = 0xf1bd, .immediate=0, .flags=0x00, .name = "WF1BD" },
  { .ov = 46, .code = 0x224c, .word = 0xf20d, .immediate=0, .flags=0x00, .name = "WF20D" },
  { .ov = 46, .code = 0x224c, .word = 0xf217, .immediate=0, .flags=0x00, .name = "WF217" },
  { .ov = 46, .code = 0x224c, .word = 0xf221, .immediate=0, .flags=0x00, .name = "WF221" },
  { .ov = 46, .code = 0x224c, .word = 0xf22b, .immediate=0, .flags=0x00, .name = "WF22B" },
  { .ov = 46, .code = 0x224c, .word = 0xf235, .immediate=0, .flags=0x00, .name = "WF235" },
  { .ov = 46, .code = 0x224c, .word = 0xf23f, .immediate=0, .flags=0x00, .name = "WF23F" },
  { .ov = 46, .code = 0x224c, .word = 0xf249, .immediate=0, .flags=0x00, .name = "WF249" },
  { .ov = 46, .code = 0x224c, .word = 0xf253, .immediate=0, .flags=0x00, .name = "WF253" },
  { .ov = 46, .code = 0x224c, .word = 0xf25d, .immediate=0, .flags=0x00, .name = "WF25D" },
  { .ov = 46, .code = 0x224c, .word = 0xf267, .immediate=0, .flags=0x00, .name = "WF267" },
  { .ov = 46, .code = 0x224c, .word = 0xf271, .immediate=0, .flags=0x00, .name = "WF271" },
  { .ov = 46, .code = 0x224c, .word = 0xf27b, .immediate=0, .flags=0x00, .name = "WF27B" },
  { .ov = 46, .code = 0x224c, .word = 0xf285, .immediate=0, .flags=0x00, .name = "WF285" },
  { .ov = 46, .code = 0x224c, .word = 0xf28f, .immediate=0, .flags=0x00, .name = "WF28F" },
  { .ov = 46, .code = 0x4b3b, .word = 0xf2a3, .immediate=0, .flags=0x80, .name = "WPHRASE" },
  { .ov = 46, .code = 0x224c, .word = 0xf2ec, .immediate=0, .flags=0x80, .name = "(.STORM)" },
  { .ov = 46, .code = 0x224c, .word = 0xf310, .immediate=0, .flags=0x80, .name = ".ROCK" },
  { .ov = 46, .code = 0x224c, .word = 0xf334, .immediate=0, .flags=0x80, .name = ".LIQUID" },
  { .ov = 46, .code = 0x224c, .word = 0xf357, .immediate=0, .flags=0x80, .name = ".CRYSTAL" },
  { .ov = 46, .code = 0x224c, .word = 0xf36a, .immediate=0, .flags=0x80, .name = ".ICE" },
  { .ov = 46, .code = 0x224c, .word = 0xf390, .immediate=0, .flags=0x80, .name = ".MOLTEN" },
  { .ov = 46, .code = 0x224c, .word = 0xf3ac, .immediate=0, .flags=0x80, .name = ".CARPET" },
  { .ov = 46, .code = 0x4b3b, .word = 0xf3e7, .immediate=0, .flags=0x80, .name = "/SURF" },
  { .ov = 46, .code = 0x224c, .word = 0xf40c, .immediate=0, .flags=0x80, .name = ".SURFACE" },
  { .ov = 46, .code = 0x224c, .word = 0xf41e, .immediate=0, .flags=0x00, .name = "WF41E" },
  { .ov = 46, .code = 0x224c, .word = 0xf426, .immediate=0, .flags=0x00, .name = "WF426" },
  { .ov = 46, .code = 0x224c, .word = 0xf42e, .immediate=0, .flags=0x00, .name = "WF42E" },
  { .ov = 46, .code = 0x224c, .word = 0xf442, .immediate=0, .flags=0x00, .name = "WF442" },
  { .ov = 46, .code = 0x224c, .word = 0xf45a, .immediate=0, .flags=0x00, .name = "WF45A" },
  { .ov = 46, .code = 0x224c, .word = 0xf473, .immediate=0, .flags=0x00, .name = "WF473" },
  { .ov = 46, .code = 0x224c, .word = 0xf47b, .immediate=0, .flags=0x00, .name = "WF47B" },
  { .ov = 46, .code = 0x224c, .word = 0xf4a0, .immediate=0, .flags=0x00, .name = "WF4A0" },
  { .ov = 46, .code = 0x224c, .word = 0xf4b5, .immediate=0, .flags=0x00, .name = "WF4B5" },
  { .ov = 46, .code = 0x224c, .word = 0xf4e2, .immediate=0, .flags=0x00, .name = "WF4E2" },
  { .ov = 46, .code = 0x224c, .word = 0xf4ff, .immediate=0, .flags=0x80, .name = "MAPS" },
  { .ov = 46, .code = 0x224c, .word = 0xf53a, .immediate=0, .flags=0x80, .name = ".STORM" },
  { .ov = 47, .code = 0x224c, .word = 0xf126, .immediate=0, .flags=0x00, .name = "WF126" },
  { .ov = 47, .code = 0x224c, .word = 0xf134, .immediate=0, .flags=0x00, .name = "WF134" },
  { .ov = 47, .code = 0x224c, .word = 0xf1cc, .immediate=0, .flags=0x00, .name = "WF1CC" },
  { .ov = 47, .code = 0x224c, .word = 0xf1f4, .immediate=0, .flags=0x00, .name = "WF1F4" },
  { .ov = 47, .code = 0xf14c, .word = 0xf20b, .immediate=0, .flags=0x80, .name = "STORMS" },
  { .ov = 47, .code = 0x7420, .word = 0xf2c3, .immediate=0, .flags=0x00, .name = "WF2C3" },
  { .ov = 47, .code = 0x7420, .word = 0xf2c8, .immediate=0, .flags=0x00, .name = "WF2C8" },
  { .ov = 47, .code = 0x7394, .word = 0xf2cd, .immediate=0, .flags=0x00, .name = "WF2CD" },
  { .ov = 47, .code = 0x7394, .word = 0xf2d5, .immediate=0, .flags=0x00, .name = "WF2D5" },
  { .ov = 47, .code = 0x1d29, .word = 0xf2dd, .immediate=0, .flags=0x00, .name = "WF2DD" },
  { .ov = 47, .code = 0x224c, .word = 0xf2e1, .immediate=0, .flags=0x00, .name = "WF2E1" },
  { .ov = 47, .code = 0x224c, .word = 0xf2f5, .immediate=0, .flags=0x00, .name = "WF2F5" },
  { .ov = 47, .code = 0x7420, .word = 0xf301, .immediate=0, .flags=0x00, .name = "WF301" },
  { .ov = 47, .code = 0x7420, .word = 0xf306, .immediate=0, .flags=0x00, .name = "WF306" },
  { .ov = 47, .code = 0x7420, .word = 0xf30b, .immediate=0, .flags=0x00, .name = "WF30B" },
  { .ov = 47, .code = 0x7394, .word = 0xf310, .immediate=0, .flags=0x00, .name = "WF310" },
  { .ov = 47, .code = 0x224c, .word = 0xf318, .immediate=0, .flags=0x00, .name = "WF318" },
  { .ov = 47, .code = 0x224c, .word = 0xf332, .immediate=0, .flags=0x00, .name = "WF332" },
  { .ov = 47, .code = 0x224c, .word = 0xf35a, .immediate=0, .flags=0x00, .name = "WF35A" },
  { .ov = 47, .code = 0x224c, .word = 0xf374, .immediate=0, .flags=0x00, .name = "WF374" },
  { .ov = 47, .code = 0x224c, .word = 0xf3b8, .immediate=0, .flags=0x80, .name = "INJURE-PL" },
  { .ov = 47, .code = 0x224c, .word = 0xf41c, .immediate=0, .flags=0x00, .name = "WF41C" },
  { .ov = 47, .code = 0x224c, .word = 0xf468, .immediate=0, .flags=0x00, .name = "WF468" },
  { .ov = 47, .code = 0x224c, .word = 0xf4a6, .immediate=0, .flags=0x00, .name = "WF4A6" },
  { .ov = 47, .code = 0x224c, .word = 0xf4e2, .immediate=0, .flags=0x00, .name = "WF4E2" },
  { .ov = 47, .code = 0x224c, .word = 0xf502, .immediate=0, .flags=0x80, .name = "(DO.STORM" },
  { .ov = 48, .code = 0x224c, .word = 0xdd16, .immediate=0, .flags=0x00, .name = "WDD16" },
  { .ov = 48, .code = 0x1d29, .word = 0xdd20, .immediate=0, .flags=0x00, .name = "WDD20" },
  { .ov = 48, .code = 0x1d29, .word = 0xdd24, .immediate=0, .flags=0x00, .name = "WDD24" },
  { .ov = 48, .code = 0x1d29, .word = 0xdd28, .immediate=0, .flags=0x00, .name = "WDD28" },
  { .ov = 48, .code = 0x224c, .word = 0xdd2e, .immediate=0, .flags=0x00, .name = "WDD2E" },
  { .ov = 48, .code = 0x224c, .word = 0xdd36, .immediate=0, .flags=0x00, .name = "WDD36" },
  { .ov = 48, .code = 0x224c, .word = 0xdd42, .immediate=0, .flags=0x00, .name = "WDD42" },
  { .ov = 48, .code = 0x224c, .word = 0xdd4c, .immediate=0, .flags=0x00, .name = "WDD4C" },
  { .ov = 48, .code = 0x224c, .word = 0xdd5c, .immediate=0, .flags=0x00, .name = "WDD5C" },
  { .ov = 48, .code = 0x224c, .word = 0xdd64, .immediate=0, .flags=0x00, .name = "WDD64" },
  { .ov = 48, .code = 0x224c, .word = 0xdd70, .immediate=0, .flags=0x00, .name = "WDD70" },
  { .ov = 48, .code = 0x2214, .word = 0xdd80, .immediate=0, .flags=0x00, .name = "WDD80" },
  { .ov = 48, .code = 0x7394, .word = 0xdd84, .immediate=0, .flags=0x00, .name = "WDD84" },
  { .ov = 48, .code = 0x7394, .word = 0xdd8c, .immediate=0, .flags=0x00, .name = "WDD8C" },
  { .ov = 48, .code = 0x7394, .word = 0xdd94, .immediate=0, .flags=0x00, .name = "WDD94" },
  { .ov = 48, .code = 0x7394, .word = 0xdd9c, .immediate=0, .flags=0x00, .name = "WDD9C" },
  { .ov = 48, .code = 0x7394, .word = 0xdda4, .immediate=0, .flags=0x00, .name = "WDDA4" },
  { .ov = 48, .code = 0x7420, .word = 0xddac, .immediate=0, .flags=0x00, .name = "WDDAC" },
  { .ov = 48, .code = 0x7420, .word = 0xddb1, .immediate=0, .flags=0x00, .name = "WDDB1" },
  { .ov = 48, .code = 0x7420, .word = 0xddb6, .immediate=0, .flags=0x00, .name = "WDDB6" },
  { .ov = 48, .code = 0x7420, .word = 0xddbb, .immediate=0, .flags=0x00, .name = "WDDBB" },
  { .ov = 48, .code = 0x7420, .word = 0xddc0, .immediate=0, .flags=0x00, .name = "WDDC0" },
  { .ov = 48, .code = 0x7420, .word = 0xddc5, .immediate=0, .flags=0x00, .name = "WDDC5" },
  { .ov = 48, .code = 0x2214, .word = 0xddca, .immediate=0, .flags=0x00, .name = "WDDCA" },
  { .ov = 48, .code = 0x7420, .word = 0xddce, .immediate=0, .flags=0x00, .name = "WDDCE" },
  { .ov = 48, .code = 0x7420, .word = 0xddd3, .immediate=0, .flags=0x00, .name = "WDDD3" },
  { .ov = 48, .code = 0x7420, .word = 0xddd8, .immediate=0, .flags=0x00, .name = "WDDD8" },
  { .ov = 48, .code = 0x7420, .word = 0xdddd, .immediate=0, .flags=0x00, .name = "WDDDD" },
  { .ov = 48, .code = 0x7420, .word = 0xdde2, .immediate=0, .flags=0x00, .name = "WDDE2" },
  { .ov = 48, .code = 0x7420, .word = 0xdde7, .immediate=0, .flags=0x00, .name = "WDDE7" },
  { .ov = 48, .code = 0x7420, .word = 0xddec, .immediate=0, .flags=0x00, .name = "WDDEC" },
  { .ov = 48, .code = 0x7420, .word = 0xddf1, .immediate=0, .flags=0x00, .name = "WDDF1" },
  { .ov = 48, .code = 0x7420, .word = 0xddf6, .immediate=0, .flags=0x00, .name = "WDDF6" },
  { .ov = 48, .code = 0x7420, .word = 0xddfb, .immediate=0, .flags=0x00, .name = "WDDFB" },
  { .ov = 48, .code = 0x7420, .word = 0xde00, .immediate=0, .flags=0x00, .name = "WDE00" },
  { .ov = 48, .code = 0x7420, .word = 0xde05, .immediate=0, .flags=0x00, .name = "WDE05" },
  { .ov = 48, .code = 0x7420, .word = 0xde0a, .immediate=0, .flags=0x00, .name = "WDE0A" },
  { .ov = 48, .code = 0x7420, .word = 0xde0f, .immediate=0, .flags=0x00, .name = "WDE0F" },
  { .ov = 48, .code = 0x7420, .word = 0xde14, .immediate=0, .flags=0x00, .name = "WDE14" },
  { .ov = 48, .code = 0x7420, .word = 0xde19, .immediate=0, .flags=0x00, .name = "WDE19" },
  { .ov = 48, .code = 0x7420, .word = 0xde1e, .immediate=0, .flags=0x00, .name = "WDE1E" },
  { .ov = 48, .code = 0x7420, .word = 0xde23, .immediate=0, .flags=0x00, .name = "WDE23" },
  { .ov = 48, .code = 0x7420, .word = 0xde28, .immediate=0, .flags=0x00, .name = "WDE28" },
  { .ov = 48, .code = 0x7420, .word = 0xde2d, .immediate=0, .flags=0x00, .name = "WDE2D" },
  { .ov = 48, .code = 0x7420, .word = 0xde32, .immediate=0, .flags=0x00, .name = "WDE32" },
  { .ov = 48, .code = 0x224c, .word = 0xde37, .immediate=0, .flags=0x00, .name = "WDE37" },
  { .ov = 48, .code = 0x1d29, .word = 0xde49, .immediate=0, .flags=0x00, .name = "WDE49" },
  { .ov = 48, .code = 0x1d29, .word = 0xde4f, .immediate=0, .flags=0x00, .name = "WDE4F" },
  { .ov = 48, .code = 0x1d29, .word = 0xde53, .immediate=0, .flags=0x00, .name = "WDE53" },
  { .ov = 48, .code = 0x1d29, .word = 0xde59, .immediate=0, .flags=0x00, .name = "WDE59" },
  { .ov = 48, .code = 0x224c, .word = 0xde5d, .immediate=0, .flags=0x00, .name = "WDE5D" },
  { .ov = 48, .code = 0x224c, .word = 0xde7b, .immediate=0, .flags=0x00, .name = "WDE7B" },
  { .ov = 48, .code = 0x224c, .word = 0xde85, .immediate=0, .flags=0x00, .name = "WDE85" },
  { .ov = 48, .code = 0x224c, .word = 0xde9f, .immediate=0, .flags=0x00, .name = "WDE9F" },
  { .ov = 48, .code = 0x224c, .word = 0xdeaf, .immediate=0, .flags=0x00, .name = "WDEAF" },
  { .ov = 48, .code = 0x224c, .word = 0xdecf, .immediate=0, .flags=0x00, .name = "WDECF" },
  { .ov = 48, .code = 0x224c, .word = 0xdf0b, .immediate=0, .flags=0x00, .name = "WDF0B" },
  { .ov = 48, .code = 0x224c, .word = 0xdf17, .immediate=0, .flags=0x00, .name = "WDF17" },
  { .ov = 48, .code = 0x4b3b, .word = 0xdf32, .immediate=0, .flags=0x80, .name = "X=-1" },
  { .ov = 48, .code = 0x4b3b, .word = 0xdf4a, .immediate=0, .flags=0x80, .name = "X=0" },
  { .ov = 48, .code = 0x4b3b, .word = 0xdf62, .immediate=0, .flags=0x80, .name = "X=1" },
  { .ov = 48, .code = 0x4b3b, .word = 0xdf81, .immediate=0, .flags=0x80, .name = "KEY>ORIENT" },
  { .ov = 48, .code = 0x224c, .word = 0xdf93, .immediate=0, .flags=0x00, .name = "WDF93" },
  { .ov = 48, .code = 0x224c, .word = 0xdfad, .immediate=0, .flags=0x00, .name = "WDFAD" },
  { .ov = 48, .code = 0x224c, .word = 0xdfb7, .immediate=0, .flags=0x00, .name = "WDFB7" },
  { .ov = 48, .code = 0x224c, .word = 0xdfc5, .immediate=0, .flags=0x00, .name = "WDFC5" },
  { .ov = 48, .code = 0x224c, .word = 0xdfd3, .immediate=0, .flags=0x00, .name = "WDFD3" },
  { .ov = 48, .code = 0x224c, .word = 0xdfe5, .immediate=0, .flags=0x00, .name = "WDFE5" },
  { .ov = 48, .code = 0x224c, .word = 0xdff3, .immediate=0, .flags=0x00, .name = "WDFF3" },
  { .ov = 48, .code = 0x224c, .word = 0xe001, .immediate=0, .flags=0x00, .name = "WE001" },
  { .ov = 48, .code = 0x224c, .word = 0xe00f, .immediate=0, .flags=0x00, .name = "WE00F" },
  { .ov = 48, .code = 0x224c, .word = 0xe019, .immediate=0, .flags=0x00, .name = "WE019" },
  { .ov = 48, .code = 0x224c, .word = 0xe037, .immediate=0, .flags=0x00, .name = "WE037" },
  { .ov = 48, .code = 0x224c, .word = 0xe055, .immediate=0, .flags=0x00, .name = "WE055" },
  { .ov = 48, .code = 0x7420, .word = 0xe093, .immediate=0, .flags=0x00, .name = "WE093" },
  { .ov = 48, .code = 0x224c, .word = 0xe098, .immediate=0, .flags=0x00, .name = "WE098" },
  { .ov = 48, .code = 0x224c, .word = 0xe0a2, .immediate=0, .flags=0x00, .name = "WE0A2" },
  { .ov = 48, .code = 0x224c, .word = 0xe0ae, .immediate=0, .flags=0x00, .name = "WE0AE" },
  { .ov = 48, .code = 0x3b74, .word = 0xe0c0, .immediate=0, .flags=0x00, .name = "WE0C0" },
  { .ov = 48, .code = 0x1d29, .word = 0xe0c6, .immediate=0, .flags=0x00, .name = "WE0C6" },
  { .ov = 48, .code = 0x224c, .word = 0xe0cc, .immediate=0, .flags=0x00, .name = "WE0CC" },
  { .ov = 48, .code = 0x224c, .word = 0xe0de, .immediate=0, .flags=0x00, .name = "WE0DE" },
  { .ov = 48, .code = 0x224c, .word = 0xe0ea, .immediate=0, .flags=0x00, .name = "WE0EA" },
  { .ov = 48, .code = 0x2214, .word = 0xe0f4, .immediate=0, .flags=0x00, .name = "WE0F4" },
  { .ov = 48, .code = 0x2214, .word = 0xe0f8, .immediate=0, .flags=0x00, .name = "WE0F8" },
  { .ov = 48, .code = 0x224c, .word = 0xe0fc, .immediate=0, .flags=0x00, .name = "WE0FC" },
  { .ov = 48, .code = 0x224c, .word = 0xe120, .immediate=0, .flags=0x00, .name = "WE120" },
  { .ov = 48, .code = 0x224c, .word = 0xe12a, .immediate=0, .flags=0x00, .name = "WE12A" },
  { .ov = 48, .code = 0x224c, .word = 0xe13a, .immediate=0, .flags=0x00, .name = "WE13A" },
  { .ov = 48, .code = 0x1d29, .word = 0xe148, .immediate=0, .flags=0x00, .name = "WE148" },
  { .ov = 48, .code = 0x1d29, .word = 0xe14c, .immediate=0, .flags=0x00, .name = "WE14C" },
  { .ov = 48, .code = 0x224c, .word = 0xe152, .immediate=0, .flags=0x00, .name = "WE152" },
  { .ov = 48, .code = 0x224c, .word = 0xe162, .immediate=0, .flags=0x00, .name = "WE162" },
  { .ov = 48, .code = 0x224c, .word = 0xe178, .immediate=0, .flags=0x00, .name = "WE178" },
  { .ov = 48, .code = 0x224c, .word = 0xe19c, .immediate=0, .flags=0x00, .name = "WE19C" },
  { .ov = 48, .code = 0x224c, .word = 0xe1c0, .immediate=0, .flags=0x00, .name = "WE1C0" },
  { .ov = 48, .code = 0x224c, .word = 0xe1cc, .immediate=0, .flags=0x00, .name = "WE1CC" },
  { .ov = 48, .code = 0x224c, .word = 0xe1d8, .immediate=0, .flags=0x00, .name = "WE1D8" },
  { .ov = 48, .code = 0x2214, .word = 0xe1e6, .immediate=0, .flags=0x00, .name = "WE1E6" },
  { .ov = 48, .code = 0x224c, .word = 0xe1ea, .immediate=0, .flags=0x00, .name = "WE1EA" },
  { .ov = 48, .code = 0x224c, .word = 0xe1fc, .immediate=0, .flags=0x00, .name = "WE1FC" },
  { .ov = 48, .code = 0x1d29, .word = 0xe21e, .immediate=0, .flags=0x00, .name = "WE21E" },
  { .ov = 48, .code = 0x224c, .word = 0xe222, .immediate=0, .flags=0x00, .name = "WE222" },
  { .ov = 48, .code = 0x224c, .word = 0xe23e, .immediate=0, .flags=0x00, .name = "WE23E" },
  { .ov = 48, .code = 0x224c, .word = 0xe24c, .immediate=0, .flags=0x00, .name = "WE24C" },
  { .ov = 48, .code = 0x224c, .word = 0xe262, .immediate=0, .flags=0x00, .name = "WE262" },
  { .ov = 48, .code = 0x224c, .word = 0xe27e, .immediate=0, .flags=0x00, .name = "WE27E" },
  { .ov = 48, .code = 0x224c, .word = 0xe29a, .immediate=0, .flags=0x00, .name = "WE29A" },
  { .ov = 48, .code = 0x2214, .word = 0xe2b6, .immediate=0, .flags=0x00, .name = "WE2B6" },
  { .ov = 48, .code = 0x2214, .word = 0xe2ba, .immediate=0, .flags=0x00, .name = "WE2BA" },
  { .ov = 48, .code = 0x1d29, .word = 0xe2be, .immediate=0, .flags=0x00, .name = "WE2BE" },
  { .ov = 48, .code = 0x7420, .word = 0xe2c2, .immediate=0, .flags=0x00, .name = "WE2C2" },
  { .ov = 48, .code = 0x7420, .word = 0xe2c7, .immediate=0, .flags=0x00, .name = "WE2C7" },
  { .ov = 48, .code = 0x7420, .word = 0xe2cc, .immediate=0, .flags=0x00, .name = "WE2CC" },
  { .ov = 48, .code = 0x7420, .word = 0xe2d1, .immediate=0, .flags=0x00, .name = "WE2D1" },
  { .ov = 48, .code = 0x7420, .word = 0xe2d6, .immediate=0, .flags=0x00, .name = "WE2D6" },
  { .ov = 48, .code = 0x7420, .word = 0xe2db, .immediate=0, .flags=0x00, .name = "WE2DB" },
  { .ov = 48, .code = 0x7420, .word = 0xe2e0, .immediate=0, .flags=0x00, .name = "WE2E0" },
  { .ov = 48, .code = 0x7420, .word = 0xe2e5, .immediate=0, .flags=0x00, .name = "WE2E5" },
  { .ov = 48, .code = 0x7420, .word = 0xe2ea, .immediate=0, .flags=0x00, .name = "WE2EA" },
  { .ov = 48, .code = 0x7420, .word = 0xe2ef, .immediate=0, .flags=0x00, .name = "WE2EF" },
  { .ov = 48, .code = 0x7420, .word = 0xe2f4, .immediate=0, .flags=0x00, .name = "WE2F4" },
  { .ov = 48, .code = 0x224c, .word = 0xe2f9, .immediate=0, .flags=0x00, .name = "WE2F9" },
  { .ov = 48, .code = 0x224c, .word = 0xe2ff, .immediate=0, .flags=0x00, .name = "WE2FF" },
  { .ov = 48, .code = 0x224c, .word = 0xe31d, .immediate=0, .flags=0x00, .name = "WE31D" },
  { .ov = 48, .code = 0x4b3b, .word = 0xe33b, .immediate=0, .flags=0x80, .name = "C>C" },
  { .ov = 48, .code = 0x224c, .word = 0xe34d, .immediate=0, .flags=0x00, .name = "WE34D" },
  { .ov = 48, .code = 0x224c, .word = 0xe357, .immediate=0, .flags=0x00, .name = "WE357" },
  { .ov = 48, .code = 0x224c, .word = 0xe363, .immediate=0, .flags=0x00, .name = "WE363" },
  { .ov = 48, .code = 0x224c, .word = 0xe36f, .immediate=0, .flags=0x00, .name = "WE36F" },
  { .ov = 48, .code = 0x224c, .word = 0xe377, .immediate=0, .flags=0x00, .name = "WE377" },
  { .ov = 48, .code = 0x224c, .word = 0xe383, .immediate=0, .flags=0x00, .name = "WE383" },
  { .ov = 48, .code = 0x224c, .word = 0xe397, .immediate=0, .flags=0x00, .name = "WE397" },
  { .ov = 48, .code = 0x224c, .word = 0xe3b9, .immediate=0, .flags=0x00, .name = "WE3B9" },
  { .ov = 48, .code = 0x4b3b, .word = 0xe3e6, .immediate=0, .flags=0x80, .name = "SCALE>.MIS" },
  { .ov = 48, .code = 0x224c, .word = 0xe3f8, .immediate=0, .flags=0x00, .name = "WE3F8" },
  { .ov = 48, .code = 0x224c, .word = 0xe414, .immediate=0, .flags=0x00, .name = "WE414" },
  { .ov = 48, .code = 0x224c, .word = 0xe424, .immediate=0, .flags=0x00, .name = "WE424" },
  { .ov = 48, .code = 0x224c, .word = 0xe442, .immediate=0, .flags=0x00, .name = "WE442" },
  { .ov = 48, .code = 0x224c, .word = 0xe452, .immediate=0, .flags=0x00, .name = "WE452" },
  { .ov = 48, .code = 0x224c, .word = 0xe49a, .immediate=0, .flags=0x00, .name = "WE49A" },
  { .ov = 48, .code = 0x224c, .word = 0xe4c0, .immediate=0, .flags=0x00, .name = "WE4C0" },
  { .ov = 48, .code = 0x224c, .word = 0xe4d0, .immediate=0, .flags=0x00, .name = "WE4D0" },
  { .ov = 48, .code = 0x224c, .word = 0xe4f0, .immediate=0, .flags=0x00, .name = "WE4F0" },
  { .ov = 48, .code = 0x224c, .word = 0xe516, .immediate=0, .flags=0x00, .name = "WE516" },
  { .ov = 48, .code = 0x224c, .word = 0xe536, .immediate=0, .flags=0x00, .name = "WE536" },
  { .ov = 48, .code = 0x2214, .word = 0xe56e, .immediate=0, .flags=0x00, .name = "WE56E" },
  { .ov = 48, .code = 0x224c, .word = 0xe572, .immediate=0, .flags=0x00, .name = "WE572" },
  { .ov = 48, .code = 0x224c, .word = 0xe5be, .immediate=0, .flags=0x00, .name = "WE5BE" },
  { .ov = 48, .code = 0x224c, .word = 0xe612, .immediate=0, .flags=0x00, .name = "WE612" },
  { .ov = 48, .code = 0x224c, .word = 0xe61a, .immediate=0, .flags=0x00, .name = "WE61A" },
  { .ov = 48, .code = 0x224c, .word = 0xe664, .immediate=0, .flags=0x00, .name = "WE664" },
  { .ov = 48, .code = 0x224c, .word = 0xe686, .immediate=0, .flags=0x00, .name = "WE686" },
  { .ov = 48, .code = 0x224c, .word = 0xe690, .immediate=0, .flags=0x00, .name = "WE690" },
  { .ov = 48, .code = 0x224c, .word = 0xe6c4, .immediate=0, .flags=0x00, .name = "WE6C4" },
  { .ov = 48, .code = 0x224c, .word = 0xe6d8, .immediate=0, .flags=0x00, .name = "WE6D8" },
  { .ov = 48, .code = 0x224c, .word = 0xe704, .immediate=0, .flags=0x00, .name = "WE704" },
  { .ov = 48, .code = 0x224c, .word = 0xe71c, .immediate=0, .flags=0x00, .name = "WE71C" },
  { .ov = 48, .code = 0x224c, .word = 0xe72c, .immediate=0, .flags=0x00, .name = "WE72C" },
  { .ov = 48, .code = 0x224c, .word = 0xe754, .immediate=0, .flags=0x00, .name = "WE754" },
  { .ov = 48, .code = 0x224c, .word = 0xe764, .immediate=0, .flags=0x00, .name = "WE764" },
  { .ov = 48, .code = 0x224c, .word = 0xe7a8, .immediate=0, .flags=0x00, .name = "WE7A8" },
  { .ov = 48, .code = 0x224c, .word = 0xe7ec, .immediate=0, .flags=0x00, .name = "WE7EC" },
  { .ov = 48, .code = 0x224c, .word = 0xe812, .immediate=0, .flags=0x00, .name = "WE812" },
  { .ov = 48, .code = 0x224c, .word = 0xe840, .immediate=0, .flags=0x00, .name = "WE840" },
  { .ov = 48, .code = 0x224c, .word = 0xe852, .immediate=0, .flags=0x00, .name = "WE852" },
  { .ov = 48, .code = 0x224c, .word = 0xe86e, .immediate=0, .flags=0x00, .name = "WE86E" },
  { .ov = 48, .code = 0x224c, .word = 0xe884, .immediate=0, .flags=0x00, .name = "WE884" },
  { .ov = 48, .code = 0x224c, .word = 0xe89a, .immediate=0, .flags=0x00, .name = "WE89A" },
  { .ov = 48, .code = 0x224c, .word = 0xe8c0, .immediate=0, .flags=0x00, .name = "WE8C0" },
  { .ov = 48, .code = 0x224c, .word = 0xe8ec, .immediate=0, .flags=0x00, .name = "WE8EC" },
  { .ov = 48, .code = 0x224c, .word = 0xe8fa, .immediate=0, .flags=0x00, .name = "WE8FA" },
  { .ov = 48, .code = 0x224c, .word = 0xe932, .immediate=0, .flags=0x00, .name = "WE932" },
  { .ov = 48, .code = 0x224c, .word = 0xe93e, .immediate=0, .flags=0x00, .name = "WE93E" },
  { .ov = 48, .code = 0x224c, .word = 0xe966, .immediate=0, .flags=0x00, .name = "WE966" },
  { .ov = 48, .code = 0x224c, .word = 0xe9a2, .immediate=0, .flags=0x00, .name = "WE9A2" },
  { .ov = 48, .code = 0x224c, .word = 0xe9d4, .immediate=0, .flags=0x00, .name = "WE9D4" },
  { .ov = 48, .code = 0x1d29, .word = 0xea2c, .immediate=0, .flags=0x00, .name = "WEA2C" },
  { .ov = 48, .code = 0x224c, .word = 0xea32, .immediate=0, .flags=0x00, .name = "WEA32" },
  { .ov = 48, .code = 0x224c, .word = 0xea5e, .immediate=0, .flags=0x00, .name = "WEA5E" },
  { .ov = 48, .code = 0x224c, .word = 0xea90, .immediate=0, .flags=0x00, .name = "WEA90" },
  { .ov = 48, .code = 0x224c, .word = 0xeae4, .immediate=0, .flags=0x00, .name = "WEAE4" },
  { .ov = 48, .code = 0x224c, .word = 0xeb27, .immediate=0, .flags=0x00, .name = "WEB27" },
  { .ov = 48, .code = 0x224c, .word = 0xeb33, .immediate=0, .flags=0x00, .name = "WEB33" },
  { .ov = 48, .code = 0x224c, .word = 0xeb45, .immediate=0, .flags=0x00, .name = "WEB45" },
  { .ov = 48, .code = 0x224c, .word = 0xeb7b, .immediate=0, .flags=0x00, .name = "WEB7B" },
  { .ov = 48, .code = 0x224c, .word = 0xeb99, .immediate=0, .flags=0x00, .name = "WEB99" },
  { .ov = 48, .code = 0x224c, .word = 0xebb9, .immediate=0, .flags=0x00, .name = "WEBB9" },
  { .ov = 48, .code = 0x224c, .word = 0xebdd, .immediate=0, .flags=0x00, .name = "WEBDD" },
  { .ov = 48, .code = 0x224c, .word = 0xec15, .immediate=0, .flags=0x00, .name = "WEC15" },
  { .ov = 48, .code = 0x224c, .word = 0xec1d, .immediate=0, .flags=0x00, .name = "WEC1D" },
  { .ov = 48, .code = 0x224c, .word = 0xec31, .immediate=0, .flags=0x00, .name = "WEC31" },
  { .ov = 48, .code = 0x224c, .word = 0xec45, .immediate=0, .flags=0x00, .name = "WEC45" },
  { .ov = 48, .code = 0x224c, .word = 0xec6e, .immediate=0, .flags=0x80, .name = "?APPROACHI" },
  { .ov = 48, .code = 0x224c, .word = 0xec7a, .immediate=0, .flags=0x00, .name = "WEC7A" },
  { .ov = 48, .code = 0x224c, .word = 0xecaa, .immediate=0, .flags=0x00, .name = "WECAA" },
  { .ov = 48, .code = 0x224c, .word = 0xecda, .immediate=0, .flags=0x00, .name = "WECDA" },
  { .ov = 48, .code = 0x224c, .word = 0xece4, .immediate=0, .flags=0x00, .name = "WECE4" },
  { .ov = 48, .code = 0x224c, .word = 0xecf5, .immediate=0, .flags=0x80, .name = "?J" },
  { .ov = 48, .code = 0xaccc, .word = 0xed2e, .immediate=0, .flags=0x80, .name = "<COMBAT>" },
  { .ov = 48, .code = 0x224c, .word = 0xee11, .immediate=0, .flags=0x00, .name = "WEE11" },
  { .ov = 48, .code = 0x224c, .word = 0xee6f, .immediate=0, .flags=0x00, .name = "WEE6F" },
  { .ov = 48, .code = 0x224c, .word = 0xee8f, .immediate=0, .flags=0x00, .name = "WEE8F" },
  { .ov = 48, .code = 0x224c, .word = 0xef07, .immediate=0, .flags=0x00, .name = "WEF07" },
  { .ov = 48, .code = 0x224c, .word = 0xef0f, .immediate=0, .flags=0x00, .name = "WEF0F" },
  { .ov = 48, .code = 0x224c, .word = 0xef23, .immediate=0, .flags=0x00, .name = "WEF23" },
  { .ov = 48, .code = 0x224c, .word = 0xef33, .immediate=0, .flags=0x00, .name = "WEF33" },
  { .ov = 48, .code = 0x224c, .word = 0xef49, .immediate=0, .flags=0x00, .name = "WEF49" },
  { .ov = 48, .code = 0x224c, .word = 0xef7d, .immediate=0, .flags=0x00, .name = "WEF7D" },
  { .ov = 48, .code = 0x224c, .word = 0xef99, .immediate=0, .flags=0x00, .name = "WEF99" },
  { .ov = 48, .code = 0x224c, .word = 0xefb1, .immediate=0, .flags=0x00, .name = "WEFB1" },
  { .ov = 48, .code = 0x224c, .word = 0xefdb, .immediate=0, .flags=0x00, .name = "WEFDB" },
  { .ov = 48, .code = 0x224c, .word = 0xeffe, .immediate=0, .flags=0x80, .name = "COMBAT" },
  { .ov = 48, .code = 0x1d29, .word = 0xf052, .immediate=0, .flags=0x00, .name = "WF052" },
  { .ov = 48, .code = 0x224c, .word = 0xf074, .immediate=0, .flags=0x00, .name = "WF074" },
  { .ov = 48, .code = 0x224c, .word = 0xf0aa, .immediate=0, .flags=0x00, .name = "WF0AA" },
  { .ov = 48, .code = 0x224c, .word = 0xf0b6, .immediate=0, .flags=0x00, .name = "WF0B6" },
  { .ov = 48, .code = 0x224c, .word = 0xf0da, .immediate=0, .flags=0x00, .name = "WF0DA" },
  { .ov = 48, .code = 0x224c, .word = 0xf0ea, .immediate=0, .flags=0x00, .name = "WF0EA" },
  { .ov = 48, .code = 0x224c, .word = 0xf102, .immediate=0, .flags=0x00, .name = "WF102" },
  { .ov = 48, .code = 0x224c, .word = 0xf12a, .immediate=0, .flags=0x00, .name = "WF12A" },
  { .ov = 48, .code = 0x224c, .word = 0xf134, .immediate=0, .flags=0x00, .name = "WF134" },
  { .ov = 48, .code = 0x1d29, .word = 0xf158, .immediate=0, .flags=0x00, .name = "WF158" },
  { .ov = 48, .code = 0x224c, .word = 0xf15e, .immediate=0, .flags=0x00, .name = "WF15E" },
  { .ov = 48, .code = 0x224c, .word = 0xf186, .immediate=0, .flags=0x00, .name = "WF186" },
  { .ov = 48, .code = 0x224c, .word = 0xf1ca, .immediate=0, .flags=0x00, .name = "WF1CA" },
  { .ov = 48, .code = 0x224c, .word = 0xf242, .immediate=0, .flags=0x00, .name = "WF242" },
  { .ov = 48, .code = 0x224c, .word = 0xf250, .immediate=0, .flags=0x00, .name = "WF250" },
  { .ov = 48, .code = 0x224c, .word = 0xf262, .immediate=0, .flags=0x00, .name = "WF262" },
  { .ov = 48, .code = 0x224c, .word = 0xf26e, .immediate=0, .flags=0x00, .name = "WF26E" },
  { .ov = 48, .code = 0x224c, .word = 0xf28a, .immediate=0, .flags=0x00, .name = "WF28A" },
  { .ov = 48, .code = 0x224c, .word = 0xf2b6, .immediate=0, .flags=0x00, .name = "WF2B6" },
  { .ov = 48, .code = 0x224c, .word = 0xf344, .immediate=0, .flags=0x00, .name = "WF344" },
  { .ov = 48, .code = 0x224c, .word = 0xf34e, .immediate=0, .flags=0x00, .name = "WF34E" },
  { .ov = 48, .code = 0x224c, .word = 0xf3a8, .immediate=0, .flags=0x00, .name = "WF3A8" },
  { .ov = 48, .code = 0x224c, .word = 0xf3b6, .immediate=0, .flags=0x00, .name = "WF3B6" },
  { .ov = 48, .code = 0x224c, .word = 0xf43a, .immediate=0, .flags=0x00, .name = "WF43A" },
  { .ov = 48, .code = 0x224c, .word = 0xf4a8, .immediate=0, .flags=0x00, .name = "WF4A8" },
  { .ov = 48, .code = 0x224c, .word = 0xf4ee, .immediate=0, .flags=0x80, .name = "WAR" },
  { .ov = 48, .code = 0x224c, .word = 0xf517, .immediate=0, .flags=0x80, .name = "CLEAR-CO" },
  { .ov = 48, .code = 0x224c, .word = 0xf552, .immediate=0, .flags=0x80, .name = "(COMB)" },
  { .ov = 49, .code = 0x224c, .word = 0xe6d6, .immediate=0, .flags=0x00, .name = "WE6D6" },
  { .ov = 49, .code = 0x224c, .word = 0xe6e0, .immediate=0, .flags=0x00, .name = "WE6E0" },
  { .ov = 49, .code = 0x224c, .word = 0xe726, .immediate=0, .flags=0x00, .name = "WE726" },
  { .ov = 49, .code = 0x224c, .word = 0xe72e, .immediate=0, .flags=0x00, .name = "WE72E" },
  { .ov = 49, .code = 0x224c, .word = 0xe73a, .immediate=0, .flags=0x00, .name = "WE73A" },
  { .ov = 49, .code = 0x224c, .word = 0xe746, .immediate=0, .flags=0x00, .name = "WE746" },
  { .ov = 49, .code = 0x224c, .word = 0xe74e, .immediate=0, .flags=0x00, .name = "WE74E" },
  { .ov = 49, .code = 0x224c, .word = 0xe75a, .immediate=0, .flags=0x00, .name = "WE75A" },
  { .ov = 49, .code = 0x2214, .word = 0xe762, .immediate=0, .flags=0x00, .name = "WE762" },
  { .ov = 49, .code = 0x7394, .word = 0xe766, .immediate=0, .flags=0x00, .name = "WE766" },
  { .ov = 49, .code = 0x7394, .word = 0xe76e, .immediate=0, .flags=0x00, .name = "WE76E" },
  { .ov = 49, .code = 0x7394, .word = 0xe776, .immediate=0, .flags=0x00, .name = "WE776" },
  { .ov = 49, .code = 0x7394, .word = 0xe77e, .immediate=0, .flags=0x00, .name = "WE77E" },
  { .ov = 49, .code = 0x7394, .word = 0xe786, .immediate=0, .flags=0x00, .name = "WE786" },
  { .ov = 49, .code = 0x7394, .word = 0xe78e, .immediate=0, .flags=0x00, .name = "WE78E" },
  { .ov = 49, .code = 0x7420, .word = 0xe796, .immediate=0, .flags=0x00, .name = "WE796" },
  { .ov = 49, .code = 0x7420, .word = 0xe79b, .immediate=0, .flags=0x00, .name = "WE79B" },
  { .ov = 49, .code = 0x7420, .word = 0xe7a0, .immediate=0, .flags=0x00, .name = "WE7A0" },
  { .ov = 49, .code = 0x7420, .word = 0xe7a5, .immediate=0, .flags=0x00, .name = "WE7A5" },
  { .ov = 49, .code = 0x7420, .word = 0xe7aa, .immediate=0, .flags=0x00, .name = "WE7AA" },
  { .ov = 49, .code = 0x7420, .word = 0xe7af, .immediate=0, .flags=0x00, .name = "WE7AF" },
  { .ov = 49, .code = 0x2214, .word = 0xe7b4, .immediate=0, .flags=0x00, .name = "WE7B4" },
  { .ov = 49, .code = 0x7420, .word = 0xe7b8, .immediate=0, .flags=0x00, .name = "WE7B8" },
  { .ov = 49, .code = 0x7420, .word = 0xe7bd, .immediate=0, .flags=0x00, .name = "WE7BD" },
  { .ov = 49, .code = 0x7420, .word = 0xe7c2, .immediate=0, .flags=0x00, .name = "WE7C2" },
  { .ov = 49, .code = 0x7420, .word = 0xe7c7, .immediate=0, .flags=0x00, .name = "WE7C7" },
  { .ov = 49, .code = 0x7420, .word = 0xe7cc, .immediate=0, .flags=0x00, .name = "WE7CC" },
  { .ov = 49, .code = 0x7420, .word = 0xe7d1, .immediate=0, .flags=0x00, .name = "WE7D1" },
  { .ov = 49, .code = 0x7420, .word = 0xe7d6, .immediate=0, .flags=0x00, .name = "WE7D6" },
  { .ov = 49, .code = 0x7420, .word = 0xe7db, .immediate=0, .flags=0x00, .name = "WE7DB" },
  { .ov = 49, .code = 0x7420, .word = 0xe7e0, .immediate=0, .flags=0x00, .name = "WE7E0" },
  { .ov = 49, .code = 0x7420, .word = 0xe7e5, .immediate=0, .flags=0x00, .name = "WE7E5" },
  { .ov = 49, .code = 0x7420, .word = 0xe7ea, .immediate=0, .flags=0x00, .name = "WE7EA" },
  { .ov = 49, .code = 0x7420, .word = 0xe7ef, .immediate=0, .flags=0x00, .name = "WE7EF" },
  { .ov = 49, .code = 0x7420, .word = 0xe7f4, .immediate=0, .flags=0x00, .name = "WE7F4" },
  { .ov = 49, .code = 0x7420, .word = 0xe7f9, .immediate=0, .flags=0x00, .name = "WE7F9" },
  { .ov = 49, .code = 0x7420, .word = 0xe7fe, .immediate=0, .flags=0x00, .name = "WE7FE" },
  { .ov = 49, .code = 0x7420, .word = 0xe803, .immediate=0, .flags=0x00, .name = "WE803" },
  { .ov = 49, .code = 0x7420, .word = 0xe808, .immediate=0, .flags=0x00, .name = "WE808" },
  { .ov = 49, .code = 0x7420, .word = 0xe80d, .immediate=0, .flags=0x00, .name = "WE80D" },
  { .ov = 49, .code = 0x7420, .word = 0xe812, .immediate=0, .flags=0x00, .name = "WE812" },
  { .ov = 49, .code = 0x7420, .word = 0xe817, .immediate=0, .flags=0x00, .name = "WE817" },
  { .ov = 49, .code = 0x7420, .word = 0xe81c, .immediate=0, .flags=0x00, .name = "WE81C" },
  { .ov = 49, .code = 0x7420, .word = 0xe821, .immediate=0, .flags=0x00, .name = "WE821" },
  { .ov = 49, .code = 0x7394, .word = 0xe826, .immediate=0, .flags=0x00, .name = "WE826" },
  { .ov = 49, .code = 0x7420, .word = 0xe82e, .immediate=0, .flags=0x00, .name = "WE82E" },
  { .ov = 49, .code = 0x1d29, .word = 0xe833, .immediate=0, .flags=0x00, .name = "WE833" },
  { .ov = 49, .code = 0x1d29, .word = 0xe83e, .immediate=0, .flags=0x00, .name = "WE83E" },
  { .ov = 49, .code = 0x1d29, .word = 0xe842, .immediate=0, .flags=0x00, .name = "WE842" },
  { .ov = 49, .code = 0x1d29, .word = 0xe846, .immediate=0, .flags=0x00, .name = "WE846" },
  { .ov = 49, .code = 0x224c, .word = 0xe84c, .immediate=0, .flags=0x00, .name = "WE84C" },
  { .ov = 49, .code = 0x224c, .word = 0xe85a, .immediate=0, .flags=0x00, .name = "WE85A" },
  { .ov = 49, .code = 0x224c, .word = 0xe864, .immediate=0, .flags=0x00, .name = "WE864" },
  { .ov = 49, .code = 0x224c, .word = 0xe87e, .immediate=0, .flags=0x00, .name = "WE87E" },
  { .ov = 49, .code = 0x224c, .word = 0xe886, .immediate=0, .flags=0x00, .name = "WE886" },
  { .ov = 49, .code = 0x224c, .word = 0xe8a4, .immediate=0, .flags=0x00, .name = "WE8A4" },
  { .ov = 49, .code = 0x224c, .word = 0xe8ec, .immediate=0, .flags=0x00, .name = "WE8EC" },
  { .ov = 49, .code = 0x224c, .word = 0xe910, .immediate=0, .flags=0x00, .name = "WE910" },
  { .ov = 49, .code = 0x224c, .word = 0xe930, .immediate=0, .flags=0x00, .name = "WE930" },
  { .ov = 49, .code = 0x224c, .word = 0xe952, .immediate=0, .flags=0x00, .name = "WE952" },
  { .ov = 49, .code = 0x224c, .word = 0xe96e, .immediate=0, .flags=0x00, .name = "WE96E" },
  { .ov = 49, .code = 0x224c, .word = 0xe98a, .immediate=0, .flags=0x00, .name = "WE98A" },
  { .ov = 49, .code = 0x1d29, .word = 0xe9ae, .immediate=0, .flags=0x80, .name = "LDAMAGE" },
  { .ov = 49, .code = 0x224c, .word = 0xe9ca, .immediate=0, .flags=0x00, .name = "WE9CA" },
  { .ov = 49, .code = 0x224c, .word = 0xe9f2, .immediate=0, .flags=0x00, .name = "WE9F2" },
  { .ov = 49, .code = 0x224c, .word = 0xe9fe, .immediate=0, .flags=0x00, .name = "WE9FE" },
  { .ov = 49, .code = 0x224c, .word = 0xea14, .immediate=0, .flags=0x80, .name = "REFRESH" },
  { .ov = 49, .code = 0x1d29, .word = 0xea1c, .immediate=0, .flags=0x00, .name = "WEA1C" },
  { .ov = 49, .code = 0x224c, .word = 0xea20, .immediate=0, .flags=0x00, .name = "WEA20" },
  { .ov = 49, .code = 0x224c, .word = 0xea2c, .immediate=0, .flags=0x00, .name = "WEA2C" },
  { .ov = 49, .code = 0x224c, .word = 0xea4a, .immediate=0, .flags=0x00, .name = "WEA4A" },
  { .ov = 49, .code = 0x1d29, .word = 0xea6a, .immediate=0, .flags=0x80, .name = "WOUNDED" },
  { .ov = 49, .code = 0x1d29, .word = 0xea7c, .immediate=0, .flags=0x80, .name = "#WOUNDE" },
  { .ov = 49, .code = 0x224c, .word = 0xea80, .immediate=0, .flags=0x00, .name = "WEA80" },
  { .ov = 49, .code = 0x224c, .word = 0xea92, .immediate=0, .flags=0x00, .name = "WEA92" },
  { .ov = 49, .code = 0x224c, .word = 0xead4, .immediate=0, .flags=0x00, .name = "WEAD4" },
  { .ov = 49, .code = 0x224c, .word = 0xeae2, .immediate=0, .flags=0x00, .name = "WEAE2" },
  { .ov = 49, .code = 0x224c, .word = 0xeaf4, .immediate=0, .flags=0x00, .name = "WEAF4" },
  { .ov = 49, .code = 0x224c, .word = 0xeb17, .immediate=0, .flags=0x00, .name = "WEB17" },
  { .ov = 49, .code = 0x224c, .word = 0xeb36, .immediate=0, .flags=0x00, .name = "WEB36" },
  { .ov = 49, .code = 0x224c, .word = 0xeb55, .immediate=0, .flags=0x00, .name = "WEB55" },
  { .ov = 49, .code = 0x224c, .word = 0xeb7f, .immediate=0, .flags=0x00, .name = "WEB7F" },
  { .ov = 49, .code = 0x224c, .word = 0xeba8, .immediate=0, .flags=0x00, .name = "WEBA8" },
  { .ov = 49, .code = 0xeb87, .word = 0xebc4, .immediate=0, .flags=0x80, .name = "ENGINE-" },
  { .ov = 49, .code = 0xeb87, .word = 0xebd4, .immediate=0, .flags=0x80, .name = "SENSOR-" },
  { .ov = 49, .code = 0xeb87, .word = 0xebe4, .immediate=0, .flags=0x80, .name = "COMM-CH" },
  { .ov = 49, .code = 0xeb87, .word = 0xebf4, .immediate=0, .flags=0x80, .name = "MISS-CH" },
  { .ov = 49, .code = 0xeb87, .word = 0xec04, .immediate=0, .flags=0x80, .name = "LASER-C" },
  { .ov = 49, .code = 0xeb87, .word = 0xec14, .immediate=0, .flags=0x80, .name = "SHIELD-" },
  { .ov = 49, .code = 0x224c, .word = 0xec1a, .immediate=0, .flags=0x00, .name = "WEC1A" },
  { .ov = 49, .code = 0x4b3b, .word = 0xec30, .immediate=0, .flags=0x80, .name = "#>?FIEL" },
  { .ov = 49, .code = 0x224c, .word = 0xec56, .immediate=0, .flags=0x00, .name = "WEC56" },
  { .ov = 49, .code = 0x224c, .word = 0xec90, .immediate=0, .flags=0x00, .name = "WEC90" },
  { .ov = 49, .code = 0x224c, .word = 0xecc8, .immediate=0, .flags=0x00, .name = "WECC8" },
  { .ov = 49, .code = 0x224c, .word = 0xed68, .immediate=0, .flags=0x00, .name = "WED68" },
  { .ov = 49, .code = 0x1d29, .word = 0xedbb, .immediate=0, .flags=0x00, .name = "WEDBB" },
  { .ov = 49, .code = 0x224c, .word = 0xedc4, .immediate=0, .flags=0x00, .name = "WEDC4" },
  { .ov = 49, .code = 0x224c, .word = 0xee11, .immediate=0, .flags=0x00, .name = "WEE11" },
  { .ov = 49, .code = 0x224c, .word = 0xee67, .immediate=0, .flags=0x00, .name = "WEE67" },
  { .ov = 49, .code = 0x224c, .word = 0xeed5, .immediate=0, .flags=0x00, .name = "WEED5" },
  { .ov = 49, .code = 0x224c, .word = 0xef1f, .immediate=0, .flags=0x00, .name = "WEF1F" },
  { .ov = 49, .code = 0x224c, .word = 0xef73, .immediate=0, .flags=0x00, .name = "WEF73" },
  { .ov = 49, .code = 0x1d29, .word = 0xefd5, .immediate=0, .flags=0x80, .name = "MDAMAGE" },
  { .ov = 49, .code = 0x224c, .word = 0xeff1, .immediate=0, .flags=0x00, .name = "WEFF1" },
  { .ov = 49, .code = 0x224c, .word = 0xefff, .immediate=0, .flags=0x00, .name = "WEFFF" },
  { .ov = 49, .code = 0x224c, .word = 0xf013, .immediate=0, .flags=0x00, .name = "WF013" },
  { .ov = 49, .code = 0x224c, .word = 0xf03d, .immediate=0, .flags=0x00, .name = "WF03D" },
  { .ov = 49, .code = 0x224c, .word = 0xf04f, .immediate=0, .flags=0x00, .name = "WF04F" },
  { .ov = 49, .code = 0x224c, .word = 0xf059, .immediate=0, .flags=0x00, .name = "WF059" },
  { .ov = 49, .code = 0x224c, .word = 0xf095, .immediate=0, .flags=0x00, .name = "WF095" },
  { .ov = 49, .code = 0x224c, .word = 0xf09f, .immediate=0, .flags=0x00, .name = "WF09F" },
  { .ov = 49, .code = 0x224c, .word = 0xf0a9, .immediate=0, .flags=0x00, .name = "WF0A9" },
  { .ov = 49, .code = 0x224c, .word = 0xf0b3, .immediate=0, .flags=0x00, .name = "WF0B3" },
  { .ov = 49, .code = 0x224c, .word = 0xf0cb, .immediate=0, .flags=0x00, .name = "WF0CB" },
  { .ov = 49, .code = 0x4b3b, .word = 0xf0df, .immediate=0, .flags=0x80, .name = "#>DAMAG" },
  { .ov = 49, .code = 0x224c, .word = 0xf105, .immediate=0, .flags=0x00, .name = "WF105" },
  { .ov = 49, .code = 0x224c, .word = 0xf125, .immediate=0, .flags=0x00, .name = "WF125" },
  { .ov = 49, .code = 0x224c, .word = 0xf151, .immediate=0, .flags=0x80, .name = "DO-ADAM" },
  { .ov = 49, .code = 0x224c, .word = 0xf19b, .immediate=0, .flags=0x00, .name = "WF19B" },
  { .ov = 49, .code = 0x224c, .word = 0xf1a9, .immediate=0, .flags=0x00, .name = "WF1A9" },
  { .ov = 49, .code = 0x224c, .word = 0xf1b5, .immediate=0, .flags=0x00, .name = "WF1B5" },
  { .ov = 49, .code = 0x224c, .word = 0xf1fd, .immediate=0, .flags=0x00, .name = "WF1FD" },
  { .ov = 49, .code = 0x224c, .word = 0xf211, .immediate=0, .flags=0x00, .name = "WF211" },
  { .ov = 49, .code = 0x224c, .word = 0xf231, .immediate=0, .flags=0x00, .name = "WF231" },
  { .ov = 49, .code = 0x4b3b, .word = 0xf251, .immediate=0, .flags=0x80, .name = "#>DISP" },
  { .ov = 49, .code = 0x224c, .word = 0xf25f, .immediate=0, .flags=0x00, .name = "WF25F" },
  { .ov = 49, .code = 0x224c, .word = 0xf283, .immediate=0, .flags=0x00, .name = "WF283" },
  { .ov = 49, .code = 0x224c, .word = 0xf2f0, .immediate=0, .flags=0x80, .name = "CDAM" },
  { .ov = 49, .code = 0x224c, .word = 0xf316, .immediate=0, .flags=0x00, .name = "WF316" },
  { .ov = 49, .code = 0x224c, .word = 0xf330, .immediate=0, .flags=0x00, .name = "WF330" },
  { .ov = 49, .code = 0x224c, .word = 0xf338, .immediate=0, .flags=0x00, .name = "WF338" },
  { .ov = 49, .code = 0x224c, .word = 0xf340, .immediate=0, .flags=0x00, .name = "WF340" },
  { .ov = 49, .code = 0x224c, .word = 0xf35c, .immediate=0, .flags=0x00, .name = "WF35C" },
  { .ov = 49, .code = 0x224c, .word = 0xf37d, .immediate=0, .flags=0x00, .name = "WF37D" },
  { .ov = 49, .code = 0x4b3b, .word = 0xf39b, .immediate=0, .flags=0x80, .name = ".EX" },
  { .ov = 49, .code = 0x224c, .word = 0xf3a9, .immediate=0, .flags=0x00, .name = "WF3A9" },
  { .ov = 49, .code = 0x224c, .word = 0xf437, .immediate=0, .flags=0x00, .name = "WF437" },
  { .ov = 49, .code = 0x224c, .word = 0xf4a9, .immediate=0, .flags=0x00, .name = "WF4A9" },
  { .ov = 49, .code = 0x224c, .word = 0xf4eb, .immediate=0, .flags=0x00, .name = "WF4EB" },
  { .ov = 49, .code = 0x224c, .word = 0xf4fb, .immediate=0, .flags=0x00, .name = "WF4FB" },
  { .ov = 49, .code = 0x224c, .word = 0xf515, .immediate=0, .flags=0x80, .name = "DO-DAMA" },
  { .ov = 49, .code = 0x224c, .word = 0xf52f, .immediate=0, .flags=0x80, .name = "DOBLAST" },
  { .ov = 50, .code = 0x7420, .word = 0xf1a6, .immediate=0, .flags=0x00, .name = "WF1A6" },
  { .ov = 50, .code = 0x7394, .word = 0xf1ab, .immediate=0, .flags=0x00, .name = "WF1AB" },
  { .ov = 50, .code = 0x1d29, .word = 0xf1b3, .immediate=0, .flags=0x00, .name = "WF1B3" },
  { .ov = 50, .code = 0x224c, .word = 0xf1b7, .immediate=0, .flags=0x00, .name = "WF1B7" },
  { .ov = 50, .code = 0x224c, .word = 0xf1e7, .immediate=0, .flags=0x00, .name = "WF1E7" },
  { .ov = 50, .code = 0x224c, .word = 0xf239, .immediate=0, .flags=0x00, .name = "WF239" },
  { .ov = 50, .code = 0x224c, .word = 0xf24b, .immediate=0, .flags=0x00, .name = "WF24B" },
  { .ov = 50, .code = 0x224c, .word = 0xf261, .immediate=0, .flags=0x00, .name = "WF261" },
  { .ov = 50, .code = 0x224c, .word = 0xf2c8, .immediate=0, .flags=0x00, .name = "WF2C8" },
  { .ov = 50, .code = 0x224c, .word = 0xf39c, .immediate=0, .flags=0x00, .name = "WF39C" },
  { .ov = 50, .code = 0x224c, .word = 0xf3b2, .immediate=0, .flags=0x00, .name = "WF3B2" },
  { .ov = 50, .code = 0x224c, .word = 0xf3eb, .immediate=0, .flags=0x00, .name = "WF3EB" },
  { .ov = 50, .code = 0x224c, .word = 0xf40d, .immediate=0, .flags=0x00, .name = "WF40D" },
  { .ov = 50, .code = 0x224c, .word = 0xf446, .immediate=0, .flags=0x00, .name = "WF446" },
  { .ov = 50, .code = 0x224c, .word = 0xf452, .immediate=0, .flags=0x00, .name = "WF452" },
  { .ov = 50, .code = 0x224c, .word = 0xf4a0, .immediate=0, .flags=0x00, .name = "WF4A0" },
  { .ov = 50, .code = 0x224c, .word = 0xf4ce, .immediate=0, .flags=0x00, .name = "WF4CE" },
  { .ov = 50, .code = 0x224c, .word = 0xf50e, .immediate=0, .flags=0x80, .name = "?LAND" },
  { .ov = 50, .code = 0x224c, .word = 0xf532, .immediate=0, .flags=0x80, .name = "?LAUNCH" },
  { .ov = 51, .code = 0x2214, .word = 0xeb76, .immediate=0, .flags=0x00, .name = "WEB76" },
  { .ov = 51, .code = 0x2214, .word = 0xeb7a, .immediate=0, .flags=0x00, .name = "WEB7A" },
  { .ov = 51, .code = 0x2214, .word = 0xeb7e, .immediate=0, .flags=0x00, .name = "WEB7E" },
  { .ov = 51, .code = 0x2214, .word = 0xeb82, .immediate=0, .flags=0x00, .name = "WEB82" },
  { .ov = 51, .code = 0x2214, .word = 0xeb86, .immediate=0, .flags=0x00, .name = "WEB86" },
  { .ov = 51, .code = 0x2214, .word = 0xeb8a, .immediate=0, .flags=0x00, .name = "WEB8A" },
  { .ov = 51, .code = 0x2214, .word = 0xeb8e, .immediate=0, .flags=0x00, .name = "WEB8E" },
  { .ov = 51, .code = 0x2214, .word = 0xeb92, .immediate=0, .flags=0x00, .name = "WEB92" },
  { .ov = 51, .code = 0x2214, .word = 0xeb96, .immediate=0, .flags=0x00, .name = "WEB96" },
  { .ov = 51, .code = 0x2214, .word = 0xeb9a, .immediate=0, .flags=0x00, .name = "WEB9A" },
  { .ov = 51, .code = 0x2214, .word = 0xeb9e, .immediate=0, .flags=0x00, .name = "WEB9E" },
  { .ov = 51, .code = 0x2214, .word = 0xeba2, .immediate=0, .flags=0x00, .name = "WEBA2" },
  { .ov = 51, .code = 0x2214, .word = 0xeba6, .immediate=0, .flags=0x00, .name = "WEBA6" },
  { .ov = 51, .code = 0x1d29, .word = 0xebaa, .immediate=0, .flags=0x00, .name = "WEBAA" },
  { .ov = 51, .code = 0x224c, .word = 0xebae, .immediate=0, .flags=0x00, .name = "WEBAE" },
  { .ov = 51, .code = 0x224c, .word = 0xebb6, .immediate=0, .flags=0x00, .name = "WEBB6" },
  { .ov = 51, .code = 0x224c, .word = 0xebbe, .immediate=0, .flags=0x00, .name = "WEBBE" },
  { .ov = 51, .code = 0x224c, .word = 0xebc6, .immediate=0, .flags=0x00, .name = "WEBC6" },
  { .ov = 51, .code = 0x224c, .word = 0xebce, .immediate=0, .flags=0x00, .name = "WEBCE" },
  { .ov = 51, .code = 0x1d29, .word = 0xeda0, .immediate=0, .flags=0x80, .name = "RND1" },
  { .ov = 51, .code = 0x1d29, .word = 0xedb3, .immediate=0, .flags=0x80, .name = "RND2" },
  { .ov = 51, .code = 0x1d29, .word = 0xedc6, .immediate=0, .flags=0x80, .name = "RND3" },
  { .ov = 51, .code = 0x1d29, .word = 0xedd7, .immediate=0, .flags=0x80, .name = "P6" },
  { .ov = 51, .code = 0x1d29, .word = 0xedf5, .immediate=0, .flags=0x80, .name = "GLISS" },
  { .ov = 51, .code = 0x1d29, .word = 0xee12, .immediate=0, .flags=0x80, .name = "P1" },
  { .ov = 51, .code = 0x224c, .word = 0xee33, .immediate=0, .flags=0x80, .name = "R," },
  { .ov = 51, .code = 0x1d29, .word = 0xee47, .immediate=0, .flags=0x80, .name = "0SONG" },
  { .ov = 51, .code = 0x1d29, .word = 0xee5c, .immediate=0, .flags=0x80, .name = "P9" },
  { .ov = 51, .code = 0x1d29, .word = 0xee6c, .immediate=0, .flags=0x80, .name = "1SONG" },
  { .ov = 51, .code = 0x1d29, .word = 0xee79, .immediate=0, .flags=0x80, .name = "P10" },
  { .ov = 51, .code = 0x1d29, .word = 0xee89, .immediate=0, .flags=0x80, .name = "2SONG" },
  { .ov = 51, .code = 0x1d29, .word = 0xeea5, .immediate=0, .flags=0x00, .name = "WEEA5" },
  { .ov = 51, .code = 0x224c, .word = 0xeea9, .immediate=0, .flags=0x00, .name = "WEEA9" },
  { .ov = 51, .code = 0x224c, .word = 0xeec1, .immediate=0, .flags=0x00, .name = "WEEC1" },
  { .ov = 51, .code = 0x224c, .word = 0xeed7, .immediate=0, .flags=0x00, .name = "WEED7" },
  { .ov = 51, .code = 0x224c, .word = 0xeef9, .immediate=0, .flags=0x00, .name = "WEEF9" },
  { .ov = 51, .code = 0x224c, .word = 0xef2b, .immediate=0, .flags=0x00, .name = "WEF2B" },
  { .ov = 51, .code = 0x224c, .word = 0xef59, .immediate=0, .flags=0x00, .name = "WEF59" },
  { .ov = 51, .code = 0x224c, .word = 0xef77, .immediate=0, .flags=0x80, .name = "INITMUS" },
  { .ov = 51, .code = 0x224c, .word = 0xefb3, .immediate=0, .flags=0x80, .name = "HIMUS" },
  { .ov = 51, .code = 0x224c, .word = 0xefd1, .immediate=0, .flags=0x00, .name = "WEFD1" },
  { .ov = 51, .code = 0x224c, .word = 0xefe3, .immediate=0, .flags=0x00, .name = "WEFE3" },
  { .ov = 51, .code = 0x224c, .word = 0xf00b, .immediate=0, .flags=0x00, .name = "WF00B" },
  { .ov = 51, .code = 0x224c, .word = 0xf01b, .immediate=0, .flags=0x00, .name = "WF01B" },
  { .ov = 51, .code = 0x1d29, .word = 0xf02d, .immediate=0, .flags=0x00, .name = "WF02D" },
  { .ov = 51, .code = 0x224c, .word = 0xf033, .immediate=0, .flags=0x00, .name = "WF033" },
  { .ov = 51, .code = 0x224c, .word = 0xf071, .immediate=0, .flags=0x00, .name = "WF071" },
  { .ov = 51, .code = 0x224c, .word = 0xf0b7, .immediate=0, .flags=0x00, .name = "WF0B7" },
  { .ov = 51, .code = 0x224c, .word = 0xf0bf, .immediate=0, .flags=0x00, .name = "WF0BF" },
  { .ov = 51, .code = 0x224c, .word = 0xf0d5, .immediate=0, .flags=0x00, .name = "WF0D5" },
  { .ov = 51, .code = 0x224c, .word = 0xf167, .immediate=0, .flags=0x80, .name = "!VPAL" },
  { .ov = 51, .code = 0x224c, .word = 0xf191, .immediate=0, .flags=0x80, .name = "SETABLT" },
  { .ov = 51, .code = 0x2214, .word = 0xf1c8, .immediate=0, .flags=0x80, .name = "EGAT" },
  { .ov = 51, .code = 0x2214, .word = 0xf1e1, .immediate=0, .flags=0x80, .name = "EGAB" },
  { .ov = 51, .code = 0x2214, .word = 0xf1fa, .immediate=0, .flags=0x80, .name = "VGAS" },
  { .ov = 51, .code = 0x224c, .word = 0xf209, .immediate=0, .flags=0x00, .name = "WF209" },
  { .ov = 51, .code = 0x224c, .word = 0xf21d, .immediate=0, .flags=0x00, .name = "WF21D" },
  { .ov = 51, .code = 0x1d29, .word = 0xf259, .immediate=0, .flags=0x00, .name = "WF259" },
  { .ov = 51, .code = 0x1d29, .word = 0xf25d, .immediate=0, .flags=0x00, .name = "WF25D" },
  { .ov = 51, .code = 0x1d29, .word = 0xf261, .immediate=0, .flags=0x00, .name = "WF261" },
  { .ov = 51, .code = 0x1d29, .word = 0xf265, .immediate=0, .flags=0x00, .name = "WF265" },
  { .ov = 51, .code = 0x1d29, .word = 0xf269, .immediate=0, .flags=0x00, .name = "WF269" },
  { .ov = 51, .code = 0x1d29, .word = 0xf275, .immediate=0, .flags=0x80, .name = "PARAS" },
  { .ov = 51, .code = 0x224c, .word = 0xf27f, .immediate=0, .flags=0x00, .name = "WF27F" },
  { .ov = 51, .code = 0xf298, .word = 0xf298, .immediate=0, .flags=0x80, .name = "@K" },
  { .ov = 51, .code = 0xf2ad, .word = 0xf2ad, .immediate=0, .flags=0x80, .name = "?ALREADY" },
  { .ov = 51, .code = 0x224c, .word = 0xf2c1, .immediate=0, .flags=0x00, .name = "WF2C1" },
  { .ov = 51, .code = 0x224c, .word = 0xf2e6, .immediate=0, .flags=0x00, .name = "WF2E6" },
  { .ov = 51, .code = 0x224c, .word = 0xf2f4, .immediate=0, .flags=0x00, .name = "WF2F4" },
  { .ov = 51, .code = 0x224c, .word = 0xf30c, .immediate=0, .flags=0x00, .name = "WF30C" },
  { .ov = 51, .code = 0x224c, .word = 0xf320, .immediate=0, .flags=0x00, .name = "WF320" },
  { .ov = 51, .code = 0x224c, .word = 0xf358, .immediate=0, .flags=0x00, .name = "WF358" },
  { .ov = 51, .code = 0x224c, .word = 0xf388, .immediate=0, .flags=0x00, .name = "WF388" },
  { .ov = 51, .code = 0x224c, .word = 0xf3b4, .immediate=0, .flags=0x80, .name = "TANDY-ALLOC" },
  { .ov = 51, .code = 0x224c, .word = 0xf3f2, .immediate=0, .flags=0x00, .name = "WF3F2" },
  { .ov = 51, .code = 0x224c, .word = 0xf40e, .immediate=0, .flags=0x00, .name = "WF40E" },
  { .ov = 51, .code = 0x224c, .word = 0xf430, .immediate=0, .flags=0x00, .name = "WF430" },
  { .ov = 51, .code = 0x224c, .word = 0xf47c, .immediate=0, .flags=0x80, .name = "SPLASH.SCREEN" },
  { .ov = 51, .code = 0x224c, .word = 0xf4db, .immediate=0, .flags=0x80, .name = "INTROS" },
  { .ov = 52, .code = 0x2214, .word = 0xdd06, .immediate=0, .flags=0x00, .name = "WDD06" },
  { .ov = 52, .code = 0x2214, .word = 0xdd0a, .immediate=0, .flags=0x00, .name = "WDD0A" },
  { .ov = 52, .code = 0x2214, .word = 0xdd0e, .immediate=0, .flags=0x00, .name = "WDD0E" },
  { .ov = 52, .code = 0x2214, .word = 0xdd12, .immediate=0, .flags=0x00, .name = "WDD12" },
  { .ov = 52, .code = 0x2214, .word = 0xdd16, .immediate=0, .flags=0x00, .name = "WDD16" },
  { .ov = 52, .code = 0x2214, .word = 0xdd1a, .immediate=0, .flags=0x00, .name = "WDD1A" },
  { .ov = 52, .code = 0x2214, .word = 0xdd1e, .immediate=0, .flags=0x00, .name = "WDD1E" },
  { .ov = 52, .code = 0x2214, .word = 0xdd22, .immediate=0, .flags=0x00, .name = "WDD22" },
  { .ov = 52, .code = 0x2214, .word = 0xdd26, .immediate=0, .flags=0x00, .name = "WDD26" },
  { .ov = 52, .code = 0x2214, .word = 0xdd2a, .immediate=0, .flags=0x00, .name = "WDD2A" },
  { .ov = 52, .code = 0x1d29, .word = 0xdd2e, .immediate=0, .flags=0x00, .name = "WDD2E" },
  { .ov = 52, .code = 0x1d29, .word = 0xdd32, .immediate=0, .flags=0x00, .name = "WDD32" },
  { .ov = 52, .code = 0x1d29, .word = 0xde16, .immediate=0, .flags=0x00, .name = "WDE16" },
  { .ov = 52, .code = 0x1d29, .word = 0xde1a, .immediate=0, .flags=0x00, .name = "WDE1A" },
  { .ov = 52, .code = 0x224c, .word = 0xde1e, .immediate=0, .flags=0x00, .name = "WDE1E" },
  { .ov = 52, .code = 0x224c, .word = 0xde2c, .immediate=0, .flags=0x00, .name = "WDE2C" },
  { .ov = 52, .code = 0x1d29, .word = 0xde3e, .immediate=0, .flags=0x00, .name = "WDE3E" },
  { .ov = 52, .code = 0x1d29, .word = 0xde42, .immediate=0, .flags=0x00, .name = "WDE42" },
  { .ov = 52, .code = 0x1d29, .word = 0xde46, .immediate=0, .flags=0x00, .name = "WDE46" },
  { .ov = 52, .code = 0x1d29, .word = 0xde4a, .immediate=0, .flags=0x00, .name = "WDE4A" },
  { .ov = 52, .code = 0x1d29, .word = 0xde4e, .immediate=0, .flags=0x00, .name = "WDE4E" },
  { .ov = 52, .code = 0x1d29, .word = 0xde52, .immediate=0, .flags=0x00, .name = "WDE52" },
  { .ov = 52, .code = 0x1d29, .word = 0xde56, .immediate=0, .flags=0x00, .name = "WDE56" },
  { .ov = 52, .code = 0x1d29, .word = 0xde5a, .immediate=0, .flags=0x00, .name = "WDE5A" },
  { .ov = 52, .code = 0x1d29, .word = 0xde5e, .immediate=0, .flags=0x00, .name = "WDE5E" },
  { .ov = 52, .code = 0x1d29, .word = 0xde62, .immediate=0, .flags=0x00, .name = "WDE62" },
  { .ov = 52, .code = 0x1d29, .word = 0xde66, .immediate=0, .flags=0x00, .name = "WDE66" },
  { .ov = 52, .code = 0x1d29, .word = 0xde6a, .immediate=0, .flags=0x00, .name = "WDE6A" },
  { .ov = 52, .code = 0x1d29, .word = 0xde6e, .immediate=0, .flags=0x00, .name = "WDE6E" },
  { .ov = 52, .code = 0x1d29, .word = 0xde72, .immediate=0, .flags=0x00, .name = "WDE72" },
  { .ov = 52, .code = 0x1d29, .word = 0xde76, .immediate=0, .flags=0x00, .name = "WDE76" },
  { .ov = 52, .code = 0x1d29, .word = 0xde7a, .immediate=0, .flags=0x00, .name = "WDE7A" },
  { .ov = 52, .code = 0x224c, .word = 0xde7e, .immediate=0, .flags=0x00, .name = "WDE7E" },
  { .ov = 52, .code = 0x2214, .word = 0xdefa, .immediate=0, .flags=0x00, .name = "WDEFA" },
  { .ov = 52, .code = 0x53f7, .word = 0xdf05, .immediate=0, .flags=0x80, .name = "HOST" },
  { .ov = 52, .code = 0x2214, .word = 0xdf25, .immediate=0, .flags=0x00, .name = "WDF25" },
  { .ov = 52, .code = 0x53f7, .word = 0xdf33, .immediate=0, .flags=0x80, .name = "VECTORS" },
  { .ov = 52, .code = 0x224c, .word = 0xdf59, .immediate=0, .flags=0x00, .name = "WDF59" },
  { .ov = 52, .code = 0x224c, .word = 0xdf87, .immediate=0, .flags=0x00, .name = "WDF87" },
  { .ov = 52, .code = 0x1d29, .word = 0xdfb5, .immediate=0, .flags=0x00, .name = "WDFB5" },
  { .ov = 52, .code = 0x224c, .word = 0xdfbb, .immediate=0, .flags=0x00, .name = "WDFBB" },
  { .ov = 52, .code = 0x224c, .word = 0xdfdf, .immediate=0, .flags=0x00, .name = "WDFDF" },
  { .ov = 52, .code = 0x224c, .word = 0xe003, .immediate=0, .flags=0x00, .name = "WE003" },
  { .ov = 52, .code = 0x1d29, .word = 0xe027, .immediate=0, .flags=0x00, .name = "WE027" },
  { .ov = 52, .code = 0x1d29, .word = 0xe02b, .immediate=0, .flags=0x00, .name = "WE02B" },
  { .ov = 52, .code = 0x224c, .word = 0xe02f, .immediate=0, .flags=0x00, .name = "WE02F" },
  { .ov = 52, .code = 0x224c, .word = 0xe03b, .immediate=0, .flags=0x00, .name = "WE03B" },
  { .ov = 52, .code = 0x2214, .word = 0xe05b, .immediate=0, .flags=0x80, .name = "STARE" },
  { .ov = 52, .code = 0x2214, .word = 0xe072, .immediate=0, .flags=0x80, .name = "STARV" },
  { .ov = 52, .code = 0x224c, .word = 0xe081, .immediate=0, .flags=0x00, .name = "WE081" },
  { .ov = 52, .code = 0x224c, .word = 0xe0e1, .immediate=0, .flags=0x00, .name = "WE0E1" },
  { .ov = 52, .code = 0x224c, .word = 0xe127, .immediate=0, .flags=0x00, .name = "WE127" },
  { .ov = 52, .code = 0x224c, .word = 0xe143, .immediate=0, .flags=0x00, .name = "WE143" },
  { .ov = 52, .code = 0x224c, .word = 0xe162, .immediate=0, .flags=0x00, .name = "WE162" },
  { .ov = 52, .code = 0x224c, .word = 0xe17c, .immediate=0, .flags=0x00, .name = "WE17C" },
  { .ov = 52, .code = 0x224c, .word = 0xe199, .immediate=0, .flags=0x00, .name = "WE199" },
  { .ov = 52, .code = 0x224c, .word = 0xe1a5, .immediate=0, .flags=0x00, .name = "WE1A5" },
  { .ov = 52, .code = 0x224c, .word = 0xe1af, .immediate=0, .flags=0x00, .name = "WE1AF" },
  { .ov = 52, .code = 0x224c, .word = 0xe245, .immediate=0, .flags=0x00, .name = "WE245" },
  { .ov = 52, .code = 0x224c, .word = 0xe251, .immediate=0, .flags=0x00, .name = "WE251" },
  { .ov = 52, .code = 0x224c, .word = 0xe269, .immediate=0, .flags=0x00, .name = "WE269" },
  { .ov = 52, .code = 0x224c, .word = 0xe287, .immediate=0, .flags=0x00, .name = "WE287" },
  { .ov = 52, .code = 0x224c, .word = 0xe29f, .immediate=0, .flags=0x00, .name = "WE29F" },
  { .ov = 52, .code = 0x224c, .word = 0xe2e1, .immediate=0, .flags=0x00, .name = "WE2E1" },
  { .ov = 52, .code = 0x224c, .word = 0xe30b, .immediate=0, .flags=0x00, .name = "WE30B" },
  { .ov = 52, .code = 0x224c, .word = 0xe34f, .immediate=0, .flags=0x00, .name = "WE34F" },
  { .ov = 52, .code = 0x224c, .word = 0xe35f, .immediate=0, .flags=0x00, .name = "WE35F" },
  { .ov = 52, .code = 0x224c, .word = 0xe3cd, .immediate=0, .flags=0x00, .name = "WE3CD" },
  { .ov = 52, .code = 0x224c, .word = 0xe3d9, .immediate=0, .flags=0x00, .name = "WE3D9" },
  { .ov = 52, .code = 0x224c, .word = 0xe40f, .immediate=0, .flags=0x00, .name = "WE40F" },
  { .ov = 52, .code = 0x224c, .word = 0xe431, .immediate=0, .flags=0x00, .name = "WE431" },
  { .ov = 52, .code = 0x224c, .word = 0xe451, .immediate=0, .flags=0x00, .name = "WE451" },
  { .ov = 52, .code = 0x224c, .word = 0xe45f, .immediate=0, .flags=0x00, .name = "WE45F" },
  { .ov = 52, .code = 0x224c, .word = 0xe53f, .immediate=0, .flags=0x00, .name = "WE53F" },
  { .ov = 52, .code = 0x224c, .word = 0xe571, .immediate=0, .flags=0x00, .name = "WE571" },
  { .ov = 52, .code = 0x224c, .word = 0xe5f7, .immediate=0, .flags=0x00, .name = "WE5F7" },
  { .ov = 52, .code = 0x224c, .word = 0xe60c, .immediate=0, .flags=0x00, .name = "WE60C" },
  { .ov = 52, .code = 0x224c, .word = 0xe652, .immediate=0, .flags=0x00, .name = "WE652" },
  { .ov = 52, .code = 0x224c, .word = 0xe674, .immediate=0, .flags=0x00, .name = "WE674" },
  { .ov = 52, .code = 0x224c, .word = 0xe67c, .immediate=0, .flags=0x00, .name = "WE67C" },
  { .ov = 52, .code = 0x224c, .word = 0xe684, .immediate=0, .flags=0x00, .name = "WE684" },
  { .ov = 52, .code = 0x224c, .word = 0xe68e, .immediate=0, .flags=0x00, .name = "WE68E" },
  { .ov = 52, .code = 0x224c, .word = 0xe6a4, .immediate=0, .flags=0x00, .name = "WE6A4" },
  { .ov = 52, .code = 0x224c, .word = 0xe6bc, .immediate=0, .flags=0x00, .name = "WE6BC" },
  { .ov = 52, .code = 0x224c, .word = 0xe6ca, .immediate=0, .flags=0x00, .name = "WE6CA" },
  { .ov = 52, .code = 0x224c, .word = 0xe770, .immediate=0, .flags=0x00, .name = "WE770" },
  { .ov = 52, .code = 0x224c, .word = 0xe7c1, .immediate=0, .flags=0x00, .name = "WE7C1" },
  { .ov = 52, .code = 0x224c, .word = 0xe825, .immediate=0, .flags=0x00, .name = "WE825" },
  { .ov = 52, .code = 0x224c, .word = 0xe84f, .immediate=0, .flags=0x00, .name = "WE84F" },
  { .ov = 52, .code = 0x224c, .word = 0xe88d, .immediate=0, .flags=0x00, .name = "WE88D" },
  { .ov = 52, .code = 0x224c, .word = 0xe8c3, .immediate=0, .flags=0x00, .name = "WE8C3" },
  { .ov = 52, .code = 0x224c, .word = 0xe90c, .immediate=0, .flags=0x00, .name = "WE90C" },
  { .ov = 52, .code = 0x224c, .word = 0xe922, .immediate=0, .flags=0x00, .name = "WE922" },
  { .ov = 52, .code = 0x224c, .word = 0xe951, .immediate=0, .flags=0x00, .name = "WE951" },
  { .ov = 52, .code = 0x224c, .word = 0xe95b, .immediate=0, .flags=0x00, .name = "WE95B" },
  { .ov = 52, .code = 0x224c, .word = 0xe9d5, .immediate=0, .flags=0x00, .name = "WE9D5" },
  { .ov = 52, .code = 0x224c, .word = 0xe9fd, .immediate=0, .flags=0x80, .name = "PRESE" },
  { .ov = 52, .code = 0x224c, .word = 0xea17, .immediate=0, .flags=0x00, .name = "WEA17" },
  { .ov = 52, .code = 0x224c, .word = 0xea1f, .immediate=0, .flags=0x00, .name = "WEA1F" },
  { .ov = 52, .code = 0x224c, .word = 0xea27, .immediate=0, .flags=0x00, .name = "WEA27" },
  { .ov = 52, .code = 0x224c, .word = 0xea31, .immediate=0, .flags=0x00, .name = "WEA31" },
  { .ov = 52, .code = 0x224c, .word = 0xea3f, .immediate=0, .flags=0x00, .name = "WEA3F" },
  { .ov = 52, .code = 0x224c, .word = 0xea5b, .immediate=0, .flags=0x00, .name = "WEA5B" },
  { .ov = 52, .code = 0x224c, .word = 0xea6f, .immediate=0, .flags=0x00, .name = "WEA6F" },
  { .ov = 52, .code = 0x224c, .word = 0xea79, .immediate=0, .flags=0x00, .name = "WEA79" },
  { .ov = 52, .code = 0x224c, .word = 0xea97, .immediate=0, .flags=0x00, .name = "WEA97" },
  { .ov = 52, .code = 0x224c, .word = 0xeaad, .immediate=0, .flags=0x00, .name = "WEAAD" },
  { .ov = 52, .code = 0x224c, .word = 0xead7, .immediate=0, .flags=0x00, .name = "WEAD7" },
  { .ov = 52, .code = 0x224c, .word = 0xeb0d, .immediate=0, .flags=0x00, .name = "WEB0D" },
  { .ov = 52, .code = 0x224c, .word = 0xeb4b, .immediate=0, .flags=0x00, .name = "WEB4B" },
  { .ov = 52, .code = 0x224c, .word = 0xeb72, .immediate=0, .flags=0x00, .name = "WEB72" },
  { .ov = 52, .code = 0x224c, .word = 0xeba3, .immediate=0, .flags=0x00, .name = "WEBA3" },
  { .ov = 52, .code = 0xebcb, .word = 0xebcb, .immediate=0, .flags=0x80, .name = "PRMSA" },
  { .ov = 52, .code = 0xebf2, .word = 0xebf2, .immediate=0, .flags=0x80, .name = "PRMLO" },
  { .ov = 52, .code = 0xec29, .word = 0xec29, .immediate=0, .flags=0x80, .name = "RETSA" },
  { .ov = 52, .code = 0xec50, .word = 0xec50, .immediate=0, .flags=0x80, .name = "RETJM" },
  { .ov = 52, .code = 0x224c, .word = 0xec7a, .immediate=0, .flags=0x00, .name = "WEC7A" },
  { .ov = 52, .code = 0x224c, .word = 0xecfe, .immediate=0, .flags=0x00, .name = "WECFE" },
  { .ov = 52, .code = 0x224c, .word = 0xed06, .immediate=0, .flags=0x00, .name = "WED06" },
  { .ov = 52, .code = 0x224c, .word = 0xed0e, .immediate=0, .flags=0x00, .name = "WED0E" },
  { .ov = 52, .code = 0x224c, .word = 0xed16, .immediate=0, .flags=0x00, .name = "WED16" },
  { .ov = 52, .code = 0x224c, .word = 0xed2c, .immediate=0, .flags=0x00, .name = "WED2C" },
  { .ov = 52, .code = 0x224c, .word = 0xed3a, .immediate=0, .flags=0x00, .name = "WED3A" },
  { .ov = 52, .code = 0x224c, .word = 0xed48, .immediate=0, .flags=0x00, .name = "WED48" },
  { .ov = 52, .code = 0x224c, .word = 0xed5e, .immediate=0, .flags=0x00, .name = "WED5E" },
  { .ov = 52, .code = 0x224c, .word = 0xed74, .immediate=0, .flags=0x00, .name = "WED74" },
  { .ov = 52, .code = 0x224c, .word = 0xed7c, .immediate=0, .flags=0x00, .name = "WED7C" },
  { .ov = 52, .code = 0x224c, .word = 0xed9c, .immediate=0, .flags=0x00, .name = "WED9C" },
  { .ov = 52, .code = 0x224c, .word = 0xeda8, .immediate=0, .flags=0x00, .name = "WEDA8" },
  { .ov = 52, .code = 0x224c, .word = 0xedb6, .immediate=0, .flags=0x00, .name = "WEDB6" },
  { .ov = 52, .code = 0x224c, .word = 0xedc4, .immediate=0, .flags=0x00, .name = "WEDC4" },
  { .ov = 52, .code = 0x224c, .word = 0xedea, .immediate=0, .flags=0x00, .name = "WEDEA" },
  { .ov = 52, .code = 0x224c, .word = 0xedf6, .immediate=0, .flags=0x00, .name = "WEDF6" },
  { .ov = 52, .code = 0x224c, .word = 0xee06, .immediate=0, .flags=0x00, .name = "WEE06" },
  { .ov = 52, .code = 0x224c, .word = 0xee12, .immediate=0, .flags=0x00, .name = "WEE12" },
  { .ov = 52, .code = 0x224c, .word = 0xee1c, .immediate=0, .flags=0x00, .name = "WEE1C" },
  { .ov = 52, .code = 0x224c, .word = 0xee40, .immediate=0, .flags=0x00, .name = "WEE40" },
  { .ov = 52, .code = 0x224c, .word = 0xee50, .immediate=0, .flags=0x00, .name = "WEE50" },
  { .ov = 52, .code = 0x224c, .word = 0xee66, .immediate=0, .flags=0x00, .name = "WEE66" },
  { .ov = 52, .code = 0x224c, .word = 0xee82, .immediate=0, .flags=0x00, .name = "WEE82" },
  { .ov = 52, .code = 0x224c, .word = 0xeeba, .immediate=0, .flags=0x80, .name = "LOAD." },
  { .ov = 52, .code = 0x224c, .word = 0xeee2, .immediate=0, .flags=0x00, .name = "WEEE2" },
  { .ov = 52, .code = 0x224c, .word = 0xef06, .immediate=0, .flags=0x00, .name = "WEF06" },
  { .ov = 52, .code = 0x224c, .word = 0xef1e, .immediate=0, .flags=0x00, .name = "WEF1E" },
  { .ov = 52, .code = 0x224c, .word = 0xef3c, .immediate=0, .flags=0x00, .name = "WEF3C" },
  { .ov = 52, .code = 0x224c, .word = 0xef54, .immediate=0, .flags=0x00, .name = "WEF54" },
  { .ov = 52, .code = 0x224c, .word = 0xef88, .immediate=0, .flags=0x00, .name = "WEF88" },
  { .ov = 52, .code = 0x224c, .word = 0xef9c, .immediate=0, .flags=0x00, .name = "WEF9C" },
  { .ov = 52, .code = 0x224c, .word = 0xefdd, .immediate=0, .flags=0x00, .name = "WEFDD" },
  { .ov = 52, .code = 0x224c, .word = 0xf019, .immediate=0, .flags=0x00, .name = "WF019" },
  { .ov = 52, .code = 0x224c, .word = 0xf13c, .immediate=0, .flags=0x00, .name = "WF13C" },
  { .ov = 52, .code = 0x224c, .word = 0xf168, .immediate=0, .flags=0x00, .name = "WF168" },
  { .ov = 52, .code = 0x224c, .word = 0xf194, .immediate=0, .flags=0x00, .name = "WF194" },
  { .ov = 52, .code = 0x224c, .word = 0xf1c5, .immediate=0, .flags=0x00, .name = "WF1C5" },
  { .ov = 52, .code = 0x4b3b, .word = 0xf1fb, .immediate=0, .flags=0x80, .name = "KEY>O" },
  { .ov = 52, .code = 0x1d29, .word = 0xf219, .immediate=0, .flags=0x80, .name = "OPTIO" },
  { .ov = 52, .code = 0x224c, .word = 0xf21d, .immediate=0, .flags=0x00, .name = "WF21D" },
  { .ov = 52, .code = 0x224c, .word = 0xf241, .immediate=0, .flags=0x80, .name = "NEW.G" },
  { .ov = 52, .code = 0x224c, .word = 0xf259, .immediate=0, .flags=0x00, .name = "WF259" },
  { .ov = 52, .code = 0x224c, .word = 0xf358, .immediate=0, .flags=0x00, .name = "WF358" },
  { .ov = 52, .code = 0x224c, .word = 0xf370, .immediate=0, .flags=0x00, .name = "WF370" },
  { .ov = 52, .code = 0x224c, .word = 0xf38e, .immediate=0, .flags=0x00, .name = "WF38E" },
  { .ov = 52, .code = 0x224c, .word = 0xf396, .immediate=0, .flags=0x00, .name = "WF396" },
  { .ov = 52, .code = 0x4b3b, .word = 0xf3bc, .immediate=0, .flags=0x80, .name = "GAMEO_2" },
  { .ov = 52, .code = 0x224c, .word = 0xf3d2, .immediate=0, .flags=0x00, .name = "WF3D2" },
  { .ov = 52, .code = 0x224c, .word = 0xf3e2, .immediate=0, .flags=0x00, .name = "WF3E2" },
  { .ov = 52, .code = 0x224c, .word = 0xf3ea, .immediate=0, .flags=0x00, .name = "WF3EA" },
  { .ov = 52, .code = 0x224c, .word = 0xf402, .immediate=0, .flags=0x00, .name = "WF402" },
  { .ov = 52, .code = 0x224c, .word = 0xf429, .immediate=0, .flags=0x00, .name = "WF429" },
  { .ov = 52, .code = 0x224c, .word = 0xf452, .immediate=0, .flags=0x80, .name = "ERR!" },
  { .ov = 52, .code = 0x224c, .word = 0xf488, .immediate=0, .flags=0x80, .name = "GAMEO_1" },
  { .ov = 52, .code = 0x224c, .word = 0xf4c1, .immediate=0, .flags=0x80, .name = "BOSS" },
  { .ov = 52, .code = 0x224c, .word = 0xf505, .immediate=0, .flags=0x80, .name = "START" },
  { .ov = 53, .code = 0x7420, .word = 0xf086, .immediate=0, .flags=0x00, .name = "WF086" },
  { .ov = 53, .code = 0x1d29, .word = 0xf08b, .immediate=0, .flags=0x00, .name = "WF08B" },
  { .ov = 53, .code = 0x7420, .word = 0xf08f, .immediate=0, .flags=0x00, .name = "WF08F" },
  { .ov = 53, .code = 0x7420, .word = 0xf094, .immediate=0, .flags=0x00, .name = "WF094" },
  { .ov = 53, .code = 0x224c, .word = 0xf099, .immediate=0, .flags=0x00, .name = "WF099" },
  { .ov = 53, .code = 0x224c, .word = 0xf0a3, .immediate=0, .flags=0x00, .name = "WF0A3" },
  { .ov = 53, .code = 0x224c, .word = 0xf0b0, .immediate=0, .flags=0x00, .name = "WF0B0" },
  { .ov = 53, .code = 0x224c, .word = 0xf0bd, .immediate=0, .flags=0x00, .name = "WF0BD" },
  { .ov = 53, .code = 0x224c, .word = 0xf0d1, .immediate=0, .flags=0x80, .name = "MP'ER" },
  { .ov = 53, .code = 0x224c, .word = 0xf139, .immediate=0, .flags=0x00, .name = "WF139" },
  { .ov = 53, .code = 0x224c, .word = 0xf145, .immediate=0, .flags=0x00, .name = "WF145" },
  { .ov = 53, .code = 0x224c, .word = 0xf155, .immediate=0, .flags=0x00, .name = "WF155" },
  { .ov = 53, .code = 0x224c, .word = 0xf166, .immediate=0, .flags=0x00, .name = "WF166" },
  { .ov = 53, .code = 0x1d29, .word = 0xf178, .immediate=0, .flags=0x00, .name = "WF178" },
  { .ov = 53, .code = 0x1d29, .word = 0xf17c, .immediate=0, .flags=0x00, .name = "WF17C" },
  { .ov = 53, .code = 0x1d29, .word = 0xf180, .immediate=0, .flags=0x00, .name = "WF180" },
  { .ov = 53, .code = 0x1d29, .word = 0xf184, .immediate=0, .flags=0x00, .name = "WF184" },
  { .ov = 53, .code = 0x1d29, .word = 0xf188, .immediate=0, .flags=0x00, .name = "WF188" },
  { .ov = 53, .code = 0x2214, .word = 0xf18c, .immediate=0, .flags=0x00, .name = "WF18C" },
  { .ov = 53, .code = 0x1d29, .word = 0xf190, .immediate=0, .flags=0x00, .name = "WF190" },
  { .ov = 53, .code = 0x224c, .word = 0xf194, .immediate=0, .flags=0x00, .name = "WF194" },
  { .ov = 53, .code = 0x224c, .word = 0xf1be, .immediate=0, .flags=0x00, .name = "WF1BE" },
  { .ov = 53, .code = 0x224c, .word = 0xf1ca, .immediate=0, .flags=0x00, .name = "WF1CA" },
  { .ov = 53, .code = 0x224c, .word = 0xf1d4, .immediate=0, .flags=0x00, .name = "WF1D4" },
  { .ov = 53, .code = 0x224c, .word = 0xf1e6, .immediate=0, .flags=0x00, .name = "WF1E6" },
  { .ov = 53, .code = 0x224c, .word = 0xf1f8, .immediate=0, .flags=0x00, .name = "WF1F8" },
  { .ov = 53, .code = 0x4b3b, .word = 0xf253, .immediate=0, .flags=0x80, .name = "COLORS" },
  { .ov = 53, .code = 0x1d29, .word = 0xf27b, .immediate=0, .flags=0x80, .name = "#>A" },
  { .ov = 53, .code = 0x224c, .word = 0xf28b, .immediate=0, .flags=0x00, .name = "WF28B" },
  { .ov = 53, .code = 0x224c, .word = 0xf29d, .immediate=0, .flags=0x00, .name = "WF29D" },
  { .ov = 53, .code = 0x224c, .word = 0xf2c3, .immediate=0, .flags=0x00, .name = "WF2C3" },
  { .ov = 53, .code = 0x224c, .word = 0xf2cb, .immediate=0, .flags=0x00, .name = "WF2CB" },
  { .ov = 53, .code = 0x224c, .word = 0xf2db, .immediate=0, .flags=0x00, .name = "WF2DB" },
  { .ov = 53, .code = 0x224c, .word = 0xf2f5, .immediate=0, .flags=0x00, .name = "WF2F5" },
  { .ov = 53, .code = 0x1d29, .word = 0xf35d, .immediate=0, .flags=0x00, .name = "WF35D" },
  { .ov = 53, .code = 0x224c, .word = 0xf365, .immediate=0, .flags=0x00, .name = "WF365" },
  { .ov = 53, .code = 0x224c, .word = 0xf38f, .immediate=0, .flags=0x00, .name = "WF38F" },
  { .ov = 53, .code = 0x224c, .word = 0xf3bc, .immediate=0, .flags=0x00, .name = "WF3BC" },
  { .ov = 53, .code = 0x224c, .word = 0xf414, .immediate=0, .flags=0x00, .name = "WF414" },
  { .ov = 53, .code = 0x224c, .word = 0xf42a, .immediate=0, .flags=0x00, .name = "WF42A" },
  { .ov = 53, .code = 0x224c, .word = 0xf464, .immediate=0, .flags=0x00, .name = "WF464" },
  { .ov = 53, .code = 0x224c, .word = 0xf4aa, .immediate=0, .flags=0x00, .name = "WF4AA" },
  { .ov = 53, .code = 0x224c, .word = 0xf4d3, .immediate=0, .flags=0x80, .name = "SP" },
  { .ov = 53, .code = 0x224c, .word = 0xf4f8, .immediate=0, .flags=0x80, .name = "2N" },
  { .ov = 54, .code = 0x224c, .word = 0xf2c6, .immediate=0, .flags=0x00, .name = "WF2C6" },
  { .ov = 54, .code = 0x224c, .word = 0xf2d8, .immediate=0, .flags=0x00, .name = "WF2D8" },
  { .ov = 54, .code = 0x224c, .word = 0xf308, .immediate=0, .flags=0x00, .name = "WF308" },
  { .ov = 54, .code = 0x224c, .word = 0xf336, .immediate=0, .flags=0x00, .name = "WF336" },
  { .ov = 54, .code = 0x224c, .word = 0xf38e, .immediate=0, .flags=0x00, .name = "WF38E" },
  { .ov = 54, .code = 0x224c, .word = 0xf3da, .immediate=0, .flags=0x00, .name = "WF3DA" },
  { .ov = 54, .code = 0x1d29, .word = 0xf430, .immediate=0, .flags=0x00, .name = "WF430" },
  { .ov = 54, .code = 0x1d29, .word = 0xf434, .immediate=0, .flags=0x00, .name = "WF434" },
  { .ov = 54, .code = 0x224c, .word = 0xf438, .immediate=0, .flags=0x00, .name = "WF438" },
  { .ov = 54, .code = 0x224c, .word = 0xf45c, .immediate=0, .flags=0x00, .name = "WF45C" },
  { .ov = 54, .code = 0x224c, .word = 0xf480, .immediate=0, .flags=0x00, .name = "WF480" },
  { .ov = 54, .code = 0x224c, .word = 0xf4c6, .immediate=0, .flags=0x00, .name = "WF4C6" },
  { .ov = 54, .code = 0x224c, .word = 0xf4e4, .immediate=0, .flags=0x00, .name = "WF4E4" },
  { .ov = 54, .code = 0x224c, .word = 0xf4f7, .immediate=0, .flags=0x80, .name = "SET-SC" },
  { .ov = 54, .code = 0x224c, .word = 0xf53b, .immediate=0, .flags=0x80, .name = "@NF" },
  { .ov = 55, .code = 0x7394, .word = 0xee96, .immediate=0, .flags=0x00, .name = "WEE96" },
  { .ov = 55, .code = 0x7394, .word = 0xee9e, .immediate=0, .flags=0x00, .name = "WEE9E" },
  { .ov = 55, .code = 0x7394, .word = 0xeea6, .immediate=0, .flags=0x00, .name = "WEEA6" },
  { .ov = 55, .code = 0x7394, .word = 0xeeae, .immediate=0, .flags=0x00, .name = "WEEAE" },
  { .ov = 55, .code = 0x2214, .word = 0xeeb6, .immediate=0, .flags=0x00, .name = "WEEB6" },
  { .ov = 55, .code = 0x2214, .word = 0xeeba, .immediate=0, .flags=0x00, .name = "WEEBA" },
  { .ov = 55, .code = 0x2214, .word = 0xeebe, .immediate=0, .flags=0x00, .name = "WEEBE" },
  { .ov = 55, .code = 0x2214, .word = 0xeec2, .immediate=0, .flags=0x00, .name = "WEEC2" },
  { .ov = 55, .code = 0x2214, .word = 0xeec6, .immediate=0, .flags=0x00, .name = "WEEC6" },
  { .ov = 55, .code = 0x2214, .word = 0xeeca, .immediate=0, .flags=0x00, .name = "WEECA" },
  { .ov = 55, .code = 0x2214, .word = 0xeece, .immediate=0, .flags=0x00, .name = "WEECE" },
  { .ov = 55, .code = 0x7394, .word = 0xeed2, .immediate=0, .flags=0x00, .name = "WEED2" },
  { .ov = 55, .code = 0x7394, .word = 0xeeda, .immediate=0, .flags=0x00, .name = "WEEDA" },
  { .ov = 55, .code = 0x7394, .word = 0xeee2, .immediate=0, .flags=0x00, .name = "WEEE2" },
  { .ov = 55, .code = 0x224c, .word = 0xeeea, .immediate=0, .flags=0x00, .name = "WEEEA" },
  { .ov = 55, .code = 0x224c, .word = 0xeefc, .immediate=0, .flags=0x00, .name = "WEEFC" },
  { .ov = 55, .code = 0x224c, .word = 0xef0c, .immediate=0, .flags=0x00, .name = "WEF0C" },
  { .ov = 55, .code = 0x224c, .word = 0xef2e, .immediate=0, .flags=0x00, .name = "WEF2E" },
  { .ov = 55, .code = 0x1d29, .word = 0xef46, .immediate=0, .flags=0x00, .name = "WEF46" },
  { .ov = 55, .code = 0x224c, .word = 0xef4a, .immediate=0, .flags=0x00, .name = "WEF4A" },
  { .ov = 55, .code = 0x224c, .word = 0xefff, .immediate=0, .flags=0x00, .name = "WEFFF" },
  { .ov = 55, .code = 0x224c, .word = 0xf02d, .immediate=0, .flags=0x00, .name = "WF02D" },
  { .ov = 55, .code = 0x224c, .word = 0xf03d, .immediate=0, .flags=0x00, .name = "WF03D" },
  { .ov = 55, .code = 0x224c, .word = 0xf049, .immediate=0, .flags=0x00, .name = "WF049" },
  { .ov = 55, .code = 0x224c, .word = 0xf066, .immediate=0, .flags=0x00, .name = "WF066" },
  { .ov = 55, .code = 0x224c, .word = 0xf0d2, .immediate=0, .flags=0x00, .name = "WF0D2" },
  { .ov = 55, .code = 0x224c, .word = 0xf0ea, .immediate=0, .flags=0x00, .name = "WF0EA" },
  { .ov = 55, .code = 0x224c, .word = 0xf106, .immediate=0, .flags=0x00, .name = "WF106" },
  { .ov = 55, .code = 0x224c, .word = 0xf12b, .immediate=0, .flags=0x80, .name = "DATE$>AD" },
  { .ov = 55, .code = 0x224c, .word = 0xf19a, .immediate=0, .flags=0x00, .name = "WF19A" },
  { .ov = 55, .code = 0x224c, .word = 0xf1a8, .immediate=0, .flags=0x00, .name = "WF1A8" },
  { .ov = 55, .code = 0x224c, .word = 0xf1d4, .immediate=0, .flags=0x00, .name = "WF1D4" },
  { .ov = 55, .code = 0x4b3b, .word = 0xf1f7, .immediate=0, .flags=0x80, .name = "IDENT-IT" },
  { .ov = 55, .code = 0x224c, .word = 0xf220, .immediate=0, .flags=0x80, .name = "ITEM>PAD" },
  { .ov = 55, .code = 0x224c, .word = 0xf246, .immediate=0, .flags=0x00, .name = "WF246" },
  { .ov = 55, .code = 0x224c, .word = 0xf254, .immediate=0, .flags=0x00, .name = "WF254" },
  { .ov = 55, .code = 0x224c, .word = 0xf25c, .immediate=0, .flags=0x00, .name = "WF25C" },
  { .ov = 55, .code = 0x224c, .word = 0xf28e, .immediate=0, .flags=0x00, .name = "WF28E" },
  { .ov = 55, .code = 0x224c, .word = 0xf2f5, .immediate=0, .flags=0x80, .name = "BOX>LIST" },
  { .ov = 55, .code = 0x224c, .word = 0xf33e, .immediate=0, .flags=0x80, .name = "GET-BOXE" },
  { .ov = 55, .code = 0x224c, .word = 0xf361, .immediate=0, .flags=0x80, .name = "MAKE-SCR" },
  { .ov = 55, .code = 0x224c, .word = 0xf39a, .immediate=0, .flags=0x80, .name = "DELETE-S" },
  { .ov = 55, .code = 0x4b3b, .word = 0xf3bd, .immediate=0, .flags=0x80, .name = "CLASS>BO" },
  { .ov = 55, .code = 0x224c, .word = 0xf3db, .immediate=0, .flags=0x00, .name = "WF3DB" },
  { .ov = 55, .code = 0x224c, .word = 0xf3f6, .immediate=0, .flags=0x80, .name = "BOX>TOCS" },
  { .ov = 55, .code = 0x224c, .word = 0xf411, .immediate=0, .flags=0x80, .name = "?ELEMENT" },
  { .ov = 55, .code = 0x224c, .word = 0xf446, .immediate=0, .flags=0x80, .name = ">BOX" },
  { .ov = 55, .code = 0x224c, .word = 0xf4d3, .immediate=0, .flags=0x80, .name = "(BOX>)" },
  { .ov = 55, .code = 0x224c, .word = 0xf512, .immediate=0, .flags=0x80, .name = "BOX>" },
  { .ov = 56, .code = 0x2214, .word = 0xeb86, .immediate=0, .flags=0x00, .name = "WEB86" },
  { .ov = 56, .code = 0x2214, .word = 0xeb8a, .immediate=0, .flags=0x00, .name = "WEB8A" },
  { .ov = 56, .code = 0x2214, .word = 0xeb8e, .immediate=0, .flags=0x00, .name = "WEB8E" },
  { .ov = 56, .code = 0x2214, .word = 0xeb92, .immediate=0, .flags=0x00, .name = "WEB92" },
  { .ov = 56, .code = 0x2214, .word = 0xeb96, .immediate=0, .flags=0x00, .name = "WEB96" },
  { .ov = 56, .code = 0x7420, .word = 0xeb9a, .immediate=0, .flags=0x00, .name = "WEB9A" },
  { .ov = 56, .code = 0x7420, .word = 0xeb9f, .immediate=0, .flags=0x00, .name = "WEB9F" },
  { .ov = 56, .code = 0x7420, .word = 0xeba4, .immediate=0, .flags=0x00, .name = "WEBA4" },
  { .ov = 56, .code = 0x7420, .word = 0xeba9, .immediate=0, .flags=0x00, .name = "WEBA9" },
  { .ov = 56, .code = 0x7394, .word = 0xebae, .immediate=0, .flags=0x00, .name = "WEBAE" },
  { .ov = 56, .code = 0x7394, .word = 0xebb6, .immediate=0, .flags=0x00, .name = "WEBB6" },
  { .ov = 56, .code = 0x7394, .word = 0xebbe, .immediate=0, .flags=0x00, .name = "WEBBE" },
  { .ov = 56, .code = 0x7394, .word = 0xebc6, .immediate=0, .flags=0x00, .name = "WEBC6" },
  { .ov = 56, .code = 0x7394, .word = 0xebce, .immediate=0, .flags=0x00, .name = "WEBCE" },
  { .ov = 56, .code = 0x7394, .word = 0xebd6, .immediate=0, .flags=0x00, .name = "WEBD6" },
  { .ov = 56, .code = 0x7394, .word = 0xebde, .immediate=0, .flags=0x00, .name = "WEBDE" },
  { .ov = 56, .code = 0x7394, .word = 0xebe6, .immediate=0, .flags=0x00, .name = "WEBE6" },
  { .ov = 56, .code = 0x7394, .word = 0xebee, .immediate=0, .flags=0x00, .name = "WEBEE" },
  { .ov = 56, .code = 0x7394, .word = 0xebf6, .immediate=0, .flags=0x00, .name = "WEBF6" },
  { .ov = 56, .code = 0x7394, .word = 0xebfe, .immediate=0, .flags=0x00, .name = "WEBFE" },
  { .ov = 56, .code = 0x7394, .word = 0xec06, .immediate=0, .flags=0x00, .name = "WEC06" },
  { .ov = 56, .code = 0x7394, .word = 0xec0e, .immediate=0, .flags=0x00, .name = "WEC0E" },
  { .ov = 56, .code = 0x7394, .word = 0xec16, .immediate=0, .flags=0x00, .name = "WEC16" },
  { .ov = 56, .code = 0x7394, .word = 0xec1e, .immediate=0, .flags=0x00, .name = "WEC1E" },
  { .ov = 56, .code = 0x7394, .word = 0xec26, .immediate=0, .flags=0x00, .name = "WEC26" },
  { .ov = 56, .code = 0x7394, .word = 0xec2e, .immediate=0, .flags=0x00, .name = "WEC2E" },
  { .ov = 56, .code = 0x7394, .word = 0xec36, .immediate=0, .flags=0x00, .name = "WEC36" },
  { .ov = 56, .code = 0x7394, .word = 0xec3e, .immediate=0, .flags=0x00, .name = "WEC3E" },
  { .ov = 56, .code = 0x7394, .word = 0xec46, .immediate=0, .flags=0x00, .name = "WEC46" },
  { .ov = 56, .code = 0x7394, .word = 0xec4e, .immediate=0, .flags=0x00, .name = "WEC4E" },
  { .ov = 56, .code = 0x7394, .word = 0xec56, .immediate=0, .flags=0x00, .name = "WEC56" },
  { .ov = 56, .code = 0x224c, .word = 0xec5e, .immediate=0, .flags=0x00, .name = "WEC5E" },
  { .ov = 56, .code = 0x224c, .word = 0xec6c, .immediate=0, .flags=0x00, .name = "WEC6C" },
  { .ov = 56, .code = 0x224c, .word = 0xec7a, .immediate=0, .flags=0x00, .name = "WEC7A" },
  { .ov = 56, .code = 0x224c, .word = 0xec82, .immediate=0, .flags=0x00, .name = "WEC82" },
  { .ov = 56, .code = 0x224c, .word = 0xec92, .immediate=0, .flags=0x00, .name = "WEC92" },
  { .ov = 56, .code = 0x224c, .word = 0xeccc, .immediate=0, .flags=0x00, .name = "WECCC" },
  { .ov = 56, .code = 0x224c, .word = 0xed0c, .immediate=0, .flags=0x80, .name = "!TAMT" },
  { .ov = 56, .code = 0x224c, .word = 0xed28, .immediate=0, .flags=0x80, .name = "@TAMT" },
  { .ov = 56, .code = 0x7394, .word = 0xed38, .immediate=0, .flags=0x00, .name = "WED38" },
  { .ov = 56, .code = 0x7394, .word = 0xed40, .immediate=0, .flags=0x00, .name = "WED40" },
  { .ov = 56, .code = 0x7394, .word = 0xed48, .immediate=0, .flags=0x00, .name = "WED48" },
  { .ov = 56, .code = 0x7394, .word = 0xed50, .immediate=0, .flags=0x00, .name = "WED50" },
  { .ov = 56, .code = 0x7394, .word = 0xed58, .immediate=0, .flags=0x00, .name = "WED58" },
  { .ov = 56, .code = 0x7394, .word = 0xed60, .immediate=0, .flags=0x00, .name = "WED60" },
  { .ov = 56, .code = 0x7394, .word = 0xed68, .immediate=0, .flags=0x00, .name = "WED68" },
  { .ov = 56, .code = 0x224c, .word = 0xed70, .immediate=0, .flags=0x00, .name = "WED70" },
  { .ov = 56, .code = 0x224c, .word = 0xed82, .immediate=0, .flags=0x00, .name = "WED82" },
  { .ov = 56, .code = 0x224c, .word = 0xed8a, .immediate=0, .flags=0x00, .name = "WED8A" },
  { .ov = 56, .code = 0x224c, .word = 0xed92, .immediate=0, .flags=0x00, .name = "WED92" },
  { .ov = 56, .code = 0x224c, .word = 0xed9a, .immediate=0, .flags=0x00, .name = "WED9A" },
  { .ov = 56, .code = 0x4b3b, .word = 0xedad, .immediate=0, .flags=0x80, .name = "(GET.BAS" },
  { .ov = 56, .code = 0x4b3b, .word = 0xedce, .immediate=0, .flags=0x80, .name = "(GETUSE)" },
  { .ov = 56, .code = 0x224c, .word = 0xede4, .immediate=0, .flags=0x00, .name = "WEDE4" },
  { .ov = 56, .code = 0x224c, .word = 0xedf2, .immediate=0, .flags=0x00, .name = "WEDF2" },
  { .ov = 56, .code = 0x224c, .word = 0xee06, .immediate=0, .flags=0x00, .name = "WEE06" },
  { .ov = 56, .code = 0x1d29, .word = 0xee1c, .immediate=0, .flags=0x00, .name = "WEE1C" },
  { .ov = 56, .code = 0x1d29, .word = 0xee23, .immediate=0, .flags=0x00, .name = "WEE23" },
  { .ov = 56, .code = 0x1d29, .word = 0xee2a, .immediate=0, .flags=0x00, .name = "WEE2A" },
  { .ov = 56, .code = 0x224c, .word = 0xee31, .immediate=0, .flags=0x00, .name = "WEE31" },
  { .ov = 56, .code = 0x224c, .word = 0xee3f, .immediate=0, .flags=0x00, .name = "WEE3F" },
  { .ov = 56, .code = 0x224c, .word = 0xee51, .immediate=0, .flags=0x00, .name = "WEE51" },
  { .ov = 56, .code = 0x224c, .word = 0xee57, .immediate=0, .flags=0x00, .name = "WEE57" },
  { .ov = 56, .code = 0x224c, .word = 0xee69, .immediate=0, .flags=0x00, .name = "WEE69" },
  { .ov = 56, .code = 0x224c, .word = 0xee7b, .immediate=0, .flags=0x00, .name = "WEE7B" },
  { .ov = 56, .code = 0x224c, .word = 0xee89, .immediate=0, .flags=0x00, .name = "WEE89" },
  { .ov = 56, .code = 0x224c, .word = 0xee99, .immediate=0, .flags=0x00, .name = "WEE99" },
  { .ov = 56, .code = 0x224c, .word = 0xeec1, .immediate=0, .flags=0x00, .name = "WEEC1" },
  { .ov = 56, .code = 0x224c, .word = 0xeed9, .immediate=0, .flags=0x00, .name = "WEED9" },
  { .ov = 56, .code = 0x224c, .word = 0xeef3, .immediate=0, .flags=0x00, .name = "WEEF3" },
  { .ov = 56, .code = 0x224c, .word = 0xef03, .immediate=0, .flags=0x00, .name = "WEF03" },
  { .ov = 56, .code = 0x224c, .word = 0xef4f, .immediate=0, .flags=0x00, .name = "WEF4F" },
  { .ov = 56, .code = 0x224c, .word = 0xef67, .immediate=0, .flags=0x00, .name = "WEF67" },
  { .ov = 56, .code = 0x224c, .word = 0xef7b, .immediate=0, .flags=0x00, .name = "WEF7B" },
  { .ov = 56, .code = 0x224c, .word = 0xef93, .immediate=0, .flags=0x00, .name = "WEF93" },
  { .ov = 56, .code = 0x224c, .word = 0xefad, .immediate=0, .flags=0x00, .name = "WEFAD" },
  { .ov = 56, .code = 0x224c, .word = 0xf009, .immediate=0, .flags=0x00, .name = "WF009" },
  { .ov = 56, .code = 0x224c, .word = 0xf01f, .immediate=0, .flags=0x00, .name = "WF01F" },
  { .ov = 56, .code = 0x224c, .word = 0xf031, .immediate=0, .flags=0x00, .name = "WF031" },
  { .ov = 56, .code = 0x224c, .word = 0xf039, .immediate=0, .flags=0x00, .name = "WF039" },
  { .ov = 56, .code = 0x1d29, .word = 0xf069, .immediate=0, .flags=0x00, .name = "WF069" },
  { .ov = 56, .code = 0x1d29, .word = 0xf06f, .immediate=0, .flags=0x00, .name = "WF06F" },
  { .ov = 56, .code = 0x224c, .word = 0xf075, .immediate=0, .flags=0x00, .name = "WF075" },
  { .ov = 56, .code = 0x224c, .word = 0xf0b3, .immediate=0, .flags=0x00, .name = "WF0B3" },
  { .ov = 56, .code = 0x224c, .word = 0xf0bd, .immediate=0, .flags=0x00, .name = "WF0BD" },
  { .ov = 56, .code = 0x224c, .word = 0xf0e3, .immediate=0, .flags=0x00, .name = "WF0E3" },
  { .ov = 56, .code = 0x224c, .word = 0xf0ff, .immediate=0, .flags=0x00, .name = "WF0FF" },
  { .ov = 56, .code = 0x224c, .word = 0xf10f, .immediate=0, .flags=0x00, .name = "WF10F" },
  { .ov = 56, .code = 0x224c, .word = 0xf129, .immediate=0, .flags=0x00, .name = "WF129" },
  { .ov = 56, .code = 0x224c, .word = 0xf143, .immediate=0, .flags=0x00, .name = "WF143" },
  { .ov = 56, .code = 0x224c, .word = 0xf163, .immediate=0, .flags=0x00, .name = "WF163" },
  { .ov = 56, .code = 0x224c, .word = 0xf177, .immediate=0, .flags=0x00, .name = "WF177" },
  { .ov = 56, .code = 0x224c, .word = 0xf18f, .immediate=0, .flags=0x00, .name = "WF18F" },
  { .ov = 56, .code = 0x224c, .word = 0xf1a3, .immediate=0, .flags=0x00, .name = "WF1A3" },
  { .ov = 56, .code = 0x224c, .word = 0xf1b7, .immediate=0, .flags=0x00, .name = "WF1B7" },
  { .ov = 56, .code = 0x1d29, .word = 0xf1c5, .immediate=0, .flags=0x00, .name = "WF1C5" },
  { .ov = 56, .code = 0x1d29, .word = 0xf1cb, .immediate=0, .flags=0x00, .name = "WF1CB" },
  { .ov = 56, .code = 0x224c, .word = 0xf1d1, .immediate=0, .flags=0x00, .name = "WF1D1" },
  { .ov = 56, .code = 0x224c, .word = 0xf21b, .immediate=0, .flags=0x00, .name = "WF21B" },
  { .ov = 56, .code = 0x224c, .word = 0xf233, .immediate=0, .flags=0x00, .name = "WF233" },
  { .ov = 56, .code = 0x224c, .word = 0xf24f, .immediate=0, .flags=0x00, .name = "WF24F" },
  { .ov = 56, .code = 0x224c, .word = 0xf25f, .immediate=0, .flags=0x00, .name = "WF25F" },
  { .ov = 56, .code = 0x224c, .word = 0xf28d, .immediate=0, .flags=0x00, .name = "WF28D" },
  { .ov = 56, .code = 0x224c, .word = 0xf2a3, .immediate=0, .flags=0x00, .name = "WF2A3" },
  { .ov = 56, .code = 0x224c, .word = 0xf2bb, .immediate=0, .flags=0x00, .name = "WF2BB" },
  { .ov = 56, .code = 0x224c, .word = 0xf2d7, .immediate=0, .flags=0x00, .name = "WF2D7" },
  { .ov = 56, .code = 0x224c, .word = 0xf30d, .immediate=0, .flags=0x00, .name = "WF30D" },
  { .ov = 56, .code = 0x224c, .word = 0xf31b, .immediate=0, .flags=0x00, .name = "WF31B" },
  { .ov = 56, .code = 0x224c, .word = 0xf33b, .immediate=0, .flags=0x00, .name = "WF33B" },
  { .ov = 56, .code = 0x1d29, .word = 0xf363, .immediate=0, .flags=0x00, .name = "WF363" },
  { .ov = 56, .code = 0x224c, .word = 0xf399, .immediate=0, .flags=0x80, .name = "TRADE>OR" },
  { .ov = 56, .code = 0x4b3b, .word = 0xf3c4, .immediate=0, .flags=0x80, .name = "APOST>PO" },
  { .ov = 56, .code = 0x224c, .word = 0xf3da, .immediate=0, .flags=0x00, .name = "WF3DA" },
  { .ov = 56, .code = 0x224c, .word = 0xf3e8, .immediate=0, .flags=0x00, .name = "WF3E8" },
  { .ov = 56, .code = 0x224c, .word = 0xf41e, .immediate=0, .flags=0x00, .name = "WF41E" },
  { .ov = 56, .code = 0x224c, .word = 0xf491, .immediate=0, .flags=0x80, .name = "SET-CARG" },
  { .ov = 56, .code = 0x224c, .word = 0xf4b7, .immediate=0, .flags=0x00, .name = "WF4B7" },
  { .ov = 56, .code = 0x224c, .word = 0xf502, .immediate=0, .flags=0x80, .name = "BLD-LIST" },
  { .ov = 57, .code = 0x1d29, .word = 0xdfd6, .immediate=0, .flags=0x00, .name = "WDFD6" },
  { .ov = 57, .code = 0x1d29, .word = 0xdfda, .immediate=0, .flags=0x00, .name = "WDFDA" },
  { .ov = 57, .code = 0x1d29, .word = 0xdfde, .immediate=0, .flags=0x00, .name = "WDFDE" },
  { .ov = 57, .code = 0x1d29, .word = 0xdfe2, .immediate=0, .flags=0x00, .name = "WDFE2" },
  { .ov = 57, .code = 0x224c, .word = 0xdfe6, .immediate=0, .flags=0x00, .name = "WDFE6" },
  { .ov = 57, .code = 0x224c, .word = 0xe000, .immediate=0, .flags=0x00, .name = "WE000" },
  { .ov = 57, .code = 0x224c, .word = 0xe00a, .immediate=0, .flags=0x00, .name = "WE00A" },
  { .ov = 57, .code = 0x224c, .word = 0xe014, .immediate=0, .flags=0x00, .name = "WE014" },
  { .ov = 57, .code = 0x224c, .word = 0xe01e, .immediate=0, .flags=0x00, .name = "WE01E" },
  { .ov = 57, .code = 0x224c, .word = 0xe028, .immediate=0, .flags=0x00, .name = "WE028" },
  { .ov = 57, .code = 0x224c, .word = 0xe032, .immediate=0, .flags=0x00, .name = "WE032" },
  { .ov = 57, .code = 0x224c, .word = 0xe03c, .immediate=0, .flags=0x00, .name = "WE03C" },
  { .ov = 57, .code = 0x224c, .word = 0xe046, .immediate=0, .flags=0x00, .name = "WE046" },
  { .ov = 57, .code = 0x224c, .word = 0xe050, .immediate=0, .flags=0x00, .name = "WE050" },
  { .ov = 57, .code = 0x224c, .word = 0xe05a, .immediate=0, .flags=0x00, .name = "WE05A" },
  { .ov = 57, .code = 0x224c, .word = 0xe064, .immediate=0, .flags=0x00, .name = "WE064" },
  { .ov = 57, .code = 0x224c, .word = 0xe06e, .immediate=0, .flags=0x00, .name = "WE06E" },
  { .ov = 57, .code = 0x224c, .word = 0xe078, .immediate=0, .flags=0x00, .name = "WE078" },
  { .ov = 57, .code = 0x224c, .word = 0xe082, .immediate=0, .flags=0x00, .name = "WE082" },
  { .ov = 57, .code = 0x224c, .word = 0xe08c, .immediate=0, .flags=0x00, .name = "WE08C" },
  { .ov = 57, .code = 0x224c, .word = 0xe096, .immediate=0, .flags=0x00, .name = "WE096" },
  { .ov = 57, .code = 0x224c, .word = 0xe0a0, .immediate=0, .flags=0x00, .name = "WE0A0" },
  { .ov = 57, .code = 0x224c, .word = 0xe0aa, .immediate=0, .flags=0x00, .name = "WE0AA" },
  { .ov = 57, .code = 0x224c, .word = 0xe0b4, .immediate=0, .flags=0x00, .name = "WE0B4" },
  { .ov = 57, .code = 0x224c, .word = 0xe0be, .immediate=0, .flags=0x00, .name = "WE0BE" },
  { .ov = 57, .code = 0x224c, .word = 0xe0c8, .immediate=0, .flags=0x00, .name = "WE0C8" },
  { .ov = 57, .code = 0x224c, .word = 0xe0d2, .immediate=0, .flags=0x00, .name = "WE0D2" },
  { .ov = 57, .code = 0x224c, .word = 0xe0dc, .immediate=0, .flags=0x00, .name = "WE0DC" },
  { .ov = 57, .code = 0x224c, .word = 0xe0e6, .immediate=0, .flags=0x00, .name = "WE0E6" },
  { .ov = 57, .code = 0x224c, .word = 0xe0f0, .immediate=0, .flags=0x00, .name = "WE0F0" },
  { .ov = 57, .code = 0x2214, .word = 0xe0fa, .immediate=0, .flags=0x00, .name = "WE0FA" },
  { .ov = 57, .code = 0x2214, .word = 0xe0fe, .immediate=0, .flags=0x00, .name = "WE0FE" },
  { .ov = 57, .code = 0x2214, .word = 0xe102, .immediate=0, .flags=0x00, .name = "WE102" },
  { .ov = 57, .code = 0x2214, .word = 0xe106, .immediate=0, .flags=0x00, .name = "WE106" },
  { .ov = 57, .code = 0x7394, .word = 0xe10a, .immediate=0, .flags=0x00, .name = "WE10A" },
  { .ov = 57, .code = 0x7394, .word = 0xe112, .immediate=0, .flags=0x00, .name = "WE112" },
  { .ov = 57, .code = 0x7394, .word = 0xe11a, .immediate=0, .flags=0x00, .name = "WE11A" },
  { .ov = 57, .code = 0x7394, .word = 0xe122, .immediate=0, .flags=0x00, .name = "WE122" },
  { .ov = 57, .code = 0x7394, .word = 0xe12a, .immediate=0, .flags=0x00, .name = "WE12A" },
  { .ov = 57, .code = 0x7394, .word = 0xe132, .immediate=0, .flags=0x00, .name = "WE132" },
  { .ov = 57, .code = 0x7394, .word = 0xe13a, .immediate=0, .flags=0x00, .name = "WE13A" },
  { .ov = 57, .code = 0x7394, .word = 0xe142, .immediate=0, .flags=0x00, .name = "WE142" },
  { .ov = 57, .code = 0x7394, .word = 0xe14a, .immediate=0, .flags=0x00, .name = "WE14A" },
  { .ov = 57, .code = 0x7420, .word = 0xe152, .immediate=0, .flags=0x00, .name = "WE152" },
  { .ov = 57, .code = 0x7420, .word = 0xe157, .immediate=0, .flags=0x00, .name = "WE157" },
  { .ov = 57, .code = 0x224c, .word = 0xe15c, .immediate=0, .flags=0x00, .name = "WE15C" },
  { .ov = 57, .code = 0x224c, .word = 0xe164, .immediate=0, .flags=0x00, .name = "WE164" },
  { .ov = 57, .code = 0x224c, .word = 0xe16c, .immediate=0, .flags=0x00, .name = "WE16C" },
  { .ov = 57, .code = 0x224c, .word = 0xe17e, .immediate=0, .flags=0x00, .name = "WE17E" },
  { .ov = 57, .code = 0x224c, .word = 0xe184, .immediate=0, .flags=0x00, .name = "WE184" },
  { .ov = 57, .code = 0x224c, .word = 0xe18a, .immediate=0, .flags=0x00, .name = "WE18A" },
  { .ov = 57, .code = 0x224c, .word = 0xe192, .immediate=0, .flags=0x00, .name = "WE192" },
  { .ov = 57, .code = 0x224c, .word = 0xe198, .immediate=0, .flags=0x00, .name = "WE198" },
  { .ov = 57, .code = 0x224c, .word = 0xe1aa, .immediate=0, .flags=0x00, .name = "WE1AA" },
  { .ov = 57, .code = 0x224c, .word = 0xe1b8, .immediate=0, .flags=0x00, .name = "WE1B8" },
  { .ov = 57, .code = 0x224c, .word = 0xe1e8, .immediate=0, .flags=0x00, .name = "WE1E8" },
  { .ov = 57, .code = 0x224c, .word = 0xe200, .immediate=0, .flags=0x00, .name = "WE200" },
  { .ov = 57, .code = 0x224c, .word = 0xe254, .immediate=0, .flags=0x00, .name = "WE254" },
  { .ov = 57, .code = 0x1d29, .word = 0xe260, .immediate=0, .flags=0x00, .name = "WE260" },
  { .ov = 57, .code = 0x224c, .word = 0xe264, .immediate=0, .flags=0x00, .name = "WE264" },
  { .ov = 57, .code = 0x224c, .word = 0xe27c, .immediate=0, .flags=0x00, .name = "WE27C" },
  { .ov = 57, .code = 0x224c, .word = 0xe28c, .immediate=0, .flags=0x00, .name = "WE28C" },
  { .ov = 57, .code = 0x224c, .word = 0xe2e4, .immediate=0, .flags=0x00, .name = "WE2E4" },
  { .ov = 57, .code = 0x224c, .word = 0xe309, .immediate=0, .flags=0x00, .name = "WE309" },
  { .ov = 57, .code = 0x224c, .word = 0xe330, .immediate=0, .flags=0x00, .name = "WE330" },
  { .ov = 57, .code = 0x4b3b, .word = 0xe361, .immediate=0, .flags=0x80, .name = "T>NAME" },
  { .ov = 57, .code = 0x224c, .word = 0xe377, .immediate=0, .flags=0x00, .name = "WE377" },
  { .ov = 57, .code = 0x224c, .word = 0xe3a7, .immediate=0, .flags=0x00, .name = "WE3A7" },
  { .ov = 57, .code = 0x224c, .word = 0xe3c4, .immediate=0, .flags=0x00, .name = "WE3C4" },
  { .ov = 57, .code = 0x224c, .word = 0xe3ee, .immediate=0, .flags=0x00, .name = "WE3EE" },
  { .ov = 57, .code = 0x224c, .word = 0xe3f8, .immediate=0, .flags=0x00, .name = "WE3F8" },
  { .ov = 57, .code = 0x224c, .word = 0xe402, .immediate=0, .flags=0x00, .name = "WE402" },
  { .ov = 57, .code = 0x224c, .word = 0xe410, .immediate=0, .flags=0x00, .name = "WE410" },
  { .ov = 57, .code = 0x224c, .word = 0xe422, .immediate=0, .flags=0x00, .name = "WE422" },
  { .ov = 57, .code = 0x4b3b, .word = 0xe42e, .immediate=0, .flags=0x80, .name = "SPL" },
  { .ov = 57, .code = 0x224c, .word = 0xe454, .immediate=0, .flags=0x00, .name = "WE454" },
  { .ov = 57, .code = 0x224c, .word = 0xe474, .immediate=0, .flags=0x00, .name = "WE474" },
  { .ov = 57, .code = 0x224c, .word = 0xe492, .immediate=0, .flags=0x00, .name = "WE492" },
  { .ov = 57, .code = 0x1d29, .word = 0xe4a6, .immediate=0, .flags=0x00, .name = "WE4A6" },
  { .ov = 57, .code = 0x1d29, .word = 0xe4aa, .immediate=0, .flags=0x00, .name = "WE4AA" },
  { .ov = 57, .code = 0x1d29, .word = 0xe4ae, .immediate=0, .flags=0x00, .name = "WE4AE" },
  { .ov = 57, .code = 0x1d29, .word = 0xe4b2, .immediate=0, .flags=0x00, .name = "WE4B2" },
  { .ov = 57, .code = 0x1d29, .word = 0xe4b6, .immediate=0, .flags=0x00, .name = "WE4B6" },
  { .ov = 57, .code = 0x1d29, .word = 0xe4ba, .immediate=0, .flags=0x00, .name = "WE4BA" },
  { .ov = 57, .code = 0x1d29, .word = 0xe4be, .immediate=0, .flags=0x00, .name = "WE4BE" },
  { .ov = 57, .code = 0x2214, .word = 0xe4c2, .immediate=0, .flags=0x00, .name = "WE4C2" },
  { .ov = 57, .code = 0x7394, .word = 0xe4c6, .immediate=0, .flags=0x00, .name = "WE4C6" },
  { .ov = 57, .code = 0x7394, .word = 0xe4ce, .immediate=0, .flags=0x00, .name = "WE4CE" },
  { .ov = 57, .code = 0x7394, .word = 0xe4d6, .immediate=0, .flags=0x00, .name = "WE4D6" },
  { .ov = 57, .code = 0x7394, .word = 0xe4de, .immediate=0, .flags=0x00, .name = "WE4DE" },
  { .ov = 57, .code = 0x7394, .word = 0xe4e6, .immediate=0, .flags=0x00, .name = "WE4E6" },
  { .ov = 57, .code = 0x7394, .word = 0xe4ee, .immediate=0, .flags=0x00, .name = "WE4EE" },
  { .ov = 57, .code = 0x7394, .word = 0xe4f6, .immediate=0, .flags=0x00, .name = "WE4F6" },
  { .ov = 57, .code = 0x7394, .word = 0xe4fe, .immediate=0, .flags=0x00, .name = "WE4FE" },
  { .ov = 57, .code = 0x7394, .word = 0xe506, .immediate=0, .flags=0x00, .name = "WE506" },
  { .ov = 57, .code = 0x7394, .word = 0xe50e, .immediate=0, .flags=0x00, .name = "WE50E" },
  { .ov = 57, .code = 0x7394, .word = 0xe516, .immediate=0, .flags=0x00, .name = "WE516" },
  { .ov = 57, .code = 0x7394, .word = 0xe51e, .immediate=0, .flags=0x00, .name = "WE51E" },
  { .ov = 57, .code = 0x7394, .word = 0xe526, .immediate=0, .flags=0x00, .name = "WE526" },
  { .ov = 57, .code = 0x7394, .word = 0xe52e, .immediate=0, .flags=0x00, .name = "WE52E" },
  { .ov = 57, .code = 0x7394, .word = 0xe536, .immediate=0, .flags=0x00, .name = "WE536" },
  { .ov = 57, .code = 0x7394, .word = 0xe53e, .immediate=0, .flags=0x00, .name = "WE53E" },
  { .ov = 57, .code = 0x7394, .word = 0xe552, .immediate=0, .flags=0x80, .name = "TRADE.EDL" },
  { .ov = 57, .code = 0x224c, .word = 0xe55a, .immediate=0, .flags=0x00, .name = "WE55A" },
  { .ov = 57, .code = 0x224c, .word = 0xe568, .immediate=0, .flags=0x00, .name = "WE568" },
  { .ov = 57, .code = 0x224c, .word = 0xe590, .immediate=0, .flags=0x00, .name = "WE590" },
  { .ov = 57, .code = 0x224c, .word = 0xe59a, .immediate=0, .flags=0x00, .name = "WE59A" },
  { .ov = 57, .code = 0x224c, .word = 0xe5a4, .immediate=0, .flags=0x00, .name = "WE5A4" },
  { .ov = 57, .code = 0x224c, .word = 0xe5ae, .immediate=0, .flags=0x00, .name = "WE5AE" },
  { .ov = 57, .code = 0x224c, .word = 0xe5b8, .immediate=0, .flags=0x00, .name = "WE5B8" },
  { .ov = 57, .code = 0x224c, .word = 0xe5c6, .immediate=0, .flags=0x00, .name = "WE5C6" },
  { .ov = 57, .code = 0x224c, .word = 0xe5d4, .immediate=0, .flags=0x00, .name = "WE5D4" },
  { .ov = 57, .code = 0x224c, .word = 0xe5ea, .immediate=0, .flags=0x00, .name = "WE5EA" },
  { .ov = 57, .code = 0x224c, .word = 0xe5f8, .immediate=0, .flags=0x00, .name = "WE5F8" },
  { .ov = 57, .code = 0x224c, .word = 0xe5fe, .immediate=0, .flags=0x00, .name = "WE5FE" },
  { .ov = 57, .code = 0x224c, .word = 0xe610, .immediate=0, .flags=0x00, .name = "WE610" },
  { .ov = 57, .code = 0x224c, .word = 0xe620, .immediate=0, .flags=0x00, .name = "WE620" },
  { .ov = 57, .code = 0x224c, .word = 0xe640, .immediate=0, .flags=0x00, .name = "WE640" },
  { .ov = 57, .code = 0x1d29, .word = 0xe676, .immediate=0, .flags=0x00, .name = "WE676" },
  { .ov = 57, .code = 0x224c, .word = 0xe67a, .immediate=0, .flags=0x00, .name = "WE67A" },
  { .ov = 57, .code = 0x224c, .word = 0xe684, .immediate=0, .flags=0x00, .name = "WE684" },
  { .ov = 57, .code = 0x224c, .word = 0xe69e, .immediate=0, .flags=0x00, .name = "WE69E" },
  { .ov = 57, .code = 0x224c, .word = 0xe6c0, .immediate=0, .flags=0x00, .name = "WE6C0" },
  { .ov = 57, .code = 0x224c, .word = 0xe6d0, .immediate=0, .flags=0x00, .name = "WE6D0" },
  { .ov = 57, .code = 0x224c, .word = 0xe6e6, .immediate=0, .flags=0x00, .name = "WE6E6" },
  { .ov = 57, .code = 0x224c, .word = 0xe6f2, .immediate=0, .flags=0x00, .name = "WE6F2" },
  { .ov = 57, .code = 0xaccc, .word = 0xe717, .immediate=0, .flags=0x80, .name = "ENTER-TRADE" },
  { .ov = 57, .code = 0x224c, .word = 0xe744, .immediate=0, .flags=0x80, .name = "DO-ENTER" },
  { .ov = 57, .code = 0x4b3b, .word = 0xe765, .immediate=0, .flags=0x80, .name = "(GETUSE)" },
  { .ov = 57, .code = 0x224c, .word = 0xe77b, .immediate=0, .flags=0x00, .name = "WE77B" },
  { .ov = 57, .code = 0x224c, .word = 0xe783, .immediate=0, .flags=0x00, .name = "WE783" },
  { .ov = 57, .code = 0x224c, .word = 0xe78b, .immediate=0, .flags=0x00, .name = "WE78B" },
  { .ov = 57, .code = 0x224c, .word = 0xe7ad, .immediate=0, .flags=0x00, .name = "WE7AD" },
  { .ov = 57, .code = 0x224c, .word = 0xe7db, .immediate=0, .flags=0x00, .name = "WE7DB" },
  { .ov = 57, .code = 0x224c, .word = 0xe801, .immediate=0, .flags=0x00, .name = "WE801" },
  { .ov = 57, .code = 0x224c, .word = 0xe809, .immediate=0, .flags=0x00, .name = "WE809" },
  { .ov = 57, .code = 0x224c, .word = 0xe813, .immediate=0, .flags=0x00, .name = "WE813" },
  { .ov = 57, .code = 0x224c, .word = 0xe81b, .immediate=0, .flags=0x00, .name = "WE81B" },
  { .ov = 57, .code = 0x224c, .word = 0xe825, .immediate=0, .flags=0x00, .name = "WE825" },
  { .ov = 57, .code = 0x224c, .word = 0xe82f, .immediate=0, .flags=0x00, .name = "WE82F" },
  { .ov = 57, .code = 0x224c, .word = 0xe849, .immediate=0, .flags=0x00, .name = "WE849" },
  { .ov = 57, .code = 0x224c, .word = 0xe85d, .immediate=0, .flags=0x00, .name = "WE85D" },
  { .ov = 57, .code = 0x224c, .word = 0xe87e, .immediate=0, .flags=0x00, .name = "WE87E" },
  { .ov = 57, .code = 0x224c, .word = 0xe89c, .immediate=0, .flags=0x00, .name = "WE89C" },
  { .ov = 57, .code = 0x224c, .word = 0xe8c4, .immediate=0, .flags=0x00, .name = "WE8C4" },
  { .ov = 57, .code = 0x224c, .word = 0xe8e6, .immediate=0, .flags=0x00, .name = "WE8E6" },
  { .ov = 57, .code = 0x224c, .word = 0xe920, .immediate=0, .flags=0x00, .name = "WE920" },
  { .ov = 57, .code = 0x224c, .word = 0xe954, .immediate=0, .flags=0x00, .name = "WE954" },
  { .ov = 57, .code = 0x224c, .word = 0xe960, .immediate=0, .flags=0x00, .name = "WE960" },
  { .ov = 57, .code = 0x224c, .word = 0xe97c, .immediate=0, .flags=0x00, .name = "WE97C" },
  { .ov = 57, .code = 0x224c, .word = 0xe9aa, .immediate=0, .flags=0x00, .name = "WE9AA" },
  { .ov = 57, .code = 0x224c, .word = 0xe9c2, .immediate=0, .flags=0x00, .name = "WE9C2" },
  { .ov = 57, .code = 0x224c, .word = 0xe9ce, .immediate=0, .flags=0x00, .name = "WE9CE" },
  { .ov = 57, .code = 0x224c, .word = 0xea04, .immediate=0, .flags=0x00, .name = "WEA04" },
  { .ov = 57, .code = 0x224c, .word = 0xea32, .immediate=0, .flags=0x00, .name = "WEA32" },
  { .ov = 57, .code = 0x224c, .word = 0xea3c, .immediate=0, .flags=0x00, .name = "WEA3C" },
  { .ov = 57, .code = 0x224c, .word = 0xea6a, .immediate=0, .flags=0x00, .name = "WEA6A" },
  { .ov = 57, .code = 0x224c, .word = 0xea9d, .immediate=0, .flags=0x00, .name = "WEA9D" },
  { .ov = 57, .code = 0x224c, .word = 0xeac5, .immediate=0, .flags=0x00, .name = "WEAC5" },
  { .ov = 57, .code = 0x224c, .word = 0xeaef, .immediate=0, .flags=0x00, .name = "WEAEF" },
  { .ov = 57, .code = 0x224c, .word = 0xeb23, .immediate=0, .flags=0x00, .name = "WEB23" },
  { .ov = 57, .code = 0x224c, .word = 0xeb45, .immediate=0, .flags=0x00, .name = "WEB45" },
  { .ov = 57, .code = 0x224c, .word = 0xeb6d, .immediate=0, .flags=0x00, .name = "WEB6D" },
  { .ov = 57, .code = 0x1d29, .word = 0xeb8f, .immediate=0, .flags=0x00, .name = "WEB8F" },
  { .ov = 57, .code = 0x224c, .word = 0xeb93, .immediate=0, .flags=0x00, .name = "WEB93" },
  { .ov = 57, .code = 0x224c, .word = 0xebdf, .immediate=0, .flags=0x00, .name = "WEBDF" },
  { .ov = 57, .code = 0x224c, .word = 0xec0e, .immediate=0, .flags=0x00, .name = "WEC0E" },
  { .ov = 57, .code = 0x224c, .word = 0xec2e, .immediate=0, .flags=0x00, .name = "WEC2E" },
  { .ov = 57, .code = 0x224c, .word = 0xec8c, .immediate=0, .flags=0x00, .name = "WEC8C" },
  { .ov = 57, .code = 0x224c, .word = 0xeca0, .immediate=0, .flags=0x00, .name = "WECA0" },
  { .ov = 57, .code = 0x224c, .word = 0xecd8, .immediate=0, .flags=0x00, .name = "WECD8" },
  { .ov = 57, .code = 0x224c, .word = 0xecfe, .immediate=0, .flags=0x00, .name = "WECFE" },
  { .ov = 57, .code = 0x224c, .word = 0xed22, .immediate=0, .flags=0x00, .name = "WED22" },
  { .ov = 57, .code = 0x224c, .word = 0xed3e, .immediate=0, .flags=0x00, .name = "WED3E" },
  { .ov = 57, .code = 0x224c, .word = 0xed9a, .immediate=0, .flags=0x00, .name = "WED9A" },
  { .ov = 57, .code = 0x224c, .word = 0xedb4, .immediate=0, .flags=0x00, .name = "WEDB4" },
  { .ov = 57, .code = 0x224c, .word = 0xedbc, .immediate=0, .flags=0x00, .name = "WEDBC" },
  { .ov = 57, .code = 0x224c, .word = 0xedc4, .immediate=0, .flags=0x00, .name = "WEDC4" },
  { .ov = 57, .code = 0x224c, .word = 0xede6, .immediate=0, .flags=0x00, .name = "WEDE6" },
  { .ov = 57, .code = 0x224c, .word = 0xee32, .immediate=0, .flags=0x00, .name = "WEE32" },
  { .ov = 57, .code = 0x224c, .word = 0xee4a, .immediate=0, .flags=0x00, .name = "WEE4A" },
  { .ov = 57, .code = 0x224c, .word = 0xee66, .immediate=0, .flags=0x00, .name = "WEE66" },
  { .ov = 57, .code = 0x224c, .word = 0xee6e, .immediate=0, .flags=0x00, .name = "WEE6E" },
  { .ov = 57, .code = 0x224c, .word = 0xee80, .immediate=0, .flags=0x00, .name = "WEE80" },
  { .ov = 57, .code = 0x224c, .word = 0xee8a, .immediate=0, .flags=0x00, .name = "WEE8A" },
  { .ov = 57, .code = 0x224c, .word = 0xee96, .immediate=0, .flags=0x00, .name = "WEE96" },
  { .ov = 57, .code = 0x224c, .word = 0xeeae, .immediate=0, .flags=0x00, .name = "WEEAE" },
  { .ov = 57, .code = 0x224c, .word = 0xeebe, .immediate=0, .flags=0x00, .name = "WEEBE" },
  { .ov = 57, .code = 0x224c, .word = 0xeed6, .immediate=0, .flags=0x00, .name = "WEED6" },
  { .ov = 57, .code = 0x224c, .word = 0xeee8, .immediate=0, .flags=0x00, .name = "WEEE8" },
  { .ov = 57, .code = 0x224c, .word = 0xef0a, .immediate=0, .flags=0x00, .name = "WEF0A" },
  { .ov = 57, .code = 0x224c, .word = 0xef1e, .immediate=0, .flags=0x00, .name = "WEF1E" },
  { .ov = 57, .code = 0x224c, .word = 0xef30, .immediate=0, .flags=0x00, .name = "WEF30" },
  { .ov = 57, .code = 0x224c, .word = 0xef46, .immediate=0, .flags=0x00, .name = "WEF46" },
  { .ov = 57, .code = 0xaccc, .word = 0xef70, .immediate=0, .flags=0x80, .name = "OPEN-EXPERT" },
  { .ov = 57, .code = 0x224c, .word = 0xefc6, .immediate=0, .flags=0x80, .name = "DO-OPEN_1" },
  { .ov = 57, .code = 0x224c, .word = 0xefd8, .immediate=0, .flags=0x00, .name = "WEFD8" },
  { .ov = 57, .code = 0x224c, .word = 0xeff6, .immediate=0, .flags=0x00, .name = "WEFF6" },
  { .ov = 57, .code = 0x224c, .word = 0xeffe, .immediate=0, .flags=0x00, .name = "WEFFE" },
  { .ov = 57, .code = 0x224c, .word = 0xf008, .immediate=0, .flags=0x00, .name = "WF008" },
  { .ov = 57, .code = 0x224c, .word = 0xf014, .immediate=0, .flags=0x00, .name = "WF014" },
  { .ov = 57, .code = 0x224c, .word = 0xf048, .immediate=0, .flags=0x00, .name = "WF048" },
  { .ov = 57, .code = 0x224c, .word = 0xf066, .immediate=0, .flags=0x00, .name = "WF066" },
  { .ov = 57, .code = 0x224c, .word = 0xf096, .immediate=0, .flags=0x00, .name = "WF096" },
  { .ov = 57, .code = 0x224c, .word = 0xf09e, .immediate=0, .flags=0x00, .name = "WF09E" },
  { .ov = 57, .code = 0x224c, .word = 0xf0a6, .immediate=0, .flags=0x00, .name = "WF0A6" },
  { .ov = 57, .code = 0x224c, .word = 0xf0ba, .immediate=0, .flags=0x00, .name = "WF0BA" },
  { .ov = 57, .code = 0x224c, .word = 0xf0cc, .immediate=0, .flags=0x00, .name = "WF0CC" },
  { .ov = 57, .code = 0x224c, .word = 0xf0d4, .immediate=0, .flags=0x00, .name = "WF0D4" },
  { .ov = 57, .code = 0x224c, .word = 0xf0ec, .immediate=0, .flags=0x00, .name = "WF0EC" },
  { .ov = 57, .code = 0x224c, .word = 0xf100, .immediate=0, .flags=0x00, .name = "WF100" },
  { .ov = 57, .code = 0x224c, .word = 0xf116, .immediate=0, .flags=0x00, .name = "WF116" },
  { .ov = 57, .code = 0x224c, .word = 0xf126, .immediate=0, .flags=0x00, .name = "WF126" },
  { .ov = 57, .code = 0x224c, .word = 0xf156, .immediate=0, .flags=0x00, .name = "WF156" },
  { .ov = 57, .code = 0x224c, .word = 0xf15a, .immediate=0, .flags=0x00, .name = "WF15A" },
  { .ov = 57, .code = 0x224c, .word = 0xf186, .immediate=0, .flags=0x00, .name = "WF186" },
  { .ov = 57, .code = 0x224c, .word = 0xf1b0, .immediate=0, .flags=0x00, .name = "WF1B0" },
  { .ov = 57, .code = 0x224c, .word = 0xf1be, .immediate=0, .flags=0x00, .name = "WF1BE" },
  { .ov = 57, .code = 0x224c, .word = 0xf1f0, .immediate=0, .flags=0x00, .name = "WF1F0" },
  { .ov = 57, .code = 0x224c, .word = 0xf224, .immediate=0, .flags=0x00, .name = "WF224" },
  { .ov = 57, .code = 0x224c, .word = 0xf25e, .immediate=0, .flags=0x00, .name = "WF25E" },
  { .ov = 57, .code = 0x224c, .word = 0xf276, .immediate=0, .flags=0x00, .name = "WF276" },
  { .ov = 57, .code = 0x224c, .word = 0xf2c8, .immediate=0, .flags=0x00, .name = "WF2C8" },
  { .ov = 57, .code = 0x224c, .word = 0xf2d0, .immediate=0, .flags=0x00, .name = "WF2D0" },
  { .ov = 57, .code = 0x224c, .word = 0xf2d8, .immediate=0, .flags=0x00, .name = "WF2D8" },
  { .ov = 57, .code = 0x224c, .word = 0xf2ea, .immediate=0, .flags=0x00, .name = "WF2EA" },
  { .ov = 57, .code = 0x224c, .word = 0xf32a, .immediate=0, .flags=0x00, .name = "WF32A" },
  { .ov = 57, .code = 0x224c, .word = 0xf37e, .immediate=0, .flags=0x00, .name = "WF37E" },
  { .ov = 57, .code = 0x224c, .word = 0xf386, .immediate=0, .flags=0x00, .name = "WF386" },
  { .ov = 57, .code = 0x224c, .word = 0xf39a, .immediate=0, .flags=0x00, .name = "WF39A" },
  { .ov = 57, .code = 0xaccc, .word = 0xf3ce, .immediate=0, .flags=0x80, .name = "(DO-BARTER)" },
  { .ov = 57, .code = 0x224c, .word = 0xf45e, .immediate=0, .flags=0x80, .name = "DO-BARTER" },
  { .ov = 57, .code = 0x224c, .word = 0xf486, .immediate=0, .flags=0x00, .name = "WF486" },
  { .ov = 57, .code = 0x4b3b, .word = 0xf4aa, .immediate=0, .flags=0x80, .name = "N>REPLY" },
  { .ov = 57, .code = 0x224c, .word = 0xf4bc, .immediate=0, .flags=0x00, .name = "WF4BC" },
  { .ov = 57, .code = 0x224c, .word = 0xf4d0, .immediate=0, .flags=0x80, .name = "!PFLAGS" },
  { .ov = 57, .code = 0x224c, .word = 0xf508, .immediate=0, .flags=0x80, .name = "L>P" },
  { .ov = 57, .code = 0x224c, .word = 0xf518, .immediate=0, .flags=0x00, .name = "WF518" },
  { .ov = 57, .code = 0x224c, .word = 0xf558, .immediate=0, .flags=0x80, .name = "DO-OPEN_2" },
  { .ov = 58, .code = 0x224c, .word = 0xe826, .immediate=0, .flags=0x00, .name = "WE826" },
  { .ov = 58, .code = 0x224c, .word = 0xe866, .immediate=0, .flags=0x00, .name = "WE866" },
  { .ov = 58, .code = 0x224c, .word = 0xe870, .immediate=0, .flags=0x00, .name = "WE870" },
  { .ov = 58, .code = 0x224c, .word = 0xe87a, .immediate=0, .flags=0x00, .name = "WE87A" },
  { .ov = 58, .code = 0x224c, .word = 0xe88a, .immediate=0, .flags=0x00, .name = "WE88A" },
  { .ov = 58, .code = 0x2214, .word = 0xe89a, .immediate=0, .flags=0x00, .name = "WE89A" },
  { .ov = 58, .code = 0x7394, .word = 0xe89e, .immediate=0, .flags=0x00, .name = "WE89E" },
  { .ov = 58, .code = 0x224c, .word = 0xe8a6, .immediate=0, .flags=0x00, .name = "WE8A6" },
  { .ov = 58, .code = 0x224c, .word = 0xe8ae, .immediate=0, .flags=0x00, .name = "WE8AE" },
  { .ov = 58, .code = 0x224c, .word = 0xe8b6, .immediate=0, .flags=0x00, .name = "WE8B6" },
  { .ov = 58, .code = 0x224c, .word = 0xe8be, .immediate=0, .flags=0x00, .name = "WE8BE" },
  { .ov = 58, .code = 0x224c, .word = 0xe8c4, .immediate=0, .flags=0x00, .name = "WE8C4" },
  { .ov = 58, .code = 0x7394, .word = 0xe90e, .immediate=0, .flags=0x00, .name = "WE90E" },
  { .ov = 58, .code = 0x7394, .word = 0xe916, .immediate=0, .flags=0x00, .name = "WE916" },
  { .ov = 58, .code = 0x7394, .word = 0xe91e, .immediate=0, .flags=0x00, .name = "WE91E" },
  { .ov = 58, .code = 0x7394, .word = 0xe926, .immediate=0, .flags=0x00, .name = "WE926" },
  { .ov = 58, .code = 0x224c, .word = 0xe92e, .immediate=0, .flags=0x00, .name = "WE92E" },
  { .ov = 58, .code = 0x224c, .word = 0xe93c, .immediate=0, .flags=0x00, .name = "WE93C" },
  { .ov = 58, .code = 0x224c, .word = 0xe942, .immediate=0, .flags=0x00, .name = "WE942" },
  { .ov = 58, .code = 0x224c, .word = 0xe948, .immediate=0, .flags=0x00, .name = "WE948" },
  { .ov = 58, .code = 0x224c, .word = 0xe94e, .immediate=0, .flags=0x00, .name = "WE94E" },
  { .ov = 58, .code = 0x224c, .word = 0xe956, .immediate=0, .flags=0x00, .name = "WE956" },
  { .ov = 58, .code = 0x224c, .word = 0xe95c, .immediate=0, .flags=0x00, .name = "WE95C" },
  { .ov = 58, .code = 0x224c, .word = 0xe962, .immediate=0, .flags=0x00, .name = "WE962" },
  { .ov = 58, .code = 0x224c, .word = 0xe968, .immediate=0, .flags=0x00, .name = "WE968" },
  { .ov = 58, .code = 0x224c, .word = 0xe96e, .immediate=0, .flags=0x00, .name = "WE96E" },
  { .ov = 58, .code = 0x224c, .word = 0xe974, .immediate=0, .flags=0x00, .name = "WE974" },
  { .ov = 58, .code = 0x224c, .word = 0xe97a, .immediate=0, .flags=0x00, .name = "WE97A" },
  { .ov = 58, .code = 0x1d29, .word = 0xe9e0, .immediate=0, .flags=0x80, .name = "MCURS" },
  { .ov = 58, .code = 0x224c, .word = 0xe9ef, .immediate=0, .flags=0x00, .name = "WE9EF" },
  { .ov = 58, .code = 0x224c, .word = 0xea2f, .immediate=0, .flags=0x00, .name = "WEA2F" },
  { .ov = 58, .code = 0x224c, .word = 0xea47, .immediate=0, .flags=0x00, .name = "WEA47" },
  { .ov = 58, .code = 0x224c, .word = 0xea4f, .immediate=0, .flags=0x00, .name = "WEA4F" },
  { .ov = 58, .code = 0x224c, .word = 0xea57, .immediate=0, .flags=0x00, .name = "WEA57" },
  { .ov = 58, .code = 0x224c, .word = 0xea95, .immediate=0, .flags=0x00, .name = "WEA95" },
  { .ov = 58, .code = 0x224c, .word = 0xeada, .immediate=0, .flags=0x00, .name = "WEADA" },
  { .ov = 58, .code = 0x224c, .word = 0xeb48, .immediate=0, .flags=0x00, .name = "WEB48" },
  { .ov = 58, .code = 0x224c, .word = 0xeb58, .immediate=0, .flags=0x00, .name = "WEB58" },
  { .ov = 58, .code = 0x224c, .word = 0xeb60, .immediate=0, .flags=0x00, .name = "WEB60" },
  { .ov = 58, .code = 0x224c, .word = 0xeb70, .immediate=0, .flags=0x00, .name = "WEB70" },
  { .ov = 58, .code = 0x224c, .word = 0xeb7a, .immediate=0, .flags=0x00, .name = "WEB7A" },
  { .ov = 58, .code = 0x224c, .word = 0xebb5, .immediate=0, .flags=0x00, .name = "WEBB5" },
  { .ov = 58, .code = 0x224c, .word = 0xebc1, .immediate=0, .flags=0x00, .name = "WEBC1" },
  { .ov = 58, .code = 0x224c, .word = 0xebcb, .immediate=0, .flags=0x00, .name = "WEBCB" },
  { .ov = 58, .code = 0x224c, .word = 0xebf9, .immediate=0, .flags=0x00, .name = "WEBF9" },
  { .ov = 58, .code = 0x224c, .word = 0xec27, .immediate=0, .flags=0x00, .name = "WEC27" },
  { .ov = 58, .code = 0x224c, .word = 0xec69, .immediate=0, .flags=0x00, .name = "WEC69" },
  { .ov = 58, .code = 0x4b3b, .word = 0xec87, .immediate=0, .flags=0x80, .name = "C>VAL" },
  { .ov = 58, .code = 0x224c, .word = 0xec9d, .immediate=0, .flags=0x00, .name = "WEC9D" },
  { .ov = 58, .code = 0x224c, .word = 0xecc5, .immediate=0, .flags=0x00, .name = "WECC5" },
  { .ov = 58, .code = 0x224c, .word = 0xecd9, .immediate=0, .flags=0x00, .name = "WECD9" },
  { .ov = 58, .code = 0x224c, .word = 0xed01, .immediate=0, .flags=0x00, .name = "WED01" },
  { .ov = 58, .code = 0x224c, .word = 0xed2d, .immediate=0, .flags=0x00, .name = "WED2D" },
  { .ov = 58, .code = 0x4b3b, .word = 0xed40, .immediate=0, .flags=0x80, .name = "T>NAME" },
  { .ov = 58, .code = 0x2214, .word = 0xed56, .immediate=0, .flags=0x00, .name = "WED56" },
  { .ov = 58, .code = 0x2214, .word = 0xed5a, .immediate=0, .flags=0x00, .name = "WED5A" },
  { .ov = 58, .code = 0x2214, .word = 0xed5e, .immediate=0, .flags=0x00, .name = "WED5E" },
  { .ov = 58, .code = 0x4b3b, .word = 0xed69, .immediate=0, .flags=0x80, .name = "TLEN" },
  { .ov = 58, .code = 0x224c, .word = 0xed77, .immediate=0, .flags=0x00, .name = "WED77" },
  { .ov = 58, .code = 0x224c, .word = 0xed97, .immediate=0, .flags=0x00, .name = "WED97" },
  { .ov = 58, .code = 0x224c, .word = 0xedaf, .immediate=0, .flags=0x00, .name = "WEDAF" },
  { .ov = 58, .code = 0x224c, .word = 0xede7, .immediate=0, .flags=0x00, .name = "WEDE7" },
  { .ov = 58, .code = 0x224c, .word = 0xedf9, .immediate=0, .flags=0x00, .name = "WEDF9" },
  { .ov = 58, .code = 0x224c, .word = 0xee11, .immediate=0, .flags=0x00, .name = "WEE11" },
  { .ov = 58, .code = 0x224c, .word = 0xee19, .immediate=0, .flags=0x00, .name = "WEE19" },
  { .ov = 58, .code = 0x224c, .word = 0xee33, .immediate=0, .flags=0x00, .name = "WEE33" },
  { .ov = 58, .code = 0x224c, .word = 0xee4b, .immediate=0, .flags=0x00, .name = "WEE4B" },
  { .ov = 58, .code = 0x224c, .word = 0xee5b, .immediate=0, .flags=0x00, .name = "WEE5B" },
  { .ov = 58, .code = 0x224c, .word = 0xee6b, .immediate=0, .flags=0x00, .name = "WEE6B" },
  { .ov = 58, .code = 0x224c, .word = 0xee71, .immediate=0, .flags=0x00, .name = "WEE71" },
  { .ov = 58, .code = 0x1d29, .word = 0xee83, .immediate=0, .flags=0x00, .name = "WEE83" },
  { .ov = 58, .code = 0x224c, .word = 0xee87, .immediate=0, .flags=0x00, .name = "WEE87" },
  { .ov = 58, .code = 0x224c, .word = 0xee9d, .immediate=0, .flags=0x00, .name = "WEE9D" },
  { .ov = 58, .code = 0x224c, .word = 0xeecf, .immediate=0, .flags=0x00, .name = "WEECF" },
  { .ov = 58, .code = 0x224c, .word = 0xeee3, .immediate=0, .flags=0x00, .name = "WEEE3" },
  { .ov = 58, .code = 0x224c, .word = 0xef14, .immediate=0, .flags=0x00, .name = "WEF14" },
  { .ov = 58, .code = 0x224c, .word = 0xef58, .immediate=0, .flags=0x00, .name = "WEF58" },
  { .ov = 58, .code = 0x224c, .word = 0xef74, .immediate=0, .flags=0x00, .name = "WEF74" },
  { .ov = 58, .code = 0x224c, .word = 0xef86, .immediate=0, .flags=0x00, .name = "WEF86" },
  { .ov = 58, .code = 0x224c, .word = 0xef90, .immediate=0, .flags=0x00, .name = "WEF90" },
  { .ov = 58, .code = 0x224c, .word = 0xef9e, .immediate=0, .flags=0x00, .name = "WEF9E" },
  { .ov = 58, .code = 0x224c, .word = 0xefae, .immediate=0, .flags=0x00, .name = "WEFAE" },
  { .ov = 58, .code = 0x224c, .word = 0xefbe, .immediate=0, .flags=0x00, .name = "WEFBE" },
  { .ov = 58, .code = 0x224c, .word = 0xefd2, .immediate=0, .flags=0x00, .name = "WEFD2" },
  { .ov = 58, .code = 0x224c, .word = 0xefda, .immediate=0, .flags=0x00, .name = "WEFDA" },
  { .ov = 58, .code = 0x224c, .word = 0xefe2, .immediate=0, .flags=0x00, .name = "WEFE2" },
  { .ov = 58, .code = 0x224c, .word = 0xeff2, .immediate=0, .flags=0x00, .name = "WEFF2" },
  { .ov = 58, .code = 0x224c, .word = 0xf00c, .immediate=0, .flags=0x00, .name = "WF00C" },
  { .ov = 58, .code = 0x224c, .word = 0xf028, .immediate=0, .flags=0x00, .name = "WF028" },
  { .ov = 58, .code = 0x224c, .word = 0xf038, .immediate=0, .flags=0x00, .name = "WF038" },
  { .ov = 58, .code = 0x224c, .word = 0xf054, .immediate=0, .flags=0x00, .name = "WF054" },
  { .ov = 58, .code = 0x224c, .word = 0xf078, .immediate=0, .flags=0x00, .name = "WF078" },
  { .ov = 58, .code = 0x224c, .word = 0xf0c6, .immediate=0, .flags=0x00, .name = "WF0C6" },
  { .ov = 58, .code = 0x224c, .word = 0xf0da, .immediate=0, .flags=0x00, .name = "WF0DA" },
  { .ov = 58, .code = 0x224c, .word = 0xf0ee, .immediate=0, .flags=0x00, .name = "WF0EE" },
  { .ov = 58, .code = 0x224c, .word = 0xf10a, .immediate=0, .flags=0x00, .name = "WF10A" },
  { .ov = 58, .code = 0x224c, .word = 0xf122, .immediate=0, .flags=0x00, .name = "WF122" },
  { .ov = 58, .code = 0x224c, .word = 0xf134, .immediate=0, .flags=0x00, .name = "WF134" },
  { .ov = 58, .code = 0x224c, .word = 0xf13c, .immediate=0, .flags=0x00, .name = "WF13C" },
  { .ov = 58, .code = 0x224c, .word = 0xf152, .immediate=0, .flags=0x00, .name = "WF152" },
  { .ov = 58, .code = 0x224c, .word = 0xf1a2, .immediate=0, .flags=0x00, .name = "WF1A2" },
  { .ov = 58, .code = 0x224c, .word = 0xf1ae, .immediate=0, .flags=0x00, .name = "WF1AE" },
  { .ov = 58, .code = 0x2214, .word = 0xf1c8, .immediate=0, .flags=0x00, .name = "WF1C8" },
  { .ov = 58, .code = 0x4b3b, .word = 0xf1d3, .immediate=0, .flags=0x80, .name = "ID>#" },
  { .ov = 58, .code = 0x224c, .word = 0xf1e9, .immediate=0, .flags=0x00, .name = "WF1E9" },
  { .ov = 58, .code = 0x224c, .word = 0xf20b, .immediate=0, .flags=0x00, .name = "WF20B" },
  { .ov = 58, .code = 0x224c, .word = 0xf217, .immediate=0, .flags=0x00, .name = "WF217" },
  { .ov = 58, .code = 0x224c, .word = 0xf223, .immediate=0, .flags=0x00, .name = "WF223" },
  { .ov = 58, .code = 0x224c, .word = 0xf26e, .immediate=0, .flags=0x00, .name = "WF26E" },
  { .ov = 58, .code = 0x224c, .word = 0xf2a4, .immediate=0, .flags=0x00, .name = "WF2A4" },
  { .ov = 58, .code = 0x224c, .word = 0xf2d4, .immediate=0, .flags=0x00, .name = "WF2D4" },
  { .ov = 58, .code = 0x224c, .word = 0xf2f2, .immediate=0, .flags=0x00, .name = "WF2F2" },
  { .ov = 58, .code = 0x224c, .word = 0xf2fe, .immediate=0, .flags=0x00, .name = "WF2FE" },
  { .ov = 58, .code = 0x224c, .word = 0xf30a, .immediate=0, .flags=0x00, .name = "WF30A" },
  { .ov = 58, .code = 0x4b3b, .word = 0xf328, .immediate=0, .flags=0x80, .name = "P>REPLY" },
  { .ov = 58, .code = 0x224c, .word = 0xf33a, .immediate=0, .flags=0x00, .name = "WF33A" },
  { .ov = 58, .code = 0x224c, .word = 0xf34c, .immediate=0, .flags=0x00, .name = "WF34C" },
  { .ov = 58, .code = 0x224c, .word = 0xf360, .immediate=0, .flags=0x00, .name = "WF360" },
  { .ov = 58, .code = 0x224c, .word = 0xf38a, .immediate=0, .flags=0x00, .name = "WF38A" },
  { .ov = 58, .code = 0x224c, .word = 0xf3b8, .immediate=0, .flags=0x00, .name = "WF3B8" },
  { .ov = 58, .code = 0x224c, .word = 0xf3ea, .immediate=0, .flags=0x00, .name = "WF3EA" },
  { .ov = 58, .code = 0x224c, .word = 0xf3f8, .immediate=0, .flags=0x00, .name = "WF3F8" },
  { .ov = 58, .code = 0x224c, .word = 0xf406, .immediate=0, .flags=0x00, .name = "WF406" },
  { .ov = 58, .code = 0x224c, .word = 0xf47b, .immediate=0, .flags=0x00, .name = "WF47B" },
  { .ov = 58, .code = 0x224c, .word = 0xf485, .immediate=0, .flags=0x00, .name = "WF485" },
  { .ov = 58, .code = 0x4b3b, .word = 0xf49a, .immediate=0, .flags=0x80, .name = "T>ACTION" },
  { .ov = 58, .code = 0x224c, .word = 0xf4ac, .immediate=0, .flags=0x00, .name = "WF4AC" },
  { .ov = 58, .code = 0x224c, .word = 0xf4d2, .immediate=0, .flags=0x00, .name = "WF4D2" },
  { .ov = 58, .code = 0x224c, .word = 0xf50e, .immediate=0, .flags=0x80, .name = "TRADE" },
  { .ov = 59, .code = 0x224c, .word = 0xed66, .immediate=0, .flags=0x00, .name = "WED66" },
  { .ov = 59, .code = 0x224c, .word = 0xed74, .immediate=0, .flags=0x00, .name = "WED74" },
  { .ov = 59, .code = 0x224c, .word = 0xed7c, .immediate=0, .flags=0x00, .name = "WED7C" },
  { .ov = 59, .code = 0x224c, .word = 0xed88, .immediate=0, .flags=0x00, .name = "WED88" },
  { .ov = 59, .code = 0x224c, .word = 0xed92, .immediate=0, .flags=0x00, .name = "WED92" },
  { .ov = 59, .code = 0x224c, .word = 0xed9e, .immediate=0, .flags=0x00, .name = "WED9E" },
  { .ov = 59, .code = 0x224c, .word = 0xeda6, .immediate=0, .flags=0x00, .name = "WEDA6" },
  { .ov = 59, .code = 0x224c, .word = 0xedae, .immediate=0, .flags=0x00, .name = "WEDAE" },
  { .ov = 59, .code = 0x224c, .word = 0xedba, .immediate=0, .flags=0x00, .name = "WEDBA" },
  { .ov = 59, .code = 0x7420, .word = 0xedc4, .immediate=0, .flags=0x00, .name = "WEDC4" },
  { .ov = 59, .code = 0x7394, .word = 0xedc9, .immediate=0, .flags=0x00, .name = "WEDC9" },
  { .ov = 59, .code = 0x7420, .word = 0xedd1, .immediate=0, .flags=0x00, .name = "WEDD1" },
  { .ov = 59, .code = 0x7420, .word = 0xedd6, .immediate=0, .flags=0x00, .name = "WEDD6" },
  { .ov = 59, .code = 0x7420, .word = 0xeddb, .immediate=0, .flags=0x00, .name = "WEDDB" },
  { .ov = 59, .code = 0x7420, .word = 0xede0, .immediate=0, .flags=0x00, .name = "WEDE0" },
  { .ov = 59, .code = 0x224c, .word = 0xedee, .immediate=0, .flags=0x80, .name = "?ETIME" },
  { .ov = 59, .code = 0x224c, .word = 0xee1a, .immediate=0, .flags=0x00, .name = "WEE1A" },
  { .ov = 59, .code = 0x224c, .word = 0xee58, .immediate=0, .flags=0x00, .name = "WEE58" },
  { .ov = 59, .code = 0x224c, .word = 0xee9a, .immediate=0, .flags=0x00, .name = "WEE9A" },
  { .ov = 59, .code = 0x1d29, .word = 0xeecf, .immediate=0, .flags=0x80, .name = "%STORM" },
  { .ov = 59, .code = 0x224c, .word = 0xeee0, .immediate=0, .flags=0x80, .name = "?.STORM" },
  { .ov = 59, .code = 0x224c, .word = 0xeefe, .immediate=0, .flags=0x00, .name = "WEEFE" },
  { .ov = 59, .code = 0x224c, .word = 0xef33, .immediate=0, .flags=0x80, .name = "DO-STORM" },
  { .ov = 59, .code = 0x224c, .word = 0xefa3, .immediate=0, .flags=0x00, .name = "WEFA3" },
  { .ov = 59, .code = 0x224c, .word = 0xefa9, .immediate=0, .flags=0x00, .name = "WEFA9" },
  { .ov = 59, .code = 0x224c, .word = 0xefb1, .immediate=0, .flags=0x00, .name = "WEFB1" },
  { .ov = 59, .code = 0x224c, .word = 0xefbb, .immediate=0, .flags=0x00, .name = "WEFBB" },
  { .ov = 59, .code = 0x224c, .word = 0xefc5, .immediate=0, .flags=0x00, .name = "WEFC5" },
  { .ov = 59, .code = 0x224c, .word = 0xefd1, .immediate=0, .flags=0x00, .name = "WEFD1" },
  { .ov = 59, .code = 0x224c, .word = 0xf003, .immediate=0, .flags=0x00, .name = "WF003" },
  { .ov = 59, .code = 0x224c, .word = 0xf00d, .immediate=0, .flags=0x00, .name = "WF00D" },
  { .ov = 59, .code = 0x224c, .word = 0xf055, .immediate=0, .flags=0x00, .name = "WF055" },
  { .ov = 59, .code = 0x224c, .word = 0xf067, .immediate=0, .flags=0x00, .name = "WF067" },
  { .ov = 59, .code = 0x224c, .word = 0xf06f, .immediate=0, .flags=0x00, .name = "WF06F" },
  { .ov = 59, .code = 0x224c, .word = 0xf085, .immediate=0, .flags=0x00, .name = "WF085" },
  { .ov = 59, .code = 0x224c, .word = 0xf0b6, .immediate=0, .flags=0x80, .name = "FADE" },
  { .ov = 59, .code = 0x224c, .word = 0xf0e2, .immediate=0, .flags=0x00, .name = "WF0E2" },
  { .ov = 59, .code = 0x224c, .word = 0xf11a, .immediate=0, .flags=0x80, .name = ".STARDATE" },
  { .ov = 59, .code = 0x224c, .word = 0xf1ac, .immediate=0, .flags=0x00, .name = "WF1AC" },
  { .ov = 59, .code = 0x224c, .word = 0xf1c4, .immediate=0, .flags=0x00, .name = "WF1C4" },
  { .ov = 59, .code = 0x224c, .word = 0xf1de, .immediate=0, .flags=0x00, .name = "WF1DE" },
  { .ov = 59, .code = 0x224c, .word = 0xf1e8, .immediate=0, .flags=0x00, .name = "WF1E8" },
  { .ov = 59, .code = 0x224c, .word = 0xf2ce, .immediate=0, .flags=0x00, .name = "WF2CE" },
  { .ov = 59, .code = 0x224c, .word = 0xf2f6, .immediate=0, .flags=0x00, .name = "WF2F6" },
  { .ov = 59, .code = 0x224c, .word = 0xf32c, .immediate=0, .flags=0x00, .name = "WF32C" },
  { .ov = 59, .code = 0x224c, .word = 0xf364, .immediate=0, .flags=0x80, .name = ".ENERGY" },
  { .ov = 59, .code = 0x224c, .word = 0xf414, .immediate=0, .flags=0x80, .name = ".CARGO" },
  { .ov = 59, .code = 0x224c, .word = 0xf451, .immediate=0, .flags=0x00, .name = "WF451" },
  { .ov = 59, .code = 0x224c, .word = 0xf479, .immediate=0, .flags=0x00, .name = "WF479" },
  { .ov = 59, .code = 0x224c, .word = 0xf49d, .immediate=0, .flags=0x00, .name = "WF49D" },
  { .ov = 59, .code = 0x224c, .word = 0xf4ca, .immediate=0, .flags=0x80, .name = ".WHERE" },
  { .ov = 59, .code = 0x224c, .word = 0xf51c, .immediate=0, .flags=0x80, .name = ".DISTANCE" },
  { .ov = 59, .code = 0x224c, .word = 0xf52d, .immediate=0, .flags=0x80, .name = ".STATS" },
  { .ov = 60, .code = 0x7420, .word = 0xf3c6, .immediate=0, .flags=0x00, .name = "WF3C6" },
  { .ov = 60, .code = 0x7420, .word = 0xf3cb, .immediate=0, .flags=0x00, .name = "WF3CB" },
  { .ov = 60, .code = 0x7420, .word = 0xf3d0, .immediate=0, .flags=0x00, .name = "WF3D0" },
  { .ov = 60, .code = 0x7420, .word = 0xf3d5, .immediate=0, .flags=0x00, .name = "WF3D5" },
  { .ov = 60, .code = 0x224c, .word = 0xf3da, .immediate=0, .flags=0x00, .name = "WF3DA" },
  { .ov = 60, .code = 0x224c, .word = 0xf3e2, .immediate=0, .flags=0x00, .name = "WF3E2" },
  { .ov = 60, .code = 0x224c, .word = 0xf42e, .immediate=0, .flags=0x80, .name = "#HUMANS" },
  { .ov = 60, .code = 0x224c, .word = 0xf444, .immediate=0, .flags=0x00, .name = "WF444" },
  { .ov = 60, .code = 0x224c, .word = 0xf45e, .immediate=0, .flags=0x00, .name = "WF45E" },
  { .ov = 60, .code = 0x224c, .word = 0xf472, .immediate=0, .flags=0x00, .name = "WF472" },
  { .ov = 60, .code = 0x224c, .word = 0xf47c, .immediate=0, .flags=0x00, .name = "WF47C" },
  { .ov = 60, .code = 0x224c, .word = 0xf4b2, .immediate=0, .flags=0x00, .name = "WF4B2" },
  { .ov = 60, .code = 0x224c, .word = 0xf4ca, .immediate=0, .flags=0x00, .name = "WF4CA" },
  { .ov = 60, .code = 0x224c, .word = 0xf4d4, .immediate=0, .flags=0x00, .name = "WF4D4" },
  { .ov = 60, .code = 0x224c, .word = 0xf4d8, .immediate=0, .flags=0x00, .name = "WF4D8" },
  { .ov = 60, .code = 0x224c, .word = 0xf4e2, .immediate=0, .flags=0x00, .name = "WF4E2" },
  { .ov = 60, .code = 0x224c, .word = 0xf4ec, .immediate=0, .flags=0x00, .name = "WF4EC" },
  { .ov = 60, .code = 0x4b3b, .word = 0xf503, .immediate=0, .flags=0x80, .name = "(DO-CLOUD)" },
  { .ov = 60, .code = 0x224c, .word = 0xf52c, .immediate=0, .flags=0x80, .name = "DO-CLOUD" },
  { .ov = 61, .code = 0x1d29, .word = 0xed46, .immediate=0, .flags=0x00, .name = "WED46" },
  { .ov = 61, .code = 0x224c, .word = 0xed4a, .immediate=0, .flags=0x00, .name = "WED4A" },
  { .ov = 61, .code = 0x224c, .word = 0xed54, .immediate=0, .flags=0x00, .name = "WED54" },
  { .ov = 61, .code = 0x224c, .word = 0xed5e, .immediate=0, .flags=0x00, .name = "WED5E" },
  { .ov = 61, .code = 0x7420, .word = 0xedbc, .immediate=0, .flags=0x00, .name = "WEDBC" },
  { .ov = 61, .code = 0x7420, .word = 0xedc1, .immediate=0, .flags=0x00, .name = "WEDC1" },
  { .ov = 61, .code = 0x7420, .word = 0xedc6, .immediate=0, .flags=0x00, .name = "WEDC6" },
  { .ov = 61, .code = 0x7420, .word = 0xedcb, .immediate=0, .flags=0x00, .name = "WEDCB" },
  { .ov = 61, .code = 0x7420, .word = 0xedd0, .immediate=0, .flags=0x00, .name = "WEDD0" },
  { .ov = 61, .code = 0x1d29, .word = 0xedd5, .immediate=0, .flags=0x00, .name = "WEDD5" },
  { .ov = 61, .code = 0x1d29, .word = 0xedd9, .immediate=0, .flags=0x00, .name = "WEDD9" },
  { .ov = 61, .code = 0x224c, .word = 0xeddd, .immediate=0, .flags=0x00, .name = "WEDDD" },
  { .ov = 61, .code = 0x224c, .word = 0xedf7, .immediate=0, .flags=0x00, .name = "WEDF7" },
  { .ov = 61, .code = 0x224c, .word = 0xee01, .immediate=0, .flags=0x00, .name = "WEE01" },
  { .ov = 61, .code = 0x224c, .word = 0xee0b, .immediate=0, .flags=0x00, .name = "WEE0B" },
  { .ov = 61, .code = 0x224c, .word = 0xee15, .immediate=0, .flags=0x00, .name = "WEE15" },
  { .ov = 61, .code = 0x224c, .word = 0xee1f, .immediate=0, .flags=0x00, .name = "WEE1F" },
  { .ov = 61, .code = 0x224c, .word = 0xee31, .immediate=0, .flags=0x00, .name = "WEE31" },
  { .ov = 61, .code = 0x224c, .word = 0xee43, .immediate=0, .flags=0x00, .name = "WEE43" },
  { .ov = 61, .code = 0x224c, .word = 0xee6d, .immediate=0, .flags=0x00, .name = "WEE6D" },
  { .ov = 61, .code = 0x224c, .word = 0xeebb, .immediate=0, .flags=0x00, .name = "WEEBB" },
  { .ov = 61, .code = 0x224c, .word = 0xeee3, .immediate=0, .flags=0x00, .name = "WEEE3" },
  { .ov = 61, .code = 0x224c, .word = 0xef07, .immediate=0, .flags=0x00, .name = "WEF07" },
  { .ov = 61, .code = 0x224c, .word = 0xef31, .immediate=0, .flags=0x00, .name = "WEF31" },
  { .ov = 61, .code = 0x4b3b, .word = 0xef43, .immediate=0, .flags=0x80, .name = "(GET-AU" },
  { .ov = 61, .code = 0x224c, .word = 0xef65, .immediate=0, .flags=0x00, .name = "WEF65" },
  { .ov = 61, .code = 0x224c, .word = 0xef81, .immediate=0, .flags=0x00, .name = "WEF81" },
  { .ov = 61, .code = 0x224c, .word = 0xefb2, .immediate=0, .flags=0x00, .name = "WEFB2" },
  { .ov = 61, .code = 0x1d29, .word = 0xefdc, .immediate=0, .flags=0x00, .name = "WEFDC" },
  { .ov = 61, .code = 0x224c, .word = 0xefe0, .immediate=0, .flags=0x00, .name = "WEFE0" },
  { .ov = 61, .code = 0x224c, .word = 0xefea, .immediate=0, .flags=0x00, .name = "WEFEA" },
  { .ov = 61, .code = 0x224c, .word = 0xf010, .immediate=0, .flags=0x00, .name = "WF010" },
  { .ov = 61, .code = 0x224c, .word = 0xf018, .immediate=0, .flags=0x00, .name = "WF018" },
  { .ov = 61, .code = 0x224c, .word = 0xf048, .immediate=0, .flags=0x00, .name = "WF048" },
  { .ov = 61, .code = 0x224c, .word = 0xf05e, .immediate=0, .flags=0x00, .name = "WF05E" },
  { .ov = 61, .code = 0x1d29, .word = 0xf06c, .immediate=0, .flags=0x00, .name = "WF06C" },
  { .ov = 61, .code = 0x224c, .word = 0xf070, .immediate=0, .flags=0x00, .name = "WF070" },
  { .ov = 61, .code = 0x224c, .word = 0xf094, .immediate=0, .flags=0x00, .name = "WF094" },
  { .ov = 61, .code = 0x224c, .word = 0xf0b0, .immediate=0, .flags=0x00, .name = "WF0B0" },
  { .ov = 61, .code = 0x224c, .word = 0xf0c0, .immediate=0, .flags=0x00, .name = "WF0C0" },
  { .ov = 61, .code = 0x224c, .word = 0xf0c8, .immediate=0, .flags=0x00, .name = "WF0C8" },
  { .ov = 61, .code = 0x224c, .word = 0xf0d4, .immediate=0, .flags=0x00, .name = "WF0D4" },
  { .ov = 61, .code = 0x1d29, .word = 0xf12a, .immediate=0, .flags=0x00, .name = "WF12A" },
  { .ov = 61, .code = 0x224c, .word = 0xf12e, .immediate=0, .flags=0x00, .name = "WF12E" },
  { .ov = 61, .code = 0x224c, .word = 0xf15c, .immediate=0, .flags=0x00, .name = "WF15C" },
  { .ov = 61, .code = 0x224c, .word = 0xf166, .immediate=0, .flags=0x00, .name = "WF166" },
  { .ov = 61, .code = 0x224c, .word = 0xf18c, .immediate=0, .flags=0x00, .name = "WF18C" },
  { .ov = 61, .code = 0x224c, .word = 0xf1c8, .immediate=0, .flags=0x00, .name = "WF1C8" },
  { .ov = 61, .code = 0x224c, .word = 0xf1e4, .immediate=0, .flags=0x00, .name = "WF1E4" },
  { .ov = 61, .code = 0x224c, .word = 0xf1fe, .immediate=0, .flags=0x00, .name = "WF1FE" },
  { .ov = 61, .code = 0x224c, .word = 0xf222, .immediate=0, .flags=0x00, .name = "WF222" },
  { .ov = 61, .code = 0x224c, .word = 0xf250, .immediate=0, .flags=0x00, .name = "WF250" },
  { .ov = 61, .code = 0x224c, .word = 0xf26a, .immediate=0, .flags=0x00, .name = "WF26A" },
  { .ov = 61, .code = 0x224c, .word = 0xf314, .immediate=0, .flags=0x00, .name = "WF314" },
  { .ov = 61, .code = 0x224c, .word = 0xf380, .immediate=0, .flags=0x00, .name = "WF380" },
  { .ov = 61, .code = 0x224c, .word = 0xf398, .immediate=0, .flags=0x00, .name = "WF398" },
  { .ov = 61, .code = 0x224c, .word = 0xf3be, .immediate=0, .flags=0x00, .name = "WF3BE" },
  { .ov = 61, .code = 0x224c, .word = 0xf3d4, .immediate=0, .flags=0x00, .name = "WF3D4" },
  { .ov = 61, .code = 0x224c, .word = 0xf3f6, .immediate=0, .flags=0x00, .name = "WF3F6" },
  { .ov = 61, .code = 0x224c, .word = 0xf40a, .immediate=0, .flags=0x00, .name = "WF40A" },
  { .ov = 61, .code = 0x224c, .word = 0xf440, .immediate=0, .flags=0x00, .name = "WF440" },
  { .ov = 61, .code = 0x224c, .word = 0xf464, .immediate=0, .flags=0x00, .name = "WF464" },
  { .ov = 61, .code = 0x224c, .word = 0xf482, .immediate=0, .flags=0x00, .name = "WF482" },
  { .ov = 61, .code = 0x224c, .word = 0xf4d1, .immediate=0, .flags=0x80, .name = "JUMP" },
  { .ov = 62, .code = 0x7420, .word = 0xf376, .immediate=0, .flags=0x00, .name = "WF376" },
  { .ov = 62, .code = 0x224c, .word = 0xf37b, .immediate=0, .flags=0x00, .name = "WF37B" },
  { .ov = 62, .code = 0x224c, .word = 0xf396, .immediate=0, .flags=0x80, .name = ".NOFUN" },
  { .ov = 62, .code = 0x224c, .word = 0xf3c8, .immediate=0, .flags=0x00, .name = "WF3C8" },
  { .ov = 62, .code = 0x224c, .word = 0xf3f6, .immediate=0, .flags=0x00, .name = "WF3F6" },
  { .ov = 62, .code = 0x224c, .word = 0xf436, .immediate=0, .flags=0x00, .name = "WF436" },
  { .ov = 62, .code = 0x224c, .word = 0xf46c, .immediate=0, .flags=0x00, .name = "WF46C" },
  { .ov = 62, .code = 0x224c, .word = 0xf47a, .immediate=0, .flags=0x00, .name = "WF47A" },
  { .ov = 62, .code = 0x224c, .word = 0xf4a0, .immediate=0, .flags=0x00, .name = "WF4A0" },
  { .ov = 62, .code = 0x224c, .word = 0xf4b2, .immediate=0, .flags=0x00, .name = "WF4B2" },
  { .ov = 62, .code = 0x224c, .word = 0xf4c0, .immediate=0, .flags=0x00, .name = "WF4C0" },
  { .ov = 62, .code = 0x224c, .word = 0xf4d7, .immediate=0, .flags=0x80, .name = "TOW-US" },
  { .ov = 63, .code = 0x7394, .word = 0xebf6, .immediate=0, .flags=0x00, .name = "WEBF6" },
  { .ov = 63, .code = 0x7394, .word = 0xebfe, .immediate=0, .flags=0x00, .name = "WEBFE" },
  { .ov = 63, .code = 0x7394, .word = 0xec06, .immediate=0, .flags=0x00, .name = "WEC06" },
  { .ov = 63, .code = 0x7394, .word = 0xec0e, .immediate=0, .flags=0x00, .name = "WEC0E" },
  { .ov = 63, .code = 0x224c, .word = 0xec16, .immediate=0, .flags=0x00, .name = "WEC16" },
  { .ov = 63, .code = 0x1d29, .word = 0xec20, .immediate=0, .flags=0x00, .name = "WEC20" },
  { .ov = 63, .code = 0x224c, .word = 0xec2a, .immediate=0, .flags=0x00, .name = "WEC2A" },
  { .ov = 63, .code = 0x224c, .word = 0xec4e, .immediate=0, .flags=0x00, .name = "WEC4E" },
  { .ov = 63, .code = 0x224c, .word = 0xec60, .immediate=0, .flags=0x00, .name = "WEC60" },
  { .ov = 63, .code = 0x224c, .word = 0xec90, .immediate=0, .flags=0x00, .name = "WEC90" },
  { .ov = 63, .code = 0x224c, .word = 0xeca2, .immediate=0, .flags=0x00, .name = "WECA2" },
  { .ov = 63, .code = 0x224c, .word = 0xecf1, .immediate=0, .flags=0x00, .name = "WECF1" },
  { .ov = 63, .code = 0x224c, .word = 0xed1f, .immediate=0, .flags=0x00, .name = "WED1F" },
  { .ov = 63, .code = 0x224c, .word = 0xed31, .immediate=0, .flags=0x00, .name = "WED31" },
  { .ov = 63, .code = 0x224c, .word = 0xed65, .immediate=0, .flags=0x00, .name = "WED65" },
  { .ov = 63, .code = 0x1d29, .word = 0xed6f, .immediate=0, .flags=0x00, .name = "WED6F" },
  { .ov = 63, .code = 0x224c, .word = 0xed74, .immediate=0, .flags=0x00, .name = "WED74" },
  { .ov = 63, .code = 0x224c, .word = 0xed7e, .immediate=0, .flags=0x00, .name = "WED7E" },
  { .ov = 63, .code = 0x224c, .word = 0xed86, .immediate=0, .flags=0x00, .name = "WED86" },
  { .ov = 63, .code = 0x224c, .word = 0xed90, .immediate=0, .flags=0x00, .name = "WED90" },
  { .ov = 63, .code = 0x224c, .word = 0xeda4, .immediate=0, .flags=0x00, .name = "WEDA4" },
  { .ov = 63, .code = 0x1d29, .word = 0xedb8, .immediate=0, .flags=0x00, .name = "WEDB8" },
  { .ov = 63, .code = 0x224c, .word = 0xedbd, .immediate=0, .flags=0x00, .name = "WEDBD" },
  { .ov = 63, .code = 0x224c, .word = 0xedc7, .immediate=0, .flags=0x00, .name = "WEDC7" },
  { .ov = 63, .code = 0x224c, .word = 0xedcf, .immediate=0, .flags=0x00, .name = "WEDCF" },
  { .ov = 63, .code = 0x224c, .word = 0xede3, .immediate=0, .flags=0x00, .name = "WEDE3" },
  { .ov = 63, .code = 0x224c, .word = 0xedf7, .immediate=0, .flags=0x00, .name = "WEDF7" },
  { .ov = 63, .code = 0x224c, .word = 0xee19, .immediate=0, .flags=0x00, .name = "WEE19" },
  { .ov = 63, .code = 0x224c, .word = 0xee25, .immediate=0, .flags=0x00, .name = "WEE25" },
  { .ov = 63, .code = 0x224c, .word = 0xee2f, .immediate=0, .flags=0x00, .name = "WEE2F" },
  { .ov = 63, .code = 0x224c, .word = 0xee5b, .immediate=0, .flags=0x00, .name = "WEE5B" },
  { .ov = 63, .code = 0x224c, .word = 0xee73, .immediate=0, .flags=0x00, .name = "WEE73" },
  { .ov = 63, .code = 0x224c, .word = 0xee91, .immediate=0, .flags=0x00, .name = "WEE91" },
  { .ov = 63, .code = 0x224c, .word = 0xeea1, .immediate=0, .flags=0x00, .name = "WEEA1" },
  { .ov = 63, .code = 0x224c, .word = 0xeecd, .immediate=0, .flags=0x00, .name = "WEECD" },
  { .ov = 63, .code = 0x224c, .word = 0xeed9, .immediate=0, .flags=0x00, .name = "WEED9" },
  { .ov = 63, .code = 0x224c, .word = 0xeee5, .immediate=0, .flags=0x00, .name = "WEEE5" },
  { .ov = 63, .code = 0x224c, .word = 0xeef9, .immediate=0, .flags=0x00, .name = "WEEF9" },
  { .ov = 63, .code = 0x224c, .word = 0xef15, .immediate=0, .flags=0x00, .name = "WEF15" },
  { .ov = 63, .code = 0x224c, .word = 0xef2d, .immediate=0, .flags=0x00, .name = "WEF2D" },
  { .ov = 63, .code = 0x4b3b, .word = 0xef59, .immediate=0, .flags=0x80, .name = "TD-SCRO" },
  { .ov = 63, .code = 0x224c, .word = 0xef67, .immediate=0, .flags=0x00, .name = "WEF67" },
  { .ov = 63, .code = 0x224c, .word = 0xef85, .immediate=0, .flags=0x00, .name = "WEF85" },
  { .ov = 63, .code = 0x224c, .word = 0xefad, .immediate=0, .flags=0x00, .name = "WEFAD" },
  { .ov = 63, .code = 0x224c, .word = 0xefbb, .immediate=0, .flags=0x00, .name = "WEFBB" },
  { .ov = 63, .code = 0x224c, .word = 0xefc9, .immediate=0, .flags=0x00, .name = "WEFC9" },
  { .ov = 63, .code = 0x224c, .word = 0xefd7, .immediate=0, .flags=0x00, .name = "WEFD7" },
  { .ov = 63, .code = 0x1d29, .word = 0xefec, .immediate=0, .flags=0x80, .name = "ACT#" },
  { .ov = 63, .code = 0x224c, .word = 0xeff0, .immediate=0, .flags=0x00, .name = "WEFF0" },
  { .ov = 63, .code = 0x224c, .word = 0xeffc, .immediate=0, .flags=0x00, .name = "WEFFC" },
  { .ov = 63, .code = 0x224c, .word = 0xf018, .immediate=0, .flags=0x00, .name = "WF018" },
  { .ov = 63, .code = 0x224c, .word = 0xf02a, .immediate=0, .flags=0x00, .name = "WF02A" },
  { .ov = 63, .code = 0x224c, .word = 0xf03c, .immediate=0, .flags=0x00, .name = "WF03C" },
  { .ov = 63, .code = 0x224c, .word = 0xf04a, .immediate=0, .flags=0x00, .name = "WF04A" },
  { .ov = 63, .code = 0x224c, .word = 0xf062, .immediate=0, .flags=0x00, .name = "WF062" },
  { .ov = 63, .code = 0x4b3b, .word = 0xf084, .immediate=0, .flags=0x80, .name = "ACT-SCR" },
  { .ov = 63, .code = 0x224c, .word = 0xf092, .immediate=0, .flags=0x00, .name = "WF092" },
  { .ov = 63, .code = 0x224c, .word = 0xf0b6, .immediate=0, .flags=0x80, .name = "ACTION?" },
  { .ov = 63, .code = 0x224c, .word = 0xf0be, .immediate=0, .flags=0x00, .name = "WF0BE" },
  { .ov = 63, .code = 0x224c, .word = 0xf0c4, .immediate=0, .flags=0x00, .name = "WF0C4" },
  { .ov = 63, .code = 0x4b3b, .word = 0xf0d4, .immediate=0, .flags=0x80, .name = "#>ACTIO" },
  { .ov = 63, .code = 0x1d29, .word = 0xf0e6, .immediate=0, .flags=0x00, .name = "WF0E6" },
  { .ov = 63, .code = 0x224c, .word = 0xf0ea, .immediate=0, .flags=0x00, .name = "WF0EA" },
  { .ov = 63, .code = 0x224c, .word = 0xf0f2, .immediate=0, .flags=0x00, .name = "WF0F2" },
  { .ov = 63, .code = 0x224c, .word = 0xf0fe, .immediate=0, .flags=0x00, .name = "WF0FE" },
  { .ov = 63, .code = 0x224c, .word = 0xf10a, .immediate=0, .flags=0x00, .name = "WF10A" },
  { .ov = 63, .code = 0x224c, .word = 0xf116, .immediate=0, .flags=0x00, .name = "WF116" },
  { .ov = 63, .code = 0x224c, .word = 0xf122, .immediate=0, .flags=0x00, .name = "WF122" },
  { .ov = 63, .code = 0x224c, .word = 0xf12e, .immediate=0, .flags=0x00, .name = "WF12E" },
  { .ov = 63, .code = 0x1d29, .word = 0xf13a, .immediate=0, .flags=0x00, .name = "WF13A" },
  { .ov = 63, .code = 0x224c, .word = 0xf13e, .immediate=0, .flags=0x00, .name = "WF13E" },
  { .ov = 63, .code = 0xf144, .word = 0xf15b, .immediate=0, .flags=0x80, .name = "10!TIME" },
  { .ov = 63, .code = 0xf144, .word = 0xf168, .immediate=0, .flags=0x80, .name = "20!TIME" },
  { .ov = 63, .code = 0xf144, .word = 0xf175, .immediate=0, .flags=0x80, .name = "30!TIME" },
  { .ov = 63, .code = 0xf144, .word = 0xf181, .immediate=0, .flags=0x80, .name = "5!TIME" },
  { .ov = 63, .code = 0xf144, .word = 0xf18d, .immediate=0, .flags=0x80, .name = "7!TIME" },
  { .ov = 63, .code = 0xf144, .word = 0xf19a, .immediate=0, .flags=0x80, .name = "13!TIME" },
  { .ov = 63, .code = 0xf144, .word = 0xf1a6, .immediate=0, .flags=0x80, .name = "3!TIME" },
  { .ov = 63, .code = 0x224c, .word = 0xf1a9, .immediate=0, .flags=0x00, .name = "WF1A9" },
  { .ov = 63, .code = 0xaccc, .word = 0xf1dd, .immediate=0, .flags=0x80, .name = "(TIMER)" },
  { .ov = 63, .code = 0x224c, .word = 0xf223, .immediate=0, .flags=0x00, .name = "WF223" },
  { .ov = 63, .code = 0x1d29, .word = 0xf23f, .immediate=0, .flags=0x80, .name = "TIMES" },
  { .ov = 63, .code = 0x224c, .word = 0xf271, .immediate=0, .flags=0x00, .name = "WF271" },
  { .ov = 63, .code = 0x224c, .word = 0xf27d, .immediate=0, .flags=0x00, .name = "WF27D" },
  { .ov = 63, .code = 0x224c, .word = 0xf289, .immediate=0, .flags=0x00, .name = "WF289" },
  { .ov = 63, .code = 0x224c, .word = 0xf2cb, .immediate=0, .flags=0x00, .name = "WF2CB" },
  { .ov = 63, .code = 0x224c, .word = 0xf2ed, .immediate=0, .flags=0x00, .name = "WF2ED" },
  { .ov = 63, .code = 0x224c, .word = 0xf31d, .immediate=0, .flags=0x00, .name = "WF31D" },
  { .ov = 63, .code = 0x224c, .word = 0xf33d, .immediate=0, .flags=0x00, .name = "WF33D" },
  { .ov = 63, .code = 0x224c, .word = 0xf351, .immediate=0, .flags=0x00, .name = "WF351" },
  { .ov = 63, .code = 0x224c, .word = 0xf385, .immediate=0, .flags=0x00, .name = "WF385" },
  { .ov = 63, .code = 0x224c, .word = 0xf39f, .immediate=0, .flags=0x00, .name = "WF39F" },
  { .ov = 63, .code = 0x224c, .word = 0xf3a9, .immediate=0, .flags=0x00, .name = "WF3A9" },
  { .ov = 63, .code = 0x224c, .word = 0xf3c9, .immediate=0, .flags=0x00, .name = "WF3C9" },
  { .ov = 63, .code = 0x224c, .word = 0xf3f9, .immediate=0, .flags=0x00, .name = "WF3F9" },
  { .ov = 63, .code = 0x224c, .word = 0xf46f, .immediate=0, .flags=0x00, .name = "WF46F" },
  { .ov = 63, .code = 0x224c, .word = 0xf49a, .immediate=0, .flags=0x80, .name = "RECALL" },
  { .ov = 63, .code = 0x224c, .word = 0xf4d0, .immediate=0, .flags=0x80, .name = "DRONE" },
  { .ov = 64, .code = 0x224c, .word = 0xec26, .immediate=0, .flags=0x00, .name = "WEC26" },
  { .ov = 64, .code = 0x224c, .word = 0xec38, .immediate=0, .flags=0x00, .name = "WEC38" },
  { .ov = 64, .code = 0x224c, .word = 0xec44, .immediate=0, .flags=0x00, .name = "WEC44" },
  { .ov = 64, .code = 0x224c, .word = 0xec4c, .immediate=0, .flags=0x00, .name = "WEC4C" },
  { .ov = 64, .code = 0x224c, .word = 0xec54, .immediate=0, .flags=0x00, .name = "WEC54" },
  { .ov = 64, .code = 0x2214, .word = 0xec5e, .immediate=0, .flags=0x00, .name = "WEC5E" },
  { .ov = 64, .code = 0x7420, .word = 0xec62, .immediate=0, .flags=0x00, .name = "WEC62" },
  { .ov = 64, .code = 0x7420, .word = 0xec67, .immediate=0, .flags=0x00, .name = "WEC67" },
  { .ov = 64, .code = 0x7420, .word = 0xec6c, .immediate=0, .flags=0x00, .name = "WEC6C" },
  { .ov = 64, .code = 0x7420, .word = 0xec71, .immediate=0, .flags=0x00, .name = "WEC71" },
  { .ov = 64, .code = 0x7420, .word = 0xec76, .immediate=0, .flags=0x00, .name = "WEC76" },
  { .ov = 64, .code = 0x224c, .word = 0xec7b, .immediate=0, .flags=0x00, .name = "WEC7B" },
  { .ov = 64, .code = 0x224c, .word = 0xec8d, .immediate=0, .flags=0x00, .name = "WEC8D" },
  { .ov = 64, .code = 0x224c, .word = 0xecab, .immediate=0, .flags=0x00, .name = "WECAB" },
  { .ov = 64, .code = 0x224c, .word = 0xecb3, .immediate=0, .flags=0x00, .name = "WECB3" },
  { .ov = 64, .code = 0x224c, .word = 0xecbb, .immediate=0, .flags=0x00, .name = "WECBB" },
  { .ov = 64, .code = 0x224c, .word = 0xecc5, .immediate=0, .flags=0x00, .name = "WECC5" },
  { .ov = 64, .code = 0x224c, .word = 0xed01, .immediate=0, .flags=0x00, .name = "WED01" },
  { .ov = 64, .code = 0x224c, .word = 0xed0f, .immediate=0, .flags=0x00, .name = "WED0F" },
  { .ov = 64, .code = 0x224c, .word = 0xed1d, .immediate=0, .flags=0x00, .name = "WED1D" },
  { .ov = 64, .code = 0x224c, .word = 0xed2b, .immediate=0, .flags=0x00, .name = "WED2B" },
  { .ov = 64, .code = 0x224c, .word = 0xed39, .immediate=0, .flags=0x00, .name = "WED39" },
  { .ov = 64, .code = 0x224c, .word = 0xed47, .immediate=0, .flags=0x00, .name = "WED47" },
  { .ov = 64, .code = 0x1d29, .word = 0xed5d, .immediate=0, .flags=0x00, .name = "WED5D" },
  { .ov = 64, .code = 0x224c, .word = 0xed61, .immediate=0, .flags=0x00, .name = "WED61" },
  { .ov = 64, .code = 0x224c, .word = 0xeda9, .immediate=0, .flags=0x00, .name = "WEDA9" },
  { .ov = 64, .code = 0x224c, .word = 0xedb5, .immediate=0, .flags=0x00, .name = "WEDB5" },
  { .ov = 64, .code = 0x224c, .word = 0xeddb, .immediate=0, .flags=0x00, .name = "WEDDB" },
  { .ov = 64, .code = 0x224c, .word = 0xede5, .immediate=0, .flags=0x00, .name = "WEDE5" },
  { .ov = 64, .code = 0x224c, .word = 0xedf7, .immediate=0, .flags=0x00, .name = "WEDF7" },
  { .ov = 64, .code = 0x224c, .word = 0xee5f, .immediate=0, .flags=0x00, .name = "WEE5F" },
  { .ov = 64, .code = 0x224c, .word = 0xeeac, .immediate=0, .flags=0x00, .name = "WEEAC" },
  { .ov = 64, .code = 0x224c, .word = 0xeee0, .immediate=0, .flags=0x00, .name = "WEEE0" },
  { .ov = 64, .code = 0x224c, .word = 0xeef6, .immediate=0, .flags=0x00, .name = "WEEF6" },
  { .ov = 64, .code = 0x224c, .word = 0xef02, .immediate=0, .flags=0x00, .name = "WEF02" },
  { .ov = 64, .code = 0x224c, .word = 0xef0c, .immediate=0, .flags=0x00, .name = "WEF0C" },
  { .ov = 64, .code = 0x224c, .word = 0xef24, .immediate=0, .flags=0x00, .name = "WEF24" },
  { .ov = 64, .code = 0x224c, .word = 0xef2c, .immediate=0, .flags=0x00, .name = "WEF2C" },
  { .ov = 64, .code = 0x224c, .word = 0xef48, .immediate=0, .flags=0x00, .name = "WEF48" },
  { .ov = 64, .code = 0x224c, .word = 0xef54, .immediate=0, .flags=0x00, .name = "WEF54" },
  { .ov = 64, .code = 0x224c, .word = 0xef86, .immediate=0, .flags=0x00, .name = "WEF86" },
  { .ov = 64, .code = 0x224c, .word = 0xefa4, .immediate=0, .flags=0x00, .name = "WEFA4" },
  { .ov = 64, .code = 0x224c, .word = 0xefd4, .immediate=0, .flags=0x00, .name = "WEFD4" },
  { .ov = 64, .code = 0x224c, .word = 0xeffc, .immediate=0, .flags=0x00, .name = "WEFFC" },
  { .ov = 64, .code = 0x1d29, .word = 0xf046, .immediate=0, .flags=0x00, .name = "WF046" },
  { .ov = 64, .code = 0x1d29, .word = 0xf04c, .immediate=0, .flags=0x00, .name = "WF04C" },
  { .ov = 64, .code = 0x1d29, .word = 0xf052, .immediate=0, .flags=0x00, .name = "WF052" },
  { .ov = 64, .code = 0x1d29, .word = 0xf058, .immediate=0, .flags=0x00, .name = "WF058" },
  { .ov = 64, .code = 0x1d29, .word = 0xf05e, .immediate=0, .flags=0x00, .name = "WF05E" },
  { .ov = 64, .code = 0x224c, .word = 0xf064, .immediate=0, .flags=0x00, .name = "WF064" },
  { .ov = 64, .code = 0x224c, .word = 0xf074, .immediate=0, .flags=0x00, .name = "WF074" },
  { .ov = 64, .code = 0x224c, .word = 0xf094, .immediate=0, .flags=0x00, .name = "WF094" },
  { .ov = 64, .code = 0x224c, .word = 0xf0e8, .immediate=0, .flags=0x00, .name = "WF0E8" },
  { .ov = 64, .code = 0x224c, .word = 0xf0f4, .immediate=0, .flags=0x00, .name = "WF0F4" },
  { .ov = 64, .code = 0x224c, .word = 0xf138, .immediate=0, .flags=0x00, .name = "WF138" },
  { .ov = 64, .code = 0x224c, .word = 0xf158, .immediate=0, .flags=0x00, .name = "WF158" },
  { .ov = 64, .code = 0x224c, .word = 0xf172, .immediate=0, .flags=0x00, .name = "WF172" },
  { .ov = 64, .code = 0x224c, .word = 0xf20c, .immediate=0, .flags=0x00, .name = "WF20C" },
  { .ov = 64, .code = 0x224c, .word = 0xf24a, .immediate=0, .flags=0x00, .name = "WF24A" },
  { .ov = 64, .code = 0x1d29, .word = 0xf254, .immediate=0, .flags=0x00, .name = "WF254" },
  { .ov = 64, .code = 0x224c, .word = 0xf258, .immediate=0, .flags=0x00, .name = "WF258" },
  { .ov = 64, .code = 0x224c, .word = 0xf26c, .immediate=0, .flags=0x00, .name = "WF26C" },
  { .ov = 64, .code = 0x224c, .word = 0xf2aa, .immediate=0, .flags=0x00, .name = "WF2AA" },
  { .ov = 64, .code = 0x224c, .word = 0xf2bc, .immediate=0, .flags=0x00, .name = "WF2BC" },
  { .ov = 64, .code = 0x224c, .word = 0xf2d4, .immediate=0, .flags=0x00, .name = "WF2D4" },
  { .ov = 64, .code = 0x224c, .word = 0xf2f4, .immediate=0, .flags=0x00, .name = "WF2F4" },
  { .ov = 64, .code = 0x224c, .word = 0xf306, .immediate=0, .flags=0x00, .name = "WF306" },
  { .ov = 64, .code = 0x224c, .word = 0xf352, .immediate=0, .flags=0x80, .name = "GNUNK>NUL" },
  { .ov = 64, .code = 0x224c, .word = 0xf374, .immediate=0, .flags=0x00, .name = "WF374" },
  { .ov = 64, .code = 0x224c, .word = 0xf3bc, .immediate=0, .flags=0x00, .name = "WF3BC" },
  { .ov = 64, .code = 0x224c, .word = 0xf3f0, .immediate=0, .flags=0x00, .name = "WF3F0" },
  { .ov = 64, .code = 0x224c, .word = 0xf448, .immediate=0, .flags=0x00, .name = "WF448" },
  { .ov = 64, .code = 0x224c, .word = 0xf476, .immediate=0, .flags=0x00, .name = "WF476" },
  { .ov = 64, .code = 0x224c, .word = 0xf491, .immediate=0, .flags=0x80, .name = "DONULL" },
  { .ov = 64, .code = 0x224c, .word = 0xf520, .immediate=0, .flags=0x80, .name = "TARG" },
  { .ov = -2, .code = 0x0000, .word = 0x0000, .immediate = 0x00, .flags=0x00, .name = NULL }
};
