// ====== OVERLAY 'MUSIC' ======
// store offset = 0xe200
// overlay size   = 0x1360

#include"../../emul/cpu.h"

#include"../data.h"
#include"../../emul/starflt1.h"


// =================================
// =========== Dictionary ==========
// =================================
//          OLDINT  codep:0x2214 wordp:0xe21f size:0x0002 C-string:'OLDINT'
//          ?MUSIC  codep:0x2214 wordp:0xe22c size:0x0002 C-string:'IsMUSIC'
//          MUSINT  codep:0x2214 wordp:0xe239 size:0x0002 C-string:'MUSINT'
//         PHRASE0  codep:0x2214 wordp:0xe247 size:0x0002 C-string:'PHRASE0'
//         CURRPHR  codep:0x2214 wordp:0xe255 size:0x0002 C-string:'CURRPHR'
//         CURNOTE  codep:0x2214 wordp:0xe263 size:0x0002 C-string:'CURNOTE'
//         REPEATS  codep:0x2214 wordp:0xe271 size:0x0002 C-string:'REPEATS'
//         COUNTER  codep:0x2214 wordp:0xe27f size:0x0002 C-string:'COUNTER'
//        DURATION  codep:0x2214 wordp:0xe28e size:0x0002 C-string:'DURATION'
//       RESTVALUE  codep:0x2214 wordp:0xe29e size:0x0002 C-string:'RESTVALUE'
//       TONESTATE  codep:0x2214 wordp:0xe2ae size:0x0002 C-string:'TONESTATE'
//           SONGS  codep:0x2214 wordp:0xe2ba size:0x0002 C-string:'SONGS'
//           SCALE  codep:0x2214 wordp:0xe2c6 size:0x0002 C-string:'SCALE'
//           WE2CA  codep:0x1d29 wordp:0xe2ca size:0x0002 C-string:'WE2CA'
//           WE2CE  codep:0x224c wordp:0xe2ce size:0x0006 C-string:'WE2CE'
//           WE2D6  codep:0x224c wordp:0xe2d6 size:0x0006 C-string:'WE2D6'
//           WE2DE  codep:0x224c wordp:0xe2de size:0x0006 C-string:'WE2DE'
//           WE2E6  codep:0x224c wordp:0xe2e6 size:0x0006 C-string:'WE2E6'
//           WE2EE  codep:0x224c wordp:0xe2ee size:0x01c9 C-string:'WE2EE'
//              P2  codep:0x1d29 wordp:0xe4be size:0x0014 C-string:'P2'
//              P3  codep:0x1d29 wordp:0xe4d9 size:0x0014 C-string:'P3'
//              P4  codep:0x1d29 wordp:0xe4f4 size:0x0014 C-string:'P4'
//              P5  codep:0x1d29 wordp:0xe50f size:0x001a C-string:'P5'
//              P6  codep:0x1d29 wordp:0xe530 size:0x0014 C-string:'P6'
//              P1  codep:0x1d29 wordp:0xe54b size:0x001a C-string:'P1'
//              R,  codep:0x224c wordp:0xe56c size:0x000a C-string:'R_co_'
//           0SONG  codep:0x1d29 wordp:0xe580 size:0x0017 C-string:'_0SONG'
//         INITMUS  codep:0x224c wordp:0xe5a3 size:0x003e C-string:'INITMUS'
//           HIMUS  codep:0x224c wordp:0xe5eb size:0x0014 C-string:'HIMUS'
//        CSCR>EGA  codep:0x224c wordp:0xe60c size:0x0072 C-string:'CSCR_gt_EGA'
//           WE680  codep:0x224c wordp:0xe680 size:0x001a C-string:'WE680'
//           WE69C  codep:0x224c wordp:0xe69c size:0x001a C-string:'WE69C'
//           WE6B8  codep:0x2214 wordp:0xe6b8 size:0x0002 C-string:'WE6B8'
//           WE6BC  codep:0x1d29 wordp:0xe6bc size:0x0002 C-string:'WE6BC'
//           WE6C0  codep:0x1d29 wordp:0xe6c0 size:0x0002 C-string:'WE6C0'
//           WE6C4  codep:0x1d29 wordp:0xe6c4 size:0x0002 C-string:'WE6C4'
//           WE6C8  codep:0x1d29 wordp:0xe6c8 size:0x0002 C-string:'WE6C8'
//           WE6CC  codep:0x1d29 wordp:0xe6cc size:0x0002 C-string:'WE6CC'
//           WE6D0  codep:0x1d29 wordp:0xe6d0 size:0x0002 C-string:'WE6D0'
//           WE6D4  codep:0x1d29 wordp:0xe6d4 size:0x0002 C-string:'WE6D4'
//           WE6D8  codep:0x1d29 wordp:0xe6d8 size:0x0002 C-string:'WE6D8'
//           WE6DC  codep:0x1d29 wordp:0xe6dc size:0x0002 C-string:'WE6DC'
//           WE6E0  codep:0x1d29 wordp:0xe6e0 size:0x0002 C-string:'WE6E0'
//           WE6E4  codep:0x224c wordp:0xe6e4 size:0x0006 C-string:'WE6E4'
//           WE6EC  codep:0x224c wordp:0xe6ec size:0x0012 C-string:'WE6EC'
//           WE700  codep:0x224c wordp:0xe700 size:0x0014 C-string:'WE700'
//           WE716  codep:0x224c wordp:0xe716 size:0x0012 C-string:'WE716'
//          BRMOVE  codep:0x224c wordp:0xe733 size:0x0098 C-string:'BRMOVE'
//           WE7CD  codep:0x224c wordp:0xe7cd size:0x0044 C-string:'WE7CD'
//           WE813  codep:0x224c wordp:0xe813 size:0x0016 C-string:'WE813'
//           WE82B  codep:0x224c wordp:0xe82b size:0x005a C-string:'WE82B'
//          REDUCE  codep:0x224c wordp:0xe890 size:0x0026 C-string:'REDUCE'
//        INCREASE  codep:0x224c wordp:0xe8c3 size:0x0018 C-string:'INCREASE'
//           XOFFS  codep:0x1d29 wordp:0xe8e5 size:0x001a C-string:'XOFFS'
//        PAUSEOFF  codep:0x1d29 wordp:0xe90c size:0x001a C-string:'PAUSEOFF'
//           WE928  codep:0x224c wordp:0xe928 size:0x0054 C-string:'WE928'
//   CREDIT.SCREEN  codep:0x224c wordp:0xe98e size:0x000e C-string:'CREDIT_dot_SCREEN'
//          INTROS  codep:0x224c wordp:0xe9a7 size:0x0000 C-string:'INTROS'

// =================================
// ============= EXTERN ============
// =================================
extern const unsigned short int cc_MUSSEG; // MUSSEG
extern const unsigned short int pp__n_CACHE; // #CACHE
extern const unsigned short int pp_XBUF_dash_SE; // XBUF-SE
extern const unsigned short int pp_HBUF_dash_SEG; // HBUF-SEG
extern const unsigned short int pp_COLOR; // COLOR
extern const unsigned short int pp_LFSEG; // LFSEG
extern const unsigned short int pp__bo__n_CACHE_bc_; // [#CACHE]
extern const unsigned short int pp_IsEGA; // ?EGA
void AUTO_dash_CACHE(); // AUTO-CACHE
void D_st_(); // D<
void _co_(); // ,
void MS(); // MS
void _2OVER(); // 2OVER
void D_gt_(); // D>
void Store_3(); // !_3
void _plus__ex__2(); // +!_2
void ON_3(); // ON_3
void OFF(); // OFF
void BLOCK_2(); // BLOCK_2
void FILE_st_(); // FILE<
void FLUSH_2(); // FLUSH_2
void _gt_DISPLAY(); // >DISPLAY
void _gt_HIDDEN(); // >HIDDEN
void _gt_LORES_2(); // >LORES_2
void SCR_dash_RES(); // SCR-RES
void DARK(); // DARK
void SONG(); // SONG
void _i_KEY(); // 'KEY
void CFIGARRAYS(); // CFIGARRAYS
void _ro__ex_SET_rc_(); // (!SET)
void _ro__ex_OLD_rc_(); // (!OLD)
void _2_at_(); // 2@
void SEG_gt_ADDR(); // SEG>ADDR
void _2DUP(); // 2DUP
void OVER(); // OVER
void ROT(); // ROT
void SWAP(); // SWAP
void _slash_(); // /
void _slash_MOD(); // /MOD
void _dash_(); // -
void D_plus_(); // D+
void BEEPOFF(); // BEEPOFF
void TIME(); // TIME
void L_at_(); // L@
void L_ex_(); // L!
void LC_at_(); // LC@
void LC_ex_(); // LC!
void LCMOVE(); // LCMOVE
void GetDS(); // @DS
void _st__ex__gt_(); // <!>
void C_gt_EGA(); // C>EGA
void DISPLAY_dash_WAIT(); // DISPLAY-WAIT
void PLOT(); // PLOT


// =================================
// =========== VARIABLES ===========
// =================================
const unsigned short int pp_WE2CA = 0xe2ca; // WE2CA size: 2
// {0x00, 0xe3}

const unsigned short int pp_P2 = 0xe4be; // P2 size: 20
// {0x09, 0x3c, 0x03, 0x2c, 0x09, 0x1c, 0x03, 0x2c, 0x09, 0x14, 0x03, 0x1c, 0x09, 0x04, 0x03, 0x14, 0x30, 0x24, 0x00, 0x00}

const unsigned short int pp_P3 = 0xe4d9; // P3 size: 20
// {0x09, 0x3c, 0x03, 0x2c, 0x09, 0x1c, 0x03, 0x2c, 0x09, 0x14, 0x03, 0x1c, 0x09, 0x04, 0x03, 0x53, 0x30, 0x04, 0x00, 0x00}

const unsigned short int pp_P4 = 0xe4f4; // P4 size: 20
// {0x09, 0x54, 0x03, 0x4c, 0x09, 0x3c, 0x03, 0x2c, 0x09, 0x3c, 0x03, 0x4c, 0x09, 0x2c, 0x03, 0x04, 0x30, 0x05, 0x00, 0x00}

const unsigned short int pp_P5 = 0xe50f; // P5 size: 26
// {0x09, 0x3d, 0x03, 0x2d, 0x09, 0x25, 0x03, 0x2d, 0x09, 0x15, 0x03, 0x25, 0x09, 0x05, 0x03, 0x15, 0x09, 0x54, 0x03, 0x4c, 0x18, 0x3c, 0x4c, 0x3c, 0x00, 0x00}

const unsigned short int pp_P6 = 0xe530; // P6 size: 20
// {0x09, 0x3d, 0x03, 0x2d, 0x09, 0x1d, 0x03, 0x2d, 0x09, 0x15, 0x03, 0x1d, 0x09, 0x05, 0x03, 0x54, 0x70, 0x05, 0x00, 0x00}

const unsigned short int pp_P1 = 0xe54b; // P1 size: 26
// {0x09, 0x3c, 0x03, 0x2c, 0x09, 0x24, 0x03, 0x2c, 0x09, 0x14, 0x03, 0x24, 0x09, 0x04, 0x03, 0x14, 0x09, 0x53, 0x03, 0x4b, 0x18, 0x3b, 0x0c, 0x3b, 0x00, 0x00}

const unsigned short int pp__0SONG = 0xe580; // 0SONG size: 23
// {0x01, 0x4b, 0x02, 0x01, 0xbe, 0x01, 0x01, 0x4b, 0x02, 0x01, 0xd9, 0x01, 0x01, 0xf4, 0x01, 0x01, 0x0f, 0x02, 0x01, 0x30, 0x02, 0x00, 0x00}

const unsigned short int pp_WE6BC = 0xe6bc; // WE6BC size: 2
// {0xf4, 0x01}

const unsigned short int pp_WE6C0 = 0xe6c0; // WE6C0 size: 2
// {0x3a, 0x20}

const unsigned short int pp_WE6C4 = 0xe6c4; // WE6C4 size: 2
// {0x3a, 0x20}

const unsigned short int pp_WE6C8 = 0xe6c8; // WE6C8 size: 2
// {0x00, 0x02}

const unsigned short int pp_WE6CC = 0xe6cc; // WE6CC size: 2
// {0x3a, 0x20}

const unsigned short int pp_WE6D0 = 0xe6d0; // WE6D0 size: 2
// {0x3a, 0x20}

const unsigned short int pp_WE6D4 = 0xe6d4; // WE6D4 size: 2
// {0x3a, 0x20}

const unsigned short int pp_WE6D8 = 0xe6d8; // WE6D8 size: 2
// {0x3a, 0x20}

const unsigned short int pp_WE6DC = 0xe6dc; // WE6DC size: 2
// {0x3a, 0x20}

const unsigned short int pp_WE6E0 = 0xe6e0; // WE6E0 size: 2
// {0x3a, 0x20}

const unsigned short int pp_XOFFS = 0xe8e5; // XOFFS size: 26
// {0x27, 0x00, 0x27, 0x00, 0x27, 0x00, 0x26, 0x00, 0x26, 0x00, 0x24, 0x00, 0x23, 0x00, 0x22, 0x00, 0x20, 0x00, 0x1e, 0x00, 0x1a, 0x00, 0x12, 0x00, 0x0c, 0x00}

const unsigned short int pp_PAUSEOFF = 0xe90c; // PAUSEOFF size: 26
// {0x58, 0x02, 0xf4, 0x01, 0x90, 0x01, 0x5e, 0x01, 0x2c, 0x01, 0xfa, 0x00, 0xc8, 0x00, 0x96, 0x00, 0x64, 0x00, 0x4b, 0x00, 0x32, 0x00, 0x23, 0x00, 0x19, 0x00}


const unsigned short int cc_OLDINT = 0xe21f; // OLDINT
const unsigned short int cc_IsMUSIC = 0xe22c; // ?MUSIC
const unsigned short int cc_MUSINT = 0xe239; // MUSINT
const unsigned short int cc_PHRASE0 = 0xe247; // PHRASE0
const unsigned short int cc_CURRPHR = 0xe255; // CURRPHR
const unsigned short int cc_CURNOTE = 0xe263; // CURNOTE
const unsigned short int cc_REPEATS = 0xe271; // REPEATS
const unsigned short int cc_COUNTER = 0xe27f; // COUNTER
const unsigned short int cc_DURATION = 0xe28e; // DURATION
const unsigned short int cc_RESTVALUE = 0xe29e; // RESTVALUE
const unsigned short int cc_TONESTATE = 0xe2ae; // TONESTATE
const unsigned short int cc_SONGS = 0xe2ba; // SONGS
const unsigned short int cc_SCALE = 0xe2c6; // SCALE
const unsigned short int cc_WE6B8 = 0xe6b8; // WE6B8


// 0xe212: db 0x7f 0x00 ' '

// ================================================
// 0xe214: WORD 'OLDINT' codep=0x2214 wordp=0xe21f
// ================================================
// 0xe21f: dw 0x0000

// ================================================
// 0xe221: WORD '?MUSIC' codep=0x2214 wordp=0xe22c
// ================================================
// 0xe22c: dw 0x0002

// ================================================
// 0xe22e: WORD 'MUSINT' codep=0x2214 wordp=0xe239
// ================================================
// 0xe239: dw 0x000e

// ================================================
// 0xe23b: WORD 'PHRASE0' codep=0x2214 wordp=0xe247
// ================================================
// 0xe247: dw 0x0003

// ================================================
// 0xe249: WORD 'CURRPHR' codep=0x2214 wordp=0xe255
// ================================================
// 0xe255: dw 0x0005

// ================================================
// 0xe257: WORD 'CURNOTE' codep=0x2214 wordp=0xe263
// ================================================
// 0xe263: dw 0x0007

// ================================================
// 0xe265: WORD 'REPEATS' codep=0x2214 wordp=0xe271
// ================================================
// 0xe271: dw 0x0009

// ================================================
// 0xe273: WORD 'COUNTER' codep=0x2214 wordp=0xe27f
// ================================================
// 0xe27f: dw 0x000a

// ================================================
// 0xe281: WORD 'DURATION' codep=0x2214 wordp=0xe28e
// ================================================
// 0xe28e: dw 0x000b

// ================================================
// 0xe290: WORD 'RESTVALUE' codep=0x2214 wordp=0xe29e
// ================================================
// 0xe29e: dw 0x000c

// ================================================
// 0xe2a0: WORD 'TONESTATE' codep=0x2214 wordp=0xe2ae
// ================================================
// 0xe2ae: dw 0x000d

// ================================================
// 0xe2b0: WORD 'SONGS' codep=0x2214 wordp=0xe2ba
// ================================================
// 0xe2ba: dw 0x0010

// ================================================
// 0xe2bc: WORD 'SCALE' codep=0x2214 wordp=0xe2c6
// ================================================
// 0xe2c6: dw 0x0024

// ================================================
// 0xe2c8: WORD 'WE2CA' codep=0x1d29 wordp=0xe2ca
// ================================================
// 0xe2ca: db 0x00 0xe3 '  '

// ================================================
// 0xe2cc: WORD 'WE2CE' codep=0x224c wordp=0xe2ce params=1 returns=2
// ================================================

void WE2CE() // WE2CE
{
  Push(Read16(cc_MUSSEG)); // MUSSEG
  SWAP(); // SWAP
}


// ================================================
// 0xe2d4: WORD 'WE2D6' codep=0x224c wordp=0xe2d6 params=2 returns=0
// ================================================

void WE2D6() // WE2D6
{
  WE2CE(); // WE2CE
  L_ex_(); // L!
}


// ================================================
// 0xe2dc: WORD 'WE2DE' codep=0x224c wordp=0xe2de params=1 returns=1
// ================================================

void WE2DE() // WE2DE
{
  WE2CE(); // WE2CE
  L_at_(); // L@
}


// ================================================
// 0xe2e4: WORD 'WE2E6' codep=0x224c wordp=0xe2e6 params=1 returns=1
// ================================================
// orphan

void WE2E6() // WE2E6
{
  WE2CE(); // WE2CE
  LC_at_(); // LC@
}


// ================================================
// 0xe2ec: WORD 'WE2EE' codep=0x224c wordp=0xe2ee params=2 returns=0
// ================================================

void WE2EE() // WE2EE
{
  WE2CE(); // WE2CE
  LC_ex_(); // LC!
}

// 0xe2f4: db 0x01 0x21 0x20 0x20 0x20 0x41 0x44 0x44 0x52 0x20 0x20 0x20 0xb3 0x01 0x4c 0x4c 0x4f 0x54 0x20 0x52 0x20 0x20 0x20 0x20 0x20 0x33 0xff 0x00 0x80 0x02 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0xf0 0xfd 0xf8 0x7e 0x7c 0x3f 0xbe 0x1f 0xfd 0x0f 0xef 0x07 0xf7 0x03 0xfb 0x01 0xb1 0xef 0xd8 0x77 0xec 0x3b 0xf6 0x1d 0xfb 0x0e 0x7d 0x07 0xbe 0x03 0xdf 0x01 0x3d 0xe2 0x1e 0x71 0x8f 0x38 0x47 0x1c 0x23 0x0e 0x11 0x07 0x88 0x03 0xc4 0x01 0x89 0xd5 0xc4 0x6a 0x62 0x35 0xb1 0x1a 0x58 0x0d 0xac 0x06 0x56 0x03 0xab 0x01 0x8e 0xc9 0xc7 0x64 0x63 0x32 0x31 0x19 0x98 0x0c 0x4c 0x06 0x26 0x03 0x93 0x01 0x3d 0xbe 0x1e 0x5f 0x8f 0x2f 0xc7 0x17 0xe3 0x0b 0xf1 0x05 0xf8 0x02 0x7c 0x01 0x90 0xb3 0xc8 0x59 0xe4 0x2c 0x72 0x16 0x39 0x0b 0x9c 0x05 0xce 0x02 0x67 0x01 0x7c 0xa9 0xbe 0x54 0x5f 0x2a 0x2f 0x15 0x97 0x0a 0x4b 0x05 0xa5 0x02 0x52 0x01 0xf8 0x9f 0xfc 0x4f 0xfe 0x27 0xff 0x13 0xff 0x09 0xff 0x04 0x7f 0x02 0x3f 0x01 0xff 0x96 0x7f 0x4b 0xbf 0x25 0xdf 0x12 0x6f 0x09 0xb7 0x04 0x5b 0x02 0x2d 0x01 0x84 0x8e 0x42 0x47 0xa1 0x23 0xd0 0x11 0xe8 0x08 0x74 0x04 0x3a 0x02 0x1d 0x01 0x85 0x86 0x42 0x43 0xa1 0x21 0xd0 0x10 0x68 0x08 0x34 0x04 0x1a 0x02 0x0d 0x01 0xb0 0xb6 0xe6 0x43 0x8a 0xc2 0xe6 0x42 0x8a 0xc6 0xe6 0x42 0xe4 0x61 0x0c 0x03 0xe6 0x61 0xc3 0xba 0x61 0x00 0xec 0x24 0xfc 0xee 0xc3 0x56 0x57 0x1e 0x52 0x51 0x53 0x50 0x0e 0x1f 0x8a 0x06 0x02 0x00 0x84 0xc0 0x75 0x03 0xe9 0x98 0x00 0x33 0xdb 0xfe 0x4f 0x0a 0x74 0x03 0xe9 0x8e 0x00 0x8a 0x47 0x0d 0x84 0xc0 0x75 0x13 0x8a 0x47 0x0c 0x84 0xc0 0x74 0x0c 0x88 0x47 0x0a 0xe8 0xc6 0xff 0xc6 0x47 0x0d 0x01 0xeb 0xe3 0x8b 0x77 0x07 0xfc 0xac 0x24 0x7f 0x74 0x3b 0x32 0xe4 0xa8 0x40 0x74 0x04 0x24 0x3f 0xfe 0xc4 0x88 0x47 0x0b 0x88 0x67 0x0c 0xac 0x89 0x77 0x07 0x3c 0xff 0x75 0x05 0x8a 0x47 0x0b 0xeb 0xce 0x8a 0x67 0x0b 0x2a 0x67 0x0c 0x88 0x67 0x0a 0x32 0xf6 0x8a 0xd0 0xd1 0xe2 0x8b 0xfa 0x8b 0x55 0x24 0xe8 0x70 0xff 0xc6 0x47 0x0d 0x00 0xe9 0x30 0x00 0x8b 0x77 0x05 0xfe 0x4f 0x09 0x75 0x18 0x83 0xc6 0x03 0x8a 0x04 0x84 0xc0 0x75 0x09 0x33 0xc0 0x89 0x06 0x02 0x00 0xe9 0x16 0x00 0x89 0x77 0x05 0x88 0x47 0x09 0x8b 0x44 0x01 0x89 0x47 0x07 0xc6 0x47 0x0a 0x01 0xc6 0x47 0x0d 0x01 0xeb 0x8c 0x58 0x5b 0x59 0x5a 0x1f 0x5f 0x5e 0xea 0x00 0x00 0x00 0x00 ' !   ADDR     LLOT R     3                         ~|?             w ;    }     =  q 8G #          jb5  X   V      dc21   L &   =  _ /        |    Y ,r 9     g |  T_*/   K   R    O '       ?   K %  o   [ -   BG #    t :     BC !  h 4        C   B   B a   a  a  $   VW RQSP        u    3  O t     G   u  G   t  G     G     w   $t;2  @t $?   G  g   w < u  G    g *g  g 2        U$ p  G   0  w  O u        u 3         w  G  D  G  G   G    X[YZ _^     '

// ================================================
// 0xe4b7: WORD 'P2' codep=0x1d29 wordp=0xe4be
// ================================================
// 0xe4be: db 0x09 0x3c 0x03 0x2c 0x09 0x1c 0x03 0x2c 0x09 0x14 0x03 0x1c 0x09 0x04 0x03 0x14 0x30 0x24 0x00 0x00 ' < ,   ,        0$  '

// ================================================
// 0xe4d2: WORD 'P3' codep=0x1d29 wordp=0xe4d9
// ================================================
// 0xe4d9: db 0x09 0x3c 0x03 0x2c 0x09 0x1c 0x03 0x2c 0x09 0x14 0x03 0x1c 0x09 0x04 0x03 0x53 0x30 0x04 0x00 0x00 ' < ,   ,       S0   '

// ================================================
// 0xe4ed: WORD 'P4' codep=0x1d29 wordp=0xe4f4
// ================================================
// 0xe4f4: db 0x09 0x54 0x03 0x4c 0x09 0x3c 0x03 0x2c 0x09 0x3c 0x03 0x4c 0x09 0x2c 0x03 0x04 0x30 0x05 0x00 0x00 ' T L < , < L ,  0   '

// ================================================
// 0xe508: WORD 'P5' codep=0x1d29 wordp=0xe50f
// ================================================
// 0xe50f: db 0x09 0x3d 0x03 0x2d 0x09 0x25 0x03 0x2d 0x09 0x15 0x03 0x25 0x09 0x05 0x03 0x15 0x09 0x54 0x03 0x4c 0x18 0x3c 0x4c 0x3c 0x00 0x00 ' = - % -   %     T L <L<  '

// ================================================
// 0xe529: WORD 'P6' codep=0x1d29 wordp=0xe530
// ================================================
// 0xe530: db 0x09 0x3d 0x03 0x2d 0x09 0x1d 0x03 0x2d 0x09 0x15 0x03 0x1d 0x09 0x05 0x03 0x54 0x70 0x05 0x00 0x00 ' = -   -       Tp   '

// ================================================
// 0xe544: WORD 'P1' codep=0x1d29 wordp=0xe54b
// ================================================
// 0xe54b: db 0x09 0x3c 0x03 0x2c 0x09 0x24 0x03 0x2c 0x09 0x14 0x03 0x24 0x09 0x04 0x03 0x14 0x09 0x53 0x03 0x4b 0x18 0x3b 0x0c 0x3b 0x00 0x00 ' < , $ ,   $     S K ; ;  '

// ================================================
// 0xe565: WORD 'R,' codep=0x224c wordp=0xe56c
// ================================================

void R_co_() // R,
{
  Push(Read16(cc_MUSSEG)); // MUSSEG
  SEG_gt_ADDR(); // SEG>ADDR
  _dash_(); // -
  _co_(); // ,
}


// ================================================
// 0xe576: WORD '0SONG' codep=0x1d29 wordp=0xe580
// ================================================
// 0xe580: db 0x01 0x4b 0x02 0x01 0xbe 0x01 0x01 0x4b 0x02 0x01 0xd9 0x01 0x01 0xf4 0x01 0x01 0x0f 0x02 0x01 0x30 0x02 0x00 0x00 ' K     K           0   '

// ================================================
// 0xe597: WORD 'INITMUS' codep=0x224c wordp=0xe5a3 params=0 returns=0
// ================================================

void INITMUS() // INITMUS
{
  unsigned short int a;
  Push(0x001c);
  _ro__ex_OLD_rc_(); // (!OLD)
  Push(Read16(regsp)); // DUP
  Push(Read16(cc_MUSINT)); // MUSINT
  WE2DE(); // WE2DE
  Push((Pop()==Pop())?1:0); // =
  Push(!Pop()); //  NOT
  if (Pop() != 0)
  {
    Push(0);
    Push(Read16(cc_IsMUSIC)); // ?MUSIC
    WE2EE(); // WE2EE
    Push(Read16(cc_OLDINT)); // OLDINT
    WE2DE(); // WE2DE
    a = Pop(); // >R
    Push(a); // I
    WE2D6(); // WE2D6
    Push(a + 2); // R> 2+
    WE2D6(); // WE2D6
    Push(Read16(cc_MUSSEG)); // MUSSEG
    Push(Read16(cc_MUSINT)); // MUSINT
    WE2DE(); // WE2DE
    Push(0x001c);
    _ro__ex_SET_rc_(); // (!SET)
    return;
  }
  Pop(); Pop(); // 2DROP
}


// ================================================
// 0xe5e1: WORD 'HIMUS' codep=0x224c wordp=0xe5eb params=0 returns=0
// ================================================

void HIMUS() // HIMUS
{
  GetDS(); // @DS
  Push(Read16(pp_WE2CA)); // WE2CA @
  Push(Read16(cc_MUSSEG)); // MUSSEG
  Push(0);
  Push(0x0320);
  LCMOVE(); // LCMOVE
  INITMUS(); // INITMUS
}


// ================================================
// 0xe5ff: WORD 'CSCR>EGA' codep=0x224c wordp=0xe60c
// ================================================

void CSCR_gt_EGA() // CSCR>EGA
{
  unsigned short int i, imax, j, jmax;
  Push(Read16(pp_XBUF_dash_SE)); // XBUF-SE @
  SWAP(); // SWAP
  FILE_st_(); // FILE<
  _gt_HIDDEN(); // >HIDDEN
  DARK(); // DARK
  Push(-1);

  i = 0;
  imax = 0x00c8;
  do // (DO)
  {

    j = 0;
    jmax = 0x0050;
    do // (DO)
    {
      Push(Pop() + 1); //  1+
      Push(Read16(pp_XBUF_dash_SE)); // XBUF-SE @
      OVER(); // OVER
      LC_at_(); // LC@
      Push(Read16(regsp)); // DUP
      Push(Pop() >> 4 & 0x000f); //  16/ 0x000f AND
      C_gt_EGA(); // C>EGA
      if (Read16(regsp) != 0) Push(Read16(regsp)); // ?DUP
      if (Pop() != 0)
      {
        Push(pp_COLOR); // COLOR
        _st__ex__gt_(); // <!>
        Push(j * 2); // I 2*
        Push(i); // J
        PLOT(); // PLOT
      }
      Push(Pop() & 0x000f); //  0x000f AND
      C_gt_EGA(); // C>EGA
      if (Read16(regsp) != 0) Push(Read16(regsp)); // ?DUP
      if (Pop() != 0)
      {
        Push(pp_COLOR); // COLOR
        _st__ex__gt_(); // <!>
        Push(j * 2 + 1); // I 2* 1+
        Push(i); // J
        PLOT(); // PLOT
      }
      j++;
    } while(j<jmax); // (LOOP)

    i++;
  } while(i<imax); // (LOOP)

  Pop(); // DROP
  SCR_dash_RES(); // SCR-RES
  _gt_DISPLAY(); // >DISPLAY
}


// ================================================
// 0xe67e: WORD 'WE680' codep=0x224c wordp=0xe680
// ================================================

void WE680() // WE680
{
  TIME(); // TIME
  _2_at_(); // 2@
  D_plus_(); // D+
  do
  {
    TIME(); // TIME
    _2_at_(); // 2@
    _2OVER(); // 2OVER
    D_gt_(); // D>
    _i_KEY(); // 'KEY
    Push(Pop() | Pop()); // OR
  } while(Pop() == 0);
  Pop(); Pop(); // 2DROP
}


// ================================================
// 0xe69a: WORD 'WE69C' codep=0x224c wordp=0xe69c
// ================================================

void WE69C() // WE69C
{
  _gt_HIDDEN(); // >HIDDEN
  DARK(); // DARK
  Push(Read16(pp_HBUF_dash_SEG)); // HBUF-SEG @
  Push(0x008d);
  FILE_st_(); // FILE<
  _gt_DISPLAY(); // >DISPLAY
  SCR_dash_RES(); // SCR-RES
  Push(0x02bc);
  MS(); // MS
}


// ================================================
// 0xe6b6: WORD 'WE6B8' codep=0x2214 wordp=0xe6b8
// ================================================
// orphan
// 0xe6b8: dw 0x0000

// ================================================
// 0xe6ba: WORD 'WE6BC' codep=0x1d29 wordp=0xe6bc
// ================================================
// 0xe6bc: db 0xf4 0x01 '  '

// ================================================
// 0xe6be: WORD 'WE6C0' codep=0x1d29 wordp=0xe6c0
// ================================================
// 0xe6c0: db 0x3a 0x20 ': '

// ================================================
// 0xe6c2: WORD 'WE6C4' codep=0x1d29 wordp=0xe6c4
// ================================================
// 0xe6c4: db 0x3a 0x20 ': '

// ================================================
// 0xe6c6: WORD 'WE6C8' codep=0x1d29 wordp=0xe6c8
// ================================================
// 0xe6c8: db 0x00 0x02 '  '

// ================================================
// 0xe6ca: WORD 'WE6CC' codep=0x1d29 wordp=0xe6cc
// ================================================
// 0xe6cc: db 0x3a 0x20 ': '

// ================================================
// 0xe6ce: WORD 'WE6D0' codep=0x1d29 wordp=0xe6d0
// ================================================
// 0xe6d0: db 0x3a 0x20 ': '

// ================================================
// 0xe6d2: WORD 'WE6D4' codep=0x1d29 wordp=0xe6d4
// ================================================
// 0xe6d4: db 0x3a 0x20 ': '

// ================================================
// 0xe6d6: WORD 'WE6D8' codep=0x1d29 wordp=0xe6d8
// ================================================
// 0xe6d8: db 0x3a 0x20 ': '

// ================================================
// 0xe6da: WORD 'WE6DC' codep=0x1d29 wordp=0xe6dc
// ================================================
// 0xe6dc: db 0x3a 0x20 ': '

// ================================================
// 0xe6de: WORD 'WE6E0' codep=0x1d29 wordp=0xe6e0
// ================================================
// 0xe6e0: db 0x3a 0x20 ': '

// ================================================
// 0xe6e2: WORD 'WE6E4' codep=0x224c wordp=0xe6e4 params=0 returns=1
// ================================================

void WE6E4() // WE6E4
{
  Push(Read16(pp_WE6DC)); // WE6DC @
}


// ================================================
// 0xe6ea: WORD 'WE6EC' codep=0x224c wordp=0xe6ec
// ================================================

void WE6EC() // WE6EC
{
  _gt_HIDDEN(); // >HIDDEN
  DARK(); // DARK
  Push(Read16(pp_HBUF_dash_SEG)); // HBUF-SEG @
  Push(0x0036);
  FILE_st_(); // FILE<
  _gt_DISPLAY(); // >DISPLAY
}


// ================================================
// 0xe6fe: WORD 'WE700' codep=0x224c wordp=0xe700 params=1 returns=2
// ================================================

void WE700() // WE700
{
  Push(Pop() * Read16(pp_WE6C8)); //  WE6C8 @ *
  Push(0x0400);
  _slash_MOD(); // /MOD
  Push(Pop() + Read16(pp_WE6CC)); //  WE6CC @ +
}


// ================================================
// 0xe714: WORD 'WE716' codep=0x224c wordp=0xe716
// ================================================

void WE716() // WE716
{
  Push(pp_WE6D8); // WE6D8
  _i_KEY(); // 'KEY
  if (Pop() != 0)
  {
    ON_3(); // ON_3
    return;
  }
  OFF(); // OFF
}


// ================================================
// 0xe728: WORD 'BRMOVE' codep=0x224c wordp=0xe733 params=1 returns=2
// ================================================

void BRMOVE() // BRMOVE
{
  unsigned short int i, imax;
  Push(Read16(regsp)); // DUP
  Push(Read16(regsp)); // DUP
  Push(Pop() + 6); //  6 +
  WE6E4(); // WE6E4
  SWAP(); // SWAP
  LC_at_(); // LC@
  Push(pp_WE6C4); // WE6C4
  Store_3(); // !_3
  Push(Pop() + 0x000a); //  0x000a +
  WE6E4(); // WE6E4
  SWAP(); // SWAP
  LC_at_(); // LC@
  Push(pp_WE6C0); // WE6C0
  Store_3(); // !_3
  Push(Pop() + 0x0010); //  0x0010 +
  WE6E4(); // WE6E4
  SWAP(); // SWAP
  Push(Read16(pp_HBUF_dash_SEG)); // HBUF-SEG @
  Push(0);

  i = 0;
  imax = Read16(pp_WE6C0); // WE6C0 @
  do // (DO)
  {
    _2OVER(); // 2OVER
    _2OVER(); // 2OVER
    ROT(); // ROT
    Push(Pop() + i * Read16(pp_WE6C4)); //  I WE6C4 @ * +
    ROT(); // ROT
    ROT(); // ROT
    Push((Pop() + ((Read16(pp_WE6C0) + Read16(pp_WE6D0)) - i) * 0x0050) + Read16(pp_WE6D4)); //  WE6C0 @ WE6D0 @ + I - 0x0050 * + WE6D4 @ +
    Push(Read16(pp_WE6C4)); // WE6C4 @
    LCMOVE(); // LCMOVE
    i++;
  } while(i<imax); // (LOOP)

  DISPLAY_dash_WAIT(); // DISPLAY-WAIT
  SCR_dash_RES(); // SCR-RES
  Pop(); Pop(); // 2DROP
  Pop(); Pop(); // 2DROP
  Push(Read16(pp_WE6C4) * Read16(pp_WE6C0) + 0x0010); // WE6C4 @ WE6C0 @ * 0x0010 +
  Push(pp_WE6E0); // WE6E0
  _plus__ex__2(); // +!_2
  Push(Read16(pp_WE6BC)); // WE6BC @
  MS(); // MS
}


// ================================================
// 0xe7cb: WORD 'WE7CD' codep=0x224c wordp=0xe7cd
// ================================================

void WE7CD() // WE7CD
{
  unsigned short int i, imax;
  TIME(); // TIME
  _2_at_(); // 2@
  Push(0xafc8); Push(0x0000);
  D_plus_(); // D+
  do
  {

    i = 0;
    imax = 0x000b;
    do // (DO)
    {
      Push(i); // I
      WE700(); // WE700
      BLOCK_2(); // BLOCK_2
      Push(Pop() + Pop()); // +
      BRMOVE(); // BRMOVE
      WE716(); // WE716
      Push(Read16(pp_WE6D8)); // WE6D8 @
      if (Pop() != 0)
      {
        imax = i; // LEAVE
      }
      i++;
    } while(i<imax); // (LOOP)

    _2DUP(); // 2DUP
    TIME(); // TIME
    _2_at_(); // 2@
    D_st_(); // D<
    Push(Pop() | Read16(pp_WE6D8)); //  WE6D8 @ OR
  } while(Pop() == 0);
  Pop(); Pop(); // 2DROP
}


// ================================================
// 0xe811: WORD 'WE813' codep=0x224c wordp=0xe813 params=0 returns=1
// ================================================

void WE813() // WE813
{
  unsigned short int i, imax;

  i = 0;
  imax = 0x000b;
  do // (DO)
  {
    Push(i); // I
    WE700(); // WE700
    BLOCK_2(); // BLOCK_2
    Pop(); Pop(); // 2DROP
    i++;
  } while(i<imax); // (LOOP)

}


// ================================================
// 0xe829: WORD 'WE82B' codep=0x224c wordp=0xe82b
// ================================================

void WE82B() // WE82B
{
  WE6EC(); // WE6EC
  Push(0x0067);
  Push(pp_WE6D0); // WE6D0
  Store_3(); // !_3
  Push(0x000b);
  Push(pp_WE6D4); // WE6D4
  Store_3(); // !_3
  Push(0x01f4);
  Push(pp_WE6BC); // WE6BC
  Store_3(); // !_3
  Push(0x0045);
  Func6("FILE-START");
  Push(Read16(Pop())); //  @
  Push(0x0040);
  _slash_(); // /
  Push(pp_WE6CC); // WE6CC
  Store_3(); // !_3
  WE813(); // WE813
  Push(0);
  SONG(); // SONG
  GetDS(); // @DS
  Push(pp_WE6DC); // WE6DC
  Store_3(); // !_3
  _gt_LORES_2(); // >LORES_2
  DARK(); // DARK
  Push(0x000a);
  WE700(); // WE700
  BLOCK_2(); // BLOCK_2
  Push(Pop() + Pop()); // +
  BRMOVE(); // BRMOVE
  WE7CD(); // WE7CD
  CFIGARRAYS(); // CFIGARRAYS
  Push(0);
  Push(Read16(cc_MUSSEG)); // MUSSEG
  Push(2);
  LC_ex_(); // LC!
  BEEPOFF(); // BEEPOFF
  _gt_DISPLAY(); // >DISPLAY
}


// ================================================
// 0xe885: WORD 'REDUCE' codep=0x224c wordp=0xe890 params=1 returns=0
// ================================================

void REDUCE() // REDUCE
{
  unsigned short int a;
  a = Pop(); // >R
  FLUSH_2(); // FLUSH_2
  Push(Read16(a)); // R@
  Push(-Pop()); //  NEGATE
  Push(pp__n_CACHE); // #CACHE
  _plus__ex__2(); // +!_2
  AUTO_dash_CACHE(); // AUTO-CACHE
  Push(-(a * 0x0040)); // R> 0x0040 * NEGATE
  Push(pp_LFSEG); // LFSEG
  _plus__ex__2(); // +!_2
  Push(Read16(pp_LFSEG)); // LFSEG @
  Push(pp_WE6DC); // WE6DC
  Store_3(); // !_3
}


// ================================================
// 0xe8b6: WORD 'INCREASE' codep=0x224c wordp=0xe8c3 params=1 returns=0
// ================================================

void INCREASE() // INCREASE
{
  FLUSH_2(); // FLUSH_2
  Push(Read16(pp__bo__n_CACHE_bc_)); // [#CACHE] @
  Push(pp__n_CACHE); // #CACHE
  Store_3(); // !_3
  AUTO_dash_CACHE(); // AUTO-CACHE
  Push(Pop() * 0x0040); //  0x0040 *
  Push(pp_LFSEG); // LFSEG
  _plus__ex__2(); // +!_2
}


// ================================================
// 0xe8db: WORD 'XOFFS' codep=0x1d29 wordp=0xe8e5
// ================================================
// 0xe8e5: db 0x27 0x00 0x27 0x00 0x27 0x00 0x26 0x00 0x26 0x00 0x24 0x00 0x23 0x00 0x22 0x00 0x20 0x00 0x1e 0x00 0x1a 0x00 0x12 0x00 0x0c 0x00 '' ' ' & & $ # "           '

// ================================================
// 0xe8ff: WORD 'PAUSEOFF' codep=0x1d29 wordp=0xe90c
// ================================================
// 0xe90c: db 0x58 0x02 0xf4 0x01 0x90 0x01 0x5e 0x01 0x2c 0x01 0xfa 0x00 0xc8 0x00 0x96 0x00 0x64 0x00 0x4b 0x00 0x32 0x00 0x23 0x00 0x19 0x00 'X     ^ ,       d K 2 #   '

// ================================================
// 0xe926: WORD 'WE928' codep=0x224c wordp=0xe928
// ================================================

void WE928() // WE928
{
  unsigned short int i, imax;
  Push(7);
  REDUCE(); // REDUCE
  Push(Read16(pp_LFSEG)); // LFSEG @
  Push(0x008c);
  FILE_st_(); // FILE<
  Push(0x0046);
  Push(pp_WE6D0); // WE6D0
  Store_3(); // !_3
  _gt_DISPLAY(); // >DISPLAY
  Push(pp_WE6E0); // WE6E0
  OFF(); // OFF

  i = 0;
  imax = 0x000d;
  do // (DO)
  {
    Push(Read16(i + (pp_XOFFS + i))); // I XOFFS I + + @
    Push(pp_WE6D4); // WE6D4
    Store_3(); // !_3
    Push(Read16(i + (pp_PAUSEOFF + i))); // I PAUSEOFF I + + @
    Push(pp_WE6BC); // WE6BC
    Store_3(); // !_3
    Push(Read16(pp_WE6E0)); // WE6E0 @
    BRMOVE(); // BRMOVE
    i++;
  } while(i<imax); // (LOOP)

  Push(7);
  INCREASE(); // INCREASE
}


// ================================================
// 0xe97c: WORD 'CREDIT.SCREEN' codep=0x224c wordp=0xe98e
// ================================================

void CREDIT_dot_SCREEN() // CREDIT.SCREEN
{
  WE69C(); // WE69C
  WE928(); // WE928
  Push(0x3a98); Push(0x0000);
  WE680(); // WE680
}


// ================================================
// 0xe99c: WORD 'INTROS' codep=0x224c wordp=0xe9a7
// ================================================
// entry

void INTROS() // INTROS
{
  HIMUS(); // HIMUS
  Push(Read16(pp_IsEGA)); // ?EGA @
  if (Pop() != 0)
  {
    Push(0x008d);
    CSCR_gt_EGA(); // CSCR>EGA
    Push(0);
    SONG(); // SONG
    Push(0x2ee0); Push(0x0000);
    WE680(); // WE680
    Push(0x0036);
    CSCR_gt_EGA(); // CSCR>EGA
    Push(0x4e20); Push(0x0000);
    WE680(); // WE680
    CFIGARRAYS(); // CFIGARRAYS
    Push(0);
    Push(Read16(cc_MUSSEG)); // MUSSEG
    Push(2);
    LC_ex_(); // LC!
    BEEPOFF(); // BEEPOFF
    _gt_DISPLAY(); // >DISPLAY
    return;
  }
  CREDIT_dot_SCREEN(); // CREDIT.SCREEN
  WE82B(); // WE82B
  DARK(); // DARK
}

// 0xe9eb: db 0x4d 0x55 0x53 0x49 0x43 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x39 0x2d 0x31 0x32 0x2d 0x31 0x32 0x37 0x20 0x5c 0x20 0x45 0x4d 0x50 0x54 0x59 0x20 0x43 0x52 0x20 0x2e 0x22 0x20 0x4e 0x4f 0x54 0x49 0x43 0x45 0x21 0x20 0x45 0x4d 0x50 0x54 0x59 0x20 0x45 0x58 0x45 0x43 0x55 0x54 0x45 0x44 0x20 0x49 0x4e 0x20 0x43 0x4f 0x4d 0x42 0x4c 0x54 0x2e 0x43 0x4d 0x50 0x20 0x22 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x56 0x3d 0x20 0x23 0x46 0x52 0x41 0x4d 0x45 0x53 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x56 0x3d 0x20 0x46 0x52 0x41 0x4d 0x45 0x4f 0x46 0x46 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x28 0x20 0x66 0x72 0x61 0x6d 0x65 0x20 0x6f 0x66 0x66 0x73 0x65 0x74 0x20 0x70 0x6f 0x69 0x6e 0x74 0x65 0x72 0x29 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x28 0x20 0x56 0x3d 0x20 0x4c 0x46 0x52 0x41 0x4d 0x45 0x20 0x29 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x56 0x3d 0x20 0x42 0x49 0x54 0x2d 0x43 0x4f 0x55 0x4e 0x54 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x43 0x52 0x45 0x41 0x54 0x45 0x20 0x46 0x49 0x4c 0x45 0x4e 0x41 0x4d 0x45 0x20 0x31 0x35 0x20 0x41 0x4c 0x4c 0x4f 0x54 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x32 0x56 0x3d 0x20 0x44 0x50 0x56 0x41 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x28 0x20 0x61 0x6c 0x6c 0x6f 0x63 0x61 0x74 0x69 0x6f 0x6e 0x20 0x70 0x6f 0x69 0x6e 0x74 0x65 0x72 0x20 0x77 0x69 0x74 0x68 0x69 0x6e 0x20 0x56 0x45 0x53 0x42 0x4c 0x54 0x29 0x20 0x20 0x20 0x43 0x52 0x45 0x41 0x54 0x45 0x20 0x42 0x4c 0x54 0x43 0x4f 0x4c 0x4f 0x52 0x53 0x20 0x31 0x36 0x20 0x41 0x4c 0x4c 0x4f 0x54 0x20 0x28 0x20 0x66 0x6c 0x61 0x67 0x73 0x20 0x73 0x68 0x6f 0x77 0x69 0x6e 0x67 0x20 0x63 0x6f 0x6c 0x6f 0x72 0x20 0x65 0x78 0x69 0x73 0x74 0x73 0x20 0x69 0x6e 0x20 0x62 0x6c 0x74 0x29 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x28 0x20 0x43 0x4f 0x4d 0x42 0x4c 0x54 0x20 0x2d 0x20 0x3f 0x43 0x4f 0x4c 0x4f 0x52 0x53 0x20 0x48 0x46 0x52 0x41 0x4d 0x45 0x4c 0x45 0x4e 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x39 0x2d 0x31 0x32 0x2d 0x38 0x35 0x29 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x3a 0x20 0x3f 0x43 0x4f 0x4c 0x4f 0x52 0x53 0x20 0x28 0x20 0x2d 0x2d 0x20 0x5c 0x20 0x73 0x65 0x74 0x20 0x62 0x6c 0x74 0x20 0x63 0x6f 0x6c 0x6f 0x72 0x20 0x66 0x6c 0x61 0x67 0x73 0x20 0x62 0x61 0x73 0x65 0x64 0x20 0x6f 0x6e 0x20 0x63 0x6f 0x6e 0x74 0x65 0x6e 0x74 0x73 0x20 0x6f 0x66 0x20 0x62 0x6c 0x74 0x29 0x20 0x20 0x20 0x20 0x42 0x4c 0x54 0x43 0x4f 0x4c 0x4f 0x52 0x53 0x20 0x31 0x36 0x20 0x30 0x20 0x46 0x49 0x4c 0x4c 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x4c 0x42 0x4c 0x54 0x20 0x40 0x20 0x30 0x20 0x44 0x4f 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x57 0x42 0x4c 0x54 0x20 0x40 0x20 0x30 0x20 0x44 0x4f 0x20 0x59 0x42 0x4c 0x54 0x20 0x40 0x20 0x4a 0x20 0x2d 0x20 0x58 0x42 0x4c 0x54 0x20 0x40 0x20 0x49 0x20 0x2b 0x20 0x4c 0x40 0x50 0x49 0x58 0x45 0x4c 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x42 0x4c 0x54 0x43 0x4f 0x4c 0x4f 0x52 0x53 0x20 0x2b 0x20 0x31 0x20 0x53 0x57 0x41 0x50 0x20 0x43 0x21 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x4c 0x4f 0x4f 0x50 0x20 0x4c 0x4f 0x4f 0x50 0x20 0x3b 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x3a 0x20 0x48 0x46 0x52 0x41 0x4d 0x45 0x4c 0x45 0x4e 0x20 0x28 0x20 0x2d 0x2d 0x20 0x5c 0x20 0x63 0x6f 0x6d 0x70 0x75 0x74 0x65 0x20 0x74 0x68 0x65 0x20 0x6c 0x65 0x6e 0x67 0x74 0x68 0x20 0x6f 0x66 0x20 0x61 0x20 0x68 0x79 0x62 0x72 0x69 0x64 0x20 0x62 0x6c 0x74 0x20 0x66 0x72 0x61 0x6d 0x65 0x29 0x20 0x20 0x20 0x20 0x20 0x20 0x28 0x20 0x5b 0x66 0x72 0x61 0x6d 0x65 0x6c 0x65 0x6e 0x5d 0x5b 0x63 0x6f 0x6c 0x6f 0x72 0x5d 0x5b 0x69 0x6d 0x61 0x67 0x65 0x2f 0x72 0x75 0x6e 0x5d 0x5b 0x69 0x6d 0x61 0x67 0x65 0x5d 0x20 0x29 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x4c 0x42 0x4c 0x54 0x20 0x40 0x20 0x57 0x42 0x4c 0x54 0x20 0x40 0x20 0x2a 0x20 0x31 0x35 0x20 0x2b 0x20 0x31 0x36 0x2f 0x20 0x32 0x2a 0x20 0x34 0x20 0x2b 0x20 0x4c 0x46 0x52 0x41 0x4d 0x45 0x20 0x21 0x20 0x3b 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x28 0x20 0x43 0x4f 0x4d 0x42 0x4c 0x54 0x20 0x2d 0x20 0x42 0x4c 0x54 0x46 0x52 0x41 0x4d 0x45 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x39 0x2d 0x31 0x32 0x2d 0x38 0x35 0x29 0x20 0x3a 0x20 0x42 0x4c 0x54 0x46 0x52 0x41 0x4d 0x45 0x20 0x28 0x20 0x2d 0x2d 0x20 0x5c 0x20 0x62 0x75 0x69 0x6c 0x64 0x20 0x61 0x20 0x62 0x6c 0x74 0x20 0x69 0x6d 0x61 0x67 0x65 0x20 0x66 0x6f 0x72 0x20 0x74 0x68 0x65 0x20 0x63 0x75 0x72 0x72 0x65 0x6e 0x74 0x20 0x63 0x6f 0x6c 0x6f 0x72 0x29 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x28 0x20 0x72 0x65 0x6c 0x61 0x74 0x69 0x76 0x65 0x20 0x74 0x6f 0x20 0x62 0x6c 0x74 0x73 0x65 0x67 0x20 0x26 0x20 0x66 0x72 0x61 0x6d 0x65 0x6f 0x66 0x66 0x29 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x42 0x49 0x54 0x2d 0x43 0x4f 0x55 0x4e 0x54 0x20 0x4f 0x46 0x46 0x20 0x20 0x46 0x52 0x41 0x4d 0x45 0x4f 0x46 0x46 0x20 0x40 0x20 0x44 0x55 0x50 0x20 0x3e 0x52 0x20 0x34 0x20 0x2b 0x20 0x41 0x42 0x4c 0x54 0x20 0x21 0x20 0x20 0x42 0x4c 0x54 0x53 0x45 0x47 0x20 0x40 0x20 0x3e 0x52 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x4c 0x46 0x52 0x41 0x4d 0x45 0x20 0x40 0x20 0x49 0x20 0x49 0x27 0x20 0x4c 0x21 0x20 0x20 0x43 0x4f 0x4c 0x4f 0x52 0x20 0x40 0x20 0x49 0x20 0x49 0x27 0x20 0x32 0x2b 0x20 0x4c 0x43 0x21 0x20 0x20 0x30 0x20 0x52 0x3e 0x20 0x52 0x3e 0x20 0x33 0x2b 0x20 0x4c 0x43 0x21 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x30 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x4c 0x42 0x4c 0x54 0x20 0x40 0x20 0x30 0x20 0x44 0x4f 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x57 0x42 0x4c 0x54 0x20 0x40 0x20 0x30 0x20 0x44 0x4f 0x20 0x59 0x42 0x4c 0x54 0x20 0x40 0x20 0x4a 0x20 0x2d 0x20 0x58 0x42 0x4c 0x54 0x20 0x40 0x20 0x49 0x20 0x2b 0x20 0x4c 0x40 0x50 0x49 0x58 0x45 0x4c 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x43 0x4f 0x4c 0x4f 0x52 0x20 0x40 0x20 0x31 0x35 0x20 0x41 0x4e 0x44 0x20 0x3d 0x20 0x20 0x53 0x48 0x4c 0x2d 0x42 0x49 0x54 0x20 0x20 0x31 0x20 0x42 0x49 0x54 0x2d 0x43 0x4f 0x55 0x4e 0x54 0x20 0x2b 0x21 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x42 0x49 0x54 0x2d 0x43 0x4f 0x55 0x4e 0x54 0x20 0x40 0x20 0x31 0x36 0x20 0x3d 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x49 0x46 0x20 0x42 0x4c 0x54 0x53 0x45 0x47 0x20 0x40 0x20 0x41 0x42 0x4c 0x54 0x20 0x40 0x20 0x4c 0x21 0x20 0x20 0x32 0x20 0x41 0x42 0x4c 0x54 0x20 0x2b 0x21 0x20 0x30 0x2e 0x20 0x42 0x49 0x54 0x2d 0x43 0x4f 0x55 0x4e 0x54 0x20 0x21 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x54 0x48 0x45 0x4e 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x4c 0x4f 0x4f 0x50 0x20 0x4c 0x4f 0x4f 0x50 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x42 0x49 0x54 0x2d 0x43 0x4f 0x55 0x4e 0x54 0x20 0x40 0x20 0x3f 0x44 0x55 0x50 0x20 0x49 0x46 0x20 0x31 0x36 0x20 0x53 0x57 0x41 0x50 0x20 0x44 0x4f 0x20 0x32 0x2a 0x20 0x4c 0x4f 0x4f 0x50 0x20 0x42 0x4c 0x54 0x53 0x45 0x47 0x20 0x00 'MUSIC___________________________                            9-12-127 \ EMPTY CR ." NOTICE! EMPTY EXECUTED IN COMBLT.CMP "            V= #FRAMES                                                      V= FRAMEOFF               ( frame offset pointer)               ( V= LFRAME )                                                   V= BIT-COUNT                                                    CREATE FILENAME 15 ALLOT                                        2V= DPVA                  ( allocation pointer within VESBLT)   CREATE BLTCOLORS 16 ALLOT ( flags showing color exists in blt)                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( COMBLT - ?COLORS HFRAMELEN                           9-12-85)                                                                 : ?COLORS ( -- \ set blt color flags based on contents of blt)    BLTCOLORS 16 0 FILL                                             LBLT @ 0 DO                                                     WBLT @ 0 DO YBLT @ J - XBLT @ I + L@PIXEL                                   BLTCOLORS + 1 SWAP C!                                        LOOP LOOP ;                                                                                                                                                                          : HFRAMELEN ( -- \ compute the length of a hybrid blt frame)      ( [framelen][color][image/run][image] )                         LBLT @ WBLT @ * 15 + 16/ 2* 4 + LFRAME ! ;                                                                                                                                                                                                                    ( COMBLT - BLTFRAME                                    9-12-85) : BLTFRAME ( -- \ build a blt image for the current color)        ( relative to bltseg & frameoff)                                BIT-COUNT OFF  FRAMEOFF @ DUP >R 4 + ABLT !  BLTSEG @ >R        LFRAME @ I I' L!  COLOR @ I I' 2+ LC!  0 R> R> 3+ LC!           0                                                               LBLT @ 0 DO                                                     WBLT @ 0 DO YBLT @ J - XBLT @ I + L@PIXEL                                   COLOR @ 15 AND =  SHL-BIT  1 BIT-COUNT +!                       BIT-COUNT @ 16 =                                                IF BLTSEG @ ABLT @ L!  2 ABLT +! 0. BIT-COUNT !                 THEN                                                         LOOP LOOP                                              BIT-COUNT @ ?DUP IF 16 SWAP DO 2* LOOP BLTSEG  '

