// ====== OVERLAY 'LP-OV' ======
// store offset = 0xe0c0
// overlay size   = 0x14a0

#include"../../emul/cpu.h"

#include"../data.h"
#include"../../emul/starflt1.h"


// =================================
// =========== Dictionary ==========
// =================================
//          planet  codep:0x2214 wordp:0xe0d6 size:0x0002 C-string:'planet'
//        creature  codep:0x2214 wordp:0xe0da size:0x0002 C-string:'creature'
//          difind  codep:0x224c wordp:0xe0de size:0x0006 C-string:'difind'
//           ?2dup  codep:0x224c wordp:0xe0e6 size:0x000c C-string:'Is2dup'
//            rput  codep:0x224c wordp:0xe0f4 size:0x000a C-string:'rput'
//            rget  codep:0x224c wordp:0xe100 size:0x000a C-string:'rget'
//     iaddr-array  codep:0x224c wordp:0xe10c size:0x0013 C-string:'iaddr_dash_array'
//          lookup  codep:0x224c wordp:0xe121 size:0x0071 C-string:'lookup'
//           >SIZE  codep:0xe114 wordp:0xe19c size:0x001e C-string:'_gt_SIZE'
//          >MOVER  codep:0xe114 wordp:0xe1c5 size:0x0021 C-string:'_gt_MOVER'
//          ?COLOR  codep:0xe114 wordp:0xe1f1 size:0x0054 C-string:'IsCOLOR'
//           >PROP  codep:0xe114 wordp:0xe24f size:0x002a C-string:'_gt_PROP'
//            coin  codep:0x224c wordp:0xe27b size:0x0008 C-string:'coin'
//           rand%  codep:0x224c wordp:0xe285 size:0x000a C-string:'rand_pe_'
//         crandom  codep:0x224c wordp:0xe291 size:0x000a C-string:'crandom'
//           scale  codep:0x224c wordp:0xe29d size:0x0014 C-string:'scale'
//         slipper  codep:0x224c wordp:0xe2b3 size:0x0006 C-string:'slipper'
//           slip!  codep:0x224c wordp:0xe2bb size:0x000a C-string:'slip_ex_'
//              %%  codep:0x224c wordp:0xe2c7 size:0x0015 C-string:'_pe__pe_'
//    atmo.density  codep:0x73ea wordp:0xe2de size:0x0006 C-string:'atmo_dot_density'
//       narrowest  codep:0x73ea wordp:0xe2e6 size:0x0006 C-string:'narrowest'
//        flattest  codep:0x73ea wordp:0xe2ee size:0x0006 C-string:'flattest'
//           shape  codep:0x73ea wordp:0xe2f6 size:0x0006 C-string:'shape'
//        exterior  codep:0x73ea wordp:0xe2fe size:0x0006 C-string:'exterior'
//      size.index  codep:0x73ea wordp:0xe306 size:0x0006 C-string:'size_dot_index'
//           niche  codep:0x73ea wordp:0xe30e size:0x0006 C-string:'niche'
//         reddest  codep:0x73ea wordp:0xe316 size:0x0006 C-string:'reddest'
//          bluest  codep:0x73ea wordp:0xe31e size:0x0006 C-string:'bluest'
//         texture  codep:0x73ea wordp:0xe326 size:0x0006 C-string:'texture'
//        w.append  codep:0x73ea wordp:0xe32e size:0x0006 C-string:'w_dot_append'
//              w#  codep:0x73ea wordp:0xe336 size:0x0006 C-string:'w_n_'
//        d.append  codep:0x73ea wordp:0xe33e size:0x0006 C-string:'d_dot_append'
//              d#  codep:0x73ea wordp:0xe346 size:0x0006 C-string:'d_n_'
//        a.append  codep:0x73ea wordp:0xe34e size:0x0006 C-string:'a_dot_append'
//              a#  codep:0x73ea wordp:0xe356 size:0x0006 C-string:'a_n_'
//        g.append  codep:0x73ea wordp:0xe35e size:0x0006 C-string:'g_dot_append'
//              g#  codep:0x73ea wordp:0xe366 size:0x0006 C-string:'g_n_'
//      g.mobility  codep:0x73ea wordp:0xe36e size:0x0006 C-string:'g_dot_mobility'
//      a.mobility  codep:0x73ea wordp:0xe376 size:0x0006 C-string:'a_dot_mobility'
//         slowest  codep:0x73ea wordp:0xe37e size:0x0006 C-string:'slowest'
//         fastest  codep:0x73ea wordp:0xe386 size:0x0006 C-string:'fastest'
//     stun.effect  codep:0x73ea wordp:0xe38e size:0x0006 C-string:'stun_dot_effect'
//      hit.points  codep:0x73ea wordp:0xe396 size:0x0006 C-string:'hit_dot_points'
//         i.level  codep:0x73ea wordp:0xe39e size:0x0006 C-string:'i_dot_level'
//         a.level  codep:0x73ea wordp:0xe3a6 size:0x0006 C-string:'a_dot_level'
//         i.level  codep:0x73ea wordp:0xe3ae size:0x0006 C-string:'i_dot_level'
//          volume  codep:0x73ea wordp:0xe3b6 size:0x0006 C-string:'volume'
//      proportion  codep:0x73ea wordp:0xe3be size:0x0006 C-string:'proportion'
//           d.hue  codep:0x73ea wordp:0xe3c6 size:0x0006 C-string:'d_dot_hue'
//          d.tint  codep:0x73ea wordp:0xe3ce size:0x0006 C-string:'d_dot_tint'
//        d.lumens  codep:0x73ea wordp:0xe3d6 size:0x0006 C-string:'d_dot_lumens'
//         d.struc  codep:0x73ea wordp:0xe3de size:0x0006 C-string:'d_dot_struc'
//        d.propor  codep:0x73ea wordp:0xe3e6 size:0x0006 C-string:'d_dot_propor'
//          d.size  codep:0x73ea wordp:0xe3ee size:0x0006 C-string:'d_dot_size'
//           w.hue  codep:0x73ea wordp:0xe3f6 size:0x0006 C-string:'w_dot_hue'
//          w.tint  codep:0x73ea wordp:0xe3fe size:0x0006 C-string:'w_dot_tint'
//           WE406  codep:0x73ea wordp:0xe406 size:0x0006 C-string:'WE406'
//         w.struc  codep:0x73ea wordp:0xe40e size:0x0006 C-string:'w_dot_struc'
//        w.propor  codep:0x73ea wordp:0xe416 size:0x0006 C-string:'w_dot_propor'
//          w.size  codep:0x73ea wordp:0xe41e size:0x0006 C-string:'w_dot_size'
//           a.hue  codep:0x73ea wordp:0xe426 size:0x0006 C-string:'a_dot_hue'
//          a.tint  codep:0x73ea wordp:0xe42e size:0x0006 C-string:'a_dot_tint'
//        a.lumens  codep:0x73ea wordp:0xe436 size:0x0006 C-string:'a_dot_lumens'
//         a.struc  codep:0x73ea wordp:0xe43e size:0x0006 C-string:'a_dot_struc'
//        a.propor  codep:0x73ea wordp:0xe446 size:0x0006 C-string:'a_dot_propor'
//          a.size  codep:0x73ea wordp:0xe44e size:0x0006 C-string:'a_dot_size'
//           g.hue  codep:0x73ea wordp:0xe456 size:0x0006 C-string:'g_dot_hue'
//          g.tint  codep:0x73ea wordp:0xe45e size:0x0006 C-string:'g_dot_tint'
//        g.lumens  codep:0x73ea wordp:0xe466 size:0x0006 C-string:'g_dot_lumens'
//         g.struc  codep:0x73ea wordp:0xe46e size:0x0006 C-string:'g_dot_struc'
//        g.propor  codep:0x73ea wordp:0xe476 size:0x0006 C-string:'g_dot_propor'
//          g.size  codep:0x73ea wordp:0xe47e size:0x0006 C-string:'g_dot_size'
//           s.hue  codep:0x73ea wordp:0xe486 size:0x0006 C-string:'s_dot_hue'
//          s.tint  codep:0x73ea wordp:0xe48e size:0x0006 C-string:'s_dot_tint'
//        s.lumens  codep:0x73ea wordp:0xe496 size:0x0006 C-string:'s_dot_lumens'
//            icon  codep:0x73ea wordp:0xe49e size:0x0006 C-string:'icon'
//       resembles  codep:0x73ea wordp:0xe4a6 size:0x0006 C-string:'resembles'
//            size  codep:0x73ea wordp:0xe4ae size:0x0006 C-string:'size'
//        whichguy  codep:0x224c wordp:0xe4b6 size:0x0012 C-string:'whichguy'
//            MAPS  codep:0x224c wordp:0xe4ca size:0x000c C-string:'MAPS'
//           PROPS  codep:0x224c wordp:0xe4d8 size:0x0096 C-string:'PROPS'
//          CHANCE  codep:0x224c wordp:0xe570 size:0x0026 C-string:'CHANCE'
//          result  codep:0x224c wordp:0xe598 size:0x000c C-string:'result'
//          rollem  codep:0x224c wordp:0xe5a6 size:0x0056 C-string:'rollem'
//        retrieve  codep:0x224c wordp:0xe5fe size:0x001a C-string:'retrieve'
//       ADDITIONS  codep:0x1d29 wordp:0xe626 size:0x0532 C-string:'ADDITIONS'
//          LIGHTS  codep:0xe4f0 wordp:0xeb63 size:0x0032 C-string:'LIGHTS'
//           ?pure  codep:0x224c wordp:0xeb97 size:0x001a C-string:'Ispure'
//          squish  codep:0x224c wordp:0xebb3 size:0x0032 C-string:'squish'
//         madness  codep:0x224c wordp:0xebe7 size:0x0056 C-string:'madness'
//           anger  codep:0x224c wordp:0xec3f size:0x0016 C-string:'anger'
//   strength-rule  codep:0x224c wordp:0xec57 size:0x0028 C-string:'strength_dash_rule'
//         durable  codep:0x224c wordp:0xec81 size:0x0008 C-string:'durable'
//        stunable  codep:0x224c wordp:0xec8b size:0x0008 C-string:'stunable'
//          movers  codep:0x224c wordp:0xec95 size:0x0062 C-string:'movers'
//        (modify)  codep:0x224c wordp:0xecf9 size:0x003c C-string:'_ro_modify_rc_'
//          modify  codep:0x224c wordp:0xed37 size:0x002a C-string:'modify'
//       customize  codep:0x224c wordp:0xed63 size:0x004a C-string:'customize'
//        colorant  codep:0x224c wordp:0xedaf size:0x003e C-string:'colorant'
//          1image  codep:0x224c wordp:0xedef size:0x002c C-string:'_1image'
//          2image  codep:0x224c wordp:0xee1d size:0x0016 C-string:'_2image'
//       PLANT.ICO  codep:0xe4f0 wordp:0xee41 size:0x0034 C-string:'PLANT_dot_ICO'
//          3image  codep:0x224c wordp:0xee77 size:0x0038 C-string:'_3image'
//          4image  codep:0x224c wordp:0xeeb1 size:0x007e C-string:'_4image'
//        set.icon  codep:0x224c wordp:0xef31 size:0x0066 C-string:'set_dot_icon'
//        colorize  codep:0x224c wordp:0xef99 size:0x0040 C-string:'colorize'
//           paint  codep:0x224c wordp:0xefdb size:0x004a C-string:'paint'
//         TALLEST  codep:0xe2cf wordp:0xf031 size:0x0016 C-string:'TALLEST'
//        SHORTEST  codep:0xe2cf wordp:0xf054 size:0x0016 C-string:'SHORTEST'
//         STALKER  codep:0xe2cf wordp:0xf076 size:0x0016 C-string:'STALKER'
//         LOSTALK  codep:0xe2cf wordp:0xf098 size:0x0016 C-string:'LOSTALK'
//        highness  codep:0x224c wordp:0xf0b0 size:0x0048 C-string:'highness'
//          (size)  codep:0x224c wordp:0xf0fa size:0x0022 C-string:'_ro_size_rc_'
//           sizer  codep:0x224c wordp:0xf11e size:0x002a C-string:'sizer'
//          smarts  codep:0x224c wordp:0xf14a size:0x0016 C-string:'smarts'
//        set-size  codep:0x224c wordp:0xf162 size:0x0016 C-string:'set_dash_size'
//         sculpts  codep:0x224c wordp:0xf17a size:0x003a C-string:'sculpts'
//          ?plant  codep:0x224c wordp:0xf1b6 size:0x009e C-string:'Isplant'
//           ?icky  codep:0x224c wordp:0xf256 size:0x012c C-string:'Isicky'
//      ?something  codep:0x224c wordp:0xf384 size:0x0146 C-string:'Issomething'
//      similarity  codep:0x224c wordp:0xf4cc size:0x0024 C-string:'similarity'
//       SPEC.PARM  codep:0x224c wordp:0xf4fe size:0x0000 C-string:'SPEC_dot_PARM'

// =================================
// ============= EXTERN ============
// =================================
extern const unsigned short int pp_SEED; // SEED
extern const unsigned short int pp_PEAK; // PEAK
extern const unsigned short int pp_FILE_n_; // FILE#
extern const unsigned short int pp_RECORD_n_; // RECORD#
extern const unsigned short int pp__ro_PLANET_rc_; // (PLANET)
extern IFieldType PHR_dash_CNT; // PHR-CNT
extern IFieldType PHRASE_dash_MEM; // PHRASE-MEM
void _star__slash_(); // */
void MAX(); // MAX
void MOD(); // MOD
void MIN(); // MIN
void _co_(); // ,
void ALLOT(); // ALLOT
void HERE(); // HERE
void NFA(); // NFA
void QUIT(); // QUIT
void ID_dot_(); // ID.
void UNRAVEL(); // UNRAVEL
void RANGE(); // RANGE
void PICK(); // PICK
void ROLL(); // ROLL
void D_eq_(); // D=
void _3_star_(); // 3*
void RRND(); // RRND
void C_ex_(); // C!
void Store_3(); // !_3
void _1_dot_5_ex_(); // 1.5!
void FILL_1(); // FILL_1
void GetRECORD(); // @RECORD
void GetINST_dash_SPECIES(); // @INST-SPECIES
void ICLOSE(); // ICLOSE
void _gt_C_plus_S(); // >C+S
void IFLD_at_(); // IFLD@
void IFLD_ex_(); // IFLD!
void IFIND(); // IFIND
void _2_at_(); // 2@
void _2DUP(); // 2DUP
void _2SWAP(); // 2SWAP
void OVER(); // OVER
void ROT(); // ROT
void SWAP(); // SWAP
void _slash_(); // /
void _dash_(); // -
void _gt_(); // >
void _st_(); // <
void _0_st_(); // 0<
void _1_dot_5_at_(); // 1.5@
void _st__ex__gt_(); // <!>
void _ro_SLIPPER_rc_(); // (SLIPPER)
void _gt_SIZE(); // >SIZE
void _gt_MOVER(); // >MOVER
void IsCOLOR(); // ?COLOR
void _gt_PROP(); // >PROP
void LIGHTS(); // LIGHTS
void TALLEST(); // TALLEST
void SHORTEST(); // SHORTEST
void STALKER(); // STALKER
void LOSTALK(); // LOSTALK


// =================================
// =========== VARIABLES ===========
// =================================
const unsigned short int pp_ADDITIONS = 0xe626; // ADDITIONS size: 1330
// {0x9c, 0x00, 0x01, 0x00, 0x17, 0xcd, 0xc4, 0xe6, 0x01, 0x00, 0x62, 0xcd, 0xe4, 0xe6, 0x01, 0x00, 0xba, 0xcb, 0x08, 0xe7, 0x01, 0x00, 0xcb, 0xcb, 0x54, 0xe7, 0x01, 0x00, 0x8b, 0xcd, 0x84, 0xe7, 0x01, 0x00, 0xe9, 0xde, 0xa4, 0xe7, 0x01, 0x00, 0xa9, 0xcb, 0xd4, 0xe7, 0x01, 0x00, 0x87, 0xcb, 0x14, 0xe8, 0x01, 0x00, 0x52, 0xde, 0x3c, 0xe8, 0x01, 0x00, 0x18, 0xde, 0x5c, 0xe8, 0x01, 0x00, 0x48, 0xdf, 0x7c, 0xe8, 0x01, 0x00, 0xfe, 0xde, 0xa8, 0xe8, 0x01, 0x00, 0x98, 0xcb, 0xe0, 0xe8, 0x01, 0x00, 0x21, 0xdf, 0x08, 0xe9, 0x01, 0x00, 0xb0, 0xcc, 0x2c, 0xe9, 0x01, 0x00, 0x59, 0xdf, 0x4c, 0xe9, 0x01, 0x00, 0xe1, 0xcb, 0x98, 0xe9, 0x01, 0x00, 0x10, 0xcc, 0x98, 0xe9, 0x01, 0x00, 0x6b, 0xdf, 0xcc, 0xe9, 0x01, 0x00, 0x00, 0xcc, 0xec, 0xe9, 0x01, 0x00, 0x07, 0xcd, 0x10, 0xea, 0x01, 0x00, 0x77, 0xde, 0x2c, 0xea, 0x01, 0x00, 0x8b, 0xde, 0x6c, 0xea, 0x01, 0x00, 0xc4, 0xde, 0xa4, 0xea, 0x01, 0x00, 0xc2, 0xdf, 0x24, 0xeb, 0x01, 0x00, 0x27, 0xcd, 0x44, 0xeb, 0x0a, 0x2d, 0xd5, 0x01, 0x14, 0x0b, 0xda, 0x01, 0x1d, 0x98, 0xd9, 0x01, 0x26, 0xb2, 0xd9, 0x01, 0x30, 0xc6, 0xd9, 0x01, 0x39, 0xdb, 0xd9, 0x01, 0x43, 0xf8, 0xd9, 0x01, 0x64, 0x1c, 0xda, 0x01, 0x09, 0x2c, 0xd9, 0x01, 0x12, 0x01, 0xd5, 0x01, 0x1b, 0x2e, 0xda, 0x01, 0x23, 0x5a, 0xd9, 0x01, 0x2c, 0x6e, 0xd9, 0x01, 0x35, 0x81, 0xd9, 0x01, 0x3d, 0x5a, 0xd5, 0x01, 0x46, 0xc6, 0xd9, 0x01, 0x64, 0xf8, 0xd9, 0x01, 0x05, 0x65, 0xd8, 0x01, 0x09, 0x75, 0xd8, 0x01, 0x0d, 0x8b, 0xd8, 0x01, 0x11, 0xc0, 0xd4, 0x01, 0x15, 0xa1, 0xd8, 0x01, 0x19, 0x18, 0xd4, 0x01, 0x1d, 0xb4, 0xd8, 0x01, 0x21, 0xdd, 0xd8, 0x01, 0x24, 0xf2, 0xd8, 0x01, 0x27, 0xd5, 0xd4, 0x01, 0x2a, 0x05, 0xd9, 0x01, 0x2d, 0x1a, 0xd9, 0x01, 0x30, 0x2f, 0xd4, 0x01, 0x33, 0x81, 0xd9, 0x01, 0x36, 0xb2, 0xd9, 0x01, 0x39, 0xc6, 0xd9, 0x01, 0x3d, 0xc7, 0xd8, 0x01, 0x41, 0xdb, 0xd9, 0x01, 0x64, 0xf8, 0xd9, 0x01, 0x07, 0xc6, 0xd3, 0x01, 0x0e, 0x28, 0xd8, 0x01, 0x15, 0xe0, 0xd3, 0x01, 0x1b, 0x00, 0xd4, 0x01, 0x21, 0x51, 0xd8, 0x01, 0x28, 0x1a, 0xd9, 0x01, 0x2f, 0x2f, 0xd4, 0x01, 0x35, 0x6e, 0xd9, 0x01, 0x3b, 0x81, 0xd9, 0x01, 0x42, 0x05, 0xd9, 0x01, 0x49, 0x3d, 0xd8, 0x01, 0x64, 0xd5, 0xd4, 0x01, 0x0a, 0x5a, 0xd9, 0x01, 0x14, 0x6e, 0xd9, 0x01, 0x1d, 0x98, 0xd9, 0x01, 0x26, 0xb2, 0xd9, 0x01, 0x30, 0x5a, 0xd5, 0x01, 0x39, 0xc6, 0xd9, 0x01, 0x43, 0xdb, 0xd9, 0x01, 0x64, 0xf8, 0xd9, 0x01, 0x07, 0xe9, 0xd7, 0x01, 0x0e, 0x96, 0xd3, 0x01, 0x15, 0x00, 0xd8, 0x01, 0x1b, 0x14, 0xd8, 0x01, 0x21, 0xdd, 0xd8, 0x01, 0x28, 0xf2, 0xd8, 0x01, 0x2f, 0x1a, 0xd9, 0x01, 0x35, 0x2f, 0xd4, 0x01, 0x3b, 0x5a, 0xd9, 0x01, 0x42, 0xf8, 0xd9, 0x01, 0x49, 0xaf, 0xd3, 0x01, 0x64, 0x6e, 0xd9, 0x01, 0x06, 0x59, 0xd7, 0x01, 0x0a, 0x73, 0xd7, 0x01, 0x0e, 0x86, 0xd7, 0x01, 0x13, 0x98, 0xd7, 0x01, 0x17, 0xac, 0xd7, 0x01, 0x1b, 0xbf, 0xd7, 0x01, 0x20, 0xd7, 0xd7, 0x01, 0x24, 0x00, 0xd8, 0x01, 0x28, 0x14, 0xd8, 0x01, 0x2d, 0xc7, 0xd8, 0x01, 0x31, 0x7c, 0xd3, 0x01, 0x35, 0xdd, 0xd8, 0x01, 0x3a, 0xf2, 0xd8, 0x01, 0x3f, 0x2f, 0xd4, 0x01, 0x43, 0x5a, 0xd9, 0x01, 0x64, 0xf8, 0xd9, 0x01, 0x09, 0x86, 0xd7, 0x01, 0x10, 0x98, 0xd7, 0x01, 0x18, 0xac, 0xd7, 0x01, 0x1f, 0xbf, 0xd7, 0x01, 0x27, 0xd7, 0xd7, 0x01, 0x2e, 0x14, 0xd8, 0x01, 0x36, 0xf2, 0xd8, 0x01, 0x3d, 0x5a, 0xd9, 0x01, 0x45, 0xdb, 0xd9, 0x01, 0x64, 0xf8, 0xd9, 0x01, 0x0a, 0xac, 0xd7, 0x01, 0x14, 0xbf, 0xd7, 0x01, 0x1d, 0xd7, 0xd7, 0x01, 0x26, 0x14, 0xd8, 0x01, 0x30, 0xb4, 0xd8, 0x01, 0x39, 0xb2, 0xd9, 0x01, 0x43, 0xc6, 0xd9, 0x01, 0x64, 0xdb, 0xd9, 0x01, 0x0a, 0x2f, 0xd7, 0x01, 0x14, 0xeb, 0xd4, 0x01, 0x1d, 0xa9, 0xd4, 0x01, 0x26, 0x7c, 0xd3, 0x01, 0x30, 0xbf, 0xd7, 0x01, 0x39, 0xd7, 0xd7, 0x01, 0x43, 0x14, 0xd8, 0x01, 0x64, 0x92, 0xd4, 0x01, 0x08, 0x73, 0xd7, 0x01, 0x0f, 0x14, 0xd8, 0x01, 0x15, 0x18, 0xd4, 0x01, 0x1b, 0xdd, 0xd8, 0x01, 0x21, 0xf2, 0xd8, 0x01, 0x28, 0x05, 0xd9, 0x01, 0x2f, 0x01, 0xd5, 0x01, 0x35, 0x43, 0xd9, 0x01, 0x3b, 0x6e, 0xd9, 0x01, 0x41, 0xc6, 0xd9, 0x01, 0x64, 0xdb, 0xd9, 0x01, 0x06, 0xf3, 0xd6, 0x01, 0x0c, 0x07, 0xd7, 0x01, 0x11, 0x32, 0xd3, 0x01, 0x16, 0x4a, 0xd3, 0x01, 0x1c, 0x62, 0xd3, 0x01, 0x21, 0x14, 0xd8, 0x01, 0x26, 0xa1, 0xd8, 0x01, 0x2c, 0x18, 0xd4, 0x01, 0x31, 0xb4, 0xd8, 0x01, 0x37, 0xd5, 0xd4, 0x01, 0x3d, 0x05, 0xd9, 0x01, 0x42, 0x43, 0xd9, 0x01, 0x48, 0x5a, 0xd9, 0x01, 0x64, 0xf8, 0xd9, 0x01, 0x09, 0xdc, 0xd6, 0x01, 0x10, 0xeb, 0xd4, 0x01, 0x18, 0xac, 0xd7, 0x01, 0x1f, 0x00, 0xd8, 0x01, 0x27, 0x14, 0xd8, 0x01, 0x2e, 0xdd, 0xd8, 0x01, 0x36, 0xf2, 0xd8, 0x01, 0x3d, 0x5a, 0xd9, 0x01, 0x45, 0x59, 0xd7, 0x01, 0x64, 0x14, 0xd8, 0x01, 0x09, 0xdc, 0xd6, 0x01, 0x12, 0x86, 0xd7, 0x01, 0x1b, 0x98, 0xd7, 0x01, 0x23, 0x14, 0xd8, 0x01, 0x2c, 0x51, 0xd8, 0x01, 0x35, 0x43, 0xd9, 0x01, 0x3d, 0x81, 0xd9, 0x01, 0x46, 0xc6, 0xd9, 0x01, 0x64, 0xf8, 0xd9, 0x01, 0x0a, 0xdc, 0xd6, 0x01, 0x14, 0x86, 0xd7, 0x01, 0x1d, 0x98, 0xd7, 0x01, 0x26, 0x14, 0xd8, 0x01, 0x30, 0x51, 0xd8, 0x01, 0x39, 0x43, 0xd9, 0x01, 0x43, 0x81, 0xd9, 0x01, 0x64, 0xf8, 0xd9, 0x01, 0x05, 0x7a, 0xd6, 0x01, 0x09, 0x90, 0xd6, 0x01, 0x0d, 0xa3, 0xd6, 0x01, 0x11, 0xb5, 0xd6, 0x01, 0x15, 0xcb, 0xd6, 0x01, 0x19, 0x1a, 0xd3, 0x01, 0x1d, 0x32, 0xd3, 0x01, 0x21, 0x4a, 0xd3, 0x01, 0x24, 0x62, 0xd3, 0x01, 0x27, 0x5a, 0xd9, 0x01, 0x2a, 0x59, 0xd7, 0x01, 0x2d, 0x98, 0xd7, 0x01, 0x30, 0xe0, 0xd3, 0x01, 0x33, 0xc7, 0xd8, 0x01, 0x36, 0x2f, 0xd4, 0x01, 0x39, 0x73, 0xd7, 0x01, 0x3d, 0x00, 0xd4, 0x01, 0x41, 0x6e, 0xd9, 0x01, 0x64, 0xb2, 0xd9, 0x01, 0x07, 0x28, 0xd8, 0x01, 0x0d, 0x3d, 0xd8, 0x01, 0x12, 0x51, 0xd8, 0x01, 0x17, 0xc0, 0xd4, 0x01, 0x1d, 0xd5, 0xd4, 0x01, 0x23, 0x05, 0xd9, 0x01, 0x28, 0x2c, 0xd9, 0x01, 0x2d, 0x6e, 0xd9, 0x01, 0x33, 0x81, 0xd9, 0x01, 0x39, 0x2d, 0xd5, 0x01, 0x3e, 0x5a, 0xd9, 0x01, 0x43, 0x5a, 0xd5, 0x01, 0x64, 0xf8, 0xd9, 0x01, 0x0a, 0x5e, 0xd6, 0x01, 0x14, 0x1a, 0xd7, 0x01, 0x1d, 0x73, 0xd7, 0x01, 0x26, 0xc0, 0xd4, 0x01, 0x30, 0xd5, 0xd4, 0x01, 0x39, 0x6e, 0xd9, 0x01, 0x43, 0x81, 0xd9, 0x01, 0x64, 0x05, 0xd9, 0x01, 0x09, 0x65, 0xd4, 0x01, 0x12, 0x1a, 0xd3, 0x01, 0x1b, 0x07, 0xd7, 0x01, 0x23, 0x14, 0xd8, 0x01, 0x2c, 0xa1, 0xd8, 0x01, 0x35, 0x18, 0xd4, 0x01, 0x3d, 0x05, 0xd9, 0x01, 0x46, 0x81, 0xd9, 0x01, 0x64, 0xdc, 0xd6, 0x01, 0x0c, 0x32, 0xd6, 0x01, 0x16, 0x47, 0xd6, 0x01, 0x20, 0x65, 0xd4, 0x01, 0x2b, 0xcb, 0xd6, 0x01, 0x36, 0xdc, 0xd6, 0x01, 0x40, 0x62, 0xd3, 0x01, 0x64, 0x3d, 0xd8, 0x01, 0x06, 0x01, 0xd3, 0x01, 0x0a, 0xc7, 0xd5, 0x01, 0x0e, 0xb5, 0xd6, 0x01, 0x13, 0x1a, 0xd3, 0x01, 0x17, 0x07, 0xd7, 0x01, 0x1b, 0x4a, 0xd3, 0x01, 0x20, 0x41, 0xd7, 0x01, 0x24, 0x62, 0xd3, 0x01, 0x28, 0xc6, 0xd3, 0x01, 0x2d, 0x00, 0xd4, 0x01, 0x31, 0x18, 0xd4, 0x01, 0x35, 0x5e, 0xd6, 0x01, 0x3a, 0x81, 0xd9, 0x01, 0x3f, 0x32, 0xd3, 0x01, 0x43, 0x05, 0xd9, 0x01, 0x64, 0x59, 0xd7, 0x01, 0x06, 0x90, 0xd6, 0x01, 0x0c, 0xa3, 0xd6, 0x01, 0x11, 0xcb, 0xd6, 0x01, 0x16, 0x4a, 0xd3, 0x01, 0x1c, 0x62, 0xd3, 0x01, 0x21, 0xc6, 0xd3, 0x01, 0x26, 0x28, 0xd8, 0x01, 0x2c, 0x00, 0xd4, 0x01, 0x31, 0x51, 0xd8, 0x01, 0x37, 0xf2, 0xd8, 0x01, 0x3d, 0xaf, 0xd3, 0x01, 0x42, 0x2c, 0xd9, 0x01, 0x48, 0x5a, 0xd9, 0x01, 0x64, 0x6e, 0xd9, 0x01, 0x03, 0xe6, 0xd2, 0x01, 0x06, 0xb4, 0xd5, 0x01, 0x08, 0xc7, 0xd5, 0x01, 0x0a, 0x06, 0xd6, 0x01, 0x0d, 0x1b, 0xd6, 0x01, 0x0f, 0x7a, 0xd6, 0x01, 0x11, 0xa3, 0xd6, 0x01, 0x14, 0xb5, 0xd6, 0x01, 0x16, 0xcb, 0xd6, 0x01, 0x18, 0x1a, 0xd3, 0x01, 0x1b, 0x07, 0xd7, 0x01, 0x1d, 0x32, 0xd3, 0x01, 0x1f, 0x59, 0xd7, 0x01, 0x22, 0xbf, 0xd7, 0x01, 0x24, 0x96, 0xd3, 0x01, 0x26, 0xaf, 0xd3, 0x01, 0x29, 0x14, 0xd8, 0x01, 0x2b, 0x28, 0xd8, 0x01, 0x2d, 0xa1, 0xd8, 0x01, 0x30, 0xc7, 0xd8, 0x01, 0x32, 0xf2, 0xd8, 0x01, 0x34, 0x2f, 0xd4, 0x01, 0x37, 0x6e, 0xd9, 0x01, 0x39, 0x81, 0xd9, 0x01, 0x3c, 0x05, 0xd9, 0x01, 0x3f, 0x01, 0xd3, 0x01, 0x41, 0x62, 0xd3, 0x01, 0x44, 0x4a, 0xd3, 0x01, 0x47, 0x7c, 0xd3, 0x01, 0x49, 0x00, 0xd4, 0x01, 0x4c, 0x18, 0xd4, 0x01, 0x64, 0x1a, 0xd9, 0x01, 0x0a, 0x1b, 0xd6, 0x01, 0x14, 0xcb, 0xd6, 0x01, 0x1d, 0x41, 0xd7, 0x01, 0x26, 0x98, 0xd7, 0x01, 0x30, 0x28, 0xd8, 0x01, 0x39, 0xe0, 0xd3, 0x01, 0x43, 0x51, 0xd8, 0x01, 0x64, 0x5a, 0xd9, 0x01, 0x10, 0xdd, 0xd5, 0x01, 0x1f, 0xf3, 0xd5, 0x01, 0x2e, 0x4e, 0xd4, 0x01, 0x3d, 0x06, 0xd6, 0x01, 0x64, 0x1b, 0xd6, 0x01}


const unsigned short int cc_planet = 0xe0d6; // planet
const unsigned short int cc_creature = 0xe0da; // creature


// 0xe0d2: db 0x47 0x01 'G '

// ================================================
// 0xe0d4: WORD 'planet' codep=0x2214 wordp=0xe0d6
// ================================================
// orphan
// 0xe0d6: dw 0x0020

// ================================================
// 0xe0d8: WORD 'creature' codep=0x2214 wordp=0xe0da
// ================================================
// 0xe0da: dw 0x0044

// ================================================
// 0xe0dc: WORD 'difind' codep=0x224c wordp=0xe0de
// ================================================
// orphan

void difind() // difind
{
  _2DUP(); // 2DUP
  IFIND(); // IFIND
}


// ================================================
// 0xe0e4: WORD '?2dup' codep=0x224c wordp=0xe0e6 params=2 returns=2
// ================================================

void Is2dup() // ?2dup
{
  _2DUP(); // 2DUP
  Push(Pop() | Pop()); // OR
  if (Pop() == 0) return;
  _2DUP(); // 2DUP
}


// ================================================
// 0xe0f2: WORD 'rput' codep=0x224c wordp=0xe0f4 params=0 returns=2
// ================================================

void rput() // rput
{
  Push(Read16(pp_RECORD_n_)); // RECORD# @
  Push(Read16(pp_FILE_n_)); // FILE# @
}


// ================================================
// 0xe0fe: WORD 'rget' codep=0x224c wordp=0xe100 params=2 returns=0
// ================================================

void rget() // rget
{
  Push(pp_FILE_n_); // FILE#
  Store_3(); // !_3
  Push(pp_RECORD_n_); // RECORD#
  Store_3(); // !_3
}


// ================================================
// 0xe10a: WORD 'iaddr-array' codep=0x224c wordp=0xe10c
// ================================================
// orphan

void iaddr_dash_array() // iaddr-array
{
  Exec("CREATE"); // call of word 0x1cbb '(CREATE)'
  Push(0);
  WD875(); // Unknown overlay function
  CODE(); // (;CODE) inlined assembler code
// 0xe114: call   1649
  SWAP(); // SWAP
  _3_star_(); // 3*
  Push(Pop() + Pop()); // +
}


// ================================================
// 0xe11f: WORD 'lookup' codep=0x224c wordp=0xe121 params=3 returns=2
// ================================================

void lookup() // lookup
{
  unsigned short int a, b, i, imax, c;
  rput(); // rput
  a = Pop(); // >R
  b = Pop(); // >R
  Push(Read16(regsp)); // DUP
  Push(Read16(Pop())&0xFF); //  C@
  _3_star_(); // 3*

  i = 3;
  imax = Pop() + 3; //  3+
  do // (DO)
  {
    Push(Read16(regsp)); // DUP
    Push(Pop() + i); //  I +
    _1_dot_5_at_(); // 1.5@
    Push(5);
    PICK(); // PICK
    Push(5);
    PICK(); // PICK
    D_eq_(); // D=
    if (Pop() != 0)
    {
      Pop(); // DROP
      Pop(); Pop(); // 2DROP
      Push2Words("0.");
      Push(i); // I
      imax = i; // LEAVE
    }
    Push(3);
    int step = Pop();
    i += step;
    if (((step>=0) && (i>=imax)) || ((step<0) && (i<=imax))) break;
  } while(1); // (+LOOP)

  c = Pop(); // >R
  Is2dup(); // ?2dup
  Push(Pop() | Pop()); // OR
  if (Pop() != 0)
  {
    _gt_C_plus_S(); // >C+S
    Push(0x63ef+PHRASE_dash_MEM.offset); // PHRASE-MEM<IFIELD>
    Push(Read16(0x63ef+PHR_dash_CNT.offset)&0xFF); // PHR-CNT<IFIELD> C@
    Exec("TYPE"); // call of word 0x2690 '(TYPE)'
    ICLOSE(); // ICLOSE
    PRINT(" not in ", 8); // (.")
    Push(c); // R>
    NFA(); // NFA
    ID_dot_(); // ID.
    UNRAVEL(); // UNRAVEL
    QUIT(); // QUIT
  }
  Push(b); // R>
  Push(3);
  _slash_(); // /
  Push(a); // R>
  Push(callp0); // R>
  rget(); // rget
}


// ================================================
// 0xe192: WORD '>SIZE' codep=0xe114 wordp=0xe19c
// ================================================
// 0xe19c: db 0x09 0x00 0x00 0x76 0xe5 0x01 0x87 0xe5 0x01 0x99 0xe5 0x01 0xa9 0xe5 0x01 0xbb 0xe5 0x01 0xd2 0xe5 0x01 0xe3 0xe5 0x01 0xf7 0xe5 0x01 0x0d 0xe6 0x01 '   v                          '

// ================================================
// 0xe1ba: WORD '>MOVER' codep=0xe114 wordp=0xe1c5
// ================================================
// 0xe1c5: db 0x0a 0x00 0x00 0x1d 0xe1 0x01 0x30 0xe1 0x01 0x45 0xe1 0x01 0x5c 0xe1 0x01 0x71 0xe1 0x01 0x85 0xe1 0x01 0x98 0xe1 0x01 0xac 0xe1 0x01 0xc0 0xe1 0x01 0xd4 0xe1 0x01 '      0  E  \  q                 '

// ================================================
// 0xe1e6: WORD '?COLOR' codep=0xe114 wordp=0xe1f1
// ================================================
// 0xe1f1: db 0x1b 0x00 0x00 0x27 0xe3 0x01 0x4d 0xe4 0x01 0x61 0xe4 0x01 0x7a 0xe4 0x01 0x37 0xe3 0x01 0x8b 0xe4 0x01 0x9d 0xe4 0x01 0xaf 0xe4 0x01 0x52 0xe3 0x01 0x65 0xe3 0x01 0x82 0xe3 0x01 0x95 0xe3 0x01 0xae 0xe3 0x01 0xca 0xe4 0x01 0xca 0xe3 0x01 0xe5 0xe4 0x01 0xdc 0xe3 0x01 0xfc 0xe4 0x01 0x00 0xe4 0x01 0x12 0xe5 0x01 0x27 0xe4 0x01 0x3a 0xe4 0x01 0x41 0xe5 0x01 0x27 0xe5 0x01 0x53 0xe5 0x01 0x64 0xe5 0x01 0x11 0xe4 0x01 '   '  M  a  z  7           R  e                                '  :  A  '  S  d     '

// ================================================
// 0xe245: WORD '>PROP' codep=0xe114 wordp=0xe24f
// ================================================
// 0xe24f: db 0x0d 0x00 0x00 0x21 0xe0 0x01 0x37 0xe0 0x01 0x48 0xe0 0x01 0x59 0xe0 0x01 0x6b 0xe0 0x01 0x7d 0xe0 0x01 0x93 0xe0 0x01 0xa6 0xe0 0x01 0xba 0xe0 0x01 0xcf 0xe0 0x01 0xe0 0xe0 0x01 0xf4 0xe0 0x01 0x08 0xe1 0x01 '   !  7  H  Y  k  }                       '

// ================================================
// 0xe279: WORD 'coin' codep=0x224c wordp=0xe27b params=0 returns=1
// ================================================

void coin() // coin
{
  Push(0);
  Push(2);
  RRND(); // RRND
}


// ================================================
// 0xe283: WORD 'rand%' codep=0x224c wordp=0xe285 params=0 returns=1
// ================================================

void rand_pe_() // rand%
{
  Push(1);
  Push(0x0064);
  RRND(); // RRND
}


// ================================================
// 0xe28f: WORD 'crandom' codep=0x224c wordp=0xe291 params=0 returns=1
// ================================================

void crandom() // crandom
{
  Push(0);
  Push(0x0100);
  RRND(); // RRND
}


// ================================================
// 0xe29b: WORD 'scale' codep=0x224c wordp=0xe29d params=3 returns=1
// ================================================

void scale() // scale
{
  unsigned short int a;
  a = Pop(); // >R
  Push(Pop() + 1); //  1+
  OVER(); // OVER
  _dash_(); // -
  Push(a); // R>
  Push(0x0100);
  _star__slash_(); // */
  Push(Pop() + Pop()); // +
}


// ================================================
// 0xe2b1: WORD 'slipper' codep=0x224c wordp=0xe2b3
// ================================================

void slipper() // slipper
{
  crandom(); // crandom
  _ro_SLIPPER_rc_(); // (SLIPPER)
}


// ================================================
// 0xe2b9: WORD 'slip!' codep=0x224c wordp=0xe2bb
// ================================================

void slip_ex_() // slip!
{
  do
  {
    slipper(); // slipper
  } while(Pop() == 0);
  scale(); // scale
}


// ================================================
// 0xe2c5: WORD '%%' codep=0x224c wordp=0xe2c7
// ================================================
// orphan

void _pe__pe_() // %%
{
  Exec("CREATE"); // call of word 0x1cbb '(CREATE)'
  Push(0);
  _co_(); // ,
  CODE(); // (;CODE) inlined assembler code
// 0xe2cf: call   1649
  OVER(); // OVER
  Push(Pop() + Pop()); // +
  Push(Pop() + Pop()); // +
  Push(Read16(Pop())); //  @
}


// ================================================
// 0xe2dc: WORD 'atmo.density' codep=0x73ea wordp=0xe2de
// ================================================
// orphan
LoadDataType atmo_dot_density = {PLANETIDX, 0x13, 0x01, 0x16, 0x658f};

// ================================================
// 0xe2e4: WORD 'narrowest' codep=0x73ea wordp=0xe2e6
// ================================================
LoadDataType narrowest = {PLANETIDX, 0x14, 0x03, 0x16, 0x658f};

// ================================================
// 0xe2ec: WORD 'flattest' codep=0x73ea wordp=0xe2ee
// ================================================
LoadDataType flattest = {PLANETIDX, 0x15, 0x02, 0x16, 0x658f};

// ================================================
// 0xe2f4: WORD 'shape' codep=0x73ea wordp=0xe2f6
// ================================================
LoadDataType shape = {CREATUREIDX, 0x04, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe2fc: WORD 'exterior' codep=0x73ea wordp=0xe2fe
// ================================================
LoadDataType exterior = {CREATUREIDX, 0x07, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe304: WORD 'size.index' codep=0x73ea wordp=0xe306
// ================================================
LoadDataType size_dot_index = {CREATUREIDX, 0x0b, 0x01, 0x9c, 0x69d8};

// ================================================
// 0xe30c: WORD 'niche' codep=0x73ea wordp=0xe30e
// ================================================
LoadDataType niche = {CREATUREIDX, 0x0c, 0x01, 0x9c, 0x69d8};

// ================================================
// 0xe314: WORD 'reddest' codep=0x73ea wordp=0xe316
// ================================================
LoadDataType reddest = {CREATUREIDX, 0x0d, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe31c: WORD 'bluest' codep=0x73ea wordp=0xe31e
// ================================================
LoadDataType bluest = {CREATUREIDX, 0x10, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe324: WORD 'texture' codep=0x73ea wordp=0xe326
// ================================================
LoadDataType texture = {CREATUREIDX, 0x13, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe32c: WORD 'w.append' codep=0x73ea wordp=0xe32e
// ================================================
LoadDataType w_dot_append = {CREATUREIDX, 0x16, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe334: WORD 'w#' codep=0x73ea wordp=0xe336
// ================================================
// orphan
LoadDataType w_n_ = {CREATUREIDX, 0x19, 0x01, 0x9c, 0x69d8};

// ================================================
// 0xe33c: WORD 'd.append' codep=0x73ea wordp=0xe33e
// ================================================
LoadDataType d_dot_append = {CREATUREIDX, 0x1a, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe344: WORD 'd#' codep=0x73ea wordp=0xe346
// ================================================
// orphan
LoadDataType d_n_ = {CREATUREIDX, 0x1d, 0x01, 0x9c, 0x69d8};

// ================================================
// 0xe34c: WORD 'a.append' codep=0x73ea wordp=0xe34e
// ================================================
LoadDataType a_dot_append = {CREATUREIDX, 0x1e, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe354: WORD 'a#' codep=0x73ea wordp=0xe356
// ================================================
LoadDataType a_n_ = {CREATUREIDX, 0x21, 0x01, 0x9c, 0x69d8};

// ================================================
// 0xe35c: WORD 'g.append' codep=0x73ea wordp=0xe35e
// ================================================
LoadDataType g_dot_append = {CREATUREIDX, 0x22, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe364: WORD 'g#' codep=0x73ea wordp=0xe366
// ================================================
LoadDataType g_n_ = {CREATUREIDX, 0x25, 0x01, 0x9c, 0x69d8};

// ================================================
// 0xe36c: WORD 'g.mobility' codep=0x73ea wordp=0xe36e
// ================================================
LoadDataType g_dot_mobility = {CREATUREIDX, 0x26, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe374: WORD 'a.mobility' codep=0x73ea wordp=0xe376
// ================================================
LoadDataType a_dot_mobility = {CREATUREIDX, 0x29, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe37c: WORD 'slowest' codep=0x73ea wordp=0xe37e
// ================================================
LoadDataType slowest = {CREATUREIDX, 0x30, 0x01, 0x9c, 0x69d8};

// ================================================
// 0xe384: WORD 'fastest' codep=0x73ea wordp=0xe386
// ================================================
LoadDataType fastest = {CREATUREIDX, 0x31, 0x01, 0x9c, 0x69d8};

// ================================================
// 0xe38c: WORD 'stun.effect' codep=0x73ea wordp=0xe38e
// ================================================
LoadDataType stun_dot_effect = {CREATUREIDX, 0x33, 0x01, 0x9c, 0x69d8};

// ================================================
// 0xe394: WORD 'hit.points' codep=0x73ea wordp=0xe396
// ================================================
LoadDataType hit_dot_points = {CREATUREIDX, 0x34, 0x01, 0x9c, 0x69d8};

// ================================================
// 0xe39c: WORD 'i.level' codep=0x73ea wordp=0xe39e
// ================================================
LoadDataType i_dot_level = {CREATUREIDX, 0x36, 0x01, 0x9c, 0x69d8};

// ================================================
// 0xe3a4: WORD 'a.level' codep=0x73ea wordp=0xe3a6
// ================================================
LoadDataType a_dot_level = {CREATUREIDX, 0x37, 0x01, 0x9c, 0x69d8};

// ================================================
// 0xe3ac: WORD 'i.level' codep=0x73ea wordp=0xe3ae
// ================================================
LoadDataType i_dot_level = {CREATUREIDX, 0x38, 0x02, 0x9c, 0x69d8};

// ================================================
// 0xe3b4: WORD 'volume' codep=0x73ea wordp=0xe3b6
// ================================================
LoadDataType volume = {CREATUREIDX, 0x3a, 0x02, 0x9c, 0x69d8};

// ================================================
// 0xe3bc: WORD 'proportion' codep=0x73ea wordp=0xe3be
// ================================================
LoadDataType proportion = {CREATUREIDX, 0x3c, 0x02, 0x9c, 0x69d8};

// ================================================
// 0xe3c4: WORD 'd.hue' codep=0x73ea wordp=0xe3c6
// ================================================
// orphan
LoadDataType d_dot_hue = {CREATUREIDX, 0x3f, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe3cc: WORD 'd.tint' codep=0x73ea wordp=0xe3ce
// ================================================
// orphan
LoadDataType d_dot_tint = {CREATUREIDX, 0x42, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe3d4: WORD 'd.lumens' codep=0x73ea wordp=0xe3d6
// ================================================
// orphan
LoadDataType d_dot_lumens = {CREATUREIDX, 0x45, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe3dc: WORD 'd.struc' codep=0x73ea wordp=0xe3de
// ================================================
LoadDataType d_dot_struc = {CREATUREIDX, 0x48, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe3e4: WORD 'd.propor' codep=0x73ea wordp=0xe3e6
// ================================================
// orphan
LoadDataType d_dot_propor = {CREATUREIDX, 0x4b, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe3ec: WORD 'd.size' codep=0x73ea wordp=0xe3ee
// ================================================
// orphan
LoadDataType d_dot_size = {CREATUREIDX, 0x4e, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe3f4: WORD 'w.hue' codep=0x73ea wordp=0xe3f6
// ================================================
// orphan
LoadDataType w_dot_hue = {CREATUREIDX, 0x51, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe3fc: WORD 'w.tint' codep=0x73ea wordp=0xe3fe
// ================================================
// orphan
LoadDataType w_dot_tint = {CREATUREIDX, 0x54, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe404: WORD 'WE406' codep=0x73ea wordp=0xe406
// ================================================
// orphan
LoadDataType WE406 = {CREATUREIDX, 0x57, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe40c: WORD 'w.struc' codep=0x73ea wordp=0xe40e
// ================================================
LoadDataType w_dot_struc = {CREATUREIDX, 0x5a, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe414: WORD 'w.propor' codep=0x73ea wordp=0xe416
// ================================================
// orphan
LoadDataType w_dot_propor = {CREATUREIDX, 0x5d, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe41c: WORD 'w.size' codep=0x73ea wordp=0xe41e
// ================================================
// orphan
LoadDataType w_dot_size = {CREATUREIDX, 0x60, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe424: WORD 'a.hue' codep=0x73ea wordp=0xe426
// ================================================
// orphan
LoadDataType a_dot_hue = {CREATUREIDX, 0x63, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe42c: WORD 'a.tint' codep=0x73ea wordp=0xe42e
// ================================================
// orphan
LoadDataType a_dot_tint = {CREATUREIDX, 0x66, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe434: WORD 'a.lumens' codep=0x73ea wordp=0xe436
// ================================================
// orphan
LoadDataType a_dot_lumens = {CREATUREIDX, 0x69, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe43c: WORD 'a.struc' codep=0x73ea wordp=0xe43e
// ================================================
LoadDataType a_dot_struc = {CREATUREIDX, 0x6c, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe444: WORD 'a.propor' codep=0x73ea wordp=0xe446
// ================================================
// orphan
LoadDataType a_dot_propor = {CREATUREIDX, 0x6f, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe44c: WORD 'a.size' codep=0x73ea wordp=0xe44e
// ================================================
// orphan
LoadDataType a_dot_size = {CREATUREIDX, 0x72, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe454: WORD 'g.hue' codep=0x73ea wordp=0xe456
// ================================================
// orphan
LoadDataType g_dot_hue = {CREATUREIDX, 0x75, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe45c: WORD 'g.tint' codep=0x73ea wordp=0xe45e
// ================================================
// orphan
LoadDataType g_dot_tint = {CREATUREIDX, 0x78, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe464: WORD 'g.lumens' codep=0x73ea wordp=0xe466
// ================================================
// orphan
LoadDataType g_dot_lumens = {CREATUREIDX, 0x7b, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe46c: WORD 'g.struc' codep=0x73ea wordp=0xe46e
// ================================================
LoadDataType g_dot_struc = {CREATUREIDX, 0x7e, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe474: WORD 'g.propor' codep=0x73ea wordp=0xe476
// ================================================
// orphan
LoadDataType g_dot_propor = {CREATUREIDX, 0x81, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe47c: WORD 'g.size' codep=0x73ea wordp=0xe47e
// ================================================
// orphan
LoadDataType g_dot_size = {CREATUREIDX, 0x84, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe484: WORD 's.hue' codep=0x73ea wordp=0xe486
// ================================================
LoadDataType s_dot_hue = {CREATUREIDX, 0x87, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe48c: WORD 's.tint' codep=0x73ea wordp=0xe48e
// ================================================
LoadDataType s_dot_tint = {CREATUREIDX, 0x8a, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe494: WORD 's.lumens' codep=0x73ea wordp=0xe496
// ================================================
LoadDataType s_dot_lumens = {CREATUREIDX, 0x8d, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe49c: WORD 'icon' codep=0x73ea wordp=0xe49e
// ================================================
LoadDataType icon = {CREATUREIDX, 0x90, 0x02, 0x9c, 0x69d8};

// ================================================
// 0xe4a4: WORD 'resembles' codep=0x73ea wordp=0xe4a6
// ================================================
LoadDataType resembles = {CREATUREIDX, 0x92, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe4ac: WORD 'size' codep=0x73ea wordp=0xe4ae
// ================================================
LoadDataType size = {CREATUREIDX, 0x95, 0x03, 0x9c, 0x69d8};

// ================================================
// 0xe4b4: WORD 'whichguy' codep=0x224c wordp=0xe4b6 params=0 returns=0
// ================================================

void whichguy() // whichguy
{
  Push(Read16(cc_creature)); // creature
  Push(Read16(regsp)); // DUP
  Push(pp_FILE_n_); // FILE#
  Store_3(); // !_3
  Push(Read16(pp_RECORD_n_)); // RECORD# @
  GetRECORD(); // @RECORD
  Pop(); // DROP
}


// ================================================
// 0xe4c8: WORD 'MAPS' codep=0x224c wordp=0xe4ca params=1 returns=2
// ================================================

void MAPS() // MAPS
{
  Push(Read16(regsp)); // DUP
  Push(Read16(Pop()) + 2); //  @ 2+
  RANGE(); // RANGE
  Push(Pop() + 2); //  2+
}


// ================================================
// 0xe4d6: WORD 'PROPS' codep=0x224c wordp=0xe4d8
// ================================================
// orphan

void PROPS() // PROPS
{
  unsigned short int i, imax, a;
  Exec("CREATE"); // call of word 0x1cbb '(CREATE)'
  Push(Pop() * 6); //  6 *
  Push(Read16(regsp)); // DUP
  _co_(); // ,
  HERE(); // HERE
  OVER(); // OVER
  ALLOT(); // ALLOT
  SWAP(); // SWAP
  Push(0);
  FILL_1(); // FILL_1
  CODE(); // (;CODE) inlined assembler code
// 0xe4f0: call   1649
  Push(0);
  Push(4);
  ROLL(); // ROLL
  Push(4);
  ROLL(); // ROLL
  Push(4);
  ROLL(); // ROLL
  MAPS(); // MAPS

  i = Pop();
  imax = Pop();
  do // (DO)
  {
    Push(i); // I
    _2_at_(); // 2@
    Push(3);
    PICK(); // PICK
    Push((Pop()==Pop())?1:0); // =
    a = Pop(); // >R
    Push(3);
    PICK(); // PICK
    Push((Pop()==Pop())?1:0); // =
    Push(Pop() & a); //  R> AND
    if (Pop() != 0)
    {
      Push(i); // I
      Push(4);
      ROLL(); // ROLL
      Pop(); // DROP
      ROT(); // ROT
      ROT(); // ROT
      imax = i; // LEAVE
    }
    Push(6);
    int step = Pop();
    i += step;
    if (((step>=0) && (i>=imax)) || ((step<0) && (i<=imax))) break;
  } while(1); // (+LOOP)

  Pop(); Pop(); // 2DROP
  if (Read16(regsp) != 0) Push(Read16(regsp)); // ?DUP
  if (Pop() != 0)
  {
    Push(Read16(Pop() + 4)); //  4 + @
    return;
  }
  PRINT("INDEX NOT IN PROBABILITY ARRAY! ", 32); // (.")
  UNRAVEL(); // UNRAVEL
  QUIT(); // QUIT
}


// ================================================
// 0xe56e: WORD 'CHANCE' codep=0x224c wordp=0xe570 params=2 returns=2
// ================================================

void CHANCE() // CHANCE
{
  unsigned short int a;
  while(1)
  {
    OVER(); // OVER
    OVER(); // OVER
    Push(Read16(Pop())&0xFF); //  C@
    Push(Read16(regsp)); // DUP
    Push(!(Pop()==0x0064?1:0)); //  0x0064 = NOT
    a = Pop(); // >R
    _gt_(); // >
    Push(Pop() & a); //  R> AND
    if (Pop() == 0) return;
    Push((Pop() + 1) + 3); //  1+ 3+
  }
}


// ================================================
// 0xe596: WORD 'result' codep=0x224c wordp=0xe598 params=2 returns=2
// ================================================

void result() // result
{
  CHANCE(); // CHANCE
  Push(Pop() + 1); //  1+
  _1_dot_5_at_(); // 1.5@
  ROT(); // ROT
  Pop(); // DROP
}


// ================================================
// 0xe5a4: WORD 'rollem' codep=0x224c wordp=0xe5a6 params=3 returns=1
// ================================================

void rollem() // rollem
{
  unsigned short int i, imax, a;
  Push(0);
  Push(4);
  ROLL(); // ROLL
  Push(4);
  ROLL(); // ROLL
  Push(4);
  ROLL(); // ROLL
  MAPS(); // MAPS

  i = Pop();
  imax = Pop();
  do // (DO)
  {
    Push(i); // I
    _2_at_(); // 2@
    Push(3);
    PICK(); // PICK
    Push((Pop()==Pop())?1:0); // =
    a = Pop(); // >R
    Push(3);
    PICK(); // PICK
    Push((Pop()==Pop())?1:0); // =
    Push(Pop() & a); //  R> AND
    if (Pop() != 0)
    {
      Push(i); // I
      Push(4);
      ROLL(); // ROLL
      Pop(); // DROP
      ROT(); // ROT
      ROT(); // ROT
      imax = i; // LEAVE
    }
    Push(6);
    int step = Pop();
    i += step;
    if (((step>=0) && (i>=imax)) || ((step<0) && (i<=imax))) break;
  } while(1); // (+LOOP)

  Pop(); Pop(); // 2DROP
  if (Read16(regsp) != 0) Push(Read16(regsp)); // ?DUP
  if (Pop() != 0)
  {
    Push(Read16(Pop() + 4)); //  4 + @
    return;
  }
  Push(-1);
}


// ================================================
// 0xe5fc: WORD 'retrieve' codep=0x224c wordp=0xe5fe params=4 returns=2
// ================================================

void retrieve() // retrieve
{
  rollem(); // rollem
  Push(Read16(regsp)); // DUP
  Push(Pop()==-1?1:0); //  -1 =
  if (Pop() != 0)
  {
    Pop(); Pop(); // 2DROP
    Push(0);
    Push(0);
    return;
  }
  result(); // result
}


// ================================================
// 0xe618: WORD 'ADDITIONS' codep=0x1d29 wordp=0xe626
// ================================================
// 0xe626: db 0x9c 0x00 0x01 0x00 0x17 0xcd 0xc4 0xe6 0x01 0x00 0x62 0xcd 0xe4 0xe6 0x01 0x00 0xba 0xcb 0x08 0xe7 0x01 0x00 0xcb 0xcb 0x54 0xe7 0x01 0x00 0x8b 0xcd 0x84 0xe7 0x01 0x00 0xe9 0xde 0xa4 0xe7 0x01 0x00 0xa9 0xcb 0xd4 0xe7 0x01 0x00 0x87 0xcb 0x14 0xe8 0x01 0x00 0x52 0xde 0x3c 0xe8 0x01 0x00 0x18 0xde 0x5c 0xe8 0x01 0x00 0x48 0xdf 0x7c 0xe8 0x01 0x00 0xfe 0xde 0xa8 0xe8 0x01 0x00 0x98 0xcb 0xe0 0xe8 0x01 0x00 0x21 0xdf 0x08 0xe9 0x01 0x00 0xb0 0xcc 0x2c 0xe9 0x01 0x00 0x59 0xdf 0x4c 0xe9 0x01 0x00 0xe1 0xcb 0x98 0xe9 0x01 0x00 0x10 0xcc 0x98 0xe9 0x01 0x00 0x6b 0xdf 0xcc 0xe9 0x01 0x00 0x00 0xcc 0xec 0xe9 0x01 0x00 0x07 0xcd 0x10 0xea 0x01 0x00 0x77 0xde 0x2c 0xea 0x01 0x00 0x8b 0xde 0x6c 0xea 0x01 0x00 0xc4 0xde 0xa4 0xea 0x01 0x00 0xc2 0xdf 0x24 0xeb 0x01 0x00 0x27 0xcd 0x44 0xeb 0x0a 0x2d 0xd5 0x01 0x14 0x0b 0xda 0x01 0x1d 0x98 0xd9 0x01 0x26 0xb2 0xd9 0x01 0x30 0xc6 0xd9 0x01 0x39 0xdb 0xd9 0x01 0x43 0xf8 0xd9 0x01 0x64 0x1c 0xda 0x01 0x09 0x2c 0xd9 0x01 0x12 0x01 0xd5 0x01 0x1b 0x2e 0xda 0x01 0x23 0x5a 0xd9 0x01 0x2c 0x6e 0xd9 0x01 0x35 0x81 0xd9 0x01 0x3d 0x5a 0xd5 0x01 0x46 0xc6 0xd9 0x01 0x64 0xf8 0xd9 0x01 0x05 0x65 0xd8 0x01 0x09 0x75 0xd8 0x01 0x0d 0x8b 0xd8 0x01 0x11 0xc0 0xd4 0x01 0x15 0xa1 0xd8 0x01 0x19 0x18 0xd4 0x01 0x1d 0xb4 0xd8 0x01 0x21 0xdd 0xd8 0x01 0x24 0xf2 0xd8 0x01 0x27 0xd5 0xd4 0x01 0x2a 0x05 0xd9 0x01 0x2d 0x1a 0xd9 0x01 0x30 0x2f 0xd4 0x01 0x33 0x81 0xd9 0x01 0x36 0xb2 0xd9 0x01 0x39 0xc6 0xd9 0x01 0x3d 0xc7 0xd8 0x01 0x41 0xdb 0xd9 0x01 0x64 0xf8 0xd9 0x01 0x07 0xc6 0xd3 0x01 0x0e 0x28 0xd8 0x01 0x15 0xe0 0xd3 0x01 0x1b 0x00 0xd4 0x01 0x21 0x51 0xd8 0x01 0x28 0x1a 0xd9 0x01 0x2f 0x2f 0xd4 0x01 0x35 0x6e 0xd9 0x01 0x3b 0x81 0xd9 0x01 0x42 0x05 0xd9 0x01 0x49 0x3d 0xd8 0x01 0x64 0xd5 0xd4 0x01 0x0a 0x5a 0xd9 0x01 0x14 0x6e 0xd9 0x01 0x1d 0x98 0xd9 0x01 0x26 0xb2 0xd9 0x01 0x30 0x5a 0xd5 0x01 0x39 0xc6 0xd9 0x01 0x43 0xdb 0xd9 0x01 0x64 0xf8 0xd9 0x01 0x07 0xe9 0xd7 0x01 0x0e 0x96 0xd3 0x01 0x15 0x00 0xd8 0x01 0x1b 0x14 0xd8 0x01 0x21 0xdd 0xd8 0x01 0x28 0xf2 0xd8 0x01 0x2f 0x1a 0xd9 0x01 0x35 0x2f 0xd4 0x01 0x3b 0x5a 0xd9 0x01 0x42 0xf8 0xd9 0x01 0x49 0xaf 0xd3 0x01 0x64 0x6e 0xd9 0x01 0x06 0x59 0xd7 0x01 0x0a 0x73 0xd7 0x01 0x0e 0x86 0xd7 0x01 0x13 0x98 0xd7 0x01 0x17 0xac 0xd7 0x01 0x1b 0xbf 0xd7 0x01 0x20 0xd7 0xd7 0x01 0x24 0x00 0xd8 0x01 0x28 0x14 0xd8 0x01 0x2d 0xc7 0xd8 0x01 0x31 0x7c 0xd3 0x01 0x35 0xdd 0xd8 0x01 0x3a 0xf2 0xd8 0x01 0x3f 0x2f 0xd4 0x01 0x43 0x5a 0xd9 0x01 0x64 0xf8 0xd9 0x01 0x09 0x86 0xd7 0x01 0x10 0x98 0xd7 0x01 0x18 0xac 0xd7 0x01 0x1f 0xbf 0xd7 0x01 0x27 0xd7 0xd7 0x01 0x2e 0x14 0xd8 0x01 0x36 0xf2 0xd8 0x01 0x3d 0x5a 0xd9 0x01 0x45 0xdb 0xd9 0x01 0x64 0xf8 0xd9 0x01 0x0a 0xac 0xd7 0x01 0x14 0xbf 0xd7 0x01 0x1d 0xd7 0xd7 0x01 0x26 0x14 0xd8 0x01 0x30 0xb4 0xd8 0x01 0x39 0xb2 0xd9 0x01 0x43 0xc6 0xd9 0x01 0x64 0xdb 0xd9 0x01 0x0a 0x2f 0xd7 0x01 0x14 0xeb 0xd4 0x01 0x1d 0xa9 0xd4 0x01 0x26 0x7c 0xd3 0x01 0x30 0xbf 0xd7 0x01 0x39 0xd7 0xd7 0x01 0x43 0x14 0xd8 0x01 0x64 0x92 0xd4 0x01 0x08 0x73 0xd7 0x01 0x0f 0x14 0xd8 0x01 0x15 0x18 0xd4 0x01 0x1b 0xdd 0xd8 0x01 0x21 0xf2 0xd8 0x01 0x28 0x05 0xd9 0x01 0x2f 0x01 0xd5 0x01 0x35 0x43 0xd9 0x01 0x3b 0x6e 0xd9 0x01 0x41 0xc6 0xd9 0x01 0x64 0xdb 0xd9 0x01 0x06 0xf3 0xd6 0x01 0x0c 0x07 0xd7 0x01 0x11 0x32 0xd3 0x01 0x16 0x4a 0xd3 0x01 0x1c 0x62 0xd3 0x01 0x21 0x14 0xd8 0x01 0x26 0xa1 0xd8 0x01 0x2c 0x18 0xd4 0x01 0x31 0xb4 0xd8 0x01 0x37 0xd5 0xd4 0x01 0x3d 0x05 0xd9 0x01 0x42 0x43 0xd9 0x01 0x48 0x5a 0xd9 0x01 0x64 0xf8 0xd9 0x01 0x09 0xdc 0xd6 0x01 0x10 0xeb 0xd4 0x01 0x18 0xac 0xd7 0x01 0x1f 0x00 0xd8 0x01 0x27 0x14 0xd8 0x01 0x2e 0xdd 0xd8 0x01 0x36 0xf2 0xd8 0x01 0x3d 0x5a 0xd9 0x01 0x45 0x59 0xd7 0x01 0x64 0x14 0xd8 0x01 0x09 0xdc 0xd6 0x01 0x12 0x86 0xd7 0x01 0x1b 0x98 0xd7 0x01 0x23 0x14 0xd8 0x01 0x2c 0x51 0xd8 0x01 0x35 0x43 0xd9 0x01 0x3d 0x81 0xd9 0x01 0x46 0xc6 0xd9 0x01 0x64 0xf8 0xd9 0x01 0x0a 0xdc 0xd6 0x01 0x14 0x86 0xd7 0x01 0x1d 0x98 0xd7 0x01 0x26 0x14 0xd8 0x01 0x30 0x51 0xd8 0x01 0x39 0x43 0xd9 0x01 0x43 0x81 0xd9 0x01 0x64 0xf8 0xd9 0x01 0x05 0x7a 0xd6 0x01 0x09 0x90 0xd6 0x01 0x0d 0xa3 0xd6 0x01 0x11 0xb5 0xd6 0x01 0x15 0xcb 0xd6 0x01 0x19 0x1a 0xd3 0x01 0x1d 0x32 0xd3 0x01 0x21 0x4a 0xd3 0x01 0x24 0x62 0xd3 0x01 0x27 0x5a 0xd9 0x01 0x2a 0x59 0xd7 0x01 0x2d 0x98 0xd7 0x01 0x30 0xe0 0xd3 0x01 0x33 0xc7 0xd8 0x01 0x36 0x2f 0xd4 0x01 0x39 0x73 0xd7 0x01 0x3d 0x00 0xd4 0x01 0x41 0x6e 0xd9 0x01 0x64 0xb2 0xd9 0x01 0x07 0x28 0xd8 0x01 0x0d 0x3d 0xd8 0x01 0x12 0x51 0xd8 0x01 0x17 0xc0 0xd4 0x01 0x1d 0xd5 0xd4 0x01 0x23 0x05 0xd9 0x01 0x28 0x2c 0xd9 0x01 0x2d 0x6e 0xd9 0x01 0x33 0x81 0xd9 0x01 0x39 0x2d 0xd5 0x01 0x3e 0x5a 0xd9 0x01 0x43 0x5a 0xd5 0x01 0x64 0xf8 0xd9 0x01 0x0a 0x5e 0xd6 0x01 0x14 0x1a 0xd7 0x01 0x1d 0x73 0xd7 0x01 0x26 0xc0 0xd4 0x01 0x30 0xd5 0xd4 0x01 0x39 0x6e 0xd9 0x01 0x43 0x81 0xd9 0x01 0x64 0x05 0xd9 0x01 0x09 0x65 0xd4 0x01 0x12 0x1a 0xd3 0x01 0x1b 0x07 0xd7 0x01 0x23 0x14 0xd8 0x01 0x2c 0xa1 0xd8 0x01 0x35 0x18 0xd4 0x01 0x3d 0x05 0xd9 0x01 0x46 0x81 0xd9 0x01 0x64 0xdc 0xd6 0x01 0x0c 0x32 0xd6 0x01 0x16 0x47 0xd6 0x01 0x20 0x65 0xd4 0x01 0x2b 0xcb 0xd6 0x01 0x36 0xdc 0xd6 0x01 0x40 0x62 0xd3 0x01 0x64 0x3d 0xd8 0x01 0x06 0x01 0xd3 0x01 0x0a 0xc7 0xd5 0x01 0x0e 0xb5 0xd6 0x01 0x13 0x1a 0xd3 0x01 0x17 0x07 0xd7 0x01 0x1b 0x4a 0xd3 0x01 0x20 0x41 0xd7 0x01 0x24 0x62 0xd3 0x01 0x28 0xc6 0xd3 0x01 0x2d 0x00 0xd4 0x01 0x31 0x18 0xd4 0x01 0x35 0x5e 0xd6 0x01 0x3a 0x81 0xd9 0x01 0x3f 0x32 0xd3 0x01 0x43 0x05 0xd9 0x01 0x64 0x59 0xd7 0x01 0x06 0x90 0xd6 0x01 0x0c 0xa3 0xd6 0x01 0x11 0xcb 0xd6 0x01 0x16 0x4a 0xd3 0x01 0x1c 0x62 0xd3 0x01 0x21 0xc6 0xd3 0x01 0x26 0x28 0xd8 0x01 0x2c 0x00 0xd4 0x01 0x31 0x51 0xd8 0x01 0x37 0xf2 0xd8 0x01 0x3d 0xaf 0xd3 0x01 0x42 0x2c 0xd9 0x01 0x48 0x5a 0xd9 0x01 0x64 0x6e 0xd9 0x01 0x03 0xe6 0xd2 0x01 0x06 0xb4 0xd5 0x01 0x08 0xc7 0xd5 0x01 0x0a 0x06 0xd6 0x01 0x0d 0x1b 0xd6 0x01 0x0f 0x7a 0xd6 0x01 0x11 0xa3 0xd6 0x01 0x14 0xb5 0xd6 0x01 0x16 0xcb 0xd6 0x01 0x18 0x1a 0xd3 0x01 0x1b 0x07 0xd7 0x01 0x1d 0x32 0xd3 0x01 0x1f 0x59 0xd7 0x01 0x22 0xbf 0xd7 0x01 0x24 0x96 0xd3 0x01 0x26 0xaf 0xd3 0x01 0x29 0x14 0xd8 0x01 0x2b 0x28 0xd8 0x01 0x2d 0xa1 0xd8 0x01 0x30 0xc7 0xd8 0x01 0x32 0xf2 0xd8 0x01 0x34 0x2f 0xd4 0x01 0x37 0x6e 0xd9 0x01 0x39 0x81 0xd9 0x01 0x3c 0x05 0xd9 0x01 0x3f 0x01 0xd3 0x01 0x41 0x62 0xd3 0x01 0x44 0x4a 0xd3 0x01 0x47 0x7c 0xd3 0x01 0x49 0x00 0xd4 0x01 0x4c 0x18 0xd4 0x01 0x64 0x1a 0xd9 0x01 0x0a 0x1b 0xd6 0x01 0x14 0xcb 0xd6 0x01 0x1d 0x41 0xd7 0x01 0x26 0x98 0xd7 0x01 0x30 0x28 0xd8 0x01 0x39 0xe0 0xd3 0x01 0x43 0x51 0xd8 0x01 0x64 0x5a 0xd9 0x01 0x10 0xdd 0xd5 0x01 0x1f 0xf3 0xd5 0x01 0x2e 0x4e 0xd4 0x01 0x3d 0x06 0xd6 0x01 0x64 0x1b 0xd6 0x01 '          b             T                           R <     \   H |               !       ,   Y L               k                 w ,     l           $   ' D  -          &   0   9   C   d    ,       .  #Z  ,n  5   =Z  F   d    e   u                      !   $   '   *   -   0/  3   6   9   =   A   d        (          !Q  (   //  5n  ;   B   I=  d    Z   n      &   0Z  9   C   d                   !   (   /   5/  ;Z  B   I   dn   Y   s                      $   (   -   1|  5   :   ?/  CZ  d                   '   .   6   =Z  E   d               &   0   9   C   d    /          &|  0   9   C   d    s              !   (   /   5C  ;n  A   d            2   J   b  !   &   ,   1   7   =   BC  HZ  d                   '   .   6   =Z  EY  d               #   ,Q  5C  =   F   d               &   0Q  9C  C   d    z                       2  !J  $b  'Z  *Y  -   0   3   6/  9s  =   An  d    (   =   Q          #   (,  -n  3   9-  >Z  CZ  d    ^       s  &   0   9n  C   d    e          #   ,   5   =   F   d    2   G   e  +   6   @b  d=                       J   A  $b  (   -   1   5^  :   ?2  C   dY               J   b  !   &(  ,   1Q  7   =   B,  HZ  dn                       z                       2   Y  "   $   &   )   +(  -   0   2   4/  7n  9   <   ?   Ab  DJ  G|  I   L   d            A  &   0(  9   CQ  dZ          .N  =   d   '

// ================================================
// 0xeb58: WORD 'LIGHTS' codep=0xe4f0 wordp=0xeb63
// ================================================
// 0xeb63: db 0x0c 0x00 0x00 0x00 0x01 0x00 0x71 0xeb 0x00 0x00 0x02 0x00 0x7d 0xeb 0x1a 0xcd 0xca 0x01 0x33 0x19 0xcb 0x01 0x64 0xf2 0xca 0x01 0x0e 0x04 0xcb 0x01 0x1a 0x19 0xcb 0x01 0x27 0x2c 0xcb 0x01 0x33 0x40 0xcb 0x01 0x40 0x58 0xcb 0x01 0x64 0x70 0xcb 0x01 '      q     }     3   d           ',  3@  @X  dp  '

// ================================================
// 0xeb95: WORD '?pure' codep=0x224c wordp=0xeb97 params=2 returns=3
// ================================================

void Ispure() // ?pure
{
  unsigned short int a, b;
  rput(); // rput
  a = Pop(); // >R
  b = Pop(); // >R
  _2DUP(); // 2DUP
  _gt_C_plus_S(); // >C+S
  GetINST_dash_SPECIES(); // @INST-SPECIES
  Push(Pop()==7?1:0); //  7 =
  ICLOSE(); // ICLOSE
  Push(b); // R>
  Push(a); // R>
  rget(); // rget
}


// ================================================
// 0xebb1: WORD 'squish' codep=0x224c wordp=0xebb3
// ================================================

void squish() // squish
{
  unsigned short int a;
  Push(Read16(pp_RECORD_n_)); // RECORD# @
  a = Pop(); // >R
  Push(pp__ro_PLANET_rc_); // (PLANET)
  _1_dot_5_at_(); // 1.5@
  _gt_C_plus_S(); // >C+S
  LoadData(flattest); // from 'PLANET'
  Push(Read16(Pop())&0xFF); //  C@
  LoadData(narrowest); // from 'PLANET'
  Push((Read16(Pop())&0xFF) + 1); //  C@ 1+
  RRND(); // RRND
  ICLOSE(); // ICLOSE
  Push(Read16(regsp)); // DUP
  _gt_PROP(); // >PROP
  _1_dot_5_at_(); // 1.5@
  Push(a); // R>
  Push(pp_RECORD_n_); // RECORD#
  Store_3(); // !_3
  whichguy(); // whichguy
  LoadData(proportion); // from 'CREATURE'
  _1_dot_5_ex_(); // 1.5!
  LoadData(volume); // from 'CREATURE'
  Store_3(); // !_3
}


// ================================================
// 0xebe5: WORD 'madness' codep=0x224c wordp=0xebe7 params=1 returns=2
// ================================================

void madness() // madness
{
  Push(2);
  OVER(); // OVER
  Push((Pop()==Pop())?1:0); // =
  if (Pop() != 0)
  {
    Pop(); // DROP
    Push(1);
    Push(0x000a);
    return;
  }
  Push(4);
  OVER(); // OVER
  Push((Pop()==Pop())?1:0); // =
  if (Pop() != 0)
  {
    Pop(); // DROP
    Push(1);
    Push(0x003c);
    return;
  }
  Push(6);
  OVER(); // OVER
  Push((Pop()==Pop())?1:0); // =
  if (Pop() != 0)
  {
    Pop(); // DROP
    Push(1);
    Push(0x003c);
    return;
  }
  Push(0x0032);
  Push(0x0064);
  ROT(); // ROT
  Pop(); // DROP
}


// ================================================
// 0xec3d: WORD 'anger' codep=0x224c wordp=0xec3f
// ================================================

void anger() // anger
{
  LoadData(niche); // from 'CREATURE'
  Push(Read16(Pop())&0xFF); //  C@
  madness(); // madness
  Push(0x0080);
  Push(pp_PEAK); // PEAK
  Store_3(); // !_3
  slip_ex_(); // slip!
  LoadData(a_dot_level); // from 'CREATURE'
  C_ex_(); // C!
}


// ================================================
// 0xec55: WORD 'strength-rule' codep=0x224c wordp=0xec57
// ================================================

void strength_dash_rule() // strength-rule
{
  Push(0);
  Push(pp_PEAK); // PEAK
  Store_3(); // !_3
  Push(0);
  Push(0x0055);
  slip_ex_(); // slip!
  LoadData(size_dot_index); // from 'CREATURE'
  Push((Read16(Pop())&0xFF) * 0x0012); //  C@ 0x0012 *
  LoadData(a_dot_level); // from 'CREATURE'
  Push((Read16(Pop())&0xFF) >> 1); //  C@ 2/
  Push(Pop() + Pop()); // +
  Push(Pop() + Pop()); // +
  Push(3);
  _slash_(); // /
}


// ================================================
// 0xec7f: WORD 'durable' codep=0x224c wordp=0xec81
// ================================================

void durable() // durable
{
  strength_dash_rule(); // strength-rule
  LoadData(hit_dot_points); // from 'CREATURE'
  C_ex_(); // C!
}


// ================================================
// 0xec89: WORD 'stunable' codep=0x224c wordp=0xec8b
// ================================================

void stunable() // stunable
{
  strength_dash_rule(); // strength-rule
  LoadData(stun_dot_effect); // from 'CREATURE'
  C_ex_(); // C!
}


// ================================================
// 0xec93: WORD 'movers' codep=0x224c wordp=0xec95
// ================================================

void movers() // movers
{
  LoadData(g_dot_mobility); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Is2dup(); // ?2dup
  Push(Pop() | Pop()); // OR
  if (Pop() != 0)
  {
    _2DUP(); // 2DUP
    Push(0xe238); Push(0x0001); // 'SESSILE'
    D_eq_(); // D=
    Push(Pop()==0?1:0); //  0=
    if (Pop() != 0)
    {
      Push(0);
      _gt_MOVER(); // >MOVER
      lookup(); // lookup
    } else
    {
      Pop(); Pop(); // 2DROP
      Push(0);
    }
  } else
  {
    Push(0);
  }
  LoadData(slowest); // from 'CREATURE'
  C_ex_(); // C!
  LoadData(a_dot_mobility); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Is2dup(); // ?2dup
  Push(Pop() | Pop()); // OR
  if (Pop() != 0)
  {
    Push(0xe1fb); Push(0x0001); // 'FLOATING'
    D_eq_(); // D=
    if (Pop() != 0)
    {
      Push(5);
    } else
    {
      Push(0x000a);
    }
  } else
  {
    Push(0);
  }
  LoadData(fastest); // from 'CREATURE'
  C_ex_(); // C!
}


// ================================================
// 0xecf7: WORD '(modify)' codep=0x224c wordp=0xecf9
// ================================================

void _ro_modify_rc_() // (modify)
{
  unsigned short int a, b;
  IFLD_at_(); // IFLD@
  a = Pop(); // >R
  b = Pop(); // >R
  Push(0);
  Push(Read16(regsp)); // DUP
  Push(b); // I
  Push(a); // I'
  D_eq_(); // D=
  Push(b); // R>
  Push(a); // R>
  Push(0xdf48); Push(0x0001); // 'TAIL'
  D_eq_(); // D=
  Push(Pop() | Pop()); // OR
  Push(!Pop()); //  NOT
  if (Pop() != 0)
  {
    Push(1);
    Push(0x000e);
    RRND(); // RRND
    _gt_PROP(); // >PROP
    _1_dot_5_at_(); // 1.5@
    ROT(); // ROT
    IFLD_ex_(); // IFLD!
    return;
  }
  Pop(); // DROP
}


// ================================================
// 0xed35: WORD 'modify' codep=0x224c wordp=0xed37
// ================================================

void modify() // modify
{
  Push(0xe3e6); // 'd.propor'
  Push(0xe33e); // 'd.append'
  _ro_modify_rc_(); // (modify)
  Push(0xe416); // 'w.propor'
  Push(0xe32e); // 'w.append'
  _ro_modify_rc_(); // (modify)
  Push(0xe446); // 'a.propor'
  Push(0xe34e); // 'a.append'
  _ro_modify_rc_(); // (modify)
  Push(0xe476); // 'g.propor'
  Push(0xe35e); // 'g.append'
  _ro_modify_rc_(); // (modify)
}


// ================================================
// 0xed61: WORD 'customize' codep=0x224c wordp=0xed63 params=4 returns=0
// ================================================

void customize() // customize
{
  unsigned short int a;
  Ispure(); // ?pure
  a = Pop(); // >R
  Pop(); Pop(); // 2DROP
  Push(a); // R>
  if (Pop() != 0)
  {
    coin(); // coin
    if (Pop() != 0)
    {
      rand_pe_(); // rand%
      Push(1);
      Push(0);
      LIGHTS(); // LIGHTS
      result(); // result
      ROT(); // ROT
      IFLD_ex_(); // IFLD!
      Pop(); // DROP
    } else
    {
      coin(); // coin
      if (Pop() != 0)
      {
        Pop(); // DROP
        rand_pe_(); // rand%
        Push(2);
        Push(0);
        LIGHTS(); // LIGHTS
        result(); // result
        ROT(); // ROT
        IFLD_ex_(); // IFLD!
      } else
      {
        Pop(); Pop(); // 2DROP
      }
    }
    return;
  }
  Pop(); Pop(); // 2DROP
}


// ================================================
// 0xedad: WORD 'colorant' codep=0x224c wordp=0xedaf
// ================================================

void colorant() // colorant
{
  unsigned short int a;
  Push(Read16(pp_RECORD_n_)); // RECORD# @
  a = Pop(); // >R
  LoadData(reddest); // from 'CREATURE'
  Push(Read16(Pop())&0xFF); //  C@
  LoadData(bluest); // from 'CREATURE'
  Push((Read16(Pop())&0xFF) + 1); //  C@ 1+
  RRND(); // RRND
  IsCOLOR(); // ?COLOR
  _1_dot_5_at_(); // 1.5@
  _2DUP(); // 2DUP
  LoadData(s_dot_hue); // from 'CREATURE'
  _1_dot_5_ex_(); // 1.5!
  Push2Words("0.");
  LoadData(s_dot_tint); // from 'CREATURE'
  _1_dot_5_ex_(); // 1.5!
  Push2Words("0.");
  LoadData(s_dot_lumens); // from 'CREATURE'
  _1_dot_5_ex_(); // 1.5!
  Push(0xe496); // 's.lumens'
  Push(0xe48e); // 's.tint'
  Push(a); // R>
  Push(pp_RECORD_n_); // RECORD#
  Store_3(); // !_3
  whichguy(); // whichguy
  _2SWAP(); // 2SWAP
  customize(); // customize
}


// ================================================
// 0xeded: WORD '1image' codep=0x224c wordp=0xedef
// ================================================

void _1image() // 1image
{
  LoadData(g_n_); // from 'CREATURE'
  Push(Read16(Pop())&0xFF); //  C@
  if (Read16(regsp) != 0) Push(Read16(regsp)); // ?DUP
  Push(Pop()==0?1:0); //  0=
  if (Pop() != 0)
  {
    Push(0x000c);
    return;
  }
  Push(Pop() - 3); //  3 -
  _0_st_(); // 0<
  if (Pop() != 0)
  {
    Push(0x000d);
    return;
  }
  Push(0x000e);
}


// ================================================
// 0xee1b: WORD '2image' codep=0x224c wordp=0xee1d
// ================================================

void _2image() // 2image
{
  LoadData(g_n_); // from 'CREATURE'
  Push(Read16(Pop())&0xFF); //  C@
  if (Pop() != 0)
  {
    Push(0x0010);
    return;
  }
  Push(0x000f);
}


// ================================================
// 0xee33: WORD 'PLANT.ICO' codep=0xe4f0 wordp=0xee41
// ================================================
// 0xee41: db 0x12 0x00 0x01 0x00 0x38 0xe2 0x55 0xee 0x01 0x00 0x5c 0xe1 0x6d 0xee 0x00 0x00 0x00 0x00 0x00 0x00 0x0e 0x00 0x00 0x00 0x1a 0x01 0x00 0x00 0x27 0x02 0x00 0x00 0x33 0x03 0x00 0x00 0x40 0x04 0x00 0x00 0x64 0x05 0x00 0x00 0x27 0x04 0x00 0x00 0x64 0x05 0x00 0x00 '    8 U   \ m               '   3   @   d   '   d   '

// ================================================
// 0xee75: WORD '3image' codep=0x224c wordp=0xee77
// ================================================

void _3image() // 3image
{
  coin(); // coin
  LoadData(g_dot_mobility); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(0xe15c); Push(0x0001); // 'CRAWLING'
  D_eq_(); // D=
  if (Pop() != 0)
  {
    if (Pop() != 0)
    {
      Push(4);
    } else
    {
      Push(5);
    }
    return;
  }
  Push(9);
  LoadData(size_dot_index); // from 'CREATURE'
  Push(Read16(Pop())&0xFF); //  C@
  _dash_(); // -
  Push(3);
  _slash_(); // /
  Push(2);
  MIN(); // MIN
  Push(Pop() * 2); //  2*
  Push(Pop() + Pop()); // +
}


// ================================================
// 0xeeaf: WORD '4image' codep=0x224c wordp=0xeeb1
// ================================================

void _4image() // 4image
{
  LoadData(g_n_); // from 'CREATURE'
  Push(Read16(Pop())&0xFF); //  C@
  if (Read16(regsp) != 0) Push(Read16(regsp)); // ?DUP
  Push(Pop()==0?1:0); //  0=
  if (Pop() != 0)
  {
    LoadData(proportion); // from 'CREATURE'
    _1_dot_5_at_(); // 1.5@
    Push(0xe07d); Push(0x0001); // 'ELONGATED'
    D_eq_(); // D=
    if (Pop() != 0)
    {
      Push(6);
    } else
    {
      Push(7);
    }
    return;
  }
  Push(1);
  OVER(); // OVER
  Push((Pop()==Pop())?1:0); // =
  if (Pop() != 0)
  {
    Pop(); // DROP
    Push(8);
    return;
  }
  Push(2);
  OVER(); // OVER
  Push((Pop()==Pop())?1:0); // =
  if (Pop() != 0)
  {
    Pop(); // DROP
    Push(9);
    return;
  }
  Push(3);
  OVER(); // OVER
  Push((Pop()==Pop())?1:0); // =
  if (Pop() != 0)
  {
    Pop(); // DROP
    Push(0x000a);
    return;
  }
  Push(4);
  OVER(); // OVER
  Push((Pop()==Pop())?1:0); // =
  if (Pop() != 0)
  {
    Pop(); // DROP
    Push(0x000a);
    return;
  }
  Push(0x000b);
  SWAP(); // SWAP
  Pop(); // DROP
}


// ================================================
// 0xef2f: WORD 'set.icon' codep=0x224c wordp=0xef31
// ================================================

void set_dot_icon() // set.icon
{
  unsigned short int a, b;
  LoadData(shape); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  _2DUP(); // 2DUP
  Push(0xddc9); Push(0x0001); // 'RADIAL'
  D_eq_(); // D=
  a = Pop(); // >R
  _2DUP(); // 2DUP
  Push(0xddb3); Push(0x0001); // 'SPHERICAL'
  D_eq_(); // D=
  Push(Pop() | a); //  R> OR
  if (Pop() != 0)
  {
    Pop(); Pop(); // 2DROP
    _1image(); // 1image
  } else
  {
    _2DUP(); // 2DUP
    Push(0xdd87); Push(0x0001); // 'AMORPHOUS'
    D_eq_(); // D=
    b = Pop(); // >R
    Push(0xdd9d); Push(0x0001); // 'IRREGULAR'
    D_eq_(); // D=
    Push(Pop() | b); //  R> OR
    if (Pop() != 0)
    {
      _2image(); // 2image
    } else
    {
      LoadData(niche); // from 'CREATURE'
      Push(Read16(Pop())&0xFF); //  C@
      Push(4);
      MOD(); // MOD
      if (Pop() != 0)
      {
        _3image(); // 3image
      } else
      {
        _4image(); // 4image
      }
    }
  }
  LoadData(icon); // from 'CREATURE'
  Store_3(); // !_3
}


// ================================================
// 0xef97: WORD 'colorize' codep=0x224c wordp=0xef99
// ================================================

void colorize() // colorize
{
  IFLD_at_(); // IFLD@
  Push(Pop() | Pop()); // OR
  if (Pop() != 0)
  {
    LoadData(reddest); // from 'CREATURE'
    Push(Read16(Pop())&0xFF); //  C@
    LoadData(bluest); // from 'CREATURE'
    Push((Read16(Pop())&0xFF) + 1); //  C@ 1+
    RRND(); // RRND
    IsCOLOR(); // ?COLOR
    _1_dot_5_at_(); // 1.5@
    _2DUP(); // 2DUP
    Push(5);
    ROLL(); // ROLL
    IFLD_ex_(); // IFLD!
    customize(); // customize
    return;
  }
  Push(0);
  Push(Read16(regsp)); // DUP
  ROT(); // ROT
  IFLD_ex_(); // IFLD!
  Push(0);
  Push(Read16(regsp)); // DUP
  ROT(); // ROT
  IFLD_ex_(); // IFLD!
  Push(0);
  Push(Read16(regsp)); // DUP
  ROT(); // ROT
  IFLD_ex_(); // IFLD!
}


// ================================================
// 0xefd9: WORD 'paint' codep=0x224c wordp=0xefdb
// ================================================

void paint() // paint
{
  Push(0xe436); // 'a.lumens'
  Push(0xe42e); // 'a.tint'
  Push(0xe426); // 'a.hue'
  Push(0xe34e); // 'a.append'
  colorize(); // colorize
  Push(0xe466); // 'g.lumens'
  Push(0xe45e); // 'g.tint'
  Push(0xe456); // 'g.hue'
  Push(0xe35e); // 'g.append'
  colorize(); // colorize
  Push(0xe3d6); // 'd.lumens'
  Push(0xe3ce); // 'd.tint'
  Push(0xe3c6); // 'd.hue'
  Push(0xe33e); // 'd.append'
  colorize(); // colorize
  Push(0xe406); // 'WE406'
  Push(0xe3fe); // 'w.tint'
  Push(0xe3f6); // 'w.hue'
  Push(0xe32e); // 'w.append'
  colorize(); // colorize
}


// ================================================
// 0xf025: WORD 'TALLEST' codep=0xe2cf wordp=0xf031
// ================================================
// 0xf031: db 0x00 0x00 0x0a 0x00 0x23 0x00 0x50 0x00 0xb4 0x00 0x2c 0x01 0x58 0x02 0x09 0x04 0x56 0x05 0xc5 0x06 0x55 0x08 '    # P   , X   V   U '

// ================================================
// 0xf047: WORD 'SHORTEST' codep=0xe2cf wordp=0xf054
// ================================================
// 0xf054: db 0x00 0x00 0x01 0x00 0x0b 0x00 0x24 0x00 0x51 0x00 0xb5 0x00 0x2d 0x01 0x59 0x02 0x0a 0x04 0x57 0x05 0xc6 0x06 '      $ Q   - Y   W   '

// ================================================
// 0xf06a: WORD 'STALKER' codep=0xe2cf wordp=0xf076
// ================================================
// 0xf076: db 0x00 0x00 0x14 0x00 0x46 0x00 0xdc 0x00 0xbc 0x02 0x08 0x07 0x74 0x0e 0xea 0x16 0x1d 0x22 0x91 0x30 0xaa 0x42 '    F       t    " 0 B'

// ================================================
// 0xf08c: WORD 'LOSTALK' codep=0xe2cf wordp=0xf098
// ================================================
// 0xf098: db 0x00 0x00 0x01 0x00 0x15 0x00 0x47 0x00 0xdd 0x00 0xbd 0x02 0x09 0x07 0x75 0x0e 0xeb 0x16 0x1e 0x22 0x92 0x30 '      G       u    " 0'

// ================================================
// 0xf0ae: WORD 'highness' codep=0x224c wordp=0xf0b0
// ================================================

void highness() // highness
{
  unsigned short int a;
  LoadData(size_dot_index); // from 'CREATURE'
  Push(Read16(Pop())&0xFF); //  C@
  LoadData(niche); // from 'CREATURE'
  Push(Read16(Pop())&0xFF); //  C@
  Push(4);
  MOD(); // MOD
  OVER(); // OVER
  OVER(); // OVER
  if (Pop() != 0)
  {
    LOSTALK(); // LOSTALK
  } else
  {
    SHORTEST(); // SHORTEST
  }
  a = Pop(); // >R
  if (Pop() != 0)
  {
    STALKER(); // STALKER
  } else
  {
    TALLEST(); // TALLEST
  }
  Push(a); // R>
  SWAP(); // SWAP
  Push(Pop() + 1); //  1+
  RRND(); // RRND
  Push(Read16(regsp)); // DUP
  LoadData(i_dot_level); // from 'CREATURE'
  Store_3(); // !_3
  LoadData(volume); // from 'CREATURE'
  Push(Read16(Pop())); //  @
  _slash_(); // /
  Push(1);
  MAX(); // MAX
  LoadData(volume); // from 'CREATURE'
  Store_3(); // !_3
}


// ================================================
// 0xf0f8: WORD '(size)' codep=0x224c wordp=0xf0fa
// ================================================

void _ro_size_rc_() // (size)
{
  IFLD_at_(); // IFLD@
  Push(Pop() | Pop()); // OR
  if (Pop() != 0)
  {
    Push(1);
    LoadData(size_dot_index); // from 'CREATURE'
    Push((Read16(Pop())&0xFF) + 1); //  C@ 1+
    RRND(); // RRND
    _gt_SIZE(); // >SIZE
    _1_dot_5_at_(); // 1.5@
  } else
  {
    Push2Words("0.");
  }
  ROT(); // ROT
  IFLD_ex_(); // IFLD!
}


// ================================================
// 0xf11c: WORD 'sizer' codep=0x224c wordp=0xf11e
// ================================================

void sizer() // sizer
{
  Push(0xe47e); // 'g.size'
  Push(0xe35e); // 'g.append'
  _ro_size_rc_(); // (size)
  Push(0xe44e); // 'a.size'
  Push(0xe34e); // 'a.append'
  _ro_size_rc_(); // (size)
  Push(0xe3ee); // 'd.size'
  Push(0xe33e); // 'd.append'
  _ro_size_rc_(); // (size)
  Push(0xe41e); // 'w.size'
  Push(0xe32e); // 'w.append'
  _ro_size_rc_(); // (size)
}


// ================================================
// 0xf148: WORD 'smarts' codep=0x224c wordp=0xf14a
// ================================================

void smarts() // smarts
{
  LoadData(niche); // from 'CREATURE'
  Push(Read16(Pop())&0xFF); //  C@
  madness(); // madness
  Push(0x0080);
  Push(pp_PEAK); // PEAK
  Store_3(); // !_3
  slip_ex_(); // slip!
  LoadData(i_dot_level); // from 'CREATURE'
  C_ex_(); // C!
}


// ================================================
// 0xf160: WORD 'set-size' codep=0x224c wordp=0xf162
// ================================================

void set_dash_size() // set-size
{
  LoadData(size_dot_index); // from 'CREATURE'
  Push(Read16(Pop())&0xFF); //  C@
  Push(1);
  MAX(); // MAX
  Push(9);
  MIN(); // MIN
  _gt_SIZE(); // >SIZE
  _1_dot_5_at_(); // 1.5@
  LoadData(size); // from 'CREATURE'
  _1_dot_5_ex_(); // 1.5!
}


// ================================================
// 0xf178: WORD 'sculpts' codep=0x224c wordp=0xf17a
// ================================================

void sculpts() // sculpts
{
  rand_pe_(); // rand%
  LoadData(d_dot_append); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(pp_ADDITIONS); // ADDITIONS
  retrieve(); // retrieve
  LoadData(d_dot_struc); // from 'CREATURE'
  _1_dot_5_ex_(); // 1.5!
  rand_pe_(); // rand%
  LoadData(w_dot_append); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(pp_ADDITIONS); // ADDITIONS
  retrieve(); // retrieve
  LoadData(w_dot_struc); // from 'CREATURE'
  _1_dot_5_ex_(); // 1.5!
  rand_pe_(); // rand%
  LoadData(g_dot_append); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(pp_ADDITIONS); // ADDITIONS
  retrieve(); // retrieve
  LoadData(g_dot_struc); // from 'CREATURE'
  _1_dot_5_ex_(); // 1.5!
  rand_pe_(); // rand%
  LoadData(a_dot_append); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(pp_ADDITIONS); // ADDITIONS
  retrieve(); // retrieve
  LoadData(a_dot_struc); // from 'CREATURE'
  _1_dot_5_ex_(); // 1.5!
}


// ================================================
// 0xf1b4: WORD '?plant' codep=0x224c wordp=0xf1b6
// ================================================

void Isplant() // ?plant
{
  unsigned short int a, b;
  LoadData(g_dot_append); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(0xdec4); Push(0x0001); // 'LEAVES'
  D_eq_(); // D=
  if (Pop() != 0)
  {
    LoadData(size_dot_index); // from 'CREATURE'
    Push(Read16(Pop())&0xFF); //  C@
    Push(5);
    _st_(); // <
    if (Pop() != 0)
    {
      Push(0xc61f); Push(0x0001); // 'PLANT-LIKE'
    } else
    {
      Push(0xc57b); Push(0x0001); // 'TREE-LIKE'
    }
    return;
  }
  LoadData(a_dot_append); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(0xcbcb); Push(0x0001); // 'FLOAT SAC'
  D_eq_(); // D=
  a = Pop(); // >R
  LoadData(a_n_); // from 'CREATURE'
  Push(((Read16(Pop())&0xFF)==1?1:0) & a); //  C@ 1 = R> AND
  if (Pop() != 0)
  {
    Push(0xc591); Push(0x0001); // 'BALLOON-LIKE'
    return;
  }
  LoadData(g_dot_append); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(0xcd62); Push(0x0001); // 'TENTACLE'
  D_eq_(); // D=
  b = Pop(); // >R
  LoadData(g_n_); // from 'CREATURE'
  Push(Read16(Pop())&0xFF); //  C@
  Push(5);
  _gt_(); // >
  Push(Pop() & b); //  R> AND
  if (Pop() != 0)
  {
    Push(0xc748); Push(0x0001); // 'ANEMONE-LIKE'
    return;
  }
  Push(0x0014);
  rand_pe_(); // rand%
  _st_(); // <
  if (Pop() != 0)
  {
    Push(0xc704); Push(0x0001); // 'FUNGOID'
    return;
  }
  Push(0xc61f); Push(0x0001); // 'PLANT-LIKE'
}


// ================================================
// 0xf254: WORD '?icky' codep=0x224c wordp=0xf256
// ================================================

void Isicky() // ?icky
{
  unsigned short int a, b, c, d;
  LoadData(shape); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(0xdd9d); Push(0x0001); // 'IRREGULAR'
  D_eq_(); // D=
  LoadData(exterior); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  a = Pop(); // >R
  b = Pop(); // >R
  Push(a); // I'
  Push(b); // I
  Push(0xcf93); Push(0x0001); // 'HARD'
  D_eq_(); // D=
  Push(a); // I'
  Push(b); // I
  Push(0xd220); Push(0x0001); // 'ROUGH'
  D_eq_(); // D=
  Push(a); // I'
  Push(b); // I
  Push(0xd0aa); Push(0x0001); // 'COARSE'
  D_eq_(); // D=
  Push(a); // I'
  Push(b); // I
  Push(0xd0f3); Push(0x0001); // 'CRUSTY'
  D_eq_(); // D=
  Push(b); // R>
  Push(a); // R>
  Push(0xd166); Push(0x0001); // 'CRACKED'
  D_eq_(); // D=
  Push(Pop() | Pop()); // OR
  Push(Pop() | Pop()); // OR
  Push(Pop() | Pop()); // OR
  Push(Pop() | Pop()); // OR
  Push(Pop() & Pop()); // AND
  if (Pop() != 0)
  {
    Push(0xc6ee); Push(0x0001); // 'ROCK-LIKE'
    return;
  }
  LoadData(shape); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(0xe07d); Push(0x0001); // 'ELONGATED'
  D_eq_(); // D=
  LoadData(g_n_); // from 'CREATURE'
  Push((Read16(Pop())&0xFF)==0?1:0); //  C@ 0=
  Push(Pop() & Pop()); // AND
  if (Pop() != 0)
  {
    Push(0xc718); Push(0x0001); // 'STARFISH-LIKE'
    return;
  }
  LoadData(shape); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(0xdd1f); Push(0x0001); // 'EXOSKELETON'
  D_eq_(); // D=
  LoadData(g_n_); // from 'CREATURE'
  Push(Read16(Pop())&0xFF); //  C@
  Push(Read16(regsp)); // DUP
  Push(3);
  _gt_(); // >
  SWAP(); // SWAP
  Push(7);
  _st_(); // <
  Push(Pop() & Pop()); // AND
  Push(Pop() & Pop()); // AND
  if (Pop() != 0)
  {
    Push(0xc609); Push(0x0001); // 'INSECTOID'
    return;
  }
  LoadData(proportion); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(0xe093); Push(0x0001); // 'NARROW'
  D_eq_(); // D=
  LoadData(g_dot_append); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(0xcd17); Push(0x0001); // 'LEG'
  D_eq_(); // D=
  c = Pop(); // >R
  LoadData(g_n_); // from 'CREATURE'
  Push(Read16(Pop())&0xFF); //  C@
  Push(4);
  _gt_(); // >
  Push(Pop() & c); //  R> AND
  Push(Pop() & Pop()); // AND
  if (Pop() != 0)
  {
    Push(0xc6be); Push(0x0001); // 'SPIDER-LIKE'
    return;
  }
  LoadData(g_dot_append); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(0xcd17); Push(0x0001); // 'LEG'
  D_eq_(); // D=
  d = Pop(); // >R
  LoadData(d_dot_append); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(0xcd8b); Push(0x0001); // 'ARM'
  D_eq_(); // D=
  Push(Pop() & d); //  R> AND
  LoadData(shape); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(0xdddc); Push(0x0001); // 'BILATERAL'
  D_eq_(); // D=
  Push(Pop() & Pop()); // AND
  if (Pop() != 0)
  {
    Push(0xc5f4); Push(0x0001); // 'HUMANOID'
    return;
  }
  Push(0);
}


// ================================================
// 0xf382: WORD '?something' codep=0x224c wordp=0xf384
// ================================================

void Issomething() // ?something
{
  unsigned short int a;
  LoadData(exterior); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(0xddf2); Push(0x0001); // 'SCALES'
  D_eq_(); // D=
  if (Pop() != 0)
  {
    LoadData(size_dot_index); // from 'CREATURE'
    Push(Read16(Pop())&0xFF); //  C@
    Push(3);
    _gt_(); // >
    if (Pop() != 0)
    {
      Push(0xc5da); Push(0x0001); // 'DINOSAUR-LIKE'
    } else
    {
      LoadData(d_dot_append); // from 'CREATURE'
      _1_dot_5_at_(); // 1.5@
      Push(0xdf59); Push(0x0001); // 'SHELL'
      D_eq_(); // D=
      if (Pop() != 0)
      {
        Push(0xc6d6); Push(0x0001); // 'TURTLE-LIKE'
      } else
      {
        Push(0xc64c); Push(0x0001); // 'REPTILIAN'
      }
    }
    return;
  }
  LoadData(exterior); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(0xd905); Push(0x0001); // 'FEATHERY'
  D_eq_(); // D=
  LoadData(a_dot_append); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(0xcbba); Push(0x0001); // 'WING'
  D_eq_(); // D=
  Push(Pop() & Pop()); // AND
  if (Pop() != 0)
  {
    Push(0xc5c4); Push(0x0001); // 'BIRD-LIKE'
    return;
  }
  LoadData(texture); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(0xceb6); Push(0x0001); // 'MUCOUSY'
  D_eq_(); // D=
  if (Pop() != 0)
  {
    LoadData(d_dot_append); // from 'CREATURE'
    _1_dot_5_at_(); // 1.5@
    Push(0xdf59); Push(0x0001); // 'SHELL'
    D_eq_(); // D=
    if (Pop() != 0)
    {
      Push(0xc690); Push(0x0001); // 'SNAIL-LIKE'
    } else
    {
      Push(0xc67a); Push(0x0001); // 'SLUG-LIKE'
    }
    return;
  }
  LoadData(exterior); // from 'CREATURE'
  _1_dot_5_at_(); // 1.5@
  Push(0xe000); Push(0x0001); // 'FUR'
  D_eq_(); // D=
  if (Pop() != 0)
  {
    LoadData(size_dot_index); // from 'CREATURE'
    Push(3);
    _st_(); // <
    if (Pop() != 0)
    {
      Push(0xc662); Push(0x0001); // 'RODENT-LIKE'
    } else
    {
      LoadData(g_dot_append); // from 'CREATURE'
      _1_dot_5_at_(); // 1.5@
      Push(0xcd17); Push(0x0001); // 'LEG'
      D_eq_(); // D=
      a = Pop(); // >R
      LoadData(g_n_); // from 'CREATURE'
      Push(Read16(Pop())&0xFF); //  C@
      Push(Read16(regsp)); // DUP
      Push(Pop()==3?1:0); //  3 =
      SWAP(); // SWAP
      Push(Pop()==4?1:0); //  4 =
      Push(Pop() | Pop()); // OR
      Push(Pop() & a); //  R> AND
      if (Pop() != 0)
      {
        LoadData(proportion); // from 'CREATURE'
        _1_dot_5_at_(); // 1.5@
        _2DUP(); // 2DUP
        _2DUP(); // 2DUP
        Push(0xe059); Push(0x0001); // 'THICK'
        D_eq_(); // D=
        _2SWAP(); // 2SWAP
        Push(0xe06b); Push(0x0001); // 'SQUAT'
        D_eq_(); // D=
        Push(Pop() | Pop()); // OR
        if (Pop() != 0)
        {
          Pop(); // DROP
          Push(0xc636); Push(0x0001); // 'BEAR-LIKE'
        } else
        {
          Push(0);
          _gt_PROP(); // >PROP
          lookup(); // lookup
          Push(8);
          _gt_(); // >
          if (Pop() != 0)
          {
            Push(0xc5aa); Push(0x0001); // 'ANTELOPE-LIKE'
          } else
          {
            Push2Words("0.");
          }
        }
      } else
      {
        Push2Words("0.");
      }
    }
    return;
  }
  Push2Words("0.");
}


// ================================================
// 0xf4ca: WORD 'similarity' codep=0x224c wordp=0xf4cc
// ================================================

void similarity() // similarity
{
  LoadData(niche); // from 'CREATURE'
  Push(Read16(Pop())&0xFF); //  C@
  Push(4);
  MOD(); // MOD
  if (Pop() != 0)
  {
    Isplant(); // ?plant
  } else
  {
    Isicky(); // ?icky
    if (Read16(regsp) != 0) Push(Read16(regsp)); // ?DUP
    Push(Pop()==0?1:0); //  0=
    if (Pop() != 0)
    {
      Issomething(); // ?something
    }
  }
  LoadData(resembles); // from 'CREATURE'
  _1_dot_5_ex_(); // 1.5!
}


// ================================================
// 0xf4f0: WORD 'SPEC.PARM' codep=0x224c wordp=0xf4fe
// ================================================
// entry

void SPEC_dot_PARM() // SPEC.PARM
{
  whichguy(); // whichguy
  Push(Read16(pp_RECORD_n_)); // RECORD# @
  Push(pp_SEED); // SEED
  _st__ex__gt_(); // <!>
  set_dash_size(); // set-size
  squish(); // squish
  anger(); // anger
  durable(); // durable
  stunable(); // stunable
  movers(); // movers
  set_dot_icon(); // set.icon
  highness(); // highness
  smarts(); // smarts
  sculpts(); // sculpts
  similarity(); // similarity
  modify(); // modify
  colorant(); // colorant
  paint(); // paint
  sizer(); // sizer
}

// 0xf528: db 0x4c 0x4f 0x50 0x41 0x52 0x4d 0x53 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x32 0x32 0x31 0x38 0x2d 0x2d 0x2d 0x2d 0x00 'LOPARMS________________________________---------2218---- '

