// =================================
// =========== Dictionary ==========
// =================================

typedef struct { int ov; unsigned short code, word; char immediate; unsigned char flags; char* name; } WORD;

WORD dictionary[]=
{
  { .ov = -1, .code = 0x0138, .word = 0x0138, .immediate=0, .flags=0x80, .name = "(!SET)" },
  { .ov = -1, .code = 0x0160, .word = 0x0160, .immediate=0, .flags=0x80, .name = "(!OLD)" },
  { .ov = -1, .code = 0x1d29, .word = 0x0188, .immediate=0, .flags=0x80, .name = "(TIME)" },
  { .ov = -1, .code = 0x01fa, .word = 0x01fa, .immediate=0, .flags=0x80, .name = "SET0/" },
  { .ov = -1, .code = 0x224c, .word = 0x0222, .immediate=0, .flags=0x80, .name = "(RESTORE)" },
  { .ov = -1, .code = 0x224c, .word = 0x0279, .immediate=0, .flags=0x80, .name = "AUTO-CACHE" },
  { .ov = -1, .code = 0x224c, .word = 0x02c2, .immediate=0, .flags=0x80, .name = "AUTO-LIMIT" },
  { .ov = -1, .code = 0x224c, .word = 0x02f6, .immediate=0, .flags=0x80, .name = "AUTO-SCREEN" },
  { .ov = -1, .code = 0x224c, .word = 0x0339, .immediate=0, .flags=0x80, .name = "COLD" },
  { .ov = -1, .code = 0x224c, .word = 0x0343, .immediate=0, .flags=0x00, .name = "W0343" },
  { .ov = -1, .code = 0x224c, .word = 0x03c3, .immediate=0, .flags=0x00, .name = "W03C3" },
  { .ov = -1, .code = 0x224c, .word = 0x03db, .immediate=0, .flags=0x80, .name = "SET-BUFFERS" },
  { .ov = -1, .code = 0x1792, .word = 0x040d, .immediate=0, .flags=0x80, .name = "SP0" },
  { .ov = -1, .code = 0x1792, .word = 0x0416, .immediate=0, .flags=0x80, .name = "R0" },
  { .ov = -1, .code = 0x1792, .word = 0x041f, .immediate=0, .flags=0x80, .name = "DP" },
  { .ov = -1, .code = 0x1792, .word = 0x042b, .immediate=0, .flags=0x80, .name = "FENCE" },
  { .ov = -1, .code = 0x1792, .word = 0x0438, .immediate=0, .flags=0x80, .name = "(INTO)" },
  { .ov = -1, .code = 0x1792, .word = 0x0447, .immediate=0, .flags=0x80, .name = "MSGFLAGS" },
  { .ov = -1, .code = 0x1792, .word = 0x0456, .immediate=0, .flags=0x80, .name = "VOC-LINK" },
  { .ov = -1, .code = 0x1792, .word = 0x0465, .immediate=0, .flags=0x80, .name = "USERSIZE" },
  { .ov = -1, .code = 0x1792, .word = 0x0474, .immediate=0, .flags=0x80, .name = "USERNEXT" },
  { .ov = -1, .code = 0x1792, .word = 0x047e, .immediate=0, .flags=0x80, .name = ">IN" },
  { .ov = -1, .code = 0x1792, .word = 0x0488, .immediate=0, .flags=0x80, .name = "TIB" },
  { .ov = -1, .code = 0x1792, .word = 0x0498, .immediate=0, .flags=0x80, .name = "VIDEOPORT" },
  { .ov = -1, .code = 0x1792, .word = 0x04a7, .immediate=0, .flags=0x80, .name = "VIDEOMEM" },
  { .ov = -1, .code = 0x1792, .word = 0x04b7, .immediate=0, .flags=0x80, .name = "CURSORLOC" },
  { .ov = -1, .code = 0x1792, .word = 0x04c1, .immediate=0, .flags=0x80, .name = "ROW" },
  { .ov = -1, .code = 0x1792, .word = 0x04cb, .immediate=0, .flags=0x80, .name = "COL" },
  { .ov = -1, .code = 0x1792, .word = 0x04d8, .immediate=0, .flags=0x80, .name = "ROWMIN" },
  { .ov = -1, .code = 0x1792, .word = 0x04e5, .immediate=0, .flags=0x80, .name = "COLMIN" },
  { .ov = -1, .code = 0x1792, .word = 0x04f2, .immediate=0, .flags=0x80, .name = "ROWMAX" },
  { .ov = -1, .code = 0x1792, .word = 0x04ff, .immediate=0, .flags=0x80, .name = "COLMAX" },
  { .ov = -1, .code = 0x1792, .word = 0x050f, .immediate=0, .flags=0x80, .name = "ATTRIBUTE" },
  { .ov = -1, .code = 0x1792, .word = 0x051d, .immediate=0, .flags=0x80, .name = "DOFFSET" },
  { .ov = -1, .code = 0x1792, .word = 0x052e, .immediate=0, .flags=0x80, .name = "SERIALPORT" },
  { .ov = -1, .code = 0x1792, .word = 0x0541, .immediate=0, .flags=0x80, .name = "PARALLELPORT" },
  { .ov = -1, .code = 0x1792, .word = 0x054c, .immediate=0, .flags=0x80, .name = "BASE" },
  { .ov = -1, .code = 0x1792, .word = 0x0556, .immediate=0, .flags=0x80, .name = "BLK" },
  { .ov = -1, .code = 0x1792, .word = 0x0560, .immediate=0, .flags=0x80, .name = "DPL" },
  { .ov = -1, .code = 0x1792, .word = 0x056a, .immediate=0, .flags=0x80, .name = "FLD" },
  { .ov = -1, .code = 0x1792, .word = 0x0574, .immediate=0, .flags=0x80, .name = "HLD" },
  { .ov = -1, .code = 0x1792, .word = 0x057d, .immediate=0, .flags=0x80, .name = "R#" },
  { .ov = -1, .code = 0x1792, .word = 0x0587, .immediate=0, .flags=0x80, .name = "SCR" },
  { .ov = -1, .code = 0x1792, .word = 0x0592, .immediate=0, .flags=0x80, .name = "SSCR" },
  { .ov = -1, .code = 0x1792, .word = 0x059e, .immediate=0, .flags=0x80, .name = "STATE" },
  { .ov = -1, .code = 0x1792, .word = 0x05ac, .immediate=0, .flags=0x80, .name = "CONTEXT" },
  { .ov = -1, .code = 0x1792, .word = 0x05b6, .immediate=0, .flags=0x80, .name = "CSP" },
  { .ov = -1, .code = 0x1792, .word = 0x05c4, .immediate=0, .flags=0x80, .name = "CURRENT" },
  { .ov = -1, .code = 0x1792, .word = 0x05d1, .immediate=0, .flags=0x80, .name = "LFALEN" },
  { .ov = -1, .code = 0x1792, .word = 0x05e1, .immediate=0, .flags=0x80, .name = "LOWERCASE" },
  { .ov = -1, .code = 0x1792, .word = 0x05f3, .immediate=0, .flags=0x80, .name = "SEARCHORDER" },
  { .ov = -1, .code = 0x1792, .word = 0x05ff, .immediate=0, .flags=0x80, .name = "WIDTH" },
  { .ov = -1, .code = 0x17b7, .word = 0x060b, .immediate=0, .flags=0x80, .name = "-FIND" },
  { .ov = -1, .code = 0x17b7, .word = 0x061b, .immediate=0, .flags=0x80, .name = "?TERMINAL" },
  { .ov = -1, .code = 0x17b7, .word = 0x0627, .immediate=0, .flags=0x80, .name = "ABORT" },
  { .ov = -1, .code = 0x17b7, .word = 0x0632, .immediate=0, .flags=0x80, .name = "BELL" },
  { .ov = -1, .code = 0x17b7, .word = 0x063b, .immediate=0, .flags=0x80, .name = "BS" },
  { .ov = -1, .code = 0x17b7, .word = 0x0644, .immediate=0, .flags=0x80, .name = "CR" },
  { .ov = -1, .code = 0x17b7, .word = 0x0651, .immediate=0, .flags=0x80, .name = "CREATE" },
  { .ov = -1, .code = 0x17b7, .word = 0x0662, .immediate=0, .flags=0x80, .name = "DISKERROR?" },
  { .ov = -1, .code = 0x17b7, .word = 0x066d, .immediate=0, .flags=0x80, .name = "EMIT" },
  { .ov = -1, .code = 0x17b7, .word = 0x067a, .immediate=0, .flags=0x80, .name = "EXPECT" },
  { .ov = -1, .code = 0x17b7, .word = 0x068a, .immediate=0, .flags=0x80, .name = "INTERPRET" },
  { .ov = -1, .code = 0x17b7, .word = 0x0697, .immediate=0, .flags=0x80, .name = "LINKS>" },
  { .ov = -1, .code = 0x17b7, .word = 0x06a2, .immediate=0, .flags=0x80, .name = "LOAD_2" },
  { .ov = -1, .code = 0x17b7, .word = 0x06ac, .immediate=0, .flags=0x80, .name = "KEY_1" },
  { .ov = -1, .code = 0x17b7, .word = 0x06b9, .immediate=0, .flags=0x80, .name = "NUMBER" },
  { .ov = -1, .code = 0x17b7, .word = 0x06c4, .immediate=0, .flags=0x80, .name = "PAGE" },
  { .ov = -1, .code = 0x17b7, .word = 0x06d3, .immediate=0, .flags=0x80, .name = "POSITION" },
  { .ov = -1, .code = 0x17b7, .word = 0x06dd, .immediate=0, .flags=0x80, .name = "R/W" },
  { .ov = -1, .code = 0x17b7, .word = 0x06e8, .immediate=0, .flags=0x80, .name = "TYPE" },
  { .ov = -1, .code = 0x17b7, .word = 0x06f4, .immediate=0, .flags=0x80, .name = "WHERE" },
  { .ov = -1, .code = 0x17b7, .word = 0x06ff, .immediate=0, .flags=0x80, .name = "WORD" },
  { .ov = -1, .code = 0x1d29, .word = 0x078c, .immediate=0, .flags=0x80, .name = "OPERATOR" },
  { .ov = -1, .code = 0x1ab5, .word = 0x081a, .immediate=1, .flags=0x80, .name = "FORTH" },
  { .ov = -1, .code = 0x224c, .word = 0x0833, .immediate=0, .flags=0x80, .name = "FREEZE" },
  { .ov = -1, .code = 0x224c, .word = 0x085d, .immediate=0, .flags=0x80, .name = "BYE_2" },
  { .ov = -1, .code = 0x224c, .word = 0x0872, .immediate=0, .flags=0x80, .name = "CHANGE" },
  { .ov = -1, .code = 0x224c, .word = 0x08dd, .immediate=0, .flags=0x80, .name = "(SETUP)" },
  { .ov = -1, .code = 0x224c, .word = 0x0939, .immediate=0, .flags=0x00, .name = "W0939" },
  { .ov = -1, .code = 0x2214, .word = 0x099a, .immediate=0, .flags=0x80, .name = "BL" },
  { .ov = -1, .code = 0x2214, .word = 0x09a4, .immediate=0, .flags=0x80, .name = "C/L" },
  { .ov = -1, .code = 0x2214, .word = 0x09b5, .immediate=0, .flags=0x80, .name = "INIT-FORTH" },
  { .ov = -1, .code = 0x2214, .word = 0x09c5, .immediate=0, .flags=0x80, .name = "INIT-USER" },
  { .ov = -1, .code = 0x2214, .word = 0x09d6, .immediate=0, .flags=0x80, .name = "INITIAL-DPB" },
  { .ov = -1, .code = 0x2214, .word = 0x09e2, .immediate=0, .flags=0x80, .name = "LIMIT" },
  { .ov = -1, .code = 0x1d29, .word = 0x09ef, .immediate=0, .flags=0x80, .name = "#CACHE" },
  { .ov = -1, .code = 0x1d29, .word = 0x09fe, .immediate=0, .flags=0x80, .name = "#BUFFERS" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a0b, .immediate=0, .flags=0x80, .name = "#SPACE" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a1b, .immediate=0, .flags=0x80, .name = "'RESTORE+" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a29, .immediate=0, .flags=0x80, .name = "'SETUP+" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a36, .immediate=0, .flags=0x80, .name = "?SOUND" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a43, .immediate=0, .flags=0x80, .name = ">BREAK" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a53, .immediate=0, .flags=0x80, .name = "BOOT-HOOK" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a63, .immediate=0, .flags=0x80, .name = "BOOT-LOAD" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a76, .immediate=0, .flags=0x80, .name = "BUFFER-BEGIN" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a88, .immediate=0, .flags=0x80, .name = "BUFFER-HEAD" },
  { .ov = -1, .code = 0x1d29, .word = 0x0a9a, .immediate=0, .flags=0x80, .name = "CACHE-BEGIN" },
  { .ov = -1, .code = 0x1d29, .word = 0x0aab, .immediate=0, .flags=0x80, .name = "CACHE-HEAD" },
  { .ov = -1, .code = 0x224c, .word = 0x0ab8, .immediate=0, .flags=0x80, .name = "'FORTH" },
  { .ov = -1, .code = 0x0ad1, .word = 0x0ad1, .immediate=0, .flags=0x80, .name = "ME" },
  { .ov = -1, .code = 0x224c, .word = 0x0ad9, .immediate=0, .flags=0x00, .name = "W0AD9" },
  { .ov = -1, .code = 0x224c, .word = 0x0b12, .immediate=0, .flags=0x00, .name = "W0B12" },
  { .ov = -1, .code = 0x224c, .word = 0x0b30, .immediate=0, .flags=0x00, .name = "W0B30" },
  { .ov = -1, .code = 0x224c, .word = 0x0b5d, .immediate=0, .flags=0x00, .name = "W0B5D" },
  { .ov = -1, .code = 0x224c, .word = 0x0b7c, .immediate=0, .flags=0x80, .name = "?ENOUGH" },
  { .ov = -1, .code = 0x0bb0, .word = 0x0bb0, .immediate=0, .flags=0x80, .name = "@" },
  { .ov = -1, .code = 0x0bbf, .word = 0x0bbf, .immediate=0, .flags=0x80, .name = "@L" },
  { .ov = -1, .code = 0x0be1, .word = 0x0be1, .immediate=0, .flags=0x80, .name = "!" },
  { .ov = -1, .code = 0x0bf1, .word = 0x0bf1, .immediate=0, .flags=0x80, .name = "!L" },
  { .ov = -1, .code = 0x0c17, .word = 0x0c17, .immediate=0, .flags=0x80, .name = "(CS?)" },
  { .ov = -1, .code = 0x0c24, .word = 0x0c24, .immediate=0, .flags=0x80, .name = "2!_2" },
  { .ov = -1, .code = 0x0c3a, .word = 0x0c3a, .immediate=0, .flags=0x80, .name = "2@" },
  { .ov = -1, .code = 0x224c, .word = 0x0c53, .immediate=0, .flags=0x80, .name = "BLANK" },
  { .ov = -1, .code = 0x0c60, .word = 0x0c60, .immediate=0, .flags=0x80, .name = "C!_2" },
  { .ov = -1, .code = 0x0c71, .word = 0x0c71, .immediate=0, .flags=0x80, .name = "C!L" },
  { .ov = -1, .code = 0x0c94, .word = 0x0c94, .immediate=0, .flags=0x80, .name = "C@" },
  { .ov = -1, .code = 0x0ca7, .word = 0x0ca7, .immediate=0, .flags=0x80, .name = "C@L" },
  { .ov = -1, .code = 0x224c, .word = 0x0ccf, .immediate=0, .flags=0x80, .name = "COUNT" },
  { .ov = -1, .code = 0x0ce4, .word = 0x0ce4, .immediate=0, .flags=0x80, .name = "CMOVE>" },
  { .ov = -1, .code = 0x0d10, .word = 0x0d10, .immediate=0, .flags=0x80, .name = "CMOVE_2" },
  { .ov = -1, .code = 0x0d35, .word = 0x0d35, .immediate=0, .flags=0x80, .name = "FILL_2" },
  { .ov = -1, .code = 0x0d56, .word = 0x0d56, .immediate=0, .flags=0x80, .name = "P!" },
  { .ov = -1, .code = 0x0d65, .word = 0x0d65, .immediate=0, .flags=0x80, .name = "P@" },
  { .ov = -1, .code = 0x0d7c, .word = 0x0d7c, .immediate=0, .flags=0x80, .name = "SEG>ADDR" },
  { .ov = -1, .code = 0x0d9c, .word = 0x0d9c, .immediate=0, .flags=0x80, .name = "ADDR>SEG" },
  { .ov = -1, .code = 0x0db6, .word = 0x0db6, .immediate=0, .flags=0x80, .name = ">R" },
  { .ov = -1, .code = 0x0dca, .word = 0x0dca, .immediate=0, .flags=0x80, .name = "?DUP" },
  { .ov = -1, .code = 0x0de0, .word = 0x0de0, .immediate=0, .flags=0x80, .name = "2DROP" },
  { .ov = -1, .code = 0x0df2, .word = 0x0df2, .immediate=0, .flags=0x80, .name = "2DUP" },
  { .ov = -1, .code = 0x0e08, .word = 0x0e08, .immediate=0, .flags=0x80, .name = "2SWAP" },
  { .ov = -1, .code = 0x224c, .word = 0x0e1f, .immediate=0, .flags=0x80, .name = "DEPTH" },
  { .ov = -1, .code = 0x0e34, .word = 0x0e34, .immediate=0, .flags=0x80, .name = "DROP" },
  { .ov = -1, .code = 0x0e43, .word = 0x0e43, .immediate=0, .flags=0x80, .name = "DUP" },
  { .ov = -1, .code = 0x0e52, .word = 0x0e52, .immediate=0, .flags=0x80, .name = "I" },
  { .ov = -1, .code = 0x0e62, .word = 0x0e62, .immediate=0, .flags=0x80, .name = "I'" },
  { .ov = -1, .code = 0x0e70, .word = 0x0e70, .immediate=0, .flags=0x80, .name = "J" },
  { .ov = -1, .code = 0x0e81, .word = 0x0e81, .immediate=0, .flags=0x80, .name = "OVER" },
  { .ov = -1, .code = 0x0e92, .word = 0x0e92, .immediate=0, .flags=0x80, .name = "R>" },
  { .ov = -1, .code = 0x0ea4, .word = 0x0ea4, .immediate=0, .flags=0x80, .name = "R@" },
  { .ov = -1, .code = 0x0eb5, .word = 0x0eb5, .immediate=0, .flags=0x80, .name = "ROT" },
  { .ov = -1, .code = 0x0ec8, .word = 0x0ec8, .immediate=0, .flags=0x80, .name = "RP!" },
  { .ov = -1, .code = 0x0ed8, .word = 0x0ed8, .immediate=0, .flags=0x80, .name = "RP@" },
  { .ov = -1, .code = 0x224c, .word = 0x0ee5, .immediate=0, .flags=0x80, .name = "S0" },
  { .ov = -1, .code = 0x0ef4, .word = 0x0ef4, .immediate=0, .flags=0x80, .name = "SWAP" },
  { .ov = -1, .code = 0x0f05, .word = 0x0f05, .immediate=0, .flags=0x80, .name = "SP!" },
  { .ov = -1, .code = 0x0f14, .word = 0x0f14, .immediate=0, .flags=0x80, .name = "SP@" },
  { .ov = -1, .code = 0x0f22, .word = 0x0f22, .immediate=0, .flags=0x80, .name = "0" },
  { .ov = -1, .code = 0x0f30, .word = 0x0f30, .immediate=0, .flags=0x80, .name = "1" },
  { .ov = -1, .code = 0x0f3f, .word = 0x0f3f, .immediate=0, .flags=0x80, .name = "2" },
  { .ov = -1, .code = 0x0f4e, .word = 0x0f4e, .immediate=0, .flags=0x80, .name = "/" },
  { .ov = -1, .code = 0x0f62, .word = 0x0f62, .immediate=0, .flags=0x80, .name = "/MOD" },
  { .ov = -1, .code = 0x0f74, .word = 0x0f74, .immediate=0, .flags=0x80, .name = "+" },
  { .ov = -1, .code = 0x0f85, .word = 0x0f85, .immediate=0, .flags=0x80, .name = "+!" },
  { .ov = -1, .code = 0x0f94, .word = 0x0f94, .immediate=0, .flags=0x80, .name = "-" },
  { .ov = -1, .code = 0x224c, .word = 0x0fa5, .immediate=0, .flags=0x80, .name = "+-" },
  { .ov = -1, .code = 0x0fb5, .word = 0x0fb5, .immediate=0, .flags=0x80, .name = "*" },
  { .ov = -1, .code = 0x224c, .word = 0x0fc6, .immediate=0, .flags=0x80, .name = "*/" },
  { .ov = -1, .code = 0x224c, .word = 0x0fd8, .immediate=0, .flags=0x80, .name = "*/MOD" },
  { .ov = -1, .code = 0x0fe9, .word = 0x0fe9, .immediate=0, .flags=0x80, .name = "1+" },
  { .ov = -1, .code = 0x0ff8, .word = 0x0ff8, .immediate=0, .flags=0x80, .name = "1-" },
  { .ov = -1, .code = 0x1007, .word = 0x1007, .immediate=0, .flags=0x80, .name = "2*" },
  { .ov = -1, .code = 0x1017, .word = 0x1017, .immediate=0, .flags=0x80, .name = "2+" },
  { .ov = -1, .code = 0x1027, .word = 0x1027, .immediate=0, .flags=0x80, .name = "2-" },
  { .ov = -1, .code = 0x1037, .word = 0x1037, .immediate=0, .flags=0x80, .name = "2/" },
  { .ov = -1, .code = 0x1047, .word = 0x1047, .immediate=0, .flags=0x80, .name = "4*" },
  { .ov = -1, .code = 0x224c, .word = 0x105a, .immediate=0, .flags=0x80, .name = "ABS" },
  { .ov = -1, .code = 0x1067, .word = 0x1067, .immediate=0, .flags=0x80, .name = "D+" },
  { .ov = -1, .code = 0x224c, .word = 0x107e, .immediate=0, .flags=0x80, .name = "D+-" },
  { .ov = -1, .code = 0x224c, .word = 0x1094, .immediate=0, .flags=0x80, .name = "DECIMAL" },
  { .ov = -1, .code = 0x224c, .word = 0x10a7, .immediate=0, .flags=0x80, .name = "DABS" },
  { .ov = -1, .code = 0x10b9, .word = 0x10b9, .immediate=0, .flags=0x80, .name = "DNEGATE" },
  { .ov = -1, .code = 0x224c, .word = 0x10cf, .immediate=0, .flags=0x80, .name = "M*" },
  { .ov = -1, .code = 0x224c, .word = 0x10eb, .immediate=0, .flags=0x80, .name = "M*/" },
  { .ov = -1, .code = 0x224c, .word = 0x1136, .immediate=0, .flags=0x80, .name = "M+" },
  { .ov = -1, .code = 0x224c, .word = 0x1143, .immediate=0, .flags=0x80, .name = "M/" },
  { .ov = -1, .code = 0x224c, .word = 0x116f, .immediate=0, .flags=0x80, .name = "M/MOD" },
  { .ov = -1, .code = 0x224c, .word = 0x118b, .immediate=0, .flags=0x80, .name = "MAX" },
  { .ov = -1, .code = 0x224c, .word = 0x11a1, .immediate=0, .flags=0x80, .name = "MOD" },
  { .ov = -1, .code = 0x224c, .word = 0x11af, .immediate=0, .flags=0x80, .name = "MIN" },
  { .ov = -1, .code = 0x11c8, .word = 0x11c8, .immediate=0, .flags=0x80, .name = "NEGATE" },
  { .ov = -1, .code = 0x11d8, .word = 0x11d8, .immediate=0, .flags=0x80, .name = "U*" },
  { .ov = -1, .code = 0x11ed, .word = 0x11ed, .immediate=0, .flags=0x80, .name = "U/MOD" },
  { .ov = -1, .code = 0x224c, .word = 0x1202, .immediate=0, .flags=0x80, .name = "UMAX" },
  { .ov = -1, .code = 0x224c, .word = 0x1219, .immediate=0, .flags=0x80, .name = "UMIN" },
  { .ov = -1, .code = 0x122f, .word = 0x122f, .immediate=0, .flags=0x80, .name = ">" },
  { .ov = -1, .code = 0x1248, .word = 0x1248, .immediate=0, .flags=0x80, .name = "<" },
  { .ov = -1, .code = 0x1261, .word = 0x1261, .immediate=0, .flags=0x80, .name = "=" },
  { .ov = -1, .code = 0x127a, .word = 0x127a, .immediate=0, .flags=0x80, .name = "0<" },
  { .ov = -1, .code = 0x128b, .word = 0x128b, .immediate=0, .flags=0x80, .name = "0=" },
  { .ov = -1, .code = 0x12a1, .word = 0x12a1, .immediate=0, .flags=0x80, .name = "0>" },
  { .ov = -1, .code = 0x224c, .word = 0x12b4, .immediate=0, .flags=0x80, .name = "D<" },
  { .ov = -1, .code = 0x12e1, .word = 0x12e1, .immediate=0, .flags=0x80, .name = "U<" },
  { .ov = -1, .code = 0x12f7, .word = 0x12f7, .immediate=0, .flags=0x80, .name = "AND" },
  { .ov = -1, .code = 0x1309, .word = 0x1309, .immediate=0, .flags=0x80, .name = "NOT" },
  { .ov = -1, .code = 0x224c, .word = 0x1320, .immediate=0, .flags=0x80, .name = "OFF_1" },
  { .ov = -1, .code = 0x224c, .word = 0x132f, .immediate=0, .flags=0x80, .name = "ON" },
  { .ov = -1, .code = 0x1340, .word = 0x1340, .immediate=0, .flags=0x80, .name = "OR" },
  { .ov = -1, .code = 0x1355, .word = 0x1355, .immediate=0, .flags=0x80, .name = "TOGGLE" },
  { .ov = -1, .code = 0x1366, .word = 0x1366, .immediate=0, .flags=0x80, .name = "XOR" },
  { .ov = -1, .code = 0x224c, .word = 0x1376, .immediate=0, .flags=0x80, .name = "#" },
  { .ov = -1, .code = 0x224c, .word = 0x13a1, .immediate=0, .flags=0x80, .name = "#>" },
  { .ov = -1, .code = 0x224c, .word = 0x13b6, .immediate=0, .flags=0x80, .name = "#S" },
  { .ov = -1, .code = 0x224c, .word = 0x13d1, .immediate=0, .flags=0x80, .name = "(NUMBER)" },
  { .ov = -1, .code = 0x143a, .word = 0x143a, .immediate=0, .flags=0x80, .name = ">UPPERCASE" },
  { .ov = -1, .code = 0x224c, .word = 0x145f, .immediate=0, .flags=0x80, .name = "<#" },
  { .ov = -1, .code = 0x224c, .word = 0x1473, .immediate=0, .flags=0x80, .name = "CONVERT" },
  { .ov = -1, .code = 0x14bd, .word = 0x14bd, .immediate=0, .flags=0x80, .name = "DIGIT" },
  { .ov = -1, .code = 0x224c, .word = 0x14ef, .immediate=0, .flags=0x80, .name = "HOLD" },
  { .ov = -1, .code = 0x1508, .word = 0x1508, .immediate=0, .flags=0x80, .name = "S->D" },
  { .ov = -1, .code = 0x224c, .word = 0x151c, .immediate=0, .flags=0x80, .name = "SIGN" },
  { .ov = -1, .code = 0x1536, .word = 0x1536, .immediate=0, .flags=0x80, .name = "(>CODE)" },
  { .ov = -1, .code = 0x1548, .word = 0x1548, .immediate=0, .flags=0x80, .name = "(;VIA)" },
  { .ov = -1, .code = 0x155e, .word = 0x155e, .immediate=0, .flags=0x80, .name = "(+LOOP)" },
  { .ov = -1, .code = 0x1593, .word = 0x1593, .immediate=0, .flags=0x80, .name = "(/LOOP)" },
  { .ov = -1, .code = 0x15ba, .word = 0x15ba, .immediate=0, .flags=0x80, .name = "(DO)" },
  { .ov = -1, .code = 0x15d2, .word = 0x15d2, .immediate=0, .flags=0x80, .name = "(LOOP)" },
  { .ov = -1, .code = 0x15fc, .word = 0x15fc, .immediate=0, .flags=0x80, .name = "0BRANCH" },
  { .ov = -1, .code = 0x1618, .word = 0x1618, .immediate=0, .flags=0x80, .name = "2LIT" },
  { .ov = -1, .code = 0x224c, .word = 0x162e, .immediate=0, .flags=0x80, .name = "ABORT-IT" },
  { .ov = -1, .code = 0x1662, .word = 0x1662, .immediate=0, .flags=0x80, .name = "BRANCH" },
  { .ov = -1, .code = 0x1675, .word = 0x1675, .immediate=0, .flags=0x80, .name = "CFAEXEC" },
  { .ov = -1, .code = 0x1684, .word = 0x1684, .immediate=0, .flags=0x80, .name = "EXECUTE" },
  { .ov = -1, .code = 0x1692, .word = 0x1692, .immediate=0, .flags=0x80, .name = "EXIT" },
  { .ov = -1, .code = 0x16a3, .word = 0x16a3, .immediate=0, .flags=0x80, .name = "GO" },
  { .ov = -1, .code = 0x1d29, .word = 0x16b4, .immediate=0, .flags=0x80, .name = "REGISTERS" },
  { .ov = -1, .code = 0x16d9, .word = 0x16d9, .immediate=0, .flags=0x80, .name = "INTERRUPT" },
  { .ov = -1, .code = 0x174c, .word = 0x174c, .immediate=0, .flags=0x80, .name = "LEAVE" },
  { .ov = -1, .code = 0x175f, .word = 0x175f, .immediate=0, .flags=0x80, .name = "LIT" },
  { .ov = -1, .code = 0x1772, .word = 0x1772, .immediate=0, .flags=0x80, .name = "SYSCALL" },
  { .ov = -1, .code = 0x224c, .word = 0x178a, .immediate=0, .flags=0x80, .name = "USER" },
  { .ov = -1, .code = 0x224c, .word = 0x17af, .immediate=0, .flags=0x80, .name = "USEREXECUTOR" },
  { .ov = -1, .code = 0x224c, .word = 0x17cb, .immediate=0, .flags=0x80, .name = "+FIND" },
  { .ov = -1, .code = 0x224c, .word = 0x17e1, .immediate=0, .flags=0x80, .name = "(-FIND)" },
  { .ov = -1, .code = 0x1818, .word = 0x1818, .immediate=0, .flags=0x80, .name = "(FIND)" },
  { .ov = -1, .code = 0x224c, .word = 0x186e, .immediate=0, .flags=0x80, .name = "(FORGET)" },
  { .ov = -1, .code = 0x224c, .word = 0x191a, .immediate=0, .flags=0x80, .name = "(LINKS)" },
  { .ov = -1, .code = 0x224c, .word = 0x193f, .immediate=0, .flags=0x80, .name = "<NAME>" },
  { .ov = -1, .code = 0x224c, .word = 0x1961, .immediate=0, .flags=0x80, .name = "?FIND" },
  { .ov = -1, .code = 0x224c, .word = 0x1982, .immediate=0, .flags=0x80, .name = "?[PTR]" },
  { .ov = -1, .code = 0x224c, .word = 0x199c, .immediate=0, .flags=0x80, .name = "DEFINITIONS" },
  { .ov = -1, .code = 0x224c, .word = 0x19b0, .immediate=0, .flags=0x80, .name = "EMPTY" },
  { .ov = -1, .code = 0x224c, .word = 0x19d3, .immediate=0, .flags=0x80, .name = "FIND" },
  { .ov = -1, .code = 0x224c, .word = 0x19f2, .immediate=0, .flags=0x80, .name = "FORGET" },
  { .ov = -1, .code = 0x224c, .word = 0x1a5c, .immediate=0, .flags=0x00, .name = "W1A5C" },
  { .ov = -1, .code = 0x224c, .word = 0x1a66, .immediate=0, .flags=0x00, .name = "W1A66" },
  { .ov = -1, .code = 0x224c, .word = 0x1a6e, .immediate=0, .flags=0x00, .name = "W1A6E" },
  { .ov = -1, .code = 0x224c, .word = 0x1a89, .immediate=0, .flags=0x80, .name = "VOCABULARY" },
  { .ov = -1, .code = 0x1ac0, .word = 0x1ac0, .immediate=0, .flags=0x00, .name = "W1AC0" },
  { .ov = -1, .code = 0x224c, .word = 0x1ae0, .immediate=0, .flags=0x80, .name = "WITHIN?" },
  { .ov = -1, .code = 0x224c, .word = 0x1b0c, .immediate=0, .flags=0x80, .name = "[-FIND]" },
  { .ov = -1, .code = 0x224c, .word = 0x1b35, .immediate=0, .flags=0x80, .name = "[-FINDS]" },
  { .ov = -1, .code = 0x224c, .word = 0x1b7d, .immediate=1, .flags=0x80, .name = "'_2" },
  { .ov = -1, .code = 0x224c, .word = 0x1b8f, .immediate=0, .flags=0x80, .name = "'STREAM" },
  { .ov = -1, .code = 0x224c, .word = 0x1bb1, .immediate=1, .flags=0x80, .name = "(" },
  { .ov = -1, .code = 0x224c, .word = 0x1bde, .immediate=0, .flags=0x80, .name = "(.\")" },
  { .ov = -1, .code = 0x224c, .word = 0x1bfc, .immediate=0, .flags=0x80, .name = "(;CODE)" },
  { .ov = -1, .code = 0x224c, .word = 0x1c15, .immediate=0, .flags=0x80, .name = "(ABORT\")" },
  { .ov = -1, .code = 0x224c, .word = 0x1c45, .immediate=0, .flags=0x80, .name = "(ABORT)" },
  { .ov = -1, .code = 0x224c, .word = 0x1c56, .immediate=1, .flags=0x80, .name = ".\"" },
  { .ov = -1, .code = 0x224c, .word = 0x1cbb, .immediate=0, .flags=0x80, .name = "(CREATE)" },
  { .ov = -1, .code = 0x224c, .word = 0x1d3e, .immediate=0, .flags=0x80, .name = "(EXPECT)" },
  { .ov = -1, .code = 0x224c, .word = 0x1dd8, .immediate=0, .flags=0x80, .name = "(INTERPRET)" },
  { .ov = -1, .code = 0x224c, .word = 0x1e23, .immediate=0, .flags=0x80, .name = "(LOAD)" },
  { .ov = -1, .code = 0x224c, .word = 0x1e68, .immediate=0, .flags=0x80, .name = "(WHERE)" },
  { .ov = -1, .code = 0x224c, .word = 0x1f06, .immediate=0, .flags=0x80, .name = "(WORD)" },
  { .ov = -1, .code = 0x224c, .word = 0x1f7d, .immediate=1, .flags=0x80, .name = "+LOOP" },
  { .ov = -1, .code = 0x224c, .word = 0x1f95, .immediate=0, .flags=0x80, .name = "," },
  { .ov = -1, .code = 0x224c, .word = 0x1fad, .immediate=1, .flags=0x80, .name = "/LOOP" },
  { .ov = -1, .code = 0x224c, .word = 0x1fc5, .immediate=1, .flags=0x80, .name = ";" },
  { .ov = -1, .code = 0x224c, .word = 0x1fdb, .immediate=0, .flags=0x80, .name = "?COMP" },
  { .ov = -1, .code = 0x224c, .word = 0x1ff4, .immediate=0, .flags=0x00, .name = "W1FF4" },
  { .ov = -1, .code = 0x224c, .word = 0x2031, .immediate=0, .flags=0x80, .name = "?CSP" },
  { .ov = -1, .code = 0x224c, .word = 0x2057, .immediate=0, .flags=0x00, .name = "W2057" },
  { .ov = -1, .code = 0x224c, .word = 0x2084, .immediate=0, .flags=0x80, .name = "?LOADING" },
  { .ov = -1, .code = 0x224c, .word = 0x20a6, .immediate=0, .flags=0x80, .name = "?PAIRS" },
  { .ov = -1, .code = 0x224c, .word = 0x20c6, .immediate=0, .flags=0x00, .name = "W20C6" },
  { .ov = -1, .code = 0x224c, .word = 0x2126, .immediate=1, .flags=0x80, .name = "ABORT\"" },
  { .ov = -1, .code = 0x224c, .word = 0x2174, .immediate=1, .flags=0x80, .name = "AGAIN" },
  { .ov = -1, .code = 0x224c, .word = 0x218e, .immediate=0, .flags=0x80, .name = "ALLOT" },
  { .ov = -1, .code = 0x224c, .word = 0x21a2, .immediate=1, .flags=0x80, .name = "BEGIN" },
  { .ov = -1, .code = 0x224c, .word = 0x21b1, .immediate=0, .flags=0x80, .name = "C," },
  { .ov = -1, .code = 0x224c, .word = 0x21c3, .immediate=0, .flags=0x80, .name = "CFA" },
  { .ov = -1, .code = 0x21c9, .word = 0x21c9, .immediate=0, .flags=0x00, .name = "W21C9" },
  { .ov = -1, .code = 0x224c, .word = 0x21f1, .immediate=0, .flags=0x80, .name = "COMPILE" },
  { .ov = -1, .code = 0x224c, .word = 0x220e, .immediate=0, .flags=0x80, .name = "CONSTANT" },
  { .ov = -1, .code = 0x224c, .word = 0x2224, .immediate=1, .flags=0x80, .name = "DO" },
  { .ov = -1, .code = 0x224c, .word = 0x2236, .immediate=0, .flags=0x80, .name = ":" },
  { .ov = -1, .code = 0x224c, .word = 0x2264, .immediate=1, .flags=0x80, .name = "DOES>" },
  { .ov = -1, .code = 0x224c, .word = 0x2287, .immediate=1, .flags=0x80, .name = "ELSE" },
  { .ov = -1, .code = 0x22ab, .word = 0x22ab, .immediate=0, .flags=0x80, .name = "ENCLOSE" },
  { .ov = -1, .code = 0x224c, .word = 0x22ef, .immediate=0, .flags=0x80, .name = "HERE" },
  { .ov = -1, .code = 0x224c, .word = 0x22fd, .immediate=0, .flags=0x80, .name = "HEX" },
  { .ov = -1, .code = 0x224c, .word = 0x230e, .immediate=1, .flags=0x80, .name = "IF" },
  { .ov = -1, .code = 0x224c, .word = 0x232a, .immediate=0, .flags=0x80, .name = "IMMEDIATE" },
  { .ov = -1, .code = 0x224c, .word = 0x233f, .immediate=0, .flags=0x80, .name = "LATEST" },
  { .ov = -1, .code = 0x224c, .word = 0x2355, .immediate=0, .flags=0x80, .name = "LFA" },
  { .ov = -1, .code = 0x224c, .word = 0x2367, .immediate=1, .flags=0x80, .name = "LITERAL" },
  { .ov = -1, .code = 0x224c, .word = 0x2386, .immediate=1, .flags=0x80, .name = "LOOP" },
  { .ov = -1, .code = 0x224c, .word = 0x23a5, .immediate=1, .flags=0x80, .name = "2LITERAL" },
  { .ov = -1, .code = 0x224c, .word = 0x23c7, .immediate=0, .flags=0x80, .name = "NFA" },
  { .ov = -1, .code = 0x224c, .word = 0x23dd, .immediate=0, .flags=0x80, .name = "PAD" },
  { .ov = -1, .code = 0x224c, .word = 0x23ef, .immediate=0, .flags=0x80, .name = "PFA" },
  { .ov = -1, .code = 0x224c, .word = 0x2405, .immediate=0, .flags=0x80, .name = "QUERY" },
  { .ov = -1, .code = 0x224c, .word = 0x2420, .immediate=0, .flags=0x80, .name = "QUIT" },
  { .ov = -1, .code = 0x224c, .word = 0x2467, .immediate=1, .flags=0x80, .name = "REPEAT" },
  { .ov = -1, .code = 0x224c, .word = 0x2482, .immediate=0, .flags=0x80, .name = "SMUDGE" },
  { .ov = -1, .code = 0x224c, .word = 0x2495, .immediate=0, .flags=0x80, .name = "TEXT" },
  { .ov = -1, .code = 0x224c, .word = 0x24c0, .immediate=1, .flags=0x80, .name = "THEN" },
  { .ov = -1, .code = 0x224c, .word = 0x24df, .immediate=0, .flags=0x80, .name = "TRAVERSE" },
  { .ov = -1, .code = 0x224c, .word = 0x2503, .immediate=1, .flags=0x80, .name = "UNTIL" },
  { .ov = -1, .code = 0x224c, .word = 0x2520, .immediate=0, .flags=0x80, .name = "VARIABLE" },
  { .ov = -1, .code = 0x224c, .word = 0x2532, .immediate=1, .flags=0x80, .name = "WHILE" },
  { .ov = -1, .code = 0x224c, .word = 0x253e, .immediate=1, .flags=0x80, .name = "zero_length_unknown" },
  { .ov = -1, .code = 0x224c, .word = 0x2558, .immediate=1, .flags=0x80, .name = "[" },
  { .ov = -1, .code = 0x224c, .word = 0x256e, .immediate=1, .flags=0x80, .name = "[COMPILE]" },
  { .ov = -1, .code = 0x224c, .word = 0x257e, .immediate=1, .flags=0x80, .name = "\\" },
  { .ov = -1, .code = 0x224c, .word = 0x25a2, .immediate=0, .flags=0x80, .name = "]" },
  { .ov = -1, .code = 0x25bc, .word = 0x25bc, .immediate=0, .flags=0x80, .name = "(?TERMINAL)" },
  { .ov = -1, .code = 0x25d7, .word = 0x25d7, .immediate=0, .flags=0x80, .name = "(KEY)" },
  { .ov = -1, .code = 0x1d29, .word = 0x25fe, .immediate=0, .flags=0x80, .name = "BEEPMS" },
  { .ov = -1, .code = 0x1d29, .word = 0x260d, .immediate=0, .flags=0x80, .name = "BEEPTONE" },
  { .ov = -1, .code = 0x2618, .word = 0x2618, .immediate=0, .flags=0x80, .name = "TONE" },
  { .ov = -1, .code = 0x2638, .word = 0x2638, .immediate=0, .flags=0x80, .name = "BEEPON_2" },
  { .ov = -1, .code = 0x2653, .word = 0x2653, .immediate=0, .flags=0x80, .name = "BEEPOFF" },
  { .ov = -1, .code = 0x224c, .word = 0x266b, .immediate=0, .flags=0x80, .name = "BEEP" },
  { .ov = -1, .code = 0x224c, .word = 0x2690, .immediate=0, .flags=0x80, .name = "(TYPE)" },
  { .ov = -1, .code = 0x224c, .word = 0x26cf, .immediate=0, .flags=0x80, .name = "(BS)" },
  { .ov = -1, .code = 0x224c, .word = 0x26ee, .immediate=0, .flags=0x80, .name = "(CR)" },
  { .ov = -1, .code = 0x224c, .word = 0x2731, .immediate=0, .flags=0x80, .name = "(EMIT)" },
  { .ov = -1, .code = 0x224c, .word = 0x274c, .immediate=0, .flags=0x80, .name = "(PAGE)" },
  { .ov = -1, .code = 0x2767, .word = 0x2767, .immediate=0, .flags=0x80, .name = "(POSITION)" },
  { .ov = -1, .code = 0x224c, .word = 0x2790, .immediate=0, .flags=0x80, .name = "-TRAILING" },
  { .ov = -1, .code = 0x224c, .word = 0x27ba, .immediate=0, .flags=0x80, .name = "." },
  { .ov = -1, .code = 0x224c, .word = 0x27ca, .immediate=0, .flags=0x80, .name = ".LINE" },
  { .ov = -1, .code = 0x224c, .word = 0x27e3, .immediate=0, .flags=0x80, .name = ".R" },
  { .ov = -1, .code = 0x27f8, .word = 0x27f8, .immediate=0, .flags=0x80, .name = ">VMOVE" },
  { .ov = -1, .code = 0x224c, .word = 0x2822, .immediate=0, .flags=0x80, .name = "?" },
  { .ov = -1, .code = 0x2836, .word = 0x2836, .immediate=0, .flags=0x80, .name = "?POSITION" },
  { .ov = -1, .code = 0x2852, .word = 0x2852, .immediate=0, .flags=0x80, .name = "CUR>ADDR" },
  { .ov = -1, .code = 0x224c, .word = 0x2868, .immediate=0, .flags=0x80, .name = "CURFWD" },
  { .ov = -1, .code = 0x224c, .word = 0x2895, .immediate=0, .flags=0x80, .name = "D." },
  { .ov = -1, .code = 0x224c, .word = 0x28a5, .immediate=0, .flags=0x80, .name = "D.R" },
  { .ov = -1, .code = 0x224c, .word = 0x28d3, .immediate=0, .flags=0x80, .name = "ID." },
  { .ov = -1, .code = 0x224c, .word = 0x2928, .immediate=0, .flags=0x80, .name = "LIST" },
  { .ov = -1, .code = 0x2973, .word = 0x2973, .immediate=0, .flags=0x80, .name = "SCROLLUP" },
  { .ov = -1, .code = 0x224c, .word = 0x2996, .immediate=0, .flags=0x80, .name = "SPACE" },
  { .ov = -1, .code = 0x224c, .word = 0x29a7, .immediate=0, .flags=0x80, .name = "SPACES" },
  { .ov = -1, .code = 0x224c, .word = 0x29c4, .immediate=0, .flags=0x80, .name = "U." },
  { .ov = -1, .code = 0x224c, .word = 0x29d2, .immediate=0, .flags=0x80, .name = "U.R" },
  { .ov = -1, .code = 0x29e1, .word = 0x29e1, .immediate=0, .flags=0x80, .name = "V@" },
  { .ov = -1, .code = 0x29fc, .word = 0x29fc, .immediate=0, .flags=0x80, .name = "V!" },
  { .ov = -1, .code = 0x2a18, .word = 0x2a18, .immediate=0, .flags=0x80, .name = "VFILL" },
  { .ov = -1, .code = 0x2a36, .word = 0x2a36, .immediate=0, .flags=0x80, .name = "VMOVE" },
  { .ov = -1, .code = 0x2a5f, .word = 0x2a5f, .immediate=0, .flags=0x80, .name = "VMOVE-" },
  { .ov = -1, .code = 0x2214, .word = 0x2a72, .immediate=0, .flags=0x80, .name = "MS/TICK" },
  { .ov = -1, .code = 0x2214, .word = 0x2a82, .immediate=0, .flags=0x80, .name = "TICKS/ADJ" },
  { .ov = -1, .code = 0x2214, .word = 0x2a8f, .immediate=0, .flags=0x80, .name = "MS/ADJ" },
  { .ov = -1, .code = 0x2a9a, .word = 0x2a9a, .immediate=0, .flags=0x80, .name = "TIME" },
  { .ov = -1, .code = 0x224c, .word = 0x2af1, .immediate=0, .flags=0x80, .name = "MS" },
  { .ov = -1, .code = 0x2214, .word = 0x2b21, .immediate=0, .flags=0x80, .name = "#DRIVES" },
  { .ov = -1, .code = 0x2214, .word = 0x2b2d, .immediate=0, .flags=0x80, .name = "#FCBS" },
  { .ov = -1, .code = 0x2214, .word = 0x2b3a, .immediate=0, .flags=0x80, .name = "#FILES" },
  { .ov = -1, .code = 0x2214, .word = 0x2b49, .immediate=0, .flags=0x80, .name = "#SEC/TRK" },
  { .ov = -1, .code = 0x2214, .word = 0x2b58, .immediate=0, .flags=0x80, .name = "DOS-FILE" },
  { .ov = -1, .code = 0x2214, .word = 0x2b66, .immediate=0, .flags=0x80, .name = "RETRIES" },
  { .ov = -1, .code = 0x2214, .word = 0x2b76, .immediate=0, .flags=0x80, .name = "SECORIGIN" },
  { .ov = -1, .code = 0x1d29, .word = 0x2b83, .immediate=0, .flags=0x80, .name = "'SVBUF" },
  { .ov = -1, .code = 0x1d29, .word = 0x2b90, .immediate=0, .flags=0x80, .name = "'MTBUF" },
  { .ov = -1, .code = 0x1d29, .word = 0x2b9c, .immediate=0, .flags=0x80, .name = "#SECS" },
  { .ov = -1, .code = 0x1d29, .word = 0x2ba7, .immediate=0, .flags=0x80, .name = "'FCB" },
  { .ov = -1, .code = 0x1d29, .word = 0x2bb4, .immediate=0, .flags=0x80, .name = "'CACHE" },
  { .ov = -1, .code = 0x1d29, .word = 0x2bc4, .immediate=0, .flags=0x80, .name = "'DOSMOUNT" },
  { .ov = -1, .code = 0x1d29, .word = 0x2bd6, .immediate=0, .flags=0x80, .name = "'DOSUNMOUNT" },
  { .ov = -1, .code = 0x1d29, .word = 0x2be3, .immediate=0, .flags=0x80, .name = "REUSEC" },
  { .ov = -1, .code = 0x1d29, .word = 0x2bf5, .immediate=0, .flags=0x80, .name = "1STCACHEBUF" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c04, .immediate=0, .flags=0x80, .name = "BLKCACHE" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c15, .immediate=0, .flags=0x80, .name = "DEFAULTDRV" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c26, .immediate=0, .flags=0x80, .name = "DISK-ERROR" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c32, .immediate=0, .flags=0x80, .name = "DRIVE" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c3c, .immediate=0, .flags=0x80, .name = "DTA" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c49, .immediate=0, .flags=0x80, .name = "FILE" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c55, .immediate=0, .flags=0x80, .name = "FRESH" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c60, .immediate=0, .flags=0x80, .name = "HEAD" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c6c, .immediate=0, .flags=0x80, .name = "LPREV" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c79, .immediate=0, .flags=0x80, .name = "OFFSET" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c84, .immediate=0, .flags=0x80, .name = "PREV" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c8e, .immediate=0, .flags=0x80, .name = "SEC" },
  { .ov = -1, .code = 0x1d29, .word = 0x2c9d, .immediate=0, .flags=0x80, .name = "SEGCACHE" },
  { .ov = -1, .code = 0x1d29, .word = 0x2ca8, .immediate=0, .flags=0x80, .name = "SYSK" },
  { .ov = -1, .code = 0x1d29, .word = 0x2cb4, .immediate=0, .flags=0x80, .name = "TRACK" },
  { .ov = -1, .code = 0x1d29, .word = 0x2cbe, .immediate=0, .flags=0x80, .name = "USE" },
  { .ov = -1, .code = 0x1d29, .word = 0x2cd0, .immediate=0, .flags=0x80, .name = "=DRIVESIZES" },
  { .ov = -1, .code = 0x224c, .word = 0x2ce5, .immediate=0, .flags=0x80, .name = "DRIVESIZES" },
  { .ov = -1, .code = 0x224c, .word = 0x2cfa, .immediate=0, .flags=0x80, .name = "BARRAY" },
  { .ov = -1, .code = 0x224c, .word = 0x2d09, .immediate=0, .flags=0x80, .name = "WARRAY" },
  { .ov = -1, .code = 0x1d29, .word = 0x2d23, .immediate=0, .flags=0x80, .name = "=DRIVENUMBERS" },
  { .ov = -1, .code = 0x1d29, .word = 0x2d34, .immediate=0, .flags=0x80, .name = "=FCBPFAS" },
  { .ov = -1, .code = 0x1d29, .word = 0x2d4c, .immediate=0, .flags=0x80, .name = "=FILEBLOCKS" },
  { .ov = -1, .code = 0x1d29, .word = 0x2d63, .immediate=0, .flags=0x80, .name = "=FILETYPES" },
  { .ov = -1, .code = 0x1d29, .word = 0x2d74, .immediate=0, .flags=0x80, .name = "=OFFSETS" },
  { .ov = -1, .code = 0x1d29, .word = 0x2d87, .immediate=0, .flags=0x80, .name = "=R/W'S" },
  { .ov = -1, .code = 0x1d29, .word = 0x2d97, .immediate=0, .flags=0x80, .name = "FCB" },
  { .ov = -1, .code = 0x1d29, .word = 0x2dfd, .immediate=0, .flags=0x80, .name = "FILENAMES" },
  { .ov = -1, .code = 0x224c, .word = 0x2e3a, .immediate=0, .flags=0x80, .name = "DRIVENUMBERS" },
  { .ov = -1, .code = 0x224c, .word = 0x2e4c, .immediate=0, .flags=0x80, .name = "FCBPFAS" },
  { .ov = -1, .code = 0x224c, .word = 0x2e61, .immediate=0, .flags=0x80, .name = "FILEBLOCKS" },
  { .ov = -1, .code = 0x224c, .word = 0x2e75, .immediate=0, .flags=0x80, .name = "FILETYPES" },
  { .ov = -1, .code = 0x224c, .word = 0x2e87, .immediate=0, .flags=0x80, .name = "OFFSETS" },
  { .ov = -1, .code = 0x224c, .word = 0x2e97, .immediate=0, .flags=0x80, .name = "R/W'S" },
  { .ov = -1, .code = 0x2ea4, .word = 0x2ea4, .immediate=0, .flags=0x80, .name = "L@" },
  { .ov = -1, .code = 0x2eb8, .word = 0x2eb8, .immediate=0, .flags=0x80, .name = "L!" },
  { .ov = -1, .code = 0x2ecd, .word = 0x2ecd, .immediate=0, .flags=0x80, .name = "LC@" },
  { .ov = -1, .code = 0x2ee5, .word = 0x2ee5, .immediate=0, .flags=0x80, .name = "LC!" },
  { .ov = -1, .code = 0x2efe, .word = 0x2efe, .immediate=0, .flags=0x80, .name = "LCMOVE" },
  { .ov = -1, .code = 0x1d29, .word = 0x2f36, .immediate=0, .flags=0x80, .name = "{LXCHG}" },
  { .ov = -1, .code = 0x2f51, .word = 0x2f51, .immediate=0, .flags=0x80, .name = "LWSCAN" },
  { .ov = -1, .code = 0x224c, .word = 0x2f89, .immediate=0, .flags=0x80, .name = "[SEGCACHE]" },
  { .ov = -1, .code = 0x224c, .word = 0x2fa6, .immediate=0, .flags=0x80, .name = "[BLKCACHE]" },
  { .ov = -1, .code = 0x224c, .word = 0x2fbf, .immediate=0, .flags=0x80, .name = "UPDATE" },
  { .ov = -1, .code = 0x224c, .word = 0x2fd9, .immediate=0, .flags=0x80, .name = "REFRESH" },
  { .ov = -1, .code = 0x224c, .word = 0x2fe9, .immediate=0, .flags=0x80, .name = "MTBUF" },
  { .ov = -1, .code = 0x224c, .word = 0x302d, .immediate=0, .flags=0x80, .name = "MTBUFFERS" },
  { .ov = -1, .code = 0x3048, .word = 0x3048, .immediate=0, .flags=0x80, .name = "(BUFFER)" },
  { .ov = -1, .code = 0x30a8, .word = 0x30a8, .immediate=0, .flags=0x80, .name = "ADVANCE>DEF" },
  { .ov = -1, .code = 0x224c, .word = 0x30d5, .immediate=0, .flags=0x80, .name = "MTCACHE" },
  { .ov = -1, .code = 0x224c, .word = 0x3115, .immediate=0, .flags=0x80, .name = "INITCACHE" },
  { .ov = -1, .code = 0x224c, .word = 0x3177, .immediate=0, .flags=0x80, .name = "(CACHE)" },
  { .ov = -1, .code = 0x224c, .word = 0x31bb, .immediate=0, .flags=0x80, .name = "CACHE>USE" },
  { .ov = -1, .code = 0x224c, .word = 0x31e5, .immediate=0, .flags=0x80, .name = "?INBCACHE" },
  { .ov = -1, .code = 0x224c, .word = 0x321b, .immediate=0, .flags=0x80, .name = "[BUF>CACHE]" },
  { .ov = -1, .code = 0x224c, .word = 0x3245, .immediate=0, .flags=0x80, .name = "BUF>CACHE" },
  { .ov = -1, .code = 0x224c, .word = 0x326b, .immediate=0, .flags=0x80, .name = "SEC-I/O" },
  { .ov = -1, .code = 0x224c, .word = 0x32d5, .immediate=0, .flags=0x80, .name = "T&SCALC" },
  { .ov = -1, .code = 0x224c, .word = 0x32fd, .immediate=0, .flags=0x80, .name = "[R/W]" },
  { .ov = -1, .code = 0x224c, .word = 0x3344, .immediate=0, .flags=0x80, .name = "[DIRECT]" },
  { .ov = -1, .code = 0x224c, .word = 0x3398, .immediate=0, .flags=0x80, .name = "<MOUNT>" },
  { .ov = -1, .code = 0x1d29, .word = 0x3408, .immediate=0, .flags=0x80, .name = "DIRNAME" },
  { .ov = -1, .code = 0x224c, .word = 0x341b, .immediate=0, .flags=0x80, .name = "DR0" },
  { .ov = -1, .code = 0x224c, .word = 0x3439, .immediate=0, .flags=0x80, .name = "DR1" },
  { .ov = -1, .code = 0x224c, .word = 0x345f, .immediate=0, .flags=0x80, .name = "<UNMOUNT>" },
  { .ov = -1, .code = 0x224c, .word = 0x34c9, .immediate=0, .flags=0x80, .name = "UNMOUNT" },
  { .ov = -1, .code = 0x224c, .word = 0x34ec, .immediate=0, .flags=0x80, .name = "NOFILES" },
  { .ov = -1, .code = 0x224c, .word = 0x350d, .immediate=0, .flags=0x80, .name = "NODRIVES" },
  { .ov = -1, .code = 0x224c, .word = 0x351b, .immediate=0, .flags=0x80, .name = "EMITS" },
  { .ov = -1, .code = 0x224c, .word = 0x353b, .immediate=0, .flags=0x80, .name = "FILES" },
  { .ov = -1, .code = 0x224c, .word = 0x3633, .immediate=0, .flags=0x80, .name = "DRIVES" },
  { .ov = -1, .code = 0x224c, .word = 0x3648, .immediate=0, .flags=0x80, .name = "(DISKERROR?)" },
  { .ov = -1, .code = 0x3672, .word = 0x3672, .immediate=0, .flags=0x00, .name = "W3672" },
  { .ov = -1, .code = 0x367f, .word = 0x367f, .immediate=0, .flags=0x00, .name = "W367F" },
  { .ov = -1, .code = 0x36bb, .word = 0x36bb, .immediate=0, .flags=0x00, .name = "W36BB" },
  { .ov = -1, .code = 0x224c, .word = 0x36d7, .immediate=0, .flags=0x00, .name = "W36D7" },
  { .ov = -1, .code = 0x224c, .word = 0x3715, .immediate=0, .flags=0x00, .name = "W3715" },
  { .ov = -1, .code = 0x224c, .word = 0x3753, .immediate=0, .flags=0x00, .name = "W3753" },
  { .ov = -1, .code = 0x224c, .word = 0x3783, .immediate=0, .flags=0x00, .name = "W3783" },
  { .ov = -1, .code = 0x224c, .word = 0x37af, .immediate=0, .flags=0x00, .name = "W37AF" },
  { .ov = -1, .code = 0x224c, .word = 0x37d3, .immediate=0, .flags=0x00, .name = "W37D3" },
  { .ov = -1, .code = 0x224c, .word = 0x3823, .immediate=0, .flags=0x00, .name = "W3823" },
  { .ov = -1, .code = 0x224c, .word = 0x3849, .immediate=0, .flags=0x00, .name = "W3849" },
  { .ov = -1, .code = 0x224c, .word = 0x385f, .immediate=0, .flags=0x80, .name = "BLOCK_1" },
  { .ov = -1, .code = 0x224c, .word = 0x3880, .immediate=0, .flags=0x80, .name = "LBLOCK_1" },
  { .ov = -1, .code = 0x224c, .word = 0x38ad, .immediate=0, .flags=0x80, .name = "SAVE-BUFFERS2" },
  { .ov = -1, .code = 0x224c, .word = 0x38fd, .immediate=0, .flags=0x80, .name = "EMPTY-BUFFERS" },
  { .ov = -1, .code = 0x224c, .word = 0x3913, .immediate=0, .flags=0x80, .name = "FLUSH" },
  { .ov = -1, .code = 0x224c, .word = 0x3922, .immediate=0, .flags=0x80, .name = "COPY" },
  { .ov = -1, .code = 0x224c, .word = 0x393f, .immediate=0, .flags=0x80, .name = "BLOCKS" },
  { .ov = -1, .code = 0x2214, .word = 0x3991, .immediate=0, .flags=0x80, .name = "PSW" },
  { .ov = -1, .code = 0x2214, .word = 0x399a, .immediate=0, .flags=0x80, .name = "AX" },
  { .ov = -1, .code = 0x2214, .word = 0x39a3, .immediate=0, .flags=0x80, .name = "BX" },
  { .ov = -1, .code = 0x2214, .word = 0x39ac, .immediate=0, .flags=0x80, .name = "CX" },
  { .ov = -1, .code = 0x2214, .word = 0x39b5, .immediate=0, .flags=0x80, .name = "DX" },
  { .ov = -1, .code = 0x2214, .word = 0x39be, .immediate=0, .flags=0x80, .name = "BP" },
  { .ov = -1, .code = 0x2214, .word = 0x39c7, .immediate=0, .flags=0x80, .name = "DI" },
  { .ov = -1, .code = 0x2214, .word = 0x39d0, .immediate=0, .flags=0x80, .name = "SI" },
  { .ov = -1, .code = 0x2214, .word = 0x39d9, .immediate=0, .flags=0x80, .name = "DS" },
  { .ov = -1, .code = 0x2214, .word = 0x39e2, .immediate=0, .flags=0x80, .name = "ES" },
  { .ov = -1, .code = 0x39ee, .word = 0x39ee, .immediate=0, .flags=0x80, .name = "MATCH" },
  { .ov = -1, .code = 0x3a39, .word = 0x3a39, .immediate=0, .flags=0x80, .name = "@EXECUTE" },
  { .ov = -1, .code = 0x224c, .word = 0x3a48, .immediate=0, .flags=0x80, .name = "NOP" },
  { .ov = -1, .code = 0x224c, .word = 0x3a51, .immediate=1, .flags=0x80, .name = "**" },
  { .ov = -1, .code = 0x1d29, .word = 0x3a60, .immediate=0, .flags=0x80, .name = "'UNRAVEL" },
  { .ov = -1, .code = 0x224c, .word = 0x3a6e, .immediate=0, .flags=0x80, .name = "UNRAVEL" },
  { .ov = -1, .code = 0x224c, .word = 0x3ab3, .immediate=0, .flags=0x80, .name = "?UNRAVEL" },
  { .ov = -1, .code = 0x224c, .word = 0x3ac3, .immediate=0, .flags=0x80, .name = "SYN" },
  { .ov = -1, .code = 0x1d29, .word = 0x3b0f, .immediate=0, .flags=0x80, .name = "TRACE" },
  { .ov = -1, .code = 0x1d29, .word = 0x3b1c, .immediate=0, .flags=0x80, .name = "[TRACE" },
  { .ov = -1, .code = 0x1d29, .word = 0x3b29, .immediate=0, .flags=0x80, .name = "TRACE]" },
  { .ov = -1, .code = 0x3aec, .word = 0x3b32, .immediate=1, .flags=0x80, .name = "D@" },
  { .ov = -1, .code = 0x3aec, .word = 0x3b3b, .immediate=1, .flags=0x80, .name = "V=" },
  { .ov = -1, .code = 0x3aec, .word = 0x3b44, .immediate=1, .flags=0x80, .name = "C=" },
  { .ov = -1, .code = 0x224c, .word = 0x3b4e, .immediate=0, .flags=0x80, .name = "2V=" },
  { .ov = -1, .code = 0x224c, .word = 0x3b60, .immediate=0, .flags=0x80, .name = "2C=" },
  { .ov = -1, .code = 0x2214, .word = 0x3b75, .immediate=0, .flags=0x80, .name = "3" },
  { .ov = -1, .code = 0x2214, .word = 0x3b7d, .immediate=0, .flags=0x80, .name = "4" },
  { .ov = -1, .code = 0x2214, .word = 0x3b85, .immediate=0, .flags=0x80, .name = "5" },
  { .ov = -1, .code = 0x2214, .word = 0x3b8d, .immediate=0, .flags=0x80, .name = "6" },
  { .ov = -1, .code = 0x2214, .word = 0x3b95, .immediate=0, .flags=0x80, .name = "7" },
  { .ov = -1, .code = 0x2214, .word = 0x3b9d, .immediate=0, .flags=0x80, .name = "8" },
  { .ov = -1, .code = 0x2214, .word = 0x3ba5, .immediate=0, .flags=0x80, .name = "9" },
  { .ov = -1, .code = 0x2214, .word = 0x3bae, .immediate=0, .flags=0x80, .name = "-1" },
  { .ov = -1, .code = 0x2214, .word = 0x3bb7, .immediate=0, .flags=0x80, .name = "-2" },
  { .ov = -1, .code = 0x224c, .word = 0x3bc2, .immediate=0, .flags=0x80, .name = "THRU_1" },
  { .ov = -1, .code = 0x224c, .word = 0x3bee, .immediate=0, .flags=0x80, .name = "(TRACE)" },
  { .ov = -1, .code = 0x1d29, .word = 0x3bf8, .immediate=0, .flags=0x80, .name = "OVA" },
  { .ov = -1, .code = 0x1d29, .word = 0x3c03, .immediate=0, .flags=0x80, .name = "T-DP" },
  { .ov = -1, .code = 0x224c, .word = 0x3c19, .immediate=0, .flags=0x80, .name = "TRANS-ALLOT" },
  { .ov = -1, .code = 0x224c, .word = 0x3c33, .immediate=0, .flags=0x80, .name = "NEWT-DP" },
  { .ov = -1, .code = 0x224c, .word = 0x3c4f, .immediate=0, .flags=0x80, .name = "TRANSIENT" },
  { .ov = -1, .code = 0x224c, .word = 0x3c72, .immediate=0, .flags=0x80, .name = "RESIDENT" },
  { .ov = -1, .code = 0x224c, .word = 0x3c92, .immediate=0, .flags=0x80, .name = "HEAD:" },
  { .ov = -1, .code = 0x224c, .word = 0x3cc0, .immediate=1, .flags=0x80, .name = "T:" },
  { .ov = -1, .code = 0x224c, .word = 0x3cdf, .immediate=1, .flags=0x80, .name = "T;" },
  { .ov = -1, .code = 0x224c, .word = 0x3ceb, .immediate=0, .flags=0x00, .name = "W3CEB" },
  { .ov = -1, .code = 0x224c, .word = 0x3d39, .immediate=0, .flags=0x00, .name = "W3D39" },
  { .ov = -1, .code = 0x224c, .word = 0x3d8f, .immediate=0, .flags=0x80, .name = "DISPOSE" },
  { .ov = -1, .code = 0x224c, .word = 0x3df7, .immediate=1, .flags=0x80, .name = "'_1" },
  { .ov = -1, .code = 0x1d29, .word = 0x3e21, .immediate=0, .flags=0x80, .name = "(2V:)" },
  { .ov = -1, .code = 0x2214, .word = 0x3e2e, .immediate=0, .flags=0x80, .name = "(C:)" },
  { .ov = -1, .code = 0x3b68, .word = 0x3e3a, .immediate=0, .flags=0x80, .name = "(2C:)" },
  { .ov = -1, .code = 0x224c, .word = 0x3e45, .immediate=0, .flags=0x80, .name = "V:" },
  { .ov = -1, .code = 0x224c, .word = 0x3e5b, .immediate=0, .flags=0x80, .name = "2V:" },
  { .ov = -1, .code = 0x224c, .word = 0x3e70, .immediate=0, .flags=0x80, .name = "C:" },
  { .ov = -1, .code = 0x224c, .word = 0x3e84, .immediate=0, .flags=0x80, .name = "2C:" },
  { .ov = -1, .code = 0x224c, .word = 0x3e9a, .immediate=0, .flags=0x80, .name = "TAB" },
  { .ov = -1, .code = 0x224c, .word = 0x3ebc, .immediate=0, .flags=0x80, .name = "ROOM?" },
  { .ov = -1, .code = 0x224c, .word = 0x3edd, .immediate=0, .flags=0x80, .name = "EXECUTES" },
  { .ov = -1, .code = 0x224c, .word = 0x3ef2, .immediate=0, .flags=0x80, .name = "BINARY" },
  { .ov = -1, .code = 0x224c, .word = 0x3f01, .immediate=0, .flags=0x80, .name = "H." },
  { .ov = -1, .code = 0x224c, .word = 0x3f1b, .immediate=0, .flags=0x80, .name = "RANGE" },
  { .ov = -1, .code = 0x224c, .word = 0x3f2d, .immediate=1, .flags=0x80, .name = "ASCII" },
  { .ov = -1, .code = 0x224c, .word = 0x3f3b, .immediate=0, .flags=0x00, .name = "SET_STR_AS_PARAM" },
  { .ov = -1, .code = 0x224c, .word = 0x3f51, .immediate=1, .flags=0x80, .name = "\"" },
  { .ov = -1, .code = 0x224c, .word = 0x3f8f, .immediate=0, .flags=0x80, .name = "DU<" },
  { .ov = -1, .code = 0x224c, .word = 0x3fb0, .immediate=0, .flags=0x80, .name = "PICK" },
  { .ov = -1, .code = 0x224c, .word = 0x3fcf, .immediate=0, .flags=0x80, .name = "ROLL" },
  { .ov = -1, .code = 0x224c, .word = 0x400f, .immediate=0, .flags=0x80, .name = "2OVER" },
  { .ov = -1, .code = 0x224c, .word = 0x4020, .immediate=0, .flags=0x80, .name = "D-" },
  { .ov = -1, .code = 0x224c, .word = 0x402e, .immediate=0, .flags=0x80, .name = "D0=" },
  { .ov = -1, .code = 0x224c, .word = 0x403b, .immediate=0, .flags=0x80, .name = "D=" },
  { .ov = -1, .code = 0x224c, .word = 0x4048, .immediate=0, .flags=0x80, .name = "D>" },
  { .ov = -1, .code = 0x224c, .word = 0x4059, .immediate=0, .flags=0x80, .name = "WITHIN" },
  { .ov = -1, .code = 0x224c, .word = 0x4076, .immediate=0, .flags=0x80, .name = "DMIN" },
  { .ov = -1, .code = 0x224c, .word = 0x408f, .immediate=0, .flags=0x80, .name = "DMAX" },
  { .ov = -1, .code = 0x224c, .word = 0x40aa, .immediate=1, .flags=0x80, .name = "MYSELF" },
  { .ov = -1, .code = 0x224c, .word = 0x40cf, .immediate=0, .flags=0x80, .name = ">TIB" },
  { .ov = -1, .code = 0x224c, .word = 0x40ef, .immediate=0, .flags=0x80, .name = "DOSPARM" },
  { .ov = -1, .code = 0x224c, .word = 0x4104, .immediate=0, .flags=0x80, .name = "XFCB" },
  { .ov = -1, .code = 0x224c, .word = 0x4116, .immediate=0, .flags=0x80, .name = "DRV" },
  { .ov = -1, .code = 0x224c, .word = 0x4124, .immediate=0, .flags=0x80, .name = "NAM" },
  { .ov = -1, .code = 0x224c, .word = 0x4134, .immediate=0, .flags=0x80, .name = "TYP" },
  { .ov = -1, .code = 0x224c, .word = 0x414b, .immediate=0, .flags=0x80, .name = "CURBLK" },
  { .ov = -1, .code = 0x224c, .word = 0x4163, .immediate=0, .flags=0x80, .name = "RECSIZE" },
  { .ov = -1, .code = 0x224c, .word = 0x417c, .immediate=0, .flags=0x80, .name = "FILESIZE" },
  { .ov = -1, .code = 0x224c, .word = 0x4193, .immediate=0, .flags=0x80, .name = "CURREC" },
  { .ov = -1, .code = 0x224c, .word = 0x41aa, .immediate=0, .flags=0x80, .name = "RELREC" },
  { .ov = -1, .code = 0x224c, .word = 0x41c1, .immediate=0, .flags=0x80, .name = "CLRFCB" },
  { .ov = -1, .code = 0x224c, .word = 0x41e8, .immediate=0, .flags=0x80, .name = "SYSTEM" },
  { .ov = -1, .code = 0x224c, .word = 0x4202, .immediate=0, .flags=0x80, .name = "SYSUTIL" },
  { .ov = -1, .code = 0x224c, .word = 0x421e, .immediate=0, .flags=0x80, .name = "DOSCALL" },
  { .ov = -1, .code = 0x224c, .word = 0x4237, .immediate=0, .flags=0x80, .name = "SELDSK" },
  { .ov = -1, .code = 0x224c, .word = 0x4253, .immediate=0, .flags=0x80, .name = "A::" },
  { .ov = -1, .code = 0x224c, .word = 0x4261, .immediate=0, .flags=0x80, .name = "B::" },
  { .ov = -1, .code = 0x224c, .word = 0x426f, .immediate=0, .flags=0x80, .name = "C::" },
  { .ov = -1, .code = 0x224c, .word = 0x4280, .immediate=0, .flags=0x80, .name = "SETFCB" },
  { .ov = -1, .code = 0x224c, .word = 0x42cf, .immediate=0, .flags=0x80, .name = "INIT" },
  { .ov = -1, .code = 0x224c, .word = 0x42e3, .immediate=0, .flags=0x80, .name = "FCBCALL" },
  { .ov = -1, .code = 0x224c, .word = 0x4302, .immediate=0, .flags=0x80, .name = "OPEN" },
  { .ov = -1, .code = 0x224c, .word = 0x4314, .immediate=0, .flags=0x80, .name = "CLOSE" },
  { .ov = -1, .code = 0x224c, .word = 0x432a, .immediate=0, .flags=0x80, .name = "SEARCH1ST" },
  { .ov = -1, .code = 0x224c, .word = 0x433f, .immediate=0, .flags=0x80, .name = "READNEXT" },
  { .ov = -1, .code = 0x224c, .word = 0x4355, .immediate=0, .flags=0x80, .name = "WRITENEXT" },
  { .ov = -1, .code = 0x224c, .word = 0x4366, .immediate=0, .flags=0x80, .name = "MAKE" },
  { .ov = -1, .code = 0x224c, .word = 0x437a, .immediate=0, .flags=0x80, .name = "DOS-DTA" },
  { .ov = -1, .code = 0x224c, .word = 0x439e, .immediate=0, .flags=0x80, .name = "READ-RANDOM" },
  { .ov = -1, .code = 0x224c, .word = 0x43b7, .immediate=0, .flags=0x80, .name = "WRITE-RANDOM" },
  { .ov = -1, .code = 0x224c, .word = 0x43c1, .immediate=0, .flags=0x00, .name = "W43C1" },
  { .ov = -1, .code = 0x224c, .word = 0x43dd, .immediate=0, .flags=0x80, .name = "MAKE<NAME>" },
  { .ov = -1, .code = 0x224c, .word = 0x4404, .immediate=0, .flags=0x80, .name = "OPEN<NAME>" },
  { .ov = -1, .code = 0x224c, .word = 0x4425, .immediate=0, .flags=0x80, .name = "[FILE]" },
  { .ov = -1, .code = 0x224c, .word = 0x4456, .immediate=0, .flags=0x80, .name = "SYSGEN" },
  { .ov = -1, .code = 0x224c, .word = 0x4492, .immediate=0, .flags=0x80, .name = "4TH>DOS" },
  { .ov = -1, .code = 0x224c, .word = 0x44c2, .immediate=0, .flags=0x00, .name = "W44C2" },
  { .ov = -1, .code = 0x224c, .word = 0x451a, .immediate=0, .flags=0x00, .name = "W451A" },
  { .ov = -1, .code = 0x224c, .word = 0x4536, .immediate=0, .flags=0x00, .name = "W4536" },
  { .ov = -1, .code = 0x224c, .word = 0x454e, .immediate=0, .flags=0x00, .name = "W454E" },
  { .ov = -1, .code = 0x1d29, .word = 0x4567, .immediate=0, .flags=0x80, .name = "MAXDRV" },
  { .ov = -1, .code = 0x224c, .word = 0x4577, .immediate=0, .flags=0x80, .name = "SETMAXDRV" },
  { .ov = -1, .code = 0x224c, .word = 0x45c5, .immediate=0, .flags=0x00, .name = "W45C5" },
  { .ov = -1, .code = 0x224c, .word = 0x45d9, .immediate=0, .flags=0x00, .name = "W45D9" },
  { .ov = -1, .code = 0x224c, .word = 0x45fb, .immediate=0, .flags=0x80, .name = "SMARTOPEN" },
  { .ov = -1, .code = 0x1d29, .word = 0x4658, .immediate=0, .flags=0x80, .name = "ASKMOUNT" },
  { .ov = -1, .code = 0x224c, .word = 0x4669, .immediate=0, .flags=0x80, .name = "<ASKMOUNT>" },
  { .ov = -1, .code = 0x224c, .word = 0x4705, .immediate=0, .flags=0x80, .name = "DOSMOUNT" },
  { .ov = -1, .code = 0x224c, .word = 0x4766, .immediate=0, .flags=0x80, .name = "DOSUNMOUNT" },
  { .ov = -1, .code = 0x224c, .word = 0x477e, .immediate=0, .flags=0x80, .name = "DR2" },
  { .ov = -1, .code = 0x224c, .word = 0x47a4, .immediate=0, .flags=0x80, .name = "DR3" },
  { .ov = -1, .code = 0x224c, .word = 0x47ce, .immediate=0, .flags=0x80, .name = "USING" },
  { .ov = -1, .code = 0x224c, .word = 0x47de, .immediate=0, .flags=0x00, .name = "W47DE" },
  { .ov = -1, .code = 0x224c, .word = 0x481c, .immediate=0, .flags=0x80, .name = "SETSYSK" },
  { .ov = -1, .code = 0x224c, .word = 0x4866, .immediate=0, .flags=0x00, .name = "W4866" },
  { .ov = -1, .code = 0x4873, .word = 0x4873, .immediate=0, .flags=0x80, .name = "ON_2" },
  { .ov = -1, .code = 0x4886, .word = 0x4886, .immediate=0, .flags=0x80, .name = "OFF_2" },
  { .ov = -1, .code = 0x4892, .word = 0x4892, .immediate=0, .flags=0x00, .name = "CAPSON" },
  { .ov = -1, .code = 0x224c, .word = 0x48ab, .immediate=0, .flags=0x80, .name = "KEY_2" },
  { .ov = -1, .code = 0x3b68, .word = 0x48ba, .immediate=0, .flags=0x80, .name = "NULL" },
  { .ov = -1, .code = 0x1d29, .word = 0x48c6, .immediate=0, .flags=0x80, .name = "ZZZ" },
  { .ov = -1, .code = 0x48dc, .word = 0x48dc, .immediate=0, .flags=0x80, .name = "<LCMOVE" },
  { .ov = -1, .code = 0x4910, .word = 0x4910, .immediate=0, .flags=0x80, .name = "2^N" },
  { .ov = -1, .code = 0x224c, .word = 0x4927, .immediate=0, .flags=0x80, .name = "BIT" },
  { .ov = -1, .code = 0x4935, .word = 0x4935, .immediate=0, .flags=0x80, .name = "16/" },
  { .ov = -1, .code = 0x4949, .word = 0x4949, .immediate=0, .flags=0x80, .name = "16*" },
  { .ov = -1, .code = 0x495e, .word = 0x495e, .immediate=0, .flags=0x80, .name = "D16*" },
  { .ov = -1, .code = 0x224c, .word = 0x4977, .immediate=0, .flags=0x80, .name = "3*" },
  { .ov = -1, .code = 0x4984, .word = 0x4984, .immediate=0, .flags=0x80, .name = "3+" },
  { .ov = -1, .code = 0x4997, .word = 0x4997, .immediate=0, .flags=0x80, .name = "1.5@" },
  { .ov = -1, .code = 0x49ae, .word = 0x49ae, .immediate=0, .flags=0x80, .name = "1.5!_2" },
  { .ov = -1, .code = 0x49c2, .word = 0x49c2, .immediate=0, .flags=0x80, .name = "@DS" },
  { .ov = -1, .code = 0x1d29, .word = 0x49ca, .immediate=0, .flags=0x00, .name = "W49CA" },
  { .ov = -1, .code = 0x224c, .word = 0x49e1, .immediate=0, .flags=0x80, .name = "+@" },
  { .ov = -1, .code = 0x49f0, .word = 0x49f0, .immediate=0, .flags=0x80, .name = "L+-@" },
  { .ov = -1, .code = 0x4a0c, .word = 0x4a0c, .immediate=0, .flags=0x80, .name = "PRTSCR" },
  { .ov = -1, .code = 0x4a15, .word = 0x4a15, .immediate=0, .flags=0x00, .name = "W4A15" },
  { .ov = -1, .code = 0x224c, .word = 0x4a41, .immediate=0, .flags=0x80, .name = "CASE" },
  { .ov = -1, .code = 0x224c, .word = 0x4a5f, .immediate=0, .flags=0x80, .name = "IS" },
  { .ov = -1, .code = 0x224c, .word = 0x4a74, .immediate=0, .flags=0x80, .name = "OTHERS" },
  { .ov = -1, .code = 0x224c, .word = 0x4a8e, .immediate=0, .flags=0x80, .name = "CASE:" },
  { .ov = -1, .code = 0x1d29, .word = 0x4ab0, .immediate=0, .flags=0x80, .name = "SEED" },
  { .ov = -1, .code = 0x4abb, .word = 0x4abb, .immediate=0, .flags=0x80, .name = "FRND" },
  { .ov = -1, .code = 0x224c, .word = 0x4ada, .immediate=0, .flags=0x80, .name = "RRND" },
  { .ov = -1, .code = 0x4af3, .word = 0x4af3, .immediate=0, .flags=0x80, .name = "+BIT" },
  { .ov = -1, .code = 0x4b08, .word = 0x4b08, .immediate=0, .flags=0x00, .name = "D2*" },
  { .ov = -1, .code = 0x4b17, .word = 0x4b17, .immediate=0, .flags=0x00, .name = "EASY-BITS" },
  { .ov = -1, .code = 0x224c, .word = 0x4b3e, .immediate=0, .flags=0x00, .name = "2'S-BIT" },
  { .ov = -1, .code = 0x224c, .word = 0x4b78, .immediate=0, .flags=0x00, .name = "1'S-BIT" },
  { .ov = -1, .code = 0x224c, .word = 0x4ba7, .immediate=0, .flags=0x80, .name = "SQRT" },
  { .ov = -1, .code = 0x4bc5, .word = 0x4bc5, .immediate=0, .flags=0x80, .name = "+-@" },
  { .ov = -1, .code = 0x4bd9, .word = 0x4bd9, .immediate=0, .flags=0x80, .name = "L1.5@" },
  { .ov = -1, .code = 0x0c60, .word = 0x4bf7, .immediate=0, .flags=0x80, .name = "<C!>" },
  { .ov = -1, .code = 0x0be1, .word = 0x4bff, .immediate=0, .flags=0x80, .name = "<!>" },
  { .ov = -1, .code = 0x49ae, .word = 0x4c0a, .immediate=0, .flags=0x80, .name = "<1.5!>" },
  { .ov = -1, .code = 0x0f85, .word = 0x4c13, .immediate=0, .flags=0x80, .name = "<+!>" },
  { .ov = -1, .code = 0x0c24, .word = 0x4c1c, .immediate=0, .flags=0x80, .name = "<D!>" },
  { .ov = -1, .code = 0x3aec, .word = 0x4c26, .immediate=1, .flags=0x80, .name = "<OFF>" },
  { .ov = -1, .code = 0x3aec, .word = 0x4c31, .immediate=1, .flags=0x80, .name = "<ON>" },
  { .ov = -1, .code = 0x3aec, .word = 0x4c3f, .immediate=1, .flags=0x80, .name = "<BLOCK>" },
  { .ov = -1, .code = 0x1d29, .word = 0x4c4c, .immediate=0, .flags=0x80, .name = "FILTER" },
  { .ov = -1, .code = 0x1d29, .word = 0x4c57, .immediate=0, .flags=0x80, .name = "PEAK" },
  { .ov = -1, .code = 0x1d29, .word = 0x4c5b, .immediate=0, .flags=0x00, .name = "CURVE" },
  { .ov = -1, .code = 0x4c87, .word = 0x4c87, .immediate=0, .flags=0x80, .name = "(SLIPPER)" },
  { .ov = -1, .code = 0x1d29, .word = 0x4cca, .immediate=0, .flags=0x80, .name = "SPHEREWRAP" },
  { .ov = -1, .code = 0x1d29, .word = 0x4cd8, .immediate=0, .flags=0x80, .name = "SIGNEXTEND" },
  { .ov = -1, .code = 0x1d29, .word = 0x4cdc, .immediate=0, .flags=0x00, .name = "W4CDC" },
  { .ov = -1, .code = 0x1d29, .word = 0x4ce0, .immediate=0, .flags=0x00, .name = "W4CE0" },
  { .ov = -1, .code = 0x1d29, .word = 0x4ce4, .immediate=0, .flags=0x00, .name = "W4CE4" },
  { .ov = -1, .code = 0x1d29, .word = 0x4cf1, .immediate=0, .flags=0x80, .name = "'ARRAY" },
  { .ov = -1, .code = 0x224c, .word = 0x4cff, .immediate=0, .flags=0x80, .name = "ARRAYSE" },
  { .ov = -1, .code = 0x224c, .word = 0x4d14, .immediate=0, .flags=0x80, .name = "#BYTES" },
  { .ov = -1, .code = 0x224c, .word = 0x4d28, .immediate=0, .flags=0x80, .name = "#COLZ" },
  { .ov = -1, .code = 0x224c, .word = 0x4d3a, .immediate=0, .flags=0x80, .name = "#ROWZ" },
  { .ov = -1, .code = 0x224c, .word = 0x4d50, .immediate=0, .flags=0x80, .name = "ACELLADDR" },
  { .ov = -1, .code = 0x4d5c, .word = 0x4d5c, .immediate=0, .flags=0x00, .name = "W4D5C" },
  { .ov = -1, .code = 0x224c, .word = 0x4d85, .immediate=0, .flags=0x80, .name = "A!" },
  { .ov = -1, .code = 0x224c, .word = 0x4d92, .immediate=0, .flags=0x80, .name = "A@" },
  { .ov = -1, .code = 0x4da4, .word = 0x4da4, .immediate=0, .flags=0x80, .name = "!OFFSETS" },
  { .ov = -1, .code = 0x224c, .word = 0x4dda, .immediate=0, .flags=0x80, .name = "ARRAY" },
  { .ov = -1, .code = 0x224c, .word = 0x4e13, .immediate=0, .flags=0x80, .name = "SETLARRAY" },
  { .ov = -1, .code = 0x1d29, .word = 0x4e49, .immediate=0, .flags=0x80, .name = "XLL" },
  { .ov = -1, .code = 0x1d29, .word = 0x4e53, .immediate=0, .flags=0x80, .name = "YLL" },
  { .ov = -1, .code = 0x1d29, .word = 0x4e5d, .immediate=0, .flags=0x80, .name = "XUR" },
  { .ov = -1, .code = 0x1d29, .word = 0x4e67, .immediate=0, .flags=0x80, .name = "YUR" },
  { .ov = -1, .code = 0x224c, .word = 0x4e75, .immediate=0, .flags=0x80, .name = "FULLARRAY" },
  { .ov = -1, .code = 0x224c, .word = 0x4e8f, .immediate=0, .flags=0x80, .name = "SETREGION" },
  { .ov = -1, .code = 0x224c, .word = 0x4ead, .immediate=0, .flags=0x80, .name = "FILLREGION" },
  { .ov = -1, .code = 0x1d29, .word = 0x4edd, .immediate=0, .flags=0x00, .name = "W4EDD" },
  { .ov = -1, .code = 0x224c, .word = 0x4eef, .immediate=0, .flags=0x00, .name = "W4EEF" },
  { .ov = -1, .code = 0x4ef5, .word = 0x4f0c, .immediate=0, .flags=0x80, .name = "BLACK" },
  { .ov = -1, .code = 0x4ef5, .word = 0x4f19, .immediate=0, .flags=0x80, .name = "DK-BLUE" },
  { .ov = -1, .code = 0x4ef5, .word = 0x4f26, .immediate=0, .flags=0x80, .name = "DK-GREEN" },
  { .ov = -1, .code = 0x4ef5, .word = 0x4f31, .immediate=0, .flags=0x80, .name = "GREEN" },
  { .ov = -1, .code = 0x4ef5, .word = 0x4f3a, .immediate=0, .flags=0x80, .name = "RED" },
  { .ov = -1, .code = 0x4ef5, .word = 0x4f46, .immediate=0, .flags=0x80, .name = "VIOLET" },
  { .ov = -1, .code = 0x4ef5, .word = 0x4f51, .immediate=0, .flags=0x80, .name = "BROWN" },
  { .ov = -1, .code = 0x4ef5, .word = 0x4f5c, .immediate=0, .flags=0x80, .name = "GREY1" },
  { .ov = -1, .code = 0x4ef5, .word = 0x4f67, .immediate=0, .flags=0x80, .name = "GREY2" },
  { .ov = -1, .code = 0x4ef5, .word = 0x4f71, .immediate=0, .flags=0x80, .name = "BLUE" },
  { .ov = -1, .code = 0x4ef5, .word = 0x4f7e, .immediate=0, .flags=0x80, .name = "LT-GREEN" },
  { .ov = -1, .code = 0x4ef5, .word = 0x4f8b, .immediate=0, .flags=0x80, .name = "LT-BLUE" },
  { .ov = -1, .code = 0x4ef5, .word = 0x4f95, .immediate=0, .flags=0x80, .name = "PINK" },
  { .ov = -1, .code = 0x4ef5, .word = 0x4fa1, .immediate=0, .flags=0x80, .name = "ORANGE" },
  { .ov = -1, .code = 0x4ef5, .word = 0x4fad, .immediate=0, .flags=0x80, .name = "YELLOW" },
  { .ov = -1, .code = 0x4ef5, .word = 0x4fb8, .immediate=0, .flags=0x80, .name = "WHITE" },
  { .ov = -1, .code = 0x1d29, .word = 0x4fbb, .immediate=0, .flags=0x00, .name = "W4FBB" },
  { .ov = -1, .code = 0x1d29, .word = 0x4fcd, .immediate=0, .flags=0x00, .name = "W4FCD" },
  { .ov = -1, .code = 0x2214, .word = 0x4ffb, .immediate=0, .flags=0x80, .name = "IHEADLEN" },
  { .ov = -1, .code = 0x2214, .word = 0x4fff, .immediate=0, .flags=0x00, .name = "END-CX" },
  { .ov = -1, .code = 0x2214, .word = 0x5003, .immediate=0, .flags=0x00, .name = "END-V" },
  { .ov = -1, .code = 0x2214, .word = 0x5007, .immediate=0, .flags=0x00, .name = "EM" },
  { .ov = -1, .code = 0x2214, .word = 0x5015, .immediate=0, .flags=0x80, .name = "*MAPSCALE" },
  { .ov = -1, .code = 0x2214, .word = 0x5022, .immediate=0, .flags=0x80, .name = "SIGBLK" },
  { .ov = -1, .code = 0x2214, .word = 0x502f, .immediate=0, .flags=0x80, .name = "ALOVSA" },
  { .ov = -1, .code = 0x2214, .word = 0x503c, .immediate=0, .flags=0x80, .name = "AHIVSA" },
  { .ov = -1, .code = 0x2214, .word = 0x5049, .immediate=0, .flags=0x80, .name = "BLOVSA" },
  { .ov = -1, .code = 0x2214, .word = 0x5056, .immediate=0, .flags=0x80, .name = "BHIVSA" },
  { .ov = -1, .code = 0x2214, .word = 0x5064, .immediate=0, .flags=0x80, .name = "'OVBACK" },
  { .ov = -1, .code = 0x2214, .word = 0x5071, .immediate=0, .flags=0x80, .name = "MUSSEG" },
  { .ov = -1, .code = 0x2214, .word = 0x507f, .immediate=0, .flags=0x80, .name = "#REMOTE" },
  { .ov = -1, .code = 0x2214, .word = 0x508a, .immediate=0, .flags=0x80, .name = "#HRS" },
  { .ov = -1, .code = 0x2214, .word = 0x5098, .immediate=0, .flags=0x80, .name = "?FIRED-WEAPONS" },
  { .ov = -1, .code = 0x2214, .word = 0x50a6, .immediate=0, .flags=0x80, .name = "?A-SHIELDS-UP" },
  { .ov = -1, .code = 0x2214, .word = 0x50b4, .immediate=0, .flags=0x80, .name = "?A-WEAP" },
  { .ov = -1, .code = 0x2214, .word = 0x50c2, .immediate=0, .flags=0x80, .name = "DBUF-SIZE" },
  { .ov = -1, .code = 0x2214, .word = 0x50d0, .immediate=0, .flags=0x80, .name = "NULL-ICON" },
  { .ov = -1, .code = 0x2214, .word = 0x50de, .immediate=0, .flags=0x80, .name = "SYS-ICO" },
  { .ov = -1, .code = 0x2214, .word = 0x50ec, .immediate=0, .flags=0x80, .name = "INVIS-I" },
  { .ov = -1, .code = 0x2214, .word = 0x50fa, .immediate=0, .flags=0x80, .name = "FLUX-IC" },
  { .ov = -1, .code = 0x2214, .word = 0x5108, .immediate=0, .flags=0x80, .name = "DEAD-IC" },
  { .ov = -1, .code = 0x2214, .word = 0x5116, .immediate=0, .flags=0x80, .name = "DEFAULT" },
  { .ov = -1, .code = 0x2214, .word = 0x5124, .immediate=0, .flags=0x80, .name = "TEXTC/L" },
  { .ov = -1, .code = 0x2214, .word = 0x5128, .immediate=0, .flags=0x00, .name = "ILIMIT" },
  { .ov = -1, .code = 0x2214, .word = 0x5136, .immediate=0, .flags=0x80, .name = "FUEL/SE" },
  { .ov = -1, .code = 0x2214, .word = 0x5144, .immediate=0, .flags=0x80, .name = "POLYSEG" },
  { .ov = -1, .code = 0x2214, .word = 0x5151, .immediate=0, .flags=0x80, .name = "'ANSYS" },
  { .ov = -1, .code = 0x3b68, .word = 0x515a, .immediate=0, .flags=0x80, .name = "0." },
  { .ov = -1, .code = 0x3b68, .word = 0x516a, .immediate=0, .flags=0x80, .name = "VANEWSPACE" },
  { .ov = -1, .code = 0x3b68, .word = 0x5178, .immediate=0, .flags=0x80, .name = "IROOT" },
  { .ov = -1, .code = 0x3b68, .word = 0x5188, .immediate=0, .flags=0x80, .name = "INACTIVE" },
  { .ov = -1, .code = 0x3b68, .word = 0x5198, .immediate=0, .flags=0x80, .name = "FRAGMENT" },
  { .ov = -1, .code = 0x3b68, .word = 0x51a6, .immediate=0, .flags=0x80, .name = "*SECS" },
  { .ov = -1, .code = 0x3b68, .word = 0x51b6, .immediate=0, .flags=0x80, .name = "*ASSIGN-CREW" },
  { .ov = -1, .code = 0x3b68, .word = 0x51c4, .immediate=0, .flags=0x80, .name = "*SHIP" },
  { .ov = -1, .code = 0x3b68, .word = 0x51d2, .immediate=0, .flags=0x80, .name = "*ASYS" },
  { .ov = -1, .code = 0x3b68, .word = 0x51e0, .immediate=0, .flags=0x80, .name = "*ARTH" },
  { .ov = -1, .code = 0x3b68, .word = 0x51ee, .immediate=0, .flags=0x80, .name = "*ELAN" },
  { .ov = -1, .code = 0x3b68, .word = 0x51fd, .immediate=0, .flags=0x80, .name = "*BRAIN" },
  { .ov = -1, .code = 0x3b68, .word = 0x520d, .immediate=0, .flags=0x80, .name = "*HEAVEN" },
  { .ov = -1, .code = 0x3b68, .word = 0x521d, .immediate=0, .flags=0x80, .name = "*ARREST" },
  { .ov = -1, .code = 0x3b68, .word = 0x522d, .immediate=0, .flags=0x80, .name = "*SPHEXI" },
  { .ov = -1, .code = 0x3b68, .word = 0x5239, .immediate=0, .flags=0x80, .name = "*SP" },
  { .ov = -1, .code = 0x2214, .word = 0x5245, .immediate=0, .flags=0x80, .name = "MPS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5253, .immediate=0, .flags=0x80, .name = "CLIP-TABLE" },
  { .ov = -1, .code = 0x224c, .word = 0x5271, .immediate=0, .flags=0x80, .name = "TABLE" },
  { .ov = -1, .code = 0x2214, .word = 0x528a, .immediate=0, .flags=0x80, .name = "16K" },
  { .ov = -1, .code = 0x1d29, .word = 0x5298, .immediate=0, .flags=0x80, .name = "FONTSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x52a5, .immediate=0, .flags=0x80, .name = "REMSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x52b3, .immediate=0, .flags=0x80, .name = "XBUF-SE" },
  { .ov = -1, .code = 0x1d29, .word = 0x52be, .immediate=0, .flags=0x80, .name = "?ALL" },
  { .ov = -1, .code = 0x1d29, .word = 0x52c9, .immediate=0, .flags=0x80, .name = "?YOK" },
  { .ov = -1, .code = 0x2214, .word = 0x52cd, .immediate=0, .flags=0x00, .name = "W52CD" },
  { .ov = -1, .code = 0x2214, .word = 0x52d1, .immediate=0, .flags=0x00, .name = "W52D1" },
  { .ov = -1, .code = 0x2214, .word = 0x52d5, .immediate=0, .flags=0x00, .name = "7CHAR" },
  { .ov = -1, .code = 0x2214, .word = 0x52d9, .immediate=0, .flags=0x00, .name = "7SPACING" },
  { .ov = -1, .code = 0x2214, .word = 0x52dd, .immediate=0, .flags=0x00, .name = "9CHAR" },
  { .ov = -1, .code = 0x1d29, .word = 0x52e1, .immediate=0, .flags=0x00, .name = "1LOGO" },
  { .ov = -1, .code = 0x1d29, .word = 0x52f1, .immediate=0, .flags=0x00, .name = "BUTTON" },
  { .ov = -1, .code = 0x1d29, .word = 0x52fd, .immediate=0, .flags=0x00, .name = "HIGHLIGHT-BUTTON" },
  { .ov = -1, .code = 0x1d29, .word = 0x5305, .immediate=0, .flags=0x00, .name = "BUTTON-ON" },
  { .ov = -1, .code = 0x1d29, .word = 0x5312, .immediate=0, .flags=0x80, .name = "'XCOMM" },
  { .ov = -1, .code = 0x1d29, .word = 0x531d, .immediate=0, .flags=0x80, .name = "TCLR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5329, .immediate=0, .flags=0x80, .name = "'HEAT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5335, .immediate=0, .flags=0x80, .name = "'TRAK" },
  { .ov = -1, .code = 0x1d29, .word = 0x5343, .immediate=0, .flags=0x80, .name = "TRAK-HR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5351, .immediate=0, .flags=0x80, .name = "A-STRENGTH" },
  { .ov = -1, .code = 0x1d29, .word = 0x535e, .immediate=0, .flags=0x80, .name = "DIRBLK" },
  { .ov = -1, .code = 0x1d29, .word = 0x536c, .immediate=0, .flags=0x80, .name = "TIMESTAMP" },
  { .ov = -1, .code = 0x1d29, .word = 0x537a, .immediate=0, .flags=0x80, .name = "RELAXTIME" },
  { .ov = -1, .code = 0x1d29, .word = 0x5388, .immediate=0, .flags=0x80, .name = "VERSION" },
  { .ov = -1, .code = 0x1d29, .word = 0x5398, .immediate=0, .flags=0x80, .name = "ICONFON" },
  { .ov = -1, .code = 0x1d29, .word = 0x53a5, .immediate=0, .flags=0x80, .name = "LFRAME" },
  { .ov = -1, .code = 0x1d29, .word = 0x53b1, .immediate=0, .flags=0x80, .name = "?AUTO" },
  { .ov = -1, .code = 0x1d29, .word = 0x53bf, .immediate=0, .flags=0x80, .name = "?CRITIC" },
  { .ov = -1, .code = 0x1d29, .word = 0x53cd, .immediate=0, .flags=0x80, .name = "ELEM-AM" },
  { .ov = -1, .code = 0x1d29, .word = 0x53db, .immediate=0, .flags=0x80, .name = "'INJURE" },
  { .ov = -1, .code = 0x1d29, .word = 0x53e9, .immediate=0, .flags=0x80, .name = "P-COLOR" },
  { .ov = -1, .code = 0x1d29, .word = 0x53f8, .immediate=0, .flags=0x80, .name = "P-PHRAS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5406, .immediate=0, .flags=0x80, .name = "P-CARP" },
  { .ov = -1, .code = 0x1d29, .word = 0x5415, .immediate=0, .flags=0x80, .name = "O-COLOR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5422, .immediate=0, .flags=0x80, .name = "HYDRO" },
  { .ov = -1, .code = 0x1d29, .word = 0x542d, .immediate=0, .flags=0x80, .name = "ATMO" },
  { .ov = -1, .code = 0x1d29, .word = 0x543a, .immediate=0, .flags=0x80, .name = "LCOLOR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5447, .immediate=0, .flags=0x80, .name = "'FLARE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5455, .immediate=0, .flags=0x80, .name = "(FLARE)" },
  { .ov = -1, .code = 0x1d29, .word = 0x545f, .immediate=0, .flags=0x80, .name = "?TV" },
  { .ov = -1, .code = 0x1d29, .word = 0x546b, .immediate=0, .flags=0x80, .name = "OLDHR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5477, .immediate=0, .flags=0x80, .name = "AVCNT" },
  { .ov = -1, .code = 0x1d29, .word = 0x547b, .immediate=0, .flags=0x00, .name = "LFILE#" },
  { .ov = -1, .code = 0x1d29, .word = 0x547f, .immediate=0, .flags=0x00, .name = "LRECORD#" },
  { .ov = -1, .code = 0x1d29, .word = 0x5483, .immediate=0, .flags=0x00, .name = "LRECORD#2" },
  { .ov = -1, .code = 0x1d29, .word = 0x548f, .immediate=0, .flags=0x80, .name = "FILE#" },
  { .ov = -1, .code = 0x1d29, .word = 0x549d, .immediate=0, .flags=0x80, .name = "RECORD#" },
  { .ov = -1, .code = 0x1d29, .word = 0x54a1, .immediate=0, .flags=0x00, .name = "1BUFADR" },
  { .ov = -1, .code = 0x1d29, .word = 0x54a5, .immediate=0, .flags=0x00, .name = "2BUFADR" },
  { .ov = -1, .code = 0x1d29, .word = 0x54b0, .immediate=0, .flags=0x80, .name = "CXSP" },
  { .ov = -1, .code = 0x1d29, .word = 0x54b4, .immediate=0, .flags=0x00, .name = "VSP" },
  { .ov = -1, .code = 0x1d29, .word = 0x54b8, .immediate=0, .flags=0x00, .name = "W54B8" },
  { .ov = -1, .code = 0x1d29, .word = 0x54c2, .immediate=0, .flags=0x80, .name = "EDL" },
  { .ov = -1, .code = 0x1d29, .word = 0x54d0, .immediate=0, .flags=0x80, .name = "A-POSTU" },
  { .ov = -1, .code = 0x1d29, .word = 0x54d4, .immediate=0, .flags=0x00, .name = "W54D4" },
  { .ov = -1, .code = 0x1d29, .word = 0x54d8, .immediate=0, .flags=0x00, .name = "#CIRC" },
  { .ov = -1, .code = 0x1d29, .word = 0x54e6, .immediate=0, .flags=0x80, .name = "P-RACES" },
  { .ov = -1, .code = 0x1d29, .word = 0x54ea, .immediate=0, .flags=0x00, .name = "LOISEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x54ee, .immediate=0, .flags=0x00, .name = "HIISEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x54f2, .immediate=0, .flags=0x00, .name = "LOCSEC" },
  { .ov = -1, .code = 0x1d29, .word = 0x54f6, .immediate=0, .flags=0x00, .name = "$SEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x54fa, .immediate=0, .flags=0x00, .name = "W54FA" },
  { .ov = -1, .code = 0x1d29, .word = 0x5508, .immediate=0, .flags=0x80, .name = "'THROW-AWAY" },
  { .ov = -1, .code = 0x1d29, .word = 0x5513, .immediate=0, .flags=0x80, .name = "'MAP" },
  { .ov = -1, .code = 0x1d29, .word = 0x5521, .immediate=0, .flags=0x80, .name = "'TRAVERS" },
  { .ov = -1, .code = 0x1d29, .word = 0x552e, .immediate=0, .flags=0x80, .name = "'?EXIT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5532, .immediate=0, .flags=0x00, .name = "'?CHOICE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5540, .immediate=0, .flags=0x80, .name = "'.FLUX-ICON" },
  { .ov = -1, .code = 0x1d29, .word = 0x554c, .immediate=0, .flags=0x80, .name = "???IT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5556, .immediate=0, .flags=0x80, .name = "?TD" },
  { .ov = -1, .code = 0x1d29, .word = 0x5562, .immediate=0, .flags=0x80, .name = "?BOMB" },
  { .ov = -1, .code = 0x1d29, .word = 0x5570, .immediate=0, .flags=0x80, .name = "?LANDED" },
  { .ov = -1, .code = 0x1d29, .word = 0x5574, .immediate=0, .flags=0x00, .name = "W5574" },
  { .ov = -1, .code = 0x1d29, .word = 0x5578, .immediate=0, .flags=0x00, .name = "QTYINST" },
  { .ov = -1, .code = 0x1d29, .word = 0x557c, .immediate=0, .flags=0x00, .name = "$MAX" },
  { .ov = -1, .code = 0x1d29, .word = 0x5580, .immediate=0, .flags=0x00, .name = "$FREE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5584, .immediate=0, .flags=0x00, .name = "$OLD" },
  { .ov = -1, .code = 0x1d29, .word = 0x5588, .immediate=0, .flags=0x00, .name = "$NEW" },
  { .ov = -1, .code = 0x1d29, .word = 0x558c, .immediate=0, .flags=0x00, .name = "[IOFF]" },
  { .ov = -1, .code = 0x1d29, .word = 0x5590, .immediate=0, .flags=0x00, .name = "LENINST" },
  { .ov = -1, .code = 0x1d29, .word = 0x559b, .immediate=0, .flags=0x80, .name = "-END" },
  { .ov = -1, .code = 0x1d29, .word = 0x55a5, .immediate=0, .flags=0x80, .name = "OV#" },
  { .ov = -1, .code = 0x1d29, .word = 0x55b0, .immediate=0, .flags=0x80, .name = "^VES" },
  { .ov = -1, .code = 0x1d29, .word = 0x55be, .immediate=0, .flags=0x80, .name = "REPAIRT" },
  { .ov = -1, .code = 0x1d29, .word = 0x55ca, .immediate=0, .flags=0x80, .name = "?ELAN" },
  { .ov = -1, .code = 0x1d29, .word = 0x55d8, .immediate=0, .flags=0x80, .name = "HBUF-SEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x55e6, .immediate=0, .flags=0x80, .name = "DBUF-SEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x55f2, .immediate=0, .flags=0x80, .name = "COLOR" },
  { .ov = -1, .code = 0x1d29, .word = 0x55ff, .immediate=0, .flags=0x80, .name = "DCOLOR" },
  { .ov = -1, .code = 0x1d29, .word = 0x560a, .immediate=0, .flags=0x80, .name = "YTAB" },
  { .ov = -1, .code = 0x1d29, .word = 0x5613, .immediate=0, .flags=0x80, .name = "Y1" },
  { .ov = -1, .code = 0x1d29, .word = 0x561c, .immediate=0, .flags=0x80, .name = "X1" },
  { .ov = -1, .code = 0x1d29, .word = 0x5625, .immediate=0, .flags=0x80, .name = "Y2" },
  { .ov = -1, .code = 0x1d29, .word = 0x562e, .immediate=0, .flags=0x80, .name = "X2" },
  { .ov = -1, .code = 0x1d29, .word = 0x563a, .immediate=0, .flags=0x80, .name = "YTABL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5648, .immediate=0, .flags=0x80, .name = "BUF-SEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5656, .immediate=0, .flags=0x80, .name = "BUF-CNT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5663, .immediate=0, .flags=0x80, .name = "RETURN" },
  { .ov = -1, .code = 0x1d29, .word = 0x5671, .immediate=0, .flags=0x80, .name = "?SPHEXI" },
  { .ov = -1, .code = 0x1d29, .word = 0x567c, .immediate=0, .flags=0x80, .name = "?WIN" },
  { .ov = -1, .code = 0x1d29, .word = 0x5686, .immediate=0, .flags=0x80, .name = "#IN" },
  { .ov = -1, .code = 0x1d29, .word = 0x5691, .immediate=0, .flags=0x80, .name = "#OUT" },
  { .ov = -1, .code = 0x1d29, .word = 0x569b, .immediate=0, .flags=0x80, .name = "VIN" },
  { .ov = -1, .code = 0x1d29, .word = 0x56a6, .immediate=0, .flags=0x80, .name = "VOUT" },
  { .ov = -1, .code = 0x1d29, .word = 0x56b0, .immediate=0, .flags=0x80, .name = "OIN" },
  { .ov = -1, .code = 0x1d29, .word = 0x56bb, .immediate=0, .flags=0x80, .name = "OOUT" },
  { .ov = -1, .code = 0x1d29, .word = 0x56bf, .immediate=0, .flags=0x00, .name = "W56BF" },
  { .ov = -1, .code = 0x1d29, .word = 0x56c3, .immediate=0, .flags=0x00, .name = "W56C3" },
  { .ov = -1, .code = 0x1d29, .word = 0x56c7, .immediate=0, .flags=0x00, .name = "W56C7" },
  { .ov = -1, .code = 0x1d29, .word = 0x56cb, .immediate=0, .flags=0x00, .name = "W56CB" },
  { .ov = -1, .code = 0x1d29, .word = 0x56cf, .immediate=0, .flags=0x00, .name = "W56CF" },
  { .ov = -1, .code = 0x1d29, .word = 0x56dc, .immediate=0, .flags=0x80, .name = "TACCPT" },
  { .ov = -1, .code = 0x1d29, .word = 0x56e8, .immediate=0, .flags=0x80, .name = "TRJCT" },
  { .ov = -1, .code = 0x1d29, .word = 0x56f4, .immediate=0, .flags=0x80, .name = "?OPEN" },
  { .ov = -1, .code = 0x1d29, .word = 0x5700, .immediate=0, .flags=0x80, .name = "?EVAL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5704, .immediate=0, .flags=0x00, .name = "W5704" },
  { .ov = -1, .code = 0x1d29, .word = 0x5708, .immediate=0, .flags=0x00, .name = "W5708" },
  { .ov = -1, .code = 0x1d29, .word = 0x570c, .immediate=0, .flags=0x00, .name = "W570C" },
  { .ov = -1, .code = 0x1d29, .word = 0x5710, .immediate=0, .flags=0x00, .name = "W5710" },
  { .ov = -1, .code = 0x1d29, .word = 0x5714, .immediate=0, .flags=0x00, .name = "W5714" },
  { .ov = -1, .code = 0x1d29, .word = 0x5718, .immediate=0, .flags=0x00, .name = "W5718" },
  { .ov = -1, .code = 0x1d29, .word = 0x571c, .immediate=0, .flags=0x00, .name = "W571C" },
  { .ov = -1, .code = 0x1d29, .word = 0x5720, .immediate=0, .flags=0x00, .name = "W5720" },
  { .ov = -1, .code = 0x1d29, .word = 0x5724, .immediate=0, .flags=0x00, .name = "W5724" },
  { .ov = -1, .code = 0x1d29, .word = 0x5728, .immediate=0, .flags=0x00, .name = "W5728" },
  { .ov = -1, .code = 0x1d29, .word = 0x572c, .immediate=0, .flags=0x00, .name = "W572C" },
  { .ov = -1, .code = 0x1d29, .word = 0x5738, .immediate=0, .flags=0x80, .name = "ILEFT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5745, .immediate=0, .flags=0x80, .name = "IRIGHT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5752, .immediate=0, .flags=0x80, .name = "IBELOW" },
  { .ov = -1, .code = 0x1d29, .word = 0x575f, .immediate=0, .flags=0x80, .name = "IABOVE" },
  { .ov = -1, .code = 0x1d29, .word = 0x576a, .immediate=0, .flags=0x80, .name = "'FLY" },
  { .ov = -1, .code = 0x1d29, .word = 0x5778, .immediate=0, .flags=0x80, .name = "'UNNEST" },
  { .ov = -1, .code = 0x1d29, .word = 0x5783, .immediate=0, .flags=0x80, .name = "?NEW" },
  { .ov = -1, .code = 0x1d29, .word = 0x5790, .immediate=0, .flags=0x80, .name = "FORCED" },
  { .ov = -1, .code = 0x1d29, .word = 0x579c, .immediate=0, .flags=0x80, .name = "#VESS" },
  { .ov = -1, .code = 0x1d29, .word = 0x57aa, .immediate=0, .flags=0x80, .name = "CTCOLOR" },
  { .ov = -1, .code = 0x1d29, .word = 0x57b7, .immediate=0, .flags=0x80, .name = "XSTART" },
  { .ov = -1, .code = 0x1d29, .word = 0x57c2, .immediate=0, .flags=0x80, .name = "XEND" },
  { .ov = -1, .code = 0x1d29, .word = 0x57ce, .immediate=0, .flags=0x80, .name = "YLINE" },
  { .ov = -1, .code = 0x1d29, .word = 0x57d9, .immediate=0, .flags=0x80, .name = "SCAN" },
  { .ov = -1, .code = 0x1d29, .word = 0x57dd, .immediate=0, .flags=0x00, .name = "ELEMENT" },
  { .ov = -1, .code = 0x1d29, .word = 0x57e1, .immediate=0, .flags=0x00, .name = "SCAN+" },
  { .ov = -1, .code = 0x1d29, .word = 0x57ec, .immediate=0, .flags=0x80, .name = "YMIN" },
  { .ov = -1, .code = 0x1d29, .word = 0x57f7, .immediate=0, .flags=0x80, .name = "YMAX" },
  { .ov = -1, .code = 0x1d29, .word = 0x57fb, .immediate=0, .flags=0x00, .name = "#HORIZ" },
  { .ov = -1, .code = 0x1d29, .word = 0x5807, .immediate=0, .flags=0x80, .name = "MOVED" },
  { .ov = -1, .code = 0x1d29, .word = 0x5814, .immediate=0, .flags=0x80, .name = "PLANTS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5822, .immediate=0, .flags=0x80, .name = "ANIMALS" },
  { .ov = -1, .code = 0x1d29, .word = 0x582f, .immediate=0, .flags=0x80, .name = "MEMSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x583c, .immediate=0, .flags=0x80, .name = "MEMOFF" },
  { .ov = -1, .code = 0x1d29, .word = 0x584a, .immediate=0, .flags=0x80, .name = "MONITOR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5858, .immediate=0, .flags=0x80, .name = "LOCRADIUS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5863, .immediate=0, .flags=0x80, .name = "YBLT" },
  { .ov = -1, .code = 0x1d29, .word = 0x586e, .immediate=0, .flags=0x80, .name = "XBLT" },
  { .ov = -1, .code = 0x1d29, .word = 0x587c, .immediate=0, .flags=0x80, .name = "XORMODE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5887, .immediate=0, .flags=0x80, .name = "LBLT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5892, .immediate=0, .flags=0x80, .name = "WBLT" },
  { .ov = -1, .code = 0x1d29, .word = 0x589d, .immediate=0, .flags=0x80, .name = "ABLT" },
  { .ov = -1, .code = 0x1d29, .word = 0x58aa, .immediate=0, .flags=0x80, .name = "BLTSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x58b5, .immediate=0, .flags=0x80, .name = "BLT>" },
  { .ov = -1, .code = 0x1d29, .word = 0x58bf, .immediate=0, .flags=0x80, .name = "LPX" },
  { .ov = -1, .code = 0x1d29, .word = 0x58cd, .immediate=0, .flags=0x80, .name = "TILE-PTR" },
  { .ov = -1, .code = 0x1d29, .word = 0x58db, .immediate=0, .flags=0x80, .name = "?FUEL-DIE" },
  { .ov = -1, .code = 0x1d29, .word = 0x58e9, .immediate=0, .flags=0x80, .name = "?G-AWARE" },
  { .ov = -1, .code = 0x1d29, .word = 0x58f3, .immediate=0, .flags=0x80, .name = "GWF" },
  { .ov = -1, .code = 0x1d29, .word = 0x58ff, .immediate=0, .flags=0x80, .name = "DXVIS" },
  { .ov = -1, .code = 0x1d29, .word = 0x590b, .immediate=0, .flags=0x80, .name = "DYVIS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5916, .immediate=0, .flags=0x80, .name = "XCON" },
  { .ov = -1, .code = 0x1d29, .word = 0x5921, .immediate=0, .flags=0x80, .name = "YCON" },
  { .ov = -1, .code = 0x1d29, .word = 0x592d, .immediate=0, .flags=0x80, .name = "DXCON" },
  { .ov = -1, .code = 0x1d29, .word = 0x5939, .immediate=0, .flags=0x80, .name = "DYCON" },
  { .ov = -1, .code = 0x1d29, .word = 0x5944, .immediate=0, .flags=0x80, .name = "XVIS" },
  { .ov = -1, .code = 0x1d29, .word = 0x594f, .immediate=0, .flags=0x80, .name = "YVIS" },
  { .ov = -1, .code = 0x1d29, .word = 0x595d, .immediate=0, .flags=0x80, .name = "XLLDEST" },
  { .ov = -1, .code = 0x1d29, .word = 0x596b, .immediate=0, .flags=0x80, .name = "YLLDEST" },
  { .ov = -1, .code = 0x1d29, .word = 0x5979, .immediate=0, .flags=0x80, .name = "GLOBALSEED" },
  { .ov = -1, .code = 0x1d29, .word = 0x5986, .immediate=0, .flags=0x80, .name = "'.CELL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5994, .immediate=0, .flags=0x80, .name = "'.BACKG" },
  { .ov = -1, .code = 0x1d29, .word = 0x59a2, .immediate=0, .flags=0x80, .name = "'ICON-P" },
  { .ov = -1, .code = 0x1d29, .word = 0x59b0, .immediate=0, .flags=0x80, .name = "'ICONBO" },
  { .ov = -1, .code = 0x1d29, .word = 0x59ba, .immediate=0, .flags=0x80, .name = "'CC" },
  { .ov = -1, .code = 0x1d29, .word = 0x59be, .immediate=0, .flags=0x00, .name = "IXSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x59c2, .immediate=0, .flags=0x00, .name = "IYSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x59c6, .immediate=0, .flags=0x00, .name = "IDSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x59ca, .immediate=0, .flags=0x00, .name = "ICSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x59ce, .immediate=0, .flags=0x00, .name = "ILSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x59da, .immediate=0, .flags=0x80, .name = "IHSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x59e8, .immediate=0, .flags=0x80, .name = "IGLOBAL" },
  { .ov = -1, .code = 0x1d29, .word = 0x59f5, .immediate=0, .flags=0x80, .name = "ILOCAL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a02, .immediate=0, .flags=0x80, .name = "IINDEX" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a0d, .immediate=0, .flags=0x80, .name = "XWLL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a18, .immediate=0, .flags=0x80, .name = "YWLL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a23, .immediate=0, .flags=0x80, .name = "XWUR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a2e, .immediate=0, .flags=0x80, .name = "YWUR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a3c, .immediate=0, .flags=0x80, .name = "*GLOBAL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a4a, .immediate=0, .flags=0x80, .name = "(STOP-COMM)" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a4e, .immediate=0, .flags=0x00, .name = "CENTERADJUST" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a5c, .immediate=0, .flags=0x80, .name = "CONTEXT-ID#" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a65, .immediate=0, .flags=0x80, .name = "EX" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a6e, .immediate=0, .flags=0x80, .name = "EY" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a79, .immediate=0, .flags=0x80, .name = "ERAD" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a86, .immediate=0, .flags=0x80, .name = "XNUMER" },
  { .ov = -1, .code = 0x1d29, .word = 0x5a93, .immediate=0, .flags=0x80, .name = "XDENOM" },
  { .ov = -1, .code = 0x1d29, .word = 0x5aa0, .immediate=0, .flags=0x80, .name = "<ARC1>" },
  { .ov = -1, .code = 0x1d29, .word = 0x5aab, .immediate=0, .flags=0x80, .name = "%EFF" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ab7, .immediate=0, .flags=0x80, .name = "STORM" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ac2, .immediate=0, .flags=0x80, .name = "'TVT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5acf, .immediate=0, .flags=0x80, .name = "'STORM" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ad9, .immediate=0, .flags=0x80, .name = "E/M" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ae7, .immediate=0, .flags=0x80, .name = "FORCEPTASK" },
  { .ov = -1, .code = 0x1d29, .word = 0x5af4, .immediate=0, .flags=0x80, .name = "#STORM" },
  { .ov = -1, .code = 0x1d29, .word = 0x5af8, .immediate=0, .flags=0x00, .name = "W5AF8" },
  { .ov = -1, .code = 0x1d29, .word = 0x5afc, .immediate=0, .flags=0x00, .name = "W5AFC" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b00, .immediate=0, .flags=0x00, .name = "W5B00" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b04, .immediate=0, .flags=0x00, .name = "BICON" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b12, .immediate=0, .flags=0x80, .name = "PORTDAT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b1e, .immediate=0, .flags=0x80, .name = "?PORT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b22, .immediate=0, .flags=0x00, .name = "W5B22" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b26, .immediate=0, .flags=0x00, .name = "W5B26" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b31, .immediate=0, .flags=0x80, .name = "BVIS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b3c, .immediate=0, .flags=0x80, .name = "LVIS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b48, .immediate=0, .flags=0x80, .name = "LFSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b55, .immediate=0, .flags=0x80, .name = "LSYSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b62, .immediate=0, .flags=0x80, .name = "MSYSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b6f, .immediate=0, .flags=0x80, .name = "SSYSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b7d, .immediate=0, .flags=0x80, .name = "?REPAIR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b89, .immediate=0, .flags=0x80, .name = "?HEAL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5b95, .immediate=0, .flags=0x80, .name = "MXNEB" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ba3, .immediate=0, .flags=0x80, .name = "THIS-BUTTON" },
  { .ov = -1, .code = 0x1d29, .word = 0x5bae, .immediate=0, .flags=0x80, .name = "NCRS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5bb9, .immediate=0, .flags=0x80, .name = "OCRS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5bc4, .immediate=0, .flags=0x80, .name = "WTOP" },
  { .ov = -1, .code = 0x1d29, .word = 0x5bd2, .immediate=0, .flags=0x80, .name = "WBOTTOM" },
  { .ov = -1, .code = 0x1d29, .word = 0x5bdf, .immediate=0, .flags=0x80, .name = "WRIGHT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5beb, .immediate=0, .flags=0x80, .name = "WLEFT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5bf8, .immediate=0, .flags=0x80, .name = "WLINES" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c05, .immediate=0, .flags=0x80, .name = "WCHARS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c13, .immediate=0, .flags=0x80, .name = "SKIP2NEST" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c1e, .immediate=0, .flags=0x80, .name = "-AIN" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c2c, .immediate=0, .flags=0x80, .name = "'LAUNCH" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c3a, .immediate=0, .flags=0x80, .name = "?ON-PLA" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c48, .immediate=0, .flags=0x80, .name = "?RECALL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c53, .immediate=0, .flags=0x80, .name = "WMSG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c5e, .immediate=0, .flags=0x80, .name = "?ROD" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c68, .immediate=0, .flags=0x80, .name = "CTX" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c72, .immediate=0, .flags=0x80, .name = "CTY" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c7e, .immediate=0, .flags=0x80, .name = "FTRIG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c8a, .immediate=0, .flags=0x80, .name = "FQUIT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5c95, .immediate=0, .flags=0x80, .name = "LKEY" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ca3, .immediate=0, .flags=0x80, .name = "'BUTTON" },
  { .ov = -1, .code = 0x1d29, .word = 0x5cb1, .immediate=0, .flags=0x80, .name = "BTN-REC" },
  { .ov = -1, .code = 0x1d29, .word = 0x5cbf, .immediate=0, .flags=0x80, .name = "CRSCOLO" },
  { .ov = -1, .code = 0x1d29, .word = 0x5cc3, .immediate=0, .flags=0x00, .name = "(SRDEPTH)" },
  { .ov = -1, .code = 0x1d29, .word = 0x5cce, .immediate=0, .flags=0x80, .name = "?>OP" },
  { .ov = -1, .code = 0x1d29, .word = 0x5cda, .immediate=0, .flags=0x80, .name = "'YANK" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ce4, .immediate=0, .flags=0x80, .name = "?12" },
  { .ov = -1, .code = 0x1d29, .word = 0x5cf1, .immediate=0, .flags=0x80, .name = "'+VESS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5cfc, .immediate=0, .flags=0x80, .name = "?NEB" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d0a, .immediate=0, .flags=0x80, .name = "FORCEKEY" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d15, .immediate=0, .flags=0x80, .name = "%VAL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d23, .immediate=0, .flags=0x80, .name = "SCROLL-" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d31, .immediate=0, .flags=0x80, .name = "[#CACHE]" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d3e, .immediate=0, .flags=0x80, .name = "ESC-EN" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d4c, .immediate=0, .flags=0x80, .name = "ESC-PFA" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d5a, .immediate=0, .flags=0x80, .name = "LINE-COUNT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d67, .immediate=0, .flags=0x80, .name = "PM-PTR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d6b, .immediate=0, .flags=0x00, .name = "?REUSE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d76, .immediate=0, .flags=0x80, .name = "SKEY" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d81, .immediate=0, .flags=0x80, .name = "#AUX" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d8d, .immediate=0, .flags=0x80, .name = "WADDR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5d98, .immediate=0, .flags=0x80, .name = "MASK" },
  { .ov = -1, .code = 0x1d29, .word = 0x5da3, .immediate=0, .flags=0x80, .name = "?EGA" },
  { .ov = -1, .code = 0x1d29, .word = 0x5dae, .immediate=0, .flags=0x80, .name = "XABS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5db9, .immediate=0, .flags=0x80, .name = "YABS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5dc7, .immediate=0, .flags=0x80, .name = "HEADING" },
  { .ov = -1, .code = 0x1d29, .word = 0x5dd3, .immediate=0, .flags=0x80, .name = "3DSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5dde, .immediate=0, .flags=0x80, .name = "VIN'" },
  { .ov = -1, .code = 0x1d29, .word = 0x5dec, .immediate=0, .flags=0x80, .name = "YSCREEN" },
  { .ov = -1, .code = 0x1d29, .word = 0x5dfa, .immediate=0, .flags=0x80, .name = "XSCREEN" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e08, .immediate=0, .flags=0x80, .name = "'COMBAT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e14, .immediate=0, .flags=0x80, .name = "'CEX+" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e1f, .immediate=0, .flags=0x80, .name = "'CEX" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e2a, .immediate=0, .flags=0x80, .name = "'WAX" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e38, .immediate=0, .flags=0x80, .name = "TERMINA" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e46, .immediate=0, .flags=0x80, .name = "?COMBAT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e54, .immediate=0, .flags=0x80, .name = "?ATTACK" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e58, .immediate=0, .flags=0x00, .name = "?RECYCLED" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e66, .immediate=0, .flags=0x80, .name = "STAR-HR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e74, .immediate=0, .flags=0x80, .name = "STARDATE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e82, .immediate=0, .flags=0x80, .name = "TIME-PASSING" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e90, .immediate=0, .flags=0x80, .name = "#CLRMAP" },
  { .ov = -1, .code = 0x1d29, .word = 0x5e9b, .immediate=0, .flags=0x80, .name = "PLHI" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ea9, .immediate=0, .flags=0x80, .name = "'PROCES" },
  { .ov = -1, .code = 0x1d29, .word = 0x5eb6, .immediate=0, .flags=0x80, .name = "CURSEG" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ec4, .immediate=0, .flags=0x80, .name = "'SIMULA" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ed1, .immediate=0, .flags=0x80, .name = "'DEATH" },
  { .ov = -1, .code = 0x1d29, .word = 0x5edf, .immediate=0, .flags=0x80, .name = "'ENDING" },
  { .ov = -1, .code = 0x1d29, .word = 0x5eed, .immediate=0, .flags=0x80, .name = "[KEYINT]" },
  { .ov = -1, .code = 0x1d29, .word = 0x5efb, .immediate=0, .flags=0x80, .name = "'CLEANU" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f09, .immediate=0, .flags=0x80, .name = "'KEY-CA" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f17, .immediate=0, .flags=0x80, .name = "'.VITAL" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f24, .immediate=0, .flags=0x80, .name = "'.DATE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f32, .immediate=0, .flags=0x80, .name = "'.VEHICLE-STATUS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f40, .immediate=0, .flags=0x80, .name = "'VEHICLE-CYCLE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f4e, .immediate=0, .flags=0x80, .name = "'CREW-C" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f5c, .immediate=0, .flags=0x80, .name = "'EXTERNAL-EVENTS" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f6a, .immediate=0, .flags=0x80, .name = "'REPAIR" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f78, .immediate=0, .flags=0x80, .name = "'TREATM" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f86, .immediate=0, .flags=0x80, .name = "WEAPON-" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f92, .immediate=0, .flags=0x80, .name = "^CRIT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5f9e, .immediate=0, .flags=0x80, .name = "?FLAT" },
  { .ov = -1, .code = 0x1d29, .word = 0x5fa9, .immediate=0, .flags=0x80, .name = "?SUP" },
  { .ov = -1, .code = 0x1d29, .word = 0x5fb5, .immediate=0, .flags=0x80, .name = "E-USE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5fc3, .immediate=0, .flags=0x80, .name = "'ENERGY" },
  { .ov = -1, .code = 0x1d29, .word = 0x5fd1, .immediate=0, .flags=0x80, .name = "?SECURE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5fdc, .immediate=0, .flags=0x80, .name = "'STP" },
  { .ov = -1, .code = 0x1d29, .word = 0x5fe9, .immediate=0, .flags=0x80, .name = "'RSIDE" },
  { .ov = -1, .code = 0x1d29, .word = 0x5ff6, .immediate=0, .flags=0x80, .name = "DERROR" },
  { .ov = -1, .code = 0x5275, .word = 0x6000, .immediate=0, .flags=0x80, .name = "OVT" },
  { .ov = -1, .code = 0x1d29, .word = 0x601f, .immediate=0, .flags=0x80, .name = "BITS" },
  { .ov = -1, .code = 0x1d29, .word = 0x602b, .immediate=0, .flags=0x80, .name = "#BITS" },
  { .ov = -1, .code = 0x224c, .word = 0x602f, .immediate=0, .flags=0x00, .name = "W602F" },
  { .ov = -1, .code = 0x224c, .word = 0x603b, .immediate=0, .flags=0x00, .name = "W603B" },
  { .ov = -1, .code = 0x224c, .word = 0x6043, .immediate=0, .flags=0x00, .name = "W6043" },
  { .ov = -1, .code = 0x4a96, .word = 0x6053, .immediate=0, .flags=0x80, .name = "CCASE" },
  { .ov = -1, .code = 0x224c, .word = 0x606f, .immediate=0, .flags=0x80, .name = "COLORCA" },
  { .ov = -1, .code = 0x1d29, .word = 0x608b, .immediate=0, .flags=0x80, .name = "TIRED-TIME" },
  { .ov = -1, .code = 0x1d29, .word = 0x609b, .immediate=0, .flags=0x80, .name = "LASTREP" },
  { .ov = -1, .code = 0x1d29, .word = 0x60ab, .immediate=0, .flags=0x80, .name = "TALKCOU" },
  { .ov = -1, .code = 0x1d29, .word = 0x60ba, .immediate=0, .flags=0x80, .name = "VSTIME" },
  { .ov = -1, .code = 0x1d29, .word = 0x60ca, .immediate=0, .flags=0x80, .name = "10*CARGO" },
  { .ov = -1, .code = 0x1d29, .word = 0x60da, .immediate=0, .flags=0x80, .name = "SENSE-ADDR" },
  { .ov = -1, .code = 0x1d29, .word = 0x60e8, .immediate=0, .flags=0x80, .name = "EYEXY" },
  { .ov = -1, .code = 0x1d29, .word = 0x60f7, .immediate=0, .flags=0x80, .name = "WEAPXY" },
  { .ov = -1, .code = 0x1d29, .word = 0x6106, .immediate=0, .flags=0x80, .name = "10*END" },
  { .ov = -1, .code = 0x1d29, .word = 0x6116, .immediate=0, .flags=0x80, .name = "TOWFINE" },
  { .ov = -1, .code = 0x1d29, .word = 0x6126, .immediate=0, .flags=0x80, .name = "ENC-TIME" },
  { .ov = -1, .code = 0x1d29, .word = 0x6136, .immediate=0, .flags=0x80, .name = "NAV-TIME" },
  { .ov = -1, .code = 0x1d29, .word = 0x613c, .immediate=0, .flags=0x00, .name = "W613C" },
  { .ov = -1, .code = 0x1d29, .word = 0x614a, .immediate=0, .flags=0x80, .name = "STIME" },
  { .ov = -1, .code = 0x1d29, .word = 0x6150, .immediate=0, .flags=0x00, .name = "W6150" },
  { .ov = -1, .code = 0x1d29, .word = 0x6156, .immediate=0, .flags=0x00, .name = "W6156" },
  { .ov = -1, .code = 0x1d29, .word = 0x615c, .immediate=0, .flags=0x00, .name = "IADDR" },
  { .ov = -1, .code = 0x1d29, .word = 0x6162, .immediate=0, .flags=0x00, .name = "W6162" },
  { .ov = -1, .code = 0x1d29, .word = 0x6172, .immediate=0, .flags=0x80, .name = "KEYTIME" },
  { .ov = -1, .code = 0x1d29, .word = 0x6182, .immediate=0, .flags=0x80, .name = "LKEYTIM" },
  { .ov = -1, .code = 0x1d29, .word = 0x6192, .immediate=0, .flags=0x80, .name = "(SCROLL-BOX)" },
  { .ov = -1, .code = 0x1d29, .word = 0x61a2, .immediate=0, .flags=0x80, .name = "(ORIGINATOR)" },
  { .ov = -1, .code = 0x1d29, .word = 0x61b2, .immediate=0, .flags=0x80, .name = "(SCROLL-CONT)" },
  { .ov = -1, .code = 0x1d29, .word = 0x61c2, .immediate=0, .flags=0x80, .name = "(AWARD)" },
  { .ov = -1, .code = 0x1d29, .word = 0x61d2, .immediate=0, .flags=0x80, .name = "BOX-IADDR" },
  { .ov = -1, .code = 0x1d29, .word = 0x61e1, .immediate=0, .flags=0x80, .name = "(BOMB)" },
  { .ov = -1, .code = 0x1d29, .word = 0x61f1, .immediate=0, .flags=0x80, .name = "REAL-MS" },
  { .ov = -1, .code = 0x1d29, .word = 0x6201, .immediate=0, .flags=0x80, .name = "LAST-UPDATE" },
  { .ov = -1, .code = 0x1d29, .word = 0x6211, .immediate=0, .flags=0x80, .name = "XWLD:XPIX" },
  { .ov = -1, .code = 0x1d29, .word = 0x6221, .immediate=0, .flags=0x80, .name = "YWLD:YPIX" },
  { .ov = -1, .code = 0x1d29, .word = 0x6230, .immediate=0, .flags=0x80, .name = "ANCHOR-CONTOUR" },
  { .ov = -1, .code = 0x1d29, .word = 0x6240, .immediate=0, .flags=0x80, .name = "OK-TALK" },
  { .ov = -1, .code = 0x1d29, .word = 0x6250, .immediate=0, .flags=0x80, .name = "(STARPO" },
  { .ov = -1, .code = 0x1d29, .word = 0x625f, .immediate=0, .flags=0x80, .name = "(SHIP)" },
  { .ov = -1, .code = 0x1d29, .word = 0x626f, .immediate=0, .flags=0x80, .name = "TVEHICLE" },
  { .ov = -1, .code = 0x1d29, .word = 0x627f, .immediate=0, .flags=0x80, .name = "TV-HOLD" },
  { .ov = -1, .code = 0x1d29, .word = 0x628f, .immediate=0, .flags=0x80, .name = "SUPER-BOX" },
  { .ov = -1, .code = 0x1d29, .word = 0x629f, .immediate=0, .flags=0x80, .name = "(SYSTEM)" },
  { .ov = -1, .code = 0x1d29, .word = 0x62af, .immediate=0, .flags=0x80, .name = "(ORBIT)" },
  { .ov = -1, .code = 0x1d29, .word = 0x62bf, .immediate=0, .flags=0x80, .name = "(PLANET)" },
  { .ov = -1, .code = 0x1d29, .word = 0x62cf, .immediate=0, .flags=0x80, .name = "(SURFACE)" },
  { .ov = -1, .code = 0x1d29, .word = 0x62df, .immediate=0, .flags=0x80, .name = "(ENCOUNTER)" },
  { .ov = -1, .code = 0x1d29, .word = 0x62ef, .immediate=0, .flags=0x80, .name = "(SHIPBOX)" },
  { .ov = -1, .code = 0x1d29, .word = 0x62ff, .immediate=0, .flags=0x80, .name = "(AORIGINATOR)" },
  { .ov = -1, .code = 0x1d29, .word = 0x630f, .immediate=0, .flags=0x80, .name = "THIS-REGION" },
  { .ov = -1, .code = 0x1d29, .word = 0x631f, .immediate=0, .flags=0x80, .name = "(THIS-ITEM)" },
  { .ov = -1, .code = 0x1d29, .word = 0x6325, .immediate=0, .flags=0x00, .name = "KEYINTADDR" },
  { .ov = -1, .code = 0x1d29, .word = 0x6329, .immediate=0, .flags=0x00, .name = "CXS" },
  { .ov = -1, .code = 0x1d29, .word = 0x63a3, .immediate=0, .flags=0x00, .name = "VSTK" },
  { .ov = -1, .code = 0x1d29, .word = 0x63ec, .immediate=0, .flags=0x80, .name = "IBFR" },
  { .ov = -1, .code = 0x1d29, .word = 0x6508, .immediate=0, .flags=0x80, .name = "YTABLE" },
  { .ov = -1, .code = 0x1d29, .word = 0x66a4, .immediate=0, .flags=0x80, .name = "VYTABLE" },
  { .ov = -1, .code = 0x1d29, .word = 0x679e, .immediate=0, .flags=0x80, .name = "LSCAN" },
  { .ov = -1, .code = 0x1d29, .word = 0x6930, .immediate=0, .flags=0x00, .name = "NEB-TABLE" },
  { .ov = -1, .code = 0x1d29, .word = 0x6972, .immediate=0, .flags=0x00, .name = "NEB2" },
  { .ov = -1, .code = 0x1d29, .word = 0x69b4, .immediate=0, .flags=0x00, .name = "V1" },
  { .ov = -1, .code = 0x1d29, .word = 0x69f6, .immediate=0, .flags=0x00, .name = "V2" },
  { .ov = -1, .code = 0x1d29, .word = 0x6a3f, .immediate=0, .flags=0x80, .name = "CMAP" },
  { .ov = -1, .code = 0x1d29, .word = 0x6a89, .immediate=0, .flags=0x80, .name = "LRTRN" },
  { .ov = -1, .code = 0x4e00, .word = 0x6a99, .immediate=0, .flags=0x80, .name = "MERCATOR" },
  { .ov = -1, .code = 0x4e00, .word = 0x6aad, .immediate=0, .flags=0x80, .name = "CONANCHOR" },
  { .ov = -1, .code = 0x4e00, .word = 0x6ac1, .immediate=0, .flags=0x80, .name = "CONTOUR" },
  { .ov = -1, .code = 0x4e00, .word = 0x6ad5, .immediate=0, .flags=0x80, .name = "ICONIMA" },
  { .ov = -1, .code = 0x4e00, .word = 0x6ae8, .immediate=0, .flags=0x80, .name = "VERTEX" },
  { .ov = -1, .code = 0x4e00, .word = 0x6afa, .immediate=0, .flags=0x80, .name = "FACET" },
  { .ov = -1, .code = 0x4e00, .word = 0x6b0b, .immediate=0, .flags=0x80, .name = "FACE" },
  { .ov = -1, .code = 0x4e00, .word = 0x6b1d, .immediate=0, .flags=0x80, .name = "PPOLY" },
  { .ov = -1, .code = 0x4e00, .word = 0x6b31, .immediate=0, .flags=0x80, .name = "GVERTEX>GRIDCOLOR" },
  { .ov = -1, .code = 0x4e00, .word = 0x6b43, .immediate=0, .flags=0x80, .name = "GPOLY" },
  { .ov = -1, .code = 0x4e00, .word = 0x6b57, .immediate=0, .flags=0x80, .name = "GRIDCOLOR" },
  { .ov = -1, .code = 0x4e00, .word = 0x6b6a, .immediate=0, .flags=0x80, .name = "G1VERT" },
  { .ov = -1, .code = 0x4e00, .word = 0x6b7e, .immediate=0, .flags=0x80, .name = "9X9COARSE" },
  { .ov = -1, .code = 0x4e00, .word = 0x6b92, .immediate=0, .flags=0x80, .name = "9X9FINE>GVERTEX" },
  { .ov = -1, .code = 0x4e00, .word = 0x6ba6, .immediate=0, .flags=0x80, .name = "XFORMVERT" },
  { .ov = -1, .code = 0x5275, .word = 0x6bba, .immediate=0, .flags=0x80, .name = "IARRAYS" },
  { .ov = -1, .code = 0x3b68, .word = 0x6be4, .immediate=0, .flags=0x80, .name = "*STARPO" },
  { .ov = -1, .code = 0x3b68, .word = 0x6bf4, .immediate=0, .flags=0x80, .name = "*PERSON" },
  { .ov = -1, .code = 0x3b68, .word = 0x6c04, .immediate=0, .flags=0x80, .name = "*SHIP-CONFIG" },
  { .ov = -1, .code = 0x3b68, .word = 0x6c14, .immediate=0, .flags=0x80, .name = "*TRADE-" },
  { .ov = -1, .code = 0x3b68, .word = 0x6c24, .immediate=0, .flags=0x80, .name = "*ITEMS-" },
  { .ov = -1, .code = 0x3b68, .word = 0x6c34, .immediate=0, .flags=0x80, .name = "*OPERAT" },
  { .ov = -1, .code = 0x3b68, .word = 0x6c42, .immediate=0, .flags=0x80, .name = "*BANK" },
  { .ov = -1, .code = 0x3b68, .word = 0x6c52, .immediate=0, .flags=0x80, .name = "*STARSHIP-HOLD" },
  { .ov = -1, .code = 0x1d29, .word = 0x6c62, .immediate=0, .flags=0x80, .name = "'VERSIONERR" },
  { .ov = -1, .code = 0x1d29, .word = 0x6c6e, .immediate=0, .flags=0x80, .name = "CTTOP" },
  { .ov = -1, .code = 0x1d29, .word = 0x6c7a, .immediate=0, .flags=0x80, .name = "CTBOT" },
  { .ov = -1, .code = 0x6c86, .word = 0x6c86, .immediate=0, .flags=0x80, .name = "C>EGA" },
  { .ov = -1, .code = 0x224c, .word = 0x6cc0, .immediate=0, .flags=0x80, .name = "?>EGA" },
  { .ov = -1, .code = 0x6cd6, .word = 0x6cd6, .immediate=0, .flags=0x80, .name = "E>CGA" },
  { .ov = -1, .code = 0x6d12, .word = 0x6d12, .immediate=0, .flags=0x80, .name = "?UPDATE" },
  { .ov = -1, .code = 0x224c, .word = 0x6d6c, .immediate=0, .flags=0x80, .name = "C!" },
  { .ov = -1, .code = 0x224c, .word = 0x6d78, .immediate=0, .flags=0x80, .name = "!_3" },
  { .ov = -1, .code = 0x224c, .word = 0x6d85, .immediate=0, .flags=0x80, .name = "+!_2" },
  { .ov = -1, .code = 0x224c, .word = 0x6d94, .immediate=0, .flags=0x80, .name = "1.5!" },
  { .ov = -1, .code = 0x224c, .word = 0x6da1, .immediate=0, .flags=0x80, .name = "2!" },
  { .ov = -1, .code = 0x224c, .word = 0x6dae, .immediate=0, .flags=0x80, .name = "D!" },
  { .ov = -1, .code = 0x224c, .word = 0x6db9, .immediate=0, .flags=0x80, .name = "ON_3" },
  { .ov = -1, .code = 0x224c, .word = 0x6dc7, .immediate=0, .flags=0x80, .name = "OFF" },
  { .ov = -1, .code = 0x224c, .word = 0x6dd6, .immediate=0, .flags=0x80, .name = "2OFF" },
  { .ov = -1, .code = 0x224c, .word = 0x6dec, .immediate=0, .flags=0x80, .name = "CMOVE" },
  { .ov = -1, .code = 0x224c, .word = 0x6dff, .immediate=0, .flags=0x80, .name = "FILL_1" },
  { .ov = -1, .code = 0x224c, .word = 0x6e0d, .immediate=0, .flags=0x00, .name = "W6E0D" },
  { .ov = -1, .code = 0x224c, .word = 0x6e21, .immediate=0, .flags=0x80, .name = "BLOCK_2" },
  { .ov = -1, .code = 0x224c, .word = 0x6e32, .immediate=0, .flags=0x80, .name = "LBLOCK_2" },
  { .ov = -1, .code = 0x224c, .word = 0x6e41, .immediate=0, .flags=0x80, .name = "LOAD_1" },
  { .ov = -1, .code = 0x224c, .word = 0x6e51, .immediate=0, .flags=0x80, .name = "-TEXT" },
  { .ov = -1, .code = 0x224c, .word = 0x6e8e, .immediate=0, .flags=0x80, .name = "$=" },
  { .ov = -1, .code = 0x224c, .word = 0x6ebb, .immediate=0, .flags=0x80, .name = "SIGFLD" },
  { .ov = -1, .code = 0x6ec1, .word = 0x6eda, .immediate=0, .flags=0x80, .name = ":SIGNATURE" },
  { .ov = -1, .code = 0x6ec1, .word = 0x6ee8, .immediate=0, .flags=0x80, .name = ":TIMESTAMP" },
  { .ov = -1, .code = 0x6ec1, .word = 0x6ef5, .immediate=0, .flags=0x80, .name = ":CKSUM" },
  { .ov = -1, .code = 0x6ec1, .word = 0x6f01, .immediate=0, .flags=0x80, .name = ":SAVE" },
  { .ov = -1, .code = 0x6ec1, .word = 0x6f0f, .immediate=0, .flags=0x80, .name = ":VERSION" },
  { .ov = -1, .code = 0x224c, .word = 0x6f1a, .immediate=0, .flags=0x80, .name = "THRU_2" },
  { .ov = -1, .code = 0x6f49, .word = 0x6f49, .immediate=0, .flags=0x80, .name = "VA>BLK" },
  { .ov = -1, .code = 0x224c, .word = 0x6f6d, .immediate=0, .flags=0x80, .name = "VA>BUF" },
  { .ov = -1, .code = 0x224c, .word = 0x6f77, .immediate=0, .flags=0x00, .name = "W6F77" },
  { .ov = -1, .code = 0x224c, .word = 0x6f81, .immediate=0, .flags=0x00, .name = "?AFILE" },
  { .ov = -1, .code = 0x224c, .word = 0x6f8f, .immediate=0, .flags=0x00, .name = "W6F8F" },
  { .ov = -1, .code = 0x224c, .word = 0x6fa3, .immediate=0, .flags=0x00, .name = "W6FA3" },
  { .ov = -1, .code = 0x224c, .word = 0x6fb1, .immediate=0, .flags=0x00, .name = "W6FB1" },
  { .ov = -1, .code = 0x1d29, .word = 0x6fb9, .immediate=0, .flags=0x00, .name = "W6FB9" },
  { .ov = -1, .code = 0x224c, .word = 0x6fbd, .immediate=0, .flags=0x00, .name = "W6FBD" },
  { .ov = -1, .code = 0x224c, .word = 0x6fdb, .immediate=0, .flags=0x00, .name = "W6FDB" },
  { .ov = -1, .code = 0x224c, .word = 0x6fe7, .immediate=0, .flags=0x00, .name = "W6FE7" },
  { .ov = -1, .code = 0x224c, .word = 0x6ffc, .immediate=0, .flags=0x80, .name = "MOUNTA" },
  { .ov = -1, .code = 0x224c, .word = 0x701f, .immediate=0, .flags=0x80, .name = "MOUNTB" },
  { .ov = -1, .code = 0x224c, .word = 0x7039, .immediate=0, .flags=0x00, .name = "W7039" },
  { .ov = -1, .code = 0x224c, .word = 0x704b, .immediate=0, .flags=0x00, .name = "W704B" },
  { .ov = -1, .code = 0x224c, .word = 0x7063, .immediate=0, .flags=0x00, .name = "MOUNT-VSA" },
  { .ov = -1, .code = 0x224c, .word = 0x7075, .immediate=0, .flags=0x00, .name = "W7075" },
  { .ov = -1, .code = 0x224c, .word = 0x70cb, .immediate=0, .flags=0x00, .name = "VSA>VA" },
  { .ov = -1, .code = 0x224c, .word = 0x70d9, .immediate=0, .flags=0x00, .name = "W70D9" },
  { .ov = -1, .code = 0x224c, .word = 0x7173, .immediate=0, .flags=0x80, .name = "MEM>DSK" },
  { .ov = -1, .code = 0x224c, .word = 0x7185, .immediate=0, .flags=0x80, .name = "MEM<DSK" },
  { .ov = -1, .code = 0x718d, .word = 0x718d, .immediate=0, .flags=0x00, .name = "RECADD" },
  { .ov = -1, .code = 0x71dd, .word = 0x71dd, .immediate=0, .flags=0x00, .name = "DOFFBLK" },
  { .ov = -1, .code = 0x224c, .word = 0x7221, .immediate=0, .flags=0x00, .name = "DFIELD" },
  { .ov = -1, .code = 0x7227, .word = 0x7244, .immediate=0, .flags=0x80, .name = "FILE-NAME" },
  { .ov = -1, .code = 0x7227, .word = 0x7251, .immediate=0, .flags=0x80, .name = "FILE-TYPE" },
  { .ov = -1, .code = 0x7227, .word = 0x725e, .immediate=0, .flags=0x80, .name = "FILE-START" },
  { .ov = -1, .code = 0x7227, .word = 0x726b, .immediate=0, .flags=0x80, .name = "FILE-END" },
  { .ov = -1, .code = 0x7227, .word = 0x7278, .immediate=0, .flags=0x80, .name = "FILE-#REC" },
  { .ov = -1, .code = 0x7227, .word = 0x7285, .immediate=0, .flags=0x80, .name = "FILE-RLEN" },
  { .ov = -1, .code = 0x7227, .word = 0x7292, .immediate=0, .flags=0x80, .name = "FILE-SLEN" },
  { .ov = -1, .code = 0x7295, .word = 0x7295, .immediate=0, .flags=0x00, .name = "BVSA>OFFBLK" },
  { .ov = -1, .code = 0x224c, .word = 0x72b9, .immediate=1, .flags=0x80, .name = "FILE:" },
  { .ov = -1, .code = 0x224c, .word = 0x731f, .immediate=0, .flags=0x80, .name = ">FILE" },
  { .ov = -1, .code = 0x224c, .word = 0x7339, .immediate=0, .flags=0x80, .name = "FILE<" },
  { .ov = -1, .code = 0x224c, .word = 0x734b, .immediate=0, .flags=0x00, .name = "?BMOUNT" },
  { .ov = -1, .code = 0x224c, .word = 0x7357, .immediate=0, .flags=0x00, .name = "|REC" },
  { .ov = -1, .code = 0x224c, .word = 0x7379, .immediate=0, .flags=0x00, .name = "?-RECINBUF" },
  { .ov = -1, .code = 0x224c, .word = 0x739b, .immediate=0, .flags=0x80, .name = "@RECORD" },
  { .ov = -1, .code = 0x224c, .word = 0x73c8, .immediate=0, .flags=0x80, .name = "AFIELD" },
  { .ov = -1, .code = 0x7425, .word = 0x7425, .immediate=0, .flags=0x00, .name = "IFLDADR" },
  { .ov = -1, .code = 0x224c, .word = 0x743f, .immediate=0, .flags=0x80, .name = "IFIELD" },
  { .ov = -1, .code = 0x744d, .word = 0x7460, .immediate=0, .flags=0x80, .name = "INST-SIB" },
  { .ov = -1, .code = 0x744d, .word = 0x746f, .immediate=0, .flags=0x80, .name = "INST-PREV" },
  { .ov = -1, .code = 0x744d, .word = 0x747e, .immediate=0, .flags=0x80, .name = "INST-OFF" },
  { .ov = -1, .code = 0x744d, .word = 0x748d, .immediate=0, .flags=0x80, .name = "INST-CLASS" },
  { .ov = -1, .code = 0x744d, .word = 0x749c, .immediate=0, .flags=0x80, .name = "INST-SPECIES" },
  { .ov = -1, .code = 0x744d, .word = 0x74ab, .immediate=0, .flags=0x80, .name = "INST-QTY" },
  { .ov = -1, .code = 0x744d, .word = 0x74b9, .immediate=0, .flags=0x80, .name = "INST-X" },
  { .ov = -1, .code = 0x744d, .word = 0x74c7, .immediate=0, .flags=0x80, .name = "INST-Y" },
  { .ov = -1, .code = 0x224c, .word = 0x74cc, .immediate=0, .flags=0x00, .name = "!INST-SIB" },
  { .ov = -1, .code = 0x224c, .word = 0x74d4, .immediate=0, .flags=0x00, .name = "!INST-PREV" },
  { .ov = -1, .code = 0x224c, .word = 0x74dc, .immediate=0, .flags=0x00, .name = "!INST-OFF" },
  { .ov = -1, .code = 0x224c, .word = 0x74e4, .immediate=0, .flags=0x00, .name = "!INST-CLASS" },
  { .ov = -1, .code = 0x224c, .word = 0x74f6, .immediate=0, .flags=0x80, .name = "!INST-SPECIES" },
  { .ov = -1, .code = 0x224c, .word = 0x74fe, .immediate=0, .flags=0x00, .name = "@INST-SIB" },
  { .ov = -1, .code = 0x224c, .word = 0x7506, .immediate=0, .flags=0x00, .name = "@INST-PREV" },
  { .ov = -1, .code = 0x224c, .word = 0x750e, .immediate=0, .flags=0x00, .name = "@INST-OFF" },
  { .ov = -1, .code = 0x224c, .word = 0x7520, .immediate=0, .flags=0x80, .name = "@INST-CLASS" },
  { .ov = -1, .code = 0x224c, .word = 0x7532, .immediate=0, .flags=0x80, .name = "@INST-SPECIES" },
  { .ov = -1, .code = 0x753f, .word = 0x753f, .immediate=0, .flags=0x80, .name = ">C" },
  { .ov = -1, .code = 0x755a, .word = 0x755a, .immediate=0, .flags=0x80, .name = "C>" },
  { .ov = -1, .code = 0x7577, .word = 0x7577, .immediate=0, .flags=0x80, .name = "CI" },
  { .ov = -1, .code = 0x224c, .word = 0x7593, .immediate=0, .flags=0x80, .name = "CDROP" },
  { .ov = -1, .code = 0x224c, .word = 0x75a1, .immediate=0, .flags=0x80, .name = "CI'" },
  { .ov = -1, .code = 0x224c, .word = 0x75b2, .immediate=0, .flags=0x80, .name = "CJ" },
  { .ov = -1, .code = 0x224c, .word = 0x75c6, .immediate=0, .flags=0x80, .name = "COVER" },
  { .ov = -1, .code = 0x75d7, .word = 0x75d7, .immediate=0, .flags=0x80, .name = "CDEPTH" },
  { .ov = -1, .code = 0x224c, .word = 0x75f3, .immediate=0, .flags=0x80, .name = "?NULL" },
  { .ov = -1, .code = 0x224c, .word = 0x7604, .immediate=0, .flags=0x80, .name = "?-NULL" },
  { .ov = -1, .code = 0x224c, .word = 0x7615, .immediate=0, .flags=0x80, .name = "?CHILD" },
  { .ov = -1, .code = 0x224c, .word = 0x761f, .immediate=0, .flags=0x00, .name = "?ONLY" },
  { .ov = -1, .code = 0x224c, .word = 0x7632, .immediate=0, .flags=0x80, .name = "!IADDR" },
  { .ov = -1, .code = 0x763a, .word = 0x763a, .immediate=0, .flags=0x00, .name = "@[IOFF]" },
  { .ov = -1, .code = 0x224c, .word = 0x7646, .immediate=0, .flags=0x00, .name = "IBFR>ICACHE" },
  { .ov = -1, .code = 0x224c, .word = 0x765c, .immediate=0, .flags=0x00, .name = "ICACHE>IBFR" },
  { .ov = -1, .code = 0x224c, .word = 0x7672, .immediate=0, .flags=0x00, .name = "BVA>BUF" },
  { .ov = -1, .code = 0x7684, .word = 0x7684, .immediate=0, .flags=0x80, .name = "PRIORITIZE" },
  { .ov = -1, .code = 0x224c, .word = 0x76b8, .immediate=0, .flags=0x00, .name = "ITLEN" },
  { .ov = -1, .code = 0x224c, .word = 0x76ec, .immediate=0, .flags=0x00, .name = "POINT>I" },
  { .ov = -1, .code = 0x224c, .word = 0x7720, .immediate=0, .flags=0x00, .name = "W7720" },
  { .ov = -1, .code = 0x224c, .word = 0x7788, .immediate=0, .flags=0x00, .name = "?UPDINST" },
  { .ov = -1, .code = 0x224c, .word = 0x7790, .immediate=0, .flags=0x00, .name = "?IN$LOC" },
  { .ov = -1, .code = 0x224c, .word = 0x77a4, .immediate=0, .flags=0x00, .name = "?UPDATE>CACHE" },
  { .ov = -1, .code = 0x224c, .word = 0x77c0, .immediate=0, .flags=0x00, .name = "?UPD>DISK" },
  { .ov = -1, .code = 0x224c, .word = 0x7800, .immediate=0, .flags=0x00, .name = "-LINST" },
  { .ov = -1, .code = 0x224c, .word = 0x787c, .immediate=0, .flags=0x00, .name = "?$COLLECT" },
  { .ov = -1, .code = 0x73ea, .word = 0x78a1, .immediate=0, .flags=0x80, .name = "1BTN" },
  { .ov = -1, .code = 0x224c, .word = 0x78b3, .immediate=0, .flags=0x80, .name = "AFIELD:" },
  { .ov = -1, .code = 0x224c, .word = 0x78e7, .immediate=0, .flags=0x80, .name = "IFIELD:" },
  { .ov = -1, .code = 0x73ea, .word = 0x7904, .immediate=0, .flags=0x80, .name = "#BTN" },
  { .ov = -1, .code = 0x224c, .word = 0x790c, .immediate=0, .flags=0x00, .name = "DISK>IBFR" },
  { .ov = -1, .code = 0x224c, .word = 0x798c, .immediate=0, .flags=0x80, .name = "SET-CURRENT" },
  { .ov = -1, .code = 0x224c, .word = 0x79cb, .immediate=0, .flags=0x80, .name = "ICLOSE" },
  { .ov = -1, .code = 0x224c, .word = 0x79f4, .immediate=0, .flags=0x80, .name = ">C+S" },
  { .ov = -1, .code = 0x224c, .word = 0x7a04, .immediate=0, .flags=0x80, .name = "@>C+S" },
  { .ov = -1, .code = 0x224c, .word = 0x7a14, .immediate=0, .flags=0x80, .name = "IOPEN" },
  { .ov = -1, .code = 0x224c, .word = 0x7a29, .immediate=0, .flags=0x80, .name = "CCLR" },
  { .ov = -1, .code = 0x224c, .word = 0x7a3f, .immediate=0, .flags=0x00, .name = "1STCHILD" },
  { .ov = -1, .code = 0x224c, .word = 0x7a4f, .immediate=0, .flags=0x80, .name = "?LAST" },
  { .ov = -1, .code = 0x224c, .word = 0x7a62, .immediate=0, .flags=0x80, .name = "?FIRST" },
  { .ov = -1, .code = 0x224c, .word = 0x7a72, .immediate=0, .flags=0x80, .name = ">C+" },
  { .ov = -1, .code = 0x224c, .word = 0x7a86, .immediate=0, .flags=0x80, .name = "INEXT" },
  { .ov = -1, .code = 0x224c, .word = 0x7a9e, .immediate=0, .flags=0x80, .name = "IPREV" },
  { .ov = -1, .code = 0x224c, .word = 0x7ab7, .immediate=0, .flags=0x80, .name = "IFIRST" },
  { .ov = -1, .code = 0x224c, .word = 0x7ac9, .immediate=0, .flags=0x80, .name = "ILAST" },
  { .ov = -1, .code = 0x224c, .word = 0x7ad8, .immediate=0, .flags=0x80, .name = "VCLR" },
  { .ov = -1, .code = 0x7ae7, .word = 0x7ae7, .immediate=0, .flags=0x80, .name = ">V" },
  { .ov = -1, .code = 0x7afe, .word = 0x7afe, .immediate=0, .flags=0x80, .name = "V>" },
  { .ov = -1, .code = 0x7b15, .word = 0x7b15, .immediate=0, .flags=0x80, .name = "VI" },
  { .ov = -1, .code = 0x224c, .word = 0x7b23, .immediate=0, .flags=0x00, .name = "IC>DSK" },
  { .ov = -1, .code = 0x224c, .word = 0x7b4f, .immediate=0, .flags=0x80, .name = "SAVE-BUFFERS" },
  { .ov = -1, .code = 0x224c, .word = 0x7b5f, .immediate=0, .flags=0x80, .name = "FLUSH_2" },
  { .ov = -1, .code = 0x224c, .word = 0x7b71, .immediate=0, .flags=0x80, .name = "IINSERT" },
  { .ov = -1, .code = 0x224c, .word = 0x7bb9, .immediate=0, .flags=0x80, .name = "<INSERT" },
  { .ov = -1, .code = 0x224c, .word = 0x7bdf, .immediate=0, .flags=0x80, .name = ">INSERT" },
  { .ov = -1, .code = 0x224c, .word = 0x7bf5, .immediate=0, .flags=0x80, .name = "IEXTRACT" },
  { .ov = -1, .code = 0x224c, .word = 0x7c37, .immediate=0, .flags=0x00, .name = "NEWSPACE" },
  { .ov = -1, .code = 0x224c, .word = 0x7c49, .immediate=0, .flags=0x80, .name = "@NEWSPACE" },
  { .ov = -1, .code = 0x224c, .word = 0x7c5b, .immediate=0, .flags=0x80, .name = "!NEWSPACE" },
  { .ov = -1, .code = 0x224c, .word = 0x7c63, .immediate=0, .flags=0x00, .name = "+!NEWSPACE" },
  { .ov = -1, .code = 0x224c, .word = 0x7c79, .immediate=0, .flags=0x80, .name = "MAXSPACE" },
  { .ov = -1, .code = 0x224c, .word = 0x7c89, .immediate=0, .flags=0x00, .name = "BLKSPACE" },
  { .ov = -1, .code = 0x4a4f, .word = 0x7ca2, .immediate=0, .flags=0x80, .name = "FLD@" },
  { .ov = -1, .code = 0x4a4f, .word = 0x7cbb, .immediate=0, .flags=0x80, .name = "FLD!" },
  { .ov = -1, .code = 0x224c, .word = 0x7cd5, .immediate=0, .flags=0x80, .name = "IFLD@" },
  { .ov = -1, .code = 0x224c, .word = 0x7cef, .immediate=0, .flags=0x80, .name = "IFLD!" },
  { .ov = -1, .code = 0x224c, .word = 0x7d01, .immediate=0, .flags=0x00, .name = "?FLD=" },
  { .ov = -1, .code = 0x224c, .word = 0x7d17, .immediate=0, .flags=0x80, .name = "?CLASS/SPECIES" },
  { .ov = -1, .code = 0x224c, .word = 0x7d39, .immediate=0, .flags=0x00, .name = "?CHOICE" },
  { .ov = -1, .code = 0x224c, .word = 0x7d41, .immediate=0, .flags=0x00, .name = "?EXIT" },
  { .ov = -1, .code = 0x224c, .word = 0x7d49, .immediate=0, .flags=0x00, .name = "TRAVERS" },
  { .ov = -1, .code = 0x224c, .word = 0x7d57, .immediate=0, .flags=0x80, .name = "MAP" },
  { .ov = -1, .code = 0x224c, .word = 0x7d5f, .immediate=0, .flags=0x00, .name = "DUP@>V!" },
  { .ov = -1, .code = 0x224c, .word = 0x7d6b, .immediate=0, .flags=0x00, .name = "V>SWAP!" },
  { .ov = -1, .code = 0x224c, .word = 0x7d7e, .immediate=0, .flags=0x80, .name = "SELECT" },
  { .ov = -1, .code = 0x224c, .word = 0x7db2, .immediate=0, .flags=0x80, .name = "?>FIRST" },
  { .ov = -1, .code = 0x224c, .word = 0x7dca, .immediate=0, .flags=0x80, .name = "SELECT-2DROP" },
  { .ov = -1, .code = 0x224c, .word = 0x7df6, .immediate=0, .flags=0x00, .name = "3SELECTDROP" },
  { .ov = -1, .code = 0x224c, .word = 0x7e02, .immediate=0, .flags=0x00, .name = "=FIND" },
  { .ov = -1, .code = 0x224c, .word = 0x7e14, .immediate=0, .flags=0x80, .name = "IFIND" },
  { .ov = -1, .code = 0x224c, .word = 0x7e1e, .immediate=0, .flags=0x00, .name = "MAP>ROOT" },
  { .ov = -1, .code = 0x224c, .word = 0x7e38, .immediate=0, .flags=0x00, .name = "MAP>LEAF" },
  { .ov = -1, .code = 0x224c, .word = 0x7e5c, .immediate=0, .flags=0x80, .name = "MAKE1ST" },
  { .ov = -1, .code = 0x224c, .word = 0x7e70, .immediate=0, .flags=0x00, .name = "EXTRACTED>INACTIVE" },
  { .ov = -1, .code = 0x224c, .word = 0x7eae, .immediate=0, .flags=0x80, .name = ">INACTIVE" },
  { .ov = -1, .code = 0x224c, .word = 0x7eca, .immediate=0, .flags=0x00, .name = "(IDELETE)" },
  { .ov = -1, .code = 0x224c, .word = 0x7edc, .immediate=0, .flags=0x80, .name = "IDELETE" },
  { .ov = -1, .code = 0x224c, .word = 0x7f08, .immediate=0, .flags=0x00, .name = "SELECT-MAP" },
  { .ov = -1, .code = 0x224c, .word = 0x7f4a, .immediate=0, .flags=0x80, .name = "ALL" },
  { .ov = -1, .code = 0x224c, .word = 0x7f67, .immediate=0, .flags=0x80, .name = "EACH" },
  { .ov = -1, .code = 0x224c, .word = 0x7f79, .immediate=0, .flags=0x00, .name = "THROW-AWAY" },
  { .ov = -1, .code = 0x224c, .word = 0x7f8b, .immediate=0, .flags=0x80, .name = "NULLPOINTERS" },
  { .ov = -1, .code = 0x224c, .word = 0x7f9b, .immediate=0, .flags=0x00, .name = "CHILDEXTRACT" },
  { .ov = -1, .code = 0x224c, .word = 0x7fb1, .immediate=0, .flags=0x00, .name = "TRY-INACTIVE" },
  { .ov = -1, .code = 0x224c, .word = 0x7fe7, .immediate=0, .flags=0x00, .name = "NEWFRAGMENT" },
  { .ov = -1, .code = 0x224c, .word = 0x8033, .immediate=0, .flags=0x80, .name = "?>MAXSP" },
  { .ov = -1, .code = 0x224c, .word = 0x8049, .immediate=0, .flags=0x00, .name = "TRY-NEWSPACE" },
  { .ov = -1, .code = 0x224c, .word = 0x8083, .immediate=0, .flags=0x00, .name = "GET-NEW-INSTANCE" },
  { .ov = -1, .code = 0x4a4f, .word = 0x80d1, .immediate=0, .flags=0x80, .name = "SET?REUSE" },
  { .ov = -1, .code = 0x224c, .word = 0x8115, .immediate=0, .flags=0x80, .name = "VICREAT" },
  { .ov = -1, .code = 0x224c, .word = 0x815b, .immediate=0, .flags=0x80, .name = "ICREATE" },
  { .ov = -1, .code = 0x224c, .word = 0x81af, .immediate=0, .flags=0x80, .name = "*CREATE" },
  { .ov = -1, .code = 0x224c, .word = 0x81d7, .immediate=0, .flags=0x00, .name = ".DRJ" },
  { .ov = -1, .code = 0x224c, .word = 0x81e3, .immediate=0, .flags=0x00, .name = ".INM" },
  { .ov = -1, .code = 0x224c, .word = 0x8215, .immediate=0, .flags=0x80, .name = ".C" },
  { .ov = -1, .code = 0x224c, .word = 0x824a, .immediate=0, .flags=0x00, .name = "INDENT.INM" },
  { .ov = -1, .code = 0x224c, .word = 0x826a, .immediate=0, .flags=0x80, .name = ".TREE" },
  { .ov = -1, .code = 0x224c, .word = 0x8294, .immediate=0, .flags=0x00, .name = "OVA@" },
  { .ov = -1, .code = 0x224c, .word = 0x82a6, .immediate=0, .flags=0x80, .name = "OV-CANCEL" },
  { .ov = -1, .code = 0x224c, .word = 0x82e2, .immediate=0, .flags=0x00, .name = "VSA>BUFADR" },
  { .ov = -1, .code = 0x224c, .word = 0x82ee, .immediate=0, .flags=0x00, .name = "?ROOMERROR" },
  { .ov = -1, .code = 0x224c, .word = 0x8309, .immediate=0, .flags=0x00, .name = "OV-VERIFY" },
  { .ov = -1, .code = 0x224c, .word = 0x8332, .immediate=0, .flags=0x00, .name = "LOAD-OVERLAY" },
  { .ov = -1, .code = 0x224c, .word = 0x83aa, .immediate=0, .flags=0x80, .name = "SAVE-OVERLAY" },
  { .ov = -1, .code = 0x224c, .word = 0x83ea, .immediate=0, .flags=0x80, .name = "OVERLAY" },
  { .ov = -1, .code = 0x224c, .word = 0x8403, .immediate=0, .flags=0x00, .name = "DP-SWITCH" },
  { .ov = -1, .code = 0x224c, .word = 0x8427, .immediate=0, .flags=0x80, .name = "OPEN-OVERLAY" },
  { .ov = -1, .code = 0x224c, .word = 0x847b, .immediate=0, .flags=0x00, .name = ".CVSAS" },
  { .ov = -1, .code = 0x224c, .word = 0x84b9, .immediate=0, .flags=0x80, .name = "CLOSE-OVERLAY" },
  { .ov = -1, .code = 0x224c, .word = 0x84d0, .immediate=0, .flags=0x80, .name = "MODULE" },
  { .ov = -1, .code = 0x1d29, .word = 0x84ec, .immediate=0, .flags=0x80, .name = "?TANDRG" },
  { .ov = -1, .code = 0x224c, .word = 0x84fa, .immediate=0, .flags=0x80, .name = "MSET-CO" },
  { .ov = -1, .code = 0x224c, .word = 0x8519, .immediate=0, .flags=0x80, .name = "!COLOR" },
  { .ov = -1, .code = 0x224c, .word = 0x8530, .immediate=0, .flags=0x80, .name = "@COLOR" },
  { .ov = -1, .code = 0x1d29, .word = 0x8538, .immediate=0, .flags=0x00, .name = "TREJECT/TACCEPT" },
  { .ov = -1, .code = 0x1d29, .word = 0x8596, .immediate=0, .flags=0x00, .name = "INT/O" },
  { .ov = -1, .code = 0x1d29, .word = 0x8605, .immediate=0, .flags=0x00, .name = "CLIP" },
  { .ov = -1, .code = 0x8783, .word = 0x8783, .immediate=0, .flags=0x80, .name = "CLIPPER" },
  { .ov = -1, .code = 0x1d29, .word = 0x87e1, .immediate=0, .flags=0x00, .name = "SCANCON" },
  { .ov = -1, .code = 0x8891, .word = 0x8891, .immediate=0, .flags=0x80, .name = "SCANPOLY" },
  { .ov = -1, .code = 0x224c, .word = 0x89a1, .immediate=0, .flags=0x80, .name = "SETCLIPWINDOW" },
  { .ov = -1, .code = 0x224c, .word = 0x89eb, .immediate=0, .flags=0x80, .name = "VCLIPSET" },
  { .ov = -1, .code = 0x224c, .word = 0x8a07, .immediate=0, .flags=0x80, .name = "DCLIPSET" },
  { .ov = -1, .code = 0x224c, .word = 0x8a19, .immediate=0, .flags=0x00, .name = "W8A19" },
  { .ov = -1, .code = 0x8a2d, .word = 0x8a2d, .immediate=0, .flags=0x00, .name = "W8A2D" },
  { .ov = -1, .code = 0x224c, .word = 0x8a54, .immediate=0, .flags=0x00, .name = "W8A54" },
  { .ov = -1, .code = 0x224c, .word = 0x8a96, .immediate=0, .flags=0x80, .name = "?HERCULES" },
  { .ov = -1, .code = 0x224c, .word = 0x8aa2, .immediate=0, .flags=0x00, .name = "YTABLE.ADDRESS" },
  { .ov = -1, .code = 0x224c, .word = 0x8ab6, .immediate=0, .flags=0x80, .name = "BLD-DIS" },
  { .ov = -1, .code = 0x224c, .word = 0x8b03, .immediate=0, .flags=0x80, .name = "BLD-MV" },
  { .ov = -1, .code = 0x224c, .word = 0x8b5d, .immediate=0, .flags=0x00, .name = "HID-DIS" },
  { .ov = -1, .code = 0x224c, .word = 0x8b8d, .immediate=0, .flags=0x00, .name = "?HID-DIS" },
  { .ov = -1, .code = 0x224c, .word = 0x8ba3, .immediate=0, .flags=0x80, .name = ">MAINVIEW" },
  { .ov = -1, .code = 0x224c, .word = 0x8bd1, .immediate=0, .flags=0x80, .name = ">DISPLAY" },
  { .ov = -1, .code = 0x224c, .word = 0x8bfb, .immediate=0, .flags=0x80, .name = ">HIDDEN" },
  { .ov = -1, .code = 0x1d29, .word = 0x8c41, .immediate=0, .flags=0x80, .name = "SET6845" },
  { .ov = -1, .code = 0x1d29, .word = 0x8c5c, .immediate=0, .flags=0x80, .name = "GIBM" },
  { .ov = -1, .code = 0x1d29, .word = 0x8c74, .immediate=0, .flags=0x80, .name = "GHERC" },
  { .ov = -1, .code = 0x1d29, .word = 0x8c8c, .immediate=0, .flags=0x80, .name = "THERC" },
  { .ov = -1, .code = 0x1d29, .word = 0x8ca6, .immediate=0, .flags=0x80, .name = ">HGRAPH" },
  { .ov = -1, .code = 0x1d29, .word = 0x8ccd, .immediate=0, .flags=0x80, .name = ">HTEXT" },
  { .ov = -1, .code = 0x1d29, .word = 0x8ceb, .immediate=0, .flags=0x00, .name = "W8CEB" },
  { .ov = -1, .code = 0x8d09, .word = 0x8d09, .immediate=0, .flags=0x80, .name = "DISPLAY-WAIT" },
  { .ov = -1, .code = 0x1d29, .word = 0x8d48, .immediate=0, .flags=0x80, .name = ">TANDY" },
  { .ov = -1, .code = 0x8d66, .word = 0x8d66, .immediate=0, .flags=0x00, .name = "W8D66" },
  { .ov = -1, .code = 0x224c, .word = 0x8d81, .immediate=0, .flags=0x80, .name = ">MONO" },
  { .ov = -1, .code = 0x8d8b, .word = 0x8d8b, .immediate=0, .flags=0x00, .name = ">LORES" },
  { .ov = -1, .code = 0x8df0, .word = 0x8df0, .immediate=0, .flags=0x00, .name = ">ALPHACODE" },
  { .ov = -1, .code = 0x224c, .word = 0x8e17, .immediate=0, .flags=0x80, .name = ">ALPHA" },
  { .ov = -1, .code = 0x224c, .word = 0x8e22, .immediate=0, .flags=0x80, .name = ">A" },
  { .ov = -1, .code = 0x1d29, .word = 0x8e32, .immediate=0, .flags=0x80, .name = "COPYLIN" },
  { .ov = -1, .code = 0x8e4f, .word = 0x8e4f, .immediate=0, .flags=0x00, .name = "W8E4F" },
  { .ov = -1, .code = 0x224c, .word = 0x8e70, .immediate=0, .flags=0x00, .name = "SCANLINE" },
  { .ov = -1, .code = 0x224c, .word = 0x8e88, .immediate=0, .flags=0x80, .name = "|DISPLAY" },
  { .ov = -1, .code = 0x224c, .word = 0x8ee7, .immediate=0, .flags=0x80, .name = ">LORES_2" },
  { .ov = -1, .code = 0x224c, .word = 0x8eff, .immediate=0, .flags=0x80, .name = "SAVE-SCR" },
  { .ov = -1, .code = 0x224c, .word = 0x8f15, .immediate=0, .flags=0x80, .name = "SCR-RES" },
  { .ov = -1, .code = 0x1d29, .word = 0x8f3d, .immediate=0, .flags=0x00, .name = "W8F3D" },
  { .ov = -1, .code = 0x8f8b, .word = 0x8f8b, .immediate=0, .flags=0x80, .name = "BFILL" },
  { .ov = -1, .code = 0x224c, .word = 0x8fc1, .immediate=0, .flags=0x80, .name = "DARK" },
  { .ov = -1, .code = 0x224c, .word = 0x8fd9, .immediate=0, .flags=0x80, .name = "BYE" },
  { .ov = -1, .code = 0x1d29, .word = 0x8ff7, .immediate=0, .flags=0x80, .name = "DUMMY" },
  { .ov = -1, .code = 0x9002, .word = 0x9002, .immediate=0, .flags=0x80, .name = "LPLOT" },
  { .ov = -1, .code = 0x9017, .word = 0x9017, .immediate=0, .flags=0x80, .name = "LXPLOT" },
  { .ov = -1, .code = 0x902b, .word = 0x902b, .immediate=0, .flags=0x80, .name = "{BLT}" },
  { .ov = -1, .code = 0x903f, .word = 0x903f, .immediate=0, .flags=0x80, .name = "LLINE" },
  { .ov = -1, .code = 0x9055, .word = 0x9055, .immediate=0, .flags=0x80, .name = "LFILLPOLY" },
  { .ov = -1, .code = 0x906b, .word = 0x906b, .immediate=0, .flags=0x80, .name = "LCOPYBLK" },
  { .ov = -1, .code = 0x9081, .word = 0x9081, .immediate=0, .flags=0x80, .name = "TILEFILL" },
  { .ov = -1, .code = 0x9097, .word = 0x9097, .immediate=0, .flags=0x80, .name = "SQLPLOT" },
  { .ov = -1, .code = 0x90ad, .word = 0x90ad, .immediate=0, .flags=0x80, .name = "V>DISPLAY" },
  { .ov = -1, .code = 0x90c3, .word = 0x90c3, .immediate=0, .flags=0x80, .name = "EEXTENT" },
  { .ov = -1, .code = 0x1d29, .word = 0x90d9, .immediate=0, .flags=0x80, .name = "{.ELLIP}" },
  { .ov = -1, .code = 0x1d29, .word = 0x90eb, .immediate=0, .flags=0x80, .name = ".{SCANELLIP}" },
  { .ov = -1, .code = 0x90f9, .word = 0x90f9, .immediate=0, .flags=0x80, .name = "ARC" },
  { .ov = -1, .code = 0x910f, .word = 0x910f, .immediate=0, .flags=0x80, .name = "L@PIXEL" },
  { .ov = -1, .code = 0x1d29, .word = 0x9125, .immediate=0, .flags=0x80, .name = "(FVLINE" },
  { .ov = -1, .code = 0x1d29, .word = 0x9137, .immediate=0, .flags=0x80, .name = "EGA-OFF" },
  { .ov = -1, .code = 0x1d29, .word = 0x9161, .immediate=0, .flags=0x80, .name = "CGA-OFF" },
  { .ov = -1, .code = 0x224c, .word = 0x918b, .immediate=0, .flags=0x80, .name = "DEF-SEG" },
  { .ov = -1, .code = 0x224c, .word = 0x91eb, .immediate=0, .flags=0x00, .name = "W91EB" },
  { .ov = -1, .code = 0x224c, .word = 0x9255, .immediate=0, .flags=0x80, .name = "DEF-OFF" },
  { .ov = -1, .code = 0x224c, .word = 0x9275, .immediate=0, .flags=0x80, .name = "DO-PATC" },
  { .ov = -1, .code = 0x224c, .word = 0x92a1, .immediate=0, .flags=0x80, .name = "LOAD-CO" },
  { .ov = -1, .code = 0x1d29, .word = 0x92cf, .immediate=0, .flags=0x80, .name = "EGA-BIT" },
  { .ov = -1, .code = 0x1d29, .word = 0x92e3, .immediate=0, .flags=0x80, .name = "CGA-BIT" },
  { .ov = -1, .code = 0x92ef, .word = 0x92ef, .immediate=0, .flags=0x80, .name = "S/RON" },
  { .ov = -1, .code = 0x1d29, .word = 0x930b, .immediate=0, .flags=0x80, .name = "(PLOT)" },
  { .ov = -1, .code = 0x9367, .word = 0x9367, .immediate=0, .flags=0x80, .name = "PLOT" },
  { .ov = -1, .code = 0x937b, .word = 0x937b, .immediate=0, .flags=0x80, .name = "SETCOLO" },
  { .ov = -1, .code = 0x9390, .word = 0x9390, .immediate=0, .flags=0x00, .name = "?EXTENTX" },
  { .ov = -1, .code = 0x93b1, .word = 0x93b1, .immediate=0, .flags=0x00, .name = "BEXTENT" },
  { .ov = -1, .code = 0x224c, .word = 0x93da, .immediate=0, .flags=0x80, .name = "BLT" },
  { .ov = -1, .code = 0x224c, .word = 0x93fa, .immediate=0, .flags=0x00, .name = "{1FONT}" },
  { .ov = -1, .code = 0x224c, .word = 0x9460, .immediate=0, .flags=0x00, .name = "{GTYPE}" },
  { .ov = -1, .code = 0x224c, .word = 0x9483, .immediate=0, .flags=0x80, .name = ">1FONT" },
  { .ov = -1, .code = 0x224c, .word = 0x94a4, .immediate=0, .flags=0x80, .name = ">0FONT" },
  { .ov = -1, .code = 0x224c, .word = 0x94d0, .immediate=0, .flags=0x80, .name = "{2FONT}" },
  { .ov = -1, .code = 0x224c, .word = 0x9527, .immediate=0, .flags=0x80, .name = ">2FONT" },
  { .ov = -1, .code = 0x224c, .word = 0x953f, .immediate=0, .flags=0x00, .name = "{3FONT}" },
  { .ov = -1, .code = 0x224c, .word = 0x959c, .immediate=0, .flags=0x80, .name = ">3FONT" },
  { .ov = -1, .code = 0x95be, .word = 0x95be, .immediate=0, .flags=0x80, .name = "SHL-BIT" },
  { .ov = -1, .code = 0x224c, .word = 0x95d6, .immediate=0, .flags=0x80, .name = "BLK>BUFFER" },
  { .ov = -1, .code = 0x224c, .word = 0x9604, .immediate=0, .flags=0x00, .name = "!EPARMS" },
  { .ov = -1, .code = 0x224c, .word = 0x9632, .immediate=0, .flags=0x80, .name = ".ELLIPSE" },
  { .ov = -1, .code = 0x224c, .word = 0x965e, .immediate=0, .flags=0x80, .name = ".CIRCLE" },
  { .ov = -1, .code = 0x224c, .word = 0x9674, .immediate=0, .flags=0x80, .name = "FILLELLIP" },
  { .ov = -1, .code = 0x224c, .word = 0x96ca, .immediate=0, .flags=0x80, .name = "FILLCIRC" },
  { .ov = -1, .code = 0x224c, .word = 0x96d6, .immediate=0, .flags=0x00, .name = "FRAMELEN" },
  { .ov = -1, .code = 0x224c, .word = 0x96fe, .immediate=0, .flags=0x80, .name = ".PACKBLT" },
  { .ov = -1, .code = 0x224c, .word = 0x9778, .immediate=0, .flags=0x80, .name = "SET-COLORMAP" },
  { .ov = -1, .code = 0x97cc, .word = 0x97cc, .immediate=0, .flags=0x80, .name = "COLORMAP" },
  { .ov = -1, .code = 0x224c, .word = 0x9805, .immediate=0, .flags=0x80, .name = "CELLCOLOR" },
  { .ov = -1, .code = 0x224c, .word = 0x9819, .immediate=0, .flags=0x80, .name = "!XYSEED" },
  { .ov = -1, .code = 0x9841, .word = 0x9841, .immediate=0, .flags=0x80, .name = "BUFFERXY" },
  { .ov = -1, .code = 0x224c, .word = 0x986e, .immediate=0, .flags=0x00, .name = ".CELL" },
  { .ov = -1, .code = 0x224c, .word = 0x9880, .immediate=0, .flags=0x80, .name = ".1X2CELL" },
  { .ov = -1, .code = 0x224c, .word = 0x989a, .immediate=0, .flags=0x80, .name = ".2X2CELL" },
  { .ov = -1, .code = 0x224c, .word = 0x98be, .immediate=0, .flags=0x80, .name = ".4X4CELL" },
  { .ov = -1, .code = 0x224c, .word = 0x98dc, .immediate=0, .flags=0x80, .name = ".8X8CELL" },
  { .ov = -1, .code = 0x224c, .word = 0x98fa, .immediate=0, .flags=0x80, .name = ".REGION+" },
  { .ov = -1, .code = 0x992d, .word = 0x992d, .immediate=0, .flags=0x80, .name = "?INVIS" },
  { .ov = -1, .code = 0x9970, .word = 0x9970, .immediate=0, .flags=0x80, .name = "WLD>SCR" },
  { .ov = -1, .code = 0x99b4, .word = 0x99b4, .immediate=0, .flags=0x80, .name = "SCR>BLT" },
  { .ov = -1, .code = 0x224c, .word = 0x99d4, .immediate=0, .flags=0x80, .name = "!VISWINDOW" },
  { .ov = -1, .code = 0x224c, .word = 0x99e8, .immediate=0, .flags=0x00, .name = "FILE>ICONIMAGE" },
  { .ov = -1, .code = 0x224c, .word = 0x9a18, .immediate=0, .flags=0x80, .name = ">1ICONFONT" },
  { .ov = -1, .code = 0x224c, .word = 0x9a36, .immediate=0, .flags=0x80, .name = ">2ICONF" },
  { .ov = -1, .code = 0x224c, .word = 0x9a56, .immediate=0, .flags=0x80, .name = ">3ICONFONT" },
  { .ov = -1, .code = 0x9a6c, .word = 0x9a6c, .immediate=0, .flags=0x00, .name = "@IW" },
  { .ov = -1, .code = 0x9a82, .word = 0x9a82, .immediate=0, .flags=0x00, .name = "W9A82" },
  { .ov = -1, .code = 0x9a9e, .word = 0x9a9e, .immediate=0, .flags=0x80, .name = "!IW" },
  { .ov = -1, .code = 0x9aba, .word = 0x9aba, .immediate=0, .flags=0x80, .name = "!IB" },
  { .ov = -1, .code = 0x224c, .word = 0x9ad4, .immediate=0, .flags=0x80, .name = "@IX" },
  { .ov = -1, .code = 0x224c, .word = 0x9ae4, .immediate=0, .flags=0x80, .name = "@IY" },
  { .ov = -1, .code = 0x224c, .word = 0x9af4, .immediate=0, .flags=0x80, .name = "@ID" },
  { .ov = -1, .code = 0x224c, .word = 0x9b04, .immediate=0, .flags=0x80, .name = "@IC" },
  { .ov = -1, .code = 0x224c, .word = 0x9b14, .immediate=0, .flags=0x80, .name = "@IL" },
  { .ov = -1, .code = 0x224c, .word = 0x9b24, .immediate=0, .flags=0x80, .name = "@IH" },
  { .ov = -1, .code = 0x224c, .word = 0x9b34, .immediate=0, .flags=0x80, .name = "!IX" },
  { .ov = -1, .code = 0x224c, .word = 0x9b44, .immediate=0, .flags=0x80, .name = "!IY" },
  { .ov = -1, .code = 0x224c, .word = 0x9b54, .immediate=0, .flags=0x80, .name = "!ID" },
  { .ov = -1, .code = 0x224c, .word = 0x9b64, .immediate=0, .flags=0x80, .name = "!IC" },
  { .ov = -1, .code = 0x224c, .word = 0x9b74, .immediate=0, .flags=0x80, .name = "!IL" },
  { .ov = -1, .code = 0x224c, .word = 0x9b84, .immediate=0, .flags=0x80, .name = "!IH" },
  { .ov = -1, .code = 0x224c, .word = 0x9b98, .immediate=0, .flags=0x80, .name = "INIT-ICONLIST" },
  { .ov = -1, .code = 0x224c, .word = 0x9bae, .immediate=0, .flags=0x80, .name = ".BACKGROUND" },
  { .ov = -1, .code = 0x224c, .word = 0x9bb6, .immediate=0, .flags=0x00, .name = "{8X8ICON}" },
  { .ov = -1, .code = 0x224c, .word = 0x9bee, .immediate=0, .flags=0x00, .name = ".8X8ICON" },
  { .ov = -1, .code = 0x224c, .word = 0x9c22, .immediate=0, .flags=0x00, .name = ".FLUX-ICON" },
  { .ov = -1, .code = 0x224c, .word = 0x9c34, .immediate=0, .flags=0x80, .name = ".CIRCLEICON" },
  { .ov = -1, .code = 0x4a4f, .word = 0x9c60, .immediate=0, .flags=0x80, .name = "SYSCASE" },
  { .ov = -1, .code = 0x224c, .word = 0x9c76, .immediate=0, .flags=0x00, .name = ".STARSYS" },
  { .ov = -1, .code = 0x4a4f, .word = 0x9c92, .immediate=0, .flags=0x80, .name = ".ICONCASES" },
  { .ov = -1, .code = 0x224c, .word = 0x9cb0, .immediate=0, .flags=0x80, .name = ".ICON" },
  { .ov = -1, .code = 0x224c, .word = 0x9cea, .immediate=0, .flags=0x80, .name = "POINT>ICON" },
  { .ov = -1, .code = 0x224c, .word = 0x9cfc, .immediate=0, .flags=0x80, .name = ".LOCAL-ICONS" },
  { .ov = -1, .code = 0x9d18, .word = 0x9d18, .immediate=0, .flags=0x00, .name = "?ILOCUS" },
  { .ov = -1, .code = 0x224c, .word = 0x9d82, .immediate=0, .flags=0x80, .name = "?ICONS-LOCUS" },
  { .ov = -1, .code = 0x224c, .word = 0x9d96, .immediate=0, .flags=0x80, .name = "?ICONS-AT" },
  { .ov = -1, .code = 0x224c, .word = 0x9daa, .immediate=0, .flags=0x80, .name = "?ICON-IADDR" },
  { .ov = -1, .code = 0x9e14, .word = 0x9e14, .immediate=0, .flags=0x00, .name = "XCHGICON" },
  { .ov = -1, .code = 0x224c, .word = 0x9e53, .immediate=0, .flags=0x00, .name = "PERCOLATE" },
  { .ov = -1, .code = 0x224c, .word = 0x9e7b, .immediate=0, .flags=0x80, .name = "-ICON" },
  { .ov = -1, .code = 0x9eb1, .word = 0x9eb1, .immediate=0, .flags=0x00, .name = "?IID" },
  { .ov = -1, .code = 0x224c, .word = 0x9efe, .immediate=0, .flags=0x80, .name = "?ICONSI" },
  { .ov = -1, .code = 0x224c, .word = 0x9f10, .immediate=0, .flags=0x80, .name = "+ICON" },
  { .ov = -1, .code = 0x224c, .word = 0x9f42, .immediate=0, .flags=0x80, .name = "+ICONBOX" },
  { .ov = -1, .code = 0x224c, .word = 0x9f56, .immediate=0, .flags=0x80, .name = "ORGLIST" },
  { .ov = -1, .code = 0x224c, .word = 0xa02d, .immediate=0, .flags=0x80, .name = "POS." },
  { .ov = -1, .code = 0x224c, .word = 0xa042, .immediate=0, .flags=0x80, .name = ".1LOGO" },
  { .ov = -1, .code = 0x224c, .word = 0xa070, .immediate=0, .flags=0x00, .name = "INIT-VIEWSCREEN-POLY" },
  { .ov = -1, .code = 0x224c, .word = 0xa08c, .immediate=0, .flags=0x00, .name = "POLY-WINDOW-BOUND" },
  { .ov = -1, .code = 0x224c, .word = 0xa0f0, .immediate=0, .flags=0x80, .name = "POLY-WINDOW-FILL" },
  { .ov = -1, .code = 0x224c, .word = 0xa102, .immediate=0, .flags=0x80, .name = "SFILL" },
  { .ov = -1, .code = 0x224c, .word = 0xa11c, .immediate=0, .flags=0x80, .name = ">SSCT" },
  { .ov = -1, .code = 0x224c, .word = 0xa136, .immediate=0, .flags=0x80, .name = ">TVCT" },
  { .ov = -1, .code = 0x224c, .word = 0xa153, .immediate=0, .flags=0x80, .name = "CTPOS." },
  { .ov = -1, .code = 0x224c, .word = 0xa183, .immediate=0, .flags=0x80, .name = "CTERASE" },
  { .ov = -1, .code = 0x224c, .word = 0xa1a9, .immediate=0, .flags=0x80, .name = "@BEEP" },
  { .ov = -1, .code = 0x224c, .word = 0xa1bd, .immediate=0, .flags=0x80, .name = "!BEEP" },
  { .ov = -1, .code = 0x224c, .word = 0xa1d1, .immediate=0, .flags=0x80, .name = "CLICK" },
  { .ov = -1, .code = 0x224c, .word = 0xa1f2, .immediate=0, .flags=0x80, .name = ">SND" },
  { .ov = -1, .code = 0x224c, .word = 0xa227, .immediate=0, .flags=0x80, .name = "BEEPON" },
  { .ov = -1, .code = 0x224c, .word = 0xa235, .immediate=0, .flags=0x00, .name = "mussegswap" },
  { .ov = -1, .code = 0x224c, .word = 0xa23d, .immediate=0, .flags=0x00, .name = "WA23D" },
  { .ov = -1, .code = 0x224c, .word = 0xa245, .immediate=0, .flags=0x00, .name = "WA245" },
  { .ov = -1, .code = 0x224c, .word = 0xa24d, .immediate=0, .flags=0x00, .name = "WA24D" },
  { .ov = -1, .code = 0x224c, .word = 0xa255, .immediate=0, .flags=0x00, .name = "WA255" },
  { .ov = -1, .code = 0x224c, .word = 0xa25d, .immediate=0, .flags=0x00, .name = "muson" },
  { .ov = -1, .code = 0x224c, .word = 0xa267, .immediate=0, .flags=0x00, .name = "musoff" },
  { .ov = -1, .code = 0x224c, .word = 0xa27a, .immediate=0, .flags=0x80, .name = "SONG" },
  { .ov = -1, .code = 0x224c, .word = 0xa2c7, .immediate=0, .flags=0x80, .name = "@CRS" },
  { .ov = -1, .code = 0x224c, .word = 0xa2fe, .immediate=0, .flags=0x80, .name = "!CRS" },
  { .ov = -1, .code = 0x224c, .word = 0xa333, .immediate=0, .flags=0x80, .name = "$." },
  { .ov = -1, .code = 0x224c, .word = 0xa345, .immediate=0, .flags=0x80, .name = "POLY-ERASE-TEXT" },
  { .ov = -1, .code = 0x224c, .word = 0xa379, .immediate=0, .flags=0x80, .name = "POS.PXT" },
  { .ov = -1, .code = 0x224c, .word = 0xa3a0, .immediate=0, .flags=0x80, .name = "WINDOW" },
  { .ov = -1, .code = 0x224c, .word = 0xa3da, .immediate=0, .flags=0x00, .name = "WA3DA" },
  { .ov = -1, .code = 0x224c, .word = 0xa3fc, .immediate=0, .flags=0x00, .name = "WA3FC" },
  { .ov = -1, .code = 0x224c, .word = 0xa424, .immediate=0, .flags=0x80, .name = "WLINE-UP" },
  { .ov = -1, .code = 0x224c, .word = 0xa45c, .immediate=0, .flags=0x80, .name = "WLINE-D" },
  { .ov = -1, .code = 0x224c, .word = 0xa48e, .immediate=0, .flags=0x80, .name = "GCR" },
  { .ov = -1, .code = 0x224c, .word = 0xa4ac, .immediate=0, .flags=0x80, .name = "WSHORTE" },
  { .ov = -1, .code = 0x224c, .word = 0xa4d5, .immediate=0, .flags=0x80, .name = "CTCR" },
  { .ov = -1, .code = 0x224c, .word = 0xa4f1, .immediate=0, .flags=0x80, .name = "TTY-SCR" },
  { .ov = -1, .code = 0x224c, .word = 0xa513, .immediate=0, .flags=0x00, .name = "WA513" },
  { .ov = -1, .code = 0x224c, .word = 0xa52a, .immediate=0, .flags=0x80, .name = "CTINIT" },
  { .ov = -1, .code = 0x224c, .word = 0xa549, .immediate=0, .flags=0x80, .name = ".TTY" },
  { .ov = -1, .code = 0x224c, .word = 0xa55b, .immediate=0, .flags=0x80, .name = "VIEWSCR" },
  { .ov = -1, .code = 0x224c, .word = 0xa5f9, .immediate=0, .flags=0x80, .name = "TXT-WIN" },
  { .ov = -1, .code = 0x224c, .word = 0xa659, .immediate=0, .flags=0x00, .name = "WA659" },
  { .ov = -1, .code = 0x224c, .word = 0xa6af, .immediate=0, .flags=0x00, .name = "WA6AF" },
  { .ov = -1, .code = 0x224c, .word = 0xa705, .immediate=0, .flags=0x00, .name = "WA705" },
  { .ov = -1, .code = 0x224c, .word = 0xa756, .immediate=0, .flags=0x80, .name = "?MRC" },
  { .ov = -1, .code = 0x224c, .word = 0xa77e, .immediate=0, .flags=0x00, .name = "WA77E" },
  { .ov = -1, .code = 0x224c, .word = 0xa7a6, .immediate=0, .flags=0x80, .name = "ERASE-AUXILLARY" },
  { .ov = -1, .code = 0x224c, .word = 0xa7ce, .immediate=0, .flags=0x80, .name = "ERASE-T" },
  { .ov = -1, .code = 0x224c, .word = 0xa7ee, .immediate=0, .flags=0x00, .name = "WA7EE" },
  { .ov = -1, .code = 0x224c, .word = 0xa802, .immediate=0, .flags=0x00, .name = "WA802" },
  { .ov = -1, .code = 0x224c, .word = 0xa82a, .immediate=0, .flags=0x80, .name = ".HIGHLI" },
  { .ov = -1, .code = 0x224c, .word = 0xa84a, .immediate=0, .flags=0x00, .name = "WA84A" },
  { .ov = -1, .code = 0x224c, .word = 0xa87c, .immediate=0, .flags=0x80, .name = ".ON" },
  { .ov = -1, .code = 0x224c, .word = 0xa89e, .immediate=0, .flags=0x80, .name = "CLR-BUT" },
  { .ov = -1, .code = 0x224c, .word = 0xa8c0, .immediate=0, .flags=0x80, .name = "INIT-BUTTON" },
  { .ov = -1, .code = 0x224c, .word = 0xa8da, .immediate=0, .flags=0x80, .name = "(SHIP-C" },
  { .ov = -1, .code = 0x224c, .word = 0xa912, .immediate=0, .flags=0x80, .name = "SHIP-CONSOLE" },
  { .ov = -1, .code = 0x224c, .word = 0xa921, .immediate=0, .flags=0x80, .name = "'KEY" },
  { .ov = -1, .code = 0x224c, .word = 0xa98d, .immediate=0, .flags=0x00, .name = "UL" },
  { .ov = -1, .code = 0x224c, .word = 0xa995, .immediate=0, .flags=0x00, .name = "U0" },
  { .ov = -1, .code = 0x224c, .word = 0xa99d, .immediate=0, .flags=0x00, .name = "0L" },
  { .ov = -1, .code = 0x224c, .word = 0xa9a5, .immediate=0, .flags=0x00, .name = "UR" },
  { .ov = -1, .code = 0x224c, .word = 0xa9b1, .immediate=0, .flags=0x00, .name = "0R" },
  { .ov = -1, .code = 0x224c, .word = 0xa9bd, .immediate=0, .flags=0x00, .name = "DL" },
  { .ov = -1, .code = 0x224c, .word = 0xa9c5, .immediate=0, .flags=0x00, .name = "DZ" },
  { .ov = -1, .code = 0x224c, .word = 0xa9cd, .immediate=0, .flags=0x00, .name = "DR" },
  { .ov = -1, .code = 0x224c, .word = 0xa9d5, .immediate=0, .flags=0x00, .name = "XY0" },
  { .ov = -1, .code = 0x224c, .word = 0xa9db, .immediate=0, .flags=0x00, .name = "TRIG" },
  { .ov = -1, .code = 0x4a4f, .word = 0xa9ef, .immediate=0, .flags=0x80, .name = "(XYSCAN)" },
  { .ov = -1, .code = 0x224c, .word = 0xaa3a, .immediate=0, .flags=0x80, .name = "XYSCAN" },
  { .ov = -1, .code = 0x224c, .word = 0xaa52, .immediate=0, .flags=0x80, .name = "?TRIG" },
  { .ov = -1, .code = 0x224c, .word = 0xaa6c, .immediate=0, .flags=0x80, .name = "?QUIT" },
  { .ov = -1, .code = 0x224c, .word = 0xaa84, .immediate=0, .flags=0x80, .name = "Y/N" },
  { .ov = -1, .code = 0x224c, .word = 0xaa98, .immediate=0, .flags=0x00, .name = "NEXT-BUTTON" },
  { .ov = -1, .code = 0x224c, .word = 0xaaac, .immediate=0, .flags=0x00, .name = "XEQ-BUTTON" },
  { .ov = -1, .code = 0x224c, .word = 0xaabc, .immediate=0, .flags=0x80, .name = ".ABTN" },
  { .ov = -1, .code = 0x224c, .word = 0xab1c, .immediate=0, .flags=0x80, .name = ".BTN-TEXT" },
  { .ov = -1, .code = 0x224c, .word = 0xab76, .immediate=0, .flags=0x80, .name = "NEW-BUT" },
  { .ov = -1, .code = 0x224c, .word = 0xabc6, .immediate=0, .flags=0x80, .name = "CURSORSPACE" },
  { .ov = -1, .code = 0x224c, .word = 0xabde, .immediate=0, .flags=0x80, .name = "BLD-CRS" },
  { .ov = -1, .code = 0x224c, .word = 0xac3c, .immediate=0, .flags=0x80, .name = "SET-CRS" },
  { .ov = -1, .code = 0x224c, .word = 0xac9d, .immediate=0, .flags=0x80, .name = "$!" },
  { .ov = -1, .code = 0x224c, .word = 0xacb3, .immediate=0, .flags=0x80, .name = "SUBROOT" },
  { .ov = -1, .code = 0x224c, .word = 0xacc7, .immediate=0, .flags=0x80, .name = "SRDEPTH" },
  { .ov = -1, .code = 0x224c, .word = 0xacd3, .immediate=0, .flags=0x00, .name = ">ASCEND" },
  { .ov = -1, .code = 0x224c, .word = 0xacf3, .immediate=0, .flags=0x80, .name = "NEXT-NODE" },
  { .ov = -1, .code = 0x744d, .word = 0xad1b, .immediate=0, .flags=0x80, .name = "INST-VAL" },
  { .ov = -1, .code = 0x73ea, .word = 0xad28, .immediate=0, .flags=0x80, .name = "SHAPE" },
  { .ov = -1, .code = 0x744d, .word = 0xad3a, .immediate=0, .flags=0x80, .name = "INST-DATE" },
  { .ov = -1, .code = 0x73ea, .word = 0xad49, .immediate=0, .flags=0x80, .name = "RESEMBLES" },
  { .ov = -1, .code = 0x73ea, .word = 0xad5b, .immediate=0, .flags=0x80, .name = "BOX-NAME" },
  { .ov = -1, .code = 0x744d, .word = 0xad6b, .immediate=0, .flags=0x80, .name = "%NAME" },
  { .ov = -1, .code = 0x73ea, .word = 0xad7a, .immediate=0, .flags=0x80, .name = "ORIG-NAME" },
  { .ov = -1, .code = 0x73ea, .word = 0xad8c, .immediate=0, .flags=0x80, .name = "SPEC-NAME" },
  { .ov = -1, .code = 0x73ea, .word = 0xad9e, .immediate=0, .flags=0x80, .name = "BD-NAME" },
  { .ov = -1, .code = 0x73ea, .word = 0xadb0, .immediate=0, .flags=0x80, .name = "ELEM-NAME" },
  { .ov = -1, .code = 0x73ea, .word = 0xadc2, .immediate=0, .flags=0x80, .name = "ELEM-VAL" },
  { .ov = -1, .code = 0x73ea, .word = 0xadd4, .immediate=0, .flags=0x80, .name = "ART-NAME" },
  { .ov = -1, .code = 0x73ea, .word = 0xade6, .immediate=0, .flags=0x80, .name = "ART-VAL" },
  { .ov = -1, .code = 0x73ea, .word = 0xadf8, .immediate=0, .flags=0x80, .name = "ART-VOL" },
  { .ov = -1, .code = 0x744d, .word = 0xae0a, .immediate=0, .flags=0x80, .name = "PHR-CNT" },
  { .ov = -1, .code = 0x744d, .word = 0xae18, .immediate=0, .flags=0x80, .name = "PHRASE-MEM" },
  { .ov = -1, .code = 0x224c, .word = 0xae23, .immediate=0, .flags=0x80, .name = "U>$" },
  { .ov = -1, .code = 0x224c, .word = 0xae2f, .immediate=0, .flags=0x00, .name = "WAE2F" },
  { .ov = -1, .code = 0x224c, .word = 0xae45, .immediate=0, .flags=0x00, .name = "WAE45" },
  { .ov = -1, .code = 0x224c, .word = 0xae67, .immediate=0, .flags=0x80, .name = "<CTVERSIONERROR>" },
  { .ov = -1, .code = 0x224c, .word = 0xae85, .immediate=0, .flags=0x80, .name = "<CTASKMOUNT>" },
  { .ov = -1, .code = 0x744d, .word = 0xae9b, .immediate=0, .flags=0x80, .name = "TEXT-CO" },
  { .ov = -1, .code = 0x744d, .word = 0xaeaa, .immediate=0, .flags=0x80, .name = "TEXT-IN" },
  { .ov = -1, .code = 0x744d, .word = 0xaeb9, .immediate=0, .flags=0x80, .name = "TEXT-TE" },
  { .ov = -1, .code = 0x224c, .word = 0xaec8, .immediate=0, .flags=0x80, .name = "TEXT>PA" },
  { .ov = -1, .code = 0x224c, .word = 0xaee8, .immediate=0, .flags=0x80, .name = "CMESS" },
  { .ov = -1, .code = 0x224c, .word = 0xaf1f, .immediate=0, .flags=0x80, .name = "X0MESS" },
  { .ov = -1, .code = 0x224c, .word = 0xaf53, .immediate=0, .flags=0x80, .name = "0MESS" },
  { .ov = -1, .code = 0x2214, .word = 0xaf5b, .immediate=0, .flags=0x00, .name = "WAF5B" },
  { .ov = -1, .code = 0x224c, .word = 0xaf69, .immediate=0, .flags=0x80, .name = "-XTRAILING" },
  { .ov = -1, .code = 0x224c, .word = 0xafa3, .immediate=0, .flags=0x80, .name = "CEX+WAX" },
  { .ov = -1, .code = 0x224c, .word = 0xafaf, .immediate=0, .flags=0x00, .name = "WAFAF" },
  { .ov = -1, .code = 0x224c, .word = 0xafcd, .immediate=0, .flags=0x00, .name = "WAFCD" },
  { .ov = -1, .code = 0x224c, .word = 0xafd5, .immediate=0, .flags=0x00, .name = "WAFD5" },
  { .ov = -1, .code = 0x224c, .word = 0xafdd, .immediate=0, .flags=0x00, .name = "WAFDD" },
  { .ov = -1, .code = 0x224c, .word = 0xafe5, .immediate=0, .flags=0x00, .name = "WAFE5" },
  { .ov = -1, .code = 0x224c, .word = 0xafed, .immediate=0, .flags=0x00, .name = "WAFED" },
  { .ov = -1, .code = 0x224c, .word = 0xaffb, .immediate=0, .flags=0x00, .name = "WAFFB" },
  { .ov = -1, .code = 0x224c, .word = 0xb003, .immediate=0, .flags=0x00, .name = "WB003" },
  { .ov = -1, .code = 0x224c, .word = 0xb00b, .immediate=0, .flags=0x00, .name = "WB00B" },
  { .ov = -1, .code = 0x224c, .word = 0xb013, .immediate=0, .flags=0x00, .name = "WB013" },
  { .ov = -1, .code = 0x224c, .word = 0xb02b, .immediate=0, .flags=0x80, .name = "?NEW-HO" },
  { .ov = -1, .code = 0x224c, .word = 0xb041, .immediate=0, .flags=0x00, .name = "WB041" },
  { .ov = -1, .code = 0x224c, .word = 0xb049, .immediate=0, .flags=0x00, .name = "WB049" },
  { .ov = -1, .code = 0x224c, .word = 0xb0bd, .immediate=0, .flags=0x80, .name = "PARALLE" },
  { .ov = -1, .code = 0x224c, .word = 0xb0d1, .immediate=0, .flags=0x00, .name = "WB0D1" },
  { .ov = -1, .code = 0x224c, .word = 0xb0e1, .immediate=0, .flags=0x00, .name = "WB0E1" },
  { .ov = -1, .code = 0x224c, .word = 0xb0f1, .immediate=0, .flags=0x00, .name = "WB0F1" },
  { .ov = -1, .code = 0x224c, .word = 0xb103, .immediate=0, .flags=0x80, .name = "DOTASKS" },
  { .ov = -1, .code = 0x224c, .word = 0xb18a, .immediate=0, .flags=0x00, .name = "WB18A" },
  { .ov = -1, .code = 0x224c, .word = 0xb1a4, .immediate=0, .flags=0x00, .name = "RESTOREINT24" },
  { .ov = -1, .code = 0x224c, .word = 0xb1bc, .immediate=0, .flags=0x80, .name = "SETDBUF" },
  { .ov = -1, .code = 0x224c, .word = 0xb219, .immediate=0, .flags=0x80, .name = "XOR!" },
  { .ov = -1, .code = 0x224c, .word = 0xb255, .immediate=0, .flags=0x80, .name = "HEAD!" },
  { .ov = -1, .code = 0x224c, .word = 0xb2cb, .immediate=0, .flags=0x00, .name = "LFCLAIM" },
  { .ov = -1, .code = 0x224c, .word = 0xb2dd, .immediate=0, .flags=0x00, .name = "AINSTALL" },
  { .ov = -1, .code = 0x224c, .word = 0xb2ff, .immediate=0, .flags=0x00, .name = "BINSTALL" },
  { .ov = -1, .code = 0x224c, .word = 0xb309, .immediate=0, .flags=0x00, .name = "AINSTALLS" },
  { .ov = -1, .code = 0x224c, .word = 0xb32f, .immediate=0, .flags=0x00, .name = "BINSTALLS" },
  { .ov = -1, .code = 0x224c, .word = 0xb3b8, .immediate=0, .flags=0x80, .name = "ICINIT" },
  { .ov = -1, .code = 0x224c, .word = 0xb3e4, .immediate=0, .flags=0x00, .name = "INIT-CRS" },
  { .ov = -1, .code = 0xb40e, .word = 0xb40e, .immediate=0, .flags=0x80, .name = "XKEYINT" },
  { .ov = -1, .code = 0x224c, .word = 0xb439, .immediate=0, .flags=0x80, .name = "INSTALLXKEY" },
  { .ov = -1, .code = 0x224c, .word = 0xb45f, .immediate=0, .flags=0x00, .name = "KILLBREAK" },
  { .ov = -1, .code = 0x224c, .word = 0xb46f, .immediate=0, .flags=0x00, .name = "farb" },
  { .ov = -1, .code = 0x224c, .word = 0xb485, .immediate=0, .flags=0x80, .name = "RESTOREKEY" },
  { .ov = -1, .code = 0x224c, .word = 0xb49f, .immediate=0, .flags=0x00, .name = "FLIMP" },
  { .ov = -1, .code = 0x224c, .word = 0xb4b1, .immediate=0, .flags=0x80, .name = "CFIGARRAYS" },
  { .ov = -1, .code = 0x224c, .word = 0xb4eb, .immediate=0, .flags=0x80, .name = "LDFONTS" },
  { .ov = -1, .code = 0x224c, .word = 0xb503, .immediate=0, .flags=0x80, .name = "CONFIGURE-SYSTEM" },
  { .ov = -1, .code = 0x224c, .word = 0xb563, .immediate=0, .flags=0x80, .name = "STARTER" },
  { .ov = -1, .code = 0x224c, .word = 0xb571, .immediate=0, .flags=0x80, .name = "DOS" },
  { .ov = -1, .code = 0x1ab5, .word = 0xb57d, .immediate=1, .flags=0x80, .name = "MUSIC" },
  { .ov = -1, .code = 0x83f8, .word = 0xb59e, .immediate=0, .flags=0x80, .name = "MUSIC-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xb5aa, .immediate=0, .flags=0x80, .name = "HIMUS" },
  { .ov = -1, .code = 0x3b68, .word = 0xb5be, .immediate=0, .flags=0x80, .name = "*CAPT-LOG" },
  { .ov = -1, .code = 0x3b68, .word = 0xb5ca, .immediate=0, .flags=0x80, .name = "*OP" },
  { .ov = -1, .code = 0x3b68, .word = 0xb5dc, .immediate=0, .flags=0x80, .name = "*COMM-OFF" },
  { .ov = -1, .code = 0x3b68, .word = 0xb5e9, .immediate=0, .flags=0x80, .name = "*EOL" },
  { .ov = -1, .code = 0x1d29, .word = 0xb5f8, .immediate=0, .flags=0x80, .name = "OTABLE" },
  { .ov = -1, .code = 0x4a4f, .word = 0xb62b, .immediate=0, .flags=0x80, .name = "+ORG" },
  { .ov = -1, .code = 0x224c, .word = 0xb648, .immediate=0, .flags=0x80, .name = "ORGIADDR" },
  { .ov = -1, .code = 0x224c, .word = 0xb66e, .immediate=0, .flags=0x80, .name = "XHBUF-SEG" },
  { .ov = -1, .code = 0x1d29, .word = 0xb68d, .immediate=0, .flags=0x80, .name = "COND-CNT" },
  { .ov = -1, .code = 0x2214, .word = 0xb698, .immediate=0, .flags=0x80, .name = "TRUE" },
  { .ov = -1, .code = 0x2214, .word = 0xb6a4, .immediate=0, .flags=0x80, .name = "FALSE" },
  { .ov = -1, .code = 0x2214, .word = 0xb6b2, .immediate=0, .flags=0x80, .name = "UNKNOWN" },
  { .ov = -1, .code = 0x2214, .word = 0xb6c0, .immediate=0, .flags=0x80, .name = "RULELIM" },
  { .ov = -1, .code = 0x2214, .word = 0xb6ce, .immediate=0, .flags=0x80, .name = "CONDLIM" },
  { .ov = -1, .code = 0x2214, .word = 0xb6dc, .immediate=0, .flags=0x80, .name = "RULECNT" },
  { .ov = -1, .code = 0x2214, .word = 0xb6ea, .immediate=0, .flags=0x80, .name = "RULEARR" },
  { .ov = -1, .code = 0x2214, .word = 0xb6f8, .immediate=0, .flags=0x80, .name = "CONDARR" },
  { .ov = -1, .code = 0x2214, .word = 0xb706, .immediate=0, .flags=0x80, .name = "CFLGARR" },
  { .ov = -1, .code = 0x224c, .word = 0xb710, .immediate=0, .flags=0x80, .name = "XC@" },
  { .ov = -1, .code = 0x224c, .word = 0xb722, .immediate=0, .flags=0x80, .name = "C+!" },
  { .ov = -1, .code = 0x224c, .word = 0xb73c, .immediate=0, .flags=0x80, .name = ">EXPERT" },
  { .ov = -1, .code = 0x224c, .word = 0xb795, .immediate=0, .flags=0x80, .name = "DISTRACT" },
  { .ov = -1, .code = 0x224c, .word = 0xb7b4, .immediate=0, .flags=0x80, .name = "EXECUTE-RULE" },
  { .ov = -1, .code = 0x224c, .word = 0xb83f, .immediate=0, .flags=0x80, .name = "EXPERT" },
  { .ov = -1, .code = 0x224c, .word = 0xb8ce, .immediate=0, .flags=0x80, .name = "-->" },
  { .ov = -1, .code = 0x224c, .word = 0xb8dd, .immediate=0, .flags=0x80, .name = "?INDEX" },
  { .ov = -1, .code = 0x224c, .word = 0xb91d, .immediate=0, .flags=0x80, .name = "CONDITION" },
  { .ov = -1, .code = 0x224c, .word = 0xb98a, .immediate=0, .flags=0x80, .name = "RULE:" },
  { .ov = -1, .code = 0x1ab5, .word = 0xba2a, .immediate=1, .flags=0x80, .name = "IT-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xba48, .immediate=0, .flags=0x80, .name = "IT-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xba4c, .immediate=0, .flags=0x00, .name = "WBA4C" },
  { .ov = -1, .code = 0x224c, .word = 0xba56, .immediate=0, .flags=0x00, .name = "WBA56" },
  { .ov = -1, .code = 0x224c, .word = 0xba60, .immediate=0, .flags=0x00, .name = "WBA60" },
  { .ov = -1, .code = 0x224c, .word = 0xba6a, .immediate=0, .flags=0x00, .name = "WBA6A" },
  { .ov = -1, .code = 0x224c, .word = 0xba74, .immediate=0, .flags=0x00, .name = "WBA74" },
  { .ov = -1, .code = 0x224c, .word = 0xba7e, .immediate=0, .flags=0x00, .name = "WBA7E" },
  { .ov = -1, .code = 0x224c, .word = 0xba88, .immediate=0, .flags=0x00, .name = "WBA88" },
  { .ov = -1, .code = 0x224c, .word = 0xba92, .immediate=0, .flags=0x00, .name = "WBA92" },
  { .ov = -1, .code = 0x224c, .word = 0xba9c, .immediate=0, .flags=0x00, .name = "WBA9C" },
  { .ov = -1, .code = 0x224c, .word = 0xbaa6, .immediate=0, .flags=0x00, .name = "WBAA6" },
  { .ov = -1, .code = 0x224c, .word = 0xbab0, .immediate=0, .flags=0x00, .name = "WBAB0" },
  { .ov = -1, .code = 0x224c, .word = 0xbac4, .immediate=0, .flags=0x80, .name = "DATE$>ADR" },
  { .ov = -1, .code = 0x224c, .word = 0xbad8, .immediate=0, .flags=0x80, .name = "BOX>LIS" },
  { .ov = -1, .code = 0x224c, .word = 0xbaec, .immediate=0, .flags=0x80, .name = "GET-BOX" },
  { .ov = -1, .code = 0x224c, .word = 0xbb00, .immediate=0, .flags=0x80, .name = "MAKE-SC" },
  { .ov = -1, .code = 0x224c, .word = 0xbb14, .immediate=0, .flags=0x80, .name = "delete-scroll-box" },
  { .ov = -1, .code = 0x224c, .word = 0xbb28, .immediate=0, .flags=0x80, .name = "BOX>TOC" },
  { .ov = -1, .code = 0x224c, .word = 0xbb39, .immediate=0, .flags=0x80, .name = ">BOX" },
  { .ov = -1, .code = 0x224c, .word = 0xbb4a, .immediate=0, .flags=0x80, .name = "BOX>" },
  { .ov = -1, .code = 0x224c, .word = 0xbb5d, .immediate=0, .flags=0x80, .name = "(BOX>)" },
  { .ov = -1, .code = 0x224c, .word = 0xbb71, .immediate=0, .flags=0x80, .name = "CLASS>B" },
  { .ov = -1, .code = 0x224c, .word = 0xbb85, .immediate=0, .flags=0x80, .name = "ITEM>PA" },
  { .ov = -1, .code = 0x1d29, .word = 0xbb98, .immediate=0, .flags=0x80, .name = "BTADDR" },
  { .ov = -1, .code = 0x1d29, .word = 0xbb9c, .immediate=0, .flags=0x00, .name = "HUFF_BT_POINTER" },
  { .ov = -1, .code = 0x1d29, .word = 0xbba0, .immediate=0, .flags=0x00, .name = "HUFF_ACTIVE_POINTER_BYTE" },
  { .ov = -1, .code = 0x1d29, .word = 0xbba4, .immediate=0, .flags=0x00, .name = "WBBA4" },
  { .ov = -1, .code = 0x1d29, .word = 0xbba8, .immediate=0, .flags=0x00, .name = "HUFF_ACTIVE_POINTER_BIT" },
  { .ov = -1, .code = 0x2214, .word = 0xbbac, .immediate=0, .flags=0x00, .name = "HUFF_PHRASE_ADDCHAR" },
  { .ov = -1, .code = 0x2214, .word = 0xbbb0, .immediate=0, .flags=0x00, .name = "HUFF_PHRASE_INIT" },
  { .ov = -1, .code = 0x2214, .word = 0xbbb4, .immediate=0, .flags=0x00, .name = "HUFF_PHRASE_FINISH" },
  { .ov = -1, .code = 0x224c, .word = 0xbbb8, .immediate=0, .flags=0x00, .name = "HUFF_MOVE_ACTIVE_POINTER" },
  { .ov = -1, .code = 0x224c, .word = 0xbbde, .immediate=0, .flags=0x00, .name = "WBBDE" },
  { .ov = -1, .code = 0x224c, .word = 0xbc36, .immediate=0, .flags=0x80, .name = "HUFF>" },
  { .ov = -1, .code = 0x744d, .word = 0xbc82, .immediate=0, .flags=0x80, .name = "PHRASE$" },
  { .ov = -1, .code = 0x224c, .word = 0xbc87, .immediate=0, .flags=0x00, .name = "HUFF_LSCAN_INIT" },
  { .ov = -1, .code = 0x224c, .word = 0xbc8f, .immediate=0, .flags=0x00, .name = "HUFF_LSCAN_ADDCHAR" },
  { .ov = -1, .code = 0x224c, .word = 0xbca5, .immediate=0, .flags=0x00, .name = "HUFF_LSCAN_FINISH" },
  { .ov = -1, .code = 0x1ab5, .word = 0xbd1f, .immediate=1, .flags=0x80, .name = "MISC-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xbd3d, .immediate=0, .flags=0x80, .name = "MISC-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xbd4a, .immediate=0, .flags=0x80, .name = "=CARGO" },
  { .ov = -1, .code = 0x224c, .word = 0xbd5b, .immediate=0, .flags=0x80, .name = "OV#IN$" },
  { .ov = -1, .code = 0x224c, .word = 0xbd70, .immediate=0, .flags=0x80, .name = "OVQUITMESS" },
  { .ov = -1, .code = 0x224c, .word = 0xbd82, .immediate=0, .flags=0x80, .name = "OV.0$$$" },
  { .ov = -1, .code = 0x224c, .word = 0xbd97, .immediate=0, .flags=0x80, .name = "OV0$$$MESS" },
  { .ov = -1, .code = 0x224c, .word = 0xbda8, .immediate=0, .flags=0x80, .name = "OVTRIM" },
  { .ov = -1, .code = 0x224c, .word = 0xbdba, .immediate=0, .flags=0x80, .name = "OVTRIMS" },
  { .ov = -1, .code = 0x224c, .word = 0xbdd8, .immediate=0, .flags=0x80, .name = "OV?ARTIFACT" },
  { .ov = -1, .code = 0x224c, .word = 0xbdef, .immediate=0, .flags=0x80, .name = "OV?.EQUIP-OK" },
  { .ov = -1, .code = 0x1ab5, .word = 0xbe01, .immediate=1, .flags=0x80, .name = "ENG-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xbe1f, .immediate=0, .flags=0x80, .name = "ENG-O" },
  { .ov = -1, .code = 0x224c, .word = 0xbe2b, .immediate=0, .flags=0x80, .name = "OV/DA" },
  { .ov = -1, .code = 0x224c, .word = 0xbe3b, .immediate=0, .flags=0x80, .name = "OV/RE" },
  { .ov = -1, .code = 0x224c, .word = 0xbe4b, .immediate=0, .flags=0x80, .name = "OVDBA" },
  { .ov = -1, .code = 0x1ab5, .word = 0xbe5d, .immediate=1, .flags=0x80, .name = "BLT-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xbe7c, .immediate=0, .flags=0x80, .name = "BLT-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xbe8a, .immediate=0, .flags=0x80, .name = ".RUNBIT" },
  { .ov = -1, .code = 0x224c, .word = 0xbe9d, .immediate=0, .flags=0x80, .name = "@.HYBRID" },
  { .ov = -1, .code = 0x224c, .word = 0xbeb2, .immediate=0, .flags=0x80, .name = ".EGARUNBIT" },
  { .ov = -1, .code = 0x1ab5, .word = 0xbec4, .immediate=1, .flags=0x80, .name = "SCI-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xbee3, .immediate=0, .flags=0x80, .name = "SCI-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xbef3, .immediate=0, .flags=0x80, .name = "OV/STATUS" },
  { .ov = -1, .code = 0x224c, .word = 0xbf05, .immediate=0, .flags=0x80, .name = "OV/STXT" },
  { .ov = -1, .code = 0x224c, .word = 0xbf1a, .immediate=0, .flags=0x80, .name = "OVSTARDATE" },
  { .ov = -1, .code = 0x224c, .word = 0xbf31, .immediate=0, .flags=0x80, .name = "OV/SENSORS" },
  { .ov = -1, .code = 0x224c, .word = 0xbf42, .immediate=0, .flags=0x80, .name = "?HEAVY" },
  { .ov = -1, .code = 0x224c, .word = 0xbf56, .immediate=0, .flags=0x80, .name = "/STARDATE" },
  { .ov = -1, .code = 0x224c, .word = 0xbf68, .immediate=0, .flags=0x80, .name = ".SORD" },
  { .ov = -1, .code = 0x224c, .word = 0xbf98, .immediate=0, .flags=0x80, .name = "?VCYCLE" },
  { .ov = -1, .code = 0x1d29, .word = 0xbfaf, .immediate=0, .flags=0x80, .name = "HEALTI" },
  { .ov = -1, .code = 0x1d29, .word = 0xbfbc, .immediate=0, .flags=0x80, .name = "LASTAP" },
  { .ov = -1, .code = 0x1d29, .word = 0xbfcb, .immediate=0, .flags=0x80, .name = "ROSTER" },
  { .ov = -1, .code = 0x1ab5, .word = 0xbfe8, .immediate=1, .flags=0x80, .name = "HEALER" },
  { .ov = -1, .code = 0x83f8, .word = 0xc007, .immediate=0, .flags=0x80, .name = "HEAL-O" },
  { .ov = -1, .code = 0x224c, .word = 0xc012, .immediate=0, .flags=0x80, .name = "(OBI" },
  { .ov = -1, .code = 0x224c, .word = 0xc021, .immediate=0, .flags=0x80, .name = "(.VI" },
  { .ov = -1, .code = 0x224c, .word = 0xc030, .immediate=0, .flags=0x80, .name = "(HEA" },
  { .ov = -1, .code = 0x224c, .word = 0xc03f, .immediate=0, .flags=0x80, .name = "(ROL" },
  { .ov = -1, .code = 0x224c, .word = 0xc04e, .immediate=0, .flags=0x80, .name = "OBIT" },
  { .ov = -1, .code = 0x224c, .word = 0xc05f, .immediate=0, .flags=0x80, .name = "HEAL" },
  { .ov = -1, .code = 0x224c, .word = 0xc070, .immediate=0, .flags=0x80, .name = ".VIT" },
  { .ov = -1, .code = 0x224c, .word = 0xc081, .immediate=0, .flags=0x80, .name = "?APP" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc0ba, .immediate=1, .flags=0x80, .name = "REPAIR" },
  { .ov = -1, .code = 0x83f8, .word = 0xc0da, .immediate=0, .flags=0x80, .name = "REPAIR-" },
  { .ov = -1, .code = 0x224c, .word = 0xc0e8, .immediate=0, .flags=0x80, .name = "DO-REPA" },
  { .ov = -1, .code = 0x224c, .word = 0xc104, .immediate=0, .flags=0x80, .name = "?SHIP-REPAIR" },
  { .ov = -1, .code = 0x224c, .word = 0xc136, .immediate=0, .flags=0x80, .name = "MREPAIR" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc163, .immediate=1, .flags=0x80, .name = "COMM-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xc183, .immediate=0, .flags=0x80, .name = "COMM-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc195, .immediate=0, .flags=0x80, .name = "OVINIT-COMM" },
  { .ov = -1, .code = 0x224c, .word = 0xc1a8, .immediate=0, .flags=0x80, .name = "U-COMM" },
  { .ov = -1, .code = 0x224c, .word = 0xc1c1, .immediate=0, .flags=0x80, .name = "COMM-EXPERTS" },
  { .ov = -1, .code = 0x224c, .word = 0xc1d1, .immediate=0, .flags=0x80, .name = "A>O" },
  { .ov = -1, .code = 0x224c, .word = 0xc1e1, .immediate=0, .flags=0x80, .name = "O>C" },
  { .ov = -1, .code = 0x224c, .word = 0xc1f3, .immediate=0, .flags=0x80, .name = ">HAIL" },
  { .ov = -1, .code = 0x224c, .word = 0xc205, .immediate=0, .flags=0x80, .name = "OV+!EDL" },
  { .ov = -1, .code = 0x224c, .word = 0xc216, .immediate=0, .flags=0x80, .name = "P>CT" },
  { .ov = -1, .code = 0x224c, .word = 0xc227, .immediate=0, .flags=0x80, .name = "CTUP" },
  { .ov = -1, .code = 0x224c, .word = 0xc23b, .immediate=0, .flags=0x80, .name = "OVEDL+AUX" },
  { .ov = -1, .code = 0x224c, .word = 0xc255, .immediate=0, .flags=0x80, .name = "MCOMM-EXPERTS" },
  { .ov = -1, .code = 0x224c, .word = 0xc26a, .immediate=0, .flags=0x80, .name = "MEDL+AUX" },
  { .ov = -1, .code = 0x224c, .word = 0xc27d, .immediate=0, .flags=0x80, .name = "DA-STR" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc292, .immediate=1, .flags=0x80, .name = "XCOM-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xc2b2, .immediate=0, .flags=0x80, .name = "XCOM-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc2be, .immediate=0, .flags=0x80, .name = "XCOMM" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc2ce, .immediate=1, .flags=0x80, .name = "FRACT" },
  { .ov = -1, .code = 0x83f8, .word = 0xc2ef, .immediate=0, .flags=0x80, .name = "FRACT-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc302, .immediate=0, .flags=0x80, .name = "MERCATOR-GEN" },
  { .ov = -1, .code = 0x224c, .word = 0xc317, .immediate=0, .flags=0x80, .name = "NEWCONTOUR" },
  { .ov = -1, .code = 0x224c, .word = 0xc32c, .immediate=0, .flags=0x80, .name = "MAKE-GLOBE" },
  { .ov = -1, .code = 0x224c, .word = 0xc33e, .immediate=0, .flags=0x80, .name = "SCRLCON" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc34e, .immediate=1, .flags=0x80, .name = "ORBIT" },
  { .ov = -1, .code = 0x83f8, .word = 0xc36f, .immediate=0, .flags=0x80, .name = "ORBIT-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc380, .immediate=0, .flags=0x80, .name = "INIT-ORBIT" },
  { .ov = -1, .code = 0x224c, .word = 0xc395, .immediate=0, .flags=0x80, .name = "SHOWSITE" },
  { .ov = -1, .code = 0x224c, .word = 0xc3a7, .immediate=0, .flags=0x80, .name = "DESCEND" },
  { .ov = -1, .code = 0x224c, .word = 0xc3ba, .immediate=0, .flags=0x80, .name = "ASCEND" },
  { .ov = -1, .code = 0x224c, .word = 0xc3cd, .immediate=0, .flags=0x80, .name = "ROTATE" },
  { .ov = -1, .code = 0x224c, .word = 0xc3e1, .immediate=0, .flags=0x80, .name = "SEEGRID" },
  { .ov = -1, .code = 0x224c, .word = 0xc3f3, .immediate=0, .flags=0x80, .name = "MROTATE" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc406, .immediate=1, .flags=0x80, .name = "VICONP" },
  { .ov = -1, .code = 0x83f8, .word = 0xc427, .immediate=0, .flags=0x80, .name = "ICONP-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc437, .immediate=0, .flags=0x80, .name = "ICON-PARM" },
  { .ov = -1, .code = 0x224c, .word = 0xc44b, .immediate=0, .flags=0x80, .name = "+ICONBXOV" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc45e, .immediate=1, .flags=0x80, .name = "SITE-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xc47e, .immediate=0, .flags=0x80, .name = "SITE-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc48c, .immediate=0, .flags=0x80, .name = "(.MERC)" },
  { .ov = -1, .code = 0x224c, .word = 0xc4a2, .immediate=0, .flags=0x80, .name = "(GETSITE)" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc4b9, .immediate=1, .flags=0x80, .name = "FLUX-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xc4d9, .immediate=0, .flags=0x80, .name = "FLUX-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc4e5, .immediate=0, .flags=0x80, .name = "OVFLUX-EFFECT" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc4f8, .immediate=1, .flags=0x80, .name = "BANK-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xc518, .immediate=0, .flags=0x80, .name = "BANK-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc52d, .immediate=0, .flags=0x80, .name = "OVINIT-BALANCE" },
  { .ov = -1, .code = 0x224c, .word = 0xc542, .immediate=0, .flags=0x80, .name = "OVTRANSACT" },
  { .ov = -1, .code = 0x224c, .word = 0xc558, .immediate=0, .flags=0x80, .name = "OVD@BALANCE" },
  { .ov = -1, .code = 0x224c, .word = 0xc56e, .immediate=0, .flags=0x80, .name = "OVD!BALANCE" },
  { .ov = -1, .code = 0x224c, .word = 0xc583, .immediate=0, .flags=0x80, .name = "OV?BALANCE" },
  { .ov = -1, .code = 0x224c, .word = 0xc596, .immediate=0, .flags=0x80, .name = "OV!TFLAG" },
  { .ov = -1, .code = 0x224c, .word = 0xc5a8, .immediate=0, .flags=0x80, .name = "I-TRANS" },
  { .ov = -1, .code = 0x224c, .word = 0xc5b6, .immediate=0, .flags=0x80, .name = "U-B" },
  { .ov = -1, .code = 0x224c, .word = 0xc5ca, .immediate=0, .flags=0x80, .name = "T+BALANCE" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc5e4, .immediate=1, .flags=0x80, .name = "ACREW-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xc605, .immediate=0, .flags=0x80, .name = "ACREW-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc610, .immediate=0, .flags=0x80, .name = "U-AC" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc624, .immediate=1, .flags=0x80, .name = "PFILE-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xc645, .immediate=0, .flags=0x80, .name = "PFILE-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc650, .immediate=0, .flags=0x80, .name = "U-PF" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc666, .immediate=1, .flags=0x80, .name = "SHIP-GR-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xc689, .immediate=0, .flags=0x80, .name = "SHIP-GR-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc697, .immediate=0, .flags=0x80, .name = "OV.MASS" },
  { .ov = -1, .code = 0x224c, .word = 0xc6a8, .immediate=0, .flags=0x80, .name = "OV.ACC" },
  { .ov = -1, .code = 0x224c, .word = 0xc6ba, .immediate=0, .flags=0x80, .name = "OV.PODS" },
  { .ov = -1, .code = 0x224c, .word = 0xc6cc, .immediate=0, .flags=0x80, .name = "OV.SHIP" },
  { .ov = -1, .code = 0x224c, .word = 0xc6e4, .immediate=0, .flags=0x80, .name = "OVBALANCEMESS" },
  { .ov = -1, .code = 0x224c, .word = 0xc6f8, .immediate=0, .flags=0x80, .name = "OV.CONFIG" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc70d, .immediate=1, .flags=0x80, .name = "CONFIG-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xc72f, .immediate=0, .flags=0x80, .name = "CONFIG-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc73a, .immediate=0, .flags=0x80, .name = "U-SC" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc74b, .immediate=1, .flags=0x80, .name = "TD-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xc769, .immediate=0, .flags=0x80, .name = "TD-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc776, .immediate=0, .flags=0x80, .name = "<TDART" },
  { .ov = -1, .code = 0x224c, .word = 0xc785, .immediate=0, .flags=0x80, .name = "U-TD" },
  { .ov = -1, .code = 0x224c, .word = 0xc794, .immediate=0, .flags=0x80, .name = "TOSS" },
  { .ov = -1, .code = 0x224c, .word = 0xc7ab, .immediate=0, .flags=0x80, .name = "KEY-ELEM-AMT" },
  { .ov = -1, .code = 0x1d29, .word = 0xc7bd, .immediate=0, .flags=0x80, .name = "?FANLYZ" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc7ca, .immediate=1, .flags=0x80, .name = "OP-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xc7e8, .immediate=0, .flags=0x80, .name = "OP-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc7f3, .immediate=0, .flags=0x80, .name = "U-OP" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc804, .immediate=1, .flags=0x80, .name = "SETTER" },
  { .ov = -1, .code = 0x83f8, .word = 0xc825, .immediate=0, .flags=0x80, .name = "PLSET-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc834, .immediate=0, .flags=0x80, .name = "SET-PLANET" },
  { .ov = -1, .code = 0x224c, .word = 0xc843, .immediate=0, .flags=0x80, .name = "SETC" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc857, .immediate=1, .flags=0x80, .name = "DPART-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xc878, .immediate=0, .flags=0x80, .name = "DPART-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc885, .immediate=0, .flags=0x80, .name = "DEPART" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc897, .immediate=1, .flags=0x80, .name = "DAMAGE_1" },
  { .ov = -1, .code = 0x83f8, .word = 0xc8b7, .immediate=0, .flags=0x80, .name = "DAMAGE_2" },
  { .ov = -1, .code = 0x224c, .word = 0xc8c3, .immediate=0, .flags=0x80, .name = "DO-DA" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc8d9, .immediate=1, .flags=0x80, .name = "COMBAT-VO" },
  { .ov = -1, .code = 0x83f8, .word = 0xc8fa, .immediate=0, .flags=0x80, .name = "COMBAT-O" },
  { .ov = -1, .code = 0x224c, .word = 0xc904, .immediate=0, .flags=0x80, .name = "(WA" },
  { .ov = -1, .code = 0x224c, .word = 0xc914, .immediate=0, .flags=0x80, .name = "(CO" },
  { .ov = -1, .code = 0x224c, .word = 0xc92a, .immediate=0, .flags=0x80, .name = "CSC" },
  { .ov = -1, .code = 0x224c, .word = 0xc938, .immediate=0, .flags=0x80, .name = "C&C" },
  { .ov = -1, .code = 0x224c, .word = 0xc948, .immediate=0, .flags=0x80, .name = "COM" },
  { .ov = -1, .code = 0x224c, .word = 0xc958, .immediate=0, .flags=0x80, .name = "WAR" },
  { .ov = -1, .code = 0x1d29, .word = 0xc96d, .immediate=0, .flags=0x80, .name = "?CALLING" },
  { .ov = -1, .code = 0x1ab5, .word = 0xc97d, .immediate=1, .flags=0x80, .name = "HMISC-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xc99e, .immediate=0, .flags=0x80, .name = "HMISC-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xc9a8, .immediate=0, .flags=0x80, .name = "UFM" },
  { .ov = -1, .code = 0x224c, .word = 0xc9b6, .immediate=0, .flags=0x80, .name = "USM" },
  { .ov = -1, .code = 0x224c, .word = 0xc9c4, .immediate=0, .flags=0x80, .name = "NFM" },
  { .ov = -1, .code = 0x224c, .word = 0xc9d2, .immediate=0, .flags=0x80, .name = "NSM" },
  { .ov = -1, .code = 0x224c, .word = 0xc9e0, .immediate=0, .flags=0x80, .name = ".EX" },
  { .ov = -1, .code = 0x224c, .word = 0xc9ef, .immediate=0, .flags=0x80, .name = "DMSG" },
  { .ov = -1, .code = 0x224c, .word = 0xc9fe, .immediate=0, .flags=0x80, .name = "D-UP" },
  { .ov = -1, .code = 0x224c, .word = 0xca11, .immediate=0, .flags=0x80, .name = "DO-FLARE" },
  { .ov = -1, .code = 0x224c, .word = 0xca20, .immediate=0, .flags=0x80, .name = "?PRL" },
  { .ov = -1, .code = 0x224c, .word = 0xca2f, .immediate=0, .flags=0x80, .name = "OSET" },
  { .ov = -1, .code = 0x224c, .word = 0xca3f, .immediate=0, .flags=0x80, .name = "ORBUP" },
  { .ov = -1, .code = 0x224c, .word = 0xca55, .immediate=0, .flags=0x80, .name = "TRAK-ENCS" },
  { .ov = -1, .code = 0x224c, .word = 0xca7c, .immediate=0, .flags=0x80, .name = "HEAT" },
  { .ov = -1, .code = 0x224c, .word = 0xca8c, .immediate=0, .flags=0x80, .name = "!'EXT" },
  { .ov = -1, .code = 0x224c, .word = 0xca9d, .immediate=0, .flags=0x80, .name = "(CTXT)" },
  { .ov = -1, .code = 0x224c, .word = 0xcab5, .immediate=0, .flags=0x80, .name = "CONTEXT-CASES" },
  { .ov = -1, .code = 0x224c, .word = 0xcac9, .immediate=0, .flags=0x80, .name = "+A-VESS" },
  { .ov = -1, .code = 0x224c, .word = 0xcade, .immediate=0, .flags=0x80, .name = "MTRAK-ENCS" },
  { .ov = -1, .code = 0x224c, .word = 0xcaf0, .immediate=0, .flags=0x80, .name = "MHEAT" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcb04, .immediate=1, .flags=0x80, .name = "NAV-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xcb22, .immediate=0, .flags=0x80, .name = "NAV-O" },
  { .ov = -1, .code = 0x224c, .word = 0xcb2e, .immediate=0, .flags=0x80, .name = "OV/(D" },
  { .ov = -1, .code = 0x224c, .word = 0xcb3e, .immediate=0, .flags=0x80, .name = "OV/(U" },
  { .ov = -1, .code = 0x224c, .word = 0xcb4e, .immediate=0, .flags=0x80, .name = "OV-SH" },
  { .ov = -1, .code = 0x224c, .word = 0xcb66, .immediate=0, .flags=0x80, .name = "OV-AR" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcb80, .immediate=1, .flags=0x80, .name = "SHPMOV-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xcba0, .immediate=0, .flags=0x80, .name = "SHPMOV-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xcbaa, .immediate=0, .flags=0x80, .name = "FLY" },
  { .ov = -1, .code = 0x224c, .word = 0xcbbf, .immediate=0, .flags=0x80, .name = "MANEUVER" },
  { .ov = -1, .code = 0x224c, .word = 0xcc0a, .immediate=0, .flags=0x80, .name = "UNNEST" },
  { .ov = -1, .code = 0x224c, .word = 0xcc1a, .immediate=0, .flags=0x80, .name = ">NEST" },
  { .ov = -1, .code = 0x224c, .word = 0xcc2d, .immediate=0, .flags=0x80, .name = "GET-HAUX" },
  { .ov = -1, .code = 0x224c, .word = 0xcc3e, .immediate=0, .flags=0x80, .name = "OV.MVS" },
  { .ov = -1, .code = 0x224c, .word = 0xcc4f, .immediate=0, .flags=0x80, .name = "S>PORT" },
  { .ov = -1, .code = 0x224c, .word = 0xcc61, .immediate=0, .flags=0x80, .name = "USE-E" },
  { .ov = -1, .code = 0x224c, .word = 0xcc72, .immediate=0, .flags=0x80, .name = "MUSE-E" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcc83, .immediate=1, .flags=0x80, .name = "VITA" },
  { .ov = -1, .code = 0x83f8, .word = 0xcca3, .immediate=0, .flags=0x80, .name = "VITA-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xccad, .immediate=0, .flags=0x80, .name = "DIO" },
  { .ov = -1, .code = 0x1ab5, .word = 0xccbf, .immediate=1, .flags=0x80, .name = "HIPARMS" },
  { .ov = -1, .code = 0x83f8, .word = 0xccdd, .immediate=0, .flags=0x80, .name = "HP-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xccec, .immediate=0, .flags=0x80, .name = "C+OPARMS" },
  { .ov = -1, .code = 0x224c, .word = 0xccfa, .immediate=0, .flags=0x80, .name = "BIO" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcd12, .immediate=1, .flags=0x80, .name = "LOPARMS" },
  { .ov = -1, .code = 0x83f8, .word = 0xcd30, .immediate=0, .flags=0x80, .name = "LP-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xcd40, .immediate=0, .flags=0x80, .name = "OTHER-PAR" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcd50, .immediate=1, .flags=0x80, .name = "SENTS" },
  { .ov = -1, .code = 0x83f8, .word = 0xcd70, .immediate=0, .flags=0x80, .name = "SENT-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xcd7c, .immediate=0, .flags=0x80, .name = "?TALK" },
  { .ov = -1, .code = 0x224c, .word = 0xcd8c, .immediate=0, .flags=0x80, .name = "SAYIT" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcd9f, .immediate=1, .flags=0x80, .name = "MAPS-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xcdbd, .immediate=0, .flags=0x80, .name = "MAPS-" },
  { .ov = -1, .code = 0x224c, .word = 0xcdc8, .immediate=0, .flags=0x80, .name = "MAPS" },
  { .ov = -1, .code = 0x224c, .word = 0xcdd8, .immediate=0, .flags=0x80, .name = ".STOR" },
  { .ov = -1, .code = 0x224c, .word = 0xcde8, .immediate=0, .flags=0x80, .name = "(2X2)" },
  { .ov = -1, .code = 0x224c, .word = 0xcdf8, .immediate=0, .flags=0x80, .name = "2X2CO" },
  { .ov = -1, .code = 0x224c, .word = 0xce0a, .immediate=0, .flags=0x80, .name = "(4X4)" },
  { .ov = -1, .code = 0x224c, .word = 0xce1a, .immediate=0, .flags=0x80, .name = "4X4CO" },
  { .ov = -1, .code = 0x224c, .word = 0xce2c, .immediate=0, .flags=0x80, .name = "(8X8)" },
  { .ov = -1, .code = 0x224c, .word = 0xce3c, .immediate=0, .flags=0x80, .name = "8X8CO" },
  { .ov = -1, .code = 0x1ab5, .word = 0xce4f, .immediate=1, .flags=0x80, .name = "SEEDER" },
  { .ov = -1, .code = 0x83f8, .word = 0xce6f, .immediate=0, .flags=0x80, .name = "SEED-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xce7c, .immediate=0, .flags=0x80, .name = "POPULA" },
  { .ov = -1, .code = 0x1ab5, .word = 0xce8f, .immediate=1, .flags=0x80, .name = "ICON-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xceb4, .immediate=0, .flags=0x80, .name = "LISTICONS-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xcec0, .immediate=0, .flags=0x80, .name = "ICONS" },
  { .ov = -1, .code = 0x1ab5, .word = 0xced0, .immediate=1, .flags=0x80, .name = "ITEMS" },
  { .ov = -1, .code = 0x83f8, .word = 0xcef1, .immediate=0, .flags=0x80, .name = "ITEMS-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xcefe, .immediate=0, .flags=0x80, .name = "/ITEMS" },
  { .ov = -1, .code = 0x224c, .word = 0xcf10, .immediate=0, .flags=0x80, .name = ">DEBRIS" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcf23, .immediate=1, .flags=0x80, .name = "MOVE-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xcf43, .immediate=0, .flags=0x80, .name = "MOVE-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xcf50, .immediate=0, .flags=0x80, .name = "TVMOVE" },
  { .ov = -1, .code = 0x224c, .word = 0xcf62, .immediate=0, .flags=0x80, .name = "?POPULA" },
  { .ov = -1, .code = 0x224c, .word = 0xcf71, .immediate=0, .flags=0x80, .name = "!E/M" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcf85, .immediate=1, .flags=0x80, .name = "STORM-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xcfa6, .immediate=0, .flags=0x80, .name = "STORM-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xcfb5, .immediate=0, .flags=0x80, .name = "DO.STORM" },
  { .ov = -1, .code = 0x224c, .word = 0xcfc6, .immediate=0, .flags=0x80, .name = "INJURE" },
  { .ov = -1, .code = 0x1ab5, .word = 0xcfd5, .immediate=1, .flags=0x80, .name = "T.V." },
  { .ov = -1, .code = 0x83f8, .word = 0xcff3, .immediate=0, .flags=0x80, .name = "TV-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd001, .immediate=0, .flags=0x80, .name = "TV-DISP" },
  { .ov = -1, .code = 0x224c, .word = 0xd013, .immediate=0, .flags=0x80, .name = "(TVSET)" },
  { .ov = -1, .code = 0x224c, .word = 0xd025, .immediate=0, .flags=0x80, .name = "(CLEAN)" },
  { .ov = -1, .code = 0x224c, .word = 0xd037, .immediate=0, .flags=0x80, .name = "(HEAVE)" },
  { .ov = -1, .code = 0x224c, .word = 0xd04b, .immediate=0, .flags=0x80, .name = "(WEAPONS)" },
  { .ov = -1, .code = 0x224c, .word = 0xd05c, .immediate=0, .flags=0x80, .name = "(TALK)" },
  { .ov = -1, .code = 0x224c, .word = 0xd06e, .immediate=0, .flags=0x80, .name = "HEAVEHO" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd082, .immediate=1, .flags=0x80, .name = "BEHAVIO" },
  { .ov = -1, .code = 0x83f8, .word = 0xd0a4, .immediate=0, .flags=0x80, .name = "BEHAVE-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd0b2, .immediate=0, .flags=0x80, .name = "TVTASKS" },
  { .ov = -1, .code = 0x224c, .word = 0xd0bf, .immediate=0, .flags=0x80, .name = "TV" },
  { .ov = -1, .code = 0x224c, .word = 0xd0d2, .immediate=0, .flags=0x80, .name = "(SIMULA)" },
  { .ov = -1, .code = 0x224c, .word = 0xd0e5, .immediate=0, .flags=0x80, .name = "SIMULATE" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd0f9, .immediate=1, .flags=0x80, .name = "STP-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xd118, .immediate=0, .flags=0x80, .name = "STP-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd125, .immediate=0, .flags=0x80, .name = "SECURE" },
  { .ov = -1, .code = 0x224c, .word = 0xd136, .immediate=0, .flags=0x80, .name = "SIC'EM" },
  { .ov = -1, .code = 0x224c, .word = 0xd145, .immediate=0, .flags=0x80, .name = "2NDS" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd15a, .immediate=1, .flags=0x80, .name = "LAUNCH-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xd178, .immediate=0, .flags=0x80, .name = "LAUNC" },
  { .ov = -1, .code = 0x224c, .word = 0xd184, .immediate=0, .flags=0x80, .name = "OVCOU" },
  { .ov = -1, .code = 0x224c, .word = 0xd196, .immediate=0, .flags=0x80, .name = "OVBAC" },
  { .ov = -1, .code = 0x224c, .word = 0xd1a8, .immediate=0, .flags=0x80, .name = ".AIRL" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd1ba, .immediate=1, .flags=0x80, .name = "CAP-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xd1d8, .immediate=0, .flags=0x80, .name = "CAP-O" },
  { .ov = -1, .code = 0x224c, .word = 0xd1e4, .immediate=0, .flags=0x80, .name = "OV/IT" },
  { .ov = -1, .code = 0x224c, .word = 0xd1f4, .immediate=0, .flags=0x80, .name = "OV/CA" },
  { .ov = -1, .code = 0x224c, .word = 0xd204, .immediate=0, .flags=0x80, .name = "OV/LA" },
  { .ov = -1, .code = 0x224c, .word = 0xd214, .immediate=0, .flags=0x80, .name = "OV>DE" },
  { .ov = -1, .code = 0x224c, .word = 0xd224, .immediate=0, .flags=0x80, .name = "OV/LO" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd236, .immediate=1, .flags=0x80, .name = "DOC-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xd255, .immediate=0, .flags=0x80, .name = "DOC-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd266, .immediate=0, .flags=0x80, .name = "OV/EXAMINE" },
  { .ov = -1, .code = 0x224c, .word = 0xd279, .immediate=0, .flags=0x80, .name = "OV/TREAT" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd28a, .immediate=1, .flags=0x80, .name = "AN-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xd2a8, .immediate=0, .flags=0x80, .name = "AN-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd2ba, .immediate=0, .flags=0x80, .name = "OV/ANALYSIS" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd2c9, .immediate=1, .flags=0x80, .name = "*MAP" },
  { .ov = -1, .code = 0x83f8, .word = 0xd2e9, .immediate=0, .flags=0x80, .name = "*MAP-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd2fa, .immediate=0, .flags=0x80, .name = "OV/STARMAP" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd313, .immediate=1, .flags=0x80, .name = "LAND-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xd333, .immediate=0, .flags=0x80, .name = "LAND-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd342, .immediate=0, .flags=0x80, .name = "TRY-LAND" },
  { .ov = -1, .code = 0x224c, .word = 0xd357, .immediate=0, .flags=0x80, .name = "TRY-LAUNCH" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd369, .immediate=1, .flags=0x80, .name = "BTN-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xd388, .immediate=0, .flags=0x80, .name = "BTN-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd394, .immediate=0, .flags=0x80, .name = "OVFLT" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd3a9, .immediate=1, .flags=0x80, .name = "CHKFLT-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xd3cb, .immediate=0, .flags=0x80, .name = "CHKFLT-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd3dc, .immediate=0, .flags=0x80, .name = "?FLIGHT-OK" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd3ed, .immediate=1, .flags=0x80, .name = "PM-VOC" },
  { .ov = -1, .code = 0x83f8, .word = 0xd40b, .immediate=0, .flags=0x80, .name = "PM-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd417, .immediate=0, .flags=0x80, .name = "PORTM" },
  { .ov = -1, .code = 0x1ab5, .word = 0xd426, .immediate=1, .flags=0x80, .name = "GAME" },
  { .ov = -1, .code = 0x83f8, .word = 0xd445, .immediate=0, .flags=0x80, .name = "GAME-OV" },
  { .ov = -1, .code = 0x224c, .word = 0xd452, .immediate=0, .flags=0x80, .name = "STARTGAME" },
  { .ov = -1, .code = 0x224c, .word = 0xd463, .immediate=0, .flags=0x80, .name = "GAMEOP_1" },
  { .ov = -1, .code = 0x224c, .word = 0xd476, .immediate=0, .flags=0x80, .name = "GAMEOP_2" },
  { .ov = -1, .code = 0x224c, .word = 0xd489, .immediate=0, .flags=0x80, .name = "LET-THERE-BE-STARFLIGHT" },
  { .ov =  0, .code = 0x2214, .word = 0xef66, .immediate=0, .flags=0x00, .name = "HIBEEP" },
  { .ov =  0, .code = 0x2214, .word = 0xef6a, .immediate=0, .flags=0x00, .name = "LOBEEP" },
  { .ov =  0, .code = 0x744d, .word = 0xef6e, .immediate=0, .flags=0x00, .name = "PHRASE$" },
  { .ov =  0, .code = 0x224c, .word = 0xef73, .immediate=0, .flags=0x00, .name = "MESSPREFIX" },
  { .ov =  0, .code = 0x224c, .word = 0xf008, .immediate=0, .flags=0x00, .name = "WF008" },
  { .ov =  0, .code = 0x224c, .word = 0xf020, .immediate=0, .flags=0x00, .name = "WF020" },
  { .ov =  0, .code = 0x224c, .word = 0xf026, .immediate=0, .flags=0x00, .name = ".PHRASE" },
  { .ov =  0, .code = 0x224c, .word = 0xf064, .immediate=0, .flags=0x00, .name = ".PHRASES" },
  { .ov =  0, .code = 0x224c, .word = 0xf08e, .immediate=0, .flags=0x00, .name = "WF08E" },
  { .ov =  0, .code = 0x224c, .word = 0xf09c, .immediate=0, .flags=0x00, .name = "WF09C" },
  { .ov =  0, .code = 0x224c, .word = 0xf0d6, .immediate=0, .flags=0x00, .name = "WF0D6" },
  { .ov =  0, .code = 0x224c, .word = 0xf158, .immediate=0, .flags=0x00, .name = "?DELETE" },
  { .ov =  0, .code = 0x224c, .word = 0xf166, .immediate=0, .flags=0x00, .name = "WF166" },
  { .ov =  0, .code = 0x224c, .word = 0xf1ac, .immediate=0, .flags=0x00, .name = "OTHER-DELETE" },
  { .ov =  0, .code = 0x224c, .word = 0xf1d6, .immediate=0, .flags=0x00, .name = ".BOMBMESS" },
  { .ov =  0, .code = 0x224c, .word = 0xf252, .immediate=0, .flags=0x00, .name = "FLASHCOLOR" },
  { .ov =  0, .code = 0x224c, .word = 0xf25e, .immediate=0, .flags=0x00, .name = "EXPLOSION" },
  { .ov =  0, .code = 0x224c, .word = 0xf29e, .immediate=0, .flags=0x00, .name = "?CRYSTAL" },
  { .ov =  0, .code = 0x224c, .word = 0xf2b0, .immediate=0, .flags=0x00, .name = "?ATNEXUS" },
  { .ov =  0, .code = 0x744d, .word = 0xf2e6, .immediate=0, .flags=0x00, .name = "ORBIT-MASK" },
  { .ov =  0, .code = 0x224c, .word = 0xf2eb, .immediate=0, .flags=0x00, .name = "CLRORBMASK" },
  { .ov =  0, .code = 0x224c, .word = 0xf30b, .immediate=0, .flags=0x00, .name = "WF30B" },
  { .ov =  0, .code = 0x224c, .word = 0xf331, .immediate=0, .flags=0x00, .name = "WF331" },
  { .ov =  0, .code = 0x224c, .word = 0xf39d, .immediate=0, .flags=0x00, .name = "WF39D" },
  { .ov =  0, .code = 0x224c, .word = 0xf426, .immediate=0, .flags=0x00, .name = "WF426" },
  { .ov =  0, .code = 0x224c, .word = 0xf430, .immediate=0, .flags=0x00, .name = "?DELETEPLANET" },
  { .ov =  0, .code = 0x224c, .word = 0xf48e, .immediate=0, .flags=0x80, .name = "DEPART" },
  { .ov =  1, .code = 0x744d, .word = 0xf1b6, .immediate=0, .flags=0x00, .name = "WF1B6" },
  { .ov =  1, .code = 0x744d, .word = 0xf1bb, .immediate=0, .flags=0x00, .name = "WF1BB" },
  { .ov =  1, .code = 0x744d, .word = 0xf1c0, .immediate=0, .flags=0x00, .name = "WF1C0" },
  { .ov =  1, .code = 0x224c, .word = 0xf1c5, .immediate=0, .flags=0x00, .name = "WF1C5" },
  { .ov =  1, .code = 0x224c, .word = 0xf258, .immediate=0, .flags=0x00, .name = "WF258" },
  { .ov =  1, .code = 0x224c, .word = 0xf270, .immediate=0, .flags=0x00, .name = "WF270" },
  { .ov =  1, .code = 0x224c, .word = 0xf2a8, .immediate=0, .flags=0x00, .name = "WF2A8" },
  { .ov =  1, .code = 0x224c, .word = 0xf2ca, .immediate=0, .flags=0x00, .name = "WF2CA" },
  { .ov =  1, .code = 0x224c, .word = 0xf2de, .immediate=0, .flags=0x00, .name = "WF2DE" },
  { .ov =  1, .code = 0x224c, .word = 0xf2f5, .immediate=0, .flags=0x00, .name = "WF2F5" },
  { .ov =  1, .code = 0x4a4f, .word = 0xf315, .immediate=0, .flags=0x80, .name = "(.CS)" },
  { .ov =  1, .code = 0x1d29, .word = 0xf327, .immediate=0, .flags=0x00, .name = "WF327" },
  { .ov =  1, .code = 0x224c, .word = 0xf32b, .immediate=0, .flags=0x00, .name = "WF32B" },
  { .ov =  1, .code = 0x224c, .word = 0xf372, .immediate=0, .flags=0x00, .name = "WF372" },
  { .ov =  1, .code = 0x224c, .word = 0xf3ad, .immediate=0, .flags=0x00, .name = "WF3AD" },
  { .ov =  1, .code = 0x224c, .word = 0xf40a, .immediate=0, .flags=0x00, .name = "WF40A" },
  { .ov =  1, .code = 0x224c, .word = 0xf450, .immediate=0, .flags=0x00, .name = "WF450" },
  { .ov =  1, .code = 0x224c, .word = 0xf480, .immediate=0, .flags=0x00, .name = "WF480" },
  { .ov =  1, .code = 0x224c, .word = 0xf4aa, .immediate=0, .flags=0x00, .name = "WF4AA" },
  { .ov =  1, .code = 0x224c, .word = 0xf501, .immediate=0, .flags=0x80, .name = "?CAN-LEAVE" },
  { .ov =  2, .code = 0x1d29, .word = 0xe356, .immediate=0, .flags=0x00, .name = "XYANCHOR" },
  { .ov =  2, .code = 0x1d29, .word = 0xe35a, .immediate=0, .flags=0x00, .name = "STD" },
  { .ov =  2, .code = 0x1d29, .word = 0xe35e, .immediate=0, .flags=0x00, .name = "RATIO" },
  { .ov =  2, .code = 0x2214, .word = 0xe364, .immediate=0, .flags=0x00, .name = "FNULL" },
  { .ov =  2, .code = 0x1d29, .word = 0xe368, .immediate=0, .flags=0x00, .name = "DY>1" },
  { .ov =  2, .code = 0x1d29, .word = 0xe36c, .immediate=0, .flags=0x00, .name = "DX>1" },
  { .ov =  2, .code = 0x1d29, .word = 0xe370, .immediate=0, .flags=0x00, .name = "X0'" },
  { .ov =  2, .code = 0x1d29, .word = 0xe374, .immediate=0, .flags=0x00, .name = "Y0'" },
  { .ov =  2, .code = 0x1d29, .word = 0xe378, .immediate=0, .flags=0x00, .name = "SCELL" },
  { .ov =  2, .code = 0x1d29, .word = 0xe37c, .immediate=0, .flags=0x00, .name = "OCELL" },
  { .ov =  2, .code = 0x3b68, .word = 0xe380, .immediate=0, .flags=0x00, .name = "MERCATOR-RATIO" },
  { .ov =  2, .code = 0x2214, .word = 0xe386, .immediate=0, .flags=0x00, .name = "MERCATOR-SCALE" },
  { .ov =  2, .code = 0x1d29, .word = 0xe38a, .immediate=0, .flags=0x00, .name = "RT0" },
  { .ov =  2, .code = 0x1d29, .word = 0xe38e, .immediate=0, .flags=0x00, .name = "RT1" },
  { .ov =  2, .code = 0x1d29, .word = 0xe392, .immediate=0, .flags=0x00, .name = "RTEMP" },
  { .ov =  2, .code = 0x1d29, .word = 0xe396, .immediate=0, .flags=0x00, .name = "TY" },
  { .ov =  2, .code = 0x224c, .word = 0xe39a, .immediate=0, .flags=0x00, .name = "SETSCALE" },
  { .ov =  2, .code = 0x224c, .word = 0xe3a6, .immediate=0, .flags=0x00, .name = "GENANCHORS" },
  { .ov =  2, .code = 0x1d29, .word = 0xe3c0, .immediate=0, .flags=0x00, .name = "[RRND]" },
  { .ov =  2, .code = 0x1d29, .word = 0xe3e0, .immediate=0, .flags=0x00, .name = "C+LIMIT" },
  { .ov =  2, .code = 0x1d29, .word = 0xe3fa, .immediate=0, .flags=0x00, .name = "DISPLACEMENT" },
  { .ov =  2, .code = 0x1d29, .word = 0xe469, .immediate=0, .flags=0x00, .name = "[SWRAP]" },
  { .ov =  2, .code = 0x1d29, .word = 0xe4b9, .immediate=0, .flags=0x00, .name = "[ACELLADDR]" },
  { .ov =  2, .code = 0x1d29, .word = 0xe4ef, .immediate=0, .flags=0x00, .name = "[A@]" },
  { .ov =  2, .code = 0x1d29, .word = 0xe50f, .immediate=0, .flags=0x00, .name = "[!HEIGHT]" },
  { .ov =  2, .code = 0xe537, .word = 0xe537, .immediate=0, .flags=0x00, .name = "!HEIGHT" },
  { .ov =  2, .code = 0x224c, .word = 0xe541, .immediate=0, .flags=0x00, .name = "SETANCHORS" },
  { .ov =  2, .code = 0x1d29, .word = 0xe56d, .immediate=0, .flags=0x00, .name = "XSHIFT" },
  { .ov =  2, .code = 0x1d29, .word = 0xe5b4, .immediate=0, .flags=0x00, .name = "YSHIFT" },
  { .ov =  2, .code = 0x1d29, .word = 0xe5fb, .immediate=0, .flags=0x00, .name = "EDGES" },
  { .ov =  2, .code = 0x1d29, .word = 0xe630, .immediate=0, .flags=0x00, .name = "CENTER" },
  { .ov =  2, .code = 0x1d29, .word = 0xe691, .immediate=0, .flags=0x00, .name = "MIDPT" },
  { .ov =  2, .code = 0x1d29, .word = 0xe6aa, .immediate=0, .flags=0x00, .name = "NEWSTD" },
  { .ov =  2, .code = 0x1d29, .word = 0xe6c2, .immediate=0, .flags=0x00, .name = "[FRACTAL]" },
  { .ov =  2, .code = 0xe75e, .word = 0xe75e, .immediate=0, .flags=0x00, .name = "FRACTALIZE" },
  { .ov =  2, .code = 0xe770, .word = 0xe770, .immediate=0, .flags=0x00, .name = "FILLARRAY" },
  { .ov =  2, .code = 0x224c, .word = 0xe78c, .immediate=0, .flags=0x00, .name = "FRACT-REGION" },
  { .ov =  2, .code = 0x224c, .word = 0xe7b9, .immediate=0, .flags=0x80, .name = "MERCATOR-GEN" },
  { .ov =  2, .code = 0x3b68, .word = 0xe7f7, .immediate=0, .flags=0x00, .name = "CONTOUR-RATIO" },
  { .ov =  2, .code = 0x2214, .word = 0xe7fd, .immediate=0, .flags=0x00, .name = "CONTOUR-SCALE" },
  { .ov =  2, .code = 0x224c, .word = 0xe801, .immediate=0, .flags=0x00, .name = "INIT-CONTOUR" },
  { .ov =  2, .code = 0x224c, .word = 0xe80f, .immediate=0, .flags=0x00, .name = "MERC>CONANCHOR" },
  { .ov =  2, .code = 0x224c, .word = 0xe86f, .immediate=0, .flags=0x00, .name = "AV-MIDPT" },
  { .ov =  2, .code = 0x224c, .word = 0xe8a1, .immediate=0, .flags=0x00, .name = "CONANCHOR-HOR" },
  { .ov =  2, .code = 0x224c, .word = 0xe8f7, .immediate=0, .flags=0x00, .name = "CONANCHOR-VER" },
  { .ov =  2, .code = 0x224c, .word = 0xe921, .immediate=0, .flags=0x00, .name = "CONANCHOR-CNT1" },
  { .ov =  2, .code = 0x224c, .word = 0xe94f, .immediate=0, .flags=0x00, .name = "CONANCHOR-CNT2" },
  { .ov =  2, .code = 0x224c, .word = 0xe979, .immediate=0, .flags=0x00, .name = "SETRELORIGIN" },
  { .ov =  2, .code = 0x224c, .word = 0xe985, .immediate=0, .flags=0x00, .name = "CONANCHOR>CONTOUR" },
  { .ov =  2, .code = 0x224c, .word = 0xea21, .immediate=0, .flags=0x00, .name = "ANCHOR_CONTOUR" },
  { .ov =  2, .code = 0x224c, .word = 0xea37, .immediate=0, .flags=0x00, .name = "SUB-CON-FRACT" },
  { .ov =  2, .code = 0x224c, .word = 0xea97, .immediate=0, .flags=0x00, .name = "FRACT_CONTOUR" },
  { .ov =  2, .code = 0x1d29, .word = 0xeacd, .immediate=0, .flags=0x00, .name = "FRAME" },
  { .ov =  2, .code = 0xead1, .word = 0xead1, .immediate=0, .flags=0x00, .name = "+FRAME" },
  { .ov =  2, .code = 0xeadc, .word = 0xeadc, .immediate=0, .flags=0x00, .name = "-FRAME" },
  { .ov =  2, .code = 0xeaea, .word = 0xeaea, .immediate=0, .flags=0x00, .name = "@FRAME" },
  { .ov =  2, .code = 0xeaf8, .word = 0xeaf8, .immediate=0, .flags=0x00, .name = "!FRAME" },
  { .ov =  2, .code = 0x224c, .word = 0xeb06, .immediate=0, .flags=0x00, .name = "@X1" },
  { .ov =  2, .code = 0x224c, .word = 0xeb0e, .immediate=0, .flags=0x00, .name = "@X2" },
  { .ov =  2, .code = 0x224c, .word = 0xeb16, .immediate=0, .flags=0x00, .name = "@XMID" },
  { .ov =  2, .code = 0x224c, .word = 0xeb20, .immediate=0, .flags=0x00, .name = "@Y1" },
  { .ov =  2, .code = 0x224c, .word = 0xeb28, .immediate=0, .flags=0x00, .name = "@Y2" },
  { .ov =  2, .code = 0x224c, .word = 0xeb30, .immediate=0, .flags=0x00, .name = "@YMID" },
  { .ov =  2, .code = 0x224c, .word = 0xeb38, .immediate=0, .flags=0x00, .name = "@STD" },
  { .ov =  2, .code = 0x224c, .word = 0xeb42, .immediate=0, .flags=0x00, .name = "!XMID" },
  { .ov =  2, .code = 0x224c, .word = 0xeb4c, .immediate=0, .flags=0x00, .name = "!YMID" },
  { .ov =  2, .code = 0x224c, .word = 0xeb54, .immediate=0, .flags=0x00, .name = "!STD" },
  { .ov =  2, .code = 0x224c, .word = 0xeb5e, .immediate=0, .flags=0x00, .name = "MIDPTT" },
  { .ov =  2, .code = 0x1d29, .word = 0xeb80, .immediate=0, .flags=0x80, .name = "POLYPTR" },
  { .ov =  2, .code = 0x1d29, .word = 0xeb84, .immediate=0, .flags=0x00, .name = "POLYCOUNTER" },
  { .ov =  2, .code = 0x1d29, .word = 0xeb88, .immediate=0, .flags=0x00, .name = "ULY" },
  { .ov =  2, .code = 0x1d29, .word = 0xeb8c, .immediate=0, .flags=0x00, .name = "ULX" },
  { .ov =  2, .code = 0x224c, .word = 0xeb90, .immediate=0, .flags=0x00, .name = "OUTPOLY" },
  { .ov =  2, .code = 0x224c, .word = 0xebfc, .immediate=0, .flags=0x00, .name = "?HOMOGENOUS" },
  { .ov =  2, .code = 0x224c, .word = 0xec70, .immediate=0, .flags=0x80, .name = "POLYGON-EXTRACT" },
  { .ov =  2, .code = 0x224c, .word = 0xecc6, .immediate=0, .flags=0x00, .name = "BUILD-CONTINENTS" },
  { .ov =  2, .code = 0x1d29, .word = 0xed30, .immediate=0, .flags=0x00, .name = "[TMP]" },
  { .ov =  2, .code = 0xed34, .word = 0xed34, .immediate=0, .flags=0x00, .name = "+TMP" },
  { .ov =  2, .code = 0xed44, .word = 0xed44, .immediate=0, .flags=0x00, .name = "-TMP" },
  { .ov =  2, .code = 0xed50, .word = 0xed50, .immediate=0, .flags=0x00, .name = "@TMP" },
  { .ov =  2, .code = 0xed62, .word = 0xed62, .immediate=0, .flags=0x00, .name = "!TMP" },
  { .ov =  2, .code = 0x1d29, .word = 0xed7d, .immediate=0, .flags=0x80, .name = "FADDR" },
  { .ov =  2, .code = 0x1d29, .word = 0xed81, .immediate=0, .flags=0x00, .name = "MAINCOLOR" },
  { .ov =  2, .code = 0x1d29, .word = 0xed85, .immediate=0, .flags=0x00, .name = "TAD" },
  { .ov =  2, .code = 0x1d29, .word = 0xed89, .immediate=0, .flags=0x00, .name = "#POL" },
  { .ov =  2, .code = 0x224c, .word = 0xed8d, .immediate=0, .flags=0x00, .name = "CACCUM" },
  { .ov =  2, .code = 0x224c, .word = 0xedd9, .immediate=0, .flags=0x00, .name = "MAJOR-COLOR" },
  { .ov =  2, .code = 0xee65, .word = 0xee65, .immediate=0, .flags=0x00, .name = "PUSH-POLY" },
  { .ov =  2, .code = 0xee96, .word = 0xee96, .immediate=0, .flags=0x00, .name = "POP-POLY" },
  { .ov =  2, .code = 0xeec2, .word = 0xeec2, .immediate=0, .flags=0x00, .name = "DROP-POLY" },
  { .ov =  2, .code = 0xeecc, .word = 0xeecc, .immediate=0, .flags=0x00, .name = "?MCLR" },
  { .ov =  2, .code = 0xeee5, .word = 0xeee5, .immediate=0, .flags=0x00, .name = "MAINPOLY" },
  { .ov =  2, .code = 0x224c, .word = 0xeefa, .immediate=0, .flags=0x00, .name = "REDUCE-FACE" },
  { .ov =  2, .code = 0x224c, .word = 0xef86, .immediate=0, .flags=0x00, .name = "REDUCE-ALL" },
  { .ov =  2, .code = 0x224c, .word = 0xefad, .immediate=0, .flags=0x80, .name = "MAKE-GLOBE" },
  { .ov =  2, .code = 0x224c, .word = 0xefb5, .immediate=0, .flags=0x00, .name = "UPSCRL" },
  { .ov =  2, .code = 0x224c, .word = 0xefd9, .immediate=0, .flags=0x00, .name = "DNSCRL" },
  { .ov =  2, .code = 0x224c, .word = 0xeffb, .immediate=0, .flags=0x00, .name = "RTSCRL" },
  { .ov =  2, .code = 0x224c, .word = 0xf023, .immediate=0, .flags=0x00, .name = "LFSCRL" },
  { .ov =  2, .code = 0x224c, .word = 0xf049, .immediate=0, .flags=0x00, .name = "SCRLXCON" },
  { .ov =  2, .code = 0x224c, .word = 0xf08b, .immediate=0, .flags=0x00, .name = "SCRLYCON" },
  { .ov =  2, .code = 0x224c, .word = 0xf0d7, .immediate=0, .flags=0x80, .name = "SCRLCON" },
  { .ov =  2, .code = 0x224c, .word = 0xf108, .immediate=0, .flags=0x80, .name = "NEWCONTOUR" },
  { .ov =  3, .code = 0x744d, .word = 0xf236, .immediate=0, .flags=0x00, .name = "WF236" },
  { .ov =  3, .code = 0x73ea, .word = 0xf23b, .immediate=0, .flags=0x00, .name = "WF23B" },
  { .ov =  3, .code = 0x744d, .word = 0xf243, .immediate=0, .flags=0x00, .name = "WF243" },
  { .ov =  3, .code = 0x73ea, .word = 0xf248, .immediate=0, .flags=0x00, .name = "WF248" },
  { .ov =  3, .code = 0x744d, .word = 0xf250, .immediate=0, .flags=0x00, .name = "WF250" },
  { .ov =  3, .code = 0x744d, .word = 0xf255, .immediate=0, .flags=0x00, .name = "WF255" },
  { .ov =  3, .code = 0x73ea, .word = 0xf25a, .immediate=0, .flags=0x00, .name = "WF25A" },
  { .ov =  3, .code = 0x744d, .word = 0xf262, .immediate=0, .flags=0x00, .name = "WF262" },
  { .ov =  3, .code = 0x2214, .word = 0xf267, .immediate=0, .flags=0x00, .name = "WF267" },
  { .ov =  3, .code = 0x2214, .word = 0xf26b, .immediate=0, .flags=0x00, .name = "WF26B" },
  { .ov =  3, .code = 0x2214, .word = 0xf26f, .immediate=0, .flags=0x00, .name = "WF26F" },
  { .ov =  3, .code = 0x2214, .word = 0xf273, .immediate=0, .flags=0x00, .name = "WF273" },
  { .ov =  3, .code = 0x2214, .word = 0xf277, .immediate=0, .flags=0x00, .name = "WF277" },
  { .ov =  3, .code = 0x2214, .word = 0xf27b, .immediate=0, .flags=0x00, .name = "WF27B" },
  { .ov =  3, .code = 0x2214, .word = 0xf27f, .immediate=0, .flags=0x00, .name = "WF27F" },
  { .ov =  3, .code = 0x2214, .word = 0xf283, .immediate=0, .flags=0x00, .name = "WF283" },
  { .ov =  3, .code = 0x2214, .word = 0xf287, .immediate=0, .flags=0x00, .name = "WF287" },
  { .ov =  3, .code = 0x2214, .word = 0xf28b, .immediate=0, .flags=0x00, .name = "WF28B" },
  { .ov =  3, .code = 0x2214, .word = 0xf28f, .immediate=0, .flags=0x00, .name = "WF28F" },
  { .ov =  3, .code = 0x224c, .word = 0xf293, .immediate=0, .flags=0x00, .name = "WF293" },
  { .ov =  3, .code = 0x224c, .word = 0xf2a1, .immediate=0, .flags=0x00, .name = "WF2A1" },
  { .ov =  3, .code = 0x4a4f, .word = 0xf2cf, .immediate=0, .flags=0x80, .name = "STAR-ID-CASES" },
  { .ov =  3, .code = 0x224c, .word = 0xf2d9, .immediate=0, .flags=0x00, .name = "WF2D9" },
  { .ov =  3, .code = 0x4a4f, .word = 0xf2f5, .immediate=0, .flags=0x80, .name = "PLANET-ID-CASES" },
  { .ov =  3, .code = 0x224c, .word = 0xf2ff, .immediate=0, .flags=0x00, .name = "WF2FF" },
  { .ov =  3, .code = 0x224c, .word = 0xf309, .immediate=0, .flags=0x00, .name = "WF309" },
  { .ov =  3, .code = 0x4a4f, .word = 0xf31e, .immediate=0, .flags=0x80, .name = "BOX-ID" },
  { .ov =  3, .code = 0x224c, .word = 0xf32c, .immediate=0, .flags=0x00, .name = "WF32C" },
  { .ov =  3, .code = 0x4a4f, .word = 0xf343, .immediate=0, .flags=0x80, .name = "SPACE-ID" },
  { .ov =  3, .code = 0x4a4f, .word = 0xf379, .immediate=0, .flags=0x80, .name = "RUIN-ID-CASES" },
  { .ov =  3, .code = 0x224c, .word = 0xf387, .immediate=0, .flags=0x00, .name = "WF387" },
  { .ov =  3, .code = 0x224c, .word = 0xf38f, .immediate=0, .flags=0x00, .name = "WF38F" },
  { .ov =  3, .code = 0x224c, .word = 0xf3ab, .immediate=0, .flags=0x00, .name = "WF3AB" },
  { .ov =  3, .code = 0x4a4f, .word = 0xf3cf, .immediate=0, .flags=0x80, .name = "PLANET-ID" },
  { .ov =  3, .code = 0x224c, .word = 0xf3f1, .immediate=0, .flags=0x00, .name = "WF3F1" },
  { .ov =  3, .code = 0x4a4f, .word = 0xf417, .immediate=0, .flags=0x80, .name = "STAR-IC-CASES" },
  { .ov =  3, .code = 0x224c, .word = 0xf435, .immediate=0, .flags=0x00, .name = "WF435" },
  { .ov =  3, .code = 0x224c, .word = 0xf43d, .immediate=0, .flags=0x00, .name = "WF43D" },
  { .ov =  3, .code = 0x4a4f, .word = 0xf461, .immediate=0, .flags=0x80, .name = "PLAN-IC-CASES" },
  { .ov =  3, .code = 0x224c, .word = 0xf47b, .immediate=0, .flags=0x00, .name = "WF47B" },
  { .ov =  3, .code = 0x224c, .word = 0xf485, .immediate=0, .flags=0x00, .name = "WF485" },
  { .ov =  3, .code = 0x4a4f, .word = 0xf4a0, .immediate=0, .flags=0x80, .name = "BOX-IC" },
  { .ov =  3, .code = 0x224c, .word = 0xf4ae, .immediate=0, .flags=0x00, .name = "WF4AE" },
  { .ov =  3, .code = 0x4a4f, .word = 0xf4c6, .immediate=0, .flags=0x80, .name = "#IC-CASES" },
  { .ov =  3, .code = 0x224c, .word = 0xf4e8, .immediate=0, .flags=0x00, .name = "WF4E8" },
  { .ov =  3, .code = 0x224c, .word = 0xf4fc, .immediate=0, .flags=0x80, .name = "ICON-PARM" },
  { .ov =  3, .code = 0x224c, .word = 0xf515, .immediate=0, .flags=0x80, .name = "+ICP" },
  { .ov =  3, .code = 0x224c, .word = 0xf528, .immediate=0, .flags=0x80, .name = "+ICONBOX" },
  { .ov =  4, .code = 0x1d29, .word = 0xee1d, .immediate=0, .flags=0x80, .name = "WLON" },
  { .ov =  4, .code = 0x1d29, .word = 0xee2a, .immediate=0, .flags=0x80, .name = "ELON" },
  { .ov =  4, .code = 0x1d29, .word = 0xee37, .immediate=0, .flags=0x80, .name = "NLAT" },
  { .ov =  4, .code = 0x1d29, .word = 0xee44, .immediate=0, .flags=0x80, .name = "SLAT" },
  { .ov =  4, .code = 0x1d29, .word = 0xee54, .immediate=0, .flags=0x80, .name = "LTLNBLT" },
  { .ov =  4, .code = 0x224c, .word = 0xee6e, .immediate=0, .flags=0x80, .name = ".LATFRAME" },
  { .ov =  4, .code = 0x224c, .word = 0xeed3, .immediate=0, .flags=0x00, .name = "WEED3" },
  { .ov =  4, .code = 0x1d29, .word = 0xef1d, .immediate=0, .flags=0x00, .name = "WEF1D" },
  { .ov =  4, .code = 0x224c, .word = 0xef28, .immediate=0, .flags=0x80, .name = ".LON" },
  { .ov =  4, .code = 0x1d29, .word = 0xef9c, .immediate=0, .flags=0x00, .name = "WEF9C" },
  { .ov =  4, .code = 0x224c, .word = 0xefa0, .immediate=0, .flags=0x00, .name = "WEFA0" },
  { .ov =  4, .code = 0x224c, .word = 0xf014, .immediate=0, .flags=0x00, .name = "WF014" },
  { .ov =  4, .code = 0xf050, .word = 0xf050, .immediate=0, .flags=0x80, .name = "(|REGION)" },
  { .ov =  4, .code = 0xf0c1, .word = 0xf0c1, .immediate=0, .flags=0x80, .name = "|EGA" },
  { .ov =  4, .code = 0x224c, .word = 0xf101, .immediate=0, .flags=0x80, .name = "|REGION" },
  { .ov =  4, .code = 0x224c, .word = 0xf119, .immediate=0, .flags=0x00, .name = "WF119" },
  { .ov =  4, .code = 0x224c, .word = 0xf121, .immediate=0, .flags=0x00, .name = "WF121" },
  { .ov =  4, .code = 0x224c, .word = 0xf12f, .immediate=0, .flags=0x00, .name = "WF12F" },
  { .ov =  4, .code = 0x224c, .word = 0xf159, .immediate=0, .flags=0x00, .name = "WF159" },
  { .ov =  4, .code = 0x224c, .word = 0xf181, .immediate=0, .flags=0x00, .name = "WF181" },
  { .ov =  4, .code = 0x224c, .word = 0xf1ce, .immediate=0, .flags=0x80, .name = ">XHAIR" },
  { .ov =  4, .code = 0x224c, .word = 0xf215, .immediate=0, .flags=0x80, .name = "<XHAIR" },
  { .ov =  4, .code = 0x224c, .word = 0xf239, .immediate=0, .flags=0x00, .name = "WF239" },
  { .ov =  4, .code = 0x1d29, .word = 0xf261, .immediate=0, .flags=0x00, .name = "WF261" },
  { .ov =  4, .code = 0x1d29, .word = 0xf28c, .immediate=0, .flags=0x00, .name = "WF28C" },
  { .ov =  4, .code = 0x224c, .word = 0xf290, .immediate=0, .flags=0x00, .name = "WF290" },
  { .ov =  4, .code = 0x224c, .word = 0xf311, .immediate=0, .flags=0x00, .name = "WF311" },
  { .ov =  4, .code = 0x224c, .word = 0xf389, .immediate=0, .flags=0x00, .name = "WF389" },
  { .ov =  4, .code = 0x224c, .word = 0xf405, .immediate=0, .flags=0x00, .name = "WF405" },
  { .ov =  4, .code = 0x224c, .word = 0xf423, .immediate=0, .flags=0x80, .name = "GETSITE_1" },
  { .ov =  4, .code = 0x224c, .word = 0xf4cf, .immediate=0, .flags=0x80, .name = ".MERCATOR" },
  { .ov =  4, .code = 0x224c, .word = 0xf537, .immediate=0, .flags=0x80, .name = "GETSITE_2" },
  { .ov =  5, .code = 0x224c, .word = 0xe566, .immediate=0, .flags=0x00, .name = "WE566" },
  { .ov =  5, .code = 0x224c, .word = 0xe570, .immediate=0, .flags=0x00, .name = "WE570" },
  { .ov =  5, .code = 0x2214, .word = 0xe578, .immediate=0, .flags=0x00, .name = "WE578" },
  { .ov =  5, .code = 0x2214, .word = 0xe57c, .immediate=0, .flags=0x00, .name = "WE57C" },
  { .ov =  5, .code = 0x2214, .word = 0xe580, .immediate=0, .flags=0x00, .name = "WE580" },
  { .ov =  5, .code = 0x2214, .word = 0xe584, .immediate=0, .flags=0x00, .name = "WE584" },
  { .ov =  5, .code = 0x2214, .word = 0xe588, .immediate=0, .flags=0x00, .name = "WE588" },
  { .ov =  5, .code = 0x224c, .word = 0xe58c, .immediate=0, .flags=0x00, .name = "WE58C" },
  { .ov =  5, .code = 0x744d, .word = 0xe59c, .immediate=0, .flags=0x00, .name = "WE59C" },
  { .ov =  5, .code = 0x73ea, .word = 0xe5a1, .immediate=0, .flags=0x00, .name = "WE5A1" },
  { .ov =  5, .code = 0x744d, .word = 0xe5a9, .immediate=0, .flags=0x00, .name = "WE5A9" },
  { .ov =  5, .code = 0x73ea, .word = 0xe5ae, .immediate=0, .flags=0x00, .name = "WE5AE" },
  { .ov =  5, .code = 0x73ea, .word = 0xe5b6, .immediate=0, .flags=0x00, .name = "WE5B6" },
  { .ov =  5, .code = 0x744d, .word = 0xe5be, .immediate=0, .flags=0x00, .name = "WE5BE" },
  { .ov =  5, .code = 0x744d, .word = 0xe5c3, .immediate=0, .flags=0x00, .name = "WE5C3" },
  { .ov =  5, .code = 0x744d, .word = 0xe5c8, .immediate=0, .flags=0x00, .name = "WE5C8" },
  { .ov =  5, .code = 0x744d, .word = 0xe5cd, .immediate=0, .flags=0x00, .name = "WE5CD" },
  { .ov =  5, .code = 0x744d, .word = 0xe5d2, .immediate=0, .flags=0x00, .name = "WE5D2" },
  { .ov =  5, .code = 0x744d, .word = 0xe5d7, .immediate=0, .flags=0x00, .name = "WE5D7" },
  { .ov =  5, .code = 0x744d, .word = 0xe5dc, .immediate=0, .flags=0x00, .name = "WE5DC" },
  { .ov =  5, .code = 0x744d, .word = 0xe5e1, .immediate=0, .flags=0x00, .name = "WE5E1" },
  { .ov =  5, .code = 0x4a4f, .word = 0xe5f0, .immediate=0, .flags=0x80, .name = "GET-VES" },
  { .ov =  5, .code = 0x224c, .word = 0xe602, .immediate=0, .flags=0x00, .name = "WE602" },
  { .ov =  5, .code = 0x224c, .word = 0xe616, .immediate=0, .flags=0x00, .name = "WE616" },
  { .ov =  5, .code = 0x224c, .word = 0xe692, .immediate=0, .flags=0x80, .name = "+A-VESS" },
  { .ov =  5, .code = 0x224c, .word = 0xe73a, .immediate=0, .flags=0x00, .name = "WE73A" },
  { .ov =  5, .code = 0x224c, .word = 0xe76d, .immediate=0, .flags=0x80, .name = "?PRL" },
  { .ov =  5, .code = 0x224c, .word = 0xe81b, .immediate=0, .flags=0x00, .name = "WE81B" },
  { .ov =  5, .code = 0x224c, .word = 0xe82d, .immediate=0, .flags=0x00, .name = "WE82D" },
  { .ov =  5, .code = 0x224c, .word = 0xe84b, .immediate=0, .flags=0x00, .name = "WE84B" },
  { .ov =  5, .code = 0x224c, .word = 0xe881, .immediate=0, .flags=0x00, .name = "WE881" },
  { .ov =  5, .code = 0x224c, .word = 0xe89d, .immediate=0, .flags=0x00, .name = "WE89D" },
  { .ov =  5, .code = 0x744d, .word = 0xe8b1, .immediate=0, .flags=0x00, .name = "WE8B1" },
  { .ov =  5, .code = 0x224c, .word = 0xe8b6, .immediate=0, .flags=0x00, .name = "WE8B6" },
  { .ov =  5, .code = 0x224c, .word = 0xe8ee, .immediate=0, .flags=0x00, .name = "WE8EE" },
  { .ov =  5, .code = 0x4a4f, .word = 0xe917, .immediate=0, .flags=0x80, .name = "DISP-SETUP" },
  { .ov =  5, .code = 0x1d29, .word = 0xe931, .immediate=0, .flags=0x00, .name = "WE931" },
  { .ov =  5, .code = 0x224c, .word = 0xe935, .immediate=0, .flags=0x00, .name = "WE935" },
  { .ov =  5, .code = 0x224c, .word = 0xe951, .immediate=0, .flags=0x00, .name = "WE951" },
  { .ov =  5, .code = 0x224c, .word = 0xe970, .immediate=0, .flags=0x80, .name = "DO-FLARE" },
  { .ov =  5, .code = 0x224c, .word = 0xea50, .immediate=0, .flags=0x00, .name = "WEA50" },
  { .ov =  5, .code = 0x224c, .word = 0xea73, .immediate=0, .flags=0x00, .name = "WEA73" },
  { .ov =  5, .code = 0x224c, .word = 0xea7f, .immediate=0, .flags=0x00, .name = "WEA7F" },
  { .ov =  5, .code = 0x224c, .word = 0xea8c, .immediate=0, .flags=0x00, .name = "WEA8C" },
  { .ov =  5, .code = 0x224c, .word = 0xea9b, .immediate=0, .flags=0x00, .name = "WEA9B" },
  { .ov =  5, .code = 0x224c, .word = 0xeaab, .immediate=0, .flags=0x00, .name = "WEAAB" },
  { .ov =  5, .code = 0x224c, .word = 0xeac3, .immediate=0, .flags=0x00, .name = "WEAC3" },
  { .ov =  5, .code = 0x224c, .word = 0xeada, .immediate=0, .flags=0x00, .name = "WEADA" },
  { .ov =  5, .code = 0x224c, .word = 0xeb08, .immediate=0, .flags=0x00, .name = "WEB08" },
  { .ov =  5, .code = 0x224c, .word = 0xeb26, .immediate=0, .flags=0x00, .name = "WEB26" },
  { .ov =  5, .code = 0x224c, .word = 0xeb36, .immediate=0, .flags=0x00, .name = "WEB36" },
  { .ov =  5, .code = 0x224c, .word = 0xeb59, .immediate=0, .flags=0x00, .name = "WEB59" },
  { .ov =  5, .code = 0x224c, .word = 0xeb76, .immediate=0, .flags=0x00, .name = "WEB76" },
  { .ov =  5, .code = 0x224c, .word = 0xeb8f, .immediate=0, .flags=0x00, .name = "WEB8F" },
  { .ov =  5, .code = 0x4a4f, .word = 0xebaa, .immediate=0, .flags=0x80, .name = "NF-M" },
  { .ov =  5, .code = 0x224c, .word = 0xebce, .immediate=0, .flags=0x80, .name = "NF-MESS" },
  { .ov =  5, .code = 0x224c, .word = 0xebd6, .immediate=0, .flags=0x00, .name = "WEBD6" },
  { .ov =  5, .code = 0x224c, .word = 0xec04, .immediate=0, .flags=0x00, .name = "WEC04" },
  { .ov =  5, .code = 0x224c, .word = 0xec2d, .immediate=0, .flags=0x00, .name = "WEC2D" },
  { .ov =  5, .code = 0x224c, .word = 0xec57, .immediate=0, .flags=0x00, .name = "WEC57" },
  { .ov =  5, .code = 0x224c, .word = 0xec7f, .immediate=0, .flags=0x00, .name = "WEC7F" },
  { .ov =  5, .code = 0x4a4f, .word = 0xeccd, .immediate=0, .flags=0x80, .name = "NS-M" },
  { .ov =  5, .code = 0x224c, .word = 0xecf1, .immediate=0, .flags=0x80, .name = "NS-MESS" },
  { .ov =  5, .code = 0x744d, .word = 0xecf9, .immediate=0, .flags=0x00, .name = "WECF9" },
  { .ov =  5, .code = 0x744d, .word = 0xecfe, .immediate=0, .flags=0x00, .name = "WECFE" },
  { .ov =  5, .code = 0x1d29, .word = 0xed03, .immediate=0, .flags=0x00, .name = "WED03" },
  { .ov =  5, .code = 0x1d29, .word = 0xed07, .immediate=0, .flags=0x00, .name = "WED07" },
  { .ov =  5, .code = 0x224c, .word = 0xed0b, .immediate=0, .flags=0x00, .name = "WED0B" },
  { .ov =  5, .code = 0x224c, .word = 0xed4b, .immediate=0, .flags=0x00, .name = "WED4B" },
  { .ov =  5, .code = 0x224c, .word = 0xed94, .immediate=0, .flags=0x00, .name = "WED94" },
  { .ov =  5, .code = 0x224c, .word = 0xedd2, .immediate=0, .flags=0x00, .name = "WEDD2" },
  { .ov =  5, .code = 0x224c, .word = 0xede6, .immediate=0, .flags=0x00, .name = "WEDE6" },
  { .ov =  5, .code = 0x224c, .word = 0xee0b, .immediate=0, .flags=0x00, .name = "WEE0B" },
  { .ov =  5, .code = 0x224c, .word = 0xee25, .immediate=0, .flags=0x00, .name = "WEE25" },
  { .ov =  5, .code = 0x224c, .word = 0xee3b, .immediate=0, .flags=0x00, .name = "WEE3B" },
  { .ov =  5, .code = 0x4a4f, .word = 0xeea3, .immediate=0, .flags=0x80, .name = "HCASE" },
  { .ov =  5, .code = 0x224c, .word = 0xeec0, .immediate=0, .flags=0x80, .name = "HEAT" },
  { .ov =  5, .code = 0x73ea, .word = 0xeed2, .immediate=0, .flags=0x00, .name = "P-TSEED" },
  { .ov =  5, .code = 0x73ea, .word = 0xeee4, .immediate=0, .flags=0x80, .name = "P-LSEED" },
  { .ov =  5, .code = 0x73ea, .word = 0xeeec, .immediate=0, .flags=0x00, .name = "P-SURF" },
  { .ov =  5, .code = 0x744d, .word = 0xeef4, .immediate=0, .flags=0x00, .name = "WEEF4" },
  { .ov =  5, .code = 0x744d, .word = 0xeef9, .immediate=0, .flags=0x00, .name = "WEEF9" },
  { .ov =  5, .code = 0x224c, .word = 0xeefe, .immediate=0, .flags=0x00, .name = "WEEFE" },
  { .ov =  5, .code = 0x4a4f, .word = 0xef19, .immediate=0, .flags=0x80, .name = "S>CM" },
  { .ov =  5, .code = 0x224c, .word = 0xef2b, .immediate=0, .flags=0x00, .name = "WEF2B" },
  { .ov =  5, .code = 0x224c, .word = 0xef3c, .immediate=0, .flags=0x80, .name = "OSET" },
  { .ov =  5, .code = 0x224c, .word = 0xefe3, .immediate=0, .flags=0x00, .name = "WEFE3" },
  { .ov =  5, .code = 0x224c, .word = 0xefeb, .immediate=0, .flags=0x00, .name = "WEFEB" },
  { .ov =  5, .code = 0x224c, .word = 0xf001, .immediate=0, .flags=0x00, .name = "WF001" },
  { .ov =  5, .code = 0x224c, .word = 0xf022, .immediate=0, .flags=0x00, .name = "WF022" },
  { .ov =  5, .code = 0x224c, .word = 0xf078, .immediate=0, .flags=0x00, .name = "WF078" },
  { .ov =  5, .code = 0x4a4f, .word = 0xf0a9, .immediate=0, .flags=0x80, .name = "UF-M" },
  { .ov =  5, .code = 0x224c, .word = 0xf0cd, .immediate=0, .flags=0x80, .name = "UF-MESS" },
  { .ov =  5, .code = 0x224c, .word = 0xf0d5, .immediate=0, .flags=0x00, .name = "WF0D5" },
  { .ov =  5, .code = 0x224c, .word = 0xf0ee, .immediate=0, .flags=0x00, .name = "WF0EE" },
  { .ov =  5, .code = 0x224c, .word = 0xf0f6, .immediate=0, .flags=0x00, .name = "WF0F6" },
  { .ov =  5, .code = 0x224c, .word = 0xf0fe, .immediate=0, .flags=0x00, .name = "WF0FE" },
  { .ov =  5, .code = 0x224c, .word = 0xf106, .immediate=0, .flags=0x00, .name = "WF106" },
  { .ov =  5, .code = 0x4a4f, .word = 0xf115, .immediate=0, .flags=0x80, .name = "US-M" },
  { .ov =  5, .code = 0x224c, .word = 0xf135, .immediate=0, .flags=0x80, .name = "US-MESS" },
  { .ov =  5, .code = 0x224c, .word = 0xf13d, .immediate=0, .flags=0x00, .name = "WF13D" },
  { .ov =  5, .code = 0x224c, .word = 0xf149, .immediate=0, .flags=0x00, .name = "WF149" },
  { .ov =  5, .code = 0x224c, .word = 0xf163, .immediate=0, .flags=0x00, .name = "WF163" },
  { .ov =  5, .code = 0x224c, .word = 0xf182, .immediate=0, .flags=0x00, .name = "WF182" },
  { .ov =  5, .code = 0x4a4f, .word = 0xf19e, .immediate=0, .flags=0x80, .name = ".EX" },
  { .ov =  5, .code = 0x744d, .word = 0xf1ac, .immediate=0, .flags=0x00, .name = "WF1AC" },
  { .ov =  5, .code = 0x1d29, .word = 0xf1b1, .immediate=0, .flags=0x00, .name = "WF1B1" },
  { .ov =  5, .code = 0x224c, .word = 0xf1bc, .immediate=0, .flags=0x80, .name = "DMSG" },
  { .ov =  5, .code = 0x224c, .word = 0xf224, .immediate=0, .flags=0x00, .name = "WF224" },
  { .ov =  5, .code = 0x224c, .word = 0xf22c, .immediate=0, .flags=0x00, .name = "WF22C" },
  { .ov =  5, .code = 0x224c, .word = 0xf240, .immediate=0, .flags=0x00, .name = "WF240" },
  { .ov =  5, .code = 0x224c, .word = 0xf248, .immediate=0, .flags=0x00, .name = "WF248" },
  { .ov =  5, .code = 0x224c, .word = 0xf250, .immediate=0, .flags=0x00, .name = "WF250" },
  { .ov =  5, .code = 0x4a4f, .word = 0xf261, .immediate=0, .flags=0x80, .name = "(CTXT)" },
  { .ov =  5, .code = 0x1d29, .word = 0xf27b, .immediate=0, .flags=0x00, .name = "WF27B" },
  { .ov =  5, .code = 0x1d29, .word = 0xf27f, .immediate=0, .flags=0x00, .name = "WF27F" },
  { .ov =  5, .code = 0x1d29, .word = 0xf283, .immediate=0, .flags=0x00, .name = "WF283" },
  { .ov =  5, .code = 0x1d29, .word = 0xf287, .immediate=0, .flags=0x00, .name = "WF287" },
  { .ov =  5, .code = 0x224c, .word = 0xf28b, .immediate=0, .flags=0x00, .name = "WF28B" },
  { .ov =  5, .code = 0x744d, .word = 0xf30c, .immediate=0, .flags=0x00, .name = "WF30C" },
  { .ov =  5, .code = 0x744d, .word = 0xf311, .immediate=0, .flags=0x00, .name = "WF311" },
  { .ov =  5, .code = 0x744d, .word = 0xf316, .immediate=0, .flags=0x00, .name = "WF316" },
  { .ov =  5, .code = 0x224c, .word = 0xf31b, .immediate=0, .flags=0x00, .name = "WF31B" },
  { .ov =  5, .code = 0x224c, .word = 0xf333, .immediate=0, .flags=0x00, .name = "WF333" },
  { .ov =  5, .code = 0x224c, .word = 0xf3ab, .immediate=0, .flags=0x00, .name = "WF3AB" },
  { .ov =  5, .code = 0x224c, .word = 0xf3f5, .immediate=0, .flags=0x00, .name = "WF3F5" },
  { .ov =  5, .code = 0x224c, .word = 0xf425, .immediate=0, .flags=0x00, .name = "WF425" },
  { .ov =  5, .code = 0x1d29, .word = 0xf43d, .immediate=0, .flags=0x00, .name = "WF43D" },
  { .ov =  5, .code = 0x224c, .word = 0xf44a, .immediate=0, .flags=0x80, .name = "TRAK-E" },
  { .ov =  5, .code = 0x224c, .word = 0xf4de, .immediate=0, .flags=0x00, .name = "WF4DE" },
  { .ov =  5, .code = 0x224c, .word = 0xf4e6, .immediate=0, .flags=0x00, .name = "WF4E6" },
  { .ov =  5, .code = 0x2214, .word = 0xf4ee, .immediate=0, .flags=0x00, .name = "WF4EE" },
  { .ov =  5, .code = 0x4a4f, .word = 0xf4fa, .immediate=0, .flags=0x80, .name = "@'EXT" },
  { .ov =  5, .code = 0x224c, .word = 0xf516, .immediate=0, .flags=0x80, .name = "(!'EXT)" },
  { .ov =  6, .code = 0xf220, .word = 0xf220, .immediate=0, .flags=0x80, .name = ".RUNBIT" },
  { .ov =  6, .code = 0x224c, .word = 0xf2f8, .immediate=0, .flags=0x80, .name = ".PARMS" },
  { .ov =  6, .code = 0x1d29, .word = 0xf35c, .immediate=0, .flags=0x80, .name = "BRIGHT" },
  { .ov =  6, .code = 0x1d29, .word = 0xf368, .immediate=0, .flags=0x80, .name = "2TEMP" },
  { .ov =  6, .code = 0xf379, .word = 0xf379, .immediate=0, .flags=0x80, .name = ".EGARUNBIT" },
  { .ov =  6, .code = 0x224c, .word = 0xf466, .immediate=0, .flags=0x80, .name = ".HYBRID" },
  { .ov =  6, .code = 0x224c, .word = 0xf505, .immediate=0, .flags=0x80, .name = "PADSEG" },
  { .ov =  6, .code = 0x224c, .word = 0xf51a, .immediate=0, .flags=0x80, .name = "@.HYBRID" },
  { .ov =  6, .code = 0x224c, .word = 0xf530, .immediate=0, .flags=0x80, .name = "SETUP" },
  { .ov =  7, .code = 0x744d, .word = 0xefd6, .immediate=0, .flags=0x00, .name = "WEFD6" },
  { .ov =  7, .code = 0x744d, .word = 0xefdb, .immediate=0, .flags=0x00, .name = "WEFDB" },
  { .ov =  7, .code = 0x744d, .word = 0xefe0, .immediate=0, .flags=0x00, .name = "WEFE0" },
  { .ov =  7, .code = 0x1d29, .word = 0xefe5, .immediate=0, .flags=0x00, .name = "WEFE5" },
  { .ov =  7, .code = 0x224c, .word = 0xf003, .immediate=0, .flags=0x80, .name = "(TRIM" },
  { .ov =  7, .code = 0x224c, .word = 0xf035, .immediate=0, .flags=0x00, .name = "WF035" },
  { .ov =  7, .code = 0x224c, .word = 0xf06d, .immediate=0, .flags=0x00, .name = "WF06D" },
  { .ov =  7, .code = 0x224c, .word = 0xf08f, .immediate=0, .flags=0x00, .name = "WF08F" },
  { .ov =  7, .code = 0x224c, .word = 0xf0b9, .immediate=0, .flags=0x00, .name = "WF0B9" },
  { .ov =  7, .code = 0x224c, .word = 0xf0e9, .immediate=0, .flags=0x80, .name = "(#IN$" },
  { .ov =  7, .code = 0x224c, .word = 0xf1ad, .immediate=0, .flags=0x80, .name = "(?ART" },
  { .ov =  7, .code = 0x224c, .word = 0xf1e5, .immediate=0, .flags=0x80, .name = "(QUIT" },
  { .ov =  7, .code = 0x224c, .word = 0xf210, .immediate=0, .flags=0x80, .name = "(.0$$" },
  { .ov =  7, .code = 0x224c, .word = 0xf233, .immediate=0, .flags=0x80, .name = "(0$$$" },
  { .ov =  7, .code = 0x224c, .word = 0xf26b, .immediate=0, .flags=0x00, .name = "WF26B" },
  { .ov =  7, .code = 0x224c, .word = 0xf279, .immediate=0, .flags=0x00, .name = "WF279" },
  { .ov =  7, .code = 0x224c, .word = 0xf296, .immediate=0, .flags=0x00, .name = "WF296" },
  { .ov =  7, .code = 0x224c, .word = 0xf2a3, .immediate=0, .flags=0x00, .name = "WF2A3" },
  { .ov =  7, .code = 0x224c, .word = 0xf2b2, .immediate=0, .flags=0x00, .name = "WF2B2" },
  { .ov =  7, .code = 0x224c, .word = 0xf2c0, .immediate=0, .flags=0x00, .name = "WF2C0" },
  { .ov =  7, .code = 0x4a4f, .word = 0xf2d5, .immediate=0, .flags=0x80, .name = ".ERR" },
  { .ov =  7, .code = 0x4a4f, .word = 0xf2fb, .immediate=0, .flags=0x80, .name = "EINDE" },
  { .ov =  7, .code = 0x224c, .word = 0xf319, .immediate=0, .flags=0x00, .name = "WF319" },
  { .ov =  7, .code = 0x224c, .word = 0xf383, .immediate=0, .flags=0x00, .name = "WF383" },
  { .ov =  7, .code = 0x224c, .word = 0xf39f, .immediate=0, .flags=0x00, .name = "WF39F" },
  { .ov =  7, .code = 0x224c, .word = 0xf3dd, .immediate=0, .flags=0x80, .name = "(?.EQ" },
  { .ov =  7, .code = 0x224c, .word = 0xf458, .immediate=0, .flags=0x00, .name = "WF458" },
  { .ov =  7, .code = 0x224c, .word = 0xf482, .immediate=0, .flags=0x80, .name = "=CARG" },
  { .ov =  8, .code = 0x224c, .word = 0xef86, .immediate=0, .flags=0x00, .name = "TRIM" },
  { .ov =  8, .code = 0x2214, .word = 0xef90, .immediate=0, .flags=0x00, .name = "3RIGHT" },
  { .ov =  8, .code = 0x2214, .word = 0xef94, .immediate=0, .flags=0x00, .name = "3LEFT" },
  { .ov =  8, .code = 0x2214, .word = 0xef98, .immediate=0, .flags=0x00, .name = "3PLUS" },
  { .ov =  8, .code = 0x2214, .word = 0xef9c, .immediate=0, .flags=0x00, .name = "2RIGHT" },
  { .ov =  8, .code = 0x2214, .word = 0xefa0, .immediate=0, .flags=0x00, .name = "2LEFT" },
  { .ov =  8, .code = 0x744d, .word = 0xefa4, .immediate=0, .flags=0x00, .name = "MASTERBALANCE" },
  { .ov =  8, .code = 0x744d, .word = 0xefa9, .immediate=0, .flags=0x00, .name = "BALANCE" },
  { .ov =  8, .code = 0x744d, .word = 0xefae, .immediate=0, .flags=0x00, .name = "TFLAG" },
  { .ov =  8, .code = 0x73ea, .word = 0xefb3, .immediate=0, .flags=0x00, .name = "TRANSTEXT" },
  { .ov =  8, .code = 0x744d, .word = 0xefbb, .immediate=0, .flags=0x00, .name = "T-AMT" },
  { .ov =  8, .code = 0x744d, .word = 0xefc0, .immediate=0, .flags=0x00, .name = "T-DATE" },
  { .ov =  8, .code = 0x224c, .word = 0xefc5, .immediate=0, .flags=0x00, .name = "SET-BANK" },
  { .ov =  8, .code = 0x224c, .word = 0xefd6, .immediate=0, .flags=0x80, .name = "!TFLAG" },
  { .ov =  8, .code = 0x224c, .word = 0xeff0, .immediate=0, .flags=0x80, .name = "D@BALANCE" },
  { .ov =  8, .code = 0x224c, .word = 0xf008, .immediate=0, .flags=0x80, .name = "D!BALANCE" },
  { .ov =  8, .code = 0x224c, .word = 0xf01f, .immediate=0, .flags=0x80, .name = "?BALANCE" },
  { .ov =  8, .code = 0x224c, .word = 0xf038, .immediate=0, .flags=0x80, .name = "INIT-BALANCE" },
  { .ov =  8, .code = 0x224c, .word = 0xf053, .immediate=0, .flags=0x80, .name = "TRANSACT" },
  { .ov =  8, .code = 0x224c, .word = 0xf0ce, .immediate=0, .flags=0x80, .name = "INT%" },
  { .ov =  8, .code = 0x1d29, .word = 0xf112, .immediate=0, .flags=0x00, .name = "DOTS" },
  { .ov =  8, .code = 0x224c, .word = 0xf128, .immediate=0, .flags=0x00, .name = ".DOTS" },
  { .ov =  8, .code = 0x224c, .word = 0xf152, .immediate=0, .flags=0x00, .name = ".BDATE" },
  { .ov =  8, .code = 0x224c, .word = 0xf196, .immediate=0, .flags=0x00, .name = ".$AMT" },
  { .ov =  8, .code = 0x224c, .word = 0xf1da, .immediate=0, .flags=0x00, .name = "?.MESS" },
  { .ov =  8, .code = 0x224c, .word = 0xf1e2, .immediate=0, .flags=0x00, .name = "BTITLE" },
  { .ov =  8, .code = 0x224c, .word = 0xf26f, .immediate=0, .flags=0x00, .name = "BOFRAME" },
  { .ov =  8, .code = 0x224c, .word = 0xf3ab, .immediate=0, .flags=0x00, .name = "BINFO" },
  { .ov =  8, .code = 0x224c, .word = 0xf464, .immediate=0, .flags=0x00, .name = "BSCREEN" },
  { .ov =  8, .code = 0x224c, .word = 0xf472, .immediate=0, .flags=0x00, .name = "BMESS" },
  { .ov =  8, .code = 0x224c, .word = 0xf4ac, .immediate=0, .flags=0x00, .name = ".BALANCE" },
  { .ov =  8, .code = 0x224c, .word = 0xf4c4, .immediate=0, .flags=0x00, .name = ".BANK" },
  { .ov =  8, .code = 0x224c, .word = 0xf4ef, .immediate=0, .flags=0x80, .name = "(U-BANK)" },
  { .ov =  9, .code = 0x224c, .word = 0xea86, .immediate=0, .flags=0x00, .name = "WEA86" },
  { .ov =  9, .code = 0x2214, .word = 0xea90, .immediate=0, .flags=0x00, .name = "WEA90" },
  { .ov =  9, .code = 0x2214, .word = 0xea94, .immediate=0, .flags=0x00, .name = "WEA94" },
  { .ov =  9, .code = 0x1d29, .word = 0xea98, .immediate=0, .flags=0x00, .name = "WEA98" },
  { .ov =  9, .code = 0x224c, .word = 0xea9c, .immediate=0, .flags=0x00, .name = "WEA9C" },
  { .ov =  9, .code = 0x1d29, .word = 0xeabe, .immediate=0, .flags=0x00, .name = "WEABE" },
  { .ov =  9, .code = 0x224c, .word = 0xeac4, .immediate=0, .flags=0x00, .name = "WEAC4" },
  { .ov =  9, .code = 0x224c, .word = 0xeae0, .immediate=0, .flags=0x00, .name = "WEAE0" },
  { .ov =  9, .code = 0x224c, .word = 0xeb09, .immediate=0, .flags=0x00, .name = "WEB09" },
  { .ov =  9, .code = 0x73ea, .word = 0xeb23, .immediate=0, .flags=0x00, .name = "WEB23" },
  { .ov =  9, .code = 0x73ea, .word = 0xeb2b, .immediate=0, .flags=0x00, .name = "WEB2B" },
  { .ov =  9, .code = 0x73ea, .word = 0xeb33, .immediate=0, .flags=0x00, .name = "WEB33" },
  { .ov =  9, .code = 0x744d, .word = 0xeb3b, .immediate=0, .flags=0x00, .name = "WEB3B" },
  { .ov =  9, .code = 0x744d, .word = 0xeb40, .immediate=0, .flags=0x00, .name = "WEB40" },
  { .ov =  9, .code = 0x744d, .word = 0xeb45, .immediate=0, .flags=0x00, .name = "WEB45" },
  { .ov =  9, .code = 0x744d, .word = 0xeb4a, .immediate=0, .flags=0x00, .name = "WEB4A" },
  { .ov =  9, .code = 0x744d, .word = 0xeb4f, .immediate=0, .flags=0x00, .name = "WEB4F" },
  { .ov =  9, .code = 0x744d, .word = 0xeb54, .immediate=0, .flags=0x00, .name = "WEB54" },
  { .ov =  9, .code = 0x744d, .word = 0xeb59, .immediate=0, .flags=0x00, .name = "WEB59" },
  { .ov =  9, .code = 0x744d, .word = 0xeb5e, .immediate=0, .flags=0x00, .name = "WEB5E" },
  { .ov =  9, .code = 0x744d, .word = 0xeb63, .immediate=0, .flags=0x00, .name = "WEB63" },
  { .ov =  9, .code = 0x744d, .word = 0xeb68, .immediate=0, .flags=0x00, .name = "WEB68" },
  { .ov =  9, .code = 0x224c, .word = 0xeb6d, .immediate=0, .flags=0x00, .name = "WEB6D" },
  { .ov =  9, .code = 0x224c, .word = 0xeb81, .immediate=0, .flags=0x00, .name = "WEB81" },
  { .ov =  9, .code = 0x1d29, .word = 0xec7a, .immediate=0, .flags=0x00, .name = "WEC7A" },
  { .ov =  9, .code = 0x224c, .word = 0xec7e, .immediate=0, .flags=0x00, .name = "WEC7E" },
  { .ov =  9, .code = 0x224c, .word = 0xec86, .immediate=0, .flags=0x00, .name = "WEC86" },
  { .ov =  9, .code = 0x224c, .word = 0xed9a, .immediate=0, .flags=0x00, .name = "WED9A" },
  { .ov =  9, .code = 0x224c, .word = 0xedc4, .immediate=0, .flags=0x00, .name = "WEDC4" },
  { .ov =  9, .code = 0x224c, .word = 0xedf8, .immediate=0, .flags=0x00, .name = "WEDF8" },
  { .ov =  9, .code = 0x224c, .word = 0xef47, .immediate=0, .flags=0x00, .name = "WEF47" },
  { .ov =  9, .code = 0x224c, .word = 0xf019, .immediate=0, .flags=0x00, .name = "WF019" },
  { .ov =  9, .code = 0x224c, .word = 0xf128, .immediate=0, .flags=0x00, .name = "WF128" },
  { .ov =  9, .code = 0x224c, .word = 0xf15e, .immediate=0, .flags=0x00, .name = "WF15E" },
  { .ov =  9, .code = 0x224c, .word = 0xf192, .immediate=0, .flags=0x00, .name = "WF192" },
  { .ov =  9, .code = 0x224c, .word = 0xf1ce, .immediate=0, .flags=0x00, .name = "WF1CE" },
  { .ov =  9, .code = 0x224c, .word = 0xf1ec, .immediate=0, .flags=0x00, .name = "WF1EC" },
  { .ov =  9, .code = 0x224c, .word = 0xf238, .immediate=0, .flags=0x00, .name = "WF238" },
  { .ov =  9, .code = 0x224c, .word = 0xf2a3, .immediate=0, .flags=0x00, .name = "WF2A3" },
  { .ov =  9, .code = 0x224c, .word = 0xf2b1, .immediate=0, .flags=0x00, .name = "WF2B1" },
  { .ov =  9, .code = 0x224c, .word = 0xf32e, .immediate=0, .flags=0x00, .name = "WF32E" },
  { .ov =  9, .code = 0x224c, .word = 0xf395, .immediate=0, .flags=0x00, .name = "WF395" },
  { .ov =  9, .code = 0x224c, .word = 0xf3d7, .immediate=0, .flags=0x00, .name = "WF3D7" },
  { .ov =  9, .code = 0x224c, .word = 0xf409, .immediate=0, .flags=0x00, .name = "WF409" },
  { .ov =  9, .code = 0x224c, .word = 0xf45f, .immediate=0, .flags=0x80, .name = "(U-ASSCREW)" },
  { .ov = 10, .code = 0x224c, .word = 0xe516, .immediate=0, .flags=0x00, .name = "WE516" },
  { .ov = 10, .code = 0x224c, .word = 0xe520, .immediate=0, .flags=0x00, .name = "WE520" },
  { .ov = 10, .code = 0x224c, .word = 0xe52a, .immediate=0, .flags=0x00, .name = "WE52A" },
  { .ov = 10, .code = 0x224c, .word = 0xe534, .immediate=0, .flags=0x00, .name = "WE534" },
  { .ov = 10, .code = 0x224c, .word = 0xe53e, .immediate=0, .flags=0x00, .name = "WE53E" },
  { .ov = 10, .code = 0x2214, .word = 0xe548, .immediate=0, .flags=0x00, .name = "WE548" },
  { .ov = 10, .code = 0x2214, .word = 0xe54c, .immediate=0, .flags=0x00, .name = "WE54C" },
  { .ov = 10, .code = 0x224c, .word = 0xe550, .immediate=0, .flags=0x00, .name = "WE550" },
  { .ov = 10, .code = 0x224c, .word = 0xe55c, .immediate=0, .flags=0x00, .name = "WE55C" },
  { .ov = 10, .code = 0x224c, .word = 0xe566, .immediate=0, .flags=0x00, .name = "WE566" },
  { .ov = 10, .code = 0x224c, .word = 0xe570, .immediate=0, .flags=0x00, .name = "WE570" },
  { .ov = 10, .code = 0x224c, .word = 0xe57a, .immediate=0, .flags=0x00, .name = "WE57A" },
  { .ov = 10, .code = 0x224c, .word = 0xe584, .immediate=0, .flags=0x00, .name = "WE584" },
  { .ov = 10, .code = 0x224c, .word = 0xe590, .immediate=0, .flags=0x00, .name = "WE590" },
  { .ov = 10, .code = 0x224c, .word = 0xe5a6, .immediate=0, .flags=0x00, .name = "WE5A6" },
  { .ov = 10, .code = 0x1d29, .word = 0xe5b0, .immediate=0, .flags=0x00, .name = "WE5B0" },
  { .ov = 10, .code = 0x224c, .word = 0xe5b6, .immediate=0, .flags=0x00, .name = "WE5B6" },
  { .ov = 10, .code = 0x224c, .word = 0xe5d2, .immediate=0, .flags=0x00, .name = "WE5D2" },
  { .ov = 10, .code = 0x224c, .word = 0xe5e2, .immediate=0, .flags=0x00, .name = "WE5E2" },
  { .ov = 10, .code = 0x224c, .word = 0xe5fb, .immediate=0, .flags=0x00, .name = "WE5FB" },
  { .ov = 10, .code = 0x224c, .word = 0xe617, .immediate=0, .flags=0x00, .name = "WE617" },
  { .ov = 10, .code = 0x224c, .word = 0xe63e, .immediate=0, .flags=0x00, .name = "WE63E" },
  { .ov = 10, .code = 0x73ea, .word = 0xe658, .immediate=0, .flags=0x00, .name = "WE658" },
  { .ov = 10, .code = 0x73ea, .word = 0xe660, .immediate=0, .flags=0x00, .name = "WE660" },
  { .ov = 10, .code = 0x73ea, .word = 0xe668, .immediate=0, .flags=0x00, .name = "WE668" },
  { .ov = 10, .code = 0x73ea, .word = 0xe670, .immediate=0, .flags=0x00, .name = "WE670" },
  { .ov = 10, .code = 0x73ea, .word = 0xe678, .immediate=0, .flags=0x00, .name = "WE678" },
  { .ov = 10, .code = 0x744d, .word = 0xe680, .immediate=0, .flags=0x00, .name = "WE680" },
  { .ov = 10, .code = 0x744d, .word = 0xe685, .immediate=0, .flags=0x00, .name = "WE685" },
  { .ov = 10, .code = 0x744d, .word = 0xe68a, .immediate=0, .flags=0x00, .name = "WE68A" },
  { .ov = 10, .code = 0x744d, .word = 0xe68f, .immediate=0, .flags=0x00, .name = "WE68F" },
  { .ov = 10, .code = 0x744d, .word = 0xe694, .immediate=0, .flags=0x00, .name = "WE694" },
  { .ov = 10, .code = 0x744d, .word = 0xe699, .immediate=0, .flags=0x00, .name = "WE699" },
  { .ov = 10, .code = 0x744d, .word = 0xe69e, .immediate=0, .flags=0x00, .name = "WE69E" },
  { .ov = 10, .code = 0x744d, .word = 0xe6a3, .immediate=0, .flags=0x00, .name = "WE6A3" },
  { .ov = 10, .code = 0x744d, .word = 0xe6a8, .immediate=0, .flags=0x00, .name = "WE6A8" },
  { .ov = 10, .code = 0x73ea, .word = 0xe6ad, .immediate=0, .flags=0x00, .name = "WE6AD" },
  { .ov = 10, .code = 0x73ea, .word = 0xe6b5, .immediate=0, .flags=0x00, .name = "WE6B5" },
  { .ov = 10, .code = 0x73ea, .word = 0xe6bd, .immediate=0, .flags=0x00, .name = "WE6BD" },
  { .ov = 10, .code = 0x224c, .word = 0xe6c5, .immediate=0, .flags=0x00, .name = "WE6C5" },
  { .ov = 10, .code = 0x224c, .word = 0xe806, .immediate=0, .flags=0x00, .name = "WE806" },
  { .ov = 10, .code = 0x224c, .word = 0xe82a, .immediate=0, .flags=0x00, .name = "WE82A" },
  { .ov = 10, .code = 0x1d29, .word = 0xe864, .immediate=0, .flags=0x00, .name = "WE864" },
  { .ov = 10, .code = 0x224c, .word = 0xe877, .immediate=0, .flags=0x00, .name = "WE877" },
  { .ov = 10, .code = 0x1d29, .word = 0xe91e, .immediate=0, .flags=0x00, .name = "WE91E" },
  { .ov = 10, .code = 0x224c, .word = 0xe922, .immediate=0, .flags=0x00, .name = "WE922" },
  { .ov = 10, .code = 0x224c, .word = 0xe92a, .immediate=0, .flags=0x00, .name = "WE92A" },
  { .ov = 10, .code = 0x224c, .word = 0xea44, .immediate=0, .flags=0x00, .name = "WEA44" },
  { .ov = 10, .code = 0x224c, .word = 0xea7d, .immediate=0, .flags=0x00, .name = "WEA7D" },
  { .ov = 10, .code = 0x224c, .word = 0xeb45, .immediate=0, .flags=0x00, .name = "WEB45" },
  { .ov = 10, .code = 0x224c, .word = 0xebcd, .immediate=0, .flags=0x00, .name = "WEBCD" },
  { .ov = 10, .code = 0x224c, .word = 0xec5d, .immediate=0, .flags=0x00, .name = "WEC5D" },
  { .ov = 10, .code = 0x224c, .word = 0xed59, .immediate=0, .flags=0x00, .name = "WED59" },
  { .ov = 10, .code = 0x224c, .word = 0xed67, .immediate=0, .flags=0x00, .name = "WED67" },
  { .ov = 10, .code = 0x224c, .word = 0xeded, .immediate=0, .flags=0x00, .name = "WEDED" },
  { .ov = 10, .code = 0x224c, .word = 0xee1d, .immediate=0, .flags=0x00, .name = "WEE1D" },
  { .ov = 10, .code = 0x224c, .word = 0xee3f, .immediate=0, .flags=0x00, .name = "WEE3F" },
  { .ov = 10, .code = 0x1d29, .word = 0xee61, .immediate=0, .flags=0x00, .name = "WEE61" },
  { .ov = 10, .code = 0x224c, .word = 0xee65, .immediate=0, .flags=0x00, .name = "WEE65" },
  { .ov = 10, .code = 0x224c, .word = 0xef53, .immediate=0, .flags=0x00, .name = "WEF53" },
  { .ov = 10, .code = 0x224c, .word = 0xefff, .immediate=0, .flags=0x00, .name = "WEFFF" },
  { .ov = 10, .code = 0x224c, .word = 0xf02d, .immediate=0, .flags=0x00, .name = "WF02D" },
  { .ov = 10, .code = 0x224c, .word = 0xf053, .immediate=0, .flags=0x00, .name = "WF053" },
  { .ov = 10, .code = 0x224c, .word = 0xf09d, .immediate=0, .flags=0x00, .name = "WF09D" },
  { .ov = 10, .code = 0x224c, .word = 0xf164, .immediate=0, .flags=0x00, .name = "WF164" },
  { .ov = 10, .code = 0x224c, .word = 0xf192, .immediate=0, .flags=0x00, .name = "WF192" },
  { .ov = 10, .code = 0x224c, .word = 0xf1f7, .immediate=0, .flags=0x00, .name = "WF1F7" },
  { .ov = 10, .code = 0x224c, .word = 0xf232, .immediate=0, .flags=0x00, .name = "WF232" },
  { .ov = 10, .code = 0x1d29, .word = 0xf2b6, .immediate=0, .flags=0x00, .name = "WF2B6" },
  { .ov = 10, .code = 0x224c, .word = 0xf2cd, .immediate=0, .flags=0x00, .name = "WF2CD" },
  { .ov = 10, .code = 0x224c, .word = 0xf36b, .immediate=0, .flags=0x00, .name = "WF36B" },
  { .ov = 10, .code = 0x224c, .word = 0xf3a3, .immediate=0, .flags=0x00, .name = "WF3A3" },
  { .ov = 10, .code = 0x224c, .word = 0xf3e7, .immediate=0, .flags=0x00, .name = "WF3E7" },
  { .ov = 10, .code = 0x224c, .word = 0xf3f9, .immediate=0, .flags=0x00, .name = "WF3F9" },
  { .ov = 10, .code = 0x224c, .word = 0xf497, .immediate=0, .flags=0x00, .name = "WF497" },
  { .ov = 10, .code = 0x4a4f, .word = 0xf4e8, .immediate=0, .flags=0x80, .name = "PFILE-FUNCTION" },
  { .ov = 10, .code = 0x224c, .word = 0xf50a, .immediate=0, .flags=0x80, .name = "(U-PFILE)" },
  { .ov = 11, .code = 0x744d, .word = 0xed36, .immediate=0, .flags=0x00, .name = "WED36" },
  { .ov = 11, .code = 0x744d, .word = 0xed3b, .immediate=0, .flags=0x00, .name = "WED3B" },
  { .ov = 11, .code = 0x744d, .word = 0xed40, .immediate=0, .flags=0x00, .name = "WED40" },
  { .ov = 11, .code = 0x744d, .word = 0xed45, .immediate=0, .flags=0x00, .name = "WED45" },
  { .ov = 11, .code = 0x744d, .word = 0xed4a, .immediate=0, .flags=0x00, .name = "WED4A" },
  { .ov = 11, .code = 0x744d, .word = 0xed4f, .immediate=0, .flags=0x00, .name = "WED4F" },
  { .ov = 11, .code = 0x744d, .word = 0xed54, .immediate=0, .flags=0x00, .name = "WED54" },
  { .ov = 11, .code = 0x744d, .word = 0xed59, .immediate=0, .flags=0x00, .name = "WED59" },
  { .ov = 11, .code = 0x744d, .word = 0xed5e, .immediate=0, .flags=0x00, .name = "WED5E" },
  { .ov = 11, .code = 0x224c, .word = 0xed63, .immediate=0, .flags=0x00, .name = "WED63" },
  { .ov = 11, .code = 0x1d29, .word = 0xed6f, .immediate=0, .flags=0x00, .name = "WED6F" },
  { .ov = 11, .code = 0x1d29, .word = 0xedb5, .immediate=0, .flags=0x00, .name = "WEDB5" },
  { .ov = 11, .code = 0x1d29, .word = 0xedfb, .immediate=0, .flags=0x00, .name = "WEDFB" },
  { .ov = 11, .code = 0x1d29, .word = 0xee2f, .immediate=0, .flags=0x00, .name = "WEE2F" },
  { .ov = 11, .code = 0x1d29, .word = 0xee53, .immediate=0, .flags=0x00, .name = "WEE53" },
  { .ov = 11, .code = 0x224c, .word = 0xee61, .immediate=0, .flags=0x80, .name = "(.MASS)" },
  { .ov = 11, .code = 0x224c, .word = 0xeee0, .immediate=0, .flags=0x80, .name = "(.ACC)" },
  { .ov = 11, .code = 0x224c, .word = 0xef1a, .immediate=0, .flags=0x00, .name = "WEF1A" },
  { .ov = 11, .code = 0x224c, .word = 0xef90, .immediate=0, .flags=0x00, .name = "WEF90" },
  { .ov = 11, .code = 0x224c, .word = 0xf014, .immediate=0, .flags=0x00, .name = "WF014" },
  { .ov = 11, .code = 0x224c, .word = 0xf026, .immediate=0, .flags=0x00, .name = "WF026" },
  { .ov = 11, .code = 0x224c, .word = 0xf098, .immediate=0, .flags=0x00, .name = "WF098" },
  { .ov = 11, .code = 0x224c, .word = 0xf0c2, .immediate=0, .flags=0x80, .name = "(.PODS)" },
  { .ov = 11, .code = 0x1d29, .word = 0xf11c, .immediate=0, .flags=0x00, .name = "WF11C" },
  { .ov = 11, .code = 0x1d29, .word = 0xf122, .immediate=0, .flags=0x00, .name = "WF122" },
  { .ov = 11, .code = 0x1d29, .word = 0xf128, .immediate=0, .flags=0x00, .name = "WF128" },
  { .ov = 11, .code = 0x224c, .word = 0xf132, .immediate=0, .flags=0x00, .name = "WF132" },
  { .ov = 11, .code = 0x224c, .word = 0xf174, .immediate=0, .flags=0x00, .name = "WF174" },
  { .ov = 11, .code = 0x224c, .word = 0xf1b6, .immediate=0, .flags=0x80, .name = "(.SHIP)" },
  { .ov = 11, .code = 0x224c, .word = 0xf1de, .immediate=0, .flags=0x80, .name = "(BALANCEMESS)" },
  { .ov = 11, .code = 0x224c, .word = 0xf21d, .immediate=0, .flags=0x00, .name = "WF21D" },
  { .ov = 11, .code = 0x224c, .word = 0xf310, .immediate=0, .flags=0x00, .name = "WF310" },
  { .ov = 11, .code = 0x224c, .word = 0xf40f, .immediate=0, .flags=0x00, .name = "WF40F" },
  { .ov = 11, .code = 0x224c, .word = 0xf4f9, .immediate=0, .flags=0x80, .name = "(.CONFIG)" },
  { .ov = 12, .code = 0x224c, .word = 0xe976, .immediate=0, .flags=0x00, .name = "WE976" },
  { .ov = 12, .code = 0x224c, .word = 0xe980, .immediate=0, .flags=0x00, .name = "WE980" },
  { .ov = 12, .code = 0x224c, .word = 0xe98a, .immediate=0, .flags=0x00, .name = "WE98A" },
  { .ov = 12, .code = 0x224c, .word = 0xe994, .immediate=0, .flags=0x00, .name = "WE994" },
  { .ov = 12, .code = 0x224c, .word = 0xe99e, .immediate=0, .flags=0x00, .name = "WE99E" },
  { .ov = 12, .code = 0x224c, .word = 0xe9a8, .immediate=0, .flags=0x00, .name = "WE9A8" },
  { .ov = 12, .code = 0x224c, .word = 0xe9b2, .immediate=0, .flags=0x00, .name = "WE9B2" },
  { .ov = 12, .code = 0x224c, .word = 0xe9bc, .immediate=0, .flags=0x00, .name = "WE9BC" },
  { .ov = 12, .code = 0x224c, .word = 0xe9c6, .immediate=0, .flags=0x00, .name = "WE9C6" },
  { .ov = 12, .code = 0x224c, .word = 0xe9d0, .immediate=0, .flags=0x00, .name = "WE9D0" },
  { .ov = 12, .code = 0x744d, .word = 0xe9da, .immediate=0, .flags=0x00, .name = "WE9DA" },
  { .ov = 12, .code = 0x744d, .word = 0xe9df, .immediate=0, .flags=0x00, .name = "WE9DF" },
  { .ov = 12, .code = 0x744d, .word = 0xe9e4, .immediate=0, .flags=0x00, .name = "WE9E4" },
  { .ov = 12, .code = 0x744d, .word = 0xe9e9, .immediate=0, .flags=0x00, .name = "WE9E9" },
  { .ov = 12, .code = 0x744d, .word = 0xe9ee, .immediate=0, .flags=0x00, .name = "WE9EE" },
  { .ov = 12, .code = 0x744d, .word = 0xe9f3, .immediate=0, .flags=0x00, .name = "WE9F3" },
  { .ov = 12, .code = 0x744d, .word = 0xe9f8, .immediate=0, .flags=0x00, .name = "WE9F8" },
  { .ov = 12, .code = 0x744d, .word = 0xe9fd, .immediate=0, .flags=0x00, .name = "WE9FD" },
  { .ov = 12, .code = 0x744d, .word = 0xea02, .immediate=0, .flags=0x00, .name = "WEA02" },
  { .ov = 12, .code = 0x744d, .word = 0xea07, .immediate=0, .flags=0x00, .name = "WEA07" },
  { .ov = 12, .code = 0x744d, .word = 0xea0c, .immediate=0, .flags=0x00, .name = "WEA0C" },
  { .ov = 12, .code = 0x744d, .word = 0xea11, .immediate=0, .flags=0x00, .name = "WEA11" },
  { .ov = 12, .code = 0x744d, .word = 0xea16, .immediate=0, .flags=0x00, .name = "WEA16" },
  { .ov = 12, .code = 0x224c, .word = 0xea1b, .immediate=0, .flags=0x00, .name = "WEA1B" },
  { .ov = 12, .code = 0x224c, .word = 0xea27, .immediate=0, .flags=0x00, .name = "WEA27" },
  { .ov = 12, .code = 0x1d29, .word = 0xea33, .immediate=0, .flags=0x00, .name = "WEA33" },
  { .ov = 12, .code = 0x1d29, .word = 0xea4a, .immediate=0, .flags=0x00, .name = "WEA4A" },
  { .ov = 12, .code = 0x224c, .word = 0xea65, .immediate=0, .flags=0x00, .name = "WEA65" },
  { .ov = 12, .code = 0x224c, .word = 0xeaa9, .immediate=0, .flags=0x00, .name = "WEAA9" },
  { .ov = 12, .code = 0x224c, .word = 0xeadd, .immediate=0, .flags=0x00, .name = "WEADD" },
  { .ov = 12, .code = 0x224c, .word = 0xeb1b, .immediate=0, .flags=0x00, .name = "WEB1B" },
  { .ov = 12, .code = 0x224c, .word = 0xeb5b, .immediate=0, .flags=0x00, .name = "WEB5B" },
  { .ov = 12, .code = 0x1d29, .word = 0xeb7d, .immediate=0, .flags=0x00, .name = "WEB7D" },
  { .ov = 12, .code = 0x1d29, .word = 0xeb81, .immediate=0, .flags=0x00, .name = "WEB81" },
  { .ov = 12, .code = 0x224c, .word = 0xebb5, .immediate=0, .flags=0x00, .name = "WEBB5" },
  { .ov = 12, .code = 0x224c, .word = 0xebe9, .immediate=0, .flags=0x00, .name = "WEBE9" },
  { .ov = 12, .code = 0x4a4f, .word = 0xec62, .immediate=0, .flags=0x80, .name = "(PARTADDR)" },
  { .ov = 12, .code = 0x224c, .word = 0xec78, .immediate=0, .flags=0x00, .name = "WEC78" },
  { .ov = 12, .code = 0x4a4f, .word = 0xec88, .immediate=0, .flags=0x80, .name = "(PTS)" },
  { .ov = 12, .code = 0x224c, .word = 0xec96, .immediate=0, .flags=0x00, .name = "WEC96" },
  { .ov = 12, .code = 0x1d29, .word = 0xecaa, .immediate=0, .flags=0x00, .name = "WECAA" },
  { .ov = 12, .code = 0x224c, .word = 0xecb0, .immediate=0, .flags=0x00, .name = "WECB0" },
  { .ov = 12, .code = 0x224c, .word = 0xed20, .immediate=0, .flags=0x00, .name = "WED20" },
  { .ov = 12, .code = 0x224c, .word = 0xed6a, .immediate=0, .flags=0x00, .name = "WED6A" },
  { .ov = 12, .code = 0x224c, .word = 0xee14, .immediate=0, .flags=0x00, .name = "WEE14" },
  { .ov = 12, .code = 0x224c, .word = 0xee20, .immediate=0, .flags=0x00, .name = "WEE20" },
  { .ov = 12, .code = 0x224c, .word = 0xef52, .immediate=0, .flags=0x00, .name = "WEF52" },
  { .ov = 12, .code = 0x224c, .word = 0xefcc, .immediate=0, .flags=0x00, .name = "WEFCC" },
  { .ov = 12, .code = 0x224c, .word = 0xf041, .immediate=0, .flags=0x00, .name = "WF041" },
  { .ov = 12, .code = 0x224c, .word = 0xf0da, .immediate=0, .flags=0x00, .name = "WF0DA" },
  { .ov = 12, .code = 0x1d29, .word = 0xf148, .immediate=0, .flags=0x00, .name = "WF148" },
  { .ov = 12, .code = 0x224c, .word = 0xf14c, .immediate=0, .flags=0x00, .name = "WF14C" },
  { .ov = 12, .code = 0x224c, .word = 0xf1d6, .immediate=0, .flags=0x00, .name = "WF1D6" },
  { .ov = 12, .code = 0x224c, .word = 0xf226, .immediate=0, .flags=0x00, .name = "WF226" },
  { .ov = 12, .code = 0x224c, .word = 0xf288, .immediate=0, .flags=0x00, .name = "WF288" },
  { .ov = 12, .code = 0x224c, .word = 0xf2c5, .immediate=0, .flags=0x00, .name = "WF2C5" },
  { .ov = 12, .code = 0x224c, .word = 0xf2fa, .immediate=0, .flags=0x00, .name = "WF2FA" },
  { .ov = 12, .code = 0x224c, .word = 0xf346, .immediate=0, .flags=0x00, .name = "WF346" },
  { .ov = 12, .code = 0x224c, .word = 0xf3b8, .immediate=0, .flags=0x00, .name = "WF3B8" },
  { .ov = 12, .code = 0x224c, .word = 0xf3d7, .immediate=0, .flags=0x00, .name = "WF3D7" },
  { .ov = 12, .code = 0x224c, .word = 0xf3fd, .immediate=0, .flags=0x00, .name = "WF3FD" },
  { .ov = 12, .code = 0x224c, .word = 0xf46d, .immediate=0, .flags=0x00, .name = "WF46D" },
  { .ov = 12, .code = 0x224c, .word = 0xf477, .immediate=0, .flags=0x00, .name = "WF477" },
  { .ov = 12, .code = 0x4a4f, .word = 0xf493, .immediate=0, .flags=0x80, .name = "CONFIG-FUNCTION" },
  { .ov = 12, .code = 0x224c, .word = 0xf4ba, .immediate=0, .flags=0x80, .name = "(U-CONFIG)" },
  { .ov = 13, .code = 0x1d29, .word = 0xe2b6, .immediate=0, .flags=0x00, .name = "WE2B6" },
  { .ov = 13, .code = 0x1d29, .word = 0xe2ba, .immediate=0, .flags=0x00, .name = "WE2BA" },
  { .ov = 13, .code = 0x1d29, .word = 0xe2be, .immediate=0, .flags=0x00, .name = "WE2BE" },
  { .ov = 13, .code = 0x224c, .word = 0xe2c2, .immediate=0, .flags=0x00, .name = "WE2C2" },
  { .ov = 13, .code = 0x224c, .word = 0xe2cc, .immediate=0, .flags=0x00, .name = "WE2CC" },
  { .ov = 13, .code = 0x224c, .word = 0xe2d6, .immediate=0, .flags=0x00, .name = "WE2D6" },
  { .ov = 13, .code = 0x224c, .word = 0xe2e0, .immediate=0, .flags=0x00, .name = "WE2E0" },
  { .ov = 13, .code = 0x224c, .word = 0xe2ea, .immediate=0, .flags=0x00, .name = "WE2EA" },
  { .ov = 13, .code = 0x224c, .word = 0xe2fa, .immediate=0, .flags=0x00, .name = "WE2FA" },
  { .ov = 13, .code = 0x224c, .word = 0xe30e, .immediate=0, .flags=0x00, .name = "WE30E" },
  { .ov = 13, .code = 0x224c, .word = 0xe318, .immediate=0, .flags=0x00, .name = "WE318" },
  { .ov = 13, .code = 0x224c, .word = 0xe322, .immediate=0, .flags=0x00, .name = "WE322" },
  { .ov = 13, .code = 0x224c, .word = 0xe32c, .immediate=0, .flags=0x00, .name = "WE32C" },
  { .ov = 13, .code = 0x224c, .word = 0xe346, .immediate=0, .flags=0x00, .name = "WE346" },
  { .ov = 13, .code = 0x224c, .word = 0xe36f, .immediate=0, .flags=0x00, .name = "WE36F" },
  { .ov = 13, .code = 0x73ea, .word = 0xe383, .immediate=0, .flags=0x00, .name = "WE383" },
  { .ov = 13, .code = 0x73ea, .word = 0xe38b, .immediate=0, .flags=0x00, .name = "WE38B" },
  { .ov = 13, .code = 0x73ea, .word = 0xe393, .immediate=0, .flags=0x00, .name = "WE393" },
  { .ov = 13, .code = 0x744d, .word = 0xe39b, .immediate=0, .flags=0x00, .name = "WE39B" },
  { .ov = 13, .code = 0x224c, .word = 0xe3a0, .immediate=0, .flags=0x00, .name = "WE3A0" },
  { .ov = 13, .code = 0x224c, .word = 0xe3a8, .immediate=0, .flags=0x00, .name = "WE3A8" },
  { .ov = 13, .code = 0x224c, .word = 0xe3b4, .immediate=0, .flags=0x00, .name = "WE3B4" },
  { .ov = 13, .code = 0x224c, .word = 0xe3c0, .immediate=0, .flags=0x00, .name = "WE3C0" },
  { .ov = 13, .code = 0x224c, .word = 0xe3ca, .immediate=0, .flags=0x00, .name = "WE3CA" },
  { .ov = 13, .code = 0x224c, .word = 0xe3e0, .immediate=0, .flags=0x00, .name = "WE3E0" },
  { .ov = 13, .code = 0x224c, .word = 0xe3ea, .immediate=0, .flags=0x00, .name = "WE3EA" },
  { .ov = 13, .code = 0x224c, .word = 0xe3fa, .immediate=0, .flags=0x00, .name = "WE3FA" },
  { .ov = 13, .code = 0x224c, .word = 0xe408, .immediate=0, .flags=0x00, .name = "WE408" },
  { .ov = 13, .code = 0x1d29, .word = 0xe4b4, .immediate=0, .flags=0x00, .name = "WE4B4" },
  { .ov = 13, .code = 0x224c, .word = 0xe4c7, .immediate=0, .flags=0x00, .name = "WE4C7" },
  { .ov = 13, .code = 0x224c, .word = 0xe4fb, .immediate=0, .flags=0x00, .name = "WE4FB" },
  { .ov = 13, .code = 0x224c, .word = 0xe537, .immediate=0, .flags=0x00, .name = "WE537" },
  { .ov = 13, .code = 0x224c, .word = 0xe606, .immediate=0, .flags=0x00, .name = "WE606" },
  { .ov = 13, .code = 0x224c, .word = 0xe628, .immediate=0, .flags=0x00, .name = "WE628" },
  { .ov = 13, .code = 0x224c, .word = 0xe679, .immediate=0, .flags=0x00, .name = "WE679" },
  { .ov = 13, .code = 0x224c, .word = 0xe693, .immediate=0, .flags=0x00, .name = "WE693" },
  { .ov = 13, .code = 0x224c, .word = 0xe6bd, .immediate=0, .flags=0x00, .name = "WE6BD" },
  { .ov = 13, .code = 0x224c, .word = 0xe709, .immediate=0, .flags=0x00, .name = "WE709" },
  { .ov = 13, .code = 0x224c, .word = 0xe735, .immediate=0, .flags=0x00, .name = "WE735" },
  { .ov = 13, .code = 0x224c, .word = 0xe749, .immediate=0, .flags=0x00, .name = "WE749" },
  { .ov = 13, .code = 0x224c, .word = 0xe79c, .immediate=0, .flags=0x00, .name = "WE79C" },
  { .ov = 13, .code = 0x224c, .word = 0xe7d3, .immediate=0, .flags=0x00, .name = "WE7D3" },
  { .ov = 13, .code = 0x224c, .word = 0xe7e8, .immediate=0, .flags=0x00, .name = "WE7E8" },
  { .ov = 13, .code = 0x224c, .word = 0xe804, .immediate=0, .flags=0x00, .name = "WE804" },
  { .ov = 13, .code = 0x224c, .word = 0xe835, .immediate=0, .flags=0x00, .name = "WE835" },
  { .ov = 13, .code = 0x224c, .word = 0xe83f, .immediate=0, .flags=0x00, .name = "WE83F" },
  { .ov = 13, .code = 0x224c, .word = 0xe847, .immediate=0, .flags=0x00, .name = "WE847" },
  { .ov = 13, .code = 0x224c, .word = 0xe859, .immediate=0, .flags=0x00, .name = "WE859" },
  { .ov = 13, .code = 0x224c, .word = 0xe86b, .immediate=0, .flags=0x00, .name = "WE86B" },
  { .ov = 13, .code = 0x224c, .word = 0xe87b, .immediate=0, .flags=0x00, .name = "WE87B" },
  { .ov = 13, .code = 0x224c, .word = 0xe8e9, .immediate=0, .flags=0x00, .name = "WE8E9" },
  { .ov = 13, .code = 0x224c, .word = 0xe917, .immediate=0, .flags=0x00, .name = "WE917" },
  { .ov = 13, .code = 0x224c, .word = 0xe921, .immediate=0, .flags=0x00, .name = "WE921" },
  { .ov = 13, .code = 0x224c, .word = 0xe957, .immediate=0, .flags=0x00, .name = "WE957" },
  { .ov = 13, .code = 0x224c, .word = 0xe999, .immediate=0, .flags=0x00, .name = "WE999" },
  { .ov = 13, .code = 0x224c, .word = 0xe9cd, .immediate=0, .flags=0x00, .name = "WE9CD" },
  { .ov = 13, .code = 0x224c, .word = 0xe9eb, .immediate=0, .flags=0x00, .name = "WE9EB" },
  { .ov = 13, .code = 0x224c, .word = 0xea1b, .immediate=0, .flags=0x00, .name = "WEA1B" },
  { .ov = 13, .code = 0x4a4f, .word = 0xea45, .immediate=0, .flags=0x80, .name = "TD-SCROLL" },
  { .ov = 13, .code = 0x224c, .word = 0xea53, .immediate=0, .flags=0x00, .name = "WEA53" },
  { .ov = 13, .code = 0x224c, .word = 0xea82, .immediate=0, .flags=0x00, .name = "WEA82" },
  { .ov = 13, .code = 0x224c, .word = 0xea98, .immediate=0, .flags=0x00, .name = "WEA98" },
  { .ov = 13, .code = 0x224c, .word = 0xeacc, .immediate=0, .flags=0x00, .name = "WEACC" },
  { .ov = 13, .code = 0x224c, .word = 0xeb66, .immediate=0, .flags=0x00, .name = "WEB66" },
  { .ov = 13, .code = 0x224c, .word = 0xeb74, .immediate=0, .flags=0x00, .name = "WEB74" },
  { .ov = 13, .code = 0x224c, .word = 0xebf3, .immediate=0, .flags=0x80, .name = "KEY-ELEM-AMT" },
  { .ov = 13, .code = 0x224c, .word = 0xecd0, .immediate=0, .flags=0x00, .name = "WECD0" },
  { .ov = 13, .code = 0x224c, .word = 0xecfc, .immediate=0, .flags=0x00, .name = "WECFC" },
  { .ov = 13, .code = 0x224c, .word = 0xed89, .immediate=0, .flags=0x00, .name = "WED89" },
  { .ov = 13, .code = 0x224c, .word = 0xedb9, .immediate=0, .flags=0x00, .name = "WEDB9" },
  { .ov = 13, .code = 0x224c, .word = 0xee73, .immediate=0, .flags=0x00, .name = "WEE73" },
  { .ov = 13, .code = 0x224c, .word = 0xef38, .immediate=0, .flags=0x00, .name = "WEF38" },
  { .ov = 13, .code = 0x224c, .word = 0xef62, .immediate=0, .flags=0x00, .name = "WEF62" },
  { .ov = 13, .code = 0x224c, .word = 0xefa0, .immediate=0, .flags=0x00, .name = "WEFA0" },
  { .ov = 13, .code = 0x224c, .word = 0xefe0, .immediate=0, .flags=0x00, .name = "WEFE0" },
  { .ov = 13, .code = 0x224c, .word = 0xf054, .immediate=0, .flags=0x00, .name = "WF054" },
  { .ov = 13, .code = 0x224c, .word = 0xf0aa, .immediate=0, .flags=0x00, .name = "WF0AA" },
  { .ov = 13, .code = 0x224c, .word = 0xf0fe, .immediate=0, .flags=0x00, .name = "WF0FE" },
  { .ov = 13, .code = 0x224c, .word = 0xf11c, .immediate=0, .flags=0x00, .name = "WF11C" },
  { .ov = 13, .code = 0x4a4f, .word = 0xf146, .immediate=0, .flags=0x80, .name = "SELL-WHAT" },
  { .ov = 13, .code = 0x224c, .word = 0xf162, .immediate=0, .flags=0x80, .name = "SELL-IT" },
  { .ov = 13, .code = 0x224c, .word = 0xf1a6, .immediate=0, .flags=0x00, .name = "WF1A6" },
  { .ov = 13, .code = 0x224c, .word = 0xf1d8, .immediate=0, .flags=0x00, .name = "WF1D8" },
  { .ov = 13, .code = 0x224c, .word = 0xf2c1, .immediate=0, .flags=0x00, .name = "WF2C1" },
  { .ov = 13, .code = 0x224c, .word = 0xf2f9, .immediate=0, .flags=0x00, .name = "WF2F9" },
  { .ov = 13, .code = 0x4a4f, .word = 0xf378, .immediate=0, .flags=0x80, .name = "BUY-WHAT" },
  { .ov = 13, .code = 0x224c, .word = 0xf386, .immediate=0, .flags=0x00, .name = "WF386" },
  { .ov = 13, .code = 0x224c, .word = 0xf3ca, .immediate=0, .flags=0x00, .name = "WF3CA" },
  { .ov = 13, .code = 0x4a4f, .word = 0xf43b, .immediate=0, .flags=0x80, .name = "DEPOT-FUNCTION" },
  { .ov = 13, .code = 0x224c, .word = 0xf45d, .immediate=0, .flags=0x80, .name = "(U-DEPOT)" },
  { .ov = 13, .code = 0x224c, .word = 0xf4ca, .immediate=0, .flags=0x80, .name = "<TDART" },
  { .ov = 14, .code = 0x744d, .word = 0xe946, .immediate=0, .flags=0x00, .name = "WE946" },
  { .ov = 14, .code = 0x744d, .word = 0xe94b, .immediate=0, .flags=0x00, .name = "WE94B" },
  { .ov = 14, .code = 0x744d, .word = 0xe950, .immediate=0, .flags=0x00, .name = "WE950" },
  { .ov = 14, .code = 0x224c, .word = 0xe955, .immediate=0, .flags=0x00, .name = "WE955" },
  { .ov = 14, .code = 0x224c, .word = 0xe9bb, .immediate=0, .flags=0x00, .name = "WE9BB" },
  { .ov = 14, .code = 0x224c, .word = 0xe9c9, .immediate=0, .flags=0x00, .name = "WE9C9" },
  { .ov = 14, .code = 0x1d29, .word = 0xea07, .immediate=0, .flags=0x00, .name = "WEA07" },
  { .ov = 14, .code = 0x224c, .word = 0xea0b, .immediate=0, .flags=0x00, .name = "WEA0B" },
  { .ov = 14, .code = 0x1d29, .word = 0xea6b, .immediate=0, .flags=0x00, .name = "WEA6B" },
  { .ov = 14, .code = 0x1d29, .word = 0xea6f, .immediate=0, .flags=0x00, .name = "WEA6F" },
  { .ov = 14, .code = 0x1d29, .word = 0xea73, .immediate=0, .flags=0x00, .name = "WEA73" },
  { .ov = 14, .code = 0x1d29, .word = 0xea77, .immediate=0, .flags=0x00, .name = "WEA77" },
  { .ov = 14, .code = 0x1d29, .word = 0xea7b, .immediate=0, .flags=0x00, .name = "WEA7B" },
  { .ov = 14, .code = 0x224c, .word = 0xea7f, .immediate=0, .flags=0x00, .name = "WEA7F" },
  { .ov = 14, .code = 0x224c, .word = 0xea91, .immediate=0, .flags=0x00, .name = "WEA91" },
  { .ov = 14, .code = 0x224c, .word = 0xeaa1, .immediate=0, .flags=0x00, .name = "WEAA1" },
  { .ov = 14, .code = 0x224c, .word = 0xeab1, .immediate=0, .flags=0x00, .name = "WEAB1" },
  { .ov = 14, .code = 0x224c, .word = 0xeac1, .immediate=0, .flags=0x00, .name = "WEAC1" },
  { .ov = 14, .code = 0x224c, .word = 0xead1, .immediate=0, .flags=0x00, .name = "WEAD1" },
  { .ov = 14, .code = 0x224c, .word = 0xeae1, .immediate=0, .flags=0x00, .name = "WEAE1" },
  { .ov = 14, .code = 0x744d, .word = 0xeaeb, .immediate=0, .flags=0x00, .name = "WEAEB" },
  { .ov = 14, .code = 0x224c, .word = 0xeaf0, .immediate=0, .flags=0x00, .name = "WEAF0" },
  { .ov = 14, .code = 0x224c, .word = 0xeba2, .immediate=0, .flags=0x00, .name = "WEBA2" },
  { .ov = 14, .code = 0x1d29, .word = 0xebfc, .immediate=0, .flags=0x00, .name = "WEBFC" },
  { .ov = 14, .code = 0xec0c, .word = 0xec0c, .immediate=0, .flags=0x80, .name = "(|REGION)" },
  { .ov = 14, .code = 0xec7d, .word = 0xec7d, .immediate=0, .flags=0x80, .name = "|EGA" },
  { .ov = 14, .code = 0x224c, .word = 0xecc1, .immediate=0, .flags=0x80, .name = "|REGION" },
  { .ov = 14, .code = 0x1d29, .word = 0xeced, .immediate=0, .flags=0x00, .name = "WECED" },
  { .ov = 14, .code = 0x1d29, .word = 0xecf1, .immediate=0, .flags=0x00, .name = "WECF1" },
  { .ov = 14, .code = 0x224c, .word = 0xed10, .immediate=0, .flags=0x00, .name = "WED10" },
  { .ov = 14, .code = 0x1d29, .word = 0xed3a, .immediate=0, .flags=0x00, .name = "WED3A" },
  { .ov = 14, .code = 0x224c, .word = 0xed40, .immediate=0, .flags=0x00, .name = "WED40" },
  { .ov = 14, .code = 0x224c, .word = 0xed4e, .immediate=0, .flags=0x00, .name = "WED4E" },
  { .ov = 14, .code = 0x224c, .word = 0xed62, .immediate=0, .flags=0x00, .name = "WED62" },
  { .ov = 14, .code = 0x224c, .word = 0xed72, .immediate=0, .flags=0x00, .name = "WED72" },
  { .ov = 14, .code = 0x224c, .word = 0xed88, .immediate=0, .flags=0x00, .name = "WED88" },
  { .ov = 14, .code = 0x224c, .word = 0xeda1, .immediate=0, .flags=0x00, .name = "WEDA1" },
  { .ov = 14, .code = 0x224c, .word = 0xedb3, .immediate=0, .flags=0x00, .name = "WEDB3" },
  { .ov = 14, .code = 0x224c, .word = 0xedbe, .immediate=0, .flags=0x00, .name = "WEDBE" },
  { .ov = 14, .code = 0x224c, .word = 0xedcf, .immediate=0, .flags=0x00, .name = "WEDCF" },
  { .ov = 14, .code = 0x224c, .word = 0xede1, .immediate=0, .flags=0x00, .name = "WEDE1" },
  { .ov = 14, .code = 0x4a4f, .word = 0xee07, .immediate=0, .flags=0x80, .name = "(.DOOR)" },
  { .ov = 14, .code = 0x224c, .word = 0xee29, .immediate=0, .flags=0x00, .name = "WEE29" },
  { .ov = 14, .code = 0x224c, .word = 0xee39, .immediate=0, .flags=0x00, .name = "WEE39" },
  { .ov = 14, .code = 0x224c, .word = 0xee6f, .immediate=0, .flags=0x00, .name = "WEE6F" },
  { .ov = 14, .code = 0x1d29, .word = 0xeeb5, .immediate=0, .flags=0x00, .name = "WEEB5" },
  { .ov = 14, .code = 0x224c, .word = 0xef2f, .immediate=0, .flags=0x00, .name = "WEF2F" },
  { .ov = 14, .code = 0x224c, .word = 0xef43, .immediate=0, .flags=0x00, .name = "WEF43" },
  { .ov = 14, .code = 0x224c, .word = 0xef65, .immediate=0, .flags=0x00, .name = "WEF65" },
  { .ov = 14, .code = 0x224c, .word = 0xef75, .immediate=0, .flags=0x00, .name = "WEF75" },
  { .ov = 14, .code = 0x224c, .word = 0xef9d, .immediate=0, .flags=0x00, .name = "WEF9D" },
  { .ov = 14, .code = 0x224c, .word = 0xefd5, .immediate=0, .flags=0x00, .name = "WEFD5" },
  { .ov = 14, .code = 0x224c, .word = 0xeffb, .immediate=0, .flags=0x00, .name = "WEFFB" },
  { .ov = 14, .code = 0x224c, .word = 0xf031, .immediate=0, .flags=0x00, .name = "WF031" },
  { .ov = 14, .code = 0x224c, .word = 0xf04b, .immediate=0, .flags=0x00, .name = "WF04B" },
  { .ov = 14, .code = 0x224c, .word = 0xf063, .immediate=0, .flags=0x00, .name = "WF063" },
  { .ov = 14, .code = 0x224c, .word = 0xf085, .immediate=0, .flags=0x00, .name = "WF085" },
  { .ov = 14, .code = 0x224c, .word = 0xf091, .immediate=0, .flags=0x00, .name = "WF091" },
  { .ov = 14, .code = 0x1d29, .word = 0xf09f, .immediate=0, .flags=0x00, .name = "WF09F" },
  { .ov = 14, .code = 0x1d29, .word = 0xf0a3, .immediate=0, .flags=0x00, .name = "WF0A3" },
  { .ov = 14, .code = 0x1d29, .word = 0xf0a7, .immediate=0, .flags=0x00, .name = "WF0A7" },
  { .ov = 14, .code = 0x1d29, .word = 0xf0b5, .immediate=0, .flags=0x00, .name = "WF0B5" },
  { .ov = 14, .code = 0x1d29, .word = 0xf151, .immediate=0, .flags=0x00, .name = "WF151" },
  { .ov = 14, .code = 0x224c, .word = 0xf18b, .immediate=0, .flags=0x00, .name = "WF18B" },
  { .ov = 14, .code = 0x224c, .word = 0xf1a9, .immediate=0, .flags=0x00, .name = "WF1A9" },
  { .ov = 14, .code = 0x224c, .word = 0xf1e9, .immediate=0, .flags=0x00, .name = "WF1E9" },
  { .ov = 14, .code = 0x224c, .word = 0xf22b, .immediate=0, .flags=0x00, .name = "WF22B" },
  { .ov = 14, .code = 0x224c, .word = 0xf239, .immediate=0, .flags=0x00, .name = "WF239" },
  { .ov = 14, .code = 0x224c, .word = 0xf293, .immediate=0, .flags=0x00, .name = "WF293" },
  { .ov = 14, .code = 0x224c, .word = 0xf2a1, .immediate=0, .flags=0x00, .name = "WF2A1" },
  { .ov = 14, .code = 0x224c, .word = 0xf2b3, .immediate=0, .flags=0x00, .name = "WF2B3" },
  { .ov = 14, .code = 0x224c, .word = 0xf30b, .immediate=0, .flags=0x00, .name = "WF30B" },
  { .ov = 14, .code = 0x224c, .word = 0xf34b, .immediate=0, .flags=0x00, .name = "WF34B" },
  { .ov = 14, .code = 0x224c, .word = 0xf361, .immediate=0, .flags=0x00, .name = "WF361" },
  { .ov = 14, .code = 0x224c, .word = 0xf379, .immediate=0, .flags=0x00, .name = "WF379" },
  { .ov = 14, .code = 0x224c, .word = 0xf391, .immediate=0, .flags=0x00, .name = "WF391" },
  { .ov = 14, .code = 0x224c, .word = 0xf3a9, .immediate=0, .flags=0x00, .name = "WF3A9" },
  { .ov = 14, .code = 0x224c, .word = 0xf410, .immediate=0, .flags=0x80, .name = "PORT-PIC" },
  { .ov = 14, .code = 0x4a4f, .word = 0xf466, .immediate=0, .flags=0x80, .name = "DO-ROOM" },
  { .ov = 14, .code = 0x224c, .word = 0xf488, .immediate=0, .flags=0x00, .name = "WF488" },
  { .ov = 14, .code = 0x4a4f, .word = 0xf4b6, .immediate=0, .flags=0x80, .name = "XWALK" },
  { .ov = 14, .code = 0x4a4f, .word = 0xf4cc, .immediate=0, .flags=0x80, .name = "YWALK" },
  { .ov = 14, .code = 0x224c, .word = 0xf4e4, .immediate=0, .flags=0x80, .name = "WALKIES" },
  { .ov = 15, .code = 0x2214, .word = 0xe796, .immediate=0, .flags=0x00, .name = "WE796" },
  { .ov = 15, .code = 0x2214, .word = 0xe79a, .immediate=0, .flags=0x00, .name = "WE79A" },
  { .ov = 15, .code = 0x2214, .word = 0xe79e, .immediate=0, .flags=0x00, .name = "WE79E" },
  { .ov = 15, .code = 0x73ea, .word = 0xe7a2, .immediate=0, .flags=0x00, .name = "WE7A2" },
  { .ov = 15, .code = 0x73ea, .word = 0xe7aa, .immediate=0, .flags=0x00, .name = "WE7AA" },
  { .ov = 15, .code = 0x73ea, .word = 0xe7b2, .immediate=0, .flags=0x00, .name = "WE7B2" },
  { .ov = 15, .code = 0x73ea, .word = 0xe7ba, .immediate=0, .flags=0x00, .name = "WE7BA" },
  { .ov = 15, .code = 0x73ea, .word = 0xe7c2, .immediate=0, .flags=0x00, .name = "WE7C2" },
  { .ov = 15, .code = 0x73ea, .word = 0xe7ca, .immediate=0, .flags=0x00, .name = "WE7CA" },
  { .ov = 15, .code = 0x73ea, .word = 0xe7d2, .immediate=0, .flags=0x00, .name = "WE7D2" },
  { .ov = 15, .code = 0x73ea, .word = 0xe7da, .immediate=0, .flags=0x00, .name = "WE7DA" },
  { .ov = 15, .code = 0x73ea, .word = 0xe7e2, .immediate=0, .flags=0x00, .name = "WE7E2" },
  { .ov = 15, .code = 0x73ea, .word = 0xe7ea, .immediate=0, .flags=0x00, .name = "WE7EA" },
  { .ov = 15, .code = 0x73ea, .word = 0xe7f2, .immediate=0, .flags=0x00, .name = "WE7F2" },
  { .ov = 15, .code = 0x73ea, .word = 0xe7fa, .immediate=0, .flags=0x00, .name = "WE7FA" },
  { .ov = 15, .code = 0x73ea, .word = 0xe802, .immediate=0, .flags=0x00, .name = "WE802" },
  { .ov = 15, .code = 0x73ea, .word = 0xe80a, .immediate=0, .flags=0x00, .name = "WE80A" },
  { .ov = 15, .code = 0x73ea, .word = 0xe812, .immediate=0, .flags=0x00, .name = "WE812" },
  { .ov = 15, .code = 0x73ea, .word = 0xe81a, .immediate=0, .flags=0x00, .name = "WE81A" },
  { .ov = 15, .code = 0x73ea, .word = 0xe822, .immediate=0, .flags=0x00, .name = "WE822" },
  { .ov = 15, .code = 0x73ea, .word = 0xe82a, .immediate=0, .flags=0x00, .name = "WE82A" },
  { .ov = 15, .code = 0x73ea, .word = 0xe832, .immediate=0, .flags=0x00, .name = "WE832" },
  { .ov = 15, .code = 0x73ea, .word = 0xe83a, .immediate=0, .flags=0x00, .name = "WE83A" },
  { .ov = 15, .code = 0x73ea, .word = 0xe842, .immediate=0, .flags=0x00, .name = "WE842" },
  { .ov = 15, .code = 0x73ea, .word = 0xe84a, .immediate=0, .flags=0x00, .name = "WE84A" },
  { .ov = 15, .code = 0x73ea, .word = 0xe852, .immediate=0, .flags=0x00, .name = "WE852" },
  { .ov = 15, .code = 0x73ea, .word = 0xe85a, .immediate=0, .flags=0x00, .name = "WE85A" },
  { .ov = 15, .code = 0x73ea, .word = 0xe862, .immediate=0, .flags=0x00, .name = "WE862" },
  { .ov = 15, .code = 0x73ea, .word = 0xe86a, .immediate=0, .flags=0x00, .name = "WE86A" },
  { .ov = 15, .code = 0x73ea, .word = 0xe872, .immediate=0, .flags=0x00, .name = "WE872" },
  { .ov = 15, .code = 0x744d, .word = 0xe87a, .immediate=0, .flags=0x00, .name = "WE87A" },
  { .ov = 15, .code = 0x73ea, .word = 0xe87f, .immediate=0, .flags=0x00, .name = "WE87F" },
  { .ov = 15, .code = 0x73ea, .word = 0xe887, .immediate=0, .flags=0x00, .name = "WE887" },
  { .ov = 15, .code = 0x73ea, .word = 0xe88f, .immediate=0, .flags=0x00, .name = "WE88F" },
  { .ov = 15, .code = 0x73ea, .word = 0xe897, .immediate=0, .flags=0x00, .name = "WE897" },
  { .ov = 15, .code = 0x73ea, .word = 0xe89f, .immediate=0, .flags=0x00, .name = "WE89F" },
  { .ov = 15, .code = 0x73ea, .word = 0xe8a7, .immediate=0, .flags=0x00, .name = "WE8A7" },
  { .ov = 15, .code = 0x224c, .word = 0xe8af, .immediate=0, .flags=0x00, .name = "WE8AF" },
  { .ov = 15, .code = 0x224c, .word = 0xe8c3, .immediate=0, .flags=0x00, .name = "WE8C3" },
  { .ov = 15, .code = 0x224c, .word = 0xe8cb, .immediate=0, .flags=0x00, .name = "WE8CB" },
  { .ov = 15, .code = 0x224c, .word = 0xe8d7, .immediate=0, .flags=0x00, .name = "WE8D7" },
  { .ov = 15, .code = 0x224c, .word = 0xe8e1, .immediate=0, .flags=0x00, .name = "WE8E1" },
  { .ov = 15, .code = 0x224c, .word = 0xe8ed, .immediate=0, .flags=0x00, .name = "WE8ED" },
  { .ov = 15, .code = 0x224c, .word = 0xe903, .immediate=0, .flags=0x00, .name = "WE903" },
  { .ov = 15, .code = 0x224c, .word = 0xe91a, .immediate=0, .flags=0x00, .name = "WE91A" },
  { .ov = 15, .code = 0x224c, .word = 0xe928, .immediate=0, .flags=0x00, .name = "WE928" },
  { .ov = 15, .code = 0x224c, .word = 0xe9c0, .immediate=0, .flags=0x00, .name = "WE9C0" },
  { .ov = 15, .code = 0x224c, .word = 0xe9e8, .immediate=0, .flags=0x00, .name = "WE9E8" },
  { .ov = 15, .code = 0x224c, .word = 0xe9f6, .immediate=0, .flags=0x00, .name = "WE9F6" },
  { .ov = 15, .code = 0x224c, .word = 0xea0a, .immediate=0, .flags=0x00, .name = "WEA0A" },
  { .ov = 15, .code = 0xe90b, .word = 0xea4d, .immediate=0, .flags=0x80, .name = "A.DENSIT" },
  { .ov = 15, .code = 0xe90b, .word = 0xea68, .immediate=0, .flags=0x80, .name = "PLANET.G" },
  { .ov = 15, .code = 0x224c, .word = 0xea78, .immediate=0, .flags=0x00, .name = "WEA78" },
  { .ov = 15, .code = 0x224c, .word = 0xeaa0, .immediate=0, .flags=0x00, .name = "WEAA0" },
  { .ov = 15, .code = 0x224c, .word = 0xeabe, .immediate=0, .flags=0x00, .name = "WEABE" },
  { .ov = 15, .code = 0x224c, .word = 0xeaec, .immediate=0, .flags=0x00, .name = "WEAEC" },
  { .ov = 15, .code = 0xe940, .word = 0xeafd, .immediate=0, .flags=0x80, .name = "NICE" },
  { .ov = 15, .code = 0x224c, .word = 0xeba5, .immediate=0, .flags=0x00, .name = "WEBA5" },
  { .ov = 15, .code = 0x224c, .word = 0xebad, .immediate=0, .flags=0x00, .name = "WEBAD" },
  { .ov = 15, .code = 0x224c, .word = 0xebbd, .immediate=0, .flags=0x00, .name = "WEBBD" },
  { .ov = 15, .code = 0x224c, .word = 0xebd3, .immediate=0, .flags=0x00, .name = "WEBD3" },
  { .ov = 15, .code = 0x224c, .word = 0xec19, .immediate=0, .flags=0x00, .name = "WEC19" },
  { .ov = 15, .code = 0x224c, .word = 0xec3d, .immediate=0, .flags=0x00, .name = "WEC3D" },
  { .ov = 15, .code = 0x224c, .word = 0xec4f, .immediate=0, .flags=0x00, .name = "WEC4F" },
  { .ov = 15, .code = 0x224c, .word = 0xec6b, .immediate=0, .flags=0x00, .name = "WEC6B" },
  { .ov = 15, .code = 0x224c, .word = 0xeca3, .immediate=0, .flags=0x00, .name = "WECA3" },
  { .ov = 15, .code = 0x224c, .word = 0xecab, .immediate=0, .flags=0x00, .name = "WECAB" },
  { .ov = 15, .code = 0x224c, .word = 0xecbb, .immediate=0, .flags=0x00, .name = "WECBB" },
  { .ov = 15, .code = 0x224c, .word = 0xeccb, .immediate=0, .flags=0x00, .name = "WECCB" },
  { .ov = 15, .code = 0x224c, .word = 0xed13, .immediate=0, .flags=0x00, .name = "WED13" },
  { .ov = 15, .code = 0x224c, .word = 0xed27, .immediate=0, .flags=0x00, .name = "WED27" },
  { .ov = 15, .code = 0x1d29, .word = 0xed5d, .immediate=0, .flags=0x00, .name = "WED5D" },
  { .ov = 15, .code = 0x1d29, .word = 0xed61, .immediate=0, .flags=0x00, .name = "WED61" },
  { .ov = 15, .code = 0x1d29, .word = 0xed65, .immediate=0, .flags=0x00, .name = "WED65" },
  { .ov = 15, .code = 0x224c, .word = 0xed69, .immediate=0, .flags=0x00, .name = "WED69" },
  { .ov = 15, .code = 0x224c, .word = 0xed75, .immediate=0, .flags=0x00, .name = "WED75" },
  { .ov = 15, .code = 0x224c, .word = 0xed99, .immediate=0, .flags=0x00, .name = "WED99" },
  { .ov = 15, .code = 0x224c, .word = 0xedaf, .immediate=0, .flags=0x00, .name = "WEDAF" },
  { .ov = 15, .code = 0x224c, .word = 0xedcf, .immediate=0, .flags=0x00, .name = "WEDCF" },
  { .ov = 15, .code = 0x224c, .word = 0xede7, .immediate=0, .flags=0x00, .name = "WEDE7" },
  { .ov = 15, .code = 0x224c, .word = 0xee2f, .immediate=0, .flags=0x00, .name = "WEE2F" },
  { .ov = 15, .code = 0x224c, .word = 0xee43, .immediate=0, .flags=0x00, .name = "WEE43" },
  { .ov = 15, .code = 0x224c, .word = 0xee9d, .immediate=0, .flags=0x00, .name = "WEE9D" },
  { .ov = 15, .code = 0x224c, .word = 0xeead, .immediate=0, .flags=0x00, .name = "WEEAD" },
  { .ov = 15, .code = 0x224c, .word = 0xeec1, .immediate=0, .flags=0x00, .name = "WEEC1" },
  { .ov = 15, .code = 0x224c, .word = 0xeed1, .immediate=0, .flags=0x00, .name = "WEED1" },
  { .ov = 15, .code = 0x224c, .word = 0xeee7, .immediate=0, .flags=0x00, .name = "WEEE7" },
  { .ov = 15, .code = 0x224c, .word = 0xef25, .immediate=0, .flags=0x00, .name = "WEF25" },
  { .ov = 15, .code = 0x1d29, .word = 0xef37, .immediate=0, .flags=0x00, .name = "WEF37" },
  { .ov = 15, .code = 0x224c, .word = 0xef3b, .immediate=0, .flags=0x00, .name = "WEF3B" },
  { .ov = 15, .code = 0x224c, .word = 0xef47, .immediate=0, .flags=0x00, .name = "WEF47" },
  { .ov = 15, .code = 0x1d29, .word = 0xef53, .immediate=0, .flags=0x00, .name = "WEF53" },
  { .ov = 15, .code = 0x224c, .word = 0xef57, .immediate=0, .flags=0x00, .name = "WEF57" },
  { .ov = 15, .code = 0x224c, .word = 0xef95, .immediate=0, .flags=0x00, .name = "WEF95" },
  { .ov = 15, .code = 0x224c, .word = 0xefa9, .immediate=0, .flags=0x00, .name = "WEFA9" },
  { .ov = 15, .code = 0x224c, .word = 0xefc5, .immediate=0, .flags=0x00, .name = "WEFC5" },
  { .ov = 15, .code = 0x224c, .word = 0xefe1, .immediate=0, .flags=0x00, .name = "WEFE1" },
  { .ov = 15, .code = 0x224c, .word = 0xeff5, .immediate=0, .flags=0x00, .name = "WEFF5" },
  { .ov = 15, .code = 0x224c, .word = 0xf041, .immediate=0, .flags=0x00, .name = "WF041" },
  { .ov = 15, .code = 0x224c, .word = 0xf055, .immediate=0, .flags=0x00, .name = "WF055" },
  { .ov = 15, .code = 0x224c, .word = 0xf067, .immediate=0, .flags=0x00, .name = "WF067" },
  { .ov = 15, .code = 0x224c, .word = 0xf081, .immediate=0, .flags=0x00, .name = "WF081" },
  { .ov = 15, .code = 0x224c, .word = 0xf093, .immediate=0, .flags=0x00, .name = "WF093" },
  { .ov = 15, .code = 0x224c, .word = 0xf09f, .immediate=0, .flags=0x00, .name = "WF09F" },
  { .ov = 15, .code = 0x224c, .word = 0xf0c7, .immediate=0, .flags=0x00, .name = "WF0C7" },
  { .ov = 15, .code = 0x224c, .word = 0xf0e9, .immediate=0, .flags=0x00, .name = "WF0E9" },
  { .ov = 15, .code = 0x224c, .word = 0xf0ff, .immediate=0, .flags=0x00, .name = "WF0FF" },
  { .ov = 15, .code = 0x224c, .word = 0xf107, .immediate=0, .flags=0x00, .name = "WF107" },
  { .ov = 15, .code = 0x224c, .word = 0xf119, .immediate=0, .flags=0x00, .name = "WF119" },
  { .ov = 15, .code = 0x224c, .word = 0xf155, .immediate=0, .flags=0x00, .name = "WF155" },
  { .ov = 15, .code = 0x224c, .word = 0xf179, .immediate=0, .flags=0x00, .name = "WF179" },
  { .ov = 15, .code = 0x224c, .word = 0xf189, .immediate=0, .flags=0x00, .name = "WF189" },
  { .ov = 15, .code = 0x224c, .word = 0xf199, .immediate=0, .flags=0x00, .name = "WF199" },
  { .ov = 15, .code = 0x224c, .word = 0xf1b5, .immediate=0, .flags=0x00, .name = "WF1B5" },
  { .ov = 15, .code = 0x224c, .word = 0xf1d3, .immediate=0, .flags=0x00, .name = "WF1D3" },
  { .ov = 15, .code = 0x224c, .word = 0xf23c, .immediate=0, .flags=0x00, .name = "WF23C" },
  { .ov = 15, .code = 0x224c, .word = 0xf286, .immediate=0, .flags=0x00, .name = "WF286" },
  { .ov = 15, .code = 0x224c, .word = 0xf2da, .immediate=0, .flags=0x00, .name = "WF2DA" },
  { .ov = 15, .code = 0x224c, .word = 0xf320, .immediate=0, .flags=0x00, .name = "WF320" },
  { .ov = 15, .code = 0x224c, .word = 0xf334, .immediate=0, .flags=0x00, .name = "WF334" },
  { .ov = 15, .code = 0x224c, .word = 0xf382, .immediate=0, .flags=0x00, .name = "WF382" },
  { .ov = 15, .code = 0x224c, .word = 0xf3ea, .immediate=0, .flags=0x00, .name = "WF3EA" },
  { .ov = 15, .code = 0x224c, .word = 0xf40c, .immediate=0, .flags=0x00, .name = "WF40C" },
  { .ov = 15, .code = 0x224c, .word = 0xf432, .immediate=0, .flags=0x00, .name = "WF432" },
  { .ov = 15, .code = 0x224c, .word = 0xf448, .immediate=0, .flags=0x00, .name = "WF448" },
  { .ov = 15, .code = 0x224c, .word = 0xf49c, .immediate=0, .flags=0x80, .name = "DIO" },
  { .ov = 16, .code = 0x2214, .word = 0xe296, .immediate=0, .flags=0x00, .name = "planet" },
  { .ov = 16, .code = 0x2214, .word = 0xe29a, .immediate=0, .flags=0x00, .name = "star" },
  { .ov = 16, .code = 0x2214, .word = 0xe29e, .immediate=0, .flags=0x00, .name = "regions" },
  { .ov = 16, .code = 0x2214, .word = 0xe2a2, .immediate=0, .flags=0x00, .name = "creature" },
  { .ov = 16, .code = 0x744d, .word = 0xe2a6, .immediate=0, .flags=0x00, .name = "crowding" },
  { .ov = 16, .code = 0x224c, .word = 0xe2ab, .immediate=0, .flags=0x00, .name = "difind" },
  { .ov = 16, .code = 0x224c, .word = 0xe2b3, .immediate=0, .flags=0x00, .name = "rput" },
  { .ov = 16, .code = 0x224c, .word = 0xe2bf, .immediate=0, .flags=0x00, .name = "rget" },
  { .ov = 16, .code = 0x224c, .word = 0xe2cb, .immediate=0, .flags=0x00, .name = "1.5," },
  { .ov = 16, .code = 0x224c, .word = 0xe2d7, .immediate=0, .flags=0x00, .name = "iaddr-array" },
  { .ov = 16, .code = 0xe2db, .word = 0xe2f1, .immediate=0, .flags=0x80, .name = "?COLOR" },
  { .ov = 16, .code = 0x224c, .word = 0xe344, .immediate=0, .flags=0x00, .name = "?s" },
  { .ov = 16, .code = 0x224c, .word = 0xe374, .immediate=0, .flags=0x00, .name = "WE374" },
  { .ov = 16, .code = 0x224c, .word = 0xe390, .immediate=0, .flags=0x00, .name = "WE390" },
  { .ov = 16, .code = 0x224c, .word = 0xe3ac, .immediate=0, .flags=0x00, .name = "WE3AC" },
  { .ov = 16, .code = 0x224c, .word = 0xe3b8, .immediate=0, .flags=0x00, .name = "WE3B8" },
  { .ov = 16, .code = 0x224c, .word = 0xe3c2, .immediate=0, .flags=0x00, .name = "WE3C2" },
  { .ov = 16, .code = 0x224c, .word = 0xe3ce, .immediate=0, .flags=0x00, .name = "WE3CE" },
  { .ov = 16, .code = 0x224c, .word = 0xe3d6, .immediate=0, .flags=0x00, .name = "WE3D6" },
  { .ov = 16, .code = 0x224c, .word = 0xe3ec, .immediate=0, .flags=0x00, .name = "WE3EC" },
  { .ov = 16, .code = 0x224c, .word = 0xe3f4, .immediate=0, .flags=0x00, .name = "WE3F4" },
  { .ov = 16, .code = 0x1d29, .word = 0xe400, .immediate=0, .flags=0x00, .name = "WE400" },
  { .ov = 16, .code = 0x224c, .word = 0xe404, .immediate=0, .flags=0x00, .name = "WE404" },
  { .ov = 16, .code = 0x224c, .word = 0xe40c, .immediate=0, .flags=0x00, .name = "WE40C" },
  { .ov = 16, .code = 0x224c, .word = 0xe418, .immediate=0, .flags=0x00, .name = "WE418" },
  { .ov = 16, .code = 0x73ea, .word = 0xe42f, .immediate=0, .flags=0x00, .name = "plan-life" },
  { .ov = 16, .code = 0x73ea, .word = 0xe437, .immediate=0, .flags=0x00, .name = "atmo.density" },
  { .ov = 16, .code = 0x73ea, .word = 0xe43f, .immediate=0, .flags=0x00, .name = "narrowest" },
  { .ov = 16, .code = 0x73ea, .word = 0xe447, .immediate=0, .flags=0x00, .name = "flattest" },
  { .ov = 16, .code = 0x73ea, .word = 0xe44f, .immediate=0, .flags=0x00, .name = "plan-mass" },
  { .ov = 16, .code = 0x73ea, .word = 0xe457, .immediate=0, .flags=0x00, .name = "cllo" },
  { .ov = 16, .code = 0x73ea, .word = 0xe45f, .immediate=0, .flags=0x00, .name = "clhi" },
  { .ov = 16, .code = 0x73ea, .word = 0xe467, .immediate=0, .flags=0x00, .name = "shape" },
  { .ov = 16, .code = 0x73ea, .word = 0xe46f, .immediate=0, .flags=0x00, .name = "exterior" },
  { .ov = 16, .code = 0x73ea, .word = 0xe477, .immediate=0, .flags=0x00, .name = "size.index" },
  { .ov = 16, .code = 0x73ea, .word = 0xe47f, .immediate=0, .flags=0x00, .name = "niche" },
  { .ov = 16, .code = 0x73ea, .word = 0xe487, .immediate=0, .flags=0x00, .name = "reddest" },
  { .ov = 16, .code = 0x73ea, .word = 0xe48f, .immediate=0, .flags=0x00, .name = "bluest" },
  { .ov = 16, .code = 0x73ea, .word = 0xe497, .immediate=0, .flags=0x00, .name = "texture" },
  { .ov = 16, .code = 0x73ea, .word = 0xe49f, .immediate=0, .flags=0x00, .name = "w.append" },
  { .ov = 16, .code = 0x73ea, .word = 0xe4a7, .immediate=0, .flags=0x00, .name = "w#" },
  { .ov = 16, .code = 0x73ea, .word = 0xe4af, .immediate=0, .flags=0x00, .name = "d.append" },
  { .ov = 16, .code = 0x73ea, .word = 0xe4b7, .immediate=0, .flags=0x00, .name = "d#" },
  { .ov = 16, .code = 0x73ea, .word = 0xe4bf, .immediate=0, .flags=0x00, .name = "a.append" },
  { .ov = 16, .code = 0x73ea, .word = 0xe4c7, .immediate=0, .flags=0x00, .name = "a#" },
  { .ov = 16, .code = 0x73ea, .word = 0xe4cf, .immediate=0, .flags=0x00, .name = "g.append" },
  { .ov = 16, .code = 0x73ea, .word = 0xe4d7, .immediate=0, .flags=0x00, .name = "g#" },
  { .ov = 16, .code = 0x73ea, .word = 0xe4df, .immediate=0, .flags=0x00, .name = "g.mobility" },
  { .ov = 16, .code = 0x73ea, .word = 0xe4e7, .immediate=0, .flags=0x00, .name = "a.mobility" },
  { .ov = 16, .code = 0x73ea, .word = 0xe4ef, .immediate=0, .flags=0x00, .name = "orlo" },
  { .ov = 16, .code = 0x73ea, .word = 0xe4f7, .immediate=0, .flags=0x00, .name = "orhi" },
  { .ov = 16, .code = 0x224c, .word = 0xe4ff, .immediate=0, .flags=0x00, .name = "spec>color" },
  { .ov = 16, .code = 0x224c, .word = 0xe50d, .immediate=0, .flags=0x00, .name = "?2dup" },
  { .ov = 16, .code = 0x224c, .word = 0xe51b, .immediate=0, .flags=0x00, .name = "whichguy" },
  { .ov = 16, .code = 0x224c, .word = 0xe52f, .immediate=0, .flags=0x00, .name = "MAPS" },
  { .ov = 16, .code = 0x224c, .word = 0xe53d, .immediate=0, .flags=0x00, .name = "PROBS" },
  { .ov = 16, .code = 0x224c, .word = 0xe5d5, .immediate=0, .flags=0x00, .name = "CHANCE" },
  { .ov = 16, .code = 0x224c, .word = 0xe5fd, .immediate=0, .flags=0x00, .name = "RESULT" },
  { .ov = 16, .code = 0x224c, .word = 0xe60b, .immediate=0, .flags=0x00, .name = "(kng)" },
  { .ov = 16, .code = 0xe555, .word = 0xe628, .immediate=0, .flags=0x80, .name = "SHAPES" },
  { .ov = 16, .code = 0xe555, .word = 0xe66a, .immediate=0, .flags=0x80, .name = "EPIDERM" },
  { .ov = 16, .code = 0x224c, .word = 0xe6f8, .immediate=0, .flags=0x00, .name = "shaper" },
  { .ov = 16, .code = 0x224c, .word = 0xe70e, .immediate=0, .flags=0x00, .name = "outfit" },
  { .ov = 16, .code = 0x224c, .word = 0xe740, .immediate=0, .flags=0x00, .name = "pelts" },
  { .ov = 16, .code = 0x224c, .word = 0xe762, .immediate=0, .flags=0x00, .name = "class.parms" },
  { .ov = 16, .code = 0xe555, .word = 0xe7e1, .immediate=0, .flags=0x80, .name = "ANIMAL.APPENDAGE" },
  { .ov = 16, .code = 0xe555, .word = 0xe874, .immediate=0, .flags=0x80, .name = "APPEARANCE" },
  { .ov = 16, .code = 0xe555, .word = 0xeb75, .immediate=0, .flags=0x80, .name = "WEAPONRY" },
  { .ov = 16, .code = 0xe555, .word = 0xebd3, .immediate=0, .flags=0x80, .name = "DECORATIONS" },
  { .ov = 16, .code = 0xe555, .word = 0xec6b, .immediate=0, .flags=0x80, .name = "#LEGS" },
  { .ov = 16, .code = 0xe555, .word = 0xed58, .immediate=0, .flags=0x80, .name = "LEGG" },
  { .ov = 16, .code = 0x224c, .word = 0xede0, .immediate=0, .flags=0x00, .name = "sizing" },
  { .ov = 16, .code = 0x224c, .word = 0xee38, .immediate=0, .flags=0x00, .name = "spec>color" },
  { .ov = 16, .code = 0x224c, .word = 0xef05, .immediate=0, .flags=0x00, .name = "WEF05" },
  { .ov = 16, .code = 0x224c, .word = 0xef3b, .immediate=0, .flags=0x00, .name = "WEF3B" },
  { .ov = 16, .code = 0x224c, .word = 0xef75, .immediate=0, .flags=0x00, .name = "dye" },
  { .ov = 16, .code = 0x224c, .word = 0xefb5, .immediate=0, .flags=0x00, .name = "WEFB5" },
  { .ov = 16, .code = 0x224c, .word = 0xefd1, .immediate=0, .flags=0x00, .name = "fortify" },
  { .ov = 16, .code = 0x224c, .word = 0xf015, .immediate=0, .flags=0x00, .name = "decorate" },
  { .ov = 16, .code = 0x224c, .word = 0xf02b, .immediate=0, .flags=0x00, .name = "trimming" },
  { .ov = 16, .code = 0xe420, .word = 0xf088, .immediate=0, .flags=0x80, .name = "GROUNDED" },
  { .ov = 16, .code = 0xe420, .word = 0xf0a2, .immediate=0, .flags=0x80, .name = "BOUYANT" },
  { .ov = 16, .code = 0x1d29, .word = 0xf0b0, .immediate=0, .flags=0x00, .name = "WF0B0" },
  { .ov = 16, .code = 0x1d29, .word = 0xf0b4, .immediate=0, .flags=0x00, .name = "WF0B4" },
  { .ov = 16, .code = 0x224c, .word = 0xf0b8, .immediate=0, .flags=0x00, .name = "WF0B8" },
  { .ov = 16, .code = 0x224c, .word = 0xf0c6, .immediate=0, .flags=0x00, .name = "WF0C6" },
  { .ov = 16, .code = 0x224c, .word = 0xf11c, .immediate=0, .flags=0x00, .name = "WF11C" },
  { .ov = 16, .code = 0x224c, .word = 0xf12a, .immediate=0, .flags=0x00, .name = "WF12A" },
  { .ov = 16, .code = 0x224c, .word = 0xf136, .immediate=0, .flags=0x00, .name = "elevate" },
  { .ov = 16, .code = 0x1d29, .word = 0xf1e6, .immediate=0, .flags=0x00, .name = "WF1E6" },
  { .ov = 16, .code = 0x224c, .word = 0xf1ea, .immediate=0, .flags=0x00, .name = "WF1EA" },
  { .ov = 16, .code = 0x224c, .word = 0xf210, .immediate=0, .flags=0x00, .name = "nubile" },
  { .ov = 16, .code = 0x224c, .word = 0xf26a, .immediate=0, .flags=0x00, .name = "WF26A" },
  { .ov = 16, .code = 0x224c, .word = 0xf278, .immediate=0, .flags=0x00, .name = "stroll" },
  { .ov = 16, .code = 0x224c, .word = 0xf2d2, .immediate=0, .flags=0x00, .name = "WF2D2" },
  { .ov = 16, .code = 0x224c, .word = 0xf3c2, .immediate=0, .flags=0x00, .name = "WF3C2" },
  { .ov = 16, .code = 0x224c, .word = 0xf3e0, .immediate=0, .flags=0x00, .name = "WF3E0" },
  { .ov = 16, .code = 0x224c, .word = 0xf404, .immediate=0, .flags=0x00, .name = "movem" },
  { .ov = 16, .code = 0x224c, .word = 0xf430, .immediate=0, .flags=0x00, .name = "animate" },
  { .ov = 16, .code = 0x224c, .word = 0xf494, .immediate=0, .flags=0x00, .name = "texturize" },
  { .ov = 16, .code = 0x224c, .word = 0xf4a6, .immediate=0, .flags=0x00, .name = "WF4A6" },
  { .ov = 16, .code = 0x224c, .word = 0xf4c0, .immediate=0, .flags=0x00, .name = "order.parms" },
  { .ov = 16, .code = 0x224c, .word = 0xf4f9, .immediate=0, .flags=0x80, .name = "C+OPARMS" },
  { .ov = 17, .code = 0x2214, .word = 0xe0d6, .immediate=0, .flags=0x00, .name = "planet" },
  { .ov = 17, .code = 0x2214, .word = 0xe0da, .immediate=0, .flags=0x00, .name = "creature" },
  { .ov = 17, .code = 0x224c, .word = 0xe0de, .immediate=0, .flags=0x00, .name = "difind" },
  { .ov = 17, .code = 0x224c, .word = 0xe0e6, .immediate=0, .flags=0x00, .name = "?2dup" },
  { .ov = 17, .code = 0x224c, .word = 0xe0f4, .immediate=0, .flags=0x00, .name = "rput" },
  { .ov = 17, .code = 0x224c, .word = 0xe100, .immediate=0, .flags=0x00, .name = "rget" },
  { .ov = 17, .code = 0x224c, .word = 0xe10c, .immediate=0, .flags=0x00, .name = "iaddr-array" },
  { .ov = 17, .code = 0x224c, .word = 0xe121, .immediate=0, .flags=0x00, .name = "lookup" },
  { .ov = 17, .code = 0xe114, .word = 0xe19c, .immediate=0, .flags=0x80, .name = ">SIZE" },
  { .ov = 17, .code = 0xe114, .word = 0xe1c5, .immediate=0, .flags=0x80, .name = ">MOVER" },
  { .ov = 17, .code = 0xe114, .word = 0xe1f1, .immediate=0, .flags=0x80, .name = "?COLOR" },
  { .ov = 17, .code = 0xe114, .word = 0xe24f, .immediate=0, .flags=0x80, .name = ">PROP" },
  { .ov = 17, .code = 0x224c, .word = 0xe27b, .immediate=0, .flags=0x00, .name = "coin" },
  { .ov = 17, .code = 0x224c, .word = 0xe285, .immediate=0, .flags=0x00, .name = "rand%" },
  { .ov = 17, .code = 0x224c, .word = 0xe291, .immediate=0, .flags=0x00, .name = "crandom" },
  { .ov = 17, .code = 0x224c, .word = 0xe29d, .immediate=0, .flags=0x00, .name = "scale" },
  { .ov = 17, .code = 0x224c, .word = 0xe2b3, .immediate=0, .flags=0x00, .name = "slipper" },
  { .ov = 17, .code = 0x224c, .word = 0xe2bb, .immediate=0, .flags=0x00, .name = "slip!" },
  { .ov = 17, .code = 0x224c, .word = 0xe2c7, .immediate=0, .flags=0x00, .name = "%%" },
  { .ov = 17, .code = 0x73ea, .word = 0xe2de, .immediate=0, .flags=0x00, .name = "atmo.density" },
  { .ov = 17, .code = 0x73ea, .word = 0xe2e6, .immediate=0, .flags=0x00, .name = "narrowest" },
  { .ov = 17, .code = 0x73ea, .word = 0xe2ee, .immediate=0, .flags=0x00, .name = "flattest" },
  { .ov = 17, .code = 0x73ea, .word = 0xe2f6, .immediate=0, .flags=0x00, .name = "shape" },
  { .ov = 17, .code = 0x73ea, .word = 0xe2fe, .immediate=0, .flags=0x00, .name = "exterior" },
  { .ov = 17, .code = 0x73ea, .word = 0xe306, .immediate=0, .flags=0x00, .name = "size.index" },
  { .ov = 17, .code = 0x73ea, .word = 0xe30e, .immediate=0, .flags=0x00, .name = "niche" },
  { .ov = 17, .code = 0x73ea, .word = 0xe316, .immediate=0, .flags=0x00, .name = "reddest" },
  { .ov = 17, .code = 0x73ea, .word = 0xe31e, .immediate=0, .flags=0x00, .name = "bluest" },
  { .ov = 17, .code = 0x73ea, .word = 0xe326, .immediate=0, .flags=0x00, .name = "texture" },
  { .ov = 17, .code = 0x73ea, .word = 0xe32e, .immediate=0, .flags=0x00, .name = "w.append" },
  { .ov = 17, .code = 0x73ea, .word = 0xe336, .immediate=0, .flags=0x00, .name = "w#" },
  { .ov = 17, .code = 0x73ea, .word = 0xe33e, .immediate=0, .flags=0x00, .name = "d.append" },
  { .ov = 17, .code = 0x73ea, .word = 0xe346, .immediate=0, .flags=0x00, .name = "d#" },
  { .ov = 17, .code = 0x73ea, .word = 0xe34e, .immediate=0, .flags=0x00, .name = "a.append" },
  { .ov = 17, .code = 0x73ea, .word = 0xe356, .immediate=0, .flags=0x00, .name = "a#" },
  { .ov = 17, .code = 0x73ea, .word = 0xe35e, .immediate=0, .flags=0x00, .name = "g.append" },
  { .ov = 17, .code = 0x73ea, .word = 0xe366, .immediate=0, .flags=0x00, .name = "g#" },
  { .ov = 17, .code = 0x73ea, .word = 0xe36e, .immediate=0, .flags=0x00, .name = "g.mobility" },
  { .ov = 17, .code = 0x73ea, .word = 0xe376, .immediate=0, .flags=0x00, .name = "a.mobility" },
  { .ov = 17, .code = 0x73ea, .word = 0xe37e, .immediate=0, .flags=0x00, .name = "slowest" },
  { .ov = 17, .code = 0x73ea, .word = 0xe386, .immediate=0, .flags=0x00, .name = "fastest" },
  { .ov = 17, .code = 0x73ea, .word = 0xe38e, .immediate=0, .flags=0x00, .name = "stun.effect" },
  { .ov = 17, .code = 0x73ea, .word = 0xe396, .immediate=0, .flags=0x00, .name = "hit.points" },
  { .ov = 17, .code = 0x73ea, .word = 0xe39e, .immediate=0, .flags=0x00, .name = "i.level" },
  { .ov = 17, .code = 0x73ea, .word = 0xe3a6, .immediate=0, .flags=0x00, .name = "a.level" },
  { .ov = 17, .code = 0x73ea, .word = 0xe3ae, .immediate=0, .flags=0x00, .name = "i.level" },
  { .ov = 17, .code = 0x73ea, .word = 0xe3b6, .immediate=0, .flags=0x00, .name = "volume" },
  { .ov = 17, .code = 0x73ea, .word = 0xe3be, .immediate=0, .flags=0x00, .name = "proportion" },
  { .ov = 17, .code = 0x73ea, .word = 0xe3c6, .immediate=0, .flags=0x00, .name = "d.hue" },
  { .ov = 17, .code = 0x73ea, .word = 0xe3ce, .immediate=0, .flags=0x00, .name = "d.tint" },
  { .ov = 17, .code = 0x73ea, .word = 0xe3d6, .immediate=0, .flags=0x00, .name = "d.lumens" },
  { .ov = 17, .code = 0x73ea, .word = 0xe3de, .immediate=0, .flags=0x00, .name = "d.struc" },
  { .ov = 17, .code = 0x73ea, .word = 0xe3e6, .immediate=0, .flags=0x00, .name = "d.propor" },
  { .ov = 17, .code = 0x73ea, .word = 0xe3ee, .immediate=0, .flags=0x00, .name = "d.size" },
  { .ov = 17, .code = 0x73ea, .word = 0xe3f6, .immediate=0, .flags=0x00, .name = "w.hue" },
  { .ov = 17, .code = 0x73ea, .word = 0xe3fe, .immediate=0, .flags=0x00, .name = "w.tint" },
  { .ov = 17, .code = 0x73ea, .word = 0xe406, .immediate=0, .flags=0x00, .name = "WE406" },
  { .ov = 17, .code = 0x73ea, .word = 0xe40e, .immediate=0, .flags=0x00, .name = "w.struc" },
  { .ov = 17, .code = 0x73ea, .word = 0xe416, .immediate=0, .flags=0x00, .name = "w.propor" },
  { .ov = 17, .code = 0x73ea, .word = 0xe41e, .immediate=0, .flags=0x00, .name = "w.size" },
  { .ov = 17, .code = 0x73ea, .word = 0xe426, .immediate=0, .flags=0x00, .name = "a.hue" },
  { .ov = 17, .code = 0x73ea, .word = 0xe42e, .immediate=0, .flags=0x00, .name = "a.tint" },
  { .ov = 17, .code = 0x73ea, .word = 0xe436, .immediate=0, .flags=0x00, .name = "a.lumens" },
  { .ov = 17, .code = 0x73ea, .word = 0xe43e, .immediate=0, .flags=0x00, .name = "a.struc" },
  { .ov = 17, .code = 0x73ea, .word = 0xe446, .immediate=0, .flags=0x00, .name = "a.propor" },
  { .ov = 17, .code = 0x73ea, .word = 0xe44e, .immediate=0, .flags=0x00, .name = "a.size" },
  { .ov = 17, .code = 0x73ea, .word = 0xe456, .immediate=0, .flags=0x00, .name = "g.hue" },
  { .ov = 17, .code = 0x73ea, .word = 0xe45e, .immediate=0, .flags=0x00, .name = "g.tint" },
  { .ov = 17, .code = 0x73ea, .word = 0xe466, .immediate=0, .flags=0x00, .name = "g.lumens" },
  { .ov = 17, .code = 0x73ea, .word = 0xe46e, .immediate=0, .flags=0x00, .name = "g.struc" },
  { .ov = 17, .code = 0x73ea, .word = 0xe476, .immediate=0, .flags=0x00, .name = "g.propor" },
  { .ov = 17, .code = 0x73ea, .word = 0xe47e, .immediate=0, .flags=0x00, .name = "g.size" },
  { .ov = 17, .code = 0x73ea, .word = 0xe486, .immediate=0, .flags=0x00, .name = "s.hue" },
  { .ov = 17, .code = 0x73ea, .word = 0xe48e, .immediate=0, .flags=0x00, .name = "s.tint" },
  { .ov = 17, .code = 0x73ea, .word = 0xe496, .immediate=0, .flags=0x00, .name = "s.lumens" },
  { .ov = 17, .code = 0x73ea, .word = 0xe49e, .immediate=0, .flags=0x00, .name = "icon" },
  { .ov = 17, .code = 0x73ea, .word = 0xe4a6, .immediate=0, .flags=0x00, .name = "resembles" },
  { .ov = 17, .code = 0x73ea, .word = 0xe4ae, .immediate=0, .flags=0x00, .name = "size" },
  { .ov = 17, .code = 0x224c, .word = 0xe4b6, .immediate=0, .flags=0x00, .name = "whichguy" },
  { .ov = 17, .code = 0x224c, .word = 0xe4ca, .immediate=0, .flags=0x00, .name = "MAPS" },
  { .ov = 17, .code = 0x224c, .word = 0xe4d8, .immediate=0, .flags=0x00, .name = "PROPS" },
  { .ov = 17, .code = 0x224c, .word = 0xe570, .immediate=0, .flags=0x00, .name = "CHANCE" },
  { .ov = 17, .code = 0x224c, .word = 0xe598, .immediate=0, .flags=0x00, .name = "result" },
  { .ov = 17, .code = 0x224c, .word = 0xe5a6, .immediate=0, .flags=0x00, .name = "rollem" },
  { .ov = 17, .code = 0x224c, .word = 0xe5fe, .immediate=0, .flags=0x00, .name = "retrieve" },
  { .ov = 17, .code = 0x1d29, .word = 0xe626, .immediate=0, .flags=0x80, .name = "ADDITIONS" },
  { .ov = 17, .code = 0xe4f0, .word = 0xeb63, .immediate=0, .flags=0x80, .name = "LIGHTS" },
  { .ov = 17, .code = 0x224c, .word = 0xeb97, .immediate=0, .flags=0x00, .name = "?pure" },
  { .ov = 17, .code = 0x224c, .word = 0xebb3, .immediate=0, .flags=0x00, .name = "squish" },
  { .ov = 17, .code = 0x224c, .word = 0xebe7, .immediate=0, .flags=0x00, .name = "madness" },
  { .ov = 17, .code = 0x224c, .word = 0xec3f, .immediate=0, .flags=0x00, .name = "anger" },
  { .ov = 17, .code = 0x224c, .word = 0xec57, .immediate=0, .flags=0x00, .name = "strength-rule" },
  { .ov = 17, .code = 0x224c, .word = 0xec81, .immediate=0, .flags=0x00, .name = "durable" },
  { .ov = 17, .code = 0x224c, .word = 0xec8b, .immediate=0, .flags=0x00, .name = "stunable" },
  { .ov = 17, .code = 0x224c, .word = 0xec95, .immediate=0, .flags=0x00, .name = "movers" },
  { .ov = 17, .code = 0x224c, .word = 0xecf9, .immediate=0, .flags=0x00, .name = "(modify)" },
  { .ov = 17, .code = 0x224c, .word = 0xed37, .immediate=0, .flags=0x00, .name = "modify" },
  { .ov = 17, .code = 0x224c, .word = 0xed63, .immediate=0, .flags=0x00, .name = "customize" },
  { .ov = 17, .code = 0x224c, .word = 0xedaf, .immediate=0, .flags=0x00, .name = "colorant" },
  { .ov = 17, .code = 0x224c, .word = 0xedef, .immediate=0, .flags=0x00, .name = "1image" },
  { .ov = 17, .code = 0x224c, .word = 0xee1d, .immediate=0, .flags=0x00, .name = "2image" },
  { .ov = 17, .code = 0xe4f0, .word = 0xee41, .immediate=0, .flags=0x80, .name = "PLANT.ICO" },
  { .ov = 17, .code = 0x224c, .word = 0xee77, .immediate=0, .flags=0x00, .name = "3image" },
  { .ov = 17, .code = 0x224c, .word = 0xeeb1, .immediate=0, .flags=0x00, .name = "4image" },
  { .ov = 17, .code = 0x224c, .word = 0xef31, .immediate=0, .flags=0x00, .name = "set.icon" },
  { .ov = 17, .code = 0x224c, .word = 0xef99, .immediate=0, .flags=0x00, .name = "colorize" },
  { .ov = 17, .code = 0x224c, .word = 0xefdb, .immediate=0, .flags=0x00, .name = "paint" },
  { .ov = 17, .code = 0xe2cf, .word = 0xf031, .immediate=0, .flags=0x80, .name = "TALLEST" },
  { .ov = 17, .code = 0xe2cf, .word = 0xf054, .immediate=0, .flags=0x80, .name = "SHORTEST" },
  { .ov = 17, .code = 0xe2cf, .word = 0xf076, .immediate=0, .flags=0x80, .name = "STALKER" },
  { .ov = 17, .code = 0xe2cf, .word = 0xf098, .immediate=0, .flags=0x80, .name = "LOSTALK" },
  { .ov = 17, .code = 0x224c, .word = 0xf0b0, .immediate=0, .flags=0x00, .name = "highness" },
  { .ov = 17, .code = 0x224c, .word = 0xf0fa, .immediate=0, .flags=0x00, .name = "(size)" },
  { .ov = 17, .code = 0x224c, .word = 0xf11e, .immediate=0, .flags=0x00, .name = "sizer" },
  { .ov = 17, .code = 0x224c, .word = 0xf14a, .immediate=0, .flags=0x00, .name = "smarts" },
  { .ov = 17, .code = 0x224c, .word = 0xf162, .immediate=0, .flags=0x00, .name = "set-size" },
  { .ov = 17, .code = 0x224c, .word = 0xf17a, .immediate=0, .flags=0x00, .name = "sculpts" },
  { .ov = 17, .code = 0x224c, .word = 0xf1b6, .immediate=0, .flags=0x00, .name = "?plant" },
  { .ov = 17, .code = 0x224c, .word = 0xf256, .immediate=0, .flags=0x00, .name = "?icky" },
  { .ov = 17, .code = 0x224c, .word = 0xf384, .immediate=0, .flags=0x00, .name = "?something" },
  { .ov = 17, .code = 0x224c, .word = 0xf4cc, .immediate=0, .flags=0x00, .name = "similarity" },
  { .ov = 17, .code = 0x224c, .word = 0xf4fe, .immediate=0, .flags=0x80, .name = "SPEC.PARM" },
  { .ov = 18, .code = 0x2214, .word = 0xe2c6, .immediate=0, .flags=0x00, .name = "WE2C6" },
  { .ov = 18, .code = 0x2214, .word = 0xe2ca, .immediate=0, .flags=0x00, .name = "WE2CA" },
  { .ov = 18, .code = 0x2214, .word = 0xe2ce, .immediate=0, .flags=0x00, .name = "WE2CE" },
  { .ov = 18, .code = 0x2214, .word = 0xe2d2, .immediate=0, .flags=0x00, .name = "WE2D2" },
  { .ov = 18, .code = 0x2214, .word = 0xe2d6, .immediate=0, .flags=0x00, .name = "WE2D6" },
  { .ov = 18, .code = 0x2214, .word = 0xe2da, .immediate=0, .flags=0x00, .name = "WE2DA" },
  { .ov = 18, .code = 0x224c, .word = 0xe2de, .immediate=0, .flags=0x00, .name = "WE2DE" },
  { .ov = 18, .code = 0x224c, .word = 0xe2e6, .immediate=0, .flags=0x00, .name = "WE2E6" },
  { .ov = 18, .code = 0x224c, .word = 0xe2f2, .immediate=0, .flags=0x00, .name = "WE2F2" },
  { .ov = 18, .code = 0x224c, .word = 0xe2fe, .immediate=0, .flags=0x00, .name = "WE2FE" },
  { .ov = 18, .code = 0x224c, .word = 0xe30a, .immediate=0, .flags=0x00, .name = "WE30A" },
  { .ov = 18, .code = 0xe312, .word = 0xe327, .immediate=0, .flags=0x80, .name = "CARDS" },
  { .ov = 18, .code = 0xe312, .word = 0xe370, .immediate=0, .flags=0x80, .name = "NICHE-SE" },
  { .ov = 18, .code = 0x224c, .word = 0xe39f, .immediate=0, .flags=0x00, .name = "WE39F" },
  { .ov = 18, .code = 0x224c, .word = 0xe3cf, .immediate=0, .flags=0x00, .name = "WE3CF" },
  { .ov = 18, .code = 0x224c, .word = 0xe3eb, .immediate=0, .flags=0x00, .name = "WE3EB" },
  { .ov = 18, .code = 0x224c, .word = 0xe407, .immediate=0, .flags=0x00, .name = "WE407" },
  { .ov = 18, .code = 0x224c, .word = 0xe413, .immediate=0, .flags=0x00, .name = "WE413" },
  { .ov = 18, .code = 0x224c, .word = 0xe41d, .immediate=0, .flags=0x00, .name = "WE41D" },
  { .ov = 18, .code = 0x224c, .word = 0xe429, .immediate=0, .flags=0x00, .name = "WE429" },
  { .ov = 18, .code = 0x2214, .word = 0xe431, .immediate=0, .flags=0x00, .name = "WE431" },
  { .ov = 18, .code = 0x224c, .word = 0xe435, .immediate=0, .flags=0x00, .name = "WE435" },
  { .ov = 18, .code = 0x1d29, .word = 0xe470, .immediate=0, .flags=0x80, .name = "PROBABLE" },
  { .ov = 18, .code = 0x224c, .word = 0xe474, .immediate=0, .flags=0x00, .name = "WE474" },
  { .ov = 18, .code = 0x224c, .word = 0xe47c, .immediate=0, .flags=0x00, .name = "WE47C" },
  { .ov = 18, .code = 0x224c, .word = 0xe488, .immediate=0, .flags=0x00, .name = "WE488" },
  { .ov = 18, .code = 0x73ea, .word = 0xe49f, .immediate=0, .flags=0x00, .name = "WE49F" },
  { .ov = 18, .code = 0x744d, .word = 0xe4ae, .immediate=0, .flags=0x80, .name = "HITS" },
  { .ov = 18, .code = 0x744d, .word = 0xe4b3, .immediate=0, .flags=0x00, .name = "WE4B3" },
  { .ov = 18, .code = 0x73ea, .word = 0xe4b8, .immediate=0, .flags=0x00, .name = "WE4B8" },
  { .ov = 18, .code = 0x73ea, .word = 0xe4c0, .immediate=0, .flags=0x00, .name = "WE4C0" },
  { .ov = 18, .code = 0x73ea, .word = 0xe4c8, .immediate=0, .flags=0x00, .name = "WE4C8" },
  { .ov = 18, .code = 0x73ea, .word = 0xe4d0, .immediate=0, .flags=0x00, .name = "WE4D0" },
  { .ov = 18, .code = 0x73ea, .word = 0xe4d8, .immediate=0, .flags=0x00, .name = "WE4D8" },
  { .ov = 18, .code = 0x73ea, .word = 0xe4e0, .immediate=0, .flags=0x00, .name = "WE4E0" },
  { .ov = 18, .code = 0x73ea, .word = 0xe4e8, .immediate=0, .flags=0x00, .name = "WE4E8" },
  { .ov = 18, .code = 0x73ea, .word = 0xe4f0, .immediate=0, .flags=0x00, .name = "WE4F0" },
  { .ov = 18, .code = 0x73ea, .word = 0xe4f8, .immediate=0, .flags=0x00, .name = "WE4F8" },
  { .ov = 18, .code = 0x73ea, .word = 0xe500, .immediate=0, .flags=0x00, .name = "WE500" },
  { .ov = 18, .code = 0x73ea, .word = 0xe508, .immediate=0, .flags=0x00, .name = "WE508" },
  { .ov = 18, .code = 0x73ea, .word = 0xe510, .immediate=0, .flags=0x00, .name = "WE510" },
  { .ov = 18, .code = 0x73ea, .word = 0xe518, .immediate=0, .flags=0x00, .name = "WE518" },
  { .ov = 18, .code = 0x73ea, .word = 0xe520, .immediate=0, .flags=0x00, .name = "WE520" },
  { .ov = 18, .code = 0x73ea, .word = 0xe528, .immediate=0, .flags=0x00, .name = "WE528" },
  { .ov = 18, .code = 0x73ea, .word = 0xe530, .immediate=0, .flags=0x00, .name = "WE530" },
  { .ov = 18, .code = 0x73ea, .word = 0xe538, .immediate=0, .flags=0x00, .name = "WE538" },
  { .ov = 18, .code = 0x73ea, .word = 0xe540, .immediate=0, .flags=0x00, .name = "WE540" },
  { .ov = 18, .code = 0x73ea, .word = 0xe548, .immediate=0, .flags=0x00, .name = "WE548" },
  { .ov = 18, .code = 0x73ea, .word = 0xe550, .immediate=0, .flags=0x00, .name = "WE550" },
  { .ov = 18, .code = 0x73ea, .word = 0xe558, .immediate=0, .flags=0x00, .name = "WE558" },
  { .ov = 18, .code = 0x73ea, .word = 0xe560, .immediate=0, .flags=0x00, .name = "WE560" },
  { .ov = 18, .code = 0x73ea, .word = 0xe568, .immediate=0, .flags=0x00, .name = "WE568" },
  { .ov = 18, .code = 0x73ea, .word = 0xe570, .immediate=0, .flags=0x00, .name = "WE570" },
  { .ov = 18, .code = 0x73ea, .word = 0xe578, .immediate=0, .flags=0x00, .name = "WE578" },
  { .ov = 18, .code = 0x73ea, .word = 0xe580, .immediate=0, .flags=0x00, .name = "WE580" },
  { .ov = 18, .code = 0x73ea, .word = 0xe588, .immediate=0, .flags=0x00, .name = "WE588" },
  { .ov = 18, .code = 0x73ea, .word = 0xe590, .immediate=0, .flags=0x00, .name = "WE590" },
  { .ov = 18, .code = 0x73ea, .word = 0xe598, .immediate=0, .flags=0x00, .name = "WE598" },
  { .ov = 18, .code = 0x73ea, .word = 0xe5a0, .immediate=0, .flags=0x00, .name = "WE5A0" },
  { .ov = 18, .code = 0x73ea, .word = 0xe5a8, .immediate=0, .flags=0x00, .name = "WE5A8" },
  { .ov = 18, .code = 0x73ea, .word = 0xe5b0, .immediate=0, .flags=0x00, .name = "WE5B0" },
  { .ov = 18, .code = 0x73ea, .word = 0xe5b8, .immediate=0, .flags=0x00, .name = "WE5B8" },
  { .ov = 18, .code = 0x73ea, .word = 0xe5c0, .immediate=0, .flags=0x00, .name = "WE5C0" },
  { .ov = 18, .code = 0x73ea, .word = 0xe5c8, .immediate=0, .flags=0x00, .name = "WE5C8" },
  { .ov = 18, .code = 0x73ea, .word = 0xe5d0, .immediate=0, .flags=0x00, .name = "WE5D0" },
  { .ov = 18, .code = 0x73ea, .word = 0xe5d8, .immediate=0, .flags=0x00, .name = "WE5D8" },
  { .ov = 18, .code = 0x73ea, .word = 0xe5e0, .immediate=0, .flags=0x00, .name = "WE5E0" },
  { .ov = 18, .code = 0x73ea, .word = 0xe5e8, .immediate=0, .flags=0x00, .name = "WE5E8" },
  { .ov = 18, .code = 0x73ea, .word = 0xe5f0, .immediate=0, .flags=0x00, .name = "WE5F0" },
  { .ov = 18, .code = 0x73ea, .word = 0xe5f8, .immediate=0, .flags=0x00, .name = "WE5F8" },
  { .ov = 18, .code = 0x73ea, .word = 0xe600, .immediate=0, .flags=0x00, .name = "WE600" },
  { .ov = 18, .code = 0x73ea, .word = 0xe608, .immediate=0, .flags=0x00, .name = "WE608" },
  { .ov = 18, .code = 0x73ea, .word = 0xe610, .immediate=0, .flags=0x00, .name = "WE610" },
  { .ov = 18, .code = 0x73ea, .word = 0xe618, .immediate=0, .flags=0x00, .name = "WE618" },
  { .ov = 18, .code = 0x73ea, .word = 0xe620, .immediate=0, .flags=0x00, .name = "WE620" },
  { .ov = 18, .code = 0x73ea, .word = 0xe628, .immediate=0, .flags=0x00, .name = "WE628" },
  { .ov = 18, .code = 0x73ea, .word = 0xe630, .immediate=0, .flags=0x00, .name = "WE630" },
  { .ov = 18, .code = 0x73ea, .word = 0xe638, .immediate=0, .flags=0x00, .name = "WE638" },
  { .ov = 18, .code = 0x73ea, .word = 0xe640, .immediate=0, .flags=0x00, .name = "WE640" },
  { .ov = 18, .code = 0x73ea, .word = 0xe648, .immediate=0, .flags=0x00, .name = "WE648" },
  { .ov = 18, .code = 0x73ea, .word = 0xe650, .immediate=0, .flags=0x00, .name = "WE650" },
  { .ov = 18, .code = 0x73ea, .word = 0xe658, .immediate=0, .flags=0x00, .name = "WE658" },
  { .ov = 18, .code = 0x73ea, .word = 0xe660, .immediate=0, .flags=0x00, .name = "WE660" },
  { .ov = 18, .code = 0x73ea, .word = 0xe668, .immediate=0, .flags=0x00, .name = "WE668" },
  { .ov = 18, .code = 0x73ea, .word = 0xe670, .immediate=0, .flags=0x00, .name = "WE670" },
  { .ov = 18, .code = 0x73ea, .word = 0xe678, .immediate=0, .flags=0x00, .name = "WE678" },
  { .ov = 18, .code = 0x744d, .word = 0xe680, .immediate=0, .flags=0x00, .name = "WE680" },
  { .ov = 18, .code = 0x744d, .word = 0xe685, .immediate=0, .flags=0x00, .name = "WE685" },
  { .ov = 18, .code = 0x744d, .word = 0xe68a, .immediate=0, .flags=0x00, .name = "WE68A" },
  { .ov = 18, .code = 0x224c, .word = 0xe68f, .immediate=0, .flags=0x00, .name = "WE68F" },
  { .ov = 18, .code = 0x224c, .word = 0xe69d, .immediate=0, .flags=0x00, .name = "WE69D" },
  { .ov = 18, .code = 0x224c, .word = 0xe6ab, .immediate=0, .flags=0x00, .name = "WE6AB" },
  { .ov = 18, .code = 0x3b68, .word = 0xe6bf, .immediate=0, .flags=0x00, .name = "WE6BF" },
  { .ov = 18, .code = 0x1d29, .word = 0xe6c5, .immediate=0, .flags=0x00, .name = "WE6C5" },
  { .ov = 18, .code = 0x1d29, .word = 0xe6c9, .immediate=0, .flags=0x00, .name = "WE6C9" },
  { .ov = 18, .code = 0x1d29, .word = 0xe863, .immediate=0, .flags=0x80, .name = "SHOW" },
  { .ov = 18, .code = 0x224c, .word = 0xe867, .immediate=0, .flags=0x00, .name = "WE867" },
  { .ov = 18, .code = 0x224c, .word = 0xe8b7, .immediate=0, .flags=0x00, .name = "WE8B7" },
  { .ov = 18, .code = 0x224c, .word = 0xe8c7, .immediate=0, .flags=0x00, .name = "WE8C7" },
  { .ov = 18, .code = 0x224c, .word = 0xe93d, .immediate=0, .flags=0x00, .name = "WE93D" },
  { .ov = 18, .code = 0x224c, .word = 0xe94b, .immediate=0, .flags=0x00, .name = "WE94B" },
  { .ov = 18, .code = 0x224c, .word = 0xe9e3, .immediate=0, .flags=0x00, .name = "WE9E3" },
  { .ov = 18, .code = 0x224c, .word = 0xea0d, .immediate=0, .flags=0x00, .name = "WEA0D" },
  { .ov = 18, .code = 0x224c, .word = 0xea1b, .immediate=0, .flags=0x00, .name = "WEA1B" },
  { .ov = 18, .code = 0x3b68, .word = 0xea2f, .immediate=0, .flags=0x00, .name = "WEA2F" },
  { .ov = 18, .code = 0x224c, .word = 0xea35, .immediate=0, .flags=0x00, .name = "WEA35" },
  { .ov = 18, .code = 0x224c, .word = 0xea3d, .immediate=0, .flags=0x00, .name = "WEA3D" },
  { .ov = 18, .code = 0x224c, .word = 0xea47, .immediate=0, .flags=0x00, .name = "WEA47" },
  { .ov = 18, .code = 0x1d29, .word = 0xea63, .immediate=0, .flags=0x00, .name = "WEA63" },
  { .ov = 18, .code = 0x224c, .word = 0xea67, .immediate=0, .flags=0x00, .name = "WEA67" },
  { .ov = 18, .code = 0xea73, .word = 0xea8e, .immediate=0, .flags=0x80, .name = "VTB" },
  { .ov = 18, .code = 0xea73, .word = 0xeaa3, .immediate=0, .flags=0x80, .name = "POSSESSI" },
  { .ov = 18, .code = 0xea73, .word = 0xeab7, .immediate=0, .flags=0x80, .name = "PRONOUN" },
  { .ov = 18, .code = 0xea73, .word = 0xeacc, .immediate=0, .flags=0x80, .name = "DETERMIN" },
  { .ov = 18, .code = 0xea73, .word = 0xeae1, .immediate=0, .flags=0x80, .name = "POSSES.P" },
  { .ov = 18, .code = 0x224c, .word = 0xeaeb, .immediate=0, .flags=0x00, .name = "WEAEB" },
  { .ov = 18, .code = 0x224c, .word = 0xeafb, .immediate=0, .flags=0x00, .name = "WEAFB" },
  { .ov = 18, .code = 0x224c, .word = 0xeb4d, .immediate=0, .flags=0x00, .name = "WEB4D" },
  { .ov = 18, .code = 0x224c, .word = 0xeb5f, .immediate=0, .flags=0x00, .name = "WEB5F" },
  { .ov = 18, .code = 0x224c, .word = 0xeb6f, .immediate=0, .flags=0x00, .name = "WEB6F" },
  { .ov = 18, .code = 0x224c, .word = 0xeb79, .immediate=0, .flags=0x00, .name = "WEB79" },
  { .ov = 18, .code = 0x224c, .word = 0xeb8b, .immediate=0, .flags=0x00, .name = "WEB8B" },
  { .ov = 18, .code = 0x224c, .word = 0xebb1, .immediate=0, .flags=0x00, .name = "WEBB1" },
  { .ov = 18, .code = 0x224c, .word = 0xebcf, .immediate=0, .flags=0x00, .name = "WEBCF" },
  { .ov = 18, .code = 0x224c, .word = 0xebdb, .immediate=0, .flags=0x00, .name = "WEBDB" },
  { .ov = 18, .code = 0x224c, .word = 0xec3b, .immediate=0, .flags=0x00, .name = "WEC3B" },
  { .ov = 18, .code = 0x224c, .word = 0xec53, .immediate=0, .flags=0x00, .name = "WEC53" },
  { .ov = 18, .code = 0x224c, .word = 0xec79, .immediate=0, .flags=0x00, .name = "WEC79" },
  { .ov = 18, .code = 0x224c, .word = 0xeca3, .immediate=0, .flags=0x00, .name = "WECA3" },
  { .ov = 18, .code = 0x224c, .word = 0xecc5, .immediate=0, .flags=0x00, .name = "WECC5" },
  { .ov = 18, .code = 0x224c, .word = 0xecfd, .immediate=0, .flags=0x00, .name = "WECFD" },
  { .ov = 18, .code = 0x224c, .word = 0xed2b, .immediate=0, .flags=0x00, .name = "WED2B" },
  { .ov = 18, .code = 0x224c, .word = 0xed59, .immediate=0, .flags=0x00, .name = "WED59" },
  { .ov = 18, .code = 0x224c, .word = 0xed95, .immediate=0, .flags=0x00, .name = "WED95" },
  { .ov = 18, .code = 0x224c, .word = 0xeded, .immediate=0, .flags=0x00, .name = "WEDED" },
  { .ov = 18, .code = 0x1d29, .word = 0xee55, .immediate=0, .flags=0x00, .name = "WEE55" },
  { .ov = 18, .code = 0x1d29, .word = 0xee67, .immediate=0, .flags=0x00, .name = "WEE67" },
  { .ov = 18, .code = 0x1d29, .word = 0xee79, .immediate=0, .flags=0x00, .name = "WEE79" },
  { .ov = 18, .code = 0x1d29, .word = 0xee8b, .immediate=0, .flags=0x00, .name = "WEE8B" },
  { .ov = 18, .code = 0x1d29, .word = 0xee9d, .immediate=0, .flags=0x00, .name = "WEE9D" },
  { .ov = 18, .code = 0x224c, .word = 0xeea1, .immediate=0, .flags=0x00, .name = "WEEA1" },
  { .ov = 18, .code = 0x1d29, .word = 0xeea9, .immediate=0, .flags=0x00, .name = "WEEA9" },
  { .ov = 18, .code = 0x224c, .word = 0xeead, .immediate=0, .flags=0x00, .name = "WEEAD" },
  { .ov = 18, .code = 0x224c, .word = 0xeecb, .immediate=0, .flags=0x00, .name = "WEECB" },
  { .ov = 18, .code = 0x224c, .word = 0xef83, .immediate=0, .flags=0x00, .name = "WEF83" },
  { .ov = 18, .code = 0xe963, .word = 0xefd2, .immediate=0, .flags=0x80, .name = "POSSIBIL" },
  { .ov = 18, .code = 0x224c, .word = 0xefec, .immediate=0, .flags=0x00, .name = "WEFEC" },
  { .ov = 18, .code = 0x224c, .word = 0xf06e, .immediate=0, .flags=0x00, .name = "WF06E" },
  { .ov = 18, .code = 0x224c, .word = 0xf0ce, .immediate=0, .flags=0x80, .name = "SAYIT" },
  { .ov = 18, .code = 0xe963, .word = 0xf0ee, .immediate=0, .flags=0x80, .name = "ANALOGS" },
  { .ov = 18, .code = 0x224c, .word = 0xf166, .immediate=0, .flags=0x00, .name = "WF166" },
  { .ov = 18, .code = 0x224c, .word = 0xf1ec, .immediate=0, .flags=0x00, .name = "WF1EC" },
  { .ov = 18, .code = 0x224c, .word = 0xf20e, .immediate=0, .flags=0x00, .name = "WF20E" },
  { .ov = 18, .code = 0x224c, .word = 0xf21e, .immediate=0, .flags=0x00, .name = "WF21E" },
  { .ov = 18, .code = 0x224c, .word = 0xf231, .immediate=0, .flags=0x00, .name = "WF231" },
  { .ov = 18, .code = 0x224c, .word = 0xf245, .immediate=0, .flags=0x00, .name = "WF245" },
  { .ov = 18, .code = 0x224c, .word = 0xf27b, .immediate=0, .flags=0x00, .name = "WF27B" },
  { .ov = 18, .code = 0x224c, .word = 0xf299, .immediate=0, .flags=0x00, .name = "WF299" },
  { .ov = 18, .code = 0x224c, .word = 0xf2bf, .immediate=0, .flags=0x00, .name = "WF2BF" },
  { .ov = 18, .code = 0x224c, .word = 0xf2cf, .immediate=0, .flags=0x00, .name = "WF2CF" },
  { .ov = 18, .code = 0x4a4f, .word = 0xf2ed, .immediate=0, .flags=0x80, .name = "CLASS>DE" },
  { .ov = 18, .code = 0x4a4f, .word = 0xf31e, .immediate=0, .flags=0x80, .name = "CLASS>TY" },
  { .ov = 18, .code = 0x224c, .word = 0xf34c, .immediate=0, .flags=0x80, .name = "?TALK" },
  { .ov = 19, .code = 0x2214, .word = 0xe7e6, .immediate=0, .flags=0x00, .name = "WE7E6" },
  { .ov = 19, .code = 0x744d, .word = 0xe7ea, .immediate=0, .flags=0x00, .name = "WE7EA" },
  { .ov = 19, .code = 0x744d, .word = 0xe7ef, .immediate=0, .flags=0x00, .name = "WE7EF" },
  { .ov = 19, .code = 0x744d, .word = 0xe7f4, .immediate=0, .flags=0x00, .name = "WE7F4" },
  { .ov = 19, .code = 0x224c, .word = 0xe7f9, .immediate=0, .flags=0x00, .name = "WE7F9" },
  { .ov = 19, .code = 0x224c, .word = 0xe807, .immediate=0, .flags=0x00, .name = "WE807" },
  { .ov = 19, .code = 0x224c, .word = 0xe815, .immediate=0, .flags=0x00, .name = "WE815" },
  { .ov = 19, .code = 0x224c, .word = 0xe829, .immediate=0, .flags=0x00, .name = "WE829" },
  { .ov = 19, .code = 0x224c, .word = 0xe83b, .immediate=0, .flags=0x00, .name = "WE83B" },
  { .ov = 19, .code = 0x744d, .word = 0xe869, .immediate=0, .flags=0x00, .name = "WE869" },
  { .ov = 19, .code = 0x744d, .word = 0xe86e, .immediate=0, .flags=0x00, .name = "WE86E" },
  { .ov = 19, .code = 0x224c, .word = 0xe873, .immediate=0, .flags=0x00, .name = "WE873" },
  { .ov = 19, .code = 0x224c, .word = 0xe88d, .immediate=0, .flags=0x00, .name = "WE88D" },
  { .ov = 19, .code = 0x224c, .word = 0xe8a5, .immediate=0, .flags=0x00, .name = "WE8A5" },
  { .ov = 19, .code = 0x224c, .word = 0xe8bf, .immediate=0, .flags=0x00, .name = "WE8BF" },
  { .ov = 19, .code = 0x224c, .word = 0xe8c9, .immediate=0, .flags=0x00, .name = "WE8C9" },
  { .ov = 19, .code = 0x224c, .word = 0xe8df, .immediate=0, .flags=0x00, .name = "WE8DF" },
  { .ov = 19, .code = 0x224c, .word = 0xe8f5, .immediate=0, .flags=0x00, .name = "WE8F5" },
  { .ov = 19, .code = 0x224c, .word = 0xe90d, .immediate=0, .flags=0x00, .name = "WE90D" },
  { .ov = 19, .code = 0x224c, .word = 0xe923, .immediate=0, .flags=0x00, .name = "WE923" },
  { .ov = 19, .code = 0x224c, .word = 0xe943, .immediate=0, .flags=0x00, .name = "WE943" },
  { .ov = 19, .code = 0x224c, .word = 0xe96b, .immediate=0, .flags=0x00, .name = "WE96B" },
  { .ov = 19, .code = 0x224c, .word = 0xe98f, .immediate=0, .flags=0x00, .name = "WE98F" },
  { .ov = 19, .code = 0x224c, .word = 0xe9b3, .immediate=0, .flags=0x00, .name = "WE9B3" },
  { .ov = 19, .code = 0x224c, .word = 0xe9d3, .immediate=0, .flags=0x00, .name = "WE9D3" },
  { .ov = 19, .code = 0x224c, .word = 0xe9e5, .immediate=0, .flags=0x00, .name = "WE9E5" },
  { .ov = 19, .code = 0x224c, .word = 0xe9f1, .immediate=0, .flags=0x00, .name = "WE9F1" },
  { .ov = 19, .code = 0x1d29, .word = 0xea3b, .immediate=0, .flags=0x00, .name = "WEA3B" },
  { .ov = 19, .code = 0x224c, .word = 0xea3f, .immediate=0, .flags=0x00, .name = "WEA3F" },
  { .ov = 19, .code = 0x224c, .word = 0xea67, .immediate=0, .flags=0x00, .name = "WEA67" },
  { .ov = 19, .code = 0x224c, .word = 0xea91, .immediate=0, .flags=0x00, .name = "WEA91" },
  { .ov = 19, .code = 0x224c, .word = 0xeb15, .immediate=0, .flags=0x00, .name = "WEB15" },
  { .ov = 19, .code = 0x224c, .word = 0xeb2b, .immediate=0, .flags=0x00, .name = "WEB2B" },
  { .ov = 19, .code = 0x224c, .word = 0xeba5, .immediate=0, .flags=0x00, .name = "WEBA5" },
  { .ov = 19, .code = 0x224c, .word = 0xebf3, .immediate=0, .flags=0x00, .name = "WEBF3" },
  { .ov = 19, .code = 0x224c, .word = 0xec1d, .immediate=0, .flags=0x00, .name = "WEC1D" },
  { .ov = 19, .code = 0x224c, .word = 0xec2b, .immediate=0, .flags=0x00, .name = "WEC2B" },
  { .ov = 19, .code = 0x224c, .word = 0xec53, .immediate=0, .flags=0x00, .name = "WEC53" },
  { .ov = 19, .code = 0x224c, .word = 0xec5b, .immediate=0, .flags=0x00, .name = "WEC5B" },
  { .ov = 19, .code = 0x1d29, .word = 0xec8d, .immediate=0, .flags=0x80, .name = "FUNCTIONS" },
  { .ov = 19, .code = 0x1d29, .word = 0xecbc, .immediate=0, .flags=0x00, .name = "WECBC" },
  { .ov = 19, .code = 0x224c, .word = 0xecc4, .immediate=0, .flags=0x00, .name = "WECC4" },
  { .ov = 19, .code = 0x224c, .word = 0xecec, .immediate=0, .flags=0x00, .name = "WECEC" },
  { .ov = 19, .code = 0x224c, .word = 0xecf4, .immediate=0, .flags=0x00, .name = "WECF4" },
  { .ov = 19, .code = 0x224c, .word = 0xed12, .immediate=0, .flags=0x00, .name = "WED12" },
  { .ov = 19, .code = 0x224c, .word = 0xed84, .immediate=0, .flags=0x80, .name = "HEAVEHO" },
  { .ov = 19, .code = 0x2214, .word = 0xed90, .immediate=0, .flags=0x00, .name = "WED90" },
  { .ov = 19, .code = 0x73ea, .word = 0xed94, .immediate=0, .flags=0x00, .name = "WED94" },
  { .ov = 19, .code = 0x224c, .word = 0xed9c, .immediate=0, .flags=0x00, .name = "WED9C" },
  { .ov = 19, .code = 0x224c, .word = 0xedd5, .immediate=0, .flags=0x80, .name = "TV-SETUP" },
  { .ov = 19, .code = 0x224c, .word = 0xede5, .immediate=0, .flags=0x00, .name = "WEDE5" },
  { .ov = 19, .code = 0x224c, .word = 0xedf7, .immediate=0, .flags=0x00, .name = "WEDF7" },
  { .ov = 19, .code = 0x224c, .word = 0xee1f, .immediate=0, .flags=0x00, .name = "WEE1F" },
  { .ov = 19, .code = 0x224c, .word = 0xee2b, .immediate=0, .flags=0x00, .name = "WEE2B" },
  { .ov = 19, .code = 0x224c, .word = 0xee39, .immediate=0, .flags=0x00, .name = "WEE39" },
  { .ov = 19, .code = 0x224c, .word = 0xeeab, .immediate=0, .flags=0x00, .name = "WEEAB" },
  { .ov = 19, .code = 0x224c, .word = 0xeefd, .immediate=0, .flags=0x00, .name = "WEEFD" },
  { .ov = 19, .code = 0x224c, .word = 0xef45, .immediate=0, .flags=0x00, .name = "WEF45" },
  { .ov = 19, .code = 0x224c, .word = 0xef63, .immediate=0, .flags=0x00, .name = "WEF63" },
  { .ov = 19, .code = 0x224c, .word = 0xef8f, .immediate=0, .flags=0x00, .name = "WEF8F" },
  { .ov = 19, .code = 0x224c, .word = 0xefeb, .immediate=0, .flags=0x00, .name = "WEFEB" },
  { .ov = 19, .code = 0x224c, .word = 0xefff, .immediate=0, .flags=0x00, .name = "WEFFF" },
  { .ov = 19, .code = 0x224c, .word = 0xf0a5, .immediate=0, .flags=0x00, .name = "WF0A5" },
  { .ov = 19, .code = 0x224c, .word = 0xf0e3, .immediate=0, .flags=0x00, .name = "WF0E3" },
  { .ov = 19, .code = 0x224c, .word = 0xf0f9, .immediate=0, .flags=0x00, .name = "WF0F9" },
  { .ov = 19, .code = 0x1d29, .word = 0xf130, .immediate=0, .flags=0x80, .name = "EYECON" },
  { .ov = 19, .code = 0x224c, .word = 0xf138, .immediate=0, .flags=0x00, .name = "WF138" },
  { .ov = 19, .code = 0x224c, .word = 0xf184, .immediate=0, .flags=0x00, .name = "WF184" },
  { .ov = 19, .code = 0x224c, .word = 0xf1ba, .immediate=0, .flags=0x00, .name = "WF1BA" },
  { .ov = 19, .code = 0x224c, .word = 0xf1d2, .immediate=0, .flags=0x00, .name = "WF1D2" },
  { .ov = 19, .code = 0x224c, .word = 0xf1fc, .immediate=0, .flags=0x00, .name = "WF1FC" },
  { .ov = 19, .code = 0x224c, .word = 0xf24e, .immediate=0, .flags=0x00, .name = "WF24E" },
  { .ov = 19, .code = 0x224c, .word = 0xf282, .immediate=0, .flags=0x80, .name = "WALK&TALK" },
  { .ov = 19, .code = 0x224c, .word = 0xf296, .immediate=0, .flags=0x00, .name = "WF296" },
  { .ov = 19, .code = 0x224c, .word = 0xf2ce, .immediate=0, .flags=0x00, .name = "WF2CE" },
  { .ov = 19, .code = 0x224c, .word = 0xf2ea, .immediate=0, .flags=0x80, .name = "TV-DISP" },
  { .ov = 19, .code = 0x224c, .word = 0xf375, .immediate=0, .flags=0x80, .name = "TV-CLEANU" },
  { .ov = 19, .code = 0x224c, .word = 0xf37b, .immediate=0, .flags=0x00, .name = "WF37B" },
  { .ov = 19, .code = 0x224c, .word = 0xf3ab, .immediate=0, .flags=0x00, .name = "WF3AB" },
  { .ov = 19, .code = 0x224c, .word = 0xf3b5, .immediate=0, .flags=0x00, .name = "WF3B5" },
  { .ov = 19, .code = 0x1d29, .word = 0xf435, .immediate=0, .flags=0x00, .name = "WF435" },
  { .ov = 19, .code = 0x224c, .word = 0xf439, .immediate=0, .flags=0x00, .name = "WF439" },
  { .ov = 19, .code = 0x224c, .word = 0xf44d, .immediate=0, .flags=0x00, .name = "WF44D" },
  { .ov = 19, .code = 0x224c, .word = 0xf477, .immediate=0, .flags=0x80, .name = "DO.WEAPON" },
  { .ov = 20, .code = 0x744d, .word = 0xd936, .immediate=0, .flags=0x00, .name = "PHRASE$" },
  { .ov = 20, .code = 0x224c, .word = 0xd93b, .immediate=0, .flags=0x00, .name = "WD93B" },
  { .ov = 20, .code = 0x744d, .word = 0xd94d, .immediate=0, .flags=0x00, .name = "LSC" },
  { .ov = 20, .code = 0x744d, .word = 0xd952, .immediate=0, .flags=0x00, .name = "LP" },
  { .ov = 20, .code = 0x744d, .word = 0xd957, .immediate=0, .flags=0x00, .name = "FC" },
  { .ov = 20, .code = 0x744d, .word = 0xd95c, .immediate=0, .flags=0x00, .name = "UA" },
  { .ov = 20, .code = 0x744d, .word = 0xd961, .immediate=0, .flags=0x00, .name = "DEDLN" },
  { .ov = 20, .code = 0x744d, .word = 0xd966, .immediate=0, .flags=0x00, .name = "DEDLY" },
  { .ov = 20, .code = 0x744d, .word = 0xd96b, .immediate=0, .flags=0x00, .name = "TC" },
  { .ov = 20, .code = 0x744d, .word = 0xd970, .immediate=0, .flags=0x00, .name = "T%" },
  { .ov = 20, .code = 0x744d, .word = 0xd975, .immediate=0, .flags=0x00, .name = "CSF" },
  { .ov = 20, .code = 0x744d, .word = 0xd97a, .immediate=0, .flags=0x00, .name = "BASE-EDL" },
  { .ov = 20, .code = 0x744d, .word = 0xd97f, .immediate=0, .flags=0x00, .name = "CPIC" },
  { .ov = 20, .code = 0x744d, .word = 0xd984, .immediate=0, .flags=0x00, .name = "AET" },
  { .ov = 20, .code = 0x744d, .word = 0xd989, .immediate=0, .flags=0x00, .name = "BET" },
  { .ov = 20, .code = 0x744d, .word = 0xd98e, .immediate=0, .flags=0x00, .name = "CET" },
  { .ov = 20, .code = 0x744d, .word = 0xd993, .immediate=0, .flags=0x00, .name = "OPE" },
  { .ov = 20, .code = 0x744d, .word = 0xd998, .immediate=0, .flags=0x00, .name = "FPE" },
  { .ov = 20, .code = 0x744d, .word = 0xd99d, .immediate=0, .flags=0x00, .name = "HPE" },
  { .ov = 20, .code = 0x744d, .word = 0xd9a2, .immediate=0, .flags=0x00, .name = "MSW" },
  { .ov = 20, .code = 0x744d, .word = 0xd9a7, .immediate=0, .flags=0x00, .name = "VST-PTR" },
  { .ov = 20, .code = 0x744d, .word = 0xd9ac, .immediate=0, .flags=0x00, .name = "COMM-SKILL" },
  { .ov = 20, .code = 0x744d, .word = 0xd9b1, .immediate=0, .flags=0x00, .name = "WD9B1" },
  { .ov = 20, .code = 0x744d, .word = 0xd9b6, .immediate=0, .flags=0x00, .name = "WD9B6" },
  { .ov = 20, .code = 0x744d, .word = 0xd9bb, .immediate=0, .flags=0x00, .name = "WD9BB" },
  { .ov = 20, .code = 0x744d, .word = 0xd9c0, .immediate=0, .flags=0x00, .name = "WD9C0" },
  { .ov = 20, .code = 0x744d, .word = 0xd9c5, .immediate=0, .flags=0x00, .name = "WD9C5" },
  { .ov = 20, .code = 0x744d, .word = 0xd9ca, .immediate=0, .flags=0x00, .name = "WD9CA" },
  { .ov = 20, .code = 0x744d, .word = 0xd9cf, .immediate=0, .flags=0x00, .name = "WD9CF" },
  { .ov = 20, .code = 0x744d, .word = 0xd9d4, .immediate=0, .flags=0x00, .name = "WD9D4" },
  { .ov = 20, .code = 0x744d, .word = 0xd9d9, .immediate=0, .flags=0x00, .name = "WD9D9" },
  { .ov = 20, .code = 0x744d, .word = 0xd9de, .immediate=0, .flags=0x00, .name = "WD9DE" },
  { .ov = 20, .code = 0x744d, .word = 0xd9e3, .immediate=0, .flags=0x00, .name = "WD9E3" },
  { .ov = 20, .code = 0x73ea, .word = 0xd9e8, .immediate=0, .flags=0x00, .name = "WD9E8" },
  { .ov = 20, .code = 0x73ea, .word = 0xd9f0, .immediate=0, .flags=0x00, .name = "WD9F0" },
  { .ov = 20, .code = 0x744d, .word = 0xd9f8, .immediate=0, .flags=0x00, .name = "WD9F8" },
  { .ov = 20, .code = 0x73ea, .word = 0xd9fd, .immediate=0, .flags=0x00, .name = "WD9FD" },
  { .ov = 20, .code = 0x1d29, .word = 0xda05, .immediate=0, .flags=0x00, .name = "(PHRASE)" },
  { .ov = 20, .code = 0x1d29, .word = 0xda0b, .immediate=0, .flags=0x00, .name = "HAILER" },
  { .ov = 20, .code = 0x2214, .word = 0xda0f, .immediate=0, .flags=0x00, .name = "?P-RESPOND" },
  { .ov = 20, .code = 0x1d29, .word = 0xda13, .immediate=0, .flags=0x00, .name = "P-POSTURE" },
  { .ov = 20, .code = 0x1d29, .word = 0xda17, .immediate=0, .flags=0x00, .name = "P-POSTURES" },
  { .ov = 20, .code = 0x1d29, .word = 0xda1b, .immediate=0, .flags=0x00, .name = "P-SUBJECT" },
  { .ov = 20, .code = 0x1d29, .word = 0xda1f, .immediate=0, .flags=0x00, .name = "P-QUES" },
  { .ov = 20, .code = 0x1d29, .word = 0xda23, .immediate=0, .flags=0x00, .name = "P-PHRASES" },
  { .ov = 20, .code = 0x1d29, .word = 0xda27, .immediate=0, .flags=0x00, .name = "A-SUBJECT" },
  { .ov = 20, .code = 0x1d29, .word = 0xda2b, .immediate=0, .flags=0x00, .name = "#A-PHRASES" },
  { .ov = 20, .code = 0x1d29, .word = 0xda2f, .immediate=0, .flags=0x00, .name = "POSTURE" },
  { .ov = 20, .code = 0x1d29, .word = 0xda33, .immediate=0, .flags=0x00, .name = "LAST-LEN" },
  { .ov = 20, .code = 0x2214, .word = 0xda37, .immediate=0, .flags=0x00, .name = "WDA37" },
  { .ov = 20, .code = 0x2214, .word = 0xda3b, .immediate=0, .flags=0x00, .name = "WDA3B" },
  { .ov = 20, .code = 0x1d29, .word = 0xda3f, .immediate=0, .flags=0x00, .name = "SUBJECT" },
  { .ov = 20, .code = 0x1d29, .word = 0xda43, .immediate=0, .flags=0x00, .name = "#A-HAILS" },
  { .ov = 20, .code = 0x1d29, .word = 0xda47, .immediate=0, .flags=0x00, .name = "#A-PHRASES-LIMIT" },
  { .ov = 20, .code = 0x1d29, .word = 0xda4b, .immediate=0, .flags=0x00, .name = "LEAST-USED" },
  { .ov = 20, .code = 0x1d29, .word = 0xda4f, .immediate=0, .flags=0x00, .name = "TIRED-TIME" },
  { .ov = 20, .code = 0x2214, .word = 0xda55, .immediate=0, .flags=0x00, .name = "?WAITING-FOR-ANSWER" },
  { .ov = 20, .code = 0x1d29, .word = 0xda59, .immediate=0, .flags=0x00, .name = "SPACIAL-CONTEXT" },
  { .ov = 20, .code = 0x2214, .word = 0xda5d, .immediate=0, .flags=0x00, .name = "?A-TALKING" },
  { .ov = 20, .code = 0x2214, .word = 0xda61, .immediate=0, .flags=0x00, .name = "WDA61" },
  { .ov = 20, .code = 0x1d29, .word = 0xda65, .immediate=0, .flags=0x00, .name = "WDA65" },
  { .ov = 20, .code = 0x1d29, .word = 0xda69, .immediate=0, .flags=0x00, .name = "%TALK" },
  { .ov = 20, .code = 0x2214, .word = 0xda6d, .immediate=0, .flags=0x00, .name = "?HAS-SURRENDERED" },
  { .ov = 20, .code = 0x1d29, .word = 0xda71, .immediate=0, .flags=0x00, .name = "ALIEN-RACE" },
  { .ov = 20, .code = 0x2214, .word = 0xda75, .immediate=0, .flags=0x00, .name = "?CALLED" },
  { .ov = 20, .code = 0x2214, .word = 0xda79, .immediate=0, .flags=0x00, .name = "?SCANNED" },
  { .ov = 20, .code = 0x1d29, .word = 0xda7d, .immediate=0, .flags=0x00, .name = "A-CAPT" },
  { .ov = 20, .code = 0x1d29, .word = 0xda8f, .immediate=0, .flags=0x00, .name = "A-SHIP" },
  { .ov = 20, .code = 0x1d29, .word = 0xdaa1, .immediate=0, .flags=0x00, .name = "P-CAPT" },
  { .ov = 20, .code = 0x1d29, .word = 0xdab3, .immediate=0, .flags=0x00, .name = "P-SHIP" },
  { .ov = 20, .code = 0x1d29, .word = 0xdac5, .immediate=0, .flags=0x00, .name = "A-QUES" },
  { .ov = 20, .code = 0x1d29, .word = 0xdacb, .immediate=0, .flags=0x00, .name = "COMM-OFF-SKILL" },
  { .ov = 20, .code = 0x1d29, .word = 0xdacf, .immediate=0, .flags=0x00, .name = "COMM-RACE" },
  { .ov = 20, .code = 0x2214, .word = 0xdad3, .immediate=0, .flags=0x00, .name = "P-STRENGTH" },
  { .ov = 20, .code = 0x1d29, .word = 0xdad7, .immediate=0, .flags=0x00, .name = "(LOCK-OUT)" },
  { .ov = 20, .code = 0x1d29, .word = 0xdadb, .immediate=0, .flags=0x00, .name = "CTCNT" },
  { .ov = 20, .code = 0x2214, .word = 0xdadf, .immediate=0, .flags=0x00, .name = "OBSEQUIOUS" },
  { .ov = 20, .code = 0x2214, .word = 0xdae3, .immediate=0, .flags=0x00, .name = "FRIENDLY" },
  { .ov = 20, .code = 0x2214, .word = 0xdae7, .immediate=0, .flags=0x00, .name = "NEUTRAL" },
  { .ov = 20, .code = 0x2214, .word = 0xdaeb, .immediate=0, .flags=0x00, .name = "HOSTILE" },
  { .ov = 20, .code = 0x2214, .word = 0xdaef, .immediate=0, .flags=0x00, .name = "FIGHT" },
  { .ov = 20, .code = 0x2214, .word = 0xdaf3, .immediate=0, .flags=0x00, .name = "THEMSELVES" },
  { .ov = 20, .code = 0x2214, .word = 0xdaf7, .immediate=0, .flags=0x00, .name = "OTHER_RACES" },
  { .ov = 20, .code = 0x2214, .word = 0xdafb, .immediate=0, .flags=0x00, .name = "GEN'L-INFO" },
  { .ov = 20, .code = 0x2214, .word = 0xdaff, .immediate=0, .flags=0x00, .name = "ANCIENTS" },
  { .ov = 20, .code = 0x2214, .word = 0xdb03, .immediate=0, .flags=0x00, .name = "OLD-EMPIRE" },
  { .ov = 20, .code = 0x744d, .word = 0xdb07, .immediate=0, .flags=0x00, .name = "WDB07" },
  { .ov = 20, .code = 0x224c, .word = 0xdb0c, .immediate=0, .flags=0x00, .name = "WDB0C" },
  { .ov = 20, .code = 0x224c, .word = 0xdb23, .immediate=0, .flags=0x80, .name = "ORIGINATOR>C" },
  { .ov = 20, .code = 0x224c, .word = 0xdb48, .immediate=0, .flags=0x80, .name = "A>ORIGINATOR" },
  { .ov = 20, .code = 0x224c, .word = 0xdb6a, .immediate=0, .flags=0x00, .name = "P>ORIGINATOR" },
  { .ov = 20, .code = 0x224c, .word = 0xdb84, .immediate=0, .flags=0x00, .name = "PHRASE>C" },
  { .ov = 20, .code = 0x224c, .word = 0xdb8c, .immediate=0, .flags=0x00, .name = "DELTA-NO" },
  { .ov = 20, .code = 0x224c, .word = 0xdb9a, .immediate=0, .flags=0x00, .name = "DELTA-YES" },
  { .ov = 20, .code = 0x224c, .word = 0xdba8, .immediate=0, .flags=0x00, .name = "!A-SUBJECT" },
  { .ov = 20, .code = 0x4a4f, .word = 0xdbbb, .immediate=0, .flags=0x80, .name = "P>AFIELD" },
  { .ov = 20, .code = 0x224c, .word = 0xdbc9, .immediate=0, .flags=0x00, .name = "POSTURE-EFFECT" },
  { .ov = 20, .code = 0x224c, .word = 0xdbdb, .immediate=0, .flags=0x00, .name = "(>BUTTON)" },
  { .ov = 20, .code = 0x224c, .word = 0xdbeb, .immediate=0, .flags=0x00, .name = ">BUTTON" },
  { .ov = 20, .code = 0x224c, .word = 0xdbff, .immediate=0, .flags=0x00, .name = "CAPT:" },
  { .ov = 20, .code = 0x3b68, .word = 0xdc0b, .immediate=0, .flags=0x00, .name = "OP#" },
  { .ov = 20, .code = 0x3b68, .word = 0xdc11, .immediate=0, .flags=0x00, .name = "FP#" },
  { .ov = 20, .code = 0x3b68, .word = 0xdc17, .immediate=0, .flags=0x00, .name = "NP#" },
  { .ov = 20, .code = 0x3b68, .word = 0xdc1d, .immediate=0, .flags=0x00, .name = "HP#" },
  { .ov = 20, .code = 0x4a4f, .word = 0xdc2a, .immediate=0, .flags=0x80, .name = "#PHR" },
  { .ov = 20, .code = 0x224c, .word = 0xdc40, .immediate=0, .flags=0x00, .name = "GET-PHRASE-LIMIT" },
  { .ov = 20, .code = 0x4a4f, .word = 0xdc59, .immediate=0, .flags=0x80, .name = "N-POSTURE" },
  { .ov = 20, .code = 0x224c, .word = 0xdc6f, .immediate=0, .flags=0x00, .name = "EDL>POSTURE" },
  { .ov = 20, .code = 0x224c, .word = 0xdcd7, .immediate=0, .flags=0x00, .name = "WDCD7" },
  { .ov = 20, .code = 0x224c, .word = 0xdce9, .immediate=0, .flags=0x80, .name = "+!EDL" },
  { .ov = 20, .code = 0x224c, .word = 0xdd47, .immediate=0, .flags=0x00, .name = "SET-OK-TIME" },
  { .ov = 20, .code = 0x224c, .word = 0xdd69, .immediate=0, .flags=0x00, .name = "SET-TIRED-TIME" },
  { .ov = 20, .code = 0x224c, .word = 0xdd7d, .immediate=0, .flags=0x00, .name = "?LOCKED-OUT" },
  { .ov = 20, .code = 0x224c, .word = 0xddbf, .immediate=0, .flags=0x00, .name = "FIND-PHRASE" },
  { .ov = 20, .code = 0x224c, .word = 0xde11, .immediate=0, .flags=0x00, .name = "?SPACE<>SUBJ" },
  { .ov = 20, .code = 0x224c, .word = 0xde2b, .immediate=0, .flags=0x00, .name = "FIND-SUBJECT" },
  { .ov = 20, .code = 0x224c, .word = 0xde6d, .immediate=0, .flags=0x00, .name = "PHRASE-SEARCH" },
  { .ov = 20, .code = 0x224c, .word = 0xdea9, .immediate=0, .flags=0x00, .name = "COMM$" },
  { .ov = 20, .code = 0x224c, .word = 0xdebb, .immediate=0, .flags=0x00, .name = "]COMM$" },
  { .ov = 20, .code = 0x224c, .word = 0xdec7, .immediate=0, .flags=0x00, .name = ">RESPOND$" },
  { .ov = 20, .code = 0x224c, .word = 0xdee2, .immediate=0, .flags=0x80, .name = ">HAIL$" },
  { .ov = 20, .code = 0x224c, .word = 0xdef4, .immediate=0, .flags=0x00, .name = "PAD+WORD" },
  { .ov = 20, .code = 0x224c, .word = 0xdf14, .immediate=0, .flags=0x00, .name = "HASH-WORD" },
  { .ov = 20, .code = 0x1d29, .word = 0xdf32, .immediate=0, .flags=0x00, .name = "A-SYLLABLES" },
  { .ov = 20, .code = 0x224c, .word = 0xe014, .immediate=0, .flags=0x00, .name = "MOVE-SYLLABLES" },
  { .ov = 20, .code = 0x224c, .word = 0xe05a, .immediate=0, .flags=0x00, .name = "A-SYLL" },
  { .ov = 20, .code = 0x224c, .word = 0xe068, .immediate=0, .flags=0x00, .name = "A-WORD" },
  { .ov = 20, .code = 0x4a4f, .word = 0xe0b4, .immediate=0, .flags=0x80, .name = "O>P" },
  { .ov = 20, .code = 0x224c, .word = 0xe0c6, .immediate=0, .flags=0x00, .name = "?SCRAMBLE" },
  { .ov = 20, .code = 0x224c, .word = 0xe0f8, .immediate=0, .flags=0x00, .name = "TERMINATE" },
  { .ov = 20, .code = 0x224c, .word = 0xe10c, .immediate=0, .flags=0x00, .name = "A>TERMINATE" },
  { .ov = 20, .code = 0x4a4f, .word = 0xe11c, .immediate=0, .flags=0x80, .name = "ACTION-CASE" },
  { .ov = 20, .code = 0x224c, .word = 0xe12a, .immediate=0, .flags=0x00, .name = "DO-UA" },
  { .ov = 20, .code = 0x224c, .word = 0xe160, .immediate=0, .flags=0x00, .name = "-LEADING" },
  { .ov = 20, .code = 0x224c, .word = 0xe190, .immediate=0, .flags=0x00, .name = "PARSE" },
  { .ov = 20, .code = 0x224c, .word = 0xe1e4, .immediate=0, .flags=0x00, .name = "+1CHAR" },
  { .ov = 20, .code = 0x224c, .word = 0xe1f0, .immediate=0, .flags=0x00, .name = "WE1F0" },
  { .ov = 20, .code = 0x224c, .word = 0xe246, .immediate=0, .flags=0x00, .name = "?WORD-FIT" },
  { .ov = 20, .code = 0x224c, .word = 0xe261, .immediate=0, .flags=0x80, .name = "CTSCROLL" },
  { .ov = 20, .code = 0x224c, .word = 0xe2a5, .immediate=0, .flags=0x00, .name = "WORD>CT" },
  { .ov = 20, .code = 0x224c, .word = 0xe2e9, .immediate=0, .flags=0x00, .name = "ANAME" },
  { .ov = 20, .code = 0x224c, .word = 0xe2f7, .immediate=0, .flags=0x00, .name = "ASHIP" },
  { .ov = 20, .code = 0x224c, .word = 0xe305, .immediate=0, .flags=0x00, .name = "CNAME" },
  { .ov = 20, .code = 0x224c, .word = 0xe313, .immediate=0, .flags=0x00, .name = "SNAME" },
  { .ov = 20, .code = 0x224c, .word = 0xe329, .immediate=0, .flags=0x00, .name = ">ENDOPTION" },
  { .ov = 20, .code = 0x224c, .word = 0xe34b, .immediate=0, .flags=0x00, .name = "OPTION$" },
  { .ov = 20, .code = 0x224c, .word = 0xe365, .immediate=0, .flags=0x00, .name = "YOU$" },
  { .ov = 20, .code = 0x224c, .word = 0xe379, .immediate=0, .flags=0x00, .name = "OTHER$" },
  { .ov = 20, .code = 0x224c, .word = 0xe38f, .immediate=0, .flags=0x00, .name = "OEMP" },
  { .ov = 20, .code = 0x224c, .word = 0xe3ac, .immediate=0, .flags=0x00, .name = "ANC$" },
  { .ov = 20, .code = 0x224c, .word = 0xe3c3, .immediate=0, .flags=0x00, .name = "NO$" },
  { .ov = 20, .code = 0x4a4f, .word = 0xe3d0, .immediate=0, .flags=0x80, .name = "(?SUBJECT)" },
  { .ov = 20, .code = 0x224c, .word = 0xe3e6, .immediate=0, .flags=0x00, .name = "?SUBJECT" },
  { .ov = 20, .code = 0x4a4f, .word = 0xe3f6, .immediate=0, .flags=0x80, .name = "SPECIAL-CASE" },
  { .ov = 20, .code = 0x224c, .word = 0xe41c, .immediate=0, .flags=0x00, .name = "SPECIAL" },
  { .ov = 20, .code = 0x224c, .word = 0xe446, .immediate=0, .flags=0x80, .name = "(PHRASE>CT)" },
  { .ov = 20, .code = 0x224c, .word = 0xe482, .immediate=0, .flags=0x00, .name = "PHRASE>CT" },
  { .ov = 20, .code = 0x1d29, .word = 0xe4b2, .immediate=0, .flags=0x00, .name = "?COMM-BTNS" },
  { .ov = 20, .code = 0x224c, .word = 0xe4b6, .immediate=0, .flags=0x00, .name = "!A-SUBJECT+" },
  { .ov = 20, .code = 0x224c, .word = 0xe4d4, .immediate=0, .flags=0x00, .name = "+5>EDL" },
  { .ov = 20, .code = 0x224c, .word = 0xe4dc, .immediate=0, .flags=0x00, .name = "WE4DC" },
  { .ov = 20, .code = 0x224c, .word = 0xe4e6, .immediate=0, .flags=0x00, .name = "WE4E6" },
  { .ov = 20, .code = 0x224c, .word = 0xe4f0, .immediate=0, .flags=0x00, .name = "WE4F0" },
  { .ov = 20, .code = 0x224c, .word = 0xe4fa, .immediate=0, .flags=0x00, .name = "+4/9>EDL" },
  { .ov = 20, .code = 0x224c, .word = 0xe514, .immediate=0, .flags=0x00, .name = "WE514" },
  { .ov = 20, .code = 0x224c, .word = 0xe51e, .immediate=0, .flags=0x00, .name = "YES>EDL" },
  { .ov = 20, .code = 0x224c, .word = 0xe526, .immediate=0, .flags=0x00, .name = "NO-EDL" },
  { .ov = 20, .code = 0x224c, .word = 0xe52e, .immediate=0, .flags=0x00, .name = "NEW-POSTURE>EDL" },
  { .ov = 20, .code = 0x224c, .word = 0xe546, .immediate=0, .flags=0x00, .name = "RESPOND>EDL" },
  { .ov = 20, .code = 0x224c, .word = 0xe554, .immediate=0, .flags=0x00, .name = "STATEMENT-EDL" },
  { .ov = 20, .code = 0x224c, .word = 0xe562, .immediate=0, .flags=0x00, .name = "WE562" },
  { .ov = 20, .code = 0x224c, .word = 0xe57e, .immediate=0, .flags=0x00, .name = "@T%" },
  { .ov = 20, .code = 0x224c, .word = 0xe58c, .immediate=0, .flags=0x00, .name = "#!%TALK" },
  { .ov = 20, .code = 0x224c, .word = 0xe5a0, .immediate=0, .flags=0x00, .name = "!%TALK" },
  { .ov = 20, .code = 0x224c, .word = 0xe5a8, .immediate=0, .flags=0x00, .name = "1.5*T%" },
  { .ov = 20, .code = 0x224c, .word = 0xe5b2, .immediate=0, .flags=0x00, .name = "2*T%" },
  { .ov = 20, .code = 0x224c, .word = 0xe5bc, .immediate=0, .flags=0x00, .name = "2.5>T%" },
  { .ov = 20, .code = 0x224c, .word = 0xe5c6, .immediate=0, .flags=0x00, .name = "1*T%" },
  { .ov = 20, .code = 0x224c, .word = 0xe5d0, .immediate=0, .flags=0x00, .name = "0.5*T%" },
  { .ov = 20, .code = 0x224c, .word = 0xe5da, .immediate=0, .flags=0x00, .name = "70>T%" },
  { .ov = 20, .code = 0x224c, .word = 0xe5e4, .immediate=0, .flags=0x00, .name = "100>T%" },
  { .ov = 20, .code = 0x224c, .word = 0xe5ee, .immediate=0, .flags=0x00, .name = "0>T%" },
  { .ov = 20, .code = 0x224c, .word = 0xe5f6, .immediate=0, .flags=0x00, .name = "CAPT:" },
  { .ov = 20, .code = 0x224c, .word = 0xe609, .immediate=0, .flags=0x00, .name = "WE609" },
  { .ov = 20, .code = 0x224c, .word = 0xe61a, .immediate=0, .flags=0x00, .name = "RAISE-SHIELDS" },
  { .ov = 20, .code = 0x224c, .word = 0xe632, .immediate=0, .flags=0x00, .name = "LOWER-SHIELDS" },
  { .ov = 20, .code = 0x224c, .word = 0xe64a, .immediate=0, .flags=0x00, .name = "ARM-WEAPONS" },
  { .ov = 20, .code = 0x224c, .word = 0xe662, .immediate=0, .flags=0x00, .name = "DISARM-WEAPONS" },
  { .ov = 20, .code = 0x224c, .word = 0xe67a, .immediate=0, .flags=0x00, .name = "CALL-FOR-SHIPS" },
  { .ov = 20, .code = 0x224c, .word = 0xe690, .immediate=0, .flags=0x00, .name = "SHIPS-ARRIVE" },
  { .ov = 20, .code = 0x224c, .word = 0xe6ac, .immediate=0, .flags=0x00, .name = "SCAN-PLAYER" },
  { .ov = 20, .code = 0x224c, .word = 0xe6c2, .immediate=0, .flags=0x00, .name = "HAIL" },
  { .ov = 20, .code = 0x224c, .word = 0xe6f2, .immediate=0, .flags=0x00, .name = "RESPOND" },
  { .ov = 20, .code = 0x224c, .word = 0xe706, .immediate=0, .flags=0x00, .name = "ANSWER" },
  { .ov = 20, .code = 0x224c, .word = 0xe71c, .immediate=0, .flags=0x00, .name = "STATEMENT" },
  { .ov = 20, .code = 0x224c, .word = 0xe72e, .immediate=0, .flags=0x00, .name = "QUESTION" },
  { .ov = 20, .code = 0x224c, .word = 0xe762, .immediate=0, .flags=0x00, .name = "TIRED-OF-WAITING" },
  { .ov = 20, .code = 0x224c, .word = 0xe774, .immediate=0, .flags=0x00, .name = "TIRED-OF-TALKING" },
  { .ov = 20, .code = 0x224c, .word = 0xe780, .immediate=0, .flags=0x00, .name = "WE780" },
  { .ov = 20, .code = 0x4a4f, .word = 0xe798, .immediate=0, .flags=0x80, .name = "(?RACE)" },
  { .ov = 20, .code = 0x224c, .word = 0xe7be, .immediate=0, .flags=0x00, .name = "WE7BE" },
  { .ov = 20, .code = 0x224c, .word = 0xe7c8, .immediate=0, .flags=0x00, .name = "?OBSEQUIOUS" },
  { .ov = 20, .code = 0x224c, .word = 0xe7d0, .immediate=0, .flags=0x00, .name = "?FRIENDLY" },
  { .ov = 20, .code = 0x224c, .word = 0xe7d8, .immediate=0, .flags=0x00, .name = "?NEUTRAL" },
  { .ov = 20, .code = 0x224c, .word = 0xe7e0, .immediate=0, .flags=0x00, .name = "?HOSTILE" },
  { .ov = 20, .code = 0x224c, .word = 0xe7e8, .immediate=0, .flags=0x00, .name = "?FIGHT" },
  { .ov = 20, .code = 0x224c, .word = 0xe7f2, .immediate=0, .flags=0x00, .name = "TALKATIVENESS" },
  { .ov = 20, .code = 0x224c, .word = 0xe7fe, .immediate=0, .flags=0x00, .name = "?TIRED-OF-TALKING" },
  { .ov = 20, .code = 0x224c, .word = 0xe80e, .immediate=0, .flags=0x00, .name = "WE80E" },
  { .ov = 20, .code = 0x224c, .word = 0xe83a, .immediate=0, .flags=0x00, .name = "WE83A" },
  { .ov = 20, .code = 0x224c, .word = 0xe850, .immediate=0, .flags=0x00, .name = "WE850" },
  { .ov = 20, .code = 0x224c, .word = 0xe868, .immediate=0, .flags=0x00, .name = "?OK-TO-TALK" },
  { .ov = 20, .code = 0x224c, .word = 0xe8b6, .immediate=0, .flags=0x00, .name = "?REPEAT" },
  { .ov = 20, .code = 0x224c, .word = 0xe8c2, .immediate=0, .flags=0x00, .name = "WE8C2" },
  { .ov = 20, .code = 0x224c, .word = 0xe8d0, .immediate=0, .flags=0x00, .name = "WE8D0" },
  { .ov = 20, .code = 0x224c, .word = 0xe8de, .immediate=0, .flags=0x00, .name = "?SHIELDS-UP" },
  { .ov = 20, .code = 0x224c, .word = 0xe8ea, .immediate=0, .flags=0x00, .name = "?SHIELDS-FLAG" },
  { .ov = 20, .code = 0x224c, .word = 0xe906, .immediate=0, .flags=0x00, .name = "?WEAPON-ARMED" },
  { .ov = 20, .code = 0x224c, .word = 0xe912, .immediate=0, .flags=0x00, .name = "?WEAPON-FLAG" },
  { .ov = 20, .code = 0x224c, .word = 0xe92e, .immediate=0, .flags=0x00, .name = "?P-HAILED" },
  { .ov = 20, .code = 0x224c, .word = 0xe93a, .immediate=0, .flags=0x00, .name = "?A-HAILED" },
  { .ov = 20, .code = 0x224c, .word = 0xe946, .immediate=0, .flags=0x00, .name = "?TIRED-OF-WAITING" },
  { .ov = 20, .code = 0x224c, .word = 0xe954, .immediate=0, .flags=0x00, .name = "?WANT-TO-TALK" },
  { .ov = 20, .code = 0x224c, .word = 0xe962, .immediate=0, .flags=0x00, .name = "?P-STATEMENT" },
  { .ov = 20, .code = 0x224c, .word = 0xe970, .immediate=0, .flags=0x00, .name = "?WAS-QUESTIONED" },
  { .ov = 20, .code = 0x224c, .word = 0xe97c, .immediate=0, .flags=0x00, .name = "?NEW-POSTURE" },
  { .ov = 20, .code = 0x224c, .word = 0xe98c, .immediate=0, .flags=0x00, .name = "<3SHIPS" },
  { .ov = 20, .code = 0x224c, .word = 0xe998, .immediate=0, .flags=0x00, .name = "?IN-COMM" },
  { .ov = 20, .code = 0x224c, .word = 0xe9b6, .immediate=0, .flags=0x00, .name = "?TERMINATED" },
  { .ov = 20, .code = 0x224c, .word = 0xe9c2, .immediate=0, .flags=0x00, .name = "?ALIEN-RACE-6" },
  { .ov = 20, .code = 0x224c, .word = 0xe9ce, .immediate=0, .flags=0x00, .name = "?MAKE-STATEMENT" },
  { .ov = 20, .code = 0x224c, .word = 0xea0c, .immediate=0, .flags=0x00, .name = "?CAN-SURRENDER" },
  { .ov = 20, .code = 0x224c, .word = 0xea24, .immediate=0, .flags=0x00, .name = "WEA24" },
  { .ov = 20, .code = 0x224c, .word = 0xea36, .immediate=0, .flags=0x00, .name = "WEA36" },
  { .ov = 20, .code = 0xb869, .word = 0xea48, .immediate=0, .flags=0x80, .name = "<EDL>" },
  { .ov = 20, .code = 0xb869, .word = 0xeabc, .immediate=0, .flags=0x80, .name = "<TALK>" },
  { .ov = 20, .code = 0xb869, .word = 0xeb70, .immediate=0, .flags=0x80, .name = "<AUX>" },
  { .ov = 20, .code = 0xb869, .word = 0xec15, .immediate=0, .flags=0x80, .name = "<COMM>" },
  { .ov = 20, .code = 0x224c, .word = 0xeca9, .immediate=0, .flags=0x00, .name = "WECA9" },
  { .ov = 20, .code = 0x224c, .word = 0xecbf, .immediate=0, .flags=0x00, .name = "P-PHRASE" },
  { .ov = 20, .code = 0x224c, .word = 0xeceb, .immediate=0, .flags=0x00, .name = "STOP-COMM" },
  { .ov = 20, .code = 0x224c, .word = 0xecf3, .immediate=0, .flags=0x00, .name = "?TRIG" },
  { .ov = 20, .code = 0x744d, .word = 0xed23, .immediate=0, .flags=0x00, .name = "WED23" },
  { .ov = 20, .code = 0x224c, .word = 0xed28, .immediate=0, .flags=0x00, .name = "WED28" },
  { .ov = 20, .code = 0x1d29, .word = 0xed72, .immediate=0, .flags=0x00, .name = "WED72" },
  { .ov = 20, .code = 0x224c, .word = 0xed77, .immediate=0, .flags=0x00, .name = ">P-POSTURE" },
  { .ov = 20, .code = 0x4a4f, .word = 0xeda6, .immediate=0, .flags=0x80, .name = "(>?)" },
  { .ov = 20, .code = 0x224c, .word = 0xedbc, .immediate=0, .flags=0x00, .name = ">QUESTION" },
  { .ov = 20, .code = 0x224c, .word = 0xedea, .immediate=0, .flags=0x00, .name = ">STATEMENT" },
  { .ov = 20, .code = 0x4a4f, .word = 0xedfe, .immediate=0, .flags=0x80, .name = ">CM" },
  { .ov = 20, .code = 0x224c, .word = 0xee10, .immediate=0, .flags=0x00, .name = ">YES" },
  { .ov = 20, .code = 0x224c, .word = 0xee23, .immediate=0, .flags=0x00, .name = ">NO" },
  { .ov = 20, .code = 0x224c, .word = 0xee35, .immediate=0, .flags=0x00, .name = ">IMPATIENT" },
  { .ov = 20, .code = 0x224c, .word = 0xee41, .immediate=0, .flags=0x00, .name = ">TERMINATE" },
  { .ov = 20, .code = 0x4a4f, .word = 0xee50, .immediate=0, .flags=0x80, .name = ">Y/N" },
  { .ov = 20, .code = 0x224c, .word = 0xee62, .immediate=0, .flags=0x00, .name = ">HAIL" },
  { .ov = 20, .code = 0x224c, .word = 0xee7c, .immediate=0, .flags=0x00, .name = ">RESPOND" },
  { .ov = 20, .code = 0x224c, .word = 0xee9e, .immediate=0, .flags=0x80, .name = "EDL+AUX" },
  { .ov = 20, .code = 0x224c, .word = 0xeed1, .immediate=0, .flags=0x80, .name = "COMM-EXPERTS" },
  { .ov = 20, .code = 0x224c, .word = 0xeefd, .immediate=0, .flags=0x00, .name = ".COMM-PIC" },
  { .ov = 20, .code = 0x224c, .word = 0xef2d, .immediate=0, .flags=0x00, .name = "WEF2D" },
  { .ov = 20, .code = 0x224c, .word = 0xef6d, .immediate=0, .flags=0x00, .name = "WEF6D" },
  { .ov = 20, .code = 0x224c, .word = 0xef9d, .immediate=0, .flags=0x00, .name = "WEF9D" },
  { .ov = 20, .code = 0x224c, .word = 0xefc3, .immediate=0, .flags=0x00, .name = "WEFC3" },
  { .ov = 20, .code = 0x224c, .word = 0xf061, .immediate=0, .flags=0x00, .name = "COMM-LOOP2" },
  { .ov = 20, .code = 0x224c, .word = 0xf0d5, .immediate=0, .flags=0x00, .name = "COMMUNICATE" },
  { .ov = 20, .code = 0x4a4f, .word = 0xf130, .immediate=0, .flags=0x80, .name = "(CBTN)" },
  { .ov = 20, .code = 0x224c, .word = 0xf13e, .immediate=0, .flags=0x00, .name = "WF13E" },
  { .ov = 20, .code = 0x224c, .word = 0xf174, .immediate=0, .flags=0x80, .name = "CL1" },
  { .ov = 20, .code = 0x224c, .word = 0xf228, .immediate=0, .flags=0x00, .name = "INIT_ACOMM" },
  { .ov = 20, .code = 0x224c, .word = 0xf27a, .immediate=0, .flags=0x00, .name = "WF27A" },
  { .ov = 20, .code = 0x224c, .word = 0xf330, .immediate=0, .flags=0x00, .name = "INIT_GCOMM" },
  { .ov = 20, .code = 0x224c, .word = 0xf3c2, .immediate=0, .flags=0x00, .name = "INIT-MCOMM" },
  { .ov = 20, .code = 0x224c, .word = 0xf444, .immediate=0, .flags=0x80, .name = "IAPWR" },
  { .ov = 20, .code = 0x224c, .word = 0xf4b0, .immediate=0, .flags=0x00, .name = "WF4B0" },
  { .ov = 20, .code = 0x224c, .word = 0xf4c6, .immediate=0, .flags=0x00, .name = "WF4C6" },
  { .ov = 20, .code = 0x224c, .word = 0xf53a, .immediate=0, .flags=0x80, .name = "ICOMM" },
  { .ov = 21, .code = 0x224c, .word = 0xea46, .immediate=0, .flags=0x00, .name = "?ARTIFACT" },
  { .ov = 21, .code = 0x224c, .word = 0xea50, .immediate=0, .flags=0x00, .name = "WEA50" },
  { .ov = 21, .code = 0x224c, .word = 0xea70, .immediate=0, .flags=0x00, .name = "A>ORIGINATOR" },
  { .ov = 21, .code = 0x224c, .word = 0xea7a, .immediate=0, .flags=0x00, .name = "ORIGINATOR>C" },
  { .ov = 21, .code = 0x224c, .word = 0xea84, .immediate=0, .flags=0x00, .name = "+!EDL" },
  { .ov = 21, .code = 0x224c, .word = 0xea8e, .immediate=0, .flags=0x00, .name = "WEA8E" },
  { .ov = 21, .code = 0x744d, .word = 0xeaa0, .immediate=0, .flags=0x00, .name = "BASE-EDL" },
  { .ov = 21, .code = 0x744d, .word = 0xeaa5, .immediate=0, .flags=0x00, .name = "AET" },
  { .ov = 21, .code = 0x744d, .word = 0xeaaa, .immediate=0, .flags=0x00, .name = "WEAAA" },
  { .ov = 21, .code = 0x3b68, .word = 0xeaaf, .immediate=0, .flags=0x00, .name = "WEAAF" },
  { .ov = 21, .code = 0x3b68, .word = 0xeab5, .immediate=0, .flags=0x00, .name = "WEAB5" },
  { .ov = 21, .code = 0x3b68, .word = 0xeabb, .immediate=0, .flags=0x00, .name = "WEABB" },
  { .ov = 21, .code = 0x224c, .word = 0xeac1, .immediate=0, .flags=0x00, .name = "WEAC1" },
  { .ov = 21, .code = 0x224c, .word = 0xeadc, .immediate=0, .flags=0x00, .name = "(PHRASE>CT)" },
  { .ov = 21, .code = 0x224c, .word = 0xeaee, .immediate=0, .flags=0x00, .name = "WEAEE" },
  { .ov = 21, .code = 0x224c, .word = 0xeb3f, .immediate=0, .flags=0x00, .name = "WEB3F" },
  { .ov = 21, .code = 0x224c, .word = 0xeb7b, .immediate=0, .flags=0x00, .name = "(>BUTTON)" },
  { .ov = 21, .code = 0x4a4f, .word = 0xeb94, .immediate=0, .flags=0x80, .name = "?VOWEL" },
  { .ov = 21, .code = 0x224c, .word = 0xebae, .immediate=0, .flags=0x00, .name = "WEBAE" },
  { .ov = 21, .code = 0x224c, .word = 0xebb6, .immediate=0, .flags=0x00, .name = "WEBB6" },
  { .ov = 21, .code = 0x224c, .word = 0xebc4, .immediate=0, .flags=0x00, .name = "WEBC4" },
  { .ov = 21, .code = 0x1d29, .word = 0xebce, .immediate=0, .flags=0x00, .name = "QTY" },
  { .ov = 21, .code = 0x224c, .word = 0xebd2, .immediate=0, .flags=0x00, .name = "WEBD2" },
  { .ov = 21, .code = 0x224c, .word = 0xebe6, .immediate=0, .flags=0x00, .name = "?>=ELEMENT" },
  { .ov = 21, .code = 0x224c, .word = 0xec24, .immediate=0, .flags=0x00, .name = "WEC24" },
  { .ov = 21, .code = 0x224c, .word = 0xec36, .immediate=0, .flags=0x00, .name = "WEC36" },
  { .ov = 21, .code = 0x224c, .word = 0xec4e, .immediate=0, .flags=0x00, .name = "+ELEMENT" },
  { .ov = 21, .code = 0x224c, .word = 0xec6e, .immediate=0, .flags=0x00, .name = "+ELEMENT" },
  { .ov = 21, .code = 0x224c, .word = 0xec8e, .immediate=0, .flags=0x00, .name = "-ARTIFACT" },
  { .ov = 21, .code = 0x224c, .word = 0xecba, .immediate=0, .flags=0x00, .name = "WECBA" },
  { .ov = 21, .code = 0x1d29, .word = 0xecca, .immediate=0, .flags=0x00, .name = "STOP-SA" },
  { .ov = 21, .code = 0x224c, .word = 0xecce, .immediate=0, .flags=0x00, .name = "VPROBE#" },
  { .ov = 21, .code = 0x224c, .word = 0xeda7, .immediate=0, .flags=0x00, .name = "WEDA7" },
  { .ov = 21, .code = 0x224c, .word = 0xeddb, .immediate=0, .flags=0x00, .name = "WEDDB" },
  { .ov = 21, .code = 0x224c, .word = 0xee17, .immediate=0, .flags=0x00, .name = "WEE17" },
  { .ov = 21, .code = 0x224c, .word = 0xee3f, .immediate=0, .flags=0x00, .name = "WEE3F" },
  { .ov = 21, .code = 0x224c, .word = 0xee73, .immediate=0, .flags=0x00, .name = "WEE73" },
  { .ov = 21, .code = 0x224c, .word = 0xeeb6, .immediate=0, .flags=0x80, .name = "XY/N" },
  { .ov = 21, .code = 0x1d29, .word = 0xef26, .immediate=0, .flags=0x00, .name = "WEF26" },
  { .ov = 21, .code = 0x224c, .word = 0xef2a, .immediate=0, .flags=0x00, .name = "WEF2A" },
  { .ov = 21, .code = 0x224c, .word = 0xef36, .immediate=0, .flags=0x00, .name = "WEF36" },
  { .ov = 21, .code = 0x224c, .word = 0xefb4, .immediate=0, .flags=0x00, .name = "ORB#" },
  { .ov = 21, .code = 0x224c, .word = 0xefc0, .immediate=0, .flags=0x00, .name = "CRYSTAL-ORB" },
  { .ov = 21, .code = 0x1d29, .word = 0xf002, .immediate=0, .flags=0x00, .name = "EnQTY" },
  { .ov = 21, .code = 0x224c, .word = 0xf006, .immediate=0, .flags=0x00, .name = "PLUTONIUM$" },
  { .ov = 21, .code = 0x224c, .word = 0xf012, .immediate=0, .flags=0x00, .name = "PLUTONIUM" },
  { .ov = 21, .code = 0x2214, .word = 0xf08a, .immediate=0, .flags=0x00, .name = "WF08A" },
  { .ov = 21, .code = 0x224c, .word = 0xf08e, .immediate=0, .flags=0x00, .name = "WF08E" },
  { .ov = 21, .code = 0x224c, .word = 0xf09a, .immediate=0, .flags=0x00, .name = "WF09A" },
  { .ov = 21, .code = 0x224c, .word = 0xf0a6, .immediate=0, .flags=0x00, .name = "NEED-ENERGY" },
  { .ov = 21, .code = 0x224c, .word = 0xf124, .immediate=0, .flags=0x00, .name = "WF124" },
  { .ov = 21, .code = 0x224c, .word = 0xf130, .immediate=0, .flags=0x00, .name = "WF130" },
  { .ov = 21, .code = 0x224c, .word = 0xf15c, .immediate=0, .flags=0x00, .name = "WF15C" },
  { .ov = 21, .code = 0x224c, .word = 0xf168, .immediate=0, .flags=0x00, .name = "WF168" },
  { .ov = 21, .code = 0x224c, .word = 0xf174, .immediate=0, .flags=0x00, .name = "WF174" },
  { .ov = 21, .code = 0x224c, .word = 0xf1c6, .immediate=0, .flags=0x00, .name = "WF1C6" },
  { .ov = 21, .code = 0x224c, .word = 0xf1d2, .immediate=0, .flags=0x00, .name = "WF1D2" },
  { .ov = 21, .code = 0x224c, .word = 0xf24e, .immediate=0, .flags=0x00, .name = "WF24E" },
  { .ov = 21, .code = 0x224c, .word = 0xf25a, .immediate=0, .flags=0x00, .name = "WF25A" },
  { .ov = 21, .code = 0x224c, .word = 0xf2aa, .immediate=0, .flags=0x00, .name = "WF2AA" },
  { .ov = 21, .code = 0x224c, .word = 0xf312, .immediate=0, .flags=0x00, .name = "WF312" },
  { .ov = 21, .code = 0x224c, .word = 0xf396, .immediate=0, .flags=0x00, .name = "WF396" },
  { .ov = 21, .code = 0x224c, .word = 0xf3a2, .immediate=0, .flags=0x00, .name = "WF3A2" },
  { .ov = 21, .code = 0x224c, .word = 0xf3fc, .immediate=0, .flags=0x00, .name = "WF3FC" },
  { .ov = 21, .code = 0x224c, .word = 0xf408, .immediate=0, .flags=0x00, .name = "WF408" },
  { .ov = 21, .code = 0x224c, .word = 0xf414, .immediate=0, .flags=0x00, .name = "WF414" },
  { .ov = 21, .code = 0x1d29, .word = 0xf454, .immediate=0, .flags=0x00, .name = "SA-ELOWAN" },
  { .ov = 21, .code = 0x1d29, .word = 0xf45f, .immediate=0, .flags=0x00, .name = "SA-THRYNN" },
  { .ov = 21, .code = 0x1d29, .word = 0xf46c, .immediate=0, .flags=0x00, .name = "SA-VELOX" },
  { .ov = 21, .code = 0x1d29, .word = 0xf475, .immediate=0, .flags=0x00, .name = "SA-MECHAN" },
  { .ov = 21, .code = 0x1d29, .word = 0xf47a, .immediate=0, .flags=0x00, .name = "SA-VPROBE" },
  { .ov = 21, .code = 0x1d29, .word = 0xf47f, .immediate=0, .flags=0x00, .name = "WF47F" },
  { .ov = 21, .code = 0x224c, .word = 0xf486, .immediate=0, .flags=0x00, .name = "DO-SA" },
  { .ov = 21, .code = 0x4a4f, .word = 0xf4c0, .immediate=0, .flags=0x80, .name = "SA-CASE" },
  { .ov = 21, .code = 0x224c, .word = 0xf4de, .immediate=0, .flags=0x00, .name = "WF4DE" },
  { .ov = 21, .code = 0x224c, .word = 0xf4fe, .immediate=0, .flags=0x80, .name = "(XCOMM)" },
  { .ov = 22, .code = 0x2214, .word = 0xec16, .immediate=0, .flags=0x00, .name = "WEC16" },
  { .ov = 22, .code = 0x2214, .word = 0xec1a, .immediate=0, .flags=0x00, .name = "WEC1A" },
  { .ov = 22, .code = 0x2214, .word = 0xec1e, .immediate=0, .flags=0x00, .name = "WEC1E" },
  { .ov = 22, .code = 0x2214, .word = 0xec22, .immediate=0, .flags=0x00, .name = "WEC22" },
  { .ov = 22, .code = 0x73ea, .word = 0xec26, .immediate=0, .flags=0x00, .name = "WEC26" },
  { .ov = 22, .code = 0x73ea, .word = 0xec2e, .immediate=0, .flags=0x00, .name = "WEC2E" },
  { .ov = 22, .code = 0x1d29, .word = 0xec36, .immediate=0, .flags=0x00, .name = "WEC36" },
  { .ov = 22, .code = 0x73ea, .word = 0xec3a, .immediate=0, .flags=0x00, .name = "WEC3A" },
  { .ov = 22, .code = 0x73ea, .word = 0xec42, .immediate=0, .flags=0x00, .name = "WEC42" },
  { .ov = 22, .code = 0x73ea, .word = 0xec4a, .immediate=0, .flags=0x00, .name = "WEC4A" },
  { .ov = 22, .code = 0x73ea, .word = 0xec52, .immediate=0, .flags=0x00, .name = "WEC52" },
  { .ov = 22, .code = 0x73ea, .word = 0xec5a, .immediate=0, .flags=0x00, .name = "WEC5A" },
  { .ov = 22, .code = 0x744d, .word = 0xec62, .immediate=0, .flags=0x00, .name = "WEC62" },
  { .ov = 22, .code = 0x73ea, .word = 0xec67, .immediate=0, .flags=0x00, .name = "WEC67" },
  { .ov = 22, .code = 0x73ea, .word = 0xec6f, .immediate=0, .flags=0x00, .name = "WEC6F" },
  { .ov = 22, .code = 0x744d, .word = 0xec77, .immediate=0, .flags=0x00, .name = "WEC77" },
  { .ov = 22, .code = 0x744d, .word = 0xec7c, .immediate=0, .flags=0x00, .name = "WEC7C" },
  { .ov = 22, .code = 0x73ea, .word = 0xec81, .immediate=0, .flags=0x00, .name = "WEC81" },
  { .ov = 22, .code = 0x744d, .word = 0xec89, .immediate=0, .flags=0x00, .name = "WEC89" },
  { .ov = 22, .code = 0x744d, .word = 0xec8e, .immediate=0, .flags=0x00, .name = "WEC8E" },
  { .ov = 22, .code = 0x744d, .word = 0xec93, .immediate=0, .flags=0x00, .name = "WEC93" },
  { .ov = 22, .code = 0x73ea, .word = 0xec98, .immediate=0, .flags=0x00, .name = "WEC98" },
  { .ov = 22, .code = 0x73ea, .word = 0xeca0, .immediate=0, .flags=0x00, .name = "WECA0" },
  { .ov = 22, .code = 0x744d, .word = 0xeca8, .immediate=0, .flags=0x00, .name = "WECA8" },
  { .ov = 22, .code = 0x224c, .word = 0xecad, .immediate=0, .flags=0x00, .name = "WECAD" },
  { .ov = 22, .code = 0x224c, .word = 0xecb9, .immediate=0, .flags=0x00, .name = "WECB9" },
  { .ov = 22, .code = 0x224c, .word = 0xecc3, .immediate=0, .flags=0x00, .name = "WECC3" },
  { .ov = 22, .code = 0x224c, .word = 0xeccf, .immediate=0, .flags=0x00, .name = "WECCF" },
  { .ov = 22, .code = 0x224c, .word = 0xecdd, .immediate=0, .flags=0x00, .name = "WECDD" },
  { .ov = 22, .code = 0x224c, .word = 0xecfb, .immediate=0, .flags=0x00, .name = "WECFB" },
  { .ov = 22, .code = 0x224c, .word = 0xed19, .immediate=0, .flags=0x00, .name = "WED19" },
  { .ov = 22, .code = 0x224c, .word = 0xed31, .immediate=0, .flags=0x00, .name = "WED31" },
  { .ov = 22, .code = 0x224c, .word = 0xed3d, .immediate=0, .flags=0x00, .name = "WED3D" },
  { .ov = 22, .code = 0x224c, .word = 0xed49, .immediate=0, .flags=0x00, .name = "WED49" },
  { .ov = 22, .code = 0x224c, .word = 0xed5b, .immediate=0, .flags=0x00, .name = "WED5B" },
  { .ov = 22, .code = 0x224c, .word = 0xed79, .immediate=0, .flags=0x00, .name = "WED79" },
  { .ov = 22, .code = 0x224c, .word = 0xed8b, .immediate=0, .flags=0x00, .name = "WED8B" },
  { .ov = 22, .code = 0x224c, .word = 0xed9d, .immediate=0, .flags=0x00, .name = "WED9D" },
  { .ov = 22, .code = 0x224c, .word = 0xedaf, .immediate=0, .flags=0x00, .name = "WEDAF" },
  { .ov = 22, .code = 0x224c, .word = 0xede1, .immediate=0, .flags=0x00, .name = "WEDE1" },
  { .ov = 22, .code = 0x224c, .word = 0xee01, .immediate=0, .flags=0x00, .name = "WEE01" },
  { .ov = 22, .code = 0x224c, .word = 0xee15, .immediate=0, .flags=0x00, .name = "WEE15" },
  { .ov = 22, .code = 0x224c, .word = 0xee4d, .immediate=0, .flags=0x00, .name = "WEE4D" },
  { .ov = 22, .code = 0x224c, .word = 0xee91, .immediate=0, .flags=0x00, .name = "WEE91" },
  { .ov = 22, .code = 0x73ea, .word = 0xeecd, .immediate=0, .flags=0x00, .name = "WEECD" },
  { .ov = 22, .code = 0x73ea, .word = 0xeed5, .immediate=0, .flags=0x00, .name = "WEED5" },
  { .ov = 22, .code = 0x73ea, .word = 0xeedd, .immediate=0, .flags=0x00, .name = "WEEDD" },
  { .ov = 22, .code = 0x73ea, .word = 0xeee5, .immediate=0, .flags=0x00, .name = "WEEE5" },
  { .ov = 22, .code = 0x73ea, .word = 0xeeed, .immediate=0, .flags=0x00, .name = "WEEED" },
  { .ov = 22, .code = 0x73ea, .word = 0xeef5, .immediate=0, .flags=0x00, .name = "WEEF5" },
  { .ov = 22, .code = 0x73ea, .word = 0xeefd, .immediate=0, .flags=0x00, .name = "WEEFD" },
  { .ov = 22, .code = 0x73ea, .word = 0xef05, .immediate=0, .flags=0x00, .name = "WEF05" },
  { .ov = 22, .code = 0x73ea, .word = 0xef0d, .immediate=0, .flags=0x00, .name = "WEF0D" },
  { .ov = 22, .code = 0x73ea, .word = 0xef15, .immediate=0, .flags=0x00, .name = "WEF15" },
  { .ov = 22, .code = 0x73ea, .word = 0xef1d, .immediate=0, .flags=0x00, .name = "WEF1D" },
  { .ov = 22, .code = 0x73ea, .word = 0xef25, .immediate=0, .flags=0x00, .name = "WEF25" },
  { .ov = 22, .code = 0x73ea, .word = 0xef2d, .immediate=0, .flags=0x00, .name = "WEF2D" },
  { .ov = 22, .code = 0x73ea, .word = 0xef35, .immediate=0, .flags=0x00, .name = "WEF35" },
  { .ov = 22, .code = 0x73ea, .word = 0xef3d, .immediate=0, .flags=0x00, .name = "WEF3D" },
  { .ov = 22, .code = 0x73ea, .word = 0xef45, .immediate=0, .flags=0x00, .name = "WEF45" },
  { .ov = 22, .code = 0x73ea, .word = 0xef4d, .immediate=0, .flags=0x00, .name = "WEF4D" },
  { .ov = 22, .code = 0x73ea, .word = 0xef55, .immediate=0, .flags=0x00, .name = "WEF55" },
  { .ov = 22, .code = 0x73ea, .word = 0xef5d, .immediate=0, .flags=0x00, .name = "WEF5D" },
  { .ov = 22, .code = 0x73ea, .word = 0xef65, .immediate=0, .flags=0x00, .name = "WEF65" },
  { .ov = 22, .code = 0x73ea, .word = 0xef6d, .immediate=0, .flags=0x00, .name = "WEF6D" },
  { .ov = 22, .code = 0x224c, .word = 0xef75, .immediate=0, .flags=0x00, .name = "WEF75" },
  { .ov = 22, .code = 0x224c, .word = 0xef89, .immediate=0, .flags=0x00, .name = "WEF89" },
  { .ov = 22, .code = 0x224c, .word = 0xefc5, .immediate=0, .flags=0x00, .name = "WEFC5" },
  { .ov = 22, .code = 0x224c, .word = 0xf001, .immediate=0, .flags=0x00, .name = "WF001" },
  { .ov = 22, .code = 0x224c, .word = 0xf00b, .immediate=0, .flags=0x00, .name = "WF00B" },
  { .ov = 22, .code = 0x224c, .word = 0xf02b, .immediate=0, .flags=0x00, .name = "WF02B" },
  { .ov = 22, .code = 0x224c, .word = 0xf079, .immediate=0, .flags=0x00, .name = "WF079" },
  { .ov = 22, .code = 0x224c, .word = 0xf0c7, .immediate=0, .flags=0x00, .name = "WF0C7" },
  { .ov = 22, .code = 0x224c, .word = 0xf0f7, .immediate=0, .flags=0x00, .name = "WF0F7" },
  { .ov = 22, .code = 0x224c, .word = 0xf143, .immediate=0, .flags=0x00, .name = "WF143" },
  { .ov = 22, .code = 0x224c, .word = 0xf163, .immediate=0, .flags=0x00, .name = "WF163" },
  { .ov = 22, .code = 0x224c, .word = 0xf189, .immediate=0, .flags=0x00, .name = "WF189" },
  { .ov = 22, .code = 0x224c, .word = 0xf19b, .immediate=0, .flags=0x00, .name = "WF19B" },
  { .ov = 22, .code = 0x224c, .word = 0xf1c1, .immediate=0, .flags=0x00, .name = "WF1C1" },
  { .ov = 22, .code = 0x224c, .word = 0xf207, .immediate=0, .flags=0x00, .name = "WF207" },
  { .ov = 22, .code = 0x224c, .word = 0xf245, .immediate=0, .flags=0x00, .name = "WF245" },
  { .ov = 22, .code = 0x224c, .word = 0xf26b, .immediate=0, .flags=0x00, .name = "WF26B" },
  { .ov = 22, .code = 0x224c, .word = 0xf29f, .immediate=0, .flags=0x00, .name = "WF29F" },
  { .ov = 22, .code = 0x224c, .word = 0xf2bb, .immediate=0, .flags=0x00, .name = "WF2BB" },
  { .ov = 22, .code = 0x224c, .word = 0xf2ed, .immediate=0, .flags=0x00, .name = "WF2ED" },
  { .ov = 22, .code = 0x224c, .word = 0xf30d, .immediate=0, .flags=0x00, .name = "WF30D" },
  { .ov = 22, .code = 0x224c, .word = 0xf31b, .immediate=0, .flags=0x00, .name = "WF31B" },
  { .ov = 22, .code = 0x224c, .word = 0xf327, .immediate=0, .flags=0x00, .name = "WF327" },
  { .ov = 22, .code = 0x224c, .word = 0xf35c, .immediate=0, .flags=0x80, .name = "?EXIST" },
  { .ov = 22, .code = 0x224c, .word = 0xf3e2, .immediate=0, .flags=0x00, .name = "WF3E2" },
  { .ov = 22, .code = 0x224c, .word = 0xf3ec, .immediate=0, .flags=0x00, .name = "WF3EC" },
  { .ov = 22, .code = 0x224c, .word = 0xf3f6, .immediate=0, .flags=0x00, .name = "WF3F6" },
  { .ov = 22, .code = 0x224c, .word = 0xf400, .immediate=0, .flags=0x00, .name = "WF400" },
  { .ov = 22, .code = 0x224c, .word = 0xf42c, .immediate=0, .flags=0x00, .name = "WF42C" },
  { .ov = 22, .code = 0x224c, .word = 0xf442, .immediate=0, .flags=0x00, .name = "WF442" },
  { .ov = 22, .code = 0x224c, .word = 0xf454, .immediate=0, .flags=0x00, .name = "WF454" },
  { .ov = 22, .code = 0x224c, .word = 0xf468, .immediate=0, .flags=0x00, .name = "WF468" },
  { .ov = 22, .code = 0x224c, .word = 0xf492, .immediate=0, .flags=0x00, .name = "WF492" },
  { .ov = 22, .code = 0x224c, .word = 0xf4d3, .immediate=0, .flags=0x80, .name = "POPULA" },
  { .ov = 23, .code = 0x224c, .word = 0xf2a6, .immediate=0, .flags=0x00, .name = "altitude" },
  { .ov = 23, .code = 0x224c, .word = 0xf34f, .immediate=0, .flags=0x00, .name = "ICON-KEY" },
  { .ov = 23, .code = 0x224c, .word = 0xf3c6, .immediate=0, .flags=0x00, .name = ".BLT" },
  { .ov = 23, .code = 0x224c, .word = 0xf3f2, .immediate=0, .flags=0x00, .name = "PAUSE-PAGE" },
  { .ov = 23, .code = 0x224c, .word = 0xf42c, .immediate=0, .flags=0x00, .name = "SEE-BLTS" },
  { .ov = 23, .code = 0x224c, .word = 0xf48a, .immediate=0, .flags=0x00, .name = "title" },
  { .ov = 23, .code = 0x224c, .word = 0xf49e, .immediate=0, .flags=0x80, .name = "ICONS" },
  { .ov = 24, .code = 0x224c, .word = 0xe696, .immediate=0, .flags=0x00, .name = "WE696" },
  { .ov = 24, .code = 0x224c, .word = 0xe6c6, .immediate=0, .flags=0x00, .name = "WE6C6" },
  { .ov = 24, .code = 0x224c, .word = 0xe6e0, .immediate=0, .flags=0x00, .name = "WE6E0" },
  { .ov = 24, .code = 0x224c, .word = 0xe702, .immediate=0, .flags=0x00, .name = "WE702" },
  { .ov = 24, .code = 0x224c, .word = 0xe71c, .immediate=0, .flags=0x00, .name = "WE71C" },
  { .ov = 24, .code = 0x224c, .word = 0xe724, .immediate=0, .flags=0x00, .name = "WE724" },
  { .ov = 24, .code = 0x224c, .word = 0xe74c, .immediate=0, .flags=0x00, .name = "WE74C" },
  { .ov = 24, .code = 0x224c, .word = 0xe770, .immediate=0, .flags=0x00, .name = "WE770" },
  { .ov = 24, .code = 0x224c, .word = 0xe794, .immediate=0, .flags=0x00, .name = "WE794" },
  { .ov = 24, .code = 0x224c, .word = 0xe7a0, .immediate=0, .flags=0x00, .name = "WE7A0" },
  { .ov = 24, .code = 0x224c, .word = 0xe7ac, .immediate=0, .flags=0x00, .name = "WE7AC" },
  { .ov = 24, .code = 0x224c, .word = 0xe7b8, .immediate=0, .flags=0x00, .name = "WE7B8" },
  { .ov = 24, .code = 0x744d, .word = 0xe7c4, .immediate=0, .flags=0x00, .name = "WE7C4" },
  { .ov = 24, .code = 0x744d, .word = 0xe7c9, .immediate=0, .flags=0x00, .name = "WE7C9" },
  { .ov = 24, .code = 0x224c, .word = 0xe7ce, .immediate=0, .flags=0x00, .name = "WE7CE" },
  { .ov = 24, .code = 0x224c, .word = 0xe7e8, .immediate=0, .flags=0x00, .name = "WE7E8" },
  { .ov = 24, .code = 0x224c, .word = 0xe802, .immediate=0, .flags=0x00, .name = "WE802" },
  { .ov = 24, .code = 0x224c, .word = 0xe85e, .immediate=0, .flags=0x00, .name = "WE85E" },
  { .ov = 24, .code = 0x224c, .word = 0xe87e, .immediate=0, .flags=0x00, .name = "WE87E" },
  { .ov = 24, .code = 0x224c, .word = 0xe89a, .immediate=0, .flags=0x80, .name = "SET-SPEED" },
  { .ov = 24, .code = 0x224c, .word = 0xe8c6, .immediate=0, .flags=0x00, .name = "WE8C6" },
  { .ov = 24, .code = 0x1d29, .word = 0xe8e5, .immediate=0, .flags=0x80, .name = "CBLT" },
  { .ov = 24, .code = 0xe8f3, .word = 0xe8f3, .immediate=0, .flags=0x80, .name = "CBLTP" },
  { .ov = 24, .code = 0x224c, .word = 0xe921, .immediate=0, .flags=0x00, .name = "WE921" },
  { .ov = 24, .code = 0x224c, .word = 0xe9e5, .immediate=0, .flags=0x00, .name = "WE9E5" },
  { .ov = 24, .code = 0x73ea, .word = 0xea15, .immediate=0, .flags=0x00, .name = "WEA15" },
  { .ov = 24, .code = 0x224c, .word = 0xea1d, .immediate=0, .flags=0x00, .name = "WEA1D" },
  { .ov = 24, .code = 0x1d29, .word = 0xea4c, .immediate=0, .flags=0x80, .name = "%STORM" },
  { .ov = 24, .code = 0x224c, .word = 0xea58, .immediate=0, .flags=0x00, .name = "WEA58" },
  { .ov = 24, .code = 0x224c, .word = 0xea6e, .immediate=0, .flags=0x00, .name = "WEA6E" },
  { .ov = 24, .code = 0x224c, .word = 0xeb06, .immediate=0, .flags=0x00, .name = "WEB06" },
  { .ov = 24, .code = 0x224c, .word = 0xeb7e, .immediate=0, .flags=0x00, .name = "WEB7E" },
  { .ov = 24, .code = 0x1d29, .word = 0xeb9c, .immediate=0, .flags=0x00, .name = "WEB9C" },
  { .ov = 24, .code = 0x1d29, .word = 0xeba0, .immediate=0, .flags=0x00, .name = "WEBA0" },
  { .ov = 24, .code = 0x2214, .word = 0xeba4, .immediate=0, .flags=0x00, .name = "WEBA4" },
  { .ov = 24, .code = 0x73ea, .word = 0xeba8, .immediate=0, .flags=0x00, .name = "WEBA8" },
  { .ov = 24, .code = 0x224c, .word = 0xebb0, .immediate=0, .flags=0x00, .name = "WEBB0" },
  { .ov = 24, .code = 0x224c, .word = 0xebc4, .immediate=0, .flags=0x00, .name = "WEBC4" },
  { .ov = 24, .code = 0x224c, .word = 0xebe4, .immediate=0, .flags=0x00, .name = "WEBE4" },
  { .ov = 24, .code = 0x224c, .word = 0xebf2, .immediate=0, .flags=0x00, .name = "WEBF2" },
  { .ov = 24, .code = 0x224c, .word = 0xec00, .immediate=0, .flags=0x00, .name = "WEC00" },
  { .ov = 24, .code = 0x224c, .word = 0xec80, .immediate=0, .flags=0x00, .name = "WEC80" },
  { .ov = 24, .code = 0x224c, .word = 0xec88, .immediate=0, .flags=0x00, .name = "WEC88" },
  { .ov = 24, .code = 0x224c, .word = 0xec96, .immediate=0, .flags=0x00, .name = "WEC96" },
  { .ov = 24, .code = 0x224c, .word = 0xeca6, .immediate=0, .flags=0x00, .name = "WECA6" },
  { .ov = 24, .code = 0x224c, .word = 0xecc0, .immediate=0, .flags=0x00, .name = "WECC0" },
  { .ov = 24, .code = 0x224c, .word = 0xecd4, .immediate=0, .flags=0x00, .name = "WECD4" },
  { .ov = 24, .code = 0x224c, .word = 0xecf2, .immediate=0, .flags=0x00, .name = "WECF2" },
  { .ov = 24, .code = 0x224c, .word = 0xed14, .immediate=0, .flags=0x00, .name = "WED14" },
  { .ov = 24, .code = 0x224c, .word = 0xed34, .immediate=0, .flags=0x00, .name = "WED34" },
  { .ov = 24, .code = 0x224c, .word = 0xed42, .immediate=0, .flags=0x00, .name = "WED42" },
  { .ov = 24, .code = 0x224c, .word = 0xed4c, .immediate=0, .flags=0x00, .name = "WED4C" },
  { .ov = 24, .code = 0x224c, .word = 0xed7a, .immediate=0, .flags=0x00, .name = "WED7A" },
  { .ov = 24, .code = 0x224c, .word = 0xeda8, .immediate=0, .flags=0x00, .name = "WEDA8" },
  { .ov = 24, .code = 0x224c, .word = 0xee06, .immediate=0, .flags=0x00, .name = "WEE06" },
  { .ov = 24, .code = 0x224c, .word = 0xee34, .immediate=0, .flags=0x00, .name = "WEE34" },
  { .ov = 24, .code = 0x224c, .word = 0xee64, .immediate=0, .flags=0x80, .name = "?POPULA" },
  { .ov = 24, .code = 0x224c, .word = 0xeece, .immediate=0, .flags=0x00, .name = "WEECE" },
  { .ov = 24, .code = 0x224c, .word = 0xef1e, .immediate=0, .flags=0x00, .name = "WEF1E" },
  { .ov = 24, .code = 0x224c, .word = 0xef48, .immediate=0, .flags=0x00, .name = "WEF48" },
  { .ov = 24, .code = 0x224c, .word = 0xef74, .immediate=0, .flags=0x00, .name = "WEF74" },
  { .ov = 24, .code = 0x224c, .word = 0xf05a, .immediate=0, .flags=0x00, .name = "WF05A" },
  { .ov = 24, .code = 0x224c, .word = 0xf082, .immediate=0, .flags=0x00, .name = "WF082" },
  { .ov = 24, .code = 0x224c, .word = 0xf09e, .immediate=0, .flags=0x00, .name = "WF09E" },
  { .ov = 24, .code = 0x224c, .word = 0xf0b6, .immediate=0, .flags=0x00, .name = "WF0B6" },
  { .ov = 24, .code = 0x224c, .word = 0xf0c0, .immediate=0, .flags=0x00, .name = "WF0C0" },
  { .ov = 24, .code = 0x224c, .word = 0xf122, .immediate=0, .flags=0x00, .name = "WF122" },
  { .ov = 24, .code = 0x224c, .word = 0xf16e, .immediate=0, .flags=0x00, .name = "WF16E" },
  { .ov = 24, .code = 0x224c, .word = 0xf1fe, .immediate=0, .flags=0x00, .name = "WF1FE" },
  { .ov = 24, .code = 0x224c, .word = 0xf212, .immediate=0, .flags=0x00, .name = "WF212" },
  { .ov = 24, .code = 0x224c, .word = 0xf292, .immediate=0, .flags=0x00, .name = "WF292" },
  { .ov = 24, .code = 0x224c, .word = 0xf29c, .immediate=0, .flags=0x00, .name = "WF29C" },
  { .ov = 24, .code = 0x224c, .word = 0xf2b8, .immediate=0, .flags=0x00, .name = "WF2B8" },
  { .ov = 24, .code = 0x224c, .word = 0xf2ca, .immediate=0, .flags=0x00, .name = "WF2CA" },
  { .ov = 24, .code = 0x224c, .word = 0xf2d8, .immediate=0, .flags=0x00, .name = "WF2D8" },
  { .ov = 24, .code = 0x224c, .word = 0xf2e2, .immediate=0, .flags=0x00, .name = "WF2E2" },
  { .ov = 24, .code = 0x224c, .word = 0xf308, .immediate=0, .flags=0x00, .name = "WF308" },
  { .ov = 24, .code = 0x224c, .word = 0xf31d, .immediate=0, .flags=0x00, .name = "WF31D" },
  { .ov = 24, .code = 0x224c, .word = 0xf355, .immediate=0, .flags=0x00, .name = "WF355" },
  { .ov = 24, .code = 0x224c, .word = 0xf36d, .immediate=0, .flags=0x00, .name = "WF36D" },
  { .ov = 24, .code = 0x224c, .word = 0xf37b, .immediate=0, .flags=0x00, .name = "WF37B" },
  { .ov = 24, .code = 0x224c, .word = 0xf38b, .immediate=0, .flags=0x00, .name = "WF38B" },
  { .ov = 24, .code = 0x224c, .word = 0xf397, .immediate=0, .flags=0x00, .name = "WF397" },
  { .ov = 24, .code = 0x224c, .word = 0xf3a7, .immediate=0, .flags=0x00, .name = "WF3A7" },
  { .ov = 24, .code = 0x224c, .word = 0xf401, .immediate=0, .flags=0x80, .name = "TV-MOVE" },
  { .ov = 24, .code = 0x73ea, .word = 0xf417, .immediate=0, .flags=0x00, .name = "plan-tseed" },
  { .ov = 24, .code = 0x224c, .word = 0xf42a, .immediate=0, .flags=0x80, .name = "APPROACH" },
  { .ov = 25, .code = 0x744d, .word = 0xec66, .immediate=0, .flags=0x00, .name = "WEC66" },
  { .ov = 25, .code = 0x744d, .word = 0xec6b, .immediate=0, .flags=0x00, .name = "WEC6B" },
  { .ov = 25, .code = 0x744d, .word = 0xec70, .immediate=0, .flags=0x00, .name = "WEC70" },
  { .ov = 25, .code = 0x224c, .word = 0xec75, .immediate=0, .flags=0x00, .name = "WEC75" },
  { .ov = 25, .code = 0x224c, .word = 0xec89, .immediate=0, .flags=0x00, .name = "WEC89" },
  { .ov = 25, .code = 0x224c, .word = 0xecd1, .immediate=0, .flags=0x00, .name = "WECD1" },
  { .ov = 25, .code = 0x224c, .word = 0xece5, .immediate=0, .flags=0x00, .name = "WECE5" },
  { .ov = 25, .code = 0x224c, .word = 0xed5c, .immediate=0, .flags=0x00, .name = "WED5C" },
  { .ov = 25, .code = 0x224c, .word = 0xee02, .immediate=0, .flags=0x80, .name = "DBARS" },
  { .ov = 25, .code = 0x224c, .word = 0xee54, .immediate=0, .flags=0x80, .name = "(/DAMAGE)" },
  { .ov = 25, .code = 0x224c, .word = 0xee68, .immediate=0, .flags=0x00, .name = "WEE68" },
  { .ov = 25, .code = 0x224c, .word = 0xeea0, .immediate=0, .flags=0x00, .name = "WEEA0" },
  { .ov = 25, .code = 0x224c, .word = 0xef70, .immediate=0, .flags=0x00, .name = "WEF70" },
  { .ov = 25, .code = 0x224c, .word = 0xef7b, .immediate=0, .flags=0x00, .name = "WEF7B" },
  { .ov = 25, .code = 0x224c, .word = 0xef89, .immediate=0, .flags=0x00, .name = "WEF89" },
  { .ov = 25, .code = 0x224c, .word = 0xef97, .immediate=0, .flags=0x00, .name = "WEF97" },
  { .ov = 25, .code = 0x224c, .word = 0xefac, .immediate=0, .flags=0x00, .name = "WEFAC" },
  { .ov = 25, .code = 0x224c, .word = 0xefba, .immediate=0, .flags=0x00, .name = "WEFBA" },
  { .ov = 25, .code = 0x224c, .word = 0xefd1, .immediate=0, .flags=0x00, .name = "WEFD1" },
  { .ov = 25, .code = 0x4a4f, .word = 0xeff1, .immediate=0, .flags=0x80, .name = ".SHIP-ITEM" },
  { .ov = 25, .code = 0x224c, .word = 0xf013, .immediate=0, .flags=0x00, .name = "WF013" },
  { .ov = 25, .code = 0x224c, .word = 0xf05b, .immediate=0, .flags=0x00, .name = "WF05B" },
  { .ov = 25, .code = 0x224c, .word = 0xf080, .immediate=0, .flags=0x00, .name = "WF080" },
  { .ov = 25, .code = 0x224c, .word = 0xf0cb, .immediate=0, .flags=0x00, .name = "WF0CB" },
  { .ov = 25, .code = 0x224c, .word = 0xf0ff, .immediate=0, .flags=0x00, .name = "WF0FF" },
  { .ov = 25, .code = 0x224c, .word = 0xf183, .immediate=0, .flags=0x00, .name = "WF183" },
  { .ov = 25, .code = 0x224c, .word = 0xf1d1, .immediate=0, .flags=0x00, .name = "WF1D1" },
  { .ov = 25, .code = 0x224c, .word = 0xf205, .immediate=0, .flags=0x00, .name = "WF205" },
  { .ov = 25, .code = 0x224c, .word = 0xf231, .immediate=0, .flags=0x00, .name = "WF231" },
  { .ov = 25, .code = 0x224c, .word = 0xf2a0, .immediate=0, .flags=0x00, .name = "WF2A0" },
  { .ov = 25, .code = 0x224c, .word = 0xf2ce, .immediate=0, .flags=0x00, .name = "WF2CE" },
  { .ov = 25, .code = 0x224c, .word = 0xf31a, .immediate=0, .flags=0x00, .name = "WF31A" },
  { .ov = 25, .code = 0x224c, .word = 0xf33a, .immediate=0, .flags=0x00, .name = "WF33A" },
  { .ov = 25, .code = 0x224c, .word = 0xf358, .immediate=0, .flags=0x00, .name = "WF358" },
  { .ov = 25, .code = 0x224c, .word = 0xf37b, .immediate=0, .flags=0x00, .name = "WF37B" },
  { .ov = 25, .code = 0x224c, .word = 0xf3a1, .immediate=0, .flags=0x00, .name = "WF3A1" },
  { .ov = 25, .code = 0x224c, .word = 0xf3c5, .immediate=0, .flags=0x00, .name = "WF3C5" },
  { .ov = 25, .code = 0x224c, .word = 0xf419, .immediate=0, .flags=0x80, .name = "(/REPAIR)" },
  { .ov = 26, .code = 0x73ea, .word = 0xf076, .immediate=0, .flags=0x00, .name = "WF076" },
  { .ov = 26, .code = 0x744d, .word = 0xf07e, .immediate=0, .flags=0x00, .name = "WF07E" },
  { .ov = 26, .code = 0x744d, .word = 0xf083, .immediate=0, .flags=0x00, .name = "WF083" },
  { .ov = 26, .code = 0x744d, .word = 0xf088, .immediate=0, .flags=0x00, .name = "WF088" },
  { .ov = 26, .code = 0x744d, .word = 0xf08d, .immediate=0, .flags=0x00, .name = "WF08D" },
  { .ov = 26, .code = 0x224c, .word = 0xf092, .immediate=0, .flags=0x00, .name = "WF092" },
  { .ov = 26, .code = 0x224c, .word = 0xf0a6, .immediate=0, .flags=0x00, .name = "WF0A6" },
  { .ov = 26, .code = 0x224c, .word = 0xf0e6, .immediate=0, .flags=0x00, .name = "WF0E6" },
  { .ov = 26, .code = 0x224c, .word = 0xf191, .immediate=0, .flags=0x00, .name = "WF191" },
  { .ov = 26, .code = 0x224c, .word = 0xf1af, .immediate=0, .flags=0x00, .name = "WF1AF" },
  { .ov = 26, .code = 0x224c, .word = 0xf1fa, .immediate=0, .flags=0x00, .name = "WF1FA" },
  { .ov = 26, .code = 0x224c, .word = 0xf229, .immediate=0, .flags=0x00, .name = "WF229" },
  { .ov = 26, .code = 0x224c, .word = 0xf244, .immediate=0, .flags=0x00, .name = "WF244" },
  { .ov = 26, .code = 0x224c, .word = 0xf26f, .immediate=0, .flags=0x00, .name = "WF26F" },
  { .ov = 26, .code = 0x224c, .word = 0xf2af, .immediate=0, .flags=0x00, .name = "WF2AF" },
  { .ov = 26, .code = 0x224c, .word = 0xf2d9, .immediate=0, .flags=0x00, .name = "WF2D9" },
  { .ov = 26, .code = 0x224c, .word = 0xf2f1, .immediate=0, .flags=0x00, .name = "WF2F1" },
  { .ov = 26, .code = 0x224c, .word = 0xf31e, .immediate=0, .flags=0x00, .name = "WF31E" },
  { .ov = 26, .code = 0x224c, .word = 0xf334, .immediate=0, .flags=0x00, .name = "WF334" },
  { .ov = 26, .code = 0x224c, .word = 0xf348, .immediate=0, .flags=0x00, .name = "WF348" },
  { .ov = 26, .code = 0x4a4f, .word = 0xf365, .immediate=0, .flags=0x80, .name = "NPCREW" },
  { .ov = 26, .code = 0x224c, .word = 0xf373, .immediate=0, .flags=0x00, .name = "WF373" },
  { .ov = 26, .code = 0x224c, .word = 0xf421, .immediate=0, .flags=0x00, .name = "WF421" },
  { .ov = 26, .code = 0x224c, .word = 0xf4d5, .immediate=0, .flags=0x80, .name = "(/EXAMINE)" },
  { .ov = 26, .code = 0x224c, .word = 0xf4ee, .immediate=0, .flags=0x80, .name = "(/TREAT)" },
  { .ov = 27, .code = 0x2214, .word = 0xdb86, .immediate=0, .flags=0x00, .name = "WDB86" },
  { .ov = 27, .code = 0x2214, .word = 0xdb8a, .immediate=0, .flags=0x00, .name = "WDB8A" },
  { .ov = 27, .code = 0x2214, .word = 0xdb8e, .immediate=0, .flags=0x00, .name = "WDB8E" },
  { .ov = 27, .code = 0x1d29, .word = 0xdb92, .immediate=0, .flags=0x00, .name = "WDB92" },
  { .ov = 27, .code = 0x1d29, .word = 0xdba0, .immediate=0, .flags=0x00, .name = "WDBA0" },
  { .ov = 27, .code = 0x1d29, .word = 0xdba4, .immediate=0, .flags=0x00, .name = "WDBA4" },
  { .ov = 27, .code = 0x1d29, .word = 0xdba8, .immediate=0, .flags=0x00, .name = "WDBA8" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbac, .immediate=0, .flags=0x00, .name = "WDBAC" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbb0, .immediate=0, .flags=0x00, .name = "WDBB0" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbb4, .immediate=0, .flags=0x00, .name = "WDBB4" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbb8, .immediate=0, .flags=0x00, .name = "WDBB8" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbbc, .immediate=0, .flags=0x00, .name = "WDBBC" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbc0, .immediate=0, .flags=0x00, .name = "WDBC0" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbc4, .immediate=0, .flags=0x00, .name = "WDBC4" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbc8, .immediate=0, .flags=0x00, .name = "WDBC8" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbcc, .immediate=0, .flags=0x00, .name = "WDBCC" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbd0, .immediate=0, .flags=0x00, .name = "WDBD0" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbd4, .immediate=0, .flags=0x00, .name = "WDBD4" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbd8, .immediate=0, .flags=0x00, .name = "WDBD8" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbdc, .immediate=0, .flags=0x00, .name = "WDBDC" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbe0, .immediate=0, .flags=0x00, .name = "WDBE0" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbe4, .immediate=0, .flags=0x00, .name = "WDBE4" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbe8, .immediate=0, .flags=0x00, .name = "WDBE8" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbec, .immediate=0, .flags=0x00, .name = "WDBEC" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbf0, .immediate=0, .flags=0x00, .name = "WDBF0" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbf4, .immediate=0, .flags=0x00, .name = "WDBF4" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbf8, .immediate=0, .flags=0x00, .name = "WDBF8" },
  { .ov = 27, .code = 0x1d29, .word = 0xdbfc, .immediate=0, .flags=0x00, .name = "WDBFC" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc00, .immediate=0, .flags=0x00, .name = "WDC00" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc04, .immediate=0, .flags=0x00, .name = "WDC04" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc08, .immediate=0, .flags=0x00, .name = "WDC08" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc0c, .immediate=0, .flags=0x00, .name = "WDC0C" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc10, .immediate=0, .flags=0x00, .name = "WDC10" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc14, .immediate=0, .flags=0x00, .name = "WDC14" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc18, .immediate=0, .flags=0x00, .name = "WDC18" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc1c, .immediate=0, .flags=0x00, .name = "WDC1C" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc20, .immediate=0, .flags=0x00, .name = "WDC20" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc24, .immediate=0, .flags=0x00, .name = "WDC24" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc28, .immediate=0, .flags=0x00, .name = "WDC28" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc2c, .immediate=0, .flags=0x00, .name = "WDC2C" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc30, .immediate=0, .flags=0x00, .name = "WDC30" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc34, .immediate=0, .flags=0x00, .name = "WDC34" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc38, .immediate=0, .flags=0x00, .name = "WDC38" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc5a, .immediate=0, .flags=0x00, .name = "WDC5A" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc64, .immediate=0, .flags=0x00, .name = "WDC64" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc86, .immediate=0, .flags=0x00, .name = "WDC86" },
  { .ov = 27, .code = 0x1d29, .word = 0xdc90, .immediate=0, .flags=0x00, .name = "WDC90" },
  { .ov = 27, .code = 0x1d29, .word = 0xdcc2, .immediate=0, .flags=0x00, .name = "WDCC2" },
  { .ov = 27, .code = 0x73ea, .word = 0xdcdc, .immediate=0, .flags=0x00, .name = "WDCDC" },
  { .ov = 27, .code = 0x1d29, .word = 0xdce4, .immediate=0, .flags=0x00, .name = "WDCE4" },
  { .ov = 27, .code = 0x1d29, .word = 0xdd20, .immediate=0, .flags=0x00, .name = "WDD20" },
  { .ov = 27, .code = 0xdd2c, .word = 0xdd2c, .immediate=0, .flags=0x00, .name = "WDD2C" },
  { .ov = 27, .code = 0x224c, .word = 0xdda4, .immediate=0, .flags=0x00, .name = "WDDA4" },
  { .ov = 27, .code = 0x224c, .word = 0xddc6, .immediate=0, .flags=0x00, .name = "WDDC6" },
  { .ov = 27, .code = 0x224c, .word = 0xddee, .immediate=0, .flags=0x00, .name = "WDDEE" },
  { .ov = 27, .code = 0x224c, .word = 0xde3c, .immediate=0, .flags=0x00, .name = "WDE3C" },
  { .ov = 27, .code = 0x224c, .word = 0xde8c, .immediate=0, .flags=0x00, .name = "WDE8C" },
  { .ov = 27, .code = 0x224c, .word = 0xdeb0, .immediate=0, .flags=0x00, .name = "WDEB0" },
  { .ov = 27, .code = 0x224c, .word = 0xded4, .immediate=0, .flags=0x00, .name = "WDED4" },
  { .ov = 27, .code = 0xdf02, .word = 0xdf02, .immediate=0, .flags=0x80, .name = "SETQUAD" },
  { .ov = 27, .code = 0xdf13, .word = 0xdf13, .immediate=0, .flags=0x80, .name = "C*/" },
  { .ov = 27, .code = 0x224c, .word = 0xdf23, .immediate=0, .flags=0x00, .name = "WDF23" },
  { .ov = 27, .code = 0x224c, .word = 0xdf51, .immediate=0, .flags=0x00, .name = "WDF51" },
  { .ov = 27, .code = 0x224c, .word = 0xdf75, .immediate=0, .flags=0x00, .name = "WDF75" },
  { .ov = 27, .code = 0x224c, .word = 0xdf95, .immediate=0, .flags=0x00, .name = "WDF95" },
  { .ov = 27, .code = 0x224c, .word = 0xdfad, .immediate=0, .flags=0x00, .name = "WDFAD" },
  { .ov = 27, .code = 0x224c, .word = 0xdfc5, .immediate=0, .flags=0x00, .name = "WDFC5" },
  { .ov = 27, .code = 0x224c, .word = 0xdfdd, .immediate=0, .flags=0x00, .name = "WDFDD" },
  { .ov = 27, .code = 0x224c, .word = 0xdff1, .immediate=0, .flags=0x00, .name = "WDFF1" },
  { .ov = 27, .code = 0x224c, .word = 0xe01b, .immediate=0, .flags=0x00, .name = "WE01B" },
  { .ov = 27, .code = 0x224c, .word = 0xe033, .immediate=0, .flags=0x00, .name = "WE033" },
  { .ov = 27, .code = 0x224c, .word = 0xe063, .immediate=0, .flags=0x00, .name = "WE063" },
  { .ov = 27, .code = 0x224c, .word = 0xe091, .immediate=0, .flags=0x00, .name = "WE091" },
  { .ov = 27, .code = 0x224c, .word = 0xe0ab, .immediate=0, .flags=0x00, .name = "WE0AB" },
  { .ov = 27, .code = 0x224c, .word = 0xe0dd, .immediate=0, .flags=0x00, .name = "WE0DD" },
  { .ov = 27, .code = 0x224c, .word = 0xe0f9, .immediate=0, .flags=0x00, .name = "WE0F9" },
  { .ov = 27, .code = 0x224c, .word = 0xe10d, .immediate=0, .flags=0x00, .name = "WE10D" },
  { .ov = 27, .code = 0x224c, .word = 0xe129, .immediate=0, .flags=0x00, .name = "WE129" },
  { .ov = 27, .code = 0x224c, .word = 0xe13b, .immediate=0, .flags=0x00, .name = "WE13B" },
  { .ov = 27, .code = 0xe16b, .word = 0xe16b, .immediate=0, .flags=0x00, .name = "WE16B" },
  { .ov = 27, .code = 0xe1b6, .word = 0xe1b6, .immediate=0, .flags=0x00, .name = "WE1B6" },
  { .ov = 27, .code = 0xe228, .word = 0xe228, .immediate=0, .flags=0x00, .name = "WE228" },
  { .ov = 27, .code = 0x224c, .word = 0xe27a, .immediate=0, .flags=0x00, .name = "WE27A" },
  { .ov = 27, .code = 0x224c, .word = 0xe2e6, .immediate=0, .flags=0x00, .name = "WE2E6" },
  { .ov = 27, .code = 0x224c, .word = 0xe358, .immediate=0, .flags=0x00, .name = "WE358" },
  { .ov = 27, .code = 0x224c, .word = 0xe388, .immediate=0, .flags=0x00, .name = "WE388" },
  { .ov = 27, .code = 0x224c, .word = 0xe3a8, .immediate=0, .flags=0x00, .name = "WE3A8" },
  { .ov = 27, .code = 0x224c, .word = 0xe3c0, .immediate=0, .flags=0x00, .name = "WE3C0" },
  { .ov = 27, .code = 0x224c, .word = 0xe410, .immediate=0, .flags=0x00, .name = "WE410" },
  { .ov = 27, .code = 0x224c, .word = 0xe462, .immediate=0, .flags=0x00, .name = "WE462" },
  { .ov = 27, .code = 0xe48c, .word = 0xe48c, .immediate=0, .flags=0x00, .name = "WE48C" },
  { .ov = 27, .code = 0xe4aa, .word = 0xe4aa, .immediate=0, .flags=0x00, .name = "WE4AA" },
  { .ov = 27, .code = 0x224c, .word = 0xe4b4, .immediate=0, .flags=0x00, .name = "WE4B4" },
  { .ov = 27, .code = 0x224c, .word = 0xe550, .immediate=0, .flags=0x00, .name = "WE550" },
  { .ov = 27, .code = 0x224c, .word = 0xe564, .immediate=0, .flags=0x00, .name = "WE564" },
  { .ov = 27, .code = 0x224c, .word = 0xe59c, .immediate=0, .flags=0x00, .name = "WE59C" },
  { .ov = 27, .code = 0x1d29, .word = 0xe5fa, .immediate=0, .flags=0x00, .name = "WE5FA" },
  { .ov = 27, .code = 0x224c, .word = 0xe5fe, .immediate=0, .flags=0x00, .name = "WE5FE" },
  { .ov = 27, .code = 0x224c, .word = 0xe654, .immediate=0, .flags=0x00, .name = "WE654" },
  { .ov = 27, .code = 0x224c, .word = 0xe670, .immediate=0, .flags=0x00, .name = "WE670" },
  { .ov = 27, .code = 0x224c, .word = 0xe68e, .immediate=0, .flags=0x00, .name = "WE68E" },
  { .ov = 27, .code = 0x224c, .word = 0xe6dc, .immediate=0, .flags=0x00, .name = "WE6DC" },
  { .ov = 27, .code = 0x224c, .word = 0xe703, .immediate=0, .flags=0x80, .name = "SHOWSITE" },
  { .ov = 27, .code = 0x224c, .word = 0xe727, .immediate=0, .flags=0x80, .name = ">VIEWSITE" },
  { .ov = 27, .code = 0x224c, .word = 0xe769, .immediate=0, .flags=0x00, .name = "WE769" },
  { .ov = 27, .code = 0x224c, .word = 0xe7a7, .immediate=0, .flags=0x00, .name = "WE7A7" },
  { .ov = 27, .code = 0x224c, .word = 0xe80d, .immediate=0, .flags=0x00, .name = "WE80D" },
  { .ov = 27, .code = 0x224c, .word = 0xe865, .immediate=0, .flags=0x00, .name = "WE865" },
  { .ov = 27, .code = 0x224c, .word = 0xe8a1, .immediate=0, .flags=0x00, .name = "WE8A1" },
  { .ov = 27, .code = 0x224c, .word = 0xe8e5, .immediate=0, .flags=0x00, .name = "WE8E5" },
  { .ov = 27, .code = 0x224c, .word = 0xe947, .immediate=0, .flags=0x00, .name = "WE947" },
  { .ov = 27, .code = 0x224c, .word = 0xe979, .immediate=0, .flags=0x00, .name = "WE979" },
  { .ov = 27, .code = 0x224c, .word = 0xe99f, .immediate=0, .flags=0x00, .name = "WE99F" },
  { .ov = 27, .code = 0x224c, .word = 0xe9b3, .immediate=0, .flags=0x00, .name = "WE9B3" },
  { .ov = 27, .code = 0x224c, .word = 0xe9ed, .immediate=0, .flags=0x00, .name = "WE9ED" },
  { .ov = 27, .code = 0x224c, .word = 0xea2b, .immediate=0, .flags=0x00, .name = "WEA2B" },
  { .ov = 27, .code = 0x224c, .word = 0xea59, .immediate=0, .flags=0x00, .name = "WEA59" },
  { .ov = 27, .code = 0x224c, .word = 0xea89, .immediate=0, .flags=0x00, .name = "WEA89" },
  { .ov = 27, .code = 0x224c, .word = 0xeab7, .immediate=0, .flags=0x00, .name = "WEAB7" },
  { .ov = 27, .code = 0x224c, .word = 0xeaf1, .immediate=0, .flags=0x00, .name = "WEAF1" },
  { .ov = 27, .code = 0x224c, .word = 0xeb45, .immediate=0, .flags=0x00, .name = "WEB45" },
  { .ov = 27, .code = 0x224c, .word = 0xeb61, .immediate=0, .flags=0x00, .name = "WEB61" },
  { .ov = 27, .code = 0x224c, .word = 0xebd1, .immediate=0, .flags=0x00, .name = "WEBD1" },
  { .ov = 27, .code = 0x224c, .word = 0xec65, .immediate=0, .flags=0x80, .name = "SEEGRID" },
  { .ov = 27, .code = 0x224c, .word = 0xec7d, .immediate=0, .flags=0x00, .name = "WEC7D" },
  { .ov = 27, .code = 0x224c, .word = 0xec97, .immediate=0, .flags=0x00, .name = "WEC97" },
  { .ov = 27, .code = 0x224c, .word = 0xecd5, .immediate=0, .flags=0x00, .name = "WECD5" },
  { .ov = 27, .code = 0x224c, .word = 0xed17, .immediate=0, .flags=0x00, .name = "WED17" },
  { .ov = 27, .code = 0x224c, .word = 0xedb1, .immediate=0, .flags=0x00, .name = "WEDB1" },
  { .ov = 27, .code = 0x224c, .word = 0xedcf, .immediate=0, .flags=0x00, .name = "WEDCF" },
  { .ov = 27, .code = 0x224c, .word = 0xedfb, .immediate=0, .flags=0x00, .name = "WEDFB" },
  { .ov = 27, .code = 0x224c, .word = 0xee65, .immediate=0, .flags=0x00, .name = "WEE65" },
  { .ov = 27, .code = 0x224c, .word = 0xee9b, .immediate=0, .flags=0x00, .name = "WEE9B" },
  { .ov = 27, .code = 0x224c, .word = 0xeed1, .immediate=0, .flags=0x00, .name = "WEED1" },
  { .ov = 27, .code = 0x224c, .word = 0xef33, .immediate=0, .flags=0x00, .name = "WEF33" },
  { .ov = 27, .code = 0x224c, .word = 0xef6f, .immediate=0, .flags=0x00, .name = "WEF6F" },
  { .ov = 27, .code = 0x224c, .word = 0xef97, .immediate=0, .flags=0x00, .name = "WEF97" },
  { .ov = 27, .code = 0x224c, .word = 0xefdb, .immediate=0, .flags=0x00, .name = "WEFDB" },
  { .ov = 27, .code = 0x224c, .word = 0xeffb, .immediate=0, .flags=0x00, .name = "WEFFB" },
  { .ov = 27, .code = 0x224c, .word = 0xf023, .immediate=0, .flags=0x00, .name = "WF023" },
  { .ov = 27, .code = 0x224c, .word = 0xf043, .immediate=0, .flags=0x00, .name = "WF043" },
  { .ov = 27, .code = 0x224c, .word = 0xf06b, .immediate=0, .flags=0x00, .name = "WF06B" },
  { .ov = 27, .code = 0x224c, .word = 0xf087, .immediate=0, .flags=0x00, .name = "WF087" },
  { .ov = 27, .code = 0x224c, .word = 0xf097, .immediate=0, .flags=0x00, .name = "WF097" },
  { .ov = 27, .code = 0x224c, .word = 0xf0a3, .immediate=0, .flags=0x00, .name = "WF0A3" },
  { .ov = 27, .code = 0x224c, .word = 0xf0af, .immediate=0, .flags=0x00, .name = "WF0AF" },
  { .ov = 27, .code = 0x224c, .word = 0xf0bb, .immediate=0, .flags=0x00, .name = "WF0BB" },
  { .ov = 27, .code = 0x224c, .word = 0xf0c7, .immediate=0, .flags=0x00, .name = "WF0C7" },
  { .ov = 27, .code = 0x224c, .word = 0xf0d3, .immediate=0, .flags=0x00, .name = "WF0D3" },
  { .ov = 27, .code = 0x224c, .word = 0xf19d, .immediate=0, .flags=0x00, .name = "WF19D" },
  { .ov = 27, .code = 0x224c, .word = 0xf1b7, .immediate=0, .flags=0x80, .name = "DESCEND" },
  { .ov = 27, .code = 0x224c, .word = 0xf246, .immediate=0, .flags=0x00, .name = "WF246" },
  { .ov = 27, .code = 0x224c, .word = 0xf2b4, .immediate=0, .flags=0x00, .name = "WF2B4" },
  { .ov = 27, .code = 0x224c, .word = 0xf2fc, .immediate=0, .flags=0x00, .name = "WF2FC" },
  { .ov = 27, .code = 0x1d29, .word = 0xf310, .immediate=0, .flags=0x00, .name = "WF310" },
  { .ov = 27, .code = 0x224c, .word = 0xf314, .immediate=0, .flags=0x00, .name = "WF314" },
  { .ov = 27, .code = 0x224c, .word = 0xf387, .immediate=0, .flags=0x80, .name = "ASCEND" },
  { .ov = 27, .code = 0x224c, .word = 0xf391, .immediate=0, .flags=0x00, .name = "WF391" },
  { .ov = 27, .code = 0x224c, .word = 0xf39f, .immediate=0, .flags=0x00, .name = "WF39F" },
  { .ov = 27, .code = 0x224c, .word = 0xf3cb, .immediate=0, .flags=0x00, .name = "WF3CB" },
  { .ov = 27, .code = 0x4a4f, .word = 0xf3fd, .immediate=0, .flags=0x80, .name = "SKYCASE" },
  { .ov = 27, .code = 0x224c, .word = 0xf413, .immediate=0, .flags=0x00, .name = "WF413" },
  { .ov = 27, .code = 0x224c, .word = 0xf42e, .immediate=0, .flags=0x80, .name = "INIT-ORBIT" },
  { .ov = 27, .code = 0x224c, .word = 0xf491, .immediate=0, .flags=0x80, .name = "ROTATE" },
  { .ov = 28, .code = 0x1d29, .word = 0xde36, .immediate=0, .flags=0x00, .name = "WDE36" },
  { .ov = 28, .code = 0x1d29, .word = 0xde3a, .immediate=0, .flags=0x00, .name = "WDE3A" },
  { .ov = 28, .code = 0x1d29, .word = 0xde3e, .immediate=0, .flags=0x00, .name = "WDE3E" },
  { .ov = 28, .code = 0x1d29, .word = 0xde44, .immediate=0, .flags=0x00, .name = "WDE44" },
  { .ov = 28, .code = 0x1d29, .word = 0xde4c, .immediate=0, .flags=0x00, .name = "WDE4C" },
  { .ov = 28, .code = 0x1d29, .word = 0xde54, .immediate=0, .flags=0x00, .name = "WDE54" },
  { .ov = 28, .code = 0x1d29, .word = 0xde5c, .immediate=0, .flags=0x00, .name = "WDE5C" },
  { .ov = 28, .code = 0x3b68, .word = 0xde64, .immediate=0, .flags=0x00, .name = "WDE64" },
  { .ov = 28, .code = 0x3b68, .word = 0xde6a, .immediate=0, .flags=0x00, .name = "WDE6A" },
  { .ov = 28, .code = 0x1d29, .word = 0xde70, .immediate=0, .flags=0x00, .name = "WDE70" },
  { .ov = 28, .code = 0x224c, .word = 0xde74, .immediate=0, .flags=0x00, .name = "WDE74" },
  { .ov = 28, .code = 0x224c, .word = 0xde7e, .immediate=0, .flags=0x00, .name = "WDE7E" },
  { .ov = 28, .code = 0x224c, .word = 0xdebc, .immediate=0, .flags=0x00, .name = "WDEBC" },
  { .ov = 28, .code = 0x224c, .word = 0xdf3e, .immediate=0, .flags=0x00, .name = "WDF3E" },
  { .ov = 28, .code = 0x224c, .word = 0xdfb6, .immediate=0, .flags=0x00, .name = "WDFB6" },
  { .ov = 28, .code = 0x744d, .word = 0xdffe, .immediate=0, .flags=0x00, .name = "WDFFE" },
  { .ov = 28, .code = 0x224c, .word = 0xe003, .immediate=0, .flags=0x00, .name = "WE003" },
  { .ov = 28, .code = 0x73ea, .word = 0xe03c, .immediate=0, .flags=0x00, .name = "WE03C" },
  { .ov = 28, .code = 0x73ea, .word = 0xe044, .immediate=0, .flags=0x00, .name = "WE044" },
  { .ov = 28, .code = 0x73ea, .word = 0xe04c, .immediate=0, .flags=0x00, .name = "WE04C" },
  { .ov = 28, .code = 0x744d, .word = 0xe054, .immediate=0, .flags=0x00, .name = "WE054" },
  { .ov = 28, .code = 0x73ea, .word = 0xe059, .immediate=0, .flags=0x00, .name = "WE059" },
  { .ov = 28, .code = 0x73ea, .word = 0xe061, .immediate=0, .flags=0x00, .name = "WE061" },
  { .ov = 28, .code = 0x73ea, .word = 0xe069, .immediate=0, .flags=0x00, .name = "WE069" },
  { .ov = 28, .code = 0x73ea, .word = 0xe071, .immediate=0, .flags=0x00, .name = "WE071" },
  { .ov = 28, .code = 0x73ea, .word = 0xe079, .immediate=0, .flags=0x00, .name = "WE079" },
  { .ov = 28, .code = 0x744d, .word = 0xe081, .immediate=0, .flags=0x00, .name = "WE081" },
  { .ov = 28, .code = 0x73ea, .word = 0xe086, .immediate=0, .flags=0x00, .name = "WE086" },
  { .ov = 28, .code = 0x73ea, .word = 0xe08e, .immediate=0, .flags=0x00, .name = "WE08E" },
  { .ov = 28, .code = 0x744d, .word = 0xe096, .immediate=0, .flags=0x00, .name = "WE096" },
  { .ov = 28, .code = 0x744d, .word = 0xe09b, .immediate=0, .flags=0x00, .name = "WE09B" },
  { .ov = 28, .code = 0x744d, .word = 0xe0a0, .immediate=0, .flags=0x00, .name = "WE0A0" },
  { .ov = 28, .code = 0x744d, .word = 0xe0a5, .immediate=0, .flags=0x00, .name = "WE0A5" },
  { .ov = 28, .code = 0x744d, .word = 0xe0aa, .immediate=0, .flags=0x00, .name = "WE0AA" },
  { .ov = 28, .code = 0x744d, .word = 0xe0af, .immediate=0, .flags=0x00, .name = "WE0AF" },
  { .ov = 28, .code = 0x744d, .word = 0xe0b4, .immediate=0, .flags=0x00, .name = "WE0B4" },
  { .ov = 28, .code = 0x744d, .word = 0xe0b9, .immediate=0, .flags=0x00, .name = "WE0B9" },
  { .ov = 28, .code = 0x744d, .word = 0xe0be, .immediate=0, .flags=0x00, .name = "WE0BE" },
  { .ov = 28, .code = 0x744d, .word = 0xe0c3, .immediate=0, .flags=0x00, .name = "WE0C3" },
  { .ov = 28, .code = 0x744d, .word = 0xe0c8, .immediate=0, .flags=0x00, .name = "WE0C8" },
  { .ov = 28, .code = 0x744d, .word = 0xe0cd, .immediate=0, .flags=0x00, .name = "WE0CD" },
  { .ov = 28, .code = 0x744d, .word = 0xe0d2, .immediate=0, .flags=0x00, .name = "WE0D2" },
  { .ov = 28, .code = 0x1d29, .word = 0xe0d7, .immediate=0, .flags=0x00, .name = "WE0D7" },
  { .ov = 28, .code = 0x224c, .word = 0xe0db, .immediate=0, .flags=0x00, .name = "WE0DB" },
  { .ov = 28, .code = 0x224c, .word = 0xe0e7, .immediate=0, .flags=0x00, .name = "WE0E7" },
  { .ov = 28, .code = 0x224c, .word = 0xe0f9, .immediate=0, .flags=0x00, .name = "WE0F9" },
  { .ov = 28, .code = 0x224c, .word = 0xe12b, .immediate=0, .flags=0x00, .name = "WE12B" },
  { .ov = 28, .code = 0x224c, .word = 0xe18d, .immediate=0, .flags=0x00, .name = "WE18D" },
  { .ov = 28, .code = 0x224c, .word = 0xe1b1, .immediate=0, .flags=0x00, .name = "WE1B1" },
  { .ov = 28, .code = 0x224c, .word = 0xe205, .immediate=0, .flags=0x00, .name = "WE205" },
  { .ov = 28, .code = 0x224c, .word = 0xe213, .immediate=0, .flags=0x00, .name = "WE213" },
  { .ov = 28, .code = 0x224c, .word = 0xe23b, .immediate=0, .flags=0x00, .name = "WE23B" },
  { .ov = 28, .code = 0x224c, .word = 0xe255, .immediate=0, .flags=0x00, .name = "WE255" },
  { .ov = 28, .code = 0x224c, .word = 0xe291, .immediate=0, .flags=0x00, .name = "WE291" },
  { .ov = 28, .code = 0x4a4f, .word = 0xe2e4, .immediate=0, .flags=0x80, .name = "CHAR>SCR" },
  { .ov = 28, .code = 0x224c, .word = 0xe2f6, .immediate=0, .flags=0x00, .name = "WE2F6" },
  { .ov = 28, .code = 0x224c, .word = 0xe34e, .immediate=0, .flags=0x00, .name = "WE34E" },
  { .ov = 28, .code = 0x224c, .word = 0xe394, .immediate=0, .flags=0x00, .name = "WE394" },
  { .ov = 28, .code = 0x224c, .word = 0xe3b6, .immediate=0, .flags=0x00, .name = "WE3B6" },
  { .ov = 28, .code = 0x224c, .word = 0xe3da, .immediate=0, .flags=0x00, .name = "WE3DA" },
  { .ov = 28, .code = 0x224c, .word = 0xe42e, .immediate=0, .flags=0x80, .name = "(/CAPT-LOG)" },
  { .ov = 28, .code = 0x224c, .word = 0xe462, .immediate=0, .flags=0x00, .name = "WE462" },
  { .ov = 28, .code = 0x224c, .word = 0xe46a, .immediate=0, .flags=0x00, .name = "WE46A" },
  { .ov = 28, .code = 0x224c, .word = 0xe47c, .immediate=0, .flags=0x00, .name = "WE47C" },
  { .ov = 28, .code = 0x224c, .word = 0xe48e, .immediate=0, .flags=0x00, .name = "WE48E" },
  { .ov = 28, .code = 0x224c, .word = 0xe49e, .immediate=0, .flags=0x00, .name = "WE49E" },
  { .ov = 28, .code = 0x224c, .word = 0xe4ae, .immediate=0, .flags=0x00, .name = "WE4AE" },
  { .ov = 28, .code = 0x224c, .word = 0xe4e2, .immediate=0, .flags=0x00, .name = "WE4E2" },
  { .ov = 28, .code = 0x224c, .word = 0xe4ee, .immediate=0, .flags=0x00, .name = "WE4EE" },
  { .ov = 28, .code = 0x224c, .word = 0xe51a, .immediate=0, .flags=0x00, .name = "WE51A" },
  { .ov = 28, .code = 0x224c, .word = 0xe552, .immediate=0, .flags=0x00, .name = "WE552" },
  { .ov = 28, .code = 0x224c, .word = 0xe564, .immediate=0, .flags=0x00, .name = "WE564" },
  { .ov = 28, .code = 0x4a4f, .word = 0xe588, .immediate=0, .flags=0x80, .name = "TD-SCROLL" },
  { .ov = 28, .code = 0x224c, .word = 0xe596, .immediate=0, .flags=0x00, .name = "WE596" },
  { .ov = 28, .code = 0x224c, .word = 0xe5c6, .immediate=0, .flags=0x00, .name = "WE5C6" },
  { .ov = 28, .code = 0x224c, .word = 0xe5ef, .immediate=0, .flags=0x00, .name = "WE5EF" },
  { .ov = 28, .code = 0x224c, .word = 0xe633, .immediate=0, .flags=0x00, .name = "WE633" },
  { .ov = 28, .code = 0x224c, .word = 0xe68b, .immediate=0, .flags=0x00, .name = "WE68B" },
  { .ov = 28, .code = 0x224c, .word = 0xe6c9, .immediate=0, .flags=0x00, .name = "WE6C9" },
  { .ov = 28, .code = 0x224c, .word = 0xe6df, .immediate=0, .flags=0x00, .name = "WE6DF" },
  { .ov = 28, .code = 0x224c, .word = 0xe709, .immediate=0, .flags=0x00, .name = "WE709" },
  { .ov = 28, .code = 0x224c, .word = 0xe73b, .immediate=0, .flags=0x00, .name = "WE73B" },
  { .ov = 28, .code = 0x224c, .word = 0xe767, .immediate=0, .flags=0x00, .name = "WE767" },
  { .ov = 28, .code = 0x224c, .word = 0xe7f7, .immediate=0, .flags=0x00, .name = "WE7F7" },
  { .ov = 28, .code = 0x224c, .word = 0xe823, .immediate=0, .flags=0x00, .name = "WE823" },
  { .ov = 28, .code = 0x224c, .word = 0xe8e9, .immediate=0, .flags=0x00, .name = "WE8E9" },
  { .ov = 28, .code = 0x224c, .word = 0xe907, .immediate=0, .flags=0x00, .name = "WE907" },
  { .ov = 28, .code = 0x224c, .word = 0xe932, .immediate=0, .flags=0x00, .name = "WE932" },
  { .ov = 28, .code = 0x224c, .word = 0xe970, .immediate=0, .flags=0x00, .name = "WE970" },
  { .ov = 28, .code = 0x224c, .word = 0xe9ba, .immediate=0, .flags=0x00, .name = "WE9BA" },
  { .ov = 28, .code = 0x224c, .word = 0xe9e2, .immediate=0, .flags=0x00, .name = "WE9E2" },
  { .ov = 28, .code = 0x224c, .word = 0xea14, .immediate=0, .flags=0x00, .name = "WEA14" },
  { .ov = 28, .code = 0x224c, .word = 0xea62, .immediate=0, .flags=0x00, .name = "WEA62" },
  { .ov = 28, .code = 0x224c, .word = 0xeaf4, .immediate=0, .flags=0x00, .name = "WEAF4" },
  { .ov = 28, .code = 0x224c, .word = 0xeb14, .immediate=0, .flags=0x00, .name = "WEB14" },
  { .ov = 28, .code = 0x224c, .word = 0xeb82, .immediate=0, .flags=0x00, .name = "WEB82" },
  { .ov = 28, .code = 0x224c, .word = 0xeb9e, .immediate=0, .flags=0x00, .name = "WEB9E" },
  { .ov = 28, .code = 0x224c, .word = 0xebc0, .immediate=0, .flags=0x00, .name = "WEBC0" },
  { .ov = 28, .code = 0x224c, .word = 0xebe8, .immediate=0, .flags=0x00, .name = "WEBE8" },
  { .ov = 28, .code = 0x224c, .word = 0xec0c, .immediate=0, .flags=0x00, .name = "WEC0C" },
  { .ov = 28, .code = 0x224c, .word = 0xec30, .immediate=0, .flags=0x00, .name = "WEC30" },
  { .ov = 28, .code = 0x224c, .word = 0xec60, .immediate=0, .flags=0x00, .name = "WEC60" },
  { .ov = 28, .code = 0x224c, .word = 0xec73, .immediate=0, .flags=0x00, .name = "WEC73" },
  { .ov = 28, .code = 0x224c, .word = 0xecdf, .immediate=0, .flags=0x00, .name = "WECDF" },
  { .ov = 28, .code = 0x224c, .word = 0xecf5, .immediate=0, .flags=0x00, .name = "WECF5" },
  { .ov = 28, .code = 0x4a4f, .word = 0xed1d, .immediate=0, .flags=0x80, .name = "1STOPTION" },
  { .ov = 28, .code = 0x1d29, .word = 0xed37, .immediate=0, .flags=0x00, .name = "WED37" },
  { .ov = 28, .code = 0x1d29, .word = 0xed3b, .immediate=0, .flags=0x00, .name = "WED3B" },
  { .ov = 28, .code = 0x224c, .word = 0xed4b, .immediate=0, .flags=0x80, .name = "DO-OPTION" },
  { .ov = 28, .code = 0x224c, .word = 0xed63, .immediate=0, .flags=0x00, .name = "WED63" },
  { .ov = 28, .code = 0x224c, .word = 0xed75, .immediate=0, .flags=0x00, .name = "WED75" },
  { .ov = 28, .code = 0x224c, .word = 0xed8b, .immediate=0, .flags=0x00, .name = "WED8B" },
  { .ov = 28, .code = 0x224c, .word = 0xeda8, .immediate=0, .flags=0x00, .name = "WEDA8" },
  { .ov = 28, .code = 0x4a4f, .word = 0xeddd, .immediate=0, .flags=0x80, .name = "ITEM-OPTIONS" },
  { .ov = 28, .code = 0x224c, .word = 0xedf7, .immediate=0, .flags=0x00, .name = "WEDF7" },
  { .ov = 28, .code = 0x224c, .word = 0xee4a, .immediate=0, .flags=0x00, .name = "WEE4A" },
  { .ov = 28, .code = 0x224c, .word = 0xeef2, .immediate=0, .flags=0x00, .name = "WEEF2" },
  { .ov = 28, .code = 0x224c, .word = 0xef23, .immediate=0, .flags=0x80, .name = "(/ITEMS)" },
  { .ov = 28, .code = 0x224c, .word = 0xefad, .immediate=0, .flags=0x00, .name = "WEFAD" },
  { .ov = 28, .code = 0x224c, .word = 0xefbf, .immediate=0, .flags=0x00, .name = "WEFBF" },
  { .ov = 28, .code = 0x224c, .word = 0xefd4, .immediate=0, .flags=0x80, .name = ">DESCEND" },
  { .ov = 28, .code = 0x224c, .word = 0xf007, .immediate=0, .flags=0x00, .name = "WF007" },
  { .ov = 28, .code = 0x224c, .word = 0xf0cd, .immediate=0, .flags=0x00, .name = "WF0CD" },
  { .ov = 28, .code = 0x224c, .word = 0xf0ea, .immediate=0, .flags=0x00, .name = "WF0EA" },
  { .ov = 28, .code = 0x224c, .word = 0xf13d, .immediate=0, .flags=0x80, .name = "(/LAUNCH/LAND)" },
  { .ov = 28, .code = 0x1d29, .word = 0xf18d, .immediate=0, .flags=0x00, .name = "WF18D" },
  { .ov = 28, .code = 0x224c, .word = 0xf191, .immediate=0, .flags=0x00, .name = "WF191" },
  { .ov = 28, .code = 0x224c, .word = 0xf199, .immediate=0, .flags=0x00, .name = "WF199" },
  { .ov = 28, .code = 0x224c, .word = 0xf1ab, .immediate=0, .flags=0x00, .name = "WF1AB" },
  { .ov = 28, .code = 0x224c, .word = 0xf1bd, .immediate=0, .flags=0x00, .name = "WF1BD" },
  { .ov = 28, .code = 0x224c, .word = 0xf1df, .immediate=0, .flags=0x00, .name = "WF1DF" },
  { .ov = 28, .code = 0x224c, .word = 0xf1fb, .immediate=0, .flags=0x00, .name = "WF1FB" },
  { .ov = 28, .code = 0x224c, .word = 0xf219, .immediate=0, .flags=0x00, .name = "WF219" },
  { .ov = 28, .code = 0x224c, .word = 0xf233, .immediate=0, .flags=0x00, .name = "WF233" },
  { .ov = 28, .code = 0x224c, .word = 0xf23f, .immediate=0, .flags=0x00, .name = "WF23F" },
  { .ov = 28, .code = 0x224c, .word = 0xf257, .immediate=0, .flags=0x00, .name = "WF257" },
  { .ov = 28, .code = 0x224c, .word = 0xf292, .immediate=0, .flags=0x00, .name = "WF292" },
  { .ov = 28, .code = 0x1d29, .word = 0xf2cc, .immediate=0, .flags=0x00, .name = "WF2CC" },
  { .ov = 28, .code = 0x224c, .word = 0xf2d0, .immediate=0, .flags=0x00, .name = "WF2D0" },
  { .ov = 28, .code = 0x224c, .word = 0xf30e, .immediate=0, .flags=0x00, .name = "WF30E" },
  { .ov = 28, .code = 0x224c, .word = 0xf348, .immediate=0, .flags=0x00, .name = "WF348" },
  { .ov = 28, .code = 0x224c, .word = 0xf37a, .immediate=0, .flags=0x00, .name = "WF37A" },
  { .ov = 28, .code = 0x224c, .word = 0xf3b2, .immediate=0, .flags=0x00, .name = "WF3B2" },
  { .ov = 28, .code = 0x224c, .word = 0xf3d3, .immediate=0, .flags=0x00, .name = "WF3D3" },
  { .ov = 28, .code = 0x224c, .word = 0xf43a, .immediate=0, .flags=0x80, .name = "(/LOG-PLAN)" },
  { .ov = 29, .code = 0x1d29, .word = 0xe606, .immediate=0, .flags=0x00, .name = "WE606" },
  { .ov = 29, .code = 0x744d, .word = 0xe60a, .immediate=0, .flags=0x00, .name = "WE60A" },
  { .ov = 29, .code = 0x744d, .word = 0xe60f, .immediate=0, .flags=0x00, .name = "WE60F" },
  { .ov = 29, .code = 0x744d, .word = 0xe614, .immediate=0, .flags=0x00, .name = "WE614" },
  { .ov = 29, .code = 0x744d, .word = 0xe619, .immediate=0, .flags=0x00, .name = "WE619" },
  { .ov = 29, .code = 0x744d, .word = 0xe61e, .immediate=0, .flags=0x00, .name = "WE61E" },
  { .ov = 29, .code = 0x744d, .word = 0xe623, .immediate=0, .flags=0x00, .name = "WE623" },
  { .ov = 29, .code = 0x744d, .word = 0xe628, .immediate=0, .flags=0x00, .name = "WE628" },
  { .ov = 29, .code = 0x744d, .word = 0xe62d, .immediate=0, .flags=0x00, .name = "WE62D" },
  { .ov = 29, .code = 0x744d, .word = 0xe632, .immediate=0, .flags=0x00, .name = "WE632" },
  { .ov = 29, .code = 0x744d, .word = 0xe637, .immediate=0, .flags=0x00, .name = "WE637" },
  { .ov = 29, .code = 0x73ea, .word = 0xe63c, .immediate=0, .flags=0x00, .name = "WE63C" },
  { .ov = 29, .code = 0x73ea, .word = 0xe644, .immediate=0, .flags=0x00, .name = "WE644" },
  { .ov = 29, .code = 0x73ea, .word = 0xe64c, .immediate=0, .flags=0x00, .name = "WE64C" },
  { .ov = 29, .code = 0x73ea, .word = 0xe654, .immediate=0, .flags=0x00, .name = "WE654" },
  { .ov = 29, .code = 0x744d, .word = 0xe65c, .immediate=0, .flags=0x00, .name = "WE65C" },
  { .ov = 29, .code = 0x73ea, .word = 0xe661, .immediate=0, .flags=0x00, .name = "WE661" },
  { .ov = 29, .code = 0x744d, .word = 0xe669, .immediate=0, .flags=0x00, .name = "WE669" },
  { .ov = 29, .code = 0x73ea, .word = 0xe66e, .immediate=0, .flags=0x00, .name = "WE66E" },
  { .ov = 29, .code = 0x73ea, .word = 0xe676, .immediate=0, .flags=0x00, .name = "WE676" },
  { .ov = 29, .code = 0x73ea, .word = 0xe67e, .immediate=0, .flags=0x00, .name = "WE67E" },
  { .ov = 29, .code = 0x73ea, .word = 0xe686, .immediate=0, .flags=0x00, .name = "WE686" },
  { .ov = 29, .code = 0x73ea, .word = 0xe68e, .immediate=0, .flags=0x00, .name = "WE68E" },
  { .ov = 29, .code = 0x73ea, .word = 0xe696, .immediate=0, .flags=0x00, .name = "WE696" },
  { .ov = 29, .code = 0x224c, .word = 0xe69e, .immediate=0, .flags=0x00, .name = "WE69E" },
  { .ov = 29, .code = 0x224c, .word = 0xe742, .immediate=0, .flags=0x00, .name = "WE742" },
  { .ov = 29, .code = 0x224c, .word = 0xe754, .immediate=0, .flags=0x00, .name = "WE754" },
  { .ov = 29, .code = 0x224c, .word = 0xe760, .immediate=0, .flags=0x00, .name = "WE760" },
  { .ov = 29, .code = 0x224c, .word = 0xe7bd, .immediate=0, .flags=0x80, .name = "?HEAVY" },
  { .ov = 29, .code = 0x224c, .word = 0xe7cf, .immediate=0, .flags=0x00, .name = "WE7CF" },
  { .ov = 29, .code = 0x224c, .word = 0xe7eb, .immediate=0, .flags=0x80, .name = ".STARDATE" },
  { .ov = 29, .code = 0x224c, .word = 0xe86b, .immediate=0, .flags=0x00, .name = "WE86B" },
  { .ov = 29, .code = 0x224c, .word = 0xe88e, .immediate=0, .flags=0x00, .name = "WE88E" },
  { .ov = 29, .code = 0x224c, .word = 0xe8b4, .immediate=0, .flags=0x00, .name = "WE8B4" },
  { .ov = 29, .code = 0x224c, .word = 0xe8ce, .immediate=0, .flags=0x00, .name = "WE8CE" },
  { .ov = 29, .code = 0x224c, .word = 0xe90e, .immediate=0, .flags=0x00, .name = "WE90E" },
  { .ov = 29, .code = 0x224c, .word = 0xe950, .immediate=0, .flags=0x00, .name = "WE950" },
  { .ov = 29, .code = 0x224c, .word = 0xe974, .immediate=0, .flags=0x00, .name = "WE974" },
  { .ov = 29, .code = 0x224c, .word = 0xe9a0, .immediate=0, .flags=0x00, .name = "WE9A0" },
  { .ov = 29, .code = 0x224c, .word = 0xe9da, .immediate=0, .flags=0x00, .name = "WE9DA" },
  { .ov = 29, .code = 0x224c, .word = 0xea26, .immediate=0, .flags=0x00, .name = "WEA26" },
  { .ov = 29, .code = 0x1d29, .word = 0xea2e, .immediate=0, .flags=0x00, .name = "WEA2E" },
  { .ov = 29, .code = 0x224c, .word = 0xea40, .immediate=0, .flags=0x00, .name = "WEA40" },
  { .ov = 29, .code = 0x224c, .word = 0xea52, .immediate=0, .flags=0x00, .name = "WEA52" },
  { .ov = 29, .code = 0x224c, .word = 0xeb07, .immediate=0, .flags=0x80, .name = ".STAT-TEXT" },
  { .ov = 29, .code = 0x224c, .word = 0xec00, .immediate=0, .flags=0x00, .name = "WEC00" },
  { .ov = 29, .code = 0x224c, .word = 0xec18, .immediate=0, .flags=0x80, .name = "(/STATUS)" },
  { .ov = 29, .code = 0x1d29, .word = 0xec24, .immediate=0, .flags=0x00, .name = "WEC24" },
  { .ov = 29, .code = 0x1d29, .word = 0xec28, .immediate=0, .flags=0x00, .name = "WEC28" },
  { .ov = 29, .code = 0x1d29, .word = 0xec2c, .immediate=0, .flags=0x00, .name = "WEC2C" },
  { .ov = 29, .code = 0x224c, .word = 0xec36, .immediate=0, .flags=0x00, .name = "WEC36" },
  { .ov = 29, .code = 0x224c, .word = 0xec70, .immediate=0, .flags=0x00, .name = "WEC70" },
  { .ov = 29, .code = 0x224c, .word = 0xecb4, .immediate=0, .flags=0x00, .name = "WECB4" },
  { .ov = 29, .code = 0x224c, .word = 0xed30, .immediate=0, .flags=0x00, .name = "WED30" },
  { .ov = 29, .code = 0x224c, .word = 0xedd0, .immediate=0, .flags=0x00, .name = "WEDD0" },
  { .ov = 29, .code = 0x224c, .word = 0xee86, .immediate=0, .flags=0x00, .name = "WEE86" },
  { .ov = 29, .code = 0x224c, .word = 0xeeb8, .immediate=0, .flags=0x00, .name = "WEEB8" },
  { .ov = 29, .code = 0x224c, .word = 0xeee0, .immediate=0, .flags=0x00, .name = "WEEE0" },
  { .ov = 29, .code = 0x224c, .word = 0xeefe, .immediate=0, .flags=0x00, .name = "WEEFE" },
  { .ov = 29, .code = 0x1d29, .word = 0xef0c, .immediate=0, .flags=0x00, .name = "WEF0C" },
  { .ov = 29, .code = 0x224c, .word = 0xef17, .immediate=0, .flags=0x00, .name = "WEF17" },
  { .ov = 29, .code = 0x224c, .word = 0xef31, .immediate=0, .flags=0x00, .name = "WEF31" },
  { .ov = 29, .code = 0x1d29, .word = 0xefd3, .immediate=0, .flags=0x00, .name = "WEFD3" },
  { .ov = 29, .code = 0x1d29, .word = 0xefda, .immediate=0, .flags=0x00, .name = "WEFDA" },
  { .ov = 29, .code = 0x1d29, .word = 0xefe1, .immediate=0, .flags=0x00, .name = "WEFE1" },
  { .ov = 29, .code = 0x1d29, .word = 0xefe5, .immediate=0, .flags=0x00, .name = "WEFE5" },
  { .ov = 29, .code = 0x224c, .word = 0xefe9, .immediate=0, .flags=0x00, .name = "WEFE9" },
  { .ov = 29, .code = 0x224c, .word = 0xf043, .immediate=0, .flags=0x00, .name = "WF043" },
  { .ov = 29, .code = 0x224c, .word = 0xf09d, .immediate=0, .flags=0x00, .name = "WF09D" },
  { .ov = 29, .code = 0x224c, .word = 0xf0bd, .immediate=0, .flags=0x00, .name = "WF0BD" },
  { .ov = 29, .code = 0x224c, .word = 0xf0ce, .immediate=0, .flags=0x00, .name = "WF0CE" },
  { .ov = 29, .code = 0x224c, .word = 0xf0de, .immediate=0, .flags=0x00, .name = "WF0DE" },
  { .ov = 29, .code = 0x224c, .word = 0xf16b, .immediate=0, .flags=0x00, .name = "WF16B" },
  { .ov = 29, .code = 0x224c, .word = 0xf1d3, .immediate=0, .flags=0x00, .name = "WF1D3" },
  { .ov = 29, .code = 0x224c, .word = 0xf239, .immediate=0, .flags=0x00, .name = "WF239" },
  { .ov = 29, .code = 0x224c, .word = 0xf2ca, .immediate=0, .flags=0x00, .name = "WF2CA" },
  { .ov = 29, .code = 0x224c, .word = 0xf2dc, .immediate=0, .flags=0x00, .name = "WF2DC" },
  { .ov = 29, .code = 0x224c, .word = 0xf390, .immediate=0, .flags=0x00, .name = "WF390" },
  { .ov = 29, .code = 0x224c, .word = 0xf39c, .immediate=0, .flags=0x00, .name = "WF39C" },
  { .ov = 29, .code = 0x224c, .word = 0xf402, .immediate=0, .flags=0x00, .name = "WF402" },
  { .ov = 29, .code = 0x4a4f, .word = 0xf418, .immediate=0, .flags=0x80, .name = ".READINGS" },
  { .ov = 29, .code = 0x224c, .word = 0xf433, .immediate=0, .flags=0x80, .name = "(/SENSORS)" },
  { .ov = 30, .code = 0x744d, .word = 0xf206, .immediate=0, .flags=0x00, .name = "WF206" },
  { .ov = 30, .code = 0x744d, .word = 0xf20b, .immediate=0, .flags=0x00, .name = "WF20B" },
  { .ov = 30, .code = 0x744d, .word = 0xf210, .immediate=0, .flags=0x00, .name = "WF210" },
  { .ov = 30, .code = 0x744d, .word = 0xf215, .immediate=0, .flags=0x00, .name = "WF215" },
  { .ov = 30, .code = 0x73ea, .word = 0xf21a, .immediate=0, .flags=0x00, .name = "WF21A" },
  { .ov = 30, .code = 0x73ea, .word = 0xf222, .immediate=0, .flags=0x00, .name = "WF222" },
  { .ov = 30, .code = 0x224c, .word = 0xf22a, .immediate=0, .flags=0x00, .name = "WF22A" },
  { .ov = 30, .code = 0x224c, .word = 0xf234, .immediate=0, .flags=0x00, .name = "WF234" },
  { .ov = 30, .code = 0x224c, .word = 0xf246, .immediate=0, .flags=0x00, .name = "WF246" },
  { .ov = 30, .code = 0x224c, .word = 0xf250, .immediate=0, .flags=0x00, .name = "WF250" },
  { .ov = 30, .code = 0x224c, .word = 0xf272, .immediate=0, .flags=0x00, .name = "WF272" },
  { .ov = 30, .code = 0x224c, .word = 0xf2b3, .immediate=0, .flags=0x80, .name = ">DOWN-SHIELD" },
  { .ov = 30, .code = 0x224c, .word = 0xf359, .immediate=0, .flags=0x00, .name = "WF359" },
  { .ov = 30, .code = 0x224c, .word = 0xf3b5, .immediate=0, .flags=0x80, .name = ">DISARM" },
  { .ov = 30, .code = 0x224c, .word = 0xf3fb, .immediate=0, .flags=0x00, .name = "WF3FB" },
  { .ov = 30, .code = 0x224c, .word = 0xf4c8, .immediate=0, .flags=0x80, .name = "(/(DIS)ARM)" },
  { .ov = 30, .code = 0x224c, .word = 0xf4fa, .immediate=0, .flags=0x80, .name = "(/(UD)SHIELD)" },
  { .ov = 31, .code = 0x1d29, .word = 0xedb6, .immediate=0, .flags=0x00, .name = "WEDB6" },
  { .ov = 31, .code = 0x744d, .word = 0xedba, .immediate=0, .flags=0x00, .name = "WEDBA" },
  { .ov = 31, .code = 0x744d, .word = 0xedbf, .immediate=0, .flags=0x00, .name = "WEDBF" },
  { .ov = 31, .code = 0x744d, .word = 0xedc4, .immediate=0, .flags=0x00, .name = "WEDC4" },
  { .ov = 31, .code = 0x744d, .word = 0xedc9, .immediate=0, .flags=0x00, .name = "WEDC9" },
  { .ov = 31, .code = 0x224c, .word = 0xedce, .immediate=0, .flags=0x00, .name = "WEDCE" },
  { .ov = 31, .code = 0x224c, .word = 0xedd8, .immediate=0, .flags=0x00, .name = "WEDD8" },
  { .ov = 31, .code = 0x224c, .word = 0xede2, .immediate=0, .flags=0x00, .name = "WEDE2" },
  { .ov = 31, .code = 0x224c, .word = 0xedec, .immediate=0, .flags=0x00, .name = "WEDEC" },
  { .ov = 31, .code = 0x224c, .word = 0xee24, .immediate=0, .flags=0x00, .name = "WEE24" },
  { .ov = 31, .code = 0x224c, .word = 0xee30, .immediate=0, .flags=0x00, .name = "WEE30" },
  { .ov = 31, .code = 0x224c, .word = 0xee4a, .immediate=0, .flags=0x00, .name = "WEE4A" },
  { .ov = 31, .code = 0x224c, .word = 0xee6c, .immediate=0, .flags=0x00, .name = "WEE6C" },
  { .ov = 31, .code = 0x224c, .word = 0xeeba, .immediate=0, .flags=0x00, .name = "WEEBA" },
  { .ov = 31, .code = 0x224c, .word = 0xeee2, .immediate=0, .flags=0x00, .name = "WEEE2" },
  { .ov = 31, .code = 0x224c, .word = 0xef06, .immediate=0, .flags=0x00, .name = "WEF06" },
  { .ov = 31, .code = 0x224c, .word = 0xef3a, .immediate=0, .flags=0x00, .name = "WEF3A" },
  { .ov = 31, .code = 0x224c, .word = 0xef50, .immediate=0, .flags=0x00, .name = "WEF50" },
  { .ov = 31, .code = 0x224c, .word = 0xef5e, .immediate=0, .flags=0x00, .name = "WEF5E" },
  { .ov = 31, .code = 0x224c, .word = 0xef68, .immediate=0, .flags=0x00, .name = "WEF68" },
  { .ov = 31, .code = 0x224c, .word = 0xef8c, .immediate=0, .flags=0x00, .name = "WEF8C" },
  { .ov = 31, .code = 0x4a4f, .word = 0xefa0, .immediate=0, .flags=0x80, .name = "(GET-AUX)" },
  { .ov = 31, .code = 0x224c, .word = 0xefc2, .immediate=0, .flags=0x00, .name = "WEFC2" },
  { .ov = 31, .code = 0x224c, .word = 0xefe4, .immediate=0, .flags=0x00, .name = "WEFE4" },
  { .ov = 31, .code = 0x224c, .word = 0xeffc, .immediate=0, .flags=0x00, .name = "WEFFC" },
  { .ov = 31, .code = 0x4a4f, .word = 0xf031, .immediate=0, .flags=0x80, .name = "1.1BTN.XEQ" },
  { .ov = 31, .code = 0x224c, .word = 0xf03f, .immediate=0, .flags=0x00, .name = "WF03F" },
  { .ov = 31, .code = 0x224c, .word = 0xf077, .immediate=0, .flags=0x00, .name = "WF077" },
  { .ov = 31, .code = 0x224c, .word = 0xf095, .immediate=0, .flags=0x00, .name = "WF095" },
  { .ov = 31, .code = 0x224c, .word = 0xf148, .immediate=0, .flags=0x00, .name = "WF148" },
  { .ov = 31, .code = 0x4a4f, .word = 0xf180, .immediate=0, .flags=0x80, .name = ">DISEMBARK" },
  { .ov = 31, .code = 0x224c, .word = 0xf18e, .immediate=0, .flags=0x00, .name = "WF18E" },
  { .ov = 31, .code = 0x224c, .word = 0xf1e2, .immediate=0, .flags=0x00, .name = "WF1E2" },
  { .ov = 31, .code = 0x224c, .word = 0xf1f6, .immediate=0, .flags=0x00, .name = "WF1F6" },
  { .ov = 31, .code = 0x224c, .word = 0xf200, .immediate=0, .flags=0x00, .name = "WF200" },
  { .ov = 31, .code = 0x224c, .word = 0xf20a, .immediate=0, .flags=0x00, .name = "WF20A" },
  { .ov = 31, .code = 0x4a4f, .word = 0xf21f, .immediate=0, .flags=0x80, .name = "1BTN.XEQ" },
  { .ov = 31, .code = 0x224c, .word = 0xf239, .immediate=0, .flags=0x00, .name = "WF239" },
  { .ov = 31, .code = 0x224c, .word = 0xf245, .immediate=0, .flags=0x00, .name = "WF245" },
  { .ov = 31, .code = 0x224c, .word = 0xf251, .immediate=0, .flags=0x00, .name = "WF251" },
  { .ov = 31, .code = 0x4a4f, .word = 0xf264, .immediate=0, .flags=0x80, .name = "2BTN.XEQ" },
  { .ov = 31, .code = 0x224c, .word = 0xf276, .immediate=0, .flags=0x00, .name = "WF276" },
  { .ov = 31, .code = 0x224c, .word = 0xf284, .immediate=0, .flags=0x00, .name = "WF284" },
  { .ov = 31, .code = 0x224c, .word = 0xf294, .immediate=0, .flags=0x00, .name = "WF294" },
  { .ov = 31, .code = 0x224c, .word = 0xf29e, .immediate=0, .flags=0x00, .name = "WF29E" },
  { .ov = 31, .code = 0x224c, .word = 0xf2ae, .immediate=0, .flags=0x00, .name = "WF2AE" },
  { .ov = 31, .code = 0x4a4f, .word = 0xf2cb, .immediate=0, .flags=0x80, .name = "3BTN.XEQ" },
  { .ov = 31, .code = 0x224c, .word = 0xf2e5, .immediate=0, .flags=0x00, .name = "WF2E5" },
  { .ov = 31, .code = 0x224c, .word = 0xf2ed, .immediate=0, .flags=0x00, .name = "WF2ED" },
  { .ov = 31, .code = 0x4a4f, .word = 0xf304, .immediate=0, .flags=0x80, .name = "4BTN.XEQ" },
  { .ov = 31, .code = 0x224c, .word = 0xf312, .immediate=0, .flags=0x00, .name = "WF312" },
  { .ov = 31, .code = 0x224c, .word = 0xf31c, .immediate=0, .flags=0x00, .name = "WF31C" },
  { .ov = 31, .code = 0x4a4f, .word = 0xf331, .immediate=0, .flags=0x80, .name = "6BTN.XEQ" },
  { .ov = 31, .code = 0x224c, .word = 0xf33f, .immediate=0, .flags=0x00, .name = "WF33F" },
  { .ov = 31, .code = 0x224c, .word = 0xf35b, .immediate=0, .flags=0x00, .name = "WF35B" },
  { .ov = 31, .code = 0x224c, .word = 0xf373, .immediate=0, .flags=0x00, .name = "WF373" },
  { .ov = 31, .code = 0x224c, .word = 0xf38b, .immediate=0, .flags=0x00, .name = "WF38B" },
  { .ov = 31, .code = 0x224c, .word = 0xf3a3, .immediate=0, .flags=0x00, .name = "WF3A3" },
  { .ov = 31, .code = 0x224c, .word = 0xf3b3, .immediate=0, .flags=0x00, .name = "WF3B3" },
  { .ov = 31, .code = 0x4a4f, .word = 0xf3d6, .immediate=0, .flags=0x80, .name = "0BTN.XEQ" },
  { .ov = 31, .code = 0x224c, .word = 0xf3f0, .immediate=0, .flags=0x00, .name = "WF3F0" },
  { .ov = 31, .code = 0x224c, .word = 0xf3fe, .immediate=0, .flags=0x00, .name = "WF3FE" },
  { .ov = 31, .code = 0x224c, .word = 0xf41a, .immediate=0, .flags=0x00, .name = "WF41A" },
  { .ov = 31, .code = 0x224c, .word = 0xf4a0, .immediate=0, .flags=0x00, .name = "WF4A0" },
  { .ov = 31, .code = 0x224c, .word = 0xf4b5, .immediate=0, .flags=0x80, .name = ">FLT" },
  { .ov = 32, .code = 0x1d29, .word = 0xe536, .immediate=0, .flags=0x00, .name = "WE536" },
  { .ov = 32, .code = 0x1d29, .word = 0xe53a, .immediate=0, .flags=0x00, .name = "WE53A" },
  { .ov = 32, .code = 0x1d29, .word = 0xe53e, .immediate=0, .flags=0x00, .name = "WE53E" },
  { .ov = 32, .code = 0x1d29, .word = 0xe542, .immediate=0, .flags=0x00, .name = "WE542" },
  { .ov = 32, .code = 0x1d29, .word = 0xe546, .immediate=0, .flags=0x00, .name = "WE546" },
  { .ov = 32, .code = 0x1d29, .word = 0xe54a, .immediate=0, .flags=0x00, .name = "WE54A" },
  { .ov = 32, .code = 0x1d29, .word = 0xe54e, .immediate=0, .flags=0x00, .name = "WE54E" },
  { .ov = 32, .code = 0x1d29, .word = 0xe552, .immediate=0, .flags=0x00, .name = "WE552" },
  { .ov = 32, .code = 0x1d29, .word = 0xe556, .immediate=0, .flags=0x00, .name = "WE556" },
  { .ov = 32, .code = 0x744d, .word = 0xe55a, .immediate=0, .flags=0x00, .name = "WE55A" },
  { .ov = 32, .code = 0x744d, .word = 0xe55f, .immediate=0, .flags=0x00, .name = "WE55F" },
  { .ov = 32, .code = 0x744d, .word = 0xe564, .immediate=0, .flags=0x00, .name = "WE564" },
  { .ov = 32, .code = 0x1d29, .word = 0xe569, .immediate=0, .flags=0x00, .name = "WE569" },
  { .ov = 32, .code = 0x1d29, .word = 0xe577, .immediate=0, .flags=0x00, .name = "WE577" },
  { .ov = 32, .code = 0x224c, .word = 0xe57b, .immediate=0, .flags=0x00, .name = "WE57B" },
  { .ov = 32, .code = 0x224c, .word = 0xe595, .immediate=0, .flags=0x00, .name = "WE595" },
  { .ov = 32, .code = 0x224c, .word = 0xe613, .immediate=0, .flags=0x00, .name = "WE613" },
  { .ov = 32, .code = 0x224c, .word = 0xe673, .immediate=0, .flags=0x00, .name = "WE673" },
  { .ov = 32, .code = 0x224c, .word = 0xe687, .immediate=0, .flags=0x00, .name = "WE687" },
  { .ov = 32, .code = 0x224c, .word = 0xe71f, .immediate=0, .flags=0x00, .name = "WE71F" },
  { .ov = 32, .code = 0x224c, .word = 0xe72b, .immediate=0, .flags=0x00, .name = "WE72B" },
  { .ov = 32, .code = 0x224c, .word = 0xe818, .immediate=0, .flags=0x00, .name = "WE818" },
  { .ov = 32, .code = 0x224c, .word = 0xe85c, .immediate=0, .flags=0x00, .name = "WE85C" },
  { .ov = 32, .code = 0x224c, .word = 0xe8a8, .immediate=0, .flags=0x00, .name = "WE8A8" },
  { .ov = 32, .code = 0x224c, .word = 0xe8f2, .immediate=0, .flags=0x00, .name = "WE8F2" },
  { .ov = 32, .code = 0x224c, .word = 0xe942, .immediate=0, .flags=0x00, .name = "WE942" },
  { .ov = 32, .code = 0x224c, .word = 0xe97e, .immediate=0, .flags=0x00, .name = "WE97E" },
  { .ov = 32, .code = 0x224c, .word = 0xe9b6, .immediate=0, .flags=0x00, .name = "WE9B6" },
  { .ov = 32, .code = 0x224c, .word = 0xe9be, .immediate=0, .flags=0x00, .name = "WE9BE" },
  { .ov = 32, .code = 0x224c, .word = 0xea4c, .immediate=0, .flags=0x00, .name = "WEA4C" },
  { .ov = 32, .code = 0x224c, .word = 0xea70, .immediate=0, .flags=0x00, .name = "WEA70" },
  { .ov = 32, .code = 0x224c, .word = 0xeaa2, .immediate=0, .flags=0x00, .name = "WEAA2" },
  { .ov = 32, .code = 0x224c, .word = 0xeaae, .immediate=0, .flags=0x00, .name = "WEAAE" },
  { .ov = 32, .code = 0x224c, .word = 0xeac6, .immediate=0, .flags=0x00, .name = "WEAC6" },
  { .ov = 32, .code = 0x224c, .word = 0xead8, .immediate=0, .flags=0x00, .name = "WEAD8" },
  { .ov = 32, .code = 0x224c, .word = 0xeb1a, .immediate=0, .flags=0x00, .name = "WEB1A" },
  { .ov = 32, .code = 0x224c, .word = 0xeb3a, .immediate=0, .flags=0x00, .name = "WEB3A" },
  { .ov = 32, .code = 0x224c, .word = 0xeb91, .immediate=0, .flags=0x00, .name = "WEB91" },
  { .ov = 32, .code = 0x224c, .word = 0xebcf, .immediate=0, .flags=0x00, .name = "WEBCF" },
  { .ov = 32, .code = 0x224c, .word = 0xec0f, .immediate=0, .flags=0x00, .name = "WEC0F" },
  { .ov = 32, .code = 0x224c, .word = 0xec57, .immediate=0, .flags=0x00, .name = "WEC57" },
  { .ov = 32, .code = 0x224c, .word = 0xec82, .immediate=0, .flags=0x00, .name = "WEC82" },
  { .ov = 32, .code = 0x224c, .word = 0xecac, .immediate=0, .flags=0x00, .name = "WECAC" },
  { .ov = 32, .code = 0x224c, .word = 0xecc0, .immediate=0, .flags=0x00, .name = "WECC0" },
  { .ov = 32, .code = 0x224c, .word = 0xed4c, .immediate=0, .flags=0x00, .name = "WED4C" },
  { .ov = 32, .code = 0x224c, .word = 0xed6f, .immediate=0, .flags=0x80, .name = "(/STARMAP)" },
  { .ov = 33, .code = 0x224c, .word = 0xd976, .immediate=0, .flags=0x00, .name = "SET-'EXTERNAL" },
  { .ov = 33, .code = 0x224c, .word = 0xd980, .immediate=0, .flags=0x00, .name = "SHP>C" },
  { .ov = 33, .code = 0x224c, .word = 0xd988, .immediate=0, .flags=0x00, .name = "PLN>C" },
  { .ov = 33, .code = 0x224c, .word = 0xd990, .immediate=0, .flags=0x00, .name = "ORB>C" },
  { .ov = 33, .code = 0x224c, .word = 0xd998, .immediate=0, .flags=0x00, .name = "SYS>C" },
  { .ov = 33, .code = 0x224c, .word = 0xd9a0, .immediate=0, .flags=0x00, .name = "ENC>C" },
  { .ov = 33, .code = 0x224c, .word = 0xd9a8, .immediate=0, .flags=0x00, .name = "2ICLOSE" },
  { .ov = 33, .code = 0x2214, .word = 0xd9b0, .immediate=0, .flags=0x00, .name = "RCOLLIDE" },
  { .ov = 33, .code = 0x2214, .word = 0xd9b4, .immediate=0, .flags=0x00, .name = "PRTRADIUS" },
  { .ov = 33, .code = 0x2214, .word = 0xd9b8, .immediate=0, .flags=0x00, .name = "DEFRADIUS" },
  { .ov = 33, .code = 0x2214, .word = 0xd9bc, .immediate=0, .flags=0x00, .name = "ORBRADIUS" },
  { .ov = 33, .code = 0x2214, .word = 0xd9c0, .immediate=0, .flags=0x00, .name = "ENCRADIUS" },
  { .ov = 33, .code = 0x2214, .word = 0xd9c4, .immediate=0, .flags=0x00, .name = "SYSRADIUS" },
  { .ov = 33, .code = 0x2214, .word = 0xd9c8, .immediate=0, .flags=0x00, .name = "VISLENGTH" },
  { .ov = 33, .code = 0x2214, .word = 0xd9cc, .immediate=0, .flags=0x00, .name = "VISWIDTH" },
  { .ov = 33, .code = 0x2214, .word = 0xd9d0, .immediate=0, .flags=0x00, .name = "BVISOFF" },
  { .ov = 33, .code = 0x2214, .word = 0xd9d4, .immediate=0, .flags=0x00, .name = "LVISOFF" },
  { .ov = 33, .code = 0x2214, .word = 0xd9d8, .immediate=0, .flags=0x00, .name = "MAXSPEED" },
  { .ov = 33, .code = 0x1d29, .word = 0xd9dc, .immediate=0, .flags=0x00, .name = "(RADIUS)" },
  { .ov = 33, .code = 0x1d29, .word = 0xd9e0, .immediate=0, .flags=0x00, .name = "[CONTEXT]" },
  { .ov = 33, .code = 0x1d29, .word = 0xd9e4, .immediate=0, .flags=0x00, .name = "WD9E4" },
  { .ov = 33, .code = 0x1d29, .word = 0xd9e8, .immediate=0, .flags=0x00, .name = "WD9E8" },
  { .ov = 33, .code = 0x1d29, .word = 0xd9ec, .immediate=0, .flags=0x00, .name = "WD9EC" },
  { .ov = 33, .code = 0x1d29, .word = 0xd9f0, .immediate=0, .flags=0x00, .name = "(COLLIDE)" },
  { .ov = 33, .code = 0x1d29, .word = 0xd9f6, .immediate=0, .flags=0x00, .name = "XCRS" },
  { .ov = 33, .code = 0x1d29, .word = 0xd9fa, .immediate=0, .flags=0x00, .name = "YCRS" },
  { .ov = 33, .code = 0x1d29, .word = 0xd9fe, .immediate=0, .flags=0x00, .name = "NAV-SKILL" },
  { .ov = 33, .code = 0x1d29, .word = 0xda02, .immediate=0, .flags=0x00, .name = "'AUX-CLEAN" },
  { .ov = 33, .code = 0x1d29, .word = 0xda06, .immediate=0, .flags=0x00, .name = "?HAS-RING-DEVICE" },
  { .ov = 33, .code = 0x1d29, .word = 0xda0a, .immediate=0, .flags=0x00, .name = "ESPEED" },
  { .ov = 33, .code = 0x1d29, .word = 0xda0e, .immediate=0, .flags=0x00, .name = "?HW" },
  { .ov = 33, .code = 0x1d29, .word = 0xda12, .immediate=0, .flags=0x00, .name = "WDA12" },
  { .ov = 33, .code = 0x1d29, .word = 0xda16, .immediate=0, .flags=0x00, .name = "WDA16" },
  { .ov = 33, .code = 0x744d, .word = 0xda1a, .immediate=0, .flags=0x00, .name = "%ACC" },
  { .ov = 33, .code = 0x744d, .word = 0xda1f, .immediate=0, .flags=0x00, .name = "%HEADING" },
  { .ov = 33, .code = 0x744d, .word = 0xda24, .immediate=0, .flags=0x00, .name = "%ENGINE" },
  { .ov = 33, .code = 0x744d, .word = 0xda29, .immediate=0, .flags=0x00, .name = "%ACLASS" },
  { .ov = 33, .code = 0x744d, .word = 0xda2e, .immediate=0, .flags=0x00, .name = "SCNT" },
  { .ov = 33, .code = 0x744d, .word = 0xda33, .immediate=0, .flags=0x00, .name = "%SCLASS" },
  { .ov = 33, .code = 0x744d, .word = 0xda38, .immediate=0, .flags=0x00, .name = "ACNT" },
  { .ov = 33, .code = 0x744d, .word = 0xda3d, .immediate=0, .flags=0x00, .name = "WDA3D" },
  { .ov = 33, .code = 0x744d, .word = 0xda42, .immediate=0, .flags=0x00, .name = "WDA42" },
  { .ov = 33, .code = 0x744d, .word = 0xda47, .immediate=0, .flags=0x00, .name = "DEST-X" },
  { .ov = 33, .code = 0x744d, .word = 0xda4c, .immediate=0, .flags=0x00, .name = "DEST-Y" },
  { .ov = 33, .code = 0x744d, .word = 0xda51, .immediate=0, .flags=0x00, .name = "?HOME-PLANET" },
  { .ov = 33, .code = 0x744d, .word = 0xda56, .immediate=0, .flags=0x00, .name = "WDA56" },
  { .ov = 33, .code = 0x744d, .word = 0xda5b, .immediate=0, .flags=0x00, .name = "ORBIT-MASK" },
  { .ov = 33, .code = 0x744d, .word = 0xda60, .immediate=0, .flags=0x00, .name = "FLAREDATE" },
  { .ov = 33, .code = 0x73ea, .word = 0xda65, .immediate=0, .flags=0x00, .name = "WDA65" },
  { .ov = 33, .code = 0x744d, .word = 0xda6d, .immediate=0, .flags=0x00, .name = "BET" },
  { .ov = 33, .code = 0x224c, .word = 0xda72, .immediate=0, .flags=0x00, .name = "@COORDS" },
  { .ov = 33, .code = 0x224c, .word = 0xda7c, .immediate=0, .flags=0x00, .name = "!COORDS" },
  { .ov = 33, .code = 0x224c, .word = 0xda86, .immediate=0, .flags=0x00, .name = "!XYTRNS" },
  { .ov = 33, .code = 0x224c, .word = 0xda92, .immediate=0, .flags=0x00, .name = "@XYABS" },
  { .ov = 33, .code = 0x224c, .word = 0xda9e, .immediate=0, .flags=0x00, .name = "@XYSHP" },
  { .ov = 33, .code = 0x224c, .word = 0xdaa8, .immediate=0, .flags=0x00, .name = "CTXT#" },
  { .ov = 33, .code = 0x224c, .word = 0xdab0, .immediate=0, .flags=0x00, .name = "!XYSHP" },
  { .ov = 33, .code = 0x224c, .word = 0xdaba, .immediate=0, .flags=0x00, .name = "!%HEADING" },
  { .ov = 33, .code = 0x224c, .word = 0xdac6, .immediate=0, .flags=0x00, .name = "?XIDENC" },
  { .ov = 33, .code = 0x224c, .word = 0xdad0, .immediate=0, .flags=0x00, .name = "0XYCRS" },
  { .ov = 33, .code = 0x224c, .word = 0xdade, .immediate=0, .flags=0x00, .name = "?PLANET" },
  { .ov = 33, .code = 0x224c, .word = 0xdaea, .immediate=0, .flags=0x00, .name = "?*ORPLAN" },
  { .ov = 33, .code = 0x224c, .word = 0xdafa, .immediate=0, .flags=0x00, .name = "?HYPER" },
  { .ov = 33, .code = 0x224c, .word = 0xdb04, .immediate=0, .flags=0x00, .name = "ORBSETUP" },
  { .ov = 33, .code = 0x224c, .word = 0xdb32, .immediate=0, .flags=0x00, .name = "WDB32" },
  { .ov = 33, .code = 0x224c, .word = 0xdb60, .immediate=0, .flags=0x00, .name = "WDB60" },
  { .ov = 33, .code = 0x224c, .word = 0xdb72, .immediate=0, .flags=0x00, .name = ".AUXSHIP" },
  { .ov = 33, .code = 0x744d, .word = 0xdbd2, .immediate=0, .flags=0x00, .name = "MAX#SHIPS" },
  { .ov = 33, .code = 0x744d, .word = 0xdbd7, .immediate=0, .flags=0x00, .name = "#SHIPS-DESTROYED" },
  { .ov = 33, .code = 0x744d, .word = 0xdbdc, .immediate=0, .flags=0x00, .name = "BASE-EDL" },
  { .ov = 33, .code = 0x744d, .word = 0xdbe1, .immediate=0, .flags=0x00, .name = "NAV" },
  { .ov = 33, .code = 0x744d, .word = 0xdbe6, .immediate=0, .flags=0x00, .name = "^NAV" },
  { .ov = 33, .code = 0x224c, .word = 0xdbeb, .immediate=0, .flags=0x00, .name = "WDBEB" },
  { .ov = 33, .code = 0x224c, .word = 0xdc19, .immediate=0, .flags=0x00, .name = "WDC19" },
  { .ov = 33, .code = 0x224c, .word = 0xdc45, .immediate=0, .flags=0x00, .name = "CHARGE-D" },
  { .ov = 33, .code = 0x4a4f, .word = 0xdc82, .immediate=0, .flags=0x80, .name = "PS>C" },
  { .ov = 33, .code = 0x224c, .word = 0xdc9c, .immediate=0, .flags=0x00, .name = ">CONS-DISP" },
  { .ov = 33, .code = 0x224c, .word = 0xdcc6, .immediate=0, .flags=0x00, .name = "ENCCLEANUP" },
  { .ov = 33, .code = 0x224c, .word = 0xdd6a, .immediate=0, .flags=0x00, .name = "ENCSETUP" },
  { .ov = 33, .code = 0x224c, .word = 0xddc4, .immediate=0, .flags=0x00, .name = "PRTSETUP" },
  { .ov = 33, .code = 0x224c, .word = 0xddda, .immediate=0, .flags=0x00, .name = "PRTCLEANUP" },
  { .ov = 33, .code = 0x224c, .word = 0xddf2, .immediate=0, .flags=0x00, .name = "MAKE-STAR" },
  { .ov = 33, .code = 0x224c, .word = 0xde12, .immediate=0, .flags=0x00, .name = "KILL-STAR" },
  { .ov = 33, .code = 0x1d29, .word = 0xde2a, .immediate=0, .flags=0x00, .name = "PREV-ORBIT" },
  { .ov = 33, .code = 0x1d29, .word = 0xde2e, .immediate=0, .flags=0x00, .name = "ORBITs" },
  { .ov = 33, .code = 0x224c, .word = 0xde32, .immediate=0, .flags=0x00, .name = "GET-ORBIT#" },
  { .ov = 33, .code = 0x224c, .word = 0xde5e, .immediate=0, .flags=0x00, .name = "(>ORBIT)" },
  { .ov = 33, .code = 0x224c, .word = 0xdeac, .immediate=0, .flags=0x00, .name = "ORBIT>" },
  { .ov = 33, .code = 0x224c, .word = 0xded6, .immediate=0, .flags=0x00, .name = ">ORBITS" },
  { .ov = 33, .code = 0x224c, .word = 0xdef6, .immediate=0, .flags=0x00, .name = "?-ORBIT" },
  { .ov = 33, .code = 0x224c, .word = 0xdf16, .immediate=0, .flags=0x00, .name = "WDF16" },
  { .ov = 33, .code = 0x224c, .word = 0xdf36, .immediate=0, .flags=0x00, .name = "WDF36" },
  { .ov = 33, .code = 0x224c, .word = 0xdf40, .immediate=0, .flags=0x00, .name = "SETRNDXY" },
  { .ov = 33, .code = 0x224c, .word = 0xdf5e, .immediate=0, .flags=0x00, .name = "WDF5E" },
  { .ov = 33, .code = 0x224c, .word = 0xdfb0, .immediate=0, .flags=0x00, .name = "OCOORDS" },
  { .ov = 33, .code = 0x4a4f, .word = 0xdfce, .immediate=0, .flags=0x80, .name = ">XY" },
  { .ov = 33, .code = 0x224c, .word = 0xdfdc, .immediate=0, .flags=0x00, .name = "SETPLNXY" },
  { .ov = 33, .code = 0x4a4f, .word = 0xe001, .immediate=0, .flags=0x80, .name = "SC>C" },
  { .ov = 33, .code = 0x224c, .word = 0xe01f, .immediate=0, .flags=0x00, .name = ".SUN" },
  { .ov = 33, .code = 0x224c, .word = 0xe033, .immediate=0, .flags=0x00, .name = ".PLANET" },
  { .ov = 33, .code = 0x224c, .word = 0xe0a3, .immediate=0, .flags=0x80, .name = ".AUXSYS" },
  { .ov = 33, .code = 0x224c, .word = 0xe107, .immediate=0, .flags=0x00, .name = "SYSSETUP" },
  { .ov = 33, .code = 0x224c, .word = 0xe12b, .immediate=0, .flags=0x00, .name = "SYSCLEANUP" },
  { .ov = 33, .code = 0x224c, .word = 0xe155, .immediate=0, .flags=0x00, .name = "RNDCPT" },
  { .ov = 33, .code = 0x224c, .word = 0xe1a1, .immediate=0, .flags=0x00, .name = "?CAN-NAVIGATE" },
  { .ov = 33, .code = 0x224c, .word = 0xe1af, .immediate=0, .flags=0x00, .name = ">[CONTEXT]" },
  { .ov = 33, .code = 0x224c, .word = 0xe1cb, .immediate=0, .flags=0x00, .name = "CTX>C" },
  { .ov = 33, .code = 0x224c, .word = 0xe1d3, .immediate=0, .flags=0x00, .name = "![CONTEXT]" },
  { .ov = 33, .code = 0x4a4f, .word = 0xe1e7, .immediate=0, .flags=0x80, .name = "RADII" },
  { .ov = 33, .code = 0x4a4f, .word = 0xe204, .immediate=0, .flags=0x80, .name = "IVAR" },
  { .ov = 33, .code = 0x224c, .word = 0xe21a, .immediate=0, .flags=0x00, .name = "#CPARMS" },
  { .ov = 33, .code = 0x224c, .word = 0xe23a, .immediate=0, .flags=0x00, .name = "!CPARMS" },
  { .ov = 33, .code = 0x224c, .word = 0xe252, .immediate=0, .flags=0x00, .name = "WE252" },
  { .ov = 33, .code = 0x224c, .word = 0xe258, .immediate=0, .flags=0x00, .name = "WE258" },
  { .ov = 33, .code = 0x224c, .word = 0xe262, .immediate=0, .flags=0x00, .name = "WE262" },
  { .ov = 33, .code = 0x4a4f, .word = 0xe285, .immediate=0, .flags=0x80, .name = "XYCASE" },
  { .ov = 33, .code = 0x224c, .word = 0xe293, .immediate=0, .flags=0x00, .name = ".COORDINATES" },
  { .ov = 33, .code = 0x2214, .word = 0xe2fb, .immediate=0, .flags=0x00, .name = "XBND" },
  { .ov = 33, .code = 0x2214, .word = 0xe2ff, .immediate=0, .flags=0x00, .name = "YBND" },
  { .ov = 33, .code = 0x2214, .word = 0xe303, .immediate=0, .flags=0x00, .name = "XLIM" },
  { .ov = 33, .code = 0x2214, .word = 0xe307, .immediate=0, .flags=0x00, .name = "YLIM" },
  { .ov = 33, .code = 0x1d29, .word = 0xe30b, .immediate=0, .flags=0x00, .name = "SDUST" },
  { .ov = 33, .code = 0x224c, .word = 0xe325, .immediate=0, .flags=0x00, .name = ">DUST" },
  { .ov = 33, .code = 0x224c, .word = 0xe351, .immediate=0, .flags=0x00, .name = "?DUST" },
  { .ov = 33, .code = 0x224c, .word = 0xe375, .immediate=0, .flags=0x00, .name = "(.DUST)" },
  { .ov = 33, .code = 0x224c, .word = 0xe3c9, .immediate=0, .flags=0x00, .name = ".DUST" },
  { .ov = 33, .code = 0x224c, .word = 0xe3f6, .immediate=0, .flags=0x80, .name = ".MVS" },
  { .ov = 33, .code = 0x224c, .word = 0xe442, .immediate=0, .flags=0x00, .name = ".FLUX-ICON" },
  { .ov = 33, .code = 0x224c, .word = 0xe4ba, .immediate=0, .flags=0x00, .name = "?CHANGEXY" },
  { .ov = 33, .code = 0x224c, .word = 0xe4fa, .immediate=0, .flags=0x00, .name = "(?NEWHEADXY)" },
  { .ov = 33, .code = 0x224c, .word = 0xe560, .immediate=0, .flags=0x00, .name = ">NEWHEADXY" },
  { .ov = 33, .code = 0x224c, .word = 0xe570, .immediate=0, .flags=0x00, .name = "#SLOPE" },
  { .ov = 33, .code = 0x224c, .word = 0xe58e, .immediate=0, .flags=0x00, .name = "#RELXY" },
  { .ov = 33, .code = 0x224c, .word = 0xe59e, .immediate=0, .flags=0x00, .name = "#QUAD" },
  { .ov = 33, .code = 0x224c, .word = 0xe5ee, .immediate=0, .flags=0x00, .name = "#HEADING" },
  { .ov = 33, .code = 0x1d29, .word = 0xe65e, .immediate=0, .flags=0x00, .name = "HEADDXDY" },
  { .ov = 33, .code = 0x224c, .word = 0xe670, .immediate=0, .flags=0x00, .name = "#HEADDXDY" },
  { .ov = 33, .code = 0x224c, .word = 0xe684, .immediate=0, .flags=0x00, .name = "#NEXTXY" },
  { .ov = 33, .code = 0x224c, .word = 0xe6a0, .immediate=0, .flags=0x00, .name = "#VECTXY" },
  { .ov = 33, .code = 0x224c, .word = 0xe6be, .immediate=0, .flags=0x00, .name = "#DIST" },
  { .ov = 33, .code = 0x224c, .word = 0xe6e4, .immediate=0, .flags=0x00, .name = "#SPEED" },
  { .ov = 33, .code = 0x224c, .word = 0xe6f8, .immediate=0, .flags=0x00, .name = "#NEWHEADXY" },
  { .ov = 33, .code = 0x224c, .word = 0xe728, .immediate=0, .flags=0x00, .name = "DWITHIN" },
  { .ov = 33, .code = 0x224c, .word = 0xe742, .immediate=0, .flags=0x00, .name = "(-ENDURIUM)" },
  { .ov = 33, .code = 0x224c, .word = 0xe7ec, .immediate=0, .flags=0x00, .name = "-ENDURIUM" },
  { .ov = 33, .code = 0x224c, .word = 0xe808, .immediate=0, .flags=0x80, .name = "USE-E" },
  { .ov = 33, .code = 0x224c, .word = 0xe85e, .immediate=0, .flags=0x00, .name = "?IN-NEB" },
  { .ov = 33, .code = 0x224c, .word = 0xe8f2, .immediate=0, .flags=0x00, .name = "#VES-SPEED" },
  { .ov = 33, .code = 0x2214, .word = 0xe906, .immediate=0, .flags=0x00, .name = "TWELVE" },
  { .ov = 33, .code = 0x4a4f, .word = 0xe913, .immediate=0, .flags=0x80, .name = "CSPEED" },
  { .ov = 33, .code = 0x1d29, .word = 0xe921, .immediate=0, .flags=0x00, .name = "#ACC" },
  { .ov = 33, .code = 0x1d29, .word = 0xe925, .immediate=0, .flags=0x00, .name = "KEYINC" },
  { .ov = 33, .code = 0x224c, .word = 0xe929, .immediate=0, .flags=0x00, .name = "!MAXSPEED" },
  { .ov = 33, .code = 0x224c, .word = 0xe93f, .immediate=0, .flags=0x00, .name = "!S/A" },
  { .ov = 33, .code = 0x224c, .word = 0xe95f, .immediate=0, .flags=0x00, .name = "ACCELERATE" },
  { .ov = 33, .code = 0x4a4f, .word = 0xe9a5, .immediate=0, .flags=0x80, .name = "NEST-SETUP" },
  { .ov = 33, .code = 0x224c, .word = 0xe9bb, .immediate=0, .flags=0x00, .name = "NEST-SPACEXY" },
  { .ov = 33, .code = 0x224c, .word = 0xe9f0, .immediate=0, .flags=0x80, .name = "NEST" },
  { .ov = 33, .code = 0x224c, .word = 0xea5a, .immediate=0, .flags=0x00, .name = ">ENCOUNTER" },
  { .ov = 33, .code = 0x224c, .word = 0xea80, .immediate=0, .flags=0x00, .name = "?BOX-NEST" },
  { .ov = 33, .code = 0x224c, .word = 0xeaa4, .immediate=0, .flags=0x00, .name = "SET-FLUX-STATE" },
  { .ov = 33, .code = 0x224c, .word = 0xeae3, .immediate=0, .flags=0x80, .name = "JMPSHP" },
  { .ov = 33, .code = 0x224c, .word = 0xeb1d, .immediate=0, .flags=0x00, .name = ">FLUX-NODE" },
  { .ov = 33, .code = 0x4a4f, .word = 0xeb53, .immediate=0, .flags=0x80, .name = "COLLIDE" },
  { .ov = 33, .code = 0x224c, .word = 0xeb6d, .immediate=0, .flags=0x00, .name = "?-*BOX" },
  { .ov = 33, .code = 0x4a4f, .word = 0xeb85, .immediate=0, .flags=0x80, .name = "?~C" },
  { .ov = 33, .code = 0x224c, .word = 0xeb97, .immediate=0, .flags=0x00, .name = "?COLLISION" },
  { .ov = 33, .code = 0x224c, .word = 0xec39, .immediate=0, .flags=0x00, .name = "WEC39" },
  { .ov = 33, .code = 0x224c, .word = 0xec5d, .immediate=0, .flags=0x00, .name = "?2NEST.ETC" },
  { .ov = 33, .code = 0x224c, .word = 0xeca9, .immediate=0, .flags=0x00, .name = "?STARPORT" },
  { .ov = 33, .code = 0x4a4f, .word = 0xed32, .immediate=0, .flags=0x80, .name = "UNNEST-CLEAN" },
  { .ov = 33, .code = 0x224c, .word = 0xed48, .immediate=0, .flags=0x00, .name = "UNNEST-SPACEXY" },
  { .ov = 33, .code = 0x224c, .word = 0xed6c, .immediate=0, .flags=0x00, .name = "?UNNEST" },
  { .ov = 33, .code = 0x224c, .word = 0xedc2, .immediate=0, .flags=0x00, .name = "?DOUBLE-UNNEST" },
  { .ov = 33, .code = 0x224c, .word = 0xede3, .immediate=0, .flags=0x80, .name = "UNNEST" },
  { .ov = 33, .code = 0x224c, .word = 0xee53, .immediate=0, .flags=0x00, .name = "WEE53" },
  { .ov = 33, .code = 0x224c, .word = 0xee87, .immediate=0, .flags=0x80, .name = "(GET-AUX" },
  { .ov = 33, .code = 0x224c, .word = 0xee9b, .immediate=0, .flags=0x00, .name = "WEE9B" },
  { .ov = 33, .code = 0x224c, .word = 0xeec9, .immediate=0, .flags=0x80, .name = "FLY" },
  { .ov = 33, .code = 0x224c, .word = 0xef11, .immediate=0, .flags=0x00, .name = "WEF11" },
  { .ov = 33, .code = 0x224c, .word = 0xef37, .immediate=0, .flags=0x80, .name = "SET-DESTINATION" },
  { .ov = 33, .code = 0x224c, .word = 0xf003, .immediate=0, .flags=0x80, .name = "SETUP-MOV" },
  { .ov = 33, .code = 0x224c, .word = 0xf0ab, .immediate=0, .flags=0x80, .name = "CLEANUP-MOV" },
  { .ov = 33, .code = 0x224c, .word = 0xf125, .immediate=0, .flags=0x80, .name = "CHK-MOV" },
  { .ov = 33, .code = 0x224c, .word = 0xf1b5, .immediate=0, .flags=0x00, .name = "WF1B5" },
  { .ov = 33, .code = 0x224c, .word = 0xf1ee, .immediate=0, .flags=0x80, .name = "+NEST" },
  { .ov = 33, .code = 0x224c, .word = 0xf204, .immediate=0, .flags=0x80, .name = "COME-HITHER" },
  { .ov = 34, .code = 0x744d, .word = 0xeb76, .immediate=0, .flags=0x00, .name = "%MASS" },
  { .ov = 34, .code = 0x744d, .word = 0xeb7b, .immediate=0, .flags=0x00, .name = "WEB7B" },
  { .ov = 34, .code = 0x744d, .word = 0xeb80, .immediate=0, .flags=0x00, .name = "WEB80" },
  { .ov = 34, .code = 0x73ea, .word = 0xeb85, .immediate=0, .flags=0x00, .name = "WEB85" },
  { .ov = 34, .code = 0x73ea, .word = 0xeb8d, .immediate=0, .flags=0x00, .name = "WEB8D" },
  { .ov = 34, .code = 0x744d, .word = 0xeb95, .immediate=0, .flags=0x00, .name = "WEB95" },
  { .ov = 34, .code = 0x73ea, .word = 0xeb9a, .immediate=0, .flags=0x00, .name = "WEB9A" },
  { .ov = 34, .code = 0x73ea, .word = 0xeba2, .immediate=0, .flags=0x00, .name = "WEBA2" },
  { .ov = 34, .code = 0x73ea, .word = 0xebaa, .immediate=0, .flags=0x00, .name = "WEBAA" },
  { .ov = 34, .code = 0x73ea, .word = 0xebb2, .immediate=0, .flags=0x00, .name = "WEBB2" },
  { .ov = 34, .code = 0x73ea, .word = 0xebba, .immediate=0, .flags=0x00, .name = "WEBBA" },
  { .ov = 34, .code = 0x744d, .word = 0xebc2, .immediate=0, .flags=0x00, .name = "WEBC2" },
  { .ov = 34, .code = 0x73ea, .word = 0xebc7, .immediate=0, .flags=0x00, .name = "WEBC7" },
  { .ov = 34, .code = 0x73ea, .word = 0xebcf, .immediate=0, .flags=0x00, .name = "WEBCF" },
  { .ov = 34, .code = 0x73ea, .word = 0xebd7, .immediate=0, .flags=0x00, .name = "WEBD7" },
  { .ov = 34, .code = 0x73ea, .word = 0xebdf, .immediate=0, .flags=0x00, .name = "ATMO.ACTIVITY" },
  { .ov = 34, .code = 0x73ea, .word = 0xebe7, .immediate=0, .flags=0x00, .name = "WEBE7" },
  { .ov = 34, .code = 0x73ea, .word = 0xebef, .immediate=0, .flags=0x00, .name = "WEBEF" },
  { .ov = 34, .code = 0x73ea, .word = 0xebf7, .immediate=0, .flags=0x00, .name = "WEBF7" },
  { .ov = 34, .code = 0x744d, .word = 0xebff, .immediate=0, .flags=0x00, .name = "WEBFF" },
  { .ov = 34, .code = 0x224c, .word = 0xec04, .immediate=0, .flags=0x00, .name = "WEC04" },
  { .ov = 34, .code = 0x224c, .word = 0xec26, .immediate=0, .flags=0x00, .name = "WEC26" },
  { .ov = 34, .code = 0x224c, .word = 0xec62, .immediate=0, .flags=0x00, .name = "WEC62" },
  { .ov = 34, .code = 0x224c, .word = 0xec6f, .immediate=0, .flags=0x00, .name = "WEC6F" },
  { .ov = 34, .code = 0x224c, .word = 0xec7c, .immediate=0, .flags=0x00, .name = "WEC7C" },
  { .ov = 34, .code = 0x224c, .word = 0xec89, .immediate=0, .flags=0x00, .name = "WEC89" },
  { .ov = 34, .code = 0x4a4f, .word = 0xeca4, .immediate=0, .flags=0x80, .name = "(.VESSEL)" },
  { .ov = 34, .code = 0x224c, .word = 0xecb6, .immediate=0, .flags=0x00, .name = "WECB6" },
  { .ov = 34, .code = 0x224c, .word = 0xecbe, .immediate=0, .flags=0x00, .name = "WECBE" },
  { .ov = 34, .code = 0x224c, .word = 0xeccb, .immediate=0, .flags=0x00, .name = "WECCB" },
  { .ov = 34, .code = 0x224c, .word = 0xecd8, .immediate=0, .flags=0x00, .name = "WECD8" },
  { .ov = 34, .code = 0x4a4f, .word = 0xed03, .immediate=0, .flags=0x80, .name = "(.OBJECT)" },
  { .ov = 34, .code = 0x224c, .word = 0xed19, .immediate=0, .flags=0x00, .name = ".OBJECT" },
  { .ov = 34, .code = 0x224c, .word = 0xed5c, .immediate=0, .flags=0x00, .name = "WED5C" },
  { .ov = 34, .code = 0x224c, .word = 0xed72, .immediate=0, .flags=0x00, .name = ".SIZE" },
  { .ov = 34, .code = 0x224c, .word = 0xedc9, .immediate=0, .flags=0x00, .name = "?.CERTAIN" },
  { .ov = 34, .code = 0x224c, .word = 0xee09, .immediate=0, .flags=0x00, .name = "HEADER" },
  { .ov = 34, .code = 0x224c, .word = 0xee15, .immediate=0, .flags=0x00, .name = "WEE15" },
  { .ov = 34, .code = 0x224c, .word = 0xee25, .immediate=0, .flags=0x00, .name = "WEE25" },
  { .ov = 34, .code = 0x224c, .word = 0xee31, .immediate=0, .flags=0x00, .name = "WEE31" },
  { .ov = 34, .code = 0x4a4f, .word = 0xee49, .immediate=0, .flags=0x80, .name = "(.TYPE)" },
  { .ov = 34, .code = 0x224c, .word = 0xee5b, .immediate=0, .flags=0x00, .name = ".TYPE" },
  { .ov = 34, .code = 0x224c, .word = 0xee76, .immediate=0, .flags=0x00, .name = "WEE76" },
  { .ov = 34, .code = 0x224c, .word = 0xee81, .immediate=0, .flags=0x00, .name = ".SHIELDS" },
  { .ov = 34, .code = 0x224c, .word = 0xef07, .immediate=0, .flags=0x00, .name = ".WEAP" },
  { .ov = 34, .code = 0x224c, .word = 0xef3c, .immediate=0, .flags=0x00, .name = ".DELEM" },
  { .ov = 34, .code = 0x224c, .word = 0xef8e, .immediate=0, .flags=0x00, .name = ".CONSTIT" },
  { .ov = 34, .code = 0x224c, .word = 0xefb7, .immediate=0, .flags=0x00, .name = "WEFB7" },
  { .ov = 34, .code = 0x224c, .word = 0xefc5, .immediate=0, .flags=0x00, .name = ".ORBIT" },
  { .ov = 34, .code = 0x224c, .word = 0xefec, .immediate=0, .flags=0x00, .name = "WEFEC" },
  { .ov = 34, .code = 0x224c, .word = 0xeff9, .immediate=0, .flags=0x00, .name = "WEFF9" },
  { .ov = 34, .code = 0x224c, .word = 0xf006, .immediate=0, .flags=0x00, .name = "WF006" },
  { .ov = 34, .code = 0x224c, .word = 0xf016, .immediate=0, .flags=0x00, .name = "WF016" },
  { .ov = 34, .code = 0x224c, .word = 0xf025, .immediate=0, .flags=0x00, .name = "WF025" },
  { .ov = 34, .code = 0x224c, .word = 0xf033, .immediate=0, .flags=0x00, .name = "WF033" },
  { .ov = 34, .code = 0x4a4f, .word = 0xf04a, .immediate=0, .flags=0x80, .name = ".TDESC" },
  { .ov = 34, .code = 0x224c, .word = 0xf068, .immediate=0, .flags=0x00, .name = "WF068" },
  { .ov = 34, .code = 0x224c, .word = 0xf0a7, .immediate=0, .flags=0x00, .name = "WF0A7" },
  { .ov = 34, .code = 0x224c, .word = 0xf0b1, .immediate=0, .flags=0x00, .name = "WF0B1" },
  { .ov = 34, .code = 0x224c, .word = 0xf0be, .immediate=0, .flags=0x00, .name = "WF0BE" },
  { .ov = 34, .code = 0x224c, .word = 0xf0cb, .immediate=0, .flags=0x00, .name = "WF0CB" },
  { .ov = 34, .code = 0x224c, .word = 0xf0d6, .immediate=0, .flags=0x00, .name = "WF0D6" },
  { .ov = 34, .code = 0x4a4f, .word = 0xf0ed, .immediate=0, .flags=0x80, .name = "(.SURF)" },
  { .ov = 34, .code = 0x224c, .word = 0xf107, .immediate=0, .flags=0x00, .name = ".SURF" },
  { .ov = 34, .code = 0x224c, .word = 0xf131, .immediate=0, .flags=0x00, .name = ".GRAV" },
  { .ov = 34, .code = 0x224c, .word = 0xf193, .immediate=0, .flags=0x00, .name = "WF193" },
  { .ov = 34, .code = 0x224c, .word = 0xf19e, .immediate=0, .flags=0x00, .name = "WF19E" },
  { .ov = 34, .code = 0x224c, .word = 0xf1ac, .immediate=0, .flags=0x00, .name = "WF1AC" },
  { .ov = 34, .code = 0x224c, .word = 0xf1bb, .immediate=0, .flags=0x00, .name = "WF1BB" },
  { .ov = 34, .code = 0x224c, .word = 0xf1c7, .immediate=0, .flags=0x00, .name = "WF1C7" },
  { .ov = 34, .code = 0x4a4f, .word = 0xf1df, .immediate=0, .flags=0x80, .name = "(.ATMO)" },
  { .ov = 34, .code = 0x224c, .word = 0xf1f9, .immediate=0, .flags=0x00, .name = "WF1F9" },
  { .ov = 34, .code = 0x224c, .word = 0xf223, .immediate=0, .flags=0x00, .name = "WF223" },
  { .ov = 34, .code = 0x224c, .word = 0xf22e, .immediate=0, .flags=0x00, .name = "WF22E" },
  { .ov = 34, .code = 0x224c, .word = 0xf23d, .immediate=0, .flags=0x00, .name = "WF23D" },
  { .ov = 34, .code = 0x224c, .word = 0xf24b, .immediate=0, .flags=0x00, .name = "WF24B" },
  { .ov = 34, .code = 0x4a4f, .word = 0xf264, .immediate=0, .flags=0x80, .name = "(.WEATH)" },
  { .ov = 34, .code = 0x224c, .word = 0xf27a, .immediate=0, .flags=0x00, .name = ".WEATH" },
  { .ov = 34, .code = 0x224c, .word = 0xf29f, .immediate=0, .flags=0x00, .name = "WF29F" },
  { .ov = 34, .code = 0x1d29, .word = 0xf2bf, .immediate=0, .flags=0x00, .name = "WF2BF" },
  { .ov = 34, .code = 0x224c, .word = 0xf2c8, .immediate=0, .flags=0x00, .name = "WF2C8" },
  { .ov = 34, .code = 0x224c, .word = 0xf2f2, .immediate=0, .flags=0x00, .name = "WF2F2" },
  { .ov = 34, .code = 0x224c, .word = 0xf31e, .immediate=0, .flags=0x00, .name = "WF31E" },
  { .ov = 34, .code = 0x224c, .word = 0xf3eb, .immediate=0, .flags=0x00, .name = "WF3EB" },
  { .ov = 34, .code = 0x224c, .word = 0xf3f1, .immediate=0, .flags=0x00, .name = "WF3F1" },
  { .ov = 34, .code = 0x224c, .word = 0xf3f7, .immediate=0, .flags=0x00, .name = "WF3F7" },
  { .ov = 34, .code = 0x4a4f, .word = 0xf410, .immediate=0, .flags=0x80, .name = "(.V/P-OBJ)" },
  { .ov = 34, .code = 0x224c, .word = 0xf41e, .immediate=0, .flags=0x00, .name = "WF41E" },
  { .ov = 34, .code = 0x224c, .word = 0xf426, .immediate=0, .flags=0x00, .name = "WF426" },
  { .ov = 34, .code = 0x224c, .word = 0xf436, .immediate=0, .flags=0x00, .name = "WF436" },
  { .ov = 34, .code = 0x4a4f, .word = 0xf458, .immediate=0, .flags=0x80, .name = "(.ANALYSIS)" },
  { .ov = 34, .code = 0x224c, .word = 0xf478, .immediate=0, .flags=0x80, .name = "(/ANALYSIS)" },
  { .ov = 35, .code = 0x224c, .word = 0xf026, .immediate=0, .flags=0x00, .name = "WF026" },
  { .ov = 35, .code = 0x224c, .word = 0xf034, .immediate=0, .flags=0x00, .name = "WF034" },
  { .ov = 35, .code = 0x224c, .word = 0xf064, .immediate=0, .flags=0x00, .name = "WF064" },
  { .ov = 35, .code = 0x224c, .word = 0xf07a, .immediate=0, .flags=0x00, .name = "WF07A" },
  { .ov = 35, .code = 0x224c, .word = 0xf08c, .immediate=0, .flags=0x00, .name = "WF08C" },
  { .ov = 35, .code = 0x224c, .word = 0xf09a, .immediate=0, .flags=0x00, .name = "COUNTDOWN" },
  { .ov = 35, .code = 0x224c, .word = 0xf0ce, .immediate=0, .flags=0x00, .name = "LAUNCH" },
  { .ov = 35, .code = 0x224c, .word = 0xf112, .immediate=0, .flags=0x00, .name = "WF112" },
  { .ov = 35, .code = 0x224c, .word = 0xf152, .immediate=0, .flags=0x00, .name = "VSXLINE" },
  { .ov = 35, .code = 0x224c, .word = 0xf162, .immediate=0, .flags=0x00, .name = ".STARLINE" },
  { .ov = 35, .code = 0x224c, .word = 0xf1c0, .immediate=0, .flags=0x00, .name = "WF1C0" },
  { .ov = 35, .code = 0x224c, .word = 0xf1de, .immediate=0, .flags=0x00, .name = "WF1DE" },
  { .ov = 35, .code = 0x1d29, .word = 0xf1fc, .immediate=0, .flags=0x00, .name = "WF1FC" },
  { .ov = 35, .code = 0x224c, .word = 0xf23b, .immediate=0, .flags=0x80, .name = ".AIRLOCK" },
  { .ov = 35, .code = 0x224c, .word = 0xf2e2, .immediate=0, .flags=0x00, .name = "WF2E2" },
  { .ov = 35, .code = 0x224c, .word = 0xf2ee, .immediate=0, .flags=0x00, .name = "WF2EE" },
  { .ov = 35, .code = 0x224c, .word = 0xf2fc, .immediate=0, .flags=0x00, .name = "WF2FC" },
  { .ov = 35, .code = 0x224c, .word = 0xf306, .immediate=0, .flags=0x00, .name = "WF306" },
  { .ov = 35, .code = 0x224c, .word = 0xf36c, .immediate=0, .flags=0x00, .name = "PORTLEAVE" },
  { .ov = 35, .code = 0x224c, .word = 0xf393, .immediate=0, .flags=0x00, .name = "WF393" },
  { .ov = 35, .code = 0x224c, .word = 0xf3fb, .immediate=0, .flags=0x80, .name = "&LAUNCH" },
  { .ov = 35, .code = 0x224c, .word = 0xf455, .immediate=0, .flags=0x80, .name = "&RETURN" },
  { .ov = 36, .code = 0x1d29, .word = 0xf3a6, .immediate=0, .flags=0x00, .name = "HYPER-DOTS" },
  { .ov = 36, .code = 0x1d29, .word = 0xf3da, .immediate=0, .flags=0x00, .name = "?STAR-TRAIL" },
  { .ov = 36, .code = 0x224c, .word = 0xf3de, .immediate=0, .flags=0x00, .name = "WF3DE" },
  { .ov = 36, .code = 0x224c, .word = 0xf3f0, .immediate=0, .flags=0x00, .name = "NOVA" },
  { .ov = 36, .code = 0x224c, .word = 0xf456, .immediate=0, .flags=0x00, .name = "INIT-HYPER-STARS" },
  { .ov = 36, .code = 0x224c, .word = 0xf470, .immediate=0, .flags=0x00, .name = "HYPER-PLOT" },
  { .ov = 36, .code = 0x224c, .word = 0xf4d0, .immediate=0, .flags=0x00, .name = "HYPER-FRAME" },
  { .ov = 36, .code = 0x224c, .word = 0xf505, .immediate=0, .flags=0x80, .name = "FLUX" },
  { .ov = 37, .code = 0x1d29, .word = 0xe446, .immediate=0, .flags=0x00, .name = "WE446" },
  { .ov = 37, .code = 0x224c, .word = 0xe44a, .immediate=0, .flags=0x00, .name = "WE44A" },
  { .ov = 37, .code = 0x744d, .word = 0xe452, .immediate=0, .flags=0x00, .name = "WE452" },
  { .ov = 37, .code = 0x744d, .word = 0xe457, .immediate=0, .flags=0x00, .name = "WE457" },
  { .ov = 37, .code = 0x744d, .word = 0xe45c, .immediate=0, .flags=0x00, .name = "WE45C" },
  { .ov = 37, .code = 0x744d, .word = 0xe461, .immediate=0, .flags=0x00, .name = "WE461" },
  { .ov = 37, .code = 0x744d, .word = 0xe466, .immediate=0, .flags=0x00, .name = "WE466" },
  { .ov = 37, .code = 0x744d, .word = 0xe46b, .immediate=0, .flags=0x00, .name = "WE46B" },
  { .ov = 37, .code = 0x744d, .word = 0xe470, .immediate=0, .flags=0x00, .name = "WE470" },
  { .ov = 37, .code = 0x744d, .word = 0xe475, .immediate=0, .flags=0x00, .name = "WE475" },
  { .ov = 37, .code = 0x224c, .word = 0xe47a, .immediate=0, .flags=0x00, .name = "WE47A" },
  { .ov = 37, .code = 0x224c, .word = 0xe484, .immediate=0, .flags=0x00, .name = "WE484" },
  { .ov = 37, .code = 0x224c, .word = 0xe494, .immediate=0, .flags=0x00, .name = "WE494" },
  { .ov = 37, .code = 0x1d29, .word = 0xe4a6, .immediate=0, .flags=0x00, .name = "WE4A6" },
  { .ov = 37, .code = 0x224c, .word = 0xe4e2, .immediate=0, .flags=0x00, .name = "WE4E2" },
  { .ov = 37, .code = 0x224c, .word = 0xe50e, .immediate=0, .flags=0x00, .name = "WE50E" },
  { .ov = 37, .code = 0x1d29, .word = 0xe58c, .immediate=0, .flags=0x00, .name = "WE58C" },
  { .ov = 37, .code = 0x224c, .word = 0xe59b, .immediate=0, .flags=0x00, .name = "WE59B" },
  { .ov = 37, .code = 0x224c, .word = 0xe5f7, .immediate=0, .flags=0x00, .name = "WE5F7" },
  { .ov = 37, .code = 0x224c, .word = 0xe637, .immediate=0, .flags=0x00, .name = "WE637" },
  { .ov = 37, .code = 0x224c, .word = 0xe665, .immediate=0, .flags=0x00, .name = "WE665" },
  { .ov = 37, .code = 0x224c, .word = 0xe6d3, .immediate=0, .flags=0x00, .name = "WE6D3" },
  { .ov = 37, .code = 0x224c, .word = 0xe735, .immediate=0, .flags=0x00, .name = "WE735" },
  { .ov = 37, .code = 0x224c, .word = 0xe78b, .immediate=0, .flags=0x00, .name = "WE78B" },
  { .ov = 37, .code = 0x224c, .word = 0xe7ca, .immediate=0, .flags=0x00, .name = "WE7CA" },
  { .ov = 37, .code = 0x224c, .word = 0xe81c, .immediate=0, .flags=0x00, .name = "WE81C" },
  { .ov = 37, .code = 0x224c, .word = 0xe842, .immediate=0, .flags=0x00, .name = "WE842" },
  { .ov = 37, .code = 0x1d29, .word = 0xe852, .immediate=0, .flags=0x00, .name = "WE852" },
  { .ov = 37, .code = 0x224c, .word = 0xe856, .immediate=0, .flags=0x00, .name = "WE856" },
  { .ov = 37, .code = 0x224c, .word = 0xe866, .immediate=0, .flags=0x00, .name = "WE866" },
  { .ov = 37, .code = 0x224c, .word = 0xe88a, .immediate=0, .flags=0x00, .name = "WE88A" },
  { .ov = 37, .code = 0x224c, .word = 0xe8b6, .immediate=0, .flags=0x00, .name = "WE8B6" },
  { .ov = 37, .code = 0x224c, .word = 0xe8d4, .immediate=0, .flags=0x00, .name = "WE8D4" },
  { .ov = 37, .code = 0x1d29, .word = 0xe8fe, .immediate=0, .flags=0x00, .name = "WE8FE" },
  { .ov = 37, .code = 0x224c, .word = 0xe902, .immediate=0, .flags=0x00, .name = "WE902" },
  { .ov = 37, .code = 0x224c, .word = 0xe912, .immediate=0, .flags=0x00, .name = "WE912" },
  { .ov = 37, .code = 0x224c, .word = 0xe9e2, .immediate=0, .flags=0x00, .name = "WE9E2" },
  { .ov = 37, .code = 0x224c, .word = 0xe9fc, .immediate=0, .flags=0x00, .name = "WE9FC" },
  { .ov = 37, .code = 0x4a4f, .word = 0xea1a, .immediate=0, .flags=0x80, .name = "(NOTICES)" },
  { .ov = 37, .code = 0x224c, .word = 0xea28, .immediate=0, .flags=0x00, .name = "WEA28" },
  { .ov = 37, .code = 0x224c, .word = 0xeb09, .immediate=0, .flags=0x00, .name = "WEB09" },
  { .ov = 37, .code = 0x224c, .word = 0xebc1, .immediate=0, .flags=0x00, .name = "WEBC1" },
  { .ov = 37, .code = 0x224c, .word = 0xec30, .immediate=0, .flags=0x00, .name = "WEC30" },
  { .ov = 37, .code = 0x224c, .word = 0xec60, .immediate=0, .flags=0x00, .name = "WEC60" },
  { .ov = 37, .code = 0x224c, .word = 0xec74, .immediate=0, .flags=0x00, .name = "WEC74" },
  { .ov = 37, .code = 0x224c, .word = 0xec88, .immediate=0, .flags=0x00, .name = "WEC88" },
  { .ov = 37, .code = 0x224c, .word = 0xeca0, .immediate=0, .flags=0x00, .name = "WECA0" },
  { .ov = 37, .code = 0x224c, .word = 0xecb6, .immediate=0, .flags=0x00, .name = "WECB6" },
  { .ov = 37, .code = 0x224c, .word = 0xeccc, .immediate=0, .flags=0x00, .name = "WECCC" },
  { .ov = 37, .code = 0x4a4f, .word = 0xecee, .immediate=0, .flags=0x80, .name = "(BAD-PLAN)" },
  { .ov = 37, .code = 0x224c, .word = 0xed0c, .immediate=0, .flags=0x00, .name = "WED0C" },
  { .ov = 37, .code = 0x224c, .word = 0xee19, .immediate=0, .flags=0x00, .name = "WEE19" },
  { .ov = 37, .code = 0x224c, .word = 0xee55, .immediate=0, .flags=0x00, .name = "WEE55" },
  { .ov = 37, .code = 0x224c, .word = 0xee8c, .immediate=0, .flags=0x00, .name = "WEE8C" },
  { .ov = 37, .code = 0x224c, .word = 0xeee3, .immediate=0, .flags=0x00, .name = "WEEE3" },
  { .ov = 37, .code = 0x224c, .word = 0xef37, .immediate=0, .flags=0x00, .name = "WEF37" },
  { .ov = 37, .code = 0x224c, .word = 0xefbc, .immediate=0, .flags=0x00, .name = "WEFBC" },
  { .ov = 37, .code = 0x224c, .word = 0xeff8, .immediate=0, .flags=0x00, .name = "WEFF8" },
  { .ov = 37, .code = 0x224c, .word = 0xf02b, .immediate=0, .flags=0x00, .name = "WF02B" },
  { .ov = 37, .code = 0x224c, .word = 0xf045, .immediate=0, .flags=0x00, .name = "WF045" },
  { .ov = 37, .code = 0x224c, .word = 0xf12c, .immediate=0, .flags=0x00, .name = "WF12C" },
  { .ov = 37, .code = 0x224c, .word = 0xf274, .immediate=0, .flags=0x00, .name = "WF274" },
  { .ov = 37, .code = 0x224c, .word = 0xf450, .immediate=0, .flags=0x00, .name = "WF450" },
  { .ov = 37, .code = 0x224c, .word = 0xf47a, .immediate=0, .flags=0x00, .name = "WF47A" },
  { .ov = 37, .code = 0x4a4f, .word = 0xf4e0, .immediate=0, .flags=0x80, .name = "OP-CASE" },
  { .ov = 37, .code = 0x224c, .word = 0xf4fb, .immediate=0, .flags=0x80, .name = "(U-OP)" },
  { .ov = 38, .code = 0x1d29, .word = 0xddf6, .immediate=0, .flags=0x00, .name = "revision" },
  { .ov = 38, .code = 0x1d29, .word = 0xddfa, .immediate=0, .flags=0x00, .name = "ttlines" },
  { .ov = 38, .code = 0x1d29, .word = 0xddfe, .immediate=0, .flags=0x00, .name = "PHRASE-MEM" },
  { .ov = 38, .code = 0x1d29, .word = 0xdec9, .immediate=0, .flags=0x00, .name = "WDEC9" },
  { .ov = 38, .code = 0x224c, .word = 0xdecd, .immediate=0, .flags=0x00, .name = "WDECD" },
  { .ov = 38, .code = 0x224c, .word = 0xdf01, .immediate=0, .flags=0x00, .name = "WDF01" },
  { .ov = 38, .code = 0x224c, .word = 0xdf0b, .immediate=0, .flags=0x00, .name = "WDF0B" },
  { .ov = 38, .code = 0x224c, .word = 0xdf55, .immediate=0, .flags=0x00, .name = "WDF55" },
  { .ov = 38, .code = 0x2214, .word = 0xdf75, .immediate=0, .flags=0x00, .name = "WDF75" },
  { .ov = 38, .code = 0x224c, .word = 0xdf79, .immediate=0, .flags=0x00, .name = "WDF79" },
  { .ov = 38, .code = 0x224c, .word = 0xdfa9, .immediate=0, .flags=0x00, .name = "WRITE-PHRASE" },
  { .ov = 38, .code = 0x2214, .word = 0xdfd5, .immediate=0, .flags=0x00, .name = "planet" },
  { .ov = 38, .code = 0x2214, .word = 0xdfd9, .immediate=0, .flags=0x00, .name = "creature" },
  { .ov = 38, .code = 0x2214, .word = 0xdfdd, .immediate=0, .flags=0x00, .name = "artifact" },
  { .ov = 38, .code = 0x2214, .word = 0xdfe1, .immediate=0, .flags=0x00, .name = "analyze-text" },
  { .ov = 38, .code = 0x73ea, .word = 0xdfe5, .immediate=0, .flags=0x00, .name = "WDFE5" },
  { .ov = 38, .code = 0x744d, .word = 0xdfed, .immediate=0, .flags=0x00, .name = "WDFED" },
  { .ov = 38, .code = 0x744d, .word = 0xdff2, .immediate=0, .flags=0x00, .name = "content-vol" },
  { .ov = 38, .code = 0x73ea, .word = 0xdff7, .immediate=0, .flags=0x00, .name = "volume" },
  { .ov = 38, .code = 0x744d, .word = 0xdfff, .immediate=0, .flags=0x00, .name = "hits" },
  { .ov = 38, .code = 0x744d, .word = 0xe004, .immediate=0, .flags=0x00, .name = "behave" },
  { .ov = 38, .code = 0x73ea, .word = 0xe009, .immediate=0, .flags=0x00, .name = "biod" },
  { .ov = 38, .code = 0x744d, .word = 0xe011, .immediate=0, .flags=0x00, .name = "inst-starx" },
  { .ov = 38, .code = 0x744d, .word = 0xe016, .immediate=0, .flags=0x00, .name = "inst-stary" },
  { .ov = 38, .code = 0x744d, .word = 0xe01b, .immediate=0, .flags=0x00, .name = "inst-plan#" },
  { .ov = 38, .code = 0x224c, .word = 0xe020, .immediate=0, .flags=0x00, .name = "whichguy" },
  { .ov = 38, .code = 0x224c, .word = 0xe034, .immediate=0, .flags=0x00, .name = "reorg" },
  { .ov = 38, .code = 0x224c, .word = 0xe044, .immediate=0, .flags=0x00, .name = "WE044" },
  { .ov = 38, .code = 0x224c, .word = 0xe05e, .immediate=0, .flags=0x00, .name = "werase" },
  { .ov = 38, .code = 0x224c, .word = 0xe072, .immediate=0, .flags=0x00, .name = "WE072" },
  { .ov = 38, .code = 0x224c, .word = 0xe084, .immediate=0, .flags=0x00, .name = "WE084" },
  { .ov = 38, .code = 0x224c, .word = 0xe0b5, .immediate=0, .flags=0x00, .name = "art-analyz" },
  { .ov = 38, .code = 0x224c, .word = 0xe0dd, .immediate=0, .flags=0x00, .name = "WE0DD" },
  { .ov = 38, .code = 0x224c, .word = 0xe107, .immediate=0, .flags=0x00, .name = "WE107" },
  { .ov = 38, .code = 0x224c, .word = 0xe117, .immediate=0, .flags=0x00, .name = "WE117" },
  { .ov = 38, .code = 0x224c, .word = 0xe181, .immediate=0, .flags=0x00, .name = "WE181" },
  { .ov = 38, .code = 0x224c, .word = 0xe18e, .immediate=0, .flags=0x00, .name = "WE18E" },
  { .ov = 38, .code = 0x224c, .word = 0xe199, .immediate=0, .flags=0x00, .name = ".desc" },
  { .ov = 38, .code = 0x224c, .word = 0xe1a8, .immediate=0, .flags=0x00, .name = ".eras" },
  { .ov = 38, .code = 0x224c, .word = 0xe1b4, .immediate=0, .flags=0x00, .name = "WE1B4" },
  { .ov = 38, .code = 0x224c, .word = 0xe1c1, .immediate=0, .flags=0x00, .name = "lpos" },
  { .ov = 38, .code = 0x1d29, .word = 0xe1cb, .immediate=0, .flags=0x00, .name = "WE1CB" },
  { .ov = 38, .code = 0x1d29, .word = 0xe1cf, .immediate=0, .flags=0x00, .name = "WE1CF" },
  { .ov = 38, .code = 0x224c, .word = 0xe1d3, .immediate=0, .flags=0x00, .name = "#options!" },
  { .ov = 38, .code = 0x224c, .word = 0xe1db, .immediate=0, .flags=0x00, .name = "WE1DB" },
  { .ov = 38, .code = 0x224c, .word = 0xe1e9, .immediate=0, .flags=0x00, .name = "WE1E9" },
  { .ov = 38, .code = 0x224c, .word = 0xe1fd, .immediate=0, .flags=0x00, .name = "tm.opts" },
  { .ov = 38, .code = 0x224c, .word = 0xe216, .immediate=0, .flags=0x00, .name = "tl.opts" },
  { .ov = 38, .code = 0x224c, .word = 0xe224, .immediate=0, .flags=0x00, .name = "WE224" },
  { .ov = 38, .code = 0x224c, .word = 0xe238, .immediate=0, .flags=0x00, .name = "WE238" },
  { .ov = 38, .code = 0x4a4f, .word = 0xe258, .immediate=0, .flags=0x80, .name = "T.OPTIONS" },
  { .ov = 38, .code = 0x224c, .word = 0xe27e, .immediate=0, .flags=0x00, .name = "WE27E" },
  { .ov = 38, .code = 0x224c, .word = 0xe28c, .immediate=0, .flags=0x00, .name = "WE28C" },
  { .ov = 38, .code = 0x224c, .word = 0xe2a0, .immediate=0, .flags=0x00, .name = "WE2A0" },
  { .ov = 38, .code = 0x224c, .word = 0xe2b9, .immediate=0, .flags=0x00, .name = "WE2B9" },
  { .ov = 38, .code = 0x224c, .word = 0xe2f9, .immediate=0, .flags=0x00, .name = "WE2F9" },
  { .ov = 38, .code = 0x224c, .word = 0xe307, .immediate=0, .flags=0x00, .name = "WE307" },
  { .ov = 38, .code = 0x4a4f, .word = 0xe323, .immediate=0, .flags=0x80, .name = "P.OPTIONS" },
  { .ov = 38, .code = 0x224c, .word = 0xe341, .immediate=0, .flags=0x00, .name = "WE341" },
  { .ov = 38, .code = 0x224c, .word = 0xe369, .immediate=0, .flags=0x00, .name = "WE369" },
  { .ov = 38, .code = 0x224c, .word = 0xe38a, .immediate=0, .flags=0x00, .name = "volume+!" },
  { .ov = 38, .code = 0x224c, .word = 0xe398, .immediate=0, .flags=0x00, .name = "?VOLUME" },
  { .ov = 38, .code = 0x224c, .word = 0xe429, .immediate=0, .flags=0x80, .name = "(EXTRACT)" },
  { .ov = 38, .code = 0x224c, .word = 0xe45b, .immediate=0, .flags=0x00, .name = "plextract" },
  { .ov = 38, .code = 0x224c, .word = 0xe465, .immediate=0, .flags=0x00, .name = "tvextract" },
  { .ov = 38, .code = 0x73ea, .word = 0xe46f, .immediate=0, .flags=0x00, .name = "niche" },
  { .ov = 38, .code = 0x73ea, .word = 0xe477, .immediate=0, .flags=0x00, .name = "i.level" },
  { .ov = 38, .code = 0x73ea, .word = 0xe47f, .immediate=0, .flags=0x00, .name = "size.index" },
  { .ov = 38, .code = 0x224c, .word = 0xe487, .immediate=0, .flags=0x00, .name = "niche>val" },
  { .ov = 38, .code = 0x224c, .word = 0xe4bb, .immediate=0, .flags=0x00, .name = "?dist" },
  { .ov = 38, .code = 0x224c, .word = 0xe4f1, .immediate=0, .flags=0x00, .name = "valuate" },
  { .ov = 38, .code = 0x224c, .word = 0xe523, .immediate=0, .flags=0x00, .name = "1$=" },
  { .ov = 38, .code = 0x224c, .word = 0xe559, .immediate=0, .flags=0x00, .name = "info-setup" },
  { .ov = 38, .code = 0x224c, .word = 0xe567, .immediate=0, .flags=0x00, .name = "$setup" },
  { .ov = 38, .code = 0x224c, .word = 0xe593, .immediate=0, .flags=0x00, .name = "$match" },
  { .ov = 38, .code = 0x224c, .word = 0xe5c1, .immediate=0, .flags=0x00, .name = "tvxy" },
  { .ov = 38, .code = 0x224c, .word = 0xe5d3, .immediate=0, .flags=0x00, .name = "xy!" },
  { .ov = 38, .code = 0x224c, .word = 0xe5df, .immediate=0, .flags=0x00, .name = ".cargo" },
  { .ov = 38, .code = 0x224c, .word = 0xe61c, .immediate=0, .flags=0x00, .name = "?>spec" },
  { .ov = 38, .code = 0x224c, .word = 0xe638, .immediate=0, .flags=0x00, .name = "?attack" },
  { .ov = 38, .code = 0x224c, .word = 0xe672, .immediate=0, .flags=0x00, .name = "WE672" },
  { .ov = 38, .code = 0x224c, .word = 0xe67c, .immediate=0, .flags=0x00, .name = "WE67C" },
  { .ov = 38, .code = 0x224c, .word = 0xe6b8, .immediate=0, .flags=0x00, .name = "WE6B8" },
  { .ov = 38, .code = 0x224c, .word = 0xe72d, .immediate=0, .flags=0x00, .name = "WE72D" },
  { .ov = 38, .code = 0x224c, .word = 0xe75b, .immediate=0, .flags=0x00, .name = "WE75B" },
  { .ov = 38, .code = 0x224c, .word = 0xe80e, .immediate=0, .flags=0x00, .name = "WE80E" },
  { .ov = 38, .code = 0x224c, .word = 0xe836, .immediate=0, .flags=0x00, .name = "WE836" },
  { .ov = 38, .code = 0x224c, .word = 0xe85a, .immediate=0, .flags=0x00, .name = "WE85A" },
  { .ov = 38, .code = 0x224c, .word = 0xe87e, .immediate=0, .flags=0x00, .name = "WE87E" },
  { .ov = 38, .code = 0x224c, .word = 0xe8ae, .immediate=0, .flags=0x00, .name = "WE8AE" },
  { .ov = 38, .code = 0x224c, .word = 0xe900, .immediate=0, .flags=0x00, .name = "WE900" },
  { .ov = 38, .code = 0x224c, .word = 0xe908, .immediate=0, .flags=0x00, .name = "WE908" },
  { .ov = 38, .code = 0x224c, .word = 0xe910, .immediate=0, .flags=0x00, .name = "WE910" },
  { .ov = 38, .code = 0x224c, .word = 0xe9a0, .immediate=0, .flags=0x00, .name = "WE9A0" },
  { .ov = 38, .code = 0x224c, .word = 0xe9aa, .immediate=0, .flags=0x00, .name = "WE9AA" },
  { .ov = 38, .code = 0x224c, .word = 0xe9fa, .immediate=0, .flags=0x00, .name = "WE9FA" },
  { .ov = 38, .code = 0x224c, .word = 0xea32, .immediate=0, .flags=0x00, .name = "pickup" },
  { .ov = 38, .code = 0x224c, .word = 0xea50, .immediate=0, .flags=0x00, .name = "delete.it" },
  { .ov = 38, .code = 0x224c, .word = 0xea5e, .immediate=0, .flags=0x00, .name = "pldelete" },
  { .ov = 38, .code = 0x224c, .word = 0xea6c, .immediate=0, .flags=0x00, .name = "tvdelete" },
  { .ov = 38, .code = 0x224c, .word = 0xea76, .immediate=0, .flags=0x00, .name = "new>box" },
  { .ov = 38, .code = 0x1d29, .word = 0xeaba, .immediate=0, .flags=0x00, .name = "clsp" },
  { .ov = 38, .code = 0x224c, .word = 0xeac0, .immediate=0, .flags=0x00, .name = "?deposited" },
  { .ov = 38, .code = 0x224c, .word = 0xeb16, .immediate=0, .flags=0x00, .name = "dropit" },
  { .ov = 38, .code = 0x73ea, .word = 0xeb52, .immediate=0, .flags=0x00, .name = "art-anlyz" },
  { .ov = 38, .code = 0x73ea, .word = 0xeb5a, .immediate=0, .flags=0x00, .name = "art-text" },
  { .ov = 38, .code = 0x224c, .word = 0xeb62, .immediate=0, .flags=0x00, .name = "arttalk" },
  { .ov = 38, .code = 0x224c, .word = 0xeb86, .immediate=0, .flags=0x00, .name = "art.desc" },
  { .ov = 38, .code = 0x1d29, .word = 0xebcb, .immediate=0, .flags=0x00, .name = "WEBCB" },
  { .ov = 38, .code = 0x4a4f, .word = 0xebd8, .immediate=0, .flags=0x80, .name = "TS.ACT" },
  { .ov = 38, .code = 0x4a4f, .word = 0xebef, .immediate=0, .flags=0x80, .name = "PS.ACT" },
  { .ov = 38, .code = 0x224c, .word = 0xebf9, .immediate=0, .flags=0x00, .name = "WEBF9" },
  { .ov = 38, .code = 0x224c, .word = 0xec0d, .immediate=0, .flags=0x00, .name = "WEC0D" },
  { .ov = 38, .code = 0x224c, .word = 0xec2b, .immediate=0, .flags=0x00, .name = "WEC2B" },
  { .ov = 38, .code = 0x224c, .word = 0xec41, .immediate=0, .flags=0x00, .name = "WEC41" },
  { .ov = 38, .code = 0x224c, .word = 0xec51, .immediate=0, .flags=0x00, .name = "WEC51" },
  { .ov = 38, .code = 0x224c, .word = 0xec67, .immediate=0, .flags=0x00, .name = "WEC67" },
  { .ov = 38, .code = 0x224c, .word = 0xec6f, .immediate=0, .flags=0x00, .name = "WEC6F" },
  { .ov = 38, .code = 0x4a4f, .word = 0xec80, .immediate=0, .flags=0x80, .name = "PA.ACT" },
  { .ov = 38, .code = 0x4a4f, .word = 0xec97, .immediate=0, .flags=0x80, .name = "TA.ACT" },
  { .ov = 38, .code = 0x224c, .word = 0xeca5, .immediate=0, .flags=0x00, .name = "WECA5" },
  { .ov = 38, .code = 0x224c, .word = 0xecb9, .immediate=0, .flags=0x00, .name = "WECB9" },
  { .ov = 38, .code = 0x224c, .word = 0xecd3, .immediate=0, .flags=0x00, .name = "WECD3" },
  { .ov = 38, .code = 0x224c, .word = 0xed0b, .immediate=0, .flags=0x00, .name = "WED0B" },
  { .ov = 38, .code = 0x224c, .word = 0xed17, .immediate=0, .flags=0x00, .name = "WED17" },
  { .ov = 38, .code = 0x4a4f, .word = 0xed2e, .immediate=0, .flags=0x80, .name = "PM.ACT" },
  { .ov = 38, .code = 0x4a4f, .word = 0xed45, .immediate=0, .flags=0x80, .name = "TM.ACT" },
  { .ov = 38, .code = 0x224c, .word = 0xed53, .immediate=0, .flags=0x00, .name = "WED53" },
  { .ov = 38, .code = 0x224c, .word = 0xed67, .immediate=0, .flags=0x00, .name = "WED67" },
  { .ov = 38, .code = 0x4a4f, .word = 0xed98, .immediate=0, .flags=0x80, .name = "PL.ACT" },
  { .ov = 38, .code = 0x224c, .word = 0xedaa, .immediate=0, .flags=0x00, .name = "WEDAA" },
  { .ov = 38, .code = 0x4a4f, .word = 0xedc9, .immediate=0, .flags=0x80, .name = "DO.BIO" },
  { .ov = 38, .code = 0x4a4f, .word = 0xede2, .immediate=0, .flags=0x80, .name = "DISPATCH" },
  { .ov = 38, .code = 0x224c, .word = 0xee00, .immediate=0, .flags=0x00, .name = "WEE00" },
  { .ov = 38, .code = 0x224c, .word = 0xee3e, .immediate=0, .flags=0x00, .name = "WEE3E" },
  { .ov = 38, .code = 0x1d29, .word = 0xee93, .immediate=0, .flags=0x00, .name = "WEE93" },
  { .ov = 38, .code = 0x224c, .word = 0xee98, .immediate=0, .flags=0x00, .name = "WEE98" },
  { .ov = 38, .code = 0x224c, .word = 0xeea0, .immediate=0, .flags=0x00, .name = "WEEA0" },
  { .ov = 38, .code = 0x224c, .word = 0xeeb2, .immediate=0, .flags=0x00, .name = "WEEB2" },
  { .ov = 38, .code = 0x224c, .word = 0xeec4, .immediate=0, .flags=0x00, .name = "WEEC4" },
  { .ov = 38, .code = 0x224c, .word = 0xeed4, .immediate=0, .flags=0x00, .name = "WEED4" },
  { .ov = 38, .code = 0x224c, .word = 0xeee4, .immediate=0, .flags=0x00, .name = "WEEE4" },
  { .ov = 38, .code = 0x224c, .word = 0xef0c, .immediate=0, .flags=0x00, .name = "full-text" },
  { .ov = 38, .code = 0x224c, .word = 0xef20, .immediate=0, .flags=0x00, .name = "WEF20" },
  { .ov = 38, .code = 0x224c, .word = 0xef32, .immediate=0, .flags=0x00, .name = "WEF32" },
  { .ov = 38, .code = 0x224c, .word = 0xef62, .immediate=0, .flags=0x00, .name = "WEF62" },
  { .ov = 38, .code = 0x224c, .word = 0xef8e, .immediate=0, .flags=0x00, .name = "WEF8E" },
  { .ov = 38, .code = 0x224c, .word = 0xefa6, .immediate=0, .flags=0x00, .name = "WEFA6" },
  { .ov = 38, .code = 0x224c, .word = 0xefd4, .immediate=0, .flags=0x00, .name = "WEFD4" },
  { .ov = 38, .code = 0x224c, .word = 0xf002, .immediate=0, .flags=0x00, .name = "WF002" },
  { .ov = 38, .code = 0x224c, .word = 0xf028, .immediate=0, .flags=0x00, .name = "WF028" },
  { .ov = 38, .code = 0x224c, .word = 0xf0a8, .immediate=0, .flags=0x00, .name = "WF0A8" },
  { .ov = 38, .code = 0x224c, .word = 0xf0b4, .immediate=0, .flags=0x00, .name = "WF0B4" },
  { .ov = 38, .code = 0x224c, .word = 0xf0de, .immediate=0, .flags=0x00, .name = "WF0DE" },
  { .ov = 38, .code = 0x224c, .word = 0xf108, .immediate=0, .flags=0x00, .name = "qtbtn" },
  { .ov = 38, .code = 0x224c, .word = 0xf134, .immediate=0, .flags=0x00, .name = "WF134" },
  { .ov = 38, .code = 0x224c, .word = 0xf176, .immediate=0, .flags=0x00, .name = "WF176" },
  { .ov = 38, .code = 0x224c, .word = 0xf194, .immediate=0, .flags=0x00, .name = "WF194" },
  { .ov = 38, .code = 0x224c, .word = 0xf19c, .immediate=0, .flags=0x00, .name = "WF19C" },
  { .ov = 38, .code = 0x224c, .word = 0xf1a6, .immediate=0, .flags=0x00, .name = "WF1A6" },
  { .ov = 38, .code = 0x224c, .word = 0xf1d4, .immediate=0, .flags=0x00, .name = "WF1D4" },
  { .ov = 38, .code = 0x4a4f, .word = 0xf214, .immediate=0, .flags=0x80, .name = "TD-SCROLL" },
  { .ov = 38, .code = 0x224c, .word = 0xf222, .immediate=0, .flags=0x00, .name = "WF222" },
  { .ov = 38, .code = 0x224c, .word = 0xf252, .immediate=0, .flags=0x00, .name = "WF252" },
  { .ov = 38, .code = 0x224c, .word = 0xf29c, .immediate=0, .flags=0x00, .name = "WF29C" },
  { .ov = 38, .code = 0x224c, .word = 0xf2da, .immediate=0, .flags=0x00, .name = "WF2DA" },
  { .ov = 38, .code = 0x224c, .word = 0xf2ee, .immediate=0, .flags=0x00, .name = "WF2EE" },
  { .ov = 38, .code = 0x224c, .word = 0xf31c, .immediate=0, .flags=0x00, .name = "WF31C" },
  { .ov = 38, .code = 0x224c, .word = 0xf348, .immediate=0, .flags=0x00, .name = "WF348" },
  { .ov = 38, .code = 0x224c, .word = 0xf36a, .immediate=0, .flags=0x00, .name = "WF36A" },
  { .ov = 38, .code = 0x224c, .word = 0xf3d6, .immediate=0, .flags=0x00, .name = "WF3D6" },
  { .ov = 38, .code = 0x224c, .word = 0xf3f8, .immediate=0, .flags=0x00, .name = "WF3F8" },
  { .ov = 38, .code = 0x224c, .word = 0xf412, .immediate=0, .flags=0x00, .name = "WF412" },
  { .ov = 38, .code = 0x224c, .word = 0xf43a, .immediate=0, .flags=0x00, .name = "return-items" },
  { .ov = 38, .code = 0x224c, .word = 0xf44e, .immediate=0, .flags=0x80, .name = ">DEBRIS" },
  { .ov = 38, .code = 0x224c, .word = 0xf458, .immediate=0, .flags=0x00, .name = "WF458" },
  { .ov = 38, .code = 0x224c, .word = 0xf480, .immediate=0, .flags=0x00, .name = "WF480" },
  { .ov = 38, .code = 0x224c, .word = 0xf49b, .immediate=0, .flags=0x80, .name = "(/ITEMS)" },
  { .ov = 39, .code = 0x224c, .word = 0xe086, .immediate=0, .flags=0x00, .name = "WE086" },
  { .ov = 39, .code = 0x224c, .word = 0xe094, .immediate=0, .flags=0x00, .name = "WE094" },
  { .ov = 39, .code = 0x224c, .word = 0xe09c, .immediate=0, .flags=0x00, .name = "WE09C" },
  { .ov = 39, .code = 0x224c, .word = 0xe0a8, .immediate=0, .flags=0x00, .name = "WE0A8" },
  { .ov = 39, .code = 0x224c, .word = 0xe0b6, .immediate=0, .flags=0x00, .name = "WE0B6" },
  { .ov = 39, .code = 0x224c, .word = 0xe0ce, .immediate=0, .flags=0x00, .name = "WE0CE" },
  { .ov = 39, .code = 0x224c, .word = 0xe0d8, .immediate=0, .flags=0x00, .name = "WE0D8" },
  { .ov = 39, .code = 0x224c, .word = 0xe0e4, .immediate=0, .flags=0x00, .name = "WE0E4" },
  { .ov = 39, .code = 0x224c, .word = 0xe0ec, .immediate=0, .flags=0x00, .name = "WE0EC" },
  { .ov = 39, .code = 0x224c, .word = 0xe100, .immediate=0, .flags=0x00, .name = "WE100" },
  { .ov = 39, .code = 0x224c, .word = 0xe10c, .immediate=0, .flags=0x00, .name = "WE10C" },
  { .ov = 39, .code = 0x224c, .word = 0xe114, .immediate=0, .flags=0x00, .name = "WE114" },
  { .ov = 39, .code = 0x73ea, .word = 0xe140, .immediate=0, .flags=0x00, .name = "WE140" },
  { .ov = 39, .code = 0x73ea, .word = 0xe148, .immediate=0, .flags=0x00, .name = "WE148" },
  { .ov = 39, .code = 0x73ea, .word = 0xe150, .immediate=0, .flags=0x00, .name = "WE150" },
  { .ov = 39, .code = 0x73ea, .word = 0xe165, .immediate=0, .flags=0x80, .name = "STUN.EFFEC" },
  { .ov = 39, .code = 0x73ea, .word = 0xe16d, .immediate=0, .flags=0x00, .name = "WE16D" },
  { .ov = 39, .code = 0x73ea, .word = 0xe175, .immediate=0, .flags=0x00, .name = "WE175" },
  { .ov = 39, .code = 0x744d, .word = 0xe184, .immediate=0, .flags=0x80, .name = "HITS" },
  { .ov = 39, .code = 0x744d, .word = 0xe191, .immediate=0, .flags=0x80, .name = "STUNS" },
  { .ov = 39, .code = 0x73ea, .word = 0xe1a3, .immediate=0, .flags=0x80, .name = "HIT.POINTS" },
  { .ov = 39, .code = 0x744d, .word = 0xe1ab, .immediate=0, .flags=0x00, .name = "WE1AB" },
  { .ov = 39, .code = 0x744d, .word = 0xe1b0, .immediate=0, .flags=0x00, .name = "WE1B0" },
  { .ov = 39, .code = 0x744d, .word = 0xe1b5, .immediate=0, .flags=0x00, .name = "WE1B5" },
  { .ov = 39, .code = 0x744d, .word = 0xe1ba, .immediate=0, .flags=0x00, .name = "WE1BA" },
  { .ov = 39, .code = 0x744d, .word = 0xe1c8, .immediate=0, .flags=0x80, .name = "BEHAVE" },
  { .ov = 39, .code = 0x73ea, .word = 0xe1cd, .immediate=0, .flags=0x00, .name = "WE1CD" },
  { .ov = 39, .code = 0x744d, .word = 0xe1e1, .immediate=0, .flags=0x80, .name = "TV-WEAPON" },
  { .ov = 39, .code = 0x744d, .word = 0xe1e6, .immediate=0, .flags=0x00, .name = "WE1E6" },
  { .ov = 39, .code = 0x73ea, .word = 0xe1f8, .immediate=0, .flags=0x80, .name = "ATMO.ACTIV" },
  { .ov = 39, .code = 0x224c, .word = 0xe20d, .immediate=0, .flags=0x80, .name = "?PLAYER-FI" },
  { .ov = 39, .code = 0x224c, .word = 0xe232, .immediate=0, .flags=0x80, .name = "?ALIEN-CLO" },
  { .ov = 39, .code = 0x224c, .word = 0xe265, .immediate=0, .flags=0x80, .name = "?ALIEN-SMA" },
  { .ov = 39, .code = 0x224c, .word = 0xe273, .immediate=0, .flags=0x00, .name = "WE273" },
  { .ov = 39, .code = 0x224c, .word = 0xe28c, .immediate=0, .flags=0x80, .name = "?RANDOM-SC" },
  { .ov = 39, .code = 0x224c, .word = 0xe2a5, .immediate=0, .flags=0x80, .name = "?ALIEN-HIT-WITH-LASER" },
  { .ov = 39, .code = 0x224c, .word = 0xe2d5, .immediate=0, .flags=0x00, .name = "WE2D5" },
  { .ov = 39, .code = 0x224c, .word = 0xe2ee, .immediate=0, .flags=0x80, .name = "?ALIEN-HIT-WITH-STUNNER" },
  { .ov = 39, .code = 0x224c, .word = 0xe308, .immediate=0, .flags=0x00, .name = "WE308" },
  { .ov = 39, .code = 0x224c, .word = 0xe31f, .immediate=0, .flags=0x80, .name = "?NOTICE-PL" },
  { .ov = 39, .code = 0x224c, .word = 0xe368, .immediate=0, .flags=0x80, .name = "?NEXT-TO-P" },
  { .ov = 39, .code = 0x224c, .word = 0xe388, .immediate=0, .flags=0x00, .name = "WE388" },
  { .ov = 39, .code = 0x224c, .word = 0xe398, .immediate=0, .flags=0x00, .name = "WE398" },
  { .ov = 39, .code = 0x224c, .word = 0xe3a6, .immediate=0, .flags=0x00, .name = "WE3A6" },
  { .ov = 39, .code = 0x224c, .word = 0xe3ba, .immediate=0, .flags=0x00, .name = "WE3BA" },
  { .ov = 39, .code = 0x224c, .word = 0xe3d4, .immediate=0, .flags=0x00, .name = "WE3D4" },
  { .ov = 39, .code = 0x224c, .word = 0xe3dc, .immediate=0, .flags=0x00, .name = "WE3DC" },
  { .ov = 39, .code = 0x224c, .word = 0xe3f0, .immediate=0, .flags=0x00, .name = "WE3F0" },
  { .ov = 39, .code = 0x224c, .word = 0xe3fe, .immediate=0, .flags=0x00, .name = "WE3FE" },
  { .ov = 39, .code = 0x224c, .word = 0xe40e, .immediate=0, .flags=0x00, .name = "WE40E" },
  { .ov = 39, .code = 0x224c, .word = 0xe41a, .immediate=0, .flags=0x00, .name = "WE41A" },
  { .ov = 39, .code = 0x224c, .word = 0xe420, .immediate=0, .flags=0x00, .name = "WE420" },
  { .ov = 39, .code = 0x224c, .word = 0xe42e, .immediate=0, .flags=0x00, .name = "WE42E" },
  { .ov = 39, .code = 0x224c, .word = 0xe438, .immediate=0, .flags=0x00, .name = "WE438" },
  { .ov = 39, .code = 0x224c, .word = 0xe44e, .immediate=0, .flags=0x00, .name = "WE44E" },
  { .ov = 39, .code = 0x224c, .word = 0xe469, .immediate=0, .flags=0x80, .name = "?STUNS<STU" },
  { .ov = 39, .code = 0x224c, .word = 0xe482, .immediate=0, .flags=0x80, .name = "?STUNNED" },
  { .ov = 39, .code = 0x224c, .word = 0xe488, .immediate=0, .flags=0x00, .name = "WE488" },
  { .ov = 39, .code = 0x224c, .word = 0xe492, .immediate=0, .flags=0x00, .name = "WE492" },
  { .ov = 39, .code = 0x224c, .word = 0xe4a2, .immediate=0, .flags=0x00, .name = "WE4A2" },
  { .ov = 39, .code = 0x224c, .word = 0xe4ac, .immediate=0, .flags=0x00, .name = "WE4AC" },
  { .ov = 39, .code = 0x224c, .word = 0xe4bc, .immediate=0, .flags=0x00, .name = "WE4BC" },
  { .ov = 39, .code = 0x224c, .word = 0xe4d9, .immediate=0, .flags=0x80, .name = "?WANTS-TO-FLY" },
  { .ov = 39, .code = 0x224c, .word = 0xe4f2, .immediate=0, .flags=0x80, .name = "?WANTS-TO-FLOAT" },
  { .ov = 39, .code = 0x224c, .word = 0xe4f8, .immediate=0, .flags=0x00, .name = "WE4F8" },
  { .ov = 39, .code = 0x224c, .word = 0xe508, .immediate=0, .flags=0x00, .name = "WE508" },
  { .ov = 39, .code = 0x224c, .word = 0xe516, .immediate=0, .flags=0x00, .name = "WE516" },
  { .ov = 39, .code = 0x224c, .word = 0xe53a, .immediate=0, .flags=0x00, .name = "WE53A" },
  { .ov = 39, .code = 0x224c, .word = 0xe548, .immediate=0, .flags=0x00, .name = "WE548" },
  { .ov = 39, .code = 0x224c, .word = 0xe556, .immediate=0, .flags=0x00, .name = "WE556" },
  { .ov = 39, .code = 0x224c, .word = 0xe564, .immediate=0, .flags=0x00, .name = "WE564" },
  { .ov = 39, .code = 0x224c, .word = 0xe5a2, .immediate=0, .flags=0x00, .name = "WE5A2" },
  { .ov = 39, .code = 0x224c, .word = 0xe5b4, .immediate=0, .flags=0x00, .name = "WE5B4" },
  { .ov = 39, .code = 0x224c, .word = 0xe5c8, .immediate=0, .flags=0x00, .name = "WE5C8" },
  { .ov = 39, .code = 0x224c, .word = 0xe5fc, .immediate=0, .flags=0x00, .name = "WE5FC" },
  { .ov = 39, .code = 0x224c, .word = 0xe60c, .immediate=0, .flags=0x00, .name = "WE60C" },
  { .ov = 39, .code = 0x224c, .word = 0xe622, .immediate=0, .flags=0x00, .name = "WE622" },
  { .ov = 39, .code = 0x224c, .word = 0xe649, .immediate=0, .flags=0x80, .name = "REDUCE-AGG" },
  { .ov = 39, .code = 0x224c, .word = 0xe670, .immediate=0, .flags=0x80, .name = "INCREASES-" },
  { .ov = 39, .code = 0x224c, .word = 0xe68c, .immediate=0, .flags=0x00, .name = "WE68C" },
  { .ov = 39, .code = 0x224c, .word = 0xe6a4, .immediate=0, .flags=0x00, .name = "WE6A4" },
  { .ov = 39, .code = 0x224c, .word = 0xe6b0, .immediate=0, .flags=0x00, .name = "WE6B0" },
  { .ov = 39, .code = 0x224c, .word = 0xe6bc, .immediate=0, .flags=0x00, .name = "WE6BC" },
  { .ov = 39, .code = 0x224c, .word = 0xe6d0, .immediate=0, .flags=0x00, .name = "WE6D0" },
  { .ov = 39, .code = 0x224c, .word = 0xe727, .immediate=0, .flags=0x80, .name = "ERASE-LIFEFORM-FROM-ARRAY" },
  { .ov = 39, .code = 0x224c, .word = 0xe73e, .immediate=0, .flags=0x80, .name = "REDUCE-HIT" },
  { .ov = 39, .code = 0x224c, .word = 0xe75c, .immediate=0, .flags=0x00, .name = "WE75C" },
  { .ov = 39, .code = 0x224c, .word = 0xe779, .immediate=0, .flags=0x80, .name = "REDUCE-STU" },
  { .ov = 39, .code = 0x224c, .word = 0xe79e, .immediate=0, .flags=0x80, .name = "STUN-EFFEC" },
  { .ov = 39, .code = 0x224c, .word = 0xe7c0, .immediate=0, .flags=0x00, .name = "WE7C0" },
  { .ov = 39, .code = 0x224c, .word = 0xe7d1, .immediate=0, .flags=0x80, .name = "INCREMENT-" },
  { .ov = 39, .code = 0x73ea, .word = 0xe7e7, .immediate=0, .flags=0x00, .name = "WE7E7" },
  { .ov = 39, .code = 0x224c, .word = 0xe7ef, .immediate=0, .flags=0x00, .name = "WE7EF" },
  { .ov = 39, .code = 0x224c, .word = 0xe7fd, .immediate=0, .flags=0x00, .name = "WE7FD" },
  { .ov = 39, .code = 0x224c, .word = 0xe80b, .immediate=0, .flags=0x00, .name = "WE80B" },
  { .ov = 39, .code = 0x224c, .word = 0xe81f, .immediate=0, .flags=0x80, .name = "DIE" },
  { .ov = 39, .code = 0x224c, .word = 0xe83b, .immediate=0, .flags=0x00, .name = "WE83B" },
  { .ov = 39, .code = 0x224c, .word = 0xe84b, .immediate=0, .flags=0x00, .name = "WE84B" },
  { .ov = 39, .code = 0x224c, .word = 0xe855, .immediate=0, .flags=0x00, .name = "WE855" },
  { .ov = 39, .code = 0x744d, .word = 0xe865, .immediate=0, .flags=0x00, .name = "WE865" },
  { .ov = 39, .code = 0x744d, .word = 0xe86a, .immediate=0, .flags=0x00, .name = "WE86A" },
  { .ov = 39, .code = 0x224c, .word = 0xe86f, .immediate=0, .flags=0x00, .name = "WE86F" },
  { .ov = 39, .code = 0x224c, .word = 0xe89b, .immediate=0, .flags=0x00, .name = "WE89B" },
  { .ov = 39, .code = 0x744d, .word = 0xe8b5, .immediate=0, .flags=0x00, .name = "WE8B5" },
  { .ov = 39, .code = 0x73ea, .word = 0xe8ba, .immediate=0, .flags=0x00, .name = "WE8BA" },
  { .ov = 39, .code = 0x224c, .word = 0xe8c2, .immediate=0, .flags=0x00, .name = "WE8C2" },
  { .ov = 39, .code = 0x224c, .word = 0xe8e4, .immediate=0, .flags=0x00, .name = "WE8E4" },
  { .ov = 39, .code = 0x224c, .word = 0xe8f8, .immediate=0, .flags=0x00, .name = "WE8F8" },
  { .ov = 39, .code = 0x224c, .word = 0xe91a, .immediate=0, .flags=0x00, .name = "WE91A" },
  { .ov = 39, .code = 0x224c, .word = 0xe946, .immediate=0, .flags=0x00, .name = "WE946" },
  { .ov = 39, .code = 0x224c, .word = 0xe9b4, .immediate=0, .flags=0x00, .name = "WE9B4" },
  { .ov = 39, .code = 0xb869, .word = 0xea3a, .immediate=0, .flags=0x80, .name = "AGGR-MODIF" },
  { .ov = 39, .code = 0xb869, .word = 0xea80, .immediate=0, .flags=0x80, .name = "VS.PLAYER" },
  { .ov = 39, .code = 0xb869, .word = 0xeac4, .immediate=0, .flags=0x80, .name = "LIFE-SIM" },
  { .ov = 39, .code = 0xb869, .word = 0xeae7, .immediate=0, .flags=0x80, .name = "ERASE-LIFE" },
  { .ov = 39, .code = 0xb869, .word = 0xeb07, .immediate=0, .flags=0x80, .name = "?REDUCE-PO" },
  { .ov = 39, .code = 0x224c, .word = 0xeb2b, .immediate=0, .flags=0x00, .name = "WEB2B" },
  { .ov = 39, .code = 0xb869, .word = 0xeb4a, .immediate=0, .flags=0x80, .name = "EFFECT-LIF" },
  { .ov = 39, .code = 0x224c, .word = 0xeb69, .immediate=0, .flags=0x00, .name = "WEB69" },
  { .ov = 39, .code = 0xb869, .word = 0xeb86, .immediate=0, .flags=0x80, .name = "GROUND>AIR" },
  { .ov = 39, .code = 0x224c, .word = 0xebf8, .immediate=0, .flags=0x00, .name = "WEBF8" },
  { .ov = 39, .code = 0x224c, .word = 0xec5b, .immediate=0, .flags=0x80, .name = "SIMULATE" },
  { .ov = 39, .code = 0x224c, .word = 0xecb7, .immediate=0, .flags=0x00, .name = "WECB7" },
  { .ov = 39, .code = 0x1d29, .word = 0xed38, .immediate=0, .flags=0x80, .name = "%STORM" },
  { .ov = 39, .code = 0x224c, .word = 0xed4e, .immediate=0, .flags=0x80, .name = "?.STORM" },
  { .ov = 39, .code = 0x224c, .word = 0xed75, .immediate=0, .flags=0x80, .name = "?STORM" },
  { .ov = 39, .code = 0x224c, .word = 0xee0d, .immediate=0, .flags=0x00, .name = "angle>text" },
  { .ov = 39, .code = 0x224c, .word = 0xeef3, .immediate=0, .flags=0x00, .name = "WEEF3" },
  { .ov = 39, .code = 0x224c, .word = 0xef13, .immediate=0, .flags=0x80, .name = "?EMBARK" },
  { .ov = 39, .code = 0x224c, .word = 0xef23, .immediate=0, .flags=0x00, .name = "WEF23" },
  { .ov = 39, .code = 0x224c, .word = 0xef37, .immediate=0, .flags=0x00, .name = "WEF37" },
  { .ov = 39, .code = 0x1d29, .word = 0xef6b, .immediate=0, .flags=0x80, .name = "FUNCTIONS" },
  { .ov = 39, .code = 0x224c, .word = 0xef8a, .immediate=0, .flags=0x00, .name = "WEF8A" },
  { .ov = 39, .code = 0x224c, .word = 0xef96, .immediate=0, .flags=0x00, .name = "WEF96" },
  { .ov = 39, .code = 0x1d29, .word = 0xef9e, .immediate=0, .flags=0x00, .name = "WEF9E" },
  { .ov = 39, .code = 0x224c, .word = 0xefa9, .immediate=0, .flags=0x80, .name = "MAPS" },
  { .ov = 39, .code = 0x224c, .word = 0xefbf, .immediate=0, .flags=0x80, .name = "WALK&TALK" },
  { .ov = 39, .code = 0x224c, .word = 0xefd2, .immediate=0, .flags=0x80, .name = "TVMOVE" },
  { .ov = 39, .code = 0x224c, .word = 0xefed, .immediate=0, .flags=0x80, .name = "DO.WEAPONS" },
  { .ov = 39, .code = 0x224c, .word = 0xf010, .immediate=0, .flags=0x80, .name = "/ITEMS" },
  { .ov = 39, .code = 0x224c, .word = 0xf022, .immediate=0, .flags=0x80, .name = "ICONS" },
  { .ov = 39, .code = 0x4a4f, .word = 0xf049, .immediate=0, .flags=0x80, .name = ">BUTTONS" },
  { .ov = 39, .code = 0x224c, .word = 0xf06b, .immediate=0, .flags=0x00, .name = "WF06B" },
  { .ov = 39, .code = 0x224c, .word = 0xf077, .immediate=0, .flags=0x00, .name = "WF077" },
  { .ov = 39, .code = 0x744d, .word = 0xf0e9, .immediate=0, .flags=0x80, .name = "NAVIG" },
  { .ov = 39, .code = 0x744d, .word = 0xf0f5, .immediate=0, .flags=0x80, .name = "^NAV" },
  { .ov = 39, .code = 0x224c, .word = 0xf103, .immediate=0, .flags=0x80, .name = "-STORM" },
  { .ov = 39, .code = 0x224c, .word = 0xf122, .immediate=0, .flags=0x80, .name = "?NAV" },
  { .ov = 39, .code = 0x224c, .word = 0xf148, .immediate=0, .flags=0x80, .name = ".DISTANCE" },
  { .ov = 39, .code = 0x224c, .word = 0xf1bf, .immediate=0, .flags=0x80, .name = ".CARGO" },
  { .ov = 39, .code = 0x224c, .word = 0xf1fc, .immediate=0, .flags=0x00, .name = "WF1FC" },
  { .ov = 39, .code = 0x224c, .word = 0xf222, .immediate=0, .flags=0x80, .name = ".ENERGY" },
  { .ov = 39, .code = 0x224c, .word = 0xf2cd, .immediate=0, .flags=0x00, .name = "WF2CD" },
  { .ov = 39, .code = 0x224c, .word = 0xf2f5, .immediate=0, .flags=0x00, .name = "WF2F5" },
  { .ov = 39, .code = 0x224c, .word = 0xf319, .immediate=0, .flags=0x00, .name = "WF319" },
  { .ov = 39, .code = 0x224c, .word = 0xf346, .immediate=0, .flags=0x80, .name = ".WHERE" },
  { .ov = 39, .code = 0x224c, .word = 0xf399, .immediate=0, .flags=0x80, .name = ".STATS" },
  { .ov = 39, .code = 0x224c, .word = 0xf3b5, .immediate=0, .flags=0x00, .name = "WF3B5" },
  { .ov = 39, .code = 0x224c, .word = 0xf3d0, .immediate=0, .flags=0x80, .name = "TV-TASKS" },
  { .ov = 39, .code = 0x224c, .word = 0xf436, .immediate=0, .flags=0x00, .name = "WF436" },
  { .ov = 39, .code = 0x224c, .word = 0xf49a, .immediate=0, .flags=0x00, .name = "WF49A" },
  { .ov = 39, .code = 0x224c, .word = 0xf4a6, .immediate=0, .flags=0x00, .name = "WF4A6" },
  { .ov = 39, .code = 0x224c, .word = 0xf4b0, .immediate=0, .flags=0x00, .name = "WF4B0" },
  { .ov = 39, .code = 0x224c, .word = 0xf4e5, .immediate=0, .flags=0x80, .name = "TV" },
  { .ov = 40, .code = 0x224c, .word = 0xf0a6, .immediate=0, .flags=0x00, .name = "WF0A6" },
  { .ov = 40, .code = 0x224c, .word = 0xf0bc, .immediate=0, .flags=0x00, .name = "WF0BC" },
  { .ov = 40, .code = 0x224c, .word = 0xf0ce, .immediate=0, .flags=0x00, .name = "WF0CE" },
  { .ov = 40, .code = 0x744d, .word = 0xf0f0, .immediate=0, .flags=0x00, .name = "WF0F0" },
  { .ov = 40, .code = 0x744d, .word = 0xf0f5, .immediate=0, .flags=0x00, .name = "WF0F5" },
  { .ov = 40, .code = 0x744d, .word = 0xf0fa, .immediate=0, .flags=0x00, .name = "WF0FA" },
  { .ov = 40, .code = 0x744d, .word = 0xf0ff, .immediate=0, .flags=0x00, .name = "WF0FF" },
  { .ov = 40, .code = 0x744d, .word = 0xf104, .immediate=0, .flags=0x00, .name = "WF104" },
  { .ov = 40, .code = 0x744d, .word = 0xf109, .immediate=0, .flags=0x00, .name = "WF109" },
  { .ov = 40, .code = 0x744d, .word = 0xf10e, .immediate=0, .flags=0x00, .name = "WF10E" },
  { .ov = 40, .code = 0x744d, .word = 0xf113, .immediate=0, .flags=0x00, .name = "WF113" },
  { .ov = 40, .code = 0x744d, .word = 0xf118, .immediate=0, .flags=0x00, .name = "WF118" },
  { .ov = 40, .code = 0x744d, .word = 0xf11d, .immediate=0, .flags=0x00, .name = "WF11D" },
  { .ov = 40, .code = 0x744d, .word = 0xf122, .immediate=0, .flags=0x00, .name = "WF122" },
  { .ov = 40, .code = 0x73ea, .word = 0xf127, .immediate=0, .flags=0x00, .name = "WF127" },
  { .ov = 40, .code = 0x224c, .word = 0xf12f, .immediate=0, .flags=0x00, .name = "WF12F" },
  { .ov = 40, .code = 0x224c, .word = 0xf139, .immediate=0, .flags=0x00, .name = "WF139" },
  { .ov = 40, .code = 0x224c, .word = 0xf147, .immediate=0, .flags=0x00, .name = "WF147" },
  { .ov = 40, .code = 0x224c, .word = 0xf183, .immediate=0, .flags=0x00, .name = "WF183" },
  { .ov = 40, .code = 0x224c, .word = 0xf202, .immediate=0, .flags=0x80, .name = "ROLE-C" },
  { .ov = 40, .code = 0x224c, .word = 0xf23c, .immediate=0, .flags=0x00, .name = "WF23C" },
  { .ov = 40, .code = 0x224c, .word = 0xf280, .immediate=0, .flags=0x00, .name = "WF280" },
  { .ov = 40, .code = 0x224c, .word = 0xf292, .immediate=0, .flags=0x00, .name = "WF292" },
  { .ov = 40, .code = 0x224c, .word = 0xf2b4, .immediate=0, .flags=0x00, .name = "WF2B4" },
  { .ov = 40, .code = 0x224c, .word = 0xf2cd, .immediate=0, .flags=0x00, .name = "WF2CD" },
  { .ov = 40, .code = 0x224c, .word = 0xf35d, .immediate=0, .flags=0x80, .name = ".VITS" },
  { .ov = 40, .code = 0x4a4f, .word = 0xf3fc, .immediate=0, .flags=0x80, .name = ">SKILL" },
  { .ov = 40, .code = 0x224c, .word = 0xf416, .immediate=0, .flags=0x00, .name = "WF416" },
  { .ov = 40, .code = 0x1d29, .word = 0xf426, .immediate=0, .flags=0x00, .name = "WF426" },
  { .ov = 40, .code = 0x1d29, .word = 0xf42a, .immediate=0, .flags=0x00, .name = "WF42A" },
  { .ov = 40, .code = 0x224c, .word = 0xf42f, .immediate=0, .flags=0x00, .name = "WF42F" },
  { .ov = 40, .code = 0x224c, .word = 0xf489, .immediate=0, .flags=0x00, .name = "WF489" },
  { .ov = 40, .code = 0x224c, .word = 0xf497, .immediate=0, .flags=0x00, .name = "WF497" },
  { .ov = 40, .code = 0x224c, .word = 0xf4c1, .immediate=0, .flags=0x00, .name = "WF4C1" },
  { .ov = 40, .code = 0x224c, .word = 0xf515, .immediate=0, .flags=0x80, .name = "OBITS" },
  { .ov = 40, .code = 0x224c, .word = 0xf524, .immediate=0, .flags=0x80, .name = "HEAL" },
  { .ov = 41, .code = 0x2214, .word = 0xeed6, .immediate=0, .flags=0x00, .name = "WEED6" },
  { .ov = 41, .code = 0x744d, .word = 0xeeda, .immediate=0, .flags=0x00, .name = "WEEDA" },
  { .ov = 41, .code = 0x744d, .word = 0xeedf, .immediate=0, .flags=0x00, .name = "WEEDF" },
  { .ov = 41, .code = 0x744d, .word = 0xeee4, .immediate=0, .flags=0x00, .name = "WEEE4" },
  { .ov = 41, .code = 0x744d, .word = 0xeee9, .immediate=0, .flags=0x00, .name = "WEEE9" },
  { .ov = 41, .code = 0x744d, .word = 0xeeee, .immediate=0, .flags=0x00, .name = "WEEEE" },
  { .ov = 41, .code = 0x744d, .word = 0xeef3, .immediate=0, .flags=0x00, .name = "WEEF3" },
  { .ov = 41, .code = 0x744d, .word = 0xeef8, .immediate=0, .flags=0x00, .name = "WEEF8" },
  { .ov = 41, .code = 0x744d, .word = 0xeefd, .immediate=0, .flags=0x00, .name = "WEEFD" },
  { .ov = 41, .code = 0x744d, .word = 0xef02, .immediate=0, .flags=0x00, .name = "WEF02" },
  { .ov = 41, .code = 0x744d, .word = 0xef07, .immediate=0, .flags=0x00, .name = "WEF07" },
  { .ov = 41, .code = 0x744d, .word = 0xef0c, .immediate=0, .flags=0x00, .name = "WEF0C" },
  { .ov = 41, .code = 0x744d, .word = 0xef11, .immediate=0, .flags=0x00, .name = "WEF11" },
  { .ov = 41, .code = 0x744d, .word = 0xef16, .immediate=0, .flags=0x00, .name = "WEF16" },
  { .ov = 41, .code = 0x4a4f, .word = 0xef24, .immediate=0, .flags=0x80, .name = ">FIELD" },
  { .ov = 41, .code = 0x1d29, .word = 0xef46, .immediate=0, .flags=0x00, .name = "WEF46" },
  { .ov = 41, .code = 0x1d29, .word = 0xef4a, .immediate=0, .flags=0x00, .name = "WEF4A" },
  { .ov = 41, .code = 0x1d29, .word = 0xef4e, .immediate=0, .flags=0x00, .name = "WEF4E" },
  { .ov = 41, .code = 0x1d29, .word = 0xef52, .immediate=0, .flags=0x00, .name = "WEF52" },
  { .ov = 41, .code = 0x224c, .word = 0xef56, .immediate=0, .flags=0x00, .name = "WEF56" },
  { .ov = 41, .code = 0x224c, .word = 0xef5e, .immediate=0, .flags=0x00, .name = "WEF5E" },
  { .ov = 41, .code = 0x224c, .word = 0xef66, .immediate=0, .flags=0x00, .name = "WEF66" },
  { .ov = 41, .code = 0x224c, .word = 0xef6e, .immediate=0, .flags=0x00, .name = "WEF6E" },
  { .ov = 41, .code = 0x224c, .word = 0xef76, .immediate=0, .flags=0x00, .name = "WEF76" },
  { .ov = 41, .code = 0x224c, .word = 0xef7e, .immediate=0, .flags=0x00, .name = "WEF7E" },
  { .ov = 41, .code = 0x224c, .word = 0xef8e, .immediate=0, .flags=0x00, .name = "WEF8E" },
  { .ov = 41, .code = 0x224c, .word = 0xef9a, .immediate=0, .flags=0x00, .name = "WEF9A" },
  { .ov = 41, .code = 0x224c, .word = 0xefaa, .immediate=0, .flags=0x00, .name = "WEFAA" },
  { .ov = 41, .code = 0x224c, .word = 0xefc0, .immediate=0, .flags=0x00, .name = "WEFC0" },
  { .ov = 41, .code = 0x224c, .word = 0xefe0, .immediate=0, .flags=0x00, .name = "WEFE0" },
  { .ov = 41, .code = 0x224c, .word = 0xeff0, .immediate=0, .flags=0x00, .name = "WEFF0" },
  { .ov = 41, .code = 0x224c, .word = 0xeffc, .immediate=0, .flags=0x00, .name = "WEFFC" },
  { .ov = 41, .code = 0x1d29, .word = 0xf03a, .immediate=0, .flags=0x00, .name = "WF03A" },
  { .ov = 41, .code = 0x224c, .word = 0xf03e, .immediate=0, .flags=0x00, .name = "WF03E" },
  { .ov = 41, .code = 0x224c, .word = 0xf086, .immediate=0, .flags=0x00, .name = "WF086" },
  { .ov = 41, .code = 0x1d29, .word = 0xf0c4, .immediate=0, .flags=0x00, .name = "WF0C4" },
  { .ov = 41, .code = 0x224c, .word = 0xf0d0, .immediate=0, .flags=0x00, .name = "WF0D0" },
  { .ov = 41, .code = 0x224c, .word = 0xf0e8, .immediate=0, .flags=0x00, .name = "WF0E8" },
  { .ov = 41, .code = 0x224c, .word = 0xf10e, .immediate=0, .flags=0x00, .name = "WF10E" },
  { .ov = 41, .code = 0x224c, .word = 0xf122, .immediate=0, .flags=0x00, .name = "WF122" },
  { .ov = 41, .code = 0x224c, .word = 0xf130, .immediate=0, .flags=0x00, .name = "WF130" },
  { .ov = 41, .code = 0x224c, .word = 0xf182, .immediate=0, .flags=0x00, .name = "WF182" },
  { .ov = 41, .code = 0x224c, .word = 0xf1a6, .immediate=0, .flags=0x00, .name = "WF1A6" },
  { .ov = 41, .code = 0x224c, .word = 0xf1c0, .immediate=0, .flags=0x00, .name = "WF1C0" },
  { .ov = 41, .code = 0x224c, .word = 0xf1e4, .immediate=0, .flags=0x00, .name = "WF1E4" },
  { .ov = 41, .code = 0x224c, .word = 0xf208, .immediate=0, .flags=0x00, .name = "WF208" },
  { .ov = 41, .code = 0x224c, .word = 0xf238, .immediate=0, .flags=0x00, .name = "WF238" },
  { .ov = 41, .code = 0x224c, .word = 0xf256, .immediate=0, .flags=0x00, .name = "WF256" },
  { .ov = 41, .code = 0x224c, .word = 0xf26c, .immediate=0, .flags=0x00, .name = "WF26C" },
  { .ov = 41, .code = 0x224c, .word = 0xf2a0, .immediate=0, .flags=0x00, .name = "WF2A0" },
  { .ov = 41, .code = 0x224c, .word = 0xf2be, .immediate=0, .flags=0x00, .name = "WF2BE" },
  { .ov = 41, .code = 0x224c, .word = 0xf2d2, .immediate=0, .flags=0x00, .name = "WF2D2" },
  { .ov = 41, .code = 0x224c, .word = 0xf2da, .immediate=0, .flags=0x00, .name = "WF2DA" },
  { .ov = 41, .code = 0x224c, .word = 0xf2f0, .immediate=0, .flags=0x00, .name = "WF2F0" },
  { .ov = 41, .code = 0x224c, .word = 0xf316, .immediate=0, .flags=0x00, .name = "WF316" },
  { .ov = 41, .code = 0x224c, .word = 0xf324, .immediate=0, .flags=0x00, .name = "WF324" },
  { .ov = 41, .code = 0x224c, .word = 0xf340, .immediate=0, .flags=0x00, .name = "WF340" },
  { .ov = 41, .code = 0x224c, .word = 0xf35b, .immediate=0, .flags=0x00, .name = "WF35B" },
  { .ov = 41, .code = 0x224c, .word = 0xf38f, .immediate=0, .flags=0x00, .name = "WF38F" },
  { .ov = 41, .code = 0x224c, .word = 0xf3cb, .immediate=0, .flags=0x00, .name = "WF3CB" },
  { .ov = 41, .code = 0x224c, .word = 0xf3eb, .immediate=0, .flags=0x00, .name = "WF3EB" },
  { .ov = 41, .code = 0x224c, .word = 0xf3f5, .immediate=0, .flags=0x00, .name = "WF3F5" },
  { .ov = 41, .code = 0x224c, .word = 0xf407, .immediate=0, .flags=0x00, .name = "WF407" },
  { .ov = 41, .code = 0x224c, .word = 0xf449, .immediate=0, .flags=0x00, .name = "WF449" },
  { .ov = 41, .code = 0x224c, .word = 0xf45f, .immediate=0, .flags=0x00, .name = "WF45F" },
  { .ov = 41, .code = 0x224c, .word = 0xf4a9, .immediate=0, .flags=0x00, .name = "WF4A9" },
  { .ov = 41, .code = 0x224c, .word = 0xf4bd, .immediate=0, .flags=0x00, .name = "WF4BD" },
  { .ov = 41, .code = 0x224c, .word = 0xf4e3, .immediate=0, .flags=0x80, .name = "DO-REPA" },
  { .ov = 42, .code = 0x2214, .word = 0xde56, .immediate=0, .flags=0x00, .name = "WDE56" },
  { .ov = 42, .code = 0x2214, .word = 0xde5a, .immediate=0, .flags=0x00, .name = "WDE5A" },
  { .ov = 42, .code = 0x2214, .word = 0xde5e, .immediate=0, .flags=0x00, .name = "WDE5E" },
  { .ov = 42, .code = 0x2214, .word = 0xde62, .immediate=0, .flags=0x00, .name = "WDE62" },
  { .ov = 42, .code = 0x2214, .word = 0xde66, .immediate=0, .flags=0x00, .name = "WDE66" },
  { .ov = 42, .code = 0x2214, .word = 0xde6a, .immediate=0, .flags=0x00, .name = "WDE6A" },
  { .ov = 42, .code = 0x2214, .word = 0xde6e, .immediate=0, .flags=0x00, .name = "WDE6E" },
  { .ov = 42, .code = 0x2214, .word = 0xde72, .immediate=0, .flags=0x00, .name = "WDE72" },
  { .ov = 42, .code = 0x2214, .word = 0xde76, .immediate=0, .flags=0x00, .name = "WDE76" },
  { .ov = 42, .code = 0x2214, .word = 0xde7a, .immediate=0, .flags=0x00, .name = "WDE7A" },
  { .ov = 42, .code = 0x2214, .word = 0xde7e, .immediate=0, .flags=0x00, .name = "WDE7E" },
  { .ov = 42, .code = 0x1d29, .word = 0xde82, .immediate=0, .flags=0x00, .name = "RESUME" },
  { .ov = 42, .code = 0x1d29, .word = 0xde86, .immediate=0, .flags=0x00, .name = "WDE86" },
  { .ov = 42, .code = 0x1d29, .word = 0xdf6a, .immediate=0, .flags=0x00, .name = "CKSUM" },
  { .ov = 42, .code = 0x1d29, .word = 0xdf6e, .immediate=0, .flags=0x00, .name = "WDF6E" },
  { .ov = 42, .code = 0x1d29, .word = 0xdf72, .immediate=0, .flags=0x00, .name = "WDF72" },
  { .ov = 42, .code = 0x1d29, .word = 0xdf76, .immediate=0, .flags=0x00, .name = "WDF76" },
  { .ov = 42, .code = 0x1d29, .word = 0xdf7a, .immediate=0, .flags=0x00, .name = "WDF7A" },
  { .ov = 42, .code = 0x1d29, .word = 0xdf7e, .immediate=0, .flags=0x00, .name = "WDF7E" },
  { .ov = 42, .code = 0x1d29, .word = 0xdf82, .immediate=0, .flags=0x00, .name = "WDF82" },
  { .ov = 42, .code = 0x1d29, .word = 0xdf86, .immediate=0, .flags=0x00, .name = "WDF86" },
  { .ov = 42, .code = 0x1d29, .word = 0xdf8a, .immediate=0, .flags=0x00, .name = "WDF8A" },
  { .ov = 42, .code = 0x1d29, .word = 0xdf8e, .immediate=0, .flags=0x00, .name = "WDF8E" },
  { .ov = 42, .code = 0x1d29, .word = 0xdf92, .immediate=0, .flags=0x00, .name = "$ADDR" },
  { .ov = 42, .code = 0x1d29, .word = 0xdf96, .immediate=0, .flags=0x00, .name = "WDF96" },
  { .ov = 42, .code = 0x1d29, .word = 0xdf9a, .immediate=0, .flags=0x00, .name = "WDF9A" },
  { .ov = 42, .code = 0x1d29, .word = 0xdf9e, .immediate=0, .flags=0x00, .name = "SUB$ADDR" },
  { .ov = 42, .code = 0x1d29, .word = 0xdfa2, .immediate=0, .flags=0x00, .name = "WDFA2" },
  { .ov = 42, .code = 0x1d29, .word = 0xdfa6, .immediate=0, .flags=0x00, .name = "WDFA6" },
  { .ov = 42, .code = 0x2214, .word = 0xdfaa, .immediate=0, .flags=0x00, .name = "WDFAA" },
  { .ov = 42, .code = 0x2214, .word = 0xdfae, .immediate=0, .flags=0x00, .name = "WDFAE" },
  { .ov = 42, .code = 0x5275, .word = 0xdfb9, .immediate=0, .flags=0x80, .name = "HOST" },
  { .ov = 42, .code = 0x5275, .word = 0xdfda, .immediate=0, .flags=0x80, .name = "VECTORERRORS" },
  { .ov = 42, .code = 0x1d29, .word = 0xe000, .immediate=0, .flags=0x00, .name = "WE000" },
  { .ov = 42, .code = 0x224c, .word = 0xe012, .immediate=0, .flags=0x00, .name = "WE012" },
  { .ov = 42, .code = 0x224c, .word = 0xe026, .immediate=0, .flags=0x00, .name = "WE026" },
  { .ov = 42, .code = 0x224c, .word = 0xe05c, .immediate=0, .flags=0x00, .name = "SET.COLORS" },
  { .ov = 42, .code = 0x1d29, .word = 0xe06a, .immediate=0, .flags=0x00, .name = "WE06A" },
  { .ov = 42, .code = 0x1d29, .word = 0xe06e, .immediate=0, .flags=0x00, .name = "$LEN" },
  { .ov = 42, .code = 0x224c, .word = 0xe072, .immediate=0, .flags=0x00, .name = "WE072" },
  { .ov = 42, .code = 0x224c, .word = 0xe07e, .immediate=0, .flags=0x00, .name = "WE07E" },
  { .ov = 42, .code = 0x224c, .word = 0xe096, .immediate=0, .flags=0x00, .name = "WE096" },
  { .ov = 42, .code = 0x224c, .word = 0xe09e, .immediate=0, .flags=0x00, .name = "WE09E" },
  { .ov = 42, .code = 0x224c, .word = 0xe0a6, .immediate=0, .flags=0x00, .name = "WE0A6" },
  { .ov = 42, .code = 0x224c, .word = 0xe0ae, .immediate=0, .flags=0x00, .name = "WE0AE" },
  { .ov = 42, .code = 0x224c, .word = 0xe0b6, .immediate=0, .flags=0x00, .name = "WE0B6" },
  { .ov = 42, .code = 0x224c, .word = 0xe0fa, .immediate=0, .flags=0x00, .name = "OUTERSPACE" },
  { .ov = 42, .code = 0x1d29, .word = 0xe106, .immediate=0, .flags=0x00, .name = "WE106" },
  { .ov = 42, .code = 0x1d29, .word = 0xe10a, .immediate=0, .flags=0x00, .name = "WE10A" },
  { .ov = 42, .code = 0x224c, .word = 0xe115, .immediate=0, .flags=0x80, .name = "?HUB" },
  { .ov = 42, .code = 0x224c, .word = 0xe138, .immediate=0, .flags=0x80, .name = "SETHID" },
  { .ov = 42, .code = 0x224c, .word = 0xe14d, .immediate=0, .flags=0x80, .name = "SETDIS" },
  { .ov = 42, .code = 0x224c, .word = 0xe160, .immediate=0, .flags=0x80, .name = "SCR>CG" },
  { .ov = 42, .code = 0x224c, .word = 0xe1b2, .immediate=0, .flags=0x00, .name = "!$" },
  { .ov = 42, .code = 0x224c, .word = 0xe1be, .immediate=0, .flags=0x00, .name = "#CPL" },
  { .ov = 42, .code = 0x224c, .word = 0xe1d6, .immediate=0, .flags=0x00, .name = "#LPS" },
  { .ov = 42, .code = 0x224c, .word = 0xe1f4, .immediate=0, .flags=0x00, .name = "?BL<-" },
  { .ov = 42, .code = 0x224c, .word = 0xe20c, .immediate=0, .flags=0x00, .name = "##LINES" },
  { .ov = 42, .code = 0x224c, .word = 0xe24e, .immediate=0, .flags=0x00, .name = "#YBLT" },
  { .ov = 42, .code = 0x224c, .word = 0xe278, .immediate=0, .flags=0x00, .name = "#XBLT" },
  { .ov = 42, .code = 0x224c, .word = 0xe2b6, .immediate=0, .flags=0x00, .name = ".SUB" },
  { .ov = 42, .code = 0x224c, .word = 0xe2c6, .immediate=0, .flags=0x00, .name = ".#LINES" },
  { .ov = 42, .code = 0x224c, .word = 0xe334, .immediate=0, .flags=0x00, .name = "WE334" },
  { .ov = 42, .code = 0x224c, .word = 0xe340, .immediate=0, .flags=0x00, .name = "BORDERMARGIN" },
  { .ov = 42, .code = 0x224c, .word = 0xe376, .immediate=0, .flags=0x00, .name = "ERASEWIND" },
  { .ov = 42, .code = 0x224c, .word = 0xe394, .immediate=0, .flags=0x00, .name = "WE394" },
  { .ov = 42, .code = 0x224c, .word = 0xe3b0, .immediate=0, .flags=0x00, .name = ".PAGE" },
  { .ov = 42, .code = 0x224c, .word = 0xe3bc, .immediate=0, .flags=0x00, .name = "BORDER" },
  { .ov = 42, .code = 0x224c, .word = 0xe49c, .immediate=0, .flags=0x00, .name = "WE49C" },
  { .ov = 42, .code = 0x224c, .word = 0xe4d0, .immediate=0, .flags=0x00, .name = ".GAMEOPS" },
  { .ov = 42, .code = 0x224c, .word = 0xe599, .immediate=0, .flags=0x00, .name = ".SAVEHEAD" },
  { .ov = 42, .code = 0x224c, .word = 0xe5c1, .immediate=0, .flags=0x00, .name = ".LOADHEAD" },
  { .ov = 42, .code = 0x224c, .word = 0xe5e9, .immediate=0, .flags=0x00, .name = "WE5E9" },
  { .ov = 42, .code = 0x224c, .word = 0xe61d, .immediate=0, .flags=0x00, .name = "WE61D" },
  { .ov = 42, .code = 0x224c, .word = 0xe63f, .immediate=0, .flags=0x00, .name = "WE63F" },
  { .ov = 42, .code = 0x224c, .word = 0xe647, .immediate=0, .flags=0x00, .name = "WE647" },
  { .ov = 42, .code = 0x224c, .word = 0xe64f, .immediate=0, .flags=0x00, .name = "WE64F" },
  { .ov = 42, .code = 0x224c, .word = 0xe659, .immediate=0, .flags=0x00, .name = "WE659" },
  { .ov = 42, .code = 0x224c, .word = 0xe66f, .immediate=0, .flags=0x00, .name = "WE66F" },
  { .ov = 42, .code = 0x224c, .word = 0xe687, .immediate=0, .flags=0x00, .name = "WE687" },
  { .ov = 42, .code = 0x224c, .word = 0xe695, .immediate=0, .flags=0x00, .name = "WE695" },
  { .ov = 42, .code = 0x224c, .word = 0xe73b, .immediate=0, .flags=0x00, .name = "WE73B" },
  { .ov = 42, .code = 0x224c, .word = 0xe78c, .immediate=0, .flags=0x00, .name = "WE78C" },
  { .ov = 42, .code = 0x224c, .word = 0xe7b6, .immediate=0, .flags=0x00, .name = "WE7B6" },
  { .ov = 42, .code = 0x224c, .word = 0xe7ee, .immediate=0, .flags=0x00, .name = "?-writeable" },
  { .ov = 42, .code = 0x224c, .word = 0xe824, .immediate=0, .flags=0x00, .name = "nomaster" },
  { .ov = 42, .code = 0x224c, .word = 0xe86d, .immediate=0, .flags=0x00, .name = "GDE" },
  { .ov = 42, .code = 0x224c, .word = 0xe881, .immediate=0, .flags=0x00, .name = ".RESUMING" },
  { .ov = 42, .code = 0x224c, .word = 0xe8b0, .immediate=0, .flags=0x00, .name = "WE8B0" },
  { .ov = 42, .code = 0x224c, .word = 0xe8c3, .immediate=0, .flags=0x80, .name = "SCR>EG" },
  { .ov = 42, .code = 0x224c, .word = 0xe93b, .immediate=0, .flags=0x00, .name = "RESTOREDISPLAY" },
  { .ov = 42, .code = 0x224c, .word = 0xe967, .immediate=0, .flags=0x00, .name = "PRESERVEDISPLAY" },
  { .ov = 42, .code = 0x224c, .word = 0xe991, .immediate=0, .flags=0x00, .name = "ESCDISABLE" },
  { .ov = 42, .code = 0x224c, .word = 0xe999, .immediate=0, .flags=0x00, .name = "ESCENABLE" },
  { .ov = 42, .code = 0x224c, .word = 0xe9a1, .immediate=0, .flags=0x00, .name = "OFFCACHE" },
  { .ov = 42, .code = 0x224c, .word = 0xe9ab, .immediate=0, .flags=0x00, .name = "ONCACHE" },
  { .ov = 42, .code = 0x224c, .word = 0xe9b9, .immediate=0, .flags=0x00, .name = "CHECKSUM" },
  { .ov = 42, .code = 0x224c, .word = 0xe9d5, .immediate=0, .flags=0x00, .name = "NEWDOSMSGS" },
  { .ov = 42, .code = 0x224c, .word = 0xe9e9, .immediate=0, .flags=0x00, .name = "?INNERSPACE" },
  { .ov = 42, .code = 0x224c, .word = 0xe9f3, .immediate=0, .flags=0x00, .name = "WE9F3" },
  { .ov = 42, .code = 0x224c, .word = 0xea11, .immediate=0, .flags=0x00, .name = "WEA11" },
  { .ov = 42, .code = 0x224c, .word = 0xea27, .immediate=0, .flags=0x00, .name = "PUSHVECT" },
  { .ov = 42, .code = 0x224c, .word = 0xea51, .immediate=0, .flags=0x00, .name = "POPVECT" },
  { .ov = 42, .code = 0x224c, .word = 0xea87, .immediate=0, .flags=0x00, .name = "WEA87" },
  { .ov = 42, .code = 0x224c, .word = 0xeac7, .immediate=0, .flags=0x00, .name = "WEAC7" },
  { .ov = 42, .code = 0x224c, .word = 0xeaee, .immediate=0, .flags=0x00, .name = "WEAEE" },
  { .ov = 42, .code = 0x224c, .word = 0xeb21, .immediate=0, .flags=0x00, .name = "WEB21" },
  { .ov = 42, .code = 0xeb4a, .word = 0xeb4a, .immediate=0, .flags=0x80, .name = "PRMSAV" },
  { .ov = 42, .code = 0xeb72, .word = 0xeb72, .immediate=0, .flags=0x80, .name = "PRMLOD" },
  { .ov = 42, .code = 0xebaa, .word = 0xebaa, .immediate=0, .flags=0x80, .name = "RETSAV" },
  { .ov = 42, .code = 0xebd2, .word = 0xebd2, .immediate=0, .flags=0x80, .name = "RETJMP" },
  { .ov = 42, .code = 0x224c, .word = 0xebfc, .immediate=0, .flags=0x00, .name = "|DISK" },
  { .ov = 42, .code = 0x224c, .word = 0xec80, .immediate=0, .flags=0x00, .name = "<DISK" },
  { .ov = 42, .code = 0x224c, .word = 0xec88, .immediate=0, .flags=0x00, .name = ">DISK" },
  { .ov = 42, .code = 0x224c, .word = 0xec90, .immediate=0, .flags=0x00, .name = "ARB" },
  { .ov = 42, .code = 0x224c, .word = 0xec9e, .immediate=0, .flags=0x00, .name = "ARRAYSPACE" },
  { .ov = 42, .code = 0x224c, .word = 0xecb4, .immediate=0, .flags=0x00, .name = "ARR>DISK" },
  { .ov = 42, .code = 0x224c, .word = 0xecc2, .immediate=0, .flags=0x00, .name = "WECC2" },
  { .ov = 42, .code = 0x224c, .word = 0xecd2, .immediate=0, .flags=0x00, .name = "WECD2" },
  { .ov = 42, .code = 0x224c, .word = 0xece0, .immediate=0, .flags=0x00, .name = "WECE0" },
  { .ov = 42, .code = 0x224c, .word = 0xecee, .immediate=0, .flags=0x00, .name = "WECEE" },
  { .ov = 42, .code = 0x224c, .word = 0xecfa, .immediate=0, .flags=0x00, .name = "WECFA" },
  { .ov = 42, .code = 0x224c, .word = 0xed08, .immediate=0, .flags=0x00, .name = "WED08" },
  { .ov = 42, .code = 0x224c, .word = 0xed16, .immediate=0, .flags=0x00, .name = "WED16" },
  { .ov = 42, .code = 0x224c, .word = 0xed22, .immediate=0, .flags=0x00, .name = "WED22" },
  { .ov = 42, .code = 0x224c, .word = 0xed32, .immediate=0, .flags=0x00, .name = "WED32" },
  { .ov = 42, .code = 0x224c, .word = 0xed3e, .immediate=0, .flags=0x00, .name = "WED3E" },
  { .ov = 42, .code = 0x224c, .word = 0xed48, .immediate=0, .flags=0x00, .name = "WED48" },
  { .ov = 42, .code = 0x224c, .word = 0xed6a, .immediate=0, .flags=0x00, .name = "WED6A" },
  { .ov = 42, .code = 0x224c, .word = 0xed72, .immediate=0, .flags=0x00, .name = "SETSAVE" },
  { .ov = 42, .code = 0x224c, .word = 0xed92, .immediate=0, .flags=0x00, .name = "WED92" },
  { .ov = 42, .code = 0x224c, .word = 0xeda2, .immediate=0, .flags=0x00, .name = "WEDA2" },
  { .ov = 42, .code = 0x224c, .word = 0xedb8, .immediate=0, .flags=0x00, .name = "WEDB8" },
  { .ov = 42, .code = 0x224c, .word = 0xeddc, .immediate=0, .flags=0x00, .name = "DATALOAD" },
  { .ov = 42, .code = 0x224c, .word = 0xee15, .immediate=0, .flags=0x80, .name = "LOAD.GAME" },
  { .ov = 42, .code = 0x224c, .word = 0xee39, .immediate=0, .flags=0x00, .name = "SAVEGAME" },
  { .ov = 42, .code = 0x224c, .word = 0xee63, .immediate=0, .flags=0x00, .name = "WEE63" },
  { .ov = 42, .code = 0x224c, .word = 0xee7b, .immediate=0, .flags=0x00, .name = "WEE7B" },
  { .ov = 42, .code = 0x224c, .word = 0xee99, .immediate=0, .flags=0x00, .name = "WEE99" },
  { .ov = 42, .code = 0x224c, .word = 0xeeb1, .immediate=0, .flags=0x00, .name = "BOX" },
  { .ov = 42, .code = 0x224c, .word = 0xeee5, .immediate=0, .flags=0x00, .name = "SET.DISPLAY.VECTORS" },
  { .ov = 42, .code = 0x224c, .word = 0xef5a, .immediate=0, .flags=0x80, .name = "SET.DISPLAY.MODE" },
  { .ov = 42, .code = 0x224c, .word = 0xf069, .immediate=0, .flags=0x00, .name = "WF069" },
  { .ov = 42, .code = 0x224c, .word = 0xf0ae, .immediate=0, .flags=0x80, .name = "POLICE.WARNING" },
  { .ov = 42, .code = 0x224c, .word = 0xf47d, .immediate=0, .flags=0x80, .name = "NEW.GA" },
  { .ov = 42, .code = 0x224c, .word = 0xf495, .immediate=0, .flags=0x00, .name = "GET-OPTION#" },
  { .ov = 42, .code = 0x224c, .word = 0xf4b9, .immediate=0, .flags=0x00, .name = "WF4B9" },
  { .ov = 42, .code = 0x4a4f, .word = 0xf4ca, .immediate=0, .flags=0x80, .name = "GAMEOPCASE" },
  { .ov = 42, .code = 0x224c, .word = 0xf4dc, .immediate=0, .flags=0x00, .name = ">GAMEOPTIONS" },
  { .ov = 42, .code = 0x224c, .word = 0xf4ec, .immediate=0, .flags=0x00, .name = "GAMEOPTIONS" },
  { .ov = 42, .code = 0x224c, .word = 0xf504, .immediate=0, .flags=0x00, .name = "<GAMEOPTIONS" },
  { .ov = 42, .code = 0x224c, .word = 0xf51d, .immediate=0, .flags=0x80, .name = "GAMEOPS" },
  { .ov = 42, .code = 0x224c, .word = 0xf527, .immediate=0, .flags=0x00, .name = "?GAME.IN.PROGRESS" },
  { .ov = 42, .code = 0x224c, .word = 0xf538, .immediate=0, .flags=0x80, .name = "START.GAME" },
  { .ov = 43, .code = 0x2214, .word = 0xec16, .immediate=0, .flags=0x00, .name = "WEC16" },
  { .ov = 43, .code = 0x2214, .word = 0xec1a, .immediate=0, .flags=0x00, .name = "WEC1A" },
  { .ov = 43, .code = 0x2214, .word = 0xec1e, .immediate=0, .flags=0x00, .name = "WEC1E" },
  { .ov = 43, .code = 0x73ea, .word = 0xec22, .immediate=0, .flags=0x00, .name = "WEC22" },
  { .ov = 43, .code = 0x73ea, .word = 0xec2a, .immediate=0, .flags=0x00, .name = "WEC2A" },
  { .ov = 43, .code = 0x73ea, .word = 0xec32, .immediate=0, .flags=0x00, .name = "WEC32" },
  { .ov = 43, .code = 0x73ea, .word = 0xec3a, .immediate=0, .flags=0x00, .name = "WEC3A" },
  { .ov = 43, .code = 0x73ea, .word = 0xec42, .immediate=0, .flags=0x00, .name = "WEC42" },
  { .ov = 43, .code = 0x73ea, .word = 0xec4a, .immediate=0, .flags=0x00, .name = "WEC4A" },
  { .ov = 43, .code = 0x73ea, .word = 0xec52, .immediate=0, .flags=0x00, .name = "WEC52" },
  { .ov = 43, .code = 0x73ea, .word = 0xec5a, .immediate=0, .flags=0x00, .name = "SURFTYPE" },
  { .ov = 43, .code = 0x73ea, .word = 0xec62, .immediate=0, .flags=0x00, .name = "WEC62" },
  { .ov = 43, .code = 0x73ea, .word = 0xec6a, .immediate=0, .flags=0x00, .name = "WEC6A" },
  { .ov = 43, .code = 0x73ea, .word = 0xec72, .immediate=0, .flags=0x00, .name = "ATMO.ACTIVITY" },
  { .ov = 43, .code = 0x73ea, .word = 0xec7a, .immediate=0, .flags=0x00, .name = "ATMO.DENSITY" },
  { .ov = 43, .code = 0x73ea, .word = 0xec82, .immediate=0, .flags=0x00, .name = "WEC82" },
  { .ov = 43, .code = 0x73ea, .word = 0xec8a, .immediate=0, .flags=0x00, .name = "WEC8A" },
  { .ov = 43, .code = 0x73ea, .word = 0xec92, .immediate=0, .flags=0x00, .name = "WEC92" },
  { .ov = 43, .code = 0x224c, .word = 0xec9a, .immediate=0, .flags=0x00, .name = "WEC9A" },
  { .ov = 43, .code = 0x224c, .word = 0xecb1, .immediate=0, .flags=0x00, .name = "WECB1" },
  { .ov = 43, .code = 0x224c, .word = 0xecbd, .immediate=0, .flags=0x00, .name = "WECBD" },
  { .ov = 43, .code = 0x224c, .word = 0xecc9, .immediate=0, .flags=0x00, .name = "WECC9" },
  { .ov = 43, .code = 0x224c, .word = 0xecdf, .immediate=0, .flags=0x00, .name = "WECDF" },
  { .ov = 43, .code = 0x224c, .word = 0xece7, .immediate=0, .flags=0x00, .name = "WECE7" },
  { .ov = 43, .code = 0x744d, .word = 0xecf3, .immediate=0, .flags=0x00, .name = "WECF3" },
  { .ov = 43, .code = 0x224c, .word = 0xecf8, .immediate=0, .flags=0x00, .name = "WECF8" },
  { .ov = 43, .code = 0x224c, .word = 0xed2e, .immediate=0, .flags=0x00, .name = "WED2E" },
  { .ov = 43, .code = 0x224c, .word = 0xed8e, .immediate=0, .flags=0x00, .name = "WED8E" },
  { .ov = 43, .code = 0xeca2, .word = 0xedb4, .immediate=0, .flags=0x80, .name = "LO-MASS" },
  { .ov = 43, .code = 0xeca2, .word = 0xedd0, .immediate=0, .flags=0x80, .name = "HI-MASS" },
  { .ov = 43, .code = 0x224c, .word = 0xede2, .immediate=0, .flags=0x00, .name = "WEDE2" },
  { .ov = 43, .code = 0x224c, .word = 0xedf8, .immediate=0, .flags=0x00, .name = "WEDF8" },
  { .ov = 43, .code = 0x224c, .word = 0xee28, .immediate=0, .flags=0x00, .name = "WEE28" },
  { .ov = 43, .code = 0x224c, .word = 0xee46, .immediate=0, .flags=0x00, .name = "WEE46" },
  { .ov = 43, .code = 0x224c, .word = 0xee92, .immediate=0, .flags=0x00, .name = "WEE92" },
  { .ov = 43, .code = 0x224c, .word = 0xeee8, .immediate=0, .flags=0x00, .name = "WEEE8" },
  { .ov = 43, .code = 0x224c, .word = 0xef7a, .immediate=0, .flags=0x00, .name = "WEF7A" },
  { .ov = 43, .code = 0x224c, .word = 0xef8a, .immediate=0, .flags=0x00, .name = "WEF8A" },
  { .ov = 43, .code = 0x224c, .word = 0xefea, .immediate=0, .flags=0x00, .name = "WEFEA" },
  { .ov = 43, .code = 0x224c, .word = 0xf01c, .immediate=0, .flags=0x00, .name = "WF01C" },
  { .ov = 43, .code = 0x224c, .word = 0xf03e, .immediate=0, .flags=0x00, .name = "WF03E" },
  { .ov = 43, .code = 0x224c, .word = 0xf06e, .immediate=0, .flags=0x00, .name = "WF06E" },
  { .ov = 43, .code = 0x224c, .word = 0xf086, .immediate=0, .flags=0x00, .name = "WF086" },
  { .ov = 43, .code = 0x224c, .word = 0xf094, .immediate=0, .flags=0x00, .name = "WF094" },
  { .ov = 43, .code = 0x1d29, .word = 0xf0af, .immediate=0, .flags=0x80, .name = "SUBHYDRO" },
  { .ov = 43, .code = 0x1d29, .word = 0xf0c1, .immediate=0, .flags=0x80, .name = "TEMPHYDR" },
  { .ov = 43, .code = 0x1d29, .word = 0xf0d5, .immediate=0, .flags=0x80, .name = "INFHYDRO" },
  { .ov = 43, .code = 0x1d29, .word = 0xf0e8, .immediate=0, .flags=0x80, .name = "SUBATMO" },
  { .ov = 43, .code = 0x1d29, .word = 0xf0fa, .immediate=0, .flags=0x80, .name = "TEMPATMO" },
  { .ov = 43, .code = 0x1d29, .word = 0xf10f, .immediate=0, .flags=0x80, .name = "INFATMO" },
  { .ov = 43, .code = 0x224c, .word = 0xf118, .immediate=0, .flags=0x00, .name = "WF118" },
  { .ov = 43, .code = 0x224c, .word = 0xf128, .immediate=0, .flags=0x00, .name = "WF128" },
  { .ov = 43, .code = 0x224c, .word = 0xf162, .immediate=0, .flags=0x00, .name = "WF162" },
  { .ov = 43, .code = 0x224c, .word = 0xf18e, .immediate=0, .flags=0x00, .name = "WF18E" },
  { .ov = 43, .code = 0x224c, .word = 0xf1c8, .immediate=0, .flags=0x00, .name = "WF1C8" },
  { .ov = 43, .code = 0x224c, .word = 0xf1e6, .immediate=0, .flags=0x00, .name = "WF1E6" },
  { .ov = 43, .code = 0x224c, .word = 0xf234, .immediate=0, .flags=0x00, .name = "WF234" },
  { .ov = 43, .code = 0x224c, .word = 0xf24e, .immediate=0, .flags=0x00, .name = "WF24E" },
  { .ov = 43, .code = 0x224c, .word = 0xf280, .immediate=0, .flags=0x00, .name = "WF280" },
  { .ov = 43, .code = 0x1d29, .word = 0xf2b7, .immediate=0, .flags=0x80, .name = "RUGS" },
  { .ov = 43, .code = 0x224c, .word = 0xf2d9, .immediate=0, .flags=0x00, .name = "WF2D9" },
  { .ov = 43, .code = 0x224c, .word = 0xf2f4, .immediate=0, .flags=0x80, .name = "SETC" },
  { .ov = 43, .code = 0x224c, .word = 0xf30a, .immediate=0, .flags=0x00, .name = "WF30A" },
  { .ov = 43, .code = 0x224c, .word = 0xf31a, .immediate=0, .flags=0x00, .name = "WF31A" },
  { .ov = 43, .code = 0x1d29, .word = 0xf335, .immediate=0, .flags=0x80, .name = "CLIST1" },
  { .ov = 43, .code = 0x1d29, .word = 0xf354, .immediate=0, .flags=0x80, .name = "CLIST2" },
  { .ov = 43, .code = 0x1d29, .word = 0xf373, .immediate=0, .flags=0x80, .name = "CLIST3" },
  { .ov = 43, .code = 0x224c, .word = 0xf389, .immediate=0, .flags=0x00, .name = "WF389" },
  { .ov = 43, .code = 0x1d29, .word = 0xf3a8, .immediate=0, .flags=0x80, .name = "(SAND)" },
  { .ov = 43, .code = 0x224c, .word = 0xf3ba, .immediate=0, .flags=0x00, .name = "WF3BA" },
  { .ov = 43, .code = 0x224c, .word = 0xf40e, .immediate=0, .flags=0x00, .name = "WF40E" },
  { .ov = 43, .code = 0x224c, .word = 0xf41c, .immediate=0, .flags=0x00, .name = "WF41C" },
  { .ov = 43, .code = 0x224c, .word = 0xf434, .immediate=0, .flags=0x00, .name = "WF434" },
  { .ov = 43, .code = 0x4a4f, .word = 0xf453, .immediate=0, .flags=0x80, .name = "(TERRAIN" },
  { .ov = 43, .code = 0x224c, .word = 0xf46d, .immediate=0, .flags=0x00, .name = "WF46D" },
  { .ov = 43, .code = 0x224c, .word = 0xf482, .immediate=0, .flags=0x80, .name = "PLAN-RUL" },
  { .ov = 44, .code = 0x2214, .word = 0xecb6, .immediate=0, .flags=0x00, .name = "WECB6" },
  { .ov = 44, .code = 0x73ea, .word = 0xecba, .immediate=0, .flags=0x00, .name = "WECBA" },
  { .ov = 44, .code = 0x73ea, .word = 0xecc2, .immediate=0, .flags=0x00, .name = "WECC2" },
  { .ov = 44, .code = 0x73ea, .word = 0xecca, .immediate=0, .flags=0x00, .name = "WECCA" },
  { .ov = 44, .code = 0x73ea, .word = 0xecd2, .immediate=0, .flags=0x00, .name = "WECD2" },
  { .ov = 44, .code = 0x73ea, .word = 0xecda, .immediate=0, .flags=0x00, .name = "WECDA" },
  { .ov = 44, .code = 0x73ea, .word = 0xece2, .immediate=0, .flags=0x00, .name = "WECE2" },
  { .ov = 44, .code = 0x73ea, .word = 0xecea, .immediate=0, .flags=0x00, .name = "WECEA" },
  { .ov = 44, .code = 0x73ea, .word = 0xecf2, .immediate=0, .flags=0x00, .name = "WECF2" },
  { .ov = 44, .code = 0x73ea, .word = 0xecfa, .immediate=0, .flags=0x00, .name = "WECFA" },
  { .ov = 44, .code = 0x2214, .word = 0xed02, .immediate=0, .flags=0x00, .name = "WED02" },
  { .ov = 44, .code = 0x73ea, .word = 0xed06, .immediate=0, .flags=0x00, .name = "WED06" },
  { .ov = 44, .code = 0x224c, .word = 0xed0e, .immediate=0, .flags=0x00, .name = "WED0E" },
  { .ov = 44, .code = 0x224c, .word = 0xed60, .immediate=0, .flags=0x00, .name = "WED60" },
  { .ov = 44, .code = 0x224c, .word = 0xed78, .immediate=0, .flags=0x00, .name = "WED78" },
  { .ov = 44, .code = 0x73ea, .word = 0xedaa, .immediate=0, .flags=0x00, .name = "WEDAA" },
  { .ov = 44, .code = 0x224c, .word = 0xedb2, .immediate=0, .flags=0x00, .name = "WEDB2" },
  { .ov = 44, .code = 0x224c, .word = 0xedde, .immediate=0, .flags=0x00, .name = "WEDDE" },
  { .ov = 44, .code = 0x224c, .word = 0xee28, .immediate=0, .flags=0x00, .name = "WEE28" },
  { .ov = 44, .code = 0x224c, .word = 0xee3e, .immediate=0, .flags=0x00, .name = "WEE3E" },
  { .ov = 44, .code = 0x224c, .word = 0xee58, .immediate=0, .flags=0x00, .name = "WEE58" },
  { .ov = 44, .code = 0x224c, .word = 0xee86, .immediate=0, .flags=0x00, .name = "WEE86" },
  { .ov = 44, .code = 0x224c, .word = 0xee96, .immediate=0, .flags=0x00, .name = "WEE96" },
  { .ov = 44, .code = 0x224c, .word = 0xeea4, .immediate=0, .flags=0x00, .name = "WEEA4" },
  { .ov = 44, .code = 0x224c, .word = 0xef1a, .immediate=0, .flags=0x00, .name = "WEF1A" },
  { .ov = 44, .code = 0x224c, .word = 0xef3f, .immediate=0, .flags=0x80, .name = "2X2CONTOUR" },
  { .ov = 44, .code = 0x224c, .word = 0xef82, .immediate=0, .flags=0x80, .name = "4X4CONTOUR" },
  { .ov = 44, .code = 0x1d29, .word = 0xefcb, .immediate=0, .flags=0x80, .name = "CBLT" },
  { .ov = 44, .code = 0xefd9, .word = 0xefd9, .immediate=0, .flags=0x80, .name = "CBLTP" },
  { .ov = 44, .code = 0x224c, .word = 0xf007, .immediate=0, .flags=0x00, .name = "WF007" },
  { .ov = 44, .code = 0x224c, .word = 0xf0d0, .immediate=0, .flags=0x80, .name = "8X8CONTOUR" },
  { .ov = 44, .code = 0x1d29, .word = 0xf119, .immediate=0, .flags=0x80, .name = "'4X4" },
  { .ov = 44, .code = 0x1d29, .word = 0xf124, .immediate=0, .flags=0x80, .name = "'2X2" },
  { .ov = 44, .code = 0x1d29, .word = 0xf12f, .immediate=0, .flags=0x80, .name = "'8X8" },
  { .ov = 44, .code = 0x224c, .word = 0xf133, .immediate=0, .flags=0x00, .name = "WF133" },
  { .ov = 44, .code = 0x224c, .word = 0xf187, .immediate=0, .flags=0x00, .name = "WF187" },
  { .ov = 44, .code = 0x224c, .word = 0xf1cf, .immediate=0, .flags=0x00, .name = "WF1CF" },
  { .ov = 44, .code = 0x224c, .word = 0xf21f, .immediate=0, .flags=0x00, .name = "WF21F" },
  { .ov = 44, .code = 0x224c, .word = 0xf229, .immediate=0, .flags=0x00, .name = "WF229" },
  { .ov = 44, .code = 0x224c, .word = 0xf233, .immediate=0, .flags=0x00, .name = "WF233" },
  { .ov = 44, .code = 0x224c, .word = 0xf23d, .immediate=0, .flags=0x00, .name = "WF23D" },
  { .ov = 44, .code = 0x224c, .word = 0xf247, .immediate=0, .flags=0x00, .name = "WF247" },
  { .ov = 44, .code = 0x224c, .word = 0xf251, .immediate=0, .flags=0x00, .name = "WF251" },
  { .ov = 44, .code = 0x224c, .word = 0xf25b, .immediate=0, .flags=0x00, .name = "WF25B" },
  { .ov = 44, .code = 0x224c, .word = 0xf265, .immediate=0, .flags=0x00, .name = "WF265" },
  { .ov = 44, .code = 0x224c, .word = 0xf26f, .immediate=0, .flags=0x00, .name = "WF26F" },
  { .ov = 44, .code = 0x224c, .word = 0xf279, .immediate=0, .flags=0x00, .name = "WF279" },
  { .ov = 44, .code = 0x224c, .word = 0xf283, .immediate=0, .flags=0x00, .name = "WF283" },
  { .ov = 44, .code = 0x224c, .word = 0xf28d, .immediate=0, .flags=0x00, .name = "WF28D" },
  { .ov = 44, .code = 0x224c, .word = 0xf297, .immediate=0, .flags=0x00, .name = "WF297" },
  { .ov = 44, .code = 0x224c, .word = 0xf2a1, .immediate=0, .flags=0x00, .name = "WF2A1" },
  { .ov = 44, .code = 0x4a4f, .word = 0xf2b5, .immediate=0, .flags=0x80, .name = "WPHRASE" },
  { .ov = 44, .code = 0x224c, .word = 0xf2fe, .immediate=0, .flags=0x80, .name = "(.STORM)" },
  { .ov = 44, .code = 0x224c, .word = 0xf322, .immediate=0, .flags=0x80, .name = ".ROCK" },
  { .ov = 44, .code = 0x224c, .word = 0xf346, .immediate=0, .flags=0x80, .name = ".LIQUID" },
  { .ov = 44, .code = 0x224c, .word = 0xf369, .immediate=0, .flags=0x80, .name = ".CRYSTAL" },
  { .ov = 44, .code = 0x224c, .word = 0xf37c, .immediate=0, .flags=0x80, .name = ".ICE" },
  { .ov = 44, .code = 0x224c, .word = 0xf3a2, .immediate=0, .flags=0x80, .name = ".MOLTEN" },
  { .ov = 44, .code = 0x224c, .word = 0xf3be, .immediate=0, .flags=0x80, .name = ".CARPET" },
  { .ov = 44, .code = 0x4a4f, .word = 0xf3f9, .immediate=0, .flags=0x80, .name = "/SURF" },
  { .ov = 44, .code = 0x224c, .word = 0xf41e, .immediate=0, .flags=0x80, .name = ".SURFACE" },
  { .ov = 44, .code = 0x224c, .word = 0xf430, .immediate=0, .flags=0x00, .name = "WF430" },
  { .ov = 44, .code = 0x224c, .word = 0xf438, .immediate=0, .flags=0x00, .name = "WF438" },
  { .ov = 44, .code = 0x224c, .word = 0xf440, .immediate=0, .flags=0x00, .name = "WF440" },
  { .ov = 44, .code = 0x224c, .word = 0xf454, .immediate=0, .flags=0x00, .name = "WF454" },
  { .ov = 44, .code = 0x224c, .word = 0xf46c, .immediate=0, .flags=0x00, .name = "WF46C" },
  { .ov = 44, .code = 0x224c, .word = 0xf485, .immediate=0, .flags=0x00, .name = "WF485" },
  { .ov = 44, .code = 0x224c, .word = 0xf48d, .immediate=0, .flags=0x00, .name = "WF48D" },
  { .ov = 44, .code = 0x224c, .word = 0xf4b2, .immediate=0, .flags=0x00, .name = "WF4B2" },
  { .ov = 44, .code = 0x224c, .word = 0xf4c7, .immediate=0, .flags=0x00, .name = "WF4C7" },
  { .ov = 44, .code = 0x224c, .word = 0xf4f4, .immediate=0, .flags=0x00, .name = "WF4F4" },
  { .ov = 44, .code = 0x224c, .word = 0xf50a, .immediate=0, .flags=0x00, .name = "WF50A" },
  { .ov = 44, .code = 0x224c, .word = 0xf51b, .immediate=0, .flags=0x80, .name = "MAPS" },
  { .ov = 44, .code = 0x224c, .word = 0xf54c, .immediate=0, .flags=0x80, .name = ".STORM" },
  { .ov = 45, .code = 0x224c, .word = 0xf0a6, .immediate=0, .flags=0x00, .name = "WF0A6" },
  { .ov = 45, .code = 0x224c, .word = 0xf0b4, .immediate=0, .flags=0x00, .name = "WF0B4" },
  { .ov = 45, .code = 0x224c, .word = 0xf14c, .immediate=0, .flags=0x00, .name = "WF14C" },
  { .ov = 45, .code = 0x224c, .word = 0xf174, .immediate=0, .flags=0x00, .name = "WF174" },
  { .ov = 45, .code = 0xf0cc, .word = 0xf18b, .immediate=0, .flags=0x80, .name = "STORMS" },
  { .ov = 45, .code = 0x744d, .word = 0xf243, .immediate=0, .flags=0x00, .name = "WF243" },
  { .ov = 45, .code = 0x744d, .word = 0xf248, .immediate=0, .flags=0x00, .name = "WF248" },
  { .ov = 45, .code = 0x73ea, .word = 0xf24d, .immediate=0, .flags=0x00, .name = "WF24D" },
  { .ov = 45, .code = 0x73ea, .word = 0xf255, .immediate=0, .flags=0x00, .name = "WF255" },
  { .ov = 45, .code = 0x1d29, .word = 0xf25d, .immediate=0, .flags=0x00, .name = "WF25D" },
  { .ov = 45, .code = 0x224c, .word = 0xf261, .immediate=0, .flags=0x00, .name = "WF261" },
  { .ov = 45, .code = 0x224c, .word = 0xf275, .immediate=0, .flags=0x00, .name = "WF275" },
  { .ov = 45, .code = 0x744d, .word = 0xf281, .immediate=0, .flags=0x00, .name = "WF281" },
  { .ov = 45, .code = 0x744d, .word = 0xf286, .immediate=0, .flags=0x00, .name = "WF286" },
  { .ov = 45, .code = 0x744d, .word = 0xf28b, .immediate=0, .flags=0x00, .name = "WF28B" },
  { .ov = 45, .code = 0x73ea, .word = 0xf290, .immediate=0, .flags=0x00, .name = "WF290" },
  { .ov = 45, .code = 0x224c, .word = 0xf298, .immediate=0, .flags=0x00, .name = "WF298" },
  { .ov = 45, .code = 0x224c, .word = 0xf2b2, .immediate=0, .flags=0x00, .name = "WF2B2" },
  { .ov = 45, .code = 0x224c, .word = 0xf2da, .immediate=0, .flags=0x00, .name = "WF2DA" },
  { .ov = 45, .code = 0x224c, .word = 0xf2f4, .immediate=0, .flags=0x00, .name = "WF2F4" },
  { .ov = 45, .code = 0x224c, .word = 0xf30e, .immediate=0, .flags=0x00, .name = "WF30E" },
  { .ov = 45, .code = 0x224c, .word = 0xf33c, .immediate=0, .flags=0x00, .name = "WF33C" },
  { .ov = 45, .code = 0x224c, .word = 0xf382, .immediate=0, .flags=0x80, .name = "INJURE-PL" },
  { .ov = 45, .code = 0x224c, .word = 0xf3e2, .immediate=0, .flags=0x00, .name = "WF3E2" },
  { .ov = 45, .code = 0x224c, .word = 0xf42e, .immediate=0, .flags=0x00, .name = "WF42E" },
  { .ov = 45, .code = 0x224c, .word = 0xf46c, .immediate=0, .flags=0x00, .name = "WF46C" },
  { .ov = 45, .code = 0x224c, .word = 0xf4a8, .immediate=0, .flags=0x00, .name = "WF4A8" },
  { .ov = 45, .code = 0x224c, .word = 0xf4c8, .immediate=0, .flags=0x80, .name = "(DO.STORM" },
  { .ov = 46, .code = 0x73ea, .word = 0xede6, .immediate=0, .flags=0x00, .name = "WEDE6" },
  { .ov = 46, .code = 0x2214, .word = 0xedee, .immediate=0, .flags=0x00, .name = "WEDEE" },
  { .ov = 46, .code = 0x2214, .word = 0xedf2, .immediate=0, .flags=0x00, .name = "WEDF2" },
  { .ov = 46, .code = 0x2214, .word = 0xedf6, .immediate=0, .flags=0x00, .name = "WEDF6" },
  { .ov = 46, .code = 0x2214, .word = 0xedfa, .immediate=0, .flags=0x00, .name = "WEDFA" },
  { .ov = 46, .code = 0x2214, .word = 0xedfe, .immediate=0, .flags=0x00, .name = "WEDFE" },
  { .ov = 46, .code = 0x2214, .word = 0xee02, .immediate=0, .flags=0x00, .name = "WEE02" },
  { .ov = 46, .code = 0x2214, .word = 0xee06, .immediate=0, .flags=0x00, .name = "WEE06" },
  { .ov = 46, .code = 0x224c, .word = 0xee0a, .immediate=0, .flags=0x00, .name = "WEE0A" },
  { .ov = 46, .code = 0x224c, .word = 0xee1a, .immediate=0, .flags=0x00, .name = "WEE1A" },
  { .ov = 46, .code = 0x224c, .word = 0xee2c, .immediate=0, .flags=0x00, .name = "WEE2C" },
  { .ov = 46, .code = 0x224c, .word = 0xee54, .immediate=0, .flags=0x00, .name = "WEE54" },
  { .ov = 46, .code = 0x1d29, .word = 0xee6c, .immediate=0, .flags=0x00, .name = "WEE6C" },
  { .ov = 46, .code = 0x224c, .word = 0xee70, .immediate=0, .flags=0x00, .name = "WEE70" },
  { .ov = 46, .code = 0x224c, .word = 0xef27, .immediate=0, .flags=0x00, .name = "WEF27" },
  { .ov = 46, .code = 0x224c, .word = 0xef51, .immediate=0, .flags=0x00, .name = "WEF51" },
  { .ov = 46, .code = 0x224c, .word = 0xef61, .immediate=0, .flags=0x00, .name = "WEF61" },
  { .ov = 46, .code = 0x224c, .word = 0xef89, .immediate=0, .flags=0x00, .name = "WEF89" },
  { .ov = 46, .code = 0x224c, .word = 0xefe9, .immediate=0, .flags=0x00, .name = "WEFE9" },
  { .ov = 46, .code = 0x224c, .word = 0xf015, .immediate=0, .flags=0x80, .name = "DATE$>ADR" },
  { .ov = 46, .code = 0x224c, .word = 0xf074, .immediate=0, .flags=0x00, .name = "WF074" },
  { .ov = 46, .code = 0x224c, .word = 0xf082, .immediate=0, .flags=0x00, .name = "WF082" },
  { .ov = 46, .code = 0x224c, .word = 0xf096, .immediate=0, .flags=0x00, .name = "WF096" },
  { .ov = 46, .code = 0x224c, .word = 0xf0c6, .immediate=0, .flags=0x00, .name = "WF0C6" },
  { .ov = 46, .code = 0x224c, .word = 0xf0de, .immediate=0, .flags=0x00, .name = "WF0DE" },
  { .ov = 46, .code = 0x4a4f, .word = 0xf104, .immediate=0, .flags=0x80, .name = "IDENT-ITEM$" },
  { .ov = 46, .code = 0x224c, .word = 0xf131, .immediate=0, .flags=0x80, .name = "ITEM>PAD" },
  { .ov = 46, .code = 0x224c, .word = 0xf157, .immediate=0, .flags=0x00, .name = "WF157" },
  { .ov = 46, .code = 0x224c, .word = 0xf1c0, .immediate=0, .flags=0x80, .name = "BOX>LIST" },
  { .ov = 46, .code = 0x224c, .word = 0xf212, .immediate=0, .flags=0x80, .name = "GET-BOXES" },
  { .ov = 46, .code = 0x224c, .word = 0xf23a, .immediate=0, .flags=0x80, .name = "MAKE-SCROLL-BOX" },
  { .ov = 46, .code = 0x224c, .word = 0xf280, .immediate=0, .flags=0x80, .name = "DELETE-SCROLL-BOX" },
  { .ov = 46, .code = 0x4a4f, .word = 0xf2ad, .immediate=0, .flags=0x80, .name = "CLASS>BOX-SPEC" },
  { .ov = 46, .code = 0x224c, .word = 0xf2cf, .immediate=0, .flags=0x00, .name = "WF2CF" },
  { .ov = 46, .code = 0x224c, .word = 0xf2ea, .immediate=0, .flags=0x80, .name = "BOX>TOCS" },
  { .ov = 46, .code = 0x224c, .word = 0xf301, .immediate=0, .flags=0x80, .name = ">BOX" },
  { .ov = 46, .code = 0x224c, .word = 0xf38e, .immediate=0, .flags=0x80, .name = "?ELEMENT" },
  { .ov = 46, .code = 0x224c, .word = 0xf3a3, .immediate=0, .flags=0x80, .name = "(BOX>)" },
  { .ov = 46, .code = 0x224c, .word = 0xf3e4, .immediate=0, .flags=0x80, .name = "BOX>" },
  { .ov = 47, .code = 0x224c, .word = 0xdd46, .immediate=0, .flags=0x00, .name = "WDD46" },
  { .ov = 47, .code = 0x224c, .word = 0xdd4e, .immediate=0, .flags=0x00, .name = "WDD4E" },
  { .ov = 47, .code = 0x224c, .word = 0xdd5a, .immediate=0, .flags=0x00, .name = "WDD5A" },
  { .ov = 47, .code = 0x224c, .word = 0xdd64, .immediate=0, .flags=0x00, .name = "WDD64" },
  { .ov = 47, .code = 0x224c, .word = 0xdd70, .immediate=0, .flags=0x00, .name = "WDD70" },
  { .ov = 47, .code = 0x224c, .word = 0xdd78, .immediate=0, .flags=0x00, .name = "WDD78" },
  { .ov = 47, .code = 0x224c, .word = 0xdd84, .immediate=0, .flags=0x00, .name = "WDD84" },
  { .ov = 47, .code = 0x2214, .word = 0xdd8c, .immediate=0, .flags=0x00, .name = "WDD8C" },
  { .ov = 47, .code = 0x73ea, .word = 0xdd90, .immediate=0, .flags=0x00, .name = "WDD90" },
  { .ov = 47, .code = 0x73ea, .word = 0xdd98, .immediate=0, .flags=0x00, .name = "WDD98" },
  { .ov = 47, .code = 0x73ea, .word = 0xdda0, .immediate=0, .flags=0x00, .name = "WDDA0" },
  { .ov = 47, .code = 0x73ea, .word = 0xdda8, .immediate=0, .flags=0x00, .name = "WDDA8" },
  { .ov = 47, .code = 0x73ea, .word = 0xddb0, .immediate=0, .flags=0x00, .name = "WDDB0" },
  { .ov = 47, .code = 0x744d, .word = 0xddb8, .immediate=0, .flags=0x00, .name = "WDDB8" },
  { .ov = 47, .code = 0x744d, .word = 0xddbd, .immediate=0, .flags=0x00, .name = "WDDBD" },
  { .ov = 47, .code = 0x744d, .word = 0xddc2, .immediate=0, .flags=0x00, .name = "WDDC2" },
  { .ov = 47, .code = 0x744d, .word = 0xddc7, .immediate=0, .flags=0x00, .name = "WDDC7" },
  { .ov = 47, .code = 0x744d, .word = 0xddcc, .immediate=0, .flags=0x00, .name = "WDDCC" },
  { .ov = 47, .code = 0x2214, .word = 0xddd1, .immediate=0, .flags=0x00, .name = "WDDD1" },
  { .ov = 47, .code = 0x744d, .word = 0xddd5, .immediate=0, .flags=0x00, .name = "WDDD5" },
  { .ov = 47, .code = 0x744d, .word = 0xddda, .immediate=0, .flags=0x00, .name = "WDDDA" },
  { .ov = 47, .code = 0x744d, .word = 0xdddf, .immediate=0, .flags=0x00, .name = "WDDDF" },
  { .ov = 47, .code = 0x744d, .word = 0xdde4, .immediate=0, .flags=0x00, .name = "WDDE4" },
  { .ov = 47, .code = 0x744d, .word = 0xdde9, .immediate=0, .flags=0x00, .name = "WDDE9" },
  { .ov = 47, .code = 0x744d, .word = 0xddee, .immediate=0, .flags=0x00, .name = "WDDEE" },
  { .ov = 47, .code = 0x744d, .word = 0xddf3, .immediate=0, .flags=0x00, .name = "WDDF3" },
  { .ov = 47, .code = 0x744d, .word = 0xddf8, .immediate=0, .flags=0x00, .name = "WDDF8" },
  { .ov = 47, .code = 0x744d, .word = 0xddfd, .immediate=0, .flags=0x00, .name = "WDDFD" },
  { .ov = 47, .code = 0x744d, .word = 0xde02, .immediate=0, .flags=0x00, .name = "WDE02" },
  { .ov = 47, .code = 0x744d, .word = 0xde07, .immediate=0, .flags=0x00, .name = "WDE07" },
  { .ov = 47, .code = 0x744d, .word = 0xde0c, .immediate=0, .flags=0x00, .name = "WDE0C" },
  { .ov = 47, .code = 0x744d, .word = 0xde11, .immediate=0, .flags=0x00, .name = "WDE11" },
  { .ov = 47, .code = 0x744d, .word = 0xde16, .immediate=0, .flags=0x00, .name = "WDE16" },
  { .ov = 47, .code = 0x744d, .word = 0xde1b, .immediate=0, .flags=0x00, .name = "WDE1B" },
  { .ov = 47, .code = 0x744d, .word = 0xde20, .immediate=0, .flags=0x00, .name = "WDE20" },
  { .ov = 47, .code = 0x744d, .word = 0xde25, .immediate=0, .flags=0x00, .name = "WDE25" },
  { .ov = 47, .code = 0x744d, .word = 0xde2a, .immediate=0, .flags=0x00, .name = "WDE2A" },
  { .ov = 47, .code = 0x744d, .word = 0xde2f, .immediate=0, .flags=0x00, .name = "WDE2F" },
  { .ov = 47, .code = 0x744d, .word = 0xde34, .immediate=0, .flags=0x00, .name = "WDE34" },
  { .ov = 47, .code = 0x1d29, .word = 0xde39, .immediate=0, .flags=0x00, .name = "WDE39" },
  { .ov = 47, .code = 0x1d29, .word = 0xde3d, .immediate=0, .flags=0x00, .name = "WDE3D" },
  { .ov = 47, .code = 0x1d29, .word = 0xde41, .immediate=0, .flags=0x00, .name = "WDE41" },
  { .ov = 47, .code = 0x1d29, .word = 0xde45, .immediate=0, .flags=0x00, .name = "WDE45" },
  { .ov = 47, .code = 0x1d29, .word = 0xde4b, .immediate=0, .flags=0x00, .name = "WDE4B" },
  { .ov = 47, .code = 0x1d29, .word = 0xde4f, .immediate=0, .flags=0x00, .name = "WDE4F" },
  { .ov = 47, .code = 0x1d29, .word = 0xde55, .immediate=0, .flags=0x00, .name = "WDE55" },
  { .ov = 47, .code = 0x224c, .word = 0xde59, .immediate=0, .flags=0x00, .name = "WDE59" },
  { .ov = 47, .code = 0x224c, .word = 0xde77, .immediate=0, .flags=0x00, .name = "WDE77" },
  { .ov = 47, .code = 0x224c, .word = 0xde81, .immediate=0, .flags=0x00, .name = "WDE81" },
  { .ov = 47, .code = 0x224c, .word = 0xde9b, .immediate=0, .flags=0x00, .name = "WDE9B" },
  { .ov = 47, .code = 0x224c, .word = 0xdeab, .immediate=0, .flags=0x00, .name = "WDEAB" },
  { .ov = 47, .code = 0x224c, .word = 0xdeb5, .immediate=0, .flags=0x00, .name = "WDEB5" },
  { .ov = 47, .code = 0x224c, .word = 0xdef1, .immediate=0, .flags=0x00, .name = "WDEF1" },
  { .ov = 47, .code = 0x4a4f, .word = 0xdf12, .immediate=0, .flags=0x80, .name = "X=-1" },
  { .ov = 47, .code = 0x4a4f, .word = 0xdf2a, .immediate=0, .flags=0x80, .name = "X=0" },
  { .ov = 47, .code = 0x4a4f, .word = 0xdf42, .immediate=0, .flags=0x80, .name = "X=1" },
  { .ov = 47, .code = 0x4a4f, .word = 0xdf60, .immediate=0, .flags=0x80, .name = "KEY>ORIEN" },
  { .ov = 47, .code = 0x224c, .word = 0xdf72, .immediate=0, .flags=0x00, .name = "WDF72" },
  { .ov = 47, .code = 0x224c, .word = 0xdf8c, .immediate=0, .flags=0x00, .name = "WDF8C" },
  { .ov = 47, .code = 0x224c, .word = 0xdf96, .immediate=0, .flags=0x00, .name = "WDF96" },
  { .ov = 47, .code = 0x224c, .word = 0xdfa4, .immediate=0, .flags=0x00, .name = "WDFA4" },
  { .ov = 47, .code = 0x224c, .word = 0xdfb2, .immediate=0, .flags=0x00, .name = "WDFB2" },
  { .ov = 47, .code = 0x224c, .word = 0xdfc0, .immediate=0, .flags=0x00, .name = "WDFC0" },
  { .ov = 47, .code = 0x224c, .word = 0xdfd2, .immediate=0, .flags=0x00, .name = "WDFD2" },
  { .ov = 47, .code = 0x224c, .word = 0xdff4, .immediate=0, .flags=0x00, .name = "WDFF4" },
  { .ov = 47, .code = 0x744d, .word = 0xe00a, .immediate=0, .flags=0x00, .name = "WE00A" },
  { .ov = 47, .code = 0x224c, .word = 0xe00f, .immediate=0, .flags=0x00, .name = "WE00F" },
  { .ov = 47, .code = 0x224c, .word = 0xe019, .immediate=0, .flags=0x00, .name = "WE019" },
  { .ov = 47, .code = 0x224c, .word = 0xe025, .immediate=0, .flags=0x00, .name = "WE025" },
  { .ov = 47, .code = 0x3b68, .word = 0xe037, .immediate=0, .flags=0x00, .name = "WE037" },
  { .ov = 47, .code = 0x1d29, .word = 0xe03d, .immediate=0, .flags=0x00, .name = "WE03D" },
  { .ov = 47, .code = 0x224c, .word = 0xe043, .immediate=0, .flags=0x00, .name = "WE043" },
  { .ov = 47, .code = 0x224c, .word = 0xe055, .immediate=0, .flags=0x00, .name = "WE055" },
  { .ov = 47, .code = 0x224c, .word = 0xe061, .immediate=0, .flags=0x00, .name = "WE061" },
  { .ov = 47, .code = 0x224c, .word = 0xe06b, .immediate=0, .flags=0x00, .name = "WE06B" },
  { .ov = 47, .code = 0x2214, .word = 0xe075, .immediate=0, .flags=0x00, .name = "WE075" },
  { .ov = 47, .code = 0x2214, .word = 0xe079, .immediate=0, .flags=0x00, .name = "WE079" },
  { .ov = 47, .code = 0x224c, .word = 0xe07d, .immediate=0, .flags=0x00, .name = "WE07D" },
  { .ov = 47, .code = 0x224c, .word = 0xe0a1, .immediate=0, .flags=0x00, .name = "WE0A1" },
  { .ov = 47, .code = 0x224c, .word = 0xe0ab, .immediate=0, .flags=0x00, .name = "WE0AB" },
  { .ov = 47, .code = 0x224c, .word = 0xe0b3, .immediate=0, .flags=0x00, .name = "WE0B3" },
  { .ov = 47, .code = 0x1d29, .word = 0xe0c1, .immediate=0, .flags=0x00, .name = "WE0C1" },
  { .ov = 47, .code = 0x1d29, .word = 0xe0c5, .immediate=0, .flags=0x00, .name = "WE0C5" },
  { .ov = 47, .code = 0x224c, .word = 0xe0cb, .immediate=0, .flags=0x00, .name = "WE0CB" },
  { .ov = 47, .code = 0x224c, .word = 0xe0db, .immediate=0, .flags=0x00, .name = "WE0DB" },
  { .ov = 47, .code = 0x224c, .word = 0xe0f1, .immediate=0, .flags=0x00, .name = "WE0F1" },
  { .ov = 47, .code = 0x224c, .word = 0xe109, .immediate=0, .flags=0x00, .name = "WE109" },
  { .ov = 47, .code = 0x224c, .word = 0xe121, .immediate=0, .flags=0x00, .name = "WE121" },
  { .ov = 47, .code = 0x224c, .word = 0xe12d, .immediate=0, .flags=0x00, .name = "WE12D" },
  { .ov = 47, .code = 0x224c, .word = 0xe139, .immediate=0, .flags=0x00, .name = "WE139" },
  { .ov = 47, .code = 0x1d29, .word = 0xe147, .immediate=0, .flags=0x00, .name = "WE147" },
  { .ov = 47, .code = 0x224c, .word = 0xe14b, .immediate=0, .flags=0x00, .name = "WE14B" },
  { .ov = 47, .code = 0x224c, .word = 0xe167, .immediate=0, .flags=0x00, .name = "WE167" },
  { .ov = 47, .code = 0x224c, .word = 0xe181, .immediate=0, .flags=0x00, .name = "WE181" },
  { .ov = 47, .code = 0x224c, .word = 0xe18f, .immediate=0, .flags=0x00, .name = "WE18F" },
  { .ov = 47, .code = 0x224c, .word = 0xe1a5, .immediate=0, .flags=0x00, .name = "WE1A5" },
  { .ov = 47, .code = 0x224c, .word = 0xe1c1, .immediate=0, .flags=0x00, .name = "WE1C1" },
  { .ov = 47, .code = 0x224c, .word = 0xe1dd, .immediate=0, .flags=0x00, .name = "WE1DD" },
  { .ov = 47, .code = 0x1d29, .word = 0xe1f7, .immediate=0, .flags=0x00, .name = "WE1F7" },
  { .ov = 47, .code = 0x2214, .word = 0xe1fb, .immediate=0, .flags=0x00, .name = "WE1FB" },
  { .ov = 47, .code = 0x2214, .word = 0xe1ff, .immediate=0, .flags=0x00, .name = "WE1FF" },
  { .ov = 47, .code = 0x2214, .word = 0xe203, .immediate=0, .flags=0x00, .name = "WE203" },
  { .ov = 47, .code = 0x2214, .word = 0xe207, .immediate=0, .flags=0x00, .name = "WE207" },
  { .ov = 47, .code = 0x224c, .word = 0xe20b, .immediate=0, .flags=0x00, .name = "WE20B" },
  { .ov = 47, .code = 0xe211, .word = 0xe228, .immediate=0, .flags=0x80, .name = "CURRX" },
  { .ov = 47, .code = 0xe211, .word = 0xe233, .immediate=0, .flags=0x80, .name = "CURRY" },
  { .ov = 47, .code = 0xe211, .word = 0xe23e, .immediate=0, .flags=0x80, .name = "DESTX" },
  { .ov = 47, .code = 0xe211, .word = 0xe249, .immediate=0, .flags=0x80, .name = "DESTY" },
  { .ov = 47, .code = 0xe211, .word = 0xe254, .immediate=0, .flags=0x80, .name = "MORIG" },
  { .ov = 47, .code = 0xe211, .word = 0xe260, .immediate=0, .flags=0x80, .name = "MCLASS" },
  { .ov = 47, .code = 0xe211, .word = 0xe26c, .immediate=0, .flags=0x80, .name = "DELTAX" },
  { .ov = 47, .code = 0xe211, .word = 0xe278, .immediate=0, .flags=0x80, .name = "DELTAY" },
  { .ov = 47, .code = 0x224c, .word = 0xe27b, .immediate=0, .flags=0x00, .name = "WE27B" },
  { .ov = 47, .code = 0x1d29, .word = 0xe292, .immediate=0, .flags=0x80, .name = "MARRAY" },
  { .ov = 47, .code = 0x224c, .word = 0xe462, .immediate=0, .flags=0x00, .name = "WE462" },
  { .ov = 47, .code = 0x224c, .word = 0xe472, .immediate=0, .flags=0x00, .name = "WE472" },
  { .ov = 47, .code = 0x224c, .word = 0xe482, .immediate=0, .flags=0x00, .name = "WE482" },
  { .ov = 47, .code = 0x224c, .word = 0xe48e, .immediate=0, .flags=0x00, .name = "WE48E" },
  { .ov = 47, .code = 0x224c, .word = 0xe49a, .immediate=0, .flags=0x00, .name = "WE49A" },
  { .ov = 47, .code = 0x224c, .word = 0xe4a2, .immediate=0, .flags=0x00, .name = "WE4A2" },
  { .ov = 47, .code = 0x224c, .word = 0xe4ae, .immediate=0, .flags=0x00, .name = "WE4AE" },
  { .ov = 47, .code = 0x4a4f, .word = 0xe4d6, .immediate=0, .flags=0x80, .name = "SCALE>MIS" },
  { .ov = 47, .code = 0x224c, .word = 0xe4e8, .immediate=0, .flags=0x00, .name = "WE4E8" },
  { .ov = 47, .code = 0x224c, .word = 0xe500, .immediate=0, .flags=0x00, .name = "WE500" },
  { .ov = 47, .code = 0x224c, .word = 0xe536, .immediate=0, .flags=0x00, .name = "WE536" },
  { .ov = 47, .code = 0x224c, .word = 0xe546, .immediate=0, .flags=0x00, .name = "WE546" },
  { .ov = 47, .code = 0x224c, .word = 0xe58e, .immediate=0, .flags=0x00, .name = "WE58E" },
  { .ov = 47, .code = 0x224c, .word = 0xe5ac, .immediate=0, .flags=0x00, .name = "WE5AC" },
  { .ov = 47, .code = 0x224c, .word = 0xe5bc, .immediate=0, .flags=0x00, .name = "WE5BC" },
  { .ov = 47, .code = 0x224c, .word = 0xe5dc, .immediate=0, .flags=0x00, .name = "WE5DC" },
  { .ov = 47, .code = 0x224c, .word = 0xe5f4, .immediate=0, .flags=0x00, .name = "WE5F4" },
  { .ov = 47, .code = 0x224c, .word = 0xe60a, .immediate=0, .flags=0x00, .name = "WE60A" },
  { .ov = 47, .code = 0x224c, .word = 0xe624, .immediate=0, .flags=0x00, .name = "WE624" },
  { .ov = 47, .code = 0x2214, .word = 0xe65c, .immediate=0, .flags=0x00, .name = "WE65C" },
  { .ov = 47, .code = 0x224c, .word = 0xe660, .immediate=0, .flags=0x00, .name = "WE660" },
  { .ov = 47, .code = 0x1d29, .word = 0xe6ac, .immediate=0, .flags=0x00, .name = "WE6AC" },
  { .ov = 47, .code = 0x1d29, .word = 0xe6b0, .immediate=0, .flags=0x00, .name = "WE6B0" },
  { .ov = 47, .code = 0x224c, .word = 0xe6b4, .immediate=0, .flags=0x00, .name = "WE6B4" },
  { .ov = 47, .code = 0x224c, .word = 0xe6e4, .immediate=0, .flags=0x00, .name = "WE6E4" },
  { .ov = 47, .code = 0x224c, .word = 0xe72c, .immediate=0, .flags=0x00, .name = "WE72C" },
  { .ov = 47, .code = 0x224c, .word = 0xe744, .immediate=0, .flags=0x00, .name = "WE744" },
  { .ov = 47, .code = 0x224c, .word = 0xe798, .immediate=0, .flags=0x00, .name = "WE798" },
  { .ov = 47, .code = 0x224c, .word = 0xe7cc, .immediate=0, .flags=0x00, .name = "WE7CC" },
  { .ov = 47, .code = 0x224c, .word = 0xe86e, .immediate=0, .flags=0x00, .name = "WE86E" },
  { .ov = 47, .code = 0x224c, .word = 0xe8a1, .immediate=0, .flags=0x00, .name = "WE8A1" },
  { .ov = 47, .code = 0x224c, .word = 0xe8b5, .immediate=0, .flags=0x00, .name = "WE8B5" },
  { .ov = 47, .code = 0x224c, .word = 0xe8e1, .immediate=0, .flags=0x00, .name = "WE8E1" },
  { .ov = 47, .code = 0x224c, .word = 0xe911, .immediate=0, .flags=0x00, .name = "WE911" },
  { .ov = 47, .code = 0x224c, .word = 0xe929, .immediate=0, .flags=0x00, .name = "WE929" },
  { .ov = 47, .code = 0x224c, .word = 0xe94d, .immediate=0, .flags=0x00, .name = "WE94D" },
  { .ov = 47, .code = 0x224c, .word = 0xe96b, .immediate=0, .flags=0x00, .name = "WE96B" },
  { .ov = 47, .code = 0x224c, .word = 0xe97d, .immediate=0, .flags=0x00, .name = "WE97D" },
  { .ov = 47, .code = 0x224c, .word = 0xe9b5, .immediate=0, .flags=0x00, .name = "WE9B5" },
  { .ov = 47, .code = 0x224c, .word = 0xe9df, .immediate=0, .flags=0x00, .name = "WE9DF" },
  { .ov = 47, .code = 0x224c, .word = 0xea01, .immediate=0, .flags=0x00, .name = "WEA01" },
  { .ov = 47, .code = 0x224c, .word = 0xea21, .immediate=0, .flags=0x00, .name = "WEA21" },
  { .ov = 47, .code = 0x224c, .word = 0xea3d, .immediate=0, .flags=0x00, .name = "WEA3D" },
  { .ov = 47, .code = 0x224c, .word = 0xea63, .immediate=0, .flags=0x00, .name = "WEA63" },
  { .ov = 47, .code = 0x224c, .word = 0xea81, .immediate=0, .flags=0x00, .name = "WEA81" },
  { .ov = 47, .code = 0x224c, .word = 0xeabb, .immediate=0, .flags=0x00, .name = "WEABB" },
  { .ov = 47, .code = 0x224c, .word = 0xeb15, .immediate=0, .flags=0x00, .name = "WEB15" },
  { .ov = 47, .code = 0x224c, .word = 0xeb63, .immediate=0, .flags=0x00, .name = "WEB63" },
  { .ov = 47, .code = 0x1d29, .word = 0xebbb, .immediate=0, .flags=0x00, .name = "WEBBB" },
  { .ov = 47, .code = 0x1d29, .word = 0xebbf, .immediate=0, .flags=0x00, .name = "WEBBF" },
  { .ov = 47, .code = 0x224c, .word = 0xebc3, .immediate=0, .flags=0x00, .name = "WEBC3" },
  { .ov = 47, .code = 0x224c, .word = 0xebe7, .immediate=0, .flags=0x00, .name = "WEBE7" },
  { .ov = 47, .code = 0x224c, .word = 0xec0b, .immediate=0, .flags=0x00, .name = "WEC0B" },
  { .ov = 47, .code = 0x224c, .word = 0xec4b, .immediate=0, .flags=0x80, .name = "SET-SCALE" },
  { .ov = 47, .code = 0x224c, .word = 0xec7b, .immediate=0, .flags=0x00, .name = "WEC7B" },
  { .ov = 47, .code = 0x224c, .word = 0xec83, .immediate=0, .flags=0x00, .name = "WEC83" },
  { .ov = 47, .code = 0x224c, .word = 0xec95, .immediate=0, .flags=0x00, .name = "WEC95" },
  { .ov = 47, .code = 0x224c, .word = 0xecc7, .immediate=0, .flags=0x00, .name = "WECC7" },
  { .ov = 47, .code = 0x224c, .word = 0xecea, .immediate=0, .flags=0x00, .name = "WECEA" },
  { .ov = 47, .code = 0x224c, .word = 0xed6a, .immediate=0, .flags=0x00, .name = "WED6A" },
  { .ov = 47, .code = 0x224c, .word = 0xed72, .immediate=0, .flags=0x00, .name = "WED72" },
  { .ov = 47, .code = 0x224c, .word = 0xed86, .immediate=0, .flags=0x00, .name = "WED86" },
  { .ov = 47, .code = 0x224c, .word = 0xed9a, .immediate=0, .flags=0x00, .name = "WED9A" },
  { .ov = 47, .code = 0x224c, .word = 0xedc2, .immediate=0, .flags=0x80, .name = "?APPROACH" },
  { .ov = 47, .code = 0x224c, .word = 0xedce, .immediate=0, .flags=0x00, .name = "WEDCE" },
  { .ov = 47, .code = 0xb869, .word = 0xee09, .immediate=0, .flags=0x80, .name = "<COMBAT>" },
  { .ov = 47, .code = 0x224c, .word = 0xeec4, .immediate=0, .flags=0x00, .name = "WEEC4" },
  { .ov = 47, .code = 0x224c, .word = 0xeed8, .immediate=0, .flags=0x00, .name = "WEED8" },
  { .ov = 47, .code = 0x224c, .word = 0xeee8, .immediate=0, .flags=0x00, .name = "WEEE8" },
  { .ov = 47, .code = 0x224c, .word = 0xeef0, .immediate=0, .flags=0x00, .name = "WEEF0" },
  { .ov = 47, .code = 0x224c, .word = 0xef08, .immediate=0, .flags=0x00, .name = "WEF08" },
  { .ov = 47, .code = 0x224c, .word = 0xef20, .immediate=0, .flags=0x00, .name = "WEF20" },
  { .ov = 47, .code = 0x224c, .word = 0xef3b, .immediate=0, .flags=0x80, .name = "COMBAT" },
  { .ov = 47, .code = 0x1d29, .word = 0xefb4, .immediate=0, .flags=0x80, .name = "ORIENT>O" },
  { .ov = 47, .code = 0x224c, .word = 0xefd6, .immediate=0, .flags=0x00, .name = "WEFD6" },
  { .ov = 47, .code = 0x224c, .word = 0xf00e, .immediate=0, .flags=0x00, .name = "WF00E" },
  { .ov = 47, .code = 0x224c, .word = 0xf01a, .immediate=0, .flags=0x00, .name = "WF01A" },
  { .ov = 47, .code = 0x224c, .word = 0xf03e, .immediate=0, .flags=0x00, .name = "WF03E" },
  { .ov = 47, .code = 0x224c, .word = 0xf058, .immediate=0, .flags=0x00, .name = "WF058" },
  { .ov = 47, .code = 0x224c, .word = 0xf080, .immediate=0, .flags=0x00, .name = "WF080" },
  { .ov = 47, .code = 0x224c, .word = 0xf08a, .immediate=0, .flags=0x00, .name = "WF08A" },
  { .ov = 47, .code = 0x1d29, .word = 0xf0b0, .immediate=0, .flags=0x00, .name = "WF0B0" },
  { .ov = 47, .code = 0x224c, .word = 0xf0b6, .immediate=0, .flags=0x00, .name = "WF0B6" },
  { .ov = 47, .code = 0x224c, .word = 0xf0d8, .immediate=0, .flags=0x00, .name = "WF0D8" },
  { .ov = 47, .code = 0x224c, .word = 0xf11e, .immediate=0, .flags=0x00, .name = "WF11E" },
  { .ov = 47, .code = 0x224c, .word = 0xf17e, .immediate=0, .flags=0x00, .name = "WF17E" },
  { .ov = 47, .code = 0x224c, .word = 0xf18c, .immediate=0, .flags=0x00, .name = "WF18C" },
  { .ov = 47, .code = 0x224c, .word = 0xf1aa, .immediate=0, .flags=0x00, .name = "WF1AA" },
  { .ov = 47, .code = 0x224c, .word = 0xf1b6, .immediate=0, .flags=0x00, .name = "WF1B6" },
  { .ov = 47, .code = 0x224c, .word = 0xf1dc, .immediate=0, .flags=0x00, .name = "WF1DC" },
  { .ov = 47, .code = 0x224c, .word = 0xf208, .immediate=0, .flags=0x00, .name = "WF208" },
  { .ov = 47, .code = 0x224c, .word = 0xf240, .immediate=0, .flags=0x00, .name = "WF240" },
  { .ov = 47, .code = 0x224c, .word = 0xf2ea, .immediate=0, .flags=0x00, .name = "WF2EA" },
  { .ov = 47, .code = 0x224c, .word = 0xf2f4, .immediate=0, .flags=0x00, .name = "WF2F4" },
  { .ov = 47, .code = 0x224c, .word = 0xf352, .immediate=0, .flags=0x00, .name = "WF352" },
  { .ov = 47, .code = 0x224c, .word = 0xf3ae, .immediate=0, .flags=0x00, .name = "WF3AE" },
  { .ov = 47, .code = 0x224c, .word = 0xf3bc, .immediate=0, .flags=0x00, .name = "WF3BC" },
  { .ov = 47, .code = 0x224c, .word = 0xf414, .immediate=0, .flags=0x00, .name = "WF414" },
  { .ov = 47, .code = 0x224c, .word = 0xf4bd, .immediate=0, .flags=0x80, .name = "WAR" },
  { .ov = 47, .code = 0x224c, .word = 0xf4ec, .immediate=0, .flags=0x80, .name = "CLEAR-CO" },
  { .ov = 48, .code = 0x1d29, .word = 0xeabd, .immediate=0, .flags=0x80, .name = "'OVS" },
  { .ov = 48, .code = 0x224c, .word = 0xeac1, .immediate=0, .flags=0x00, .name = "WEAC1" },
  { .ov = 48, .code = 0x224c, .word = 0xeac9, .immediate=0, .flags=0x00, .name = "WEAC9" },
  { .ov = 48, .code = 0x224c, .word = 0xead5, .immediate=0, .flags=0x00, .name = "WEAD5" },
  { .ov = 48, .code = 0x224c, .word = 0xeae1, .immediate=0, .flags=0x00, .name = "WEAE1" },
  { .ov = 48, .code = 0x224c, .word = 0xeae9, .immediate=0, .flags=0x00, .name = "WEAE9" },
  { .ov = 48, .code = 0x224c, .word = 0xeaf5, .immediate=0, .flags=0x00, .name = "WEAF5" },
  { .ov = 48, .code = 0x2214, .word = 0xeafd, .immediate=0, .flags=0x00, .name = "WEAFD" },
  { .ov = 48, .code = 0x73ea, .word = 0xeb01, .immediate=0, .flags=0x00, .name = "WEB01" },
  { .ov = 48, .code = 0x73ea, .word = 0xeb09, .immediate=0, .flags=0x00, .name = "WEB09" },
  { .ov = 48, .code = 0x73ea, .word = 0xeb11, .immediate=0, .flags=0x00, .name = "WEB11" },
  { .ov = 48, .code = 0x73ea, .word = 0xeb19, .immediate=0, .flags=0x00, .name = "WEB19" },
  { .ov = 48, .code = 0x73ea, .word = 0xeb21, .immediate=0, .flags=0x00, .name = "WEB21" },
  { .ov = 48, .code = 0x73ea, .word = 0xeb29, .immediate=0, .flags=0x00, .name = "WEB29" },
  { .ov = 48, .code = 0x744d, .word = 0xeb31, .immediate=0, .flags=0x00, .name = "WEB31" },
  { .ov = 48, .code = 0x744d, .word = 0xeb36, .immediate=0, .flags=0x00, .name = "WEB36" },
  { .ov = 48, .code = 0x744d, .word = 0xeb3b, .immediate=0, .flags=0x00, .name = "WEB3B" },
  { .ov = 48, .code = 0x744d, .word = 0xeb40, .immediate=0, .flags=0x00, .name = "WEB40" },
  { .ov = 48, .code = 0x744d, .word = 0xeb45, .immediate=0, .flags=0x00, .name = "WEB45" },
  { .ov = 48, .code = 0x744d, .word = 0xeb4a, .immediate=0, .flags=0x00, .name = "WEB4A" },
  { .ov = 48, .code = 0x2214, .word = 0xeb4f, .immediate=0, .flags=0x00, .name = "WEB4F" },
  { .ov = 48, .code = 0x744d, .word = 0xeb53, .immediate=0, .flags=0x00, .name = "WEB53" },
  { .ov = 48, .code = 0x744d, .word = 0xeb58, .immediate=0, .flags=0x00, .name = "WEB58" },
  { .ov = 48, .code = 0x744d, .word = 0xeb5d, .immediate=0, .flags=0x00, .name = "WEB5D" },
  { .ov = 48, .code = 0x744d, .word = 0xeb62, .immediate=0, .flags=0x00, .name = "WEB62" },
  { .ov = 48, .code = 0x744d, .word = 0xeb67, .immediate=0, .flags=0x00, .name = "WEB67" },
  { .ov = 48, .code = 0x744d, .word = 0xeb6c, .immediate=0, .flags=0x00, .name = "WEB6C" },
  { .ov = 48, .code = 0x744d, .word = 0xeb71, .immediate=0, .flags=0x00, .name = "WEB71" },
  { .ov = 48, .code = 0x744d, .word = 0xeb76, .immediate=0, .flags=0x00, .name = "WEB76" },
  { .ov = 48, .code = 0x744d, .word = 0xeb7b, .immediate=0, .flags=0x00, .name = "WEB7B" },
  { .ov = 48, .code = 0x744d, .word = 0xeb80, .immediate=0, .flags=0x00, .name = "WEB80" },
  { .ov = 48, .code = 0x744d, .word = 0xeb85, .immediate=0, .flags=0x00, .name = "WEB85" },
  { .ov = 48, .code = 0x744d, .word = 0xeb8a, .immediate=0, .flags=0x00, .name = "WEB8A" },
  { .ov = 48, .code = 0x744d, .word = 0xeb8f, .immediate=0, .flags=0x00, .name = "WEB8F" },
  { .ov = 48, .code = 0x744d, .word = 0xeb94, .immediate=0, .flags=0x00, .name = "WEB94" },
  { .ov = 48, .code = 0x744d, .word = 0xeb99, .immediate=0, .flags=0x00, .name = "WEB99" },
  { .ov = 48, .code = 0x744d, .word = 0xeb9e, .immediate=0, .flags=0x00, .name = "WEB9E" },
  { .ov = 48, .code = 0x744d, .word = 0xeba3, .immediate=0, .flags=0x00, .name = "WEBA3" },
  { .ov = 48, .code = 0x744d, .word = 0xeba8, .immediate=0, .flags=0x00, .name = "WEBA8" },
  { .ov = 48, .code = 0x744d, .word = 0xebad, .immediate=0, .flags=0x00, .name = "WEBAD" },
  { .ov = 48, .code = 0x744d, .word = 0xebb2, .immediate=0, .flags=0x00, .name = "WEBB2" },
  { .ov = 48, .code = 0x73ea, .word = 0xebb7, .immediate=0, .flags=0x00, .name = "WEBB7" },
  { .ov = 48, .code = 0x744d, .word = 0xebbf, .immediate=0, .flags=0x00, .name = "WEBBF" },
  { .ov = 48, .code = 0x1d29, .word = 0xebcb, .immediate=0, .flags=0x80, .name = "RSRC" },
  { .ov = 48, .code = 0x1d29, .word = 0xebd6, .immediate=0, .flags=0x00, .name = "WEBD6" },
  { .ov = 48, .code = 0x1d29, .word = 0xebda, .immediate=0, .flags=0x00, .name = "WEBDA" },
  { .ov = 48, .code = 0x1d29, .word = 0xebde, .immediate=0, .flags=0x00, .name = "WEBDE" },
  { .ov = 48, .code = 0x224c, .word = 0xebe4, .immediate=0, .flags=0x00, .name = "WEBE4" },
  { .ov = 48, .code = 0x224c, .word = 0xebf2, .immediate=0, .flags=0x00, .name = "WEBF2" },
  { .ov = 48, .code = 0x224c, .word = 0xebfc, .immediate=0, .flags=0x00, .name = "WEBFC" },
  { .ov = 48, .code = 0x224c, .word = 0xec0a, .immediate=0, .flags=0x00, .name = "WEC0A" },
  { .ov = 48, .code = 0x224c, .word = 0xec12, .immediate=0, .flags=0x00, .name = "WEC12" },
  { .ov = 48, .code = 0x224c, .word = 0xec30, .immediate=0, .flags=0x00, .name = "WEC30" },
  { .ov = 48, .code = 0x224c, .word = 0xec46, .immediate=0, .flags=0x00, .name = "WEC46" },
  { .ov = 48, .code = 0x224c, .word = 0xec6a, .immediate=0, .flags=0x00, .name = "WEC6A" },
  { .ov = 48, .code = 0x224c, .word = 0xec8a, .immediate=0, .flags=0x00, .name = "WEC8A" },
  { .ov = 48, .code = 0x224c, .word = 0xeca0, .immediate=0, .flags=0x00, .name = "WECA0" },
  { .ov = 48, .code = 0x224c, .word = 0xecbc, .immediate=0, .flags=0x00, .name = "WECBC" },
  { .ov = 48, .code = 0x224c, .word = 0xecd8, .immediate=0, .flags=0x00, .name = "WECD8" },
  { .ov = 48, .code = 0x224c, .word = 0xecf2, .immediate=0, .flags=0x00, .name = "WECF2" },
  { .ov = 48, .code = 0x1d29, .word = 0xed04, .immediate=0, .flags=0x80, .name = "LDAMAGE" },
  { .ov = 48, .code = 0x224c, .word = 0xed12, .immediate=0, .flags=0x00, .name = "WED12" },
  { .ov = 48, .code = 0x224c, .word = 0xed36, .immediate=0, .flags=0x00, .name = "WED36" },
  { .ov = 48, .code = 0x224c, .word = 0xed4e, .immediate=0, .flags=0x00, .name = "WED4E" },
  { .ov = 48, .code = 0x1d29, .word = 0xed5a, .immediate=0, .flags=0x00, .name = "WED5A" },
  { .ov = 48, .code = 0x224c, .word = 0xed5e, .immediate=0, .flags=0x00, .name = "WED5E" },
  { .ov = 48, .code = 0x224c, .word = 0xed6a, .immediate=0, .flags=0x00, .name = "WED6A" },
  { .ov = 48, .code = 0x1d29, .word = 0xed92, .immediate=0, .flags=0x80, .name = "WOUNDED" },
  { .ov = 48, .code = 0x1d29, .word = 0xed9a, .immediate=0, .flags=0x00, .name = "WED9A" },
  { .ov = 48, .code = 0x224c, .word = 0xed9e, .immediate=0, .flags=0x00, .name = "WED9E" },
  { .ov = 48, .code = 0x224c, .word = 0xede0, .immediate=0, .flags=0x00, .name = "WEDE0" },
  { .ov = 48, .code = 0x224c, .word = 0xedf2, .immediate=0, .flags=0x00, .name = "WEDF2" },
  { .ov = 48, .code = 0x224c, .word = 0xee04, .immediate=0, .flags=0x00, .name = "WEE04" },
  { .ov = 48, .code = 0x224c, .word = 0xee27, .immediate=0, .flags=0x00, .name = "WEE27" },
  { .ov = 48, .code = 0x224c, .word = 0xee46, .immediate=0, .flags=0x00, .name = "WEE46" },
  { .ov = 48, .code = 0x224c, .word = 0xee65, .immediate=0, .flags=0x00, .name = "WEE65" },
  { .ov = 48, .code = 0x224c, .word = 0xee8e, .immediate=0, .flags=0x00, .name = "WEE8E" },
  { .ov = 48, .code = 0xee6d, .word = 0xeeaa, .immediate=0, .flags=0x80, .name = "ENGINE-" },
  { .ov = 48, .code = 0xee6d, .word = 0xeeba, .immediate=0, .flags=0x80, .name = "SENSOR-" },
  { .ov = 48, .code = 0xee6d, .word = 0xeeca, .immediate=0, .flags=0x80, .name = "COMM-CH" },
  { .ov = 48, .code = 0xee6d, .word = 0xeeda, .immediate=0, .flags=0x80, .name = "MISS-CH" },
  { .ov = 48, .code = 0xee6d, .word = 0xeeea, .immediate=0, .flags=0x80, .name = "LASER-C" },
  { .ov = 48, .code = 0xee6d, .word = 0xeefa, .immediate=0, .flags=0x80, .name = "SHIELD-" },
  { .ov = 48, .code = 0x224c, .word = 0xef00, .immediate=0, .flags=0x00, .name = "WEF00" },
  { .ov = 48, .code = 0x4a4f, .word = 0xef16, .immediate=0, .flags=0x80, .name = "#>?FIEL" },
  { .ov = 48, .code = 0x224c, .word = 0xef3c, .immediate=0, .flags=0x00, .name = "WEF3C" },
  { .ov = 48, .code = 0x224c, .word = 0xef76, .immediate=0, .flags=0x00, .name = "WEF76" },
  { .ov = 48, .code = 0x224c, .word = 0xef8e, .immediate=0, .flags=0x00, .name = "WEF8E" },
  { .ov = 48, .code = 0x224c, .word = 0xf02e, .immediate=0, .flags=0x00, .name = "WF02E" },
  { .ov = 48, .code = 0x1d29, .word = 0xf081, .immediate=0, .flags=0x00, .name = "WF081" },
  { .ov = 48, .code = 0x224c, .word = 0xf08a, .immediate=0, .flags=0x00, .name = "WF08A" },
  { .ov = 48, .code = 0x224c, .word = 0xf0e0, .immediate=0, .flags=0x00, .name = "WF0E0" },
  { .ov = 48, .code = 0x224c, .word = 0xf136, .immediate=0, .flags=0x00, .name = "WF136" },
  { .ov = 48, .code = 0x224c, .word = 0xf162, .immediate=0, .flags=0x00, .name = "WF162" },
  { .ov = 48, .code = 0x224c, .word = 0xf19a, .immediate=0, .flags=0x00, .name = "WF19A" },
  { .ov = 48, .code = 0x224c, .word = 0xf1ec, .immediate=0, .flags=0x00, .name = "WF1EC" },
  { .ov = 48, .code = 0x1d29, .word = 0xf22a, .immediate=0, .flags=0x80, .name = "MDAMAGE" },
  { .ov = 48, .code = 0x224c, .word = 0xf23a, .immediate=0, .flags=0x00, .name = "WF23A" },
  { .ov = 48, .code = 0x224c, .word = 0xf248, .immediate=0, .flags=0x00, .name = "WF248" },
  { .ov = 48, .code = 0x224c, .word = 0xf26a, .immediate=0, .flags=0x00, .name = "WF26A" },
  { .ov = 48, .code = 0x224c, .word = 0xf2a2, .immediate=0, .flags=0x00, .name = "WF2A2" },
  { .ov = 48, .code = 0x224c, .word = 0xf2ac, .immediate=0, .flags=0x00, .name = "WF2AC" },
  { .ov = 48, .code = 0x224c, .word = 0xf2e8, .immediate=0, .flags=0x00, .name = "WF2E8" },
  { .ov = 48, .code = 0x224c, .word = 0xf2f2, .immediate=0, .flags=0x00, .name = "WF2F2" },
  { .ov = 48, .code = 0x224c, .word = 0xf2fc, .immediate=0, .flags=0x00, .name = "WF2FC" },
  { .ov = 48, .code = 0x224c, .word = 0xf306, .immediate=0, .flags=0x00, .name = "WF306" },
  { .ov = 48, .code = 0x224c, .word = 0xf31e, .immediate=0, .flags=0x00, .name = "WF31E" },
  { .ov = 48, .code = 0x4a4f, .word = 0xf332, .immediate=0, .flags=0x80, .name = "#>DAMAG" },
  { .ov = 48, .code = 0x224c, .word = 0xf358, .immediate=0, .flags=0x00, .name = "WF358" },
  { .ov = 48, .code = 0x224c, .word = 0xf378, .immediate=0, .flags=0x00, .name = "WF378" },
  { .ov = 48, .code = 0x224c, .word = 0xf3a4, .immediate=0, .flags=0x00, .name = "WF3A4" },
  { .ov = 48, .code = 0x224c, .word = 0xf3ea, .immediate=0, .flags=0x00, .name = "WF3EA" },
  { .ov = 48, .code = 0x224c, .word = 0xf3f8, .immediate=0, .flags=0x00, .name = "WF3F8" },
  { .ov = 48, .code = 0x224c, .word = 0xf404, .immediate=0, .flags=0x00, .name = "WF404" },
  { .ov = 48, .code = 0x224c, .word = 0xf43c, .immediate=0, .flags=0x00, .name = "WF43C" },
  { .ov = 48, .code = 0x224c, .word = 0xf47f, .immediate=0, .flags=0x00, .name = "WF47F" },
  { .ov = 48, .code = 0x224c, .word = 0xf4e5, .immediate=0, .flags=0x00, .name = "WF4E5" },
  { .ov = 48, .code = 0x224c, .word = 0xf4f7, .immediate=0, .flags=0x00, .name = "WF4F7" },
  { .ov = 48, .code = 0x224c, .word = 0xf507, .immediate=0, .flags=0x00, .name = "WF507" },
  { .ov = 48, .code = 0x224c, .word = 0xf521, .immediate=0, .flags=0x80, .name = "DO-DAMA" },
  { .ov = 49, .code = 0x744d, .word = 0xf136, .immediate=0, .flags=0x00, .name = "WF136" },
  { .ov = 49, .code = 0x73ea, .word = 0xf13b, .immediate=0, .flags=0x00, .name = "WF13B" },
  { .ov = 49, .code = 0x1d29, .word = 0xf143, .immediate=0, .flags=0x00, .name = "WF143" },
  { .ov = 49, .code = 0x224c, .word = 0xf147, .immediate=0, .flags=0x00, .name = "WF147" },
  { .ov = 49, .code = 0x224c, .word = 0xf177, .immediate=0, .flags=0x00, .name = "WF177" },
  { .ov = 49, .code = 0x224c, .word = 0xf1c9, .immediate=0, .flags=0x00, .name = "WF1C9" },
  { .ov = 49, .code = 0x224c, .word = 0xf1db, .immediate=0, .flags=0x00, .name = "WF1DB" },
  { .ov = 49, .code = 0x224c, .word = 0xf1f1, .immediate=0, .flags=0x00, .name = "WF1F1" },
  { .ov = 49, .code = 0x224c, .word = 0xf258, .immediate=0, .flags=0x00, .name = "WF258" },
  { .ov = 49, .code = 0x224c, .word = 0xf32c, .immediate=0, .flags=0x00, .name = "WF32C" },
  { .ov = 49, .code = 0x224c, .word = 0xf342, .immediate=0, .flags=0x00, .name = "WF342" },
  { .ov = 49, .code = 0x224c, .word = 0xf37b, .immediate=0, .flags=0x00, .name = "WF37B" },
  { .ov = 49, .code = 0x224c, .word = 0xf39d, .immediate=0, .flags=0x00, .name = "WF39D" },
  { .ov = 49, .code = 0x224c, .word = 0xf3d6, .immediate=0, .flags=0x00, .name = "WF3D6" },
  { .ov = 49, .code = 0x224c, .word = 0xf3e2, .immediate=0, .flags=0x00, .name = "WF3E2" },
  { .ov = 49, .code = 0x224c, .word = 0xf430, .immediate=0, .flags=0x00, .name = "WF430" },
  { .ov = 49, .code = 0x224c, .word = 0xf45e, .immediate=0, .flags=0x00, .name = "WF45E" },
  { .ov = 49, .code = 0x224c, .word = 0xf49e, .immediate=0, .flags=0x80, .name = "?LAND" },
  { .ov = 49, .code = 0x224c, .word = 0xf4f5, .immediate=0, .flags=0x80, .name = "?LAUNCH" },
  { .ov = 50, .code = 0x2214, .word = 0xe21f, .immediate=0, .flags=0x80, .name = "OLDINT" },
  { .ov = 50, .code = 0x2214, .word = 0xe22c, .immediate=0, .flags=0x80, .name = "?MUSIC" },
  { .ov = 50, .code = 0x2214, .word = 0xe239, .immediate=0, .flags=0x80, .name = "MUSINT" },
  { .ov = 50, .code = 0x2214, .word = 0xe247, .immediate=0, .flags=0x80, .name = "PHRASE0" },
  { .ov = 50, .code = 0x2214, .word = 0xe255, .immediate=0, .flags=0x80, .name = "CURRPHR" },
  { .ov = 50, .code = 0x2214, .word = 0xe263, .immediate=0, .flags=0x80, .name = "CURNOTE" },
  { .ov = 50, .code = 0x2214, .word = 0xe271, .immediate=0, .flags=0x80, .name = "REPEATS" },
  { .ov = 50, .code = 0x2214, .word = 0xe27f, .immediate=0, .flags=0x80, .name = "COUNTER" },
  { .ov = 50, .code = 0x2214, .word = 0xe28e, .immediate=0, .flags=0x80, .name = "DURATION" },
  { .ov = 50, .code = 0x2214, .word = 0xe29e, .immediate=0, .flags=0x80, .name = "RESTVALUE" },
  { .ov = 50, .code = 0x2214, .word = 0xe2ae, .immediate=0, .flags=0x80, .name = "TONESTATE" },
  { .ov = 50, .code = 0x2214, .word = 0xe2ba, .immediate=0, .flags=0x80, .name = "SONGS" },
  { .ov = 50, .code = 0x2214, .word = 0xe2c6, .immediate=0, .flags=0x80, .name = "SCALE" },
  { .ov = 50, .code = 0x1d29, .word = 0xe2ca, .immediate=0, .flags=0x00, .name = "WE2CA" },
  { .ov = 50, .code = 0x224c, .word = 0xe2ce, .immediate=0, .flags=0x00, .name = "WE2CE" },
  { .ov = 50, .code = 0x224c, .word = 0xe2d6, .immediate=0, .flags=0x00, .name = "WE2D6" },
  { .ov = 50, .code = 0x224c, .word = 0xe2de, .immediate=0, .flags=0x00, .name = "WE2DE" },
  { .ov = 50, .code = 0x224c, .word = 0xe2e6, .immediate=0, .flags=0x00, .name = "WE2E6" },
  { .ov = 50, .code = 0x224c, .word = 0xe2ee, .immediate=0, .flags=0x00, .name = "WE2EE" },
  { .ov = 50, .code = 0x1d29, .word = 0xe4be, .immediate=0, .flags=0x80, .name = "P2" },
  { .ov = 50, .code = 0x1d29, .word = 0xe4d9, .immediate=0, .flags=0x80, .name = "P3" },
  { .ov = 50, .code = 0x1d29, .word = 0xe4f4, .immediate=0, .flags=0x80, .name = "P4" },
  { .ov = 50, .code = 0x1d29, .word = 0xe50f, .immediate=0, .flags=0x80, .name = "P5" },
  { .ov = 50, .code = 0x1d29, .word = 0xe530, .immediate=0, .flags=0x80, .name = "P6" },
  { .ov = 50, .code = 0x1d29, .word = 0xe54b, .immediate=0, .flags=0x80, .name = "P1" },
  { .ov = 50, .code = 0x224c, .word = 0xe56c, .immediate=0, .flags=0x80, .name = "R," },
  { .ov = 50, .code = 0x1d29, .word = 0xe580, .immediate=0, .flags=0x80, .name = "0SONG" },
  { .ov = 50, .code = 0x224c, .word = 0xe5a3, .immediate=0, .flags=0x80, .name = "INITMUS" },
  { .ov = 50, .code = 0x224c, .word = 0xe5eb, .immediate=0, .flags=0x80, .name = "HIMUS" },
  { .ov = 50, .code = 0x224c, .word = 0xe60c, .immediate=0, .flags=0x80, .name = "CSCR>EGA" },
  { .ov = 50, .code = 0x224c, .word = 0xe680, .immediate=0, .flags=0x00, .name = "WE680" },
  { .ov = 50, .code = 0x224c, .word = 0xe69c, .immediate=0, .flags=0x00, .name = "WE69C" },
  { .ov = 50, .code = 0x2214, .word = 0xe6b8, .immediate=0, .flags=0x00, .name = "WE6B8" },
  { .ov = 50, .code = 0x1d29, .word = 0xe6bc, .immediate=0, .flags=0x00, .name = "WE6BC" },
  { .ov = 50, .code = 0x1d29, .word = 0xe6c0, .immediate=0, .flags=0x00, .name = "WE6C0" },
  { .ov = 50, .code = 0x1d29, .word = 0xe6c4, .immediate=0, .flags=0x00, .name = "WE6C4" },
  { .ov = 50, .code = 0x1d29, .word = 0xe6c8, .immediate=0, .flags=0x00, .name = "WE6C8" },
  { .ov = 50, .code = 0x1d29, .word = 0xe6cc, .immediate=0, .flags=0x00, .name = "WE6CC" },
  { .ov = 50, .code = 0x1d29, .word = 0xe6d0, .immediate=0, .flags=0x00, .name = "WE6D0" },
  { .ov = 50, .code = 0x1d29, .word = 0xe6d4, .immediate=0, .flags=0x00, .name = "WE6D4" },
  { .ov = 50, .code = 0x1d29, .word = 0xe6d8, .immediate=0, .flags=0x00, .name = "WE6D8" },
  { .ov = 50, .code = 0x1d29, .word = 0xe6dc, .immediate=0, .flags=0x00, .name = "WE6DC" },
  { .ov = 50, .code = 0x1d29, .word = 0xe6e0, .immediate=0, .flags=0x00, .name = "WE6E0" },
  { .ov = 50, .code = 0x224c, .word = 0xe6e4, .immediate=0, .flags=0x00, .name = "WE6E4" },
  { .ov = 50, .code = 0x224c, .word = 0xe6ec, .immediate=0, .flags=0x00, .name = "WE6EC" },
  { .ov = 50, .code = 0x224c, .word = 0xe700, .immediate=0, .flags=0x00, .name = "WE700" },
  { .ov = 50, .code = 0x224c, .word = 0xe716, .immediate=0, .flags=0x00, .name = "WE716" },
  { .ov = 50, .code = 0x224c, .word = 0xe733, .immediate=0, .flags=0x80, .name = "BRMOVE" },
  { .ov = 50, .code = 0x224c, .word = 0xe7cd, .immediate=0, .flags=0x00, .name = "WE7CD" },
  { .ov = 50, .code = 0x224c, .word = 0xe813, .immediate=0, .flags=0x00, .name = "WE813" },
  { .ov = 50, .code = 0x224c, .word = 0xe82b, .immediate=0, .flags=0x00, .name = "WE82B" },
  { .ov = 50, .code = 0x224c, .word = 0xe890, .immediate=0, .flags=0x80, .name = "REDUCE" },
  { .ov = 50, .code = 0x224c, .word = 0xe8c3, .immediate=0, .flags=0x80, .name = "INCREASE" },
  { .ov = 50, .code = 0x1d29, .word = 0xe8e5, .immediate=0, .flags=0x80, .name = "XOFFS" },
  { .ov = 50, .code = 0x1d29, .word = 0xe90c, .immediate=0, .flags=0x80, .name = "PAUSEOFF" },
  { .ov = 50, .code = 0x224c, .word = 0xe928, .immediate=0, .flags=0x00, .name = "WE928" },
  { .ov = 50, .code = 0x224c, .word = 0xe98e, .immediate=0, .flags=0x80, .name = "CREDIT.SCREEN" },
  { .ov = 50, .code = 0x224c, .word = 0xe9a7, .immediate=0, .flags=0x80, .name = "INTROS" },
  { .ov = 51, .code = 0x744d, .word = 0xefd6, .immediate=0, .flags=0x00, .name = "WEFD6" },
  { .ov = 51, .code = 0x1d29, .word = 0xefdb, .immediate=0, .flags=0x00, .name = "WEFDB" },
  { .ov = 51, .code = 0x224c, .word = 0xefe8, .immediate=0, .flags=0x80, .name = "SIC'EM" },
  { .ov = 51, .code = 0x1d29, .word = 0xf032, .immediate=0, .flags=0x00, .name = "WF032" },
  { .ov = 51, .code = 0x1d29, .word = 0xf036, .immediate=0, .flags=0x00, .name = "WF036" },
  { .ov = 51, .code = 0x1d29, .word = 0xf03a, .immediate=0, .flags=0x00, .name = "WF03A" },
  { .ov = 51, .code = 0x1d29, .word = 0xf03e, .immediate=0, .flags=0x00, .name = "WF03E" },
  { .ov = 51, .code = 0x1d29, .word = 0xf042, .immediate=0, .flags=0x00, .name = "WF042" },
  { .ov = 51, .code = 0x224c, .word = 0xf048, .immediate=0, .flags=0x00, .name = "WF048" },
  { .ov = 51, .code = 0x224c, .word = 0xf088, .immediate=0, .flags=0x00, .name = "WF088" },
  { .ov = 51, .code = 0x224c, .word = 0xf094, .immediate=0, .flags=0x00, .name = "WF094" },
  { .ov = 51, .code = 0x224c, .word = 0xf0a1, .immediate=0, .flags=0x00, .name = "WF0A1" },
  { .ov = 51, .code = 0x224c, .word = 0xf0ae, .immediate=0, .flags=0x00, .name = "WF0AE" },
  { .ov = 51, .code = 0x224c, .word = 0xf0bc, .immediate=0, .flags=0x00, .name = "WF0BC" },
  { .ov = 51, .code = 0x224c, .word = 0xf0c9, .immediate=0, .flags=0x00, .name = "WF0C9" },
  { .ov = 51, .code = 0x224c, .word = 0xf0d9, .immediate=0, .flags=0x00, .name = "WF0D9" },
  { .ov = 51, .code = 0x224c, .word = 0xf0e5, .immediate=0, .flags=0x00, .name = "WF0E5" },
  { .ov = 51, .code = 0x224c, .word = 0xf0f5, .immediate=0, .flags=0x00, .name = "WF0F5" },
  { .ov = 51, .code = 0x224c, .word = 0xf106, .immediate=0, .flags=0x00, .name = "WF106" },
  { .ov = 51, .code = 0x224c, .word = 0xf111, .immediate=0, .flags=0x00, .name = "WF111" },
  { .ov = 51, .code = 0x224c, .word = 0xf124, .immediate=0, .flags=0x00, .name = "WF124" },
  { .ov = 51, .code = 0x224c, .word = 0xf13a, .immediate=0, .flags=0x00, .name = "WF13A" },
  { .ov = 51, .code = 0x224c, .word = 0xf147, .immediate=0, .flags=0x00, .name = "WF147" },
  { .ov = 51, .code = 0x224c, .word = 0xf154, .immediate=0, .flags=0x00, .name = "WF154" },
  { .ov = 51, .code = 0x224c, .word = 0xf160, .immediate=0, .flags=0x00, .name = "WF160" },
  { .ov = 51, .code = 0x224c, .word = 0xf16f, .immediate=0, .flags=0x00, .name = "WF16F" },
  { .ov = 51, .code = 0x224c, .word = 0xf182, .immediate=0, .flags=0x00, .name = "WF182" },
  { .ov = 51, .code = 0x224c, .word = 0xf190, .immediate=0, .flags=0x00, .name = "WF190" },
  { .ov = 51, .code = 0x224c, .word = 0xf19d, .immediate=0, .flags=0x00, .name = "WF19D" },
  { .ov = 51, .code = 0x224c, .word = 0xf1b5, .immediate=0, .flags=0x00, .name = "WF1B5" },
  { .ov = 51, .code = 0x224c, .word = 0xf1c0, .immediate=0, .flags=0x00, .name = "WF1C0" },
  { .ov = 51, .code = 0x224c, .word = 0xf1ce, .immediate=0, .flags=0x00, .name = "WF1CE" },
  { .ov = 51, .code = 0x224c, .word = 0xf1dc, .immediate=0, .flags=0x00, .name = "WF1DC" },
  { .ov = 51, .code = 0x224c, .word = 0xf1ec, .immediate=0, .flags=0x00, .name = "WF1EC" },
  { .ov = 51, .code = 0x224c, .word = 0xf1fc, .immediate=0, .flags=0x00, .name = "WF1FC" },
  { .ov = 51, .code = 0x224c, .word = 0xf20d, .immediate=0, .flags=0x00, .name = "WF20D" },
  { .ov = 51, .code = 0x224c, .word = 0xf223, .immediate=0, .flags=0x00, .name = "WF223" },
  { .ov = 51, .code = 0x224c, .word = 0xf231, .immediate=0, .flags=0x00, .name = "WF231" },
  { .ov = 51, .code = 0x224c, .word = 0xf24c, .immediate=0, .flags=0x00, .name = "WF24C" },
  { .ov = 51, .code = 0x224c, .word = 0xf257, .immediate=0, .flags=0x00, .name = "WF257" },
  { .ov = 51, .code = 0x224c, .word = 0xf26c, .immediate=0, .flags=0x00, .name = "WF26C" },
  { .ov = 51, .code = 0x224c, .word = 0xf277, .immediate=0, .flags=0x00, .name = "WF277" },
  { .ov = 51, .code = 0x1d29, .word = 0xf287, .immediate=0, .flags=0x00, .name = "WF287" },
  { .ov = 51, .code = 0x1d29, .word = 0xf29b, .immediate=0, .flags=0x00, .name = "WF29B" },
  { .ov = 51, .code = 0x1d29, .word = 0xf2cd, .immediate=0, .flags=0x00, .name = "WF2CD" },
  { .ov = 51, .code = 0x224c, .word = 0xf2e7, .immediate=0, .flags=0x00, .name = "WF2E7" },
  { .ov = 51, .code = 0x224c, .word = 0xf32d, .immediate=0, .flags=0x00, .name = "WF32D" },
  { .ov = 51, .code = 0x224c, .word = 0xf34b, .immediate=0, .flags=0x00, .name = "WF34B" },
  { .ov = 51, .code = 0x224c, .word = 0xf3a0, .immediate=0, .flags=0x00, .name = "WF3A0" },
  { .ov = 51, .code = 0x224c, .word = 0xf3e4, .immediate=0, .flags=0x00, .name = "WF3E4" },
  { .ov = 51, .code = 0x224c, .word = 0xf441, .immediate=0, .flags=0x00, .name = "WF441" },
  { .ov = 51, .code = 0x224c, .word = 0xf45a, .immediate=0, .flags=0x00, .name = "WF45A" },
  { .ov = 51, .code = 0x224c, .word = 0xf48f, .immediate=0, .flags=0x00, .name = "WF48F" },
  { .ov = 51, .code = 0x224c, .word = 0xf4bf, .immediate=0, .flags=0x80, .name = "STP" },
  { .ov = 51, .code = 0x224c, .word = 0xf4f4, .immediate=0, .flags=0x80, .name = "2NDS" },
  { .ov = -2, .code = 0x0000, .word = 0x0000, .immediate = 0x00, .flags=0x00, .name = NULL }
};
