#include<stdio.h>

#ifdef STARFLT1
    unsigned char huffmantable[100] =
    {
        0x9c, 0x81, 0x96, 0x81, 0x81, 0x20, 0x83, 0x81,
        0x81, 0x48, 0x59, 0x43, 0x82, 0x81, 0x4d, 0x57,
        0x81, 0x2e, 0x81, 0x42, 0x84, 0x81, 0x31, 0x81,
        0x5a, 0x81, 0x34, 0x33, 0x86, 0x81, 0x51, 0x81,
        0x81, 0x32, 0x81, 0x25, 0x2b, 0x81, 0x23, 0x28,
        0x81, 0x3f, 0x39, 0x81, 0x37, 0x2a, 0x84, 0x81,
        0x54, 0x81, 0x81, 0x4c, 0x50, 0x46, 0x53, 0x4f,
        0x8d, 0x81, 0x82, 0x81, 0x4e, 0x41, 0x49, 0x81,
        0x81, 0x55, 0x81, 0x47, 0x2c, 0x81, 0x81, 0x58,
        0x27, 0x81, 0x81, 0x21, 0x35, 0x81, 0x26, 0x81,
        0x29, 0x2f, 0x81, 0x45, 0x81, 0x52, 0x81, 0x44,
        0x81, 0x56, 0x4b, 0x81, 0x81, 0x30, 0x81, 0x2d,
        0x81, 0x4a, 0x36, 0x38
    };
#else
    unsigned char huffmantable[102] =
    {
        0xa1, 0x81, 0x8b, 0x81, 0x5e, 0x81, 0x81, 0x45,
        0x81, 0x52, 0x81, 0x44, 0x81, 0x56, 0x4b, 0x81,
        0x81, 0x30, 0x81, 0x2d, 0x81, 0x4a, 0x36, 0x38,
        0x81, 0x20, 0x83, 0x81, 0x81, 0x48, 0x59, 0x43,
        0x82, 0x81, 0x4d, 0x57, 0x81, 0x2e, 0x81, 0x42,
        0x84, 0x81, 0x31, 0x81, 0x5a, 0x81, 0x34, 0x33,
        0x86, 0x81, 0x51, 0x81, 0x81, 0x32, 0x81, 0x25,
        0x2b, 0x81, 0x23, 0x28, 0x81, 0x3f, 0x39, 0x81,
        0x37, 0x2a, 0x86, 0x81, 0x84, 0x81, 0x54, 0x81,
        0x81, 0x4c, 0x50, 0x46, 0x53, 0x4f, 0x82, 0x81,
        0x4e, 0x41, 0x49, 0x81, 0x81, 0x55, 0x81, 0x47,
        0x2c, 0x81, 0x81, 0x58, 0x27, 0x81, 0x81, 0x21,
        0x35, 0x81, 0x26, 0x81, 0x29, 0x2f
    };
#endif

char HuffmanDecodeChar(unsigned char *buf, int *byteoffset, int *bits)
{
    int huffoffset = 0;
    while(1)
    {
        int bit = ((buf[*byteoffset] & (*bits))!=0)?1:0;
        if ((*bits) == 0x80)
        {
            (*byteoffset)++;
        }
        (*bits) >>= 1;
        if (*bits == 0)
        {
            *bits = 0x80;
        }
        //printf("%i\n", *bits);
        if ((huffmantable[huffoffset+bit]&0x80) == 0)
            return huffmantable[huffoffset+bit];
        huffoffset += (huffmantable[huffoffset+bit] & 0x7F) * 2;
    }
}

void HuffmanDecode(FILE* fp, char* buf, int n)
{
    int bits = 0x80;
    int byteoffset = 0;
    for(int i=0; i<n; i++)
    {
        char c = HuffmanDecodeChar((unsigned char*)buf, &byteoffset, &bits);
        fprintf(fp, "%c", c);
    }
}

char* HuffmanDecodeToString(char* buf, int n)
{
    int bits = 0x80;
    int byteoffset = 0;
    static char str[512];

    for(int i=0; i<n; i++)
    {
        char c = HuffmanDecodeChar((unsigned char*)buf, &byteoffset, &bits);
        str[i] = c;
    }
    str[n]=0;
    return str;
}
