#ifndef DATA_H
#define DATA_H

// following table contains all planets in starflight 1 and their random seeds to generate their landscape
// it is not part of fract-ov, but a combination of instance and adata content
typedef struct { int x, y, orbit, species, seed; } PLANET;

typedef struct { int idx; int d1, surftype, mass, lseed, tseed, d8, min, d2, d3, d4, d5, d6, coldest, warmest, atmoactivity, atmodensity, d7; } PLANETTYPEENTRY;

PLANETTYPEENTRY planettypes[]=
{
  {.idx= 0, .d1=32, .surftype=32, .mass=8224, .lseed= 32, .d8= 8224, .tseed=0x2020, .d8= 32, .min= 32, .d2= 32, .d3= 32, .d4=32, .d5=32, .d6=32, .coldest=32, .warmest=8224, .atmoactivity=32, .atmodensity=32, .d7=32},
  {.idx= 1, .d1= 1, .surftype= 4, .mass=   0, .lseed=  0, .d8=    0, .tseed=0x0000, .d8=  0, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx= 2, .d1= 2, .surftype= 4, .mass=   0, .lseed=  0, .d8=    0, .tseed=0x0000, .d8=  0, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx= 3, .d1= 3, .surftype= 4, .mass=   0, .lseed=  0, .d8=    0, .tseed=0x0000, .d8=  0, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx= 4, .d1= 4, .surftype= 4, .mass=   0, .lseed=  0, .d8=    0, .tseed=0x0000, .d8=  0, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx= 5, .d1= 1, .surftype= 5, .mass=   0, .lseed=  0, .d8=    0, .tseed=0x0000, .d8=  0, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx= 6, .d1= 2, .surftype= 5, .mass=   0, .lseed=  0, .d8=    0, .tseed=0x0000, .d8=  0, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx= 7, .d1= 3, .surftype= 5, .mass=   0, .lseed=  0, .d8=    0, .tseed=0x0000, .d8=  0, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx= 8, .d1= 4, .surftype= 5, .mass=   0, .lseed=  0, .d8=    0, .tseed=0x0000, .d8=  0, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx= 9, .d1= 1, .surftype= 2, .mass=   0, .lseed=  0, .d8=    0, .tseed=0x0000, .d8=  0, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=10, .d1= 2, .surftype= 2, .mass=   0, .lseed=  0, .d8=    0, .tseed=0x0000, .d8=  0, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=11, .d1= 3, .surftype= 2, .mass=   0, .lseed=  0, .d8=    0, .tseed=0x0000, .d8=  0, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=12, .d1= 4, .surftype= 2, .mass=   0, .lseed=  0, .d8=    0, .tseed=0x0000, .d8=  0, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=13, .d1= 1, .surftype= 3, .mass=   0, .lseed=  0, .d8=    0, .tseed=0x0000, .d8=  0, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=14, .d1= 2, .surftype= 3, .mass=   0, .lseed=  0, .d8=    0, .tseed=0x0000, .d8=  0, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=15, .d1= 3, .surftype= 3, .mass=   0, .lseed=  0, .d8=    0, .tseed=0x0000, .d8=  0, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=16, .d1= 4, .surftype= 3, .mass=   0, .lseed=  0, .d8=    0, .tseed=0x0000, .d8=  0, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=17, .d1= 5, .surftype= 1, .mass=   0, .lseed=  0, .d8=    0, .tseed=0x0000, .d8=  0, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=18, .d1= 7, .surftype= 2, .mass= 100, .lseed=  0, .d8=  199, .tseed=0x03b8, .d8= 13, .min=  0, .d2=255, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=19, .d1= 4, .surftype= 2, .mass= 415, .lseed=  0, .d8=  299, .tseed=0x017e, .d8= 51, .min= 60, .d2=128, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=20, .d1= 2, .surftype= 3, .mass=  70, .lseed=  0, .d8=  399, .tseed=0x0290, .d8=204, .min=100, .d2= 51, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=21, .d1= 2, .surftype= 5, .mass=  65, .lseed=  0, .d8=  499, .tseed=0x000d, .d8= 77, .min=150, .d2= 89, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=22, .d1= 3, .surftype= 5, .mass=  90, .lseed=  0, .d8=  599, .tseed=0x018f, .d8= 77, .min=175, .d2=153, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=23, .d1= 6, .surftype= 0, .mass= 101, .lseed=  0, .d8=    0, .tseed=0x006e, .d8= 75, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=24, .d1= 3, .surftype= 2, .mass=  95, .lseed=255, .d8=  699, .tseed=0x01d2, .d8=102, .min=120, .d2=179, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=25, .d1= 4, .surftype= 3, .mass= 250, .lseed= 77, .d8=  799, .tseed=0x00b6, .d8=128, .min=200, .d2= 51, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=26, .d1= 2, .surftype= 2, .mass=  60, .lseed=204, .d8=  899, .tseed=0x0007, .d8= 64, .min= 51, .d2=153, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=27, .d1= 2, .surftype= 3, .mass=  80, .lseed= 51, .d8=  999, .tseed=0x0003, .d8= 77, .min=250, .d2=128, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=28, .d1= 3, .surftype= 2, .mass= 109, .lseed=179, .d8=  109, .tseed=0x00ea, .d8=153, .min=128, .d2=153, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=29, .d1= 4, .surftype= 2, .mass= 140, .lseed=230, .d8=  119, .tseed=0x000c, .d8=115, .min=150, .d2= 77, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=30, .d1= 2, .surftype= 2, .mass=  76, .lseed=255, .d8=  119, .tseed=0x00d2, .d8=204, .min= 80, .d2=179, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=31, .d1= 4, .surftype= 3, .mass= 180, .lseed= 20, .d8=  139, .tseed=0x0168, .d8= 40, .min= 30, .d2=102, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=32, .d1= 2, .surftype= 2, .mass= 250, .lseed= 89, .d8=  197, .tseed=0x003e, .d8= 51, .min= 50, .d2=153, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=33, .d1= 3, .surftype= 5, .mass= 105, .lseed= 64, .d8=  159, .tseed=0x024e, .d8= 51, .min= 70, .d2= 38, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=34, .d1= 3, .surftype= 2, .mass= 100, .lseed=153, .d8=  169, .tseed=0x03b9, .d8=166, .min=100, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=35, .d1= 2, .surftype= 2, .mass=  55, .lseed=230, .d8=  179, .tseed=0x21e3, .d8= 55, .min= 75, .d2=128, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=36, .d1= 4, .surftype= 3, .mass= 180, .lseed= 38, .d8=  189, .tseed=0x00ce, .d8= 38, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=37, .d1= 2, .surftype= 2, .mass=  72, .lseed=255, .d8=  209, .tseed=0x033c, .d8= 85, .min=120, .d2= 32, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=38, .d1= 3, .surftype= 3, .mass=  94, .lseed= 89, .d8=  205, .tseed=0x009b, .d8= 45, .min=200, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=39, .d1= 4, .surftype= 2, .mass= 125, .lseed=255, .d8=  229, .tseed=0x0042, .d8=185, .min=150, .d2= 40, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=40, .d1= 4, .surftype= 3, .mass= 400, .lseed= 70, .d8=  239, .tseed=0x0180, .d8=200, .min=150, .d2= 60, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=41, .d1= 4, .surftype= 5, .mass= 280, .lseed= 85, .d8=  249, .tseed=0x0071, .d8= 70, .min= 80, .d2= 35, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=42, .d1= 2, .surftype= 3, .mass=  88, .lseed=145, .d8=  259, .tseed=0x0009, .d8=153, .min=175, .d2= 45, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=43, .d1= 4, .surftype= 2, .mass= 115, .lseed=255, .d8=10101, .tseed=0x00b2, .d8= 20, .min=150, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=44, .d1= 1, .surftype= 5, .mass=   3, .lseed=  0, .d8=  279, .tseed=0x0419, .d8=255, .min=255, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=45, .d1= 1, .surftype= 4, .mass=  20, .lseed=  0, .d8=  289, .tseed=0x007d, .d8=255, .min= 50, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=46, .d1= 2, .surftype= 2, .mass=  50, .lseed=160, .d8=  309, .tseed=0x005c, .d8=115, .min=150, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=47, .d1= 2, .surftype= 2, .mass=  89, .lseed=220, .d8=  319, .tseed=0x0167, .d8= 70, .min= 75, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=48, .d1= 4, .surftype= 2, .mass= 210, .lseed=255, .d8=  329, .tseed=0x006b, .d8= 10, .min=100, .d2=175, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=49, .d1= 3, .surftype= 2, .mass=  99, .lseed=255, .d8=  339, .tseed=0x01c5, .d8=130, .min=130, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=50, .d1= 2, .surftype= 3, .mass=  77, .lseed=150, .d8=  349, .tseed=0x006d, .d8= 25, .min=150, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=51, .d1= 3, .surftype= 2, .mass=  95, .lseed=125, .d8=  359, .tseed=0x0076, .d8= 50, .min=255, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=52, .d1= 4, .surftype= 3, .mass= 370, .lseed=135, .d8=  369, .tseed=0x01c3, .d8=153, .min=200, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=53, .d1= 4, .surftype= 2, .mass= 178, .lseed= 77, .d8=  379, .tseed=0x0033, .d8= 77, .min=200, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=54, .d1= 3, .surftype= 2, .mass= 100, .lseed=190, .d8=  389, .tseed=0x0075, .d8=128, .min=150, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=55, .d1= 2, .surftype= 5, .mass=  65, .lseed=153, .d8=  409, .tseed=0x0073, .d8= 13, .min=180, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=56, .d1= 4, .surftype= 2, .mass= 200, .lseed=204, .d8=  419, .tseed=0x0bb8, .d8= 75, .min=  0, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=57, .d1= 4, .surftype= 3, .mass= 140, .lseed=130, .d8=  429, .tseed=0x00c5, .d8=120, .min=255, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=58, .d1= 3, .surftype= 5, .mass= 108, .lseed=255, .d8=  439, .tseed=0x0057, .d8=100, .min=  0, .d2=255, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=59, .d1= 2, .surftype= 2, .mass=  85, .lseed=255, .d8=  449, .tseed=0x0173, .d8=255, .min=200, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
  {.idx=60, .d1= 4, .surftype= 2, .mass= 790, .lseed=255, .d8=  459, .tseed=0x00de, .d8=180, .min= 50, .d2=  0, .d3=  0, .d4= 0, .d5= 0, .d6= 0, .coldest= 0, .warmest= 0, .atmoactivity= 0, .atmodensity= 0, .d7= 0},
};

char cmap[][0x40]=
{
  {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
  {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
  {0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
  {0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22},
  {0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc},
  {0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
  {0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
  {0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
  {0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa},
  {0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa},
  {0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
  {0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
  {0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
  {0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07},
  {0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07},
};

char *compounds[] =
{
  "NONE",
  "NITROGEN",
  "OXYGEN",
  "METHANE",
  "CARBON MONOXIDE",
  "WATER",
  "AMMONIA COMPOUNDS",
  "CHLORINE COMPOUNDS",
  "METHANOL, ETHANOL",
  "SULFUR COMPOUNDS",
  "SILICON COMPOUNDS",
  "SODIUM COMPOUNDS",
  "FLUORINE COMPOUNDS",
  "METAL COMPOUNDS",
  "HYDROGEN, HELIUM",
  "NITROGEN, OXYGEN",
  "OXYGEN, CARBON DIOXIDE",
  "AMMONIA, HYDROGEN",
  "METHANE, AMMONIA, ARGON",
  "FLUORINE, CHLORINE",
  "METHANE, HYDROGEN CYANIDE",
  "OXYGEN, HYDROGEN",
  "HYDROGEN"
};


PLANET planetseeds[]=
{
{.x=1720, .y= 688, .orbit=  1, .species=  6, .seed=0x10c3},
{.x=1720, .y= 688, .orbit=  2, .species=  7, .seed=0x10b8},
{.x=1720, .y= 688, .orbit=  3, .species= 18, .seed=0x03b8},
{.x=1720, .y= 688, .orbit=  4, .species=  6, .seed=0x10a2},
{.x=1720, .y= 688, .orbit=  5, .species= 17, .seed=0x1097},
{.x=1720, .y= 688, .orbit=  6, .species= 17, .seed=0x108c},
{.x=1720, .y= 688, .orbit=  7, .species= 16, .seed=0x1081},
{.x=1720, .y= 688, .orbit=  8, .species= 16, .seed=0x1076},
{.x=1736, .y= 704, .orbit=  1, .species=  5, .seed=0x1118},
{.x=1736, .y= 704, .orbit=  2, .species= 19, .seed=0x017e},
{.x=1736, .y= 704, .orbit=  3, .species= 17, .seed=0x1102},
{.x=1736, .y= 704, .orbit=  4, .species= 20, .seed=0x0290},
{.x=1736, .y= 704, .orbit=  6, .species= 15, .seed=0x10ec},
{.x=1736, .y= 704, .orbit=  8, .species= 13, .seed=0x10e1},
{.x=1720, .y= 704, .orbit=  3, .species=  6, .seed=0x114c},
{.x=1720, .y= 704, .orbit=  5, .species= 16, .seed=0x1141},
{.x=1720, .y= 704, .orbit=  6, .species= 14, .seed=0x1136},
{.x=1872, .y= 160, .orbit=  3, .species= 10, .seed=0x118b},
{.x=1872, .y= 160, .orbit=  4, .species= 21, .seed=0x000d},
{.x=1872, .y= 160, .orbit=  5, .species= 17, .seed=0x1175},
{.x=1872, .y= 160, .orbit=  8, .species= 13, .seed=0x116a},
{.x=1840, .y= 208, .orbit=  3, .species= 17, .seed=0x11c7},
{.x=1840, .y= 208, .orbit=  6, .species= 16, .seed=0x11bc},
{.x=1832, .y= 176, .orbit=  1, .species=  6, .seed=0x1206},
{.x=1832, .y= 176, .orbit=  2, .species=  9, .seed=0x11fb},
{.x=1832, .y= 176, .orbit=  4, .species= 15, .seed=0x11f0},
{.x=1832, .y= 176, .orbit=  7, .species= 14, .seed=0x11e5},
{.x=1816, .y= 192, .orbit=  3, .species=  2, .seed=0x123a},
{.x=1816, .y= 192, .orbit=  6, .species= 17, .seed=0x122f},
{.x=1816, .y= 192, .orbit=  7, .species= 17, .seed=0x1224},
{.x=1904, .y=1512, .orbit=  1, .species=  1, .seed=0x126e},
{.x=1904, .y=1512, .orbit=  4, .species=  7, .seed=0x1263},
{.x=1904, .y=1512, .orbit=  6, .species= 22, .seed=0x018f},
{.x=1536, .y=1216, .orbit=  5, .species= 23, .seed=0x006e},
{.x=1440, .y= 992, .orbit=  2, .species=  5, .seed=0x12e1},
{.x=1440, .y= 992, .orbit=  3, .species= 24, .seed=0x01d2},
{.x=1440, .y= 992, .orbit=  4, .species= 12, .seed=0x12cb},
{.x=1440, .y= 992, .orbit=  6, .species= 16, .seed=0x12c0},
{.x=1440, .y= 992, .orbit=  7, .species= 13, .seed=0x12b5},
{.x=1440, .y= 992, .orbit=  8, .species= 14, .seed=0x12aa},
{.x=1440, .y= 960, .orbit=  4, .species= 25, .seed=0x00b6},
{.x=1440, .y= 960, .orbit=  5, .species= 15, .seed=0x130a},
{.x=1440, .y= 960, .orbit=  7, .species= 13, .seed=0x12ff},
{.x=1440, .y= 976, .orbit=  3, .species= 14, .seed=0x133e},
{.x=1440, .y= 976, .orbit=  5, .species= 17, .seed=0x1333},
{.x=1032, .y= 264, .orbit=  1, .species=  5, .seed=0x1388},
{.x=1032, .y= 264, .orbit=  2, .species= 26, .seed=0x0007},
{.x=1032, .y= 264, .orbit=  3, .species= 17, .seed=0x1372},
{.x=1032, .y= 264, .orbit=  4, .species= 16, .seed=0x1367},
{.x=1032, .y= 264, .orbit=  5, .species= 16, .seed=0x135c},
{.x= 144, .y= 400, .orbit=  1, .species=  2, .seed=0x13d2},
{.x= 144, .y= 400, .orbit=  3, .species=  3, .seed=0x13c7},
{.x= 144, .y= 400, .orbit=  4, .species=  8, .seed=0x13bc},
{.x= 144, .y= 400, .orbit=  6, .species=  5, .seed=0x13b1},
{.x= 144, .y= 400, .orbit=  8, .species= 27, .seed=0x0003},
{.x= 648, .y= 784, .orbit=  1, .species= 28, .seed=0x00ea},
{.x= 648, .y= 784, .orbit=  7, .species= 14, .seed=0x13f0},
{.x= 896, .y=1600, .orbit=  3, .species= 10, .seed=0x143f},
{.x= 896, .y=1600, .orbit=  4, .species= 17, .seed=0x1434},
{.x= 896, .y=1600, .orbit=  5, .species= 29, .seed=0x000c},
{.x= 896, .y=1600, .orbit=  7, .species= 13, .seed=0x141e},
{.x= 816, .y= 640, .orbit=  3, .species= 17, .seed=0x1486},
{.x= 816, .y= 640, .orbit=  4, .species= 17, .seed=0x147b},
{.x= 816, .y= 640, .orbit=  6, .species= 14, .seed=0x1470},
{.x= 784, .y= 656, .orbit=  2, .species=  7, .seed=0x14d0},
{.x= 784, .y= 656, .orbit=  3, .species= 13, .seed=0x14c5},
{.x= 784, .y= 656, .orbit=  4, .species= 15, .seed=0x14ba},
{.x= 784, .y= 656, .orbit=  6, .species= 16, .seed=0x14af},
{.x= 784, .y= 656, .orbit=  7, .species= 14, .seed=0x14a4},
{.x= 784, .y= 640, .orbit=  1, .species=  2, .seed=0x150f},
{.x= 784, .y= 640, .orbit=  3, .species=  6, .seed=0x1504},
{.x= 784, .y= 640, .orbit=  5, .species=  8, .seed=0x14f9},
{.x= 784, .y= 640, .orbit=  7, .species= 15, .seed=0x14ee},
{.x= 784, .y= 624, .orbit=  2, .species=  5, .seed=0x1543},
{.x= 784, .y= 624, .orbit=  7, .species= 16, .seed=0x1538},
{.x= 784, .y= 624, .orbit=  8, .species= 13, .seed=0x152d},
{.x= 760, .y= 640, .orbit=  4, .species= 17, .seed=0x156c},
{.x= 760, .y= 640, .orbit=  5, .species= 17, .seed=0x1561},
{.x= 688, .y= 440, .orbit=  1, .species=  1, .seed=0x15d7},
{.x= 688, .y= 440, .orbit=  2, .species=  7, .seed=0x15cc},
{.x= 688, .y= 440, .orbit=  3, .species=  5, .seed=0x15c1},
{.x= 688, .y= 440, .orbit=  4, .species= 12, .seed=0x15b6},
{.x= 688, .y= 440, .orbit=  5, .species= 17, .seed=0x15ab},
{.x= 688, .y= 440, .orbit=  6, .species= 13, .seed=0x15a0},
{.x= 688, .y= 440, .orbit=  7, .species= 13, .seed=0x1595},
{.x= 688, .y= 440, .orbit=  8, .species= 13, .seed=0x158a},
{.x= 544, .y= 528, .orbit=  1, .species= 30, .seed=0x00d2},
{.x= 544, .y= 528, .orbit=  2, .species=  7, .seed=0x160b},
{.x= 544, .y= 528, .orbit=  3, .species=  8, .seed=0x1600},
{.x= 544, .y= 528, .orbit=  6, .species= 14, .seed=0x15f5},
{.x=1000, .y= 800, .orbit=  1, .species=  5, .seed=0x1660},
{.x=1000, .y= 800, .orbit=  3, .species= 58, .seed=0x0057},
{.x=1000, .y= 800, .orbit=  5, .species= 31, .seed=0x0168},
{.x=1000, .y= 800, .orbit=  6, .species= 16, .seed=0x163f},
{.x=1000, .y= 800, .orbit=  7, .species= 15, .seed=0x1634},
{.x= 984, .y= 808, .orbit=  1, .species=  6, .seed=0x16c0},
{.x= 984, .y= 808, .orbit=  2, .species= 32, .seed=0x003e},
{.x= 984, .y= 808, .orbit=  3, .species= 17, .seed=0x16aa},
{.x= 984, .y= 808, .orbit=  4, .species= 17, .seed=0x169f},
{.x= 984, .y= 808, .orbit=  6, .species= 15, .seed=0x1694},
{.x= 984, .y= 808, .orbit=  7, .species= 14, .seed=0x1689},
{.x= 984, .y= 808, .orbit=  8, .species= 14, .seed=0x167e},
{.x= 944, .y=1168, .orbit=  2, .species=  6, .seed=0x16ff},
{.x= 944, .y=1168, .orbit=  3, .species= 17, .seed=0x16f4},
{.x= 944, .y=1168, .orbit=  4, .species= 17, .seed=0x16e9},
{.x= 944, .y=1168, .orbit=  5, .species= 33, .seed=0x024e},
{.x=1160, .y= 856, .orbit=  1, .species=  1, .seed=0x1749},
{.x=1160, .y= 856, .orbit=  2, .species=  6, .seed=0x173e},
{.x=1160, .y= 856, .orbit=  3, .species=  5, .seed=0x1733},
{.x=1160, .y= 856, .orbit=  4, .species= 34, .seed=0x03b9},
{.x=1160, .y= 856, .orbit=  6, .species= 16, .seed=0x171d},
{.x=1144, .y= 920, .orbit=  5, .species= 35, .seed=0x21e3},
{.x=1144, .y= 920, .orbit=  7, .species= 15, .seed=0x1767},
{.x=1400, .y= 752, .orbit=  3, .species= 36, .seed=0x00ce},
{.x=1400, .y= 752, .orbit=  6, .species= 14, .seed=0x179b},
{.x=1400, .y= 752, .orbit=  8, .species= 13, .seed=0x1790},
{.x=1184, .y= 504, .orbit=  3, .species=  5, .seed=0x17e5},
{.x=1184, .y= 504, .orbit=  4, .species= 37, .seed=0x033c},
{.x=1184, .y= 504, .orbit=  6, .species= 16, .seed=0x17cf},
{.x=1184, .y= 504, .orbit=  7, .species= 16, .seed=0x17c4},
{.x= 656, .y=1184, .orbit=  6, .species= 11, .seed=0x1813},
{.x= 448, .y=1152, .orbit=  3, .species= 38, .seed=0x009b},
{.x= 448, .y=1152, .orbit=  4, .species= 13, .seed=0x183c},
{.x= 448, .y=1152, .orbit=  5, .species= 16, .seed=0x1831},
{.x= 160, .y=1584, .orbit=  3, .species=  5, .seed=0x1891},
{.x= 160, .y=1584, .orbit=  5, .species= 17, .seed=0x1886},
{.x= 160, .y=1584, .orbit=  6, .species= 17, .seed=0x187b},
{.x= 160, .y=1584, .orbit=  7, .species= 14, .seed=0x1870},
{.x= 160, .y=1584, .orbit=  8, .species= 14, .seed=0x1865},
{.x=1056, .y=1320, .orbit=  1, .species= 39, .seed=0x0042},
{.x=1056, .y=1320, .orbit=  3, .species= 10, .seed=0x18af},
{.x=1200, .y=1184, .orbit=  1, .species= 10, .seed=0x191a},
{.x=1200, .y=1184, .orbit=  3, .species=  7, .seed=0x190f},
{.x=1200, .y=1184, .orbit=  4, .species= 17, .seed=0x1904},
{.x=1200, .y=1184, .orbit=  5, .species= 16, .seed=0x18f9},
{.x=1200, .y=1184, .orbit=  6, .species= 16, .seed=0x18ee},
{.x=1200, .y=1184, .orbit=  7, .species= 14, .seed=0x18e3},
{.x=1200, .y=1184, .orbit=  8, .species= 13, .seed=0x18d8},
{.x= 440, .y= 256, .orbit=  1, .species=  6, .seed=0x1959},
{.x= 440, .y= 256, .orbit=  4, .species= 40, .seed=0x0180},
{.x= 440, .y= 256, .orbit=  6, .species= 15, .seed=0x1943},
{.x= 440, .y= 256, .orbit=  7, .species= 13, .seed=0x1938},
{.x=1312, .y= 672, .orbit=  4, .species= 17, .seed=0x198d},
{.x=1312, .y= 672, .orbit=  5, .species= 17, .seed=0x1982},
{.x=1312, .y= 672, .orbit=  6, .species= 17, .seed=0x1977},
{.x=1312, .y= 680, .orbit=  1, .species=  2, .seed=0x19f8},
{.x=1312, .y= 680, .orbit=  2, .species=  3, .seed=0x19ed},
{.x=1312, .y= 680, .orbit=  3, .species=  4, .seed=0x19e2},
{.x=1312, .y= 680, .orbit=  4, .species=  7, .seed=0x19d7},
{.x=1312, .y= 680, .orbit=  5, .species= 17, .seed=0x19cc},
{.x=1312, .y= 680, .orbit=  6, .species=  8, .seed=0x19c1},
{.x=1312, .y= 680, .orbit=  7, .species= 41, .seed=0x0071},
{.x=1312, .y= 680, .orbit=  8, .species= 42, .seed=0x0009},
{.x=1320, .y= 680, .orbit=  8, .species= 14, .seed=0x1a16},
{.x=1320, .y= 672, .orbit=  1, .species=  1, .seed=0x1a6b},
{.x=1320, .y= 672, .orbit=  2, .species=  1, .seed=0x1a60},
{.x=1320, .y= 672, .orbit=  3, .species=  4, .seed=0x1a55},
{.x=1320, .y= 672, .orbit=  6, .species=  8, .seed=0x1a4a},
{.x=1320, .y= 672, .orbit=  7, .species=  6, .seed=0x1a3f},
{.x=1320, .y= 672, .orbit=  8, .species= 43, .seed=0x00b2},
{.x=1288, .y=1080, .orbit=  1, .species=  2, .seed=0x1a94},
{.x=1288, .y=1080, .orbit=  2, .species=  6, .seed=0x1a89},
{.x=1992, .y=   0, .orbit=  2, .species= 44, .seed=0x0419},
{.x=1192, .y=1064, .orbit=  1, .species= 45, .seed=0x007d},
{.x=1192, .y=1064, .orbit=  2, .species=  7, .seed=0x1afc},
{.x=1192, .y=1064, .orbit=  3, .species= 17, .seed=0x1af1},
{.x=1192, .y=1064, .orbit=  4, .species= 46, .seed=0x005c},
{.x=1192, .y=1064, .orbit=  5, .species= 47, .seed=0x0167},
{.x=1192, .y=1064, .orbit=  6, .species= 15, .seed=0x1ad0},
{.x=1232, .y= 496, .orbit=  2, .species=  5, .seed=0x1b3b},
{.x=1232, .y= 496, .orbit=  4, .species= 16, .seed=0x1b30},
{.x=1232, .y= 496, .orbit=  6, .species= 14, .seed=0x1b25},
{.x= 904, .y= 224, .orbit=  4, .species= 17, .seed=0x1b82},
{.x= 904, .y= 224, .orbit=  5, .species= 13, .seed=0x1b77},
{.x= 904, .y= 224, .orbit=  8, .species= 14, .seed=0x1b6c},
{.x= 968, .y=  32, .orbit=  1, .species=  5, .seed=0x1bcc},
{.x= 968, .y=  32, .orbit=  2, .species=  5, .seed=0x1bc1},
{.x= 968, .y=  32, .orbit=  4, .species= 15, .seed=0x1bb6},
{.x= 968, .y=  32, .orbit=  5, .species= 16, .seed=0x1bab},
{.x= 968, .y=  32, .orbit=  7, .species= 13, .seed=0x1ba0},
{.x=1000, .y= 312, .orbit=  1, .species=  7, .seed=0x1c00},
{.x=1000, .y= 312, .orbit=  7, .species= 16, .seed=0x1bf5},
{.x=1000, .y= 312, .orbit=  8, .species= 16, .seed=0x1bea},
{.x=1008, .y= 576, .orbit=  5, .species= 17, .seed=0x1c29},
{.x=1008, .y= 576, .orbit=  6, .species= 13, .seed=0x1c1e},
{.x=1024, .y= 200, .orbit=  2, .species=  2, .seed=0x1c68},
{.x=1024, .y= 200, .orbit=  3, .species=  3, .seed=0x1c5d},
{.x=1024, .y= 200, .orbit=  4, .species= 16, .seed=0x1c52},
{.x=1024, .y= 200, .orbit=  7, .species= 14, .seed=0x1c47},
{.x=1152, .y= 352, .orbit=  1, .species= 49, .seed=0x01c5},
{.x=1152, .y= 352, .orbit=  3, .species= 17, .seed=0x1cc5},
{.x=1152, .y= 352, .orbit=  4, .species= 14, .seed=0x1cba},
{.x=1152, .y= 352, .orbit=  5, .species= 16, .seed=0x1caf},
{.x=1152, .y= 352, .orbit=  6, .species= 16, .seed=0x1ca4},
{.x=1152, .y= 352, .orbit=  7, .species= 13, .seed=0x1c99},
{.x=1152, .y= 176, .orbit=  5, .species= 11, .seed=0x1cf9},
{.x=1152, .y= 176, .orbit=  6, .species= 15, .seed=0x1cee},
{.x=1208, .y= 544, .orbit=  2, .species=  7, .seed=0x1d2d},
{.x=1208, .y= 544, .orbit=  5, .species= 16, .seed=0x1d22},
{.x=1208, .y= 544, .orbit=  8, .species= 14, .seed=0x1d17},
{.x=1296, .y= 344, .orbit=  4, .species= 17, .seed=0x1d4b},
{.x=1304, .y= 368, .orbit=  1, .species=  1, .seed=0x1d8a},
{.x=1304, .y= 368, .orbit=  3, .species=  6, .seed=0x1d7f},
{.x=1304, .y= 368, .orbit=  6, .species= 53, .seed=0x0033},
{.x=1304, .y= 368, .orbit=  7, .species= 15, .seed=0x1d69},
{.x=1352, .y=  16, .orbit=  3, .species=  7, .seed=0x1db3},
{.x=1352, .y=  16, .orbit=  5, .species= 16, .seed=0x1da8},
{.x=1440, .y=  64, .orbit=  1, .species=  2, .seed=0x1e31},
{.x=1440, .y=  64, .orbit=  2, .species=  6, .seed=0x1e26},
{.x=1440, .y=  64, .orbit=  3, .species= 11, .seed=0x1e1b},
{.x=1440, .y=  64, .orbit=  4, .species= 12, .seed=0x1e10},
{.x=1440, .y=  64, .orbit=  5, .species= 17, .seed=0x1e05},
{.x=1440, .y=  64, .orbit=  6, .species= 17, .seed=0x1dfa},
{.x=1440, .y=  64, .orbit=  7, .species= 16, .seed=0x1def},
{.x=1440, .y=  64, .orbit=  8, .species= 13, .seed=0x1de4},
{.x=1440, .y= 224, .orbit=  3, .species= 17, .seed=0x1e5a},
{.x=1440, .y= 224, .orbit=  6, .species= 13, .seed=0x1e4f},
{.x=1448, .y= 208, .orbit=  7, .species=  8, .seed=0x1e78},
{.x=1504, .y= 592, .orbit=  1, .species=  5, .seed=0x1eac},
{.x=1504, .y= 592, .orbit=  2, .species=  9, .seed=0x1ea1},
{.x=1504, .y= 592, .orbit=  8, .species= 13, .seed=0x1e96},
{.x=1536, .y= 352, .orbit=  3, .species= 17, .seed=0x1ef6},
{.x=1536, .y= 352, .orbit=  4, .species= 17, .seed=0x1eeb},
{.x=1536, .y= 352, .orbit=  5, .species= 17, .seed=0x1ee0},
{.x=1536, .y= 352, .orbit=  6, .species= 17, .seed=0x1ed5},
{.x=1536, .y= 352, .orbit=  8, .species= 15, .seed=0x1eca},
{.x=1552, .y= 312, .orbit=  3, .species= 13, .seed=0x1f2a},
{.x=1552, .y= 312, .orbit=  4, .species= 16, .seed=0x1f1f},
{.x=1552, .y= 312, .orbit=  6, .species= 15, .seed=0x1f14},
{.x=1568, .y= 360, .orbit=  3, .species=  8, .seed=0x1f69},
{.x=1568, .y= 360, .orbit=  4, .species= 16, .seed=0x1f5e},
{.x=1568, .y= 360, .orbit=  7, .species= 16, .seed=0x1f53},
{.x=1568, .y= 360, .orbit=  8, .species= 14, .seed=0x1f48},
{.x=1568, .y= 392, .orbit=  5, .species= 17, .seed=0x1f92},
{.x=1568, .y= 392, .orbit=  6, .species= 14, .seed=0x1f87},
{.x=1416, .y=  88, .orbit=  3, .species= 51, .seed=0x0076},
{.x=1416, .y=  88, .orbit=  6, .species= 16, .seed=0x1fb0},
{.x=1760, .y=  40, .orbit=  2, .species=  6, .seed=0x2021},
{.x=1760, .y=  40, .orbit=  3, .species= 17, .seed=0x2016},
{.x=1760, .y=  40, .orbit=  4, .species= 17, .seed=0x200b},
{.x=1760, .y=  40, .orbit=  6, .species= 14, .seed=0x2000},
{.x=1760, .y=  40, .orbit=  7, .species= 16, .seed=0x1fec},
{.x=1800, .y=  56, .orbit=  7, .species= 15, .seed=0x203f},
{.x=1752, .y= 168, .orbit=  2, .species=  2, .seed=0x2068},
{.x=1752, .y= 168, .orbit=  3, .species=  6, .seed=0x205d},
{.x=1688, .y= 216, .orbit=  2, .species= 10, .seed=0x2086},
{.x=1672, .y= 232, .orbit=  1, .species=  5, .seed=0x20db},
{.x=1672, .y= 232, .orbit=  2, .species=  5, .seed=0x20d0},
{.x=1672, .y= 232, .orbit=  3, .species= 17, .seed=0x20c5},
{.x=1672, .y= 232, .orbit=  5, .species= 16, .seed=0x20ba},
{.x=1672, .y= 232, .orbit=  6, .species= 14, .seed=0x20af},
{.x=1672, .y= 232, .orbit=  7, .species= 16, .seed=0x20a4},
{.x=1864, .y= 288, .orbit=  1, .species=  5, .seed=0x2122},
{.x=1864, .y= 288, .orbit=  5, .species= 17, .seed=0x2117},
{.x=1864, .y= 288, .orbit=  8, .species= 13, .seed=0x210c},
{.x=1568, .y= 568, .orbit=  1, .species=  7, .seed=0x2156},
{.x=1568, .y= 568, .orbit=  2, .species=  6, .seed=0x214b},
{.x=1568, .y= 568, .orbit=  8, .species= 15, .seed=0x2140},
{.x=1840, .y= 536, .orbit=  3, .species=  8, .seed=0x2174},
{.x=1672, .y= 640, .orbit=  1, .species=  6, .seed=0x21e7},
{.x=1672, .y= 640, .orbit=  2, .species= 17, .seed=0x21dc},
{.x=1672, .y= 640, .orbit=  3, .species= 17, .seed=0x21d1},
{.x=1672, .y= 640, .orbit=  4, .species= 11, .seed=0x21c6},
{.x=1672, .y= 640, .orbit=  5, .species= 17, .seed=0x21bb},
{.x=1672, .y= 640, .orbit=  6, .species= 13, .seed=0x21b0},
{.x=1672, .y= 640, .orbit=  7, .species= 13, .seed=0x21a5},
{.x=1976, .y= 648, .orbit=  2, .species=  6, .seed=0x2210},
{.x=1976, .y= 648, .orbit=  7, .species= 14, .seed=0x2205},
{.x=1688, .y= 744, .orbit=  1, .species=  5, .seed=0x2239},
{.x=1688, .y= 744, .orbit=  2, .species=  5, .seed=0x222e},
{.x=1888, .y= 952, .orbit=  1, .species=  1, .seed=0x2278},
{.x=1888, .y= 952, .orbit=  3, .species=  6, .seed=0x226d},
{.x=1888, .y= 952, .orbit=  4, .species= 17, .seed=0x2262},
{.x=1888, .y= 952, .orbit=  6, .species= 17, .seed=0x2257},
{.x=1632, .y=1152, .orbit=  5, .species=  8, .seed=0x2296},
{.x=1648, .y=1160, .orbit=  3, .species= 14, .seed=0x22ca},
{.x=1648, .y=1160, .orbit=  4, .species= 16, .seed=0x22bf},
{.x=1648, .y=1160, .orbit=  8, .species= 15, .seed=0x22b4},
{.x=1680, .y=1128, .orbit=  1, .species=  6, .seed=0x2309},
{.x=1680, .y=1128, .orbit=  2, .species=  5, .seed=0x22fe},
{.x=1680, .y=1128, .orbit=  3, .species=  7, .seed=0x22f3},
{.x=1680, .y=1128, .orbit=  6, .species= 16, .seed=0x22e8},
{.x=1696, .y=1168, .orbit=  2, .species=  3, .seed=0x2353},
{.x=1696, .y=1168, .orbit=  3, .species=  6, .seed=0x2348},
{.x=1696, .y=1168, .orbit=  6, .species= 17, .seed=0x233d},
{.x=1696, .y=1168, .orbit=  7, .species= 14, .seed=0x2332},
{.x=1696, .y=1168, .orbit=  8, .species= 14, .seed=0x2327},
{.x=1728, .y=1144, .orbit=  3, .species= 17, .seed=0x237c},
{.x=1728, .y=1144, .orbit=  6, .species= 15, .seed=0x2371},
{.x=1664, .y=1272, .orbit=  4, .species=  8, .seed=0x23c3},
{.x=1664, .y=1272, .orbit=  6, .species= 17, .seed=0x23b8},
{.x=1664, .y=1272, .orbit=  8, .species= 17, .seed=0x23ad},
{.x=1808, .y=1336, .orbit=  2, .species=  5, .seed=0x2400},
{.x=1808, .y=1336, .orbit=  3, .species=  7, .seed=0x23ec},
{.x=1808, .y=1336, .orbit=  7, .species= 14, .seed=0x23e1},
{.x=1752, .y=1416, .orbit=  2, .species=  9, .seed=0x2455},
{.x=1752, .y=1416, .orbit=  4, .species= 16, .seed=0x244a},
{.x=1752, .y=1416, .orbit=  5, .species= 16, .seed=0x243f},
{.x=1752, .y=1416, .orbit=  6, .species= 16, .seed=0x2434},
{.x=1752, .y=1416, .orbit=  7, .species= 16, .seed=0x2429},
{.x=1752, .y=1416, .orbit=  8, .species= 13, .seed=0x241e},
{.x=1280, .y= 352, .orbit=  3, .species= 17, .seed=0x247e},
{.x=1280, .y= 352, .orbit=  5, .species= 17, .seed=0x2473},
{.x=1768, .y= 872, .orbit=  2, .species=  3, .seed=0x24bd},
{.x=1768, .y= 872, .orbit=  6, .species=  7, .seed=0x24b2},
{.x=1768, .y= 872, .orbit=  7, .species= 17, .seed=0x24a7},
{.x=1768, .y= 872, .orbit=  8, .species= 15, .seed=0x249c},
{.x=1808, .y=1664, .orbit=  2, .species=  6, .seed=0x24fc},
{.x=1808, .y=1664, .orbit=  3, .species= 17, .seed=0x24f1},
{.x=1808, .y=1664, .orbit=  6, .species= 16, .seed=0x24e6},
{.x=1808, .y=1664, .orbit=  7, .species= 13, .seed=0x24db},
{.x=1432, .y=1688, .orbit=  1, .species= 10, .seed=0x254e},
{.x=1432, .y=1688, .orbit=  3, .species= 17, .seed=0x2543},
{.x=1432, .y=1688, .orbit=  4, .species= 16, .seed=0x2538},
{.x=1432, .y=1688, .orbit=  7, .species= 16, .seed=0x252d},
{.x=1408, .y=1616, .orbit=  2, .species=  8, .seed=0x256c},
{.x=1392, .y=1600, .orbit=  1, .species=  5, .seed=0x25d7},
{.x=1392, .y=1600, .orbit=  2, .species=  5, .seed=0x25cc},
{.x=1392, .y=1600, .orbit=  3, .species=  8, .seed=0x25c1},
{.x=1392, .y=1600, .orbit=  4, .species= 12, .seed=0x25b6},
{.x=1392, .y=1600, .orbit=  5, .species= 17, .seed=0x25ab},
{.x=1392, .y=1600, .orbit=  6, .species= 16, .seed=0x25a0},
{.x=1392, .y=1600, .orbit=  7, .species= 13, .seed=0x2595},
{.x=1392, .y=1600, .orbit=  8, .species= 16, .seed=0x258a},
{.x=1472, .y=1600, .orbit=  1, .species=  6, .seed=0x2621},
{.x=1472, .y=1600, .orbit=  3, .species= 14, .seed=0x2616},
{.x=1472, .y=1600, .orbit=  4, .species= 16, .seed=0x260b},
{.x=1472, .y=1600, .orbit=  5, .species= 16, .seed=0x2600},
{.x=1472, .y=1600, .orbit=  7, .species= 13, .seed=0x25f5},
{.x=1432, .y=1560, .orbit=  2, .species=  5, .seed=0x2660},
{.x=1432, .y=1560, .orbit=  4, .species= 17, .seed=0x2655},
{.x=1432, .y=1560, .orbit=  6, .species= 57, .seed=0x00c5},
{.x=1432, .y=1560, .orbit=  8, .species= 14, .seed=0x263f},
{.x=1496, .y=1544, .orbit=  2, .species=  7, .seed=0x267e},
{.x=1592, .y=1448, .orbit=  3, .species=  5, .seed=0x26e3},
{.x=1592, .y=1448, .orbit=  4, .species= 11, .seed=0x26d8},
{.x=1592, .y=1448, .orbit=  5, .species= 17, .seed=0x26cd},
{.x=1592, .y=1448, .orbit=  7, .species= 15, .seed=0x26c2},
{.x=1432, .y=1384, .orbit=  1, .species=  1, .seed=0x2717},
{.x=1432, .y=1384, .orbit=  2, .species=  8, .seed=0x270c},
{.x=1432, .y=1384, .orbit=  4, .species=  6, .seed=0x2701},
{.x=1376, .y=1368, .orbit=  2, .species=  7, .seed=0x2740},
{.x=1376, .y=1368, .orbit=  6, .species= 13, .seed=0x2735},
{.x=1432, .y=1352, .orbit=  1, .species=  6, .seed=0x27a0},
{.x=1432, .y=1352, .orbit=  2, .species=  6, .seed=0x2795},
{.x=1432, .y=1352, .orbit=  3, .species= 10, .seed=0x278a},
{.x=1432, .y=1352, .orbit=  4, .species=  8, .seed=0x277f},
{.x=1432, .y=1352, .orbit=  5, .species= 17, .seed=0x2774},
{.x=1432, .y=1352, .orbit=  6, .species= 16, .seed=0x2769},
{.x=1432, .y=1352, .orbit=  8, .species= 13, .seed=0x275e},
{.x=1456, .y=1360, .orbit=  2, .species=  5, .seed=0x27df},
{.x=1456, .y=1360, .orbit=  3, .species=  5, .seed=0x27d4},
{.x=1456, .y=1360, .orbit=  5, .species= 13, .seed=0x27c9},
{.x=1456, .y=1360, .orbit=  6, .species= 13, .seed=0x27be},
{.x=1160, .y=1648, .orbit=  4, .species= 17, .seed=0x280b},
{.x=1160, .y=1648, .orbit=  8, .species= 15, .seed=0x2800},
{.x=1032, .y=1712, .orbit=  6, .species= 16, .seed=0x2829},
{.x=1016, .y=1704, .orbit=  2, .species=  6, .seed=0x2873},
{.x=1016, .y=1704, .orbit=  3, .species= 17, .seed=0x2868},
{.x=1016, .y=1704, .orbit=  4, .species= 17, .seed=0x285d},
{.x=1016, .y=1704, .orbit=  5, .species= 17, .seed=0x2852},
{.x=1016, .y=1704, .orbit=  6, .species= 14, .seed=0x2847},
{.x=1000, .y=1512, .orbit=  2, .species=  7, .seed=0x28a7},
{.x=1000, .y=1512, .orbit=  4, .species=  9, .seed=0x289c},
{.x=1000, .y=1512, .orbit=  8, .species= 16, .seed=0x2891},
{.x=1024, .y=1496, .orbit=  1, .species= 11, .seed=0x28d0},
{.x=1024, .y=1496, .orbit=  8, .species= 13, .seed=0x28c5},
{.x=1024, .y=1464, .orbit=  2, .species= 17, .seed=0x2904},
{.x=1024, .y=1464, .orbit=  4, .species=  6, .seed=0x28f9},
{.x=1024, .y=1464, .orbit=  6, .species= 14, .seed=0x28ee},
{.x=1144, .y=1400, .orbit=  4, .species=  7, .seed=0x294b},
{.x=1144, .y=1400, .orbit=  5, .species= 15, .seed=0x2940},
{.x=1144, .y=1400, .orbit=  8, .species= 14, .seed=0x2935},
{.x=1192, .y=1384, .orbit=  2, .species=  6, .seed=0x2974},
{.x=1192, .y=1384, .orbit=  4, .species=  6, .seed=0x2969},
{.x=1208, .y=1384, .orbit=  1, .species=  5, .seed=0x29c9},
{.x=1208, .y=1384, .orbit=  2, .species=  5, .seed=0x29be},
{.x=1208, .y=1384, .orbit=  4, .species= 10, .seed=0x29b3},
{.x=1208, .y=1384, .orbit=  5, .species= 17, .seed=0x29a8},
{.x=1208, .y=1384, .orbit=  6, .species= 13, .seed=0x299d},
{.x=1208, .y=1384, .orbit=  7, .species= 13, .seed=0x2992},
{.x=1160, .y=1344, .orbit=  3, .species= 15, .seed=0x29e7},
{.x=1088, .y=1336, .orbit=  3, .species= 17, .seed=0x2a26},
{.x=1088, .y=1336, .orbit=  4, .species= 17, .seed=0x2a1b},
{.x=1088, .y=1336, .orbit=  6, .species= 16, .seed=0x2a10},
{.x=1088, .y=1336, .orbit=  8, .species= 14, .seed=0x2a05},
{.x= 952, .y=1296, .orbit=  5, .species=  8, .seed=0x2a4f},
{.x= 952, .y=1296, .orbit=  7, .species= 17, .seed=0x2a44},
{.x= 968, .y=1264, .orbit=  1, .species=  6, .seed=0x2a99},
{.x= 968, .y=1264, .orbit=  2, .species=  5, .seed=0x2a8e},
{.x= 968, .y=1264, .orbit=  3, .species=  5, .seed=0x2a83},
{.x= 968, .y=1264, .orbit=  5, .species= 15, .seed=0x2a78},
{.x= 968, .y=1264, .orbit=  6, .species= 15, .seed=0x2a6d},
{.x=1088, .y=1264, .orbit=  5, .species=  7, .seed=0x2ab7},
{.x=1096, .y=1248, .orbit=  2, .species=  7, .seed=0x2b01},
{.x=1096, .y=1248, .orbit=  3, .species=  5, .seed=0x2af6},
{.x=1096, .y=1248, .orbit=  4, .species= 12, .seed=0x2aeb},
{.x=1096, .y=1248, .orbit=  6, .species= 16, .seed=0x2ae0},
{.x=1096, .y=1248, .orbit=  8, .species= 16, .seed=0x2ad5},
{.x=1096, .y=1224, .orbit=  4, .species= 13, .seed=0x2b35},
{.x=1096, .y=1224, .orbit=  6, .species= 16, .seed=0x2b2a},
{.x=1096, .y=1224, .orbit=  7, .species= 13, .seed=0x2b1f},
{.x=1328, .y=1272, .orbit=  2, .species=  7, .seed=0x2b5e},
{.x=1328, .y=1272, .orbit=  5, .species= 11, .seed=0x2b53},
{.x=1296, .y=1248, .orbit=  1, .species=  6, .seed=0x2bb0},
{.x=1296, .y=1248, .orbit=  2, .species=  7, .seed=0x2ba5},
{.x=1296, .y=1248, .orbit=  4, .species= 17, .seed=0x2b9a},
{.x=1296, .y=1248, .orbit=  6, .species= 14, .seed=0x2b8f},
{.x=1344, .y=1184, .orbit=  2, .species=  5, .seed=0x2be4},
{.x=1344, .y=1184, .orbit=  4, .species=  8, .seed=0x2bd9},
{.x=1344, .y=1184, .orbit=  5, .species= 15, .seed=0x2bce},
{.x=1504, .y=1184, .orbit=  7, .species= 13, .seed=0x2c13},
{.x=1048, .y=1168, .orbit=  2, .species=  6, .seed=0x2c5d},
{.x=1048, .y=1168, .orbit=  3, .species= 17, .seed=0x2c52},
{.x=1048, .y=1168, .orbit=  6, .species= 15, .seed=0x2c47},
{.x=1048, .y=1168, .orbit=  7, .species= 16, .seed=0x2c3c},
{.x=1048, .y=1168, .orbit=  8, .species= 14, .seed=0x2c31},
{.x=1200, .y=1104, .orbit=  3, .species=  8, .seed=0x2c86},
{.x=1200, .y=1104, .orbit=  5, .species= 16, .seed=0x2c7b},
{.x=1280, .y= 384, .orbit=  1, .species=  5, .seed=0x2cdb},
{.x=1280, .y= 384, .orbit=  3, .species= 10, .seed=0x2cd0},
{.x=1280, .y= 384, .orbit=  4, .species= 12, .seed=0x2cc5},
{.x=1280, .y= 384, .orbit=  6, .species= 14, .seed=0x2cba},
{.x=1280, .y= 384, .orbit=  7, .species= 13, .seed=0x2caf},
{.x=1280, .y= 384, .orbit=  8, .species= 13, .seed=0x2ca4},
{.x= 912, .y=1104, .orbit=  1, .species=  2, .seed=0x2d2d},
{.x= 912, .y=1104, .orbit=  3, .species=  5, .seed=0x2d22},
{.x= 912, .y=1104, .orbit=  4, .species= 17, .seed=0x2d17},
{.x= 912, .y=1104, .orbit=  7, .species= 15, .seed=0x2d0c},
{.x=1024, .y= 992, .orbit=  1, .species=  5, .seed=0x2d61},
{.x=1024, .y= 992, .orbit=  2, .species= 11, .seed=0x2d56},
{.x=1024, .y= 992, .orbit=  3, .species=  5, .seed=0x2d4b},
{.x=1032, .y= 984, .orbit=  2, .species=  7, .seed=0x2d8a},
{.x=1032, .y= 984, .orbit=  5, .species= 17, .seed=0x2d7f},
{.x=1328, .y= 968, .orbit=  5, .species=  8, .seed=0x2da8},
{.x=1304, .y= 952, .orbit=  2, .species=  5, .seed=0x2e08},
{.x=1304, .y= 952, .orbit=  3, .species= 17, .seed=0x2dfd},
{.x=1304, .y= 952, .orbit=  4, .species= 48, .seed=0x006b},
{.x=1304, .y= 952, .orbit=  5, .species= 17, .seed=0x2de7},
{.x=1304, .y= 952, .orbit=  6, .species= 13, .seed=0x2ddc},
{.x=1304, .y= 952, .orbit=  7, .species= 16, .seed=0x2dd1},
{.x=1304, .y= 952, .orbit=  8, .species= 13, .seed=0x2dc6},
{.x=1384, .y= 944, .orbit=  2, .species= 17, .seed=0x2e31},
{.x=1384, .y= 944, .orbit=  3, .species= 17, .seed=0x2e26},
{.x=1208, .y= 952, .orbit=  1, .species=  2, .seed=0x2e7b},
{.x=1208, .y= 952, .orbit=  2, .species=  2, .seed=0x2e70},
{.x=1208, .y= 952, .orbit=  3, .species=  7, .seed=0x2e65},
{.x=1208, .y= 952, .orbit=  5, .species= 17, .seed=0x2e5a},
{.x=1208, .y= 952, .orbit=  7, .species= 17, .seed=0x2e4f},
{.x=1048, .y= 928, .orbit=  4, .species=  5, .seed=0x2ea4},
{.x=1048, .y= 928, .orbit=  6, .species= 15, .seed=0x2e99},
{.x=1400, .y= 896, .orbit=  3, .species= 17, .seed=0x2ec2},
{.x= 984, .y= 856, .orbit=  2, .species=  3, .seed=0x2f1f},
{.x= 984, .y= 856, .orbit=  4, .species=  4, .seed=0x2f14},
{.x= 984, .y= 856, .orbit=  5, .species=  8, .seed=0x2f09},
{.x= 984, .y= 856, .orbit=  7, .species=  6, .seed=0x2efe},
{.x= 984, .y= 856, .orbit=  8, .species= 10, .seed=0x2ef3},
{.x=1256, .y= 784, .orbit=  1, .species=  5, .seed=0x2f5e},
{.x=1256, .y= 784, .orbit=  3, .species= 17, .seed=0x2f53},
{.x=1256, .y= 784, .orbit=  4, .species= 15, .seed=0x2f48},
{.x=1256, .y= 784, .orbit=  6, .species= 16, .seed=0x2f3d},
{.x=1264, .y= 760, .orbit=  1, .species=  5, .seed=0x2fbe},
{.x=1264, .y= 760, .orbit=  2, .species=  5, .seed=0x2fb3},
{.x=1264, .y= 760, .orbit=  3, .species= 12, .seed=0x2fa8},
{.x=1264, .y= 760, .orbit=  4, .species= 17, .seed=0x2f9d},
{.x=1264, .y= 760, .orbit=  5, .species= 16, .seed=0x2f92},
{.x=1264, .y= 760, .orbit=  6, .species= 14, .seed=0x2f87},
{.x=1264, .y= 760, .orbit=  8, .species= 14, .seed=0x2f7c},
{.x=1248, .y= 752, .orbit=  2, .species=  1, .seed=0x2fe7},
{.x=1248, .y= 752, .orbit=  7, .species=  7, .seed=0x2fdc},
{.x=1256, .y= 728, .orbit=  5, .species= 16, .seed=0x3013},
{.x=1144, .y= 656, .orbit=  2, .species=  7, .seed=0x3052},
{.x=1144, .y= 656, .orbit=  3, .species=  7, .seed=0x3047},
{.x=1144, .y= 656, .orbit=  4, .species=  9, .seed=0x303c},
{.x=1144, .y= 656, .orbit=  5, .species=  7, .seed=0x3031},
{.x=1160, .y= 648, .orbit=  1, .species=  1, .seed=0x309c},
{.x=1160, .y= 648, .orbit=  2, .species=  6, .seed=0x3091},
{.x=1160, .y= 648, .orbit=  4, .species= 17, .seed=0x3086},
{.x=1160, .y= 648, .orbit=  7, .species= 17, .seed=0x307b},
{.x=1160, .y= 648, .orbit=  8, .species= 15, .seed=0x3070},
{.x=1152, .y= 640, .orbit=  2, .species=  3, .seed=0x30c5},
{.x=1152, .y= 640, .orbit=  7, .species= 17, .seed=0x30ba},
{.x= 936, .y= 912, .orbit=  2, .species=  6, .seed=0x310c},
{.x= 936, .y= 912, .orbit=  3, .species= 17, .seed=0x3101},
{.x= 936, .y= 912, .orbit=  6, .species= 14, .seed=0x30f6},
{.x= 944, .y=1408, .orbit=  1, .species=  3, .seed=0x3177},
{.x= 944, .y=1408, .orbit=  2, .species=  2, .seed=0x316c},
{.x= 944, .y=1408, .orbit=  3, .species=  6, .seed=0x3161},
{.x= 944, .y=1408, .orbit=  4, .species= 17, .seed=0x3156},
{.x= 944, .y=1408, .orbit=  5, .species= 12, .seed=0x314b},
{.x= 944, .y=1408, .orbit=  6, .species= 11, .seed=0x3140},
{.x= 944, .y=1408, .orbit=  7, .species= 17, .seed=0x3135},
{.x= 944, .y=1408, .orbit=  8, .species= 14, .seed=0x312a},
{.x= 744, .y=1656, .orbit=  2, .species=  6, .seed=0x31b6},
{.x= 744, .y=1656, .orbit=  4, .species= 17, .seed=0x31ab},
{.x= 744, .y=1656, .orbit=  5, .species= 17, .seed=0x31a0},
{.x= 744, .y=1656, .orbit=  7, .species= 13, .seed=0x3195},
{.x= 696, .y=1632, .orbit=  3, .species= 12, .seed=0x31df},
{.x= 696, .y=1632, .orbit=  4, .species= 12, .seed=0x31d4},
{.x= 560, .y=1664, .orbit=  1, .species=  5, .seed=0x3234},
{.x= 560, .y=1664, .orbit=  2, .species= 17, .seed=0x3229},
{.x= 560, .y=1664, .orbit=  3, .species= 17, .seed=0x321e},
{.x= 560, .y=1664, .orbit=  5, .species= 17, .seed=0x3213},
{.x= 560, .y=1664, .orbit=  6, .species= 14, .seed=0x3208},
{.x= 560, .y=1664, .orbit=  7, .species= 14, .seed=0x31fd},
{.x= 544, .y=1688, .orbit=  1, .species=  6, .seed=0x3273},
{.x= 544, .y=1688, .orbit=  2, .species=  6, .seed=0x3268},
{.x= 544, .y=1688, .orbit=  4, .species= 15, .seed=0x325d},
{.x= 544, .y=1688, .orbit=  6, .species= 16, .seed=0x3252},
{.x= 536, .y=1664, .orbit=  4, .species=  6, .seed=0x329c},
{.x= 536, .y=1664, .orbit=  6, .species= 17, .seed=0x3291},
{.x= 520, .y=1616, .orbit=  3, .species= 15, .seed=0x32f9},
{.x= 520, .y=1616, .orbit=  4, .species= 16, .seed=0x32ee},
{.x= 520, .y=1616, .orbit=  5, .species= 16, .seed=0x32e3},
{.x= 520, .y=1616, .orbit=  7, .species= 16, .seed=0x32d8},
{.x= 520, .y=1616, .orbit=  8, .species= 14, .seed=0x32cd},
{.x= 448, .y=1616, .orbit=  1, .species=  1, .seed=0x3338},
{.x= 448, .y=1616, .orbit=  2, .species=  5, .seed=0x332d},
{.x= 448, .y=1616, .orbit=  7, .species= 15, .seed=0x3322},
{.x= 448, .y=1616, .orbit=  8, .species= 13, .seed=0x3317},
{.x= 136, .y=1704, .orbit=  2, .species=  9, .seed=0x338d},
{.x= 136, .y=1704, .orbit=  3, .species= 60, .seed=0x00de},
{.x= 136, .y=1704, .orbit=  4, .species= 12, .seed=0x3377},
{.x= 136, .y=1704, .orbit=  6, .species= 16, .seed=0x336c},
{.x= 136, .y=1704, .orbit=  7, .species= 13, .seed=0x3361},
{.x= 136, .y=1704, .orbit=  8, .species= 13, .seed=0x3356},
{.x= 120, .y=1712, .orbit=  5, .species= 13, .seed=0x33ab},
{.x=  16, .y=1648, .orbit=  3, .species= 17, .seed=0x33c9},
{.x= 104, .y=1576, .orbit=  2, .species= 10, .seed=0x340b},
{.x= 104, .y=1576, .orbit=  4, .species= 16, .seed=0x3400},
{.x= 104, .y=1576, .orbit=  5, .species= 14, .seed=0x33f2},
{.x= 104, .y=1576, .orbit=  7, .species= 16, .seed=0x33e7},
{.x= 824, .y=1480, .orbit=  1, .species=  2, .seed=0x343f},
{.x= 824, .y=1480, .orbit=  6, .species= 17, .seed=0x3434},
{.x= 824, .y=1480, .orbit=  7, .species= 11, .seed=0x3429},
{.x= 536, .y=1472, .orbit=  3, .species=  8, .seed=0x3473},
{.x= 536, .y=1472, .orbit=  4, .species= 17, .seed=0x3468},
{.x= 536, .y=1472, .orbit=  5, .species= 14, .seed=0x345d},
{.x= 840, .y=1320, .orbit=  1, .species=  2, .seed=0x34db},
{.x= 840, .y=1320, .orbit=  2, .species=  7, .seed=0x34d0},
{.x= 840, .y=1320, .orbit=  4, .species= 17, .seed=0x34c5},
{.x= 840, .y=1320, .orbit=  5, .species= 56, .seed=0x0bb8},
{.x= 840, .y=1320, .orbit=  6, .species= 17, .seed=0x34af},
{.x= 840, .y=1320, .orbit=  7, .species= 13, .seed=0x34a4},
{.x= 680, .y=1344, .orbit=  2, .species=  6, .seed=0x350f},
{.x= 680, .y=1344, .orbit=  4, .species= 16, .seed=0x3504},
{.x= 680, .y=1344, .orbit=  6, .species= 16, .seed=0x34f9},
{.x= 664, .y=1352, .orbit=  6, .species= 15, .seed=0x3538},
{.x= 664, .y=1352, .orbit=  7, .species= 13, .seed=0x352d},
{.x= 552, .y=1304, .orbit=  3, .species=  7, .seed=0x3561},
{.x= 552, .y=1304, .orbit=  5, .species= 14, .seed=0x3556},
{.x= 280, .y=1384, .orbit=  5, .species= 11, .seed=0x357f},
{.x= 256, .y=1376, .orbit=  1, .species= 10, .seed=0x35d4},
{.x= 256, .y=1376, .orbit=  2, .species= 10, .seed=0x35c9},
{.x= 256, .y=1376, .orbit=  3, .species= 17, .seed=0x35be},
{.x= 256, .y=1376, .orbit=  4, .species= 16, .seed=0x35b3},
{.x= 256, .y=1376, .orbit=  5, .species= 16, .seed=0x35a8},
{.x= 256, .y=1376, .orbit=  6, .species= 15, .seed=0x359d},
{.x= 216, .y=1376, .orbit=  1, .species=  6, .seed=0x35f2},
{.x= 208, .y=1384, .orbit=  2, .species=  7, .seed=0x3631},
{.x= 208, .y=1384, .orbit=  4, .species=  8, .seed=0x3626},
{.x= 208, .y=1384, .orbit=  5, .species=  8, .seed=0x361b},
{.x= 208, .y=1384, .orbit=  7, .species= 15, .seed=0x3610},
{.x= 728, .y=1112, .orbit=  5, .species= 16, .seed=0x366d},
{.x= 728, .y=1112, .orbit=  7, .species= 14, .seed=0x3662},
{.x= 128, .y=1304, .orbit=  3, .species=  5, .seed=0x36ac},
{.x= 128, .y=1304, .orbit=  4, .species=  5, .seed=0x36a1},
{.x= 128, .y=1304, .orbit=  5, .species=  9, .seed=0x3696},
{.x= 128, .y=1304, .orbit=  6, .species= 17, .seed=0x368b},
{.x= 168, .y=1240, .orbit=  2, .species=  6, .seed=0x36e0},
{.x= 168, .y=1240, .orbit=  3, .species= 17, .seed=0x36d5},
{.x= 168, .y=1240, .orbit=  8, .species= 14, .seed=0x36ca},
{.x= 184, .y=1216, .orbit=  4, .species= 10, .seed=0x3709},
{.x= 184, .y=1216, .orbit=  7, .species= 14, .seed=0x36fe},
{.x= 136, .y=1200, .orbit=  3, .species= 17, .seed=0x3766},
{.x= 136, .y=1200, .orbit=  4, .species= 17, .seed=0x375b},
{.x= 136, .y=1200, .orbit=  5, .species= 17, .seed=0x3750},
{.x= 136, .y=1200, .orbit=  6, .species= 17, .seed=0x3745},
{.x= 136, .y=1200, .orbit=  7, .species= 17, .seed=0x373a},
{.x= 344, .y=1208, .orbit=  2, .species=  7, .seed=0x379a},
{.x= 344, .y=1208, .orbit=  6, .species= 15, .seed=0x378f},
{.x= 344, .y=1208, .orbit=  8, .species= 15, .seed=0x3784},
{.x= 360, .y=1208, .orbit=  1, .species=  5, .seed=0x37ef},
{.x= 360, .y=1208, .orbit=  2, .species= 55, .seed=0x0073},
{.x= 360, .y=1208, .orbit=  4, .species= 17, .seed=0x37d9},
{.x= 360, .y=1208, .orbit=  5, .species= 15, .seed=0x37ce},
{.x= 360, .y=1208, .orbit=  6, .species= 16, .seed=0x37c3},
{.x= 360, .y=1208, .orbit=  8, .species= 13, .seed=0x37b8},
{.x= 352, .y=1200, .orbit=  2, .species=  6, .seed=0x3813},
{.x= 368, .y=1184, .orbit=  3, .species= 17, .seed=0x3865},
{.x= 368, .y=1184, .orbit=  4, .species= 17, .seed=0x385a},
{.x= 368, .y=1184, .orbit=  6, .species= 17, .seed=0x384f},
{.x= 368, .y=1184, .orbit=  8, .species= 14, .seed=0x3844},
{.x= 608, .y=1064, .orbit=  3, .species=  3, .seed=0x388e},
{.x= 608, .y=1064, .orbit=  7, .species= 11, .seed=0x3883},
{.x= 608, .y=1048, .orbit=  2, .species=  1, .seed=0x38c2},
{.x= 608, .y=1048, .orbit=  3, .species=  1, .seed=0x38b7},
{.x= 608, .y=1048, .orbit=  5, .species=  8, .seed=0x38ac},
{.x= 752, .y= 944, .orbit=  3, .species=  6, .seed=0x391f},
{.x= 752, .y= 944, .orbit=  4, .species=  6, .seed=0x3914},
{.x= 752, .y= 944, .orbit=  5, .species=  8, .seed=0x3909},
{.x= 752, .y= 944, .orbit=  7, .species= 16, .seed=0x38fe},
{.x= 752, .y= 944, .orbit=  8, .species= 14, .seed=0x38f3},
{.x= 728, .y= 936, .orbit=  3, .species=  6, .seed=0x3953},
{.x= 728, .y= 936, .orbit=  4, .species= 17, .seed=0x3948},
{.x= 728, .y= 936, .orbit=  5, .species= 12, .seed=0x393d},
{.x= 704, .y= 960, .orbit=  2, .species=  5, .seed=0x397c},
{.x= 704, .y= 960, .orbit=  4, .species= 17, .seed=0x3971},
{.x= 624, .y= 984, .orbit=  3, .species= 50, .seed=0x006d},
{.x= 624, .y= 984, .orbit=  5, .species= 15, .seed=0x39a5},
{.x= 624, .y= 984, .orbit=  6, .species= 13, .seed=0x399a},
{.x= 464, .y= 992, .orbit=  2, .species=  6, .seed=0x3a18},
{.x= 464, .y= 992, .orbit=  3, .species=  6, .seed=0x3a0d},
{.x= 464, .y= 992, .orbit=  4, .species=  8, .seed=0x3a02},
{.x= 464, .y= 992, .orbit=  5, .species= 12, .seed=0x39f7},
{.x= 464, .y= 992, .orbit=  6, .species= 17, .seed=0x39ec},
{.x= 464, .y= 992, .orbit=  7, .species= 14, .seed=0x39e1},
{.x= 448, .y= 992, .orbit=  2, .species=  1, .seed=0x3a57},
{.x= 448, .y= 992, .orbit=  4, .species=  4, .seed=0x3a4c},
{.x= 448, .y= 992, .orbit=  7, .species= 17, .seed=0x3a41},
{.x= 448, .y= 992, .orbit=  8, .species= 17, .seed=0x3a36},
{.x= 456, .y= 968, .orbit=  6, .species= 10, .seed=0x3a75},
{.x= 336, .y=1008, .orbit=  2, .species=  5, .seed=0x3a9e},
{.x= 336, .y=1008, .orbit=  5, .species= 16, .seed=0x3a93},
{.x=  56, .y= 944, .orbit=  2, .species=  2, .seed=0x3b11},
{.x=  56, .y= 944, .orbit=  3, .species=  3, .seed=0x3b06},
{.x=  56, .y= 944, .orbit=  4, .species=  8, .seed=0x3afb},
{.x=  56, .y= 944, .orbit=  5, .species= 17, .seed=0x3af0},
{.x=  56, .y= 944, .orbit=  6, .species= 17, .seed=0x3ae5},
{.x=  56, .y= 944, .orbit=  7, .species= 59, .seed=0x0173},
{.x=  56, .y= 944, .orbit=  8, .species= 17, .seed=0x3acf},
{.x=  56, .y= 912, .orbit=  2, .species=  6, .seed=0x3b45},
{.x=  56, .y= 912, .orbit=  3, .species=  6, .seed=0x3b3a},
{.x=  56, .y= 912, .orbit=  4, .species=  5, .seed=0x3b2f},
{.x= 104, .y= 920, .orbit=  5, .species= 17, .seed=0x3b6e},
{.x= 104, .y= 920, .orbit=  6, .species= 17, .seed=0x3b63},
{.x= 128, .y= 896, .orbit=  4, .species=  8, .seed=0x3b97},
{.x= 128, .y= 896, .orbit=  6, .species= 17, .seed=0x3b8c},
{.x= 136, .y= 864, .orbit=  3, .species=  6, .seed=0x3bd6},
{.x= 136, .y= 864, .orbit=  4, .species=  6, .seed=0x3bcb},
{.x= 136, .y= 864, .orbit=  7, .species= 13, .seed=0x3bc0},
{.x= 136, .y= 864, .orbit=  8, .species= 13, .seed=0x3bb5},
{.x=  88, .y= 896, .orbit=  1, .species=  2, .seed=0x3c21},
{.x=  88, .y= 896, .orbit=  2, .species=  2, .seed=0x3c16},
{.x=  88, .y= 896, .orbit=  4, .species=  7, .seed=0x3c0b},
{.x=  88, .y= 896, .orbit=  5, .species=  8, .seed=0x3c00},
{.x=  88, .y= 896, .orbit=  6, .species= 12, .seed=0x3bf4},
{.x=  96, .y= 896, .orbit=  2, .species=  3, .seed=0x3c55},
{.x=  96, .y= 896, .orbit=  7, .species=  5, .seed=0x3c4a},
{.x=  96, .y= 896, .orbit=  8, .species= 11, .seed=0x3c3f},
{.x= 760, .y= 824, .orbit=  3, .species= 17, .seed=0x3c86},
{.x= 560, .y= 816, .orbit=  2, .species=  7, .seed=0x3cd8},
{.x= 560, .y= 816, .orbit=  4, .species=  9, .seed=0x3ccd},
{.x= 560, .y= 816, .orbit=  5, .species=  9, .seed=0x3cc2},
{.x= 560, .y= 816, .orbit=  6, .species= 17, .seed=0x3cb7},
{.x= 504, .y= 816, .orbit=  4, .species=  8, .seed=0x3d22},
{.x= 504, .y= 816, .orbit=  5, .species= 12, .seed=0x3d17},
{.x= 504, .y= 816, .orbit=  6, .species= 17, .seed=0x3d0c},
{.x= 504, .y= 816, .orbit=  7, .species= 16, .seed=0x3d01},
{.x= 504, .y= 816, .orbit=  8, .species= 15, .seed=0x3cf6},
{.x= 520, .y= 792, .orbit=  1, .species=  1, .seed=0x3d4b},
{.x= 520, .y= 792, .orbit=  6, .species= 13, .seed=0x3d40},
{.x= 528, .y= 816, .orbit=  2, .species=  6, .seed=0x3d8a},
{.x= 528, .y= 816, .orbit=  4, .species= 10, .seed=0x3d7f},
{.x= 528, .y= 816, .orbit=  5, .species= 16, .seed=0x3d74},
{.x= 528, .y= 816, .orbit=  8, .species= 16, .seed=0x3d69},
{.x= 328, .y= 824, .orbit=  5, .species= 16, .seed=0x3da8},
{.x= 184, .y= 784, .orbit=  3, .species=  3, .seed=0x3ddc},
{.x= 184, .y= 784, .orbit=  7, .species= 17, .seed=0x3dd1},
{.x= 184, .y= 784, .orbit=  8, .species= 17, .seed=0x3dc6},
{.x= 192, .y= 760, .orbit=  1, .species= 10, .seed=0x3e47},
{.x= 192, .y= 760, .orbit=  2, .species= 11, .seed=0x3e3c},
{.x= 192, .y= 760, .orbit=  3, .species= 13, .seed=0x3e31},
{.x= 192, .y= 760, .orbit=  4, .species= 16, .seed=0x3e26},
{.x= 192, .y= 760, .orbit=  5, .species= 13, .seed=0x3e1b},
{.x= 192, .y= 760, .orbit=  6, .species= 16, .seed=0x3e10},
{.x= 192, .y= 760, .orbit=  7, .species= 16, .seed=0x3e05},
{.x= 192, .y= 760, .orbit=  8, .species= 14, .seed=0x3dfa},
{.x=  80, .y= 704, .orbit=  1, .species=  7, .seed=0x3e70},
{.x=  80, .y= 704, .orbit=  3, .species=  7, .seed=0x3e65},
{.x= 728, .y= 688, .orbit=  1, .species=  2, .seed=0x3ecd},
{.x= 728, .y= 688, .orbit=  2, .species=  5, .seed=0x3ec2},
{.x= 728, .y= 688, .orbit=  3, .species=  6, .seed=0x3eb7},
{.x= 728, .y= 688, .orbit=  4, .species=  6, .seed=0x3eac},
{.x= 728, .y= 688, .orbit=  7, .species= 13, .seed=0x3ea1},
{.x= 704, .y= 688, .orbit=  3, .species= 17, .seed=0x3f01},
{.x= 704, .y= 688, .orbit=  5, .species= 16, .seed=0x3ef6},
{.x= 704, .y= 688, .orbit=  7, .species= 14, .seed=0x3eeb},
{.x= 688, .y= 640, .orbit=  5, .species= 10, .seed=0x3f1f},
{.x= 704, .y= 624, .orbit=  2, .species=  6, .seed=0x3f5e},
{.x= 704, .y= 624, .orbit=  3, .species= 17, .seed=0x3f53},
{.x= 704, .y= 624, .orbit=  4, .species= 17, .seed=0x3f48},
{.x= 704, .y= 624, .orbit=  5, .species= 17, .seed=0x3f3d},
{.x= 696, .y= 616, .orbit=  5, .species= 17, .seed=0x3f87},
{.x= 696, .y= 616, .orbit=  6, .species= 16, .seed=0x3f7c},
{.x= 272, .y= 664, .orbit=  3, .species=  5, .seed=0x3fbb},
{.x= 272, .y= 664, .orbit=  6, .species= 14, .seed=0x3fb0},
{.x= 272, .y= 664, .orbit=  8, .species= 13, .seed=0x3fa5},
{.x= 208, .y= 656, .orbit=  1, .species=  3, .seed=0x402c},
{.x= 208, .y= 656, .orbit=  2, .species=  4, .seed=0x4021},
{.x= 208, .y= 656, .orbit=  3, .species=  8, .seed=0x4016},
{.x= 208, .y= 656, .orbit=  5, .species=  8, .seed=0x400b},
{.x= 208, .y= 656, .orbit=  6, .species= 11, .seed=0x4000},
{.x= 208, .y= 656, .orbit=  7, .species= 17, .seed=0x3fec},
{.x= 832, .y= 568, .orbit=  1, .species=  6, .seed=0x406b},
{.x= 832, .y= 568, .orbit=  3, .species= 13, .seed=0x4060},
{.x= 832, .y= 568, .orbit=  4, .species= 15, .seed=0x4055},
{.x= 832, .y= 568, .orbit=  7, .species= 16, .seed=0x404a},
{.x= 720, .y= 552, .orbit=  2, .species=  7, .seed=0x4094},
{.x= 720, .y= 552, .orbit=  6, .species= 13, .seed=0x4089},
{.x= 664, .y= 536, .orbit=  2, .species= 17, .seed=0x40de},
{.x= 664, .y= 536, .orbit=  3, .species= 17, .seed=0x40d3},
{.x= 664, .y= 536, .orbit=  4, .species=  5, .seed=0x40c8},
{.x= 664, .y= 536, .orbit=  6, .species= 17, .seed=0x40bd},
{.x= 664, .y= 536, .orbit=  7, .species= 14, .seed=0x40b2},
{.x= 616, .y= 432, .orbit=  3, .species= 15, .seed=0x40fc},
{.x= 688, .y= 336, .orbit=  7, .species= 14, .seed=0x411a},
{.x= 696, .y= 320, .orbit=  2, .species=  5, .seed=0x4159},
{.x= 696, .y= 320, .orbit=  4, .species= 11, .seed=0x414e},
{.x= 696, .y= 320, .orbit=  5, .species= 17, .seed=0x4143},
{.x= 696, .y= 320, .orbit=  7, .species= 13, .seed=0x4138},
{.x= 704, .y= 304, .orbit=  2, .species=  5, .seed=0x418d},
{.x= 704, .y= 304, .orbit=  5, .species= 17, .seed=0x4182},
{.x= 704, .y= 304, .orbit=  8, .species= 14, .seed=0x4177},
{.x= 752, .y= 336, .orbit=  2, .species=  6, .seed=0x41d7},
{.x= 752, .y= 336, .orbit=  3, .species=  8, .seed=0x41cc},
{.x= 752, .y= 336, .orbit=  5, .species= 52, .seed=0x01c3},
{.x= 752, .y= 336, .orbit=  6, .species= 16, .seed=0x41b6},
{.x= 752, .y= 336, .orbit=  7, .species= 14, .seed=0x41ab},
{.x= 656, .y= 304, .orbit=  6, .species= 13, .seed=0x41f5},
{.x= 776, .y= 104, .orbit=  2, .species=  7, .seed=0x4247},
{.x= 776, .y= 104, .orbit=  3, .species= 17, .seed=0x423c},
{.x= 776, .y= 104, .orbit=  5, .species= 16, .seed=0x4231},
{.x= 776, .y= 104, .orbit=  7, .species= 15, .seed=0x4226},
{.x= 752, .y=  56, .orbit=  2, .species=  8, .seed=0x4270},
{.x= 752, .y=  56, .orbit=  6, .species= 15, .seed=0x4265},
{.x= 720, .y=  64, .orbit=  4, .species=  9, .seed=0x42af},
{.x= 720, .y=  64, .orbit=  5, .species= 10, .seed=0x42a4},
{.x= 720, .y=  64, .orbit=  6, .species= 16, .seed=0x4299},
{.x= 720, .y=  64, .orbit=  7, .species= 16, .seed=0x428e},
{.x= 584, .y=  56, .orbit=  4, .species= 17, .seed=0x42d8},
{.x= 584, .y=  56, .orbit=  6, .species= 17, .seed=0x42cd},
{.x= 528, .y= 248, .orbit=  2, .species=  6, .seed=0x430c},
{.x= 528, .y= 248, .orbit=  3, .species= 14, .seed=0x4301},
{.x= 528, .y= 248, .orbit=  5, .species= 14, .seed=0x42f6},
{.x= 280, .y= 520, .orbit=  6, .species= 15, .seed=0x4348},
{.x= 280, .y= 520, .orbit=  7, .species= 15, .seed=0x433d},
{.x= 288, .y= 520, .orbit=  1, .species=  6, .seed=0x437c},
{.x= 288, .y= 520, .orbit=  2, .species= 17, .seed=0x4371},
{.x= 288, .y= 520, .orbit=  5, .species= 14, .seed=0x4366},
{.x= 256, .y= 504, .orbit=  1, .species=  1, .seed=0x43a5},
{.x= 256, .y= 504, .orbit=  6, .species= 17, .seed=0x439a},
{.x=  40, .y= 528, .orbit=  2, .species=  6, .seed=0x43e4},
{.x=  40, .y= 528, .orbit=  3, .species=  8, .seed=0x43d9},
{.x=  40, .y= 528, .orbit=  5, .species= 12, .seed=0x43ce},
{.x=  40, .y= 528, .orbit=  6, .species= 16, .seed=0x43c3},
{.x= 416, .y= 472, .orbit=  2, .species=  1, .seed=0x4470},
{.x= 416, .y= 472, .orbit=  3, .species=  6, .seed=0x4465},
{.x= 416, .y= 472, .orbit=  4, .species= 17, .seed=0x445a},
{.x= 416, .y= 472, .orbit=  5, .species=  5, .seed=0x444f},
{.x= 416, .y= 472, .orbit=  6, .species= 12, .seed=0x4444},
{.x= 416, .y= 472, .orbit=  7, .species= 17, .seed=0x4439},
{.x= 416, .y= 448, .orbit=  1, .species= 54, .seed=0x0075},
{.x= 416, .y= 448, .orbit=  2, .species=  9, .seed=0x44a4},
{.x= 416, .y= 448, .orbit=  3, .species= 17, .seed=0x4499},
{.x= 416, .y= 448, .orbit=  4, .species= 16, .seed=0x448e},
{.x=  16, .y= 272, .orbit=  2, .species=  7, .seed=0x44ee},
{.x=  16, .y= 272, .orbit=  3, .species= 16, .seed=0x44e3},
{.x=  16, .y= 272, .orbit=  6, .species= 16, .seed=0x44d8},
{.x=  16, .y= 272, .orbit=  7, .species= 13, .seed=0x44cd},
{.x=  32, .y= 272, .orbit=  3, .species= 10, .seed=0x4522},
{.x=  32, .y= 272, .orbit=  5, .species= 17, .seed=0x4517},
{.x=  32, .y= 272, .orbit=  7, .species= 15, .seed=0x450c},
{.x=  80, .y= 168, .orbit=  2, .species=  5, .seed=0x454b},
{.x=  80, .y= 168, .orbit=  7, .species= 14, .seed=0x4540},
{.x= 248, .y= 216, .orbit=  2, .species=  6, .seed=0x4569},
{.x= 304, .y= 208, .orbit=  1, .species=  5, .seed=0x45be},
{.x= 304, .y= 208, .orbit=  2, .species=  5, .seed=0x45b3},
{.x= 304, .y= 208, .orbit=  3, .species= 13, .seed=0x45a8},
{.x= 304, .y= 208, .orbit=  4, .species= 13, .seed=0x459d},
{.x= 304, .y= 208, .orbit=  7, .species= 13, .seed=0x4592},
{.x= 304, .y= 208, .orbit=  8, .species= 13, .seed=0x4587},
{.x= 336, .y= 216, .orbit=  2, .species=  3, .seed=0x45e7},
{.x= 336, .y= 216, .orbit=  7, .species= 10, .seed=0x45dc},
{.x= 384, .y= 240, .orbit=  2, .species= 17, .seed=0x4626},
{.x= 384, .y= 240, .orbit=  3, .species= 17, .seed=0x461b},
{.x= 384, .y= 240, .orbit=  4, .species= 17, .seed=0x4610},
{.x= 384, .y= 240, .orbit=  6, .species= 17, .seed=0x4605},
{.x= 336, .y= 160, .orbit=  3, .species= 17, .seed=0x4644},
{.x= 448, .y=  80, .orbit=  1, .species=  1, .seed=0x4683},
{.x= 448, .y=  80, .orbit=  6, .species= 16, .seed=0x4678},
{.x= 448, .y=  80, .orbit=  7, .species= 13, .seed=0x466d},
{.x= 448, .y=  80, .orbit=  8, .species= 13, .seed=0x4662},
{.x= 456, .y=  96, .orbit=  2, .species=  7, .seed=0x46ac},
{.x= 456, .y=  96, .orbit=  7, .species= 14, .seed=0x46a1},
{.x= 264, .y=  48, .orbit=  2, .species=  9, .seed=0x46e0},
{.x= 264, .y=  48, .orbit=  3, .species= 12, .seed=0x46d5},
{.x= 264, .y=  48, .orbit=  4, .species= 13, .seed=0x46ca},
{.x= 248, .y=  40, .orbit=  2, .species=  7, .seed=0x46fe},
{.x= 112, .y=  40, .orbit=  1, .species=  5, .seed=0x4769},
{.x= 112, .y=  40, .orbit=  2, .species= 11, .seed=0x475e},
{.x= 112, .y=  40, .orbit=  3, .species= 17, .seed=0x4753},
{.x= 112, .y=  40, .orbit=  4, .species= 16, .seed=0x4748},
{.x= 112, .y=  40, .orbit=  5, .species= 16, .seed=0x473d},
{.x= 112, .y=  40, .orbit=  6, .species= 16, .seed=0x4732},
{.x= 112, .y=  40, .orbit=  7, .species= 16, .seed=0x4727},
{.x= 112, .y=  40, .orbit=  8, .species= 13, .seed=0x471c},
{.x= 400, .y=1544, .orbit=  5, .species=  8, .seed=0x47a8},
{.x= 400, .y=1544, .orbit=  6, .species=  8, .seed=0x479d},
{.x= 400, .y=1544, .orbit=  7, .species= 10, .seed=0x4792},
{.x= 400, .y=1544, .orbit=  8, .species= 17, .seed=0x4787},
{.x=   0, .y=   0, .orbit=  0, .species= -1, .seed=0x0000},
};

char earthmap[]=
{
0x78, 0x78, 0x78, 0x78, 0x92, 0x92, 0x78, 0x78, 0x78, 0x92, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x92, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x78, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x78, 0x78, 0x92, 0x78, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x20, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x30, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x20, 0x92, 0x92, 0x92, 0x30, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x60, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x20, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x10, 0x10, 0x10, 0x10, 0x20, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x78, 0x10, 0x20, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x20, 0x20, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x20, 0x10, 0x10, 0x10, 0x20, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x78, 0x10, 0x20, 0x30, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x20, 0x20, 0x92, 0x92, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x20, 0x10, 0x20, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x78, 0x10, 0x10, 0x20, 0x20, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x20, 0x10, 0x20, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x78, 0x10, 0x10, 0x10, 0x20, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x20, 0x20, 0x20, 0x20, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x60, 0x30, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x60, 0x10, 0x20, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x20, 0x10, 0x20, 0x20, 0x60, 0x92, 0x92, 0x92, 0x92, 0x92, 0x30, 0x92, 0x30, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x10, 0x10, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x20, 0x20, 0x30, 0x10, 0x10, 0x20, 0x20, 0x92, 0x92, 0x92, 0x10, 0x92, 0x92, 0x10, 0x92, 0x20, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x10, 0x92, 0x92, 0x92, 0x92, 0x10, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x20, 0x20, 0x20, 0x10, 0x10, 0x30, 0x60, 0x30, 0x92, 0x92, 0x30, 0x10, 0x92, 0x10, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x30, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x10, 0x20, 0x10, 0x30, 0x10, 0x10, 0x30, 0x10, 0x10, 0x92, 0x30, 0x60, 0x78, 0x78, 0x30, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x30, 0x10, 0x20, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x30, 0x30, 0x30, 0x10, 0x92, 0x20, 0x20, 0x30, 0x30, 0x30, 0x60, 0x78, 0x78, 0x60, 0x10, 0x92, 0x30, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x30, 0x10, 0x30, 0x10, 0x20, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x10, 0x92, 0x92, 0x92, 0x92, 0x10, 0x10, 0x30, 0x10, 0x10, 0x60, 0x78, 0x30, 0x10, 0x10, 0x92, 0x92, 0x30, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x30, 0x10, 0x60, 0x10, 0x10, 0x20, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x10, 0x92, 0x30, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x60, 0x60, 0x30, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x60, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x10, 0x10, 0x20, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0x30, 0x10, 0x10, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x10, 0x10, 0x92, 0x92, 0x92, 0x10, 0x78, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x92, 0x92, 0x92, 0x92, 0x92, 0x10, 0x92, 0x30, 0x10, 0x10, 0x10, 0x10, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x10, 0x92, 0x92, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x30, 0x10, 0x78, 0x78, 0x60, 0x10, 0x10, 0x10, 0x10, 0x92, 0x92, 0x10, 0x92, 0x92, 0x30, 0x92, 0x92, 0x92, 0x92, 0x92, 0x20, 0x10, 0x10, 0x10, 0x10, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x10, 0x10, 0x10, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x10, 0x10, 0x10, 0x60, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x92, 0x92, 0x30, 0x30, 0x92, 0x92, 0x20, 0x92, 0x92, 0x92, 0x20, 0x20, 0x92, 0x10, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x20, 0x20, 0x20, 0x30, 0x20, 0x10, 0x10, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x20, 0x20, 0x30, 0x92, 0x92, 0x92, 0x10, 0x10, 0x10, 0x10, 0x30, 0x92, 0x92, 0x30, 0x30, 0x60, 0x30, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x20, 0x20, 0x20, 0x10, 0x20, 0x10, 0x10, 0x10, 0x10, 0x30, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x10, 0x20, 0x92, 0x92, 0x30, 0x30, 0x30, 0x30, 0x30, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x30, 0x92, 0x92, 0x92, 0x20, 0x10, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x78, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x10, 0x30, 0x30, 0x92, 0x92, 0x30, 0x30, 0x30, 0x30, 0x92, 0x78, 0x78, 0x78, 0x92, 0x78, 0x78, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x10, 0x92, 0x92, 0x92, 0x92, 0x78, 0x78, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x92, 0x78, 0x78, 0x78, 0x78, 0x78
};

#endif
