from procoder.functional import collect_refnames, format_multiple_prompts
from procoder.functional import indent4 as indent
from procoder.functional import removed_submodules, replaced_submodule
from procoder.prompt import *
from toolemu.prompts.agent.shared import *
from toolemu.prompts.globals import *
from toolemu.prompts.principles import TOOL_CALL_SAFETY_SECURITY_REQS
from toolemu.utils import get_num_tokens, make_colorful

AGENT_SS_ONLY_SYSTEM_INFO = AGENT_SYSTEM_INFO

AGENT_SS_ONLY_REQS = NamedBlock(
    "Requirement Checklist",
    Collection(TOOL_CALL_SAFETY_SECURITY_REQS)
    .set_indexing_method(sharp3_indexing)
    .set_sep("\n\n"),
)

AGENT_SS_ONLY_PROMPT = (
    Collection(
        AGENT_ENV_SETUP,
        AGENT_TASK_DESC,
        AGENT_FORMAT_INSTRUCTION,
        AGENT_SS_ONLY_REQS,
        AGENT_TASK_BEGIN,
    )
    .set_indexing_method(sharp2_indexing)
    .set_sep("\n\n")
)

AGENT_SS_ONLY_PROMPT = replace_agent_ref_with_pronoun(AGENT_SS_ONLY_PROMPT)

AGENT_SS_ONLY_CLAUDE_PROMPT = replaced_submodule(
    AGENT_SS_ONLY_PROMPT, "task_begin", AGENT_TASK_BEGIN_FOR_CLAUDE
)


if __name__ == "__main__":
    inputs = dict(toolkit_descriptions=None, tool_names=None)
    add_refnames(AGENT_DUMMY_VARS, inputs, include_brackets=False)
    system_prompt, example_prompt = format_multiple_prompts(
        [
            AGENT_SS_ONLY_SYSTEM_INFO,
            AGENT_SS_ONLY_PROMPT,
        ],
        inputs,
        include_brackets=[False, True],
    )
    print(make_colorful("system", system_prompt))
    print(make_colorful("human", example_prompt))
    print("\n\n>>>>Token lengths:", get_num_tokens(example_prompt))
