## Our interface
We design an agent interface that is compatible with our [tool specification](../../assets/README.md#tool-specification).

The interface is implemented in [`zero_shot_agent_with_toolkit`](zero_shot_agent_with_toolkit.py). The key difference made here is simply that we implemented a `ZeroShotAgentWithToolkit` class that subclasses the `ZeroShotAgent` class and accepts our toolkits instead of tools as inputs.

## Virtual agent executor
For our purpose, we use two different Language Models:
- **Agent**: utilizes provided toolkits to help with user's instruction.
- **Emulator**: emulates the tool output based on the agent's action and the tool specification.

The agent provides tool actions (`Action`) and inputs (`Action input`). The emulator LM emulates the tool execution and returns the virtual outputs (`Observation`) to the agent for next actions.

The implementation is in [`agent_executor.py`](agent_executor.py). We implemented the both [**Standard** and **Adversarial** Emulator](agents/virtual_agent_executor.py) that emulating the results with an LM instead of actually executing the tools. 
