"""Generate tools from spec from thoughts"""
# NOTE: some convertion from thoughts to spec might exceed context length.
# You need to reduce the context length, or use claude or gpt-3.5-16k instead.

import argparse
import os.path as osp
import random

from dotenv import load_dotenv
from toolemu.dataloader import DataLoader
from toolemu.executors import BaseFuncExecutor
from toolemu.generators import ToolSpecGenerator
from toolemu.utils import (
    llm_register_args,
    load_openai_llm_with_args,
    print_intermediate_result_and_stop,
    read_file,
)
from toolemu.utils.my_typing import *

load_dotenv()
parser = argparse.ArgumentParser()

llm_register_args(parser, prefix="gen")
ToolSpecGenerator.register_args(parser)
DataLoader.register_args(parser)
BaseFuncExecutor.register_args(parser)

parser.add_argument(
    "--format-example-file",
    "-fe",
    type=str,
    default="./assets/for_generation/format_example_tool.json",
)
parser.add_argument("--random-seed", "-seed", type=int, default=42)
args = parser.parse_args()
random.seed(args.random_seed)

llm = load_openai_llm_with_args(args, prefix="gen")
generator = ToolSpecGenerator.from_args(args, llm)
runner = BaseFuncExecutor.from_args(args)


def main():
    tool_thoughts = DataLoader.from_args(args, item_name="toolkit thought")
    format_example = read_file(args.format_example_file)
    output_file = f"{osp.splitext(tool_thoughts._input_path)[0]}_spec.jsonl"

    if generator._stop_at in ["preprocess", "prompt"]:
        result = generator(
            dict(example_tools=[format_example], toolkit=tool_thoughts[0])
        )
        print_intermediate_result_and_stop(result, generator._stop_at)

    def transform_thought(thought):
        inputs = dict(example_tools=[format_example], toolkit=thought)
        try:
            return None, generator(inputs)
        except Exception as e:
            print(f"Error encountered: {e}")
            return thought, None

    _, remaining_dataset, _ = runner.run(transform_thought, output_file, tool_thoughts)
    print(f"{len(remaining_dataset)} toolkits failed to be generated.")


if __name__ == "__main__":
    main()
