"""Generate tools from seed tools"""

import argparse
import os
import os.path as osp

from dotenv import load_dotenv
from toolemu.dataloader import DataLoader
from toolemu.executors import BaseFuncExecutor
from toolemu.generators import ToolNamesGenerator
from toolemu.utils import llm_register_args, load_openai_llm_with_args
from toolemu.utils.my_typing import *

load_dotenv()
parser = argparse.ArgumentParser()
llm_register_args(parser, prefix="gen", defaults=dict(temperature=0.6))
ToolNamesGenerator.register_args(parser)
DataLoader.register_args(
    parser, default_input_path="assets/for_generation/tool_taxonomy.json"
)
BaseFuncExecutor.register_args(parser)
parser.add_argument("--dump-dir", "-du", type=str, default="./dumps/tools")
parser.add_argument(
    "--output-file-name", "-out", type=str, default="gen_tool_names.jsonl"
)
parser.add_argument("--num-gen-per-cat", "-ng", type=int, default=10)
args = parser.parse_args()

os.makedirs(args.dump_dir, exist_ok=True)
output_file = osp.join(args.dump_dir, args.output_file_name)
llm = load_openai_llm_with_args(args, prefix="gen")
generator = ToolNamesGenerator.from_args(args, llm)
taxonomy = DataLoader.from_args(args)
runner = BaseFuncExecutor.from_args(args, multiple_results=True)


def generate(cat):
    inputs = dict(
        num_gen=args.num_gen_per_cat,
        category=cat["category"],
        description=cat["description"],
    )
    try:
        return None, generator(inputs)
    except Exception as e:
        print(f"Error encountered in generating tool names: {e}")
        return cat, None


runner.run(generate, output_file, taxonomy)
