# Data Curation

Our data curation procedure is depicted as followed, where we use GPT-4 to generate an initial set of tool specifications and test cases, followed by human filtering and modifications. 
This folder contains scripts for generating the inital set with GPT-4.

<div align="center">
  <img src="../../assets/figures/Data_curation.jpg" width="90%">
</div>

## Toolkit Curation

### Overview

To curate a toolkit, we first generate the toolkit name and description, and then create its detailed specification according to our [toolkit requirements](../../toolemu/prompts/text/toolkit_spec_generator.md#requirements) and a [formatting example](../../assets/for_generation/format_example_tool.json).
Finally, we manually review and refine the generated toolkit specification to ensure the adherence to the [toolkit requirements](../../toolemu/prompts/text/toolkit_spec_generator.md#requirements). 
Our toolkit specification is defined and described [here](../../assets/README.md#tool-specification).

Due to the context length constraint of GPT-4 (~8k), we generate the toolkit specification from its name and description in two steps: we first generate a list of tools and details ( `generate_tool_thoughts.py`) and then transform it to the final JSON specification (`generate_tool_specs.py`).

Note: You can skip this stage if you want to use [our curated toolkit](../../assets/all_toolkits.json). 

### Curation Steps

1. [Optional] Generate toolkit names and descriptions: Use [`generate_tool_names.py`](generate_tool_names.py) to brainstorm and generate a list of potential toolkit names and descriptions given the [toolkit taxonomy](../../assets/for_generation/tool_taxonomy.json). 
You can provide a list of indexes to select specific categories to generate toolkits from, the number of toolkit names to generate per category, and the output file (default `dumps/tools/gen_tool_names.jsonl`). See the script for more details.
    ```bash
    python generate_tool_names.py [--selected-indexes CATEGORY_INDEXES] [--num-gen-per-cat NUM] [--output-file-name FILE_NAME]
    ```

Note:
You may apply manual filtering to keep only those you are interested in testing.
If you have a specific toolkit to curate in mind, you can skip this step and specify its name and description manually.


2. Generate tools and details: Use [`generate_tool_thoughts.py`](generate_tool_thoughts.py) to brainstorm a list of tools for each toolkit and other details (e.g., the tool functionality and potential risks). You may apply manual filtering and modification according to [toolkit requirements](../../toolemu/prompts/text/toolkit_spec_generator.md#requirements) in this step to ensure the quality of generated toolkits.
    ```bash
    python generate_tool_thoughts.py [--input-path TOOL_NAMES_FILE_PATH]
    ```

3. Convert to JSON spec: Once you have your toolkit thoughts generated, filtered, and modified, you can convert them into a more structured specification using `generate_tool_specs.py`:
   ```bash
   python generate_tool_specs.py [--input-path TOOL_THOUGHTS_FILE_PATH]
   ```

4. [Recommended] Final review and refinement: The generated toolkit specifications may not adhere to the set requirements, thus it is advisable to conduct a manual review and make necessary adjustments. Additionally, it is recommended to assess the toolkit with a few relevant test cases to ensure its functionality and compliance.

All files generated by the above scripts are stored in the `dumps/tools` folder, you may change the dump folder by passing `--dump-dir DUMP_DIR` to the scripts.

## Test Case Curation

### Overview

We follow a similar precedure for curating our test cases. First, we generate a set of test cases from the specified list of toolkits along with their potential risks with GPT-4 according to the [test case requirements](../../toolemu/prompts/text/case_generator.md#requirements) and [formatting examples](../../assets/for_generation/format_example_cases.json)
Then, we apply manual filtering and modification.
Our test case specification is defined and described [here](../../assets/README.md#test-case-specification).

### Curation Steps

1. Prepare your toolkit and risks files. Ensure they are in the correct format as expected by the script, you may use our curated toolkits to generate your own test cases. See the [toolkits](../../assets/all_toolkits.json) and [risks](../../assets/for_generation/toolkit_risks.json) files for examples.

2. Run the test case generation script. This will generate `TARGET_NUM` test cases involving the specified toolkits. 
   ```bash
   python generate_test_cases.py --target-num TARGET_NUM --max-attempts MAX_ATTEMPTS [--toolkits-path TOOLKITS_FILE_PATH] [--risk-file-path RISK_FILE_PATH]
   [--dump-dir DUMP_DIR]
   ```

3. [Recommended] Final review and refinement: It is recommended to manually review the generated test cases, run it with our emulators, and make necessary refinement to ensure their quality and adherence to the [set requirements]((../../toolemu/prompts/text/case_generator.md#requirements)).



### Test Case Completion
For the previous test curation, all the test case fields are brainstormed and generated from scratch by GPT-4. In some use cases, you may have a specific basic test case in mind, and would like to fill in the fields required by our adversarial emulator and safety evaluator. We provide a [notebook](../../notebooks/complete_case.ipynb) for doing so, where you can complete the test case fields based on the toolkit, user instruction, and potential risks.
It is also recommanded to review and refine the generated fields if needed.

