## Welcome to ToolEmu's Contribution Guide!

Thank you for your interest in contributing to our project. This guide is designed to make your contribution process straightforward and effective. We appreciate your effort in contributing more test cases and toolkit specifications.

### Table of Contents

1. [Getting Started](#getting-started)
2. [Contribution Guidelines](#contribution-guidelines)
3. [Adding New Test Cases](#adding-new-test-cases)
4. [Adding New Toolkit Specifications](#adding-new-toolkit-specifications)
5. [Contributing Codes](#contributing-codes)
6. [Pull Request Process](#pull-request-process)
7. [Code of Conduct](#code-of-conduct)
8. [Questions?](#questions)

### Getting Started

1. **Fork the Repository**: Click on the 'Fork' button at the top right corner of the repository page to create a copy of our repository on your GitHub account.

2. **Clone Your Fork**: Clone the forked repository to your local machine.

   ```bash
   git clone https://github.com/YOUR_USERNAME/ToolEmu.git
   ```

3. **Set Upstream**: Add the original repository as an upstream remote.

   ```bash
   git remote add upstream https://github.com/ryoungj/ToolEmu.git
   ```

### Contribution Guidelines

1. Always work on a new branch for each contribution. Do not make changes directly to the `main` or `master` branch.
2. Make sure to pull the latest changes from the upstream before making a pull request.
3. Ensure that your contribution aligns with the project's coding and documentation standards.

### Adding New Test Cases
Before you start, please carefully read and understand how the test case is [specified](assets/README.md#test-case-specification) and [curated](./scripts/generation/README.md#test-case-curation).


1. Navigate to the [`assets/contrib/cases`](assets/contrib/cases) directory.
2. If you are adding your first case, create a new directory with your username. Otherwise, navigate to your existing directory.
3. Create a new file or edit an existing one with your test cases.
    - The name field of each test case should be unique accross your test cases. <!-- and should not be changed. -->
4. Ensure that your test cases follow the same format as the existing ones.
    - Please checkout out our [examples](assets/contrib/cases/official/example.json) for more details.
5. Add comments in the pull request to explain the purpose and expected outcome of each test case.
    - We are looking for red team test cases that can be used to evaluate the safety of the tool-augmented agent.
    - Please use [`scripts/emulate.py`](scripts/emulate.py) to run at least one agent execution trajectory and provide the resulted trajectory in the pull request.

### Adding New Toolkit Specifications
Before you start, please carefully read and understand how the toolkit is [specified](assets/README.md#tool-specification) and [curated](./scripts/generation/README.md#toolkit-curation).

1. Navigate to the [`assets/contrib/toolkits`](assets/contrib/toolkits) directory.
2. If you are adding your first toolkit, create a new directory with your username. Otherwise, navigate to your existing directory.
3. For new toolkit specifications, create a new json file under your folder. For updates, modify the existing file.
    - The toolkit field of each toolkit specification should be unique accross your toolkits. <!-- and should not be changed. -->
4. Ensure that your toolkit follow the same format as the existing ones.
    - Please checkout out our [examples](assets/contrib/toolkits/official/example.json) for more details.
5. Add comments in the pull request to explain the purpose of adding or updating the toolkit.
    - We are looking for toolkits that can be used to enhance the ability of LLM agent, and can be used to evaluate the tool-augmented agent.
    - Please also provide at least one test case that uses the toolkit.

### Contributing Codes
1. We welcome any contributions that can improve the usability of the project.
2. Please use `black` to format your code before making a pull request.

### Pull Request Process

1. Commit your changes with a meaningful commit message.
2. Push your branch to your forked repository.
3. Create a pull request from your forked repository to the original repository.
4. In the pull request description, explain your changes, the reason behind them, and any related issue numbers.
5. Wait for the maintainers to review your pull request. Address any feedback or changes requested.

### Code of Conduct

By participating in this project, you are expected to uphold our [Code of Conduct](CODE_OF_CONDUCT.md). Please read it before making any contributions.

### Questions?

If you have questions or need further guidance, please open an issue with the label `question`, and we'll be happy to help!

---

Thank you for your contribution and for making ToolEmu better! 🌟
