
/*******************************************************************************
 * Indus, a program analysis and transformation toolkit for Java.
 * Copyright (c) 2001, 2007 Venkatesh Prasad Ranganath
 * 
 * All rights reserved.  This program and the accompanying materials are made 
 * available under the terms of the Eclipse Public License v1.0 which accompanies 
 * the distribution containing this program, and is available at 
 * http://www.opensource.org/licenses/eclipse-1.0.php.
 * 
 * For questions about the license, copyright, and software, contact 
 * 	Venkatesh Prasad Ranganath at venkateshprasad.ranganath@gmail.com
 *                                 
 * This software was developed by Venkatesh Prasad Ranganath in SAnToS Laboratory 
 * at Kansas State University.
 *******************************************************************************/

package edu.ksu.cis.indus.common.graph;



/**
 * This class tests directed graph and simple node graph implementations with a different graph instance.  All the local
 * tests are overloaded suitably.
 * 
 * <p>
 * This represents the CFG as generated by <b>javac</b> for the following snippet.
 * </p>
 * <pre>
 *  public static void main(String[] s) {
 *       int i = 0;
 *       do {
 *           while(i > 0) {
 *               i--;
 *           };
 *           i++;
 *       } while (i < 10);
 *       System.out.println("Hi");
 *   }
 * </pre>
 *
 * @author <a href="http://www.cis.ksu.edu/~rvprasad">Venkatesh Prasad Ranganath</a>
 * @author $Author$
 * @version $Revision$ $Date$
 */
public class JavacBasedDirectedAndSimpleNodeGraphTest
  extends JikesBasedDirectedAndSimpleNodeGraphTest {
	/**
	 * @see edu.ksu.cis.indus.common.graph.SimpleNodeGraphTest#testlocalGetSinks()
	 */
	public void testlocalGetSinks() {
		assertFalse(dg.getSinks().isEmpty());
		assertTrue(dg.getSinks().contains(name2node.get("e")));
	}

	/**
	 * @see JikesBasedDirectedAndSimpleNodeGraphTest#setUp()
	 */
	protected void setUp()
	  throws Exception {
		final SimpleNodeGraph<String> _sng = new SimpleNodeGraph<String>();
		name2node.put("a", _sng.getNode("a"));
		name2node.put("b", _sng.getNode("b"));
		name2node.put("c", _sng.getNode("c"));
		name2node.put("d", _sng.getNode("d"));
		name2node.put("e", _sng.getNode("e"));

		_sng.addEdgeFromTo( name2node.get("a"),  name2node.get("b"));
		_sng.addEdgeFromTo( name2node.get("b"),  name2node.get("c"));
		_sng.addEdgeFromTo( name2node.get("b"),  name2node.get("d"));
		_sng.addEdgeFromTo( name2node.get("d"),  name2node.get("e"));
		// add loop edges
		_sng.addEdgeFromTo( name2node.get("c"),  name2node.get("b"));
		_sng.addEdgeFromTo( name2node.get("d"),  name2node.get("b"));
		setSNG(_sng);

		numberOfCycles = 2;
	}

	/**
	 * @see edu.ksu.cis.indus.common.graph.AbstractDirectedGraphTest#localtestIsAncestorOf()
	 */
	protected void localtestIsAncestorOf() {
		assertTrue(sng.isAncestorOf( name2node.get("a"),  name2node.get("a")));
		assertTrue(sng.isAncestorOf( name2node.get("a"),  name2node.get("e")));
		assertFalse(sng.isAncestorOf( name2node.get("e"),  name2node.get("b")));
	}

	/**
	 * @see edu.ksu.cis.indus.common.graph.AbstractDirectedGraphTest#localtestIsReachable()
	 */
	protected void localtestIsReachable() {
		assertTrue(sng.isReachable( name2node.get("a"),  name2node.get("e"), true));
		assertTrue(sng.isReachable( name2node.get("e"),  name2node.get("a"), false));
		assertTrue(sng.isReachable( name2node.get("c"),  name2node.get("e"), true));
		assertTrue(sng.isReachable( name2node.get("d"),  name2node.get("c"), true));
	}
}

// End of File
