/*******************************************************************************
 * Indus, a program analysis and transformation toolkit for Java.
 * Copyright (c) 2001, 2007 Venkatesh Prasad Ranganath
 * 
 * All rights reserved.  This program and the accompanying materials are made 
 * available under the terms of the Eclipse Public License v1.0 which accompanies 
 * the distribution containing this program, and is available at 
 * http://www.opensource.org/licenses/eclipse-1.0.php.
 * 
 * For questions about the license, copyright, and software, contact 
 * 	Venkatesh Prasad Ranganath at venkateshprasad.ranganath@gmail.com
 *                                 
 * This software was developed by Venkatesh Prasad Ranganath in SAnToS Laboratory 
 * at Kansas State University.
 *******************************************************************************/

package edu.ksu.cis.indus.common.collections;

import edu.ksu.cis.indus.IndusTestCase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * This class tests <code>CollectionsUtilities</code> class.
 * 
 * @author <a href="http://www.cis.ksu.edu/~rvprasad">Venkatesh Prasad Ranganath</a>
 * @author $Author$
 * @version $Revision$ $Date$
 */
public class CollectionsUtilitiesTest
		extends IndusTestCase {

	/**
	 * A factory for list of strings. 
	 */
	static final IFactory<List<String>> factory = new IFactory<List<String>>() {

		public List<String> create() {
			return new ArrayList<String>();
		}

	};

	/**
	 * The map.
	 */
	private Map<String, Collection<String>> map;

	/**
	 * Tests <code>putAllIntoCollectionInMap</code>.
	 */
	public final void testPutAllIntoCollectionInMap() {
		final Collection<String> _temp = new ArrayList<String>();
		_temp.add("second");
		MapUtils.putAllIntoCollectionInMapUsingFactory(map, "first", _temp, factory);
		assertNotNull(map.get("first"));
		assertTrue(map.get("first").contains("second"));
	}

	/**
	 * Tests <code>putIntoCollectionInMap</code>.
	 */
	public final void testPutIntoCollectionInMap() {
		final Collection<String> _temp = new ArrayList<String>();
		_temp.add("second");
		MapUtils.putIntoCollectionInMapUsingFactory(map, "first", "second", factory);
		assertNotNull(map.get("first"));
		assertTrue(map.get("first").contains("second"));
	}

	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	@Override protected void setUp() throws Exception {
		map = new HashMap<String, Collection<String>>();
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	@Override protected void tearDown() throws Exception {
		map.clear();
		map = null;
	}
}

// End of File
