/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.ClassEnv;
import jas.CodeAttr;
import jas.InsnOperand;
import jas.RuntimeConstants;
import java.io.DataOutputStream;
import java.io.IOException;

class UnsignedByteWideOperand
extends InsnOperand
implements RuntimeConstants {
    int val;

    UnsignedByteWideOperand(int n) {
        this.val = n;
    }

    int size(ClassEnv classEnv, CodeAttr codeAttr) {
        if (this.val >= 256) {
            return 3;
        }
        return 1;
    }

    void writePrefix(ClassEnv classEnv, CodeAttr codeAttr, DataOutputStream dataOutputStream) throws IOException {
        if (this.val > 255) {
            dataOutputStream.writeByte(-60);
        }
    }

    void write(ClassEnv classEnv, CodeAttr codeAttr, DataOutputStream dataOutputStream) throws IOException {
        if (this.val > 255) {
            dataOutputStream.writeShort((short)(0xFFFF & this.val));
        } else {
            dataOutputStream.writeByte((byte)(this.val & 0xFF));
        }
    }

    void resolve(ClassEnv classEnv) {
    }
}

