/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.ClassEnv;
import jas.CodeAttr;
import jas.Insn;
import jas.InsnOperand;
import jas.Label;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;

class TableswitchOperand
extends InsnOperand {
    int min;
    int max;
    Label dflt;
    Label[] jmp;
    Insn source;

    TableswitchOperand(Insn insn, int n, int n2, Label label, Label[] labelArray) {
        this.min = n;
        this.max = n2;
        this.dflt = label;
        this.jmp = labelArray;
        this.source = insn;
    }

    void resolve(ClassEnv classEnv) {
    }

    int size(ClassEnv classEnv, CodeAttr codeAttr) throws jasError {
        int n = 12;
        int n2 = codeAttr.getPc(this.source);
        if ((n2 + 1) % 4 != 0) {
            n += 4 - (n2 + 1) % 4;
        }
        if (this.jmp != null) {
            n += 4 * this.jmp.length;
        }
        return n;
    }

    void write(ClassEnv classEnv, CodeAttr codeAttr, DataOutputStream dataOutputStream) throws IOException, jasError {
        int n;
        int n2 = codeAttr.getPc(this.source);
        if ((n2 + 1) % 4 != 0) {
            int n3 = 4 - (n2 + 1) % 4;
            n = 0;
            while (n < n3) {
                dataOutputStream.writeByte(0);
                ++n;
            }
        }
        this.dflt.writeWideOffset(codeAttr, this.source, dataOutputStream);
        dataOutputStream.writeInt(this.min);
        dataOutputStream.writeInt(this.max);
        n = this.jmp.length;
        int n4 = 0;
        while (n4 < n) {
            this.jmp[n4].writeWideOffset(codeAttr, this.source, dataOutputStream);
            ++n4;
        }
    }
}

