/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.ClassEnv;
import jas.CodeAttr;
import jas.Insn;
import jas.InsnOperand;
import jas.Label;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;

class LookupswitchOperand
extends InsnOperand {
    Label dflt;
    Insn source;
    int[] match;
    Label[] jmp;

    LookupswitchOperand(Insn insn, Label label, int[] nArray, Label[] labelArray) {
        this.dflt = label;
        this.jmp = labelArray;
        this.match = nArray;
        this.source = insn;
    }

    void resolve(ClassEnv classEnv) {
    }

    int size(ClassEnv classEnv, CodeAttr codeAttr) throws jasError {
        int n = 8;
        int n2 = codeAttr.getPc(this.source);
        if ((n2 + 1) % 4 != 0) {
            n += 4 - (n2 + 1) % 4;
        }
        if (this.jmp != null) {
            n += 8 * this.jmp.length;
        }
        return n;
    }

    void write(ClassEnv classEnv, CodeAttr codeAttr, DataOutputStream dataOutputStream) throws IOException, jasError {
        int n;
        int n2 = codeAttr.getPc(this.source);
        if ((n2 + 1) % 4 != 0) {
            int n3 = 4 - (n2 + 1) % 4;
            n = 0;
            while (n < n3) {
                dataOutputStream.writeByte(0);
                ++n;
            }
        }
        this.dflt.writeWideOffset(codeAttr, this.source, dataOutputStream);
        if (this.jmp == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(this.jmp.length);
            n = 0;
            while (n < this.jmp.length) {
                dataOutputStream.writeInt(this.match[n]);
                this.jmp[n].writeWideOffset(codeAttr, this.source, dataOutputStream);
                ++n;
            }
        }
    }
}

