/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.CP;
import jas.ClassEnv;
import jas.CodeAttr;
import jas.InsnOperand;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;

class CPOperand
extends InsnOperand {
    CP cpe;
    boolean wide;

    int size(ClassEnv classEnv, CodeAttr codeAttr) {
        if (this.wide) {
            return 2;
        }
        return 1;
    }

    CPOperand(CP cP) {
        this.cpe = cP;
        this.wide = true;
    }

    CPOperand(CP cP, boolean bl) {
        this.cpe = cP;
        this.wide = bl;
    }

    void resolve(ClassEnv classEnv) {
        classEnv.addCPItem(this.cpe);
    }

    void write(ClassEnv classEnv, CodeAttr codeAttr, DataOutputStream dataOutputStream) throws IOException, jasError {
        short s = classEnv.getCPIndex(this.cpe);
        if (this.wide) {
            dataOutputStream.writeShort(s);
        } else {
            if (s > 255) {
                throw new jasError("exceeded size for small cpidx" + this.cpe);
            }
            dataOutputStream.writeByte((byte)(0xFF & s));
        }
    }
}

