/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.peq.queryengine;

import edu.ksu.cis.peq.datastructures.WorkList;
import edu.ksu.cis.peq.fsm.interfaces.IFSM;
import edu.ksu.cis.peq.fsm.interfaces.IFSMToken;
import edu.ksu.cis.peq.fsm.interfaces.IState;
import edu.ksu.cis.peq.fsm.interfaces.ITransition;
import edu.ksu.cis.peq.graph.interfaces.IEdge;
import edu.ksu.cis.peq.graph.interfaces.IGraphEngine;
import edu.ksu.cis.peq.graph.interfaces.INode;
import edu.ksu.cis.peq.queryengine.AbstractQueryEngine;
import edu.ksu.cis.peq.queryengine.IQueryProgressListener;
import edu.ksu.cis.peq.queryengine.IUQMatcher;
import edu.ksu.cis.peq.queryengine.MatchPair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class UniversalQueryEngine$v1
extends AbstractQueryEngine {
    private Collection results = Collections.EMPTY_LIST;
    private Set listeners = new HashSet();
    private Map tMap = new HashMap();
    private Map uMap = new HashMap();

    public UniversalQueryEngine$v1(IGraphEngine gEngine, IFSM fsm, IUQMatcher matcher) {
        super(gEngine, fsm, matcher);
    }

    public Collection getResults() {
        return this.results;
    }

    protected Set matchNodeAndState(INode node, IState state) {
        LinkedHashSet<IFSMToken> _matchSet = new LinkedHashSet<IFSMToken>();
        Set _edgeSet = node.getExitingEdges();
        Set _transitionSet = state.getExitingTransitions();
        for (IEdge _edge : _edgeSet) {
            MatchPair _mPair = null;
            for (ITransition _transition : _transitionSet) {
                IFSMToken _token = this.matcher.getMatch(_edge, _transition);
                if (!_token.isEmpty()) {
                    if (_mPair == null) {
                        _mPair = new MatchPair();
                        _mPair.setTransition(_transition);
                        _mPair.setSubstMap(_token.getSubstituitionMap());
                        _matchSet.add(_token);
                    } else {
                        boolean _dCheck;
                        boolean bl = _dCheck = _mPair.getTransitionEdge().equals(_token.getTransitionEdge()) && _mPair.getSubstituitionMap().equals(_token.getSubstituitionMap());
                        if (!_dCheck) {
                            throw new RuntimeException("Determinism check failed");
                        }
                    }
                }
                if (_mPair != null) continue;
                _matchSet.add(((IUQMatcher)this.matcher).createBadToken(_edge));
            }
        }
        return _matchSet;
    }

    protected Set matchAndMergeReach(INode node, IState state, IFSMToken parent, Set reachSet) {
        LinkedHashSet<IFSMToken> _matchSet = new LinkedHashSet<IFSMToken>();
        Set _edgeSet = node.getExitingEdges();
        Set _transitionSet = state.getExitingTransitions();
        for (IEdge _edge : _edgeSet) {
            MatchPair _mPair = null;
            for (ITransition _transition : _transitionSet) {
                IFSMToken _badToken;
                IFSMToken _mergedToken;
                IFSMToken _token = this.matcher.getMatch(_edge, _transition);
                if (!_token.isEmpty() && !(_mergedToken = this.matcher.merge(parent, _token)).isEmpty()) {
                    if (_mPair == null) {
                        _mPair = new MatchPair();
                        _mPair.setTransition(_mergedToken.getTransitionEdge());
                        _mPair.setSubstMap(_mergedToken.getSubstituitionMap());
                        if (!reachSet.contains(_mergedToken)) {
                            _matchSet.add(_mergedToken);
                        }
                    } else {
                        boolean _dCheck;
                        boolean bl = _dCheck = _mPair.getTransitionEdge().equals(_token.getTransitionEdge()) && _mPair.getSubstituitionMap().equals(_token.getSubstituitionMap());
                        if (!_dCheck) {
                            throw new RuntimeException("Determinism check failed");
                        }
                    }
                }
                if (_mPair != null || reachSet.contains(_badToken = ((IUQMatcher)this.matcher).createBadToken(_edge))) continue;
                _matchSet.add(_badToken);
            }
        }
        return _matchSet;
    }

    public void execute() {
        HashSet<IFSMToken> _reachSet = new HashSet<IFSMToken>();
        WorkList _workList = new WorkList();
        this.fireProgressEvent(this, "Initializing work list", null);
        _workList.addAll(this.initializeWorkSet());
        while (_workList.hasWork()) {
            Boolean _b;
            IFSMToken _fsmToken = (IFSMToken)_workList.getWork();
            _reachSet.add(_fsmToken);
            INode _reachNode = _fsmToken.getGraphEdge().getDstnNode();
            IState _reachState = _fsmToken.getTransitionEdge().getDstnState();
            if (_reachNode != null && _reachState != null) {
                _workList.addAll(this.matchAndMergeReach(_reachNode, _reachState, _fsmToken, _reachSet));
            }
            if ((_b = (Boolean)this.tMap.get(_reachNode)) == null || _b.booleanValue()) {
                boolean _result = _reachState.isFinalState();
                Boolean _rBool = new Boolean(_result);
                this.tMap.put(_reachNode, _rBool);
            }
            if ((_b = (Boolean)this.tMap.get(_reachNode)).booleanValue()) {
                IFSMToken _tok = (IFSMToken)this.uMap.get(_reachNode);
                if (_tok == null) {
                    this.uMap.put(_reachNode, _fsmToken);
                } else {
                    this.updateMap(_tok.getSubstituitionMap(), _fsmToken.getSubstituitionMap());
                }
            } else {
                this.uMap.put(_reachNode, null);
            }
            String _msg = "Processed node : " + _reachNode + " State : " + _reachState;
            this.fireProgressEvent(this, _msg, null);
        }
        this.postProcess();
    }

    private void updateMap(Map targetMap, Map sourceMap) {
        Set _parentSet = sourceMap.entrySet();
        for (Map.Entry _entry : _parentSet) {
            Object _key = _entry.getKey();
            Object _val = _entry.getValue();
            if (targetMap.containsKey(_key)) {
                Object _oldObj = targetMap.get(_key);
                if (_oldObj.equals(_val)) continue;
                throw new RuntimeException("Parameter update conflict");
            }
            targetMap.put(_key, _val);
        }
    }

    private void postProcess() {
        HashSet<IFSMToken> _result = new HashSet<IFSMToken>();
        Set _resultSet = this.tMap.entrySet();
        for (Map.Entry _entry : _resultSet) {
            IFSMToken _token;
            INode _node = (INode)_entry.getKey();
            Boolean _val = (Boolean)_entry.getValue();
            if (!_val.booleanValue() || (_token = (IFSMToken)this.uMap.get(_node)) == null || _token.isEmpty()) continue;
            _result.add(_token);
        }
        this.meetResultPC(_result);
    }

    private void meetResultPC(Set resultSet) {
        if (resultSet.size() > 0) {
            this.results = new LinkedHashSet();
            for (IFSMToken _rtoken : resultSet) {
                LinkedList<IFSMToken> _lstResult = new LinkedList<IFSMToken>();
                _lstResult.add(_rtoken);
                IFSMToken _currToken = _rtoken;
                while (_currToken.getParent() != null) {
                    _lstResult.add(_currToken.getParent());
                    _currToken = _currToken.getParent();
                }
                Collections.reverse(_lstResult);
                this.results.add(_lstResult);
            }
        }
    }

    private Set initializeWorkSet() {
        LinkedHashSet _initSet = new LinkedHashSet();
        Set _initNodes = this.gEngine.getInitialNodes();
        Iterator _nodeIterator = _initNodes.iterator();
        IState _state = this.fsm.getInitialState();
        while (_nodeIterator.hasNext()) {
            INode _node = (INode)_nodeIterator.next();
            _initSet.addAll(this.matchNodeAndState(_node, _state));
        }
        return _initSet;
    }

    private void fireProgressEvent(UniversalQueryEngine$v1 source, String message, Object information) {
        final IQueryProgressListener.QueryProgressEvent _event = new IQueryProgressListener.QueryProgressEvent(source, message, information);
        Thread _t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Set set = UniversalQueryEngine$v1.this.listeners;
                synchronized (set) {
                    Iterator _it = UniversalQueryEngine$v1.this.listeners.iterator();
                    while (_it.hasNext()) {
                        ((IQueryProgressListener)_it.next()).queryProgress(_event);
                    }
                }
            }
        };
        _t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IQueryProgressListener queryListener) {
        Set set = this.listeners;
        synchronized (set) {
            if (!this.listeners.contains(queryListener)) {
                this.listeners.add(queryListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IQueryProgressListener queryListener) {
        Set set = this.listeners;
        synchronized (set) {
            if (this.listeners.contains(queryListener)) {
                this.listeners.remove(queryListener);
            }
        }
    }
}

