/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.automata.transformers;

import edu.ksu.cis.automata.entities.Automata;
import edu.ksu.cis.automata.entities.State;
import edu.ksu.cis.automata.entities.Transition;
import edu.ksu.cis.automata.helpers.EpsClosureCalculator;
import edu.ksu.cis.automata.interfaces.IAutomata;
import edu.ksu.cis.automata.interfaces.IState;
import edu.ksu.cis.automata.interfaces.ITransition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EpsRemovalTransformer {
    private IAutomata inpAutomata;
    private IState newInitialState;
    private IAutomata opAutomata;

    public EpsRemovalTransformer(IAutomata automata) {
        this.inpAutomata = automata;
    }

    public void process() {
        Map sToEMap = this.preCompute();
        HashMap sToEcMap = new HashMap();
        this.createEpsFreeAutm(sToEcMap, this.inpAutomata.getInitialState(), new HashSet(), sToEMap);
        IState oldInitialState = this.inpAutomata.getInitialState();
        Set ecSet = (Set)sToEMap.get(oldInitialState);
        this.newInitialState = (IState)sToEcMap.get(ecSet);
        this.postCompute(sToEcMap);
    }

    protected Map preCompute() {
        EpsClosureCalculator ecc = new EpsClosureCalculator(this.inpAutomata);
        ecc.process();
        Map sToEcMap = ecc.getResults();
        return sToEcMap;
    }

    private void createEpsFreeAutm(Map sToEcMap, IState state, Set reachset, Map sToEMap) {
        if (!reachset.contains(state)) {
            reachset.add(state);
            State newState = null;
            Set eSet = (Set)sToEMap.get(state);
            if (sToEcMap.containsKey(eSet)) {
                newState = (State)sToEcMap.get(eSet);
            } else {
                newState = new State();
                sToEcMap.put(eSet, newState);
            }
            for (State eState : eSet) {
                Set transSet = eState.getExitingTransitions();
                for (ITransition trans : transSet) {
                    if (trans.isEpsTransition()) continue;
                    State theState = null;
                    State dstnState = (State)trans.getDstnState();
                    Set dEset = (Set)sToEMap.get(dstnState);
                    Object _rObj = sToEcMap.get(dEset);
                    if (_rObj == null) {
                        theState = new State();
                        sToEcMap.put(dEset, theState);
                    } else {
                        theState = (State)_rObj;
                    }
                    Transition t = new Transition();
                    t.setSrcState(newState);
                    t.setDstnState(theState);
                    t.setSymbol(trans.getSymbol());
                    newState.addExitingTransition(t);
                    theState.addEnteringTransition(t);
                    this.createEpsFreeAutm(sToEcMap, dstnState, reachset, sToEMap);
                }
            }
        }
    }

    protected void postCompute(Map sToEcMap) {
        this.computeFinalStates(sToEcMap);
        this.opAutomata = new Automata();
        ((Automata)this.opAutomata).setInitialState(this.newInitialState);
        ((Automata)this.opAutomata).collectFinalStates();
    }

    private void computeFinalStates(Map epsMap) {
        Set entrySet = epsMap.entrySet();
        block0: for (Map.Entry entry : entrySet) {
            Set epsSet = (Set)entry.getKey();
            State state = (State)entry.getValue();
            for (State oldState : epsSet) {
                if (!oldState.isFinalState()) continue;
                state.setFinalState(true);
                continue block0;
            }
        }
    }

    public IAutomata getResult() {
        return this.opAutomata;
    }
}

