/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.automata.test.main;

import edu.ksu.cis.automata.builders.RegexBuilder;
import edu.ksu.cis.automata.entities.State;
import edu.ksu.cis.automata.entities.test.Symbol1;
import edu.ksu.cis.automata.entities.test.Symbol2;
import edu.ksu.cis.automata.entities.test.Symbol3;
import edu.ksu.cis.automata.entities.test.Symbol4;
import edu.ksu.cis.automata.interfaces.IAutomata;
import edu.ksu.cis.automata.interfaces.IState;
import edu.ksu.cis.automata.transformers.EpsRemovalTransformer;
import edu.ksu.cis.automata.utilities.AutomataDescriber;

public class Main {
    public static void main(String[] args) {
        RegexBuilder builder = new RegexBuilder();
        IState initState = builder.initialize();
        Symbol1 sym1 = new Symbol1("sym1", null);
        Symbol2 sym2 = new Symbol2("sym2", null);
        Symbol3 sym3 = new Symbol3("sym3", null);
        Symbol4 sym4 = new Symbol4("sym4", null);
        IState newState = builder.createNormal(sym1, initState);
        newState = builder.createKleene(sym1, newState);
        ((State)newState).setFinalState(true);
        IAutomata atm = builder.finalizeAtm();
        AutomataDescriber ad = new AutomataDescriber(atm);
        ad.process();
        System.out.println(ad.printAutomata());
        System.out.println("Converting the automata to an epsilon free automata");
        EpsRemovalTransformer ert = new EpsRemovalTransformer(atm);
        ert.process();
        IAutomata epsFreeAtm = ert.getResult();
        ad = new AutomataDescriber(epsFreeAtm);
        ad.process();
        System.out.println(ad.printAutomata());
    }
}

