/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.automata.helpers;

import edu.ksu.cis.automata.interfaces.IAutomata;
import edu.ksu.cis.automata.interfaces.IState;
import edu.ksu.cis.automata.interfaces.ITransition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EpsClosureCalculator {
    private Map sToEclsMap;
    private IAutomata srcAutomata;

    public EpsClosureCalculator(IAutomata atm) {
        this.srcAutomata = atm;
        this.sToEclsMap = new HashMap();
    }

    public void process() {
        IState initState = this.srcAutomata.getInitialState();
        this.calculateEclosure(initState, new HashSet());
    }

    private void calculateEclosure(IState state, Set reachSet) {
        if (reachSet.contains(state)) {
            return;
        }
        this.calEclosureForState(state);
        reachSet.add(state);
        Set transSet = state.getExitingTransitions();
        for (ITransition trans : transSet) {
            this.calculateEclosure(trans.getDstnState(), reachSet);
        }
    }

    private Set calEclosureForState(IState state) {
        if (this.sToEclsMap.containsKey(state)) {
            return (Set)this.sToEclsMap.get(state);
        }
        HashSet<IState> retSet = new HashSet<IState>();
        retSet.add(state);
        Set transitionSet = state.getExitingTransitions();
        for (ITransition t : transitionSet) {
            if (!t.isEpsTransition()) continue;
            retSet.addAll(this.calEclosureForState(t.getDstnState()));
        }
        this.sToEclsMap.put(state, retSet);
        return retSet;
    }

    public Map getResults() {
        return this.sToEclsMap;
    }
}

